/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import demo.cms.TestSignedAndEnvelopedDataStream$Writer;
import demo.keystore.CMSKeyStore;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.cms.CertificateIdentifier;
import iaik.cms.EnvelopedDataStream;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.KeyTransRecipientInfo;
import iaik.cms.RecipientInfo;
import iaik.cms.SignedDataStream;
import iaik.cms.SignerInfo;
import iaik.cms.attributes.CMSContentType;
import iaik.cms.attributes.SigningTime;
import iaik.security.random.SecRandom;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;

public class TestSignedAndEnvelopedDataStream {
    SecureRandom random;
    X509Certificate[] certificates;
    PrivateKey user2_crypt_pk;
    X509Certificate user2_crypt;
    PrivateKey user1_crypt_pk;
    X509Certificate user1_crypt;
    PrivateKey user1_sign_pk;
    X509Certificate user1_sign;

    public void testSignedAndEnvelopedDataStream(byte[] byArray) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        SignedDataStream signedDataStream = new SignedDataStream((InputStream)bufferedInputStream, 1);
        signedDataStream.setCertificates((Certificate[])this.certificates);
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(this.user1_sign);
        SignerInfo signerInfo = new SignerInfo((CertificateIdentifier)issuerAndSerialNumber, AlgorithmID.sha1, this.user1_sign_pk);
        Attribute[] attributeArray = new Attribute[2];
        CMSContentType cMSContentType = new CMSContentType(ObjectID.cms_data);
        attributeArray[0] = new Attribute((AttributeValue)cMSContentType);
        SigningTime signingTime = new SigningTime();
        attributeArray[1] = new Attribute((AttributeValue)signingTime);
        signerInfo.setSignedAttributes(attributeArray);
        signedDataStream.addSignerInfo(signerInfo);
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
        TestSignedAndEnvelopedDataStream$Writer testSignedAndEnvelopedDataStream$Writer = new TestSignedAndEnvelopedDataStream$Writer(this, signedDataStream, pipedOutputStream);
        testSignedAndEnvelopedDataStream$Writer.start();
        EnvelopedDataStream envelopedDataStream = new EnvelopedDataStream((InputStream)pipedInputStream, (AlgorithmID)AlgorithmID.des_CBC.clone());
        RecipientInfo[] recipientInfoArray = new RecipientInfo[]{new KeyTransRecipientInfo(this.user1_crypt, AlgorithmID.rsaEncryption), new KeyTransRecipientInfo(this.user2_crypt, AlgorithmID.rsaEncryption)};
        envelopedDataStream.setRecipientInfos(recipientInfoArray);
        envelopedDataStream.writeTo((OutputStream)bufferedOutputStream, 2048);
        ((OutputStream)bufferedOutputStream).close();
        ((InputStream)bufferedInputStream).close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        System.out.println("Message created, now doing the parsing...");
        bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray2));
        envelopedDataStream = new EnvelopedDataStream((InputStream)bufferedInputStream);
        envelopedDataStream.setupCipher((Key)this.user1_crypt_pk, 0);
        InputStream inputStream = envelopedDataStream.getInputStream();
        System.out.println("Message decrypted!");
        signedDataStream = new SignedDataStream(inputStream);
        InputStream inputStream2 = signedDataStream.getInputStream();
        byteArrayOutputStream.reset();
        bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        StreamCopier streamCopier = new StreamCopier(inputStream2, (OutputStream)bufferedOutputStream);
        streamCopier.copyStream();
        ((OutputStream)bufferedOutputStream).close();
        ((OutputStream)byteArrayOutputStream).close();
        ((InputStream)bufferedInputStream).close();
        inputStream.close();
        X509Certificate x509Certificate = signedDataStream.verify(0);
        System.out.println("Signature OK from: " + x509Certificate.getSubjectDN());
        System.out.println("Received message: \"" + new String(byteArrayOutputStream.toByteArray()) + "\"");
    }

    public void start() {
        String string = "This demo message will be signed and/or encrypted.";
        System.out.println("Test message: \"" + string + "\"");
        System.out.println();
        byte[] byArray = string.getBytes();
        try {
            this.testSignedAndEnvelopedDataStream(byArray);
            System.out.println();
            System.out.println("Ready!");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new TestSignedAndEnvelopedDataStream().start();
        System.in.read();
    }

    public TestSignedAndEnvelopedDataStream() throws IOException {
        System.out.println();
        System.out.println("*********************************************************************************************");
        System.out.println("*                               TestSignedAndEnvelopedDataStream demo                       *");
        System.out.println("* (shows the usage of the combined SignedDataStream and EnvelopedDataStream implementation) *");
        System.out.println("*********************************************************************************************");
        System.out.println();
        X509Certificate[] x509CertificateArray = CMSKeyStore.getCertificateChain(0, 1);
        this.user1_sign = x509CertificateArray[0];
        this.user1_sign_pk = CMSKeyStore.getPrivateKey(0, 1);
        this.user1_crypt = CMSKeyStore.getCertificateChain(0, 4)[0];
        this.user1_crypt_pk = CMSKeyStore.getPrivateKey(0, 4);
        this.user2_crypt = CMSKeyStore.getCertificateChain(0, 6)[0];
        this.user2_crypt_pk = CMSKeyStore.getPrivateKey(0, 6);
        this.certificates = new X509Certificate[x509CertificateArray.length + 1];
        System.arraycopy(x509CertificateArray, 0, this.certificates, 0, x509CertificateArray.length);
        this.certificates[x509CertificateArray.length] = this.user1_crypt;
        this.random = SecRandom.getDefault();
    }
}

