/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.cipher;

import iaik.xml.crypto.alg.cipher.ProxyCipher;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public abstract class BlockCipherProxyCipher
extends ProxyCipher {
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;
    protected SecureRandom random_;
    protected Key key_;
    protected int opmode_;
    protected int ivPos_;
    protected byte[] iv_;
    protected int ivLength_;

    protected int writeIV(byte[] byArray, int n) throws ShortBufferException {
        if (this.ivPos_ < this.ivLength_) {
            int n2 = this.ivLength_ - this.ivPos_;
            if (n + n2 > byArray.length) {
                throw new ShortBufferException();
            }
            System.arraycopy(this.iv_, this.ivPos_, byArray, n, n2);
            this.ivPos_ += n2;
            return n2;
        }
        return 0;
    }

    protected byte[] writeIV() {
        if (this.ivPos_ < this.ivLength_) {
            int n = this.ivLength_ - this.ivPos_;
            byte[] byArray = new byte[n];
            System.arraycopy(this.iv_, this.ivPos_, byArray, 0, n);
            this.ivPos_ += n;
            return byArray;
        }
        return null;
    }

    protected int readIV(byte[] byArray, int n, int n2) {
        if (this.ivPos_ < this.ivLength_) {
            int n3 = Math.min(this.ivLength_ - this.ivPos_, n2);
            if (n3 > 0 && byArray != null) {
                System.arraycopy(byArray, n, this.iv_, this.ivPos_, n3);
            }
            this.ivPos_ += n3;
            if (this.ivPos_ >= this.ivLength_) {
                IvParameterSpec ivParameterSpec = new IvParameterSpec(this.iv_);
                try {
                    this.cipher_.init(this.opmode_, this.key_, ivParameterSpec, this.random_);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new RuntimeException(invalidKeyException.getMessage());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    invalidAlgorithmParameterException.printStackTrace();
                }
            }
            return n3;
        }
        return 0;
    }

    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        return this.cipher_.wrap(key);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (this.opmode_ == 2 || this.opmode_ == 4) {
            if (this.ivPos_ < this.ivLength_) {
                int n4 = this.readIV(byArray, n, n2);
                if (n4 < n2) {
                    return super.engineUpdate(byArray, n + n4, n2 - n4, byArray2, n3);
                }
                return 0;
            }
            return super.engineUpdate(byArray, n, n2, byArray2, n3);
        }
        if (this.ivPos_ < this.ivLength_) {
            int n5 = this.writeIV(byArray2, n3);
            return n5 + super.engineUpdate(byArray, n, n2, byArray2, n3 + n5);
        }
        return super.engineUpdate(byArray, n, n2, byArray2, n3);
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (this.opmode_ == 2 || this.opmode_ == 4) {
            if (this.ivPos_ < this.ivLength_) {
                int n3 = this.readIV(byArray, n, n2);
                if (n3 < n2) {
                    return super.engineUpdate(byArray, n + n3, n2 - n3);
                }
                return null;
            }
            return super.engineUpdate(byArray, n, n2);
        }
        if (this.ivPos_ < this.ivLength_) {
            byte[] byArray2 = this.writeIV();
            byte[] byArray3 = super.engineUpdate(byArray, n, n2);
            return this.concatenate(byArray2, byArray3);
        }
        return super.engineUpdate(byArray, n, n2);
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws NoSuchAlgorithmException, InvalidKeyException {
        return this.cipher_.unwrap(byArray, string, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.opmode_ = n;
        this.key_ = key;
        this.random_ = secureRandom;
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("AlgorithmParameter " + (class$javax$crypto$spec$IvParameterSpec != null ? class$javax$crypto$spec$IvParameterSpec : (class$javax$crypto$spec$IvParameterSpec = BlockCipherProxyCipher.class$("javax.crypto.spec.IvParameterSpec"))).getName() + " not required.");
            this.iv_ = ((IvParameterSpec)algorithmParameterSpec).getIV();
            this.ivLength_ = this.iv_.length;
            this.ivPos_ = this.iv_.length;
            super.engineInit(n, key, algorithmParameterSpec, secureRandom);
            return;
        } else {
            this.engineInit(n, key, secureRandom);
        }
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.opmode_ = n;
        this.key_ = key;
        this.random_ = secureRandom;
        if (this.opmode_ == 2 || this.opmode_ == 4) {
            this.iv_ = new byte[this.ivLength_];
            this.ivPos_ = 0;
            IvParameterSpec ivParameterSpec = new IvParameterSpec(this.iv_);
            try {
                super.engineInit(n, key, ivParameterSpec, secureRandom);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                super.engineInit(n, key, secureRandom);
                this.ivLength_ = 0;
                this.ivPos_ = 0;
            }
        } else {
            super.engineInit(n, key, secureRandom);
            this.iv_ = this.cipher_.getIV();
            this.ivLength_ = this.iv_ != null ? this.iv_.length : 0;
            this.ivPos_ = 0;
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.opmode_ = n;
        this.key_ = key;
        this.random_ = secureRandom;
        if (algorithmParameters != null) {
            IvParameterSpec ivParameterSpec;
            try {
                ivParameterSpec = (IvParameterSpec)algorithmParameters.getParameterSpec(class$javax$crypto$spec$IvParameterSpec != null ? class$javax$crypto$spec$IvParameterSpec : (class$javax$crypto$spec$IvParameterSpec = BlockCipherProxyCipher.class$("javax.crypto.spec.IvParameterSpec")));
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameters " + algorithmParameters.getClass().getName() + " not supported.");
            }
            this.iv_ = ivParameterSpec.getIV();
            this.ivLength_ = this.iv_.length;
            this.ivPos_ = this.iv_.length;
            super.engineInit(n, key, algorithmParameters, secureRandom);
        } else {
            this.engineInit(n, key, secureRandom);
        }
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        if (this.opmode_ == 2 || this.opmode_ == 4) {
            if (this.ivPos_ < this.ivLength_) {
                int n4 = this.readIV(byArray, n, n2);
                if (n4 < n2) {
                    return super.engineDoFinal(byArray, n + n4, n2 - n4, byArray2, n3);
                }
                throw new IllegalBlockSizeException();
            }
            return super.engineDoFinal(byArray, n, n2, byArray2, n3);
        }
        if (this.ivPos_ < this.ivLength_) {
            int n5 = this.writeIV(byArray2, n3);
            return n5 + super.engineDoFinal(byArray, n, n2, byArray2, n3 + n5);
        }
        return super.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
        if (this.opmode_ == 2 || this.opmode_ == 4) {
            if (this.ivPos_ < this.ivLength_) {
                int n3 = this.readIV(byArray, n, n2);
                if (n3 < n2) {
                    return super.engineDoFinal(byArray, n + n3, n2 - n3);
                }
                throw new IllegalBlockSizeException();
            }
            return super.engineDoFinal(byArray, n, n2);
        }
        if (this.ivPos_ < this.ivLength_) {
            byte[] byArray2 = this.writeIV();
            byte[] byArray3 = super.engineDoFinal(byArray, n, n2);
            return this.concatenate(byArray2, byArray3);
        }
        return super.engineDoFinal(byArray, n, n2);
    }

    protected byte[] concatenate(byte[] byArray, byte[] byArray2) {
        int n;
        int n2 = byArray != null ? byArray.length : 0;
        int n3 = n = byArray2 != null ? byArray2.length : 0;
        if (n2 + n > 0) {
            byte[] byArray3 = new byte[n2 + n];
            if (n2 > 0) {
                System.arraycopy(byArray, 0, byArray3, 0, n2);
            }
            if (n > 0) {
                System.arraycopy(byArray2, 0, byArray3, n2, n);
            }
            return byArray3;
        }
        return null;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BlockCipherProxyCipher() throws NoSuchPaddingException, NoSuchProviderException, NoSuchAlgorithmException {
        this.ivLength_ = this.cipher_.getBlockSize();
    }
}

