/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.CodeSigner;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.timestamp.TimestampToken;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

public class JarSignature {
    private CertificateFactory certificateFactory;
    private Signature sig;
    private SignerInfo[] signers = null;
    private CodeSigner[] codesigners = null;
    private PublicKey publicKey = null;
    private PrivateKey privateKey = null;
    private X509Certificate[] certChain = null;
    public static String BLOB_SIGNATURE = "META-INF/SIGNATURE.BSF";

    private JarSignature() {
    }

    public static JarSignature load(byte[] byArray) throws ParsingException, CertificateException, IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        return new JarSignature(byArray);
    }

    public static JarSignature create(PrivateKey privateKey, X509Certificate[] x509CertificateArray) throws NoSuchAlgorithmException, InvalidKeyException {
        return new JarSignature(privateKey, x509CertificateArray);
    }

    private JarSignature(PrivateKey privateKey, X509Certificate[] x509CertificateArray) throws NoSuchAlgorithmException, InvalidKeyException {
        this.privateKey = privateKey;
        this.certChain = x509CertificateArray;
        String string = this.privateKey.getAlgorithm();
        if (string.equalsIgnoreCase("DSA")) {
            this.sig = Signature.getInstance("SHA1withDSA");
        } else if (string.equalsIgnoreCase("RSA")) {
            this.sig = Signature.getInstance("SHA256withRSA");
        } else if (string.equalsIgnoreCase("EC")) {
            this.sig = Signature.getInstance("SHA256withECDSA");
        } else {
            throw new RuntimeException("private key is not a DSA or RSA key");
        }
        this.sig.initSign(this.privateKey);
    }

    public byte[] getEncoded(String string) throws NoSuchAlgorithmException, SignatureException, IOException {
        if (this.privateKey == null) {
            return null;
        }
        AlgorithmId algorithmId = AlgorithmId.get(string);
        AlgorithmId[] algorithmIdArray = new AlgorithmId[]{algorithmId};
        ContentInfo contentInfo = new ContentInfo(ContentInfo.DATA_OID, null);
        Principal principal = this.certChain[0].getIssuerDN();
        BigInteger bigInteger = this.certChain[0].getSerialNumber();
        byte[] byArray = this.sig.sign();
        SignerInfo signerInfo = new SignerInfo((X500Name)principal, bigInteger, algorithmId, AlgorithmId.get(this.privateKey.getAlgorithm()), byArray);
        SignerInfo[] signerInfoArray = new SignerInfo[]{signerInfo};
        PKCS7 pKCS7 = new PKCS7(algorithmIdArray, contentInfo, this.certChain, signerInfoArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        pKCS7.encodeSignedData(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] getBytes(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    JarSignature(byte[] byArray) throws ParsingException, CertificateException, IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        PKCS7 pKCS7 = new PKCS7(byArray);
        this.certificateFactory = CertificateFactory.getInstance("X509");
        this.signers = pKCS7.getSignerInfos();
        X509Certificate x509Certificate = this.signers[0].getCertificate(pKCS7);
        this.publicKey = x509Certificate.getPublicKey();
        String string = this.publicKey.getAlgorithm();
        if (string.equalsIgnoreCase("DSA")) {
            this.sig = Signature.getInstance("SHA1withDSA");
        } else if (string.equalsIgnoreCase("RSA")) {
            this.sig = Signature.getInstance("SHA256withRSA");
        } else if (string.equalsIgnoreCase("EC")) {
            this.sig = Signature.getInstance("SHA256withECDSA");
        }
        this.sig.initVerify(this.publicKey);
        this.extractCodeSigners(this.signers, pKCS7);
    }

    public InputStream updateWithZipEntry(String string, InputStream inputStream) throws SignatureException {
        if (this.sig != null) {
            this.sig.update(string.getBytes());
        }
        return new ValidationStream(inputStream);
    }

    public void update(byte[] byArray) throws SignatureException {
        if (this.sig != null) {
            this.sig.update(byArray);
        }
    }

    public boolean isValid() {
        if (this.sig == null || this.signers == null || this.signers.length == 0) {
            return false;
        }
        try {
            return this.sig.verify(this.signers[0].getEncryptedDigest());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void extractCodeSigners(SignerInfo[] signerInfoArray, PKCS7 pKCS7) throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        ArrayList<CodeSigner> arrayList = new ArrayList<CodeSigner>();
        for (int i = 0; i < signerInfoArray.length; ++i) {
            SignerInfo signerInfo = signerInfoArray[i];
            ArrayList<X509Certificate> arrayList2 = signerInfo.getCertificateChain(pKCS7);
            CertPath certPath = this.certificateFactory.generateCertPath(arrayList2);
            CodeSigner codeSigner = new CodeSigner(certPath, this.getTimestamp(signerInfo));
            arrayList.add(codeSigner);
        }
        this.codesigners = arrayList.toArray(new CodeSigner[0]);
    }

    private Timestamp getTimestamp(SignerInfo signerInfo) throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        PKCS9Attribute pKCS9Attribute;
        Timestamp timestamp = null;
        PKCS9Attributes pKCS9Attributes = signerInfo.getUnauthenticatedAttributes();
        if (pKCS9Attributes != null && (pKCS9Attribute = pKCS9Attributes.getAttribute("signatureTimestampToken")) != null) {
            PKCS7 pKCS7 = new PKCS7((byte[])pKCS9Attribute.getValue());
            byte[] byArray = pKCS7.getContentInfo().getData();
            SignerInfo[] signerInfoArray = pKCS7.verify(byArray);
            ArrayList<X509Certificate> arrayList = signerInfoArray[0].getCertificateChain(pKCS7);
            CertPath certPath = this.certificateFactory.generateCertPath(arrayList);
            TimestampToken timestampToken = new TimestampToken(byArray);
            timestamp = new Timestamp(timestampToken.getDate(), certPath);
        }
        return timestamp;
    }

    public CodeSigner[] getCodeSigners() {
        return this.codesigners;
    }

    private class ValidationStream
    extends InputStream {
        InputStream dataStream = null;

        public ValidationStream(InputStream inputStream) {
            this.dataStream = inputStream;
        }

        public int read() throws IOException {
            int n = this.dataStream.read();
            try {
                JarSignature.this.sig.update((byte)n);
            }
            catch (SignatureException signatureException) {
                signatureException.printStackTrace();
            }
            return n;
        }

        public void close() throws IOException {
            this.dataStream.close();
        }
    }
}

