/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XEvent;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XkbAccessXNotifyEvent;
import sun.awt.X11.XkbActionMessageEvent;
import sun.awt.X11.XkbAnyEvent;
import sun.awt.X11.XkbBellNotifyEvent;
import sun.awt.X11.XkbCompatMapNotifyEvent;
import sun.awt.X11.XkbControlsNotifyEvent;
import sun.awt.X11.XkbExtensionDeviceNotifyEvent;
import sun.awt.X11.XkbIndicatorNotifyEvent;
import sun.awt.X11.XkbMapNotifyEvent;
import sun.awt.X11.XkbNamesNotifyEvent;
import sun.awt.X11.XkbNewKeyboardNotifyEvent;
import sun.awt.X11.XkbStateNotifyEvent;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XkbEvent
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 192;
    }

    @Override
    public int getDataSize() {
        return XkbEvent.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XkbEvent(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XkbEvent() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XkbEvent.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_type() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_type(int n) {
        log.finest("");
        Native.putInt(this.pData + 0L, n);
    }

    public XkbAnyEvent get_any() {
        log.finest("");
        return new XkbAnyEvent(this.pData + 0L);
    }

    public XkbNewKeyboardNotifyEvent get_new_kbd() {
        log.finest("");
        return new XkbNewKeyboardNotifyEvent(this.pData + 0L);
    }

    public XkbMapNotifyEvent get_map() {
        log.finest("");
        return new XkbMapNotifyEvent(this.pData + 0L);
    }

    public XkbStateNotifyEvent get_state() {
        log.finest("");
        return new XkbStateNotifyEvent(this.pData + 0L);
    }

    public XkbControlsNotifyEvent get_ctrls() {
        log.finest("");
        return new XkbControlsNotifyEvent(this.pData + 0L);
    }

    public XkbIndicatorNotifyEvent get_indicators() {
        log.finest("");
        return new XkbIndicatorNotifyEvent(this.pData + 0L);
    }

    public XkbNamesNotifyEvent get_names() {
        log.finest("");
        return new XkbNamesNotifyEvent(this.pData + 0L);
    }

    public XkbCompatMapNotifyEvent get_compat() {
        log.finest("");
        return new XkbCompatMapNotifyEvent(this.pData + 0L);
    }

    public XkbBellNotifyEvent get_bell() {
        log.finest("");
        return new XkbBellNotifyEvent(this.pData + 0L);
    }

    public XkbActionMessageEvent get_message() {
        log.finest("");
        return new XkbActionMessageEvent(this.pData + 0L);
    }

    public XkbAccessXNotifyEvent get_accessx() {
        log.finest("");
        return new XkbAccessXNotifyEvent(this.pData + 0L);
    }

    public XkbExtensionDeviceNotifyEvent get_device() {
        log.finest("");
        return new XkbExtensionDeviceNotifyEvent(this.pData + 0L);
    }

    public XEvent get_core() {
        log.finest("");
        return new XEvent(this.pData + 0L);
    }

    @Override
    String getName() {
        return "XkbEvent";
    }

    @Override
    String getFieldsAsString() {
        String string = "";
        string = string + "type = " + XlibWrapper.eventToString[this.get_type()] + ", ";
        string = string + "any = " + this.get_any() + ", ";
        string = string + "new_kbd = " + this.get_new_kbd() + ", ";
        string = string + "map = " + this.get_map() + ", ";
        string = string + "state = " + this.get_state() + ", ";
        string = string + "ctrls = " + this.get_ctrls() + ", ";
        string = string + "indicators = " + this.get_indicators() + ", ";
        string = string + "names = " + this.get_names() + ", ";
        string = string + "compat = " + this.get_compat() + ", ";
        string = string + "bell = " + this.get_bell() + ", ";
        string = string + "message = " + this.get_message() + ", ";
        string = string + "accessx = " + this.get_accessx() + ", ";
        string = string + "device = " + this.get_device() + ", ";
        string = string + "core = " + this.get_core() + ", ";
        return string;
    }
}

