/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.output;

import com.sun.xml.internal.bind.util.AttributesImpl;
import com.sun.xml.internal.bind.v2.runtime.XMLSerializer;
import com.sun.xml.internal.bind.v2.runtime.output.NamespaceContextImpl;
import com.sun.xml.internal.bind.v2.runtime.output.Pcdata;
import com.sun.xml.internal.bind.v2.runtime.output.XmlOutputAbstractImpl;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public class SAXOutput
extends XmlOutputAbstractImpl {
    protected final ContentHandler out;
    private String elementNsUri;
    private String elementLocalName;
    private String elementQName;
    private char[] buf = new char[256];
    private final AttributesImpl atts = new AttributesImpl();

    public SAXOutput(ContentHandler contentHandler) {
        this.out = contentHandler;
        contentHandler.setDocumentLocator(new LocatorImpl());
    }

    @Override
    public void startDocument(XMLSerializer xMLSerializer, boolean bl, int[] nArray, NamespaceContextImpl namespaceContextImpl) throws SAXException, IOException, XMLStreamException {
        super.startDocument(xMLSerializer, bl, nArray, namespaceContextImpl);
        if (!bl) {
            this.out.startDocument();
        }
    }

    @Override
    public void endDocument(boolean bl) throws SAXException, IOException, XMLStreamException {
        if (!bl) {
            this.out.endDocument();
        }
        super.endDocument(bl);
    }

    @Override
    public void beginStartTag(int n, String string) {
        this.elementNsUri = this.nsContext.getNamespaceURI(n);
        this.elementLocalName = string;
        this.elementQName = this.getQName(n, string);
        this.atts.clear();
    }

    @Override
    public void attribute(int n, String string, String string2) {
        String string3;
        String string4;
        if (n == -1) {
            string4 = "";
            string3 = string;
        } else {
            string4 = this.nsContext.getNamespaceURI(n);
            String string5 = this.nsContext.getPrefix(n);
            string3 = string5.length() == 0 ? string : string5 + ':' + string;
        }
        this.atts.addAttribute(string4, string, string3, "CDATA", string2);
    }

    @Override
    public void endStartTag() throws SAXException {
        NamespaceContextImpl.Element element = this.nsContext.getCurrent();
        if (element != null) {
            int n = element.count();
            for (int i = 0; i < n; ++i) {
                String string = element.getPrefix(i);
                String string2 = element.getNsUri(i);
                if (string2.length() == 0 && element.getBase() == 1) continue;
                this.out.startPrefixMapping(string, string2);
            }
        }
        this.out.startElement(this.elementNsUri, this.elementLocalName, this.elementQName, this.atts);
    }

    @Override
    public void endTag(int n, String string) throws SAXException {
        this.out.endElement(this.nsContext.getNamespaceURI(n), string, this.getQName(n, string));
        NamespaceContextImpl.Element element = this.nsContext.getCurrent();
        if (element != null) {
            int n2 = element.count();
            for (int i = n2 - 1; i >= 0; --i) {
                String string2 = element.getPrefix(i);
                String string3 = element.getNsUri(i);
                if (string3.length() == 0 && element.getBase() == 1) continue;
                this.out.endPrefixMapping(string2);
            }
        }
    }

    private String getQName(int n, String string) {
        String string2 = this.nsContext.getPrefix(n);
        String string3 = string2.length() == 0 ? string : string2 + ':' + string;
        return string3;
    }

    @Override
    public void text(String string, boolean bl) throws IOException, SAXException, XMLStreamException {
        int n = string.length();
        if (this.buf.length <= n) {
            this.buf = new char[Math.max(this.buf.length * 2, n + 1)];
        }
        if (bl) {
            string.getChars(0, n, this.buf, 1);
            this.buf[0] = 32;
        } else {
            string.getChars(0, n, this.buf, 0);
        }
        this.out.characters(this.buf, 0, n + (bl ? 1 : 0));
    }

    @Override
    public void text(Pcdata pcdata, boolean bl) throws IOException, SAXException, XMLStreamException {
        int n = pcdata.length();
        if (this.buf.length <= n) {
            this.buf = new char[Math.max(this.buf.length * 2, n + 1)];
        }
        if (bl) {
            pcdata.writeTo(this.buf, 1);
            this.buf[0] = 32;
        } else {
            pcdata.writeTo(this.buf, 0);
        }
        this.out.characters(this.buf, 0, n + (bl ? 1 : 0));
    }
}

