/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.Logging;
import com.sun.javafx.css.CascadingStyle;
import com.sun.javafx.css.CompoundSelector;
import com.sun.javafx.css.CssError;
import com.sun.javafx.css.Declaration;
import com.sun.javafx.css.Match;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.SimpleSelector;
import com.sun.javafx.css.Style;
import com.sun.javafx.css.StyleHelper;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.parser.CSSParser;
import com.sun.javafx.logging.PlatformLogger;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.PopupWindow;
import javafx.stage.Window;

public class StyleManager {
    private Stylesheet defaultUserAgentStylesheet;
    private ObservableMap<String, Stylesheet> authorStylesheetMap = FXCollections.observableHashMap();
    private static Map<String, ParentStylesheetContainer> parentStylesheetMap = new HashMap<String, ParentStylesheetContainer>();
    private Map<WeakReference<Scene>, StylesheetContainer> containerMap;
    private StylesheetContainer defaultContainer;
    private Map<String, Stylesheet> userAgentStylesheetMap = new HashMap<String, Stylesheet>();
    private final Map<String, Long> pseudoclassMasks = new HashMap<String, Long>();
    static int hits = 0;
    static int misses = 0;
    static int puts = 0;
    static int tries = 0;
    private ObservableList<CssError> errors = null;

    public static StyleManager getInstance() {
        return Holder.INSTANCE;
    }

    private static PlatformLogger logger() {
        return Holder.LOGGER;
    }

    private void addAuthorStylesheet(String string, Stylesheet stylesheet) {
        if (stylesheet != null) {
            stylesheet.setOrigin(Stylesheet.Origin.AUTHOR);
            this.authorStylesheetMap.put(string, stylesheet);
        } else {
            this.authorStylesheetMap.remove(string);
        }
    }

    private Stylesheet getAuthorStylesheet(String string) {
        return (Stylesheet)this.authorStylesheetMap.get(string);
    }

    public void parentStylesheetsChanged(Parent parent, ListChangeListener.Change<String> change) {
        Scene scene = parent.getScene();
        if (scene == null) {
            return;
        }
        boolean bl = false;
        while (change.next()) {
            if (!change.wasRemoved()) continue;
            List<String> list = change.getRemoved();
            int n = list != null ? list.size() : 0;
            for (int i = 0; i < n; ++i) {
                String string = list.get(i);
                ParentStylesheetContainer parentStylesheetContainer = parentStylesheetMap.remove(string);
                if (parentStylesheetContainer == null) continue;
                this.clearParentCache(parentStylesheetContainer);
            }
        }
        change.reset();
    }

    private void clearParentCache(ParentStylesheetContainer parentStylesheetContainer) {
        List list = ((RefList)parentStylesheetContainer.parents).list;
        List list2 = ((RefList)parentStylesheetContainer.keys).list;
        for (int i = list.size() - 1; 0 <= i; --i) {
            Scene scene;
            Reference reference = (Reference)list.get(i);
            Parent parent = (Parent)reference.get();
            if (parent == null || (scene = parent.getScene()) == null) continue;
            StylesheetContainer stylesheetContainer = null;
            if (this.containerMap != null && (stylesheetContainer = this.get(this.containerMap, scene)) != null) {
                this.clearParentCache(stylesheetContainer, list2);
            }
            if (this.defaultContainer != null) {
                this.clearParentCache(this.defaultContainer, list2);
            }
            parent.impl_reapplyCSS();
        }
    }

    private void clearParentCache(StylesheetContainer stylesheetContainer, List<Reference<Key>> list) {
        if (stylesheetContainer.cacheMap.isEmpty()) {
            return;
        }
        for (int i = list.size() - 1; 0 <= i; --i) {
            Reference<Key> reference = list.get(i);
            Key key = reference.get();
            if (key == null) continue;
            Cache cache = (Cache)stylesheetContainer.cacheMap.remove(key);
        }
    }

    private void expunge(Map<WeakReference<Scene>, StylesheetContainer> map) {
        ArrayList<WeakReference<Scene>> arrayList = null;
        for (WeakReference<Scene> weakReference : map.keySet()) {
            if (weakReference.get() != null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<WeakReference<Scene>>();
            }
            arrayList.add(weakReference);
        }
        if (arrayList != null) {
            for (int i = arrayList.size() - 1; 0 <= i; --i) {
                WeakReference<Scene> weakReference;
                weakReference = map.remove(arrayList.remove(i));
                ((StylesheetContainer)((Object)weakReference)).destroy();
            }
        }
    }

    private void put(Map<WeakReference<Scene>, StylesheetContainer> map, Scene scene, StylesheetContainer stylesheetContainer) {
        this.expunge(map);
        map.put(new WeakReference<Scene>(scene), stylesheetContainer);
    }

    private StylesheetContainer get(Map<WeakReference<Scene>, StylesheetContainer> map, Scene scene) {
        this.expunge(map);
        for (Map.Entry<WeakReference<Scene>, StylesheetContainer> entry : map.entrySet()) {
            if (!scene.equals(entry.getKey().get())) continue;
            return entry.getValue();
        }
        return null;
    }

    private StylesheetContainer remove(Map<WeakReference<Scene>, StylesheetContainer> map, Scene scene) {
        this.expunge(map);
        WeakReference<Scene> weakReference = null;
        for (WeakReference<Scene> weakReference2 : map.keySet()) {
            if (!scene.equals(weakReference2.get())) continue;
            weakReference = weakReference2;
            break;
        }
        Object object = null;
        if (weakReference != null) {
            object = map.remove(weakReference);
            weakReference.clear();
        }
        return object;
    }

    private StyleManager() {
    }

    private static URL getURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                String string2 = string != null && string.startsWith("/") ? string.substring(1) : string;
                return classLoader.getResource(string2);
            }
            return null;
        }
    }

    private Stylesheet loadStylesheet(final String string) {
        try {
            return this.loadStylesheetUnPrivileged(string);
        }
        catch (AccessControlException accessControlException) {
            if (StyleManager.logger().isLoggable(800)) {
                StyleManager.logger().info("Could not load the stylesheet, trying with FilePermissions : " + string);
            }
            if (string.length() < 7 && string.indexOf("!/") < string.length() - 7) {
                return null;
            }
            try {
                String string2;
                String string3;
                URI uRI;
                String string4;
                URI uRI2 = new URI(string);
                if ("jar".equals(uRI2.getScheme()) && (string4 = (uRI = AccessController.doPrivileged(new PrivilegedExceptionAction<URI>(){

                    @Override
                    public URI run() throws URISyntaxException, PrivilegedActionException {
                        return StyleManager.class.getProtectionDomain().getCodeSource().getLocation().toURI();
                    }
                })).getSchemeSpecificPart()).equals((string3 = (string2 = uRI2.getSchemeSpecificPart()).substring(string2.indexOf(47), string2.indexOf("!/"))).toString())) {
                    String string5 = string.substring(string.indexOf("!/") + 2);
                    if (string.endsWith(".css") || string.endsWith(".bss")) {
                        JarEntry jarEntry;
                        FilePermission filePermission = new FilePermission(string4, "read");
                        PermissionCollection permissionCollection = filePermission.newPermissionCollection();
                        permissionCollection.add(filePermission);
                        AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissionCollection)});
                        JarFile jarFile = null;
                        try {
                            jarFile = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                                @Override
                                public JarFile run() throws FileNotFoundException, IOException {
                                    return new JarFile(string4);
                                }
                            }, accessControlContext);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            return null;
                        }
                        if (jarFile != null && (jarEntry = jarFile.getJarEntry(string5)) != null) {
                            return AccessController.doPrivileged(new PrivilegedAction<Stylesheet>(){

                                @Override
                                public Stylesheet run() {
                                    return StyleManager.this.loadStylesheetUnPrivileged(string);
                                }
                            }, accessControlContext);
                        }
                    }
                }
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
    }

    private Stylesheet loadStylesheetUnPrivileged(final String string) {
        block12: {
            Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    String string2 = System.getProperty("binary.css");
                    return !string.endsWith(".bss") && string2 != null ? !Boolean.valueOf(string2).booleanValue() : Boolean.FALSE;
                }
            });
            try {
                String string2 = bl != false ? ".css" : ".bss";
                String string3 = string.endsWith(".css") || string.endsWith(".bss") ? string.substring(0, string.length() - 4) : string;
                URL uRL = StyleManager.getURL(string3 + string2);
                if (uRL == null && (bl = Boolean.valueOf(bl == false)).booleanValue()) {
                    uRL = StyleManager.getURL(string3 + ".css");
                }
                Stylesheet stylesheet = null;
                if (uRL != null && !bl.booleanValue() && (stylesheet = Stylesheet.loadBinary(uRL)) == null && (bl = Boolean.valueOf(bl == false)).booleanValue()) {
                    uRL = StyleManager.getURL(string3 + ".css");
                }
                if (uRL != null && bl.booleanValue()) {
                    stylesheet = CSSParser.getInstance().parse(uRL);
                }
                if (stylesheet == null) {
                    if (this.errors != null) {
                        CssError cssError = new CssError("Resource \"" + string + "\" not found.");
                        this.errors.add(cssError);
                    }
                    if (StyleManager.logger().isLoggable(900)) {
                        StyleManager.logger().warning(String.format("Resource \"%s\" not found.", string));
                    }
                }
                return stylesheet;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.errors != null) {
                    CssError cssError = new CssError("Stylesheet \"" + string + "\" not found.");
                    this.errors.add(cssError);
                }
                if (StyleManager.logger().isLoggable(800)) {
                    StyleManager.logger().info("Could not find stylesheet: " + string);
                }
            }
            catch (IOException iOException) {
                if (this.errors != null) {
                    CssError cssError = new CssError("Could not load stylesheet: " + string);
                    this.errors.add(cssError);
                }
                if (!StyleManager.logger().isLoggable(800)) break block12;
                StyleManager.logger().info("Could not load stylesheet: " + string);
            }
        }
        return null;
    }

    public void addUserAgentStylesheet(String string) {
        this.addUserAgentStylesheet(null, string);
    }

    public void addUserAgentStylesheet(Scene scene, String string) {
        if (string == null || string.trim().isEmpty()) {
            return;
        }
        if (!this.userAgentStylesheetMap.containsKey(string)) {
            CssError.setCurrentScene(scene);
            Stylesheet stylesheet = this.loadStylesheet(string);
            stylesheet.setOrigin(Stylesheet.Origin.USER_AGENT);
            this.userAgentStylesheetMap.put(string, stylesheet);
            if (stylesheet != null) {
                this.userAgentStylesheetsChanged();
            }
            CssError.setCurrentScene(null);
        }
    }

    public void setDefaultUserAgentStylesheet(String string) {
        this.setDefaultUserAgentStylesheet(null, string);
    }

    public void setDefaultUserAgentStylesheet(Scene scene, String string) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("null arg fname");
        }
        CssError.setCurrentScene(scene);
        Stylesheet stylesheet = this.loadStylesheet(string);
        if (stylesheet != null) {
            stylesheet.setOrigin(Stylesheet.Origin.USER_AGENT);
            this.setDefaultUserAgentStylesheet(stylesheet);
        }
        CssError.setCurrentScene(null);
    }

    public void setDefaultUserAgentStylesheet(Stylesheet stylesheet) {
        this.defaultUserAgentStylesheet = stylesheet;
        if (this.defaultUserAgentStylesheet != null) {
            this.defaultUserAgentStylesheet.setOrigin(Stylesheet.Origin.USER_AGENT);
        }
        this.userAgentStylesheetsChanged();
    }

    private void userAgentStylesheetsChanged() {
        if (this.defaultContainer != null) {
            this.defaultContainer.destroy();
            this.defaultContainer = null;
        }
        if (this.containerMap != null) {
            for (StylesheetContainer object : this.containerMap.values()) {
                object.destroy();
            }
            this.containerMap.clear();
        }
        Iterator<Object> iterator = Window.impl_getWindows();
        while (iterator.hasNext()) {
            Scene scene = ((Window)iterator.next()).getScene();
            if (scene == null) continue;
            this.updateStylesheets(scene);
            scene.getRoot().impl_reapplyCSS();
        }
    }

    public void reloadStylesheets(Scene scene) {
        this.authorStylesheetMap.clear();
        this.updateStylesheets(scene);
        scene.getRoot().impl_reapplyCSS();
    }

    public void replaceStylesheet(Scene scene, Stylesheet stylesheet) {
        StylesheetContainer stylesheetContainer;
        StylesheetContainer stylesheetContainer2 = stylesheetContainer = this.containerMap != null ? this.get(this.containerMap, scene) : null;
        if (stylesheetContainer != null) {
            int n = stylesheetContainer.stylesheets.indexOf(stylesheet);
            if (n > -1) {
                stylesheetContainer.stylesheets.set(n, stylesheet);
            } else {
                stylesheetContainer.stylesheets.add(stylesheet);
            }
            stylesheetContainer.clearCaches();
        } else {
            if (this.containerMap == null) {
                this.containerMap = new HashMap<WeakReference<Scene>, StylesheetContainer>();
            }
            stylesheetContainer = new StylesheetContainer(null);
            stylesheetContainer.stylesheets.add(stylesheet);
            this.put(this.containerMap, scene, stylesheetContainer);
        }
        scene.getRoot().impl_reapplyCSS();
    }

    public void updateStylesheets(Scene scene) {
        Object object;
        if (scene.getWindow() == null) {
            return;
        }
        if (this.containerMap != null && (object = this.remove(this.containerMap, scene)) != null) {
            ((StylesheetContainer)object).destroy();
        }
        if (scene.getStylesheets().size() == 0) {
            return;
        }
        CssError.setCurrentScene(scene);
        object = new ArrayList();
        for (int i = 0; i < scene.getStylesheets().size(); ++i) {
            String string = (String)scene.getStylesheets().get(i);
            string = string.trim();
            try {
                Stylesheet stylesheet = this.loadStylesheet(string);
                this.addAuthorStylesheet(string, stylesheet);
                if (stylesheet == null) continue;
                object.add(stylesheet);
                continue;
            }
            catch (Exception exception) {
                System.err.printf("Cannot add stylesheet. %s\n", exception.getLocalizedMessage());
            }
        }
        CssError.setCurrentScene(scene);
        if (this.containerMap == null) {
            this.containerMap = new HashMap<WeakReference<Scene>, StylesheetContainer>();
        }
        StylesheetContainer stylesheetContainer = new StylesheetContainer((Collection)object);
        this.put(this.containerMap, scene, stylesheetContainer);
    }

    public long getPseudoclassMask(String string) {
        Long l = this.pseudoclassMasks.get(string);
        if (l == null) {
            int n = this.pseudoclassMasks.size();
            l = 1L << n;
            this.pseudoclassMasks.put(string, l);
        }
        return l;
    }

    long getPseudoclassMask(List<String> list) {
        long l = 0L;
        int n = list != null ? list.size() : -1;
        for (int i = 0; i < n; ++i) {
            long l2 = this.getPseudoclassMask(list.get(i));
            l |= l2;
        }
        return l;
    }

    public List<String> getPseudoclassStrings(long l) {
        if (l == 0L) {
            return Collections.EMPTY_LIST;
        }
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        for (Map.Entry<String, Long> entry : this.pseudoclassMasks.entrySet()) {
            hashMap.put(entry.getValue(), entry.getKey());
        }
        ArrayList arrayList = new ArrayList();
        for (long i = 0L; i < 64L; ++i) {
            String string;
            long l2 = 1L << (int)i & l;
            if (l2 == 0L || (string = (String)hashMap.get(l2)) == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public StyleHelper getStyleHelper(Node node) {
        assert (node != null && node.getScene() != null);
        boolean bl = this.containerMap == null;
        StylesheetContainer stylesheetContainer = null;
        if (!bl) {
            EventTarget eventTarget;
            Window window = null;
            if (node != null && node.getScene() != null) {
                window = node.getScene().getWindow();
                while (window instanceof PopupWindow) {
                    eventTarget = (PopupWindow)window;
                    window = ((PopupWindow)eventTarget).getOwnerWindow();
                }
            }
            if ((eventTarget = window == null ? node.getScene() : window.getScene()) != null) {
                stylesheetContainer = this.get(this.containerMap, (Scene)eventTarget);
            }
            boolean bl2 = bl = stylesheetContainer == null;
        }
        if (bl) {
            if (this.defaultContainer == null) {
                this.defaultContainer = new StylesheetContainer(null);
            }
            return this.defaultContainer.getStyleHelper(node);
        }
        return stylesheetContainer.getStyleHelper(node);
    }

    public ObservableList<CssError> errorsProperty() {
        if (this.errors == null) {
            this.errors = FXCollections.observableArrayList();
        }
        return this.errors;
    }

    public ObservableList<CssError> getErrors() {
        return this.errors;
    }

    private static class Key {
        String className;
        String id;
        List<String> styleClass;
        int[] indices;

        private Key() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Key) {
                boolean bl;
                Key key = (Key)object;
                boolean bl2 = bl = this.className.equals(key.className) && (this.indices == null && key.indices == null || this.indices != null && key.indices != null) && (this.id == null && key.id == null || this.id != null && this.id.equals(key.id)) && (this.styleClass == null && key.styleClass == null || this.styleClass != null && this.styleClass.containsAll(key.styleClass));
                if (bl && this.indices != null) {
                    int n;
                    int n2 = Math.min(this.indices.length, key.indices.length);
                    for (n = 0; bl && n < n2; ++n) {
                        bl = this.indices[n] == key.indices[n];
                    }
                    if (bl) {
                        for (n = n2; bl && n < this.indices.length; ++n) {
                            bl = this.indices[n] == -1;
                        }
                        for (n = n2; bl && n < key.indices.length; ++n) {
                            bl = key.indices[n] == -1;
                        }
                    }
                }
                return bl;
            }
            return false;
        }

        public int hashCode() {
            int n = this.className.hashCode();
            n = 31 * (n + (this.id == null || this.id.isEmpty() ? 1231 : this.id.hashCode()));
            n = 31 * (n + (this.styleClass == null || this.styleClass.isEmpty() ? 1237 : ((Object)this.styleClass).hashCode()));
            if (this.indices != null) {
                n = 31 * (n + Arrays.hashCode(this.indices));
            }
            return n;
        }

        public String toString() {
            return "Key [" + this.className + ", " + String.valueOf(this.id) + ", " + String.valueOf(this.styleClass) + "]";
        }
    }

    private static class Cache {
        private final List<Rule> rules;
        private final long pseudoclassStateMask;
        private final boolean impactsChildren;
        private final Map<Long, StyleMap> cache;

        Cache(List<Rule> list, long l, boolean bl) {
            this.rules = list;
            this.pseudoclassStateMask = l;
            this.impactsChildren = bl;
            this.cache = new HashMap<Long, StyleMap>();
        }

        private StyleMap getStyleMap(StylesheetContainer stylesheetContainer, Node node) {
            Object object;
            int n;
            int n2;
            if (!this.impactsChildren) {
                boolean bl;
                String string = node.getStyle();
                boolean bl2 = bl = string != null && !string.isEmpty();
                if (this.rules.isEmpty() && this.pseudoclassStateMask == 0L && !bl) {
                    boolean bl3 = false;
                    List<StyleableProperty> list = node.impl_getStyleableProperties();
                    n2 = list != null ? list.size() : 0;
                    for (n = 0; n < n2; ++n) {
                        if (!list.get(n).isInherits()) continue;
                        bl3 = true;
                        break;
                    }
                    if (!bl3) {
                        return null;
                    }
                }
            }
            long l = 0L;
            long l2 = 1L;
            n = this.rules.size();
            for (n2 = 0; n2 < n; ++n2) {
                object = this.rules.get(n2);
                if (((Rule)object).applies(node)) {
                    l |= l2;
                }
                l2 <<= 1;
            }
            Long l3 = l;
            if (this.cache.containsKey(l3)) {
                StyleMap styleMap = this.cache.get(l3);
                return styleMap;
            }
            List<CascadingStyle> list = this.getStyles(node);
            object = new HashMap();
            int n3 = list != null ? list.size() : 0;
            for (int i = 0; i < n3; ++i) {
                CascadingStyle cascadingStyle = list.get(i);
                String string = cascadingStyle.getProperty();
                ArrayList<CascadingStyle> arrayList = (ArrayList<CascadingStyle>)object.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<CascadingStyle>(5);
                    object.put(string, arrayList);
                }
                arrayList.add(cascadingStyle);
            }
            StyleMap styleMap = new StyleMap(stylesheetContainer.nextSmapId(), (Map)object);
            this.cache.put(l3, styleMap);
            return styleMap;
        }

        private List<CascadingStyle> getStyles(Node node) {
            if (this.rules == null || this.rules.isEmpty()) {
                return null;
            }
            ArrayList<CascadingStyle> arrayList = new ArrayList<CascadingStyle>(this.rules.size());
            int n = 0;
            int n2 = this.rules.size();
            for (int i = 0; i < n2; ++i) {
                Rule rule = this.rules.get(i);
                List<Match> list = rule.matches(node);
                int n3 = list.size();
                for (int j = 0; j < n3; ++j) {
                    Match match = list.get(j);
                    if (match == null) continue;
                    int n4 = rule.declarations.size();
                    for (int k = 0; k < n4; ++k) {
                        Declaration declaration = (Declaration)rule.declarations.get(k);
                        CascadingStyle cascadingStyle = new CascadingStyle(new Style(match.selector, declaration), match.pseudoclasses, match.specificity, n++);
                        arrayList.add(cascadingStyle);
                    }
                }
            }
            Collections.sort(arrayList);
            return arrayList;
        }
    }

    static class StyleMap {
        final long uniqueId;
        final Map<String, List<CascadingStyle>> map;

        private StyleMap(long l, Map<String, List<CascadingStyle>> map) {
            this.uniqueId = l;
            this.map = map;
        }
    }

    private static class StylesheetContainer {
        private final List<Stylesheet> stylesheets;
        private final Map<Key, Cache> cacheMap = new HashMap<Key, Cache>();
        private final Key key = new Key();
        private final Map<StyleHelper.StyleCacheKey, StyleHelper.StyleCacheBucket> styleCache;
        private int smapCount;

        private StylesheetContainer(Collection<Stylesheet> collection) {
            this.stylesheets = new ArrayList<Stylesheet>();
            if (StyleManager.getInstance().defaultUserAgentStylesheet != null) {
                this.stylesheets.add(StyleManager.getInstance().defaultUserAgentStylesheet);
            }
            if (StyleManager.getInstance().userAgentStylesheetMap != null && !StyleManager.getInstance().userAgentStylesheetMap.isEmpty()) {
                this.stylesheets.addAll(StyleManager.getInstance().userAgentStylesheetMap.values());
            }
            if (collection != null) {
                this.stylesheets.addAll(collection);
            }
            this.styleCache = new HashMap<StyleHelper.StyleCacheKey, StyleHelper.StyleCacheBucket>();
            this.smapCount = 0;
        }

        private void destroy() {
            this.stylesheets.clear();
            this.clearCaches();
        }

        private void clearCaches() {
            this.styleCache.clear();
            this.cacheMap.clear();
            this.smapCount = 0;
        }

        private long nextSmapId() {
            return ++this.smapCount;
        }

        private static int[] getIndicesOfParentsWithStylesheets(Parent parent, int n) {
            if (parent == null) {
                return new int[n];
            }
            int[] nArray = StylesheetContainer.getIndicesOfParentsWithStylesheets(parent.getParent(), ++n);
            nArray[nArray.length - n] = !parent.getStylesheets().isEmpty() ? parent.hashCode() : -1;
            return nArray;
        }

        private List<ParentStylesheetContainer> gatherParentStylesheets(Parent parent) {
            if (parent == null) {
                return null;
            }
            List<String> list = parent.impl_getAllParentStylesheets();
            if (list == null || list.isEmpty()) {
                return null;
            }
            ArrayList<ParentStylesheetContainer> arrayList = new ArrayList<ParentStylesheetContainer>();
            CssError.setCurrentScene(parent.getScene());
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                String string = list.get(i);
                ParentStylesheetContainer parentStylesheetContainer = null;
                if (parentStylesheetMap.containsKey(string)) {
                    parentStylesheetContainer = (ParentStylesheetContainer)parentStylesheetMap.get(string);
                    ((RefList)parentStylesheetContainer.parents).add(parent);
                } else {
                    Stylesheet stylesheet = StyleManager.getInstance().loadStylesheet(string);
                    parentStylesheetContainer = new ParentStylesheetContainer(string, stylesheet);
                    ((RefList)parentStylesheetContainer.parents).add(parent);
                    parentStylesheetMap.put(string, parentStylesheetContainer);
                }
                if (parentStylesheetContainer == null) continue;
                arrayList.add(parentStylesheetContainer);
            }
            CssError.setCurrentScene(null);
            return arrayList;
        }

        private StyleHelper getStyleHelper(Node node) {
            Object object;
            String string = node.getClass().getName();
            String string2 = node.getId();
            ObservableList<String> observableList = node.getStyleClass();
            int[] nArray = StylesheetContainer.getIndicesOfParentsWithStylesheets(node instanceof Parent ? (Parent)node : node.getParent(), 0);
            boolean bl = false;
            for (int i = 0; i < nArray.length && !(bl = nArray[i] != -1); ++i) {
            }
            this.key.className = string;
            this.key.id = string2;
            this.key.styleClass = observableList;
            this.key.indices = (int[])(bl ? nArray : null);
            Cache cache = this.cacheMap.get(this.key);
            this.key.styleClass = null;
            if (cache == null) {
                int n;
                Object object2;
                int n2;
                int n3;
                object = new ArrayList();
                long l = 0L;
                boolean bl2 = node instanceof Parent;
                boolean bl3 = false;
                List<ParentStylesheetContainer> list = bl ? this.gatherParentStylesheets(node instanceof Parent ? (Parent)node : node.getParent()) : null;
                List<Stylesheet> list2 = null;
                if (list == null || list.isEmpty()) {
                    list2 = this.stylesheets;
                } else {
                    list2 = new ArrayList<Stylesheet>(list.size());
                    n3 = list.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        object2 = list.get(n2);
                        list2.add(((ParentStylesheetContainer)object2).stylesheet);
                    }
                    list2.addAll(0, this.stylesheets);
                }
                n3 = list2.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    List<Rule> list3;
                    object2 = list2.get(n2);
                    List<Rule> list4 = list3 = object2 != null ? ((Stylesheet)object2).getRules() : null;
                    if (list3 == null || list3.isEmpty()) continue;
                    int n4 = list3.size();
                    for (int i = 0; i < n4; ++i) {
                        Rule rule = list3.get(i);
                        boolean bl4 = rule.mightApply(string, string2, observableList);
                        if (bl4) {
                            object.add(rule);
                        }
                        if (!bl4 && !bl2) continue;
                        int n5 = rule.selectors != null ? rule.selectors.size() : 0;
                        for (int j = 0; j < n5; ++j) {
                            Selector selector;
                            Selector selector2 = rule.selectors.get(j);
                            if (selector2 instanceof CompoundSelector) {
                                selector = (CompoundSelector)selector2;
                                List<SimpleSelector> list5 = ((CompoundSelector)selector).getSelectors();
                                if (bl4) {
                                    SimpleSelector simpleSelector = list5.get(list5.size() - 1);
                                    l |= StyleManager.getInstance().getPseudoclassMask(simpleSelector.getPseudoclasses());
                                    continue;
                                }
                                if (!bl2) continue;
                                int n6 = list5.size() - 1;
                                for (int k = 0; k < n6; ++k) {
                                    SimpleSelector simpleSelector = list5.get(k);
                                    if (!simpleSelector.mightApply(string, string2, observableList)) continue;
                                    l |= StyleManager.getInstance().getPseudoclassMask(simpleSelector.getPseudoclasses());
                                    bl3 = true;
                                }
                                continue;
                            }
                            if (!bl4) continue;
                            selector = (SimpleSelector)selector2;
                            l |= StyleManager.getInstance().getPseudoclassMask(((SimpleSelector)selector).getPseudoclasses());
                        }
                    }
                }
                Key key = new Key();
                key.className = string;
                key.id = string2;
                n3 = observableList.size();
                key.styleClass = new ArrayList<String>(n3);
                for (n = 0; n < n3; ++n) {
                    key.styleClass.add((String)observableList.get(n));
                }
                key.indices = (int[])(bl ? nArray : null);
                cache = new Cache((List<Rule>)object, l, bl3);
                this.cacheMap.put(key, cache);
                n = list != null ? list.size() : 0;
                for (int i = 0; i < n; ++i) {
                    ParentStylesheetContainer parentStylesheetContainer = list.get(i);
                    ((RefList)parentStylesheetContainer.keys).add(key);
                }
            }
            if ((object = cache.getStyleMap(this, node)) == null) {
                return null;
            }
            StyleHelper styleHelper = StyleHelper.create(node, ((StyleMap)object).map, this.styleCache, cache.pseudoclassStateMask, ((StyleMap)object).uniqueId);
            return styleHelper;
        }
    }

    private static class RefList<K> {
        private final List<Reference<K>> list = new ArrayList<Reference<K>>();

        private RefList() {
        }

        private void add(K k) {
            for (int i = this.list.size() - 1; 0 <= i; --i) {
                Reference<K> reference = this.list.get(i);
                K k2 = reference.get();
                if (k2 == null) {
                    this.list.remove(i);
                    continue;
                }
                if (k2 != k) continue;
                return;
            }
            this.list.add(new WeakReference<K>(k));
        }
    }

    private static class ParentStylesheetContainer {
        private final String fname;
        private final Stylesheet stylesheet;
        private final RefList<Parent> parents;
        private final RefList<Key> keys;

        private ParentStylesheetContainer(String string, Stylesheet stylesheet) {
            this.fname = string;
            this.stylesheet = stylesheet;
            this.parents = new RefList();
            this.keys = new RefList();
        }
    }

    private static class Holder {
        private static StyleManager INSTANCE = new StyleManager();
        private static PlatformLogger LOGGER = Logging.getCSSLogger();

        private Holder() {
        }
    }
}

