/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.NULL;
import iaik.utils.InternalErrorException;
import iaik.x509.ocsp.RevokedInfo;
import iaik.x509.ocsp.UnknownInfo;

public class CertStatus {
    UnknownInfo a;
    RevokedInfo b;
    int c;
    public static final int UNKNOWN = 2;
    public static final int REVOKED = 1;
    public static final int GOOD = 0;

    public String toString() {
        switch (this.c) {
            case 0: {
                return "good";
            }
            case 1: {
                return "Revoked: " + this.b;
            }
            case 2: {
                return "unknown " + this.a;
            }
        }
        throw new InternalErrorException("Unsupported cert status: " + this.c);
    }

    public ASN1Object toASN1Object() {
        switch (this.c) {
            case 0: {
                return new CON_SPEC(0, new NULL(), true);
            }
            case 1: {
                return new CON_SPEC(1, this.b.toASN1Object(), true);
            }
            case 2: {
                return new CON_SPEC(2, this.a.toASN1Object(), true);
            }
        }
        return null;
    }

    public UnknownInfo getUnknownInfo() {
        return this.a;
    }

    public RevokedInfo getRevokedInfo() {
        return this.b;
    }

    public String getCertStatusName() {
        String string;
        switch (this.c) {
            case 0: {
                string = "good";
                break;
            }
            case 1: {
                string = "revoked";
                break;
            }
            case 2: {
                string = "unknown";
                break;
            }
            default: {
                string = "undefined cert status: " + this.c;
            }
        }
        return string;
    }

    public int getCertStatus() {
        return this.c;
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
        this.c = cON_SPEC.getAsnType().getTag();
        switch (this.c) {
            case 1: {
                cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                this.b = new RevokedInfo((ASN1Object)cON_SPEC.getValue());
                return;
            }
            case 2: {
                boolean bl = false;
                if (cON_SPEC.countComponents() == 1) {
                    if (cON_SPEC.getComponentAt(0).getAsnType().equals(ASN.ENUMERATED)) {
                        bl = true;
                    }
                } else {
                    Object object = cON_SPEC.getValue();
                    if (object instanceof byte[] && ((byte[])object).length > 0) {
                        cON_SPEC.forceImplicitlyTagged(ASN.ENUMERATED);
                        bl = true;
                    }
                }
                if (!bl) {
                    cON_SPEC.forceImplicitlyTagged(ASN.NULL);
                }
                this.a = new UnknownInfo((ASN1Object)cON_SPEC.getValue());
                return;
            }
            default: {
                throw new CodingException("Unsupported cert status. Invalid tag:" + this.c);
            }
            case 0: 
        }
    }

    public CertStatus(UnknownInfo unknownInfo) {
        this.c = 2;
        if (unknownInfo == null) {
            unknownInfo = new UnknownInfo();
        }
        this.a = unknownInfo;
    }

    public CertStatus(RevokedInfo revokedInfo) {
        if (revokedInfo == null) {
            throw new IllegalArgumentException("Cannot create revoked CertStatus. Missing RevokedInfo!");
        }
        this.c = 1;
        this.b = revokedInfo;
    }

    public CertStatus(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }

    public CertStatus() {
        this.c = 0;
    }
}

