/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig.keyinfo;

import iaik.security.ecc.ECCException;
import iaik.security.ecc.ecdsa.ECDSAParameter;
import iaik.security.ecc.ecdsa.ECPublicKey;
import iaik.security.ecc.interfaces.ECDSAParams;
import iaik.security.ecc.interfaces.ECDSAPublicKey;
import iaik.security.ecc.math.ecgroup.AffineCoordinate;
import iaik.security.ecc.math.ecgroup.Coordinate;
import iaik.security.ecc.math.ecgroup.ECGroupFactory;
import iaik.security.ecc.math.ecgroup.ECPoint;
import iaik.security.ecc.math.ecgroup.EllipticCurve;
import iaik.security.ecc.math.field.BinaryField;
import iaik.security.ecc.math.field.Field;
import iaik.security.ecc.math.field.FieldElement;
import iaik.security.ecc.math.field.PrimeField;
import iaik.security.ecc.parameter.ECCParameterFactory;
import iaik.security.ecc.spec.ECCParameterSpec;
import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.keyinfo.KeyValueType;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.URI;
import iaik.xml.crypto.utils.URIException;
import java.math.BigInteger;
import java.security.PublicKey;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ECDSAKeyValueImpl
extends KeyValueType {
    static /* synthetic */ Class class$iaik$security$ecc$interfaces$ECDSAPublicKey;
    public static final String xsiNS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final int BINARYFIELD_TYPE = 2;
    public static final int PRIMEFIELD_TYPE = 1;

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        NodeList nodeList2;
        int n;
        int n2;
        int n3;
        Object object;
        String string;
        Element element;
        Object object2;
        ECCParameterSpec eCCParameterSpec;
        Object object3;
        Object object4;
        if (nodeList == null) {
            return;
        }
        String string2 = this.getNamespace();
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Element element2 = ECDSAKeyValueImpl.getChildElement((Element)this.getNode(), string2, "DomainParameters", 1);
        if (element2 == null) {
            throw new MarshalException("Domain parameters must not be implicit.");
        }
        Element element3 = ECDSAKeyValueImpl.getChildElement(element2, string2, "NamedCurve", 1);
        if (element3 != null) {
            try {
                object4 = new URI(element3.getAttributeNS(null, "URN"));
                object3 = ECCParameterFactory.getInstance();
                eCCParameterSpec = object3.getParameterByOID(((URI)object4).getPath().substring(4));
            }
            catch (URIException uRIException) {
                throw new MarshalException("Error when producing a URI from OID: ", uRIException);
            }
        } else {
            BigInteger bigInteger;
            Node node;
            object4 = ECDSAKeyValueImpl.getChildElement(element2, string2, "ExplicitParams", 1);
            object3 = ECDSAKeyValueImpl.getChildElement((Element)object4, string2, "FieldParams", 1);
            object2 = ECDSAKeyValueImpl.getChildElement((Element)object4, string2, "CurveParams", 1);
            element = ECDSAKeyValueImpl.getChildElement((Element)object4, string2, "BasePointParams", 1);
            string = dOMCryptoContext.getNamespacePrefix(string2, null);
            object = null;
            int n4 = 0;
            boolean bl = true;
            int n5 = 2;
            n3 = 3;
            n2 = 4;
            n = -1;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            nodeList2 = object3.getChildNodes();
            int n10 = 0;
            while (n10 < nodeList2.getLength()) {
                node = nodeList2.item(n10);
                if (node.getNodeType() == 1) {
                    if (node.getLocalName().equals("P")) {
                        if (n4 != 0) {
                            throw new MarshalException("Illegal FieldParameters supplied");
                        }
                        n4 = 1;
                        object = new BigInteger(ECDSAKeyValueImpl.getChildElementText((Element)object3, string2, "P", 1), 10);
                    } else if (node.getLocalName().equals("M")) {
                        if (n4 != 0) {
                            throw new MarshalException("Illegal FieldParameters supplied");
                        }
                        n4 = 2;
                        n = Integer.parseInt(ECDSAKeyValueImpl.getChildElementText((Element)object3, string2, "M", 1));
                    } else if (node.getLocalName().equals("K")) {
                        if (n4 != 2) {
                            throw new MarshalException("Illegal FieldParameters supplied");
                        }
                        n4 = 3;
                        n6 = Integer.parseInt(ECDSAKeyValueImpl.getChildElementText((Element)object3, string2, "K", 1));
                    } else if (node.getLocalName().equals("K1")) {
                        if (n4 != 2) {
                            throw new MarshalException("Illegal FieldParameters supplied");
                        }
                        n4 = 4;
                        n7 = Integer.parseInt(ECDSAKeyValueImpl.getChildElementText((Element)object3, string2, "K1", 1));
                    } else if (node.getLocalName().equals("K2")) {
                        if (n4 != 4) {
                            throw new MarshalException("Illegal FieldParameters supplied");
                        }
                        n4 = 4;
                        n8 = Integer.parseInt(ECDSAKeyValueImpl.getChildElementText((Element)object3, string2, "K2", 1));
                    } else if (node.getLocalName().equals("K3")) {
                        if (n4 != 4) {
                            throw new MarshalException("Illegal FieldParameters supplied");
                        }
                        n4 = 4;
                        n9 = Integer.parseInt(ECDSAKeyValueImpl.getChildElementText((Element)object3, string2, "K3", 1));
                    }
                }
                ++n10;
            }
            if (n4 == 0) {
                throw new MarshalException("No valid FieldParams found!");
            }
            node = ECDSAKeyValueImpl.getChildElement((Element)object2, string2, "A", 1);
            String string3 = node.getAttributeNS(null, "Value");
            Element element4 = ECDSAKeyValueImpl.getChildElement((Element)object2, string2, "B", 1);
            String string4 = element4.getAttributeNS(null, "Value");
            String string5 = ECDSAKeyValueImpl.getChildElementText((Element)object2, string2, "Seed", 1);
            BigInteger bigInteger2 = string5 != null ? new BigInteger(string5, 10) : null;
            Element element5 = ECDSAKeyValueImpl.getChildElement(element, string2, "BasePoint", 1);
            Element element6 = ECDSAKeyValueImpl.getChildElement(element5, string2, "X", 1);
            String string6 = element6.getAttributeNS(null, "Value");
            Element element7 = ECDSAKeyValueImpl.getChildElement(element5, string2, "Y", 1);
            String string7 = element7.getAttributeNS(null, "Value");
            String string8 = ECDSAKeyValueImpl.getChildElementText(element, string2, "Order", 1);
            BigInteger bigInteger3 = new BigInteger(string8, 10);
            String string9 = ECDSAKeyValueImpl.getChildElementText(element, string2, "Cofactor", 1);
            BigInteger bigInteger4 = bigInteger = string9 != null ? new BigInteger(string9, 10) : null;
            if (n4 == 1) {
                BigInteger bigInteger5 = new BigInteger(string3, 10);
                BigInteger bigInteger6 = new BigInteger(string4, 10);
                BigInteger bigInteger7 = new BigInteger(string6, 10);
                BigInteger bigInteger8 = new BigInteger(string7, 10);
                eCCParameterSpec = new ECCParameterSpec((BigInteger)object, bigInteger, bigInteger3, bigInteger2, null, bigInteger5, bigInteger6, bigInteger7, bigInteger8, null);
            } else {
                int[] nArray = new int[n / 32 + (n % 32 != 0 ? 1 : 0)];
                if (n4 == 3) {
                    nArray[n / 32] = 1 << n % 32;
                    int n11 = n6 / 32;
                    nArray[n11] = nArray[n11] + (1 << n6 % 32);
                    nArray[0] = nArray[0] + 1;
                } else {
                    nArray[n / 32] = 1 << n % 32;
                    int n12 = n9 / 32;
                    nArray[n12] = nArray[n12] + (1 << n9 % 32);
                    int n13 = n8 / 32;
                    nArray[n13] = nArray[n13] + (1 << n8 % 32);
                    int n14 = n7 / 32;
                    nArray[n14] = nArray[n14] + (1 << n7 % 32);
                    nArray[0] = nArray[0] + 1;
                }
                eCCParameterSpec = new ECCParameterSpec(nArray, bigInteger, bigInteger3, ECDSAKeyValueImpl.octetString2IntArray(string3), ECDSAKeyValueImpl.octetString2IntArray(string4), ECDSAKeyValueImpl.octetString2IntArray(string6), ECDSAKeyValueImpl.octetString2IntArray(string7), null);
            }
        }
        object4 = ECDSAKeyValueImpl.getChildElement((Element)this.getNode(), string2, "PublicKey", 1);
        object3 = ECDSAKeyValueImpl.getChildElement((Element)object4, string2, "X", 1);
        object2 = object3.getAttributeNS(null, "Value");
        element = ECDSAKeyValueImpl.getChildElement((Element)object4, string2, "Y", 1);
        string = element.getAttributeNS(null, "Value");
        try {
            FieldElement fieldElement;
            FieldElement fieldElement2;
            object = new ECDSAParameter(eCCParameterSpec);
            ECGroupFactory eCGroupFactory = ECGroupFactory.getInstance();
            EllipticCurve ellipticCurve = eCGroupFactory.getCurve(eCCParameterSpec.getA(), eCCParameterSpec.getB(), eCCParameterSpec.getR(), 1);
            Field field = ellipticCurve.getField();
            n3 = 1;
            n2 = 2;
            int n15 = n = eCCParameterSpec.getGx().getField().getFieldId() == 1 ? n3 : n2;
            if (n == n3) {
                PrimeField primeField = (PrimeField)field;
                fieldElement2 = primeField.newElement(new BigInteger((String)object2, 10));
                fieldElement = primeField.newElement(new BigInteger(string, 10));
            } else {
                fieldElement2 = field.newElement(ECDSAKeyValueImpl.octetString2ByteArray((String)object2));
                fieldElement = field.newElement(ECDSAKeyValueImpl.octetString2ByteArray(string));
            }
            AffineCoordinate affineCoordinate = new AffineCoordinate(fieldElement2, fieldElement);
            ECPoint eCPoint = ellipticCurve.newPoint((Coordinate)affineCoordinate);
            nodeList2 = new ECPublicKey((ECDSAParams)object, eCPoint);
            this.publicKey_ = nodeList2;
        }
        catch (ECCException eCCException) {
            throw new MarshalException("An error occured during Marshaling the ECDSAKeyValue");
        }
    }

    private static int[] octetString2IntArray(String string) {
        int n = string.length() / 2;
        int[] nArray = new int[n / 4 + (n % 4 != 0 ? 1 : 0)];
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.length() - (n2 + 1) * 2;
            int n4 = Integer.parseInt(string.substring(n3, n3 + 2), 16);
            int n5 = n2 / 4;
            nArray[n5] = nArray[n5] + ((n4 & 0xFF) << n2 % 4 * 8);
            ++n2;
        }
        return nArray;
    }

    private static byte[] octetString2ByteArray(String string) {
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.length() - (n2 + 1) * 2;
            byArray[n - n2 - 1] = (byte)Integer.parseInt(string.substring(n3, n3 + 2), 16);
            ++n2;
        }
        return byArray;
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.marshalAttributes(dOMCryptoContext, element);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Element element;
        Node node3;
        Element element2;
        Object object;
        Object object2;
        Node node4 = super.marshal(dOMCryptoContext, node, node2);
        dOMCryptoContext.putNamespacePrefix(xsiNS, "xsi");
        Document document = DOMUtils.getOwnerDocument(node);
        String string = dOMCryptoContext.getNamespacePrefix(this.getNamespace(), dOMCryptoContext.getDefaultNamespacePrefix());
        String string2 = this.getNamespace();
        ECDSAPublicKey eCDSAPublicKey = (ECDSAPublicKey)this.publicKey_;
        ECDSAParams eCDSAParams = eCDSAPublicKey.getParameter();
        EllipticCurve ellipticCurve = eCDSAParams.getG().getCurve();
        Field field = ellipticCurve.getField();
        int n = field.getFieldId();
        if (eCDSAParams != null) {
            object2 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "DomainParameters"));
            object = eCDSAParams.getOID();
            if (object != null) {
                element2 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "NamedCurve"));
                node3 = document.createAttributeNS("", "URN");
                node3.setValue("urn:oid:" + eCDSAParams.getOID());
                element2.setAttributeNodeNS((Attr)node3);
                object2.appendChild(element2);
                node4.appendChild((Node)object2);
            } else {
                Element element3;
                Element element4;
                Object object3;
                Object object4;
                Object object5;
                element2 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "ExplicitParams"));
                node3 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "FieldParams"));
                if (n == 1) {
                    element = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "P"));
                    DOMUtils.addBigIntegerToElement(element, field.getSize());
                    node3.appendChild(element);
                    node3.setAttributeNS(xsiNS, "xsi:type", "PrimeFieldParamsType");
                    DOMUtils.createNSDeclAttribute(dOMCryptoContext, (Element)node3, xsiNS);
                } else {
                    if (n != 2) {
                        throw new MarshalException("Field type not supported!");
                    }
                    element = (BinaryField)field;
                    object5 = element.getIrreduciblePolynomial();
                    object4 = element.newElement((int[])object5);
                    int n2 = element.getOrder();
                    object3 = new int[3];
                    int n3 = 2;
                    int n4 = 1;
                    while (n4 < n2 - 1) {
                        if (object4.testBit(n4)) {
                            object3[n3 - 2] = n4;
                            if (++n3 == 5) break;
                        }
                        ++n4;
                    }
                    switch (n3) {
                        case 3: {
                            element4 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "M"));
                            DOMUtils.addTextToElement(element4, Integer.toString(element.getOrder(), 10));
                            node3.appendChild(element4);
                            element3 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "K"));
                            DOMUtils.addTextToElement(element3, Integer.toString(object3[0], 10));
                            node3.appendChild(element3);
                            node3.setAttributeNS(xsiNS, "xsi:type", "TnBFieldParamsType");
                            DOMUtils.createNSDeclAttribute(dOMCryptoContext, (Element)node3, xsiNS);
                            break;
                        }
                        case 5: {
                            element4 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "M"));
                            DOMUtils.addTextToElement(element4, Integer.toString(element.getOrder(), 10));
                            node3.appendChild(element4);
                            Element element5 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "K1"));
                            DOMUtils.addTextToElement(element5, Integer.toString(object3[0], 10));
                            node3.appendChild(element5);
                            Element element6 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "K2"));
                            DOMUtils.addTextToElement(element6, Integer.toString(object3[1], 10));
                            node3.appendChild(element6);
                            Element element7 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "K3"));
                            DOMUtils.addTextToElement(element7, Integer.toString(object3[2], 10));
                            node3.appendChild(element7);
                            node3.setAttributeNS(xsiNS, "xsi:type", "PnBFieldParamsType");
                            DOMUtils.createNSDeclAttribute(dOMCryptoContext, (Element)node3, xsiNS);
                            break;
                        }
                    }
                }
                element2.appendChild(node3);
                element = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "CurveParams"));
                object5 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "A"));
                object5.setAttributeNS("", "Value", n == 1 ? ellipticCurve.getA().toBigInt().toString(10) : ECDSAKeyValueImpl.evenStringLength(ellipticCurve.getA().toBigInt().toString(16)));
                element.appendChild((Node)object5);
                object4 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "B"));
                object4.setAttributeNS("", "Value", n == 1 ? ellipticCurve.getB().toBigInt().toString(10) : ECDSAKeyValueImpl.evenStringLength(ellipticCurve.getB().toBigInt().toString(16)));
                element.appendChild((Node)object4);
                if (eCDSAParams.getS() != null) {
                    Element element8 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "Seed"));
                    element8.appendChild(document.createTextNode(ECDSAKeyValueImpl.evenStringLength(eCDSAParams.getS().toString(16))));
                    element.appendChild(element8);
                }
                element2.appendChild(element);
                Element element9 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "BasePointParams"));
                object3 = eCDSAParams.getG();
                AffineCoordinate affineCoordinate = (AffineCoordinate)object3.getCoordinates().toAffine();
                Element element10 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "BasePoint"));
                element9.appendChild(element10);
                if (!object3.isInfinity()) {
                    element4 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "X"));
                    element3 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "Y"));
                    element10.appendChild(element4);
                    element10.appendChild(element3);
                    element4.setAttributeNS("", "Value", n == 1 ? affineCoordinate.getX().toBigInt().toString(10) : ECDSAKeyValueImpl.evenStringLength(eCDSAParams.getG().getCoordinates().getX().toBigInt().toString(16)));
                    element4.setAttributeNS(xsiNS, "xsi:type", n == 1 ? DOMStructure.getQualifiedName(string, "PrimeFieldElemType") : DOMStructure.getQualifiedName(string, "CharTwoFieldElemType"));
                    DOMUtils.createNSDeclAttribute(dOMCryptoContext, element4, xsiNS);
                    element3.setAttributeNS("", "Value", n == 1 ? affineCoordinate.getY().toBigInt().toString(10) : ECDSAKeyValueImpl.evenStringLength(eCDSAParams.getG().getCoordinates().getY().toBigInt().toString(16)));
                    element3.setAttributeNS(xsiNS, "xsi:type", n == 1 ? DOMStructure.getQualifiedName(string, "PrimeFieldElemType") : DOMStructure.getQualifiedName(string, "CharTwoFieldElemType"));
                    DOMUtils.createNSDeclAttribute(dOMCryptoContext, element3, xsiNS);
                }
                element4 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "Order"));
                element9.appendChild(element4);
                DOMUtils.addBigIntegerToElement(element4, eCDSAParams.getR());
                if (eCDSAParams.getK() != null) {
                    element3 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "Cofactor"));
                    element9.appendChild(element3);
                    DOMUtils.addBigIntegerToElement(element3, eCDSAParams.getK());
                }
                element2.appendChild(element9);
                object2.appendChild(element2);
                node4.appendChild((Node)object2);
            }
        }
        object2 = eCDSAPublicKey.getW();
        object = (AffineCoordinate)object2.getCoordinates().toAffine();
        element2 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "PublicKey"));
        if (!object2.isInfinity()) {
            node3 = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "X"));
            element = document.createElementNS(string2, DOMStructure.getQualifiedName(string, "Y"));
            node3.setAttributeNS("", "Value", n == 1 ? object.getX().toBigInt().toString(10) : ECDSAKeyValueImpl.evenStringLength(object.getX().toBigInt().toString(16)));
            node3.setAttributeNS(xsiNS, "xsi:type", n == 1 ? DOMStructure.getQualifiedName(string, "PrimeFieldElemType") : DOMStructure.getQualifiedName(string, "CharTwoFieldElemType"));
            DOMUtils.createNSDeclAttribute(dOMCryptoContext, (Element)node3, xsiNS);
            element.setAttributeNS("", "Value", n == 1 ? object.getY().toBigInt().toString(10) : ECDSAKeyValueImpl.evenStringLength(object.getY().toBigInt().toString(16)));
            element.setAttributeNS(xsiNS, "xsi:type", n == 1 ? DOMStructure.getQualifiedName(string, "PrimeFieldElemType") : DOMStructure.getQualifiedName(string, "CharTwoFieldElemType"));
            DOMUtils.createNSDeclAttribute(dOMCryptoContext, element, xsiNS);
            element2.appendChild(node3);
            element2.appendChild(element);
        }
        node4.appendChild(element2);
        dOMCryptoContext.putNamespacePrefix(xsiNS, null);
        return node4;
    }

    public String getNamespace() {
        return "http://www.w3.org/2001/04/xmldsig-more#";
    }

    public String getLocalName() {
        return "ECDSAKeyValue";
    }

    private static String getChildElementText(Element element, String string, String string2, int n) {
        Element element2 = ECDSAKeyValueImpl.getChildElement(element, string, string2, n);
        if (element2 == null) {
            return null;
        }
        NodeList nodeList = element2.getChildNodes();
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 3) {
                return node.getNodeValue();
            }
            ++n2;
        }
        return null;
    }

    private static Element getChildElement(Element element, String string, String string2, int n) {
        NodeList nodeList = element.getElementsByTagNameNS(string, string2);
        if (nodeList.getLength() < n) {
            return null;
        }
        return (Element)nodeList.item(n - 1);
    }

    private static String evenStringLength(String string) {
        return string.length() % 2 != 0 ? "0" + string : string;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ECDSAKeyValueImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
    }

    public ECDSAKeyValueImpl(PublicKey publicKey) {
        super(publicKey);
        if (!(publicKey instanceof ECDSAPublicKey)) {
            throw new IllegalArgumentException("Argument 'ecdsaPublicKey' must be of type '" + (class$iaik$security$ecc$interfaces$ECDSAPublicKey != null ? class$iaik$security$ecc$interfaces$ECDSAPublicKey : (class$iaik$security$ecc$interfaces$ECDSAPublicKey = ECDSAKeyValueImpl.class$("iaik.security.ecc.interfaces.ECDSAPublicKey"))).getName() + "'.");
        }
    }
}

