// ------------------------------------------------------------------
// Copyright (c) 2004-2007 Atheros Corporation.  All rights reserved.
// 
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//
// ------------------------------------------------------------------
//===================================================================
// Author(s): ="Atheros"
//===================================================================


#ifndef _RTC_SOC_REG_REG_H_
#define _RTC_SOC_REG_REG_H_

#define SOC_RESET_CONTROL_ADDRESS                0x00000000
#define SOC_RESET_CONTROL_OFFSET                 0x00000000
#define SOC_RESET_CONTROL_SDIO2_RST_MSB          31
#define SOC_RESET_CONTROL_SDIO2_RST_LSB          31
#define SOC_RESET_CONTROL_SDIO2_RST_MASK         0x80000000
#define SOC_RESET_CONTROL_SDIO2_RST_GET(x)       (((x) & SOC_RESET_CONTROL_SDIO2_RST_MASK) >> SOC_RESET_CONTROL_SDIO2_RST_LSB)
#define SOC_RESET_CONTROL_SDIO2_RST_SET(x)       (((x) << SOC_RESET_CONTROL_SDIO2_RST_LSB) & SOC_RESET_CONTROL_SDIO2_RST_MASK)
#define SOC_RESET_CONTROL_SPI2_RST_MSB           30
#define SOC_RESET_CONTROL_SPI2_RST_LSB           30
#define SOC_RESET_CONTROL_SPI2_RST_MASK          0x40000000
#define SOC_RESET_CONTROL_SPI2_RST_GET(x)        (((x) & SOC_RESET_CONTROL_SPI2_RST_MASK) >> SOC_RESET_CONTROL_SPI2_RST_LSB)
#define SOC_RESET_CONTROL_SPI2_RST_SET(x)        (((x) << SOC_RESET_CONTROL_SPI2_RST_LSB) & SOC_RESET_CONTROL_SPI2_RST_MASK)
#define SOC_RESET_CONTROL_I2S_1_RST_MSB          29
#define SOC_RESET_CONTROL_I2S_1_RST_LSB          29
#define SOC_RESET_CONTROL_I2S_1_RST_MASK         0x20000000
#define SOC_RESET_CONTROL_I2S_1_RST_GET(x)       (((x) & SOC_RESET_CONTROL_I2S_1_RST_MASK) >> SOC_RESET_CONTROL_I2S_1_RST_LSB)
#define SOC_RESET_CONTROL_I2S_1_RST_SET(x)       (((x) << SOC_RESET_CONTROL_I2S_1_RST_LSB) & SOC_RESET_CONTROL_I2S_1_RST_MASK)
#define SOC_RESET_CONTROL_I2S_1_MBOX_RST_MSB     28
#define SOC_RESET_CONTROL_I2S_1_MBOX_RST_LSB     28
#define SOC_RESET_CONTROL_I2S_1_MBOX_RST_MASK    0x10000000
#define SOC_RESET_CONTROL_I2S_1_MBOX_RST_GET(x)  (((x) & SOC_RESET_CONTROL_I2S_1_MBOX_RST_MASK) >> SOC_RESET_CONTROL_I2S_1_MBOX_RST_LSB)
#define SOC_RESET_CONTROL_I2S_1_MBOX_RST_SET(x)  (((x) << SOC_RESET_CONTROL_I2S_1_MBOX_RST_LSB) & SOC_RESET_CONTROL_I2S_1_MBOX_RST_MASK)
#define SOC_RESET_CONTROL_I2C_SLAVE_RST_MSB      27
#define SOC_RESET_CONTROL_I2C_SLAVE_RST_LSB      27
#define SOC_RESET_CONTROL_I2C_SLAVE_RST_MASK     0x08000000
#define SOC_RESET_CONTROL_I2C_SLAVE_RST_GET(x)   (((x) & SOC_RESET_CONTROL_I2C_SLAVE_RST_MASK) >> SOC_RESET_CONTROL_I2C_SLAVE_RST_LSB)
#define SOC_RESET_CONTROL_I2C_SLAVE_RST_SET(x)   (((x) << SOC_RESET_CONTROL_I2C_SLAVE_RST_LSB) & SOC_RESET_CONTROL_I2C_SLAVE_RST_MASK)
#define SOC_RESET_CONTROL_USB_PHY_ARST_MSB       26
#define SOC_RESET_CONTROL_USB_PHY_ARST_LSB       26
#define SOC_RESET_CONTROL_USB_PHY_ARST_MASK      0x04000000
#define SOC_RESET_CONTROL_USB_PHY_ARST_GET(x)    (((x) & SOC_RESET_CONTROL_USB_PHY_ARST_MASK) >> SOC_RESET_CONTROL_USB_PHY_ARST_LSB)
#define SOC_RESET_CONTROL_USB_PHY_ARST_SET(x)    (((x) << SOC_RESET_CONTROL_USB_PHY_ARST_LSB) & SOC_RESET_CONTROL_USB_PHY_ARST_MASK)
#define SOC_RESET_CONTROL_USB_PHY_RST_MSB        25
#define SOC_RESET_CONTROL_USB_PHY_RST_LSB        25
#define SOC_RESET_CONTROL_USB_PHY_RST_MASK       0x02000000
#define SOC_RESET_CONTROL_USB_PHY_RST_GET(x)     (((x) & SOC_RESET_CONTROL_USB_PHY_RST_MASK) >> SOC_RESET_CONTROL_USB_PHY_RST_LSB)
#define SOC_RESET_CONTROL_USB_PHY_RST_SET(x)     (((x) << SOC_RESET_CONTROL_USB_PHY_RST_LSB) & SOC_RESET_CONTROL_USB_PHY_RST_MASK)
#define SOC_RESET_CONTROL_USB_RST_MSB            24
#define SOC_RESET_CONTROL_USB_RST_LSB            24
#define SOC_RESET_CONTROL_USB_RST_MASK           0x01000000
#define SOC_RESET_CONTROL_USB_RST_GET(x)         (((x) & SOC_RESET_CONTROL_USB_RST_MASK) >> SOC_RESET_CONTROL_USB_RST_LSB)
#define SOC_RESET_CONTROL_USB_RST_SET(x)         (((x) << SOC_RESET_CONTROL_USB_RST_LSB) & SOC_RESET_CONTROL_USB_RST_MASK)
#define SOC_RESET_CONTROL_MMAC_RST_MSB           23
#define SOC_RESET_CONTROL_MMAC_RST_LSB           23
#define SOC_RESET_CONTROL_MMAC_RST_MASK          0x00800000
#define SOC_RESET_CONTROL_MMAC_RST_GET(x)        (((x) & SOC_RESET_CONTROL_MMAC_RST_MASK) >> SOC_RESET_CONTROL_MMAC_RST_LSB)
#define SOC_RESET_CONTROL_MMAC_RST_SET(x)        (((x) << SOC_RESET_CONTROL_MMAC_RST_LSB) & SOC_RESET_CONTROL_MMAC_RST_MASK)
#define SOC_RESET_CONTROL_MDIO_RST_MSB           22
#define SOC_RESET_CONTROL_MDIO_RST_LSB           22
#define SOC_RESET_CONTROL_MDIO_RST_MASK          0x00400000
#define SOC_RESET_CONTROL_MDIO_RST_GET(x)        (((x) & SOC_RESET_CONTROL_MDIO_RST_MASK) >> SOC_RESET_CONTROL_MDIO_RST_LSB)
#define SOC_RESET_CONTROL_MDIO_RST_SET(x)        (((x) << SOC_RESET_CONTROL_MDIO_RST_LSB) & SOC_RESET_CONTROL_MDIO_RST_MASK)
#define SOC_RESET_CONTROL_GE0_RST_MSB            21
#define SOC_RESET_CONTROL_GE0_RST_LSB            21
#define SOC_RESET_CONTROL_GE0_RST_MASK           0x00200000
#define SOC_RESET_CONTROL_GE0_RST_GET(x)         (((x) & SOC_RESET_CONTROL_GE0_RST_MASK) >> SOC_RESET_CONTROL_GE0_RST_LSB)
#define SOC_RESET_CONTROL_GE0_RST_SET(x)         (((x) << SOC_RESET_CONTROL_GE0_RST_LSB) & SOC_RESET_CONTROL_GE0_RST_MASK)
#define SOC_RESET_CONTROL_I2S_RST_MSB            20
#define SOC_RESET_CONTROL_I2S_RST_LSB            20
#define SOC_RESET_CONTROL_I2S_RST_MASK           0x00100000
#define SOC_RESET_CONTROL_I2S_RST_GET(x)         (((x) & SOC_RESET_CONTROL_I2S_RST_MASK) >> SOC_RESET_CONTROL_I2S_RST_LSB)
#define SOC_RESET_CONTROL_I2S_RST_SET(x)         (((x) << SOC_RESET_CONTROL_I2S_RST_LSB) & SOC_RESET_CONTROL_I2S_RST_MASK)
#define SOC_RESET_CONTROL_I2S_MBOX_RST_MSB       19
#define SOC_RESET_CONTROL_I2S_MBOX_RST_LSB       19
#define SOC_RESET_CONTROL_I2S_MBOX_RST_MASK      0x00080000
#define SOC_RESET_CONTROL_I2S_MBOX_RST_GET(x)    (((x) & SOC_RESET_CONTROL_I2S_MBOX_RST_MASK) >> SOC_RESET_CONTROL_I2S_MBOX_RST_LSB)
#define SOC_RESET_CONTROL_I2S_MBOX_RST_SET(x)    (((x) << SOC_RESET_CONTROL_I2S_MBOX_RST_LSB) & SOC_RESET_CONTROL_I2S_MBOX_RST_MASK)
#define SOC_RESET_CONTROL_CHECKSUM_ACC_RST_MSB   18
#define SOC_RESET_CONTROL_CHECKSUM_ACC_RST_LSB   18
#define SOC_RESET_CONTROL_CHECKSUM_ACC_RST_MASK  0x00040000
#define SOC_RESET_CONTROL_CHECKSUM_ACC_RST_GET(x) (((x) & SOC_RESET_CONTROL_CHECKSUM_ACC_RST_MASK) >> SOC_RESET_CONTROL_CHECKSUM_ACC_RST_LSB)
#define SOC_RESET_CONTROL_CHECKSUM_ACC_RST_SET(x) (((x) << SOC_RESET_CONTROL_CHECKSUM_ACC_RST_LSB) & SOC_RESET_CONTROL_CHECKSUM_ACC_RST_MASK)
#define SOC_RESET_CONTROL_UART2_RST_MSB          17
#define SOC_RESET_CONTROL_UART2_RST_LSB          17
#define SOC_RESET_CONTROL_UART2_RST_MASK         0x00020000
#define SOC_RESET_CONTROL_UART2_RST_GET(x)       (((x) & SOC_RESET_CONTROL_UART2_RST_MASK) >> SOC_RESET_CONTROL_UART2_RST_LSB)
#define SOC_RESET_CONTROL_UART2_RST_SET(x)       (((x) << SOC_RESET_CONTROL_UART2_RST_LSB) & SOC_RESET_CONTROL_UART2_RST_MASK)
#define SOC_RESET_CONTROL_DEBUG_UART_RST_MSB     16
#define SOC_RESET_CONTROL_DEBUG_UART_RST_LSB     16
#define SOC_RESET_CONTROL_DEBUG_UART_RST_MASK    0x00010000
#define SOC_RESET_CONTROL_DEBUG_UART_RST_GET(x)  (((x) & SOC_RESET_CONTROL_DEBUG_UART_RST_MASK) >> SOC_RESET_CONTROL_DEBUG_UART_RST_LSB)
#define SOC_RESET_CONTROL_DEBUG_UART_RST_SET(x)  (((x) << SOC_RESET_CONTROL_DEBUG_UART_RST_LSB) & SOC_RESET_CONTROL_DEBUG_UART_RST_MASK)
#define SOC_RESET_CONTROL_MIT_REG_MAPPING_RST_MSB 13
#define SOC_RESET_CONTROL_MIT_REG_MAPPING_RST_LSB 13
#define SOC_RESET_CONTROL_MIT_REG_MAPPING_RST_MASK 0x00002000
#define SOC_RESET_CONTROL_MIT_REG_MAPPING_RST_GET(x) (((x) & SOC_RESET_CONTROL_MIT_REG_MAPPING_RST_MASK) >> SOC_RESET_CONTROL_MIT_REG_MAPPING_RST_LSB)
#define SOC_RESET_CONTROL_MIT_REG_MAPPING_RST_SET(x) (((x) << SOC_RESET_CONTROL_MIT_REG_MAPPING_RST_LSB) & SOC_RESET_CONTROL_MIT_REG_MAPPING_RST_MASK)
#define SOC_RESET_CONTROL_MIT_ADAPTOR_RST_MSB    12
#define SOC_RESET_CONTROL_MIT_ADAPTOR_RST_LSB    12
#define SOC_RESET_CONTROL_MIT_ADAPTOR_RST_MASK   0x00001000
#define SOC_RESET_CONTROL_MIT_ADAPTOR_RST_GET(x) (((x) & SOC_RESET_CONTROL_MIT_ADAPTOR_RST_MASK) >> SOC_RESET_CONTROL_MIT_ADAPTOR_RST_LSB)
#define SOC_RESET_CONTROL_MIT_ADAPTOR_RST_SET(x) (((x) << SOC_RESET_CONTROL_MIT_ADAPTOR_RST_LSB) & SOC_RESET_CONTROL_MIT_ADAPTOR_RST_MASK)
#define SOC_RESET_CONTROL_CPU_INIT_RESET_MSB     11
#define SOC_RESET_CONTROL_CPU_INIT_RESET_LSB     11
#define SOC_RESET_CONTROL_CPU_INIT_RESET_MASK    0x00000800
#define SOC_RESET_CONTROL_CPU_INIT_RESET_GET(x)  (((x) & SOC_RESET_CONTROL_CPU_INIT_RESET_MASK) >> SOC_RESET_CONTROL_CPU_INIT_RESET_LSB)
#define SOC_RESET_CONTROL_CPU_INIT_RESET_SET(x)  (((x) << SOC_RESET_CONTROL_CPU_INIT_RESET_LSB) & SOC_RESET_CONTROL_CPU_INIT_RESET_MASK)
#define SOC_RESET_CONTROL_RST_OUT_MSB            9
#define SOC_RESET_CONTROL_RST_OUT_LSB            9
#define SOC_RESET_CONTROL_RST_OUT_MASK           0x00000200
#define SOC_RESET_CONTROL_RST_OUT_GET(x)         (((x) & SOC_RESET_CONTROL_RST_OUT_MASK) >> SOC_RESET_CONTROL_RST_OUT_LSB)
#define SOC_RESET_CONTROL_RST_OUT_SET(x)         (((x) << SOC_RESET_CONTROL_RST_OUT_LSB) & SOC_RESET_CONTROL_RST_OUT_MASK)
#define SOC_RESET_CONTROL_COLD_RST_MSB           8
#define SOC_RESET_CONTROL_COLD_RST_LSB           8
#define SOC_RESET_CONTROL_COLD_RST_MASK          0x00000100
#define SOC_RESET_CONTROL_COLD_RST_GET(x)        (((x) & SOC_RESET_CONTROL_COLD_RST_MASK) >> SOC_RESET_CONTROL_COLD_RST_LSB)
#define SOC_RESET_CONTROL_COLD_RST_SET(x)        (((x) << SOC_RESET_CONTROL_COLD_RST_LSB) & SOC_RESET_CONTROL_COLD_RST_MASK)
#define SOC_RESET_CONTROL_CPU_WARM_RST_MSB       6
#define SOC_RESET_CONTROL_CPU_WARM_RST_LSB       6
#define SOC_RESET_CONTROL_CPU_WARM_RST_MASK      0x00000040
#define SOC_RESET_CONTROL_CPU_WARM_RST_GET(x)    (((x) & SOC_RESET_CONTROL_CPU_WARM_RST_MASK) >> SOC_RESET_CONTROL_CPU_WARM_RST_LSB)
#define SOC_RESET_CONTROL_CPU_WARM_RST_SET(x)    (((x) << SOC_RESET_CONTROL_CPU_WARM_RST_LSB) & SOC_RESET_CONTROL_CPU_WARM_RST_MASK)
#define SOC_RESET_CONTROL_MBOX_RST_MSB           2
#define SOC_RESET_CONTROL_MBOX_RST_LSB           2
#define SOC_RESET_CONTROL_MBOX_RST_MASK          0x00000004
#define SOC_RESET_CONTROL_MBOX_RST_GET(x)        (((x) & SOC_RESET_CONTROL_MBOX_RST_MASK) >> SOC_RESET_CONTROL_MBOX_RST_LSB)
#define SOC_RESET_CONTROL_MBOX_RST_SET(x)        (((x) << SOC_RESET_CONTROL_MBOX_RST_LSB) & SOC_RESET_CONTROL_MBOX_RST_MASK)
#define SOC_RESET_CONTROL_UART_RST_MSB           1
#define SOC_RESET_CONTROL_UART_RST_LSB           1
#define SOC_RESET_CONTROL_UART_RST_MASK          0x00000002
#define SOC_RESET_CONTROL_UART_RST_GET(x)        (((x) & SOC_RESET_CONTROL_UART_RST_MASK) >> SOC_RESET_CONTROL_UART_RST_LSB)
#define SOC_RESET_CONTROL_UART_RST_SET(x)        (((x) << SOC_RESET_CONTROL_UART_RST_LSB) & SOC_RESET_CONTROL_UART_RST_MASK)
#define SOC_RESET_CONTROL_SI0_RST_MSB            0
#define SOC_RESET_CONTROL_SI0_RST_LSB            0
#define SOC_RESET_CONTROL_SI0_RST_MASK           0x00000001
#define SOC_RESET_CONTROL_SI0_RST_GET(x)         (((x) & SOC_RESET_CONTROL_SI0_RST_MASK) >> SOC_RESET_CONTROL_SI0_RST_LSB)
#define SOC_RESET_CONTROL_SI0_RST_SET(x)         (((x) << SOC_RESET_CONTROL_SI0_RST_LSB) & SOC_RESET_CONTROL_SI0_RST_MASK)

#define SOC_TCXO_DETECT_ADDRESS                  0x00000004
#define SOC_TCXO_DETECT_OFFSET                   0x00000004
#define SOC_TCXO_DETECT_PRESENT_MSB              0
#define SOC_TCXO_DETECT_PRESENT_LSB              0
#define SOC_TCXO_DETECT_PRESENT_MASK             0x00000001
#define SOC_TCXO_DETECT_PRESENT_GET(x)           (((x) & SOC_TCXO_DETECT_PRESENT_MASK) >> SOC_TCXO_DETECT_PRESENT_LSB)
#define SOC_TCXO_DETECT_PRESENT_SET(x)           (((x) << SOC_TCXO_DETECT_PRESENT_LSB) & SOC_TCXO_DETECT_PRESENT_MASK)

#define SOC_XTAL_TEST_ADDRESS                    0x00000008
#define SOC_XTAL_TEST_OFFSET                     0x00000008
#define SOC_XTAL_TEST_NOTCXODET_MSB              0
#define SOC_XTAL_TEST_NOTCXODET_LSB              0
#define SOC_XTAL_TEST_NOTCXODET_MASK             0x00000001
#define SOC_XTAL_TEST_NOTCXODET_GET(x)           (((x) & SOC_XTAL_TEST_NOTCXODET_MASK) >> SOC_XTAL_TEST_NOTCXODET_LSB)
#define SOC_XTAL_TEST_NOTCXODET_SET(x)           (((x) << SOC_XTAL_TEST_NOTCXODET_LSB) & SOC_XTAL_TEST_NOTCXODET_MASK)

#define SOC_CPU_CLOCK_ADDRESS                    0x00000020
#define SOC_CPU_CLOCK_OFFSET                     0x00000020
#define SOC_CPU_CLOCK_STANDARD_MSB               1
#define SOC_CPU_CLOCK_STANDARD_LSB               0
#define SOC_CPU_CLOCK_STANDARD_MASK              0x00000003
#define SOC_CPU_CLOCK_STANDARD_GET(x)            (((x) & SOC_CPU_CLOCK_STANDARD_MASK) >> SOC_CPU_CLOCK_STANDARD_LSB)
#define SOC_CPU_CLOCK_STANDARD_SET(x)            (((x) << SOC_CPU_CLOCK_STANDARD_LSB) & SOC_CPU_CLOCK_STANDARD_MASK)

#define SOC_CLOCK_CONTROL_ADDRESS                0x00000028
#define SOC_CLOCK_CONTROL_OFFSET                 0x00000028
#define SOC_CLOCK_CONTROL_LF_CLK32_MSB           2
#define SOC_CLOCK_CONTROL_LF_CLK32_LSB           2
#define SOC_CLOCK_CONTROL_LF_CLK32_MASK          0x00000004
#define SOC_CLOCK_CONTROL_LF_CLK32_GET(x)        (((x) & SOC_CLOCK_CONTROL_LF_CLK32_MASK) >> SOC_CLOCK_CONTROL_LF_CLK32_LSB)
#define SOC_CLOCK_CONTROL_LF_CLK32_SET(x)        (((x) << SOC_CLOCK_CONTROL_LF_CLK32_LSB) & SOC_CLOCK_CONTROL_LF_CLK32_MASK)
#define SOC_CLOCK_CONTROL_SI0_CLK_MSB            0
#define SOC_CLOCK_CONTROL_SI0_CLK_LSB            0
#define SOC_CLOCK_CONTROL_SI0_CLK_MASK           0x00000001
#define SOC_CLOCK_CONTROL_SI0_CLK_GET(x)         (((x) & SOC_CLOCK_CONTROL_SI0_CLK_MASK) >> SOC_CLOCK_CONTROL_SI0_CLK_LSB)
#define SOC_CLOCK_CONTROL_SI0_CLK_SET(x)         (((x) << SOC_CLOCK_CONTROL_SI0_CLK_LSB) & SOC_CLOCK_CONTROL_SI0_CLK_MASK)

#define SOC_WDT_CONTROL_ADDRESS                  0x00000030
#define SOC_WDT_CONTROL_OFFSET                   0x00000030
#define SOC_WDT_CONTROL_ACTION_MSB               2
#define SOC_WDT_CONTROL_ACTION_LSB               0
#define SOC_WDT_CONTROL_ACTION_MASK              0x00000007
#define SOC_WDT_CONTROL_ACTION_GET(x)            (((x) & SOC_WDT_CONTROL_ACTION_MASK) >> SOC_WDT_CONTROL_ACTION_LSB)
#define SOC_WDT_CONTROL_ACTION_SET(x)            (((x) << SOC_WDT_CONTROL_ACTION_LSB) & SOC_WDT_CONTROL_ACTION_MASK)

#define SOC_WDT_STATUS_ADDRESS                   0x00000034
#define SOC_WDT_STATUS_OFFSET                    0x00000034
#define SOC_WDT_STATUS_INTERRUPT_MSB             0
#define SOC_WDT_STATUS_INTERRUPT_LSB             0
#define SOC_WDT_STATUS_INTERRUPT_MASK            0x00000001
#define SOC_WDT_STATUS_INTERRUPT_GET(x)          (((x) & SOC_WDT_STATUS_INTERRUPT_MASK) >> SOC_WDT_STATUS_INTERRUPT_LSB)
#define SOC_WDT_STATUS_INTERRUPT_SET(x)          (((x) << SOC_WDT_STATUS_INTERRUPT_LSB) & SOC_WDT_STATUS_INTERRUPT_MASK)

#define SOC_WDT_ADDRESS                          0x00000038
#define SOC_WDT_OFFSET                           0x00000038
#define SOC_WDT_TARGET_MSB                       21
#define SOC_WDT_TARGET_LSB                       0
#define SOC_WDT_TARGET_MASK                      0x003fffff
#define SOC_WDT_TARGET_GET(x)                    (((x) & SOC_WDT_TARGET_MASK) >> SOC_WDT_TARGET_LSB)
#define SOC_WDT_TARGET_SET(x)                    (((x) << SOC_WDT_TARGET_LSB) & SOC_WDT_TARGET_MASK)

#define SOC_WDT_COUNT_ADDRESS                    0x0000003c
#define SOC_WDT_COUNT_OFFSET                     0x0000003c
#define SOC_WDT_COUNT_VALUE_MSB                  21
#define SOC_WDT_COUNT_VALUE_LSB                  0
#define SOC_WDT_COUNT_VALUE_MASK                 0x003fffff
#define SOC_WDT_COUNT_VALUE_GET(x)               (((x) & SOC_WDT_COUNT_VALUE_MASK) >> SOC_WDT_COUNT_VALUE_LSB)
#define SOC_WDT_COUNT_VALUE_SET(x)               (((x) << SOC_WDT_COUNT_VALUE_LSB) & SOC_WDT_COUNT_VALUE_MASK)

#define SOC_WDT_RESET_ADDRESS                    0x00000040
#define SOC_WDT_RESET_OFFSET                     0x00000040
#define SOC_WDT_RESET_VALUE_MSB                  0
#define SOC_WDT_RESET_VALUE_LSB                  0
#define SOC_WDT_RESET_VALUE_MASK                 0x00000001
#define SOC_WDT_RESET_VALUE_GET(x)               (((x) & SOC_WDT_RESET_VALUE_MASK) >> SOC_WDT_RESET_VALUE_LSB)
#define SOC_WDT_RESET_VALUE_SET(x)               (((x) << SOC_WDT_RESET_VALUE_LSB) & SOC_WDT_RESET_VALUE_MASK)

#define SOC_INT_STATUS_ADDRESS                   0x00000044
#define SOC_INT_STATUS_OFFSET                    0x00000044
#define SOC_INT_STATUS_STE_MBOX_MSB              31
#define SOC_INT_STATUS_STE_MBOX_LSB              31
#define SOC_INT_STATUS_STE_MBOX_MASK             0x80000000
#define SOC_INT_STATUS_STE_MBOX_GET(x)           (((x) & SOC_INT_STATUS_STE_MBOX_MASK) >> SOC_INT_STATUS_STE_MBOX_LSB)
#define SOC_INT_STATUS_STE_MBOX_SET(x)           (((x) << SOC_INT_STATUS_STE_MBOX_LSB) & SOC_INT_STATUS_STE_MBOX_MASK)
#define SOC_INT_STATUS_SDIO2_MBOX_MSB            30
#define SOC_INT_STATUS_SDIO2_MBOX_LSB            30
#define SOC_INT_STATUS_SDIO2_MBOX_MASK           0x40000000
#define SOC_INT_STATUS_SDIO2_MBOX_GET(x)         (((x) & SOC_INT_STATUS_SDIO2_MBOX_MASK) >> SOC_INT_STATUS_SDIO2_MBOX_LSB)
#define SOC_INT_STATUS_SDIO2_MBOX_SET(x)         (((x) << SOC_INT_STATUS_SDIO2_MBOX_LSB) & SOC_INT_STATUS_SDIO2_MBOX_MASK)
#define SOC_INT_STATUS_USBDMA_MSB                29
#define SOC_INT_STATUS_USBDMA_LSB                29
#define SOC_INT_STATUS_USBDMA_MASK               0x20000000
#define SOC_INT_STATUS_USBDMA_GET(x)             (((x) & SOC_INT_STATUS_USBDMA_MASK) >> SOC_INT_STATUS_USBDMA_LSB)
#define SOC_INT_STATUS_USBDMA_SET(x)             (((x) << SOC_INT_STATUS_USBDMA_LSB) & SOC_INT_STATUS_USBDMA_MASK)
#define SOC_INT_STATUS_USBIP_MSB                 28
#define SOC_INT_STATUS_USBIP_LSB                 28
#define SOC_INT_STATUS_USBIP_MASK                0x10000000
#define SOC_INT_STATUS_USBIP_GET(x)              (((x) & SOC_INT_STATUS_USBIP_MASK) >> SOC_INT_STATUS_USBIP_LSB)
#define SOC_INT_STATUS_USBIP_SET(x)              (((x) << SOC_INT_STATUS_USBIP_LSB) & SOC_INT_STATUS_USBIP_MASK)
#define SOC_INT_STATUS_MMAC_MSB                  27
#define SOC_INT_STATUS_MMAC_LSB                  27
#define SOC_INT_STATUS_MMAC_MASK                 0x08000000
#define SOC_INT_STATUS_MMAC_GET(x)               (((x) & SOC_INT_STATUS_MMAC_MASK) >> SOC_INT_STATUS_MMAC_LSB)
#define SOC_INT_STATUS_MMAC_SET(x)               (((x) << SOC_INT_STATUS_MMAC_LSB) & SOC_INT_STATUS_MMAC_MASK)
#define SOC_INT_STATUS_MIT_REG_ACCESS_MSB        26
#define SOC_INT_STATUS_MIT_REG_ACCESS_LSB        26
#define SOC_INT_STATUS_MIT_REG_ACCESS_MASK       0x04000000
#define SOC_INT_STATUS_MIT_REG_ACCESS_GET(x)     (((x) & SOC_INT_STATUS_MIT_REG_ACCESS_MASK) >> SOC_INT_STATUS_MIT_REG_ACCESS_LSB)
#define SOC_INT_STATUS_MIT_REG_ACCESS_SET(x)     (((x) << SOC_INT_STATUS_MIT_REG_ACCESS_LSB) & SOC_INT_STATUS_MIT_REG_ACCESS_MASK)
#define SOC_INT_STATUS_FLIGHT_MODE_MSB           25
#define SOC_INT_STATUS_FLIGHT_MODE_LSB           25
#define SOC_INT_STATUS_FLIGHT_MODE_MASK          0x02000000
#define SOC_INT_STATUS_FLIGHT_MODE_GET(x)        (((x) & SOC_INT_STATUS_FLIGHT_MODE_MASK) >> SOC_INT_STATUS_FLIGHT_MODE_LSB)
#define SOC_INT_STATUS_FLIGHT_MODE_SET(x)        (((x) << SOC_INT_STATUS_FLIGHT_MODE_LSB) & SOC_INT_STATUS_FLIGHT_MODE_MASK)
#define SOC_INT_STATUS_BBP_SLEEP_RISING_MSB      24
#define SOC_INT_STATUS_BBP_SLEEP_RISING_LSB      24
#define SOC_INT_STATUS_BBP_SLEEP_RISING_MASK     0x01000000
#define SOC_INT_STATUS_BBP_SLEEP_RISING_GET(x)   (((x) & SOC_INT_STATUS_BBP_SLEEP_RISING_MASK) >> SOC_INT_STATUS_BBP_SLEEP_RISING_LSB)
#define SOC_INT_STATUS_BBP_SLEEP_RISING_SET(x)   (((x) << SOC_INT_STATUS_BBP_SLEEP_RISING_LSB) & SOC_INT_STATUS_BBP_SLEEP_RISING_MASK)
#define SOC_INT_STATUS_RF_SLEEP_RISING_MSB       23
#define SOC_INT_STATUS_RF_SLEEP_RISING_LSB       23
#define SOC_INT_STATUS_RF_SLEEP_RISING_MASK      0x00800000
#define SOC_INT_STATUS_RF_SLEEP_RISING_GET(x)    (((x) & SOC_INT_STATUS_RF_SLEEP_RISING_MASK) >> SOC_INT_STATUS_RF_SLEEP_RISING_LSB)
#define SOC_INT_STATUS_RF_SLEEP_RISING_SET(x)    (((x) << SOC_INT_STATUS_RF_SLEEP_RISING_LSB) & SOC_INT_STATUS_RF_SLEEP_RISING_MASK)
#define SOC_INT_STATUS_MODE_SWITCH_MSB           22
#define SOC_INT_STATUS_MODE_SWITCH_LSB           22
#define SOC_INT_STATUS_MODE_SWITCH_MASK          0x00400000
#define SOC_INT_STATUS_MODE_SWITCH_GET(x)        (((x) & SOC_INT_STATUS_MODE_SWITCH_MASK) >> SOC_INT_STATUS_MODE_SWITCH_LSB)
#define SOC_INT_STATUS_MODE_SWITCH_SET(x)        (((x) << SOC_INT_STATUS_MODE_SWITCH_LSB) & SOC_INT_STATUS_MODE_SWITCH_MASK)
#define SOC_INT_STATUS_HCI_UART_MSB              21
#define SOC_INT_STATUS_HCI_UART_LSB              21
#define SOC_INT_STATUS_HCI_UART_MASK             0x00200000
#define SOC_INT_STATUS_HCI_UART_GET(x)           (((x) & SOC_INT_STATUS_HCI_UART_MASK) >> SOC_INT_STATUS_HCI_UART_LSB)
#define SOC_INT_STATUS_HCI_UART_SET(x)           (((x) << SOC_INT_STATUS_HCI_UART_LSB) & SOC_INT_STATUS_HCI_UART_MASK)
#define SOC_INT_STATUS_THERM_MSB                 20
#define SOC_INT_STATUS_THERM_LSB                 20
#define SOC_INT_STATUS_THERM_MASK                0x00100000
#define SOC_INT_STATUS_THERM_GET(x)              (((x) & SOC_INT_STATUS_THERM_MASK) >> SOC_INT_STATUS_THERM_LSB)
#define SOC_INT_STATUS_THERM_SET(x)              (((x) << SOC_INT_STATUS_THERM_LSB) & SOC_INT_STATUS_THERM_MASK)
#define SOC_INT_STATUS_EFUSE_OVERWRITE_MSB       19
#define SOC_INT_STATUS_EFUSE_OVERWRITE_LSB       19
#define SOC_INT_STATUS_EFUSE_OVERWRITE_MASK      0x00080000
#define SOC_INT_STATUS_EFUSE_OVERWRITE_GET(x)    (((x) & SOC_INT_STATUS_EFUSE_OVERWRITE_MASK) >> SOC_INT_STATUS_EFUSE_OVERWRITE_LSB)
#define SOC_INT_STATUS_EFUSE_OVERWRITE_SET(x)    (((x) << SOC_INT_STATUS_EFUSE_OVERWRITE_LSB) & SOC_INT_STATUS_EFUSE_OVERWRITE_MASK)
#define SOC_INT_STATUS_UART_MBOX_MSB             18
#define SOC_INT_STATUS_UART_MBOX_LSB             18
#define SOC_INT_STATUS_UART_MBOX_MASK            0x00040000
#define SOC_INT_STATUS_UART_MBOX_GET(x)          (((x) & SOC_INT_STATUS_UART_MBOX_MASK) >> SOC_INT_STATUS_UART_MBOX_LSB)
#define SOC_INT_STATUS_UART_MBOX_SET(x)          (((x) << SOC_INT_STATUS_UART_MBOX_LSB) & SOC_INT_STATUS_UART_MBOX_MASK)
#define SOC_INT_STATUS_GENERIC_MBOX_MSB          17
#define SOC_INT_STATUS_GENERIC_MBOX_LSB          17
#define SOC_INT_STATUS_GENERIC_MBOX_MASK         0x00020000
#define SOC_INT_STATUS_GENERIC_MBOX_GET(x)       (((x) & SOC_INT_STATUS_GENERIC_MBOX_MASK) >> SOC_INT_STATUS_GENERIC_MBOX_LSB)
#define SOC_INT_STATUS_GENERIC_MBOX_SET(x)       (((x) << SOC_INT_STATUS_GENERIC_MBOX_LSB) & SOC_INT_STATUS_GENERIC_MBOX_MASK)
#define SOC_INT_STATUS_RDMA_MSB                  16
#define SOC_INT_STATUS_RDMA_LSB                  16
#define SOC_INT_STATUS_RDMA_MASK                 0x00010000
#define SOC_INT_STATUS_RDMA_GET(x)               (((x) & SOC_INT_STATUS_RDMA_MASK) >> SOC_INT_STATUS_RDMA_LSB)
#define SOC_INT_STATUS_RDMA_SET(x)               (((x) << SOC_INT_STATUS_RDMA_LSB) & SOC_INT_STATUS_RDMA_MASK)
#define SOC_INT_STATUS_BTCOEX_MSB                15
#define SOC_INT_STATUS_BTCOEX_LSB                15
#define SOC_INT_STATUS_BTCOEX_MASK               0x00008000
#define SOC_INT_STATUS_BTCOEX_GET(x)             (((x) & SOC_INT_STATUS_BTCOEX_MASK) >> SOC_INT_STATUS_BTCOEX_LSB)
#define SOC_INT_STATUS_BTCOEX_SET(x)             (((x) << SOC_INT_STATUS_BTCOEX_LSB) & SOC_INT_STATUS_BTCOEX_MASK)
#define SOC_INT_STATUS_RTC_POWER_MSB             14
#define SOC_INT_STATUS_RTC_POWER_LSB             14
#define SOC_INT_STATUS_RTC_POWER_MASK            0x00004000
#define SOC_INT_STATUS_RTC_POWER_GET(x)          (((x) & SOC_INT_STATUS_RTC_POWER_MASK) >> SOC_INT_STATUS_RTC_POWER_LSB)
#define SOC_INT_STATUS_RTC_POWER_SET(x)          (((x) << SOC_INT_STATUS_RTC_POWER_LSB) & SOC_INT_STATUS_RTC_POWER_MASK)
#define SOC_INT_STATUS_MAC_MSB                   13
#define SOC_INT_STATUS_MAC_LSB                   13
#define SOC_INT_STATUS_MAC_MASK                  0x00002000
#define SOC_INT_STATUS_MAC_GET(x)                (((x) & SOC_INT_STATUS_MAC_MASK) >> SOC_INT_STATUS_MAC_LSB)
#define SOC_INT_STATUS_MAC_SET(x)                (((x) << SOC_INT_STATUS_MAC_LSB) & SOC_INT_STATUS_MAC_MASK)
#define SOC_INT_STATUS_MAILBOX_MSB               12
#define SOC_INT_STATUS_MAILBOX_LSB               12
#define SOC_INT_STATUS_MAILBOX_MASK              0x00001000
#define SOC_INT_STATUS_MAILBOX_GET(x)            (((x) & SOC_INT_STATUS_MAILBOX_MASK) >> SOC_INT_STATUS_MAILBOX_LSB)
#define SOC_INT_STATUS_MAILBOX_SET(x)            (((x) << SOC_INT_STATUS_MAILBOX_LSB) & SOC_INT_STATUS_MAILBOX_MASK)
#define SOC_INT_STATUS_RTC_ALARM_MSB             11
#define SOC_INT_STATUS_RTC_ALARM_LSB             11
#define SOC_INT_STATUS_RTC_ALARM_MASK            0x00000800
#define SOC_INT_STATUS_RTC_ALARM_GET(x)          (((x) & SOC_INT_STATUS_RTC_ALARM_MASK) >> SOC_INT_STATUS_RTC_ALARM_LSB)
#define SOC_INT_STATUS_RTC_ALARM_SET(x)          (((x) << SOC_INT_STATUS_RTC_ALARM_LSB) & SOC_INT_STATUS_RTC_ALARM_MASK)
#define SOC_INT_STATUS_HF_TIMER_MSB              10
#define SOC_INT_STATUS_HF_TIMER_LSB              10
#define SOC_INT_STATUS_HF_TIMER_MASK             0x00000400
#define SOC_INT_STATUS_HF_TIMER_GET(x)           (((x) & SOC_INT_STATUS_HF_TIMER_MASK) >> SOC_INT_STATUS_HF_TIMER_LSB)
#define SOC_INT_STATUS_HF_TIMER_SET(x)           (((x) << SOC_INT_STATUS_HF_TIMER_LSB) & SOC_INT_STATUS_HF_TIMER_MASK)
#define SOC_INT_STATUS_LF_TIMER3_MSB             9
#define SOC_INT_STATUS_LF_TIMER3_LSB             9
#define SOC_INT_STATUS_LF_TIMER3_MASK            0x00000200
#define SOC_INT_STATUS_LF_TIMER3_GET(x)          (((x) & SOC_INT_STATUS_LF_TIMER3_MASK) >> SOC_INT_STATUS_LF_TIMER3_LSB)
#define SOC_INT_STATUS_LF_TIMER3_SET(x)          (((x) << SOC_INT_STATUS_LF_TIMER3_LSB) & SOC_INT_STATUS_LF_TIMER3_MASK)
#define SOC_INT_STATUS_LF_TIMER2_MSB             8
#define SOC_INT_STATUS_LF_TIMER2_LSB             8
#define SOC_INT_STATUS_LF_TIMER2_MASK            0x00000100
#define SOC_INT_STATUS_LF_TIMER2_GET(x)          (((x) & SOC_INT_STATUS_LF_TIMER2_MASK) >> SOC_INT_STATUS_LF_TIMER2_LSB)
#define SOC_INT_STATUS_LF_TIMER2_SET(x)          (((x) << SOC_INT_STATUS_LF_TIMER2_LSB) & SOC_INT_STATUS_LF_TIMER2_MASK)
#define SOC_INT_STATUS_LF_TIMER1_MSB             7
#define SOC_INT_STATUS_LF_TIMER1_LSB             7
#define SOC_INT_STATUS_LF_TIMER1_MASK            0x00000080
#define SOC_INT_STATUS_LF_TIMER1_GET(x)          (((x) & SOC_INT_STATUS_LF_TIMER1_MASK) >> SOC_INT_STATUS_LF_TIMER1_LSB)
#define SOC_INT_STATUS_LF_TIMER1_SET(x)          (((x) << SOC_INT_STATUS_LF_TIMER1_LSB) & SOC_INT_STATUS_LF_TIMER1_MASK)
#define SOC_INT_STATUS_LF_TIMER0_MSB             6
#define SOC_INT_STATUS_LF_TIMER0_LSB             6
#define SOC_INT_STATUS_LF_TIMER0_MASK            0x00000040
#define SOC_INT_STATUS_LF_TIMER0_GET(x)          (((x) & SOC_INT_STATUS_LF_TIMER0_MASK) >> SOC_INT_STATUS_LF_TIMER0_LSB)
#define SOC_INT_STATUS_LF_TIMER0_SET(x)          (((x) << SOC_INT_STATUS_LF_TIMER0_LSB) & SOC_INT_STATUS_LF_TIMER0_MASK)
#define SOC_INT_STATUS_KEYPAD_MSB                5
#define SOC_INT_STATUS_KEYPAD_LSB                5
#define SOC_INT_STATUS_KEYPAD_MASK               0x00000020
#define SOC_INT_STATUS_KEYPAD_GET(x)             (((x) & SOC_INT_STATUS_KEYPAD_MASK) >> SOC_INT_STATUS_KEYPAD_LSB)
#define SOC_INT_STATUS_KEYPAD_SET(x)             (((x) << SOC_INT_STATUS_KEYPAD_LSB) & SOC_INT_STATUS_KEYPAD_MASK)
#define SOC_INT_STATUS_SI_MSB                    4
#define SOC_INT_STATUS_SI_LSB                    4
#define SOC_INT_STATUS_SI_MASK                   0x00000010
#define SOC_INT_STATUS_SI_GET(x)                 (((x) & SOC_INT_STATUS_SI_MASK) >> SOC_INT_STATUS_SI_LSB)
#define SOC_INT_STATUS_SI_SET(x)                 (((x) << SOC_INT_STATUS_SI_LSB) & SOC_INT_STATUS_SI_MASK)
#define SOC_INT_STATUS_GPIO_MSB                  3
#define SOC_INT_STATUS_GPIO_LSB                  3
#define SOC_INT_STATUS_GPIO_MASK                 0x00000008
#define SOC_INT_STATUS_GPIO_GET(x)               (((x) & SOC_INT_STATUS_GPIO_MASK) >> SOC_INT_STATUS_GPIO_LSB)
#define SOC_INT_STATUS_GPIO_SET(x)               (((x) << SOC_INT_STATUS_GPIO_LSB) & SOC_INT_STATUS_GPIO_MASK)
#define SOC_INT_STATUS_UART_MSB                  2
#define SOC_INT_STATUS_UART_LSB                  2
#define SOC_INT_STATUS_UART_MASK                 0x00000004
#define SOC_INT_STATUS_UART_GET(x)               (((x) & SOC_INT_STATUS_UART_MASK) >> SOC_INT_STATUS_UART_LSB)
#define SOC_INT_STATUS_UART_SET(x)               (((x) << SOC_INT_STATUS_UART_LSB) & SOC_INT_STATUS_UART_MASK)
#define SOC_INT_STATUS_ERROR_MSB                 1
#define SOC_INT_STATUS_ERROR_LSB                 1
#define SOC_INT_STATUS_ERROR_MASK                0x00000002
#define SOC_INT_STATUS_ERROR_GET(x)              (((x) & SOC_INT_STATUS_ERROR_MASK) >> SOC_INT_STATUS_ERROR_LSB)
#define SOC_INT_STATUS_ERROR_SET(x)              (((x) << SOC_INT_STATUS_ERROR_LSB) & SOC_INT_STATUS_ERROR_MASK)
#define SOC_INT_STATUS_WDT_INT_MSB               0
#define SOC_INT_STATUS_WDT_INT_LSB               0
#define SOC_INT_STATUS_WDT_INT_MASK              0x00000001
#define SOC_INT_STATUS_WDT_INT_GET(x)            (((x) & SOC_INT_STATUS_WDT_INT_MASK) >> SOC_INT_STATUS_WDT_INT_LSB)
#define SOC_INT_STATUS_WDT_INT_SET(x)            (((x) << SOC_INT_STATUS_WDT_INT_LSB) & SOC_INT_STATUS_WDT_INT_MASK)

#define SOC_LF_TIMER0_ADDRESS                    0x00000048
#define SOC_LF_TIMER0_OFFSET                     0x00000048
#define SOC_LF_TIMER0_TARGET_MSB                 31
#define SOC_LF_TIMER0_TARGET_LSB                 0
#define SOC_LF_TIMER0_TARGET_MASK                0xffffffff
#define SOC_LF_TIMER0_TARGET_GET(x)              (((x) & SOC_LF_TIMER0_TARGET_MASK) >> SOC_LF_TIMER0_TARGET_LSB)
#define SOC_LF_TIMER0_TARGET_SET(x)              (((x) << SOC_LF_TIMER0_TARGET_LSB) & SOC_LF_TIMER0_TARGET_MASK)

#define SOC_LF_TIMER_COUNT0_ADDRESS              0x0000004c
#define SOC_LF_TIMER_COUNT0_OFFSET               0x0000004c
#define SOC_LF_TIMER_COUNT0_VALUE_MSB            31
#define SOC_LF_TIMER_COUNT0_VALUE_LSB            0
#define SOC_LF_TIMER_COUNT0_VALUE_MASK           0xffffffff
#define SOC_LF_TIMER_COUNT0_VALUE_GET(x)         (((x) & SOC_LF_TIMER_COUNT0_VALUE_MASK) >> SOC_LF_TIMER_COUNT0_VALUE_LSB)
#define SOC_LF_TIMER_COUNT0_VALUE_SET(x)         (((x) << SOC_LF_TIMER_COUNT0_VALUE_LSB) & SOC_LF_TIMER_COUNT0_VALUE_MASK)

#define SOC_LF_TIMER_CONTROL0_ADDRESS            0x00000050
#define SOC_LF_TIMER_CONTROL0_OFFSET             0x00000050
#define SOC_LF_TIMER_CONTROL0_ENABLE_MSB         2
#define SOC_LF_TIMER_CONTROL0_ENABLE_LSB         2
#define SOC_LF_TIMER_CONTROL0_ENABLE_MASK        0x00000004
#define SOC_LF_TIMER_CONTROL0_ENABLE_GET(x)      (((x) & SOC_LF_TIMER_CONTROL0_ENABLE_MASK) >> SOC_LF_TIMER_CONTROL0_ENABLE_LSB)
#define SOC_LF_TIMER_CONTROL0_ENABLE_SET(x)      (((x) << SOC_LF_TIMER_CONTROL0_ENABLE_LSB) & SOC_LF_TIMER_CONTROL0_ENABLE_MASK)
#define SOC_LF_TIMER_CONTROL0_AUTO_RESTART_MSB   1
#define SOC_LF_TIMER_CONTROL0_AUTO_RESTART_LSB   1
#define SOC_LF_TIMER_CONTROL0_AUTO_RESTART_MASK  0x00000002
#define SOC_LF_TIMER_CONTROL0_AUTO_RESTART_GET(x) (((x) & SOC_LF_TIMER_CONTROL0_AUTO_RESTART_MASK) >> SOC_LF_TIMER_CONTROL0_AUTO_RESTART_LSB)
#define SOC_LF_TIMER_CONTROL0_AUTO_RESTART_SET(x) (((x) << SOC_LF_TIMER_CONTROL0_AUTO_RESTART_LSB) & SOC_LF_TIMER_CONTROL0_AUTO_RESTART_MASK)
#define SOC_LF_TIMER_CONTROL0_RESET_MSB          0
#define SOC_LF_TIMER_CONTROL0_RESET_LSB          0
#define SOC_LF_TIMER_CONTROL0_RESET_MASK         0x00000001
#define SOC_LF_TIMER_CONTROL0_RESET_GET(x)       (((x) & SOC_LF_TIMER_CONTROL0_RESET_MASK) >> SOC_LF_TIMER_CONTROL0_RESET_LSB)
#define SOC_LF_TIMER_CONTROL0_RESET_SET(x)       (((x) << SOC_LF_TIMER_CONTROL0_RESET_LSB) & SOC_LF_TIMER_CONTROL0_RESET_MASK)

#define SOC_LF_TIMER_STATUS0_ADDRESS             0x00000054
#define SOC_LF_TIMER_STATUS0_OFFSET              0x00000054
#define SOC_LF_TIMER_STATUS0_INTERRUPT_MSB       0
#define SOC_LF_TIMER_STATUS0_INTERRUPT_LSB       0
#define SOC_LF_TIMER_STATUS0_INTERRUPT_MASK      0x00000001
#define SOC_LF_TIMER_STATUS0_INTERRUPT_GET(x)    (((x) & SOC_LF_TIMER_STATUS0_INTERRUPT_MASK) >> SOC_LF_TIMER_STATUS0_INTERRUPT_LSB)
#define SOC_LF_TIMER_STATUS0_INTERRUPT_SET(x)    (((x) << SOC_LF_TIMER_STATUS0_INTERRUPT_LSB) & SOC_LF_TIMER_STATUS0_INTERRUPT_MASK)

#define SOC_LF_TIMER1_ADDRESS                    0x00000058
#define SOC_LF_TIMER1_OFFSET                     0x00000058
#define SOC_LF_TIMER1_TARGET_MSB                 31
#define SOC_LF_TIMER1_TARGET_LSB                 0
#define SOC_LF_TIMER1_TARGET_MASK                0xffffffff
#define SOC_LF_TIMER1_TARGET_GET(x)              (((x) & SOC_LF_TIMER1_TARGET_MASK) >> SOC_LF_TIMER1_TARGET_LSB)
#define SOC_LF_TIMER1_TARGET_SET(x)              (((x) << SOC_LF_TIMER1_TARGET_LSB) & SOC_LF_TIMER1_TARGET_MASK)

#define SOC_LF_TIMER_COUNT1_ADDRESS              0x0000005c
#define SOC_LF_TIMER_COUNT1_OFFSET               0x0000005c
#define SOC_LF_TIMER_COUNT1_VALUE_MSB            31
#define SOC_LF_TIMER_COUNT1_VALUE_LSB            0
#define SOC_LF_TIMER_COUNT1_VALUE_MASK           0xffffffff
#define SOC_LF_TIMER_COUNT1_VALUE_GET(x)         (((x) & SOC_LF_TIMER_COUNT1_VALUE_MASK) >> SOC_LF_TIMER_COUNT1_VALUE_LSB)
#define SOC_LF_TIMER_COUNT1_VALUE_SET(x)         (((x) << SOC_LF_TIMER_COUNT1_VALUE_LSB) & SOC_LF_TIMER_COUNT1_VALUE_MASK)

#define SOC_LF_TIMER_CONTROL1_ADDRESS            0x00000060
#define SOC_LF_TIMER_CONTROL1_OFFSET             0x00000060
#define SOC_LF_TIMER_CONTROL1_ENABLE_MSB         2
#define SOC_LF_TIMER_CONTROL1_ENABLE_LSB         2
#define SOC_LF_TIMER_CONTROL1_ENABLE_MASK        0x00000004
#define SOC_LF_TIMER_CONTROL1_ENABLE_GET(x)      (((x) & SOC_LF_TIMER_CONTROL1_ENABLE_MASK) >> SOC_LF_TIMER_CONTROL1_ENABLE_LSB)
#define SOC_LF_TIMER_CONTROL1_ENABLE_SET(x)      (((x) << SOC_LF_TIMER_CONTROL1_ENABLE_LSB) & SOC_LF_TIMER_CONTROL1_ENABLE_MASK)
#define SOC_LF_TIMER_CONTROL1_AUTO_RESTART_MSB   1
#define SOC_LF_TIMER_CONTROL1_AUTO_RESTART_LSB   1
#define SOC_LF_TIMER_CONTROL1_AUTO_RESTART_MASK  0x00000002
#define SOC_LF_TIMER_CONTROL1_AUTO_RESTART_GET(x) (((x) & SOC_LF_TIMER_CONTROL1_AUTO_RESTART_MASK) >> SOC_LF_TIMER_CONTROL1_AUTO_RESTART_LSB)
#define SOC_LF_TIMER_CONTROL1_AUTO_RESTART_SET(x) (((x) << SOC_LF_TIMER_CONTROL1_AUTO_RESTART_LSB) & SOC_LF_TIMER_CONTROL1_AUTO_RESTART_MASK)
#define SOC_LF_TIMER_CONTROL1_RESET_MSB          0
#define SOC_LF_TIMER_CONTROL1_RESET_LSB          0
#define SOC_LF_TIMER_CONTROL1_RESET_MASK         0x00000001
#define SOC_LF_TIMER_CONTROL1_RESET_GET(x)       (((x) & SOC_LF_TIMER_CONTROL1_RESET_MASK) >> SOC_LF_TIMER_CONTROL1_RESET_LSB)
#define SOC_LF_TIMER_CONTROL1_RESET_SET(x)       (((x) << SOC_LF_TIMER_CONTROL1_RESET_LSB) & SOC_LF_TIMER_CONTROL1_RESET_MASK)

#define SOC_LF_TIMER_STATUS1_ADDRESS             0x00000064
#define SOC_LF_TIMER_STATUS1_OFFSET              0x00000064
#define SOC_LF_TIMER_STATUS1_INTERRUPT_MSB       0
#define SOC_LF_TIMER_STATUS1_INTERRUPT_LSB       0
#define SOC_LF_TIMER_STATUS1_INTERRUPT_MASK      0x00000001
#define SOC_LF_TIMER_STATUS1_INTERRUPT_GET(x)    (((x) & SOC_LF_TIMER_STATUS1_INTERRUPT_MASK) >> SOC_LF_TIMER_STATUS1_INTERRUPT_LSB)
#define SOC_LF_TIMER_STATUS1_INTERRUPT_SET(x)    (((x) << SOC_LF_TIMER_STATUS1_INTERRUPT_LSB) & SOC_LF_TIMER_STATUS1_INTERRUPT_MASK)

#define SOC_LF_TIMER2_ADDRESS                    0x00000068
#define SOC_LF_TIMER2_OFFSET                     0x00000068
#define SOC_LF_TIMER2_TARGET_MSB                 31
#define SOC_LF_TIMER2_TARGET_LSB                 0
#define SOC_LF_TIMER2_TARGET_MASK                0xffffffff
#define SOC_LF_TIMER2_TARGET_GET(x)              (((x) & SOC_LF_TIMER2_TARGET_MASK) >> SOC_LF_TIMER2_TARGET_LSB)
#define SOC_LF_TIMER2_TARGET_SET(x)              (((x) << SOC_LF_TIMER2_TARGET_LSB) & SOC_LF_TIMER2_TARGET_MASK)

#define SOC_LF_TIMER_COUNT2_ADDRESS              0x0000006c
#define SOC_LF_TIMER_COUNT2_OFFSET               0x0000006c
#define SOC_LF_TIMER_COUNT2_VALUE_MSB            31
#define SOC_LF_TIMER_COUNT2_VALUE_LSB            0
#define SOC_LF_TIMER_COUNT2_VALUE_MASK           0xffffffff
#define SOC_LF_TIMER_COUNT2_VALUE_GET(x)         (((x) & SOC_LF_TIMER_COUNT2_VALUE_MASK) >> SOC_LF_TIMER_COUNT2_VALUE_LSB)
#define SOC_LF_TIMER_COUNT2_VALUE_SET(x)         (((x) << SOC_LF_TIMER_COUNT2_VALUE_LSB) & SOC_LF_TIMER_COUNT2_VALUE_MASK)

#define SOC_LF_TIMER_CONTROL2_ADDRESS            0x00000070
#define SOC_LF_TIMER_CONTROL2_OFFSET             0x00000070
#define SOC_LF_TIMER_CONTROL2_ENABLE_MSB         2
#define SOC_LF_TIMER_CONTROL2_ENABLE_LSB         2
#define SOC_LF_TIMER_CONTROL2_ENABLE_MASK        0x00000004
#define SOC_LF_TIMER_CONTROL2_ENABLE_GET(x)      (((x) & SOC_LF_TIMER_CONTROL2_ENABLE_MASK) >> SOC_LF_TIMER_CONTROL2_ENABLE_LSB)
#define SOC_LF_TIMER_CONTROL2_ENABLE_SET(x)      (((x) << SOC_LF_TIMER_CONTROL2_ENABLE_LSB) & SOC_LF_TIMER_CONTROL2_ENABLE_MASK)
#define SOC_LF_TIMER_CONTROL2_AUTO_RESTART_MSB   1
#define SOC_LF_TIMER_CONTROL2_AUTO_RESTART_LSB   1
#define SOC_LF_TIMER_CONTROL2_AUTO_RESTART_MASK  0x00000002
#define SOC_LF_TIMER_CONTROL2_AUTO_RESTART_GET(x) (((x) & SOC_LF_TIMER_CONTROL2_AUTO_RESTART_MASK) >> SOC_LF_TIMER_CONTROL2_AUTO_RESTART_LSB)
#define SOC_LF_TIMER_CONTROL2_AUTO_RESTART_SET(x) (((x) << SOC_LF_TIMER_CONTROL2_AUTO_RESTART_LSB) & SOC_LF_TIMER_CONTROL2_AUTO_RESTART_MASK)
#define SOC_LF_TIMER_CONTROL2_RESET_MSB          0
#define SOC_LF_TIMER_CONTROL2_RESET_LSB          0
#define SOC_LF_TIMER_CONTROL2_RESET_MASK         0x00000001
#define SOC_LF_TIMER_CONTROL2_RESET_GET(x)       (((x) & SOC_LF_TIMER_CONTROL2_RESET_MASK) >> SOC_LF_TIMER_CONTROL2_RESET_LSB)
#define SOC_LF_TIMER_CONTROL2_RESET_SET(x)       (((x) << SOC_LF_TIMER_CONTROL2_RESET_LSB) & SOC_LF_TIMER_CONTROL2_RESET_MASK)

#define SOC_LF_TIMER_STATUS2_ADDRESS             0x00000074
#define SOC_LF_TIMER_STATUS2_OFFSET              0x00000074
#define SOC_LF_TIMER_STATUS2_INTERRUPT_MSB       0
#define SOC_LF_TIMER_STATUS2_INTERRUPT_LSB       0
#define SOC_LF_TIMER_STATUS2_INTERRUPT_MASK      0x00000001
#define SOC_LF_TIMER_STATUS2_INTERRUPT_GET(x)    (((x) & SOC_LF_TIMER_STATUS2_INTERRUPT_MASK) >> SOC_LF_TIMER_STATUS2_INTERRUPT_LSB)
#define SOC_LF_TIMER_STATUS2_INTERRUPT_SET(x)    (((x) << SOC_LF_TIMER_STATUS2_INTERRUPT_LSB) & SOC_LF_TIMER_STATUS2_INTERRUPT_MASK)

#define SOC_LF_TIMER3_ADDRESS                    0x00000078
#define SOC_LF_TIMER3_OFFSET                     0x00000078
#define SOC_LF_TIMER3_TARGET_MSB                 31
#define SOC_LF_TIMER3_TARGET_LSB                 0
#define SOC_LF_TIMER3_TARGET_MASK                0xffffffff
#define SOC_LF_TIMER3_TARGET_GET(x)              (((x) & SOC_LF_TIMER3_TARGET_MASK) >> SOC_LF_TIMER3_TARGET_LSB)
#define SOC_LF_TIMER3_TARGET_SET(x)              (((x) << SOC_LF_TIMER3_TARGET_LSB) & SOC_LF_TIMER3_TARGET_MASK)

#define SOC_LF_TIMER_COUNT3_ADDRESS              0x0000007c
#define SOC_LF_TIMER_COUNT3_OFFSET               0x0000007c
#define SOC_LF_TIMER_COUNT3_VALUE_MSB            31
#define SOC_LF_TIMER_COUNT3_VALUE_LSB            0
#define SOC_LF_TIMER_COUNT3_VALUE_MASK           0xffffffff
#define SOC_LF_TIMER_COUNT3_VALUE_GET(x)         (((x) & SOC_LF_TIMER_COUNT3_VALUE_MASK) >> SOC_LF_TIMER_COUNT3_VALUE_LSB)
#define SOC_LF_TIMER_COUNT3_VALUE_SET(x)         (((x) << SOC_LF_TIMER_COUNT3_VALUE_LSB) & SOC_LF_TIMER_COUNT3_VALUE_MASK)

#define SOC_LF_TIMER_CONTROL3_ADDRESS            0x00000080
#define SOC_LF_TIMER_CONTROL3_OFFSET             0x00000080
#define SOC_LF_TIMER_CONTROL3_ENABLE_MSB         2
#define SOC_LF_TIMER_CONTROL3_ENABLE_LSB         2
#define SOC_LF_TIMER_CONTROL3_ENABLE_MASK        0x00000004
#define SOC_LF_TIMER_CONTROL3_ENABLE_GET(x)      (((x) & SOC_LF_TIMER_CONTROL3_ENABLE_MASK) >> SOC_LF_TIMER_CONTROL3_ENABLE_LSB)
#define SOC_LF_TIMER_CONTROL3_ENABLE_SET(x)      (((x) << SOC_LF_TIMER_CONTROL3_ENABLE_LSB) & SOC_LF_TIMER_CONTROL3_ENABLE_MASK)
#define SOC_LF_TIMER_CONTROL3_AUTO_RESTART_MSB   1
#define SOC_LF_TIMER_CONTROL3_AUTO_RESTART_LSB   1
#define SOC_LF_TIMER_CONTROL3_AUTO_RESTART_MASK  0x00000002
#define SOC_LF_TIMER_CONTROL3_AUTO_RESTART_GET(x) (((x) & SOC_LF_TIMER_CONTROL3_AUTO_RESTART_MASK) >> SOC_LF_TIMER_CONTROL3_AUTO_RESTART_LSB)
#define SOC_LF_TIMER_CONTROL3_AUTO_RESTART_SET(x) (((x) << SOC_LF_TIMER_CONTROL3_AUTO_RESTART_LSB) & SOC_LF_TIMER_CONTROL3_AUTO_RESTART_MASK)
#define SOC_LF_TIMER_CONTROL3_RESET_MSB          0
#define SOC_LF_TIMER_CONTROL3_RESET_LSB          0
#define SOC_LF_TIMER_CONTROL3_RESET_MASK         0x00000001
#define SOC_LF_TIMER_CONTROL3_RESET_GET(x)       (((x) & SOC_LF_TIMER_CONTROL3_RESET_MASK) >> SOC_LF_TIMER_CONTROL3_RESET_LSB)
#define SOC_LF_TIMER_CONTROL3_RESET_SET(x)       (((x) << SOC_LF_TIMER_CONTROL3_RESET_LSB) & SOC_LF_TIMER_CONTROL3_RESET_MASK)

#define SOC_LF_TIMER_STATUS3_ADDRESS             0x00000084
#define SOC_LF_TIMER_STATUS3_OFFSET              0x00000084
#define SOC_LF_TIMER_STATUS3_INTERRUPT_MSB       0
#define SOC_LF_TIMER_STATUS3_INTERRUPT_LSB       0
#define SOC_LF_TIMER_STATUS3_INTERRUPT_MASK      0x00000001
#define SOC_LF_TIMER_STATUS3_INTERRUPT_GET(x)    (((x) & SOC_LF_TIMER_STATUS3_INTERRUPT_MASK) >> SOC_LF_TIMER_STATUS3_INTERRUPT_LSB)
#define SOC_LF_TIMER_STATUS3_INTERRUPT_SET(x)    (((x) << SOC_LF_TIMER_STATUS3_INTERRUPT_LSB) & SOC_LF_TIMER_STATUS3_INTERRUPT_MASK)

#define SOC_HF_TIMER_ADDRESS                     0x00000088
#define SOC_HF_TIMER_OFFSET                      0x00000088
#define SOC_HF_TIMER_TARGET_MSB                  31
#define SOC_HF_TIMER_TARGET_LSB                  12
#define SOC_HF_TIMER_TARGET_MASK                 0xfffff000
#define SOC_HF_TIMER_TARGET_GET(x)               (((x) & SOC_HF_TIMER_TARGET_MASK) >> SOC_HF_TIMER_TARGET_LSB)
#define SOC_HF_TIMER_TARGET_SET(x)               (((x) << SOC_HF_TIMER_TARGET_LSB) & SOC_HF_TIMER_TARGET_MASK)

#define SOC_HF_TIMER_COUNT_ADDRESS               0x0000008c
#define SOC_HF_TIMER_COUNT_OFFSET                0x0000008c
#define SOC_HF_TIMER_COUNT_VALUE_MSB             31
#define SOC_HF_TIMER_COUNT_VALUE_LSB             12
#define SOC_HF_TIMER_COUNT_VALUE_MASK            0xfffff000
#define SOC_HF_TIMER_COUNT_VALUE_GET(x)          (((x) & SOC_HF_TIMER_COUNT_VALUE_MASK) >> SOC_HF_TIMER_COUNT_VALUE_LSB)
#define SOC_HF_TIMER_COUNT_VALUE_SET(x)          (((x) << SOC_HF_TIMER_COUNT_VALUE_LSB) & SOC_HF_TIMER_COUNT_VALUE_MASK)

#define SOC_HF_LF_COUNT_ADDRESS                  0x00000090
#define SOC_HF_LF_COUNT_OFFSET                   0x00000090
#define SOC_HF_LF_COUNT_VALUE_MSB                31
#define SOC_HF_LF_COUNT_VALUE_LSB                0
#define SOC_HF_LF_COUNT_VALUE_MASK               0xffffffff
#define SOC_HF_LF_COUNT_VALUE_GET(x)             (((x) & SOC_HF_LF_COUNT_VALUE_MASK) >> SOC_HF_LF_COUNT_VALUE_LSB)
#define SOC_HF_LF_COUNT_VALUE_SET(x)             (((x) << SOC_HF_LF_COUNT_VALUE_LSB) & SOC_HF_LF_COUNT_VALUE_MASK)

#define SOC_HF_TIMER_CONTROL_ADDRESS             0x00000094
#define SOC_HF_TIMER_CONTROL_OFFSET              0x00000094
#define SOC_HF_TIMER_CONTROL_ENABLE_MSB          3
#define SOC_HF_TIMER_CONTROL_ENABLE_LSB          3
#define SOC_HF_TIMER_CONTROL_ENABLE_MASK         0x00000008
#define SOC_HF_TIMER_CONTROL_ENABLE_GET(x)       (((x) & SOC_HF_TIMER_CONTROL_ENABLE_MASK) >> SOC_HF_TIMER_CONTROL_ENABLE_LSB)
#define SOC_HF_TIMER_CONTROL_ENABLE_SET(x)       (((x) << SOC_HF_TIMER_CONTROL_ENABLE_LSB) & SOC_HF_TIMER_CONTROL_ENABLE_MASK)
#define SOC_HF_TIMER_CONTROL_ON_MSB              2
#define SOC_HF_TIMER_CONTROL_ON_LSB              2
#define SOC_HF_TIMER_CONTROL_ON_MASK             0x00000004
#define SOC_HF_TIMER_CONTROL_ON_GET(x)           (((x) & SOC_HF_TIMER_CONTROL_ON_MASK) >> SOC_HF_TIMER_CONTROL_ON_LSB)
#define SOC_HF_TIMER_CONTROL_ON_SET(x)           (((x) << SOC_HF_TIMER_CONTROL_ON_LSB) & SOC_HF_TIMER_CONTROL_ON_MASK)
#define SOC_HF_TIMER_CONTROL_AUTO_RESTART_MSB    1
#define SOC_HF_TIMER_CONTROL_AUTO_RESTART_LSB    1
#define SOC_HF_TIMER_CONTROL_AUTO_RESTART_MASK   0x00000002
#define SOC_HF_TIMER_CONTROL_AUTO_RESTART_GET(x) (((x) & SOC_HF_TIMER_CONTROL_AUTO_RESTART_MASK) >> SOC_HF_TIMER_CONTROL_AUTO_RESTART_LSB)
#define SOC_HF_TIMER_CONTROL_AUTO_RESTART_SET(x) (((x) << SOC_HF_TIMER_CONTROL_AUTO_RESTART_LSB) & SOC_HF_TIMER_CONTROL_AUTO_RESTART_MASK)
#define SOC_HF_TIMER_CONTROL_RESET_MSB           0
#define SOC_HF_TIMER_CONTROL_RESET_LSB           0
#define SOC_HF_TIMER_CONTROL_RESET_MASK          0x00000001
#define SOC_HF_TIMER_CONTROL_RESET_GET(x)        (((x) & SOC_HF_TIMER_CONTROL_RESET_MASK) >> SOC_HF_TIMER_CONTROL_RESET_LSB)
#define SOC_HF_TIMER_CONTROL_RESET_SET(x)        (((x) << SOC_HF_TIMER_CONTROL_RESET_LSB) & SOC_HF_TIMER_CONTROL_RESET_MASK)

#define SOC_HF_TIMER_STATUS_ADDRESS              0x00000098
#define SOC_HF_TIMER_STATUS_OFFSET               0x00000098
#define SOC_HF_TIMER_STATUS_INTERRUPT_MSB        0
#define SOC_HF_TIMER_STATUS_INTERRUPT_LSB        0
#define SOC_HF_TIMER_STATUS_INTERRUPT_MASK       0x00000001
#define SOC_HF_TIMER_STATUS_INTERRUPT_GET(x)     (((x) & SOC_HF_TIMER_STATUS_INTERRUPT_MASK) >> SOC_HF_TIMER_STATUS_INTERRUPT_LSB)
#define SOC_HF_TIMER_STATUS_INTERRUPT_SET(x)     (((x) << SOC_HF_TIMER_STATUS_INTERRUPT_LSB) & SOC_HF_TIMER_STATUS_INTERRUPT_MASK)

#define SOC_RTC_CONTROL_ADDRESS                  0x0000009c
#define SOC_RTC_CONTROL_OFFSET                   0x0000009c
#define SOC_RTC_CONTROL_ENABLE_MSB               2
#define SOC_RTC_CONTROL_ENABLE_LSB               2
#define SOC_RTC_CONTROL_ENABLE_MASK              0x00000004
#define SOC_RTC_CONTROL_ENABLE_GET(x)            (((x) & SOC_RTC_CONTROL_ENABLE_MASK) >> SOC_RTC_CONTROL_ENABLE_LSB)
#define SOC_RTC_CONTROL_ENABLE_SET(x)            (((x) << SOC_RTC_CONTROL_ENABLE_LSB) & SOC_RTC_CONTROL_ENABLE_MASK)
#define SOC_RTC_CONTROL_LOAD_RTC_MSB             1
#define SOC_RTC_CONTROL_LOAD_RTC_LSB             1
#define SOC_RTC_CONTROL_LOAD_RTC_MASK            0x00000002
#define SOC_RTC_CONTROL_LOAD_RTC_GET(x)          (((x) & SOC_RTC_CONTROL_LOAD_RTC_MASK) >> SOC_RTC_CONTROL_LOAD_RTC_LSB)
#define SOC_RTC_CONTROL_LOAD_RTC_SET(x)          (((x) << SOC_RTC_CONTROL_LOAD_RTC_LSB) & SOC_RTC_CONTROL_LOAD_RTC_MASK)
#define SOC_RTC_CONTROL_LOAD_ALARM_MSB           0
#define SOC_RTC_CONTROL_LOAD_ALARM_LSB           0
#define SOC_RTC_CONTROL_LOAD_ALARM_MASK          0x00000001
#define SOC_RTC_CONTROL_LOAD_ALARM_GET(x)        (((x) & SOC_RTC_CONTROL_LOAD_ALARM_MASK) >> SOC_RTC_CONTROL_LOAD_ALARM_LSB)
#define SOC_RTC_CONTROL_LOAD_ALARM_SET(x)        (((x) << SOC_RTC_CONTROL_LOAD_ALARM_LSB) & SOC_RTC_CONTROL_LOAD_ALARM_MASK)

#define SOC_RTC_TIME_ADDRESS                     0x000000a0
#define SOC_RTC_TIME_OFFSET                      0x000000a0
#define SOC_RTC_TIME_WEEK_DAY_MSB                26
#define SOC_RTC_TIME_WEEK_DAY_LSB                24
#define SOC_RTC_TIME_WEEK_DAY_MASK               0x07000000
#define SOC_RTC_TIME_WEEK_DAY_GET(x)             (((x) & SOC_RTC_TIME_WEEK_DAY_MASK) >> SOC_RTC_TIME_WEEK_DAY_LSB)
#define SOC_RTC_TIME_WEEK_DAY_SET(x)             (((x) << SOC_RTC_TIME_WEEK_DAY_LSB) & SOC_RTC_TIME_WEEK_DAY_MASK)
#define SOC_RTC_TIME_HOUR_MSB                    21
#define SOC_RTC_TIME_HOUR_LSB                    16
#define SOC_RTC_TIME_HOUR_MASK                   0x003f0000
#define SOC_RTC_TIME_HOUR_GET(x)                 (((x) & SOC_RTC_TIME_HOUR_MASK) >> SOC_RTC_TIME_HOUR_LSB)
#define SOC_RTC_TIME_HOUR_SET(x)                 (((x) << SOC_RTC_TIME_HOUR_LSB) & SOC_RTC_TIME_HOUR_MASK)
#define SOC_RTC_TIME_MINUTE_MSB                  14
#define SOC_RTC_TIME_MINUTE_LSB                  8
#define SOC_RTC_TIME_MINUTE_MASK                 0x00007f00
#define SOC_RTC_TIME_MINUTE_GET(x)               (((x) & SOC_RTC_TIME_MINUTE_MASK) >> SOC_RTC_TIME_MINUTE_LSB)
#define SOC_RTC_TIME_MINUTE_SET(x)               (((x) << SOC_RTC_TIME_MINUTE_LSB) & SOC_RTC_TIME_MINUTE_MASK)
#define SOC_RTC_TIME_SECOND_MSB                  6
#define SOC_RTC_TIME_SECOND_LSB                  0
#define SOC_RTC_TIME_SECOND_MASK                 0x0000007f
#define SOC_RTC_TIME_SECOND_GET(x)               (((x) & SOC_RTC_TIME_SECOND_MASK) >> SOC_RTC_TIME_SECOND_LSB)
#define SOC_RTC_TIME_SECOND_SET(x)               (((x) << SOC_RTC_TIME_SECOND_LSB) & SOC_RTC_TIME_SECOND_MASK)

#define SOC_RTC_DATE_ADDRESS                     0x000000a4
#define SOC_RTC_DATE_OFFSET                      0x000000a4
#define SOC_RTC_DATE_YEAR_MSB                    23
#define SOC_RTC_DATE_YEAR_LSB                    16
#define SOC_RTC_DATE_YEAR_MASK                   0x00ff0000
#define SOC_RTC_DATE_YEAR_GET(x)                 (((x) & SOC_RTC_DATE_YEAR_MASK) >> SOC_RTC_DATE_YEAR_LSB)
#define SOC_RTC_DATE_YEAR_SET(x)                 (((x) << SOC_RTC_DATE_YEAR_LSB) & SOC_RTC_DATE_YEAR_MASK)
#define SOC_RTC_DATE_MONTH_MSB                   12
#define SOC_RTC_DATE_MONTH_LSB                   8
#define SOC_RTC_DATE_MONTH_MASK                  0x00001f00
#define SOC_RTC_DATE_MONTH_GET(x)                (((x) & SOC_RTC_DATE_MONTH_MASK) >> SOC_RTC_DATE_MONTH_LSB)
#define SOC_RTC_DATE_MONTH_SET(x)                (((x) << SOC_RTC_DATE_MONTH_LSB) & SOC_RTC_DATE_MONTH_MASK)
#define SOC_RTC_DATE_MONTH_DAY_MSB               5
#define SOC_RTC_DATE_MONTH_DAY_LSB               0
#define SOC_RTC_DATE_MONTH_DAY_MASK              0x0000003f
#define SOC_RTC_DATE_MONTH_DAY_GET(x)            (((x) & SOC_RTC_DATE_MONTH_DAY_MASK) >> SOC_RTC_DATE_MONTH_DAY_LSB)
#define SOC_RTC_DATE_MONTH_DAY_SET(x)            (((x) << SOC_RTC_DATE_MONTH_DAY_LSB) & SOC_RTC_DATE_MONTH_DAY_MASK)

#define SOC_RTC_SET_TIME_ADDRESS                 0x000000a8
#define SOC_RTC_SET_TIME_OFFSET                  0x000000a8
#define SOC_RTC_SET_TIME_WEEK_DAY_MSB            26
#define SOC_RTC_SET_TIME_WEEK_DAY_LSB            24
#define SOC_RTC_SET_TIME_WEEK_DAY_MASK           0x07000000
#define SOC_RTC_SET_TIME_WEEK_DAY_GET(x)         (((x) & SOC_RTC_SET_TIME_WEEK_DAY_MASK) >> SOC_RTC_SET_TIME_WEEK_DAY_LSB)
#define SOC_RTC_SET_TIME_WEEK_DAY_SET(x)         (((x) << SOC_RTC_SET_TIME_WEEK_DAY_LSB) & SOC_RTC_SET_TIME_WEEK_DAY_MASK)
#define SOC_RTC_SET_TIME_HOUR_MSB                21
#define SOC_RTC_SET_TIME_HOUR_LSB                16
#define SOC_RTC_SET_TIME_HOUR_MASK               0x003f0000
#define SOC_RTC_SET_TIME_HOUR_GET(x)             (((x) & SOC_RTC_SET_TIME_HOUR_MASK) >> SOC_RTC_SET_TIME_HOUR_LSB)
#define SOC_RTC_SET_TIME_HOUR_SET(x)             (((x) << SOC_RTC_SET_TIME_HOUR_LSB) & SOC_RTC_SET_TIME_HOUR_MASK)
#define SOC_RTC_SET_TIME_MINUTE_MSB              14
#define SOC_RTC_SET_TIME_MINUTE_LSB              8
#define SOC_RTC_SET_TIME_MINUTE_MASK             0x00007f00
#define SOC_RTC_SET_TIME_MINUTE_GET(x)           (((x) & SOC_RTC_SET_TIME_MINUTE_MASK) >> SOC_RTC_SET_TIME_MINUTE_LSB)
#define SOC_RTC_SET_TIME_MINUTE_SET(x)           (((x) << SOC_RTC_SET_TIME_MINUTE_LSB) & SOC_RTC_SET_TIME_MINUTE_MASK)
#define SOC_RTC_SET_TIME_SECOND_MSB              6
#define SOC_RTC_SET_TIME_SECOND_LSB              0
#define SOC_RTC_SET_TIME_SECOND_MASK             0x0000007f
#define SOC_RTC_SET_TIME_SECOND_GET(x)           (((x) & SOC_RTC_SET_TIME_SECOND_MASK) >> SOC_RTC_SET_TIME_SECOND_LSB)
#define SOC_RTC_SET_TIME_SECOND_SET(x)           (((x) << SOC_RTC_SET_TIME_SECOND_LSB) & SOC_RTC_SET_TIME_SECOND_MASK)

#define SOC_RTC_SET_DATE_ADDRESS                 0x000000ac
#define SOC_RTC_SET_DATE_OFFSET                  0x000000ac
#define SOC_RTC_SET_DATE_YEAR_MSB                23
#define SOC_RTC_SET_DATE_YEAR_LSB                16
#define SOC_RTC_SET_DATE_YEAR_MASK               0x00ff0000
#define SOC_RTC_SET_DATE_YEAR_GET(x)             (((x) & SOC_RTC_SET_DATE_YEAR_MASK) >> SOC_RTC_SET_DATE_YEAR_LSB)
#define SOC_RTC_SET_DATE_YEAR_SET(x)             (((x) << SOC_RTC_SET_DATE_YEAR_LSB) & SOC_RTC_SET_DATE_YEAR_MASK)
#define SOC_RTC_SET_DATE_MONTH_MSB               12
#define SOC_RTC_SET_DATE_MONTH_LSB               8
#define SOC_RTC_SET_DATE_MONTH_MASK              0x00001f00
#define SOC_RTC_SET_DATE_MONTH_GET(x)            (((x) & SOC_RTC_SET_DATE_MONTH_MASK) >> SOC_RTC_SET_DATE_MONTH_LSB)
#define SOC_RTC_SET_DATE_MONTH_SET(x)            (((x) << SOC_RTC_SET_DATE_MONTH_LSB) & SOC_RTC_SET_DATE_MONTH_MASK)
#define SOC_RTC_SET_DATE_MONTH_DAY_MSB           5
#define SOC_RTC_SET_DATE_MONTH_DAY_LSB           0
#define SOC_RTC_SET_DATE_MONTH_DAY_MASK          0x0000003f
#define SOC_RTC_SET_DATE_MONTH_DAY_GET(x)        (((x) & SOC_RTC_SET_DATE_MONTH_DAY_MASK) >> SOC_RTC_SET_DATE_MONTH_DAY_LSB)
#define SOC_RTC_SET_DATE_MONTH_DAY_SET(x)        (((x) << SOC_RTC_SET_DATE_MONTH_DAY_LSB) & SOC_RTC_SET_DATE_MONTH_DAY_MASK)

#define SOC_RTC_SET_ALARM_ADDRESS                0x000000b0
#define SOC_RTC_SET_ALARM_OFFSET                 0x000000b0
#define SOC_RTC_SET_ALARM_HOUR_MSB               21
#define SOC_RTC_SET_ALARM_HOUR_LSB               16
#define SOC_RTC_SET_ALARM_HOUR_MASK              0x003f0000
#define SOC_RTC_SET_ALARM_HOUR_GET(x)            (((x) & SOC_RTC_SET_ALARM_HOUR_MASK) >> SOC_RTC_SET_ALARM_HOUR_LSB)
#define SOC_RTC_SET_ALARM_HOUR_SET(x)            (((x) << SOC_RTC_SET_ALARM_HOUR_LSB) & SOC_RTC_SET_ALARM_HOUR_MASK)
#define SOC_RTC_SET_ALARM_MINUTE_MSB             14
#define SOC_RTC_SET_ALARM_MINUTE_LSB             8
#define SOC_RTC_SET_ALARM_MINUTE_MASK            0x00007f00
#define SOC_RTC_SET_ALARM_MINUTE_GET(x)          (((x) & SOC_RTC_SET_ALARM_MINUTE_MASK) >> SOC_RTC_SET_ALARM_MINUTE_LSB)
#define SOC_RTC_SET_ALARM_MINUTE_SET(x)          (((x) << SOC_RTC_SET_ALARM_MINUTE_LSB) & SOC_RTC_SET_ALARM_MINUTE_MASK)
#define SOC_RTC_SET_ALARM_SECOND_MSB             6
#define SOC_RTC_SET_ALARM_SECOND_LSB             0
#define SOC_RTC_SET_ALARM_SECOND_MASK            0x0000007f
#define SOC_RTC_SET_ALARM_SECOND_GET(x)          (((x) & SOC_RTC_SET_ALARM_SECOND_MASK) >> SOC_RTC_SET_ALARM_SECOND_LSB)
#define SOC_RTC_SET_ALARM_SECOND_SET(x)          (((x) << SOC_RTC_SET_ALARM_SECOND_LSB) & SOC_RTC_SET_ALARM_SECOND_MASK)

#define SOC_RTC_CONFIG_ADDRESS                   0x000000b4
#define SOC_RTC_CONFIG_OFFSET                    0x000000b4
#define SOC_RTC_CONFIG_BCD_MSB                   2
#define SOC_RTC_CONFIG_BCD_LSB                   2
#define SOC_RTC_CONFIG_BCD_MASK                  0x00000004
#define SOC_RTC_CONFIG_BCD_GET(x)                (((x) & SOC_RTC_CONFIG_BCD_MASK) >> SOC_RTC_CONFIG_BCD_LSB)
#define SOC_RTC_CONFIG_BCD_SET(x)                (((x) << SOC_RTC_CONFIG_BCD_LSB) & SOC_RTC_CONFIG_BCD_MASK)
#define SOC_RTC_CONFIG_TWELVE_HOUR_MSB           1
#define SOC_RTC_CONFIG_TWELVE_HOUR_LSB           1
#define SOC_RTC_CONFIG_TWELVE_HOUR_MASK          0x00000002
#define SOC_RTC_CONFIG_TWELVE_HOUR_GET(x)        (((x) & SOC_RTC_CONFIG_TWELVE_HOUR_MASK) >> SOC_RTC_CONFIG_TWELVE_HOUR_LSB)
#define SOC_RTC_CONFIG_TWELVE_HOUR_SET(x)        (((x) << SOC_RTC_CONFIG_TWELVE_HOUR_LSB) & SOC_RTC_CONFIG_TWELVE_HOUR_MASK)
#define SOC_RTC_CONFIG_DSE_MSB                   0
#define SOC_RTC_CONFIG_DSE_LSB                   0
#define SOC_RTC_CONFIG_DSE_MASK                  0x00000001
#define SOC_RTC_CONFIG_DSE_GET(x)                (((x) & SOC_RTC_CONFIG_DSE_MASK) >> SOC_RTC_CONFIG_DSE_LSB)
#define SOC_RTC_CONFIG_DSE_SET(x)                (((x) << SOC_RTC_CONFIG_DSE_LSB) & SOC_RTC_CONFIG_DSE_MASK)

#define SOC_RTC_ALARM_STATUS_ADDRESS             0x000000b8
#define SOC_RTC_ALARM_STATUS_OFFSET              0x000000b8
#define SOC_RTC_ALARM_STATUS_ENABLE_MSB          1
#define SOC_RTC_ALARM_STATUS_ENABLE_LSB          1
#define SOC_RTC_ALARM_STATUS_ENABLE_MASK         0x00000002
#define SOC_RTC_ALARM_STATUS_ENABLE_GET(x)       (((x) & SOC_RTC_ALARM_STATUS_ENABLE_MASK) >> SOC_RTC_ALARM_STATUS_ENABLE_LSB)
#define SOC_RTC_ALARM_STATUS_ENABLE_SET(x)       (((x) << SOC_RTC_ALARM_STATUS_ENABLE_LSB) & SOC_RTC_ALARM_STATUS_ENABLE_MASK)
#define SOC_RTC_ALARM_STATUS_INTERRUPT_MSB       0
#define SOC_RTC_ALARM_STATUS_INTERRUPT_LSB       0
#define SOC_RTC_ALARM_STATUS_INTERRUPT_MASK      0x00000001
#define SOC_RTC_ALARM_STATUS_INTERRUPT_GET(x)    (((x) & SOC_RTC_ALARM_STATUS_INTERRUPT_MASK) >> SOC_RTC_ALARM_STATUS_INTERRUPT_LSB)
#define SOC_RTC_ALARM_STATUS_INTERRUPT_SET(x)    (((x) << SOC_RTC_ALARM_STATUS_INTERRUPT_LSB) & SOC_RTC_ALARM_STATUS_INTERRUPT_MASK)

#define SOC_UART_WAKEUP_ADDRESS                  0x000000bc
#define SOC_UART_WAKEUP_OFFSET                   0x000000bc
#define SOC_UART_WAKEUP_ENABLE_MSB               0
#define SOC_UART_WAKEUP_ENABLE_LSB               0
#define SOC_UART_WAKEUP_ENABLE_MASK              0x00000001
#define SOC_UART_WAKEUP_ENABLE_GET(x)            (((x) & SOC_UART_WAKEUP_ENABLE_MASK) >> SOC_UART_WAKEUP_ENABLE_LSB)
#define SOC_UART_WAKEUP_ENABLE_SET(x)            (((x) << SOC_UART_WAKEUP_ENABLE_LSB) & SOC_UART_WAKEUP_ENABLE_MASK)

#define SOC_RESET_CAUSE_ADDRESS                  0x000000c0
#define SOC_RESET_CAUSE_OFFSET                   0x000000c0
#define SOC_RESET_CAUSE_LAST_MSB                 2
#define SOC_RESET_CAUSE_LAST_LSB                 0
#define SOC_RESET_CAUSE_LAST_MASK                0x00000007
#define SOC_RESET_CAUSE_LAST_GET(x)              (((x) & SOC_RESET_CAUSE_LAST_MASK) >> SOC_RESET_CAUSE_LAST_LSB)
#define SOC_RESET_CAUSE_LAST_SET(x)              (((x) << SOC_RESET_CAUSE_LAST_LSB) & SOC_RESET_CAUSE_LAST_MASK)

#define SOC_SYSTEM_SLEEP_ADDRESS                 0x000000c4
#define SOC_SYSTEM_SLEEP_OFFSET                  0x000000c4
#define SOC_SYSTEM_SLEEP_MCI_MSB                 5
#define SOC_SYSTEM_SLEEP_MCI_LSB                 5
#define SOC_SYSTEM_SLEEP_MCI_MASK                0x00000020
#define SOC_SYSTEM_SLEEP_MCI_GET(x)              (((x) & SOC_SYSTEM_SLEEP_MCI_MASK) >> SOC_SYSTEM_SLEEP_MCI_LSB)
#define SOC_SYSTEM_SLEEP_MCI_SET(x)              (((x) << SOC_SYSTEM_SLEEP_MCI_LSB) & SOC_SYSTEM_SLEEP_MCI_MASK)
#define SOC_SYSTEM_SLEEP_HOST_IF_MSB             4
#define SOC_SYSTEM_SLEEP_HOST_IF_LSB             4
#define SOC_SYSTEM_SLEEP_HOST_IF_MASK            0x00000010
#define SOC_SYSTEM_SLEEP_HOST_IF_GET(x)          (((x) & SOC_SYSTEM_SLEEP_HOST_IF_MASK) >> SOC_SYSTEM_SLEEP_HOST_IF_LSB)
#define SOC_SYSTEM_SLEEP_HOST_IF_SET(x)          (((x) << SOC_SYSTEM_SLEEP_HOST_IF_LSB) & SOC_SYSTEM_SLEEP_HOST_IF_MASK)
#define SOC_SYSTEM_SLEEP_MBOX_MSB                3
#define SOC_SYSTEM_SLEEP_MBOX_LSB                3
#define SOC_SYSTEM_SLEEP_MBOX_MASK               0x00000008
#define SOC_SYSTEM_SLEEP_MBOX_GET(x)             (((x) & SOC_SYSTEM_SLEEP_MBOX_MASK) >> SOC_SYSTEM_SLEEP_MBOX_LSB)
#define SOC_SYSTEM_SLEEP_MBOX_SET(x)             (((x) << SOC_SYSTEM_SLEEP_MBOX_LSB) & SOC_SYSTEM_SLEEP_MBOX_MASK)
#define SOC_SYSTEM_SLEEP_MAC_IF_MSB              2
#define SOC_SYSTEM_SLEEP_MAC_IF_LSB              2
#define SOC_SYSTEM_SLEEP_MAC_IF_MASK             0x00000004
#define SOC_SYSTEM_SLEEP_MAC_IF_GET(x)           (((x) & SOC_SYSTEM_SLEEP_MAC_IF_MASK) >> SOC_SYSTEM_SLEEP_MAC_IF_LSB)
#define SOC_SYSTEM_SLEEP_MAC_IF_SET(x)           (((x) << SOC_SYSTEM_SLEEP_MAC_IF_LSB) & SOC_SYSTEM_SLEEP_MAC_IF_MASK)
#define SOC_SYSTEM_SLEEP_LIGHT_MSB               1
#define SOC_SYSTEM_SLEEP_LIGHT_LSB               1
#define SOC_SYSTEM_SLEEP_LIGHT_MASK              0x00000002
#define SOC_SYSTEM_SLEEP_LIGHT_GET(x)            (((x) & SOC_SYSTEM_SLEEP_LIGHT_MASK) >> SOC_SYSTEM_SLEEP_LIGHT_LSB)
#define SOC_SYSTEM_SLEEP_LIGHT_SET(x)            (((x) << SOC_SYSTEM_SLEEP_LIGHT_LSB) & SOC_SYSTEM_SLEEP_LIGHT_MASK)
#define SOC_SYSTEM_SLEEP_DISABLE_MSB             0
#define SOC_SYSTEM_SLEEP_DISABLE_LSB             0
#define SOC_SYSTEM_SLEEP_DISABLE_MASK            0x00000001
#define SOC_SYSTEM_SLEEP_DISABLE_GET(x)          (((x) & SOC_SYSTEM_SLEEP_DISABLE_MASK) >> SOC_SYSTEM_SLEEP_DISABLE_LSB)
#define SOC_SYSTEM_SLEEP_DISABLE_SET(x)          (((x) << SOC_SYSTEM_SLEEP_DISABLE_LSB) & SOC_SYSTEM_SLEEP_DISABLE_MASK)

#define SOC_SDIO_WRAPPER_ADDRESS                 0x000000c8
#define SOC_SDIO_WRAPPER_OFFSET                  0x000000c8
#define SOC_SDIO_WRAPPER_SLEEP_MSB               3
#define SOC_SDIO_WRAPPER_SLEEP_LSB               3
#define SOC_SDIO_WRAPPER_SLEEP_MASK              0x00000008
#define SOC_SDIO_WRAPPER_SLEEP_GET(x)            (((x) & SOC_SDIO_WRAPPER_SLEEP_MASK) >> SOC_SDIO_WRAPPER_SLEEP_LSB)
#define SOC_SDIO_WRAPPER_SLEEP_SET(x)            (((x) << SOC_SDIO_WRAPPER_SLEEP_LSB) & SOC_SDIO_WRAPPER_SLEEP_MASK)
#define SOC_SDIO_WRAPPER_WAKEUP_MSB              2
#define SOC_SDIO_WRAPPER_WAKEUP_LSB              2
#define SOC_SDIO_WRAPPER_WAKEUP_MASK             0x00000004
#define SOC_SDIO_WRAPPER_WAKEUP_GET(x)           (((x) & SOC_SDIO_WRAPPER_WAKEUP_MASK) >> SOC_SDIO_WRAPPER_WAKEUP_LSB)
#define SOC_SDIO_WRAPPER_WAKEUP_SET(x)           (((x) << SOC_SDIO_WRAPPER_WAKEUP_LSB) & SOC_SDIO_WRAPPER_WAKEUP_MASK)
#define SOC_SDIO_WRAPPER_SOC_ON_MSB              1
#define SOC_SDIO_WRAPPER_SOC_ON_LSB              1
#define SOC_SDIO_WRAPPER_SOC_ON_MASK             0x00000002
#define SOC_SDIO_WRAPPER_SOC_ON_GET(x)           (((x) & SOC_SDIO_WRAPPER_SOC_ON_MASK) >> SOC_SDIO_WRAPPER_SOC_ON_LSB)
#define SOC_SDIO_WRAPPER_SOC_ON_SET(x)           (((x) << SOC_SDIO_WRAPPER_SOC_ON_LSB) & SOC_SDIO_WRAPPER_SOC_ON_MASK)
#define SOC_SDIO_WRAPPER_ON_MSB                  0
#define SOC_SDIO_WRAPPER_ON_LSB                  0
#define SOC_SDIO_WRAPPER_ON_MASK                 0x00000001
#define SOC_SDIO_WRAPPER_ON_GET(x)               (((x) & SOC_SDIO_WRAPPER_ON_MASK) >> SOC_SDIO_WRAPPER_ON_LSB)
#define SOC_SDIO_WRAPPER_ON_SET(x)               (((x) << SOC_SDIO_WRAPPER_ON_LSB) & SOC_SDIO_WRAPPER_ON_MASK)

#define SOC_INT_STATUS1_ADDRESS                  0x000000cc
#define SOC_INT_STATUS1_OFFSET                   0x000000cc
#define SOC_INT_STATUS1_I2S_1_MSB                9
#define SOC_INT_STATUS1_I2S_1_LSB                9
#define SOC_INT_STATUS1_I2S_1_MASK               0x00000200
#define SOC_INT_STATUS1_I2S_1_GET(x)             (((x) & SOC_INT_STATUS1_I2S_1_MASK) >> SOC_INT_STATUS1_I2S_1_LSB)
#define SOC_INT_STATUS1_I2S_1_SET(x)             (((x) << SOC_INT_STATUS1_I2S_1_LSB) & SOC_INT_STATUS1_I2S_1_MASK)
#define SOC_INT_STATUS1_I2S_MSB                  8
#define SOC_INT_STATUS1_I2S_LSB                  8
#define SOC_INT_STATUS1_I2S_MASK                 0x00000100
#define SOC_INT_STATUS1_I2S_GET(x)               (((x) & SOC_INT_STATUS1_I2S_MASK) >> SOC_INT_STATUS1_I2S_LSB)
#define SOC_INT_STATUS1_I2S_SET(x)               (((x) << SOC_INT_STATUS1_I2S_LSB) & SOC_INT_STATUS1_I2S_MASK)
#define SOC_INT_STATUS1_MDIO_MSB                 7
#define SOC_INT_STATUS1_MDIO_LSB                 7
#define SOC_INT_STATUS1_MDIO_MASK                0x00000080
#define SOC_INT_STATUS1_MDIO_GET(x)              (((x) & SOC_INT_STATUS1_MDIO_MASK) >> SOC_INT_STATUS1_MDIO_LSB)
#define SOC_INT_STATUS1_MDIO_SET(x)              (((x) << SOC_INT_STATUS1_MDIO_LSB) & SOC_INT_STATUS1_MDIO_MASK)
#define SOC_INT_STATUS1_GMAC_MSB                 6
#define SOC_INT_STATUS1_GMAC_LSB                 6
#define SOC_INT_STATUS1_GMAC_MASK                0x00000040
#define SOC_INT_STATUS1_GMAC_GET(x)              (((x) & SOC_INT_STATUS1_GMAC_MASK) >> SOC_INT_STATUS1_GMAC_LSB)
#define SOC_INT_STATUS1_GMAC_SET(x)              (((x) << SOC_INT_STATUS1_GMAC_LSB) & SOC_INT_STATUS1_GMAC_MASK)
#define SOC_INT_STATUS1_I2C_S_MSB                5
#define SOC_INT_STATUS1_I2C_S_LSB                5
#define SOC_INT_STATUS1_I2C_S_MASK               0x00000020
#define SOC_INT_STATUS1_I2C_S_GET(x)             (((x) & SOC_INT_STATUS1_I2C_S_MASK) >> SOC_INT_STATUS1_I2C_S_LSB)
#define SOC_INT_STATUS1_I2C_S_SET(x)             (((x) << SOC_INT_STATUS1_I2C_S_LSB) & SOC_INT_STATUS1_I2C_S_MASK)
#define SOC_INT_STATUS1_CKSUM_MSB                4
#define SOC_INT_STATUS1_CKSUM_LSB                4
#define SOC_INT_STATUS1_CKSUM_MASK               0x00000010
#define SOC_INT_STATUS1_CKSUM_GET(x)             (((x) & SOC_INT_STATUS1_CKSUM_MASK) >> SOC_INT_STATUS1_CKSUM_LSB)
#define SOC_INT_STATUS1_CKSUM_SET(x)             (((x) << SOC_INT_STATUS1_CKSUM_LSB) & SOC_INT_STATUS1_CKSUM_MASK)
#define SOC_INT_STATUS1_MAC_4_MSB                3
#define SOC_INT_STATUS1_MAC_4_LSB                3
#define SOC_INT_STATUS1_MAC_4_MASK               0x00000008
#define SOC_INT_STATUS1_MAC_4_GET(x)             (((x) & SOC_INT_STATUS1_MAC_4_MASK) >> SOC_INT_STATUS1_MAC_4_LSB)
#define SOC_INT_STATUS1_MAC_4_SET(x)             (((x) << SOC_INT_STATUS1_MAC_4_LSB) & SOC_INT_STATUS1_MAC_4_MASK)
#define SOC_INT_STATUS1_MAC_3_MSB                2
#define SOC_INT_STATUS1_MAC_3_LSB                2
#define SOC_INT_STATUS1_MAC_3_MASK               0x00000004
#define SOC_INT_STATUS1_MAC_3_GET(x)             (((x) & SOC_INT_STATUS1_MAC_3_MASK) >> SOC_INT_STATUS1_MAC_3_LSB)
#define SOC_INT_STATUS1_MAC_3_SET(x)             (((x) << SOC_INT_STATUS1_MAC_3_LSB) & SOC_INT_STATUS1_MAC_3_MASK)
#define SOC_INT_STATUS1_MAC_2_MSB                1
#define SOC_INT_STATUS1_MAC_2_LSB                1
#define SOC_INT_STATUS1_MAC_2_MASK               0x00000002
#define SOC_INT_STATUS1_MAC_2_GET(x)             (((x) & SOC_INT_STATUS1_MAC_2_MASK) >> SOC_INT_STATUS1_MAC_2_LSB)
#define SOC_INT_STATUS1_MAC_2_SET(x)             (((x) << SOC_INT_STATUS1_MAC_2_LSB) & SOC_INT_STATUS1_MAC_2_MASK)
#define SOC_INT_STATUS1_MAC_1_MSB                0
#define SOC_INT_STATUS1_MAC_1_LSB                0
#define SOC_INT_STATUS1_MAC_1_MASK               0x00000001
#define SOC_INT_STATUS1_MAC_1_GET(x)             (((x) & SOC_INT_STATUS1_MAC_1_MASK) >> SOC_INT_STATUS1_MAC_1_LSB)
#define SOC_INT_STATUS1_MAC_1_SET(x)             (((x) << SOC_INT_STATUS1_MAC_1_LSB) & SOC_INT_STATUS1_MAC_1_MASK)

#define SOC_LPO_CAL_TIME_ADDRESS                 0x000000d4
#define SOC_LPO_CAL_TIME_OFFSET                  0x000000d4
#define SOC_LPO_CAL_TIME_LENGTH_MSB              13
#define SOC_LPO_CAL_TIME_LENGTH_LSB              0
#define SOC_LPO_CAL_TIME_LENGTH_MASK             0x00003fff
#define SOC_LPO_CAL_TIME_LENGTH_GET(x)           (((x) & SOC_LPO_CAL_TIME_LENGTH_MASK) >> SOC_LPO_CAL_TIME_LENGTH_LSB)
#define SOC_LPO_CAL_TIME_LENGTH_SET(x)           (((x) << SOC_LPO_CAL_TIME_LENGTH_LSB) & SOC_LPO_CAL_TIME_LENGTH_MASK)

#define SOC_LPO_INIT_DIVIDEND_INT_ADDRESS        0x000000d8
#define SOC_LPO_INIT_DIVIDEND_INT_OFFSET         0x000000d8
#define SOC_LPO_INIT_DIVIDEND_INT_VALUE_MSB      23
#define SOC_LPO_INIT_DIVIDEND_INT_VALUE_LSB      0
#define SOC_LPO_INIT_DIVIDEND_INT_VALUE_MASK     0x00ffffff
#define SOC_LPO_INIT_DIVIDEND_INT_VALUE_GET(x)   (((x) & SOC_LPO_INIT_DIVIDEND_INT_VALUE_MASK) >> SOC_LPO_INIT_DIVIDEND_INT_VALUE_LSB)
#define SOC_LPO_INIT_DIVIDEND_INT_VALUE_SET(x)   (((x) << SOC_LPO_INIT_DIVIDEND_INT_VALUE_LSB) & SOC_LPO_INIT_DIVIDEND_INT_VALUE_MASK)

#define SOC_LPO_INIT_DIVIDEND_FRACTION_ADDRESS   0x000000dc
#define SOC_LPO_INIT_DIVIDEND_FRACTION_OFFSET    0x000000dc
#define SOC_LPO_INIT_DIVIDEND_FRACTION_VALUE_MSB 10
#define SOC_LPO_INIT_DIVIDEND_FRACTION_VALUE_LSB 0
#define SOC_LPO_INIT_DIVIDEND_FRACTION_VALUE_MASK 0x000007ff
#define SOC_LPO_INIT_DIVIDEND_FRACTION_VALUE_GET(x) (((x) & SOC_LPO_INIT_DIVIDEND_FRACTION_VALUE_MASK) >> SOC_LPO_INIT_DIVIDEND_FRACTION_VALUE_LSB)
#define SOC_LPO_INIT_DIVIDEND_FRACTION_VALUE_SET(x) (((x) << SOC_LPO_INIT_DIVIDEND_FRACTION_VALUE_LSB) & SOC_LPO_INIT_DIVIDEND_FRACTION_VALUE_MASK)

#define SOC_LPO_CAL_ADDRESS                      0x000000e0
#define SOC_LPO_CAL_OFFSET                       0x000000e0
#define SOC_LPO_CAL_ENABLE_MSB                   20
#define SOC_LPO_CAL_ENABLE_LSB                   20
#define SOC_LPO_CAL_ENABLE_MASK                  0x00100000
#define SOC_LPO_CAL_ENABLE_GET(x)                (((x) & SOC_LPO_CAL_ENABLE_MASK) >> SOC_LPO_CAL_ENABLE_LSB)
#define SOC_LPO_CAL_ENABLE_SET(x)                (((x) << SOC_LPO_CAL_ENABLE_LSB) & SOC_LPO_CAL_ENABLE_MASK)
#define SOC_LPO_CAL_COUNT_MSB                    19
#define SOC_LPO_CAL_COUNT_LSB                    0
#define SOC_LPO_CAL_COUNT_MASK                   0x000fffff
#define SOC_LPO_CAL_COUNT_GET(x)                 (((x) & SOC_LPO_CAL_COUNT_MASK) >> SOC_LPO_CAL_COUNT_LSB)
#define SOC_LPO_CAL_COUNT_SET(x)                 (((x) << SOC_LPO_CAL_COUNT_LSB) & SOC_LPO_CAL_COUNT_MASK)

#define SOC_LPO_CAL_TEST_CONTROL_ADDRESS         0x000000e4
#define SOC_LPO_CAL_TEST_CONTROL_OFFSET          0x000000e4
#define SOC_LPO_CAL_TEST_CONTROL_ENABLE_MSB      16
#define SOC_LPO_CAL_TEST_CONTROL_ENABLE_LSB      16
#define SOC_LPO_CAL_TEST_CONTROL_ENABLE_MASK     0x00010000
#define SOC_LPO_CAL_TEST_CONTROL_ENABLE_GET(x)   (((x) & SOC_LPO_CAL_TEST_CONTROL_ENABLE_MASK) >> SOC_LPO_CAL_TEST_CONTROL_ENABLE_LSB)
#define SOC_LPO_CAL_TEST_CONTROL_ENABLE_SET(x)   (((x) << SOC_LPO_CAL_TEST_CONTROL_ENABLE_LSB) & SOC_LPO_CAL_TEST_CONTROL_ENABLE_MASK)
#define SOC_LPO_CAL_TEST_CONTROL_RTC_CYCLES_MSB  15
#define SOC_LPO_CAL_TEST_CONTROL_RTC_CYCLES_LSB  0
#define SOC_LPO_CAL_TEST_CONTROL_RTC_CYCLES_MASK 0x0000ffff
#define SOC_LPO_CAL_TEST_CONTROL_RTC_CYCLES_GET(x) (((x) & SOC_LPO_CAL_TEST_CONTROL_RTC_CYCLES_MASK) >> SOC_LPO_CAL_TEST_CONTROL_RTC_CYCLES_LSB)
#define SOC_LPO_CAL_TEST_CONTROL_RTC_CYCLES_SET(x) (((x) << SOC_LPO_CAL_TEST_CONTROL_RTC_CYCLES_LSB) & SOC_LPO_CAL_TEST_CONTROL_RTC_CYCLES_MASK)

#define SOC_LPO_CAL_TEST_STATUS_ADDRESS          0x000000e8
#define SOC_LPO_CAL_TEST_STATUS_OFFSET           0x000000e8
#define SOC_LPO_CAL_TEST_STATUS_READY_MSB        16
#define SOC_LPO_CAL_TEST_STATUS_READY_LSB        16
#define SOC_LPO_CAL_TEST_STATUS_READY_MASK       0x00010000
#define SOC_LPO_CAL_TEST_STATUS_READY_GET(x)     (((x) & SOC_LPO_CAL_TEST_STATUS_READY_MASK) >> SOC_LPO_CAL_TEST_STATUS_READY_LSB)
#define SOC_LPO_CAL_TEST_STATUS_READY_SET(x)     (((x) << SOC_LPO_CAL_TEST_STATUS_READY_LSB) & SOC_LPO_CAL_TEST_STATUS_READY_MASK)
#define SOC_LPO_CAL_TEST_STATUS_COUNT_MSB        15
#define SOC_LPO_CAL_TEST_STATUS_COUNT_LSB        0
#define SOC_LPO_CAL_TEST_STATUS_COUNT_MASK       0x0000ffff
#define SOC_LPO_CAL_TEST_STATUS_COUNT_GET(x)     (((x) & SOC_LPO_CAL_TEST_STATUS_COUNT_MASK) >> SOC_LPO_CAL_TEST_STATUS_COUNT_LSB)
#define SOC_LPO_CAL_TEST_STATUS_COUNT_SET(x)     (((x) << SOC_LPO_CAL_TEST_STATUS_COUNT_LSB) & SOC_LPO_CAL_TEST_STATUS_COUNT_MASK)

#define LEGACY_SOC_CHIP_ID_ADDRESS               0x000000ec
#define LEGACY_SOC_CHIP_ID_OFFSET                0x000000ec
#define LEGACY_SOC_CHIP_ID_DEVICE_ID_MSB         31
#define LEGACY_SOC_CHIP_ID_DEVICE_ID_LSB         16
#define LEGACY_SOC_CHIP_ID_DEVICE_ID_MASK        0xffff0000
#define LEGACY_SOC_CHIP_ID_DEVICE_ID_GET(x)      (((x) & LEGACY_SOC_CHIP_ID_DEVICE_ID_MASK) >> LEGACY_SOC_CHIP_ID_DEVICE_ID_LSB)
#define LEGACY_SOC_CHIP_ID_DEVICE_ID_SET(x)      (((x) << LEGACY_SOC_CHIP_ID_DEVICE_ID_LSB) & LEGACY_SOC_CHIP_ID_DEVICE_ID_MASK)
#define LEGACY_SOC_CHIP_ID_CONFIG_ID_MSB         15
#define LEGACY_SOC_CHIP_ID_CONFIG_ID_LSB         4
#define LEGACY_SOC_CHIP_ID_CONFIG_ID_MASK        0x0000fff0
#define LEGACY_SOC_CHIP_ID_CONFIG_ID_GET(x)      (((x) & LEGACY_SOC_CHIP_ID_CONFIG_ID_MASK) >> LEGACY_SOC_CHIP_ID_CONFIG_ID_LSB)
#define LEGACY_SOC_CHIP_ID_CONFIG_ID_SET(x)      (((x) << LEGACY_SOC_CHIP_ID_CONFIG_ID_LSB) & LEGACY_SOC_CHIP_ID_CONFIG_ID_MASK)
#define LEGACY_SOC_CHIP_ID_VERSION_ID_MSB        3
#define LEGACY_SOC_CHIP_ID_VERSION_ID_LSB        0
#define LEGACY_SOC_CHIP_ID_VERSION_ID_MASK       0x0000000f
#define LEGACY_SOC_CHIP_ID_VERSION_ID_GET(x)     (((x) & LEGACY_SOC_CHIP_ID_VERSION_ID_MASK) >> LEGACY_SOC_CHIP_ID_VERSION_ID_LSB)
#define LEGACY_SOC_CHIP_ID_VERSION_ID_SET(x)     (((x) << LEGACY_SOC_CHIP_ID_VERSION_ID_LSB) & LEGACY_SOC_CHIP_ID_VERSION_ID_MASK)

#define SOC_CHIP_ID_ADDRESS                      0x000000f0
#define SOC_CHIP_ID_OFFSET                       0x000000f0
#define SOC_CHIP_ID_DEVICE_ID_MSB                31
#define SOC_CHIP_ID_DEVICE_ID_LSB                16
#define SOC_CHIP_ID_DEVICE_ID_MASK               0xffff0000
#define SOC_CHIP_ID_DEVICE_ID_GET(x)             (((x) & SOC_CHIP_ID_DEVICE_ID_MASK) >> SOC_CHIP_ID_DEVICE_ID_LSB)
#define SOC_CHIP_ID_DEVICE_ID_SET(x)             (((x) << SOC_CHIP_ID_DEVICE_ID_LSB) & SOC_CHIP_ID_DEVICE_ID_MASK)
#define SOC_CHIP_ID_CONFIG_ID_MSB                15
#define SOC_CHIP_ID_CONFIG_ID_LSB                4
#define SOC_CHIP_ID_CONFIG_ID_MASK               0x0000fff0
#define SOC_CHIP_ID_CONFIG_ID_GET(x)             (((x) & SOC_CHIP_ID_CONFIG_ID_MASK) >> SOC_CHIP_ID_CONFIG_ID_LSB)
#define SOC_CHIP_ID_CONFIG_ID_SET(x)             (((x) << SOC_CHIP_ID_CONFIG_ID_LSB) & SOC_CHIP_ID_CONFIG_ID_MASK)
#define SOC_CHIP_ID_VERSION_ID_MSB               3
#define SOC_CHIP_ID_VERSION_ID_LSB               0
#define SOC_CHIP_ID_VERSION_ID_MASK              0x0000000f
#define SOC_CHIP_ID_VERSION_ID_GET(x)            (((x) & SOC_CHIP_ID_VERSION_ID_MASK) >> SOC_CHIP_ID_VERSION_ID_LSB)
#define SOC_CHIP_ID_VERSION_ID_SET(x)            (((x) << SOC_CHIP_ID_VERSION_ID_LSB) & SOC_CHIP_ID_VERSION_ID_MASK)

#define SOC_POWER_REG_ADDRESS                    0x0000010c
#define SOC_POWER_REG_OFFSET                     0x0000010c
#define SOC_POWER_REG_SWREG_VS_EN_MSB            17
#define SOC_POWER_REG_SWREG_VS_EN_LSB            17
#define SOC_POWER_REG_SWREG_VS_EN_MASK           0x00020000
#define SOC_POWER_REG_SWREG_VS_EN_GET(x)         (((x) & SOC_POWER_REG_SWREG_VS_EN_MASK) >> SOC_POWER_REG_SWREG_VS_EN_LSB)
#define SOC_POWER_REG_SWREG_VS_EN_SET(x)         (((x) << SOC_POWER_REG_SWREG_VS_EN_LSB) & SOC_POWER_REG_SWREG_VS_EN_MASK)
#define SOC_POWER_REG_DISCON_MODE_EN_MSB         16
#define SOC_POWER_REG_DISCON_MODE_EN_LSB         16
#define SOC_POWER_REG_DISCON_MODE_EN_MASK        0x00010000
#define SOC_POWER_REG_DISCON_MODE_EN_GET(x)      (((x) & SOC_POWER_REG_DISCON_MODE_EN_MASK) >> SOC_POWER_REG_DISCON_MODE_EN_LSB)
#define SOC_POWER_REG_DISCON_MODE_EN_SET(x)      (((x) << SOC_POWER_REG_DISCON_MODE_EN_LSB) & SOC_POWER_REG_DISCON_MODE_EN_MASK)
#define SOC_POWER_REG_DEEP_SLEEP_EN_MSB          15
#define SOC_POWER_REG_DEEP_SLEEP_EN_LSB          15
#define SOC_POWER_REG_DEEP_SLEEP_EN_MASK         0x00008000
#define SOC_POWER_REG_DEEP_SLEEP_EN_GET(x)       (((x) & SOC_POWER_REG_DEEP_SLEEP_EN_MASK) >> SOC_POWER_REG_DEEP_SLEEP_EN_LSB)
#define SOC_POWER_REG_DEEP_SLEEP_EN_SET(x)       (((x) << SOC_POWER_REG_DEEP_SLEEP_EN_LSB) & SOC_POWER_REG_DEEP_SLEEP_EN_MASK)
#define SOC_POWER_REG_DEBUG_EN_MSB               14
#define SOC_POWER_REG_DEBUG_EN_LSB               14
#define SOC_POWER_REG_DEBUG_EN_MASK              0x00004000
#define SOC_POWER_REG_DEBUG_EN_GET(x)            (((x) & SOC_POWER_REG_DEBUG_EN_MASK) >> SOC_POWER_REG_DEBUG_EN_LSB)
#define SOC_POWER_REG_DEBUG_EN_SET(x)            (((x) << SOC_POWER_REG_DEBUG_EN_LSB) & SOC_POWER_REG_DEBUG_EN_MASK)
#define SOC_POWER_REG_WLAN_BB_PWD_EN_MSB         13
#define SOC_POWER_REG_WLAN_BB_PWD_EN_LSB         13
#define SOC_POWER_REG_WLAN_BB_PWD_EN_MASK        0x00002000
#define SOC_POWER_REG_WLAN_BB_PWD_EN_GET(x)      (((x) & SOC_POWER_REG_WLAN_BB_PWD_EN_MASK) >> SOC_POWER_REG_WLAN_BB_PWD_EN_LSB)
#define SOC_POWER_REG_WLAN_BB_PWD_EN_SET(x)      (((x) << SOC_POWER_REG_WLAN_BB_PWD_EN_LSB) & SOC_POWER_REG_WLAN_BB_PWD_EN_MASK)
#define SOC_POWER_REG_WLAN_MAC_PWD_EN_MSB        12
#define SOC_POWER_REG_WLAN_MAC_PWD_EN_LSB        12
#define SOC_POWER_REG_WLAN_MAC_PWD_EN_MASK       0x00001000
#define SOC_POWER_REG_WLAN_MAC_PWD_EN_GET(x)     (((x) & SOC_POWER_REG_WLAN_MAC_PWD_EN_MASK) >> SOC_POWER_REG_WLAN_MAC_PWD_EN_LSB)
#define SOC_POWER_REG_WLAN_MAC_PWD_EN_SET(x)     (((x) << SOC_POWER_REG_WLAN_MAC_PWD_EN_LSB) & SOC_POWER_REG_WLAN_MAC_PWD_EN_MASK)
#define SOC_POWER_REG_CPU_INT_ENABLE_MSB         7
#define SOC_POWER_REG_CPU_INT_ENABLE_LSB         7
#define SOC_POWER_REG_CPU_INT_ENABLE_MASK        0x00000080
#define SOC_POWER_REG_CPU_INT_ENABLE_GET(x)      (((x) & SOC_POWER_REG_CPU_INT_ENABLE_MASK) >> SOC_POWER_REG_CPU_INT_ENABLE_LSB)
#define SOC_POWER_REG_CPU_INT_ENABLE_SET(x)      (((x) << SOC_POWER_REG_CPU_INT_ENABLE_LSB) & SOC_POWER_REG_CPU_INT_ENABLE_MASK)
#define SOC_POWER_REG_RADIO_PWD_EN_MSB           4
#define SOC_POWER_REG_RADIO_PWD_EN_LSB           4
#define SOC_POWER_REG_RADIO_PWD_EN_MASK          0x00000010
#define SOC_POWER_REG_RADIO_PWD_EN_GET(x)        (((x) & SOC_POWER_REG_RADIO_PWD_EN_MASK) >> SOC_POWER_REG_RADIO_PWD_EN_LSB)
#define SOC_POWER_REG_RADIO_PWD_EN_SET(x)        (((x) << SOC_POWER_REG_RADIO_PWD_EN_LSB) & SOC_POWER_REG_RADIO_PWD_EN_MASK)
#define SOC_POWER_REG_WLAN_PWD_EN_MSB            1
#define SOC_POWER_REG_WLAN_PWD_EN_LSB            1
#define SOC_POWER_REG_WLAN_PWD_EN_MASK           0x00000002
#define SOC_POWER_REG_WLAN_PWD_EN_GET(x)         (((x) & SOC_POWER_REG_WLAN_PWD_EN_MASK) >> SOC_POWER_REG_WLAN_PWD_EN_LSB)
#define SOC_POWER_REG_WLAN_PWD_EN_SET(x)         (((x) << SOC_POWER_REG_WLAN_PWD_EN_LSB) & SOC_POWER_REG_WLAN_PWD_EN_MASK)
#define SOC_POWER_REG_POWER_EN_MSB               0
#define SOC_POWER_REG_POWER_EN_LSB               0
#define SOC_POWER_REG_POWER_EN_MASK              0x00000001
#define SOC_POWER_REG_POWER_EN_GET(x)            (((x) & SOC_POWER_REG_POWER_EN_MASK) >> SOC_POWER_REG_POWER_EN_LSB)
#define SOC_POWER_REG_POWER_EN_SET(x)            (((x) << SOC_POWER_REG_POWER_EN_LSB) & SOC_POWER_REG_POWER_EN_MASK)

#define SOC_CORE_CLK_CTRL_ADDRESS                0x00000110
#define SOC_CORE_CLK_CTRL_OFFSET                 0x00000110
#define SOC_CORE_CLK_CTRL_DIV_MSB                2
#define SOC_CORE_CLK_CTRL_DIV_LSB                0
#define SOC_CORE_CLK_CTRL_DIV_MASK               0x00000007
#define SOC_CORE_CLK_CTRL_DIV_GET(x)             (((x) & SOC_CORE_CLK_CTRL_DIV_MASK) >> SOC_CORE_CLK_CTRL_DIV_LSB)
#define SOC_CORE_CLK_CTRL_DIV_SET(x)             (((x) << SOC_CORE_CLK_CTRL_DIV_LSB) & SOC_CORE_CLK_CTRL_DIV_MASK)

#define SOC_GPIO_WAKEUP_CONTROL_ADDRESS          0x00000114
#define SOC_GPIO_WAKEUP_CONTROL_OFFSET           0x00000114
#define SOC_GPIO_WAKEUP_CONTROL_ENABLE_MSB       0
#define SOC_GPIO_WAKEUP_CONTROL_ENABLE_LSB       0
#define SOC_GPIO_WAKEUP_CONTROL_ENABLE_MASK      0x00000001
#define SOC_GPIO_WAKEUP_CONTROL_ENABLE_GET(x)    (((x) & SOC_GPIO_WAKEUP_CONTROL_ENABLE_MASK) >> SOC_GPIO_WAKEUP_CONTROL_ENABLE_LSB)
#define SOC_GPIO_WAKEUP_CONTROL_ENABLE_SET(x)    (((x) << SOC_GPIO_WAKEUP_CONTROL_ENABLE_LSB) & SOC_GPIO_WAKEUP_CONTROL_ENABLE_MASK)

#define SLEEP_RETENTION_ADDRESS                  0x00000214
#define SLEEP_RETENTION_OFFSET                   0x00000214
#define SLEEP_RETENTION_GREEN_SAVE_MSB           10
#define SLEEP_RETENTION_GREEN_SAVE_LSB           10
#define SLEEP_RETENTION_GREEN_SAVE_MASK          0x00000400
#define SLEEP_RETENTION_GREEN_SAVE_GET(x)        (((x) & SLEEP_RETENTION_GREEN_SAVE_MASK) >> SLEEP_RETENTION_GREEN_SAVE_LSB)
#define SLEEP_RETENTION_GREEN_SAVE_SET(x)        (((x) << SLEEP_RETENTION_GREEN_SAVE_LSB) & SLEEP_RETENTION_GREEN_SAVE_MASK)
#define SLEEP_RETENTION_TIME_MSB                 9
#define SLEEP_RETENTION_TIME_LSB                 2
#define SLEEP_RETENTION_TIME_MASK                0x000003fc
#define SLEEP_RETENTION_TIME_GET(x)              (((x) & SLEEP_RETENTION_TIME_MASK) >> SLEEP_RETENTION_TIME_LSB)
#define SLEEP_RETENTION_TIME_SET(x)              (((x) << SLEEP_RETENTION_TIME_LSB) & SLEEP_RETENTION_TIME_MASK)
#define SLEEP_RETENTION_MODE_MSB                 1
#define SLEEP_RETENTION_MODE_LSB                 1
#define SLEEP_RETENTION_MODE_MASK                0x00000002
#define SLEEP_RETENTION_MODE_GET(x)              (((x) & SLEEP_RETENTION_MODE_MASK) >> SLEEP_RETENTION_MODE_LSB)
#define SLEEP_RETENTION_MODE_SET(x)              (((x) << SLEEP_RETENTION_MODE_LSB) & SLEEP_RETENTION_MODE_MASK)
#define SLEEP_RETENTION_ENABLE_MSB               0
#define SLEEP_RETENTION_ENABLE_LSB               0
#define SLEEP_RETENTION_ENABLE_MASK              0x00000001
#define SLEEP_RETENTION_ENABLE_GET(x)            (((x) & SLEEP_RETENTION_ENABLE_MASK) >> SLEEP_RETENTION_ENABLE_LSB)
#define SLEEP_RETENTION_ENABLE_SET(x)            (((x) << SLEEP_RETENTION_ENABLE_LSB) & SLEEP_RETENTION_ENABLE_MASK)

#define LP_PERF_COUNTER_ADDRESS                  0x00000284
#define LP_PERF_COUNTER_OFFSET                   0x00000284
#define LP_PERF_COUNTER_EN_MSB                   0
#define LP_PERF_COUNTER_EN_LSB                   0
#define LP_PERF_COUNTER_EN_MASK                  0x00000001
#define LP_PERF_COUNTER_EN_GET(x)                (((x) & LP_PERF_COUNTER_EN_MASK) >> LP_PERF_COUNTER_EN_LSB)
#define LP_PERF_COUNTER_EN_SET(x)                (((x) << LP_PERF_COUNTER_EN_LSB) & LP_PERF_COUNTER_EN_MASK)

#define LP_PERF_LIGHT_SLEEP_ADDRESS              0x00000288
#define LP_PERF_LIGHT_SLEEP_OFFSET               0x00000288
#define LP_PERF_LIGHT_SLEEP_CNT_MSB              31
#define LP_PERF_LIGHT_SLEEP_CNT_LSB              0
#define LP_PERF_LIGHT_SLEEP_CNT_MASK             0xffffffff
#define LP_PERF_LIGHT_SLEEP_CNT_GET(x)           (((x) & LP_PERF_LIGHT_SLEEP_CNT_MASK) >> LP_PERF_LIGHT_SLEEP_CNT_LSB)
#define LP_PERF_LIGHT_SLEEP_CNT_SET(x)           (((x) << LP_PERF_LIGHT_SLEEP_CNT_LSB) & LP_PERF_LIGHT_SLEEP_CNT_MASK)

#define LP_PERF_DEEP_SLEEP_ADDRESS               0x0000028c
#define LP_PERF_DEEP_SLEEP_OFFSET                0x0000028c
#define LP_PERF_DEEP_SLEEP_CNT_MSB               31
#define LP_PERF_DEEP_SLEEP_CNT_LSB               0
#define LP_PERF_DEEP_SLEEP_CNT_MASK              0xffffffff
#define LP_PERF_DEEP_SLEEP_CNT_GET(x)            (((x) & LP_PERF_DEEP_SLEEP_CNT_MASK) >> LP_PERF_DEEP_SLEEP_CNT_LSB)
#define LP_PERF_DEEP_SLEEP_CNT_SET(x)            (((x) << LP_PERF_DEEP_SLEEP_CNT_LSB) & LP_PERF_DEEP_SLEEP_CNT_MASK)

#define LP_PERF_ON_ADDRESS                       0x00000290
#define LP_PERF_ON_OFFSET                        0x00000290
#define LP_PERF_ON_CNT_MSB                       31
#define LP_PERF_ON_CNT_LSB                       0
#define LP_PERF_ON_CNT_MASK                      0xffffffff
#define LP_PERF_ON_CNT_GET(x)                    (((x) & LP_PERF_ON_CNT_MASK) >> LP_PERF_ON_CNT_LSB)
#define LP_PERF_ON_CNT_SET(x)                    (((x) << LP_PERF_ON_CNT_LSB) & LP_PERF_ON_CNT_MASK)

#define CHIP_MODE_ADDRESS                        0x000002a8
#define CHIP_MODE_OFFSET                         0x000002a8
#define CHIP_MODE_BIT_MSB                        1
#define CHIP_MODE_BIT_LSB                        0
#define CHIP_MODE_BIT_MASK                       0x00000003
#define CHIP_MODE_BIT_GET(x)                     (((x) & CHIP_MODE_BIT_MASK) >> CHIP_MODE_BIT_LSB)
#define CHIP_MODE_BIT_SET(x)                     (((x) << CHIP_MODE_BIT_LSB) & CHIP_MODE_BIT_MASK)

#define CLK_REQ_FALL_EDGE_ADDRESS                0x000002ac
#define CLK_REQ_FALL_EDGE_OFFSET                 0x000002ac
#define CLK_REQ_FALL_EDGE_EN_MSB                 31
#define CLK_REQ_FALL_EDGE_EN_LSB                 31
#define CLK_REQ_FALL_EDGE_EN_MASK                0x80000000
#define CLK_REQ_FALL_EDGE_EN_GET(x)              (((x) & CLK_REQ_FALL_EDGE_EN_MASK) >> CLK_REQ_FALL_EDGE_EN_LSB)
#define CLK_REQ_FALL_EDGE_EN_SET(x)              (((x) << CLK_REQ_FALL_EDGE_EN_LSB) & CLK_REQ_FALL_EDGE_EN_MASK)
#define CLK_REQ_FALL_EDGE_DELAY_MSB              7
#define CLK_REQ_FALL_EDGE_DELAY_LSB              0
#define CLK_REQ_FALL_EDGE_DELAY_MASK             0x000000ff
#define CLK_REQ_FALL_EDGE_DELAY_GET(x)           (((x) & CLK_REQ_FALL_EDGE_DELAY_MASK) >> CLK_REQ_FALL_EDGE_DELAY_LSB)
#define CLK_REQ_FALL_EDGE_DELAY_SET(x)           (((x) << CLK_REQ_FALL_EDGE_DELAY_LSB) & CLK_REQ_FALL_EDGE_DELAY_MASK)

#define OTP_ADDRESS                              0x000002b0
#define OTP_OFFSET                               0x000002b0
#define OTP_LDO25_EN_MSB                         1
#define OTP_LDO25_EN_LSB                         1
#define OTP_LDO25_EN_MASK                        0x00000002
#define OTP_LDO25_EN_GET(x)                      (((x) & OTP_LDO25_EN_MASK) >> OTP_LDO25_EN_LSB)
#define OTP_LDO25_EN_SET(x)                      (((x) << OTP_LDO25_EN_LSB) & OTP_LDO25_EN_MASK)
#define OTP_VDD12_EN_MSB                         0
#define OTP_VDD12_EN_LSB                         0
#define OTP_VDD12_EN_MASK                        0x00000001
#define OTP_VDD12_EN_GET(x)                      (((x) & OTP_VDD12_EN_MASK) >> OTP_VDD12_EN_LSB)
#define OTP_VDD12_EN_SET(x)                      (((x) << OTP_VDD12_EN_LSB) & OTP_VDD12_EN_MASK)

#define OTP_STATUS_ADDRESS                       0x000002b4
#define OTP_STATUS_OFFSET                        0x000002b4
#define OTP_STATUS_LDO25_EN_READY_MSB            1
#define OTP_STATUS_LDO25_EN_READY_LSB            1
#define OTP_STATUS_LDO25_EN_READY_MASK           0x00000002
#define OTP_STATUS_LDO25_EN_READY_GET(x)         (((x) & OTP_STATUS_LDO25_EN_READY_MASK) >> OTP_STATUS_LDO25_EN_READY_LSB)
#define OTP_STATUS_LDO25_EN_READY_SET(x)         (((x) << OTP_STATUS_LDO25_EN_READY_LSB) & OTP_STATUS_LDO25_EN_READY_MASK)
#define OTP_STATUS_VDD12_EN_READY_MSB            0
#define OTP_STATUS_VDD12_EN_READY_LSB            0
#define OTP_STATUS_VDD12_EN_READY_MASK           0x00000001
#define OTP_STATUS_VDD12_EN_READY_GET(x)         (((x) & OTP_STATUS_VDD12_EN_READY_MASK) >> OTP_STATUS_VDD12_EN_READY_LSB)
#define OTP_STATUS_VDD12_EN_READY_SET(x)         (((x) << OTP_STATUS_VDD12_EN_READY_LSB) & OTP_STATUS_VDD12_EN_READY_MASK)

#define PMU_ADDRESS                              0x000002b8
#define PMU_OFFSET                               0x000002b8
#define PMU_REG_WAKEUP_TIME_SEL_MSB              1
#define PMU_REG_WAKEUP_TIME_SEL_LSB              0
#define PMU_REG_WAKEUP_TIME_SEL_MASK             0x00000003
#define PMU_REG_WAKEUP_TIME_SEL_GET(x)           (((x) & PMU_REG_WAKEUP_TIME_SEL_MASK) >> PMU_REG_WAKEUP_TIME_SEL_LSB)
#define PMU_REG_WAKEUP_TIME_SEL_SET(x)           (((x) << PMU_REG_WAKEUP_TIME_SEL_LSB) & PMU_REG_WAKEUP_TIME_SEL_MASK)

#define PMU_CONFIG_ADDRESS                       0x000002bc
#define PMU_CONFIG_OFFSET                        0x000002bc
#define PMU_CONFIG_VALUE_MSB                     4
#define PMU_CONFIG_VALUE_LSB                     0
#define PMU_CONFIG_VALUE_MASK                    0x0000001f
#define PMU_CONFIG_VALUE_GET(x)                  (((x) & PMU_CONFIG_VALUE_MASK) >> PMU_CONFIG_VALUE_LSB)
#define PMU_CONFIG_VALUE_SET(x)                  (((x) << PMU_CONFIG_VALUE_LSB) & PMU_CONFIG_VALUE_MASK)

#define PMU_PAREG_ADDRESS                        0x000002c0
#define PMU_PAREG_OFFSET                         0x000002c0
#define PMU_PAREG_LVL_CTR_MSB                    2
#define PMU_PAREG_LVL_CTR_LSB                    0
#define PMU_PAREG_LVL_CTR_MASK                   0x00000007
#define PMU_PAREG_LVL_CTR_GET(x)                 (((x) & PMU_PAREG_LVL_CTR_MASK) >> PMU_PAREG_LVL_CTR_LSB)
#define PMU_PAREG_LVL_CTR_SET(x)                 (((x) << PMU_PAREG_LVL_CTR_LSB) & PMU_PAREG_LVL_CTR_MASK)

#define PMU_BYPASS_ADDRESS                       0x000002c4
#define PMU_BYPASS_OFFSET                        0x000002c4
#define PMU_BYPASS_SWREG_MSB                     1
#define PMU_BYPASS_SWREG_LSB                     1
#define PMU_BYPASS_SWREG_MASK                    0x00000002
#define PMU_BYPASS_SWREG_GET(x)                  (((x) & PMU_BYPASS_SWREG_MASK) >> PMU_BYPASS_SWREG_LSB)
#define PMU_BYPASS_SWREG_SET(x)                  (((x) << PMU_BYPASS_SWREG_LSB) & PMU_BYPASS_SWREG_MASK)
#define PMU_BYPASS_PAREG_MSB                     0
#define PMU_BYPASS_PAREG_LSB                     0
#define PMU_BYPASS_PAREG_MASK                    0x00000001
#define PMU_BYPASS_PAREG_GET(x)                  (((x) & PMU_BYPASS_PAREG_MASK) >> PMU_BYPASS_PAREG_LSB)
#define PMU_BYPASS_PAREG_SET(x)                  (((x) << PMU_BYPASS_PAREG_LSB) & PMU_BYPASS_PAREG_MASK)

#define THERM_CTRL1_ADDRESS                      0x000002dc
#define THERM_CTRL1_OFFSET                       0x000002dc
#define THERM_CTRL1_BYPASS_MSB                   16
#define THERM_CTRL1_BYPASS_LSB                   16
#define THERM_CTRL1_BYPASS_MASK                  0x00010000
#define THERM_CTRL1_BYPASS_GET(x)                (((x) & THERM_CTRL1_BYPASS_MASK) >> THERM_CTRL1_BYPASS_LSB)
#define THERM_CTRL1_BYPASS_SET(x)                (((x) << THERM_CTRL1_BYPASS_LSB) & THERM_CTRL1_BYPASS_MASK)
#define THERM_CTRL1_WIDTH_ARBITOR_MSB            15
#define THERM_CTRL1_WIDTH_ARBITOR_LSB            12
#define THERM_CTRL1_WIDTH_ARBITOR_MASK           0x0000f000
#define THERM_CTRL1_WIDTH_ARBITOR_GET(x)         (((x) & THERM_CTRL1_WIDTH_ARBITOR_MASK) >> THERM_CTRL1_WIDTH_ARBITOR_LSB)
#define THERM_CTRL1_WIDTH_ARBITOR_SET(x)         (((x) << THERM_CTRL1_WIDTH_ARBITOR_LSB) & THERM_CTRL1_WIDTH_ARBITOR_MASK)
#define THERM_CTRL1_WIDTH_MSB                    11
#define THERM_CTRL1_WIDTH_LSB                    5
#define THERM_CTRL1_WIDTH_MASK                   0x00000fe0
#define THERM_CTRL1_WIDTH_GET(x)                 (((x) & THERM_CTRL1_WIDTH_MASK) >> THERM_CTRL1_WIDTH_LSB)
#define THERM_CTRL1_WIDTH_SET(x)                 (((x) << THERM_CTRL1_WIDTH_LSB) & THERM_CTRL1_WIDTH_MASK)
#define THERM_CTRL1_TYPE_MSB                     4
#define THERM_CTRL1_TYPE_LSB                     3
#define THERM_CTRL1_TYPE_MASK                    0x00000018
#define THERM_CTRL1_TYPE_GET(x)                  (((x) & THERM_CTRL1_TYPE_MASK) >> THERM_CTRL1_TYPE_LSB)
#define THERM_CTRL1_TYPE_SET(x)                  (((x) << THERM_CTRL1_TYPE_LSB) & THERM_CTRL1_TYPE_MASK)
#define THERM_CTRL1_MEASURE_MSB                  2
#define THERM_CTRL1_MEASURE_LSB                  2
#define THERM_CTRL1_MEASURE_MASK                 0x00000004
#define THERM_CTRL1_MEASURE_GET(x)               (((x) & THERM_CTRL1_MEASURE_MASK) >> THERM_CTRL1_MEASURE_LSB)
#define THERM_CTRL1_MEASURE_SET(x)               (((x) << THERM_CTRL1_MEASURE_LSB) & THERM_CTRL1_MEASURE_MASK)
#define THERM_CTRL1_INT_EN_MSB                   1
#define THERM_CTRL1_INT_EN_LSB                   1
#define THERM_CTRL1_INT_EN_MASK                  0x00000002
#define THERM_CTRL1_INT_EN_GET(x)                (((x) & THERM_CTRL1_INT_EN_MASK) >> THERM_CTRL1_INT_EN_LSB)
#define THERM_CTRL1_INT_EN_SET(x)                (((x) << THERM_CTRL1_INT_EN_LSB) & THERM_CTRL1_INT_EN_MASK)
#define THERM_CTRL1_INT_STATUS_MSB               0
#define THERM_CTRL1_INT_STATUS_LSB               0
#define THERM_CTRL1_INT_STATUS_MASK              0x00000001
#define THERM_CTRL1_INT_STATUS_GET(x)            (((x) & THERM_CTRL1_INT_STATUS_MASK) >> THERM_CTRL1_INT_STATUS_LSB)
#define THERM_CTRL1_INT_STATUS_SET(x)            (((x) << THERM_CTRL1_INT_STATUS_LSB) & THERM_CTRL1_INT_STATUS_MASK)

#define THERM_CTRL2_ADDRESS                      0x000002e0
#define THERM_CTRL2_OFFSET                       0x000002e0
#define THERM_CTRL2_ADC_OFF_MSB                  25
#define THERM_CTRL2_ADC_OFF_LSB                  25
#define THERM_CTRL2_ADC_OFF_MASK                 0x02000000
#define THERM_CTRL2_ADC_OFF_GET(x)               (((x) & THERM_CTRL2_ADC_OFF_MASK) >> THERM_CTRL2_ADC_OFF_LSB)
#define THERM_CTRL2_ADC_OFF_SET(x)               (((x) << THERM_CTRL2_ADC_OFF_LSB) & THERM_CTRL2_ADC_OFF_MASK)
#define THERM_CTRL2_ADC_ON_MSB                   24
#define THERM_CTRL2_ADC_ON_LSB                   24
#define THERM_CTRL2_ADC_ON_MASK                  0x01000000
#define THERM_CTRL2_ADC_ON_GET(x)                (((x) & THERM_CTRL2_ADC_ON_MASK) >> THERM_CTRL2_ADC_ON_LSB)
#define THERM_CTRL2_ADC_ON_SET(x)                (((x) << THERM_CTRL2_ADC_ON_LSB) & THERM_CTRL2_ADC_ON_MASK)
#define THERM_CTRL2_SAMPLE_MSB                   23
#define THERM_CTRL2_SAMPLE_LSB                   16
#define THERM_CTRL2_SAMPLE_MASK                  0x00ff0000
#define THERM_CTRL2_SAMPLE_GET(x)                (((x) & THERM_CTRL2_SAMPLE_MASK) >> THERM_CTRL2_SAMPLE_LSB)
#define THERM_CTRL2_SAMPLE_SET(x)                (((x) << THERM_CTRL2_SAMPLE_LSB) & THERM_CTRL2_SAMPLE_MASK)
#define THERM_CTRL2_HIGH_MSB                     15
#define THERM_CTRL2_HIGH_LSB                     8
#define THERM_CTRL2_HIGH_MASK                    0x0000ff00
#define THERM_CTRL2_HIGH_GET(x)                  (((x) & THERM_CTRL2_HIGH_MASK) >> THERM_CTRL2_HIGH_LSB)
#define THERM_CTRL2_HIGH_SET(x)                  (((x) << THERM_CTRL2_HIGH_LSB) & THERM_CTRL2_HIGH_MASK)
#define THERM_CTRL2_LOW_MSB                      7
#define THERM_CTRL2_LOW_LSB                      0
#define THERM_CTRL2_LOW_MASK                     0x000000ff
#define THERM_CTRL2_LOW_GET(x)                   (((x) & THERM_CTRL2_LOW_MASK) >> THERM_CTRL2_LOW_LSB)
#define THERM_CTRL2_LOW_SET(x)                   (((x) << THERM_CTRL2_LOW_LSB) & THERM_CTRL2_LOW_MASK)

#define THERM_CTRL3_ADDRESS                      0x000002e4
#define THERM_CTRL3_OFFSET                       0x000002e4
#define THERM_CTRL3_ADC_GAIN_MSB                 16
#define THERM_CTRL3_ADC_GAIN_LSB                 8
#define THERM_CTRL3_ADC_GAIN_MASK                0x0001ff00
#define THERM_CTRL3_ADC_GAIN_GET(x)              (((x) & THERM_CTRL3_ADC_GAIN_MASK) >> THERM_CTRL3_ADC_GAIN_LSB)
#define THERM_CTRL3_ADC_GAIN_SET(x)              (((x) << THERM_CTRL3_ADC_GAIN_LSB) & THERM_CTRL3_ADC_GAIN_MASK)
#define THERM_CTRL3_ADC_OFFSET_MSB               7
#define THERM_CTRL3_ADC_OFFSET_LSB               0
#define THERM_CTRL3_ADC_OFFSET_MASK              0x000000ff
#define THERM_CTRL3_ADC_OFFSET_GET(x)            (((x) & THERM_CTRL3_ADC_OFFSET_MASK) >> THERM_CTRL3_ADC_OFFSET_LSB)
#define THERM_CTRL3_ADC_OFFSET_SET(x)            (((x) << THERM_CTRL3_ADC_OFFSET_LSB) & THERM_CTRL3_ADC_OFFSET_MASK)

#define LISTEN_MODE1_ADDRESS                     0x000002e8
#define LISTEN_MODE1_OFFSET                      0x000002e8
#define LISTEN_MODE1_TIMER_CLEAR_MSB             19
#define LISTEN_MODE1_TIMER_CLEAR_LSB             19
#define LISTEN_MODE1_TIMER_CLEAR_MASK            0x00080000
#define LISTEN_MODE1_TIMER_CLEAR_GET(x)          (((x) & LISTEN_MODE1_TIMER_CLEAR_MASK) >> LISTEN_MODE1_TIMER_CLEAR_LSB)
#define LISTEN_MODE1_TIMER_CLEAR_SET(x)          (((x) << LISTEN_MODE1_TIMER_CLEAR_LSB) & LISTEN_MODE1_TIMER_CLEAR_MASK)
#define LISTEN_MODE1_TIMER_THRESH_WAKE_MSB       18
#define LISTEN_MODE1_TIMER_THRESH_WAKE_LSB       3
#define LISTEN_MODE1_TIMER_THRESH_WAKE_MASK      0x0007fff8
#define LISTEN_MODE1_TIMER_THRESH_WAKE_GET(x)    (((x) & LISTEN_MODE1_TIMER_THRESH_WAKE_MASK) >> LISTEN_MODE1_TIMER_THRESH_WAKE_LSB)
#define LISTEN_MODE1_TIMER_THRESH_WAKE_SET(x)    (((x) << LISTEN_MODE1_TIMER_THRESH_WAKE_LSB) & LISTEN_MODE1_TIMER_THRESH_WAKE_MASK)
#define LISTEN_MODE1_TIMER_OVERFLOW_WAKE_MSB     2
#define LISTEN_MODE1_TIMER_OVERFLOW_WAKE_LSB     2
#define LISTEN_MODE1_TIMER_OVERFLOW_WAKE_MASK    0x00000004
#define LISTEN_MODE1_TIMER_OVERFLOW_WAKE_GET(x)  (((x) & LISTEN_MODE1_TIMER_OVERFLOW_WAKE_MASK) >> LISTEN_MODE1_TIMER_OVERFLOW_WAKE_LSB)
#define LISTEN_MODE1_TIMER_OVERFLOW_WAKE_SET(x)  (((x) << LISTEN_MODE1_TIMER_OVERFLOW_WAKE_LSB) & LISTEN_MODE1_TIMER_OVERFLOW_WAKE_MASK)
#define LISTEN_MODE1_CLOCK_GATE_MSB              1
#define LISTEN_MODE1_CLOCK_GATE_LSB              1
#define LISTEN_MODE1_CLOCK_GATE_MASK             0x00000002
#define LISTEN_MODE1_CLOCK_GATE_GET(x)           (((x) & LISTEN_MODE1_CLOCK_GATE_MASK) >> LISTEN_MODE1_CLOCK_GATE_LSB)
#define LISTEN_MODE1_CLOCK_GATE_SET(x)           (((x) << LISTEN_MODE1_CLOCK_GATE_LSB) & LISTEN_MODE1_CLOCK_GATE_MASK)
#define LISTEN_MODE1_ENABLE_MSB                  0
#define LISTEN_MODE1_ENABLE_LSB                  0
#define LISTEN_MODE1_ENABLE_MASK                 0x00000001
#define LISTEN_MODE1_ENABLE_GET(x)               (((x) & LISTEN_MODE1_ENABLE_MASK) >> LISTEN_MODE1_ENABLE_LSB)
#define LISTEN_MODE1_ENABLE_SET(x)               (((x) << LISTEN_MODE1_ENABLE_LSB) & LISTEN_MODE1_ENABLE_MASK)

#define LISTEN_MODE2_ADDRESS                     0x000002ec
#define LISTEN_MODE2_OFFSET                      0x000002ec
#define LISTEN_MODE2_TIMER_TRIGGER_WAKE_MSB      15
#define LISTEN_MODE2_TIMER_TRIGGER_WAKE_LSB      0
#define LISTEN_MODE2_TIMER_TRIGGER_WAKE_MASK     0x0000ffff
#define LISTEN_MODE2_TIMER_TRIGGER_WAKE_GET(x)   (((x) & LISTEN_MODE2_TIMER_TRIGGER_WAKE_MASK) >> LISTEN_MODE2_TIMER_TRIGGER_WAKE_LSB)
#define LISTEN_MODE2_TIMER_TRIGGER_WAKE_SET(x)   (((x) << LISTEN_MODE2_TIMER_TRIGGER_WAKE_LSB) & LISTEN_MODE2_TIMER_TRIGGER_WAKE_MASK)

#define AUDIO_PLL_CONFIG_ADDRESS                 0x000002f0
#define AUDIO_PLL_CONFIG_OFFSET                  0x000002f0
#define AUDIO_PLL_CONFIG_UPDATING_MSB            31
#define AUDIO_PLL_CONFIG_UPDATING_LSB            31
#define AUDIO_PLL_CONFIG_UPDATING_MASK           0x80000000
#define AUDIO_PLL_CONFIG_UPDATING_GET(x)         (((x) & AUDIO_PLL_CONFIG_UPDATING_MASK) >> AUDIO_PLL_CONFIG_UPDATING_LSB)
#define AUDIO_PLL_CONFIG_UPDATING_SET(x)         (((x) << AUDIO_PLL_CONFIG_UPDATING_LSB) & AUDIO_PLL_CONFIG_UPDATING_MASK)
#define AUDIO_PLL_CONFIG_EXT_DIV_MSB             14
#define AUDIO_PLL_CONFIG_EXT_DIV_LSB             12
#define AUDIO_PLL_CONFIG_EXT_DIV_MASK            0x00007000
#define AUDIO_PLL_CONFIG_EXT_DIV_GET(x)          (((x) & AUDIO_PLL_CONFIG_EXT_DIV_MASK) >> AUDIO_PLL_CONFIG_EXT_DIV_LSB)
#define AUDIO_PLL_CONFIG_EXT_DIV_SET(x)          (((x) << AUDIO_PLL_CONFIG_EXT_DIV_LSB) & AUDIO_PLL_CONFIG_EXT_DIV_MASK)
#define AUDIO_PLL_CONFIG_POSTPLLDIV_MSB          9
#define AUDIO_PLL_CONFIG_POSTPLLDIV_LSB          7
#define AUDIO_PLL_CONFIG_POSTPLLDIV_MASK         0x00000380
#define AUDIO_PLL_CONFIG_POSTPLLDIV_GET(x)       (((x) & AUDIO_PLL_CONFIG_POSTPLLDIV_MASK) >> AUDIO_PLL_CONFIG_POSTPLLDIV_LSB)
#define AUDIO_PLL_CONFIG_POSTPLLDIV_SET(x)       (((x) << AUDIO_PLL_CONFIG_POSTPLLDIV_LSB) & AUDIO_PLL_CONFIG_POSTPLLDIV_MASK)
#define AUDIO_PLL_CONFIG_PLLPWD_MSB              5
#define AUDIO_PLL_CONFIG_PLLPWD_LSB              5
#define AUDIO_PLL_CONFIG_PLLPWD_MASK             0x00000020
#define AUDIO_PLL_CONFIG_PLLPWD_GET(x)           (((x) & AUDIO_PLL_CONFIG_PLLPWD_MASK) >> AUDIO_PLL_CONFIG_PLLPWD_LSB)
#define AUDIO_PLL_CONFIG_PLLPWD_SET(x)           (((x) << AUDIO_PLL_CONFIG_PLLPWD_LSB) & AUDIO_PLL_CONFIG_PLLPWD_MASK)
#define AUDIO_PLL_CONFIG_BYPASS_MSB              4
#define AUDIO_PLL_CONFIG_BYPASS_LSB              4
#define AUDIO_PLL_CONFIG_BYPASS_MASK             0x00000010
#define AUDIO_PLL_CONFIG_BYPASS_GET(x)           (((x) & AUDIO_PLL_CONFIG_BYPASS_MASK) >> AUDIO_PLL_CONFIG_BYPASS_LSB)
#define AUDIO_PLL_CONFIG_BYPASS_SET(x)           (((x) << AUDIO_PLL_CONFIG_BYPASS_LSB) & AUDIO_PLL_CONFIG_BYPASS_MASK)
#define AUDIO_PLL_CONFIG_REFDIV_MSB              3
#define AUDIO_PLL_CONFIG_REFDIV_LSB              0
#define AUDIO_PLL_CONFIG_REFDIV_MASK             0x0000000f
#define AUDIO_PLL_CONFIG_REFDIV_GET(x)           (((x) & AUDIO_PLL_CONFIG_REFDIV_MASK) >> AUDIO_PLL_CONFIG_REFDIV_LSB)
#define AUDIO_PLL_CONFIG_REFDIV_SET(x)           (((x) << AUDIO_PLL_CONFIG_REFDIV_LSB) & AUDIO_PLL_CONFIG_REFDIV_MASK)

#define AUDIO_PLL_MODULATION_ADDRESS             0x000002f4
#define AUDIO_PLL_MODULATION_OFFSET              0x000002f4
#define AUDIO_PLL_MODULATION_TGT_DIV_FRAC_MSB    28
#define AUDIO_PLL_MODULATION_TGT_DIV_FRAC_LSB    11
#define AUDIO_PLL_MODULATION_TGT_DIV_FRAC_MASK   0x1ffff800
#define AUDIO_PLL_MODULATION_TGT_DIV_FRAC_GET(x) (((x) & AUDIO_PLL_MODULATION_TGT_DIV_FRAC_MASK) >> AUDIO_PLL_MODULATION_TGT_DIV_FRAC_LSB)
#define AUDIO_PLL_MODULATION_TGT_DIV_FRAC_SET(x) (((x) << AUDIO_PLL_MODULATION_TGT_DIV_FRAC_LSB) & AUDIO_PLL_MODULATION_TGT_DIV_FRAC_MASK)
#define AUDIO_PLL_MODULATION_TGT_DIV_INT_MSB     6
#define AUDIO_PLL_MODULATION_TGT_DIV_INT_LSB     1
#define AUDIO_PLL_MODULATION_TGT_DIV_INT_MASK    0x0000007e
#define AUDIO_PLL_MODULATION_TGT_DIV_INT_GET(x)  (((x) & AUDIO_PLL_MODULATION_TGT_DIV_INT_MASK) >> AUDIO_PLL_MODULATION_TGT_DIV_INT_LSB)
#define AUDIO_PLL_MODULATION_TGT_DIV_INT_SET(x)  (((x) << AUDIO_PLL_MODULATION_TGT_DIV_INT_LSB) & AUDIO_PLL_MODULATION_TGT_DIV_INT_MASK)
#define AUDIO_PLL_MODULATION_START_MSB           0
#define AUDIO_PLL_MODULATION_START_LSB           0
#define AUDIO_PLL_MODULATION_START_MASK          0x00000001
#define AUDIO_PLL_MODULATION_START_GET(x)        (((x) & AUDIO_PLL_MODULATION_START_MASK) >> AUDIO_PLL_MODULATION_START_LSB)
#define AUDIO_PLL_MODULATION_START_SET(x)        (((x) << AUDIO_PLL_MODULATION_START_LSB) & AUDIO_PLL_MODULATION_START_MASK)

#define AUDIO_PLL_MOD_STEP_ADDRESS               0x000002f8
#define AUDIO_PLL_MOD_STEP_OFFSET                0x000002f8
#define AUDIO_PLL_MOD_STEP_FRAC_MSB              31
#define AUDIO_PLL_MOD_STEP_FRAC_LSB              14
#define AUDIO_PLL_MOD_STEP_FRAC_MASK             0xffffc000
#define AUDIO_PLL_MOD_STEP_FRAC_GET(x)           (((x) & AUDIO_PLL_MOD_STEP_FRAC_MASK) >> AUDIO_PLL_MOD_STEP_FRAC_LSB)
#define AUDIO_PLL_MOD_STEP_FRAC_SET(x)           (((x) << AUDIO_PLL_MOD_STEP_FRAC_LSB) & AUDIO_PLL_MOD_STEP_FRAC_MASK)
#define AUDIO_PLL_MOD_STEP_INT_MSB               13
#define AUDIO_PLL_MOD_STEP_INT_LSB               4
#define AUDIO_PLL_MOD_STEP_INT_MASK              0x00003ff0
#define AUDIO_PLL_MOD_STEP_INT_GET(x)            (((x) & AUDIO_PLL_MOD_STEP_INT_MASK) >> AUDIO_PLL_MOD_STEP_INT_LSB)
#define AUDIO_PLL_MOD_STEP_INT_SET(x)            (((x) << AUDIO_PLL_MOD_STEP_INT_LSB) & AUDIO_PLL_MOD_STEP_INT_MASK)
#define AUDIO_PLL_MOD_STEP_UPDATE_CNT_MSB        3
#define AUDIO_PLL_MOD_STEP_UPDATE_CNT_LSB        0
#define AUDIO_PLL_MOD_STEP_UPDATE_CNT_MASK       0x0000000f
#define AUDIO_PLL_MOD_STEP_UPDATE_CNT_GET(x)     (((x) & AUDIO_PLL_MOD_STEP_UPDATE_CNT_MASK) >> AUDIO_PLL_MOD_STEP_UPDATE_CNT_LSB)
#define AUDIO_PLL_MOD_STEP_UPDATE_CNT_SET(x)     (((x) << AUDIO_PLL_MOD_STEP_UPDATE_CNT_LSB) & AUDIO_PLL_MOD_STEP_UPDATE_CNT_MASK)

#define CURRENT_AUDIO_PLL_MODULATION_ADDRESS     0x000002fc
#define CURRENT_AUDIO_PLL_MODULATION_OFFSET      0x000002fc
#define CURRENT_AUDIO_PLL_MODULATION_FRAC_MSB    27
#define CURRENT_AUDIO_PLL_MODULATION_FRAC_LSB    10
#define CURRENT_AUDIO_PLL_MODULATION_FRAC_MASK   0x0ffffc00
#define CURRENT_AUDIO_PLL_MODULATION_FRAC_GET(x) (((x) & CURRENT_AUDIO_PLL_MODULATION_FRAC_MASK) >> CURRENT_AUDIO_PLL_MODULATION_FRAC_LSB)
#define CURRENT_AUDIO_PLL_MODULATION_FRAC_SET(x) (((x) << CURRENT_AUDIO_PLL_MODULATION_FRAC_LSB) & CURRENT_AUDIO_PLL_MODULATION_FRAC_MASK)
#define CURRENT_AUDIO_PLL_MODULATION_INT_MSB     6
#define CURRENT_AUDIO_PLL_MODULATION_INT_LSB     1
#define CURRENT_AUDIO_PLL_MODULATION_INT_MASK    0x0000007e
#define CURRENT_AUDIO_PLL_MODULATION_INT_GET(x)  (((x) & CURRENT_AUDIO_PLL_MODULATION_INT_MASK) >> CURRENT_AUDIO_PLL_MODULATION_INT_LSB)
#define CURRENT_AUDIO_PLL_MODULATION_INT_SET(x)  (((x) << CURRENT_AUDIO_PLL_MODULATION_INT_LSB) & CURRENT_AUDIO_PLL_MODULATION_INT_MASK)

#define ETH_PLL_CONFIG_ADDRESS                   0x00000300
#define ETH_PLL_CONFIG_OFFSET                    0x00000300
#define ETH_PLL_CONFIG_GE0_MASTER_MSB            30
#define ETH_PLL_CONFIG_GE0_MASTER_LSB            30
#define ETH_PLL_CONFIG_GE0_MASTER_MASK           0x40000000
#define ETH_PLL_CONFIG_GE0_MASTER_GET(x)         (((x) & ETH_PLL_CONFIG_GE0_MASTER_MASK) >> ETH_PLL_CONFIG_GE0_MASTER_LSB)
#define ETH_PLL_CONFIG_GE0_MASTER_SET(x)         (((x) << ETH_PLL_CONFIG_GE0_MASTER_LSB) & ETH_PLL_CONFIG_GE0_MASTER_MASK)
#define ETH_PLL_CONFIG_GE0_MSB                   29
#define ETH_PLL_CONFIG_GE0_LSB                   29
#define ETH_PLL_CONFIG_GE0_MASK                  0x20000000
#define ETH_PLL_CONFIG_GE0_GET(x)                (((x) & ETH_PLL_CONFIG_GE0_MASK) >> ETH_PLL_CONFIG_GE0_LSB)
#define ETH_PLL_CONFIG_GE0_SET(x)                (((x) << ETH_PLL_CONFIG_GE0_LSB) & ETH_PLL_CONFIG_GE0_MASK)
#define ETH_PLL_CONFIG_RANGE_MSB                 28
#define ETH_PLL_CONFIG_RANGE_LSB                 28
#define ETH_PLL_CONFIG_RANGE_MASK                0x10000000
#define ETH_PLL_CONFIG_RANGE_GET(x)              (((x) & ETH_PLL_CONFIG_RANGE_MASK) >> ETH_PLL_CONFIG_RANGE_LSB)
#define ETH_PLL_CONFIG_RANGE_SET(x)              (((x) << ETH_PLL_CONFIG_RANGE_LSB) & ETH_PLL_CONFIG_RANGE_MASK)
#define ETH_PLL_CONFIG_FRAC_MSB                  27
#define ETH_PLL_CONFIG_FRAC_LSB                  18
#define ETH_PLL_CONFIG_FRAC_MASK                 0x0ffc0000
#define ETH_PLL_CONFIG_FRAC_GET(x)               (((x) & ETH_PLL_CONFIG_FRAC_MASK) >> ETH_PLL_CONFIG_FRAC_LSB)
#define ETH_PLL_CONFIG_FRAC_SET(x)               (((x) << ETH_PLL_CONFIG_FRAC_LSB) & ETH_PLL_CONFIG_FRAC_MASK)
#define ETH_PLL_CONFIG_INT_MSB                   17
#define ETH_PLL_CONFIG_INT_LSB                   12
#define ETH_PLL_CONFIG_INT_MASK                  0x0003f000
#define ETH_PLL_CONFIG_INT_GET(x)                (((x) & ETH_PLL_CONFIG_INT_MASK) >> ETH_PLL_CONFIG_INT_LSB)
#define ETH_PLL_CONFIG_INT_SET(x)                (((x) << ETH_PLL_CONFIG_INT_LSB) & ETH_PLL_CONFIG_INT_MASK)
#define ETH_PLL_CONFIG_OUTDIV_MSB                9
#define ETH_PLL_CONFIG_OUTDIV_LSB                7
#define ETH_PLL_CONFIG_OUTDIV_MASK               0x00000380
#define ETH_PLL_CONFIG_OUTDIV_GET(x)             (((x) & ETH_PLL_CONFIG_OUTDIV_MASK) >> ETH_PLL_CONFIG_OUTDIV_LSB)
#define ETH_PLL_CONFIG_OUTDIV_SET(x)             (((x) << ETH_PLL_CONFIG_OUTDIV_LSB) & ETH_PLL_CONFIG_OUTDIV_MASK)
#define ETH_PLL_CONFIG_PLLPWD_MSB                6
#define ETH_PLL_CONFIG_PLLPWD_LSB                6
#define ETH_PLL_CONFIG_PLLPWD_MASK               0x00000040
#define ETH_PLL_CONFIG_PLLPWD_GET(x)             (((x) & ETH_PLL_CONFIG_PLLPWD_MASK) >> ETH_PLL_CONFIG_PLLPWD_LSB)
#define ETH_PLL_CONFIG_PLLPWD_SET(x)             (((x) << ETH_PLL_CONFIG_PLLPWD_LSB) & ETH_PLL_CONFIG_PLLPWD_MASK)
#define ETH_PLL_CONFIG_BYPASS_MSB                5
#define ETH_PLL_CONFIG_BYPASS_LSB                5
#define ETH_PLL_CONFIG_BYPASS_MASK               0x00000020
#define ETH_PLL_CONFIG_BYPASS_GET(x)             (((x) & ETH_PLL_CONFIG_BYPASS_MASK) >> ETH_PLL_CONFIG_BYPASS_LSB)
#define ETH_PLL_CONFIG_BYPASS_SET(x)             (((x) << ETH_PLL_CONFIG_BYPASS_LSB) & ETH_PLL_CONFIG_BYPASS_MASK)
#define ETH_PLL_CONFIG_REFDIV_MSB                4
#define ETH_PLL_CONFIG_REFDIV_LSB                0
#define ETH_PLL_CONFIG_REFDIV_MASK               0x0000001f
#define ETH_PLL_CONFIG_REFDIV_GET(x)             (((x) & ETH_PLL_CONFIG_REFDIV_MASK) >> ETH_PLL_CONFIG_REFDIV_LSB)
#define ETH_PLL_CONFIG_REFDIV_SET(x)             (((x) << ETH_PLL_CONFIG_REFDIV_LSB) & ETH_PLL_CONFIG_REFDIV_MASK)

#define CPU_PLL_CONFIG_ADDRESS                   0x00000304
#define CPU_PLL_CONFIG_OFFSET                    0x00000304
#define CPU_PLL_CONFIG_RANGE_MSB                 28
#define CPU_PLL_CONFIG_RANGE_LSB                 28
#define CPU_PLL_CONFIG_RANGE_MASK                0x10000000
#define CPU_PLL_CONFIG_RANGE_GET(x)              (((x) & CPU_PLL_CONFIG_RANGE_MASK) >> CPU_PLL_CONFIG_RANGE_LSB)
#define CPU_PLL_CONFIG_RANGE_SET(x)              (((x) << CPU_PLL_CONFIG_RANGE_LSB) & CPU_PLL_CONFIG_RANGE_MASK)
#define CPU_PLL_CONFIG_FRAC_MSB                  25
#define CPU_PLL_CONFIG_FRAC_LSB                  20
#define CPU_PLL_CONFIG_FRAC_MASK                 0x03f00000
#define CPU_PLL_CONFIG_FRAC_GET(x)               (((x) & CPU_PLL_CONFIG_FRAC_MASK) >> CPU_PLL_CONFIG_FRAC_LSB)
#define CPU_PLL_CONFIG_FRAC_SET(x)               (((x) << CPU_PLL_CONFIG_FRAC_LSB) & CPU_PLL_CONFIG_FRAC_MASK)
#define CPU_PLL_CONFIG_INT_MSB                   17
#define CPU_PLL_CONFIG_INT_LSB                   12
#define CPU_PLL_CONFIG_INT_MASK                  0x0003f000
#define CPU_PLL_CONFIG_INT_GET(x)                (((x) & CPU_PLL_CONFIG_INT_MASK) >> CPU_PLL_CONFIG_INT_LSB)
#define CPU_PLL_CONFIG_INT_SET(x)                (((x) << CPU_PLL_CONFIG_INT_LSB) & CPU_PLL_CONFIG_INT_MASK)
#define CPU_PLL_CONFIG_OUTDIV_MSB                9
#define CPU_PLL_CONFIG_OUTDIV_LSB                7
#define CPU_PLL_CONFIG_OUTDIV_MASK               0x00000380
#define CPU_PLL_CONFIG_OUTDIV_GET(x)             (((x) & CPU_PLL_CONFIG_OUTDIV_MASK) >> CPU_PLL_CONFIG_OUTDIV_LSB)
#define CPU_PLL_CONFIG_OUTDIV_SET(x)             (((x) << CPU_PLL_CONFIG_OUTDIV_LSB) & CPU_PLL_CONFIG_OUTDIV_MASK)
#define CPU_PLL_CONFIG_PLLPWD_MSB                6
#define CPU_PLL_CONFIG_PLLPWD_LSB                6
#define CPU_PLL_CONFIG_PLLPWD_MASK               0x00000040
#define CPU_PLL_CONFIG_PLLPWD_GET(x)             (((x) & CPU_PLL_CONFIG_PLLPWD_MASK) >> CPU_PLL_CONFIG_PLLPWD_LSB)
#define CPU_PLL_CONFIG_PLLPWD_SET(x)             (((x) << CPU_PLL_CONFIG_PLLPWD_LSB) & CPU_PLL_CONFIG_PLLPWD_MASK)
#define CPU_PLL_CONFIG_REFDIV_MSB                4
#define CPU_PLL_CONFIG_REFDIV_LSB                0
#define CPU_PLL_CONFIG_REFDIV_MASK               0x0000001f
#define CPU_PLL_CONFIG_REFDIV_GET(x)             (((x) & CPU_PLL_CONFIG_REFDIV_MASK) >> CPU_PLL_CONFIG_REFDIV_LSB)
#define CPU_PLL_CONFIG_REFDIV_SET(x)             (((x) << CPU_PLL_CONFIG_REFDIV_LSB) & CPU_PLL_CONFIG_REFDIV_MASK)

#define BB_PLL_CONFIG_ADDRESS                    0x00000308
#define BB_PLL_CONFIG_OFFSET                     0x00000308
#define BB_PLL_CONFIG_FRAC_MSB                   17
#define BB_PLL_CONFIG_FRAC_LSB                   0
#define BB_PLL_CONFIG_FRAC_MASK                  0x0003ffff
#define BB_PLL_CONFIG_FRAC_GET(x)                (((x) & BB_PLL_CONFIG_FRAC_MASK) >> BB_PLL_CONFIG_FRAC_LSB)
#define BB_PLL_CONFIG_FRAC_SET(x)                (((x) << BB_PLL_CONFIG_FRAC_LSB) & BB_PLL_CONFIG_FRAC_MASK)

#define ETH_XMII_ADDRESS                         0x0000030c
#define ETH_XMII_OFFSET                          0x0000030c
#define ETH_XMII_TX_INVERT_MSB                   31
#define ETH_XMII_TX_INVERT_LSB                   31
#define ETH_XMII_TX_INVERT_MASK                  0x80000000
#define ETH_XMII_TX_INVERT_GET(x)                (((x) & ETH_XMII_TX_INVERT_MASK) >> ETH_XMII_TX_INVERT_LSB)
#define ETH_XMII_TX_INVERT_SET(x)                (((x) << ETH_XMII_TX_INVERT_LSB) & ETH_XMII_TX_INVERT_MASK)
#define ETH_XMII_GIGE_QUAD_MSB                   30
#define ETH_XMII_GIGE_QUAD_LSB                   30
#define ETH_XMII_GIGE_QUAD_MASK                  0x40000000
#define ETH_XMII_GIGE_QUAD_GET(x)                (((x) & ETH_XMII_GIGE_QUAD_MASK) >> ETH_XMII_GIGE_QUAD_LSB)
#define ETH_XMII_GIGE_QUAD_SET(x)                (((x) << ETH_XMII_GIGE_QUAD_LSB) & ETH_XMII_GIGE_QUAD_MASK)
#define ETH_XMII_RX_DELAY_MSB                    29
#define ETH_XMII_RX_DELAY_LSB                    28
#define ETH_XMII_RX_DELAY_MASK                   0x30000000
#define ETH_XMII_RX_DELAY_GET(x)                 (((x) & ETH_XMII_RX_DELAY_MASK) >> ETH_XMII_RX_DELAY_LSB)
#define ETH_XMII_RX_DELAY_SET(x)                 (((x) << ETH_XMII_RX_DELAY_LSB) & ETH_XMII_RX_DELAY_MASK)
#define ETH_XMII_TX_DELAY_MSB                    27
#define ETH_XMII_TX_DELAY_LSB                    26
#define ETH_XMII_TX_DELAY_MASK                   0x0c000000
#define ETH_XMII_TX_DELAY_GET(x)                 (((x) & ETH_XMII_TX_DELAY_MASK) >> ETH_XMII_TX_DELAY_LSB)
#define ETH_XMII_TX_DELAY_SET(x)                 (((x) << ETH_XMII_TX_DELAY_LSB) & ETH_XMII_TX_DELAY_MASK)
#define ETH_XMII_GIGE_MSB                        25
#define ETH_XMII_GIGE_LSB                        25
#define ETH_XMII_GIGE_MASK                       0x02000000
#define ETH_XMII_GIGE_GET(x)                     (((x) & ETH_XMII_GIGE_MASK) >> ETH_XMII_GIGE_LSB)
#define ETH_XMII_GIGE_SET(x)                     (((x) << ETH_XMII_GIGE_LSB) & ETH_XMII_GIGE_MASK)
#define ETH_XMII_OFFSET_PHASE_MSB                24
#define ETH_XMII_OFFSET_PHASE_LSB                24
#define ETH_XMII_OFFSET_PHASE_MASK               0x01000000
#define ETH_XMII_OFFSET_PHASE_GET(x)             (((x) & ETH_XMII_OFFSET_PHASE_MASK) >> ETH_XMII_OFFSET_PHASE_LSB)
#define ETH_XMII_OFFSET_PHASE_SET(x)             (((x) << ETH_XMII_OFFSET_PHASE_LSB) & ETH_XMII_OFFSET_PHASE_MASK)
#define ETH_XMII_OFFSET_COUNT_MSB                23
#define ETH_XMII_OFFSET_COUNT_LSB                16
#define ETH_XMII_OFFSET_COUNT_MASK               0x00ff0000
#define ETH_XMII_OFFSET_COUNT_GET(x)             (((x) & ETH_XMII_OFFSET_COUNT_MASK) >> ETH_XMII_OFFSET_COUNT_LSB)
#define ETH_XMII_OFFSET_COUNT_SET(x)             (((x) << ETH_XMII_OFFSET_COUNT_LSB) & ETH_XMII_OFFSET_COUNT_MASK)
#define ETH_XMII_PHASE1_COUNT_MSB                15
#define ETH_XMII_PHASE1_COUNT_LSB                8
#define ETH_XMII_PHASE1_COUNT_MASK               0x0000ff00
#define ETH_XMII_PHASE1_COUNT_GET(x)             (((x) & ETH_XMII_PHASE1_COUNT_MASK) >> ETH_XMII_PHASE1_COUNT_LSB)
#define ETH_XMII_PHASE1_COUNT_SET(x)             (((x) << ETH_XMII_PHASE1_COUNT_LSB) & ETH_XMII_PHASE1_COUNT_MASK)
#define ETH_XMII_PHASE0_COUNT_MSB                7
#define ETH_XMII_PHASE0_COUNT_LSB                0
#define ETH_XMII_PHASE0_COUNT_MASK               0x000000ff
#define ETH_XMII_PHASE0_COUNT_GET(x)             (((x) & ETH_XMII_PHASE0_COUNT_MASK) >> ETH_XMII_PHASE0_COUNT_LSB)
#define ETH_XMII_PHASE0_COUNT_SET(x)             (((x) << ETH_XMII_PHASE0_COUNT_LSB) & ETH_XMII_PHASE0_COUNT_MASK)

#define USB_PHY_CONFIG_ADDRESS                   0x00000310
#define USB_PHY_CONFIG_OFFSET                    0x00000310
#define USB_PHY_CONFIG_REFCLK_SEL_MSB            7
#define USB_PHY_CONFIG_REFCLK_SEL_LSB            4
#define USB_PHY_CONFIG_REFCLK_SEL_MASK           0x000000f0
#define USB_PHY_CONFIG_REFCLK_SEL_GET(x)         (((x) & USB_PHY_CONFIG_REFCLK_SEL_MASK) >> USB_PHY_CONFIG_REFCLK_SEL_LSB)
#define USB_PHY_CONFIG_REFCLK_SEL_SET(x)         (((x) << USB_PHY_CONFIG_REFCLK_SEL_LSB) & USB_PHY_CONFIG_REFCLK_SEL_MASK)
#define USB_PHY_CONFIG_REFDIV_MSB                3
#define USB_PHY_CONFIG_REFDIV_LSB                3
#define USB_PHY_CONFIG_REFDIV_MASK               0x00000008
#define USB_PHY_CONFIG_REFDIV_GET(x)             (((x) & USB_PHY_CONFIG_REFDIV_MASK) >> USB_PHY_CONFIG_REFDIV_LSB)
#define USB_PHY_CONFIG_REFDIV_SET(x)             (((x) << USB_PHY_CONFIG_REFDIV_LSB) & USB_PHY_CONFIG_REFDIV_MASK)
#define USB_PHY_CONFIG_TESTMODE_MSB              2
#define USB_PHY_CONFIG_TESTMODE_LSB              2
#define USB_PHY_CONFIG_TESTMODE_MASK             0x00000004
#define USB_PHY_CONFIG_TESTMODE_GET(x)           (((x) & USB_PHY_CONFIG_TESTMODE_MASK) >> USB_PHY_CONFIG_TESTMODE_LSB)
#define USB_PHY_CONFIG_TESTMODE_SET(x)           (((x) << USB_PHY_CONFIG_TESTMODE_LSB) & USB_PHY_CONFIG_TESTMODE_MASK)
#define USB_PHY_CONFIG_PLL_PWD_MSB               1
#define USB_PHY_CONFIG_PLL_PWD_LSB               1
#define USB_PHY_CONFIG_PLL_PWD_MASK              0x00000002
#define USB_PHY_CONFIG_PLL_PWD_GET(x)            (((x) & USB_PHY_CONFIG_PLL_PWD_MASK) >> USB_PHY_CONFIG_PLL_PWD_LSB)
#define USB_PHY_CONFIG_PLL_PWD_SET(x)            (((x) << USB_PHY_CONFIG_PLL_PWD_LSB) & USB_PHY_CONFIG_PLL_PWD_MASK)
#define USB_PHY_CONFIG_HOSTMODE_MSB              0
#define USB_PHY_CONFIG_HOSTMODE_LSB              0
#define USB_PHY_CONFIG_HOSTMODE_MASK             0x00000001
#define USB_PHY_CONFIG_HOSTMODE_GET(x)           (((x) & USB_PHY_CONFIG_HOSTMODE_MASK) >> USB_PHY_CONFIG_HOSTMODE_LSB)
#define USB_PHY_CONFIG_HOSTMODE_SET(x)           (((x) << USB_PHY_CONFIG_HOSTMODE_LSB) & USB_PHY_CONFIG_HOSTMODE_MASK)

#define MITSUMI_INT_CONTROL_REG_ADDRESS          0x00000314
#define MITSUMI_INT_CONTROL_REG_OFFSET           0x00000314
#define MITSUMI_INT_CONTROL_REG_FLIGHT_MODE_EN_MSB 3
#define MITSUMI_INT_CONTROL_REG_FLIGHT_MODE_EN_LSB 3
#define MITSUMI_INT_CONTROL_REG_FLIGHT_MODE_EN_MASK 0x00000008
#define MITSUMI_INT_CONTROL_REG_FLIGHT_MODE_EN_GET(x) (((x) & MITSUMI_INT_CONTROL_REG_FLIGHT_MODE_EN_MASK) >> MITSUMI_INT_CONTROL_REG_FLIGHT_MODE_EN_LSB)
#define MITSUMI_INT_CONTROL_REG_FLIGHT_MODE_EN_SET(x) (((x) << MITSUMI_INT_CONTROL_REG_FLIGHT_MODE_EN_LSB) & MITSUMI_INT_CONTROL_REG_FLIGHT_MODE_EN_MASK)
#define MITSUMI_INT_CONTROL_REG_BBP_SLEEP_EN_MSB 2
#define MITSUMI_INT_CONTROL_REG_BBP_SLEEP_EN_LSB 2
#define MITSUMI_INT_CONTROL_REG_BBP_SLEEP_EN_MASK 0x00000004
#define MITSUMI_INT_CONTROL_REG_BBP_SLEEP_EN_GET(x) (((x) & MITSUMI_INT_CONTROL_REG_BBP_SLEEP_EN_MASK) >> MITSUMI_INT_CONTROL_REG_BBP_SLEEP_EN_LSB)
#define MITSUMI_INT_CONTROL_REG_BBP_SLEEP_EN_SET(x) (((x) << MITSUMI_INT_CONTROL_REG_BBP_SLEEP_EN_LSB) & MITSUMI_INT_CONTROL_REG_BBP_SLEEP_EN_MASK)
#define MITSUMI_INT_CONTROL_REG_RF_SLEEP_EN_MSB  1
#define MITSUMI_INT_CONTROL_REG_RF_SLEEP_EN_LSB  1
#define MITSUMI_INT_CONTROL_REG_RF_SLEEP_EN_MASK 0x00000002
#define MITSUMI_INT_CONTROL_REG_RF_SLEEP_EN_GET(x) (((x) & MITSUMI_INT_CONTROL_REG_RF_SLEEP_EN_MASK) >> MITSUMI_INT_CONTROL_REG_RF_SLEEP_EN_LSB)
#define MITSUMI_INT_CONTROL_REG_RF_SLEEP_EN_SET(x) (((x) << MITSUMI_INT_CONTROL_REG_RF_SLEEP_EN_LSB) & MITSUMI_INT_CONTROL_REG_RF_SLEEP_EN_MASK)
#define MITSUMI_INT_CONTROL_REG_MODE_SWITCH_EN_MSB 0
#define MITSUMI_INT_CONTROL_REG_MODE_SWITCH_EN_LSB 0
#define MITSUMI_INT_CONTROL_REG_MODE_SWITCH_EN_MASK 0x00000001
#define MITSUMI_INT_CONTROL_REG_MODE_SWITCH_EN_GET(x) (((x) & MITSUMI_INT_CONTROL_REG_MODE_SWITCH_EN_MASK) >> MITSUMI_INT_CONTROL_REG_MODE_SWITCH_EN_LSB)
#define MITSUMI_INT_CONTROL_REG_MODE_SWITCH_EN_SET(x) (((x) << MITSUMI_INT_CONTROL_REG_MODE_SWITCH_EN_LSB) & MITSUMI_INT_CONTROL_REG_MODE_SWITCH_EN_MASK)

#define MITSUMI_INT_STATUS_REG_ADDRESS           0x00000318
#define MITSUMI_INT_STATUS_REG_OFFSET            0x00000318
#define MITSUMI_INT_STATUS_REG_FLIGHT_MODE_INT_MSB 3
#define MITSUMI_INT_STATUS_REG_FLIGHT_MODE_INT_LSB 3
#define MITSUMI_INT_STATUS_REG_FLIGHT_MODE_INT_MASK 0x00000008
#define MITSUMI_INT_STATUS_REG_FLIGHT_MODE_INT_GET(x) (((x) & MITSUMI_INT_STATUS_REG_FLIGHT_MODE_INT_MASK) >> MITSUMI_INT_STATUS_REG_FLIGHT_MODE_INT_LSB)
#define MITSUMI_INT_STATUS_REG_FLIGHT_MODE_INT_SET(x) (((x) << MITSUMI_INT_STATUS_REG_FLIGHT_MODE_INT_LSB) & MITSUMI_INT_STATUS_REG_FLIGHT_MODE_INT_MASK)
#define MITSUMI_INT_STATUS_REG_BBP_SLEEP_INT_MSB 2
#define MITSUMI_INT_STATUS_REG_BBP_SLEEP_INT_LSB 2
#define MITSUMI_INT_STATUS_REG_BBP_SLEEP_INT_MASK 0x00000004
#define MITSUMI_INT_STATUS_REG_BBP_SLEEP_INT_GET(x) (((x) & MITSUMI_INT_STATUS_REG_BBP_SLEEP_INT_MASK) >> MITSUMI_INT_STATUS_REG_BBP_SLEEP_INT_LSB)
#define MITSUMI_INT_STATUS_REG_BBP_SLEEP_INT_SET(x) (((x) << MITSUMI_INT_STATUS_REG_BBP_SLEEP_INT_LSB) & MITSUMI_INT_STATUS_REG_BBP_SLEEP_INT_MASK)
#define MITSUMI_INT_STATUS_REG_RF_SLEEP_INT_MSB  1
#define MITSUMI_INT_STATUS_REG_RF_SLEEP_INT_LSB  1
#define MITSUMI_INT_STATUS_REG_RF_SLEEP_INT_MASK 0x00000002
#define MITSUMI_INT_STATUS_REG_RF_SLEEP_INT_GET(x) (((x) & MITSUMI_INT_STATUS_REG_RF_SLEEP_INT_MASK) >> MITSUMI_INT_STATUS_REG_RF_SLEEP_INT_LSB)
#define MITSUMI_INT_STATUS_REG_RF_SLEEP_INT_SET(x) (((x) << MITSUMI_INT_STATUS_REG_RF_SLEEP_INT_LSB) & MITSUMI_INT_STATUS_REG_RF_SLEEP_INT_MASK)
#define MITSUMI_INT_STATUS_REG_MODE_SWITCH_INT_MSB 0
#define MITSUMI_INT_STATUS_REG_MODE_SWITCH_INT_LSB 0
#define MITSUMI_INT_STATUS_REG_MODE_SWITCH_INT_MASK 0x00000001
#define MITSUMI_INT_STATUS_REG_MODE_SWITCH_INT_GET(x) (((x) & MITSUMI_INT_STATUS_REG_MODE_SWITCH_INT_MASK) >> MITSUMI_INT_STATUS_REG_MODE_SWITCH_INT_LSB)
#define MITSUMI_INT_STATUS_REG_MODE_SWITCH_INT_SET(x) (((x) << MITSUMI_INT_STATUS_REG_MODE_SWITCH_INT_LSB) & MITSUMI_INT_STATUS_REG_MODE_SWITCH_INT_MASK)

#define CURRENT_WORKING_MODE_ADDRESS             0x0000031c
#define CURRENT_WORKING_MODE_OFFSET              0x0000031c
#define CURRENT_WORKING_MODE_MIT_FORCE_ACTIVE_ON_MSB 5
#define CURRENT_WORKING_MODE_MIT_FORCE_ACTIVE_ON_LSB 5
#define CURRENT_WORKING_MODE_MIT_FORCE_ACTIVE_ON_MASK 0x00000020
#define CURRENT_WORKING_MODE_MIT_FORCE_ACTIVE_ON_GET(x) (((x) & CURRENT_WORKING_MODE_MIT_FORCE_ACTIVE_ON_MASK) >> CURRENT_WORKING_MODE_MIT_FORCE_ACTIVE_ON_LSB)
#define CURRENT_WORKING_MODE_MIT_FORCE_ACTIVE_ON_SET(x) (((x) << CURRENT_WORKING_MODE_MIT_FORCE_ACTIVE_ON_LSB) & CURRENT_WORKING_MODE_MIT_FORCE_ACTIVE_ON_MASK)
#define CURRENT_WORKING_MODE_MIT_REG_WR_TRIGGER_EN_MSB 2
#define CURRENT_WORKING_MODE_MIT_REG_WR_TRIGGER_EN_LSB 2
#define CURRENT_WORKING_MODE_MIT_REG_WR_TRIGGER_EN_MASK 0x00000004
#define CURRENT_WORKING_MODE_MIT_REG_WR_TRIGGER_EN_GET(x) (((x) & CURRENT_WORKING_MODE_MIT_REG_WR_TRIGGER_EN_MASK) >> CURRENT_WORKING_MODE_MIT_REG_WR_TRIGGER_EN_LSB)
#define CURRENT_WORKING_MODE_MIT_REG_WR_TRIGGER_EN_SET(x) (((x) << CURRENT_WORKING_MODE_MIT_REG_WR_TRIGGER_EN_LSB) & CURRENT_WORKING_MODE_MIT_REG_WR_TRIGGER_EN_MASK)
#define CURRENT_WORKING_MODE_NOT_FIRST_MIT_MODE_MSB 1
#define CURRENT_WORKING_MODE_NOT_FIRST_MIT_MODE_LSB 1
#define CURRENT_WORKING_MODE_NOT_FIRST_MIT_MODE_MASK 0x00000002
#define CURRENT_WORKING_MODE_NOT_FIRST_MIT_MODE_GET(x) (((x) & CURRENT_WORKING_MODE_NOT_FIRST_MIT_MODE_MASK) >> CURRENT_WORKING_MODE_NOT_FIRST_MIT_MODE_LSB)
#define CURRENT_WORKING_MODE_NOT_FIRST_MIT_MODE_SET(x) (((x) << CURRENT_WORKING_MODE_NOT_FIRST_MIT_MODE_LSB) & CURRENT_WORKING_MODE_NOT_FIRST_MIT_MODE_MASK)
#define CURRENT_WORKING_MODE_VALUE_MSB           0
#define CURRENT_WORKING_MODE_VALUE_LSB           0
#define CURRENT_WORKING_MODE_VALUE_MASK          0x00000001
#define CURRENT_WORKING_MODE_VALUE_GET(x)        (((x) & CURRENT_WORKING_MODE_VALUE_MASK) >> CURRENT_WORKING_MODE_VALUE_LSB)
#define CURRENT_WORKING_MODE_VALUE_SET(x)        (((x) << CURRENT_WORKING_MODE_VALUE_LSB) & CURRENT_WORKING_MODE_VALUE_MASK)

#define RTC_SLEEP_COUNT_ADDRESS                  0x00000320
#define RTC_SLEEP_COUNT_OFFSET                   0x00000320
#define RTC_SLEEP_COUNT_THRESHOLD_MSB            5
#define RTC_SLEEP_COUNT_THRESHOLD_LSB            0
#define RTC_SLEEP_COUNT_THRESHOLD_MASK           0x0000003f
#define RTC_SLEEP_COUNT_THRESHOLD_GET(x)         (((x) & RTC_SLEEP_COUNT_THRESHOLD_MASK) >> RTC_SLEEP_COUNT_THRESHOLD_LSB)
#define RTC_SLEEP_COUNT_THRESHOLD_SET(x)         (((x) << RTC_SLEEP_COUNT_THRESHOLD_LSB) & RTC_SLEEP_COUNT_THRESHOLD_MASK)

#define MIT2_VAP_ADDRESS                         0x00000324
#define MIT2_VAP_OFFSET                          0x00000324
#define MIT2_VAP_MODE_MSB                        0
#define MIT2_VAP_MODE_LSB                        0
#define MIT2_VAP_MODE_MASK                       0x00000001
#define MIT2_VAP_MODE_GET(x)                     (((x) & MIT2_VAP_MODE_MASK) >> MIT2_VAP_MODE_LSB)
#define MIT2_VAP_MODE_SET(x)                     (((x) << MIT2_VAP_MODE_LSB) & MIT2_VAP_MODE_MASK)

#define SECOND_HOST_INFT_ADDRESS                 0x00000328
#define SECOND_HOST_INFT_OFFSET                  0x00000328
#define SECOND_HOST_INFT_SDIO_MODE_MSB           0
#define SECOND_HOST_INFT_SDIO_MODE_LSB           0
#define SECOND_HOST_INFT_SDIO_MODE_MASK          0x00000001
#define SECOND_HOST_INFT_SDIO_MODE_GET(x)        (((x) & SECOND_HOST_INFT_SDIO_MODE_MASK) >> SECOND_HOST_INFT_SDIO_MODE_LSB)
#define SECOND_HOST_INFT_SDIO_MODE_SET(x)        (((x) << SECOND_HOST_INFT_SDIO_MODE_LSB) & SECOND_HOST_INFT_SDIO_MODE_MASK)

#define SDIO_HOST_ADDRESS                        0x0000032c
#define SDIO_HOST_OFFSET                         0x0000032c
#define SDIO_HOST_RESET_MSB                      0
#define SDIO_HOST_RESET_LSB                      0
#define SDIO_HOST_RESET_MASK                     0x00000001
#define SDIO_HOST_RESET_GET(x)                   (((x) & SDIO_HOST_RESET_MASK) >> SDIO_HOST_RESET_LSB)
#define SDIO_HOST_RESET_SET(x)                   (((x) << SDIO_HOST_RESET_LSB) & SDIO_HOST_RESET_MASK)

#define ENTERPRISE_CONFIG_ADDRESS                0x00000330
#define ENTERPRISE_CONFIG_OFFSET                 0x00000330
#define ENTERPRISE_CONFIG_TPC_LOWER_PERFORMANCE_MSB 12
#define ENTERPRISE_CONFIG_TPC_LOWER_PERFORMANCE_LSB 12
#define ENTERPRISE_CONFIG_TPC_LOWER_PERFORMANCE_MASK 0x00001000
#define ENTERPRISE_CONFIG_TPC_LOWER_PERFORMANCE_GET(x) (((x) & ENTERPRISE_CONFIG_TPC_LOWER_PERFORMANCE_MASK) >> ENTERPRISE_CONFIG_TPC_LOWER_PERFORMANCE_LSB)
#define ENTERPRISE_CONFIG_TPC_LOWER_PERFORMANCE_SET(x) (((x) << ENTERPRISE_CONFIG_TPC_LOWER_PERFORMANCE_LSB) & ENTERPRISE_CONFIG_TPC_LOWER_PERFORMANCE_MASK)
#define ENTERPRISE_CONFIG_SWCOM_IDLE_MODE_MSB    11
#define ENTERPRISE_CONFIG_SWCOM_IDLE_MODE_LSB    11
#define ENTERPRISE_CONFIG_SWCOM_IDLE_MODE_MASK   0x00000800
#define ENTERPRISE_CONFIG_SWCOM_IDLE_MODE_GET(x) (((x) & ENTERPRISE_CONFIG_SWCOM_IDLE_MODE_MASK) >> ENTERPRISE_CONFIG_SWCOM_IDLE_MODE_LSB)
#define ENTERPRISE_CONFIG_SWCOM_IDLE_MODE_SET(x) (((x) << ENTERPRISE_CONFIG_SWCOM_IDLE_MODE_LSB) & ENTERPRISE_CONFIG_SWCOM_IDLE_MODE_MASK)
#define ENTERPRISE_CONFIG_STBC_DISABLE_MSB       10
#define ENTERPRISE_CONFIG_STBC_DISABLE_LSB       10
#define ENTERPRISE_CONFIG_STBC_DISABLE_MASK      0x00000400
#define ENTERPRISE_CONFIG_STBC_DISABLE_GET(x)    (((x) & ENTERPRISE_CONFIG_STBC_DISABLE_MASK) >> ENTERPRISE_CONFIG_STBC_DISABLE_LSB)
#define ENTERPRISE_CONFIG_STBC_DISABLE_SET(x)    (((x) << ENTERPRISE_CONFIG_STBC_DISABLE_LSB) & ENTERPRISE_CONFIG_STBC_DISABLE_MASK)
#define ENTERPRISE_CONFIG_LDPC_DISABLE_MSB       9
#define ENTERPRISE_CONFIG_LDPC_DISABLE_LSB       9
#define ENTERPRISE_CONFIG_LDPC_DISABLE_MASK      0x00000200
#define ENTERPRISE_CONFIG_LDPC_DISABLE_GET(x)    (((x) & ENTERPRISE_CONFIG_LDPC_DISABLE_MASK) >> ENTERPRISE_CONFIG_LDPC_DISABLE_LSB)
#define ENTERPRISE_CONFIG_LDPC_DISABLE_SET(x)    (((x) << ENTERPRISE_CONFIG_LDPC_DISABLE_LSB) & ENTERPRISE_CONFIG_LDPC_DISABLE_MASK)
#define ENTERPRISE_CONFIG_GREEN_TX_DISABLE_MSB   8
#define ENTERPRISE_CONFIG_GREEN_TX_DISABLE_LSB   8
#define ENTERPRISE_CONFIG_GREEN_TX_DISABLE_MASK  0x00000100
#define ENTERPRISE_CONFIG_GREEN_TX_DISABLE_GET(x) (((x) & ENTERPRISE_CONFIG_GREEN_TX_DISABLE_MASK) >> ENTERPRISE_CONFIG_GREEN_TX_DISABLE_LSB)
#define ENTERPRISE_CONFIG_GREEN_TX_DISABLE_SET(x) (((x) << ENTERPRISE_CONFIG_GREEN_TX_DISABLE_LSB) & ENTERPRISE_CONFIG_GREEN_TX_DISABLE_MASK)
#define ENTERPRISE_CONFIG_DUAL_BAND_DISABLE_MSB  7
#define ENTERPRISE_CONFIG_DUAL_BAND_DISABLE_LSB  7
#define ENTERPRISE_CONFIG_DUAL_BAND_DISABLE_MASK 0x00000080
#define ENTERPRISE_CONFIG_DUAL_BAND_DISABLE_GET(x) (((x) & ENTERPRISE_CONFIG_DUAL_BAND_DISABLE_MASK) >> ENTERPRISE_CONFIG_DUAL_BAND_DISABLE_LSB)
#define ENTERPRISE_CONFIG_DUAL_BAND_DISABLE_SET(x) (((x) << ENTERPRISE_CONFIG_DUAL_BAND_DISABLE_LSB) & ENTERPRISE_CONFIG_DUAL_BAND_DISABLE_MASK)
#define ENTERPRISE_CONFIG_CHAIN1_DISABLE_MSB     6
#define ENTERPRISE_CONFIG_CHAIN1_DISABLE_LSB     6
#define ENTERPRISE_CONFIG_CHAIN1_DISABLE_MASK    0x00000040
#define ENTERPRISE_CONFIG_CHAIN1_DISABLE_GET(x)  (((x) & ENTERPRISE_CONFIG_CHAIN1_DISABLE_MASK) >> ENTERPRISE_CONFIG_CHAIN1_DISABLE_LSB)
#define ENTERPRISE_CONFIG_CHAIN1_DISABLE_SET(x)  (((x) << ENTERPRISE_CONFIG_CHAIN1_DISABLE_LSB) & ENTERPRISE_CONFIG_CHAIN1_DISABLE_MASK)
#define ENTERPRISE_CONFIG_CH_5MHZ_DISABLE_MSB    5
#define ENTERPRISE_CONFIG_CH_5MHZ_DISABLE_LSB    5
#define ENTERPRISE_CONFIG_CH_5MHZ_DISABLE_MASK   0x00000020
#define ENTERPRISE_CONFIG_CH_5MHZ_DISABLE_GET(x) (((x) & ENTERPRISE_CONFIG_CH_5MHZ_DISABLE_MASK) >> ENTERPRISE_CONFIG_CH_5MHZ_DISABLE_LSB)
#define ENTERPRISE_CONFIG_CH_5MHZ_DISABLE_SET(x) (((x) << ENTERPRISE_CONFIG_CH_5MHZ_DISABLE_LSB) & ENTERPRISE_CONFIG_CH_5MHZ_DISABLE_MASK)
#define ENTERPRISE_CONFIG_CH_10MHZ_DISABLE_MSB   4
#define ENTERPRISE_CONFIG_CH_10MHZ_DISABLE_LSB   4
#define ENTERPRISE_CONFIG_CH_10MHZ_DISABLE_MASK  0x00000010
#define ENTERPRISE_CONFIG_CH_10MHZ_DISABLE_GET(x) (((x) & ENTERPRISE_CONFIG_CH_10MHZ_DISABLE_MASK) >> ENTERPRISE_CONFIG_CH_10MHZ_DISABLE_LSB)
#define ENTERPRISE_CONFIG_CH_10MHZ_DISABLE_SET(x) (((x) << ENTERPRISE_CONFIG_CH_10MHZ_DISABLE_LSB) & ENTERPRISE_CONFIG_CH_10MHZ_DISABLE_MASK)
#define ENTERPRISE_CONFIG_TXBF_DISABLE_MSB       3
#define ENTERPRISE_CONFIG_TXBF_DISABLE_LSB       3
#define ENTERPRISE_CONFIG_TXBF_DISABLE_MASK      0x00000008
#define ENTERPRISE_CONFIG_TXBF_DISABLE_GET(x)    (((x) & ENTERPRISE_CONFIG_TXBF_DISABLE_MASK) >> ENTERPRISE_CONFIG_TXBF_DISABLE_LSB)
#define ENTERPRISE_CONFIG_TXBF_DISABLE_SET(x)    (((x) << ENTERPRISE_CONFIG_TXBF_DISABLE_LSB) & ENTERPRISE_CONFIG_TXBF_DISABLE_MASK)
#define ENTERPRISE_CONFIG_MIN_PKT_SIZE_DISABLE_MSB 2
#define ENTERPRISE_CONFIG_MIN_PKT_SIZE_DISABLE_LSB 2
#define ENTERPRISE_CONFIG_MIN_PKT_SIZE_DISABLE_MASK 0x00000004
#define ENTERPRISE_CONFIG_MIN_PKT_SIZE_DISABLE_GET(x) (((x) & ENTERPRISE_CONFIG_MIN_PKT_SIZE_DISABLE_MASK) >> ENTERPRISE_CONFIG_MIN_PKT_SIZE_DISABLE_LSB)
#define ENTERPRISE_CONFIG_MIN_PKT_SIZE_DISABLE_SET(x) (((x) << ENTERPRISE_CONFIG_MIN_PKT_SIZE_DISABLE_LSB) & ENTERPRISE_CONFIG_MIN_PKT_SIZE_DISABLE_MASK)
#define ENTERPRISE_CONFIG_LOOPBACK_DISABLE_MSB   1
#define ENTERPRISE_CONFIG_LOOPBACK_DISABLE_LSB   1
#define ENTERPRISE_CONFIG_LOOPBACK_DISABLE_MASK  0x00000002
#define ENTERPRISE_CONFIG_LOOPBACK_DISABLE_GET(x) (((x) & ENTERPRISE_CONFIG_LOOPBACK_DISABLE_MASK) >> ENTERPRISE_CONFIG_LOOPBACK_DISABLE_LSB)
#define ENTERPRISE_CONFIG_LOOPBACK_DISABLE_SET(x) (((x) << ENTERPRISE_CONFIG_LOOPBACK_DISABLE_LSB) & ENTERPRISE_CONFIG_LOOPBACK_DISABLE_MASK)
#define ENTERPRISE_CONFIG_LOCATION_DISABLE_MSB   0
#define ENTERPRISE_CONFIG_LOCATION_DISABLE_LSB   0
#define ENTERPRISE_CONFIG_LOCATION_DISABLE_MASK  0x00000001
#define ENTERPRISE_CONFIG_LOCATION_DISABLE_GET(x) (((x) & ENTERPRISE_CONFIG_LOCATION_DISABLE_MASK) >> ENTERPRISE_CONFIG_LOCATION_DISABLE_LSB)
#define ENTERPRISE_CONFIG_LOCATION_DISABLE_SET(x) (((x) << ENTERPRISE_CONFIG_LOCATION_DISABLE_LSB) & ENTERPRISE_CONFIG_LOCATION_DISABLE_MASK)

#define RTC_DEBUG_BUS_ADDRESS                    0x00000334
#define RTC_DEBUG_BUS_OFFSET                     0x00000334
#define RTC_DEBUG_BUS_SEL_MSB                    0
#define RTC_DEBUG_BUS_SEL_LSB                    0
#define RTC_DEBUG_BUS_SEL_MASK                   0x00000001
#define RTC_DEBUG_BUS_SEL_GET(x)                 (((x) & RTC_DEBUG_BUS_SEL_MASK) >> RTC_DEBUG_BUS_SEL_LSB)
#define RTC_DEBUG_BUS_SEL_SET(x)                 (((x) << RTC_DEBUG_BUS_SEL_LSB) & RTC_DEBUG_BUS_SEL_MASK)

#define RTC_EXT_CLK_BUF_ADDRESS                  0x00000338
#define RTC_EXT_CLK_BUF_OFFSET                   0x00000338
#define RTC_EXT_CLK_BUF_EN_MSB                   0
#define RTC_EXT_CLK_BUF_EN_LSB                   0
#define RTC_EXT_CLK_BUF_EN_MASK                  0x00000001
#define RTC_EXT_CLK_BUF_EN_GET(x)                (((x) & RTC_EXT_CLK_BUF_EN_MASK) >> RTC_EXT_CLK_BUF_EN_LSB)
#define RTC_EXT_CLK_BUF_EN_SET(x)                (((x) << RTC_EXT_CLK_BUF_EN_LSB) & RTC_EXT_CLK_BUF_EN_MASK)


#ifndef __ASSEMBLER__

typedef struct rtc_soc_reg_reg_s {
  volatile unsigned int soc_reset_control;
  volatile unsigned int soc_tcxo_detect;
  volatile unsigned int soc_xtal_test;
  unsigned char pad0[20]; /* pad to 0x20 */
  volatile unsigned int soc_cpu_clock;
  unsigned char pad1[4]; /* pad to 0x28 */
  volatile unsigned int soc_clock_control;
  unsigned char pad2[4]; /* pad to 0x30 */
  volatile unsigned int soc_wdt_control;
  volatile unsigned int soc_wdt_status;
  volatile unsigned int soc_wdt;
  volatile unsigned int soc_wdt_count;
  volatile unsigned int soc_wdt_reset;
  volatile unsigned int soc_int_status;
  volatile unsigned int soc_lf_timer0;
  volatile unsigned int soc_lf_timer_count0;
  volatile unsigned int soc_lf_timer_control0;
  volatile unsigned int soc_lf_timer_status0;
  volatile unsigned int soc_lf_timer1;
  volatile unsigned int soc_lf_timer_count1;
  volatile unsigned int soc_lf_timer_control1;
  volatile unsigned int soc_lf_timer_status1;
  volatile unsigned int soc_lf_timer2;
  volatile unsigned int soc_lf_timer_count2;
  volatile unsigned int soc_lf_timer_control2;
  volatile unsigned int soc_lf_timer_status2;
  volatile unsigned int soc_lf_timer3;
  volatile unsigned int soc_lf_timer_count3;
  volatile unsigned int soc_lf_timer_control3;
  volatile unsigned int soc_lf_timer_status3;
  volatile unsigned int soc_hf_timer;
  volatile unsigned int soc_hf_timer_count;
  volatile unsigned int soc_hf_lf_count;
  volatile unsigned int soc_hf_timer_control;
  volatile unsigned int soc_hf_timer_status;
  volatile unsigned int soc_rtc_control;
  volatile unsigned int soc_rtc_time;
  volatile unsigned int soc_rtc_date;
  volatile unsigned int soc_rtc_set_time;
  volatile unsigned int soc_rtc_set_date;
  volatile unsigned int soc_rtc_set_alarm;
  volatile unsigned int soc_rtc_config;
  volatile unsigned int soc_rtc_alarm_status;
  volatile unsigned int soc_uart_wakeup;
  volatile unsigned int soc_reset_cause;
  volatile unsigned int soc_system_sleep;
  volatile unsigned int soc_sdio_wrapper;
  volatile unsigned int soc_int_status1;
  unsigned char pad3[4]; /* pad to 0xd4 */
  volatile unsigned int soc_lpo_cal_time;
  volatile unsigned int soc_lpo_init_dividend_int;
  volatile unsigned int soc_lpo_init_dividend_fraction;
  volatile unsigned int soc_lpo_cal;
  volatile unsigned int soc_lpo_cal_test_control;
  volatile unsigned int soc_lpo_cal_test_status;
  volatile unsigned int legacy_soc_chip_id;
  volatile unsigned int soc_chip_id;
  unsigned char pad4[24]; /* pad to 0x10c */
  volatile unsigned int soc_power_reg;
  volatile unsigned int soc_core_clk_ctrl;
  volatile unsigned int soc_gpio_wakeup_control;
  unsigned char pad5[252]; /* pad to 0x214 */
  volatile unsigned int sleep_retention;
  unsigned char pad6[108]; /* pad to 0x284 */
  volatile unsigned int lp_perf_counter;
  volatile unsigned int lp_perf_light_sleep;
  volatile unsigned int lp_perf_deep_sleep;
  volatile unsigned int lp_perf_on;
  unsigned char pad7[20]; /* pad to 0x2a8 */
  volatile unsigned int chip_mode;
  volatile unsigned int clk_req_fall_edge;
  volatile unsigned int otp;
  volatile unsigned int otp_status;
  volatile unsigned int pmu;
  volatile unsigned int pmu_config;
  volatile unsigned int pmu_pareg;
  volatile unsigned int pmu_bypass;
  unsigned char pad8[20]; /* pad to 0x2dc */
  volatile unsigned int therm_ctrl1;
  volatile unsigned int therm_ctrl2;
  volatile unsigned int therm_ctrl3;
  volatile unsigned int listen_mode1;
  volatile unsigned int listen_mode2;
  volatile unsigned int audio_pll_config;
  volatile unsigned int audio_pll_modulation;
  volatile unsigned int audio_pll_mod_step;
  volatile unsigned int current_audio_pll_modulation;
  volatile unsigned int eth_pll_config;
  volatile unsigned int cpu_pll_config;
  volatile unsigned int bb_pll_config;
  volatile unsigned int eth_xmii;
  volatile unsigned int usb_phy_config;
  volatile unsigned int mitsumi_int_control_reg;
  volatile unsigned int mitsumi_int_status_reg;
  volatile unsigned int current_working_mode;
  volatile unsigned int rtc_sleep_count;
  volatile unsigned int mit2_vap;
  volatile unsigned int second_host_inft;
  volatile unsigned int sdio_host;
  volatile unsigned int enterprise_config;
  volatile unsigned int rtc_debug_bus;
  volatile unsigned int rtc_ext_clk_buf;
} rtc_soc_reg_reg_t;

#endif /* __ASSEMBLER__ */

#endif /* _RTC_SOC_REG_H_ */
