import QtQuick
import QtQuick.Studio.DesignEffects

Item {
    id: root
    width: 300
    height: 80
    property alias searchBarRadius: searchBar.radius
    property bool withIcon: true

    Rectangle {
        id: searchBar

        radius: 40
        anchors.fill: parent
        gradient: Gradient {
            GradientStop {
                position: 0
                color: "#e5eaee"
            }

            GradientStop {
                position: 1
                color: "#E6EBEE"
            }
            orientation: Gradient.Vertical
        }

        DesignEffect {
            id: designEffect
            layerBlurRadius: 1

            effects: [
                DesignDropShadow {
                    id: designDropShadow3
                    blur: 12
                    offsetX: 0
                    offsetY: -1
                    color: "#47E18383"
                },

                DesignDropShadow {
                    id: designDropShadow
                    blur: 8
                    offsetX: 3
                    offsetY: 6
                    color: "#2e100F2E"
                },
                DesignDropShadow {
                    id: designDropShadow1
                    blur: 7
                    offsetX: -4
                    offsetY: -4
                    color: "#ffffff"
                }
            ]
        }
    }

    Text {
        id: text1
        color: "#848893"
        text: qsTr("Search...")
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 30
        anchors.rightMargin: 0
        anchors.topMargin: 0
        anchors.bottomMargin: 0
        font.pixelSize: 18
        verticalAlignment: Text.AlignVCenter
    }

    Image {
        id: magGlass
        visible: root.withIcon
        anchors.verticalCenter: parent.verticalCenter
        anchors.right: parent.right
        anchors.rightMargin: 25
        source: "../images/magGlass.png"
        fillMode: Image.PreserveAspectFit
    }
}
