

/*
This is a UI file (.ui.qml) that is intended to be edited in Qt Design Studio only.
It is supposed to be strictly declarative and only uses a subset of QML. If you edit
this file manually, you might introduce QML code that is not supported by Qt Design Studio.
Check out https://doc.qt.io/qtcreator/creator-quick-ui-forms.html for details on .ui.qml files.
*/

// framework imports
import QtQuick 6.7
import QtQuick.Controls 6.7
import QtQuick.Studio.DesignEffects
import QtQuick.Layouts
import DesignEffectsDemo

// content folders
import "calculator"
import "neumorphism"
import "skeuomorphism"
import "glassmorphism"
import "FigmaBridgeEffects"

Item {
    id: root
    width: Constants.width
    height: Constants.height

    Rectangle {
        id: rectangle
        color: "#b9b9b9"
        anchors.fill: parent

        Text {
            id: galleryLabel
            x: 734
            y: 20
            text: qsTr("DESIGN EFFECTS DEMO GALLERY")
            anchors.right: parent.right
            anchors.top: parent.top
            anchors.rightMargin: 40
            anchors.topMargin: 50
            font.pixelSize: 48
            font.styleName: "SemiBold"
            font.family: "Victor Mono"
        }

        ColumnLayout {
            id: mainMenu
            width: 300
            height: 300
            anchors.left: parent.left
            anchors.top: parent.top
            anchors.leftMargin: 20
            anchors.topMargin: 200

            GalleryMenuButton {
                id: neuo
                height: 70
                autoExclusive: true
                checked: true
                buttonLabelText: "Neumorphism"
                Layout.fillWidth: true

                Connections {
                    target: neuo
                    function onClicked() {
                        galleryPanel.currentIndex = 0
                        menuPanel.currentIndex = 0
                    }
                }
            }

            GalleryMenuButton {
                id: skeuo
                height: 70
                autoExclusive: true
                buttonLabelText: "Skeuomorphism"
                Layout.fillWidth: true

                Connections {
                    target: skeuo
                    function onClicked() {
                        galleryPanel.currentIndex = 4
                        menuPanel.currentIndex = 1
                    }
                }
            }

            GalleryMenuButton {
                id: glass
                height: 70
                autoExclusive: true
                buttonLabelText: "Glassmorphism"
                Layout.fillWidth: true

                Connections {
                    target: glass
                    function onClicked() {
                        galleryPanel.currentIndex = 7
                        menuPanel.currentIndex = 2
                    }
                }
            }

            GalleryMenuButton {
                id: demo
                height: 70
                autoExclusive: true
                buttonLabelText: "Demo Project"
                Layout.fillWidth: true

                Connections {
                    target: demo
                    function onClicked() {
                        menuPanel.currentIndex = 3
                        galleryPanel.currentIndex = 11
                    }
                }
            }
        }

        Rectangle {
            id: splitter
            width: 300
            height: 5
            color: "#000000"
            anchors.bottom: mainMenu.bottom
            anchors.bottomMargin: -20
            anchors.horizontalCenter: mainMenu.horizontalCenter
        }

        StackLayout {
            id: menuPanel
            width: 300
            anchors.left: parent.left
            anchors.top: splitter.bottom
            anchors.bottom: parent.bottom
            anchors.leftMargin: 20
            anchors.topMargin: 20
            anchors.bottomMargin: 20
            currentIndex: 0

            ColumnLayout {
                id: neuoM
                Layout.fillWidth: true

                GalleryMenuButton {
                    id: nMenu1
                    height: 70
                    autoExclusive: true
                    checked: true
                    Layout.fillWidth: true
                    buttonLabelText: "Intro"

                    Connections {
                        target: nMenu1
                        function onClicked() {
                            galleryPanel.currentIndex = 0
                        }
                    }
                }

                GalleryMenuButton {
                    id: nMenu2
                    height: 70
                    autoExclusive: true
                    Layout.fillWidth: true
                    buttonLabelText: "Design Studies"

                    Connections {
                        target: nMenu2
                        function onClicked() {
                            galleryPanel.currentIndex = 1
                        }
                    }
                }

                GalleryMenuButton {
                    id: nMenu4
                    height: 70
                    autoExclusive: true
                    Layout.fillWidth: true
                    buttonLabelText: "Design Studies 2"

                    Connections {
                        target: nMenu4
                        function onClicked() {
                            galleryPanel.currentIndex = 3
                        }
                    }
                }

                GalleryMenuButton {
                    id: nMenu3
                    height: 70
                    autoExclusive: true
                    Layout.fillWidth: true
                    buttonLabelText: "Animations"

                    Connections {
                        target: nMenu3
                        function onClicked() {
                            galleryPanel.currentIndex = 2
                        }
                    }
                }
            }

            ColumnLayout {
                id: skeuoM
                Layout.fillWidth: true

                GalleryMenuButton {
                    id: sMenu1
                    height: 70
                    autoExclusive: true
                    checked: true
                    Layout.fillWidth: true
                    buttonLabelText: "Intro"

                    Connections {
                        target: sMenu1
                        function onClicked() {
                            galleryPanel.currentIndex = 4
                        }
                    }
                }

                GalleryMenuButton {
                    id: sMenu2
                    height: 70
                    autoExclusive: true
                    Layout.fillWidth: true
                    buttonLabelText: "Design Studies"

                    Connections {
                        target: sMenu2
                        function onClicked() {
                            galleryPanel.currentIndex = 5
                        }
                    }
                }

                GalleryMenuButton {
                    id: sMenu4
                    height: 70
                    Connections {
                        target: sMenu4
                        function onClicked() {
                            galleryPanel.currentIndex = 6
                        }
                    }
                    buttonLabelText: "Interaction"
                    autoExclusive: true
                    Layout.fillWidth: true
                }
            }

            ColumnLayout {
                id: glassM
                Layout.fillWidth: true

                GalleryMenuButton {
                    id: gMenu1
                    height: 70
                    autoExclusive: true
                    checked: true
                    buttonLabelText: "Intro"
                    Layout.fillWidth: true

                    Connections {
                        target: gMenu1
                        function onClicked() {
                            galleryPanel.currentIndex = 7
                        }
                    }
                }

                GalleryMenuButton {
                    id: gMenu2
                    height: 70
                    autoExclusive: true
                    Layout.fillWidth: true
                    buttonLabelText: "Design Studies"

                    Connections {
                        target: gMenu2
                        function onClicked() {
                            galleryPanel.currentIndex = 8
                        }
                    }
                }

                GalleryMenuButton {
                    id: gMenu3
                    height: 70
                    autoExclusive: true
                    Layout.fillWidth: true
                    buttonLabelText: "Animation"

                    Connections {
                        target: gMenu3
                        function onClicked() {
                            galleryPanel.currentIndex = 9
                        }
                    }
                }

                GalleryMenuButton {
                    id: gMenu4
                    height: 70
                    Connections {
                        target: gMenu4
                        function onClicked() {
                            galleryPanel.currentIndex = 10
                        }
                    }
                    buttonLabelText: "Interaction"
                    autoExclusive: true
                    Layout.fillWidth: true
                }
            }

            ColumnLayout {
                id: empty
                Layout.fillWidth: true

                Image {
                    id: bwq
                    source: "images/bwq.png"
                    mipmap: true
                    Layout.fillWidth: true
                    fillMode: Image.PreserveAspectFit
                }
            }
        }

        StackLayout {
            id: galleryPanel
            anchors.left: menuPanel.right
            anchors.right: parent.right
            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.leftMargin: 20
            anchors.rightMargin: 20
            anchors.topMargin: 200
            anchors.bottomMargin: 20
            currentIndex: 0

            NeuIntroText {
                id: neuRect
                neuVisible: true
                skeuoVisible: false
                glassVisible: false
            }

            NeumorphicControls {
                id: neumorphicControls
            }

            Neumorphism {
                id: neumorphism
            }

            Item {
                id: designStudies2
                width: 200
                height: 200
                Layout.fillHeight: true
                Layout.fillWidth: true

                ControlDesignStudies {
                    id: controlDesignStudies
                    anchors.verticalCenter: parent.verticalCenter
                    anchors.right: parent.right
                    anchors.rightMargin: 50
                }

                ColumnLayout {
                    id: figmaDesigns
                    anchors.verticalCenter: parent.verticalCenter
                    anchors.left: parent.left
                    anchors.leftMargin: 100
                    Image {
                        id: controlComponent
                        source: "images/controlComponent.png"
                        fillMode: Image.PreserveAspectFit
                    }

                    Image {
                        id: controlDesignStudies1
                        source: "images/ControlDesignStudies.png"
                        fillMode: Image.PreserveAspectFit
                    }
                }
            }

            NeuIntroText {
                id: skeuoRect
                skeuoVisible: true
                neuVisible: false
                glassVisible: false
            }

            Skueomorphism {
                id: skueomorphism
            }

            Item {
                id: skeuoInteraction
                width: 200
                height: 200
                Layout.fillHeight: true
                Layout.fillWidth: true

                Image {
                    id: effectControlFigma
                    anchors.verticalCenter: parent.verticalCenter
                    anchors.left: parent.left
                    anchors.leftMargin: 150
                    source: "images/effectsControlFigma.png"
                    fillMode: Image.PreserveAspectFit
                }

                Text {
                    id: dsLabel
                    y: 736
                    width: 514
                    height: 58
                    text: qsTr("Figma Button Template")
                    anchors.bottom: parent.bottom
                    anchors.bottomMargin: 10
                    font.pixelSize: 28
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter
                    anchors.horizontalCenter: effectControlFigma.horizontalCenter
                    font.family: "Victor Mono"
                }

                TemplateButtonDemo {
                    id: templateDemo
                    anchors.verticalCenter: parent.verticalCenter
                    anchors.right: parent.right
                    anchors.rightMargin: 200
                }

                Text {
                    id: dsLabel2
                    y: 736
                    width: 514
                    height: 58
                    text: qsTr("Actual Qt Quick Buttons")
                    anchors.bottom: parent.bottom
                    anchors.bottomMargin: 10
                    font.pixelSize: 28
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter
                    anchors.horizontalCenter: templateDemo.horizontalCenter
                    font.family: "Victor Mono"
                }
            }

            NeuIntroText {
                id: glassRect
                skeuoVisible: false
                neuVisible: false
                glassVisible: true
            }

            Item {
                id: glassStudy
                width: 200
                height: 200
                Layout.fillHeight: true
                Layout.fillWidth: true

                GlassDemo {
                    id: glassDemo
                    anchors.verticalCenter: parent.verticalCenter
                    anchors.right: parent.right
                    anchors.rightMargin: 200
                }

                Text {
                    id: dsLabel1
                    y: 736
                    width: 514
                    height: 58
                    text: qsTr("Figma Bridge Import")
                    anchors.bottom: parent.bottom
                    anchors.bottomMargin: 10
                    font.pixelSize: 28
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter
                    font.family: "Victor Mono"
                    anchors.horizontalCenter: glassDemo.horizontalCenter
                }

                Image {
                    id: figmaReference
                    anchors.verticalCenter: parent.verticalCenter
                    anchors.left: parent.left
                    anchors.leftMargin: 200
                    source: "images/GlassDemo.png"
                    fillMode: Image.PreserveAspectFit
                }

                Text {
                    id: dsLabel3
                    y: 736
                    width: 514
                    height: 58
                    text: qsTr("Figma Design")
                    anchors.bottom: parent.bottom
                    anchors.bottomMargin: 10
                    font.pixelSize: 28
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter
                    font.family: "Victor Mono"
                    anchors.horizontalCenter: figmaReference.horizontalCenter
                }
            }

            GlassDial {
                id: glassDial
            }

            BackgroundBlurDemo {
                id: draggableGlass
                width: 1560
                height: 800
            }

            Rectangle {
                id: demoPopup
                width: 200
                height: 200
                gradient: Gradient {
                    GradientStop {
                        position: 0
                        color: "#b2b2b2"
                    }

                    GradientStop {
                        position: 1
                        color: "#717171"
                    }
                    orientation: Gradient.Horizontal
                }

                DemoButton {
                    id: popButton
                    height: 70
                    anchors.verticalCenter: parent.verticalCenter
                    buttonLabelText: "Run Demo"
                    anchors.horizontalCenter: parent.horizontalCenter

                    Connections {
                        target: popButton
                        function onClicked() {
                            demoPop.open()
                        }
                    }
                }

                Popup {
                    id: demoPop
                    //due to https://bugreports.qt.io/browse/QTBUG-124479
                    //this currently doesn't work in the live preview
                    //to live preview the calculator demo you can use CalculatorDemo.ui.qml
                    parent: Overlay.overlay
                    closePolicy: Popup.CloseOnPressOutside
                    modal: true
                    focus: true
                    x: Math.round((root.width - calculatorDemo.width) / 2)
                    y: Math.round((root.height - calculatorDemo.height) / 2)
                    dim: true
                    margins: -1
                    padding: 0

                    contentItem: CalculatorDemo {
                        id: calculatorDemo
                    }
                    background: Rectangle {
                        implicitHeight: 1080
                        implicitWidth: 1032
                        color: "#FFFFFF"
                    }
                }
            }
        }

        Image {
            id: qtGroup_logo_black
            width: 300
            anchors.left: parent.left
            anchors.top: parent.top
            anchors.leftMargin: 20
            anchors.topMargin: 50
            source: "images/QtGroup_logo_black.png"
            mipmap: true
            fillMode: Image.PreserveAspectFit
        }
    }
}
