import QtQuick
import QtQuick.Controls
import QtQuick.Studio.DesignEffects 1.0

Rectangle {
    id: buttonLow
    width: 100
    height: 100
    color: "transparent"
    property alias labelText: label.text

    Rectangle {
        id: hole
        color: "#181614"
        radius: 3
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
    }

    Rectangle {
        id: button
        radius: 9
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 3
        anchors.rightMargin: 4
        anchors.topMargin: 2
        anchors.bottomMargin: 2
        gradient: Gradient {
            id: button_Gradient
            GradientStop {
                id: button_GradientStop_0
                position: 0
                color: "#ff2c2c2c"
            }

            GradientStop {
                id: button_GradientStop_1
                position: 1
                color: "#ff282828"
            }
            orientation: Gradient.Vertical
        }
        DesignEffect {
            id: button_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
            effects: [
                DesignDropShadow {
                    id: button_DesignDropShadow_0
                    visible: true
                    color: "#6e000000"
                    spread: 0
                    offsetY: 11
                    offsetX: 8
                    blur: 18
                },
                DesignInnerShadow {
                    id: button_DesignInnerShadow_1
                    visible: true
                    color: "#7a000000"
                    spread: 0
                    offsetY: -2
                    offsetX: -2
                    blur: 3
                },
                DesignInnerShadow {
                    id: button_DesignInnerShadow_2
                    visible: true
                    color: "#ffffffff"
                    spread: 0
                    offsetY: 2
                    offsetX: 2
                    blur: 3
                }
            ]
        }
    }

    Text {
        id: label
        color: "#d7d6d6"
        text: qsTr("A")
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 13
        anchors.rightMargin: 23
        anchors.topMargin: 2
        anchors.bottomMargin: 39
        font.pixelSize: 31
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.Wrap
        font.weight: Font.Bold
        font.family: "DIN Alternate"
        DesignEffect {
            id: label_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
        }
    }
}

/*##^##
Designer {
    D{i:0;uuid:"0d7d4da6-66c9-5bae-8e43-7857e34579bc"}D{i:1;uuid:"624c0205-7bfe-5a54-b172-8dcf6c0a26ac"}
D{i:2;uuid:"b07380fd-a5a4-5a6c-a91d-638b6bcf4c87"}D{i:6;uuid:"b07380fd-a5a4-5a6c-a91d-638b6bcf4c87_DesignEffect"}
D{i:7;uuid:"b07380fd-a5a4-5a6c-a91d-638b6bcf4c87_DesignDropShadow_0"}D{i:8;uuid:"b07380fd-a5a4-5a6c-a91d-638b6bcf4c87_DesignInnerShadow_1"}
D{i:9;uuid:"b07380fd-a5a4-5a6c-a91d-638b6bcf4c87_DesignInnerShadow_2"}D{i:3;uuid:"b07380fd-a5a4-5a6c-a91d-638b6bcf4c87_Gradient"}
D{i:4;uuid:"b07380fd-a5a4-5a6c-a91d-638b6bcf4c87_GradientStop_0"}D{i:5;uuid:"b07380fd-a5a4-5a6c-a91d-638b6bcf4c87_GradientStop_1"}
D{i:10;uuid:"91636d04-bcc0-5cad-8cc3-182f6878ce1c"}D{i:11;uuid:"91636d04-bcc0-5cad-8cc3-182f6878ce1c_DesignEffect"}
}
##^##*/

