/*
 * arch/arm/mach-sun4i/clock/ccmu/pll_cfg_tbl.c
 *
 * (C) Copyright 2007-2012
 * Allwinner Technology Co., Ltd. <www.allwinnertech.com>
 * Kevin Zhang <kevin@allwinnertech.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include "ccm_i.h"
#include <mach/aw_ccu.h>

struct core_pll_freq_tbl{
    __u8    FactorN;
    __u8    FactorK;
    __u8    FactorM;
    __u8    FactorP;
    __u32   Pll;
};

/* core pll parameter table */
static struct core_pll_freq_tbl    CorePllTbl[] = {

    { 10,    0,    0,    3,    30000000  },   /* freq = (6M * 5  ), index = 0   */
    { 10,    0,    0,    3,    30000000  },   /* freq = (6M * 5  ), index = 1   */
    { 10,    0,    0,    3,    30000000  },   /* freq = (6M * 5  ), index = 2   */
    { 10,    0,    0,    3,    30000000  },   /* freq = (6M * 5  ), index = 3   */
    { 10,    0,    0,    3,    30000000  },   /* freq = (6M * 5  ), index = 4   */
    { 10,    0,    0,    3,    30000000  },   /* freq = (6M * 5  ), index = 5   */
    { 12,    0,    0,    3,    36000000  },   /* freq = (6M * 6  ), index = 6   */
    { 7 ,    1,    0,    3,    42000000  },   /* freq = (6M * 7  ), index = 7   */
    { 16,    0,    0,    3,    48000000  },   /* freq = (6M * 8  ), index = 8   */
    { 9 ,    1,    0,    3,    54000000  },   /* freq = (6M * 9  ), index = 9   */
    { 10,    0,    0,    2,    60000000  },   /* freq = (6M * 10 ), index = 10  */
    { 11,    0,    0,    2,    66000000  },   /* freq = (6M * 11 ), index = 11  */
    { 12,    0,    0,    2,    72000000  },   /* freq = (6M * 12 ), index = 12  */
    { 13,    0,    0,    2,    78000000  },   /* freq = (6M * 13 ), index = 13  */
    { 14,    0,    0,    2,    84000000  },   /* freq = (6M * 14 ), index = 14  */
    { 15,    0,    0,    2,    90000000  },   /* freq = (6M * 15 ), index = 15  */
    { 16,    0,    0,    2,    96000000  },   /* freq = (6M * 16 ), index = 16  */
    { 17,    0,    0,    2,    102000000 },   /* freq = (6M * 17 ), index = 17  */
    { 18,    0,    0,    2,    108000000 },   /* freq = (6M * 18 ), index = 18  */
    { 19,    0,    0,    2,    114000000 },   /* freq = (6M * 19 ), index = 19  */
    { 10,    0,    0,    1,    120000000 },   /* freq = (6M * 20 ), index = 20  */
    { 21,    0,    0,    2,    126000000 },   /* freq = (6M * 21 ), index = 21  */
    { 11,    0,    0,    1,    132000000 },   /* freq = (6M * 22 ), index = 22  */
    { 23,    0,    0,    2,    138000000 },   /* freq = (6M * 23 ), index = 23  */
    { 12,    0,    0,    1,    144000000 },   /* freq = (6M * 24 ), index = 24  */
    { 25,    0,    0,    2,    150000000 },   /* freq = (6M * 25 ), index = 25  */
    { 13,    0,    0,    1,    156000000 },   /* freq = (6M * 26 ), index = 26  */
    { 27,    0,    0,    2,    162000000 },   /* freq = (6M * 27 ), index = 27  */
    { 14,    0,    0,    1,    168000000 },   /* freq = (6M * 28 ), index = 28  */
    { 29,    0,    0,    2,    174000000 },   /* freq = (6M * 29 ), index = 29  */
    { 15,    0,    0,    1,    180000000 },   /* freq = (6M * 30 ), index = 30  */
    { 31,    0,    0,    2,    186000000 },   /* freq = (6M * 31 ), index = 31  */
    { 16,    0,    0,    1,    192000000 },   /* freq = (6M * 32 ), index = 32  */
    { 16,    0,    0,    1,    192000000 },   /* freq = (6M * 32 ), index = 33  */
    { 17,    0,    0,    1,    204000000 },   /* freq = (6M * 34 ), index = 34  */
    { 17,    0,    0,    1,    204000000 },   /* freq = (6M * 34 ), index = 35  */
    { 18,    0,    0,    1,    216000000 },   /* freq = (6M * 36 ), index = 36  */
    { 18,    0,    0,    1,    216000000 },   /* freq = (6M * 36 ), index = 37  */
    { 19,    0,    0,    1,    228000000 },   /* freq = (6M * 38 ), index = 38  */
    { 19,    0,    0,    1,    228000000 },   /* freq = (6M * 38 ), index = 39  */
    { 10,    0,    0,    0,    240000000 },   /* freq = (6M * 40 ), index = 40  */
    { 10,    0,    0,    0,    240000000 },   /* freq = (6M * 40 ), index = 41  */
    { 21,    0,    0,    1,    252000000 },   /* freq = (6M * 42 ), index = 42  */
    { 21,    0,    0,    1,    252000000 },   /* freq = (6M * 42 ), index = 43  */
    { 11,    0,    0,    0,    264000000 },   /* freq = (6M * 44 ), index = 44  */
    { 11,    0,    0,    0,    264000000 },   /* freq = (6M * 44 ), index = 45  */
    { 23,    0,    0,    1,    276000000 },   /* freq = (6M * 46 ), index = 46  */
    { 23,    0,    0,    1,    276000000 },   /* freq = (6M * 46 ), index = 47  */
    { 12,    0,    0,    0,    288000000 },   /* freq = (6M * 48 ), index = 48  */
    { 12,    0,    0,    0,    288000000 },   /* freq = (6M * 48 ), index = 49  */
    { 25,    0,    0,    1,    300000000 },   /* freq = (6M * 50 ), index = 50  */
    { 25,    0,    0,    1,    300000000 },   /* freq = (6M * 50 ), index = 51  */
    { 13,    0,    0,    0,    312000000 },   /* freq = (6M * 52 ), index = 52  */
    { 13,    0,    0,    0,    312000000 },   /* freq = (6M * 52 ), index = 53  */
    { 27,    0,    0,    1,    324000000 },   /* freq = (6M * 54 ), index = 54  */
    { 27,    0,    0,    1,    324000000 },   /* freq = (6M * 54 ), index = 55  */
    { 14,    0,    0,    0,    336000000 },   /* freq = (6M * 56 ), index = 56  */
    { 14,    0,    0,    0,    336000000 },   /* freq = (6M * 56 ), index = 57  */
    { 29,    0,    0,    1,    348000000 },   /* freq = (6M * 58 ), index = 58  */
    { 29,    0,    0,    1,    348000000 },   /* freq = (6M * 58 ), index = 59  */
    { 15,    0,    0,    0,    360000000 },   /* freq = (6M * 60 ), index = 60  */
    { 15,    0,    0,    0,    360000000 },   /* freq = (6M * 60 ), index = 61  */
    { 31,    0,    0,    1,    372000000 },   /* freq = (6M * 62 ), index = 62  */
    { 31,    0,    0,    1,    372000000 },   /* freq = (6M * 62 ), index = 63  */
    { 16,    0,    0,    0,    384000000 },   /* freq = (6M * 64 ), index = 64  */
    { 16,    0,    0,    0,    384000000 },   /* freq = (6M * 64 ), index = 65  */
    { 16,    0,    0,    0,    384000000 },   /* freq = (6M * 64 ), index = 66  */
    { 16,    0,    0,    0,    384000000 },   /* freq = (6M * 64 ), index = 67  */
    { 17,    0,    0,    0,    408000000 },   /* freq = (6M * 68 ), index = 68  */
    { 17,    0,    0,    0,    408000000 },   /* freq = (6M * 68 ), index = 69  */
    { 17,    0,    0,    0,    408000000 },   /* freq = (6M * 68 ), index = 70  */
    { 17,    0,    0,    0,    408000000 },   /* freq = (6M * 68 ), index = 71  */
    { 18,    0,    0,    0,    432000000 },   /* freq = (6M * 72 ), index = 72  */
    { 18,    0,    0,    0,    432000000 },   /* freq = (6M * 72 ), index = 73  */
    { 18,    0,    0,    0,    432000000 },   /* freq = (6M * 72 ), index = 74  */
    { 18,    0,    0,    0,    432000000 },   /* freq = (6M * 72 ), index = 75  */
    { 19,    0,    0,    0,    456000000 },   /* freq = (6M * 76 ), index = 76  */
    { 19,    0,    0,    0,    456000000 },   /* freq = (6M * 76 ), index = 77  */
    { 19,    0,    0,    0,    456000000 },   /* freq = (6M * 76 ), index = 78  */
    { 19,    0,    0,    0,    456000000 },   /* freq = (6M * 76 ), index = 79  */
    { 20,    0,    0,    0,    480000000 },   /* freq = (6M * 80 ), index = 80  */
    { 20,    0,    0,    0,    480000000 },   /* freq = (6M * 80 ), index = 81  */
    { 20,    0,    0,    0,    480000000 },   /* freq = (6M * 80 ), index = 82  */
    { 20,    0,    0,    0,    480000000 },   /* freq = (6M * 80 ), index = 83  */
    { 21,    0,    0,    0,    504000000 },   /* freq = (6M * 84 ), index = 84  */
    { 21,    0,    0,    0,    504000000 },   /* freq = (6M * 84 ), index = 85  */
    { 21,    0,    0,    0,    504000000 },   /* freq = (6M * 84 ), index = 86  */
    { 21,    0,    0,    0,    504000000 },   /* freq = (6M * 84 ), index = 87  */
    { 22,    0,    0,    0,    528000000 },   /* freq = (6M * 88 ), index = 88  */
    { 22,    0,    0,    0,    528000000 },   /* freq = (6M * 88 ), index = 89  */
    { 22,    0,    0,    0,    528000000 },   /* freq = (6M * 88 ), index = 90  */
    { 22,    0,    0,    0,    528000000 },   /* freq = (6M * 88 ), index = 91  */
    { 23,    0,    0,    0,    552000000 },   /* freq = (6M * 92 ), index = 92  */
    { 23,    0,    0,    0,    552000000 },   /* freq = (6M * 92 ), index = 93  */
    { 23,    0,    0,    0,    552000000 },   /* freq = (6M * 92 ), index = 94  */
    { 23,    0,    0,    0,    552000000 },   /* freq = (6M * 92 ), index = 95  */
    { 24,    0,    0,    0,    576000000 },   /* freq = (6M * 96 ), index = 96  */
    { 24,    0,    0,    0,    576000000 },   /* freq = (6M * 96 ), index = 97  */
    { 24,    0,    0,    0,    576000000 },   /* freq = (6M * 96 ), index = 98  */
    { 24,    0,    0,    0,    576000000 },   /* freq = (6M * 96 ), index = 99  */
    { 25,    0,    0,    0,    600000000 },   /* freq = (6M * 100), index = 100 */
    { 25,    0,    0,    0,    600000000 },   /* freq = (6M * 100), index = 101 */
    { 25,    0,    0,    0,    600000000 },   /* freq = (6M * 100), index = 102 */
    { 25,    0,    0,    0,    600000000 },   /* freq = (6M * 100), index = 103 */
    { 26,    0,    0,    0,    624000000 },   /* freq = (6M * 104), index = 104 */
    { 26,    0,    0,    0,    624000000 },   /* freq = (6M * 104), index = 105 */
    { 26,    0,    0,    0,    624000000 },   /* freq = (6M * 104), index = 106 */
    { 26,    0,    0,    0,    624000000 },   /* freq = (6M * 104), index = 107 */
    { 27,    0,    0,    0,    648000000 },   /* freq = (6M * 108), index = 108 */
    { 27,    0,    0,    0,    648000000 },   /* freq = (6M * 108), index = 109 */
    { 27,    0,    0,    0,    648000000 },   /* freq = (6M * 108), index = 110 */
    { 27,    0,    0,    0,    648000000 },   /* freq = (6M * 108), index = 111 */
    { 28,    0,    0,    0,    672000000 },   /* freq = (6M * 112), index = 112 */
    { 28,    0,    0,    0,    672000000 },   /* freq = (6M * 112), index = 113 */
    { 28,    0,    0,    0,    672000000 },   /* freq = (6M * 112), index = 114 */
    { 28,    0,    0,    0,    672000000 },   /* freq = (6M * 112), index = 115 */
    { 29,    0,    0,    0,    696000000 },   /* freq = (6M * 116), index = 116 */
    { 29,    0,    0,    0,    696000000 },   /* freq = (6M * 116), index = 117 */
    { 29,    0,    0,    0,    696000000 },   /* freq = (6M * 116), index = 118 */
    { 29,    0,    0,    0,    696000000 },   /* freq = (6M * 116), index = 119 */
    { 30,    0,    0,    0,    720000000 },   /* freq = (6M * 120), index = 120 */
    { 30,    0,    0,    0,    720000000 },   /* freq = (6M * 120), index = 121 */
    { 30,    0,    0,    0,    720000000 },   /* freq = (6M * 120), index = 122 */
    { 30,    0,    0,    0,    720000000 },   /* freq = (6M * 120), index = 123 */
    { 31,    0,    0,    0,    744000000 },   /* freq = (6M * 124), index = 124 */
    { 31,    0,    0,    0,    744000000 },   /* freq = (6M * 124), index = 125 */
    { 31,    0,    0,    0,    744000000 },   /* freq = (6M * 124), index = 126 */
    { 31,    0,    0,    0,    744000000 },   /* freq = (6M * 124), index = 127 */
    { 16,    1,    0,    0,    768000000 },   /* freq = (6M * 128), index = 128 */
    { 16,    1,    0,    0,    768000000 },   /* freq = (6M * 128), index = 129 */
    { 16,    1,    0,    0,    768000000 },   /* freq = (6M * 128), index = 130 */
    { 16,    1,    0,    0,    768000000 },   /* freq = (6M * 128), index = 131 */
    { 16,    1,    0,    0,    768000000 },   /* freq = (6M * 128), index = 132 */
    { 16,    1,    0,    0,    768000000 },   /* freq = (6M * 128), index = 133 */
    { 16,    1,    0,    0,    768000000 },   /* freq = (6M * 128), index = 134 */
    { 16,    1,    0,    0,    768000000 },   /* freq = (6M * 128), index = 135 */
    { 17,    1,    0,    0,    816000000 },   /* freq = (6M * 136), index = 136 */
    { 17,    1,    0,    0,    816000000 },   /* freq = (6M * 136), index = 137 */
    { 17,    1,    0,    0,    816000000 },   /* freq = (6M * 136), index = 138 */
    { 17,    1,    0,    0,    816000000 },   /* freq = (6M * 136), index = 139 */
    { 17,    1,    0,    0,    816000000 },   /* freq = (6M * 136), index = 140 */
    { 17,    1,    0,    0,    816000000 },   /* freq = (6M * 136), index = 141 */
    { 17,    1,    0,    0,    816000000 },   /* freq = (6M * 136), index = 142 */
    { 17,    1,    0,    0,    816000000 },   /* freq = (6M * 136), index = 143 */
    { 18,    1,    0,    0,    864000000 },   /* freq = (6M * 144), index = 144 */
    { 18,    1,    0,    0,    864000000 },   /* freq = (6M * 144), index = 145 */
    { 18,    1,    0,    0,    864000000 },   /* freq = (6M * 144), index = 146 */
    { 18,    1,    0,    0,    864000000 },   /* freq = (6M * 144), index = 147 */
    { 18,    1,    0,    0,    864000000 },   /* freq = (6M * 144), index = 148 */
    { 18,    1,    0,    0,    864000000 },   /* freq = (6M * 144), index = 149 */
    { 18,    1,    0,    0,    864000000 },   /* freq = (6M * 144), index = 150 */
    { 18,    1,    0,    0,    864000000 },   /* freq = (6M * 144), index = 151 */
    { 19,    1,    0,    0,    912000000 },   /* freq = (6M * 152), index = 152 */
    { 19,    1,    0,    0,    912000000 },   /* freq = (6M * 152), index = 153 */
    { 19,    1,    0,    0,    912000000 },   /* freq = (6M * 152), index = 154 */
    { 19,    1,    0,    0,    912000000 },   /* freq = (6M * 152), index = 155 */
    { 19,    1,    0,    0,    912000000 },   /* freq = (6M * 152), index = 156 */
    { 19,    1,    0,    0,    912000000 },   /* freq = (6M * 152), index = 157 */
    { 19,    1,    0,    0,    912000000 },   /* freq = (6M * 152), index = 158 */
    { 19,    1,    0,    0,    912000000 },   /* freq = (6M * 152), index = 159 */
    { 20,    1,    0,    0,    960000000 },   /* freq = (6M * 160), index = 160 */
    { 20,    1,    0,    0,    960000000 },   /* freq = (6M * 160), index = 161 */
    { 20,    1,    0,    0,    960000000 },   /* freq = (6M * 160), index = 162 */
    { 20,    1,    0,    0,    960000000 },   /* freq = (6M * 160), index = 163 */
    { 20,    1,    0,    0,    960000000 },   /* freq = (6M * 160), index = 164 */
    { 20,    1,    0,    0,    960000000 },   /* freq = (6M * 160), index = 165 */
    { 20,    1,    0,    0,    960000000 },   /* freq = (6M * 160), index = 166 */
    { 20,    1,    0,    0,    960000000 },   /* freq = (6M * 160), index = 167 */
    { 21,    1,    0,    0,    1008000000},   /* freq = (6M * 168), index = 168 */
    { 21,    1,    0,    0,    1008000000},   /* freq = (6M * 168), index = 169 */
    { 21,    1,    0,    0,    1008000000},   /* freq = (6M * 168), index = 170 */
    { 21,    1,    0,    0,    1008000000},   /* freq = (6M * 168), index = 171 */
    { 21,    1,    0,    0,    1008000000},   /* freq = (6M * 168), index = 172 */
    { 21,    1,    0,    0,    1008000000},   /* freq = (6M * 168), index = 173 */
    { 21,    1,    0,    0,    1008000000},   /* freq = (6M * 168), index = 174 */
    { 21,    1,    0,    0,    1008000000},   /* freq = (6M * 168), index = 175 */
    { 22,    1,    0,    0,    1056000000},   /* freq = (6M * 176), index = 176 */
    { 22,    1,    0,    0,    1056000000},   /* freq = (6M * 176), index = 177 */
    { 22,    1,    0,    0,    1056000000},   /* freq = (6M * 176), index = 178 */
    { 22,    1,    0,    0,    1056000000},   /* freq = (6M * 176), index = 179 */
    { 22,    1,    0,    0,    1056000000},   /* freq = (6M * 176), index = 180 */
    { 22,    1,    0,    0,    1056000000},   /* freq = (6M * 176), index = 181 */
    { 22,    1,    0,    0,    1056000000},   /* freq = (6M * 176), index = 182 */
    { 22,    1,    0,    0,    1056000000},   /* freq = (6M * 176), index = 183 */
    { 23,    1,    0,    0,    1104000000},   /* freq = (6M * 184), index = 184 */
    { 23,    1,    0,    0,    1104000000},   /* freq = (6M * 184), index = 185 */
    { 23,    1,    0,    0,    1104000000},   /* freq = (6M * 184), index = 186 */
    { 23,    1,    0,    0,    1104000000},   /* freq = (6M * 184), index = 187 */
    { 23,    1,    0,    0,    1104000000},   /* freq = (6M * 184), index = 188 */
    { 23,    1,    0,    0,    1104000000},   /* freq = (6M * 184), index = 189 */
    { 23,    1,    0,    0,    1104000000},   /* freq = (6M * 184), index = 190 */
    { 23,    1,    0,    0,    1104000000},   /* freq = (6M * 184), index = 191 */
    { 24,    1,    0,    0,    1152000000},   /* freq = (6M * 192), index = 192 */
    { 24,    1,    0,    0,    1152000000},   /* freq = (6M * 192), index = 193 */
    { 24,    1,    0,    0,    1152000000},   /* freq = (6M * 192), index = 194 */
    { 24,    1,    0,    0,    1152000000},   /* freq = (6M * 192), index = 195 */
    { 24,    1,    0,    0,    1152000000},   /* freq = (6M * 192), index = 196 */
    { 24,    1,    0,    0,    1152000000},   /* freq = (6M * 192), index = 197 */
    { 24,    1,    0,    0,    1152000000},   /* freq = (6M * 192), index = 198 */
    { 24,    1,    0,    0,    1152000000},   /* freq = (6M * 192), index = 199 */
    { 25,    1,    0,    0,    1200000000},   /* freq = (6M * 200), index = 200 */
    { 25,    1,    0,    0,    1200000000},   /* freq = (6M * 200), index = 201 */
    { 25,    1,    0,    0,    1200000000},   /* freq = (6M * 200), index = 202 */
    { 25,    1,    0,    0,    1200000000},   /* freq = (6M * 200), index = 203 */
    { 25,    1,    0,    0,    1200000000},   /* freq = (6M * 200), index = 204 */
    { 25,    1,    0,    0,    1200000000},   /* freq = (6M * 200), index = 205 */
    { 25,    1,    0,    0,    1200000000},   /* freq = (6M * 200), index = 206 */
    { 25,    1,    0,    0,    1200000000},   /* freq = (6M * 200), index = 207 */
    { 26,    1,    0,    0,    1248000000},   /* freq = (6M * 208), index = 208 */
    { 26,    1,    0,    0,    1248000000},   /* freq = (6M * 208), index = 209 */
    { 26,    1,    0,    0,    1248000000},   /* freq = (6M * 208), index = 210 */
    { 26,    1,    0,    0,    1248000000},   /* freq = (6M * 208), index = 211 */
    { 26,    1,    0,    0,    1248000000},   /* freq = (6M * 208), index = 212 */
    { 26,    1,    0,    0,    1248000000},   /* freq = (6M * 208), index = 213 */
    { 26,    1,    0,    0,    1248000000},   /* freq = (6M * 208), index = 214 */
    { 26,    1,    0,    0,    1248000000},   /* freq = (6M * 208), index = 215 */
    { 27,    1,    0,    0,    1296000000},   /* freq = (6M * 216), index = 216 */
    { 27,    1,    0,    0,    1296000000},   /* freq = (6M * 216), index = 217 */
    { 27,    1,    0,    0,    1296000000},   /* freq = (6M * 216), index = 218 */
    { 27,    1,    0,    0,    1296000000},   /* freq = (6M * 216), index = 219 */
    { 27,    1,    0,    0,    1296000000},   /* freq = (6M * 216), index = 220 */
    { 27,    1,    0,    0,    1296000000},   /* freq = (6M * 216), index = 221 */
    { 27,    1,    0,    0,    1296000000},   /* freq = (6M * 216), index = 222 */
    { 27,    1,    0,    0,    1296000000},   /* freq = (6M * 216), index = 223 */
    { 28,    1,    0,    0,    1344000000},   /* freq = (6M * 224), index = 224 */
    { 28,    1,    0,    0,    1344000000},   /* freq = (6M * 224), index = 225 */
    { 28,    1,    0,    0,    1344000000},   /* freq = (6M * 224), index = 226 */
    { 28,    1,    0,    0,    1344000000},   /* freq = (6M * 224), index = 227 */
    { 28,    1,    0,    0,    1344000000},   /* freq = (6M * 224), index = 228 */
    { 28,    1,    0,    0,    1344000000},   /* freq = (6M * 224), index = 229 */
    { 28,    1,    0,    0,    1344000000},   /* freq = (6M * 224), index = 230 */
    { 28,    1,    0,    0,    1344000000},   /* freq = (6M * 224), index = 231 */
    { 29,    1,    0,    0,    1392000000},   /* freq = (6M * 232), index = 232 */
    { 29,    1,    0,    0,    1392000000},   /* freq = (6M * 232), index = 233 */
    { 29,    1,    0,    0,    1392000000},   /* freq = (6M * 232), index = 234 */
    { 29,    1,    0,    0,    1392000000},   /* freq = (6M * 232), index = 235 */
    { 29,    1,    0,    0,    1392000000},   /* freq = (6M * 232), index = 236 */
    { 29,    1,    0,    0,    1392000000},   /* freq = (6M * 232), index = 237 */
    { 29,    1,    0,    0,    1392000000},   /* freq = (6M * 232), index = 238 */
    { 29,    1,    0,    0,    1392000000},   /* freq = (6M * 232), index = 239 */
    { 30,    1,    0,    0,    1440000000},   /* freq = (6M * 240), index = 240 */
    { 30,    1,    0,    0,    1440000000},   /* freq = (6M * 240), index = 241 */
    { 30,    1,    0,    0,    1440000000},   /* freq = (6M * 240), index = 242 */
    { 30,    1,    0,    0,    1440000000},   /* freq = (6M * 240), index = 243 */
    { 30,    1,    0,    0,    1440000000},   /* freq = (6M * 240), index = 244 */
    { 30,    1,    0,    0,    1440000000},   /* freq = (6M * 240), index = 245 */
    { 30,    1,    0,    0,    1440000000},   /* freq = (6M * 240), index = 246 */
    { 30,    1,    0,    0,    1440000000},   /* freq = (6M * 240), index = 247 */
    { 31,    1,    0,    0,    1488000000},   /* freq = (6M * 248), index = 248 */
};


int ccm_clk_get_pll_para(struct core_pll_factor_t *factor, __u64 rate)
{
    int     index;

    if(!factor)
    {
        return -1;
    }

    if(rate > 1488000000)
    {
        rate = 1488000000;
    }
    index = ccu_clk_uldiv(rate, 6000000);

    factor->FactorN = CorePllTbl[index].FactorN;
    factor->FactorK = CorePllTbl[index].FactorK;
    factor->FactorM = CorePllTbl[index].FactorM;
    factor->FactorP = CorePllTbl[index].FactorP;

    return 0;
}

