import QtQuick 2.8
import QtQuick.Studio.Components 1.0
import DigitalCluster 1.0

GroupItem {
    id: buttonsInteriorLight

    CPbutton {
        id: buttonInteriorDarker
        x: 0
        y: 0
        width: 120
        height: 50
        buttonState: "left"

        labelText: "darker"

        Connections {
            target: buttonInteriorDarker.mouseArea
            onPressed: {
                Car3dControl.makeInteriorDarkerButtonPressed = true
                buttonInteriorDarker.state = "on"
                buttonInteriorBrighter.state = "off" // activates second button if it was disabled
            }
        }

        Connections {
            target: buttonInteriorDarker.mouseArea
            onReleased: {
                Car3dControl.makeInteriorDarkerButtonPressed = false
                buttonInteriorDarker.state = Car3dControl.interiorBrightness
                        === 0.0 ? "disabled" : "off"
            }
        }
    }

    CPbutton {
        id: buttonInteriorBrighter
        x: 121
        y: 0
        width: 120
        height: 50
        labelText: "brighter"
        buttonState: "center"

        Connections {
            target: buttonInteriorBrighter.mouseArea
            onPressed: {
                Car3dControl.makeInteriorBrighterButtonPressed = true
                buttonInteriorBrighter.state = "on"
                buttonInteriorDarker.state = "off" // activates second button if it was disabled
            }
        }

        Connections {
            target: buttonInteriorBrighter.mouseArea
            onReleased: {
                Car3dControl.makeInteriorBrighterButtonPressed = false
                buttonInteriorBrighter.state = Car3dControl.interiorBrightness
                        === 1.0 ? "disabled" : "off"
            }
        }
    }

    CPbutton {
        id: buttonInteriorHuePlus
        x: 242
        y: 0
        width: 120
        height: 50
        clip: true
        buttonState: "right"
        labelText: "hue"

        Connections {
            target: buttonInteriorHuePlus.mouseArea
            onPressed: {

                Car3dControl.hueChangePaused = false
                buttonInteriorHuePlus.state = "on"
            }
        }

        Connections {
            target: buttonInteriorHuePlus.mouseArea
            onReleased: {
                buttonInteriorHuePlus.state = "off"
                Car3dControl.hueChangePaused = true
            }
        }
    }
}

/*##^##
Designer {
    D{i:0;height:50;width:363}
}
##^##*/

