import QtQuick
import QtQuick3D
import QtQuick.Timeline
Node {
    id: rootNode
    Node {
        id: qtLogo
        y: -2.33196
        rotation: Qt.quaternion(0.999829, -0.00118362, 0.018435, 0.000880325)
        scale.x: 1
        scale.z: 1
        Model {
            id: qt_green
            x: -0.179
            y: 1.358
            z: 1.28812
            source: "meshes/qt_green.mesh"
            scale.z: 1
            scale.y: 1
            scale.x: 1
            eulerRotation.z: 0.1276
            eulerRotation.y: 45.54668
            eulerRotation.x: 0.02902

            DefaultMaterial {
                id: mat_2_material
                opacity: 0.8
                bumpAmount: 1
                normalMap: glassNormal1
                indexOfRefraction: 3
                fresnelPower: -5
                specularRoughness: 0.001
                specularReflectionMap: car_day_hdr
                specularAmount: 1
                blendMode: DefaultMaterial.SourceOver
                specularTint: "#ffffff"
                lightProbe: car_day_hdr
                diffuseLightWrap: 0.2
                translucentFalloff: 2
                diffuseColor: "#2fa321"

                Texture {
                    id: glassNormal1
                    source: "../../../Simple3DContent/images/glassNormal.png"
                }
            }
            materials: [
                mat_2_material
            ]
        }
        Model {
            id: qt
            x: 0.179
            y: -1.358
            z: 2.38132
            source: "meshes/qt.mesh"
            eulerRotation.z: 0.1276
            eulerRotation.y: 45.54668
            eulerRotation.x: 0.02902

            DefaultMaterial {
                id: mat_3_material
                blendMode: DefaultMaterial.SourceOver
                specularTint: "#e4e4e4"
                specularAmount: 0.3
                lightProbe: car_day_hdr
                diffuseColor: "#ffffff"
            }
            materials: [
                mat_3_material
            ]
        }
    }
    Model {
        id: tube
        source: "meshes/tube.mesh"

        DefaultMaterial {
            id: mat_material
            diffuseColor: "#686868"
            specularTint: "#567f46"
            specularAmount: 1
            specularRoughness: 0.001
            lightProbe: car_day_hdr

            Texture {
                id: car_day_hdr
                source: "../../../Simple3DContent/images/car_day_hdr.hdr"
                mappingMode: Texture.LightProbe
            }
        }
        materials: [
            mat_material
        ]
    }
    Model {
        id: tube_1
        rotation: Qt.quaternion(0.5, -0.5, 0.5, -0.5)
        source: "meshes/tube_1.mesh"
        materials: [
            mat_material
        ]
    }
    Model {
        id: tube_2
        rotation: Qt.quaternion(0.707107, 0, 0, 0.707107)
        source: "meshes/tube_2.mesh"
        materials: [
            mat_material
        ]
    }
    Model {
        id: tube_3
        rotation: Qt.quaternion(0.707107, 0, 0.707107, 0)
        source: "meshes/tube_3.mesh"
        materials: [
            mat_material
        ]
    }
    Model {
        id: tube_4
        rotation: Qt.quaternion(0.653282, -0.270598, 0.270598, -0.653281)
        scale.y: 1
        scale.z: 1
        source: "meshes/tube_4.mesh"
        materials: [
            mat_material
        ]
    }
    Model {
        id: tube_6
        rotation: Qt.quaternion(0.92388, 0, 0.382683, 0)
        scale.x: 1
        scale.z: 1
        source: "meshes/tube_6.mesh"
        materials: [
            mat_material
        ]
    }
    Model {
        id: tube_5
        rotation: Qt.quaternion(0.653282, 0.270598, -0.270598, -0.653281)
        scale.y: 1
        scale.z: 1
        source: "meshes/tube_5.mesh"
        materials: [
            mat_material
        ]
    }
    Model {
        id: tube_7
        rotation: Qt.quaternion(1.91069e-15, 4.37114e-08, 1, 4.37114e-08)
        source: "meshes/tube_7.mesh"
        materials: [
            mat_material
        ]
        Model {
            id: text_
            x: 9.95561e-16
            y: -8.12937
            z: 9.95561e-16
            rotation: Qt.quaternion(0.92388, 0, 0.382683, 0)
            scale.x: 1
            scale.z: 1
            source: "meshes/text_.mesh"

            DefaultMaterial {
                id: mat_4_material
                lightProbe: car_day_hdr
                diffuseColor: "#c5c5c5"
            }
            materials: [
                mat_4_material
            ]
        }
    }

    Timeline {
        id: timeline0
        startFrame: 0
        endFrame: 2000
        currentFrame: 0
        enabled: true
        animations: [
            TimelineAnimation {
                pingPong: true
                duration: 4000
                from: 0
                to: 2000
                running: true
                loops: Animation.Infinite
            }
        ]

        KeyframeGroup {
            target: tube_2
            property: "rotation"
            keyframeSource: "animations/tube_2_rotation.qad"
        }

        KeyframeGroup {
            target: tube_2
            property: "scale"
            Keyframe {
                frame: 0
                value: Qt.vector3d(1, 1, 1)
            }
        }

        KeyframeGroup {
            target: tube_3
            property: "rotation"
            keyframeSource: "animations/tube_3_rotation.qad"
        }

        KeyframeGroup {
            target: tube_3
            property: "scale"
            Keyframe {
                frame: 0
                value: Qt.vector3d(1, 1, 1)
            }
        }

        KeyframeGroup {
            target: tube_6
            property: "rotation"
            keyframeSource: "animations/tube_6_rotation.qad"
        }

        KeyframeGroup {
            target: tube_6
            property: "scale"
            Keyframe {
                frame: 0
                value: Qt.vector3d(1, 1, 1)
            }
        }

        KeyframeGroup {
            target: qtLogo
            property: "position"
            keyframeSource: "animations/qtLogo_position.qad"
        }

        KeyframeGroup {
            target: qtLogo
            property: "rotation"
            keyframeSource: "animations/qtLogo_rotation.qad"
        }

        KeyframeGroup {
            target: qtLogo
            property: "scale"
            Keyframe {
                frame: 0
                value: Qt.vector3d(1, 1, 1)
            }
        }

        KeyframeGroup {
            target: tube_4
            property: "rotation"
            keyframeSource: "animations/tube_4_rotation.qad"
        }

        KeyframeGroup {
            target: tube_4
            property: "scale"
            Keyframe {
                frame: 0
                value: Qt.vector3d(1, 1, 1)
            }
        }

        KeyframeGroup {
            target: tube
            property: "rotation"
            keyframeSource: "animations/tube_rotation.qad"
        }

        KeyframeGroup {
            target: tube
            property: "scale"
            Keyframe {
                frame: 0
                value: Qt.vector3d(1, 1, 1)
            }
        }

        KeyframeGroup {
            target: tube_5
            property: "rotation"
            keyframeSource: "animations/tube_5_rotation.qad"
        }

        KeyframeGroup {
            target: tube_5
            property: "scale"
            Keyframe {
                frame: 0
                value: Qt.vector3d(1, 1, 1)
            }
        }

        KeyframeGroup {
            target: tube_7
            property: "rotation"
            keyframeSource: "animations/tube_7_rotation.qad"
        }

        KeyframeGroup {
            target: tube_7
            property: "scale"
            Keyframe {
                frame: 0
                value: Qt.vector3d(1, 1, 1)
            }
        }

        KeyframeGroup {
            target: tube_1
            property: "rotation"
            keyframeSource: "animations/tube_1_rotation.qad"
        }

        KeyframeGroup {
            target: tube_1
            property: "scale"
            Keyframe {
                frame: 0
                value: Qt.vector3d(1, 1, 1)
            }
        }
    }
}
