/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Outrun demo.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick
import QtQuick.Controls
import QtQuick3D
import Outrun_Cluster 1.0
import Generated.QtQuick3D.Cluster 1.0
import QtQuick.Timeline 1.0
import QtQuick.Studio.Effects 1.0
import QtQuick3D.Effects 6.2
import Generated.QtQuick3D.Hyperdrive 1.0
import Generated.QtQuick3D.Warp 1.0
import Generated.QtQuick3D.Lanes 1.0
import QtQuick3D.Particles3D 6.2
import Generated.QtQuick3D.Gaugelines 1.0
import Generated.QtQuick3D.AdasPlane 1.0
import Generated.QtQuick3D.Car_Optimized_2 1.0
import Generated.QtQuick3D.Desert_Enviroment 1.0
import Generated.QtQuick3D.Car 1.0

ParticleSystem3D {
    visible: false
    running: false
    z: 195.4485
    SpriteParticle3D {
        id: starParticle
        sprite: Texture {
            source: "../images/glowdot.png"
        }
        maxAmount: 200
        color: "#fdfdf7"
        particleScale: 1
        fadeOutDuration: 50
        billboard: true
    }
    ParticleEmitter3D {
        x: 0
        y: -0
        depthBias: -10
        shape: particleShape
        z: -21.0764
        particle: starParticle
        velocity: VectorDirection3D {
            direction: Qt.vector3d(0, 0, 20)
        }
        particleScaleVariation: 0.4
        emitRate: 50
        lifeSpan: 4000
    }

    Attractor3D {
        id: attractor
        x: -0
        y: 0.452
        shape: particleShape
        z: 151.12125
    }

    PointRotator3D {
        id: pointRotator
        x: 0
        y: 8.021
        magnitude: 40
        direction.x: -50
        direction.y: 0
        z: 59.94998
    }

    ParticleShape3D {
        id: particleShape
        extents.z: 1
        extents.y: 1
        extents.x: 10
    }
}
