import QtQuick
import QtQuick3D
import QtQuick.Timeline 1.0
import QtQuick3D.AssetUtils 6.0
import Generated.QtQuick3D.Cluster_sandi 1.0
Node {
    id: rootNode
    property real gaugepos: 0.5
    property bool night: false

    Model {
        id: gaugelines
        scale.x: 1
        scale.y: 1
        scale.z: 1
        source: "../Cluster_sandi/meshes/cluster_sandi.mesh"
        materials: [customMaterial]

        CustomMaterial {
            id: customMaterial
            fragmentShader: "../../../Outrun_ClusterContent/gauge.frag"
            property real uvanim: 0
            property real blend: 0
            property color materialColor: "#232323"
            property double rayMaxDistance: 100
            property int marchSteps: 300
            property int refinementSteps: 10
            property double depthBias: 0.1
            property double specular: 0.01
            depthDrawMode: Material.AlwaysDepthDraw
            destinationBlend: CustomMaterial.OneMinusSrcAlpha
            sourceBlend: CustomMaterial.SrcAlpha
            shadingMode: CustomMaterial.Shaded
            property TextureInput nightTex: TextureInput {
                        texture: Texture {
                            source: "../../../images/gaugeline_new.png"
                            tilingModeVertical: Texture.Repeat
                            tilingModeHorizontal: Texture.Repeat


                        }
            }
            property TextureInput dayTex: TextureInput {
                        texture: Texture {
                            source: "../../../images/gaugelineDay.jpg"
                            tilingModeVertical: Texture.Repeat
                            tilingModeHorizontal: Texture.Repeat


                        }
            }
            lightProbe: car_ref1

            vertexShader: "../../../Outrun_ClusterContent/gauge.vert"

            Texture {
                id: car_ref1
                source: "../../../images/car_ref1.png"
                magFilter: Texture.Nearest
                minFilter: Texture.Nearest
                mipFilter: Texture.Nearest
                mappingMode: Texture.LightProbe
            }


        }
    }

    Timeline {
            id: timeline
            animations: [
                TimelineAnimation {
                    id: timelineAnimation
                    loops: 1
                    duration: 500
                    running: true
                    to: 500
                    from: 0
                }
            ]
            enabled: true
            endFrame: 500
            startFrame: 0
            currentFrame: gaugepos

            KeyframeGroup {
                target: customMaterial
                property: "uvanim"

                Keyframe {
                    frame: 0
                    value: 0.4
                }

                Keyframe {
                    frame: 500
                    value: -0.4
                }
            }
    }
    states: [
        State {
            name: "day"
            when: !night

            PropertyChanges {
                target: gaugelines
                source: "../Cluster_sandi/meshes/cluster_sandi.mesh"
            }
            PropertyChanges{
                target: customMaterial
                blend: 1.0

            }

            PropertyChanges {
                target: timeline
                currentFrame: speed
            }
        },
        State {
            name: "night"
            when: night
            PropertyChanges{
                target: customMaterial
                lightProbe: car_ref1
                blend: 0

            }

            PropertyChanges {
                target: gaugelines
                source: "../Cluster_sandi/meshes/cluster_sandi.mesh"
                castsShadows: false
            }

            PropertyChanges {
                target: car_ref1
                source: "../../../images/gaugeline_night_lp.png"
                magFilter: Texture.None
                mipFilter: Texture.None
                minFilter: Texture.None
                mappingMode: Texture.LightProbe
                positionU: 25.2
            }
        }
    ]
    transitions: [
        Transition {
            NumberAnimation {
                easing.bezierCurve: [0.175,0.885,0.32,1.27,1,1]
                properties: "blend"
                easing.type: Easing.InOutQuad
                duration: 1000
            }
        }
    ]
}
