import QtQuick
import QtQuick.Controls
import EosADAS
import "TurnSignals"
import "Cluster2D"
import backend.Data 1.0 as Data
import QtQuick3D.Helpers

Rectangle {
    id: eosADAS
    anchors.centerIn: parent
    height: width * 0.375 // keep aspect ratio
    color: "#000000"
    border.width: 1
    width: Constants.width

    property real scaleFactor: (eosADAS.height / 720)

    property alias roadLaneLines: adasView.lanelines
    property alias timelineAnimationAdas: adasView.timelineAnimationAdas

    ADAS {
        id: adasView
        width: eosADAS.width * 0.66
        height: width / 2
        anchors.centerIn: parent
        focus: true
    }

    Cluster2D {
        id: clusterScreen
        anchors.fill: parent
        visible: adasView.state == "Adas"
        state: adasView.state
        enabled: false
    }

    TurnSignals {
        id: turnSignals
        anchors.fill: parent
        visible: adasView.state == "Adas"
        turningRight: adasView.signaling
        state: adasView.state
    }

    DebugView {
        id: debugView
        visible: false
        source: adasView
    }

    Item {
        id: __materialLibrary__
    }
}
