/* $PostgresPy: if/src/tupd.h,v 1.18 2004/07/27 16:15:57 flaw Exp $
 * 
 * † Instrument:
 *     Copyright 2004, rhid development. All Rights Reserved.
 *     
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 * Description:
 *    Python Postgres Tuple Descriptor declaration.
 */
#ifndef PyPg_TUPD_H
#define PyPg_TUPD_H "tupd.h"
#ifdef __cplusplus
extern "C" {
#endif

typedef struct PyPgTupleDesc {
	PyPgDatum_HEAD
} PyPgTupleDesc, *PgTupD;

#define PgTupD(OB) ((PgTupD) OB)

extern PyTypeObject PyPgTupleDesc_Type;

HeapTuple PgTupD_AttTuple(PgTupD, long);
long PgTupD_AttOffset(PgTupD, PyObj);

#define PgTupD_NEW() (PyObj)PyPgTupleDesc_Type.tp_alloc(&PyPgTupleDesc_Type, 0)
PyObj PyPgTupleDesc_New(TupleDesc);

PyObj PgTupD_FromRelation(Relation);
#define PyPgTupleDesc_FromRelation(X) PgTupD_FromRelation(X)

PyObj PyPgTupleDesc_FromRelationOid(Oid);
#define PgTupD_FromRelationOid(O) \
		PyPgTupleDesc_FromRelationOid(O)

#define PgTupD_TypeCheck(OB) (PyObject_TypeCheck(OB, &PyPgTupleDesc_Type))
#define PgTupD_TypeCheckExact(OB) (OB->ob_type == &PyPgTupleDesc_Type)

#define PgTupD_FetchTD(OB) ((TupleDesc) (PgTupD(OB)->ob_datum))

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_TUPD_H */
