/* $PostgresPy: if/src/obj.h,v 1.21 2004/07/27 09:18:39 flaw Exp $
 * 
 * † Instrument:
 *     Copyright 2004, rhid development. All Rights Reserved.
 *     
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 * Description:
 *    Abstract Postgres object interface
 */
#ifndef PyPg_OBJ_H
#define PyPg_OBJ_H "obj.h"
#ifdef __cplusplus
extern "C" {
#endif

#define PgObjFlag_Void	(PgDatFlag_Void)
#define PgObjFlag_Free	(PgDatFlag_Ref)
#define PgObjFlag_Null	(PgDatFlag_Final)
#define PgObjFlag_Final (PgObjFlag_Null << 1)

typedef struct PyPgObject {
	PyPgDatum_HEAD
	PyObj ob_pgtype;
} PyPgObject, *PgObj;

#define PgObj(OB) ((PgObj) OB)

#define PgObjFlags(OB) (PgObj(OB)->ob_datum_flags)
#define PgObj_ShouldFree(OB) (PgObjFlags(OB) & PgObjFlag_Free)
#define PgObj_IsNull(OB) (PgObjFlags(OB) & PgObjFlag_Null)

extern PyTypeObject PyPgObject_Type;

#define PgObj_NEW() (PyObj)PyPgObject_Type.tp_alloc(&PyPgObject_Type, 0)
PyObj PyPgObject_New(Datum, PyObj);
void PyPgObject_Init(PyObj, Datum, PyObj);

PyObj PgObj_Operate(char *op, PgObj self, PyObj with);

PyObj PgObj_FromDatumAndTypeOid(Datum, Oid);
#define PgObj_FromDatumAndPgType(D,T) (PyPgObject_New(D,T))

#define PgObj_FromPgTypeAndPyObject(TYPE, OB) \
	(PyObject_CallFunctionObjArgs(TYPE, OB, NULL))
PyObj PgObj_FromArrayTypeTupleAndPySequence(HeapTuple, PyObj);

#define PgObj_TypeCheck(OB) (PyObject_TypeCheck((OB), &PyPgObject_Type))
#define PgObj_TypeCheckExact(OB) ((OB)->ob_type == &PyPgObject_Type)

#define PgObj_FetchDatum(OB) (PgObj(OB)->ob_datum)
#define PgObj_FetchType(OB) (PgObj(OB)->ob_pgtype)
#define PgObj_FetchTypeHT(OB) PgType_FetchHT(PgObj_FetchType(OB))
#define PgObj_FetchTypeOid(OB) (PgType_FetchOid(PgObj_FetchType(OB)))
#define PGOTYPESTRUCT(OB) (TYPESTRUCT(PgObj_FetchTypeHT(OB)))

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_OBJ_H */
