// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1200 -mattr=+wavefrontsize32,-real-true16 -show-encoding %s | FileCheck --check-prefixes=GFX12,W32 %s
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1200 -mattr=+wavefrontsize64,-real-true16 -show-encoding %s | FileCheck --check-prefixes=GFX12,W64 %s
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1200 -mattr=+wavefrontsize32,-real-true16 -filetype=null %s 2>&1 | FileCheck --check-prefix=W32-ERR --implicit-check-not=error: %s
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1200 -mattr=+wavefrontsize64,-real-true16 -filetype=null %s 2>&1 | FileCheck --check-prefix=W64-ERR --implicit-check-not=error: %s

v_add_co_ci_u32_dpp v5, vcc_lo, v1, v2, vcc_lo dpp8:[7,6,5,4,3,2,1,0]
// W32: encoding: [0xe9,0x04,0x0a,0x40,0x01,0x77,0x39,0x05]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc_lo, v1, v2, vcc_lo dpp8:[7,6,5,4,3,2,1,0] fi:1
// W32: encoding: [0xea,0x04,0x0a,0x40,0x01,0x77,0x39,0x05]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v255, vcc_lo, v255, v255, vcc_lo dpp8:[0,0,0,0,0,0,0,0] fi:0
// W32: encoding: [0xe9,0xfe,0xff,0x41,0xff,0x00,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc, v1, v2, vcc dpp8:[7,6,5,4,3,2,1,0]
// W64: encoding: [0xe9,0x04,0x0a,0x40,0x01,0x77,0x39,0x05]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v5, vcc, v1, v2, vcc dpp8:[7,6,5,4,3,2,1,0] fi:1
// W64: encoding: [0xea,0x04,0x0a,0x40,0x01,0x77,0x39,0x05]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_ci_u32 v255, vcc, v255, v255, vcc dpp8:[0,0,0,0,0,0,0,0] fi:0
// W64: encoding: [0xe9,0xfe,0xff,0x41,0xff,0x00,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_f16 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x64,0x01,0x77,0x39,0x05]

v_add_f16 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x64,0x01,0x77,0x39,0x05]

v_add_f16 v127, v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xfe,0x64,0x7f,0x00,0x00,0x00]

v_add_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x06,0x01,0x77,0x39,0x05]

v_add_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x06,0x01,0x77,0x39,0x05]

v_add_f32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x07,0xff,0x00,0x00,0x00]

v_add_nc_u32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x4a,0x01,0x77,0x39,0x05]

v_add_nc_u32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x4a,0x01,0x77,0x39,0x05]

v_add_nc_u32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x4b,0xff,0x00,0x00,0x00]

v_and_b32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x36,0x01,0x77,0x39,0x05]

v_and_b32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x36,0x01,0x77,0x39,0x05]

v_and_b32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x37,0xff,0x00,0x00,0x00]

v_ashrrev_i32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x34,0x01,0x77,0x39,0x05]

v_ashrrev_i32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x34,0x01,0x77,0x39,0x05]

v_ashrrev_i32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x35,0xff,0x00,0x00,0x00]

v_cndmask_b32 v5, v1, v2, vcc_lo dpp8:[7,6,5,4,3,2,1,0]
// W32: encoding: [0xe9,0x04,0x0a,0x02,0x01,0x77,0x39,0x05]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, v1, v2, vcc_lo dpp8:[7,6,5,4,3,2,1,0] fi:1
// W32: encoding: [0xea,0x04,0x0a,0x02,0x01,0x77,0x39,0x05]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v255, v255, v255, vcc_lo dpp8:[0,0,0,0,0,0,0,0] fi:0
// W32: encoding: [0xe9,0xfe,0xff,0x03,0xff,0x00,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, v1, v2, vcc dpp8:[7,6,5,4,3,2,1,0]
// W64: encoding: [0xe9,0x04,0x0a,0x02,0x01,0x77,0x39,0x05]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v5, v1, v2, vcc dpp8:[7,6,5,4,3,2,1,0] fi:1
// W64: encoding: [0xea,0x04,0x0a,0x02,0x01,0x77,0x39,0x05]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cndmask_b32 v255, v255, v255, vcc dpp8:[0,0,0,0,0,0,0,0] fi:0
// W64: encoding: [0xe9,0xfe,0xff,0x03,0xff,0x00,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_cvt_pk_rtz_f16_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x5e,0x01,0x77,0x39,0x05]

v_cvt_pk_rtz_f16_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x5e,0x01,0x77,0x39,0x05]

v_cvt_pk_rtz_f16_f32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x5f,0xff,0x00,0x00,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x5e,0x01,0x77,0x39,0x05]

v_cvt_pkrtz_f16_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x5e,0x01,0x77,0x39,0x05]

v_cvt_pkrtz_f16_f32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x5f,0xff,0x00,0x00,0x00]

v_fmac_f16 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x6c,0x01,0x77,0x39,0x05]

v_fmac_f16 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x6c,0x01,0x77,0x39,0x05]

v_fmac_f16 v127, v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xfe,0x6c,0x7f,0x00,0x00,0x00]

v_fmac_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x56,0x01,0x77,0x39,0x05]

v_fmac_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x56,0x01,0x77,0x39,0x05]

v_fmac_f32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x57,0xff,0x00,0x00,0x00]

v_ldexp_f16 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x76,0x01,0x77,0x39,0x05]

v_ldexp_f16 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x76,0x01,0x77,0x39,0x05]

v_ldexp_f16 v127, v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xfe,0x76,0x7f,0x00,0x00,0x00]

v_lshlrev_b32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x30,0x01,0x77,0x39,0x05]

v_lshlrev_b32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x30,0x01,0x77,0x39,0x05]

v_lshlrev_b32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x31,0xff,0x00,0x00,0x00]

v_lshrrev_b32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x32,0x01,0x77,0x39,0x05]

v_lshrrev_b32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x32,0x01,0x77,0x39,0x05]

v_lshrrev_b32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x33,0xff,0x00,0x00,0x00]

v_max_num_f16 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x62,0x01,0x77,0x39,0x05]

v_max_num_f16 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x62,0x01,0x77,0x39,0x05]

v_max_num_f16 v127, v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xfe,0x62,0x7f,0x00,0x00,0x00]

v_max_num_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x2c,0x01,0x77,0x39,0x05]

v_max_num_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x2c,0x01,0x77,0x39,0x05]

v_max_num_f32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x2d,0xff,0x00,0x00,0x00]

v_max_i32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x24,0x01,0x77,0x39,0x05]

v_max_i32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x24,0x01,0x77,0x39,0x05]

v_max_i32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x25,0xff,0x00,0x00,0x00]

v_max_u32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x28,0x01,0x77,0x39,0x05]

v_max_u32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x28,0x01,0x77,0x39,0x05]

v_max_u32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x29,0xff,0x00,0x00,0x00]

v_min_num_f16 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x60,0x01,0x77,0x39,0x05]

v_min_num_f16 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x60,0x01,0x77,0x39,0x05]

v_min_num_f16 v127, v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xfe,0x60,0x7f,0x00,0x00,0x00]

v_min_num_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x2a,0x01,0x77,0x39,0x05]

v_min_num_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x2a,0x01,0x77,0x39,0x05]

v_min_num_f32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x2b,0xff,0x00,0x00,0x00]

v_min_i32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x22,0x01,0x77,0x39,0x05]

v_min_i32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x22,0x01,0x77,0x39,0x05]

v_min_i32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x23,0xff,0x00,0x00,0x00]

v_min_u32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x26,0x01,0x77,0x39,0x05]

v_min_u32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x26,0x01,0x77,0x39,0x05]

v_min_u32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x27,0xff,0x00,0x00,0x00]

v_mul_dx9_zero_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x0e,0x01,0x77,0x39,0x05]

v_mul_dx9_zero_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x0e,0x01,0x77,0x39,0x05]

v_mul_dx9_zero_f32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x0f,0xff,0x00,0x00,0x00]

v_mul_f16 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x6a,0x01,0x77,0x39,0x05]

v_mul_f16 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x6a,0x01,0x77,0x39,0x05]

v_mul_f16 v127, v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xfe,0x6a,0x7f,0x00,0x00,0x00]

v_mul_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x10,0x01,0x77,0x39,0x05]

v_mul_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x10,0x01,0x77,0x39,0x05]

v_mul_f32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x11,0xff,0x00,0x00,0x00]

v_mul_hi_i32_i24 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x14,0x01,0x77,0x39,0x05]

v_mul_hi_i32_i24 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x14,0x01,0x77,0x39,0x05]

v_mul_hi_i32_i24 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x15,0xff,0x00,0x00,0x00]

v_mul_hi_u32_u24 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x18,0x01,0x77,0x39,0x05]

v_mul_hi_u32_u24 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x18,0x01,0x77,0x39,0x05]

v_mul_hi_u32_u24 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x19,0xff,0x00,0x00,0x00]

v_mul_i32_i24 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x12,0x01,0x77,0x39,0x05]

v_mul_i32_i24 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x12,0x01,0x77,0x39,0x05]

v_mul_i32_i24 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x13,0xff,0x00,0x00,0x00]

v_mul_dx9_zero_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x0e,0x01,0x77,0x39,0x05]

v_mul_dx9_zero_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x0e,0x01,0x77,0x39,0x05]

v_mul_dx9_zero_f32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x0f,0xff,0x00,0x00,0x00]

v_mul_u32_u24 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x16,0x01,0x77,0x39,0x05]

v_mul_u32_u24 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x16,0x01,0x77,0x39,0x05]

v_mul_u32_u24 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x17,0xff,0x00,0x00,0x00]

v_or_b32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x38,0x01,0x77,0x39,0x05]

v_or_b32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x38,0x01,0x77,0x39,0x05]

v_or_b32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x39,0xff,0x00,0x00,0x00]

v_sub_co_ci_u32 v5, vcc_lo, v1, v2, vcc_lo dpp8:[7,6,5,4,3,2,1,0]
// W32: encoding: [0xe9,0x04,0x0a,0x42,0x01,0x77,0x39,0x05]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc_lo, v1, v2, vcc_lo dpp8:[7,6,5,4,3,2,1,0] fi:1
// W32: encoding: [0xea,0x04,0x0a,0x42,0x01,0x77,0x39,0x05]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v255, vcc_lo, v255, v255, vcc_lo dpp8:[0,0,0,0,0,0,0,0] fi:0
// W32: encoding: [0xe9,0xfe,0xff,0x43,0xff,0x00,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc, v1, v2, vcc dpp8:[7,6,5,4,3,2,1,0]
// W64: encoding: [0xe9,0x04,0x0a,0x42,0x01,0x77,0x39,0x05]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v5, vcc, v1, v2, vcc dpp8:[7,6,5,4,3,2,1,0] fi:1
// W64: encoding: [0xea,0x04,0x0a,0x42,0x01,0x77,0x39,0x05]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_ci_u32 v255, vcc, v255, v255, vcc dpp8:[0,0,0,0,0,0,0,0] fi:0
// W64: encoding: [0xe9,0xfe,0xff,0x43,0xff,0x00,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_f16 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x66,0x01,0x77,0x39,0x05]

v_sub_f16 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x66,0x01,0x77,0x39,0x05]

v_sub_f16 v127, v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xfe,0x66,0x7f,0x00,0x00,0x00]

v_sub_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x08,0x01,0x77,0x39,0x05]

v_sub_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x08,0x01,0x77,0x39,0x05]

v_sub_f32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x09,0xff,0x00,0x00,0x00]

v_sub_nc_u32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x4c,0x01,0x77,0x39,0x05]

v_sub_nc_u32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x4c,0x01,0x77,0x39,0x05]

v_sub_nc_u32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x4d,0xff,0x00,0x00,0x00]

v_subrev_co_ci_u32 v5, vcc_lo, v1, v2, vcc_lo dpp8:[7,6,5,4,3,2,1,0]
// W32: encoding: [0xe9,0x04,0x0a,0x44,0x01,0x77,0x39,0x05]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc_lo, v1, v2, vcc_lo dpp8:[7,6,5,4,3,2,1,0] fi:1
// W32: encoding: [0xea,0x04,0x0a,0x44,0x01,0x77,0x39,0x05]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v255, vcc_lo, v255, v255, vcc_lo dpp8:[0,0,0,0,0,0,0,0] fi:0
// W32: encoding: [0xe9,0xfe,0xff,0x45,0xff,0x00,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc, v1, v2, vcc dpp8:[7,6,5,4,3,2,1,0]
// W64: encoding: [0xe9,0x04,0x0a,0x44,0x01,0x77,0x39,0x05]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v5, vcc, v1, v2, vcc dpp8:[7,6,5,4,3,2,1,0] fi:1
// W64: encoding: [0xea,0x04,0x0a,0x44,0x01,0x77,0x39,0x05]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_ci_u32 v255, vcc, v255, v255, vcc dpp8:[0,0,0,0,0,0,0,0] fi:0
// W64: encoding: [0xe9,0xfe,0xff,0x45,0xff,0x00,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_f16 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x68,0x01,0x77,0x39,0x05]

v_subrev_f16 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x68,0x01,0x77,0x39,0x05]

v_subrev_f16 v127, v127, v127 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xfe,0x68,0x7f,0x00,0x00,0x00]

v_subrev_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x0a,0x01,0x77,0x39,0x05]

v_subrev_f32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x0a,0x01,0x77,0x39,0x05]

v_subrev_f32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x0b,0xff,0x00,0x00,0x00]

v_subrev_nc_u32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x4e,0x01,0x77,0x39,0x05]

v_subrev_nc_u32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x4e,0x01,0x77,0x39,0x05]

v_subrev_nc_u32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x4f,0xff,0x00,0x00,0x00]

v_xnor_b32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x3c,0x01,0x77,0x39,0x05]

v_xnor_b32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x3c,0x01,0x77,0x39,0x05]

v_xnor_b32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x3d,0xff,0x00,0x00,0x00]

v_xor_b32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX12: encoding: [0xe9,0x04,0x0a,0x3a,0x01,0x77,0x39,0x05]

v_xor_b32 v5, v1, v2 dpp8:[7,6,5,4,3,2,1,0] fi:1
// GFX12: encoding: [0xea,0x04,0x0a,0x3a,0x01,0x77,0x39,0x05]

v_xor_b32 v255, v255, v255 dpp8:[0,0,0,0,0,0,0,0] fi:0
// GFX12: encoding: [0xe9,0xfe,0xff,0x3b,0xff,0x00,0x00,0x00]
