; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -passes=instsimplify -S < %s | FileCheck %s

define i1 @test_powi_even_exp(float %x) {
; CHECK-LABEL: define i1 @test_powi_even_exp(
; CHECK-SAME: float [[X:%.*]]) {
; CHECK-NEXT:    ret i1 false
;
  %y = call float @llvm.powi.f32(float %x, i32 8)
  %cmp = fcmp olt float %y, 0.0
  ret i1 %cmp
}

define i1 @test_powi_base(float nofpclass(ninf nnorm nsub nzero) %x, i32 %e) {
; CHECK-LABEL: define i1 @test_powi_base(
; CHECK-SAME: float nofpclass(ninf nzero nsub nnorm) [[X:%.*]], i32 [[E:%.*]]) {
; CHECK-NEXT:    ret i1 false
;
  %y = call float @llvm.powi.f32(float %x, i32 %e)
  %cmp = fcmp olt float %y, 0.0
  ret i1 %cmp
}

define i1 @test_powi_base_without_nsz(float nofpclass(ninf nnorm nsub) %x, i32 %e) {
; CHECK-LABEL: define i1 @test_powi_base_without_nsz(
; CHECK-SAME: float nofpclass(ninf nsub nnorm) [[X:%.*]], i32 [[E:%.*]]) {
; CHECK-NEXT:    [[Y:%.*]] = call float @llvm.powi.f32.i32(float [[X]], i32 [[E]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp olt float [[Y]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %y = call float @llvm.powi.f32(float %x, i32 %e)
  %cmp = fcmp olt float %y, 0.0
  ret i1 %cmp
}

define float @pr31702(float %x, i32 %n) {
; CHECK-LABEL: define float @pr31702(
; CHECK-SAME: float [[X:%.*]], i32 [[N:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CALL1:%.*]] = call float @llvm.powi.f32.i32(float -0.000000e+00, i32 [[N]])
; CHECK-NEXT:    [[CALL2:%.*]] = call float @llvm.fabs.f32(float [[CALL1]])
; CHECK-NEXT:    ret float [[CALL2]]
;
entry:
  %call1 = call float @llvm.powi.f32(float -0.0, i32 %n)
  %call2 = call float @llvm.fabs.f32(float %call1)
  ret float %call2
}

declare float @llvm.powi.f32(float, i32)
declare float @llvm.fabs.f32(float)
