// Copyright (C) 2021 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial


#include "intwrapper.h"

int IntWrapper::toInt() const
{
    return m_number;
}

IntWrapper &IntWrapper::operator ++()
{
    ++m_number;
    return *this;
}

IntWrapper IntWrapper::operator++(int)
{
    IntWrapper result(*this);
    ++m_number;
    return result;
}

IntWrapper &IntWrapper::operator--()
{
    --m_number;
    return *this;
}

IntWrapper IntWrapper::operator--(int)
{
    IntWrapper result(*this);
    --m_number;
    return result;
}
