/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Outrun demo.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick
import QtQuick.Controls
import QtQuick3D
import Outrun_Cluster 1.0
import QtQuick.Timeline 1.0
import QtQuick.Studio.Effects 1.0
import QtQuick3D.Effects 6.2
import Generated.QtQuick3D.Hyperdrive 1.0
import Generated.QtQuick3D.Warp 1.0
import Generated.QtQuick3D.Lanes 1.0

Item {
    id: clock
    
    property int hours: currentTime.split(":")[0]
    property int minutes: currentTime.split(":")[1]
    property string currentTime: "12:00"
    property string arrivaltime
    property real distanceremaining
    property real newdistanceremaining
    property real meterspersecond
    property int minutesremaining
    property int arrivalhours
    property int arrivalminutes
    property real drivespeed
    
    function arrivalTime(speed, distance){
        return Math.floor(distance / speed)
    }

    Timer {
        interval: 1000
        running: true
        repeat: true
        onTriggered: {
            distanceremaining -= (meterspersecond / 1000)
            newdistanceremaining = distanceremaining
            minutesremaining = (drivespeed > 0) ? (distanceremaining / (drivespeed / 60)) : -1
            if (drivespeed > 20) {
                arrivalhours = (hours + Math.floor((minutes+minutesremaining) / 60)) % 24
                arrivalminutes = Math.floor(minutes+minutesremaining) % 60
                var hoursString = (arrivalhours.toFixed()).toString();
                var minutesString = (arrivalminutes.toFixed()).toString();
                if (arrivalminutes < 10)
                    minutesString = "0" + minutesString;
                arrivaltime = hoursString + ":" + minutesString;
            } else {
                arrivaltime = "--:--";
            }
        }
    }
}

/*##^##
Designer {
    D{i:0;autoSize:true;height:480;width:640}
}
##^##*/
