import QtQuick 6.7
import QtQuick.Studio.DesignEffects
import QtQuick.Studio.Components
import QtQuick.Shapes 1.0

Item {
    id: root
    width: 1560
    height: 860
    visible: true

    property alias glassVisible: glassGroup.visible
    property alias skeuoVisible: skeuoRect.visible
    property alias neuVisible: neuRect.visible

    Rectangle {
        id: neuRect
        color: "#b1b1b1"
        anchors.fill: parent

        Item {
            id: circleGroup
            width: 500
            height: 500
            anchors.verticalCenter: parent.verticalCenter
            anchors.horizontalCenter: parent.horizontalCenter

            EllipseItem {
                id: ellipse
                width: 286
                height: 286
                anchors.verticalCenter: parent.verticalCenter
                anchors.horizontalCenter: parent.horizontalCenter
                fillColor: "#b1b1b1"
                strokeColor: "#00ff0000"

                DesignEffect {
                    id: de0
                    layerBlurRadius: 0

                    effects: [
                        DesignDropShadow {
                            id: ds00
                            color: "#ccffffff"
                            blur: 10
                            spread: 0
                            offsetY: -3
                            offsetX: -3
                        },
                        DesignDropShadow {
                            id: ds11
                            color: "#53000000"
                            blur: 10
                            spread: 0
                            offsetY: 3
                            offsetX: 3
                        }
                    ]
                }
            }

            EllipseItem {
                id: ellipse1
                x: 262
                y: 228
                width: 222
                height: 222
                strokeColor: "#00ff0000"
                fillColor: "#b1b1b1"
                DesignEffect {
                    id: de2
                    layerBlurRadius: 0
                    effects: [
                        DesignDropShadow {
                            id: ds2
                            color: "#ccffffff"
                            spread: 0
                            offsetY: -3
                            offsetX: -3
                            blur: 10
                        },
                        DesignDropShadow {
                            id: ds12
                            color: "#53000000"
                            spread: 0
                            offsetY: 3
                            offsetX: 3
                            blur: 10
                        }
                    ]
                }
            }

            EllipseItem {

                id: ellipse2
                x: 86
                y: 113
                width: 144
                height: 144
                strokeColor: "#00ff0000"
                fillColor: "#b1b1b1"
                DesignEffect {
                    id: de3
                    layerBlurRadius: 0
                    effects: [
                        DesignDropShadow {
                            id: ds3
                            color: "#ccffffff"
                            spread: 0
                            offsetY: -3
                            offsetX: -3
                            blur: 10
                        },
                        DesignDropShadow {
                            id: ds13
                            color: "#53000000"
                            spread: 0
                            offsetY: 3
                            offsetX: 3
                            blur: 10
                        }
                    ]
                }
            }
        }
        Text {
            id: neuText
            color: "#b1b1b1"
            text: qsTr("NEUMORPHISM")
            anchors.verticalCenter: parent.verticalCenter
            font.pixelSize: 128
            font.hintingPreference: Font.PreferNoHinting
            renderType: Text.NativeRendering
            font.styleName: "Bold"
            font.family: "Victor Mono"
            anchors.horizontalCenter: parent.horizontalCenter

            DesignEffect {
                id: de111
                layerBlurRadius: 0
                effects: [
                    DesignDropShadow {
                        id: ds211
                        color: "#41000000"
                        spread: 0
                        offsetY: 2
                        offsetX: 2
                        blur: 4
                    },
                    DesignDropShadow {
                        id: ds221
                        color: "#fdfdfd"
                        spread: 0
                        offsetY: -2
                        offsetX: -2
                        blur: 4
                    }
                ]
            }
        }
    }

    Rectangle {
        id: skeuoRect
        color: "#b1b1b1"
        anchors.fill: parent
        Item {
            id: circleGroup1
            width: 500
            height: 500
            visible: true
            anchors.verticalCenter: parent.verticalCenter
            EllipseItem {
                id: ellipse3
                width: 286
                height: 286
                anchors.verticalCenter: parent.verticalCenter
                antialiasing: true
                gradient: LinearGradient {
                    y2: ellipse3.height * 1
                    y1: ellipse3.height * 0
                    x2: ellipse3.width * 1
                    x1: ellipse3.width * 0
                    GradientStop {
                        position: 0
                        color: "#B1B1B1"
                    }

                    GradientStop {
                        position: 1
                        color: "#4B4B4B"
                    }
                }
                strokeColor: "#00ff0000"
                DesignEffect {
                    id: de4
                    visible: true
                    backgroundBlurVisible: true
                    layerBlurRadius: 2
                    effects: [
                        DesignDropShadow {
                            id: ds4
                            visible: true
                            color: "#52000000"
                            showBehind: false
                            spread: 0
                            offsetY: 3
                            offsetX: 3
                            blur: 10
                        },
                        DesignInnerShadow {
                            id: ds14
                            visible: true
                            color: "#5bffffff"
                            spread: 0
                            offsetY: -2
                            offsetX: -2
                            blur: 2
                        },
                        DesignDropShadow {
                            showBehind: false
                            blur: 50
                            offsetY: 10
                            offsetX: 23
                        }
                    ]
                }
                anchors.horizontalCenter: parent.horizontalCenter
            }

            EllipseItem {
                id: ellipse4
                x: 262
                y: 228
                width: 222
                height: 222
                antialiasing: true
                gradient: LinearGradient {
                    y2: ellipse4.height * 1
                    y1: ellipse4.height * 0
                    x2: ellipse4.width * 1
                    x1: ellipse4.width * 0
                    GradientStop {
                        position: 0
                        color: "#b1b1b1"
                    }

                    GradientStop {
                        position: 1
                        color: "#4b4b4b"
                    }
                }
                strokeColor: "#00ff0000"
                DesignEffect {
                    id: de5
                    layerBlurRadius: 0
                    effects: [
                        DesignDropShadow {
                            id: ds5
                            color: "#5f000000"
                            showBehind: false
                            spread: 0
                            offsetY: -4
                            offsetX: -4
                            blur: 10
                        },
                        DesignInnerShadow {
                            visible: true
                            color: "#31ffffff"
                            blur: 2
                            offsetY: -3
                            offsetX: -3
                        },

                        DesignDropShadow {
                            id: ds15
                            color: "#53000000"
                            spread: 0
                            offsetY: 3
                            offsetX: 3
                            blur: 10
                        },
                        DesignDropShadow {
                            color: "#4f000000"
                            showBehind: false
                            blur: 49
                            offsetY: 23
                            offsetX: 29
                        }
                    ]
                }
            }

            EllipseItem {
                id: ellipse5
                x: 86
                y: 113
                width: 144
                height: 144
                antialiasing: true
                gradient: LinearGradient {
                    y2: ellipse5.height * 1
                    y1: ellipse5.height * 0
                    x2: ellipse5.width * 1
                    x1: ellipse5.width * 0
                    GradientStop {
                        position: 0
                        color: "#b1b1b1"
                    }

                    GradientStop {
                        position: 1
                        color: "#4b4b4b"
                    }
                }
                strokeColor: "#00ff0000"
                DesignEffect {
                    id: de6
                    layerBlurRadius: 0
                    effects: [
                        DesignDropShadow {
                            id: ds6
                            color: "#52000000"
                            showBehind: false
                            spread: 0
                            offsetY: 3
                            offsetX: 3
                            blur: 10
                        },
                        DesignInnerShadow {
                            id: ds16
                            color: "#5bffffff"
                            spread: 0
                            offsetY: -2
                            offsetX: -2
                            blur: 10
                        }
                    ]
                }
            }

            anchors.horizontalCenter: parent.horizontalCenter
        }

        Text {
            id: skeuoText
            color: "#8a8a8a"
            text: qsTr("SKEUOMORPHISM")
            anchors.verticalCenter: parent.verticalCenter
            font.pixelSize: 128
            renderTypeQuality: Text.HighRenderTypeQuality
            font.styleName: "Bold"
            font.family: "Victor Mono"
            DesignEffect {
                id: de7
                layerBlurRadius: 2
                effects: [
                    DesignDropShadow {
                        id: ds7
                        color: "#3e000000"
                        showBehind: false
                        spread: 0
                        offsetY: 6
                        offsetX: 6
                        blur: 8
                    },
                    DesignInnerShadow {
                        id: ds8
                        color: "#71ffffff"
                        spread: 0
                        offsetY: 1
                        offsetX: 1
                        blur: 1
                    },
                    DesignInnerShadow {
                        id: is9
                        color: "#a5000000"
                        spread: 0
                        offsetY: -2
                        offsetX: -2
                        blur: 1
                    }
                ]
            }
            anchors.horizontalCenter: parent.horizontalCenter
        }
    }

    Item {
        id: glassGroup
        anchors.fill: parent

        Rectangle {
            id: glassRect
            color: "#b1b1b1"
            anchors.fill: parent
            Item {
                id: circleGroup2
                width: 500
                height: 500
                anchors.verticalCenter: parent.verticalCenter
                EllipseItem {
                    id: ellipse6
                    width: 286
                    height: 286
                    anchors.verticalCenter: parent.verticalCenter
                    gradient: LinearGradient {
                        y2: ellipse6.height * 1
                        y1: ellipse6.height * 0
                        x2: ellipse6.width * 1
                        x1: ellipse6.width * 0
                        GradientStop {
                            position: 0
                            color: "#a62800"
                        }

                        GradientStop {
                            position: 0.44451
                            color: "#c44821"
                        }

                        GradientStop {
                            position: 0.83816
                            color: "#151100"
                        }
                    }
                    strokeColor: "#00ff0000"
                    anchors.horizontalCenter: parent.horizontalCenter
                }

                EllipseItem {
                    id: ellipse7
                    x: 262
                    y: 228
                    width: 222
                    height: 222
                    gradient: LinearGradient {
                        y2: ellipse7.height * 1
                        y1: ellipse7.height * 0
                        x2: ellipse7.width * 1
                        x1: ellipse7.width * 0
                        GradientStop {
                            position: 0
                            color: "#006aa6"
                        }

                        GradientStop {
                            position: 0.68945
                            color: "#151110"
                        }

                        GradientStop {
                            position: 0.71224
                            color: "#151110"
                        }
                    }
                    strokeColor: "#00ff0000"
                }

                EllipseItem {
                    id: ellipse8
                    x: 86
                    y: 113
                    width: 144
                    height: 144
                    gradient: LinearGradient {
                        y2: ellipse8.height * 1
                        y1: ellipse8.height * 0
                        x2: ellipse8.width * 1
                        x1: ellipse8.width * 0
                        GradientStop {
                            position: 0.19924
                            color: "#a60059"
                        }

                        GradientStop {
                            position: 0.31115
                            color: "#a60059"
                        }

                        GradientStop {
                            position: 1
                            color: "#000000"
                        }
                    }
                    strokeColor: "#00ff0000"
                }
                anchors.horizontalCenter: parent.horizontalCenter
            }
        }

        Text {
            id: glassText
            x: 281
            y: 343
            color: "#2ed7d7d7"
            text: qsTr("GLASSMORPHISM")
            anchors.verticalCenter: parent.verticalCenter
            font.pixelSize: 128
            font.styleName: "Bold"
            font.family: "Victor Mono"
            DesignEffect {
                id: de11
                layerBlurVisible: false
                backgroundBlurRadius: 24
                backgroundLayer: glassRect
                layerBlurRadius: 0
                effects: [
                    DesignInnerShadow {
                        id: ds21
                        visible: false
                        color: "#34ffffff"
                        spread: 0
                        offsetY: -1
                        offsetX: -1
                        blur: 1
                    },
                    DesignInnerShadow {
                        id: ds22
                        visible: true
                        color: "#34ffffff"
                        spread: 0
                        offsetY: 1
                        offsetX: 1
                        blur: 1
                    },
                    DesignDropShadow {
                        color: "#33ffffff"
                        offsetY: -1
                        offsetX: -1
                        blur: 1
                    },
                    DesignDropShadow {
                        color: "#33ffffff"
                        blur: 1
                        offsetY: 1
                        offsetX: 1
                    }
                ]
            }
            anchors.horizontalCenter: parent.horizontalCenter
        }
    }
}

/*##^##
Designer {
    D{i:0}D{i:19;invisible:true}D{i:50;invisible:true}
}
##^##*/

