import QtQuick
import QtQuick.VirtualKeyboard
import QtQuick.VirtualKeyboard.Styles

KeyPanel {
    id: root

    Rectangle {
        id: keyboardSpecialKey
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.rightMargin: 14
        anchors.leftMargin: 14
        anchors.bottomMargin: 10
        anchors.topMargin: 10
        color: "transparent"
        radius: 24
        border.color: "#222840"
        border.width: 1

        Text {
            id: period
            width: 111
            height: 110
            color: "#fafafa"
            text: root.control.displayText
            font.pixelSize: 48
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            wrapMode: Text.Wrap
            font.weight: Font.Normal
            font.italic: true
            font.family: "Inter"
            anchors.horizontalCenterOffset: 1
            anchors.centerIn: parent
        }

        GlowRectangle {
            id: glowRectangleID
            anchors.fill: keyboardSpecialKey
            glowRectRadius: 24
            visible: root.control.pressed

        }
    }
}
/*##^##
Designer {
    D{i:0;uuid:"625cc2ae-faf4-53a7-92c9-283160d61557"}D{i:1;uuid:"66fae9aa-5827-5d47-889e-06982c06ad56"}
D{i:2;uuid:"bb3702d0-bbab-58ab-9295-29bc2d33f657"}
}
##^##*/

