/* $Id: python.h,v 1.5 2005/12/14 08:22:31 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/include/py.h,v 1.2 2005/02/05 19:31:54 flaw
 * imp/include/py.h,v 1.4 2004/12/15 04:52:39 flaw
 * if/include/py.h,v 1.15 2004/09/28 16:08:48 flaw
 *//*
 * Python utility macros and definitions.
 */
#ifndef PyPg_python_H
#define PyPg_python_H 0
#ifdef __cplusplus
extern "C" {
#endif

typedef PyObject * PyObj;
#define PyObj(OB) ((PyObj) OB)

#define PyMapItem(ob,str)	(PyMapping_HasKeyString(ob,str)? \
									 PyMapping_GetItemString(ob,str):(PyObj)NULL)
#define PySeqItem(ob,num)	PySequence_GetItem(ob,num)
#define PyAttr(ob,str)	(PyObject_HasAttrString(ob,str)? \
								PyObject_GetAttrString(ob,str):(PyObj) NULL)

#define PySetAttr(ob,str,v) PyObject_SetAttrString(ob,str,v)

#define PyErrSetAttr(att,ob) PySetAttr(PyErr_Occurred(),att,ob)

#define PYSTR(str)	PyString_FromString(str)
#define PYSTRF(...)	PyString_FromFormat(__VA_ARGS__)
#define PYFLOAT(i)	PyFloat_FromDouble(i)
#define PYINT(i)		PyInt_FromLong(i)
#define PYLONG(L)		PyLong_FromLong(L)
#define PYLLONG(L)	PyLong_FromLongLong(L)
#define PYULONG(L)	PyLong_FromUnsignedLong(L)
#define PYULLONG(L)	PyLong_FromUnsignedLongLong(L)


#define PYASSTR(str)		PyString_AS_STRING(str)
#define PYASINT(i)		PyInt_AS_LONG(i)
#define PYASDOUBLE(i)	PyFloat_AS_DOUBLE(i)

#if Py_MARSHAL_VERSION < 1 || !defined(Py_MARSHAL_VERSION)
#define PyMarshal_WriteObjectToString(OB, N) \
	PyMarshal_WriteObjectToString(OB)
#endif

#define PySPEC(OB,...) do { 						\
	printf("\n-> Spec: "__VA_ARGS__);			\
	puts("\n"__LOCATION__);							\
	puts(" in ");										\
	puts(__func__);									\
	if(OB != NULL) { printf(						\
		"\nPython Object %s@%p\n"					\
		"	Type: %s@%p\n"								\
		"	Reference Count: %d",					\
		#OB, OB,											\
		(OB)->ob_type->tp_name, (OB)->ob_type, \
		(OB)->ob_refcnt								\
	);														\
		if (!PyErr_Occurred()) {					\
			PyObj obrepr = NULL;						\
			char *rs = "<PyErr_Occurred>";		\
			obrepr = PyObject_Repr(OB);			\
			rs = PyString_AS_STRING(obrepr);		\
			printf("\nRepr: %s", rs);				\
			Py_DECREF(obrepr);						\
		}													\
	} else { puts(#OB" is <NULL>"); }			\
	puts("\n");											\
} while(0)

#ifdef REF_TRACING
#define If_RefTrace(X) X
#else
#define If_RefTrace(X) do{}while(0)
#endif

#define DECREF(ob) \
	do{If_RefTrace(PySPEC(ob, "Decrement")); Py_DECREF(ob);}while(0)
#define INCREF(ob) \
	do{If_RefTrace(PySPEC(ob, "Increment")); Py_INCREF(ob);}while(0)
#define XDECREF(ob) do{if(ob) DECREF(ob);}while(0)
#define XINCREF(ob) do{if(ob) INCREF(ob);}while(0)

#define RETURN_NONE do{INCREF(Py_None); return(Py_None);}while(0)
#define RETURN_NONE_OR_NULL \
do{if (PyErr_Occurred()) return(NULL); else RETURN_NONE;}while(0)

PyObj Py_RETURN_SELF(PyObj, ...);

#define PyDict_SetCFunction(D, N, FN, FLAGS) \
	do { register PyObj _fn; PyMethodDef _md; \
	_md.ml_name = N; _md.ml_flags = FLAGS; _md.ml_meth = (PyCFunction) FN; \
	_fn = PyCFunction_New(&_md, NULL); \
	PyDict_SetItemString(D, _md.ml_name, _fn); \
	Py_DECREF(_fn); } while(0)

#define Py_Call(...) PyObject_CallFunctionObjArgs(__VA_ARGS__, NULL)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_python_H */
/*
 * vim: ts=3:sw=3:noet:
 */
