/*
 * Generated by XCodeGen v0.1
 * Sun Jun 16 19:57:29 EDT 2002
 */

package output.dao;

import java.util.HashSet;
import java.util.Set;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import output.dto.ContentDTO;

/**
 * 
 *
 * @author 
 * @version 
 *
 * @see ContentDTO
 */
public class ContentDAO
{
    /** INSERT SQL statement */
    public static final String SQL_INSERT = "INSERT INTO CONTENT(id,creationDate,lastUpdate,ownerId,updaterId) VALUES(?,?,?,?,?)";
    
    /** SELECT SQL statement */
    public static final String SQL_SELECT = "SELECT CONTENT.id,CONTENT.creationDate,CONTENT.lastUpdate,CONTENT.ownerId,CONTENT.updaterId FROM CONTENT";
    
    /** UPDATE SQL statement */
    public static final String SQL_UPDATE = "UPDATE CONTENT SET creationDate=?,lastUpdate=?,ownerId=?,updaterId=?";
    
    /** Delete SQL Statement */
    public static final String SQL_DELETE = "DELETE FROM CONTENT";

    /** Active connection */
    private Connection cnn;
    
    
////////////////////////////////////
// Constructors
////////////////////////////////////

    public ContentDAO( Connection cnn )
    {
        if ( cnn == null )  throw new IllegalArgumentException( "cnn is null" );
        
        this.cnn = cnn;
    }
    

////////////////////////////////////
// Public methods
////////////////////////////////////
    
    /**
     * Persist a Content into the database
     *
     * @param       Content to persist
     * @return      value of the primary key of the object persisted
     * @throws      SQLException if any error occurs
     */
    public int create( ContentDTO data ) throws SQLException
    {
        PreparedStatement stmt = null;
        try
        {

            // Create the object
            stmt = cnn.prepareStatement( SQL_INSERT, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );
            
                            
        stmt.setInt( 1, data.getId() );
                            
        java.util.Date value2 = data.getCreationDate();
                    stmt.setDate( 2, value2 != null ? new java.sql.Date( value2.getTime() ) : null ); 
                                    
        java.util.Date value3 = data.getLastUpdate();
                    stmt.setDate( 3, value3 != null ? new java.sql.Date( value3.getTime() ) : null ); 
                                                            
        int value4 = data.getOwnerId();
        if ( value4 != 0 )  stmt.setInt( 4, value4 ); else stmt.setNull( 4, Types.INTEGER );
                                                    
        int value5 = data.getUpdaterId();
        if ( value5 != 0 )  stmt.setInt( 5, value5 ); else stmt.setNull( 5, Types.INTEGER );
    
            stmt.executeUpdate();
            
            return data.getId();
        }
        finally
        {
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }

    /**
     * Persist modification on a Content into the database
     *
     * @param       Content to persist
     * @return      true if the object has been updated, false if not
     * @throws      SQLException if any error occurs
     */
    public boolean update( ContentDTO data ) throws SQLException
    {
        PreparedStatement stmt = null;


        if ( exists( data ) )
        {
            // Update the object
            try
            {
                stmt = cnn.prepareStatement( SQL_UPDATE + " WHERE id=?", ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );

                
                                
        java.util.Date value1 = data.getCreationDate();
                    stmt.setDate( 1, value1 != null ? new java.sql.Date( value1.getTime() ) : null ); 
                        
                                
        java.util.Date value2 = data.getLastUpdate();
                    stmt.setDate( 2, value2 != null ? new java.sql.Date( value2.getTime() ) : null ); 
                        
                                                        
        int value3 = data.getOwnerId();
        if ( value3 != 0 )  stmt.setInt( 3, value3 ); else stmt.setNull( 3, Types.INTEGER );
                
                                                        
        int value4 = data.getUpdaterId();
        if ( value4 != 0 )  stmt.setInt( 4, value4 ); else stmt.setNull( 4, Types.INTEGER );
                                            
        stmt.setInt( 5, data.getId() );
                    
                stmt.executeUpdate();
                return true;
            }
            finally
            {
                if ( stmt != null )
                {
                    try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
                }
            }
        }
        return false;
    }

    /**
     * Remove a Content from the database
     *
     * @param       pk  Primary key of the Content to remove
     * @throws      SQLException if any error occurs
     */
    public void removeByPK( int pk ) throws SQLException
    {
        PreparedStatement stmt = null;
        try
        {
            // Remove the object
            stmt = cnn.prepareStatement( SQL_DELETE + " WHERE id=?", ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );
            
                                
        stmt.setInt( 1, pk );
                
            stmt.executeUpdate();
        }
        finally
        {
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }
    
    /**
     * Find a Content by its primary key
     *
     * @param pk    primary key of the Content requested
     * @return      Content found, <code>null</code> if nothing found
     * @throws      SQLException if any error occurs
     */
    public ContentDTO findByPK( int pk ) throws SQLException
    {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try
        {
            String sql = SQL_SELECT + " WHERE CONTENT.id=?";
            stmt = cnn.prepareStatement( sql, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );
                
                                
        stmt.setInt( 1, pk );
    
            rs = stmt.executeQuery();
            return rs.next() ? newDataObject( rs ) : null;
        }
        finally
        {
            if ( rs != null )
            {
                try{    rs.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }

                                            
    /**
     * Find document of a given ower created after a given date
     *
      * @param ownerId     Id of the owner
      * @param creationDate     
      * @param _index          Index of the first element to return. (0 is the starting index)
     * @param _maxcount       Max number of items to return
     * @return                java.util.Set of Content, or an empty java.util.Set if nothing found
     * @throws SQLException   if any error occurs
     */
     public Set findByOwner_CreationDate ( int ownerId, java.util.Date creationDate, int _index, int _maxcount ) throws SQLException
    {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try
        {
            String sql = SQL_SELECT + " WHERE ownerId=? AND creationDate>?";
            stmt = cnn.prepareStatement( sql, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );


                                                    
        int value1 = ownerId;
        if ( value1 != 0 )  stmt.setInt( 1, value1 ); else stmt.setNull( 1, Types.INTEGER );
    
                            
        java.util.Date value2 = creationDate;
                    stmt.setDate( 2, value2 != null ? new java.sql.Date( value2.getTime() ) : null ); 
            
            rs = stmt.executeQuery();


            return filter( rs, _index, _maxcount );
        }
        finally
        {
            if ( rs != null )
            {
                try{    rs.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }


//////////////////////////////////////////////////
// Private methods
//////////////////////////////////////////////////

    private boolean exists( ContentDTO data ) throws SQLException
    {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try
        {
            stmt = cnn.prepareStatement( "SELECT id FROM CONTENT WHERE id=?", ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );
            
                                
        stmt.setInt( 1, data.getId() );
                
            rs = stmt.executeQuery();
            return rs.next();
        }
        finally
        {
            if ( rs != null )
            {
                try{    rs.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }

    private Set filter( ResultSet rs, int offset, int maxcount ) throws SQLException
    {
        HashSet set = new HashSet();
        for( int i=0, count=0 ; rs.next() && ( maxcount > count ) ; i++ )
        {
            if ( i >= offset )
            {
                set.add( newDataObject( rs ) );
                count++;
            }
        }
        return set;
    }

    private ContentDTO newDataObject( ResultSet rs ) throws SQLException
    {
        ContentDTO data = new ContentDTO();
        

                        data.setId( rs.getInt( 1 ) );

                        data.setCreationDate( rs.getDate( 2 ) );

                        data.setLastUpdate( rs.getDate( 3 ) );

                        data.setOwnerId( rs.getInt( 4 ) );

                        data.setUpdaterId( rs.getInt( 5 ) );

        return data;
    }
}
