#include "main.h"
//------------------------------------------------------------------------------
Controller::Controller (HWND hwnd)
    :	_output		 	(hwnd,	IDE_OUTPUT),
        _stop		 	(hwnd,	IDB_STOP),
        _start		 	(hwnd,	IDB_START, FALSE),
        _options	 	(hwnd,	IDB_OPTIONS, TRUE),
        _smart			(hwnd,	IDR_SMART, TRUE),
        _fast			(hwnd,	IDR_FAST, TRUE),
        _immediate		(hwnd,	IDR_IMMEDIATE, TRUE)

{
    // Attach icon to main dialog
    hIconR = LoadIcon (TheInstance, MAKEINTRESOURCE (IDI_APPICON ));
    hIconS = LoadIcon (TheInstance, MAKEINTRESOURCE (IDI_APPICONSTOP ));
    
    SendMessage (hwnd, WM_SETICON, WPARAM (TRUE), LPARAM (hIconS));
    SendMessage (hwnd, WM_SETICON, WPARAM (FALSE), LPARAM (hIconS));

    // Add icon to system tray
    ni_data.cbSize = sizeof(NOTIFYICONDATA);
    ni_data.hWnd = hwnd;
    ni_data.uID = IDI_APPICON;
    ni_data.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
    ni_data.uCallbackMessage = WM_ICON_NOTIFY;
    ni_data.hIcon = hIconS;
    sprintf( ni_data.szTip, MSGFMT_TOOLTIP_STOPPED_S, Prf.m_title );
    Shell_NotifyIcon( NIM_ADD, &ni_data );
    
    // Other initializations...
    _output.SetFocus();
    _smart.Select();
	
	_shutdownmode =0;
}
//------------------------------------------------------------------------------
void Controller::WriteOutput( char* buf )
{
	Prf.Log(buf);

	switch( _output.AppendStringCheck(buf))
	{
		case 0:
			break;
		case __FLAG_READY:
			DisableStartButton();
			EnableStopButton();
   			SendMessage (ni_data.hWnd, WM_SETICON, WPARAM (TRUE), LPARAM (hIconR));
       		SendMessage (ni_data.hWnd, WM_SETICON, WPARAM (FALSE), LPARAM (hIconR));
       		sprintf( ni_data.szTip, MSGFMT_TOOLTIP_STARTED_S, Prf.m_title);
       		ni_data.hIcon = hIconR;
       		Shell_NotifyIcon( NIM_MODIFY, &ni_data );
			break;
		case __FLAG_SHUTDOWN:
			EnableStartButton();
			DisableStopButton();
   			SendMessage (ni_data.hWnd, WM_SETICON, WPARAM (TRUE), LPARAM (hIconS));
       		SendMessage (ni_data.hWnd, WM_SETICON, WPARAM (FALSE), LPARAM (hIconS));
       		sprintf( ni_data.szTip, MSGFMT_TOOLTIP_STOPPED_S, Prf.m_title);
       		ni_data.hIcon = hIconS;
       		Shell_NotifyIcon( NIM_MODIFY, &ni_data );
			if(Prf.m_stopquit)
				PostMessage(ni_data.hWnd, WM_QUIT,0,0L);
			break;
	}
}
//------------------------------------------------------------------------------
void Controller::Command (HWND hwnd, int controlID, int command)
{
    switch (controlID)
    {
        case IDR_SMART:
        	_shutdownmode = 0;
            break;
        case IDR_FAST:
        	_shutdownmode = 1;
            break;
        case IDR_IMMEDIATE:
        	_shutdownmode = 2;
            break;
        case IDE_OUTPUT:
            break;
        case IDB_START:
			SetWindowText(hwnd, Prf.m_title);
            ConsolePostmaster.StartChildProcess( Prf.m_command, Prf.m_bindir, FALSE );
            break;
        case IDB_STOP:
			SignalCommand( GetCommandPid( Prf.m_pidfile ), GetShutdownMode() );
            break;
        case IDB_OPTIONS:
            int hDialogOpt = 0;
		    hDialogOpt = DialogBox (TheInstance, MAKEINTRESOURCE (IDD_OPTIONS), hwnd, (DLGPROC)DialogProcOpt);
		    switch ( hDialogOpt  )
		    {
		    	case -1:
		        	ShowLastError(MSG_DIALOGBOX);
		        	break;
		        case OPT_DLG_CANCEL:
		        	break;
		        case OPT_DLG_ERR:
		        	MessageBox( NULL, MSG_SAVE_VALUES_FAILED, MSG_ERROR, MB_OK|MB_ICONINFORMATION );
		        	break;
		        case OPT_DLG_OK:
		        	MessageBox( NULL, MSG_SAVE_VALUES_RESTART, MSG_SUCCESS, MB_OK|MB_ICONINFORMATION );
		        	break;
		    }		            		
        	break;
    }
}
//------------------------------------------------------------------------------
void Controller::OnTrayNotification(UINT wParam, LONG lParam)
{
	if (LOWORD(lParam) == WM_LBUTTONDBLCLK )
	{
		Show();
	}
}
//------------------------------------------------------------------------------
void Controller::Hide( void )
{
	::ShowWindow( ni_data.hWnd, SW_HIDE );
}
//------------------------------------------------------------------------------
void Controller::Show( void )
{
	::ShowWindow( ni_data.hWnd, SW_SHOWNORMAL );
}
//------------------------------------------------------------------------------
