/*
 *
 *  Created by: Win Bausch and Bettina Kemme
 *
 */
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/times.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <limits.h>
#include "c.h"

#include "utils/elog.h"

static int PerfLogFile = 0;

int LogFile_init(void);
int LogFile_record(bool isLocal, uint32 xid, const char *recordTag);
int LogFile_close(void);

int
LogFile_init(void)
{	
	char logfilepath[80],
		 logOrigin[40];
	time_t origin = 0;
	
	if (!getenv("PGPERFLOG"))
		return -1;
		
	sprintf(logfilepath, "%s/%lx.%lu", getenv("PGPERFLOG"), gethostid(), getpid());
	PerfLogFile = open(logfilepath, O_RDWR | O_CREAT);
	origin = time(NULL);
	sprintf(logOrigin, "host %s on %s\n", getenv("HOST"), ctime(&origin));
	write(PerfLogFile, logOrigin , strlen(logOrigin)); 
	return 0;
}

int
LogFile_record(bool isLocal, uint32 xid, const char *recordTag)
{
	struct tms 	dummy;
	clock_t		time = 0;
	char 		logline[200];
	
	//elog(NOTICE,"About to write log record...");
	if(!PerfLogFile)
		return -1;
		
	time = times(&dummy);
	sprintf(logline, "%s %lu %s %lu\n", isLocal ? "L":"R", (long) xid, recordTag, time);
	write(PerfLogFile, logline, strlen(logline));
	//elog(NOTICE, "Done");
	return 0;
}

int
LogFile_close(void)
{
	close(PerfLogFile);
	PerfLogFile = 0;
	return 0;
}
