/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc3;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.Field;
import org.postgresql.core.ResultHandler;
import org.postgresql.core.Utils;
import org.postgresql.jdbc2.AbstractJdbc2Statement;
import org.postgresql.jdbc3.AbstractJdbc3Connection;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc3Statement
extends AbstractJdbc2Statement {
    private final int rsHoldability;

    public AbstractJdbc3Statement(AbstractJdbc3Connection c, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(c, rsType, rsConcurrency);
        this.rsHoldability = rsHoldability;
    }

    public AbstractJdbc3Statement(AbstractJdbc3Connection connection, String sql, boolean isCallable, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, sql, isCallable, rsType, rsConcurrency);
        this.rsHoldability = rsHoldability;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (current == 1 && this.result != null && this.result.getResultSet() != null) {
            this.result.getResultSet().close();
        }
        if (this.result != null) {
            this.result = this.result.getNext();
        }
        if (current == 3) {
            while (this.firstUnclosedResult != this.result) {
                if (this.firstUnclosedResult.getResultSet() != null) {
                    this.firstUnclosedResult.getResultSet().close();
                }
                this.firstUnclosedResult = this.firstUnclosedResult.getNext();
            }
        }
        return this.result != null && this.result.getResultSet() != null;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkClosed();
        if (this.generatedKeys == null || this.generatedKeys.getResultSet() == null) {
            return this.createDriverResultSet(new Field[0], new Vector());
        }
        return this.generatedKeys.getResultSet();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.executeUpdate(sql);
        }
        sql = AbstractJdbc3Statement.addReturning(sql, new String[]{"*"}, false);
        this.executeReturning(sql);
        return this.getUpdateCount();
    }

    private static String addReturning(String sql, String[] columns, boolean escape) throws SQLException {
        if ((sql = sql.trim()).endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        StringBuffer sb = new StringBuffer(sql);
        sb.append(" RETURNING ");
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            if (escape) {
                Utils.appendEscapedIdentifier(sb, columns[i]);
                continue;
            }
            sb.append(columns[i]);
        }
        return sb.toString();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null || columnIndexes.length == 0) {
            return this.executeUpdate(sql);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys by column index is not supported."), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames == null || columnNames.length == 0) {
            return this.executeUpdate(sql);
        }
        sql = AbstractJdbc3Statement.addReturning(sql, columnNames, true);
        this.executeReturning(sql);
        return this.getUpdateCount();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.execute(sql);
        }
        sql = AbstractJdbc3Statement.addReturning(sql, new String[]{"*"}, false);
        return this.executeReturning(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null || columnIndexes.length == 0) {
            return this.execute(sql);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys by column index is not supported."), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (columnNames.length == 0) {
            return this.execute(sql);
        }
        sql = AbstractJdbc3Statement.addReturning(sql, columnNames, true);
        return this.executeReturning(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.rsHoldability;
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setURL(int,URL)");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        int flags = 49;
        AbstractJdbc2Statement.StatementResultHandler handler = new AbstractJdbc2Statement.StatementResultHandler();
        this.connection.getQueryExecutor().execute(this.preparedQuery, this.preparedParameters, (ResultHandler)handler, 0, 0, flags);
        int[] oids = this.preparedParameters.getTypeOIDs();
        if (oids != null) {
            return this.createParameterMetaData(this.connection, oids);
        }
        return null;
    }

    public abstract ParameterMetaData createParameterMetaData(BaseConnection var1, int[] var2) throws SQLException;

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(String,int)");
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(String,int,int)");
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(String,int,String)");
    }

    public URL getURL(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getURL(String)");
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setURL(String,URL)");
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNull(String,int)");
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBoolean(String,boolean)");
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setByte(String,byte)");
    }

    public void setShort(String parameterName, short x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setShort(String,short)");
    }

    public void setInt(String parameterName, int x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setInt(String,int)");
    }

    public void setLong(String parameterName, long x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setLong(String,long)");
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setFloat(String,float)");
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setDouble(String,double)");
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBigDecimal(String,BigDecimal)");
    }

    public void setString(String parameterName, String x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setString(String,String)");
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBytes(String,byte)");
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setDate(String,Date)");
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setTime(String,Time)");
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setTimestamp(String,Timestamp)");
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(String,InputStream,int)");
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBinaryStream(String,InputStream,int)");
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject(String,Object,int,int)");
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject(String,Object,int)");
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject(String,Object)");
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(String,Reader,int)");
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setDate(String,Date,Calendar)");
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setTime(String,Time,Calendar)");
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setTimestamp(String,Timestamp,Calendar)");
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNull(String,int,String)");
    }

    public String getString(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getString(String)");
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBoolean(String)");
    }

    public byte getByte(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getByte(String)");
    }

    public short getShort(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getShort(String)");
    }

    public int getInt(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getInt(String)");
    }

    public long getLong(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getLong(String)");
    }

    public float getFloat(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getFloat(String)");
    }

    public double getDouble(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getDouble(String)");
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBytes(String)");
    }

    public Date getDate(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getDate(String)");
    }

    public Time getTime(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTime(String)");
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTimestamp(String)");
    }

    public Object getObject(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(String)");
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBigDecimal(String)");
    }

    public Object getObjectImpl(String parameterName, Map map) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(String,Map)");
    }

    public Ref getRef(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRef(String)");
    }

    public Blob getBlob(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBlob(String)");
    }

    public Clob getClob(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getClob(String)");
    }

    public Array getArray(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getArray(String)");
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getDate(String,Calendar)");
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTime(String,Calendar)");
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTimestamp(String,Calendar)");
    }

    public URL getURL(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getURL(String)");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (targetSqlType == 16) {
            targetSqlType = -7;
        }
        super.setObject(parameterIndex, x, targetSqlType, scale);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (sqlType == 16) {
            sqlType = -7;
        }
        super.setNull(parameterIndex, sqlType);
    }

    @Override
    protected boolean wantsHoldableResultSet() {
        return this.rsHoldability == 1;
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        switch (sqlType) {
            case 16: {
                sqlType = -7;
                break;
            }
        }
        super.registerOutParameter(parameterIndex, sqlType, !this.adjustIndex);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }
}

