/*-------------------------------------------------------------------------
 *
 * fmgroids.h
 *    Macros that define the OIDs of built-in functions.
 *
 * These macros can be used to avoid a catalog lookup when a specific
 * fmgr-callable function needs to be referenced.
 *
 * Portions Copyright (c) 1996-2008, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *	******************************
 *	*** DO NOT EDIT THIS FILE! ***
 *	******************************
 *
 *	It has been GENERATED by Gen_fmgrtab.sh
 *	from ../../../src/include/catalog/pg_proc.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef	FMGROIDS_H
#define FMGROIDS_H

/*
 *	Constant macros for the OIDs of entries in pg_proc.
 *
 *	NOTE: macros are named after the prosrc value, ie the actual C name
 *	of the implementing function, not the proname which may be overloaded.
 *	For example, we want to be able to assign different macro names to both
 *	char_text() and name_text() even though these both appear with proname
 *	'text'.  If the same C function appears in more than one pg_proc entry,
 *	its equivalent macro will be defined with the lowest OID among those
 *	entries.
 */
#define F_BYTEAOUT 31
#define F_CHAROUT 33
#define F_NAMEIN 34
#define F_NAMEOUT 35
#define F_INT2IN 38
#define F_INT2OUT 39
#define F_INT2VECTORIN 40
#define F_INT2VECTOROUT 41
#define F_INT4IN 42
#define F_INT4OUT 43
#define F_REGPROCIN 44
#define F_REGPROCOUT 45
#define F_TEXTIN 46
#define F_TEXTOUT 47
#define F_TIDIN 48
#define F_TIDOUT 49
#define F_XIDIN 50
#define F_XIDOUT 51
#define F_CIDIN 52
#define F_CIDOUT 53
#define F_OIDVECTORIN 54
#define F_OIDVECTOROUT 55
#define F_BOOLLT 56
#define F_BOOLGT 57
#define F_BOOLEQ 60
#define F_CHAREQ 61
#define F_NAMEEQ 62
#define F_INT2EQ 63
#define F_INT2LT 64
#define F_INT4EQ 65
#define F_INT4LT 66
#define F_TEXTEQ 67
#define F_XIDEQ 68
#define F_CIDEQ 69
#define F_CHARNE 70
#define F_CHARLE 72
#define F_CHARGT 73
#define F_CHARGE 74
#define F_CHARTOI4 77
#define F_I4TOCHAR 78
#define F_NAMEREGEXEQ 79
#define F_BOOLNE 84
#define F_PGSQL_VERSION 89
#define F_EQSEL 101
#define F_NEQSEL 102
#define F_SCALARLTSEL 103
#define F_SCALARGTSEL 104
#define F_EQJOINSEL 105
#define F_NEQJOINSEL 106
#define F_SCALARLTJOINSEL 107
#define F_SCALARGTJOINSEL 108
#define F_UNKNOWNIN 109
#define F_UNKNOWNOUT 110
#define F_NUMERIC_FAC 111
#define F_BOX_ABOVE_EQ 115
#define F_BOX_BELOW_EQ 116
#define F_POINT_IN 117
#define F_POINT_OUT 118
#define F_LSEG_IN 119
#define F_LSEG_OUT 120
#define F_PATH_IN 121
#define F_PATH_OUT 122
#define F_BOX_IN 123
#define F_BOX_OUT 124
#define F_BOX_OVERLAP 125
#define F_BOX_GE 126
#define F_BOX_GT 127
#define F_BOX_EQ 128
#define F_BOX_LT 129
#define F_BOX_LE 130
#define F_POINT_ABOVE 131
#define F_POINT_LEFT 132
#define F_POINT_RIGHT 133
#define F_POINT_BELOW 134
#define F_POINT_EQ 135
#define F_ON_PB 136
#define F_ON_PPATH 137
#define F_BOX_CENTER 138
#define F_AREASEL 139
#define F_AREAJOINSEL 140
#define F_INT4MUL 141
#define F_INT4NE 144
#define F_INT2NE 145
#define F_INT2GT 146
#define F_INT4GT 147
#define F_INT2LE 148
#define F_INT4LE 149
#define F_INT4GE 150
#define F_INT2GE 151
#define F_INT2MUL 152
#define F_INT2DIV 153
#define F_INT4DIV 154
#define F_INT2MOD 155
#define F_INT4MOD 156
#define F_TEXTNE 157
#define F_INT24EQ 158
#define F_INT42EQ 159
#define F_INT24LT 160
#define F_INT42LT 161
#define F_INT24GT 162
#define F_INT42GT 163
#define F_INT24NE 164
#define F_INT42NE 165
#define F_INT24LE 166
#define F_INT42LE 167
#define F_INT24GE 168
#define F_INT42GE 169
#define F_INT24MUL 170
#define F_INT42MUL 171
#define F_INT24DIV 172
#define F_INT42DIV 173
#define F_INT24MOD 174
#define F_INT42MOD 175
#define F_INT2PL 176
#define F_INT4PL 177
#define F_INT24PL 178
#define F_INT42PL 179
#define F_INT2MI 180
#define F_INT4MI 181
#define F_INT24MI 182
#define F_INT42MI 183
#define F_OIDEQ 184
#define F_OIDNE 185
#define F_BOX_SAME 186
#define F_BOX_CONTAIN 187
#define F_BOX_LEFT 188
#define F_BOX_OVERLEFT 189
#define F_BOX_OVERRIGHT 190
#define F_BOX_RIGHT 191
#define F_BOX_CONTAINED 192
#define F_FLOAT4IN 200
#define F_FLOAT4OUT 201
#define F_FLOAT4MUL 202
#define F_FLOAT4DIV 203
#define F_FLOAT4PL 204
#define F_FLOAT4MI 205
#define F_FLOAT4UM 206
#define F_FLOAT4ABS 207
#define F_FLOAT4_ACCUM 208
#define F_FLOAT4LARGER 209
#define F_FLOAT4SMALLER 211
#define F_INT4UM 212
#define F_INT2UM 213
#define F_FLOAT8IN 214
#define F_FLOAT8OUT 215
#define F_FLOAT8MUL 216
#define F_FLOAT8DIV 217
#define F_FLOAT8PL 218
#define F_FLOAT8MI 219
#define F_FLOAT8UM 220
#define F_FLOAT8ABS 221
#define F_FLOAT8_ACCUM 222
#define F_FLOAT8LARGER 223
#define F_FLOAT8SMALLER 224
#define F_LSEG_CENTER 225
#define F_PATH_CENTER 226
#define F_POLY_CENTER 227
#define F_DROUND 228
#define F_DTRUNC 229
#define F_DSQRT 230
#define F_DCBRT 231
#define F_DPOW 232
#define F_DEXP 233
#define F_DLOG1 234
#define F_I2TOD 235
#define F_I2TOF 236
#define F_DTOI2 237
#define F_FTOI2 238
#define F_LINE_DISTANCE 239
#define F_ABSTIMEIN 240
#define F_ABSTIMEOUT 241
#define F_RELTIMEIN 242
#define F_RELTIMEOUT 243
#define F_TIMEPL 244
#define F_TIMEMI 245
#define F_TINTERVALIN 246
#define F_TINTERVALOUT 247
#define F_INTINTERVAL 248
#define F_TINTERVALREL 249
#define F_TIMENOW 250
#define F_ABSTIMEEQ 251
#define F_ABSTIMENE 252
#define F_ABSTIMELT 253
#define F_ABSTIMEGT 254
#define F_ABSTIMELE 255
#define F_ABSTIMEGE 256
#define F_RELTIMEEQ 257
#define F_RELTIMENE 258
#define F_RELTIMELT 259
#define F_RELTIMEGT 260
#define F_RELTIMELE 261
#define F_RELTIMEGE 262
#define F_TINTERVALSAME 263
#define F_TINTERVALCT 264
#define F_TINTERVALOV 265
#define F_TINTERVALLENEQ 266
#define F_TINTERVALLENNE 267
#define F_TINTERVALLENLT 268
#define F_TINTERVALLENGT 269
#define F_TINTERVALLENLE 270
#define F_TINTERVALLENGE 271
#define F_TINTERVALSTART 272
#define F_TINTERVALEND 273
#define F_TIMEOFDAY 274
#define F_ABSTIME_FINITE 275
#define F_INTER_SL 277
#define F_INTER_LB 278
#define F_FLOAT48MUL 279
#define F_FLOAT48DIV 280
#define F_FLOAT48PL 281
#define F_FLOAT48MI 282
#define F_FLOAT84MUL 283
#define F_FLOAT84DIV 284
#define F_FLOAT84PL 285
#define F_FLOAT84MI 286
#define F_FLOAT4EQ 287
#define F_FLOAT4NE 288
#define F_FLOAT4LT 289
#define F_FLOAT4LE 290
#define F_FLOAT4GT 291
#define F_FLOAT4GE 292
#define F_FLOAT8EQ 293
#define F_FLOAT8NE 294
#define F_FLOAT8LT 295
#define F_FLOAT8LE 296
#define F_FLOAT8GT 297
#define F_FLOAT8GE 298
#define F_FLOAT48EQ 299
#define F_FLOAT48NE 300
#define F_FLOAT48LT 301
#define F_FLOAT48LE 302
#define F_FLOAT48GT 303
#define F_FLOAT48GE 304
#define F_FLOAT84EQ 305
#define F_FLOAT84NE 306
#define F_FLOAT84LT 307
#define F_FLOAT84LE 308
#define F_FLOAT84GT 309
#define F_FLOAT84GE 310
#define F_FTOD 311
#define F_DTOF 312
#define F_I2TOI4 313
#define F_I4TOI2 314
#define F_INT2VECTOREQ 315
#define F_I4TOD 316
#define F_DTOI4 317
#define F_I4TOF 318
#define F_FTOI4 319
#define F_WIDTH_BUCKET_FLOAT8 320
#define F_HASH_ACLITEM 329
#define F_BTGETTUPLE 330
#define F_BTINSERT 331
#define F_BTBULKDELETE 332
#define F_BTBEGINSCAN 333
#define F_BTRESCAN 334
#define F_BTENDSCAN 335
#define F_BTMARKPOS 336
#define F_BTRESTRPOS 337
#define F_BTBUILD 338
#define F_POLY_SAME 339
#define F_POLY_CONTAIN 340
#define F_POLY_LEFT 341
#define F_POLY_OVERLEFT 342
#define F_POLY_OVERRIGHT 343
#define F_POLY_RIGHT 344
#define F_POLY_CONTAINED 345
#define F_POLY_OVERLAP 346
#define F_POLY_IN 347
#define F_POLY_OUT 348
#define F_BTINT2CMP 350
#define F_BTINT4CMP 351
#define F_BTFLOAT4CMP 354
#define F_BTFLOAT8CMP 355
#define F_BTOIDCMP 356
#define F_BTABSTIMECMP 357
#define F_BTCHARCMP 358
#define F_BTNAMECMP 359
#define F_BTTEXTCMP 360
#define F_LSEG_DISTANCE 361
#define F_LSEG_INTERPT 362
#define F_DIST_PS 363
#define F_DIST_PB 364
#define F_DIST_SB 365
#define F_CLOSE_PS 366
#define F_CLOSE_PB 367
#define F_CLOSE_SB 368
#define F_ON_PS 369
#define F_PATH_DISTANCE 370
#define F_DIST_PPATH 371
#define F_ON_SB 372
#define F_INTER_SB 373
#define F_CASH_CMP 377
#define F_ARRAY_PUSH 378
#define F_BTRELTIMECMP 380
#define F_BTTINTERVALCMP 381
#define F_BTARRAYCMP 382
#define F_ARRAY_CAT 383
#define F_ARRAY_NE 390
#define F_ARRAY_LT 391
#define F_ARRAY_GT 392
#define F_ARRAY_LE 393
#define F_TEXT_TO_ARRAY 394
#define F_ARRAY_TO_TEXT 395
#define F_ARRAY_GE 396
#define F_HASHINT2VECTOR 398
#define F_HASHMACADDR 399
#define F_HASHTEXT 400
#define F_RTRIM1 401
#define F_BTOIDVECTORCMP 404
#define F_NAME_TEXT 406
#define F_TEXT_NAME 407
#define F_NAME_BPCHAR 408
#define F_BPCHAR_NAME 409
#define F_HASHINET 422
#define F_HASHVACUUMCLEANUP 425
#define F_HASH_NUMERIC 432
#define F_MACADDR_IN 436
#define F_MACADDR_OUT 437
#define F_HASHCOSTESTIMATE 438
#define F_HASHGETTUPLE 440
#define F_HASHINSERT 441
#define F_HASHBULKDELETE 442
#define F_HASHBEGINSCAN 443
#define F_HASHRESCAN 444
#define F_HASHENDSCAN 445
#define F_HASHMARKPOS 446
#define F_HASHRESTRPOS 447
#define F_HASHBUILD 448
#define F_HASHINT2 449
#define F_HASHINT4 450
#define F_HASHFLOAT4 451
#define F_HASHFLOAT8 452
#define F_HASHOID 453
#define F_HASHCHAR 454
#define F_HASHNAME 455
#define F_HASHVARLENA 456
#define F_HASHOIDVECTOR 457
#define F_TEXT_LARGER 458
#define F_TEXT_SMALLER 459
#define F_INT8IN 460
#define F_INT8OUT 461
#define F_INT8UM 462
#define F_INT8PL 463
#define F_INT8MI 464
#define F_INT8MUL 465
#define F_INT8DIV 466
#define F_INT8EQ 467
#define F_INT8NE 468
#define F_INT8LT 469
#define F_INT8GT 470
#define F_INT8LE 471
#define F_INT8GE 472
#define F_INT84EQ 474
#define F_INT84NE 475
#define F_INT84LT 476
#define F_INT84GT 477
#define F_INT84LE 478
#define F_INT84GE 479
#define F_INT84 480
#define F_INT48 481
#define F_I8TOD 482
#define F_DTOI8 483
#define F_ARRAY_LARGER 515
#define F_ARRAY_SMALLER 516
#define F_INET_ABBREV 598
#define F_CIDR_ABBREV 599
#define F_INET_SET_MASKLEN 605
#define F_OIDVECTORNE 619
#define F_CIDR_SET_MASKLEN 635
#define F_BTGETMULTI 636
#define F_HASHGETMULTI 637
#define F_GISTGETMULTI 638
#define F_I8TOF 652
#define F_FTOI8 653
#define F_NAMELT 655
#define F_NAMELE 656
#define F_NAMEGT 657
#define F_NAMEGE 658
#define F_NAMENE 659
#define F_BPCHAR 668
#define F_VARCHAR 669
#define F_MKTINTERVAL 676
#define F_OIDVECTORLT 677
#define F_OIDVECTORLE 678
#define F_OIDVECTOREQ 679
#define F_OIDVECTORGE 680
#define F_OIDVECTORGT 681
#define F_NETWORK_NETWORK 683
#define F_NETWORK_NETMASK 696
#define F_NETWORK_MASKLEN 697
#define F_NETWORK_BROADCAST 698
#define F_NETWORK_HOST 699
#define F_CURRENT_USER 710
#define F_NETWORK_FAMILY 711
#define F_INT82 714
#define F_LO_CREATE 715
#define F_OIDLT 716
#define F_OIDLE 717
#define F_BYTEAOCTETLEN 720
#define F_BYTEAGETBYTE 721
#define F_BYTEASETBYTE 722
#define F_BYTEAGETBIT 723
#define F_BYTEASETBIT 724
#define F_DIST_PL 725
#define F_DIST_LB 726
#define F_DIST_SL 727
#define F_DIST_CPOLY 728
#define F_POLY_DISTANCE 729
#define F_NETWORK_SHOW 730
#define F_TEXT_LT 740
#define F_TEXT_LE 741
#define F_TEXT_GT 742
#define F_TEXT_GE 743
#define F_ARRAY_EQ 744
#define F_SESSION_USER 746
#define F_ARRAY_DIMS 747
#define F_ARRAY_IN 750
#define F_ARRAY_OUT 751
#define F_MACADDR_TRUNC 753
#define F_INT28 754
#define F_SMGRIN 760
#define F_SMGROUT 761
#define F_SMGREQ 762
#define F_SMGRNE 763
#define F_LO_IMPORT 764
#define F_LO_EXPORT 765
#define F_INT4INC 766
#define F_INT4LARGER 768
#define F_INT4SMALLER 769
#define F_INT2LARGER 770
#define F_INT2SMALLER 771
#define F_GISTCOSTESTIMATE 772
#define F_GISTGETTUPLE 774
#define F_GISTINSERT 775
#define F_GISTBULKDELETE 776
#define F_GISTBEGINSCAN 777
#define F_GISTRESCAN 778
#define F_GISTENDSCAN 779
#define F_GISTMARKPOS 780
#define F_GISTRESTRPOS 781
#define F_GISTBUILD 782
#define F_TINTERVALEQ 784
#define F_TINTERVALNE 785
#define F_TINTERVALLT 786
#define F_TINTERVALGT 787
#define F_TINTERVALLE 788
#define F_TINTERVALGE 789
#define F_PG_CLIENT_ENCODING 810
#define F_MACADDR_EQ 830
#define F_MACADDR_LT 831
#define F_MACADDR_LE 832
#define F_MACADDR_GT 833
#define F_MACADDR_GE 834
#define F_MACADDR_NE 835
#define F_MACADDR_CMP 836
#define F_BTINT8CMP 842
#define F_CASH_MUL_FLT4 846
#define F_CASH_DIV_FLT4 847
#define F_FLT4_MUL_CASH 848
#define F_TEXTPOS 849
#define F_TEXTLIKE 850
#define F_TEXTNLIKE 851
#define F_INT48EQ 852
#define F_INT48NE 853
#define F_INT48LT 854
#define F_INT48GT 855
#define F_INT48LE 856
#define F_INT48GE 857
#define F_NAMELIKE 858
#define F_NAMENLIKE 859
#define F_CHAR_BPCHAR 860
#define F_CURRENT_DATABASE 861
#define F_INT4_MUL_CASH 862
#define F_INT2_MUL_CASH 863
#define F_CASH_MUL_INT4 864
#define F_CASH_DIV_INT4 865
#define F_CASH_MUL_INT2 866
#define F_CASH_DIV_INT2 867
#define F_LOWER 870
#define F_UPPER 871
#define F_INITCAP 872
#define F_LPAD 873
#define F_RPAD 874
#define F_LTRIM 875
#define F_RTRIM 876
#define F_TEXT_SUBSTR 877
#define F_TRANSLATE 878
#define F_LTRIM1 881
#define F_TEXT_SUBSTR_NO_LEN 883
#define F_BTRIM 884
#define F_BTRIM1 885
#define F_CASH_IN 886
#define F_CASH_OUT 887
#define F_CASH_EQ 888
#define F_CASH_NE 889
#define F_CASH_LT 890
#define F_CASH_LE 891
#define F_CASH_GT 892
#define F_CASH_GE 893
#define F_CASH_PL 894
#define F_CASH_MI 895
#define F_CASH_MUL_FLT8 896
#define F_CASH_DIV_FLT8 897
#define F_CASHLARGER 898
#define F_CASHSMALLER 899
#define F_INET_IN 910
#define F_INET_OUT 911
#define F_FLT8_MUL_CASH 919
#define F_NETWORK_EQ 920
#define F_NETWORK_LT 921
#define F_NETWORK_LE 922
#define F_NETWORK_GT 923
#define F_NETWORK_GE 924
#define F_NETWORK_NE 925
#define F_NETWORK_CMP 926
#define F_NETWORK_SUB 927
#define F_NETWORK_SUBEQ 928
#define F_NETWORK_SUP 929
#define F_NETWORK_SUPEQ 930
#define F_CASH_WORDS 935
#define F_TEXT_CHAR 944
#define F_INT8MOD 945
#define F_CHAR_TEXT 946
#define F_HASHINT8 949
#define F_ISTRUE 950
#define F_ISFALSE 951
#define F_LO_OPEN 952
#define F_LO_CLOSE 953
#define F_LOREAD 954
#define F_LOWRITE 955
#define F_LO_LSEEK 956
#define F_LO_CREAT 957
#define F_LO_TELL 958
#define F_ON_PL 959
#define F_ON_SL 960
#define F_CLOSE_PL 961
#define F_CLOSE_SL 962
#define F_CLOSE_LB 963
#define F_LO_UNLINK 964
#define F_BTVACUUMCLEANUP 972
#define F_PATH_INTER 973
#define F_BOX_AREA 975
#define F_BOX_WIDTH 976
#define F_BOX_HEIGHT 977
#define F_BOX_DISTANCE 978
#define F_PATH_AREA 979
#define F_BOX_INTERSECT 980
#define F_BOX_DIAGONAL 981
#define F_PATH_N_LT 982
#define F_PATH_N_GT 983
#define F_PATH_N_EQ 984
#define F_PATH_N_LE 985
#define F_PATH_N_GE 986
#define F_PATH_LENGTH 987
#define F_POINT_NE 988
#define F_POINT_VERT 989
#define F_POINT_HORIZ 990
#define F_POINT_DISTANCE 991
#define F_POINT_SLOPE 992
#define F_LSEG_CONSTRUCT 993
#define F_LSEG_INTERSECT 994
#define F_LSEG_PARALLEL 995
#define F_LSEG_PERP 996
#define F_LSEG_VERTICAL 997
#define F_LSEG_HORIZONTAL 998
#define F_LSEG_EQ 999
#define F_LO_TRUNCATE 1004
#define F_TIMESTAMPTZ_IZONE 1026
#define F_NULLVALUE 1029
#define F_NONNULLVALUE 1030
#define F_ACLITEMIN 1031
#define F_ACLITEMOUT 1032
#define F_ACLINSERT 1035
#define F_ACLREMOVE 1036
#define F_ACLCONTAINS 1037
#define F_GETDATABASEENCODING 1039
#define F_BPCHARIN 1044
#define F_BPCHAROUT 1045
#define F_VARCHARIN 1046
#define F_VARCHAROUT 1047
#define F_BPCHAREQ 1048
#define F_BPCHARLT 1049
#define F_BPCHARLE 1050
#define F_BPCHARGT 1051
#define F_BPCHARGE 1052
#define F_BPCHARNE 1053
#define F_ACLITEM_EQ 1062
#define F_BPCHAR_LARGER 1063
#define F_BPCHAR_SMALLER 1064
#define F_PG_PREPARED_XACT 1065
#define F_GENERATE_SERIES_STEP_INT4 1066
#define F_GENERATE_SERIES_INT4 1067
#define F_GENERATE_SERIES_STEP_INT8 1068
#define F_GENERATE_SERIES_INT8 1069
#define F_BPCHARCMP 1078
#define F_TEXT_REGCLASS 1079
#define F_HASHBPCHAR 1080
#define F_FORMAT_TYPE 1081
#define F_DATE_IN 1084
#define F_DATE_OUT 1085
#define F_DATE_EQ 1086
#define F_DATE_LT 1087
#define F_DATE_LE 1088
#define F_DATE_GT 1089
#define F_DATE_GE 1090
#define F_DATE_NE 1091
#define F_DATE_CMP 1092
#define F_TIME_LT 1102
#define F_TIME_LE 1103
#define F_TIME_GT 1104
#define F_TIME_GE 1105
#define F_TIME_NE 1106
#define F_TIME_CMP 1107
#define F_DATE_LARGER 1138
#define F_DATE_SMALLER 1139
#define F_DATE_MI 1140
#define F_DATE_PLI 1141
#define F_DATE_MII 1142
#define F_TIME_IN 1143
#define F_TIME_OUT 1144
#define F_TIME_EQ 1145
#define F_CIRCLE_ADD_PT 1146
#define F_CIRCLE_SUB_PT 1147
#define F_CIRCLE_MUL_PT 1148
#define F_CIRCLE_DIV_PT 1149
#define F_TIMESTAMPTZ_IN 1150
#define F_TIMESTAMPTZ_OUT 1151
#define F_TIMESTAMP_EQ 1152
#define F_TIMESTAMP_NE 1153
#define F_TIMESTAMP_LT 1154
#define F_TIMESTAMP_LE 1155
#define F_TIMESTAMP_GE 1156
#define F_TIMESTAMP_GT 1157
#define F_TIMESTAMPTZ_ZONE 1159
#define F_INTERVAL_IN 1160
#define F_INTERVAL_OUT 1161
#define F_INTERVAL_EQ 1162
#define F_INTERVAL_NE 1163
#define F_INTERVAL_LT 1164
#define F_INTERVAL_LE 1165
#define F_INTERVAL_GE 1166
#define F_INTERVAL_GT 1167
#define F_INTERVAL_UM 1168
#define F_INTERVAL_PL 1169
#define F_INTERVAL_MI 1170
#define F_TIMESTAMPTZ_PART 1171
#define F_INTERVAL_PART 1172
#define F_ABSTIME_TIMESTAMPTZ 1173
#define F_DATE_TIMESTAMPTZ 1174
#define F_INTERVAL_JUSTIFY_HOURS 1175
#define F_RELTIME_INTERVAL 1177
#define F_TIMESTAMPTZ_DATE 1178
#define F_ABSTIME_DATE 1179
#define F_TIMESTAMPTZ_ABSTIME 1180
#define F_XID_AGE 1181
#define F_TIMESTAMP_MI 1188
#define F_TIMESTAMPTZ_PL_INTERVAL 1189
#define F_TIMESTAMPTZ_MI_INTERVAL 1190
#define F_INTERVAL_RELTIME 1194
#define F_TIMESTAMP_SMALLER 1195
#define F_TIMESTAMP_LARGER 1196
#define F_INTERVAL_SMALLER 1197
#define F_INTERVAL_LARGER 1198
#define F_TIMESTAMPTZ_AGE 1199
#define F_INTERVAL_SCALE 1200
#define F_TIMESTAMPTZ_TRUNC 1217
#define F_INTERVAL_TRUNC 1218
#define F_INT8INC 1219
#define F_INT8ABS 1230
#define F_INT8LARGER 1236
#define F_INT8SMALLER 1237
#define F_TEXTICREGEXEQ 1238
#define F_TEXTICREGEXNE 1239
#define F_NAMEICREGEXEQ 1240
#define F_NAMEICREGEXNE 1241
#define F_BOOLIN 1242
#define F_BOOLOUT 1243
#define F_BYTEAIN 1244
#define F_CHARIN 1245
#define F_CHARLT 1246
#define F_INT4ABS 1251
#define F_NAMEREGEXNE 1252
#define F_INT2ABS 1253
#define F_TEXTREGEXEQ 1254
#define F_TEXTREGEXNE 1256
#define F_TEXTLEN 1257
#define F_TEXTCAT 1258
#define F_PG_CHAR_TO_ENCODING 1264
#define F_TIDNE 1265
#define F_CIDR_IN 1267
#define F_BTCOSTESTIMATE 1268
#define F_PG_COLUMN_SIZE 1269
#define F_OVERLAPS_TIMETZ 1271
#define F_DATETIME_TIMESTAMP 1272
#define F_TIMETZ_PART 1273
#define F_INT84PL 1274
#define F_INT84MI 1275
#define F_INT84MUL 1276
#define F_INT84DIV 1277
#define F_INT48PL 1278
#define F_INT48MI 1279
#define F_INT48MUL 1280
#define F_INT48DIV 1281
#define F_QUOTE_IDENT 1282
#define F_QUOTE_LITERAL 1283
#define F_I8TOOID 1287
#define F_OIDTOI8 1288
#define F_TIDEQ 1292
#define F_CURRTID_BYRELOID 1293
#define F_CURRTID_BYRELNAME 1294
#define F_INTERVAL_JUSTIFY_DAYS 1295
#define F_DATETIMETZ_TIMESTAMPTZ 1297
#define F_NOW 1299
#define F_POSITIONSEL 1300
#define F_POSITIONJOINSEL 1301
#define F_CONTSEL 1302
#define F_CONTJOINSEL 1303
#define F_OVERLAPS_TIMESTAMP 1304
#define F_OVERLAPS_TIME 1308
#define F_TIMESTAMP_IN 1312
#define F_TIMESTAMP_OUT 1313
#define F_TIMESTAMP_CMP 1314
#define F_INTERVAL_CMP 1315
#define F_TIMESTAMP_TIME 1316
#define F_BPCHARLEN 1318
#define F_INTERVAL_DIV 1326
#define F_DLOG10 1339
#define F_OIDVECTORTYPES 1349
#define F_TIMETZ_IN 1350
#define F_TIMETZ_OUT 1351
#define F_TIMETZ_EQ 1352
#define F_TIMETZ_NE 1353
#define F_TIMETZ_LT 1354
#define F_TIMETZ_LE 1355
#define F_TIMETZ_GE 1356
#define F_TIMETZ_GT 1357
#define F_TIMETZ_CMP 1358
#define F_NETWORK_HOSTMASK 1362
#define F_MAKEACLITEM 1365
#define F_TIME_INTERVAL 1370
#define F_PG_LOCK_STATUS 1371
#define F_TEXTOCTETLEN 1374
#define F_BPCHAROCTETLEN 1375
#define F_TIME_LARGER 1377
#define F_TIME_SMALLER 1378
#define F_TIMETZ_LARGER 1379
#define F_TIMETZ_SMALLER 1380
#define F_TIME_PART 1385
#define F_PG_GET_CONSTRAINTDEF 1387
#define F_TIMESTAMPTZ_TIMETZ 1388
#define F_TIMESTAMP_FINITE 1389
#define F_INTERVAL_FINITE 1390
#define F_PG_STAT_GET_BACKEND_START 1391
#define F_PG_STAT_GET_BACKEND_CLIENT_ADDR 1392
#define F_PG_STAT_GET_BACKEND_CLIENT_PORT 1393
#define F_CURRENT_SCHEMA 1402
#define F_CURRENT_SCHEMAS 1403
#define F_LINE_PARALLEL 1412
#define F_LINE_PERP 1413
#define F_LINE_VERTICAL 1414
#define F_LINE_HORIZONTAL 1415
#define F_CIRCLE_CENTER 1416
#define F_ISNOTTRUE 1417
#define F_ISNOTFALSE 1418
#define F_INTERVAL_TIME 1419
#define F_POINTS_BOX 1421
#define F_BOX_ADD 1422
#define F_BOX_SUB 1423
#define F_BOX_MUL 1424
#define F_BOX_DIV 1425
#define F_CIDR_OUT 1427
#define F_POLY_CONTAIN_PT 1428
#define F_PT_CONTAINED_POLY 1429
#define F_PATH_ISCLOSED 1430
#define F_PATH_ISOPEN 1431
#define F_PATH_NPOINTS 1432
#define F_PATH_CLOSE 1433
#define F_PATH_OPEN 1434
#define F_PATH_ADD 1435
#define F_PATH_ADD_PT 1436
#define F_PATH_SUB_PT 1437
#define F_PATH_MUL_PT 1438
#define F_PATH_DIV_PT 1439
#define F_CONSTRUCT_POINT 1440
#define F_POINT_ADD 1441
#define F_POINT_SUB 1442
#define F_POINT_MUL 1443
#define F_POINT_DIV 1444
#define F_POLY_NPOINTS 1445
#define F_POLY_BOX 1446
#define F_POLY_PATH 1447
#define F_BOX_POLY 1448
#define F_PATH_POLY 1449
#define F_CIRCLE_IN 1450
#define F_CIRCLE_OUT 1451
#define F_CIRCLE_SAME 1452
#define F_CIRCLE_CONTAIN 1453
#define F_CIRCLE_LEFT 1454
#define F_CIRCLE_OVERLEFT 1455
#define F_CIRCLE_OVERRIGHT 1456
#define F_CIRCLE_RIGHT 1457
#define F_CIRCLE_CONTAINED 1458
#define F_CIRCLE_OVERLAP 1459
#define F_CIRCLE_BELOW 1460
#define F_CIRCLE_ABOVE 1461
#define F_CIRCLE_EQ 1462
#define F_CIRCLE_NE 1463
#define F_CIRCLE_LT 1464
#define F_CIRCLE_GT 1465
#define F_CIRCLE_LE 1466
#define F_CIRCLE_GE 1467
#define F_CIRCLE_AREA 1468
#define F_CIRCLE_DIAMETER 1469
#define F_CIRCLE_RADIUS 1470
#define F_CIRCLE_DISTANCE 1471
#define F_CR_CIRCLE 1473
#define F_POLY_CIRCLE 1474
#define F_CIRCLE_POLY 1475
#define F_DIST_PC 1476
#define F_CIRCLE_CONTAIN_PT 1477
#define F_PT_CONTAINED_CIRCLE 1478
#define F_BOX_CIRCLE 1479
#define F_CIRCLE_BOX 1480
#define F_LSEG_NE 1482
#define F_LSEG_LT 1483
#define F_LSEG_LE 1484
#define F_LSEG_GT 1485
#define F_LSEG_GE 1486
#define F_LSEG_LENGTH 1487
#define F_CLOSE_LS 1488
#define F_CLOSE_LSEG 1489
#define F_LINE_IN 1490
#define F_LINE_OUT 1491
#define F_LINE_EQ 1492
#define F_LINE_CONSTRUCT_PP 1493
#define F_LINE_INTERPT 1494
#define F_LINE_INTERSECT 1495
#define F_BIT_IN 1564
#define F_BIT_OUT 1565
#define F_PG_GET_RULEDEF 1573
#define F_NEXTVAL_OID 1574
#define F_CURRVAL_OID 1575
#define F_SETVAL_OID 1576
#define F_VARBIT_IN 1579
#define F_VARBIT_OUT 1580
#define F_BITEQ 1581
#define F_BITNE 1582
#define F_BITGE 1592
#define F_BITGT 1593
#define F_BITLE 1594
#define F_BITLT 1595
#define F_BITCMP 1596
#define F_PG_ENCODING_TO_CHAR 1597
#define F_DRANDOM 1598
#define F_SETSEED 1599
#define F_DASIN 1600
#define F_DACOS 1601
#define F_DATAN 1602
#define F_DATAN2 1603
#define F_DSIN 1604
#define F_DCOS 1605
#define F_DTAN 1606
#define F_DCOT 1607
#define F_DEGREES 1608
#define F_RADIANS 1609
#define F_DPI 1610
#define F_INTERVAL_MUL 1618
#define F_ASCII 1620
#define F_CHR 1621
#define F_REPEAT 1622
#define F_SIMILAR_ESCAPE 1623
#define F_MUL_D_INTERVAL 1624
#define F_TEXTICLIKE 1633
#define F_TEXTICNLIKE 1634
#define F_NAMEICLIKE 1635
#define F_NAMEICNLIKE 1636
#define F_LIKE_ESCAPE 1637
#define F_OIDGT 1638
#define F_OIDGE 1639
#define F_PG_GET_VIEWDEF_NAME 1640
#define F_PG_GET_VIEWDEF 1641
#define F_PG_GET_USERBYID 1642
#define F_PG_GET_INDEXDEF 1643
#define F_RI_FKEY_CHECK_INS 1644
#define F_RI_FKEY_CHECK_UPD 1645
#define F_RI_FKEY_CASCADE_DEL 1646
#define F_RI_FKEY_CASCADE_UPD 1647
#define F_RI_FKEY_RESTRICT_DEL 1648
#define F_RI_FKEY_RESTRICT_UPD 1649
#define F_RI_FKEY_SETNULL_DEL 1650
#define F_RI_FKEY_SETNULL_UPD 1651
#define F_RI_FKEY_SETDEFAULT_DEL 1652
#define F_RI_FKEY_SETDEFAULT_UPD 1653
#define F_RI_FKEY_NOACTION_DEL 1654
#define F_RI_FKEY_NOACTION_UPD 1655
#define F_PG_GET_TRIGGERDEF 1662
#define F_PG_GET_SERIAL_SEQUENCE 1665
#define F_BITAND 1673
#define F_BITOR 1674
#define F_BITXOR 1675
#define F_BITNOT 1676
#define F_BITSHIFTLEFT 1677
#define F_BITSHIFTRIGHT 1678
#define F_BITCAT 1679
#define F_BITSUBSTR 1680
#define F_BITLENGTH 1681
#define F_BITOCTETLENGTH 1682
#define F_BITFROMINT4 1683
#define F_BITTOINT4 1684
#define F_BIT 1685
#define F_VARBIT 1687
#define F_TIME_HASH 1688
#define F_FLATFILE_UPDATE_TRIGGER 1689
#define F_TIME_MI_TIME 1690
#define F_BOOLLE 1691
#define F_BOOLGE 1692
#define F_BTBOOLCMP 1693
#define F_TIMETZ_HASH 1696
#define F_INTERVAL_HASH 1697
#define F_BITPOSITION 1698
#define F_NUMERIC_IN 1701
#define F_NUMERIC_OUT 1702
#define F_NUMERIC 1703
#define F_NUMERIC_ABS 1704
#define F_NUMERIC_SIGN 1706
#define F_NUMERIC_ROUND 1707
#define F_NUMERIC_TRUNC 1709
#define F_NUMERIC_CEIL 1711
#define F_NUMERIC_FLOOR 1712
#define F_LENGTH_IN_ENCODING 1713
#define F_PG_CONVERT_FROM 1714
#define F_INET_TO_CIDR 1715
#define F_PG_GET_EXPR 1716
#define F_PG_CONVERT_TO 1717
#define F_NUMERIC_EQ 1718
#define F_NUMERIC_NE 1719
#define F_NUMERIC_GT 1720
#define F_NUMERIC_GE 1721
#define F_NUMERIC_LT 1722
#define F_NUMERIC_LE 1723
#define F_NUMERIC_ADD 1724
#define F_NUMERIC_SUB 1725
#define F_NUMERIC_MUL 1726
#define F_NUMERIC_DIV 1727
#define F_NUMERIC_MOD 1728
#define F_NUMERIC_SQRT 1730
#define F_NUMERIC_EXP 1732
#define F_NUMERIC_LN 1734
#define F_NUMERIC_LOG 1736
#define F_NUMERIC_POWER 1738
#define F_INT4_NUMERIC 1740
#define F_FLOAT4_NUMERIC 1742
#define F_FLOAT8_NUMERIC 1743
#define F_NUMERIC_INT4 1744
#define F_NUMERIC_FLOAT4 1745
#define F_NUMERIC_FLOAT8 1746
#define F_TIME_PL_INTERVAL 1747
#define F_TIME_MI_INTERVAL 1748
#define F_TIMETZ_PL_INTERVAL 1749
#define F_TIMETZ_MI_INTERVAL 1750
#define F_NUMERIC_INC 1764
#define F_SETVAL3_OID 1765
#define F_NUMERIC_SMALLER 1766
#define F_NUMERIC_LARGER 1767
#define F_INTERVAL_TO_CHAR 1768
#define F_NUMERIC_CMP 1769
#define F_TIMESTAMPTZ_TO_CHAR 1770
#define F_NUMERIC_UMINUS 1771
#define F_NUMERIC_TO_CHAR 1772
#define F_INT4_TO_CHAR 1773
#define F_INT8_TO_CHAR 1774
#define F_FLOAT4_TO_CHAR 1775
#define F_FLOAT8_TO_CHAR 1776
#define F_NUMERIC_TO_NUMBER 1777
#define F_TO_TIMESTAMP 1778
#define F_NUMERIC_INT8 1779
#define F_TO_DATE 1780
#define F_INT8_NUMERIC 1781
#define F_INT2_NUMERIC 1782
#define F_NUMERIC_INT2 1783
#define F_OIDIN 1798
#define F_OIDOUT 1799
#define F_PG_CONVERT 1813
#define F_ICLIKESEL 1814
#define F_ICNLIKESEL 1815
#define F_ICLIKEJOINSEL 1816
#define F_ICNLIKEJOINSEL 1817
#define F_REGEXEQSEL 1818
#define F_LIKESEL 1819
#define F_ICREGEXEQSEL 1820
#define F_REGEXNESEL 1821
#define F_NLIKESEL 1822
#define F_ICREGEXNESEL 1823
#define F_REGEXEQJOINSEL 1824
#define F_LIKEJOINSEL 1825
#define F_ICREGEXEQJOINSEL 1826
#define F_REGEXNEJOINSEL 1827
#define F_NLIKEJOINSEL 1828
#define F_ICREGEXNEJOINSEL 1829
#define F_FLOAT8_AVG 1830
#define F_FLOAT8_VAR_SAMP 1831
#define F_FLOAT8_STDDEV_SAMP 1832
#define F_NUMERIC_ACCUM 1833
#define F_INT2_ACCUM 1834
#define F_INT4_ACCUM 1835
#define F_INT8_ACCUM 1836
#define F_NUMERIC_AVG 1837
#define F_NUMERIC_VAR_SAMP 1838
#define F_NUMERIC_STDDEV_SAMP 1839
#define F_INT2_SUM 1840
#define F_INT4_SUM 1841
#define F_INT8_SUM 1842
#define F_INTERVAL_ACCUM 1843
#define F_INTERVAL_AVG 1844
#define F_TO_ASCII_DEFAULT 1845
#define F_TO_ASCII_ENC 1846
#define F_TO_ASCII_ENCNAME 1847
#define F_INT28EQ 1850
#define F_INT28NE 1851
#define F_INT28LT 1852
#define F_INT28GT 1853
#define F_INT28LE 1854
#define F_INT28GE 1855
#define F_INT82EQ 1856
#define F_INT82NE 1857
#define F_INT82LT 1858
#define F_INT82GT 1859
#define F_INT82LE 1860
#define F_INT82GE 1861
#define F_INT2AND 1892
#define F_INT2OR 1893
#define F_INT2XOR 1894
#define F_INT2NOT 1895
#define F_INT2SHL 1896
#define F_INT2SHR 1897
#define F_INT4AND 1898
#define F_INT4OR 1899
#define F_INT4XOR 1900
#define F_INT4NOT 1901
#define F_INT4SHL 1902
#define F_INT4SHR 1903
#define F_INT8AND 1904
#define F_INT8OR 1905
#define F_INT8XOR 1906
#define F_INT8NOT 1907
#define F_INT8SHL 1908
#define F_INT8SHR 1909
#define F_INT8UP 1910
#define F_INT2UP 1911
#define F_INT4UP 1912
#define F_FLOAT4UP 1913
#define F_FLOAT8UP 1914
#define F_NUMERIC_UPLUS 1915
#define F_HAS_TABLE_PRIVILEGE_NAME_NAME 1922
#define F_HAS_TABLE_PRIVILEGE_NAME_ID 1923
#define F_HAS_TABLE_PRIVILEGE_ID_NAME 1924
#define F_HAS_TABLE_PRIVILEGE_ID_ID 1925
#define F_HAS_TABLE_PRIVILEGE_NAME 1926
#define F_HAS_TABLE_PRIVILEGE_ID 1927
#define F_PG_STAT_GET_NUMSCANS 1928
#define F_PG_STAT_GET_TUPLES_RETURNED 1929
#define F_PG_STAT_GET_TUPLES_FETCHED 1930
#define F_PG_STAT_GET_TUPLES_INSERTED 1931
#define F_PG_STAT_GET_TUPLES_UPDATED 1932
#define F_PG_STAT_GET_TUPLES_DELETED 1933
#define F_PG_STAT_GET_BLOCKS_FETCHED 1934
#define F_PG_STAT_GET_BLOCKS_HIT 1935
#define F_PG_STAT_GET_BACKEND_IDSET 1936
#define F_PG_STAT_GET_BACKEND_PID 1937
#define F_PG_STAT_GET_BACKEND_DBID 1938
#define F_PG_STAT_GET_BACKEND_USERID 1939
#define F_PG_STAT_GET_BACKEND_ACTIVITY 1940
#define F_PG_STAT_GET_DB_NUMBACKENDS 1941
#define F_PG_STAT_GET_DB_XACT_COMMIT 1942
#define F_PG_STAT_GET_DB_XACT_ROLLBACK 1943
#define F_PG_STAT_GET_DB_BLOCKS_FETCHED 1944
#define F_PG_STAT_GET_DB_BLOCKS_HIT 1945
#define F_BINARY_ENCODE 1946
#define F_BINARY_DECODE 1947
#define F_BYTEAEQ 1948
#define F_BYTEALT 1949
#define F_BYTEALE 1950
#define F_BYTEAGT 1951
#define F_BYTEAGE 1952
#define F_BYTEANE 1953
#define F_BYTEACMP 1954
#define F_TIMESTAMP_SCALE 1961
#define F_INT2_AVG_ACCUM 1962
#define F_INT4_AVG_ACCUM 1963
#define F_INT8_AVG 1964
#define F_OIDLARGER 1965
#define F_OIDSMALLER 1966
#define F_TIMESTAMPTZ_SCALE 1967
#define F_TIME_SCALE 1968
#define F_TIMETZ_SCALE 1969
#define F_PG_STAT_GET_TUPLES_HOT_UPDATED 1972
#define F_BYTEALIKE 2005
#define F_BYTEANLIKE 2006
#define F_LIKE_ESCAPE_BYTEA 2009
#define F_BYTEACAT 2011
#define F_BYTEA_SUBSTR 2012
#define F_BYTEA_SUBSTR_NO_LEN 2013
#define F_BYTEAPOS 2014
#define F_BYTEATRIM 2015
#define F_TIMESTAMPTZ_TIME 2019
#define F_TIMESTAMP_TRUNC 2020
#define F_TIMESTAMP_PART 2021
#define F_ABSTIME_TIMESTAMP 2023
#define F_DATE_TIMESTAMP 2024
#define F_PG_BACKEND_PID 2026
#define F_TIMESTAMPTZ_TIMESTAMP 2027
#define F_TIMESTAMP_TIMESTAMPTZ 2028
#define F_TIMESTAMP_DATE 2029
#define F_TIMESTAMP_ABSTIME 2030
#define F_TIMESTAMP_PL_INTERVAL 2032
#define F_TIMESTAMP_MI_INTERVAL 2033
#define F_TIMETZ_ZONE 2037
#define F_TIMETZ_IZONE 2038
#define F_TIMESTAMP_HASH 2039
#define F_TIMETZ_TIME 2046
#define F_TIME_TIMETZ 2047
#define F_TIMESTAMP_TO_CHAR 2049
#define F_AGGREGATE_DUMMY 2050
#define F_TIMESTAMP_AGE 2058
#define F_TIMESTAMP_ZONE 2069
#define F_TIMESTAMP_IZONE 2070
#define F_DATE_PL_INTERVAL 2071
#define F_DATE_MI_INTERVAL 2072
#define F_TEXTREGEXSUBSTR 2073
#define F_BITFROMINT8 2075
#define F_BITTOINT8 2076
#define F_SHOW_CONFIG_BY_NAME 2077
#define F_SET_CONFIG_BY_NAME 2078
#define F_PG_TABLE_IS_VISIBLE 2079
#define F_PG_TYPE_IS_VISIBLE 2080
#define F_PG_FUNCTION_IS_VISIBLE 2081
#define F_PG_OPERATOR_IS_VISIBLE 2082
#define F_PG_OPCLASS_IS_VISIBLE 2083
#define F_SHOW_ALL_SETTINGS 2084
#define F_REPLACE_TEXT 2087
#define F_SPLIT_TEXT 2088
#define F_TO_HEX32 2089
#define F_TO_HEX64 2090
#define F_ARRAY_LOWER 2091
#define F_ARRAY_UPPER 2092
#define F_PG_CONVERSION_IS_VISIBLE 2093
#define F_PG_STAT_GET_BACKEND_ACTIVITY_START 2094
#define F_TEXT_PATTERN_LT 2160
#define F_TEXT_PATTERN_LE 2161
#define F_TEXT_PATTERN_EQ 2162
#define F_TEXT_PATTERN_GE 2163
#define F_TEXT_PATTERN_GT 2164
#define F_TEXT_PATTERN_NE 2165
#define F_BTTEXT_PATTERN_CMP 2166
#define F_PG_DATABASE_SIZE_NAME 2168
#define F_WIDTH_BUCKET_NUMERIC 2170
#define F_PG_CANCEL_BACKEND 2171
#define F_PG_START_BACKUP 2172
#define F_PG_STOP_BACKUP 2173
#define F_NAME_PATTERN_LT 2181
#define F_NAME_PATTERN_LE 2182
#define F_NAME_PATTERN_EQ 2183
#define F_NAME_PATTERN_GE 2184
#define F_NAME_PATTERN_GT 2185
#define F_NAME_PATTERN_NE 2186
#define F_BTNAME_PATTERN_CMP 2187
#define F_BTINT48CMP 2188
#define F_BTINT84CMP 2189
#define F_BTINT24CMP 2190
#define F_BTINT42CMP 2191
#define F_BTINT28CMP 2192
#define F_BTINT82CMP 2193
#define F_BTFLOAT48CMP 2194
#define F_BTFLOAT84CMP 2195
#define F_INET_CLIENT_ADDR 2196
#define F_INET_CLIENT_PORT 2197
#define F_INET_SERVER_ADDR 2198
#define F_INET_SERVER_PORT 2199
#define F_REGPROCEDUREIN 2212
#define F_REGPROCEDUREOUT 2213
#define F_REGOPERIN 2214
#define F_REGOPEROUT 2215
#define F_REGOPERATORIN 2216
#define F_REGOPERATOROUT 2217
#define F_REGCLASSIN 2218
#define F_REGCLASSOUT 2219
#define F_REGTYPEIN 2220
#define F_REGTYPEOUT 2221
#define F_PG_STAT_CLEAR_SNAPSHOT 2230
#define F_FMGR_INTERNAL_VALIDATOR 2246
#define F_FMGR_C_VALIDATOR 2247
#define F_FMGR_SQL_VALIDATOR 2248
#define F_HAS_DATABASE_PRIVILEGE_NAME_NAME 2250
#define F_HAS_DATABASE_PRIVILEGE_NAME_ID 2251
#define F_HAS_DATABASE_PRIVILEGE_ID_NAME 2252
#define F_HAS_DATABASE_PRIVILEGE_ID_ID 2253
#define F_HAS_DATABASE_PRIVILEGE_NAME 2254
#define F_HAS_DATABASE_PRIVILEGE_ID 2255
#define F_HAS_FUNCTION_PRIVILEGE_NAME_NAME 2256
#define F_HAS_FUNCTION_PRIVILEGE_NAME_ID 2257
#define F_HAS_FUNCTION_PRIVILEGE_ID_NAME 2258
#define F_HAS_FUNCTION_PRIVILEGE_ID_ID 2259
#define F_HAS_FUNCTION_PRIVILEGE_NAME 2260
#define F_HAS_FUNCTION_PRIVILEGE_ID 2261
#define F_HAS_LANGUAGE_PRIVILEGE_NAME_NAME 2262
#define F_HAS_LANGUAGE_PRIVILEGE_NAME_ID 2263
#define F_HAS_LANGUAGE_PRIVILEGE_ID_NAME 2264
#define F_HAS_LANGUAGE_PRIVILEGE_ID_ID 2265
#define F_HAS_LANGUAGE_PRIVILEGE_NAME 2266
#define F_HAS_LANGUAGE_PRIVILEGE_ID 2267
#define F_HAS_SCHEMA_PRIVILEGE_NAME_NAME 2268
#define F_HAS_SCHEMA_PRIVILEGE_NAME_ID 2269
#define F_HAS_SCHEMA_PRIVILEGE_ID_NAME 2270
#define F_HAS_SCHEMA_PRIVILEGE_ID_ID 2271
#define F_HAS_SCHEMA_PRIVILEGE_NAME 2272
#define F_HAS_SCHEMA_PRIVILEGE_ID 2273
#define F_PG_STAT_RESET 2274
#define F_TEXTREGEXREPLACE_NOOPT 2284
#define F_TEXTREGEXREPLACE 2285
#define F_PG_TOTAL_RELATION_SIZE_OID 2286
#define F_PG_TOTAL_RELATION_SIZE_NAME 2287
#define F_PG_SIZE_PRETTY 2288
#define F_PG_RELATION_SIZE_NAME 2289
#define F_RECORD_IN 2290
#define F_RECORD_OUT 2291
#define F_CSTRING_IN 2292
#define F_CSTRING_OUT 2293
#define F_ANY_IN 2294
#define F_ANY_OUT 2295
#define F_ANYARRAY_IN 2296
#define F_ANYARRAY_OUT 2297
#define F_VOID_IN 2298
#define F_VOID_OUT 2299
#define F_TRIGGER_IN 2300
#define F_TRIGGER_OUT 2301
#define F_LANGUAGE_HANDLER_IN 2302
#define F_LANGUAGE_HANDLER_OUT 2303
#define F_INTERNAL_IN 2304
#define F_INTERNAL_OUT 2305
#define F_OPAQUE_IN 2306
#define F_OPAQUE_OUT 2307
#define F_DCEIL 2308
#define F_DFLOOR 2309
#define F_DSIGN 2310
#define F_MD5_TEXT 2311
#define F_ANYELEMENT_IN 2312
#define F_ANYELEMENT_OUT 2313
#define F_MD5_BYTEA 2321
#define F_PG_TABLESPACE_SIZE_OID 2322
#define F_PG_TABLESPACE_SIZE_NAME 2323
#define F_PG_DATABASE_SIZE_OID 2324
#define F_PG_RELATION_SIZE_OID 2325
#define F_DATE_LT_TIMESTAMP 2338
#define F_DATE_LE_TIMESTAMP 2339
#define F_DATE_EQ_TIMESTAMP 2340
#define F_DATE_GT_TIMESTAMP 2341
#define F_DATE_GE_TIMESTAMP 2342
#define F_DATE_NE_TIMESTAMP 2343
#define F_DATE_CMP_TIMESTAMP 2344
#define F_DATE_LT_TIMESTAMPTZ 2351
#define F_DATE_LE_TIMESTAMPTZ 2352
#define F_DATE_EQ_TIMESTAMPTZ 2353
#define F_DATE_GT_TIMESTAMPTZ 2354
#define F_DATE_GE_TIMESTAMPTZ 2355
#define F_DATE_NE_TIMESTAMPTZ 2356
#define F_DATE_CMP_TIMESTAMPTZ 2357
#define F_TIMESTAMP_LT_DATE 2364
#define F_TIMESTAMP_LE_DATE 2365
#define F_TIMESTAMP_EQ_DATE 2366
#define F_TIMESTAMP_GT_DATE 2367
#define F_TIMESTAMP_GE_DATE 2368
#define F_TIMESTAMP_NE_DATE 2369
#define F_TIMESTAMP_CMP_DATE 2370
#define F_TIMESTAMPTZ_LT_DATE 2377
#define F_TIMESTAMPTZ_LE_DATE 2378
#define F_TIMESTAMPTZ_EQ_DATE 2379
#define F_TIMESTAMPTZ_GT_DATE 2380
#define F_TIMESTAMPTZ_GE_DATE 2381
#define F_TIMESTAMPTZ_NE_DATE 2382
#define F_TIMESTAMPTZ_CMP_DATE 2383
#define F_HAS_TABLESPACE_PRIVILEGE_NAME_NAME 2390
#define F_HAS_TABLESPACE_PRIVILEGE_NAME_ID 2391
#define F_HAS_TABLESPACE_PRIVILEGE_ID_NAME 2392
#define F_HAS_TABLESPACE_PRIVILEGE_ID_ID 2393
#define F_HAS_TABLESPACE_PRIVILEGE_NAME 2394
#define F_HAS_TABLESPACE_PRIVILEGE_ID 2395
#define F_SHELL_IN 2398
#define F_SHELL_OUT 2399
#define F_ARRAY_RECV 2400
#define F_ARRAY_SEND 2401
#define F_RECORD_RECV 2402
#define F_RECORD_SEND 2403
#define F_INT2RECV 2404
#define F_INT2SEND 2405
#define F_INT4RECV 2406
#define F_INT4SEND 2407
#define F_INT8RECV 2408
#define F_INT8SEND 2409
#define F_INT2VECTORRECV 2410
#define F_INT2VECTORSEND 2411
#define F_BYTEARECV 2412
#define F_BYTEASEND 2413
#define F_TEXTRECV 2414
#define F_TEXTSEND 2415
#define F_UNKNOWNRECV 2416
#define F_UNKNOWNSEND 2417
#define F_OIDRECV 2418
#define F_OIDSEND 2419
#define F_OIDVECTORRECV 2420
#define F_OIDVECTORSEND 2421
#define F_NAMERECV 2422
#define F_NAMESEND 2423
#define F_FLOAT4RECV 2424
#define F_FLOAT4SEND 2425
#define F_FLOAT8RECV 2426
#define F_FLOAT8SEND 2427
#define F_POINT_RECV 2428
#define F_POINT_SEND 2429
#define F_BPCHARRECV 2430
#define F_BPCHARSEND 2431
#define F_VARCHARRECV 2432
#define F_VARCHARSEND 2433
#define F_CHARRECV 2434
#define F_CHARSEND 2435
#define F_BOOLRECV 2436
#define F_BOOLSEND 2437
#define F_TIDRECV 2438
#define F_TIDSEND 2439
#define F_XIDRECV 2440
#define F_XIDSEND 2441
#define F_CIDRECV 2442
#define F_CIDSEND 2443
#define F_REGPROCRECV 2444
#define F_REGPROCSEND 2445
#define F_REGPROCEDURERECV 2446
#define F_REGPROCEDURESEND 2447
#define F_REGOPERRECV 2448
#define F_REGOPERSEND 2449
#define F_REGOPERATORRECV 2450
#define F_REGOPERATORSEND 2451
#define F_REGCLASSRECV 2452
#define F_REGCLASSSEND 2453
#define F_REGTYPERECV 2454
#define F_REGTYPESEND 2455
#define F_BIT_RECV 2456
#define F_BIT_SEND 2457
#define F_VARBIT_RECV 2458
#define F_VARBIT_SEND 2459
#define F_NUMERIC_RECV 2460
#define F_NUMERIC_SEND 2461
#define F_ABSTIMERECV 2462
#define F_ABSTIMESEND 2463
#define F_RELTIMERECV 2464
#define F_RELTIMESEND 2465
#define F_TINTERVALRECV 2466
#define F_TINTERVALSEND 2467
#define F_DATE_RECV 2468
#define F_DATE_SEND 2469
#define F_TIME_RECV 2470
#define F_TIME_SEND 2471
#define F_TIMETZ_RECV 2472
#define F_TIMETZ_SEND 2473
#define F_TIMESTAMP_RECV 2474
#define F_TIMESTAMP_SEND 2475
#define F_TIMESTAMPTZ_RECV 2476
#define F_TIMESTAMPTZ_SEND 2477
#define F_INTERVAL_RECV 2478
#define F_INTERVAL_SEND 2479
#define F_LSEG_RECV 2480
#define F_LSEG_SEND 2481
#define F_PATH_RECV 2482
#define F_PATH_SEND 2483
#define F_BOX_RECV 2484
#define F_BOX_SEND 2485
#define F_POLY_RECV 2486
#define F_POLY_SEND 2487
#define F_LINE_RECV 2488
#define F_LINE_SEND 2489
#define F_CIRCLE_RECV 2490
#define F_CIRCLE_SEND 2491
#define F_CASH_RECV 2492
#define F_CASH_SEND 2493
#define F_MACADDR_RECV 2494
#define F_MACADDR_SEND 2495
#define F_INET_RECV 2496
#define F_INET_SEND 2497
#define F_CIDR_RECV 2498
#define F_CIDR_SEND 2499
#define F_CSTRING_RECV 2500
#define F_CSTRING_SEND 2501
#define F_ANYARRAY_RECV 2502
#define F_ANYARRAY_SEND 2503
#define F_PG_GET_RULEDEF_EXT 2504
#define F_PG_GET_VIEWDEF_NAME_EXT 2505
#define F_PG_GET_VIEWDEF_EXT 2506
#define F_PG_GET_INDEXDEF_EXT 2507
#define F_PG_GET_CONSTRAINTDEF_EXT 2508
#define F_PG_GET_EXPR_EXT 2509
#define F_PG_PREPARED_STATEMENT 2510
#define F_PG_CURSOR 2511
#define F_FLOAT8_VAR_POP 2512
#define F_FLOAT8_STDDEV_POP 2513
#define F_NUMERIC_VAR_POP 2514
#define F_BOOLAND_STATEFUNC 2515
#define F_BOOLOR_STATEFUNC 2516
#define F_TIMESTAMP_LT_TIMESTAMPTZ 2520
#define F_TIMESTAMP_LE_TIMESTAMPTZ 2521
#define F_TIMESTAMP_EQ_TIMESTAMPTZ 2522
#define F_TIMESTAMP_GT_TIMESTAMPTZ 2523
#define F_TIMESTAMP_GE_TIMESTAMPTZ 2524
#define F_TIMESTAMP_NE_TIMESTAMPTZ 2525
#define F_TIMESTAMP_CMP_TIMESTAMPTZ 2526
#define F_TIMESTAMPTZ_LT_TIMESTAMP 2527
#define F_TIMESTAMPTZ_LE_TIMESTAMP 2528
#define F_TIMESTAMPTZ_EQ_TIMESTAMP 2529
#define F_TIMESTAMPTZ_GT_TIMESTAMP 2530
#define F_TIMESTAMPTZ_GE_TIMESTAMP 2531
#define F_TIMESTAMPTZ_NE_TIMESTAMP 2532
#define F_TIMESTAMPTZ_CMP_TIMESTAMP 2533
#define F_PG_TABLESPACE_DATABASES 2556
#define F_INT4_BOOL 2557
#define F_BOOL_INT4 2558
#define F_LASTVAL 2559
#define F_PGSQL_POSTMASTER_START_TIME 2560
#define F_GISTVACUUMCLEANUP 2561
#define F_BOX_BELOW 2562
#define F_BOX_OVERBELOW 2563
#define F_BOX_OVERABOVE 2564
#define F_BOX_ABOVE 2565
#define F_POLY_BELOW 2566
#define F_POLY_OVERBELOW 2567
#define F_POLY_OVERABOVE 2568
#define F_POLY_ABOVE 2569
#define F_GIST_BOX_CONSISTENT 2578
#define F_GIST_BOX_COMPRESS 2579
#define F_GIST_BOX_DECOMPRESS 2580
#define F_GIST_BOX_PENALTY 2581
#define F_GIST_BOX_PICKSPLIT 2582
#define F_GIST_BOX_UNION 2583
#define F_GIST_BOX_SAME 2584
#define F_GIST_POLY_CONSISTENT 2585
#define F_GIST_POLY_COMPRESS 2586
#define F_CIRCLE_OVERBELOW 2587
#define F_CIRCLE_OVERABOVE 2588
#define F_GIST_CIRCLE_CONSISTENT 2591
#define F_GIST_CIRCLE_COMPRESS 2592
#define F_NUMERIC_STDDEV_POP 2596
#define F_DOMAIN_IN 2597
#define F_DOMAIN_RECV 2598
#define F_PG_TIMEZONE_ABBREVS 2599
#define F_PG_RELOAD_CONF 2621
#define F_PG_ROTATE_LOGFILE 2622
#define F_PG_STAT_FILE 2623
#define F_PG_READ_FILE 2624
#define F_PG_LS_DIR 2625
#define F_PG_SLEEP 2626
#define F_INETNOT 2627
#define F_INETAND 2628
#define F_INETOR 2629
#define F_INETPL 2630
#define F_INETMI_INT8 2632
#define F_INETMI 2633
#define F_STATEMENT_TIMESTAMP 2648
#define F_CLOCK_TIMESTAMP 2649
#define F_PG_HAS_ROLE_NAME_NAME 2705
#define F_PG_HAS_ROLE_NAME_ID 2706
#define F_PG_HAS_ROLE_ID_NAME 2707
#define F_PG_HAS_ROLE_ID_ID 2708
#define F_PG_HAS_ROLE_NAME 2709
#define F_PG_HAS_ROLE_ID 2710
#define F_INTERVAL_JUSTIFY_INTERVAL 2711
#define F_GINGETTUPLE 2730
#define F_GINGETMULTI 2731
#define F_GININSERT 2732
#define F_GINBEGINSCAN 2733
#define F_GINRESCAN 2734
#define F_GINENDSCAN 2735
#define F_GINMARKPOS 2736
#define F_GINRESTRPOS 2737
#define F_GINBUILD 2738
#define F_GINBULKDELETE 2739
#define F_GINVACUUMCLEANUP 2740
#define F_GINCOSTESTIMATE 2741
#define F_GINARRAYEXTRACT 2743
#define F_GINARRAYCONSISTENT 2744
#define F_INT8_AVG_ACCUM 2746
#define F_ARRAYOVERLAP 2747
#define F_ARRAYCONTAINS 2748
#define F_ARRAYCONTAINED 2749
#define F_PG_STAT_GET_DB_TUPLES_RETURNED 2758
#define F_PG_STAT_GET_DB_TUPLES_FETCHED 2759
#define F_PG_STAT_GET_DB_TUPLES_INSERTED 2760
#define F_PG_STAT_GET_DB_TUPLES_UPDATED 2761
#define F_PG_STAT_GET_DB_TUPLES_DELETED 2762
#define F_REGEXP_MATCHES_NO_FLAGS 2763
#define F_REGEXP_MATCHES 2764
#define F_REGEXP_SPLIT_TO_TABLE_NO_FLAGS 2765
#define F_REGEXP_SPLIT_TO_TABLE 2766
#define F_REGEXP_SPLIT_TO_ARRAY_NO_FLAGS 2767
#define F_REGEXP_SPLIT_TO_ARRAY 2768
#define F_PG_STAT_GET_BGWRITER_TIMED_CHECKPOINTS 2769
#define F_PG_STAT_GET_BGWRITER_REQUESTED_CHECKPOINTS 2770
#define F_PG_STAT_GET_BGWRITER_BUF_WRITTEN_CHECKPOINTS 2771
#define F_PG_STAT_GET_BGWRITER_BUF_WRITTEN_CLEAN 2772
#define F_PG_STAT_GET_BGWRITER_MAXWRITTEN_CLEAN 2773
#define F_GINQUERYARRAYEXTRACT 2774
#define F_PG_STAT_GET_BUF_WRITTEN_BACKEND 2775
#define F_ANYNONARRAY_IN 2777
#define F_ANYNONARRAY_OUT 2778
#define F_PG_STAT_GET_LAST_VACUUM_TIME 2781
#define F_PG_STAT_GET_LAST_AUTOVACUUM_TIME 2782
#define F_PG_STAT_GET_LAST_ANALYZE_TIME 2783
#define F_PG_STAT_GET_LAST_AUTOANALYZE_TIME 2784
#define F_BTOPTIONS 2785
#define F_HASHOPTIONS 2786
#define F_GISTOPTIONS 2787
#define F_GINOPTIONS 2788
#define F_TIDGT 2790
#define F_TIDLT 2791
#define F_TIDGE 2792
#define F_TIDLE 2793
#define F_BTTIDCMP 2794
#define F_TIDLARGER 2795
#define F_TIDSMALLER 2796
#define F_INT8INC_ANY 2804
#define F_INT8INC_FLOAT8_FLOAT8 2805
#define F_FLOAT8_REGR_ACCUM 2806
#define F_FLOAT8_REGR_SXX 2807
#define F_FLOAT8_REGR_SYY 2808
#define F_FLOAT8_REGR_SXY 2809
#define F_FLOAT8_REGR_AVGX 2810
#define F_FLOAT8_REGR_AVGY 2811
#define F_FLOAT8_REGR_R2 2812
#define F_FLOAT8_REGR_SLOPE 2813
#define F_FLOAT8_REGR_INTERCEPT 2814
#define F_FLOAT8_COVAR_POP 2815
#define F_FLOAT8_COVAR_SAMP 2816
#define F_FLOAT8_CORR 2817
#define F_PG_SWITCH_XLOG 2848
#define F_PG_CURRENT_XLOG_LOCATION 2849
#define F_PG_XLOGFILE_NAME_OFFSET 2850
#define F_PG_XLOGFILE_NAME 2851
#define F_PG_CURRENT_XLOG_INSERT_LOCATION 2852
#define F_PG_STAT_GET_BACKEND_WAITING 2853
#define F_PG_MY_TEMP_SCHEMA 2854
#define F_PG_IS_OTHER_TEMP_SCHEMA 2855
#define F_PG_TIMEZONE_NAMES 2856
#define F_PG_STAT_GET_BACKEND_XACT_START 2857
#define F_NUMERIC_AVG_ACCUM 2858
#define F_PG_STAT_GET_BUF_ALLOC 2859
#define F_PG_STAT_GET_LIVE_TUPLES 2878
#define F_PG_STAT_GET_DEAD_TUPLES 2879
#define F_PG_ADVISORY_LOCK_INT8 2880
#define F_PG_ADVISORY_LOCK_SHARED_INT8 2881
#define F_PG_TRY_ADVISORY_LOCK_INT8 2882
#define F_PG_TRY_ADVISORY_LOCK_SHARED_INT8 2883
#define F_PG_ADVISORY_UNLOCK_INT8 2884
#define F_PG_ADVISORY_UNLOCK_SHARED_INT8 2885
#define F_PG_ADVISORY_LOCK_INT4 2886
#define F_PG_ADVISORY_LOCK_SHARED_INT4 2887
#define F_PG_TRY_ADVISORY_LOCK_INT4 2888
#define F_PG_TRY_ADVISORY_LOCK_SHARED_INT4 2889
#define F_PG_ADVISORY_UNLOCK_INT4 2890
#define F_PG_ADVISORY_UNLOCK_SHARED_INT4 2891
#define F_PG_ADVISORY_UNLOCK_ALL 2892
#define F_XML_IN 2893
#define F_XML_OUT 2894
#define F_XMLCOMMENT 2895
#define F_TEXTTOXML 2896
#define F_XMLVALIDATE 2897
#define F_XML_RECV 2898
#define F_XML_SEND 2899
#define F_XMLCONCAT2 2900
#define F_VARBITTYPMODIN 2902
#define F_INTERVALTYPMODIN 2903
#define F_INTERVALTYPMODOUT 2904
#define F_TIMESTAMPTYPMODIN 2905
#define F_TIMESTAMPTYPMODOUT 2906
#define F_TIMESTAMPTZTYPMODIN 2907
#define F_TIMESTAMPTZTYPMODOUT 2908
#define F_TIMETYPMODIN 2909
#define F_TIMETYPMODOUT 2910
#define F_TIMETZTYPMODIN 2911
#define F_TIMETZTYPMODOUT 2912
#define F_BPCHARTYPMODIN 2913
#define F_BPCHARTYPMODOUT 2914
#define F_VARCHARTYPMODIN 2915
#define F_VARCHARTYPMODOUT 2916
#define F_NUMERICTYPMODIN 2917
#define F_NUMERICTYPMODOUT 2918
#define F_BITTYPMODIN 2919
#define F_BITTYPMODOUT 2920
#define F_VARBITTYPMODOUT 2921
#define F_XMLTOTEXT 2922
#define F_TABLE_TO_XML 2923
#define F_QUERY_TO_XML 2924
#define F_CURSOR_TO_XML 2925
#define F_TABLE_TO_XMLSCHEMA 2926
#define F_QUERY_TO_XMLSCHEMA 2927
#define F_CURSOR_TO_XMLSCHEMA 2928
#define F_TABLE_TO_XML_AND_XMLSCHEMA 2929
#define F_QUERY_TO_XML_AND_XMLSCHEMA 2930
#define F_XPATH 2931
#define F_SCHEMA_TO_XML 2933
#define F_SCHEMA_TO_XMLSCHEMA 2934
#define F_SCHEMA_TO_XML_AND_XMLSCHEMA 2935
#define F_DATABASE_TO_XML 2936
#define F_DATABASE_TO_XMLSCHEMA 2937
#define F_DATABASE_TO_XML_AND_XMLSCHEMA 2938
#define F_TXID_SNAPSHOT_IN 2939
#define F_TXID_SNAPSHOT_OUT 2940
#define F_TXID_SNAPSHOT_RECV 2941
#define F_TXID_SNAPSHOT_SEND 2942
#define F_TXID_CURRENT 2943
#define F_TXID_CURRENT_SNAPSHOT 2944
#define F_TXID_SNAPSHOT_XMIN 2945
#define F_TXID_SNAPSHOT_XMAX 2946
#define F_TXID_SNAPSHOT_XIP 2947
#define F_TXID_VISIBLE_IN_SNAPSHOT 2948
#define F_UUID_IN 2952
#define F_UUID_OUT 2953
#define F_UUID_LT 2954
#define F_UUID_LE 2955
#define F_UUID_EQ 2956
#define F_UUID_GE 2957
#define F_UUID_GT 2958
#define F_UUID_NE 2959
#define F_UUID_CMP 2960
#define F_UUID_RECV 2961
#define F_UUID_SEND 2962
#define F_UUID_HASH 2963
#define F_BOOLTEXT 2971
#define F_ANYENUM_IN 3504
#define F_ANYENUM_OUT 3505
#define F_ENUM_IN 3506
#define F_ENUM_OUT 3507
#define F_ENUM_EQ 3508
#define F_ENUM_NE 3509
#define F_ENUM_LT 3510
#define F_ENUM_GT 3511
#define F_ENUM_LE 3512
#define F_ENUM_GE 3513
#define F_ENUM_CMP 3514
#define F_HASHENUM 3515
#define F_ENUM_SMALLER 3524
#define F_ENUM_LARGER 3525
#define F_ENUM_FIRST 3528
#define F_ENUM_LAST 3529
#define F_ENUM_RANGE_BOUNDS 3530
#define F_ENUM_RANGE_ALL 3531
#define F_ENUM_RECV 3532
#define F_ENUM_SEND 3533
#define F_TSVECTORIN 3610
#define F_TSVECTOROUT 3611
#define F_TSQUERYIN 3612
#define F_TSQUERYOUT 3613
#define F_TSVECTOR_LT 3616
#define F_TSVECTOR_LE 3617
#define F_TSVECTOR_EQ 3618
#define F_TSVECTOR_NE 3619
#define F_TSVECTOR_GE 3620
#define F_TSVECTOR_GT 3621
#define F_TSVECTOR_CMP 3622
#define F_TSVECTOR_STRIP 3623
#define F_TSVECTOR_SETWEIGHT 3624
#define F_TSVECTOR_CONCAT 3625
#define F_TS_MATCH_VQ 3634
#define F_TS_MATCH_QV 3635
#define F_TSVECTORSEND 3638
#define F_TSVECTORRECV 3639
#define F_TSQUERYSEND 3640
#define F_TSQUERYRECV 3641
#define F_GTSVECTORIN 3646
#define F_GTSVECTOROUT 3647
#define F_GTSVECTOR_COMPRESS 3648
#define F_GTSVECTOR_DECOMPRESS 3649
#define F_GTSVECTOR_PICKSPLIT 3650
#define F_GTSVECTOR_UNION 3651
#define F_GTSVECTOR_SAME 3652
#define F_GTSVECTOR_PENALTY 3653
#define F_GTSVECTOR_CONSISTENT 3654
#define F_GIN_EXTRACT_TSVECTOR 3656
#define F_GIN_EXTRACT_TSQUERY 3657
#define F_GIN_TSQUERY_CONSISTENT 3658
#define F_TSQUERY_LT 3662
#define F_TSQUERY_LE 3663
#define F_TSQUERY_EQ 3664
#define F_TSQUERY_NE 3665
#define F_TSQUERY_GE 3666
#define F_TSQUERY_GT 3667
#define F_TSQUERY_CMP 3668
#define F_TSQUERY_AND 3669
#define F_TSQUERY_OR 3670
#define F_TSQUERY_NOT 3671
#define F_TSQUERY_NUMNODE 3672
#define F_TSQUERYTREE 3673
#define F_TSQUERY_REWRITE 3684
#define F_TSQUERY_REWRITE_QUERY 3685
#define F_TS_STAT1 3689
#define F_TS_STAT2 3690
#define F_TSQ_MCONTAINS 3691
#define F_TSQ_MCONTAINED 3692
#define F_GTSQUERY_COMPRESS 3695
#define F_GTSQUERY_DECOMPRESS 3696
#define F_GTSQUERY_PICKSPLIT 3697
#define F_GTSQUERY_UNION 3698
#define F_GTSQUERY_SAME 3699
#define F_GTSQUERY_PENALTY 3700
#define F_GTSQUERY_CONSISTENT 3701
#define F_TS_RANK_WTTF 3703
#define F_TS_RANK_WTT 3704
#define F_TS_RANK_TTF 3705
#define F_TS_RANK_TT 3706
#define F_TS_RANKCD_WTTF 3707
#define F_TS_RANKCD_WTT 3708
#define F_TS_RANKCD_TTF 3709
#define F_TS_RANKCD_TT 3710
#define F_TSVECTOR_LENGTH 3711
#define F_TS_TOKEN_TYPE_BYID 3713
#define F_TS_TOKEN_TYPE_BYNAME 3714
#define F_TS_PARSE_BYID 3715
#define F_TS_PARSE_BYNAME 3716
#define F_PRSD_START 3717
#define F_PRSD_NEXTTOKEN 3718
#define F_PRSD_END 3719
#define F_PRSD_HEADLINE 3720
#define F_PRSD_LEXTYPE 3721
#define F_TS_LEXIZE 3723
#define F_DSIMPLE_INIT 3725
#define F_DSIMPLE_LEXIZE 3726
#define F_DSYNONYM_INIT 3728
#define F_DSYNONYM_LEXIZE 3729
#define F_DISPELL_INIT 3731
#define F_DISPELL_LEXIZE 3732
#define F_REGCONFIGIN 3736
#define F_REGCONFIGOUT 3737
#define F_REGCONFIGRECV 3738
#define F_REGCONFIGSEND 3739
#define F_THESAURUS_INIT 3740
#define F_THESAURUS_LEXIZE 3741
#define F_TS_HEADLINE_BYID_OPT 3743
#define F_TS_HEADLINE_BYID 3744
#define F_TO_TSVECTOR_BYID 3745
#define F_TO_TSQUERY_BYID 3746
#define F_PLAINTO_TSQUERY_BYID 3747
#define F_TO_TSVECTOR 3749
#define F_TO_TSQUERY 3750
#define F_PLAINTO_TSQUERY 3751
#define F_TSVECTOR_UPDATE_TRIGGER_BYID 3752
#define F_TSVECTOR_UPDATE_TRIGGER_BYCOLUMN 3753
#define F_TS_HEADLINE_OPT 3754
#define F_TS_HEADLINE 3755
#define F_PG_TS_PARSER_IS_VISIBLE 3756
#define F_PG_TS_DICT_IS_VISIBLE 3757
#define F_PG_TS_CONFIG_IS_VISIBLE 3758
#define F_GET_CURRENT_TS_CONFIG 3759
#define F_TS_MATCH_TT 3760
#define F_TS_MATCH_TQ 3761
#define F_PG_TS_TEMPLATE_IS_VISIBLE 3768
#define F_REGDICTIONARYIN 3771
#define F_REGDICTIONARYOUT 3772
#define F_REGDICTIONARYRECV 3773
#define F_REGDICTIONARYSEND 3774

#endif	/* FMGROIDS_H */
