/* $PostgreSQL: pgsql/contrib/intagg/int_aggregate.sql.in,v 1.9 2007/11/13 04:24:28 momjian Exp $ */

-- Adjust this setting to control where the objects get created.
SET search_path = public;

-- Internal function for the aggregate
-- Is called for each item in an aggregation
CREATE OR REPLACE FUNCTION int_agg_state (int4[], int4)
RETURNS int4[]
AS '$libdir/int_aggregate','int_agg_state'
LANGUAGE C;

-- Internal function for the aggregate
-- Is called at the end of the aggregation, and returns an array.
CREATE OR REPLACE FUNCTION int_agg_final_array (int4[])
RETURNS int4[]
AS '$libdir/int_aggregate','int_agg_final_array'
LANGUAGE C;

-- The aggregate function itself
-- uses the above functions to create an array of integers from an aggregation.
CREATE AGGREGATE int_array_aggregate (
	BASETYPE = int4,
	SFUNC = int_agg_state,
	STYPE = int4[],
	FINALFUNC = int_agg_final_array
);

-- The enumeration function
-- returns each element in a one dimensional integer array
-- as a row.
CREATE OR REPLACE FUNCTION int_array_enum(int4[])
RETURNS setof integer
AS '$libdir/int_aggregate','int_enum'
LANGUAGE C IMMUTABLE STRICT;
