/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* vsp_auth.sql */

static const char *proc0 = 
"#line 48 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"islwsp (in ch integer)\n"
"{\n"
"if (32 = ch or 8 = ch)\n"
"{\n"
"return (1);\n"
"}\n"
"else\n"
"{\n"
"return (0);\n"
"}\n"
"}\n"
"--src vsp_auth.sql:46\n"
;

static const char *proc1 = 
"#line 63 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"issep (in ch integer)\n"
"{\n"
"if (islwsp(ch) or 44 = ch or 10 = ch or 13 = ch)\n"
"{\n"
"return (1);\n"
"}\n"
"else\n"
"{\n"
"return (0);\n"
"}\n"
"}\n"
"--src vsp_auth.sql:61\n"
;

static const char *proc2 = 
"#line 78 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"skip_lwsp (in str varchar, in pos integer, in len integer)\n"
"{\n"
"declare inx integer;\n"
"\n"
"inx := pos;\n"
"\n"
"while (inx < len and islwsp (aref (str, inx)))\n"
"{\n"
"inx := inx + 1;\n"
"}\n"
"return (inx);\n"
"}\n"
"--src vsp_auth.sql:76\n"
;

static const char *proc3 = 
"#line 94 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"skip_sep (in str varchar, in pos integer, in len integer)\n"
"{\n"
"declare inx integer;\n"
"declare c integer;\n"
"\n"
"inx := pos;\n"
"\n"
"while (inx < len and issep (aref (str, inx)))\n"
"{\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"return (inx);\n"
"}\n"
"--src vsp_auth.sql:92\n"
;

static const char *proc4 = 
"#line 112 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"skip_quote (in str varchar, in pos integer, in len integer)\n"
"{\n"
"declare inx integer;\n"
"\n"
"inx := pos;\n"
"\n"
"while (inx < len and 34 <> aref (str, inx))\n"
"{\n"
"inx := inx + 1;\n"
"}\n"
"return (inx + 1);\n"
"}\n"
"--src vsp_auth.sql:110\n"
;

static const char *proc5 = 
"#line 136 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"vsp_auth_next_tok (in str varchar, inout pos integer, in len integer)\n"
"{\n"
"declare start, inx integer;\n"
"declare quote integer;\n"
"declare reading_val integer;\n"
"declare c integer;\n"
"\n"
"start := skip_sep (str, pos, len);\n"
"inx := start;\n"
"\n"
"reading_val := 0;\n"
"quote := 0;\n"
"\n"
"if (61 = aref (str, inx))\n"
"{\n"
"reading_val := 1;\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"while (inx < len)\n"
"{\n"
"c := aref (str, inx);\n"
"\n"
"\n"
"\n"
"if (34 = c)\n"
"{\n"
"if (quote)\n"
"{\n"
"pos := inx + 1;\n"
"return (vector (\'value\', subseq (str, start, inx)));\n"
"}\n"
"else\n"
"{\n"
"quote := 1;\n"
"start := inx + 1;\n"
"goto cont;\n"
"}\n"
"}\n"
"if (not quote)\n"
"{\n"
"\n"
"\n"
"if (61 = c)\n"
"{\n"
"pos := inx + 1;\n"
"return (vector (\'name\', subseq (str, start, inx)));\n"
"}\n"
"if (issep (c))\n"
"{\n"
"pos := inx + 1;\n"
"if (reading_val)\n"
"{\n"
"return (vector (\'value\', subseq (str, start, inx)));\n"
"}\n"
"else\n"
"{\n"
"return (vector (\'single\', subseq (str, start, inx)));\n"
"}\n"
"}\n"
"}\n"
"cont:\n"
"\n"
"inx := inx + 1;\n"
"}\n"
"return (null);\n"
"}\n"
"--src vsp_auth.sql:134\n"
;

static const char *proc6 = 
"#line 207 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"vsp_auth_vec_compose (in str varchar, in meth varchar)\n"
"{\n"
"\n"
"declare reading_name varchar;\n"
"declare cred, authtype, vec varchar;\n"
"declare i, start, pos, len integer;\n"
"\n"
"declare tok varchar;\n"
"\n"
"len := length (str);\n"
"pos := strcasestr (str, \'Authorization:\')+14;\n"
"\n"
"tok := vsp_auth_next_tok (str, pos, len);\n"
"\n"
"if (aref (tok, 0) <> \'single\')\n"
"return (null);\n"
"\n"
"authtype := aref(tok, 1);\n"
"\n"
"if (\'basic\' = lcase (authtype))\n"
"{\n"
"\n"
"declare start_pos integer;\n"
"pos := skip_sep (str, pos, len);\n"
"start_pos := pos;\n"
"while (0 = issep (aref (str, pos)))\n"
"{\n"
"pos := pos + 1;\n"
"}\n"
"tok := sprintf (\'%s\', decode_base64 (subseq (str, start_pos, pos)));\n"
"if (length (tok) < 2)\n"
"return (0);\n"
"i := strchr(tok, \':\');\n"
"return (vector (\'authtype\', \'basic\',\n"
"\'username\', \"LEFT\" (tok, i),\n"
"\'pass\', \"RIGHT\" (tok, length (tok) - 1 - i)));\n"
"}\n"
"\n"
"vec := make_array (26,\'any\');\n"
"\n"
"aset (vec, 0, \'method\');\n"
"aset (vec, 1, meth);\n"
"aset (vec, 2, \'authtype\');\n"
"aset (vec, 3, authtype);\n"
"\n"
"i := 4;\n"
"\n"
"while (1)\n"
"{\n"
"tok := vsp_auth_next_tok (str, pos, len);\n"
"\n"
"if (tok is null)\n"
"return (vec);\n"
"\n"
"\n"
"aset (vec, i, aref(tok, 1));\n"
"\n"
"i := i + 1;\n"
"}\n"
"}\n"
"--src vsp_auth.sql:205\n"
;

static const char *proc7 = 
"#line 272 \"[executable]/vsp_auth.sql\"\n"
" create procedure\n"
"vsp_auth_vec (in lines varchar)\n"
"{\n"
"\n"
"declare line varchar;\n"
"declare nlines integer;\n"
"declare inx integer;\n"
"declare pos, len integer;\n"
"declare meth varchar;\n"
"\n"
"inx := 0;\n"
"nlines := length (lines);\n"
"\n"
"\n"
"\n"
"\n"
"pos := 0;\n"
"len := length (aref (lines, 0));\n"
"meth := (aref (vsp_auth_next_tok (aref (lines, 0), pos, len), 1));\n"
"\n"
"while (inx < nlines)\n"
"{\n"
"line := aref (lines, inx);\n"
"\n"
"if (strcasestr (line, \'Authorization:\') is not null)\n"
"return (vsp_auth_vec_compose (line, meth));\n"
"inx := inx + 1;\n"
"}\n"
"return (0);\n"
"}\n"
"--src vsp_auth.sql:270\n"
;

static const char *proc8 = 
"#line 304 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"vsp_ua_skip_lwsp (inout str varchar)\n"
"{\n"
"return (subseq (str, skip_lwsp (str, 0, length (str)), length (str)));\n"
"}\n"
"--src vsp_auth.sql:302\n"
;

static const char *proc9 = 
"#line 312 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"vsp_ua_match_hdr (inout lines any, in match_str varchar)\n"
"{\n"
"declare idx, len integer;\n"
"declare line varchar;\n"
"\n"
"idx := 0;\n"
"len := length (lines);\n"
"\n"
"while (idx < len)\n"
"{\n"
"line := aref (lines, idx);\n"
"if (matches_like (line, match_str))\n"
"return (vsp_ua_skip_lwsp (aref (split_and_decode (line, 0, \'=_\\n:\'), 1)));\n"
"inc (idx);\n"
"}\n"
"return \'\';\n"
"}\n"
"--src vsp_auth.sql:310\n"
;

static const char *proc10 = 
"#line 336 \"[executable]/vsp_auth.sql\"\n"
" create procedure\n"
"vsp_calculate_digest (in username varchar, in pass varchar, in auth_vec any)\n"
"{\n"
"declare A1, A2, gen_resp varchar;\n"
"declare auth_type varchar;\n"
"\n"
"if (not isarray (auth_vec))\n"
"return null;\n"
"\n"
"auth_type := lower (get_keyword (\'authtype\', auth_vec, \'\'));\n"
"\n"
"gen_resp := null;\n"
"\n"
"if (\'digest\' = auth_type)\n"
"{\n"
"A1 := sprintf (\'%s:%s:%s\', username, get_keyword (\'realm\', auth_vec, \'\'), pass);\n"
"A1 := md5 (A1);\n"
"\n"
"A2 := sprintf (\'%s:%s\', get_keyword(\'method\', auth_vec), get_keyword (\'uri\', auth_vec, \'\'));\n"
"\n"
"A2 := md5 (A2);\n"
"\n"
"gen_resp := sprintf (\'%s:%s:%s:%s:%s:%s\', A1, get_keyword (\'nonce\', auth_vec, \'\'),\n"
"get_keyword (\'nc\', auth_vec, \'\'),\n"
"get_keyword (\'cnonce\', auth_vec, \'\'),\n"
"get_keyword (\'qop\', auth_vec, \'\'), A2);\n"
"\n"
"gen_resp := md5 (gen_resp);\n"
"}\n"
"return gen_resp;\n"
"}\n"
"--src vsp_auth.sql:334\n"
;

static const char *proc11 = 
"#line 369 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"vsp_ua_prop_init ()\n"
"{\n"
"\n"
"return (vector (\'has_basic_auth\', \'has_digest_auth\',\n"
"\'is_msie\', \'has_frames\',\n"
"\'has_tables\', \'has_css1\',\n"
"\'has_css2\', \'has_xml\',\n"
"\'browser_level\', \'ua_platform\',\n"
"\'is_robot\', \'is_dav_client\'));\n"
"}\n"
"--src vsp_auth.sql:367\n"
;

static const char *proc12 = 
"#line 382 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"vsp_ua_vec_init ()\n"
"{\n"
"return (vector (\n"
"\'Mozilla/4*(compatible; MSIE 6*Windows*\',\n"
"vector (\'True\', \'True\',\n"
"\'True\', \'True\',\n"
"\'True\', \'True\',\n"
"\'False\', \'True\',\n"
"6, \'Win32\',\n"
"\'False\', \'False\'),\n"
"\'Mozilla/4*(compatible; MSIE 5*Windows*\',\n"
"vector (\'True\', \'True\',\n"
"\'True\', \'True\',\n"
"\'True\', \'True\',\n"
"\'False\', \'True\',\n"
"5, \'Win32\',\n"
"\'False\', \'False\'),\n"
"\'Mozilla/4*(compatible; MSIE 4*Windows*\',\n"
"vector (\'True\', \'True\',\n"
"\'True\', \'True\',\n"
"\'True\', \'True\',\n"
"\'False\', \'False\',\n"
"4, \'Win32\',\n"
"\'False\', \'False\'),\n"
"\'Mozilla/4*(compatible; MSIE 6*Linux*Opera [7-9]*\',\n"
"vector (\'True\', \'True\',\n"
"\'True\', \'True\',\n"
"\'True\', \'True\',\n"
"\'False\', \'False\',\n"
"4, \'Linux\',\n"
"\'False\', \'False\'),\n"
"\'*(compatible; MSIE*\',\n"
"vector (\'False\', \'False\',\n"
"\'True\', \'False\',\n"
"\'True\', \'False\',\n"
"\'False\', \'False\',\n"
"2, \'Win32\',\n"
"\'False\', \'False\'),\n"
"\'Mozilla/4.*Windows*\',\n"
"vector (\'True\', \'True\',\n"
"\'False\', \'True\',\n"
"\'True\', \'True\',\n"
"\'False\', \'False\',\n"
"4, \'Win32\',\n"
"\'False\', \'False\'),\n"
"\'Mozilla/5.*Windows*\',\n"
"vector (\'True\', \'True\',\n"
"\'False\', \'True\',\n"
"\'True\', \'True\',\n"
"\'False\', \'True\',\n"
"5, \'Win32\',\n"
"\'False\', \'False\'),\n"
"\'Mozilla/4.*Linux*\',\n"
"vector (\'True\', \'False\',\n"
"\'False\', \'True\',\n"
"\'True\', \'True\',\n"
"\'False\', \'False\',\n"
"4, \'Linux\',\n"
"\'False\', \'False\'),\n"
"\'Mozilla/5.*AppleWebKit/5*\',\n"
"vector (\'True\', \'True\',\n"
"\'False\', \'True\',\n"
"\'True\', \'True\',\n"
"\'True\', \'True\',\n"
"5, \'NA\',\n"
"\'False\', \'False\'),\n"
"\'Mozilla/5.*Linux*\',\n"
"vector (\'True\', \'True\',\n"
"\'False\', \'True\',\n"
"\'True\', \'True\',\n"
"\'False\', \'True\',\n"
"5, \'Linux\',\n"
"\'False\', \'False\'),\n"
"\'Mozilla/4.*Macintosh*\',\n"
"vector (\'True\', \'False\',\n"
"\'False\', \'True\',\n"
"\'True\', \'True\',\n"
"\'False\', \'False\',\n"
"4, \'Mac\',\n"
"\'False\', \'False\'),\n"
"\'Mozilla/5.*Macintosh*\',\n"
"vector (\'True\', \'True\',\n"
"\'False\', \'True\',\n"
"\'True\', \'True\',\n"
"\'False\', \'True\',\n"
"5, \'Mac\',\n"
"\'False\', \'False\'),\n"
"\'Lynx/2*\',\n"
"vector (\'True\', \'False\',\n"
"\'False\', \'True\',\n"
"\'True\', \'False\',\n"
"\'False\', \'False\',\n"
"2, \'NA\',\n"
"\'False\', \'False\'),\n"
"\'Microsoft Data Access Internet Publishing Provider DAV*\',\n"
"vector (\'True\', \'True\',\n"
"\'False\', \'False\',\n"
"\'False\', \'False\',\n"
"\'False\', \'False\',\n"
"0, \'Win32\',\n"
"\'False\', \'True\'),\n"
"\'cadaver/*\',\n"
"vector (\'True\', \'True\',\n"
"\'False\', \'False\',\n"
"\'False\', \'False\',\n"
"\'False\', \'False\',\n"
"0, \'NA\',\n"
"\'False\', \'True\'),\n"
"\'Opera/4*\',\n"
"vector (\'True\', \'True\',\n"
"\'True\', \'True\',\n"
"\'True\', \'True\',\n"
"\'False\', \'False\',\n"
"4, \'Linux\',\n"
"\'False\', \'False\'),\n"
"\'curl/*\',\n"
"vector (\'True\', \'True\',\n"
"\'False\', \'False\',\n"
"\'False\', \'False\',\n"
"\'False\', \'False\',\n"
"0, \'NA\',\n"
"\'False\', \'False\'),\n"
"\'WebDAVFS/*\',\n"
"vector (\'True\', \'True\',\n"
"\'False\', \'True\',\n"
"\'True\',  \'True\',\n"
"\'False\', \'False\',\n"
"0, \'Mac\',\n"
"\'False\', \'True\'),\n"
"\'*\',\n"
"vector (\'False\', \'False\',\n"
"\'False\', \'False\',\n"
"\'False\', \'False\',\n"
"\'False\', \'False\',\n"
"1, \'NA\',\n"
"\'False\', \'False\')));\n"
"}\n"
"--src vsp_auth.sql:380\n"
;

static const char *proc13 = 
"#line 527 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"vsp_ua_get_prop (in prop_name varchar, inout ua_id varchar, inout prop_map any, inout ua_vec any)\n"
"{\n"
"\n"
"\n"
"declare idx, prop_idx integer;\n"
"declare ua_vec_len integer;\n"
"\n"
"\n"
"ua_vec_len := length (ua_vec);\n"
"prop_idx := 0;\n"
"\n"
"while (prop_idx <= length (prop_map) and aref (prop_map, prop_idx) <> prop_name)\n"
"{\n"
"inc (prop_idx);\n"
"}\n"
"\n"
"return (aref (vsp_ua_get_prop_list (ua_id, prop_map, ua_vec), prop_idx));\n"
"}\n"
"--src vsp_auth.sql:525\n"
;

static const char *proc14 = 
"#line 550 \"[executable]/vsp_auth.sql\"\n"
" create procedure\n"
"vsp_ua_get_props (in prop_name varchar, in lines any)\n"
"{\n"
"return vsp_ua_get_prop (prop_name, vsp_ua_id (lines), vsp_ua_prop_init (), vsp_ua_vec_init ());\n"
"}\n"
"--src vsp_auth.sql:548\n"
;

static const char *proc15 = 
"#line 562 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"vsp_ua_get_prop_list (inout ua_id varchar, inout prop_map any, inout ua_vec any)\n"
"{\n"
"\n"
"declare idx, prop_idx integer;\n"
"declare ua_vec_len integer;\n"
"\n"
"ua_vec_len := length (ua_vec);\n"
"idx := 0;\n"
"\n"
"while (idx < ua_vec_len)\n"
"{\n"
"\n"
"if (matches_like (ua_id, aref (ua_vec, idx)))\n"
"{\n"
"\n"
"return (aref (ua_vec, idx + 1));\n"
"}\n"
"idx := idx + 2;\n"
"}\n"
"}\n"
"--src vsp_auth.sql:560\n"
;

static const char *proc16 = 
"#line 586 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"inc (inout i integer)\n"
"{\n"
"i := i + 1;\n"
"}\n"
"--src vsp_auth.sql:584\n"
;

static const char *proc17 = 
"#line 594 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"vsp_ua_prop_tbl (inout prop_list any, inout prop_map any)\n"
"{\n"
"\n"
"declare idx, len integer;\n"
"len := length (prop_map);\n"
"idx := 0;\n"
"\n"
"\n"
"\n"
"\n"
"http (\'<table border=\"1\">\');\n"
"while (idx < len)\n"
"{\n"
"http (\'<tr><td>\');\n"
"http (aref (prop_map, idx));\n"
"http (\'</td><td>\');\n"
"http (cast (aref (prop_list, idx) as varchar));\n"
"http (\'</td></tr>\');\n"
"inc (idx);\n"
"}\n"
"http (\'</table>\');\n"
"}\n"
"--src vsp_auth.sql:592\n"
;

static const char *proc18 = 
"#line 620 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"vsp_ua_id (in lines any)\n"
"{\n"
"return (vsp_ua_match_hdr (lines, \'%[Uu]ser-[Aa]gent: %\'));\n"
"}\n"
"--src vsp_auth.sql:618\n"
;

static const char *proc19 = 
"#line 632 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"vsp_ua_match_hdr_1 (inout lines any, in match_str varchar)\n"
"{\n"
"declare idx, jdx, len integer;\n"
"declare line varchar;\n"
"declare dbg integer;\n"
"\n"
"idx := 0;\n"
"len := length (lines);\n"
"jdx := 0;\n"
"\n"
"while (idx < len)\n"
"{\n"
"line := aref (lines, idx);\n"
"if (matches_like (line, match_str))\n"
"{\n"
"\n"
"len := length (line);\n"
"vsp_ua_next_tok (line, \':\', jdx);\n"
"inc (jdx);\n"
"return (subseq (line, skip_lwsp (line, jdx, len), len));\n"
"}\n"
"inc (idx);\n"
"}\n"
"return (null);\n"
"}\n"
"--src vsp_auth.sql:630\n"
;

static const char *proc20 = 
"#line 661 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"vsp_ua_get_cookie_str (in lines any)\n"
"{\n"
"return (vsp_ua_match_hdr_1 (lines, \'%[Cc]ookie:%\'));\n"
"}\n"
"--src vsp_auth.sql:659\n"
;

static const char *proc21 = 
"#line 673 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"vsp_ua_next_cookie (in cook_str varchar, inout inx integer)\n"
"{\n"
"return vector();\n"
"}\n"
"--src vsp_auth.sql:671\n"
;

static const char *proc22 = 
"#line 686 \"[executable]/vsp_auth.sql\"\n"
" create procedure\n"
"vsp_ua_set_cookie (in cook_str varchar)\n"
"{\n"
"http_header (concat (http_header_get (),\n"
"cook_str));\n"
"}\n"
"--src vsp_auth.sql:684\n"
;

static const char *proc23 = 
"#line 695 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"vsp_ua_app_cookie (in cook_str varchar,\n"
"in name varchar,\n"
"in value varchar,\n"
"in domain varchar,\n"
"in path varchar,\n"
"in expires varchar,\n"
"in secure varchar) returns varchar\n"
"{\n"
"declare tmp varchar;\n"
"\n"
"tmp := concat (cook_str, \', \',\n"
"name, \'=\', value, \';\');\n"
"if (\'\' <> expires)\n"
"tmp := concat (tmp, \',expires=\', expires);\n"
"\n"
"if (\'\' <> domain)\n"
"tmp := concat (tmp, \',domain=\', domain);\n"
"\n"
"if (\'\' <> path)\n"
"tmp := concat (tmp, \',path=\', path);\n"
"\n"
"if (\'\' <> secure)\n"
"tmp := concat (tmp, \' secure\');\n"
"\n"
"return (tmp);\n"
"}\n"
"--src vsp_auth.sql:693\n"
;

static const char *proc24 = 
"#line 726 \"[executable]/vsp_auth.sql\"\n"
" create procedure\n"
"vsp_auth_get (in realm varchar, in domain varchar,\n"
"in nonce varchar, in opaque varchar,\n"
"in stale varchar, inout lines any, in allow_basic integer)\n"
"{\n"
"\n"
"declare hdr varchar;\n"
"declare ua_id varchar;\n"
"declare foo varchar;\n"
"declare require_encrypted integer;\n"
"\n"
"ua_id := vsp_ua_id (lines);\n"
"\n"
"http_request_status (\'HTTP/1.1 401 Unauthorized\');\n"
"require_encrypted := sys_stat (\'sql_encryption_on_password\');\n"
"if (allow_basic and (require_encrypted = 1 or require_encrypted = 2))\n"
"require_encrypted := 0;\n"
"else\n"
"require_encrypted := 1;\n"
"\n"
"if (trim (vsp_ua_match_hdr (lines, \'X-Requested-With: %\'), \'\\r\') <> \'XMLHttpRequest\')\n"
"{\n"
"if (require_encrypted and (\'True\' = vsp_ua_get_prop (\'has_digest_auth\',\n"
"ua_id, vsp_ua_prop_init (),\n"
"vsp_ua_vec_init ()) or 0 = allow_basic))\n"
"{\n"
"\n"
"hdr := sprintf (\'WWW-Authenticate: Digest realm=\"%s\", domain=\"%s\", nonce=\"%s\", opaque=\"%s\", stale=\"%s\", qop=\"auth\", algorithm=\"MD5\"\\r\\n\',\n"
"coalesce (realm, \'\'),\n"
"coalesce (domain, \'\'),\n"
"coalesce (nonce, \'\'),\n"
"coalesce (opaque, \'\'),\n"
"coalesce (stale, \'\'));\n"
"\n"
"http_header(concat (coalesce (http_header_get (), \'\'), hdr));\n"
"return 0;\n"
"}\n"
"hdr := sprintf (\'WWW-Authenticate: Basic realm=\"%s\"\\r\\n\', coalesce (realm, \'\'));\n"
"http_header (concat (coalesce (http_header_get (), \'\'), hdr));\n"
"return 0;\n"
"}\n"
"}\n"
"--src vsp_auth.sql:724\n"
;

static const char *proc25 = 
"#line 776 \"[executable]/vsp_auth.sql\"\n"
" create procedure\n"
"vsp_auth_verify_pass (in auth_vec varchar,\n"
"in username varchar,\n"
"in realm varchar,\n"
"in uri varchar,\n"
"in nonce varchar,\n"
"in nc varchar,\n"
"in cnonce varchar,\n"
"in qop varchar,\n"
"in pass varchar)\n"
"\n"
"{\n"
"\n"
"return http_auth_verify (auth_vec, username, realm, uri, nonce, nc, cnonce, qop, pass);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"--src vsp_auth.sql:774\n"
;

static const char *proc26 = 
"#line 842 \"[executable]/vsp_auth.sql\"\n"
"create procedure\n"
"vsp_ua_next_tok (in str varchar, in sep varchar, inout inx integer)\n"
"{\n"
"declare len integer;\n"
"declare tok_st integer;\n"
"\n"
"len := length (str);\n"
"\n"
"while (not isnull (strchr (sep, aref (str, inx))))\n"
"{\n"
"if (inx = len)\n"
"return (NULL);\n"
"\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"tok_st := inx;\n"
"\n"
"while (isnull (strchr (sep, aref (str, inx))))\n"
"{\n"
"inx := inx + 1;\n"
"}\n"
"return subseq (str, tok_st, inx);\n"
"}\n"
"--src vsp_auth.sql:840\n"
;

static const char *proc27 = 
"#line 870 \"[executable]/vsp_auth.sql\"\n"
" create procedure\n"
"vsp_ua_get_cookie_vec (in lines any)\n"
"{\n"
"declare cook_vec any;\n"
"declare cook_str varchar;\n"
"declare inx integer;\n"
"declare tok varchar;\n"
"\n"
"inx := 0;\n"
"cook_vec := vector ();\n"
"\n"
"\n"
"cook_str := vsp_ua_get_cookie_str (lines);\n"
"\n"
"\n"
"\n"
"if (cook_str is null)\n"
"return (vector ());\n"
"\n"
"while (1)\n"
"{\n"
"tok := vsp_ua_next_tok (cook_str, \' \\t=;\\r\\n\', inx);\n"
"\n"
"if (tok is null)\n"
"goto nd;\n"
"cook_vec := vector_concat (cook_vec, vector (tok));\n"
"}\n"
"nd:\n"
"if (0 <> mod (length (cook_vec), 2))\n"
"return (vector ());\n"
"return (cook_vec);\n"
"}\n"
"--src vsp_auth.sql:868\n"
;

static const char *proc28 = 
"#line 905 \"[executable]/vsp_auth.sql\"\n"
" create procedure\n"
"vsp_ua_make_cookie (in name varchar,\n"
"in value varchar,\n"
"in expires datetime,\n"
"in domain varchar,\n"
"in path varchar,\n"
"in secure integer)\n"
"{\n"
"declare tmp varchar;\n"
"\n"
"tmp := concat (\'Set-cookie: \', name, \'=\', value, \'\');\n"
"\n"
"if (expires is not null)\n"
"{\n"
"tmp := concat (tmp, \'; expires=\', soap_print_box (expires, \'\', 1),\'\');\n"
"}\n"
"if (\'\' <> domain)\n"
"tmp := concat (tmp, \'; domain=\', domain, \'\');\n"
"\n"
"if (\'\' <> path)\n"
"tmp := concat (tmp, \'; path=\', path,\'\');\n"
"\n"
"if (0 <> secure)\n"
"tmp := concat (tmp, \' secure\');\n"
"\n"
"\n"
"\n"
"tmp := concat (tmp, \'\\r\\n\');\n"
"return (tmp);\n"
"}\n"
"--src vsp_auth.sql:903\n"
;

/* soap.sql */

static const char *proc29 = 
"#line 24 \"[executable]/soap.sql\"\n"
" create procedure\n"
"SOAP_CLIENT (\n"
"in url varchar,\n"
"in operation varchar,\n"
"in target_namespace varchar := null,\n"
"in parameters any := null,\n"
"in headers any := null,\n"
"in soap_action varchar := \'\',\n"
"in attachments any := null,\n"
"in ticket any := null,\n"
"in passwd varchar := null,\n"
"in user_name varchar := null,\n"
"in user_password varchar := null,\n"
"in auth_type varchar := \'none\',\n"
"in security_type varchar := \'sign\',\n"
"in debug integer := 0,\n"
"in template varchar := null,\n"
"in style integer := 0,\n"
"in version integer := 11,\n"
"in direction integer := 0,\n"
"in http_header any := null,\n"
"in security_schema any := null,\n"
"in time_out int := 100)\n"
"{\n"
"declare conn, ret any;\n"
"conn := null;\n"
"ret := SOAP_ASYNC_CLIENT (\n"
"url,\n"
"operation,\n"
"target_namespace,\n"
"parameters,\n"
"headers,\n"
"soap_action,\n"
"attachments,\n"
"ticket,\n"
"passwd,\n"
"user_name,\n"
"user_password,\n"
"auth_type,\n"
"security_type,\n"
"debug,\n"
"template,\n"
"style,\n"
"version,\n"
"direction,\n"
"http_header,\n"
"security_schema,\n"
"time_out,\n"
"conn\n"
");\n"
"return ret;\n"
"}\n"
"--src soap.sql:22\n"
;

static const char *proc30 = 
"#line 79 \"[executable]/soap.sql\"\n"
" create procedure\n"
"SOAP_ASYNC_CLIENT\n"
"(\n"
"in url varchar,\n"
"in operation varchar,\n"
"in target_namespace varchar := null,\n"
"in parameters any := null,\n"
"in headers any := null,\n"
"in soap_action varchar := \'\',\n"
"in attachments any := null,\n"
"in ticket any := null,\n"
"in passwd varchar := null,\n"
"in user_name varchar := null,\n"
"in user_password varchar := null,\n"
"in auth_type varchar := \'none\',\n"
"in security_type varchar := \'sign\',\n"
"in debug integer := 0,\n"
"in template varchar := null,\n"
"in style integer := 0,\n"
"in version integer := 11,\n"
"in direction integer := 0,\n"
"in http_header any := null,\n"
"in security_schema any := null,\n"
"in time_out int := 100,\n"
"inout conn any\n"
")\n"
"{\n"
"declare host, path varchar;\n"
"declare hinfo, resp, ver, skeys any;\n"
"declare security_tp int;\n"
"\n"
"hinfo := rfc1808_parse_uri (url);\n"
"host := hinfo [1];\n"
"if (lower (hinfo[0]) = \'https\' and ticket is null)\n"
"ticket := \'1\';\n"
"path := vspx_uri_compose (vector (\'\',\'\', hinfo [2], hinfo[3], hinfo[4], hinfo[5]));\n"
"if (parameters is null)\n"
"parameters := vector ();\n"
"\n"
"if (auth_type = \'x509\' or auth_type = \'kerberos\' or auth_type = \'key\')\n"
"security_tp := case security_type when \'sign\' then 1 else 2 end;\n"
"else\n"
"{\n"
"security_tp := 0;\n"
"if (lower (hinfo[0]) <> \'https\')\n"
"ticket := null;\n"
"}\n"
"\n"
"if (debug)\n"
"ver := -1 * version;\n"
"else\n"
"ver := version;\n"
"\n"
"soap_action := \'\"\' || trim (soap_action, \'\"\') || \'\"\';\n"
"\n"
"if (lower (hinfo[0]) = \'https\' and strchr (host, \':\') is null)\n"
"host := host || \':443\';\n"
"\n"
"skeys := null;\n"
"\n"
"if (connection_get (\'wssc-keys\') is not null)\n"
"connection_set (\'wssc-keys\', null);\n"
"\n"
"resp := soap_call_new (host, path, target_namespace, operation, parameters,\n"
"ver, ticket, passwd, soap_action, style,\n"
"user_name, user_password, security_tp, ticket, template, headers, http_header,\n"
"direction, security_schema, conn, time_out, skeys);\n"
"\n"
"if (skeys is not null)\n"
"connection_set (\'wssc-keys\', skeys);\n"
"\n"
"return resp;\n"
"}\n"
"--src soap.sql:77\n"
;

static const char *proc31 = 
"#line 154 \"[executable]/soap.sql\"\n"
"create procedure WSSE_GET_NS_INFO (inout doc any, inout ns any)\n"
"{\n"
"declare wsse any;\n"
"wsse := vector (\n"
"\'http://schemas.xmlsoap.org/ws/2002/12/secext\',\n"
"\'http://schemas.xmlsoap.org/ws/2002/04/secext\',\n"
"\'http://schemas.xmlsoap.org/ws/2002/07/secext\',\n"
"\'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\'\n"
");\n"
"foreach (varchar uri in wsse) do\n"
"{\n"
"if (xpath_eval (sprintf (\'[ xmlns:wsse=\"%s\" ] //wsse:Security\', uri), doc) is not null)\n"
"{\n"
"if (uri like \'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-%\')\n"
"ns := vector (\'wsse\', uri,\n"
"\'wsu\', \'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\');\n"
"else\n"
"ns := vector (\'wsse\', uri);\n"
"}\n"
"}\n"
"}\n"
"--src soap.sql:152\n"
;

static const char *proc32 = 
"#line 178 \"[executable]/soap.sql\"\n"
" create procedure WSSE_OASIS_URI () returns varchar\n"
"{\n"
"return \'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\';\n"
"}\n"
"--src soap.sql:176\n"
;

static const char *proc33 = 
"#line 185 \"[executable]/soap.sql\"\n"
" create procedure WSSU_OASIS_URI () returns varchar\n"
"{\n"
"return \'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\';\n"
"}\n"
"--src soap.sql:183\n"
;

static const char *proc34 = 
"#line 191 \"[executable]/soap.sql\"\n"
"create procedure\n"
"SOAP_DEFAULT_XENC_TEMPLATE (in body varchar, in key_name varchar, in ns any)\n"
"{\n"
"declare tmpl, algo varchar;\n"
"algo := xenc_get_key_algo (key_name);\n"
"if (algo is null)\n"
"return NULL;\n"
"\n"
"tmpl := sprintf (\'<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
"<Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\" >\n"
"<SignedInfo>\n"
"<CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\" />\n"
"<SignatureMethod Algorithm=\"%s\" />\n"
"</SignedInfo>\n"
"<SignatureValue></SignatureValue>\n"
"<KeyInfo>\n"
"<KeyName>%s</KeyName>\n"
"</KeyInfo>\n"
"</Signature>\', algo, key_name);\n"
"\n"
"return dsig_template_ext (xtree_doc (body), tmpl, ns,\n"
"\'http://schemas.xmlsoap.org/soap/envelope/\', \'Body\',\n"
"\n"
"\'http://schemas.xmlsoap.org/ws/2004/03/addressing\', \'Action\',\n"
"\'http://schemas.xmlsoap.org/ws/2004/03/addressing\', \'From\',\n"
"\'http://schemas.xmlsoap.org/ws/2004/03/addressing\', \'To\',\n"
"\'http://schemas.xmlsoap.org/ws/2004/03/addressing\', \'MessageID\',\n"
"\'http://schemas.xmlsoap.org/ws/2004/03/addressing\', \'ReplyTo\',\n"
"\'http://schemas.xmlsoap.org/ws/2004/03/addressing\', \'FaultTo\',\n"
"\'http://schemas.xmlsoap.org/ws/2004/03/addressing\', \'RelatesTo\',\n"
"\n"
"\'http://schemas.xmlsoap.org/ws/2003/03/addressing\', \'Action\',\n"
"\'http://schemas.xmlsoap.org/ws/2003/03/addressing\', \'From\',\n"
"\'http://schemas.xmlsoap.org/ws/2003/03/addressing\', \'To\',\n"
"\'http://schemas.xmlsoap.org/ws/2003/03/addressing\', \'MessageID\',\n"
"\'http://schemas.xmlsoap.org/ws/2003/03/addressing\', \'ReplyTo\',\n"
"\'http://schemas.xmlsoap.org/ws/2003/03/addressing\', \'FaultTo\',\n"
"\'http://schemas.xmlsoap.org/ws/2003/03/addressing\', \'RelatesTo\',\n"
"\n"
"\'http://schemas.xmlsoap.org/rp\', \'action\',\n"
"\'http://schemas.xmlsoap.org/rp\', \'to\',\n"
"\'http://schemas.xmlsoap.org/rp\', \'id\',\n"
"\n"
"\'http://schemas.xmlsoap.org/ws/2002/07/utility\', \'Created\',\n"
"\'http://schemas.xmlsoap.org/ws/2002/07/utility\', \'Expires\'\n"
");\n"
"\n"
"}\n"
"--src soap.sql:189\n"
;

static const char *proc35 = 
"#line 241 \"[executable]/soap.sql\"\n"
"create procedure\n"
"SOAP_CLIENT_WSS (INOUT BODY ANY, INOUT KEYI ANY, INOUT TEMPLATE VARCHAR, INOUT SIGN INT, INOUT NS ANY)\n"
"{\n"
"declare resp varchar;\n"
"declare request varchar;\n"
"declare _template varchar;\n"
"declare _ns any;\n"
"\n"
"if (not sign)\n"
"return;\n"
"\n"
"request := string_output_string (BODY);\n"
"_template := TEMPLATE;\n"
"\n"
"if (isarray (NS) and not isstring (NS))\n"
"_ns := NS;\n"
"else\n"
"_ns := vector ();\n"
"\n"
"\n"
"if (_template like \'^[%^]\' escape \'^\')\n"
"{\n"
"_template := trim (_template, \'[]\');\n"
"if (\"LEFT\" (_template, 5) = \'func:\')\n"
"{\n"
"declare mdata any;\n"
"_template := subseq (_template, 5);\n"
"_template := call (_template)(request);\n"
"}\n"
"else\n"
"_template := SOAP_DEFAULT_XENC_TEMPLATE (request, _template, _ns);\n"
"}\n"
"\n"
"if (sign = 1 or keyi is null)\n"
"{\n"
"resp := xenc_encrypt (request, 11, _template, _ns);\n"
"}\n"
"else if (sign = 2)\n"
"resp := xenc_encrypt (request, 11, _template, _ns, \'//Envelope/Body\', keyi, \'Content\');\n"
"string_output_flush (BODY);\n"
"http (resp, BODY);\n"
"}\n"
"--src soap.sql:239\n"
;

static const char *proc36 = 
"#line 286 \"[executable]/soap.sql\"\n"
" create procedure\n"
"wsrp_error (in code integer, in reason varchar, in endpoint varchar, inout soap_xml any)\n"
"{\n"
"declare errm any;\n"
"http_rewrite ();\n"
"errm := xslt (\'http://local.virt/wsrp_error\', soap_xml, vector (\'code\', cast (code as varchar), \'reason\', reason, \'endpoint\', endpoint, \'id\', lower(uuid())));\n"
"http_value (errm);\n"
"http_request_status (\'HTTP/1.1 500 Server Error\');\n"
"signal (\'SOAP\', sprintf (\'%d %s\', code, reason));\n"
"}\n"
"--src soap.sql:284\n"
;

static const char *proc37 = 
"#line 298 \"[executable]/soap.sql\"\n"
"create procedure\n"
"WS_SOAP_GET_KEYINFO (inout soap_xml any, inout lines any)\n"
"{\n"
"declare tkt any;\n"
"declare tp, enc varchar;\n"
"declare ser, own, issuer, stard, endd, usr any;\n"
"declare sec, pos1, pos2 any;\n"
"\n"
"sec := xpath_eval\n"
"(\'[xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\"] /S:Envelope/S:Header/*:Security\',\n"
"soap_xml, 1);\n"
"\n"
"\n"
"if (sec is null)\n"
"return ;\n"
"\n"
"\n"
"\n"
"tkt := xpath_eval (\'BinarySecurityToken/text()\', sec, 1);\n"
"tp := xpath_eval  (\'BinarySecurityToken/@ValueType\', sec, 1);\n"
"enc := xpath_eval (\'BinarySecurityToken/@EncodingType\', sec, 1);\n"
"usr := xpath_eval (\'UsernameToken/Username/text()\', sec, 1);\n"
"\n"
"if (usr is not null)\n"
"{\n"
"connection_set (\'wss-user\', cast (usr as varchar));\n"
"}\n"
"\n"
"if (tkt is null)\n"
"return;\n"
"\n"
"tp := cast (tp as varchar);\n"
"enc := cast (enc as varchar);\n"
"tkt := cast (tkt as varchar);\n"
"\n"
"pos1 := strrchr (tp,  \'#\');\n"
"pos2 := strrchr (enc, \'#\');\n"
"if (pos1 is null)\n"
"{\n"
"pos1 := strrchr (tp, \':\');\n"
"pos2 := strrchr (enc, \':\');\n"
"}\n"
"\n"
"if (pos1 is not null)\n"
"tp := subseq (tp, pos1 + 1, length (tp));\n"
"if (pos2 is not null)\n"
"enc := subseq (enc, pos2 + 1, length (enc));\n"
"\n"
"ser := own := issuer := stard := endd := NULL;\n"
"if (tp = \'X509v3\')\n"
"{\n"
"if (enc = \'Base64Binary\')\n"
"{\n"
"declare cert any;\n"
"cert := decode_base64 (tkt);\n"
"ser := get_certificate_info (1, cert, 1);\n"
"own := get_certificate_info (2, cert, 1);\n"
"issuer := get_certificate_info (3, cert, 1);\n"
"stard := get_certificate_info (4, cert, 1);\n"
"endd := get_certificate_info (5, cert, 1);\n"
"}\n"
"}\n"
"else if (tp = \'Kerberosv5ST\')\n"
"{\n"
"if (enc = \'Base64Binary\')\n"
"{\n"
"declare cert, ctx, cip, cnt any;\n"
"cert := decode_base64 (tkt);\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"dbg_obj_print (__SQL_MESSAGE);\n"
"resignal;\n"
"};\n"
"ctx := krb_init_srv_ctx (\'host\', cert);\n"
"ser := krb_inquire_ctx (ctx, 1);\n"
"own := krb_inquire_ctx (ctx, 2);\n"
"issuer := krb_inquire_ctx (ctx, 3);\n"
"stard := krb_inquire_ctx (ctx, 4);\n"
"endd := krb_inquire_ctx (ctx, 5);\n"
"\n"
"cip := cast (xpath_eval (\'//CipherValue/text()\', soap_xml, 1) as varchar);\n"
"cnt := kerberos_unseal (ctx, cip);\n"
"dbg_obj_print (cnt);\n"
"}\n"
"}\n"
"connection_set (\'wss-token-owner\', own);\n"
"connection_set (\'wss-token-issuer\', issuer);\n"
"connection_set (\'wss-token-serial\', ser);\n"
"connection_set (\'wss-token-start\', stard);\n"
"connection_set (\'wss-token-end\', endd);\n"
"}\n"
"--src soap.sql:296\n"
;

static const char *proc38 = 
"#line 391 \"[executable]/soap.sql\"\n"
"create procedure\n"
"WS_SECURITY_CHECK (inout body varchar, inout soap_xml any, inout lines any, inout ns any)\n"
"{\n"
"declare decoded varchar;\n"
"declare body_str varchar;\n"
"declare validate_sign int;\n"
"declare opts, uhook, ekeys any;\n"
"\n"
"body_str := string_output_string (body);\n"
"\n"
"if (0)\n"
"log_message (\'Calling security pre-processing\');\n"
"\n"
"opts := http_map_get (\'soap_opts\');\n"
"validate_sign := get_keyword (\'WSS-Validate-Signature\', opts, 2);\n"
"\n"
"if (isstring (validate_sign))\n"
"validate_sign := cast (validate_sign as integer);\n"
"\n"
"\n"
"{\n"
"declare exit handler for sqlstate \'*\' {\n"
"if (1)\n"
"log_message (sprintf (\'WSS: %s\', __SQL_MESSAGE));\n"
"resignal;\n"
"\n"
"\n"
"};\n"
"\n"
"decoded := xenc_decrypt_soap (body_str, 11, validate_sign, \'UTF-8\', \'x-any\', opts, ekeys);\n"
"connection_set (\'wss-keys\', ekeys);\n"
"if (isstring (decoded))\n"
"soap_xml := xml_tree_doc (decoded);\n"
"}\n"
"\n"
"WSSE_GET_NS_INFO (soap_xml, ns);\n"
"\n"
"\n"
"{\n"
"declare created, expires, timenow datetime;\n"
"declare _created, _expires any;\n"
"timenow := now ();\n"
"_created := xpath_eval (\'[xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:u=\"http://schemas.xmlsoap.org/ws/2002/07/utility\"] /S:Envelope/S:Header/u:Timestamp/u:Created\', soap_xml);\n"
"_expires := xpath_eval (\'[xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:u=\"http://schemas.xmlsoap.org/ws/2002/07/utility\"] /S:Envelope/S:Header/u:Timestamp/u:Expires\', soap_xml);\n"
"\n"
"if (_expires is not null and _created is not null)\n"
"{\n"
"created := soap_box_xml_entity (_created, timenow, 11);\n"
"expires := soap_box_xml_entity (_expires, timenow, 11);\n"
"\n"
"\n"
"if ((dateadd(\'second\', -1, created) > timenow or timenow > expires))\n"
"signal (\'SOAP\', sprintf (\'300 Message Expired (created %s expires %s, time now is %s)\',\n"
"__rdf_strsqlval (created), __rdf_strsqlval (expires), __rdf_strsqlval (timenow) ) );\n"
"}\n"
"}\n"
"\n"
"\n"
"nxt:\n"
"WS_SOAP_GET_KEYINFO (soap_xml, lines);\n"
"\n"
"uhook := get_keyword (\'WSS-SecurityCheck\', opts, NULL);\n"
"\n"
"\n"
"if (length (uhook) > 0 and __proc_exists (uhook))\n"
"{\n"
"call (uhook) (soap_xml);\n"
"}\n"
"\n"
"if (__proc_exists (\'DB.DBA.WS_SOAP_ACCOUNTING\'))\n"
"{\n"
"declare rc int;\n"
"rc := call (\'DB.DBA.WS_SOAP_ACCOUNTING\') ();\n"
"if (not rc)\n"
"{\n"
"http_rewrite ();\n"
"http (soap_make_error (\'300\', \'42000\', \'Accounting failed\'));\n"
"http_request_status (\'HTTP/1.1 500 Server Error\');\n"
"signal (\'SOAP\', sprintf (\'%d %s\', 300, \'Accounting failed\'));\n"
"}\n"
"}\n"
"\n"
"}\n"
"--src soap.sql:389\n"
;

static const char *proc39 = 
"#line 476 \"[executable]/soap.sql\"\n"
"create procedure\n"
"WS_SECURITY_ADD (inout body any, inout ns any)\n"
"{\n"
"declare _body any;\n"
"declare _ns any;\n"
"\n"
"if (0)\n"
"log_message (\'Calling security post-processing\');\n"
"declare templ, tempf, kname, ktype, tp varchar;\n"
"declare keyinst, ses, opts any;\n"
"\n"
"opts := http_map_get (\'soap_opts\');\n"
"templ := get_keyword (\'WSS-Template\', opts, NULL);\n"
"tempf := get_keyword (\'WSS-Func-Template\', opts, NULL);\n"
"kname := get_keyword (\'WSS-KEY\', opts, NULL);\n"
"\n"
"if (isarray (ns) and not isstring (ns))\n"
"_ns := ns;\n"
"else\n"
"_ns := vector ();\n"
"\n"
"\n"
"if (isstring (kname) and __proc_exists (kname))\n"
"keyinst := call (kname) ();\n"
"else\n"
"keyinst := NULL;\n"
"\n"
"\n"
"ses := string_output ();\n"
"http_value (body, null, ses);\n"
"_body := string_output_string (ses);\n"
"\n"
"\n"
"if (tempf is not null)\n"
"{\n"
"templ := call (tempf)(body);\n"
"}\n"
"else if (templ is not null)\n"
"{\n"
"if (templ like \'^[%^]\' escape \'^\')\n"
"{\n"
"templ := trim (templ, \'[]\');\n"
"if (\"LEFT\" (templ, 5) = \'func:\')\n"
"{\n"
"templ := subseq (templ, 5);\n"
"templ := call (templ)(_body);\n"
"}\n"
"else\n"
"templ := SOAP_DEFAULT_XENC_TEMPLATE (_body, templ, _ns);\n"
"}\n"
"else\n"
"templ := file_to_string (templ);\n"
"}\n"
"else\n"
"templ := null;\n"
"\n"
"if (keyinst is not null)\n"
"body := xenc_encrypt (_body, 11, templ, _ns,\n"
"\'//Envelope/Body[*]\', keyinst, \'Content\');\n"
"else if (templ is not null)\n"
"body := xenc_encrypt (_body, 11, templ, _ns);\n"
"else\n"
"return 0;\n"
"return 1;\n"
"}\n"
"--src soap.sql:474\n"
;

static const char *proc40 = 
"#line 544 \"[executable]/soap.sql\"\n"
" create procedure\n"
"WS_SOAP (in path any, in params any, in lines any)\n"
"{\n"
"declare content_type, soap_method, soap_xml varchar;\n"
"declare res any;\n"
"declare rp, soap_header any;\n"
"declare rp_act, wssec, wsrpe integer;\n"
"declare req_body varchar;\n"
"declare wss, attachments, ns any;\n"
"declare soap_ver int;\n"
"\n"
"soap_ver := 11;\n"
"ns := vector ();\n"
"\n"
"if (length (params) < 1) params := __http_stream_params ();\n"
"\n"
"if (isstring({?\'content\'}) and lower(trim({?\'content\'})) = \'wsdl\')\n"
"{\n"
"http (soap_wsdl ());\n"
"return;\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"rp_act := 0; wssec := 0; wsrpe := 0;\n"
"content_type := http_request_header (lines, \'Content-Type\');\n"
"soap_method := trim (http_request_header (lines, \'SOAPAction\', null, \'\'), \'\"\');\n"
"soap_xml := NULL; attachments := NULL;\n"
"if (isstring (content_type))\n"
"content_type := lower (content_type);\n"
"\n"
"if (content_type = \'text/xml\')\n"
"{\n"
"req_body := http_body_read ();\n"
"soap_xml := xml_tree_doc (xml_tree (req_body));\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"else if (content_type = \'application/dime\')\n"
"{\n"
"declare dime_arr any;\n"
"req_body := http_body_read ();\n"
"req_body := string_output_string (req_body);\n"
"dime_arr := dime_tree (req_body);\n"
"\n"
"req_body := dime_arr [0][2];\n"
"attachments := dime_arr;\n"
"aset (attachments, 0, NULL);\n"
"soap_xml := xml_tree_doc (xml_tree (req_body));\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"else\n"
"{\n"
"http_request_status (\'HTTP/1.1 400 Bad request\');\n"
"signal (\'42000\', \'Unsupported media type\');\n"
"}\n"
"\n"
"http_header (\'Content-Type: text/xml; charset=\"utf-8\"\\r\\n\');\n"
"\n"
"\n"
"rp := xpath_eval (\'[xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:rp=\"http://schemas.xmlsoap.org/rp\"] /S:Envelope/S:Header/rp:path\', soap_xml, 1);\n"
"soap_header := xpath_eval (\'[xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\"] /S:Envelope/S:Header\', soap_xml, 1);\n"
"\n"
"wss := xpath_eval (\'[xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:wss=\"http://schemas.xmlsoap.org/ws/2002/07/secext\"] /S:Envelope/S:Header/wss:Security\', soap_xml, 1);\n"
"if (wss is null)\n"
"wss := xpath_eval (\'[xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:wss=\"http://schemas.xmlsoap.org/ws/2002/04/secext\"] /S:Envelope/S:Header/wss:Security\', soap_xml, 1);\n"
"\n"
"if (http_map_get (\'soap_opts\'))\n"
"{\n"
"if (lower (get_keyword (\'WS-SEC\', http_map_get (\'soap_opts\'), \'no\')) like \'y%\')\n"
"{\n"
"\n"
"wssec := 1;\n"
"}\n"
"\n"
"if (lower (get_keyword (\'WS-RP\', http_map_get (\'soap_opts\'), \'no\')) like \'y%\')\n"
"wsrpe := 1;\n"
"}\n"
"\n"
"declare this_point, send_to, _action, _id, _to, newfwd varchar;\n"
"declare _rev any;\n"
"declare errm any;\n"
"if (rp is not null and wsrpe)\n"
"{\n"
"declare _actor, _mustund nvarchar;\n"
"\n"
"declare _fwd any;\n"
"\n"
"_action := xpath_eval (\'string(action)\', rp, 1);\n"
"_id := xpath_eval (\'string(id)\', rp, 1);\n"
"_actor := xpath_eval (\'@actor\', rp, 1);\n"
"_mustund := xpath_eval (\'@mustUnderstand\', rp, 1);\n"
"if (_actor <> N\'http://schemas.xmlsoap.org/soap/actor/next\' or _mustund <> N\'1\')\n"
"db..wsrp_error (701, \'WS-Routing Header Required\', \'\', soap_xml);\n"
"\n"
"_to := xpath_eval (\'string(to)\', rp, 1);\n"
"_fwd := xpath_eval (\'fwd\', rp, 1);\n"
"_rev := xpath_eval (\'rev\', rp, 1);\n"
"\n"
"\n"
"\n"
"\n"
"this_point := soap_current_url ();\n"
"if (this_point not like \'%/\' and http_path() like \'%/\')\n"
"this_point := concat (this_point, \'/\');\n"
"send_to := NULL;\n"
"_to := cast (_to as varchar);\n"
"if (_fwd is null or xpath_eval(\'via[1]\', _fwd, 1) is null)\n"
"{\n"
"\n"
"if (_to <> this_point)\n"
"{\n"
"db..wsrp_error (800, \'WS-Routing receiver fault\', _to, soap_xml);\n"
"}\n"
"\n"
"rp_act := 2;\n"
"}\n"
"else\n"
"{\n"
"declare _to1 varchar;\n"
"send_to := xpath_eval(\'via[2]\', _fwd, 1);\n"
"if (send_to is not null)\n"
"send_to := xpath_eval(\'string()\', send_to, 1);\n"
"_to1 := xpath_eval(\'string(via[1])\', _fwd, 1);\n"
"_to1 := cast (_to1 as varchar);\n"
"\n"
"\n"
"if (_to1 <> this_point)\n"
"{\n"
"db..wsrp_error (800, \'WS-Routing receiver fault\', _to, soap_xml);\n"
"}\n"
"\n"
"if (send_to is null)\n"
"{\n"
"if (xpath_eval (\'to\', rp, 1) is null)\n"
"{\n"
"\n"
"_to := _to1;\n"
"rp_act := 2;\n"
"}\n"
"else\n"
"{\n"
"\n"
"send_to := _to;\n"
"rp_act := 1;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"\n"
"rp_act := 1;\n"
"}\n"
"}\n"
"\n"
"}\n"
"else if (wsrpe)\n"
"db..wsrp_error (701, \'WS-Routing Header Required\', \'\', soap_xml);\n"
"\n"
"newfwd := \'\';\n"
"if (__proc_exists (\'DB.DBA.WS_SOAP_RF_HEADER\'))\n"
"{\n"
"newfwd := call (\'DB.DBA.WS_SOAP_RF_HEADER\') (soap_header, lines, this_point, send_to);\n"
"if (newfwd <> \'\')\n"
"{\n"
"send_to := newfwd;\n"
"rp_act := 1;\n"
"}\n"
"}\n"
"\n"
"if (rp_act = 1)\n"
"{\n"
"declare hdr, body, hl, ses, hinfo varchar;\n"
"declare hst varchar;\n"
"send_to := cast (send_to as varchar);\n"
"hinfo := rfc1808_parse_uri (send_to);\n"
"if (hinfo [0] = \'\' or hinfo [1] = \'\' or hinfo [2] = \'\' or hinfo [5] <> \'\')\n"
"{\n"
"db..wsrp_error (713, \'Endpoint Invalid\', send_to, soap_xml);\n"
"}\n"
"if (hinfo [0] <> \'http\')\n"
"{\n"
"db..wsrp_error (712, \'Endpoint Not Supported\', send_to, soap_xml);\n"
"}\n"
"body := xslt (\'http://local.virt/wsrp_interm\', soap_xml, vector (\'newrev\', \'\', \'newfwd\', newfwd));\n"
"ses := string_output ();\n"
"http_value (body, NULL, ses);\n"
"body := string_output_string (ses);\n"
"hdr := sprintf (\'SOAPAction: \"%s\"\\r\\nContent-Type: text/xml; charset=\"utf-8\"\', _action);\n"
"{\n"
"declare exit handler for sqlstate \'*\' {\n"
"db..wsrp_error (820, \'Endpoint Not Reachable\', send_to, soap_xml);\n"
"};\n"
"declare exit handler for sqlstate \'22023\' {\n"
"db..wsrp_error (730, \'Endpoint Too Long\', send_to, soap_xml);\n"
"};\n"
"declare exit handler for sqlstate \'08006\' {\n"
"db..wsrp_error (740, \'Message Timeout\', send_to, soap_xml);\n"
"};\n"
"if (registry_get (\'__SOAP_WSRP_LOG\') = \'1\')\n"
"log_message (\'Forwarding request to: \' || send_to);\n"
"res := http_get (send_to, hl, \'POST\', hdr, body);\n"
"}\n"
"\n"
"\n"
"hst := trim(hl[0], \'\\r\\n \');\n"
"\n"
"if (hst like \'HTTP/1.1 4%\')\n"
"db..wsrp_error (820, \'Endpoint Not Reachable\', send_to, soap_xml);\n"
"\n"
"http_request_status (hst);\n"
"\n"
"rp_act := 0;\n"
"if ((\'text/xml\' = http_request_header (hl, \'Content-Type\')) and atoi (http_request_header (hl, \'Content-Length\', null, \'0\')))\n"
"{\n"
"soap_xml := xml_tree_doc (xml_tree (res));\n"
"\n"
"res := xslt (\'http://local.virt/wsrp_interm\', soap_xml, vector (\'newrev\', this_point, \'newfwd\', \'\'));\n"
"}\n"
"\n"
"}\n"
"else\n"
"{\n"
"declare soap_res any;\n"
"declare new_xml any;\n"
"\n"
"declare exit handler for SQLSTATE \'*\' {\n"
"declare err_msg varchar;\n"
"err_msg := soap_make_error (\'300\', __SQL_STATE, __SQL_MESSAGE);\n"
"http (err_msg);\n"
"if (wssec and length (http_pending_req ()) = 1)\n"
"xenc_delete_temp_keys ();\n"
"resignal \'VSPRT\';\n"
"};\n"
"\n"
"if (wssec)\n"
"{\n"
"WS_SECURITY_CHECK (req_body, soap_xml, lines, ns);\n"
"}\n"
"\n"
"new_xml := xslt (\'http://local.virt/wsrp_ultim\', soap_xml);\n"
"\n"
"if (__proc_exists (\'DB.DBA.WS_SOAP_RF_MESSAGE\'))\n"
"res := call (\'DB.DBA.WS_SOAP_RF_MESSAGE\') (new_xml, lines, _action, this_point);\n"
"if (res is null)\n"
"res := soap_server (new_xml, soap_method, lines, soap_ver, null, null, attachments);\n"
"\n"
"if (wsrpe)\n"
"{\n"
"declare _from_mail varchar;\n"
"_from_mail := get_keyword (\'wsrp-from\',http_map_get (\'soap_opts\'), \'\');\n"
"soap_res := xml_tree_doc (res);\n"
"\n"
"res := xslt (\'http://local.virt/wsrp_resp\', soap_res, vector (\'id\', lower(uuid()), \'relatesTo\', _id, \'action\', _action, \'fwd\', _rev, \'to\', _to, \'from\', _from_mail));\n"
"}\n"
"else\n"
"{\n"
"soap_res := xml_tree_doc (res);\n"
"res := xslt (\'http://local.virt/wsrp_resp\', soap_res, vector (\'routing\', 0, \'b_id\', lower(uuid())));\n"
"}\n"
"\n"
"if (wssec)\n"
"{\n"
"WS_SECURITY_ADD (res, ns);\n"
"if (length (http_pending_req ()) = 1)\n"
"xenc_delete_temp_keys ();\n"
"}\n"
"}\n"
"\n"
"if (registry_get (\'__SOAP_WSRP_LOG\') = \'1\')\n"
"log_message (\'Sending response to: \' || http_client_ip ());\n"
"\n"
"if (isstring (res))\n"
"http (res);\n"
"else\n"
"http_value (res);\n"
"}\n"
"--src soap.sql:542\n"
;

static const char *tbl0 = 
"create table DB.DBA.WS_REFERRALS (\n"
"R_ID  	varchar,\n"
"R_FOR 	varchar,\n"
"R_GO  	long varchar,\n"
"R_EXPIRY 	datetime,\n"
"R_URL	varchar,\n"
"R_STATIC	varchar default NULL,\n"
"primary key (R_ID, R_FOR)\n"
")\n";

static const char *alter0 = 
"alter table DB.DBA.WS_REFERRALS add R_STATIC varchar default NULL\n";

static const char *proc41 = 
"#line 859 \"[executable]/soap.sql\"\n"
"create procedure\n"
"DB.DBA.WS_SOAP_RF_HEADER (in soap_xml any, in lines any, in this_point varchar, in next_hop varchar)\n"
"{\n"
"declare referrals any;\n"
"declare matches any;\n"
"\n"
"if (soap_xml is null)\n"
"return \'\';\n"
"\n"
"referrals := xpath_eval (\'[xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:r=\"http://schemas.xmlsoap.org/ws/2001/10/referral\"] /S:Envelope/S:Header/r:referrals\', soap_xml, 1);\n"
"\n"
"matches := vector ();\n"
"if (referrals is null)\n"
"{\n"
"for select R_ID, R_FOR, R_GO, R_EXPIRY from DB.DBA.WS_REFERRALS where R_URL = this_point and\n"
"(this_point like R_FOR or next_hop like R_FOR)\n"
"and datediff (\'second\', now(), R_EXPIRY) > 0 do\n"
"{\n"
"matches := vector_concat (matches, vector (vector (R_FOR, R_GO, R_ID, R_EXPIRY)));\n"
"}\n"
"goto choose;\n"
"}\n"
"\n"
"\n"
"declare _refs, _ref, _for_pref, _for_exact, _go, _if_ttl, go_via any;\n"
"declare _refid, _if_inv varchar;\n"
"declare len, inx, i, l integer;\n"
"\n"
"_refs := xpath_eval (\'ref[*]\', referrals, 0);\n"
"inx := 0; len := length(_refs);\n"
"\n"
"if (not len)\n"
"return \'\';\n"
"while (inx < len)\n"
"{\n"
"_ref := _refs[inx];\n"
"inx := inx + 1;\n"
"_refid := cast (xpath_eval (\'string(refId)\', _ref, 1) as varchar);\n"
"_if_ttl := cast (xpath_eval (\'string(if/ttl)\', _ref, 1) as integer);\n"
"_if_inv := xpath_eval (\'if/invalidates/rid/text()\', _ref, 0);\n"
"_go := xpath_eval (\'go/via/text()\', _ref, 0);\n"
"_for_pref := xpath_eval (\'for/prefix/text()\', _ref, 0);\n"
"_for_exact := xpath_eval (\'for/exact/text()\', _ref, 0);\n"
"i := 0; l := length (_if_inv);\n"
"while (i < l)\n"
"{\n"
"declare elm varchar;\n"
"elm := cast (_if_inv[i] as varchar);\n"
"delete from WS_REFERRALS where R_ID = elm;\n"
"i := i + 1;\n"
"}\n"
"i := 0; l := length (_go);\n"
"go_via := vector ();\n"
"while (i < l)\n"
"{\n"
"go_via := vector_concat (go_via, vector (cast (_go[i] as varchar)));\n"
"i := i + 1;\n"
"}\n"
"if (i)\n"
"go_via := serialize (go_via);\n"
"else\n"
"go_via := NULL;\n"
"declare expiry datetime;\n"
"_if_ttl := _if_ttl / 1000;\n"
"if (_if_ttl <= 0)\n"
"_if_ttl := 3600*24;\n"
"expiry := dateadd (\'second\', _if_ttl, now());\n"
"declare exit handler for sqlstate \'23000\' {\n"
"rollback work;\n"
"return \'\';\n"
"};\n"
"i := 0; l := length (_for_pref);\n"
"while (go_via is not null and (i < l))\n"
"{\n"
"declare elm varchar;\n"
"elm := cast (_for_pref[i] as varchar);\n"
"elm := concat (elm, \'%\');\n"
"if (this_point like elm)\n"
"{\n"
"matches := vector_concat (matches, vector (vector (elm, go_via, _refid, expiry)));\n"
"\n"
"}\n"
"i := i + 1;\n"
"}\n"
"i := 0; l := length (_for_exact);\n"
"while (go_via is not null and (i < l))\n"
"{\n"
"declare elm varchar;\n"
"elm := cast (_for_exact[i] as varchar);\n"
"if (this_point = elm)\n"
"{\n"
"matches := vector_concat (matches, vector (vector (elm, go_via, _refid, expiry)));\n"
"\n"
"}\n"
"i := i + 1;\n"
"}\n"
"}\n"
"choose:\n"
"commit work;\n"
"i := 0; l := length (matches);\n"
"declare choice any;\n"
"choice := vector (\'\', vector (\'\'));\n"
"while (i < l)\n"
"{\n"
"declare elm any;\n"
"declare via, host varchar;\n"
"elm := matches[i];\n"
"host := elm[0];\n"
"via := deserialize(elm[1]);\n"
"if (length (via) and length (host) > length (choice[0]))\n"
"choice := vector (host, via);\n"
"i := i + 1;\n"
"}\n"
"\n"
"if (choice[0] <> \'\')\n"
"return choice[1][0];\n"
"return \'\';\n"
"}\n"
"--src soap.sql:857\n"
;

static const char *proc42 = 
"#line 979 \"[executable]/soap.sql\"\n"
"create procedure\n"
"DB.DBA.WS_SOAP_RF_MESSAGE (in soap_xml any, in lines any, inout action varchar, inout this_url varchar)\n"
"{\n"
"declare query, queryresp, register, register_resp, refresp, referrals, _for_pref, _for_exact any;\n"
"declare _go, _if, _refid any;\n"
"declare i, l integer;\n"
"query := NULL; queryresp := NULL; register := NULL; register_resp := NULL; refresp := NULL;\n"
"referrals := NULL;\n"
"if (action = \'http://schemas.xmlsoap.org/ws/2001/10/referral#query\')\n"
"query := xpath_eval (\'[xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:r=\"http://schemas.xmlsoap.org/ws/2001/10/referral\"] /S:Envelope/S:Body/r:query\', soap_xml, 1);\n"
"else if (action = \'http://schemas.xmlsoap.org/ws/2001/10/referral#queryResponse\')\n"
"queryresp := xpath_eval (\'[xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:r=\"http://schemas.xmlsoap.org/ws/2001/10/referral\"] /S:Envelope/S:Body/r:queryResponse\', soap_xml, 1);\n"
"else if (action = \'http://schemas.xmlsoap.org/ws/2001/10/referral#register\')\n"
"register := xpath_eval (\'[xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:r=\"http://schemas.xmlsoap.org/ws/2001/10/referral\"] /S:Envelope/S:Body/r:register\', soap_xml, 1);\n"
"else if (action = \'http://schemas.xmlsoap.org/ws/2001/10/referral#registrationResponse\')\n"
"register_resp := xpath_eval (\'[xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:r=\"http://schemas.xmlsoap.org/ws/2001/10/referral\"] /S:Envelope/S:Body/r:registrationResponse\', soap_xml, 1);\n"
"\n"
"if (query is not null or queryresp is not null or register is not null or register_resp is not null)\n"
"{\n"
"delete from WS_REFERRALS where datediff (\'second\', now(), R_EXPIRY) <= 0;\n"
"commit work;\n"
"}\n"
"\n"
"if (query is not null)\n"
"{\n"
"declare ses, _for any;\n"
"declare pt varchar;\n"
"ses := string_output ();\n"
"_for_pref := xpath_eval (\'for/prefix/text()\', query, 0);\n"
"_for_exact := xpath_eval (\'for/exact/text()\', query, 0);\n"
"http (\'<S:Envelope xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\">\', ses);\n"
"http (\'<S:Body xmlns:r=\"http://schemas.xmlsoap.org/ws/2001/10/referral\">\', ses);\n"
"http (\'<r:queryResponse>\', ses);\n"
"\n"
"pt := \'exact\';\n"
"_for := _for_exact;\n"
"again:\n"
"i := 0; l := length (_for);\n"
"while (i < l)\n"
"{\n"
"declare elm, velm varchar;\n"
"declare j, k, ttl integer;\n"
"declare via any;\n"
"elm := cast (_for[i] as varchar);\n"
"for select R_ID, R_FOR, R_GO, R_EXPIRY from WS_REFERRALS where elm like R_FOR and R_URL = this_url do\n"
"{\n"
"ttl := datediff (\'second\', now(), R_EXPIRY);\n"
"ttl := ttl * 1000;\n"
"R_FOR := trim (R_FOR, \'%\');\n"
"http (\'<r:ref>\', ses);\n"
"http (\'<r:for>\', ses);\n"
"http (sprintf (\'<r:%s>%s</r:%s>\', pt, R_FOR, pt), ses);\n"
"http (\'</r:for>\', ses);\n"
"http (\'<r:if>\', ses);\n"
"http (sprintf (\'<r:ttl>%d</r:ttl>\', ttl), ses);\n"
"http (\'</r:if>\', ses);\n"
"via := deserialize (R_GO);\n"
"j := 0; k := length (via);\n"
"http (\'<r:go>\', ses);\n"
"\n"
"while (j < k)\n"
"{\n"
"velm := sprintf (\'<r:via>%s</r:via>\', via[j]);\n"
"http (velm, ses);\n"
"j := j + 1;\n"
"}\n"
"http (\'</r:go>\', ses);\n"
"http (sprintf (\'<r:refId>%s</r:refId>\', R_ID), ses);\n"
"http (\'</r:ref>\', ses);\n"
"}\n"
"i := i + 1;\n"
"}\n"
"if (pt = \'exact\')\n"
"{\n"
"pt := \'prefix\';\n"
"_for := _for_pref;\n"
"goto again;\n"
"}\n"
"http (\'</r:queryResponse>\', ses);\n"
"http (\'</S:Body>\', ses);\n"
"http (\'</S:Envelope>\', ses);\n"
"action := \'http://schemas.xmlsoap.org/ws/2001/10/referral#queryResponse\';\n"
"return string_output_string (ses);\n"
"}\n"
"else if (register is not null or queryresp is not null)\n"
"{\n"
"declare _ref, _refs, go_via, _if_ttl, _if_inv any;\n"
"declare is_reg integer;\n"
"declare inx, len integer;\n"
"is_reg := 1;\n"
"if (register is null)\n"
"{\n"
"is_reg := 0;\n"
"register := queryresp;\n"
"}\n"
"_refs := xpath_eval (\'ref[*]\', register, 0);\n"
"inx := 0; len := length(_refs);\n"
"\n"
"if (not len)\n"
"return NULL;\n"
"\n"
"while (inx < len)\n"
"{\n"
"_ref := _refs[inx];\n"
"inx := inx + 1;\n"
"_refid := cast (xpath_eval (\'string(refId)\', _ref, 1) as varchar);\n"
"_if_ttl := cast (xpath_eval (\'string(if/ttl)\', _ref, 1) as integer);\n"
"_if_inv := xpath_eval (\'if/invalidates/rid/text()\', _ref, 0);\n"
"_go := xpath_eval (\'go/via/text()\', _ref, 0);\n"
"_for_pref := xpath_eval (\'for/prefix/text()\', _ref, 0);\n"
"_for_exact := xpath_eval (\'for/exact/text()\', _ref, 0);\n"
"i := 0; l := length (_if_inv);\n"
"while (i < l)\n"
"{\n"
"declare elm varchar;\n"
"elm := cast (_if_inv[i] as varchar);\n"
"delete from WS_REFERRALS where R_ID = elm;\n"
"i := i + 1;\n"
"}\n"
"i := 0; l := length (_go);\n"
"go_via := vector ();\n"
"while (i < l)\n"
"{\n"
"go_via := vector_concat (go_via, vector (cast (_go[i] as varchar)));\n"
"i := i + 1;\n"
"}\n"
"if (i)\n"
"go_via := serialize (go_via);\n"
"else\n"
"go_via := NULL;\n"
"i := 0; l := length (_for_pref);\n"
"declare expiry datetime;\n"
"_if_ttl := _if_ttl / 1000;\n"
"if (_if_ttl <= 0)\n"
"_if_ttl := 3600*24;\n"
"expiry := dateadd (\'second\', _if_ttl, now());\n"
"declare exit handler for sqlstate \'23000\' {\n"
"rollback work;\n"
"if (is_reg)\n"
"{\n"
"action := \'http://schemas.xmlsoap.org/ws/2001/10/referral#registrationResponse\';\n"
"return (\n"
"\'<S:Envelope xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\">\n"
"<S:Body>\n"
"<S:Fault xmlns:r=\"http://schemas.xmlsoap.org/ws/2001/10/referral\">\n"
"<faultcode>r:registrationFault</faultcode>\n"
"<faultstring>Registration Fault</faultstring>\n"
"<detail>\n"
"<r:duplicate />\n"
"</detail>\n"
"</S:Fault>\n"
"</S:Body>\n"
"</S:Envelope>\');\n"
"}\n"
"return NULL;\n"
"};\n"
"while (go_via is not null and (i < l))\n"
"{\n"
"declare elm varchar;\n"
"elm := cast (_for_pref[i] as varchar);\n"
"elm := concat (elm, \'%\');\n"
"insert into WS_REFERRALS (R_ID, R_FOR, R_GO, R_EXPIRY, R_URL)\n"
"values (_refid, elm, go_via, expiry, this_url);\n"
"i := i + 1;\n"
"}\n"
"i := 0; l := length (_for_exact);\n"
"while (go_via is not null and (i < l))\n"
"{\n"
"declare elm varchar;\n"
"elm := cast (_for_exact[i] as varchar);\n"
"insert into WS_REFERRALS (R_ID, R_FOR, R_GO, R_EXPIRY, R_URL)\n"
"values (_refid, elm, go_via, expiry, this_url);\n"
"i := i + 1;\n"
"}\n"
"}\n"
"\n"
"if (is_reg)\n"
"{\n"
"action := \'http://schemas.xmlsoap.org/ws/2001/10/referral#registrationResponse\';\n"
"return (\'<S:Envelope xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\">\n"
"<S:Body>\n"
"<r:registrationResponse xmlns:r=\"http://schemas.xmlsoap.org/ws/2001/10/referral\"/>\n"
"</S:Body>\n"
"</S:Envelope>\');\n"
"}\n"
"\n"
"}\n"
"\n"
"return NULL;\n"
"}\n"
"--src soap.sql:977\n"
;

static const char *proc43 = 
"#line 1171 \"[executable]/soap.sql\"\n"
"create procedure\n"
"SOAP_LOAD_SCH (in sch varchar, in udts any := null, in \"array\" int := 0, in do_result int := 1)\n"
"{\n"
"declare ents, xte, xt, arr, xarr any;\n"
"declare i, l int;\n"
"declare name, udt, name1, tns1 varchar;\n"
"if (isentity (sch))\n"
"xte := sch;\n"
"else\n"
"xte := xml_tree_doc (sch);\n"
"xt := xslt (\'http://local.virt/soap_import_sch\', xte);\n"
"arr := xpath_eval (\'/complexType|/element|/simpleType|/attribute\', xt, 0);\n"
"l := length (arr);\n"
"if (not \"array\")\n"
"{\n"
"if (do_result)\n"
"result_names (name, udt);\n"
"}\n"
"else\n"
"xarr := make_array (l, \'any\');\n"
"if (isnull (udts))\n"
"udts := vector ();\n"
"while (i < l)\n"
"{\n"
"declare frag, udtn any;\n"
"frag := xml_cut (arr[i]);\n"
"frag := xslt (\'http://local.virt/xslt_copy\', frag);\n"
"name1 := cast(xpath_eval (\'string(/@name)\', frag, 1) as varchar);\n"
"tns1 := cast(xpath_eval (\'string(/@targetNamespace)\', frag, 1) as varchar);\n"
"if (tns1 is not null and tns1 <> \'\')\n"
"name1 := sprintf (\'%s:%s\', tns1, name1);\n"
"udt := null;\n"
"if (not \"array\")\n"
"{\n"
"if (get_keyword (name1, udts, \'\') <> \'\')\n"
"{\n"
"udtn := get_keyword (name1, udts, \'\');\n"
"udt := udtn;\n"
"name := soap_dt_define (\'\', frag, udtn);\n"
"}\n"
"else\n"
"name := soap_dt_define (\'\', frag);\n"
"if (do_result)\n"
"result (name, udt);\n"
"}\n"
"else if (\"array\" < 0)\n"
"{\n"
"aset (xarr, i, frag);\n"
"}\n"
"else\n"
"{\n"
"declare xte1 any;\n"
"\n"
"xte1 := xslt (\'http://local.virt/soap_sch\', frag, vector (\'udt_struct\', 0, \'any_type\', 1));\n"
"aset (xarr, i, xte1);\n"
"}\n"
"i := i + 1;\n"
"}\n"
"return xarr;\n"
"}\n"
"--src soap.sql:1169\n"
;

static const char *proc44 = 
"#line 1234 \"[executable]/soap.sql\"\n"
" create procedure\n"
"DB.DBA.WSDL_SPLIT_NAME (in url varchar, in part int)\n"
"{\n"
"declare pos int;\n"
"declare ret varchar;\n"
"if (not isstring (url))\n"
"return \'\';\n"
"pos := strrchr (url, \':\');\n"
"if (pos is not null)\n"
"{\n"
"if (part)\n"
"{\n"
"ret := substring (url, pos + 2, length (url));\n"
"}\n"
"else\n"
"{\n"
"ret := substring (url, 1, pos);\n"
"}\n"
"}\n"
"else\n"
"return url;\n"
"return ret;\n"
"}\n"
"--src soap.sql:1232\n"
;

static const char *other0 = 
"insert soft DB.DBA.SYS_XPF_EXTENSIONS (XPE_NAME, XPE_PNAME) VALUES (\'http://www.openlinksw.com/wsdl/:split-name\',\n"
"\'DB.DBA.WSDL_SPLIT_NAME\')\n";
static const char *other1 = 
"xpf_extension (\'http://www.openlinksw.com/wsdl/:split-name\', \'DB.DBA.WSDL_SPLIT_NAME\', 0)\n";
static const char *proc45 = 
"#line 1266 \"[executable]/soap.sql\"\n"
"create procedure\n"
"WSDL_IMPORT_TYPES (inout mid any)\n"
"{\n"
"declare xp, tp any;\n"
"declare i, l, inx, len int;\n"
"xp := xpath_eval (\'[ xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" ] //xsd:schema\', mid, 0);\n"
"i := 0; l := length (xp);\n"
"while (i < l)\n"
"{\n"
"declare ent any;\n"
"ent := xml_cut (xp[i]);\n"
"tp := SOAP_LOAD_SCH (ent, null, -1);\n"
"inx := 0; len := length (tp);\n"
"while (inx < len)\n"
"{\n"
"declare elm any;\n"
"declare name1, tns1, name2, is_elem varchar;\n"
"elm := tp[inx];\n"
"name1 := cast(xpath_eval (\'string(/@name)\', elm, 1) as varchar);\n"
"tns1 := cast(xpath_eval (\'string(/@targetNamespace)\', elm, 1) as varchar);\n"
"is_elem := xpath_eval (\'boolean (element)\', elm, 1);\n"
"if (tns1 is not null and tns1 <> \'\')\n"
"name1 := sprintf (\'%s:%s\', tns1, name1);\n"
"if (not exists (select 1 from SYS_SOAP_DATATYPES where SDT_NAME = name1 and SDT_TYPE = is_elem))\n"
"{\n"
"name2 := soap_dt_define (\'\', elm);\n"
"\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"i := i + 1;\n"
"}\n"
"}\n"
"--src soap.sql:1264\n"
;

static const char *proc46 = 
"#line 1301 \"[executable]/soap.sql\"\n"
"create procedure\n"
"EXECUTE_SCRIPT (inout ses any)\n"
"{\n"
"declare cmd, dbg any;\n"
"declare line varchar;\n"
"declare i, is_drop, ctr, offs int;\n"
"commit work;\n"
"cmd := null;\n"
"ctr := 0;\n"
"while (1)\n"
"{\n"
"line := ses_read_line (ses, 0);\n"
"ctr := ctr + 1;\n"
"if (not isstring (line))\n"
"return;\n"
"if (cmd is null and (line like \'create %\' or line like \'drop %\'))\n"
"{\n"
"cmd := string_output ();\n"
"dbg := string_output ();\n"
"is_drop := 0;\n"
"if (line like \'drop %\')\n"
"is_drop := 1;\n"
"i := 1;\n"
"offs := ctr;\n"
"}\n"
"if (rtrim(line) = \';\')\n"
"{\n"
"declare stmt, stat, msg varchar;\n"
"stmt := string_output_string (cmd);\n"
"stat := \'00000\'; msg := \'\';\n"
"exec (stmt, stat, msg);\n"
"if (stat = \'00000\')\n"
"{\n"
"commit work;\n"
"}\n"
"else\n"
"{\n"
"rollback work;\n"
"if (not is_drop)\n"
"{\n"
"log_message (sprintf (\'VSPX: %s %s\',stat, msg));\n"
"dbg_obj_print (string_output_string (dbg));\n"
"}\n"
"if (not (stmt like \'drop %\'))\n"
"signal (stat, concat (msg, sprintf (\'; at offset: %d\', offs), \'\\nwhile executing the following statement:\\n\', stmt));\n"
"}\n"
"cmd := null;\n"
"dbg := null;\n"
"}\n"
"if (cmd is not null)\n"
"{\n"
"http (line, cmd);\n"
"http (\'\\n\', cmd);\n"
"http (sprintf (\'%03d \', i), dbg);\n"
"http (line, dbg);\n"
"http (\'\\n\', dbg);\n"
"i := i + 1;\n"
"}\n"
"}\n"
"return NULL;\n"
"}\n"
"--src soap.sql:1299\n"
;

static const char *proc47 = 
"#line 1364 \"[executable]/soap.sql\"\n"
"create procedure\n"
"WSDL_IMPORT_UDT (in url varchar, in f varchar := null, in exec int := 0)\n"
"{\n"
"declare res, ses, xe, mid any;\n"
"declare resource_text, src varchar;\n"
"\n"
"resource_text := XML_URI_GET (\'\', url);\n"
"xe := xtree_doc (resource_text, 0, url);\n"
"res := xslt (\'http://local.virt/wsdl_expand\', xe);\n"
"\n"
"mid := xslt (\'http://local.virt/wsdl_parts\', res);\n"
"\n"
"\n"
"res := xslt (\'http://local.virt/wsdl_import\', mid, vector (\'wsdlURI\', url));\n"
"ses := string_output ();\n"
"http_value (res, null, ses);\n"
"src := string_output_string (ses);\n"
"\n"
"if (f is not null)\n"
"string_to_file (f, src, -2);\n"
"\n"
"\n"
"WSDL_IMPORT_TYPES (mid);\n"
"\n"
"if (exec)\n"
"EXECUTE_SCRIPT (ses);\n"
"\n"
"return src;\n"
"}\n"
"--src soap.sql:1362\n"
;

static const char *proc48 = 
"#line 1398 \"[executable]/soap.sql\"\n"
" create procedure\n"
"DB.DBA.XML_RPC_GET_PARAM_NAME (in proc varchar, in ordinal int)\n"
"{\n"
"declare pars, proc1 any;\n"
"declare elm any;\n"
"proc1 := __proc_exists (proc);\n"
"if (proc1 is not null)\n"
"pars := procedure_cols (proc1);\n"
"else\n"
"pars := procedure_cols (complete_proc_name (proc,1));\n"
"if (not isarray(pars) or length (pars) < ordinal)\n"
"return \'param\';\n"
"if (pars[0][3] = \'\')\n"
"ordinal := ordinal + 1;\n"
"elm := pars[ordinal - 1];\n"
"return elm[3];\n"
"}\n"
"--src soap.sql:1396\n"
;

static const char *proc49 = 
"#line 1418 \"[executable]/soap.sql\"\n"
" create procedure\n"
"DB.DBA.XML_RPC_MAKE_ELT_NAME (in val varchar)\n"
"{\n"
"if (val like \'[0-9]%\')\n"
"val := \'_\'||val;\n"
"val := sprintf (\'%U\', val);\n"
"val := replace (val, \'/\', \'%2F\');\n"
"val := replace (val, \'%\', \'_x\');\n"
"return val;\n"
"}\n"
"--src soap.sql:1416\n"
;

static const char *other2 = 
"insert soft DB.DBA.SYS_XPF_EXTENSIONS (XPE_NAME, XPE_PNAME)\n"
"VALUES (\'http://www.openlinksw.com/xmlrpc/:getParamName\', \'DB.DBA.XML_RPC_GET_PARAM_NAME\')\n";
static const char *other3 = 
"xpf_extension (\'http://www.openlinksw.com/xmlrpc/:getParamName\', \'DB.DBA.XML_RPC_GET_PARAM_NAME\', 0)\n";
static const char *other4 = 
"insert soft DB.DBA.SYS_XPF_EXTENSIONS (XPE_NAME, XPE_PNAME)\n"
"VALUES (\'http://www.openlinksw.com/xmlrpc/:makeElementName\', \'DB.DBA.XML_RPC_MAKE_ELT_NAME\')\n";
static const char *other5 = 
"xpf_extension (\'http://www.openlinksw.com/xmlrpc/:makeElementName\', \'DB.DBA.XML_RPC_MAKE_ELT_NAME\', 0)\n";
static const char *proc50 = 
"#line 1448 \"[executable]/soap.sql\"\n"
" create procedure DB.DBA.XML_RPC_DATE_CVT (in dt varchar)\n"
"{\n"
"declare ts any;\n"
"if (dt not like \'____-__-__T__:__:__.%\')\n"
"return dt;\n"
"ts := stringdate (dt);\n"
"ts := dt_set_tz (ts, 0);\n"
"return soap_print_box (ts, \'\', 0);\n"
"}\n"
"--src soap.sql:1446\n"
;

static const char *other6 = 
"insert soft DB.DBA.SYS_XPF_EXTENSIONS (XPE_NAME, XPE_PNAME)\n"
"VALUES (\'http://www.openlinksw.com/xmlrpc/:getGMTtime\', \'DB.DBA.XML_RPC_DATE_CVT\')\n";
static const char *other7 = 
"xpf_extension (\'http://www.openlinksw.com/xmlrpc/:getGMTtime\', \'DB.DBA.XML_RPC_DATE_CVT\', 0)\n";
static const char *proc51 = 
"#line 1467 \"[executable]/soap.sql\"\n"
"create procedure\n"
"XMLRPC_MAKE_ERROR (in code varchar, in state varchar, in message varchar)\n"
"{\n"
"return\n"
"\'<?xml version=\"1.0\"?>\\n\' ||\n"
"\'  <methodResponse>\\n\' ||\n"
"\'   <fault>\\n\' ||\n"
"\'    <value>\\n\' ||\n"
"\'      <struct>\\n\' ||\n"
"\'         <member>\\n\' ||\n"
"\'            <name>faultCode</name>\\n\' ||\n"
"\'            <value><int>\' || code || \'</int></value>\\n\' ||\n"
"\'         </member>\\n\' ||\n"
"\'      <member>\\n\' ||\n"
"\'        <name>faultString</name>\\n\' ||\n"
"\'        <value>\\n\' ||\n"
"\'          <string>\' || sprintf (\'%V\', message) ||\'</string>\\n\' ||\n"
"\'        </value>\\n\' ||\n"
"\'      </member>\\n\' ||\n"
"\'    </struct>\\n\' ||\n"
"\'  </value>\\n\' ||\n"
"\'</fault>\\n\' ||\n"
"\'</methodResponse>\' ;\n"
"}\n"
"--src soap.sql:1465\n"
;

static const char *proc52 = 
"#line 1496 \"[executable]/soap.sql\"\n"
" create procedure\n"
"XMLRPC_SERVER (in path any, in params any, in lines any)\n"
"{\n"
"declare content_type, soap_xml varchar;\n"
"declare req_body, resp_body varchar;\n"
"declare soap_req any;\n"
"declare soap_resp any;\n"
"declare result any;\n"
"\n"
"if (length (params) < 1) params := __http_stream_params ();\n"
"\n"
"content_type := http_request_header (lines, \'Content-Type\');\n"
"\n"
"\n"
"if (content_type = \'text/xml\')\n"
"{\n"
"req_body := http_body_read ();\n"
"soap_xml := xml_tree_doc (xml_tree (req_body));\n"
"}\n"
"else\n"
"{\n"
"http_request_status (\'HTTP/1.1 400 Bad request\');\n"
"signal (\'42000\', \'Unsupported media type\');\n"
"}\n"
"\n"
"http_header (\'Content-Type: text/xml; charset=\"utf-8\"\\r\\n\');\n"
"\n"
"set http_charset=\'UTF-8\';\n"
"\n"
"declare exit handler for SQLSTATE \'*\' {\n"
"declare err_msg varchar;\n"
"http_rewrite ();\n"
"rollback work;\n"
"err_msg := xmlrpc_make_error (\'300\', __SQL_STATE, __SQL_MESSAGE);\n"
"if (registry_get (\'__debug_xmlrpc\') = \'1\')\n"
"dbg_obj_print (err_msg);\n"
"http (err_msg);\n"
"resignal \'VSPRT\';\n"
"};\n"
"\n"
"set_user_id (http_map_get (\'soap_uid\'), 0);\n"
"if (registry_get (\'__debug_xmlrpc\') = \'1\')\n"
"dbg_obj_print (\'XML-RPC request:\', soap_xml);\n"
"soap_req := xslt (\'http://local.virt/xmlrpc_soap\', soap_xml);\n"
"\n"
"resp_body := soap_server (soap_req, \'\', lines, 11);\n"
"\n"
"soap_resp := xml_tree_doc (resp_body);\n"
"result := xslt (\'http://local.virt/soap_xmlrpc\', soap_resp);\n"
"if (registry_get (\'__debug_xmlrpc\') = \'1\')\n"
"dbg_obj_print (\'XML-RPC response:\', result);\n"
"http_value (result);\n"
"}\n"
"--src soap.sql:1494\n"
;

static const char *proc53 = 
"#line 1553 \"[executable]/soap.sql\"\n"
"create procedure\n"
"XMLRPC2SOAP (INOUT BODY VARCHAR)\n"
"{\n"
"declare tmp, ret, ses any;\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"signal (\'42000\', \'Not well formed XMLRPC response.\', \'SP036\');\n"
"};\n"
"if (registry_get (\'__debug_xmlrpc\') = \'1\')\n"
"dbg_obj_print (BODY);\n"
"tmp := xml_tree_doc (BODY);\n"
"}\n"
"ret := xslt (\'http://local.virt/xmlrpc_soap\', tmp, vector (\'call\', \'1\'));\n"
"ses := string_output ();\n"
"http_value (ret, null, ses);\n"
"BODY := string_output_string (ses);\n"
"}\n"
"--src soap.sql:1551\n"
;

static const char *proc54 = 
"#line 1573 \"[executable]/soap.sql\"\n"
"create procedure\n"
"SOAP2XMLRPC (INOUT BODY VARCHAR)\n"
"{\n"
"declare tmp, ret, body_str any;\n"
"body_str := string_output_string (BODY);\n"
"if (registry_get (\'__debug_xmlrpc\') = \'1\')\n"
"dbg_obj_print (body_str);\n"
"tmp := xml_tree_doc (body_str);\n"
"ret := xslt (\'http://local.virt/soap_xmlrpc\', tmp, vector (\'call\', \'1\'));\n"
"if (registry_get (\'__debug_xmlrpc\') = \'1\')\n"
"dbg_obj_print (ret);\n"
"string_output_flush (BODY);\n"
"http_value (ret, null, BODY);\n"
"}\n"
"--src soap.sql:1571\n"
;

static const char *proc55 = 
"#line 1592 \"[executable]/soap.sql\"\n"
" create procedure\n"
"XMLRPC_CALL (in uri varchar, in meth varchar, in params any, in id any := null)\n"
"{\n"
"declare i, l int;\n"
"declare pars, ret, hinfo, res any;\n"
"\n"
"l := length (params);\n"
"i := 0;\n"
"pars := vector ();\n"
"\n"
"while (i < l)\n"
"{\n"
"pars := vector_concat (pars, vector (sprintf (\'param%d\', i), params[i]));\n"
"i := i + 1;\n"
"}\n"
"hinfo := rfc1808_parse_uri (uri);\n"
"res := soap_call_new (hinfo[1], hinfo[2], null, meth, pars, 11, null, null, null, 32, null, null, 0, null, null, null, id);\n"
"return res;\n"
"}\n"
"--src soap.sql:1590\n"
;

static const char *proc56 = 
"#line 1614 \"[executable]/soap.sql\"\n"
" create procedure\n"
"SOAP12_ROUTER (in uri varchar, in this_url varchar, in header any, in body any)\n"
"{\n"
"declare req varchar;\n"
"declare resp varchar;\n"
"declare hd, head any;\n"
"declare host varchar;\n"
"declare ss any;\n"
"ss := string_output ();\n"
"\n"
"req := xml_tree_doc (xmlconcat (xml_tree_doc (header), xml_tree_doc (body)));\n"
"req := xslt (\'http://local.virt/soap12_router\', req, vector (\'this\', this_url));\n"
"req := serialize_to_UTF8_xml (req);\n"
"http (req, ss);\n"
"\n"
"hd := rfc1808_parse_uri (uri);\n"
"\n"
"host := hd[1];\n"
"\n"
"head := vector (\n"
"sprintf (\'POST %s HTTP/1.1\\r\\n\', hd[2]),\n"
"\'Content-Type: application/soap+xml; charset=\"utf-8\"\\r\\n\',\n"
"sprintf (\'Content-Length: %d\\r\\n\', length (req))\n"
");\n"
"\n"
"http_proxy (host, head, ss);\n"
"}\n"
"--src soap.sql:1612\n"
;

static const char *proc57 = 
"#line 1643 \"[executable]/soap.sql\"\n"
"create procedure\n"
"DB.DBA.SOAP_WS_TRUST_XENC_TEMPLATE (in body varchar)\n"
"{\n"
"declare tmpl, _user, _pass varchar;\n"
"_user := cast (connection_get (\'__soap_ws_trust_user\') as varchar);\n"
"_pass := cast (connection_get (\'__soap_ws_trust_pass\') as varchar);\n"
"tmpl := sprintf (\'<?xml version=\"1.0\" encoding=\"utf-8\"?><Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2002/07/utility\" xmlns:wsse=\"http://schemas.xmlsoap.org/ws/2002/12/secext\"> <SignedInfo><CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"/><SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#hmac-sha1\"/></SignedInfo><SignatureValue /><KeyInfo><KeyValue><wsse:UsernameToken><wsse:Username>%s</wsse:Username><wsse:Password Type=\"wsse:PasswordText\">%s</wsse:Password></wsse:UsernameToken></KeyValue></KeyInfo></Signature>\', _user, _pass);\n"
"return dsig_template_ext (xtree_doc (body), tmpl,\n"
"\'http://schemas.xmlsoap.org/soap/envelope/\', \'Body\',\n"
"\'http://schemas.xmlsoap.org/ws/2002/07/utility\', \'Expires\',\n"
"\'http://schemas.xmlsoap.org/ws/2002/07/utility\', \'Created\',\n"
"\'http://schemas.xmlsoap.org/ws/2003/03/addressing\', \'To\',\n"
"\'http://schemas.xmlsoap.org/ws/2003/03/addressing\', \'MessageID\',\n"
"\'http://schemas.xmlsoap.org/ws/2003/03/addressing\', \'From\',\n"
"\'http://schemas.xmlsoap.org/ws/2003/03/addressing\', \'Action\');\n"
"}\n"
"--src soap.sql:1641\n"
;

static const char *tbl1 = 
"create table SYS_SOAP_UDT_PUB (SUP_CLASS varchar,\n"
"SUP_LHOST varchar,\n"
"SUP_HOST varchar,\n"
"SUP_END_POINT varchar,\n"
"primary key (SUP_LHOST, SUP_HOST, SUP_END_POINT, SUP_CLASS))\n";

static const char *trig0 = 
"#line 1668 \"[executable]/soap.sql\"\n"
"create trigger HTTP_PATH_D_UDT_PUB after delete on DB.DBA.HTTP_PATH\n"
"{\n"
"delete from SYS_SOAP_UDT_PUB where SUP_LHOST = HP_LISTEN_HOST and\n"
"SUP_HOST = HP_HOST and SUP_END_POINT = HP_LPATH;\n"
"}\n"
"--src soap.sql:1666\n";

static const char *trig1 = 
"#line 1675 \"[executable]/soap.sql\"\n"
"create trigger SOAP_UDT_PUB_I before insert on SYS_SOAP_UDT_PUB\n"
"{\n"
"if (not exists\n"
"(select 1 from DB.DBA.HTTP_PATH\n"
"where SUP_LHOST = HP_LISTEN_HOST and SUP_HOST = HP_HOST and SUP_END_POINT = HP_LPATH\n"
"))\n"
"signal (\'22023\', \'No such virtual directory defined\');\n"
"__soap_udt_publish (SUP_HOST, SUP_LHOST, SUP_END_POINT, SUP_CLASS);\n"
"}\n"
"--src soap.sql:1673\n";

static const char *trig2 = 
"#line 1687 \"[executable]/soap.sql\"\n"
"create trigger SOAP_UDT_PUB_U before update on SYS_SOAP_UDT_PUB referencing old as O, new as N\n"
"{\n"
"__soap_udt_unpublish (O.SUP_HOST, O.SUP_LHOST, O.SUP_END_POINT, O.SUP_CLASS);\n"
"__soap_udt_publish (O.SUP_HOST, O.SUP_LHOST, N.SUP_END_POINT, N.SUP_CLASS);\n"
"}\n"
"--src soap.sql:1685\n";

static const char *trig3 = 
"#line 1695 \"[executable]/soap.sql\"\n"
"create trigger SOAP_UDT_PUB_D before delete on SYS_SOAP_UDT_PUB\n"
"{\n"
"__soap_udt_unpublish (SUP_HOST, SUP_LHOST, SUP_END_POINT, SUP_CLASS);\n"
"}\n"
"--src soap.sql:1693\n";

static const char *proc58 = 
"#line 1702 \"[executable]/soap.sql\"\n"
" create procedure GET_XSD_EXTENSION (in nam varchar)\n"
"{\n"
"declare ext any;\n"
"ext := (select xslt(\'http://local.virt/soap_sch\', xml_tree_doc (sdt_sch)) from sys_soap_datatypes where sdt_name = nam and sdt_type = 0);\n"
"if (ext is null)\n"
"return xml_tree_doc (\'<fake/>\');\n"
"return ext;\n"
"}\n"
"--src soap.sql:1700\n"
;

static const char *other8 = 
"insert soft DB.DBA.SYS_XPF_EXTENSIONS (XPE_NAME, XPE_PNAME) VALUES\n"
"(\'http://www.openlinksw.com/virtuoso/soap:getExtension\', \'DB.DBA.GET_XSD_EXTENSION\')\n";
static const char *other9 = 
"xpf_extension (\'http://www.openlinksw.com/virtuoso/soap:getExtension\', \'DB.DBA.GET_XSD_EXTENSION\', 0)\n";
static const char *proc59 = 
"#line 1721 \"[executable]/soap.sql\"\n"
"create procedure DB.DBA.WS_MIME_ENV (in _all any, in call_mode integer)\n"
"{\n"
"declare _inx, _len integer;\n"
"declare _res, _bnd, _c_type varchar;\n"
"declare _part, temp, hdr any;\n"
"\n"
"_bnd := concat (\'-\',\'-\',\'-\',\'-\', md5 (cast (now () as varchar)));\n"
"\n"
"temp := \'<uuid:\' || uuid () || \'>\';\n"
"temp := \'<\' || uuid () || \'>\';\n"
"\n"
"_c_type := sprintf (\'multipart/related; boundary=\"%s\"; type=\"text/xml\"; start=\"%s\"\', _bnd, temp);\n"
"\n"
"if (call_mode)\n"
"{\n"
"hdr := (concat (\'Content-Type: \', _c_type, \'\\r\\n\'));\n"
"_res := \'\\r\\n\\r\\n\';\n"
"}\n"
"else\n"
"{\n"
"hdr := _c_type;\n"
"_res := \'\';\n"
"}\n"
"\n"
"_inx := 0;\n"
"_len := length (_all);\n"
"\n"
"while (_inx < _len)\n"
"{\n"
"declare c_id, c_type any;\n"
"\n"
"_part := aref (_all, _inx);\n"
"\n"
"if (_inx = 0)\n"
"{\n"
"c_id := temp;\n"
"c_type := \'text/xml\';\n"
"}\n"
"else\n"
"{\n"
"c_id := \'<\' || replace (_part[0], \'cid:\', \'\', 1) || \'>\';\n"
"c_type := _part[1];\n"
"}\n"
"\n"
"_res := concat (_res, \'-\',\'-\', _bnd, \'\\r\\n\');\n"
"_res := concat (_res, \'Content-Type: \', c_type, \'\\r\\n\');\n"
"_res := concat (_res, \'Content-Transfer-Encoding: binary\\r\\n\');\n"
"_res := concat (_res, \'Content-ID: \', c_id, \'\\r\\n\\r\\n\');\n"
"_res := concat (_res, aref (_part, 2), \'\\r\\n\');\n"
"_inx := _inx + 1;\n"
"}\n"
"_res := concat (_res, \'-\',\'-\', _bnd, \'-\',\'-\\r\\n\');\n"
"\n"
"return vector (_res, hdr);\n"
"}\n"
"--src soap.sql:1719\n"
;

static const char *proc60 = 
"#line 1779 \"[executable]/soap.sql\"\n"
"create procedure DB.DBA.WS_MIME_RESP_C (in _all any)\n"
"{\n"
"return DB.DBA.WS_MIME_ENV (_all, 0);\n"
"}\n"
"--src soap.sql:1777\n"
;

static const char *proc61 = 
"#line 1785 \"[executable]/soap.sql\"\n"
"create procedure DB.DBA.WS_MIME_RESP (in _all any)\n"
"{\n"
"return DB.DBA.WS_MIME_ENV (_all, 1);\n"
"}\n"
"--src soap.sql:1783\n"
;

static const char *other10 = 
"grant execute on DB.DBA.WS_MIME_RESP to public\n";
static const char *other11 = 
"grant execute on DB.DBA.WS_MIME_RESP_C to public\n";
static const char *proc62 = 
"#line 1797 \"[executable]/soap.sql\"\n"
"create procedure vsmx_user_check (in name varchar, in pass varchar)\n"
"{\n"
"return 1;\n"
"}\n"
"--src soap.sql:1795\n"
;

static const char *proc63 = 
"#line 1804 \"[executable]/soap.sql\"\n"
" create procedure\n"
"DB.DBA.SOAP_VSMX (in path any, in params any, in lines any)\n"
"{ ?>\n"
"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"\n"
"\"http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd\">\n"
"<HTML>\n"
"<HEAD>\n"
"<STYLE>\n"
"BODY\n"
"{\n"
"MARGIN-TOP: 0px;\n"
"FONT-SIZE: 80%;\n"
"MARGIN-LEFT: 0em;\n"
"COLOR: #000000;\n"
"MARGIN-RIGHT: 0em;\n"
"FONT-FAMILY: Verdana, \'MS Serif\', Serif;\n"
"BACKGROUND-COLOR: #ffffff\n"
"}\n"
".head1\n"
"{\n"
"PADDING-BOTTOM: 5px;\n"
"MARGIN-LEFT: -3em;\n"
"COLOR: #191970;\n"
"LINE-HEIGHT: normal;\n"
"MARGIN-RIGHT: -3em;\n"
"PADDING-TOP: 5px;\n"
"BORDER-BOTTOM: navy thin solid;\n"
"FONT-FAMILY: Verdana, Arial, Helvetica, Lucida, Sans-Serif;\n"
"BACKGROUND-COLOR: skyblue;\n"
"TEXT-ALIGN: right\n"
"}\n"
"DIV.foot\n"
"{\n"
"CLEAR: left;\n"
"BORDER-TOP: lightslategray thin solid;\n"
"FONT-SIZE: 10px;\n"
"LINE-HEIGHT: normal;\n"
"FONT-FAMILY: Verdana, Arial, Helvetica, Lucida, Sans-Serif;\n"
"TEXT-ALIGN: right\n"
"}\n"
"H1\n"
"{\n"
"PADDING-RIGHT: 3em;\n"
"MARGIN-TOP: 5px;\n"
"FONT-SIZE: 185%;\n"
"MARGIN-BOTTOM: 5px;\n"
"MARGIN-LEFT: 0em\n"
"}\n"
"A\n"
"{\n"
"COLOR: blue;\n"
"TEXT-DECORATION: none\n"
"}\n"
"A:hover\n"
"{\n"
"TEXT-DECORATION: underline\n"
"}\n"
".operation\n"
"{\n"
"PADDING-RIGHT: 10px;\n"
"PADDING-LEFT: 30px;\n"
"PADDING-BOTTOM: 10px;\n"
"PADDING-TOP: 10px;\n"
"VERTICAL-ALIGN: top;\n"
"}\n"
".soaplist\n"
"{\n"
"VERTICAL-ALIGN: top;\n"
"PADDING-RIGHT: 5px;\n"
"PADDING-LEFT: 25px;\n"
"PADDING-BOTTOM: 10px;\n"
"MARGIN: 0px;\n"
"WIDTH: 225px;\n"
"PADDING-TOP: 10px;\n"
"BACKGROUND-COLOR: gainsboro\n"
"}\n"
".soapdesc\n"
"{\n"
"FONT-SIZE: 90%;\n"
"FONT-FAMILY: Tahoma\n"
"}\n"
"INPUT\n"
"{\n"
"BORDER-RIGHT: silver 1px solid;\n"
"BORDER-TOP: silver 1px solid;\n"
"BORDER-LEFT: silver 1px solid;\n"
"BORDER-BOTTOM: silver 1px solid;\n"
"FONT-FAMILY: Tahoma\n"
"}\n"
".btns\n"
"{\n"
"TEXT-ALIGN: right\n"
"}\n"
"TABLE.service\n"
"{\n"
"BORDER-RIGHT: #ebebeb 1px solid;\n"
"BORDER-TOP: #ebebeb 1px solid;\n"
"BORDER-LEFT: #ebebeb 1px solid;\n"
"BORDER-BOTTOM: #ebebeb 1px solid;\n"
"FONT-FAMILY: Tahoma\n"
"}\n"
"TH.service\n"
"{\n"
"BACKGROUND-COLOR: silver;\n"
"TEXT-ALIGN: left\n"
"}\n"
"H2\n"
"{\n"
"FONT-SIZE: 150%;\n"
"MARGIN-LEFT: -20px\n"
"}\n"
"H3\n"
"{\n"
"FONT-SIZE: 120%;\n"
"MARGIN-BOTTOM: 0px;\n"
"MARGIN-LEFT: -10px\n"
"}\n"
".soapli\n"
"{\n"
"PADDING-BOTTOM: 5px;\n"
"TEXT-INDENT: -20px\n"
"}\n"
"TD.service\n"
"{\n"
"BACKGROUND-COLOR: #f0f0f0\n"
"}\n"
".response\n"
"{\n"
"BORDER-RIGHT: #f0f0f0 1px solid;\n"
"PADDING-RIGHT: 2px;\n"
"BORDER-TOP: #f0f0f0 1px solid;\n"
"PADDING-LEFT: 2px;\n"
"PADDING-BOTTOM: 2px;\n"
"BORDER-LEFT: #f0f0f0 1px solid;\n"
"PADDING-TOP: 2px;\n"
"BORDER-BOTTOM: #f0f0f0 1px solid\n"
"}\n"
".details\n"
"{\n"
"PADDING-RIGHT: 2px;\n"
"PADDING-LEFT: 30px;\n"
"PADDING-BOTTOM: 2px;\n"
"PADDING-TOP: 10px;\n"
"BACKGROUND-COLOR: #f0f0f0;\n"
"TEXT-ALIGN: left\n"
"}\n"
".level1\n"
"{\n"
"COLOR: blue\n"
"}\n"
".level2\n"
"{\n"
"COLOR: red\n"
"}\n"
".level3\n"
"{\n"
"COLOR: green\n"
"}\n"
".level4\n"
"{\n"
"COLOR: teal\n"
"}\n"
".attribname\n"
"{\n"
"TEXT-ALIGN: right;\n"
"}\n"
".attrib\n"
"{\n"
"COLOR: #990000\n"
"}\n"
"</STYLE>\n"
"<TITLE>Web Service Testing</TITLE>\n"
"</HEAD>\n"
"<BODY>\n"
"<DIV class=\"head1\"><H1>Web Services Test Page (VSMX)</H1></DIV>\n"
"<?vsp\n"
"declare this_page varchar;\n"
"declare wsdl any;\n"
"declare inx, len, _u_id integer;\n"
"this_page := \'services.vsmx\';\n"
"set http_charset=\'UTF-8\';\n"
"http_header (\'Cache-Control: no-cache, must-revalidate\\r\\nPragma: no-cache\\r\\nExpires: Thu, 01 Dec 1994 01:02:03 GMT\\r\\n\');\n"
"\n"
"?>\n"
"<DIV class=\"soappage\">\n"
"<TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\">\n"
"<TR><TD class=\"soaplist\">\n"
"<H2>Services Available</H2>\n"
"<?vsp\n"
"declare xt any;\n"
"wsdl := soap_wsdl();\n"
"if (not (registry_get (\'old_vsmx\') = \'1\') and isstring (file_stat (http_root()||\'/vsmx/oper.vspx\')))\n"
"{\n"
"declare sid any;\n"
"sid := vspx_sid_generate ();\n"
"insert into VSPX_SESSION (VS_REALM, VS_SID, VS_UID, VS_STATE, VS_EXPIRY)\n"
"values (\'vsmx\', sid, null,\n"
"serialize (vector (\'wsdl\', wsdl, \'loc\', WS.WS.EXPAND_URL (HTTP_REQUESTED_URL(),\'services.wsdl\'))),\n"
"now ());\n"
"http_request_status (\'HTTP/1.1 302 Found\');\n"
"http_header (sprintf (\'Location: /vsmx/oper.vspx?sid=%s&realm=vsmx\\r\\n\', sid));\n"
"http_rewrite ();\n"
"return;\n"
"}\n"
"xt := xml_tree_doc (wsdl);\n"
"inx := 0;\n"
"_u_id := (select top 1 U_ID from DB.DBA.SYS_USERS where U_NAME = http_map_get (\'soap_uid\'));\n"
"for select 0 as TP, P_NAME as operation, coalesce (P_TEXT, blob_to_string (P_MORE)) as content\n"
"from DB.DBA.SYS_PROCEDURES where (name_part (P_NAME, 0) = http_map_get (\'soap_qual\')\n"
"and name_part (P_NAME,1) = http_map_get (\'soap_uid\'))\n"
"or exists (select 1 from DB.DBA.SYS_GRANTS where G_USER = _u_id and G_OP = 32 and G_OBJECT = P_NAME)\n"
"\n"
"union select 0 as TP, G_OBJECT as operation, \'\' as content from DB.DBA.SYS_GRANTS where\n"
"G_USER = _u_id and G_OP = 32 and __proc_exists (G_OBJECT) is not null\n"
"and not exists (select 1 from DB.DBA.SYS_PROCEDURES where G_OBJECT = P_NAME)\n"
"\n"
"union select 1 as TP, M_NAME as operation, blob_to_string (M_TEXT) as content\n"
"from DB.DBA.SYS_METHODS, DB.DBA.SYS_USER_TYPES where M_ID = UT_ID and\n"
"exists (select 1 from DB.DBA.SYS_GRANTS where G_USER = _u_id and G_OP = 32 and G_OBJECT = UT_NAME)\n"
"do\n"
"{\n"
"declare comments, title, elm, operation1, q, o varchar;\n"
"\n"
"q := name_part (operation, 0);\n"
"o := name_part (operation, 1);\n"
"\n"
"if (TP = 1)\n"
"operation1 := operation;\n"
"else if ((length (q) + length (o) + 3) < length (operation))\n"
"operation1 := substring (operation, length (q) + length (o) + 3, length (operation));\n"
"else\n"
"goto nxt;\n"
"\n"
"operation := operation1;\n"
"\n"
"elm := xpath_eval (sprintf (\'/definitions/portType/operation[@name = \\\'%s\\\']\', operation), xt);\n"
"if (elm is null)\n"
"goto nxt;\n"
"title := regexp_match (\'--##.*\', content);\n"
"if (title is null)\n"
"title := \'\';\n"
"else\n"
"title := substring (title, 5, length (title));\n"
"?>\n"
"<DIV class=\"soapli\"><A href=\"<?=this_page?>?operation=<?=operation?>\"><?=operation?></A><BR />\n"
"<SPAN class=\"soapdesc\"><?=title?></SPAN></DIV>\n"
"<?vsp\n"
"inx := inx + 1;\n"
"nxt:;\n"
"}\n"
"?>\n"
"</TD>\n"
"<TD class=\"operation\">\n"
"<?vsp\n"
"\n"
"if ({?\'operation\'} is not null )\n"
"{\n"
"declare xe, pars any;\n"
"declare xps, url varchar;\n"
"wsdl := soap_wsdl();\n"
"xe := xml_tree_doc (wsdl);\n"
"if (xpath_eval (sprintf (\'/definitions/binding/operation[@name=\"%s\"]/operation[@style=\"document\"]\', {?\'operation\'}), xe) is null)\n"
"{\n"
"xps := sprintf (\'/definitions/message[@name = \\\'%sRequest\\\']/part\', {?\'operation\'});\n"
"}\n"
"else if (xpath_eval (sprintf (\'/definitions/message[@name = \\\'%sRequest\\\']/part[@name=\"parameters\"]\', {?\'operation\'}), xe) is not null)\n"
"{\n"
"declare elm_name any;\n"
"declare pos int;\n"
"\n"
"xps := sprintf (\'/definitions/message[@name = \\\'%sRequest\\\']/part/@element\', {?\'operation\'});\n"
"elm_name := cast (xpath_eval (xps, xe) as varchar);\n"
"pos := strrchr (elm_name, \':\');\n"
"if (pos is not null)\n"
"{\n"
"elm_name := subseq (elm_name, pos + 1, length (elm_name));\n"
"}\n"
"xps := sprintf (\'/definitions/types/schema/element[@name = \"%s\"]//element\', elm_name);\n"
"}\n"
"else\n"
"{\n"
"xps := sprintf (\'/definitions/message[@name = \\\'%sRequest\\\']/part\', {?\'operation\'});\n"
"}\n"
"\n"
"pars := xpath_eval (xps, xe, 0);\n"
"url := cast (xpath_eval (\'/definitions/service/port/address/@location\', xe, 1) as varchar);\n"
"len := length (pars);\n"
"inx := 0;\n"
"?>\n"
"<H2><?={?\'operation\'}?></H2>\n"
"<H3>Details</H3>\n"
"<P>The service end point is: <?=url?></P>\n"
"<P>The WSDL end point is: <A href=\"<?=url?>/services.wsdl\"><?=url?>/services.wsdl</A></P>\n"
"<H3>Test</H3>\n"
"<FORM method=\"POST\" action=\"<?=this_page?>\">\n"
"<INPUT type=\"hidden\" name=\"operation\" value=\"<?={?\'operation\'}?>\" >\n"
"<INPUT type=\"hidden\" name=\"url\" value=\"<?=url?>\" >\n"
"<TABLE class=\"service\" border=\"0\" cellpadding=\"2\" cellspacing=\"2\">\n"
"<TR>\n"
"<TH class=\"service\">Parameter</TH>\n"
"<TH class=\"service\">Value</TH>\n"
"<TH class=\"service\">Type</TH>\n"
"</TR>\n"
"<?vsp\n"
"while (inx < len)\n"
"{\n"
"declare n, t varchar;\n"
"n := xpath_eval (\'@name\', pars[inx], 1);\n"
"t := xpath_eval (\'@type\', pars[inx], 1);\n"
"n := cast (n as varchar); t := cast (t as varchar);\n"
"if (t like \'http://www.w3.org/____/XMLSchema:%\')\n"
"{\n"
"t := substring (t, length (\'http://www.w3.org/____/XMLSchema:\') + 1, length (t));\n"
"t := concat (\'xsd:\', t);\n"
"}\n"
"else if (strchr (t, \':\') is not null and t not like \'xsd:%\')\n"
"{\n"
"declare colon integer;\n"
"colon := strrchr (t, \':\');\n"
"t := substring (t, colon + 1, length (t));\n"
"t := concat (\'s\', t);\n"
"}\n"
"?>\n"
"<TR>\n"
"<TD class=\"service\"><?=n?></TD>\n"
"<?vsp if (t like \'xsd:%\') { ?>\n"
"<TD class=\"service\"><input type=\"text\" name=\"<?=n?>\" size=\"40\" /></TD>\n"
"<?vsp } else { ?>\n"
"<TD class=\"service\"><textarea name=\"<?=n?>\" rows=10 cols=\"40\"><?vsp\n"
"if (t like \'_:%\' and t not like \'_:ArrayOf%\')\n"
"{\n"
"declare struct, t1 any;\n"
"declare i, l integer;\n"
"t1 := substring (t, 3, length (t));\n"
"xps :=\n"
"sprintf (\'/definitions/types/schema/complexType[@name = \'\'%s\'\']/*/element/@name\', t1);\n"
"struct := xpath_eval (xps, xe, 0);\n"
"i := 0; l := length (struct);\n"
"while (i < l)\n"
"{\n"
"http (cast (struct[i] as varchar));\n"
"http (\'=\\r\\n\');\n"
"i := i + 1;\n"
"}\n"
"}\n"
"?></textarea></TD>\n"
"<?vsp } ?>\n"
"<TD class=\"service\"><SPAN class=\"datatype\"><?=t?></SPAN>\n"
"<input type=\"hidden\" name=\"<?=n?>_type\" value=\"<?=t?>\"></TD>\n"
"</TR>\n"
"<?vsp\n"
"inx := inx + 1;\n"
"}\n"
"if (not inx)\n"
"{\n"
"?>\n"
"<TR><TD class=\"service\" colspan=\"2\">No input parameters are required for this service.</TD></TR>\n"
"<?vsp\n"
"}\n"
"?>\n"
"<TR><TD class=\"btns\" colspan=\"2\"><input type=\"submit\" name=\"callit\" value=\"Invoke\"></TD></TR>\n"
"</TABLE>\n"
"</form>\n"
"<?vsp\n"
"}\n"
"\n"
"if ({?\'operation\'} is not null and {?\'callit\'} is not null)\n"
"{\n"
"declare hinfo, result, ver, pars1, _url any;\n"
"declare xe, xps, pars any;\n"
"wsdl := soap_wsdl();\n"
"xe := xml_tree_doc (wsdl);\n"
"_url := {?\'url\'};\n"
"hinfo := rfc1808_parse_uri ({?\'url\'});\n"
"\n"
"if (xpath_eval (sprintf (\'/definitions/binding/operation[@name=\"%s\"]/operation[@style=\"document\"]\', {?\'operation\'}), xe) is null)\n"
"{\n"
"xps := sprintf (\'/definitions/message[@name = \\\'%sRequest\\\']/part\', {?\'operation\'});\n"
"}\n"
"else if (xpath_eval (sprintf (\'/definitions/message[@name = \\\'%sRequest\\\']/part[@name=\"parameters\"]\', {?\'operation\'}), xe) is not null)\n"
"{\n"
"declare elm_name any;\n"
"declare pos int;\n"
"\n"
"xps := sprintf (\'/definitions/message[@name = \\\'%sRequest\\\']/part/@element\', {?\'operation\'});\n"
"elm_name := cast (xpath_eval (xps, xe) as varchar);\n"
"pos := strrchr (elm_name, \':\');\n"
"if (pos is not null)\n"
"{\n"
"elm_name := subseq (elm_name, pos + 1, length (elm_name));\n"
"}\n"
"xps := sprintf (\'/definitions/types/schema/element[@name = \"%s\"]//element\', elm_name);\n"
"}\n"
"else\n"
"{\n"
"xps := sprintf (\'/definitions/message[@name = \\\'%sRequest\\\']/part\', {?\'operation\'});\n"
"}\n"
"pars := xpath_eval (xps, xe, 0);\n"
"len := length (pars);\n"
"inx := 0;\n"
"pars1 := vector ();\n"
"while (inx < len)\n"
"{\n"
"declare exit handler for sqlstate \'*\' {\n"
"result := xml_tree_doc (sprintf (\'<Error>\n"
"<Code>%V\n"
"</Code>\n"
"<Message>%V\n"
"</Message>\n"
"</Error>\', __SQL_STATE, __SQL_MESSAGE));\n"
"goto err;\n"
"};\n"
"declare n, t, v, va varchar;\n"
"n := xpath_eval (\'@name\', pars[inx], 1);\n"
"t := xpath_eval (\'@type\', pars[inx], 1);\n"
"n := cast (n as varchar); t := cast (t as varchar);\n"
"if (t like \'http://www.w3.org/____/XMLSchema:%\')\n"
"{\n"
"t := substring (t, length (\'http://www.w3.org/____/XMLSchema:\') + 1, length (t));\n"
"t := concat (\'xsd:\', t);\n"
"}\n"
"else if (strchr (t, \':\') is not null and t not like \'xsd:%\')\n"
"{\n"
"declare colon integer;\n"
"colon := strrchr (t, \':\');\n"
"t := substring (t, colon + 1, length (t));\n"
"t := concat (\'s\', t);\n"
"}\n"
"v := get_keyword (n, params);\n"
"if (t like \'_:ArrayOf%\')\n"
"{\n"
"v := replace (v, \'\\r\\n\', \'\\n\');\n"
"va := split_and_decode (v, 0, \'\\0\\0\\n\');\n"
"pars1 := vector_concat (pars1, vector (n, va));\n"
"}\n"
"else if (t like \'_:%\')\n"
"{\n"
"declare r, struct, rstr any;\n"
"declare i, l integer;\n"
"v := replace (v, \'\\r\\n\', \'\\n\');\n"
"va := coalesce (split_and_decode (v, 0, \'\\0\\0\\n=\'), vector ());\n"
"t := substring (t, 3, length (t));\n"
"xps :=\n"
"sprintf (\'/definitions/types/schema/complexType[@name = \'\'%s\'\']/*/element/@name\', t);\n"
"struct := xpath_eval (xps, xe, 0);\n"
"i := 0; l := length (struct);\n"
"rstr := vector (composite(), \'<soap_box_structure>\');\n"
"while (i < l)\n"
"{\n"
"declare part nvarchar;\n"
"part := get_keyword (struct[i], va);\n"
"part := charset_recode (part,\'UTF-8\',\'_WIDE_\');\n"
"rstr := vector_concat (rstr, vector (cast (struct[i] as varchar), part));\n"
"i := i + 1;\n"
"}\n"
"pars1 := vector_concat (pars1, vector (n, rstr));\n"
"}\n"
"else if (t like \'%:dateTime\')\n"
"{\n"
"v := charset_recode (v,\'UTF-8\',\'_WIDE_\');\n"
"v := cast (v as varchar);\n"
"v := cast (v as datetime);\n"
"pars1 := vector_concat (pars1, vector (n, v));\n"
"}\n"
"else\n"
"{\n"
"v := charset_recode (v,\'UTF-8\',\'_WIDE_\');\n"
"pars1 := vector_concat (pars1, vector (n, v));\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"ver := 11;\n"
"{\n"
"declare exit handler for sqlstate \'*\' {\n"
"result := xml_tree_doc (sprintf (\'<Error>\n"
"<Code>%V\n"
"</Code>\n"
"<Message>%V\n"
"</Message>\n"
"</Error>\', __SQL_STATE, __SQL_MESSAGE));\n"
"goto err;\n"
"};\n"
"if (atoi (virtuoso_ini_item_value (\'HTTPServer\', \'ServerThreads\')) < 2)\n"
"{\n"
"result := xml_tree_doc (sprintf (\'<Error>\n"
"<Code>%V\n"
"</Code>\n"
"<Message>%V\n"
"</Message>\n"
"</Error>\', \'42000\', \'At least two HTTP threads must be available\'));\n"
"goto err;\n"
"}\n"
"else\n"
"{\n"
"result := DB.DBA.SOAP_CLIENT (url=>_url, operation=>{?\'operation\'}, parameters=>pars1, version=>ver);\n"
"}\n"
"}\n"
"\n"
"if (ver = 11)\n"
"{\n"
"if (result[0][0] <> \' root\')\n"
"result := vector (vector(\' root\'), result);\n"
"result := xml_tree_doc (result);\n"
"}\n"
"else\n"
"{\n"
"result := xml_tree_doc (sprintf (\'<Error>\n"
"<Code>%V\n"
"</Code>\n"
"<Message>%V\n"
"</Message>\n"
"</Error>\', ver[1], ver[2]));\n"
"}\n"
"err:;\n"
"declare ses any;\n"
"ses := xslt (\'__soap_vsmx\', result, vector (\'service\', {?\'operation\'}));\n"
"http_value (ses);\n"
"}\n"
"\n"
"?>\n"
"</TD></TR></TABLE>\n"
"</DIV>\n"
"<DIV class=\"foot\"><SPAN class=\"foot\">Virtuoso Universal Server <?=sys_stat(\'st_dbms_ver\')?> - Copyright&copy; 1998-2015 OpenLink Software.</SPAN></DIV>\n"
"</BODY>\n"
"</HTML>\n"
"<?vsp\n"
"}\n"
"--src soap.sql:1802\n"
;


static const char *other12 = 
" xslt_sheet (\'__soap_vsmx\', xml_tree_doc(\'<?xml version=\"1.0\"?>\n"
"<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n"
"<xsl:output method=\"html\" indent=\"yes\" encoding=\"UTF-8\" />\n"
"<xsl:param name=\"service\" select=\"\'\'\'\'\" />\n"
"<xsl:param name=\"ret_uri\" select=\"\'\'services.vsmx\'\'\" />\n"
"<xsl:template match=\"/\">\n"
"<H3>Response</H3>\n"
"<BR />\n"
"<DIV class=\"response\"><xsl:apply-templates select=\"*\">\n"
"<xsl:with-param name=\"level\">1</xsl:with-param></xsl:apply-templates></DIV>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\"><xsl:param name=\"level\" />\n"
"<DIV class=\"details\">\n"
"<SPAN><xsl:attribute name=\"class\">level<xsl:value-of select=\"$level\" /></xsl:attribute>\n"
"<xsl:value-of select=\"local-name()\"/>:</SPAN>\n"
"<xsl:if test=\"$level > 1\">\n"
"<SPAN class=\"data\"><xsl:value-of select=\"text()\"/>\n"
"<xsl:if test=\"@*\">\n"
"<BR /><TABLE border=\"0\" cellpadding=\"0\" cellspacing=\"2\">\n"
"<xsl:for-each select=\"@*\">\n"
"<xsl:if test=\"(namespace-uri(.) != \'\'urn:schemas-microsoft-com:datatypes\'\')\n"
"and (namespace-uri(.) != \'\'http://www.w3.org/2001/XMLSchema-instance\'\')\n"
"and (namespace-uri(.) != \'\'http://schemas.xmlsoap.org/soap/encoding/\'\')\n"
"and (namespace-uri(.) != \'\'urn:schemas-openlink-com:xml-sql\'\')\">\n"
"<TR><TD class=\"attribname\"><xsl:value-of select=\"local-name()\" />=</TD>\n"
"<TD class=\"attrib\">\"<xsl:value-of select=\".\" />\"</TD></TR>\n"
"</xsl:if>\n"
"</xsl:for-each>\n"
"</TABLE>\n"
"</xsl:if>\n"
"</SPAN>\n"
"</xsl:if>\n"
"<xsl:apply-templates select=\"*\">\n"
"<xsl:with-param name=\"level\"><xsl:value-of select=\"$level+1\" /></xsl:with-param>\n"
"</xsl:apply-templates>\n"
"</DIV>\n"
"</xsl:template>\n"
"</xsl:stylesheet>\')\n"
")\n";
static const char *proc64 = 
"#line 2377 \"[executable]/soap.sql\"\n"
"create procedure WSDL_EXPAND (in _base_url any, in rsv any, inout schem any, inout defs any, inout ret any)\n"
"{\n"
"declare idx, len, idx1, len1, use_cache integer;\n"
"declare _location, _what varchar;\n"
"declare _new, _import, _base, sch, t1, t2 any;\n"
"\n"
"if (not isarray (schem)) schem := vector ();\n"
"if (not isarray (defs))  defs := vector ();\n"
"if (not rsv is NULL)  _base_url := WS.WS.EXPAND_URL (_base_url, rsv);\n"
"\n"
"use_cache := 0;\n"
"\n"
"_base := WSDL_GET (_base_url, use_cache);\n"
"\n"
"if (rsv is NULL)  ret := _base;\n"
"\n"
"sch := xpath_eval (\'/definitions/import\', _base, 0);\n"
"\n"
"if (length (t1 := xpath_eval (\'/definitions/types/schema\', _base, 0)) > 0) schem := vector_concat (t1, schem);\n"
"if (length (t2 := xpath_eval (\'/definitions\', _base, 0)) > 0) defs := vector_concat (defs, t2);\n"
"\n"
"idx := 0; len := length (sch);\n"
"while (idx < len)\n"
"{\n"
"_location := cast (xpath_eval (\'@location\', sch[idx], 1) as varchar);\n"
"_import := WSDL_GET (WS.WS.EXPAND_URL (_base_url, _location), use_cache);\n"
"_new := xpath_eval (\'/definitions/import\', _import, 0);\n"
"if (length (t1 := xpath_eval (\'/definitions/types/schema\', _import, 0))>0) schem := vector_concat (schem, t1);\n"
"if (length (t2 := xpath_eval (\'/definitions\', _import, 0)) > 0) defs := vector_concat (defs, t2);\n"
"len1 := length (_new); idx1 := 0;\n"
"if (length (_new) > 0)\n"
"{\n"
"while (idx1 < len1)\n"
"{\n"
"_what := cast (xpath_eval (\'@location\', _new[0], 1) as varchar);\n"
"_base_url := WS.WS.EXPAND_URL (_base_url, _location);\n"
"WSDL_EXPAND (_base_url, _what, schem, defs, ret);\n"
"idx1 := idx1 + 1;\n"
"}\n"
"}\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"--src soap.sql:2375\n"
;

static const char *proc65 = 
"#line 2424 \"[executable]/soap.sql\"\n"
" create procedure\n"
"DB.DBA.SOAP_WSDL_IMPORT (in url varchar, in mode_wsdl integer := 1, in wire_dump integer := 0, in drop_module integer := 0)\n"
"{\n"
"declare wsdl, xp, xt, uri, hinfo, sch, ret, pt any;\n"
"declare i, l, i1, l1, is_literal integer;\n"
"declare err, name, tns, mname, stmt, transport varchar;\n"
"declare port_name, port_name_last any;\n"
"declare tt, dmod varchar;\n"
"\n"
"WSDL_EXPAND (url, NULL, sch, pt, wsdl);\n"
"\n"
"i1 := 0; l1 := length (sch);\n"
"while (i1 < l1)\n"
"{\n"
"xp := xpath_eval (\'complexType\', sch[i1], 0);\n"
"tns := xpath_eval (\'@targetNamespace\', sch[i1], 1);\n"
"if (tns is not null)\n"
"{\n"
"tns := cast (tns as varchar);\n"
"tns := concat (tns, \':\');\n"
"}\n"
"else\n"
"tns := \'\';\n"
"\n"
"i := 0; l := length (xp);\n"
"while (i < l)\n"
"{\n"
"xt := xslt (\'http://local.virt/soap_sch\', xp[i]);\n"
"err := xpath_eval (\'string(//@error)\', xt, 1);\n"
"err := cast (err as varchar);\n"
"if (err <> \'\')\n"
"{\n"
"rollback work;\n"
"signal (\'22023\', err, \'SODT1\');\n"
"}\n"
"name := cast(xpath_eval (\'string(/complexType/@name)\', xt, 1) as varchar);\n"
"if (not exists (select 1 from DB.DBA.SYS_SOAP_DATATYPES where SDT_NAME = concat (tns, name) and SDT_TYPE = 0))\n"
"{\n"
"insert soft DB.DBA.SYS_SOAP_DATATYPES (SDT_NAME,SDT_SCH,SDT_TYPE) values (concat(tns, name), xt, 0);\n"
"__soap_dt_define (concat(tns, name), xt);\n"
"}\n"
"i := i + 1;\n"
"}\n"
"xp := xpath_eval (\'element\', sch[i1], 0);\n"
"i := 0; l := length (xp);\n"
"while (i < l)\n"
"{\n"
"xt := xslt (\'http://local.virt/soap_sch\', xp[i], vector (\'target_Namespace\', rtrim(tns, \':\')));\n"
"err := xpath_eval (\'string(//@error)\', xt, 1);\n"
"err := cast (err as varchar);\n"
"if (err <> \'\')\n"
"{\n"
"rollback work;\n"
"signal (\'22023\', err, \'SODT1\');\n"
"}\n"
"name := cast(xpath_eval (\'string(/element/@name)\', xt, 1) as varchar);\n"
"if (not exists (select 1 from DB.DBA.SYS_SOAP_DATATYPES where SDT_NAME = concat (tns, name) and SDT_TYPE = 1))\n"
"{\n"
"insert soft DB.DBA.SYS_SOAP_DATATYPES (SDT_NAME,SDT_SCH,SDT_TYPE) values (concat(tns, name), xt, 1);\n"
"__soap_dt_define (concat(tns, name), xt, NULL, 1);\n"
"}\n"
"\n"
"{\n"
"declare cmpl, cname, cname2,  sch2 varchar;\n"
"cmpl := xpath_eval (sprintf (\'element[%d]/complexType[*]\', (i+1)), sch[i1], 1);\n"
"\n"
"if (cmpl is not null)\n"
"{\n"
"declare name1 varchar;\n"
"name1 := cast(xpath_eval (sprintf (\'string(element[%d]/@name)\' , (i+1)), sch[i1], 1) as varchar);\n"
"cname := sprintf (\'elementType__%s\', name1);\n"
"if (tns is null or tns = \'\')\n"
"cname2 := cname;\n"
"else\n"
"cname2 := sprintf (\'%s%s\', tns, cname);\n"
"sch2 := xslt (\'http://local.virt/soap_sch\', cmpl,\n"
"vector (\'type_name\', cname, \'target_Namespace\', rtrim(tns, \':\')));\n"
"__soap_dt_define (cname2, sch2, sch2, 0);\n"
"insert replacing DB.DBA.SYS_SOAP_DATATYPES (SDT_NAME,SDT_SCH, SDT_TYPE) values (cname2, sch2, 0);\n"
"}\n"
"}\n"
"i := i + 1;\n"
"}\n"
"i1 := i1 + 1;\n"
"}\n"
"declare extens any;\n"
"declare ns_ext nvarchar;\n"
"extens := xpath_eval (\'[xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"] //*[@wsdl:required = \"true\"]\', wsdl, 0);\n"
"i1 := 0; l1 := length (extens);\n"
"while (i1 < l1)\n"
"{\n"
"ns_ext := xpath_eval (\'namespace-uri(.)\', extens[i1], 1);\n"
"if (ns_ext <> N\'http://schemas.xmlsoap.org/wsdl/soap/\')\n"
"{\n"
"rollback work;\n"
"signal (\'22023\', \'Not supported extensibility element\', \'SODT2\');\n"
"}\n"
"i1 := i1 + 1;\n"
"}\n"
"\n"
"\n"
"mname := cast (xpath_eval (\'/definitions/service/@name\', wsdl, 1) as varchar);\n"
"uri := cast (xpath_eval (\'[xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\"] /definitions/service/port/soap:address/@location\', wsdl, 1) as varchar);\n"
"hinfo := rfc1808_parse_uri (uri);\n"
"\n"
"stmt := concat (\'CREATE MODULE \', DB.DBA.SYS_ALFANUM_NAME (mname), \' {\\r\\n\');\n"
"dmod := concat (\'DROP MODULE \', DB.DBA.SYS_ALFANUM_NAME (mname));\n"
"ret := vector (mname);\n"
"i1 := 0; l1 := length (pt);\n"
"while (i1 < l1)\n"
"{\n"
"if (not port_name is NULL or port_name <> 0) port_name_last := port_name;\n"
"port_name := cast (xpath_eval (\'/definitions/portType/@name\', pt[i1], 1) as varchar);\n"
"if (port_name is NULL) goto new_loop;\n"
"if ((port_name_last <> port_name) and\n"
"(port_name_last <> \'0\') and\n"
"(port_name_last <> 0) and\n"
"(not port_name_last is NULL))\n"
"port_name := port_name_last;\n"
"tt := sprintf (\'[xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\"] /definitions/binding[@type like \'\'%s\'\']/soap:binding/@transport\', concat (\'%\', port_name));\n"
"if (transport := FIND_WSDL (pt, tt) is NULL) goto new_loop;\n"
"tt := sprintf (\'/definitions/portType[@name like \'\'%s\'\']/operation\', port_name);\n"
"xp := xpath_eval (tt, pt[i1], 0);\n"
"i := 0; l := length (xp);\n"
"while (i < l)\n"
"{\n"
"declare i_message, o_message, i_parm, o_parm any;\n"
"declare o_name, o_ns, soap_action, _ins, _out varchar;\n"
"declare colon, j, k integer;\n"
"declare ppars, res_pars varchar;\n"
"declare encoded any;\n"
"\n"
"o_name := cast (xpath_eval (\'@name\', xp[i], 1) as varchar);\n"
"\n"
"i_message := cast (xpath_eval (\'input/@message\', xp[i], 1) as varchar);\n"
"o_message := cast (xpath_eval (\'output/@message\', xp[i], 1) as varchar);\n"
"\n"
"colon := strrchr (i_message, \':\');\n"
"if (colon is not null)\n"
"i_message := substring (i_message, colon+2, length (i_message));\n"
"colon := strrchr (o_message, \':\');\n"
"if (colon is not null)\n"
"o_message := substring (o_message, colon+2, length (o_message));\n"
"\n"
"tt := sprintf (\'/definitions/message[@name like \'\'%s\'\']/part\', concat (\'%\', i_message));\n"
"i_parm := FIND_WSDL(pt ,tt);\n"
"\n"
"tt := sprintf (\'/definitions/message[@name like \'\'%s\'\']/part\', concat (\'%\', o_message));\n"
"o_parm := FIND_WSDL(pt ,tt);\n"
"\n"
"ppars := \'\'; res_pars := vector ();\n"
"_ins := \'\'; _out := \'\';\n"
"\n"
"\n"
"\n"
"declare have_in_par integer;\n"
"j := 0; k := length (i_parm); have_in_par := 0;\n"
"is_literal := 0;\n"
"while (j < k)\n"
"{\n"
"declare par, typ varchar;\n"
"par := cast (xpath_eval (\'@name\', i_parm[j]) as varchar);\n"
"typ := cast (xpath_eval (\'@type\', i_parm[j]) as varchar);\n"
"if (typ is NULL)\n"
"{\n"
"typ := cast (xpath_eval (\'@element\', i_parm[j]) as varchar);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"is_literal := 1;\n"
"}\n"
"if (j > 0)\n"
"{\n"
"_ins := concat (_ins, \',\');\n"
"ppars := concat (ppars, \',\');\n"
"}\n"
"_ins := concat (_ins, \'IN _\', par, \' any __soap_type \'\'\',typ ,\'\'\'\');\n"
"ppars := concat (ppars, sprintf (\'vector(\'\'%s\'\', \'\'%s\'\'), _\', par, typ), par);\n"
"res_pars := vector_concat (res_pars, vector (concat (\'_\', par), typ));\n"
"j := j + 1;\n"
"}\n"
"have_in_par := j;\n"
"\n"
"\n"
"\n"
"j := 0; k := length (o_parm);\n"
"while (j < k)\n"
"{\n"
"declare par, typ varchar;\n"
"par := cast (xpath_eval (\'@name\', o_parm[j]) as varchar);\n"
"typ := cast (xpath_eval (\'@type\', o_parm[j]) as varchar);\n"
"if (j > 0 or have_in_par > 0)\n"
"{\n"
"_out := concat (_out, \',\');\n"
"}\n"
"_out := concat (_out, \'OUT _\', par ,\' any __soap_type \'\'\',typ ,\'\'\'\');\n"
"\n"
"j := j + 1;\n"
"}\n"
"\n"
"stmt := concat (stmt, \'\\r\\n PROCEDURE \', o_name, \' (\', _ins);\n"
"\n"
"ret := vector_concat (ret, vector(o_name, res_pars));\n"
"o_ns := cast (xpath_eval (\n"
"sprintf (\'/definitions/binding/operation[@name = \'\'%s\'\']/input/body/@namespace\',\n"
"o_name), wsdl, 1) as varchar);\n"
"soap_action :=\n"
"cast (xpath_eval (\n"
"sprintf (\'/definitions/binding/operation[@name = \'\'%s\'\']/operation/@soapAction\',\n"
"o_name), wsdl, 1) as varchar);\n"
"\n"
"encoded := cast (xpath_eval (\n"
"sprintf (\'[xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\"] /definitions/binding/operation[@name = \'\'%s\'\']/input/soap:body/@use\',\n"
"o_name), wsdl, 1) as varchar);\n"
"\n"
"if (encoded is not null and encoded = \'literal\')\n"
"{\n"
"encoded := 1;\n"
"is_literal := 1;\n"
"}\n"
"else\n"
"encoded := 0;\n"
"\n"
"if (wire_dump)\n"
"encoded := encoded + 2;\n"
"\n"
"if (soap_action is null or soap_action = \'\')\n"
"{\n"
"soap_action := \'\"\"\';\n"
"}\n"
"else\n"
"{\n"
"soap_action := concat (\'\"\',trim (soap_action, \'\" \'),\'\"\');\n"
"}\n"
"\n"
"if (length (o_ns))\n"
"o_ns := sprintf (\'\'\'%s\'\'\', o_ns);\n"
"else\n"
"o_ns := \'NULL\';\n"
"\n"
"soap_action := sprintf (\'\'\'%s\'\'\', soap_action);\n"
"\n"
"if (not mode_wsdl)\n"
"stmt := concat (stmt, _out);\n"
"\n"
"if (is_literal)\n"
"stmt := concat (stmt, \') \\n returns any __soap_doc \'\'__VOID__\'\'\\n\');\n"
"else\n"
"stmt := concat (stmt, \') \\n returns any __soap_type \'\'__VOID__\'\'\\n\');\n"
"\n"
"if (mode_wsdl)\n"
"{\n"
"stmt := concat (stmt, \'{\\n  declare res, ver any;\\n  ver:=11;\\n  \');\n"
"stmt := concat (stmt,\n"
"sprintf (\'res := soap_call_new (\'\'%s\'\',\'\'%s\'\',\\n    %s, \'\'%s\'\', vector (%s), ver, NULL, NULL, %s, %d);\\n\',\n"
"hinfo[1], hinfo[2], o_ns, o_name, ppars, soap_action, encoded));\n"
"stmt := concat (stmt, \'  if (ver <> 11) signal (ver[1], ver[2]); \\r\\n return res; };  \');\n"
"}\n"
"else\n"
"{\n"
"stmt := concat (stmt, \'{ \\n declare ret any; \\n return ret; \\n} ;\\n\');\n"
"}\n"
"\n"
"i := i + 1;\n"
"}\n"
"new_loop:\n"
"i1 := i1 + 1;\n"
"}\n"
"stmt := concat (stmt, \'  \\r\\n} \\n\');\n"
"\n"
"if (length (stmt) > 7)\n"
"{\n"
"if (drop_module)\n"
"{\n"
"declare st1, ms1 varchar;\n"
"st1 := \'00000\';\n"
"exec (dmod, st1, ms1);\n"
"}\n"
"DB.DBA.EXEC_STMT (stmt, 0);\n"
"}\n"
"else\n"
"ret := NULL;\n"
"return ret;\n"
"}\n"
"--src soap.sql:2422\n"
;

static const char *proc66 = 
"#line 2712 \"[executable]/soap.sql\"\n"
"create procedure FIND_WSDL (in _all any, in _what varchar)\n"
"{\n"
"declare idx, len integer;\n"
"declare ret any;\n"
"\n"
"len := length (_all);\n"
"idx := 0;\n"
"\n"
"while (idx < len)\n"
"{\n"
"ret := xpath_eval (_what, _all[idx], 0);\n"
"if (length (ret) > 0)\n"
"return ret;\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"return NULL;\n"
"}\n"
"--src soap.sql:2710\n"
;

static const char *proc67 = 
"#line 2733 \"[executable]/soap.sql\"\n"
"create procedure WSDL_GET (in uri varchar, in _mode integer)\n"
"{\n"
"declare _hdr, _ret any;\n"
"\n"
"\n"
"_ret := xml_uri_get (uri, \'\');\n"
"_ret := xml_tree_doc (_ret);\n"
"return _ret;\n"
"}\n"
"--src soap.sql:2731\n"
;

/* wsrp_ultim.xsl */

static const char *xsl3[]= {
"<?xml version=\"1.0\"?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\"\n"
"    xmlns:SOAP=\"http://schemas.xmlsoap.org/soap/envelope/\"\n"
"    xmlns:rp=\"http://schemas.xmlsoap.org/rp\"\n"
"    xmlns:wss04=\"http://schemas.xmlsoap.org/ws/2002/04/secext\"\n"
"    xmlns:wss07=\"http://schemas.xmlsoap.org/ws/2002/07/secext\"\n"
"    xmlns:wss=\"http://schemas.xmlsoap.org/ws/2002/12/secext\"\n"
"    xmlns:wsso=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\"\n"
"    xmlns:util=\"http://schemas.xmlsoap.org/ws/2002/07/utility\">\n"
"<xsl:output method=\"xml\" indent=\"yes\" omit-xml-declaration=\"yes\"/>\n"
"\n"
"  <xsl:template match=\"rp:path|wss04:Security|wss07:Security|wss:Security|wsso:Security|util:Timestamp\" />\n"
"\n"
"  <xsl:template match=\"*\">\n"
"    <xsl:copy>\n"
"      <xsl:copy-of select=\"@*\" />\n"
"      <xsl:apply-templates />\n"
"    </xsl:copy>\n"
"  </xsl:template>\n"
"\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
"\n"
,
 NULL };

/* wsrp_resp.xsl */

static const char *xsl4[]= {
"<?xml version=\"1.0\"?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\"\n"
"    xmlns:SOAP=\"http://schemas.xmlsoap.org/soap/envelope/\"\n"
"    xmlns:rp=\"http://schemas.xmlsoap.org/rp\"\n"
"    xmlns:wss=\"http://schemas.xmlsoap.org/ws/2002/12/secext\"\n"
"    xmlns:wsse=\"http://schemas.xmlsoap.org/ws/2002/12/secext\"\n"
"    xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2003/03/addressing\"\n"
"    xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2002/07/utility\"\n"
"    xmlns:wsuoasis=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"\n"
"    >\n"
"<xsl:output method=\"xml\" indent=\"yes\" omit-xml-declaration=\"yes\"/>\n"
"\n"
"  <xsl:param name=\"action\" />\n"
"  <xsl:param name=\"fwd\" />\n"
"  <xsl:param name=\"id\" />\n"
"  <xsl:param name=\"to\" />\n"
"  <xsl:param name=\"from\" />\n"
"  <xsl:param name=\"relatesTo\" />\n"
"  <xsl:param name=\"routing\" select=\"1\" />\n"
"  <xsl:param name=\"b_id\" />\n"
"  <xsl:param name=\"wsu\" select=\"'http://schemas.xmlsoap.org/ws/2002/07/utility'\"/>\n"
"\n"
"  <xsl:template match=\"/\">\n"
"    <xsl:apply-templates select=\"*\" />\n"
"  </xsl:template>\n"
"\n"
"  <xsl:template match=\"SOAP:Envelope\">\n"
"    <xsl:copy>\n"
"      <xsl:copy-of select=\"@*\" />\n"
"        <xsl:choose>\n"
"	<xsl:when test=\"not SOAP:Header and boolean($routing)\">\n"
"	  <SOAP:Header>\n"
"	    <rp:path  SOAP:actor=\"http://schemas.xmlsoap.org/soap/actor/next\" SOAP:mustUnderstand=\"1\">\n"
"	      <rp:action><xsl:value-of select=\"$action\" /></rp:action>\n"
"	      <rp:id>uuid:<xsl:value-of select=\"$id\" /></rp:id>\n"
"	      <rp:relatesTo><xsl:value-of select=\"$relatesTo\" /></rp:relatesTo>\n"
"	      <rp:fwd>\n"
"	      <xsl:if test=\"$fwd\">\n"
"		<xsl:copy-of select=\"$fwd/via\" />\n"
"	      </xsl:if>\n"
"	      </rp:fwd>\n"
"	      <rp:rev>\n"
"		<rp:via><xsl:value-of select=\"$to\" /></rp:via>\n"
"	      </rp:rev>\n"
"	      <rp:from><xsl:value-of select=\"$from\" /></rp:from>\n"
"	    </rp:path>\n"
"	  </SOAP:Header>\n"
"	</xsl:when>\n"
"	<xsl:when test=\"not boolean($routing) and not SOAP:Header\">\n"
"	  <SOAP:Header />\n"
"	</xsl:when>\n"
"	</xsl:choose>\n"
"      <xsl:apply-templates select=\"node()\" />\n"
"    </xsl:copy>\n"
"  </xsl:template>\n"
"\n"
"  <xsl:template match=\"SOAP:Header\">\n"
"    <xsl:copy>\n"
"      <xsl:copy-of select=\"@*\" />\n"
"	<xsl:if test=\"boolean($routing)\" >\n"
"        <rp:path  SOAP:actor=\"http://schemas.xmlsoap.org/soap/actor/next\" SOAP:mustUnderstand=\"1\">\n"
"	  <rp:action><xsl:value-of select=\"$action\" /></rp:action>\n"
"	  <rp:id>uuid:<xsl:value-of select=\"$id\" /></rp:id>\n"
"	  <rp:relatesTo><xsl:value-of select=\"$relatesTo\" /></rp:relatesTo>\n"
"	  <rp:fwd>\n"
"	    <xsl:if test=\"$fwd\">\n"
"	    <xsl:copy-of select=\"$fwd/via\" />\n"
"	    </xsl:if>\n"
"	  </rp:fwd>\n"
"	  <rp:rev>\n"
"	    <rp:via><xsl:value-of select=\"$to\" /></rp:via>\n"
"	  </rp:rev>\n"
"	  <rp:from><xsl:value-of select=\"$from\" /></rp:from>\n"
"	</rp:path>\n"
"	</xsl:if>\n"
"      <xsl:apply-templates select=\"node()\" />\n"
"    </xsl:copy>\n"
"  </xsl:template>\n"
"\n"
"  <xsl:template match=\"rp:path\"></xsl:template>\n"
"\n"
"  <xsl:template match=\"SOAP:Body[not @wsu:Id and not @wsuoasis:Id]\">\n"
"    <xsl:copy>\n"
"      <xsl:copy-of select=\"@*\" />\n"
"      <xsl:attribute name=\"Id\" namespace=\"{$wsu}\">Id-<xsl:value-of select=\"$b_id\" /></xsl:attribute>\n"
"     <xsl:apply-templates select=\"*\"/>\n"
"    </xsl:copy>\n"
"  </xsl:template>\n"
"\n"
"  <xsl:template match=\"*\">\n"
"    <xsl:copy>\n"
"      <xsl:copy-of select=\"@*\" />\n"
"      <xsl:copy-of select=\"*\" />\n"
"    </xsl:copy>\n"
"  </xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* wsrp_interm.xsl */

static const char *xsl5[]= {
"<?xml version=\"1.0\"?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\"\n"
"    xmlns:SOAP=\"http://schemas.xmlsoap.org/soap/envelope/\"\n"
"    xmlns:rp=\"http://schemas.xmlsoap.org/rp\">\n"
"<xsl:output method=\"xml\" indent=\"yes\" omit-xml-declaration=\"yes\"/>\n"
"<xsl:param name=\"newrev\" />\n"
"<xsl:param name=\"newfwd\" />\n"
"  <xsl:template match=\"/\">\n"
"    <xsl:apply-templates select=\"*\" />\n"
"  </xsl:template>\n"
"\n"
"  <xsl:template match=\"SOAP:Envelope\">\n"
"   <SOAP:Envelope>\n"
"    <xsl:copy-of select=\"@*\" />\n"
"    <xsl:apply-templates select=\"*\" />\n"
"   </SOAP:Envelope>\n"
"  </xsl:template>\n"
"\n"
"  <xsl:template match=\"SOAP:Body\">\n"
"   <SOAP:Body>\n"
"    <xsl:copy-of select=\"@*\" />\n"
"    <xsl:copy-of select=\"*\" />\n"
"   </SOAP:Body>\n"
"  </xsl:template>\n"
"\n"
"  <xsl:template match=\"SOAP:Header\">\n"
"   <SOAP:Header>\n"
"   <xsl:copy-of select=\"@*\" />\n"
"   <xsl:for-each select=\"*\">\n"
"     <xsl:choose>\n"
"       <xsl:when test=\"name(.) = 'http://schemas.xmlsoap.org/rp:path'\">\n"
"         <rp:path>\n"
"	   <xsl:apply-templates select=\".\" />\n"
"         </rp:path>\n"
"       </xsl:when>\n"
"       <xsl:otherwise>\n"
"         <xsl:copy-of select=\".\" />\n"
"       </xsl:otherwise>\n"
"     </xsl:choose>\n"
"   </xsl:for-each>\n"
"   </SOAP:Header>\n"
"  </xsl:template>\n"
"\n"
"  <xsl:template match=\"rp:path\">\n"
"   <xsl:copy-of select=\"@*\" />\n"
"   <xsl:for-each select=\"*\">\n"
"     <xsl:choose>\n"
"       <xsl:when test=\"name(.) = 'http://schemas.xmlsoap.org/rp:fwd'\">\n"
"         <rp:fwd>\n"
"	   <xsl:if test=\"$newfwd != ''\">\n"
"	     <rp:via><xsl:value-of select=\"$newfwd\" /></rp:via>\n"
"	   </xsl:if>\n"
"	   <xsl:for-each select=\"via\">\n"
" 	     <xsl:if test=\"position(.) > 1\">\n"
"	       <xsl:copy-of select=\".\" />\n"
"	      </xsl:if>\n"
"	   </xsl:for-each>\n"
"         </rp:fwd>\n"
"       </xsl:when>\n"
"       <xsl:when test=\"name(.) = 'http://schemas.xmlsoap.org/rp:rev'\">\n"
"         <rp:rev>\n"
"	   <rp:via><xsl:value-of select=\"$newrev\" /></rp:via>\n"
"	   <xsl:copy-of select=\"via\" />\n"
"         </rp:rev>\n"
"       </xsl:when>\n"
"       <xsl:otherwise>\n"
"         <xsl:copy-of select=\".\" />\n"
"       </xsl:otherwise>\n"
"     </xsl:choose>\n"
"   </xsl:for-each>\n"
"  </xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* wsrp_error.xsl */

static const char *xsl6[]= {
"<?xml version=\"1.0\"?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\"\n"
"    xmlns:SOAP=\"http://schemas.xmlsoap.org/soap/envelope/\"\n"
"    xmlns:n0=\"http://schemas.xmlsoap.org/soap/envelope/\"\n"
"    xmlns:rp=\"http://schemas.xmlsoap.org/rp\">\n"
"<xsl:output method=\"xml\" indent=\"yes\" omit-xml-declaration=\"yes\"/>\n"
"<xsl:param name=\"newrev\" />\n"
"  <xsl:template match=\"/\">\n"
"    <xsl:apply-templates select=\"*\" />\n"
"  </xsl:template>\n"
"\n"
"  <xsl:template match=\"SOAP:Envelope\">\n"
"   <SOAP:Envelope>\n"
"    <xsl:apply-templates select=\"*\" />\n"
"   </SOAP:Envelope>\n"
"  </xsl:template>\n"
"\n"
"  <xsl:template match=\"SOAP:Body\">\n"
"   <SOAP:Body>\n"
"     <SOAP:Fault>\n"
"       <SOAP:faultcode>n0:Client</SOAP:faultcode>\n"
"       <SOAP:faultstring>Client Error</SOAP:faultstring>\n"
"       <SOAP:faultactor></SOAP:faultactor>\n"
"     </SOAP:Fault>\n"
"   </SOAP:Body>\n"
"  </xsl:template>\n"
"\n"
"  <xsl:template match=\"SOAP:Header\">\n"
"   <SOAP:Header>\n"
"   <xsl:choose>\n"
"   <xsl:when test=\"rp:path\">\n"
"   <xsl:for-each select=\"*\">\n"
"       <xsl:if test=\"name(.) = 'http://schemas.xmlsoap.org/rp:path'\">\n"
"         <rp:path>\n"
"	   <xsl:apply-templates select=\".\" />\n"
"	   <rp:fault>\n"
"	     <rp:code><xsl:value-of select=\"$code\" /></rp:code>\n"
"	     <rp:reason><xsl:value-of select=\"$reason\" /></rp:reason>\n"
"	     <rp:endpoint><xsl:value-of select=\"$endpoint\" /></rp:endpoint>\n"
"           </rp:fault>\n"
"         </rp:path>\n"
"       </xsl:if>\n"
"   </xsl:for-each>\n"
"   </xsl:when>\n"
"   <xsl:otherwise>\n"
"         <rp:path>\n"
"           <rp:fwd>\n"
"  	     <rp:via />\n"
"           </rp:fwd>\n"
"	   <rp:rev>\n"
"	   </rp:rev>\n"
"	   <rp:fault>\n"
"	     <rp:code><xsl:value-of select=\"$code\" /></rp:code>\n"
"	     <rp:reason><xsl:value-of select=\"$reason\" /></rp:reason>\n"
"	     <rp:endpoint><xsl:value-of select=\"$endpoint\" /></rp:endpoint>\n"
"           </rp:fault>\n"
"         </rp:path>\n"
"   </xsl:otherwise>\n"
"   </xsl:choose>\n"
"   </SOAP:Header>\n"
"  </xsl:template>\n"
"\n"
"  <xsl:template match=\"rp:path\">\n"
"   <xsl:copy-of select=\"@*\" />\n"
"   <xsl:for-each select=\"*\">\n"
"     <xsl:choose>\n"
"       <xsl:when test=\"name(.) = 'http://schemas.xmlsoap.org/rp:fwd'\">\n"
"         <rp:fwd>\n"
"	   <rp:via />\n"
"         </rp:fwd>\n"
"       </xsl:when>\n"
"       <xsl:when test=\"name(.) = 'http://schemas.xmlsoap.org/rp:rev'\">\n"
"         <rp:rev>\n"
"         </rp:rev>\n"
"       </xsl:when>\n"
"       <xsl:when test=\"name(.) = 'http://schemas.xmlsoap.org/rp:id'\">\n"
"         <rp:relatesTo><xsl:value-of select=\".\" /></rp:relatesTo>\n"
"         <rp:id>uuid:<xsl:value-of select=\"$id\" /></rp:id>\n"
"       </xsl:when>\n"
"     </xsl:choose>\n"
"   </xsl:for-each>\n"
"  </xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* soap_sch.xsl */

static const char *xsl7[]= {
"<?xml version=\"1.0\"?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\"\n"
"    xmlns:enc=\"http://schemas.xmlsoap.org/soap/encoding/\"\n"
"    xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"\n"
"    xmlns=\"http://www.w3.org/2001/XMLSchema\"\n"
"    xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n"
"    xmlns:vi=\"http://www.openlinksw.com/wsdl/\"\n"
"    xmlns:vs=\"http://www.openlinksw.com/virtuoso/soap\"\n"
"    >\n"
"  <xsl:output method=\"xml\" omit-xml-declaration=\"yes\" indent=\"yes\" encoding=\"UTF-8\"/>\n"
"  <xsl:param name=\"type_name\" select=\"''\"/>\n"
"  <xsl:param name=\"udt_struct\" select=\"0\"/>\n"
"  <xsl:param name=\"target_Namespace\" select=\"''\"/>\n"
"  <xsl:param name=\"any_type\" select=\"0\"/>\n"
"  <xsl:template match=\"/\">\n"
"    <xsl:apply-templates select=\"*\"/>\n"
"  </xsl:template>\n"
"  <xsl:template match=\"schema\">\n"
"    <xsl:apply-templates select=\"*\"/>\n"
"  </xsl:template>\n"
"  <xsl:template match=\"complexType\">\n"
"    <complexType>\n"
"      <xsl:choose>\n"
"        <xsl:when test=\"@name != ''\">\n"
"          <xsl:attribute name=\"name\"><xsl:value-of select=\"@name\"/></xsl:attribute>\n"
"        </xsl:when>\n"
"        <xsl:otherwise>\n"
"          <xsl:attribute name=\"name\"><xsl:value-of select=\"$type_name\"/></xsl:attribute>\n"
"        </xsl:otherwise>\n"
"      </xsl:choose>\n"
"      <!-- keep the targetNamespace -->\n"
"      <xsl:attribute name=\"targetNamespace\"><xsl:value-of select=\"@targetNamespace\"/></xsl:attribute>\n"
"      <xsl:choose>\n"
"        <xsl:when test=\"not boolean ($udt_struct) and (count (child::*/child::*/sequence/element) &lt;= 1 or starts-with(@name,'ArrayOf') or count (child::*/element) &lt;= 1)\">\n"
"          <xsl:apply-templates select=\"complexContent|simpleContent\">\n"
"            <xsl:with-param name=\"min\">0</xsl:with-param>\n"
"          </xsl:apply-templates>\n"
"        </xsl:when>\n"
"        <xsl:otherwise>\n"
"          <xsl:apply-templates select=\"complexContent|simpleContent\">\n"
"            <xsl:with-param name=\"min\">1</xsl:with-param>\n"
"          </xsl:apply-templates>\n"
"        </xsl:otherwise>\n"
"      </xsl:choose>\n"
"      <xsl:apply-templates select=\"group\">\n"
"        <xsl:with-param name=\"min\">1</xsl:with-param>\n"
"      </xsl:apply-templates>\n"
"      <xsl:choose>\n"
"        <xsl:when test=\"count (sequence/element) &lt;= 1 and not boolean ($udt_struct)\">\n"
"          <xsl:apply-templates select=\"sequence\">\n"
"            <xsl:with-param name=\"min\">0</xsl:with-param>\n"
"            <xsl:with-param name=\"cmpc\">1</xsl:with-param>\n"
"            <xsl:with-param name=\"attr\">\n"
"              <xsl:copy-of select=\"attribute\"/>\n"
"            </xsl:with-param>\n"
"            <xsl:with-param name=\"ext\">\n"
"              <xsl:value-of select=\"count(attribute)\"/>\n"
"            </xsl:with-param>\n"
"          </xsl:apply-templates>\n"
"        </xsl:when>\n"
"        <xsl:otherwise>\n"
"          <xsl:apply-templates select=\"sequence\">\n"
"            <xsl:with-param name=\"min\">1</xsl:with-param>\n"
"            <xsl:with-param name=\"cmpc\">1</xsl:with-param>\n"
"            <xsl:with-param name=\"attr\">\n"
"              <xsl:copy-of select=\"attribute|anyAttribute\"/>\n"
"            </xsl:with-param>\n"
"            <xsl:with-param name=\"ext\">\n"
"              <xsl:value-of select=\"count(attribute|anyAttribute)\"/>\n"
"            </xsl:with-param>\n"
"          </xsl:apply-templates>\n"
"        </xsl:otherwise>\n"
"      </xsl:choose>\n"
"      <xsl:if test=\"choice\">\n"
"        <complexContent>\n"
"	  <restriction base=\"enc:Struct\">\n"
"	    <xsl:attribute name=\"choice\">1</xsl:attribute>\n"
"            <xsl:apply-templates select=\"choice\">\n"
"              <xsl:with-param name=\"min\">1</xsl:with-param>\n"
"            </xsl:apply-templates>\n"
"	  </restriction>\n"
"	</complexContent>\n"
"      </xsl:if>\n"
"      <xsl:apply-templates select=\"all\">\n"
"        <xsl:with-param name=\"min\">1</xsl:with-param>\n"
"      </xsl:apply-templates>\n"
"      <xsl:if test=\"attribute and not local-name(*) != 'attribute'\">\n"
"	  <simpleContent>\n"
"	      <extension base=\"string\">\n"
"		  <xsl:apply-templates select=\"attribute\" />\n"
"	      </extension>\n"
"	  </simpleContent>\n"
"      </xsl:if>\n"
"    </complexType>\n"
"  </xsl:template>\n"
"  <xsl:template match=\"complexContent\">\n"
"    <complexContent>\n"
"      <xsl:apply-templates select=\"restriction\">\n"
"        <xsl:with-param name=\"min\">\n"
"          <xsl:value-of select=\"$min\"/>\n"
"        </xsl:with-param>\n"
"      </xsl:apply-templates>\n"
"      <xsl:apply-templates select=\"extension\">\n"
"        <xsl:with-param name=\"min\">\n"
"          <xsl:value-of select=\"$min\"/>\n"
"        </xsl:with-param>\n"
"      </xsl:apply-templates>\n"
"      <xsl:if test=\"count(sequence)>0\">\n"
"        <sequence error=\"The 'sequence' element is not supported as child of complexContent\"/>\n"
"      </xsl:if>\n"
"    </complexContent>\n"
"  </xsl:template>\n"
"  <xsl:template match=\"any\">\n"
"    <element type=\"__XML__\" name=\"\" minOccurs=\"0\" maxOccurs=\"unbounded\" />\n"
"    <!--any error=\"The 'any' element is not supported\"/-->\n"
"  </xsl:template>\n"
"  <xsl:template match=\"simpleContent\">\n"
"    <xsl:copy-of select=\".\"/>\n"
"    <!--complexContent>\n"
"  <xsl:apply-templates select=\"restriction\">\n"
"     <xsl:with-param name=\"min\"><xsl:value-of select=\"$min\" /></xsl:with-param>\n"
"  </xsl:apply-templates>\n"
"  <xsl:apply-templates select=\"extension\">\n"
"     <xsl:with-param name=\"min\"><xsl:value-of select=\"$min\" /></xsl:with-param>\n"
"  </xsl:apply-templates>\n"
"</complexContent-->\n"
"  </xsl:template>\n"
"  <xsl:template match=\"extension|restriction\" mode=\"simple\">\n"
"  <xsl:copy>\n"
"    <xsl:copy-of select=\"@*\" />\n"
"    <xsl:attribute name=\"enumeration\"><xsl:value-of select=\"boolean(enumeration)\" /></xsl:attribute>\n"
"    <xsl:copy-of select=\"*\" />\n"
"  </xsl:copy>\n"
"  </xsl:template>\n"
"  <xsl:template match=\"*\" mode=\"simple\">\n"
"  </xsl:template>\n"
"  <xsl:template match=\"simpleType\">\n"
"    <complexType>\n"
"      <xsl:attribute name=\"name\"><xsl:value-of select=\"@name\"/></xsl:attribute>\n"
"      <simpleContent>\n"
"        <xsl:apply-templates select=\"extension|restriction\" mode=\"simple\" />\n"
"      </simpleContent>\n"
"    </complexType>\n"
"  </xsl:template>\n"
"  <xsl:template match=\"group\">\n"
"    <group error=\"The 'group' element is not supported\"/>\n"
"  </xsl:template>\n"
"  <xsl:template match=\"choice\">\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"parent::sequence\">\n"
"        <xsl:apply-templates select=\"element|any\" />\n"
"      </xsl:when>\n"
"      <xsl:otherwise>\n"
"        <sequence>\n"
"	  <xsl:apply-templates select=\"element|any\" />\n"
"        <!--choice error=\"The 'choice' element is not supported\"/-->\n"
"	</sequence>\n"
"      </xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:template>\n"
"  <xsl:template match=\"restriction\">\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"count(sequence/element|attribute)>0\">\n"
"        <restriction base=\"enc:Struct\">\n"
"          <xsl:if test=\"$min!=1\">\n"
"            <xsl:attribute name=\"base\"><xsl:value-of select=\"@base\"/></xsl:attribute>\n"
"          </xsl:if>\n"
"          <xsl:choose>\n"
"            <xsl:when test=\"sequence/element\">\n"
"              <xsl:apply-templates select=\"sequence\">\n"
"                <xsl:with-param name=\"min\">\n"
"                  <xsl:value-of select=\"$min\"/>\n"
"                </xsl:with-param>\n"
"              </xsl:apply-templates>\n"
"            </xsl:when>\n"
"            <xsl:when test=\"attribute/@arrayType\">\n"
"              <sequence>\n"
"                <element name=\"item\" type=\"\" minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"                  <xsl:attribute name=\"type\"><xsl:value-of select=\"normalize-space(translate(attribute/@arrayType,'[]','  '))\"/></xsl:attribute>\n"
"                </element>\n"
"              </sequence>\n"
"            </xsl:when>\n"
"          </xsl:choose>\n"
"          <xsl:if test=\"attribute/@arrayType\">\n"
"	      <attribute ref=\"enc:arrayType\" wsdl:arrayType=\"\">\n"
"		  <xsl:attribute name=\"wsdl:arrayType\"><xsl:value-of select=\"attribute/@arrayType\"/></xsl:attribute>\n"
"	      </attribute>\n"
"          </xsl:if>\n"
"          <xsl:if test=\"not(attribute/@arrayType) and $min=0 and @base\">\n"
"            <attribute ref=\"enc:arrayType\">\n"
"              <xsl:attribute name=\"wsdl:arrayType\"><xsl:value-of select=\"sequence/element[1]/@type\"/><xsl:text>[]</xsl:text></xsl:attribute>\n"
"            </attribute>\n"
"          </xsl:if>\n"
"        </restriction>\n"
"      </xsl:when>\n"
"      <xsl:otherwise>\n"
"        <xsl:if test=\"@base\">\n"
"          <restriction base=\"enc:Struct\">\n"
"            <sequence>\n"
"              <element name=\"item\" type=\"\">\n"
"                <xsl:attribute name=\"type\"><xsl:value-of select=\"@base\"/></xsl:attribute>\n"
"              </element>\n"
"            </sequence>\n"
"          </restriction>\n"
"        </xsl:if>\n"
"        <xsl:if test=\"not (@base)\">\n"
"          <sequence>\n"
"            <element error=\"No sequence/element defined or base attribute supplied\"/>\n"
"          </sequence>\n"
"        </xsl:if>\n"
"      </xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:template>\n"
"  <xsl:template match=\"extension\">\n"
"    <xsl:choose>\n"
"	<xsl:when test=\"not boolean ($udt_struct)\">\n"
"	    <xsl:choose>\n"
"		<xsl:when test=\"contains (@base, ':')\">\n"
"		    <xsl:variable name=\"ext\" select=\"vs:getExtension (@base)\"/>\n"
"		</xsl:when>\n"
"		<xsl:otherwise>\n"
"		    <xsl:variable name=\"ext\" select=\"vs:getExtension (concat(ancestor-or-self::*/@targetNamespace,':',@base))\"/>\n"
"		</xsl:otherwise>\n"
"            </xsl:choose> 		\n"
"	  <xsl:choose>\n"
"	      <xsl:when test=\"$ext//xs:element or xs:sequence/xs:element\">\n"
"	  <restriction base=\"enc:Struct\">\n"
"	      <sequence>\n"
"		  <xsl:apply-templates select=\"$ext//xs:element\">\n"
"		      <xsl:with-param name=\"namespace\" select=\"concat($ext/*/@targetNamespace,':',$ext/*/@name)\"/>\n"
"		  </xsl:apply-templates>\n"
"		  <xsl:apply-templates select=\"xs:sequence/*\"/>\n"
"	      </sequence>\n"
"	  </restriction>\n"
"      </xsl:when>\n"
"	      <xsl:when test=\"$ext//xs:simpleContent\">\n"
"		  <restriction base=\"enc:Struct\">\n"
"		      <xsl:apply-templates select=\"$ext//xs:simpleContent/xs:attribute\"/>\n"
"		      <xsl:apply-templates select=\"xs:attribute\"/>\n"
"		  </restriction>\n"
"	      </xsl:when>\n"
"	      <xsl:otherwise>\n"
"		  <xsl:message terminate=\"no\"><xsl:copy-of select=\"vs:getExtension (@base)\"/></xsl:message>\n"
"		  <extension>\n"
"		      <xsl:attribute name=\"error\">The 'extension' element [<xsl:value-of select=\"@base\"/>] can not be found when expanding <xsl:value-of select=\"ancestor::*[@name]/@name\"/></xsl:attribute>\n"
"		  </extension>\n"
"	      </xsl:otherwise>\n"
"	  </xsl:choose>\n"
"      </xsl:when>\n"
"      <xsl:otherwise>\n"
"        <xsl:copy>\n"
"          <xsl:copy-of select=\"@*\"/>\n"
"          <xsl:apply-templates select=\"node()\">\n"
"            <xsl:with-param name=\"min\">1</xsl:with-param>\n"
"          </xsl:apply-templates>\n"
"        </xsl:copy>\n"
"      </xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:template>\n"
"  <xsl:template match=\"attribute\">\n"
"      <xsl:choose>\n"
"	  <xsl:when test=\"@arrayType\">\n"
"	      <attribute ref=\"enc:arrayType\" wsdl:arrayType=\"\">\n"
"		  <xsl:attribute name=\"wsdl:arrayType\"><xsl:value-of select=\"@arrayType\"/></xsl:attribute>\n"
"	      </attribute>\n"
"	  </xsl:when>\n"
"	  <xsl:when test=\"@ref\">\n"
"	      <xsl:copy>\n"
"		  <xsl:attribute name=\"name\"><xsl:value-of select=\"vi:split-name(@ref, 1)\"/></xsl:attribute>\n"
"		  <xsl:attribute name=\"type\">string</xsl:attribute>\n"
"	      </xsl:copy>\n"
"	  </xsl:when>\n"
"	  <xsl:when test=\"@type and @name\">\n"
"	      <xsl:copy-of select=\".|@*\"/>\n"
"	  </xsl:when>\n"
"      </xsl:choose>\n"
"  </xsl:template>\n"
"  <xsl:template match=\"sequence\">\n"
"    <xsl:param name=\"min\" select=\"0\"/>\n"
"    <xsl:param name=\"cmpc\" select=\"''\"/>\n"
"    <xsl:param name=\"ext\" select=\"0\"/>\n"
"    <xsl:param name=\"attr\" select=\"''\"/>\n"
"    <xsl:if test=\"$cmpc!=''\">\n"
"      <xsl:if test=\"$ext='0'\">\n"
"        <complexContent>\n"
"          <restriction base=\"enc:Struct\">\n"
"            <xsl:attribute name=\"base\"><xsl:choose><xsl:when test=\"count(element) > 1 or boolean($udt_struct) or choice\">http://schemas.xmlsoap.org/soap/encoding/:Struct</xsl:when><xsl:otherwise>http://schemas.xmlsoap.org/soap/encoding/:Array</xsl:otherwise></xsl:choose></xsl:attribute>\n"
"	    <xsl:if test=\"choice\">\n"
"	      <xsl:attribute name=\"choice\">1</xsl:attribute>\n"
"	    </xsl:if>\n"
"            <sequence>\n"
"              <xsl:apply-templates select=\"element|any|choice\">\n"
"                <xsl:with-param name=\"min\">\n"
"                  <xsl:value-of select=\"$min\"/>\n"
"                </xsl:with-param>\n"
"              </xsl:apply-templates>\n"
"            </sequence>\n"
"          </restriction>\n"
"        </complexContent>\n"
"      </xsl:if>\n"
"      <xsl:if test=\"$ext!='0'\">\n"
"        <complexContent>\n"
"          <extension base=\"enc:Struct\">\n"
"            <sequence>\n"
"              <xsl:apply-templates select=\"element|any|choice\">\n"
"                <xsl:with-param name=\"min\">\n"
"                  <xsl:value-of select=\"$min\"/>\n"
"                </xsl:with-param>\n"
"              </xsl:apply-templates>\n"
"            </sequence>\n"
"            <xsl:copy-of select=\"$attr\"/>\n"
"          </extension>\n"
"        </complexContent>\n"
"      </xsl:if>\n"
"    </xsl:if>\n"
"    <xsl:if test=\"$cmpc=''\">\n"
"      <sequence>\n"
"        <xsl:apply-templates select=\"element|any|choice\">\n"
"          <xsl:with-param name=\"min\">\n"
"            <xsl:value-of select=\"$min\"/>\n"
"          </xsl:with-param>\n"
"        </xsl:apply-templates>\n"
"      </sequence>\n"
"    </xsl:if>\n"
"  </xsl:template>\n"
"  <xsl:template match=\"element\">\n"
"    <xsl:param name=\"min\" select=\"0\"/>\n"
"    <xsl:param name=\"namespace\" select=\"''\"/>\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"complexType\">\n"
"        <element>\n"
"          <xsl:copy-of select=\"@*\"/>\n"
"	  <xsl:choose>\n"
"	  <xsl:when test=\"$any_type and complexType/sequence/any\" >\n"
"	  <xsl:attribute name=\"type\">__ANY__</xsl:attribute>\n"
"	  </xsl:when>\n"
"          <xsl:when test=\"complexType\">\n"
"            <xsl:choose>\n"
"              <xsl:when test=\"@targetNamespace != ''\">\n"
"                <xsl:attribute name=\"type\"><xsl:value-of select=\"@targetNamespace\"/>:elementType__<xsl:value-of select=\"@name\"/></xsl:attribute>\n"
"              </xsl:when>\n"
"              <xsl:otherwise>\n"
"                <xsl:attribute name=\"targetNamespace\"><xsl:value-of select=\"$target_Namespace\"/></xsl:attribute>\n"
"                <xsl:attribute name=\"type\"><xsl:value-of select=\"$target_Namespace\"/>:elementType__<xsl:value-of select=\"@name\"/></xsl:attribute>\n"
"              </xsl:otherwise>\n"
"            </xsl:choose>\n"
"          </xsl:when>\n"
"	  </xsl:choose>\n"
"        </element>\n"
"      </xsl:when>\n"
"      <xsl:when test=\"simpleType/restriction[@base]\">\n"
"        <element>\n"
"	    <xsl:copy-of select=\"@*\"/>\n"
"	    <xsl:attribute name=\"type\"><xsl:value-of select=\"simpleType/restriction/@base\"/></xsl:attribute>\n"
"        </element>\n"
"      </xsl:when>\n"
"      <xsl:otherwise>\n"
"        <element>\n"
"	  <xsl:choose>\n"
"	    <xsl:when test=\"boolean (@ref)\">\n"
"	      <xsl:attribute name=\"ref\"><xsl:value-of select=\"@ref\"/></xsl:attribute>\n"
"	    </xsl:when>\n"
"	    <xsl:otherwise>\n"
"              <xsl:attribute name=\"name\"><xsl:value-of select=\"@name\"/></xsl:attribute>\n"
"	      <xsl:choose>\n"
"	        <xsl:when test=\"boolean(@type)\">\n"
"                  <xsl:attribute name=\"type\"><xsl:value-of select=\"@type\"/></xsl:attribute>\n"
"		</xsl:when>\n"
"		<xsl:otherwise>\n"
"                  <xsl:attribute name=\"type\">__ANY__</xsl:attribute>\n"
"		</xsl:otherwise>\n"
"	      </xsl:choose>\n"
"	    </xsl:otherwise>\n"
"	  </xsl:choose>\n"
"          <xsl:if test=\"@form\">\n"
"            <xsl:attribute name=\"form\"><xsl:value-of select=\"@form\"/></xsl:attribute>\n"
"	  </xsl:if>\n"
"	  <xsl:attribute name=\"nillable\"><xsl:value-of select=\"boolean(@nillable = 1 or @nillable = 'true')\"/></xsl:attribute>\n"
"	  <xsl:copy-of select=\"@minOccurs\"/>\n"
"	  <xsl:copy-of select=\"@maxOccurs\"/>\n"
"	  <xsl:if test=\"not @minOccurs\">\n"
"	      <xsl:choose>\n"
"		  <xsl:when test=\"parent::*[@minOccurs]\">\n"
"		      <xsl:copy-of select=\"parent::*/@minOccurs\"/>\n"
"		  </xsl:when>\n"
"		  <xsl:when test=\"ancestor::*[@base='http://schemas.xmlsoap.org/soap/encoding/:Array']\">\n"
"		      <xsl:attribute name=\"minOccurs\">0</xsl:attribute>\n"
"		  </xsl:when>\n"
"		  <xsl:otherwise>\n"
"		      <xsl:attribute name=\"minOccurs\">1</xsl:attribute>\n"
"		  </xsl:otherwise>\n"
"	      </xsl:choose>\n"
"	  </xsl:if>\n"
"	  <xsl:if test=\"not @maxOccurs\">\n"
"	      <xsl:choose>\n"
"		  <xsl:when test=\"parent::*[@maxOccurs]\">\n"
"		      <xsl:copy-of select=\"parent::*/@maxOccurs\"/>\n"
"		  </xsl:when>\n"
"		  <xsl:when test=\"ancestor::*[@base='http://schemas.xmlsoap.org/soap/encoding/:Array']\">\n"
"		      <xsl:attribute name=\"maxOccurs\">unbounded</xsl:attribute>\n"
"		  </xsl:when>\n"
"		  <xsl:otherwise>\n"
"		      <xsl:attribute name=\"maxOccurs\">1</xsl:attribute>\n"
"		  </xsl:otherwise>\n"
"	      </xsl:choose>\n"
"	  </xsl:if>\n"
"          <xsl:if test=\"./child::*\">\n"
"	      <xsl:attribute name=\"error\">The definitions cannot be implied</xsl:attribute>\n"
"	  </xsl:if>\n"
"	  <xsl:if test=\"$namespace != ''\">\n"
"	      <xsl:attribute name=\"namespace\"><xsl:value-of select=\"$namespace\"/></xsl:attribute>\n"
"	  </xsl:if>\n"
"        </element>\n"
"      </xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:template>\n"
"  <xsl:template match=\"all\">\n"
"    <complexContent>\n"
"      <restriction base=\"enc:Struct\">\n"
"        <sequence>\n"
"          <xsl:apply-templates select=\"element|any\">\n"
"            <xsl:with-param name=\"min\">\n"
"              <xsl:value-of select=\"$min\"/>\n"
"            </xsl:with-param>\n"
"          </xsl:apply-templates>\n"
"        </sequence>\n"
"      </restriction>\n"
"    </complexContent>\n"
"  </xsl:template>\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* soap_import_sch.xsl */

static const char *xsl8[]= {
"<?xml version=\"1.0\"?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\"\n"
"	xmlns:types=\"http://soapinterop.org/attachments/xsd\"\n"
"	xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n"
"	xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\"\n"
"	xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"\n"
"	xmlns:dime=\"http://schemas.xmlsoap.org/ws/2002/04/dime/wsdl/\"\n"
"	xmlns:content=\"http://schemas.xmlsoap.org/ws/2002/04/content-type/\"\n"
"	xmlns:ref=\"http://schemas.xmlsoap.org/ws/2002/04/reference/\">\n"
"  <xsl:output method=\"xml\" indent=\"yes\" omit-xml-declaration=\"yes\"/>\n"
"\n"
"  <xsl:param name=\"tns\" select=\"//xsd:schema/@targetNamespace\"/>\n"
"\n"
"  <xsl:template match=\"/\">\n"
"    <xsl:apply-templates select=\"*\" />\n"
"  </xsl:template>\n"
"\n"
"  <xsl:template match=\"xsd:schema\">\n"
"      <xsl:apply-templates select=\"xsd:complexType[not xsd:complexContent/xsd:extension]|xsd:simpleType|xsd:element|xsd:attribute\" />\n"
"      <xsl:apply-templates select=\"xsd:complexType[xsd:complexContent/xsd:extension]\" />\n"
"  </xsl:template>\n"
"\n"
"  <xsl:template match=\"xsd:complexType|xsd:simpleType|xsd:element|xsd:attribute\">\n"
"    <xsl:copy>\n"
"      <xsl:copy-of select=\"@*\"/>\n"
"      <xsl:attribute name=\"targetNamespace\"><xsl:value-of select=\"$tns\"/></xsl:attribute>\n"
"      <xsl:apply-templates select=\"*\" mode=\"inside_type\" />\n"
"    </xsl:copy>\n"
"  </xsl:template>\n"
"\n"
"  <xsl:template match=\"xsd:annotation[not xsd:appinfo]|xsd:documentation\" mode=\"inside_type\"/>\n"
"\n"
"  <xsl:template match=\"*\" mode=\"inside_type\">\n"
"    <xsl:copy>\n"
"      <xsl:copy-of select=\"@*\" />\n"
"      <xsl:apply-templates select=\"*\" mode=\"inside_type\" />\n"
"    </xsl:copy>\n"
"  </xsl:template>\n"
"\n"
"  <xsl:template match=\"*\"/>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* wsdl_expand.xsl */

static const char *xsl9[]= {
"<?xml version='1.0'?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n"
"     version=\"1.0\"\n"
"     xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"\n"
"     xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n"
"     xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\"\n"
"     xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\"\n"
"     xmlns:pl=\"http://schemas.xmlsoap.org/ws/2003/05/partner-link/\"\n"
"     >\n"
"\n"
"<xsl:output method=\"xml\" omit-xml-declaration=\"no\" indent=\"yes\" />\n"
"\n"
"<xsl:template match=\"/\">\n"
"<wsdl:definitions>\n"
"    <xsl:attribute name=\"targetNamespace\"><xsl:value-of select=\"descendant-or-self::wsdl:definitions/@targetNamespace\" /></xsl:attribute>\n"
"    <wsdl:types>\n"
"	<xsl:apply-templates select=\"//xsd:schema\" mode=\"xsd\"/>\n"
"	<xsl:apply-templates select=\"//wsdl:import\" mode=\"xsd\"/>\n"
"    </wsdl:types>\n"
"    <xsl:apply-templates select=\"node()\" />\n"
"</wsdl:definitions>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"wsdl:import\">\n"
"    <xsl:param name=\"topns\" />\n"
"    <xsl:choose>\n"
"	<xsl:when test=\"$topns != ''\">\n"
"	    <xsl:variable name=\"ns\" select=\"$topns\"/>\n"
"	</xsl:when>\n"
"	<xsl:when test=\"@namespace\">\n"
"	    <xsl:variable name=\"ns\" select=\"@namespace\"/>\n"
"	</xsl:when>\n"
"	<xsl:otherwise>\n"
"	    <xsl:variable name=\"ns\" select=\"ancestor::wsdl:definitions/@targetNamespace\"/>\n"
"	</xsl:otherwise>\n"
"    </xsl:choose>\n"
"    <xsl:choose>\n"
"	<xsl:when test=\"@namespace\">\n"
"	    <xsl:variable name=\"ns1\" select=\"@namespace\"/>\n"
"	</xsl:when>\n"
"	<xsl:otherwise>\n"
"	    <xsl:variable name=\"ns1\" select=\"ancestor::wsdl:definitions/@targetNamespace\"/>\n"
"	</xsl:otherwise>\n"
"    </xsl:choose>\n"
"    <xsl:variable name=\"doc\" select=\"document (@location)\"/>\n"
"    <xsl:apply-templates select=\"$doc/*[@targetNamespace = $ns]\" >\n"
"	<xsl:with-param name=\"topns\" select=\"$ns\" />\n"
"    </xsl:apply-templates>\n"
"    <xsl:apply-templates select=\"$doc//wsdl:import\" >\n"
"	<xsl:with-param name=\"topns\" select=\"$ns1\" />\n"
"    </xsl:apply-templates>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"wsdl:definitions\">\n"
"<xsl:param name=\"topns\" />\n"
"    <xsl:apply-templates select=\"node()\" >\n"
"      <xsl:with-param name=\"topns\" select=\"$topns\" />\n"
"    </xsl:apply-templates>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"wsdl:portType|wsdl:binding|wsdl:message\">\n"
"    <xsl:variable name=\"tns\" select=\"ancestor::wsdl:definitions/@targetNamespace\"/>\n"
"    <xsl:variable name=\"localname\" select=\"@name\"/>\n"
"    <xsl:copy>\n"
"      <xsl:copy-of select=\"@*\" />\n"
"      <xsl:attribute name=\"name\"><xsl:value-of select=\"concat ($tns,':',$localname)\" /></xsl:attribute>\n"
"      <xsl:apply-templates select=\"node()\" />\n"
"    </xsl:copy>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"pl:*\">\n"
"    <xsl:copy>\n"
"	<xsl:for-each select=\"@*\">\n"
"	    <xsl:attribute name=\"{local-name()}\"><xsl:value-of select=\"expand-qname (0, .)\"/></xsl:attribute>\n"
"	</xsl:for-each>\n"
"      <xsl:apply-templates select=\"*\" />\n"
"    </xsl:copy>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\">\n"
"    <xsl:copy>\n"
"      <xsl:copy-of select=\"@*\" />\n"
"      <xsl:apply-templates select=\"node()\" />\n"
"    </xsl:copy>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"wsdl:types\" />\n"
"<xsl:template match=\"xsd:schema\" />\n"
"<xsl:template match=\"xsd:import[@schemaLocation]\" />\n"
"\n"
"<xsl:template match=\"xsd:schema\" mode=\"xsd\">\n"
"    <xsl:for-each select=\"xsd:import\">\n"
"	<xsl:choose>\n"
"	    <xsl:when test=\"@schemaLocation\">\n"
"		<xsl:variable name=\"sch\" select=\"document(@schemaLocation)\"/>\n"
"		<xsl:apply-templates select=\"$sch/*\" mode=\"xsd\"/>\n"
"	    </xsl:when>\n"
"	    <!--xsl:otherwise>\n"
"		<xsl:variable name=\"lns\" select=\"@namespace\"/>\n"
"		<xsl:apply-templates select=\"//xsd:schema[@targetNamespace = $lns]\" mode=\"xsd\"/>\n"
"	    </xsl:otherwise-->\n"
"	</xsl:choose>\n"
"    </xsl:for-each>\n"
"    <xsl:copy>\n"
"      <xsl:copy-of select=\"@*\" />\n"
"      <xsl:apply-templates select=\"*\" />\n"
"    </xsl:copy>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"wsdl:import\" mode=\"xsd\">\n"
"    <xsl:choose>\n"
"	<xsl:when test=\"@namespace\">\n"
"	    <xsl:variable name=\"ns\" select=\"@namespace\"/>\n"
"	</xsl:when>\n"
"	<xsl:otherwise>\n"
"	    <xsl:variable name=\"ns\" select=\"ancestor::wsdl:definitions/@targetNamespace\"/>\n"
"	</xsl:otherwise>\n"
"    </xsl:choose>\n"
"\n"
"    <xsl:variable name=\"doc\" select=\"document (@location)\"/>\n"
"    <xsl:apply-templates select=\"$doc//xsd:schema[@targetNamespace = $ns]\" mode=\"xsd\"/>\n"
"    <xsl:apply-templates select=\"$doc//wsdl:definitions[@targetNamespace = $ns]/wsdl:import\" mode=\"xsd\"/>\n"
"    <xsl:apply-templates select=\"$doc//wsdl:import[@namespace=$ns]\" mode=\"xsd\"/>\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* wsdl_parts.xsl */

static const char *xsl10[]= {
"<?xml version='1.0'?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n"
"     version=\"1.0\"\n"
"     xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"\n"
"     xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n"
"     xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\"\n"
"     xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\"\n"
"     xmlns:vi=\"http://www.openlinksw.com/wsdl/\"\n"
"     >\n"
"\n"
"<xsl:output method=\"xml\" omit-xml-declaration=\"no\" indent=\"yes\" />\n"
"\n"
"<xsl:param name=\"tns\" select=\"/wsdl:definitions/@targetNamespace\" />\n"
"\n"
"<xsl:template match=\"/\">\n"
"  <xsl:apply-templates select=\"node()\" />\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"wsdl:part\">\n"
"<xsl:choose>\n"
"<xsl:when test=\"@type\">\n"
"    <xsl:copy>\n"
"      <xsl:copy-of select=\"@*\" />\n"
"      <xsl:apply-templates select=\"node()\" />\n"
"    </xsl:copy>\n"
"</xsl:when>\n"
"<xsl:when test=\"@element and @name != 'parameters'\">\n"
"  <xsl:copy>\n"
"    <xsl:copy-of select=\"@*\" />\n"
"    <xsl:apply-templates select=\"node()\" />\n"
"  </xsl:copy>\n"
"  <!--wsdl:part>\n"
"  <xsl:variable name=\"ename\" select=\"vi:split-name (@element, 1)\" />\n"
"  <xsl:variable name=\"exsd\" select=\"vi:split-name (@element, 0)\" />\n"
"  <xsl:attribute name=\"name\"><xsl:value-of select=\"//xsd:schema[@targetNamespace = $exsd]/xsd:element[@name = $ename]/@name\" /></xsl:attribute>\n"
"  <xsl:choose>\n"
"  <xsl:when test=\"//xsd:schema[@targetNamespace = $exsd]/xsd:element[@name = $ename]/@type\">\n"
"  <xsl:attribute name=\"type\"><xsl:value-of select=\"//xsd:schema[@targetNamespace = $exsd]/xsd:element[@name = $ename]/@type\" /></xsl:attribute>\n"
"  </xsl:when>\n"
"  <xsl:otherwise>\n"
"  <xsl:attribute name=\"type\"><xsl:value-of select=\"$exsd\"/>:elementType__<xsl:value-of select=\"//xsd:schema[@targetNamespace = $exsd]/xsd:element[@name = $ename]/@name\" /></xsl:attribute>\n"
"  </xsl:otherwise>\n"
"  </xsl:choose>\n"
"  </wsdl:part-->\n"
"</xsl:when>\n"
"<xsl:when test=\"@element and @name = 'parameters'\">\n"
"  <xsl:variable name=\"ename\" select=\"vi:split-name (@element, 1)\" />\n"
"  <xsl:variable name=\"exsd\" select=\"vi:split-name (@element, 0)\" />\n"
"  <xsl:for-each select=\"//xsd:schema[@targetNamespace = $exsd]/xsd:element[@name = $ename]\">\n"
"    <xsl:choose>\n"
"     <xsl:when test=\"xsd:complexType//xsd:element\">\n"
"       <xsl:for-each select=\"xsd:complexType//xsd:element\">\n"
"	   <wsdl:part>\n"
"	       <xsl:choose>\n"
"		   <xsl:when test=\"@name\">\n"
"		       <xsl:attribute name=\"name\">\n"
"			   <xsl:value-of select=\"@name\"/>\n"
"		       </xsl:attribute>\n"
"		       <xsl:attribute name=\"type\">\n"
"			   <xsl:value-of select=\"@type\"/>\n"
"		       </xsl:attribute>\n"
"		   </xsl:when>\n"
"		   <xsl:when test=\"@ref\">\n"
"		       <xsl:variable name=\"rnam\" select=\"vi:split-name (@ref, 1)\" />\n"
"		       <xsl:variable name=\"rns\" select=\"vi:split-name (@ref, 0)\" />\n"
"		       <xsl:attribute name=\"name\">\n"
"			   <xsl:value-of select=\"$rnam\"/>\n"
"		       </xsl:attribute>\n"
"		       <xsl:attribute name=\"type\">\n"
"			   <xsl:value-of select=\"//xsd:schema[@targetNamespace = $rns]/xsd:element[@name=$rnam]/@type\"/>\n"
"		       </xsl:attribute>\n"
"		   </xsl:when>\n"
"	       </xsl:choose>\n"
"         </wsdl:part>\n"
"       </xsl:for-each>\n"
"     </xsl:when>\n"
"     <xsl:otherwise>\n"
"   	<xsl:variable name=\"tname\" select=\"vi:split-name (@type, 1)\" />\n"
"  	<xsl:variable name=\"txsd\" select=\"vi:split-name (@type, 0)\" />\n"
"        <xsl:for-each select=\"//xsd:schema[@targetNamespace = $txsd]/xsd:complexType[@name = $tname]//xsd:element\">\n"
"         <wsdl:part>\n"
"	  <xsl:attribute name=\"name\">\n"
"            <xsl:value-of select=\"@name\"/>\n"
"	  </xsl:attribute>\n"
"	  <xsl:attribute name=\"type\">\n"
"            <xsl:value-of select=\"@type\"/>\n"
"	  </xsl:attribute>\n"
"         </wsdl:part>\n"
"       </xsl:for-each>\n"
"     </xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:for-each>\n"
"</xsl:when>\n"
"<xsl:otherwise>\n"
"      <xsl:apply-templates select=\"node()\" />\n"
"</xsl:otherwise>\n"
"</xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"wsdl:operation[wsdl:input/soap:body]\">\n"
"    <xsl:copy>\n"
"      <xsl:copy-of select=\"@*\" />\n"
"\n"
"      <xsl:if test=\"not (wsdl:input/soap:body/@encodingStyle)\">\n"
"      <xsl:variable name=\"opname\" select=\"@name\" />\n"
"      <xsl:variable name=\"pname\" select=\"ancestor::wsdl:binding/@type\" />\n"
"       <xsl:attribute name=\"enc\">\n"
"        <xsl:for-each select=\"/wsdl:definitions/wsdl:portType[@name = $pname]/wsdl:operation[@name = $opname]\">\n"
"          <xsl:variable name=\"msg\" select=\"wsdl:input/@message\"/>\n"
"          <xsl:value-of select=\"boolean (/wsdl:definitions/wsdl:message[@name = $msg]/part[1]/@name = 'parameters')\" />\n"
"        </xsl:for-each>\n"
"       </xsl:attribute>\n"
"       <xsl:if test=\"/wsdl:definitions/wsdl:message[@name = $msg]/part[1]/@name = 'parameters'\">\n"
"         <xsl:attribute name=\"elnamespace\">\n"
"           <xsl:value-of select=\"vi:split-name (/wsdl:definitions/wsdl:message[@name = $msg]/part[1]/@element, 0)\" />\n"
"         </xsl:attribute>\n"
"         <xsl:attribute name=\"form\">\n"
"	   <xsl:variable name=\"elname\" select=\"/wsdl:definitions/wsdl:message[@name = $msg]/part[1]/@element\" />\n"
" 	   <xsl:variable name=\"elname0\" select=\"vi:split-name ($elname, 0)\" />\n"
" 	   <xsl:variable name=\"elname1\" select=\"vi:split-name ($elname, 1)\" />\n"
"           <xsl:value-of select=\"/wsdl:definitions/wsdl:types/xsd:schema[ @targetNamespace = $elname0 and xsd:element[ @name = $elname1 ] ]/@elementFormDefault\"/>\n"
"         </xsl:attribute>\n"
"\n"
"       </xsl:if>\n"
"      </xsl:if>\n"
"\n"
"      <xsl:if test=\"not (wsdl:input/soap:body/@namespace)\">\n"
"      <xsl:variable name=\"opname\" select=\"@name\" />\n"
"      <xsl:variable name=\"pname\" select=\"ancestor::wsdl:binding/@type\" />\n"
"       <xsl:attribute name=\"namespace\">\n"
"        <xsl:for-each select=\"/wsdl:definitions/wsdl:portType[@name = $pname]/wsdl:operation[@name = $opname]\">\n"
"          <xsl:variable name=\"msg\" select=\"wsdl:input/@message\"/>\n"
"          <xsl:value-of select=\"vi:split-name (/wsdl:definitions/wsdl:message[@name = $msg]/part[1]/@element, 0)\" />\n"
"        </xsl:for-each>\n"
"       </xsl:attribute>\n"
"      </xsl:if>\n"
"\n"
"      <xsl:apply-templates select=\"node()\" />\n"
"    </xsl:copy>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\">\n"
"    <xsl:copy>\n"
"      <xsl:copy-of select=\"@*\" />\n"
"      <xsl:apply-templates select=\"node()\" />\n"
"    </xsl:copy>\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* wsdl_import.xsl */

static const char *xsl11[]= {
"<?xml version='1.0'?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n"
"     version=\"1.0\"\n"
"     xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"\n"
"     xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n"
"     xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\"\n"
"     xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\"\n"
"     xmlns:vi=\"http://www.openlinksw.com/wsdl/\"\n"
"     >\n"
"<xsl:output method=\"text\" omit-xml-declaration=\"yes\" indent=\"yes\" />\n"
"\n"
"<xsl:param name=\"tns\" select=\"/wsdl:definitions/@targetNamespace\" />\n"
"<xsl:param name=\"wsdlURI\" />\n"
"<xsl:template match=\"/\">\n"
"-- Automatically generated code\n"
"-- imported from WSDL URI: \"<xsl:value-of select=\"$wsdlURI\" />\"\n"
" <xsl:apply-templates select=\"*\" />\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"wsdl:definitions\">\n"
" <xsl:apply-templates select=\"*\" />\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"wsdl:service\">\n"
"<xsl:variable name=\"classname\" select=\"@name\" />\n"
"<xsl:for-each select=\"wsdl:port[soap:address]\">\n"
"<xsl:variable name=\"binded\" select=\"@binding\" />\n"
"<xsl:choose>\n"
"<xsl:when test=\"position() = 1\">\n"
"<xsl:variable name=\"sname\" select=\"$classname\" />\n"
"</xsl:when>\n"
"<xsl:otherwise>\n"
"<xsl:variable name=\"sname\" select=\"concat ($classname,position())\" />\n"
"</xsl:otherwise>\n"
"</xsl:choose>\n"
"-- UDT class\n"
"drop type \"<xsl:value-of select=\"$sname\"/>\"\n"
";\n", 
"\n"
"create type \"<xsl:value-of select=\"$sname\"/>\"\n"
"  as\n"
"    (\n"
"      debug int default 0,\n"
"      url varchar default '<xsl:value-of select=\"soap:address/@location\" />',\n"
"      ticket varchar default null,\n"
"      request varchar,\n"
"      response varchar\n"
"    )\n"
"-- Binding: \"<xsl:value-of select=\"$binded\" />\"\n"
"<xsl:apply-templates select=\"/wsdl:definitions/wsdl:binding[@name=$binded]\" mode=\"declare\" />\n"
"method style () returns any\n"
";\n", 
"\n"
"-- Methods\n"
"<xsl:apply-templates select=\"/wsdl:definitions/wsdl:binding[@name=$binded]\" mode=\"define\" ><xsl:with-param name=\"class\" select=\"$sname\"/></xsl:apply-templates>\n"
"</xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"wsdl:binding\" mode=\"declare\" >\n"
"    <xsl:apply-templates select=\"wsdl:*\" mode=\"declare\">\n"
"	<xsl:with-param name=\"portname\" select=\"@type\" />\n"
"	<xsl:with-param name=\"bindname\" select=\"@name\" />\n"
"    </xsl:apply-templates>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"wsdl:binding\" mode=\"define\" >\n"
"    <xsl:apply-templates select=\"wsdl:*\" mode=\"define\">\n"
"	<xsl:with-param name=\"portname\" select=\"@type\" />\n"
"	<xsl:with-param name=\"bindname\" select=\"@name\" />\n"
"	<xsl:with-param name=\"class\" select=\"$class\" />\n"
"    </xsl:apply-templates>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"wsdl:operation\" mode=\"declare\" >\n"
"<xsl:variable name=\"opname\" select=\"@name\" />\n"
"<xsl:variable name=\"oper\" select=\".\" />\n"
"method \"<xsl:value-of select=\"@name\" />\"\n"
"       (\n"
"<xsl:apply-templates select=\"/wsdl:definitions/wsdl:portType[@name = $portname]/wsdl:operation[@name = $opname]\" mode=\"params\" >\n"
"	<xsl:with-param name=\"bindname\" select=\"$bindname\" />\n"
"	<xsl:with-param name=\"oper\" select=\"$oper\" />\n"
"       </xsl:apply-templates>\n"
"       ) returns any,\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"wsdl:operation\" mode=\"define\" >\n"
"<xsl:variable name=\"opname\" select=\"@name\" />\n"
"<xsl:variable name=\"oper\" select=\".\" />\n"
"create method \"<xsl:value-of select=\"@name\" />\"\n"
"       (\n"
"<xsl:apply-templates select=\"/wsdl:definitions/wsdl:portType[@name = $portname]/wsdl:operation[@name = $opname]\" mode=\"def_params\" >\n"
"	<xsl:with-param name=\"bindname\" select=\"$bindname\" />\n"
"	<xsl:with-param name=\"oper\" select=\"$oper\" />\n"
"       </xsl:apply-templates>\n"
"       )\n"
"       <xsl:text>__soap_type '__VOID__' </xsl:text>\n"
"for \"<xsl:value-of select=\"$class\" />\"\n"
"{\n"
"  declare action, namespace, enc varchar;\n"
"  declare style, form int;\n"
"  declare _result, _body, xe any;\n"
"  action := '<xsl:value-of select=\"soap:operation/@soapAction\" />';\n"
"  <xsl:choose>\n"
"  <xsl:when test=\"@elnamespace and @enc = 1\">\n"
"  namespace := '<xsl:value-of select=\"@elnamespace\" />';\n"
"  form := <xsl:value-of select=\"boolean (@form = 'qualified')\" />;\n"
"  </xsl:when>\n"
"  <xsl:when test=\"wsdl:input/soap:body/@namespace\">\n"
"  namespace := '<xsl:value-of select=\"wsdl:input/soap:body/@namespace\" />';\n"
"  form := 0;\n"
"  </xsl:when>\n"
"  <xsl:otherwise>\n"
"  namespace := '<xsl:value-of select=\"@namespace\" />';\n"
"  form := 0;\n"
"  </xsl:otherwise>\n"
"  </xsl:choose>\n"
"  <xsl:choose>\n"
"  <xsl:when test=\"wsdl:input/soap:body/@encodingStyle\" >\n"
"  style := 0;\n"
"  </xsl:when>\n"
"  <xsl:when test=\"@enc = 1\" >\n"
"  style := 5;\n"
"  </xsl:when>\n"
"  <xsl:otherwise>\n"
"  style := 1;\n"
"  </xsl:otherwise>\n"
"  </xsl:choose>\n"
"  if (self.debug)\n"
"    style := style + 2;\n"
"  style := style + (form * 16);\n"
"  _result := DB.DBA.SOAP_CLIENT (\n"
"	        url=>self.url,\n"
"		operation=>'<xsl:value-of select=\"@name\" />',\n"
" 		soap_action=>action,\n"
"	        target_namespace=>namespace,\n"
" 		parameters=>vector\n"
"                        (\n"
"<xsl:apply-templates select=\"/wsdl:definitions/wsdl:portType[@name=$portname]/wsdl:operation[@name = $opname]\" mode=\"val_params\" />\n"
"			),\n"
" 		headers=>vector\n"
"                        (\n"
"<xsl:call-template name=\"header_params\" />\n"
"			),\n"
"		style=>style,\n"
"		ticket=>self.ticket\n"
"	       );\n"
"  if (self.debug)\n"
"    {\n"
"      _body := _result[0];\n"
"      self.request := _result[1];\n"
"      self.response := _result[2];\n"
"    }\n"
"  else\n"
"    _body := _result;\n"
"  xe := xml_cut (xml_tree_doc (_body));\n"
"  if (xpath_eval ('[ xmlns:SOAP=\"http://schemas.xmlsoap.org/soap/envelope/\" ] //SOAP:Fault', xe, 1) is null)\n"
"    {\n"
"<xsl:apply-templates select=\"/wsdl:definitions/wsdl:portType[@name=$portname]/wsdl:operation[@name = $opname]\" mode=\"ret_params\" /><xsl:text>      </xsl:text>;\n"
"    }\n"
"  return _result;\n"
"}\n"
";\n", 
"</xsl:template>\n"
"\n"
"<xsl:template match=\"wsdl:operation\" mode=\"params\" >\n"
"<xsl:variable name=\"inmsg\" select=\"wsdl:input/@message\"/>\n"
"<xsl:variable name=\"outmsg\" select=\"wsdl:output/@message\"/>\n"
"<xsl:variable name=\"inhdr\" select=\"$oper/input/header/@message\"/>\n"
"<xsl:variable name=\"outhdr\" select=\"$oper/output/header/@message\"/>\n"
"<xsl:for-each select=\"/wsdl:definitions/wsdl:message[@name = $inmsg or @name = $outmsg or @name = $inhdr or @name = $outhdr]/part\" >\n"
"<xsl:choose>\n"
"<xsl:when test=\"parent::wsdl:message[@name = $inmsg or @name = $inhdr]\">\n"
"<xsl:variable name=\"partname\" select=\"''\"/>\n"
"</xsl:when>\n"
"<xsl:otherwise>\n"
"<xsl:variable name=\"partname\" select=\"@name\"/>\n"
"</xsl:otherwise>\n"
"</xsl:choose>\n"
"<xsl:if test=\"not(/wsdl:definitions/wsdl:message[@name = $inmsg or @name = $inhdr]/part[@name=$partname])\">\n"
"<xsl:text>        </xsl:text>\"<xsl:value-of select=\"@name\" />\" any<xsl:if test=\"position() < last()\">,\n"
"</xsl:if>\n"
"</xsl:if>\n"
"</xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"wsdl:operation\" mode=\"def_params\" >\n"
"<xsl:variable name=\"inmsg\" select=\"wsdl:input/@message\"/>\n"
"<xsl:variable name=\"outmsg\" select=\"wsdl:output/@message\"/>\n"
"<xsl:variable name=\"inhdr\" select=\"$oper/input/header/@message\"/>\n"
"<xsl:variable name=\"outhdr\" select=\"$oper/output/header/@message\"/>\n"
"<xsl:for-each select=\"/wsdl:definitions/wsdl:message[@name = $inmsg or @name = $outmsg or @name = $inhdr or @name = $outhdr]/part\" >\n"
"    <xsl:variable name=\"myname\" select=\"@name\"/>\n"
"<xsl:choose>\n"
"<xsl:when test=\"parent::wsdl:message[@name = $inmsg or @name = $inhdr]\">\n"
"    <xsl:variable name=\"partname\" select=\"''\"/>\n"
"    <xsl:choose>\n"
"	<xsl:when test=\"/wsdl:definitions/wsdl:message[@name = $outmsg or @name = $outhdr]/part[@name=$myname]\">\n"
"    <xsl:variable name=\"partty\" select=\"'inout'\"/>\n"
"    </xsl:when>\n"
"    <xsl:otherwise>\n"
"    <xsl:variable name=\"partty\" select=\"'in'\"/>\n"
"    </xsl:otherwise>\n"
"    </xsl:choose>\n"
"</xsl:when>\n"
"<xsl:otherwise>\n"
"<xsl:variable name=\"partname\" select=\"@name\"/>\n"
"    <xsl:variable name=\"partty\" select=\"'out'\"/>\n"
"</xsl:otherwise>\n"
"</xsl:choose>\n"
"<xsl:if test=\"not(/wsdl:definitions/wsdl:message[@name = $inmsg]/part[@name=$partname])\">\n"
"    <xsl:text>        </xsl:text><xsl:value-of select=\"$partty\"/><xsl:text> \"</xsl:text>\n"
"    <xsl:value-of select=\"@name\" /><xsl:text>\" any </xsl:text>\n"
"    <xsl:choose>\n"
"	<xsl:when test=\"/wsdl:definitions/wsdl:message[@name = $inhdr or @name = $outhdr]/part[@name=$myname]\">\n"
"	    <xsl:variable name=\"ishdr\" select=\"true()\"/>\n"
"	</xsl:when>\n"
"	<xsl:otherwise>\n"
"	    <xsl:variable name=\"ishdr\" select=\"false()\"/>\n"
"	</xsl:otherwise>\n"
"    </xsl:choose>\n"
"    <xsl:call-template name=\"soap_dt\">\n"
"	<xsl:with-param name=\"ishdr\" select=\"$ishdr\"/>\n"
"    </xsl:call-template>\n"
"    <xsl:if test=\"position() < last()\">,\n"
"</xsl:if>\n"
"</xsl:if>\n"
"</xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template name=\"soap_dt\">\n"
"    <xsl:if test=\"@type != '' or @element != ''\">\n"
"	<xsl:text> </xsl:text>\n"
"	 <xsl:choose>\n"
"	     <xsl:when test=\"$ishdr\">__soap_header</xsl:when>\n"
"	     <xsl:otherwise>__soap_type</xsl:otherwise>\n"
"	 </xsl:choose>\n"
"	<xsl:text> '</xsl:text><xsl:call-template name=\"par_type\"/><xsl:text>'</xsl:text>\n"
"    </xsl:if>\n"
"</xsl:template>\n"
"\n"
"<xsl:template name=\"header_params\">\n"
"    <xsl:for-each select=\"wsdl:input/header\">\n"
"	<xsl:variable name=\"part\" select=\"@part\"/>\n"
"	<xsl:variable name=\"message\" select=\"@message\"/>\n"
"	<xsl:for-each select=\"/wsdl:definitions/wsdl:message[@name = $message]/part[@name=$part]\">\n"
"	    <xsl:text>        		</xsl:text>vector('<xsl:value-of select=\"@name\" />', '<xsl:call-template name=\"par_type\"/>'), \"<xsl:value-of select=\"@name\" /><xsl:text>\"</xsl:text>\n"
"	</xsl:for-each><xsl:if test=\"position() < last()\">,\n"
"</xsl:if>\n"
"    </xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"wsdl:operation\" mode=\"val_params\" >\n"
"<xsl:variable name=\"inmsg\" select=\"wsdl:input/@message\"/>\n"
"<xsl:for-each select=\"/wsdl:definitions/wsdl:message[@name = $inmsg]/part\" >\n"
"<xsl:text>        		</xsl:text>vector('<xsl:value-of select=\"@name\" />', '<xsl:call-template name=\"par_type\"/>'), \"<xsl:value-of select=\"@name\" />\" <xsl:if test=\"position() < last()\">,\n"
"</xsl:if>\n"
"</xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"wsdl:operation\" mode=\"ret_params\" >\n"
"<xsl:variable name=\"msg\" select=\"wsdl:output/@message\"/>\n"
"<xsl:for-each select=\"/wsdl:definitions/wsdl:message[@name = $msg]/part\" >\n"
"    <xsl:text> declare temp any;     </xsl:text>\n"
"    <xsl:text> temp:= </xsl:text> xpath_eval ('//<xsl:call-template name=\"xpf_elm\"/>', xe, 1); if (temp is NULL) return NULL;\n"
"    <xsl:text>      </xsl:text>\"<xsl:value-of select=\"@name\" />\" := xml_cut (temp);\n"
"    <xsl:if test=\"@type != '' or @element != ''\">\n"
"	<xsl:text>      </xsl:text>\"<xsl:value-of select=\"@name\" />\" := soap_box_xml_entity_validating (\"<xsl:value-of select=\"@name\" />\", '<xsl:call-template name=\"par_type\"/>', <xsl:call-template name=\"type_mode\"/>);\n"
"    </xsl:if>\n"
"</xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template name=\"par_type\">\n"
"<xsl:choose>\n"
"<xsl:when test=\"@type\">\n"
"<xsl:value-of select=\"@type\" />\n"
"</xsl:when>\n"
"<xsl:when test=\"@element\">\n"
"<xsl:value-of select=\"@element\" />\n"
"</xsl:when>\n"
"</xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<xsl:template name=\"xpf_elm\">\n"
"<xsl:choose>\n"
"<xsl:when test=\"@type\"><xsl:value-of select=\"@name\" /></xsl:when>\n"
"<xsl:when test=\"@element\"><xsl:value-of select=\"vi:split-name(@element,1)\" /></xsl:when>\n"
"</xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<xsl:template name=\"type_mode\">\n"
"<xsl:choose>\n"
"<xsl:when test=\"@type\">0</xsl:when>\n"
"<xsl:when test=\"@element\">1</xsl:when>\n"
"</xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\"/>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* wsdl2rdf.xsl */

static const char *xsl12[]= {
"<?xml version=\"1.0\" ?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<!DOCTYPE xsl:stylesheet [\n"
"<!ENTITY rdf \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n"
"<!ENTITY rdfs \"http://www.w3.org/2000/01/rdf-schema#\">\n"
"<!ENTITY wsdlr \"http://www.w3.org/ns/wsdl-rdf#\">\n"
"<!ENTITY wsdl \"http://www.w3.org/2006/01/wsdl\">\n"
"<!ENTITY wsoap \"http://www.w3.org/ns/wsdl/soap\">\n"
"]>\n"
"<xsl:stylesheet version=\"1.0\"\n"
"    xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n"
"    xmlns:rdf=\"&rdf;\"\n"
"    xmlns:rdfs=\"&rdfs;\"\n"
"    xmlns:wsdlr=\"&wsdlr;\"\n"
"    xmlns:wsoap=\"&wsoap;\"\n"
"    xmlns:wsdl=\"&wsdl;\"\n"
"    >\n"
"    <xsl:output method=\"xml\" indent=\"yes\" media-type=\"application/rdf+xml\" />\n"
"    <xsl:variable name=\"ns\" select=\"/wsdl:description/@targetNamespace\"/>\n"
"    <xsl:variable name=\"uc\">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable>\n"
"    <xsl:variable name=\"lc\">abcdefghijklmnopqrstuvwxyz</xsl:variable>\n"
"\n"
"    <xsl:template match=\"wsdl:description\">\n"
"	<rdf:RDF>\n"
"	    <xsl:variable name=\"iri\"><xsl:call-template name=\"iri\"/></xsl:variable>\n"
"	    <rdf:Description rdf:about=\"{$iri}\">\n"
"		<rdf:type rdf:resource=\"&wsdlr;Description\"/>\n"
"		<xsl:apply-templates mode=\"inner\"/>\n"
"	    </rdf:Description>\n"
"	    <xsl:for-each select=\"wsdl:interface/wsdl:operation/wsdl:*/@element\">\n"
"		<xsl:variable name=\"qn\" select=\"expand-qname (0, .)\"/>\n"
"		<rdf:Description rdf:about=\"{$qn}\">\n"
"		    <rdf:type rdf:resource=\"&wsdlr;QName\"/>\n"
"		    <wsdlr:localName><xsl:value-of select=\"substring-after (., ':')\"/></wsdlr:localName>\n"
"		    <wsdlr:namespace rdf:resource=\"{substring-before($qn, concat (':', substring-after (., ':')))}\"/>\n"
"		</rdf:Description>\n"
"	    </xsl:for-each>\n"
"	    <xsl:apply-templates/>\n"
"	</rdf:RDF>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template match=\"wsdl:interface\">\n"
"	<xsl:variable name=\"iri\"><xsl:call-template name=\"iri\"/></xsl:variable>\n"
"	<rdf:Description rdf:about=\"{$iri}\">\n"
"	    <rdf:type rdf:resource=\"&wsdlr;Interface\"/>\n"
"	    <rdfs:label><xsl:value-of select=\"@name\"/></rdfs:label>\n"
"	    <xsl:apply-templates mode=\"intf-inner\"/>\n"
"	</rdf:Description>\n"
"	<xsl:apply-templates/>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template match=\"wsdl:operation\" mode=\"intf-inner\">\n"
"	<wsdlr:interfaceOperation>\n"
"	    <xsl:attribute name=\"resource\" namespace=\"&rdf;\">\n"
"		<xsl:call-template name=\"op-iri\"/>\n"
"	    </xsl:attribute>\n"
"	</wsdlr:interfaceOperation>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template match=\"wsdl:operation[@name]\">\n"
"	<xsl:variable name=\"iri\"><xsl:call-template name=\"op-iri\"/></xsl:variable>\n"
"	<rdf:Description rdf:about=\"{$iri}\">\n"
"	    <rdf:type rdf:resource=\"&wsdlr;InterfaceOperation\"/>\n"
"	    <rdfs:label><xsl:value-of select=\"@name\"/></rdfs:label>\n"
"	    <wsdlr:messageExchangePattern rdf:resource=\"{@pattern}\"/>\n"
"	    <wsdlr:operationStyle rdf:resource=\"{@style}\"/>\n"
"	    <xsl:apply-templates mode=\"op-inner\"/>\n"
"	</rdf:Description>\n"
"	<xsl:apply-templates/>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template match=\"wsdl:input|wsdl:output\" mode=\"op-inner\">\n"
"	<xsl:variable name=\"iri\"><xsl:call-template name=\"msg-iri\"/></xsl:variable>\n"
"	<wsdlr:interfaceMessageReference rdf:resource=\"{$iri}\"/>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template match=\"wsdl:input|wsdl:output\">\n"
"	<xsl:variable name=\"iri\"><xsl:call-template name=\"msg-iri\"/></xsl:variable>\n"
"	<rdf:Description rdf:about=\"{$iri}\">\n"
"	    <rdf:type rdf:resource=\"&wsdlr;InterfaceMessageReference\"/>\n"
"	    <xsl:choose>\n"
"		<xsl:when test=\"local-name() = 'input'\">\n"
"		    <rdf:type rdf:resource=\"&wsdlr;InputMessage\"/>\n"
"		</xsl:when>\n"
"		<xsl:when test=\"local-name() = 'output'\">\n"
"		    <rdf:type rdf:resource=\"&wsdlr;OutputMessage\"/>\n"
"		</xsl:when>\n"
"	    </xsl:choose>\n"
"	    <wsdlr:messageLabel rdf:resource=\"{../@pattern}#{@messageLabel}\"/>\n"
"	    <wsdlr:messageContentModel rdf:resource=\"&wsdlr;ElementContent\"/>\n"
"	    <wsdlr:elementDeclaration rdf:resource=\"{expand-qname (0, @element)}\"/>\n"
"	</rdf:Description>\n"
"    </xsl:template>\n"
"\n"
"\n"
"    <xsl:template match=\"wsdl:fault\" mode=\"intf-inner\">\n"
"	<wsdlr:interfaceFault>\n"
"	    <xsl:attribute name=\"resource\" namespace=\"&rdf;\">\n"
"		<xsl:call-template name=\"op-iri\"/>\n"
"	    </xsl:attribute>\n"
"	</wsdlr:interfaceFault>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template match=\"wsdl:interface|wsdl:binding|wsdl:service\" mode=\"inner\">\n"
"	<xsl:element name=\"{local-name(.)}\" namespace=\"&wsdlr;\">\n"
"	    <xsl:attribute name=\"resource\" namespace=\"&rdf;\">\n"
"		<xsl:call-template name=\"iri\"/>\n"
"	    </xsl:attribute>\n"
"	</xsl:element>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template match=\"wsdl:binding\">\n"
"	<xsl:variable name=\"iri\"><xsl:call-template name=\"iri\"/></xsl:variable>\n"
"	<xsl:variable name=\"if-name\" select=\"substring-after (@interface, ':')\"/>\n"
"	<xsl:variable name=\"if-iri\">\n"
"	    <xsl:apply-templates select=\"//wsdl:interface[@name = $if-name]\" mode=\"get-iri\"/>\n"
"	</xsl:variable>\n"
"	<rdf:Description rdf:about=\"{$iri}\">\n"
"	    <rdf:type rdf:resource=\"&wsdlr;Binding\"/>\n"
"	    <rdf:type rdf:resource=\"{@type}\"/>\n"
"	    <rdfs:label><xsl:value-of select=\"@name\"/></rdfs:label>\n"
"	    <wsdlr:binds rdf:resource=\"{$if-iri}\"/>\n"
"	    <wsoap:protocol rdf:resource=\"{@wsoap:protocol}\"/>\n"
"	    <wsoap:version><xsl:value-of select=\"@wsoap:version\"/></wsoap:version>\n"
"	    <xsl:apply-templates mode=\"bind-inner\" />\n"
"	</rdf:Description>\n"
"	<xsl:apply-templates/>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template match=\"wsdl:operation\" mode=\"bind-inner\">\n"
"	<xsl:variable name=\"iri\"><xsl:call-template name=\"op-iri\"/></xsl:variable>\n"
"	<wsdlr:bindingOperation rdf:resource=\"{$iri}\"/>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template match=\"wsdl:operation[@ref]\">\n"
"	<xsl:variable name=\"op-name\" select=\"substring-after (@ref, ':')\"/>\n"
"	<xsl:variable name=\"op-iri\">\n"
"	    <xsl:apply-templates select=\"//wsdl:operation[@name = $op-name]\" mode=\"get-iri\"/>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"iri\"><xsl:call-template name=\"op-iri\"/></xsl:variable>\n"
"	<rdf:Description rdf:about=\"{$iri}\">\n"
"	    <rdf:type rdf:resource=\"&wsdlr;BindingOperation\"/>\n"
"	    <wsdlr:binds rdf:resource=\"{$op-iri}\"/>\n"
"	</rdf:Description>\n"
"	<xsl:apply-templates/>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template match=\"wsdl:interface\" mode=\"get-iri\">\n"
"	<xsl:call-template name=\"iri\"/>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template match=\"wsdl:operation\" mode=\"get-iri\">\n"
"	<xsl:call-template name=\"op-iri\"/>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template match=\"wsdl:binding\" mode=\"get-iri\">\n"
"	<xsl:call-template name=\"iri\"/>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template match=\"wsdl:service\">\n"
"	<xsl:variable name=\"iri\"><xsl:call-template name=\"iri\"/></xsl:variable>\n"
"	<rdf:Description rdf:about=\"{$iri}\">\n"
"	    <rdf:type rdf:resource=\"&wsdlr;Service\"/>\n"
"	    <rdfs:label><xsl:value-of select=\"@name\"/></rdfs:label>\n"
"	    <xsl:apply-templates mode=\"svc-inner\" />\n"
"	    <xsl:apply-templates select=\"//wsdl:interface\" mode=\"svc-inner\" />\n"
"	</rdf:Description>\n"
"	<xsl:apply-templates/>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template match=\"wsdl:endpoint\" mode=\"svc-inner\">\n"
"	 <xsl:variable name=\"iri\"><xsl:call-template name=\"ep-iri\"/></xsl:variable>\n"
"	 <wsdlr:endpoint rdf:resource=\"{$iri}\"/>\n"
"     </xsl:template>\n"
"\n"
"     <xsl:template match=\"wsdl:interface\" mode=\"svc-inner\">\n"
"	 <xsl:variable name=\"iri\"><xsl:call-template name=\"iri\"/></xsl:variable>\n"
"	 <wsdlr:implements rdf:resource=\"{$iri}\"/>\n"
"     </xsl:template>\n"
"\n"
"    <xsl:template match=\"wsdl:endpoint\">\n"
"	<xsl:variable name=\"iri\"><xsl:call-template name=\"ep-iri\"/></xsl:variable>\n"
"	<xsl:variable name=\"bnd-name\" select=\"substring-after (@binding, ':')\"/>\n"
"	<xsl:variable name=\"bnd-iri\">\n"
"	    <xsl:apply-templates select=\"//wsdl:binding[@name = $bnd-name]\" mode=\"get-iri\"/>\n"
"	</xsl:variable>\n"
"	<rdf:Description rdf:about=\"{$iri}\">\n"
"	    <rdf:type rdf:resource=\"&wsdlr;Endpoint\"/>\n"
"	    <rdfs:label><xsl:value-of select=\"@name\"/></rdfs:label>\n"
"	    <wsdlr:address rdf:resource=\"{@address}\"/>\n"
"	    <wsdlr:usesBinding rdf:resource=\"{$bnd-iri}\"/>\n"
"	</rdf:Description>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template name=\"msg-iri\">\n"
"	<xsl:value-of select=\"$ns\"/>\n"
"	<xsl:text>#wsdl.interfaceMessageReference</xsl:text>\n"
"	<xsl:text>(</xsl:text>\n"
"	<xsl:value-of select=\"../../@name\"/><xsl:text>/</xsl:text>\n"
"	<xsl:value-of select=\"../@name\"/><xsl:text>/</xsl:text>\n"
"	<xsl:value-of select=\"@messageLabel\"/>\n"
"	<xsl:text>)</xsl:text>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template name=\"op-iri\">\n"
"	<xsl:value-of select=\"$ns\"/>\n"
"	<xsl:text>#wsdl.</xsl:text>\n"
"	<xsl:value-of select=\"local-name(parent::*)\"/>\n"
"	<xsl:value-of select=\"translate (substring (local-name(.), 1, 1), $lc, $uc)\"/>\n"
"	<xsl:value-of select=\"substring (local-name(.), 2)\"/>\n"
"	<xsl:text>(</xsl:text>\n"
"	<xsl:value-of select=\"../@name\"/><xsl:text>/</xsl:text>\n"
"	<xsl:choose>\n"
"	    <xsl:when test=\"@name\">\n"
"		<xsl:value-of select=\"@name\"/>\n"
"	    </xsl:when>\n"
"	    <xsl:when test=\"@ref\">\n"
"		<xsl:value-of select=\"substring-after (@ref, ':')\"/>\n"
"	    </xsl:when>\n"
"	</xsl:choose>\n"
"	<xsl:text>)</xsl:text>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template name=\"ep-iri\">\n"
"	<xsl:value-of select=\"$ns\"/>\n"
"	<xsl:text>#wsdl.</xsl:text>\n"
"	<xsl:value-of select=\"local-name(.)\"/>\n"
"	<xsl:text>(</xsl:text>\n"
"	<xsl:value-of select=\"../@name\"/><xsl:text>/</xsl:text>\n"
"	<xsl:value-of select=\"@name\"/>\n"
"	<xsl:text>)</xsl:text>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template name=\"iri\">\n"
"	<xsl:value-of select=\"$ns\"/>\n"
"	<xsl:text>#wsdl.</xsl:text>\n"
"	<xsl:value-of select=\"local-name(.)\"/>\n"
"	<xsl:text>(</xsl:text>\n"
"	<xsl:value-of select=\"@name\"/>\n"
"	<xsl:text>)</xsl:text>\n"
"    </xsl:template>\n"
"\n"
"    <xsl:template match=\"text()\" mode=\"inner\"/>\n"
"    <xsl:template match=\"text()\" mode=\"op-inner\"/>\n"
"    <xsl:template match=\"text()\" mode=\"intf-inner\"/>\n"
"    <xsl:template match=\"text()\" mode=\"bind-inner\"/>\n"
"    <xsl:template match=\"text()\" mode=\"svc-inner\"/>\n"
"    <xsl:template match=\"text()\"/>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* xmlrpc_soap.xsl */

static const char *xsl13[]= {
"<?xml version='1.0'?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n"
"     version=\"1.0\"\n"
"     xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"\n"
"     xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n"
"     xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\"\n"
"     xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\"\n"
"     xmlns:SOAP=\"http://schemas.xmlsoap.org/soap/envelope/\"\n"
"     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n"
"     xmlns:vi=\"http://www.openlinksw.com/xmlrpc/\"\n"
"     >\n"
"\n"
"<xsl:output method=\"xml\" omit-xml-declaration=\"no\" indent=\"yes\" />\n"
"\n"
"<xsl:param name=\"call\" select=\"''\" />\n"
"\n"
"<xsl:template match=\"/\">\n"
"  <SOAP:Envelope SOAP:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n"
"    <SOAP:Body>\n"
"      <xsl:apply-templates select=\"node()\" />\n"
"    </SOAP:Body>\n"
"  </SOAP:Envelope>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"methodCall\">\n"
"<xsl:element name=\"{methodName}\" namespace=\"\">\n"
"  <xsl:apply-templates select=\"*\"><xsl:with-param name=\"method\" select=\"methodName\"/></xsl:apply-templates>\n"
"</xsl:element>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"methodResponse\">\n"
"  <xsl:choose>\n"
"  <xsl:when test=\"fault\">\n"
"    <xsl:apply-templates select=\"*\"><xsl:with-param name=\"method\" select=\"''\"/></xsl:apply-templates>\n"
"  </xsl:when>\n"
"  <xsl:otherwise>\n"
"  <xsl:copy>\n"
"    <xsl:apply-templates select=\"*\"><xsl:with-param name=\"method\" select=\"''\"/></xsl:apply-templates>\n"
"  </xsl:copy>\n"
"  </xsl:otherwise>\n"
"  </xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"fault\">\n"
"   <SOAP:Fault>\n"
"     <faultcode><xsl:apply-templates select=\".//member[name='faultCode']/value\" mode=\"value\"/></faultcode>\n"
"     <faultstring><xsl:apply-templates select=\".//member[name='faultString']/value\" mode=\"value\"/></faultstring>\n"
"     <detail/>\n"
"   </SOAP:Fault>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"params\">\n"
"  <xsl:for-each select=\"param\">\n"
"  <xsl:choose>\n"
"  <xsl:when test=\"$method != ''\">\n"
"  <xsl:variable name=\"elname\" select=\"vi:getParamName ($method, position ())\" />\n"
"  </xsl:when>\n"
"  <xsl:otherwise>\n"
"  <xsl:variable name=\"elname\" select=\"concat ('Param', position ())\" />\n"
"  </xsl:otherwise>\n"
"  </xsl:choose>\n"
"  <xsl:element name=\"{$elname}\">\n"
"  <xsl:attribute name=\"type\" namespace=\"http://www.w3.org/2001/XMLSchema-instance\">\n"
"      <xsl:apply-templates select=\"value\" mode=\"type\" />\n"
"  </xsl:attribute>\n"
"  <xsl:if test=\"value/array\">\n"
"  <xsl:attribute name=\"arrayType\" namespace=\"http://schemas.xmlsoap.org/soap/encoding/\">\n"
"    <xsl:apply-templates select=\"value/array/data/*[1]\" mode=\"type\" /><xsl:value-of select=\"concat('[',count(value/array/data/*),']')\" />\n"
"  </xsl:attribute>\n"
"  </xsl:if>\n"
"  <xsl:apply-templates select=\"value\" mode=\"value\" />\n"
"  </xsl:element>\n"
"  </xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"value\" mode=\"type\">\n"
"<xsl:choose>\n"
"<xsl:when test=\"i4|int\">http://www.w3.org/2001/XMLSchema:int</xsl:when>\n"
"<xsl:when test=\"string\">http://www.w3.org/2001/XMLSchema:string</xsl:when>\n"
"<xsl:when test=\"double\">http://www.w3.org/2001/XMLSchema:double</xsl:when>\n"
"<xsl:when test=\"boolean\">http://www.w3.org/2001/XMLSchema:boolean</xsl:when>\n"
"<xsl:when test=\"local-name(*[1]) = 'dateTime.iso8601'\">http://www.w3.org/2001/XMLSchema:dateTime</xsl:when>\n"
"<xsl:when test=\"base64\">http://www.w3.org/2001/XMLSchema:base64Binary</xsl:when>\n"
"<xsl:when test=\"struct\">http://schemas.xmlsoap.org/soap/encoding/:Struct</xsl:when>\n"
"<xsl:when test=\"array\">http://schemas.xmlsoap.org/soap/encoding/:Array</xsl:when>\n"
"<xsl:otherwise>http://www.w3.org/2001/XMLSchema:string</xsl:otherwise>\n"
"</xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<!--xsl:comment><xsl:value-of select=\"value/i4\" /></xsl:comment-->\n"
"<xsl:template match=\"value\" mode=\"value\">\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"struct\">\n"
"	<xsl:for-each select=\"struct/member\">\n"
"	  <xsl:variable name=\"mname\" select=\"vi:makeElementName (name)\"/>\n"
"          <xsl:element name=\"{$mname}\">\n"
"	      <xsl:attribute name=\"type\" namespace=\"http://www.w3.org/2001/XMLSchema-instance\">\n"
"		  <xsl:apply-templates select=\"value\" mode=\"type\" />\n"
"	      </xsl:attribute>\n"
"	      <xsl:if test=\"value/array\">\n"
"	        <xsl:attribute name=\"arrayType\" namespace=\"http://schemas.xmlsoap.org/soap/encoding/\">\n"
"	          <xsl:apply-templates select=\"value/array/data/*[1]\" mode=\"type\" /><xsl:value-of select=\"concat('[',count(value/array/data/*),']')\" />\n"
"	        </xsl:attribute>\n"
"              </xsl:if>\n"
"             <xsl:apply-templates select=\"value\" mode=\"value\" />\n"
"          </xsl:element>\n"
"        </xsl:for-each>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"array\">\n"
"        <xsl:for-each select=\"array/data/value\">\n"
"          <item>\n"
"	      <xsl:attribute name=\"type\" namespace=\"http://www.w3.org/2001/XMLSchema-instance\">\n"
"		  <xsl:apply-templates select=\".\" mode=\"type\" />\n"
"	      </xsl:attribute>\n"
"             <xsl:apply-templates select=\".\" mode=\"value\" />\n"
"          </item>\n"
"        </xsl:for-each>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"*\">\n"
"      <xsl:apply-templates select=\"*\" mode=\"value\" />\n"
"    </xsl:when>\n"
"    <xsl:otherwise>\n"
"      <xsl:value-of select=\"text()\" />\n"
"    </xsl:otherwise>\n"
"  </xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\">\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
"\n"
,
 NULL };

/* soap_xmlrpc.xsl */

static const char *xsl14[]= {
"<?xml version='1.0'?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n"
"     version=\"1.0\"\n"
"     xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"\n"
"     xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n"
"     xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\"\n"
"     xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\"\n"
"     xmlns:SOAP=\"http://schemas.xmlsoap.org/soap/envelope/\"\n"
"     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n"
"     xmlns:vi=\"http://www.openlinksw.com/xmlrpc/\"\n"
"     >\n"
"\n"
"<xsl:output method=\"xml\" omit-xml-declaration=\"no\" indent=\"yes\" />\n"
"\n"
"<xsl:param name=\"call\" select=\"''\" />\n"
"\n"
"<xsl:template match=\"/\">\n"
"   <xsl:apply-templates select=\"*\" />\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"SOAP:Envelope\">\n"
"   <xsl:apply-templates select=\"*\" />\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"SOAP:Body\">\n"
"<xsl:choose>\n"
"<xsl:when test=\"$call != ''\">\n"
"   <methodCall>\n"
"     <methodName><xsl:value-of select=\"name(*[1])\" /></methodName>\n"
"     <params>\n"
"       <xsl:for-each select=\"*[1]/*\">\n"
"         <param>\n"
"           <value>\n"
"             <xsl:apply-templates select=\".\" mode=\"value\" />\n"
"           </value>\n"
"         </param>\n"
"       </xsl:for-each>\n"
"     </params>\n"
"   </methodCall>\n"
"</xsl:when>\n"
"<xsl:otherwise>\n"
"   <methodResponse>\n"
"     <params>\n"
"       <xsl:for-each select=\"*[1]/*\">\n"
"         <param>\n"
"           <value>\n"
"             <xsl:apply-templates select=\".\" mode=\"value\" />\n"
"           </value>\n"
"         </param>\n"
"       </xsl:for-each>\n"
"     </params>\n"
"   </methodResponse>\n"
"</xsl:otherwise>\n"
"</xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\" mode=\"value\">\n"
"\n"
" <!--xsl:comment><xsl:value-of select=\"count(*)\" /></xsl:comment-->\n"
" <xsl:choose>\n"
" <xsl:when test=\"@xsi:type\">\n"
"   <xsl:variable name=\"xsitype\" select=\"@xsi:type\"/>\n"
" </xsl:when>\n"
" <xsl:when test=\"parent::*[@soapenc:arrayType]/@xsi:type\">\n"
"   <xsl:variable name=\"xsitype\" select=\"substring-before (parent::*[@soapenc:arrayType]/@xsi:type, '[')\"/>\n"
" </xsl:when>\n"
" <xsl:otherwise>\n"
"   <xsl:variable name=\"xsitype\" select=\"''\"/>\n"
" </xsl:otherwise>\n"
" </xsl:choose>\n"
"\n"
" <xsl:choose>\n"
" <xsl:when test=\"@soapenc:arrayType\">\n"
"   <xsl:variable name=\"elname\" select=\"'array'\" />\n"
" </xsl:when>\n"
" <xsl:when test=\"$xsitype = 'http://www.w3.org/2001/XMLSchema:string'\">\n"
" <xsl:variable name=\"elname\" select=\"'string'\" />\n"
" </xsl:when>\n"
" <xsl:when test=\"$xsitype = 'http://www.w3.org/2001/XMLSchema:int'\">\n"
" <xsl:variable name=\"elname\" select=\"'i4'\" />\n"
" </xsl:when>\n"
" <xsl:when test=\"$xsitype = 'http://www.w3.org/2001/XMLSchema:double'\">\n"
" <xsl:variable name=\"elname\" select=\"'double'\" />\n"
" </xsl:when>\n"
" <xsl:when test=\"$xsitype = 'http://www.w3.org/2001/XMLSchema:decimal'\">\n"
" <xsl:variable name=\"elname\" select=\"'double'\" />\n"
" </xsl:when>\n"
" <xsl:when test=\"$xsitype = 'http://www.w3.org/2001/XMLSchema:float'\">\n"
" <xsl:variable name=\"elname\" select=\"'double'\" />\n"
" </xsl:when>\n"
" <xsl:when test=\"$xsitype = 'http://www.w3.org/2001/XMLSchema:boolean'\">\n"
" <xsl:variable name=\"elname\" select=\"'boolean'\" />\n"
" </xsl:when>\n"
" <xsl:when test=\"$xsitype = 'http://www.w3.org/2001/XMLSchema:dateTime'\">\n"
" <xsl:variable name=\"elname\" select=\"'dateTime.iso8601'\" />\n"
" </xsl:when>\n"
" <xsl:when test=\"$xsitype = 'http://www.w3.org/2001/XMLSchema:base64Binary'\">\n"
" <xsl:variable name=\"elname\" select=\"'base64'\" />\n"
" </xsl:when>\n"
" <xsl:when test=\"*\">\n"
"   <xsl:variable name=\"elname\" select=\"'struct'\" />\n"
" </xsl:when>\n"
" <xsl:otherwise>\n"
" <xsl:variable name=\"elname\" select=\"'string'\" />\n"
" </xsl:otherwise>\n"
" </xsl:choose>\n"
"\n"
" <xsl:element name=\"{$elname}\">\n"
" <xsl:choose>\n"
" <xsl:when test=\"$elname = 'struct'\">\n"
"   <xsl:for-each select=\"*\">\n"
"     <xsl:if test=\"not boolean(number(@xsi:nil))\">\n"
"     <member>\n"
"       <name><xsl:value-of select=\"name()\" /></name>\n"
"       <value><xsl:apply-templates select=\".\" mode=\"value\" /></value>\n"
"     </member>\n"
"     </xsl:if>\n"
"   </xsl:for-each>\n"
" </xsl:when>\n"
" <xsl:when test=\"$elname = 'array'\">\n"
"    <data>\n"
"      <xsl:for-each select=\"*\">\n"
"         <value><xsl:apply-templates select=\".\" mode=\"value\" /></value>\n"
"      </xsl:for-each>\n"
"    </data>\n"
" </xsl:when>\n"
" <xsl:when test=\"$elname = 'dateTime.iso8601'\">\n"
"     <xsl:variable name=\"dt\" select=\"vi:getGMTtime(.)\" />\n"
"  <xsl:value-of select=\"concat (translate (substring-before($dt, 'T'), '-', ''), 'T', substring-after ($dt, 'T'))\" />\n"
" </xsl:when>\n"
" <xsl:otherwise>\n"
" <xsl:value-of select=\".\" />\n"
" </xsl:otherwise>\n"
" </xsl:choose>\n"
" </xsl:element>\n"
"\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\">\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
"\n"
,
 NULL };

/* soap12_router.xsl */

static const char *xsl15[]= {
"<?xml version=\"1.0\"?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\"\n"
"    xmlns:env=\"http://www.w3.org/2003/05/soap-envelope\"\n"
"    xmlns:enc=\"http://www.w3.org/2003/05/soap-encoding\"\n"
"    xmlns:rpc=\"http://www.w3.org/2003/05/soap-rpc\">\n"
"    <xsl:output method=\"xml\" indent=\"yes\" />\n"
"    <xsl:param name=\"this\" />\n"
"    <xsl:param name=\"next\" select=\"'http://www.w3.org/2003/05/soap-encoding/role/next'\"/>\n"
"    <xsl:template match=\"/\">\n"
"	<env:Envelope>\n"
"	    <xsl:apply-templates />\n"
"	</env:Envelope>\n"
"    </xsl:template>\n"
"    <xsl:template match=\"env:Envelope\">\n"
"	<xsl:apply-templates />\n"
"    </xsl:template>\n"
"    <xsl:template match=\"*[@env:role = $this or @env:role = $next]\"/>\n"
"    <xsl:template match=\"*\">\n"
"	<xsl:copy>\n"
"	    <xsl:copy-of select=\"@*\" />\n"
"	    <xsl:apply-templates />\n"
"	</xsl:copy>\n"
"    </xsl:template>\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* wsrm_ddl.sql */

static const char *udt0 = 
"CREATE TYPE SOAP_CLIENT_REQ AS\n"
"(\n"
"url varchar,\n"
"operation varchar,\n"
"target_namespace varchar default null,\n"
"parameters any default null,\n"
"headers any default null,\n"
"soap_action varchar default \'\',\n"
"attachments any default null,\n"
"ticket any default null,\n"
"passwd varchar default null,\n"
"user_name varchar default null,\n"
"user_password varchar default null,\n"
"auth_type varchar default \'none\',\n"
"security_type varchar default \'sign\',\n"
"debug integer default 0,\n"
"template varchar default null,\n"
"style integer default 1,\n"
"version integer default 11,\n"
"direction integer default 0,\n"
"security_schema any default null\n"
")\n";

static const char *udt1 = 
"create type WSA_CLI as\n"
"(\n"
"mid varchar default null,\n"
"\"to\" varchar default null,\n"
"\"from\" varchar default null,\n"
"action varchar default null,\n"
"fault_to varchar default null,\n"
"reply_to varchar default null\n"
")\n"
"constructor method WSA_CLI ()\n";

static const char *other13 = 
"create constructor method WSA_CLI () for WSA_CLI\n"
"{\n"
"self.mid := lower (\'uuid:\' || uuid ());\n"
"}\n";

static const char *tbl2 = 
"CREATE TABLE SYS_WSRM_IN_MESSAGE_LOG (\n"
"IML_INDENTIFIER 	varchar,\n"
"IML_MESSAGE_ID 		int NOT NULL,\n"
"IML_EXPIRE_DATE 	datetime,\n"
"IML_RECEIVE_DATE 	timestamp NOT NULL ,\n"
"IML_MESSAGE 		long varchar NOT NULL,\n"
"IML_EXECUTE_RESP	long varchar,\n"
"IML_ADDRES		long DB.DBA.WSA_CLI NOT NULL,\n"
"IML_STATE		int default 0,\n"
"primary key (IML_INDENTIFIER, IML_MESSAGE_ID)\n"
")\n";

static const char *tbl3 = 
"CREATE TABLE SYS_WSRM_IN_SEQUENCES\n"
"(\n"
"WIS_IDENTIFIER 			varchar,\n"
"WIS_VERSION 			varchar,\n"
"WIS_DELIVERY_ASSURANCE 		varchar,\n"
"WIS_SEQUENCE_EXPIRATION 	datetime,\n"
"WIS_INACTIVITY_TIMEOUT 		integer,\n"
"WIS_RETRANSMISSION_INTERVAL 	integer,\n"
"WIS_ACKNOWLEDGEMENT_INTERVAL 	integer,\n"
"WIS_ACK_SENT			int default 0,\n"
"primary key (WIS_IDENTIFIER)\n"
")\n";

static const char *trig4 = 
"#line 100 \"[executable]/wsrm_ddl.sql\"\n"
"create trigger SYS_WSRM_IN_SEQUENCES_D after delete on SYS_WSRM_IN_SEQUENCES\n"
"{\n"
"delete from SYS_WSRM_IN_MESSAGE_LOG where IML_INDENTIFIER = WIS_IDENTIFIER;\n"
"}\n"
"--src wsrm_ddl.sql:98\n";

static const char *tbl4 = 
"CREATE TABLE SYS_WSRM_OUT_MESSAGE_LOG (\n"
"OML_INDENTIFIER 	varchar,\n"
"OML_MESSAGE_ID 		int NOT NULL,\n"
"OML_EXPIRE_DATE 	datetime,\n"
"OML_SEND_DATE 		timestamp NOT NULL,\n"
"OML_MESSAGE 		long DB.DBA.SOAP_CLIENT_REQ NOT NULL,\n"
"OML_ADDRESS 		long DB.DBA.WSA_CLI NOT NULL,\n"
"OML_STATE		int,\n"
"OML_RESPONSE		long xml,\n"
"primary key (OML_INDENTIFIER, OML_MESSAGE_ID)\n"
")\n";

static const char *tbl5 = 
"CREATE TABLE SYS_WSRM_OUT_SEQUENCES\n"
"(\n"
"WOS_IDENTIFIER 			varchar,\n"
"WOS_VERSION 			varchar,\n"
"WOS_DELIVERY_ASSURANCE 		varchar,\n"
"WOS_SEQUENCE_EXPIRATION 	datetime,\n"
"WOS_INACTIVITY_TIMEOUT 		integer,\n"
"WOS_RETRANSMISSION_INTERVAL 	integer,\n"
"WOS_ACKNOWLEDGEMENT_INTERVAL 	integer,\n"
"WOS_LAST_SENT			integer,\n"
"primary key (WOS_IDENTIFIER)\n"
")\n";

static const char *trig5 = 
"#line 141 \"[executable]/wsrm_ddl.sql\"\n"
"create trigger SYS_WSRM_OUT_SEQUENCES_D after delete on SYS_WSRM_OUT_SEQUENCES\n"
"{\n"
"delete from SYS_WSRM_OUT_MESSAGE_LOG where OML_INDENTIFIER = WOS_IDENTIFIER;\n"
"}\n"
"--src wsrm_ddl.sql:139\n";

static const char *udt2 = 
"create type soap_parameter as\n"
"(\n"
"s any default null,\n"
"param_type int default 1,\n"
"param_xsd varchar default null,\n"
"ver int default 11\n"
")\n"
"temporary self as ref\n"
"constructor method soap_complex_parameter (),\n"
"constructor method soap_simple_parameter (val any),\n"
"constructor method soap_array_parameter (n int),\n"
"constructor method soap_single_parameter (elm soap_parameter),\n"
"method get_length () returns any,\n"
"method add_member (name varchar, val any) returns any,\n"
"method set_member (name varchar, val any) returns any,\n"
"method set_member (pos int, val any) returns any,\n"
"method get_member (name varchar) returns any,\n"
"method get_member (pos int) returns any,\n"
"method get_value () returns any,\n"
"method set_value (val any) returns any,\n"
"method set_attribute (name varchar, val any) returns any,\n"
"method get_attribute (name varchar) returns any,\n"
"method get_call_param (name varchar) returns any,\n"
"method set_xsd (xsd varchar) returns any,\n"
"method deserialize (xs any, elem varchar) returns any,\n"
"method serialize (tag varchar) returns any,\n"
"method check_struct () returns any,\n"
"method check_simple () returns any,\n"
"method set_struct (s any) returns any\n";

static const char *other14 = 
"create method check_struct () for soap_parameter\n"
"{\n"
"if (self.s is not null and self.param_type <> 1)\n"
"signal (\'22023\', \'Not structure\');\n"
"}\n";

static const char *other15 = 
"create method check_simple () for soap_parameter\n"
"{\n"
"if (self.s is not null and self.param_type <> 0)\n"
"signal (\'22023\', \'Not simple type\');\n"
"}\n";

static const char *other16 = 
"create method set_struct (in s any) for soap_parameter\n"
"{\n"
"self.s := s;\n"
"if (isarray (s) and length (s))\n"
"{\n"
"if (__tag (s[0]) = 255 and length (s) = 3)\n"
"self.param_type := 0;\n"
"else if (__tag (s[0]) = 255 and mod (length (s), 2) = 0)\n"
"self.param_type := 1;\n"
"else\n"
"self.param_type := 2;\n"
"}\n"
"}\n";

static const char *other17 = 
"create constructor method soap_complex_parameter () for soap_parameter\n"
"{\n"
"self.s := vector (composite (), \'\');\n"
"}\n";

static const char *other18 = 
"create constructor method soap_simple_parameter (in val any) for soap_parameter\n"
"{\n"
"self.s := vector (composite (), \'\', val);\n"
"self.param_type := 0;\n"
"}\n";

static const char *other19 = 
"create constructor method soap_array_parameter (in n int) for soap_parameter\n"
"{\n"
"self.s := make_array (n, \'any\');\n"
"self.param_type := 2;\n"
"}\n";

static const char *other20 = 
"create constructor method soap_single_parameter (in elm soap_parameter) for soap_parameter\n"
"{\n"
"self.s := vector (elm.s);\n"
"self.param_type := 2;\n"
"}\n";

static const char *other21 = 
"create method get_length () for soap_parameter\n"
"{\n"
"if (self.s is null)\n"
"return 0;\n"
"\n"
"if (self.param_type)\n"
"return ((length (self.s) - 2) / 2);\n"
"\n"
"return length (self.s[2]);\n"
"}\n";

static const char *other22 = 
"create method add_member (in name varchar, in val any) for soap_parameter\n"
"{\n"
"self.check_struct ();\n"
"if (__tag (val) = 206 and udt_instance_of (val, fix_identifier_case (\'DB.DBA.soap_parameter\')))\n"
"val := (val as soap_parameter).s;\n"
"self.s := vector_concat (self.s, vector (name, val));\n"
"}\n";

static const char *other23 = 
"create method set_member (in name varchar, in val any) for soap_parameter\n"
"{\n"
"declare pos int;\n"
"self.check_struct ();\n"
"if (__tag (val) = 206 and udt_instance_of (val, fix_identifier_case (\'DB.DBA.soap_parameter\')))\n"
"val := (val as soap_parameter).s;\n"
"pos := position (name, self.s);\n"
"if (pos)\n"
"{\n"
"declare tmp any;\n"
"tmp := self.s;\n"
"tmp[pos] := val;\n"
"self.s := tmp;\n"
"}\n"
"else\n"
"self.add_member (name, val);\n"
"}\n";

static const char *other24 = 
"create method set_member (in pos int, in val any) for soap_parameter\n"
"{\n"
"self.check_struct ();\n"
"if (pos >= self.get_length () or pos < 0)\n"
"signal (\'22023\', \'Bad range\');\n"
"\n"
"if (__tag (val) = 206 and udt_instance_of (val, fix_identifier_case (\'DB.DBA.soap_parameter\')))\n"
"val := (val as soap_parameter).s;\n"
"declare tmp any;\n"
"tmp := self.s;\n"
"tmp[((pos+1)*2)+1] := val;\n"
"self.s := tmp;\n"
"}\n";

static const char *other25 = 
"create method get_member (in name varchar) for soap_parameter\n"
"{\n"
"self.check_struct ();\n"
"return get_keyword (name, self.s);\n"
"}\n";

static const char *other26 = 
"create method get_member (in pos int) for soap_parameter\n"
"{\n"
"self.check_struct ();\n"
"return self.s[((pos+1)*2)+1];\n"
"}\n";

static const char *other27 = 
"create method get_value () for soap_parameter\n"
"{\n"
"self.check_simple ();\n"
"return self.s[2];\n"
"}\n";

static const char *other28 = 
"create method set_value (in val any) for soap_parameter\n"
"{\n"
"self.check_simple ();\n"
"declare tmp any;\n"
"tmp := self.s;\n"
"tmp[2] := val;\n"
"self.s := tmp;\n"
"}\n";

static const char *other29 = 
"create method set_attribute (in name varchar, in val any) for soap_parameter\n"
"{\n"
"declare tmp, attr any;\n"
"declare pos int;\n"
"\n"
"tmp := self.s;\n"
"attr := tmp[1];\n"
"\n"
"if (not isarray (attr) or isstring (attr))\n"
"attr := vector ();\n"
"\n"
"pos := position (name, attr);\n"
"if (pos)\n"
"attr[pos] := val;\n"
"else\n"
"attr := vector_concat (attr, vector (name, val));\n"
"\n"
"tmp[1] := attr;\n"
"self.s := tmp;\n"
"}\n";

static const char *other30 = 
"create method get_attribute (in name varchar) for soap_parameter\n"
"{\n"
"declare tmp, attr any;\n"
"tmp := self.s;\n"
"attr := tmp[1];\n"
"\n"
"if (not isarray (attr) or isstring (attr))\n"
"attr := vector ();\n"
"return get_keyword (name, attr);\n"
"}\n";

static const char *other31 = 
"create method set_xsd (in xsd varchar) for soap_parameter\n"
"{\n"
"self.param_xsd := xsd;\n"
"}\n";

static const char *other32 = 
"create method deserialize (in xs any, in elem varchar) for soap_parameter\n"
"{\n"
"declare xt, xp, val any;\n"
"xt := xml_tree_doc (xs);\n"
"xp := xpath_eval (\'//\'||elem, xt, 1);\n"
"if (xp is null)\n"
"{\n"
"self.s := vector ();\n"
"return;\n"
"}\n"
"\n"
"if (self.param_xsd is not null)\n"
"val := soap_box_xml_entity_validating (xml_cut(xp), self.param_xsd);\n"
"else\n"
"val := soap_box_xml_entity (xml_cut(xp), self.s, self.ver);\n"
"self.s := val;\n"
"}\n";

static const char *other33 = 
"create method serialize (in tag varchar) for soap_parameter\n"
"{\n"
"if (self.param_xsd is not null)\n"
"return soap_print_box_validating (self.s, tag, self.param_xsd, 0, 0);\n"
"else\n"
"return soap_print_box (self.s, tag, self.ver);\n"
"}\n";

static const char *other34 = 
"create method get_call_param (in name varchar) for soap_parameter\n"
"{\n"
"if (self.param_xsd is not null)\n"
"return vector (vector (name, self.param_xsd), self.s);\n"
"else\n"
"return vector (name, self.s);\n"
"}\n";

static const char *proc68 = 
"#line 404 \"[executable]/wsrm_ddl.sql\"\n"
"create procedure WSRM_ENSURE_SCH ()\n"
"{\n"
"if (registry_get (\'__wsrm_version__\') = \'0.8\')\n"
"return;\n"
"\n"
"SOAP_LOAD_SCH (WSRM_WSRM_XSD (), null, 0, 0);\n"
"SOAP_LOAD_SCH (WSRM_WSP_XSD (), null, 0, 0);\n"
"SOAP_LOAD_SCH (WSRM_WSA_XSD (), null, 0, 0);\n"
"SOAP_LOAD_SCH (WSRM_UTILITY_XSD (), null, 0, 0);\n"
"SOAP_LOAD_SCH (WSRM_UTILITY200306_XSD (), null, 0, 0);\n"
"SOAP_LOAD_SCH (WSRM_WSS_XSD (), null, 0, 0);\n"
"SOAP_LOAD_SCH (WSRM_WSA200403_XSD (), null, 0, 0);\n"
"SOAP_LOAD_SCH (WSRM_OASIS200401WSSUTILITY_XSD (), null, 0, 0);\n"
"SOAP_LOAD_SCH (WSRM_ORABPEL_XSD (), null, 0, 0);\n"
"SOAP_LOAD_SCH (WSRM_WSRM_2005_02_XSD (), null, 0, 0);\n"
"SOAP_LOAD_SCH (WSRM_WSA200408_XSD (), null, 0, 0);\n"
"\n"
"registry_set (\'__wsrm_version__\', \'0.8\');\n"
"}\n"
"--src wsrm_ddl.sql:402\n"
;


static const char *other35 = 
" WSRM_ENSURE_SCH ()\n";
/* wsrm_xsd.sql */

static const char *proc69 = 
"#line 8 \"[executable]/wsrm_xsd.sql\"\n"
"CREATE PROCEDURE WSRM_WSRM_XSD ()\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"http (\'<?xml version=\"1.0\" encoding=\"UTF-8\"?>\\n\', ses);\n"
"http (\'<xsd:schema\\n\', ses);\n"
"http (\'    	targetNamespace=\"http://schemas.xmlsoap.org/ws/2004/03/rm\"\\n\', ses);\n"
"http (\'	xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2002/07/utility\"\\n\', ses);\n"
"http (\'	xmlns:wsrm=\"http://schemas.xmlsoap.org/ws/2004/03/rm\"\\n\', ses);\n"
"http (\'	xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\\n\', ses);\n"
"http (\'	xmlns:wssu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"\\n\', ses);\n"
"http (\'	elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'	<!-- *** BASE ***\\n\', ses);\n"
"http (\'	-->\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"SequenceType\">\\n\', ses);\n"
"http (\'	<xsd:sequence>\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsu:Identifier\"/>\\n\', ses);\n"
"http (\'	    <xsd:element name=\"MessageNumber\" type=\"xsd:unsignedLong\"/>\\n\', ses);\n"
"http (\'	    <xsd:element name=\"LastMessage\" type=\"xsd:ENTITY\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'	</xsd:sequence>\\n\', ses);\n"
"http (\'	<xsd:attribute ref=\"wssu:Id\" />\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"SequenceTerminate_t\">\\n\', ses);\n"
"http (\'	<xsd:sequence>\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsu:Identifier\"/>\\n\', ses);\n"
"http (\'	</xsd:sequence>\\n\', ses);\n"
"http (\'	<xsd:attribute ref=\"wssu:Id\" />\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"AcknowledgmentRange_t\">\\n\', ses);\n"
"http (\'	<xsd:sequence/>\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"Upper\" type=\"xsd:unsignedLong\" use=\"required\"/>\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"Lower\" type=\"xsd:unsignedLong\" use=\"required\"/>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"SequenceAcknowledgment_t\">\\n\', ses);\n"
"http (\'	<xsd:sequence>\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsu:Identifier\"/>\\n\', ses);\n"
"http (\'	    <xsd:element name=\"AcknowledgmentRange\" type=\"wsrm:AcknowledgmentRange_t\" maxOccurs=\"unbounded\">\\n\', ses);\n"
"http (\'	    </xsd:element>\\n\', ses);\n"
"http (\'	</xsd:sequence>\\n\', ses);\n"
"http (\'	<xsd:attribute ref=\"wssu:Id\" />\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"SequenceAcknowledgement_t\">\\n\', ses);\n"
"http (\'	<xsd:sequence>\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsu:Identifier\"/>\\n\', ses);\n"
"http (\'	    <xsd:element name=\"AcknowledgementRange\" type=\"wsrm:AcknowledgmentRange_t\" maxOccurs=\"unbounded\">\\n\', ses);\n"
"http (\'	    </xsd:element>\\n\', ses);\n"
"http (\'	</xsd:sequence>\\n\', ses);\n"
"http (\'	<xsd:attribute ref=\"wssu:Id\" />\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"AckRequestedType\">\\n\', ses);\n"
"http (\'	<xsd:sequence>\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsu:Identifier\"/>\\n\', ses);\n"
"http (\'	</xsd:sequence>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:element name=\"Sequence\" type=\"wsrm:SequenceType\"/>\\n\', ses);\n"
"http (\'    <xsd:element name=\"SequenceTerminate\" type=\"wsrm:SequenceTerminate_t\"/>\\n\', ses);\n"
"http (\'    <xsd:element name=\"SequenceAcknowledgment\" type=\"wsrm:SequenceAcknowledgment_t\" />\\n\', ses);\n"
"http (\'    <xsd:element name=\"SequenceAcknowledgement\" type=\"wsrm:SequenceAcknowledgement_t\" />\\n\', ses);\n"
"http (\'    <xsd:element name=\"AckRequested\" type=\"wsrm:AckRequestedType\"/>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <!-- *** FAULTS ***\\n\', ses);\n"
"http (\'    -->\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:simpleType name=\"FaultCodes\">\\n\', ses);\n"
"http (\'	<xsd:restriction base=\"xsd:QName\">\\n\', ses);\n"
"http (\'	    <xsd:enumeration value=\"wsrm:UnknownSequence\"/>\\n\', ses);\n"
"http (\'	    <xsd:enumeration value=\"wsrm:SequenceTerminated\"/>\\n\', ses);\n"
"http (\'	    <xsd:enumeration value=\"wsrm:InvalidAcknowledgement\"/>\\n\', ses);\n"
"http (\'	    <xsd:enumeration value=\"wsrm:MessageNumberRollover\"/>\\n\', ses);\n"
"http (\'	</xsd:restriction>\\n\', ses);\n"
"http (\'    </xsd:simpleType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"SequenceFaultType\">\\n\', ses);\n"
"http (\'	<xsd:sequence>\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsu:Identifier\"/>\\n\', ses);\n"
"http (\'	    <xsd:element name=\"FaultCode\" type=\"wsrm:FaultCodes\"/>\\n\', ses);\n"
"http (\'	</xsd:sequence>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:element name=\"SequenceFault\" type=\"wsrm:SequenceFaultType\"/>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <!-- *** ASSERTATIONS ***\\n\', ses);\n"
"http (\'    -->\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"InactivityTimeout_t\">\\n\', ses);\n"
"http (\'	<xsd:sequence/>\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"Milliseconds\" type=\"xsd:unsignedLong\" use=\"required\"/>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"BaseRetransmissionInterval_t\">\\n\', ses);\n"
"http (\'	<xsd:sequence/>\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"Milliseconds\" type=\"xsd:unsignedLong\" use=\"required\"/>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"AcknowledgementInterval_t\">\\n\', ses);\n"
"http (\'	<xsd:sequence/>\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"Milliseconds\" type=\"xsd:unsignedLong\" use=\"required\"/>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"PolicyAssertionType\">\\n\', ses);\n"
"http (\'	<xsd:sequence>\\n\', ses);\n"
"http (\'	    <xsd:any namespace=\"##other\" processContents=\"lax\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\\n\', ses);\n"
"http (\'	</xsd:sequence>\\n\', ses);\n"
"http (\'	<xsd:anyAttribute namespace=\"##other\"/>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:simpleType name=\"DeliveryAssuranceEnum\">\\n\', ses);\n"
"http (\'	<xsd:restriction base=\"xsd:QName\">\\n\', ses);\n"
"http (\'	    <xsd:enumeration value=\"wsrm:AtMostOnce\"/>\\n\', ses);\n"
"http (\'	    <xsd:enumeration value=\"wsrm:AtLeastOnce\"/>\\n\', ses);\n"
"http (\'	    <xsd:enumeration value=\"wsrm:ExactlyOnce\"/>\\n\', ses);\n"
"http (\'	    <xsd:enumeration value=\"wsrm:InOrder\"/>\\n\', ses);\n"
"http (\'	</xsd:restriction>\\n\', ses);\n"
"http (\'    </xsd:simpleType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"DeliveryAssurance_t\">\\n\', ses);\n"
"http (\'	<xsd:sequence/>\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"Value\" type=\"xsd:QName\" use=\"required\"/>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:element name=\"InactivityTimeout\" type=\"wsrm:InactivityTimeout_t\" />\\n\', ses);\n"
"http (\'    <xsd:element name=\"BaseRetransmissionInterval\" type=\"wsrm:BaseRetransmissionInterval_t\" />\\n\', ses);\n"
"http (\'    <xsd:element name=\"ExponentialBackoff\" type=\"wsrm:PolicyAssertionType\"/>\\n\', ses);\n"
"http (\'    <xsd:element name=\"AcknowledgementInterval\" type=\"wsrm:AcknowledgementInterval_t\"/>\\n\', ses);\n"
"http (\'    <xsd:element name=\"DeliveryAssurance\" type=\"wsrm:DeliveryAssurance_t\"/>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <!-- *** Sequence Reference ***\\n\', ses);\n"
"http (\'    -->\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"SequenceRefType\">\\n\', ses);\n"
"http (\'	<xsd:sequence />\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"Identifier\" type=\"xsd:anyURI\" use=\"required\"/>\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"Match\" type=\"wsrm:MatchChoiceType\" use=\"optional\"/>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:simpleType name=\"MatchChoiceType\">\\n\', ses);\n"
"http (\'	<xsd:restriction base=\"xsd:QName\">\\n\', ses);\n"
"http (\'	    <xsd:enumeration value=\"wsrm:Exact\"/>\\n\', ses);\n"
"http (\'	    <xsd:enumeration value=\"wsrm:Prefix\"/>\\n\', ses);\n"
"http (\'	</xsd:restriction>\\n\', ses);\n"
"http (\'    </xsd:simpleType>\\n\', ses);\n"
"http (\'    <xsd:element name=\"SequenceRef\" type=\"wsrm:SequenceRefType\"/>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xsd:element name=\"CreateSequence\" type=\"wsrm:CreateSequenceType\"/>\\n\', ses);\n"
"http (\'  <xsd:complexType name=\"CreateSequenceType\">\\n\', ses);\n"
"http (\'     <xsd:sequence />\\n\', ses);\n"
"http (\'	<xsd:attribute ref=\"wssu:Id\" />\\n\', ses);\n"
"http (\'  </xsd:complexType>\\n\', ses);\n"
"http (\'  <xsd:element name=\"CreateSequenceResponse\" type=\"wsrm:HandshakeType\"/>\\n\', ses);\n"
"http (\'  <xsd:element name=\"TerminateSequence\" type=\"wsrm:HandshakeType\"/>\\n\', ses);\n"
"http (\'  <xsd:complexType name=\"HandshakeType\">\\n\', ses);\n"
"http (\'    <xsd:sequence>\\n\', ses);\n"
"http (\'      <xsd:element ref=\"wsu:Identifier\"/>\\n\', ses);\n"
"http (\'    </xsd:sequence>\\n\', ses);\n"
"http (\'  </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'</xsd:schema>\\n\', ses);\n"
"return string_output_string (ses);\n"
"}\n"
"--src wsrm_xsd.sql:6\n"
;

static const char *proc70 = 
"#line 180 \"[executable]/wsrm_xsd.sql\"\n"
"CREATE PROCEDURE WSRM_WSP_XSD ()\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"http (\'<?xml version=\"1.0\" encoding=\"UTF-8\"?>\\n\', ses);\n"
"http (\'<xsd:schema\\n\', ses);\n"
"http (\'    targetNamespace=\"http://schemas.xmlsoap.org/ws/2002/12/policy\"\\n\', ses);\n"
"http (\'    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\\n\', ses);\n"
"http (\'    xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2002/12/policy\"\\n\', ses);\n"
"http (\'    xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2002/07/utility\"\\n\', ses);\n"
"http (\'    xmlns:wsrm=\"http://schemas.xmlsoap.org/ws/2004/03/rm\"\\n\', ses);\n"
"http (\'    xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2003/03/addressing\"\\n\', ses);\n"
"http (\'    elementFormDefault=\"qualified\" blockDefault=\"#all\">\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:simpleType name=\"UsageType\">\\n\', ses);\n"
"http (\'	<xsd:restriction base=\"xsd:QName\">\\n\', ses);\n"
"http (\'	    <xsd:enumeration value=\"wsp:Required\"/>\\n\', ses);\n"
"http (\'	    <xsd:enumeration value=\"wsp:Optional\"/>\\n\', ses);\n"
"http (\'	    <xsd:enumeration value=\"wsp:Rejected\"/>\\n\', ses);\n"
"http (\'	    <xsd:enumeration value=\"wsp:Ignored\"/>\\n\', ses);\n"
"http (\'	    <xsd:enumeration value=\"wsp:Observed\"/>\\n\', ses);\n"
"http (\'	</xsd:restriction>\\n\', ses);\n"
"http (\'    </xsd:simpleType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"SpecVersionAssertion\">\\n\', ses);\n"
"http (\'	<xsd:sequence />\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"URI\" type=\"xsd:anyURI\" use=\"required\"/>\\n\', ses);\n"
"http (\'	<xsd:attribute name =\"Usage\" type=\"xsd:string\" use=\"optional\"/>\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"Preference\" type=\"xsd:int\" use=\"optional\"/>\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"Id\" type=\"xsd:ID\" use=\"optional\"/>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"PolicyExpression\">\\n\', ses);\n"
"http (\'	<xsd:sequence minOccurs=\"0\" maxOccurs=\"unbounded\">\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsp:SpecVersion\" />\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsrm:DeliveryAssurance\" />\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsu:Expires\" minOccurs=\"0\" maxOccurs=\"1\"/>\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsrm:InactivityTimeout\" />\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsrm:BaseRetransmissionInterval\" />\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsrm:AcknowledgementInterval\" />\\n\', ses);\n"
"http (\'	</xsd:sequence>\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"Name\" type=\"xsd:NCName\" use=\"optional\"/>\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"TargetNamespace\" type=\"xsd:anyURI\" use=\"optional\"/>\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"Id\" type=\"xsd:ID\" use=\"optional\"/>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"PolicyAttachmentType\">\\n\', ses);\n"
"http (\'	<xsd:sequence>\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsp:AppliesTo\"/>\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsp:Policy\" minOccurs=\"0\" />\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsp:PolicyReference\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'	</xsd:sequence>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"AppliesTo\">\\n\', ses);\n"
"http (\'	<xsd:sequence>\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsrm:SequenceRef\" minOccurs=\"0\" maxOccurs=\"1\"/>\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsa:EndpointReference\" minOccurs=\"0\" maxOccurs=\"1\"/>\\n\', ses);\n"
"http (\'	</xsd:sequence>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"PolicyReferenceType\">\\n\', ses);\n"
"http (\'	<xsd:sequence />\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"URI\" type=\"xsd:anyURI\" use=\"optional\"/>\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"Ref\" type=\"xsd:QName\" use=\"optional\"/>\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"Digest\" type=\"xsd:base64Binary\" use=\"optional\"/>\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"DigestAlgorithm\" type=\"xsd:QName\" use=\"optional\"/>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:element name=\"AppliesTo\" type=\"wsp:AppliesTo\"/>\\n\', ses);\n"
"http (\'    <xsd:element name=\"SpecVersion\" type=\"wsp:SpecVersionAssertion\"/>\\n\', ses);\n"
"http (\'    <xsd:element name=\"Policy\" type=\"wsp:PolicyExpression\"/>\\n\', ses);\n"
"http (\'    <xsd:element name=\"PolicyAttachment\" type=\"wsp:PolicyAttachmentType\"/>\\n\', ses);\n"
"http (\'    <xsd:element name=\"PolicyReference\" type=\"wsp:PolicyReferenceType\"/>\\n\', ses);\n"
"http (\'</xsd:schema>\\n\', ses);\n"
"return string_output_string (ses);\n"
"}\n"
"--src wsrm_xsd.sql:178\n"
;

static const char *proc71 = 
"#line 262 \"[executable]/wsrm_xsd.sql\"\n"
"CREATE PROCEDURE WSRM_WSA_XSD ()\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"http (\'<?xml version=\"1.0\"?>\\n\', ses);\n"
"http (\'<xs:schema targetNamespace=\"http://schemas.xmlsoap.org/ws/2003/03/addressing\" xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2002/07/utility\" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2003/03/addressing\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ora=\"http://schemas.oracle.com/bpel\" elementFormDefault=\"qualified\" blockDefault=\"#all\">\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'	<xs:element name=\"EndpointReference\" type=\"wsa:EndpointReferenceType\"/>\\n\', ses);\n"
"http (\'	<xs:complexType name=\"EndpointReferenceType\">\\n\', ses);\n"
"http (\'		<xs:sequence>\\n\', ses);\n"
"http (\'			<xs:element name=\"Address\" type=\"xs:anyURI\"/>\\n\', ses);\n"
"http (\'			<xs:element name=\"ReferenceProperties\" type=\"wsa:ReferencePropertiesType\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'			<xs:element name=\"PortType\" type=\"wsa:AttributedQName\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'			<xs:element name=\"ServiceName\" type=\"wsa:ServiceNameType\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'		</xs:sequence>\\n\', ses);\n"
"http (\'	<xs:attribute ref=\"wsu:Id\" />\\n\', ses);\n"
"http (\'	</xs:complexType>\\n\', ses);\n"
"http (\'	<xs:complexType name=\"ReferencePropertiesType\">\\n\', ses);\n"
"http (\'		<xs:sequence>\\n\', ses);\n"
"http (\'			<xs:any processContents=\"lax\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\\n\', ses);\n"
"http (\'		</xs:sequence>\\n\', ses);\n"
"http (\'	</xs:complexType>\\n\', ses);\n"
"http (\'	<xs:complexType name=\"ServiceNameType\">\\n\', ses);\n"
"http (\'		<xs:simpleContent>\\n\', ses);\n"
"http (\'			<xs:extension base=\"xs:QName\">\\n\', ses);\n"
"http (\'				<xs:attribute name=\"PortName\" type=\"xs:NCName\"/>\\n\', ses);\n"
"http (\'			</xs:extension>\\n\', ses);\n"
"http (\'		</xs:simpleContent>\\n\', ses);\n"
"http (\'	</xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    	<xs:complexType name=\"AttributedURI\">\\n\', ses);\n"
"http (\'		<xs:simpleContent>\\n\', ses);\n"
"http (\'	    		<xs:extension base=\"xs:anyURI\">\\n\', ses);\n"
"http (\'				<xs:attribute ref=\"wsu:Id\" use=\"optional\"/>\\n\', ses);\n"
"http (\'				<xs:attribute ref=\"ora:rootId\" use=\"optional\"/>\\n\', ses);\n"
"http (\'				<xs:attribute ref=\"ora:parentId\" use=\"optional\"/>\\n\', ses);\n"
"http (\'				<xs:attribute ref=\"ora:priority\" use=\"optional\"/>\\n\', ses);\n"
"http (\'	    		</xs:extension>\\n\', ses);\n"
"http (\'		</xs:simpleContent>\\n\', ses);\n"
"http (\'    	</xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'	<xs:element name=\"MessageID\" type=\"wsa:AttributedURI\"/>\\n\', ses);\n"
"http (\'	<xs:element name=\"RelatesTo\" type=\"wsa:Relationship\"/>\\n\', ses);\n"
"http (\'	<xs:element name=\"To\" type=\"wsa:AttributedURI\"/>\\n\', ses);\n"
"http (\'	<xs:element name=\"Action\" type=\"wsa:AttributedURI\" nillable=\"false\" />\\n\', ses);\n"
"http (\'	<xs:element name=\"From\" type=\"wsa:EndpointReferenceType\"/>\\n\', ses);\n"
"http (\'	<xs:element name=\"ReplyTo\" type=\"wsa:EndpointReferenceType\"/>\\n\', ses);\n"
"http (\'	<xs:element name=\"FaultTo\" type=\"wsa:EndpointReferenceType\"/>\\n\', ses);\n"
"http (\'	<xs:element name=\"Recipient\" type=\"wsa:EndpointReferenceType\"/>\\n\', ses);\n"
"http (\'	<xs:complexType name=\"Relationship\">\\n\', ses);\n"
"http (\'		<xs:simpleContent>\\n\', ses);\n"
"http (\'			<xs:extension base=\"xs:anyURI\">\\n\', ses);\n"
"http (\'				<xs:attribute name=\"RelationshipType\" type=\"xs:QName\" use=\"optional\"/>\\n\', ses);\n"
"http (\'				<xs:attribute ref=\"wsu:Id\" />\\n\', ses);\n"
"http (\'			</xs:extension>\\n\', ses);\n"
"http (\'		</xs:simpleContent>\\n\', ses);\n"
"http (\'	</xs:complexType>\\n\', ses);\n"
"http (\'	<xs:simpleType name=\"RelationshipTypeValues\">\\n\', ses);\n"
"http (\'		<xs:restriction base=\"xs:QName\">\\n\', ses);\n"
"http (\'			<xs:enumeration value=\"wsa:Response\"/>\\n\', ses);\n"
"http (\'		</xs:restriction>\\n\', ses);\n"
"http (\'	</xs:simpleType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'	<xs:complexType name=\"AttributedQName\">\\n\', ses);\n"
"http (\'		<xs:simpleContent>\\n\', ses);\n"
"http (\'			<xs:extension base=\"xs:QName\">\\n\', ses);\n"
"http (\'			</xs:extension>\\n\', ses);\n"
"http (\'		</xs:simpleContent>\\n\', ses);\n"
"http (\'	</xs:complexType>\\n\', ses);\n"
"http (\'</xs:schema>\\n\', ses);\n"
"return string_output_string (ses);\n"
"}\n"
"--src wsrm_xsd.sql:260\n"
;

static const char *proc72 = 
"#line 340 \"[executable]/wsrm_xsd.sql\"\n"
"CREATE PROCEDURE WSRM_UTILITY_XSD ()\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"http (\'<?xml version=\"1.0\" encoding=\"UTF-8\"?>\\n\', ses);\n"
"http (\'<xsd:schema targetNamespace=\"http://schemas.xmlsoap.org/ws/2002/07/utility\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2002/07/utility\" xmlns=\"http://schemas.xmlsoap.org/ws/2002/07/utility\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\" version=\"0.1\">\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"AttributedURI\">\\n\', ses);\n"
"http (\'	<xsd:simpleContent>\\n\', ses);\n"
"http (\'	    <xsd:extension base=\"xsd:anyURI\">\\n\', ses);\n"
"http (\'		<xsd:attribute ref=\"wsu:Id\" use=\"optional\"/>\\n\', ses);\n"
"http (\'	    </xsd:extension>\\n\', ses);\n"
"http (\'	</xsd:simpleContent>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"TimestampType\">\\n\', ses);\n"
"http (\'	<xsd:sequence>\\n\', ses);\n"
"http (\'	    <xsd:element name=\"Created\" type=\"wsu:TimestampType_t\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'	    <xsd:element name=\"Expires\" type=\"wsu:TimestampType_t\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'	</xsd:sequence>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"TimestampType_t\">\\n\', ses);\n"
"http (\'	<xsd:simpleContent>\\n\', ses);\n"
"http (\'	    <xsd:extension base=\"xsd:dateTime\">\\n\', ses);\n"
"http (\'		<xsd:attribute ref=\"wsu:Id\" use=\"optional\"/>\\n\', ses);\n"
"http (\'	    </xsd:extension>\\n\', ses);\n"
"http (\'	</xsd:simpleContent>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:element name=\"Timestamp\" type=\"wsu:TimestampType\" />\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:attribute name=\"Id\" type=\"xsd:ID\"/>\\n\', ses);\n"
"http (\'    <xsd:element name=\"Identifier\" type=\"wsu:AttributedURI\" />\\n\', ses);\n"
"http (\'    <xsd:element name=\"Expires\" type=\"wsu:TimestampType_t\" />\\n\', ses);\n"
"http (\'    <xsd:element name=\"Created\" type=\"wsu:TimestampType_t\" />\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'</xsd:schema>\\n\', ses);\n"
"return string_output_string (ses);\n"
"}\n"
"--src wsrm_xsd.sql:338\n"
;

static const char *proc73 = 
"#line 383 \"[executable]/wsrm_xsd.sql\"\n"
"CREATE PROCEDURE WSRM_UTILITY200306_XSD ()\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"http (\'<?xml version=\"1.0\" encoding=\"UTF-8\"?>\\n\', ses);\n"
"http (\'<xsd:schema targetNamespace=\"http://schemas.xmlsoap.org/ws/2003/06/utility\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2003/06/utility\" xmlns=\"http://schemas.xmlsoap.org/ws/2002/07/utility\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\" version=\"0.1\">\\n\', ses);\n"
"http (\'    <xsd:complexType name=\"TimestampType\">\\n\', ses);\n"
"http (\'	<xsd:sequence>\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsu:Created\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'	    <xsd:element ref=\"wsu:Expires\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'	</xsd:sequence>\\n\', ses);\n"
"http (\'	<xsd:attribute type=\"xsd:ID\" use=\"optional\"/>\\n\', ses);\n"
"http (\'    </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:element name=\"Timestamp\" type=\"wsu:TimestampType\" />\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xsd:element name=\"Expires\" type=\"xsd:dateTime\" />\\n\', ses);\n"
"http (\'    <xsd:element name=\"Created\" type=\"xsd:dateTime\" />\\n\', ses);\n"
"http (\'</xsd:schema>\\n\', ses);\n"
"return string_output_string (ses);\n"
"}\n"
"--src wsrm_xsd.sql:381\n"
;

static const char *proc74 = 
"#line 409 \"[executable]/wsrm_xsd.sql\"\n"
"CREATE PROCEDURE WSRM_WSS_XSD ()\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"http (\'<?xml version=\"1.0\" encoding=\"UTF-8\"?>\\n\', ses);\n"
"http (\'<xsd:schema \\n\', ses);\n"
"http (\'    targetNamespace=\"http://schemas.xmlsoap.org/ws/2003/06/secext\" \\n\', ses);\n"
"http (\'    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" \\n\', ses);\n"
"http (\'    xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2003/06/utility\" \\n\', ses);\n"
"http (\'    xmlns:wsse=\"http://schemas.xmlsoap.org/ws/2003/06/secext\" \\n\', ses);\n"
"http (\'    xmlns=\"http://schemas.xmlsoap.org/ws/2003/06/secext\" \\n\', ses);\n"
"http (\'    xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\" \\n\', ses);\n"
"http (\'    elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\\n\', ses);\n"
"http (\'	<xsd:element name=\"Security\" type=\"wsse:SecurityHeaderType\" />\\n\', ses);\n"
"http (\'	<xsd:complexType name=\"SecurityHeaderType\">\\n\', ses);\n"
"http (\'	        <xsd:sequence>\\n\', ses);\n"
"http (\'		  <xsd:element ref=\"wsu:Timestamp\" minOccurs=\"0\" maxOccurs=\"1\" />\\n\', ses);\n"
"http (\'		</xsd:sequence>\\n\', ses);\n"
"http (\'	</xsd:complexType>\\n\', ses);\n"
"http (\'</xsd:schema>\\n\', ses);\n"
"return string_output_string (ses);\n"
"}\n"
"--src wsrm_xsd.sql:407\n"
;

static const char *proc75 = 
"#line 436 \"[executable]/wsrm_xsd.sql\"\n"
"CREATE PROCEDURE WSRM_WSS0212_XSD ()\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"http (\'<?xml version=\"1.0\" encoding=\"UTF-8\"?>\\n\', ses);\n"
"http (\'<xsd:schema targetNamespace=\"http://schemas.xmlsoap.org/ws/2002/12/secext\" \\n\', ses);\n"
"http (\'            xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" \\n\', ses);\n"
"http (\'            xmlns=\"http://schemas.xmlsoap.org/ws/2002/12/secext\" \\n\', ses);\n"
"http (\'            xmlns:wsse=\"http://schemas.xmlsoap.org/ws/2002/12/secext\" \\n\', ses);\n"
"http (\'            xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2002/07/utility\" \\n\', ses);\n"
"http (\'	    xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2002/12/policy\"\\n\', ses);\n"
"http (\'            xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" \\n\', ses);\n"
"http (\'            xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2003/03/addressing\"\\n\', ses);\n"
"http (\'            xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" \\n\', ses);\n"
"http (\'            xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" \\n\', ses);\n"
"http (\'            elementFormDefault=\"qualified\" \\n\', ses);\n"
"http (\'            attributeFormDefault=\"unqualified\" \\n\', ses);\n"
"http (\'            blockDefault=\"#all\" \\n\', ses);\n"
"http (\'            version=\"0.3\">\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'	<xsd:import namespace=\"http://schemas.xmlsoap.org/ws/2002/07/utility\" schemaLocation=\"http://schemas.xmlsoap.org/ws/2002/07/utility\"/>\\n\', ses);\n"
"http (\'    <xsd:import namespace=\"http://schemas.xmlsoap.org/ws/2002/12/policy\" schemaLocation=\"http://schemas.xmlsoap.org/ws/2002/12/policy\" />\\n\', ses);\n"
"http (\'	<xsd:import namespace=\"http://www.w3.org/XML/1998/namespace\" schemaLocation=\"http://www.w3.org/2001/xml.xsd\"/>\\n\', ses);\n"
"http (\'	<xsd:import namespace=\"http://www.w3.org/2000/09/xmldsig#\" schemaLocation=\"http://www.w3.org/TR/2002/REC-xmldsig-core-20020212/xmldsig-core-schema.xsd\"/>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'	<xsd:complexType name=\"AttributedString\">\\n\', ses);\n"
"http (\'		<xsd:simpleContent>\\n\', ses);\n"
"http (\'				<xsd:attribute ref=\"wsu:Id\"/>\\n\', ses);\n"
"http (\'				<xsd:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'		</xsd:simpleContent>\\n\', ses);\n"
"http (\'	</xsd:complexType>\\n\', ses);\n"
"http (\'	<xsd:complexType name=\"PasswordString\">\\n\', ses);\n"
"http (\'		<xsd:simpleContent>\\n\', ses);\n"
"http (\'				<xsd:attribute name=\"Type\" type=\"xsd:QName\"/>\\n\', ses);\n"
"http (\'		</xsd:simpleContent>\\n\', ses);\n"
"http (\'	</xsd:complexType>\\n\', ses);\n"
"http (\'	<xsd:complexType name=\"EncodedString\">\\n\', ses);\n"
"http (\'		<xsd:simpleContent>\\n\', ses);\n"
"http (\'				<xsd:attribute name=\"EncodingType\" type=\"xsd:QName\"/>\\n\', ses);\n"
"http (\'		</xsd:simpleContent>\\n\', ses);\n"
"http (\'	</xsd:complexType>\\n\', ses);\n"
"http (\'	<xsd:complexType name=\"UsernameTokenType\">\\n\', ses);\n"
"http (\'		<xsd:sequence>\\n\', ses);\n"
"http (\'			<xsd:element name=\"Username\" type=\"wsse:AttributedString\"/>\\n\', ses);\n"
"http (\'			<xsd:any processContents=\"lax\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\\n\', ses);\n"
"http (\'		</xsd:sequence>\\n\', ses);\n"
"http (\'		<xsd:attribute ref=\"wsu:Id\"/>\\n\', ses);\n"
"http (\'		<xsd:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'	</xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'	<xsd:complexType name=\"BinarySecurityTokenType\">\\n\', ses);\n"
"http (\'		<xsd:attribute name=\"ValueType\" type=\"xsd:QName\"/>\\n\', ses);\n"
"http (\'		<xsd:attribute name=\"EncodingType\" type=\"xsd:QName\"/>\\n\', ses);\n"
"http (\'		<xsd:attribute ref=\"wsu:Id\"/>\\n\', ses);\n"
"http (\'	</xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'	<xsd:complexType name=\"KeyIdentifierType\">\\n\', ses);\n"
"http (\'		<xsd:simpleContent>\\n\', ses);\n"
"http (\'				<xsd:attribute name=\"ValueType\" type=\"xsd:QName\"/>\\n\', ses);\n"
"http (\'		</xsd:simpleContent>\\n\', ses);\n"
"http (\'	</xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'    <xs:attribute name=\\\'RefType\\\' type=\\\'xs:QName\\\' />\\n\', ses);\n"
"http (\'	<xsd:complexType name=\"ReferenceType\">\\n\', ses);\n"
"http (\'		<xsd:attribute name=\"URI\" type=\"xsd:anyURI\"/>\\n\', ses);\n"
"http (\'		<xsd:attribute ref=\"wsse:RefType\" use=\"optional\" />\\n\', ses);\n"
"http (\'		<xsd:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'	</xsd:complexType>\\n\', ses);\n"
"http (\'	<xsd:complexType name=\"SecurityTokenReferenceType\">\\n\', ses);\n"
"http (\'		<xsd:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\\n\', ses);\n"
"http (\'			<xsd:any processContents=\"lax\"/>\\n\', ses);\n"
"http (\'		</xsd:choice>\\n\', ses);\n"
"http (\'		<xsd:attribute ref=\"wsu:Id\"/>\\n\', ses);\n"
"http (\'		<xsd:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'	</xsd:complexType>\\n\', ses);\n"
"http (\'	<xsd:complexType name=\"SecurityHeaderType\">\\n\', ses);\n"
"http (\'		<xsd:sequence>\\n\', ses);\n"
"http (\'			<xsd:any processContents=\"lax\" minOccurs=\"0\" maxOccurs=\"unbounded\">\\n\', ses);\n"
"http (\'			</xsd:any>\\n\', ses);\n"
"http (\'		</xsd:sequence>\\n\', ses);\n"
"http (\'		<xsd:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'	</xsd:complexType>\\n\', ses);\n"
"http (\'	<xsd:element name=\"UsernameToken\" type=\"wsse:UsernameTokenType\">\\n\', ses);\n"
"http (\'	</xsd:element>\\n\', ses);\n"
"http (\'	<xsd:element name=\"BinarySecurityToken\" type=\"wsse:BinarySecurityTokenType\">\\n\', ses);\n"
"http (\'	</xsd:element>\\n\', ses);\n"
"http (\'	<xsd:element name=\"Reference\" type=\"wsse:ReferenceType\">\\n\', ses);\n"
"http (\'	</xsd:element>\\n\', ses);\n"
"http (\'	<xsd:element name=\"KeyIdentifier\" type=\"wsse:KeyIdentifierType\">\\n\', ses);\n"
"http (\'	</xsd:element>\\n\', ses);\n"
"http (\'	<xsd:element name=\"SecurityTokenReference\" type=\"wsse:SecurityTokenReferenceType\">\\n\', ses);\n"
"http (\'	</xsd:element>\\n\', ses);\n"
"http (\'	<xsd:element name=\"Security\" type=\"wsse:SecurityHeaderType\">\\n\', ses);\n"
"http (\'	</xsd:element>\\n\', ses);\n"
"http (\'	<xsd:element name=\"Password\" type=\"wsse:PasswordString\"/>\\n\', ses);\n"
"http (\'	<xsd:element name=\"Nonce\" type=\"wsse:EncodedString\"/>\\n\', ses);\n"
"http (\'	<xsd:simpleType name=\"PasswordTypeEnum\">\\n\', ses);\n"
"http (\'		<xsd:restriction base=\"xsd:QName\">\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:PasswordText\"/>\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:PasswordDigest\"/>\\n\', ses);\n"
"http (\'		</xsd:restriction>\\n\', ses);\n"
"http (\'	</xsd:simpleType>\\n\', ses);\n"
"http (\'	<xsd:simpleType name=\"ValueTypeEnum\">\\n\', ses);\n"
"http (\'		<xsd:restriction base=\"xsd:QName\">\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:X509v3\"/>\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:Kerberosv5TGT\"/>\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:Kerberosv5ST\"/>\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:PKCS7\"/>\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:PKIPath\"/>\\n\', ses);\n"
"http (\'		</xsd:restriction>\\n\', ses);\n"
"http (\'	</xsd:simpleType>\\n\', ses);\n"
"http (\'	<xsd:simpleType name=\"EncodingTypeEnum\">\\n\', ses);\n"
"http (\'		<xsd:restriction base=\"xsd:QName\">\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:Base64Binary\"/>\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:HexBinary\"/>\\n\', ses);\n"
"http (\'		</xsd:restriction>\\n\', ses);\n"
"http (\'	</xsd:simpleType>\\n\', ses);\n"
"http (\'	<xsd:simpleType name=\"FaultcodeEnum\">\\n\', ses);\n"
"http (\'		<xsd:restriction base=\"xsd:QName\">\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:UnsupportedSecurityToken\"/>\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:UnsupportedAlgorithm\"/>\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:InvalidSecurity\"/>\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:InvalidSecurityToken\"/>\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:FailedAuthentication\"/>\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:FailedCheck\"/>\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:SecurityTokenUnavailable\"/>\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:InvalidRequest\" />\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:RequestFailed\" />\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:AuthenticationBadElements\" />\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:BadRequest\" />\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:ExpiredData\" />\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:InvalidTimeRange\" />\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:BadContextToken\" />\\n\', ses);\n"
"http (\'			<xsd:enumeration value=\"wsse:UnknownDerivationSource\" />\\n\', ses);\n"
"http (\'		</xsd:restriction>\\n\', ses);\n"
"http (\'	</xsd:simpleType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xsd:complexType name=\\\'RequestSecurityTokenType\\\' >\\n\', ses);\n"
"http (\'    <xsd:sequence>\\n\', ses);\n"
"http (\'       <xsd:element name=\\\'TokenType\\\' type=\\\'xsd:string\\\' minOccurs=\"0\" maxOccurs=\"1\" />\\n\', ses);\n"
"http (\'       <xsd:element name=\\\'RequestType\\\' type=\\\'xsd:string\\\' minOccurs=\"0\" maxOccurs=\"1\" />\\n\', ses);\n"
"http (\'       <xsd:element ref=\\\'wsp:AppliesTo\\\' minOccurs=\"0\" maxOccurs=\"1\" />\\n\', ses);\n"
"http (\'    </xsd:sequence>\\n\', ses);\n"
"http (\'  </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xsd:element name=\\\'RequestSecurityToken\\\' type=\\\'wsse:RequestSecurityTokenType\\\' />\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xsd:complexType name=\\\'RequestedSecurityTokenType\\\' >\\n\', ses);\n"
"http (\'    <xsd:sequence>\\n\', ses);\n"
"http (\'       <xsd:element name=\"BinarySecurityToken\" type=\"wsse:BinarySecurityTokenType\"/>\\n\', ses);\n"
"http (\'    </xsd:sequence>\\n\', ses);\n"
"http (\'  </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xsd:complexType name=\\\'RequestSecurityTokenResponseType\\\' >\\n\', ses);\n"
"http (\'    <xsd:sequence>\\n\', ses);\n"
"http (\'       <xsd:element name=\\\'TokenType\\\' type=\\\'xsd:string\\\' minOccurs=\"0\" maxOccurs=\"1\" />\\n\', ses);\n"
"http (\'       <xsd:element name=\\\'RequestedSecurityToken\\\' type=\\\'wsse:RequestedSecurityTokenType\\\' minOccurs=\"0\" maxOccurs=\"1\" />\\n\', ses);\n"
"http (\'    </xsd:sequence>\\n\', ses);\n"
"http (\'  </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xsd:element name=\\\'RequestSecurityTokenResponse\\\' type=\\\'wsse:RequestSecurityTokenResponseType\\\' />\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'Challenge\\\' type=\\\'wsse:ChallengeOrIntegrity\\\' />\\n\', ses);\n"
"http (\'  <xs:element name=\\\'BinaryNegotiation\\\' type=\\\'wsse:BinarySecurityTokenType\\\' /> \\n\', ses);\n"
"http (\'  <xs:element name=\\\'RequestedProofToken\\\' type=\\\'wsse:RequestedSecurityTokenType\\\' />\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xsd:complexType name=\\\'RequestedSecurityTokenType_h\\\' >\\n\', ses);\n"
"http (\'    <xsd:sequence>\\n\', ses);\n"
"http (\'	<xsd:element name=\"wsa:MessageID\" type=\"wsa:AttributedURI\"/>\\n\', ses);\n"
"http (\'	<xsd:element name=\"wsa:From\" type=\"wsa:EndpointReferenceType\"/>\\n\', ses);\n"
"http (\'    </xsd:sequence>\\n\', ses);\n"
"http (\'  </xsd:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'RequestedProofToken_h\\\' type=\\\'wsse:RequestedSecurityTokenType_h\\\' />\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'SecurityHeader\\\' type=\\\'wsse:SecurityHeaderPolType\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'SecurityHeaderPolType\\\' >\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'	  <xs:any namespace=\\\'##any\\\' processContents=\\\'lax\\\' minOccurs=\\\'0\\\' maxOccurs=\\\'unbounded\\\' />\\n\', ses);\n"
"http (\'	</xs:sequence>\\n\', ses);\n"
"http (\'    <xs:attribute ref=\\\'wsp:Usage\\\' use=\\\'required\\\' />\\n\', ses);\n"
"http (\'	<xs:attribute name=\\\'MustPrepend\\\' type=\\\'xs:boolean\\\' />\\n\', ses);\n"
"http (\'	<xs:attribute name=\\\'MustManifestEncryption\\\' type=\\\'xs:boolean\\\' />\\n\', ses);\n"
"http (\'	<xs:anyAttribute namespace=\\\'##any\\\' processContents=\\\'lax\\\' />\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'MessageAge\\\' type=\\\'wsse:MessageAgeType\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'MessageAgeType\\\' >\\n\', ses);\n"
"http (\'    <xs:attribute ref=\\\'wsp:Usage\\\' use=\\\'required\\\' />\\n\', ses);\n"
"http (\'	<xs:attribute ref=\\\'wsp:Preference\\\' use=\\\'optional\\\' />\\n\', ses);\n"
"http (\'	<xs:attribute name=\\\'Age\\\' type=\\\'xs:unsignedInt\\\' use=\\\'required\\\' />\\n\', ses);\n"
"http (\'	<xs:anyAttribute namespace=\\\'##any\\\' processContents=\\\'lax\\\' />\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  \\n\', ses);\n"
"http (\'  <xs:element name=\\\'MessageParts\\\' type=\\\'wsse:XPathSoap\\\' />\\n\', ses);\n"
"http (\'  <xs:element name=\\\'TokenIssuer\\\' type=\\\'xs:string\\\' />\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'Confidentiality\\\' type=\\\'wsse:Confidentiality\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'Confidentiality\\\' >\\n\', ses);\n"
"http (\'	<xs:sequence>\\n\', ses);\n"
"http (\'	  <xs:any namespace=\\\'##any\\\' processContents=\\\'lax\\\' minOccurs=\\\'0\\\' maxOccurs=\\\'unbounded\\\' />\\n\', ses);\n"
"http (\'	</xs:sequence>\\n\', ses);\n"
"http (\'    <xs:attribute name=\\\'Actor\\\' type=\\\'xs:anyURI\\\' use=\\\'optional\\\' />\\n\', ses);\n"
"http (\'    <xs:attribute ref=\\\'wsp:Preference\\\' use=\\\'optional\\\' />\\n\', ses);\n"
"http (\'    <xs:attribute ref=\\\'wsp:Usage\\\' use=\\\'required\\\' />\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'Integrity\\\' type=\\\'wsse:ChallengeOrIntegrity\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'ChallengeOrIntegrity\\\' >\\n\', ses);\n"
"http (\'	<xs:sequence>\\n\', ses);\n"
"http (\'	  <xs:any namespace=\\\'##any\\\' processContents=\\\'lax\\\' minOccurs=\\\'0\\\' maxOccurs=\\\'unbounded\\\' />\\n\', ses);\n"
"http (\'	</xs:sequence>\\n\', ses);\n"
"http (\'    <xs:attribute ref=\\\'wsp:Preference\\\' use=\\\'optional\\\' />\\n\', ses);\n"
"http (\'    <xs:attribute ref=\\\'wsp:Usage\\\' use=\\\'required\\\' />\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'Algorithm\\\' type=\\\'wsse:AlgorithmType\\\' />\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'AlgorithmType\\\' >\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:any namespace=\\\'##any\\\' processContents=\\\'lax\\\' minOccurs=\\\'0\\\' maxOccurs=\\\'unbounded\\\' />\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'    <xs:attribute name=\\\'Type\\\' type=\\\'wsse:AlgorithmTypeOpenEnum\\\' use=\\\'optional\\\' />\\n\', ses);\n"
"http (\'    <xs:attribute name=\\\'URI\\\' type=\\\'xs:anyURI\\\' use=\\\'optional\\\' />\\n\', ses);\n"
"http (\'    <xs:attribute ref=\\\'wsp:Preference\\\' use=\\\'optional\\\' />\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:simpleType name=\\\'AlgorithmTypeEnum\\\' >\\n\', ses);\n"
"http (\'    <xs:restriction base=\\\'xs:QName\\\' >\\n\', ses);\n"
"http (\'	  <xs:enumeration value=\\\'wsse:AlgCanonicalization\\\' />\\n\', ses);\n"
"http (\'	  <xs:enumeration value=\\\'wsse:AlgSignature\\\' />\\n\', ses);\n"
"http (\'	  <xs:enumeration value=\\\'wsse:AlgTransform\\\' />\\n\', ses);\n"
"http (\'	  <xs:enumeration value=\\\'wsse:AlgDigest\\\' />\\n\', ses);\n"
"http (\'	  <xs:enumeration value=\\\'wsse:AlgEncryption\\\' />\\n\', ses);\n"
"http (\'    </xs:restriction>\\n\', ses);\n"
"http (\'  </xs:simpleType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:simpleType name=\\\'AlgorithmTypeOpenEnum\\\' >\\n\', ses);\n"
"http (\'    <xs:union memberTypes=\\\'wsse:AlgorithmTypeEnum xs:QName\\\' />\\n\', ses);\n"
"http (\'  </xs:simpleType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'KeyInfo\\\' type=\\\'wsse:KeyInfoType\\\' />  \\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'KeyInfoType\\\' >\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'	  <xs:element ref=\\\'wsse:SecurityToken\\\' minOccurs=\\\'0\\\' />\\n\', ses);\n"
"http (\'	</xs:sequence>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'SecurityToken\\\' type=\\\'wsse:SecurityTokenType\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'SecurityTokenType\\\' >\\n\', ses);\n"
"http (\'	<xs:sequence>\\n\', ses);\n"
"http (\'	  <xs:any namespace=\\\'##any\\\' processContents=\\\'lax\\\' minOccurs=\\\'0\\\' maxOccurs=\\\'unbounded\\\' />	 \\n\', ses);\n"
"http (\'	</xs:sequence>\\n\', ses);\n"
"http (\'	<xs:attribute ref=\\\'wsp:Preference\\\' use=\\\'optional\\\' />\\n\', ses);\n"
"http (\'    <xs:attribute ref=\\\'wsp:Usage\\\' use=\\\'required\\\' />\\n\', ses);\n"
"http (\'	<xs:anyAttribute namespace=\\\'##other\\\' processContents=\\\'lax\\\' />\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:simpleType name=\\\'TokenTypeEnum\\\' >\\n\', ses);\n"
"http (\'    <xs:restriction base=\\\'xs:QName\\\' >\\n\', ses);\n"
"http (\'      <xs:enumeration value=\\\'wsse:X509v3\\\' />\\n\', ses);\n"
"http (\'      <xs:enumeration value=\\\'wsse:Kerberosv5TGT\\\' />\\n\', ses);\n"
"http (\'      <xs:enumeration value=\\\'wsse:Kerberosv5ST\\\' />\\n\', ses);\n"
"http (\'      <xs:enumeration value=\\\'wsse:UserNameToken\\\' />\\n\', ses);\n"
"http (\'      <xs:enumeration value=\\\'wsse:SAMLAssertion\\\' />\\n\', ses);\n"
"http (\'      <xs:enumeration value=\\\'wsse:XrMLLicense\\\' />\\n\', ses);\n"
"http (\'    </xs:restriction>\\n\', ses);\n"
"http (\'  </xs:simpleType>\\n\', ses);\n"
"http (\'  <xs:simpleType name=\\\'TokenTypeOpenEnum\\\' >\\n\', ses);\n"
"http (\'    <xs:union memberTypes=\\\'wsse:TokenTypeEnum xs:QName\\\' />\\n\', ses);\n"
"http (\'  </xs:simpleType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'Visibility\\\' type=\\\'wsse:VisibilityType\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'VisibilityType\\\' >\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'	  <xs:any namespace=\\\'##any\\\' processContents=\\\'lax\\\' minOccurs=\\\'0\\\' maxOccurs=\\\'unbounded\\\' />\\n\', ses);\n"
"http (\'	</xs:sequence>\\n\', ses);\n"
"http (\'	<xs:attribute ref=\\\'wsp:Usage\\\' use=\\\'required\\\' />\\n\', ses);\n"
"http (\'	<xs:anyAttribute namespace=\\\'##any\\\' processContents=\\\'lax\\\' />\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:simpleType name=\\\'SignerType\\\'>\\n\', ses);\n"
"http (\'    <xs:list itemType=\\\'xs:anyURI\\\' />\\n\', ses);\n"
"http (\'  </xs:simpleType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'SubjectName\\\' type=\\\'wsse:SubjectNameType\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'SubjectNameType\\\' >\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'	  <xs:any namespace=\\\'##any\\\' processContents=\\\'lax\\\' minOccurs=\\\'0\\\' maxOccurs=\\\'unbounded\\\' />\\n\', ses);\n"
"http (\'	</xs:sequence>\\n\', ses);\n"
"http (\'	<xs:attribute name=\\\'MatchType\\\' type=\\\'wsse:MatchTypeEnum\\\' use=\\\'optional\\\' /> \\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:element name=\\\'X509Extension\\\' type=\\\'wsse:X509ExtensionType\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'X509ExtensionType\\\' >\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'	  <xs:any namespace=\\\'##any\\\' processContents=\\\'lax\\\' minOccurs=\\\'0\\\' maxOccurs=\\\'unbounded\\\' />\\n\', ses);\n"
"http (\'	</xs:sequence>\\n\', ses);\n"
"http (\'	<xs:attribute name=\\\'MatchType\\\' type=\\\'wsse:MatchTypeEnum\\\' use=\\\'optional\\\' /> \\n\', ses);\n"
"http (\'	<xs:attribute name=\\\'OID\\\' type=\\\'xs:string\\\' use=\\\'required\\\' />\\n\', ses);\n"
"http (\'	<xs:attribute name=\\\'Critical\\\' type=\\\'xs:boolean\\\' use=\\\'optional\\\' />\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:element name=\\\'UsePassword\\\' type=\\\'wsse:UsePasswordType\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'UsePasswordType\\\' >\\n\', ses);\n"
"http (\'    <xs:attribute name=\\\'Type\\\' type=\\\'wsse:PasswordTypeEnum\\\' use=\\\'optional\\\' /> \\n\', ses);\n"
"http (\'	<xs:attribute ref=\\\'wsp:Usage\\\' use=\\\'required\\\' />\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:simpleType name=\\\'MatchTypeEnum\\\' >\\n\', ses);\n"
"http (\'    <xs:restriction base=\\\'xs:QName\\\' >\\n\', ses);\n"
"http (\'	  <xs:enumeration value=\\\'wsse:Exact\\\' />\\n\', ses);\n"
"http (\'	  <xs:enumeration value=\\\'wsse:Prefix\\\' />\\n\', ses);\n"
"http (\'	  <xs:enumeration value=\\\'wsse:Regexp\\\' />\\n\', ses);\n"
"http (\'	</xs:restriction>\\n\', ses);\n"
"http (\'  </xs:simpleType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'ServiceName\\\' type=\\\'xs:string\\\' />\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:simpleType name=\\\'RequestTypeEnum\\\' >\\n\', ses);\n"
"http (\'    <xs:restriction base=\\\'xs:QName\\\' >\\n\', ses);\n"
"http (\'	  <xs:enumeration value=\\\'wsse:ReqIssue\\\' />\\n\', ses);\n"
"http (\'	  <xs:enumeration value=\\\'wsse:ReqValidate\\\' />\\n\', ses);\n"
"http (\'	  <xs:enumeration value=\\\'wsse:ReqExchange\\\' />\\n\', ses);\n"
"http (\'	</xs:restriction>\\n\', ses);\n"
"http (\'  </xs:simpleType>\\n\', ses);\n"
"http (\'  <xs:simpleType name=\\\'RequestTypeOpenEnum\\\' >\\n\', ses);\n"
"http (\'    <xs:union memberTypes=\\\'wsse:RequestTypeEnum xs:QName\\\' />\\n\', ses);\n"
"http (\'  </xs:simpleType>\\n\', ses);\n"
"http (\'  <xs:element name=\\\'RequestType\\\' type=\\\'wsse:RequestTypeOpenEnum\\\' />\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'Base\\\' type=\\\'wsse:SecurityTokenReferenceType\\\' />\\n\', ses);\n"
"http (\'  <xs:element name=\\\'Supporting\\\' type=\\\'wsse:SecurityTokenReferenceType\\\' />\\n\', ses);\n"
"http (\'  <xs:element name=\\\'Claims\\\' />\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:simpleType name=\\\'KeyEnum\\\' >\\n\', ses);\n"
"http (\'    <xs:restriction base=\\\'xs:QName\\\' >\\n\', ses);\n"
"http (\'	  <xs:enumeration value=\\\'wsse:PublicKey\\\' />\\n\', ses);\n"
"http (\'	  <xs:enumeration value=\\\'wsse:SymmetricKey\\\' />\\n\', ses);\n"
"http (\'	</xs:restriction>\\n\', ses);\n"
"http (\'  </xs:simpleType>\\n\', ses);\n"
"http (\'  <xs:simpleType name=\\\'KeyOpenEnum\\\' >\\n\', ses);\n"
"http (\'    <xs:union memberTypes=\\\'wsse:KeyEnum xs:QName\\\' />\\n\', ses);\n"
"http (\'  </xs:simpleType>\\n\', ses);\n"
"http (\'  <xs:element name=\\\'KeyType\\\' type=\\\'wsse:KeyOpenEnum\\\' />\\n\', ses);\n"
"http (\'  <xs:element name=\\\'RequestKeyType\\\' type=\\\'wsse:KeyOpenEnum\\\' />\\n\', ses);\n"
"http (\'  <xs:element name=\\\'KeySize\\\' type=\\\'xs:unsignedInt\\\' />\\n\', ses);\n"
"http (\'  <xs:element name=\\\'RequestKeySize\\\' type=\\\'xs:unsignedInt\\\' />\\n\', ses);\n"
"http (\'  <xs:element name=\\\'RequestSignatureAlgorithm\\\' type=\\\'xs:anyURI\\\' />\\n\', ses);\n"
"http (\'  <xs:element name=\\\'RequestEncryption\\\' type=\\\'wsse:SecurityTokenReferenceType\\\' />\\n\', ses);\n"
"http (\'  <xs:element name=\\\'RequestProofEncryption\\\' type=\\\'wsse:SecurityTokenReferenceType\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'SecurityTokenReferences\\\' >\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:element ref=\\\'wsse:SecurityTokenReference\\\' maxOccurs=\\\'unbounded\\\' />\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'UseBase\\\' >\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'UsePublicKey\\\' type=\\\'wsse:UsePublicKeyType\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'UsePublicKeyType\\\' >\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:element ref=\\\'ds:KeyInfo\\\' />\\n\', ses);\n"
"http (\'	</xs:sequence>\\n\', ses);\n"
"http (\'    <xs:attribute name=\\\'Sig\\\' type=\\\'xs:anyURI\\\' use=\\\'optional\\\' />\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'OnBehalfOf\\\' type=\\\'wsse:TokenOrRef\\\' />\\n\', ses);\n"
"http (\'  <xs:element name=\\\'DelegateTo\\\' type=\\\'wsse:TokenOrRef\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'TokenOrRef\\\' >\\n\', ses);\n"
"http (\'	<xs:sequence>\\n\', ses);\n"
"http (\'	  <xs:any namespace=\\\'##any\\\' processContents=\\\'lax\\\' minOccurs=\\\'0\\\' maxOccurs=\\\'unbounded\\\' />\\n\', ses);\n"
"http (\'	</xs:sequence>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'Forwardable\\\' />\\n\', ses);\n"
"http (\'  <xs:element name=\\\'Delegatable\\\' />\\n\', ses);\n"
"http (\'  <xs:element name=\\\'Proxiable\\\' />\\n\', ses);\n"
"http (\'  <xs:element name=\\\'AllowPostdating\\\' />\\n\', ses);\n"
"http (\'  <xs:element name=\\\'Renewing\\\' type=\\\'wsse:RenewingType\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'RenewingType\\\' >\\n\', ses);\n"
"http (\'    <xs:attribute name=\\\'Allow\\\' type=\\\'xs:boolean\\\' />\\n\', ses);\n"
"http (\'    <xs:attribute name=\\\'OK\\\' type=\\\'xs:boolean\\\' />\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'LifeTime\\\' type=\\\'wsse:LifeTimeType\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'LifeTimeType\\\' >\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:element ref=\\\'wsu:Created\\\' minOccurs=\\\'0\\\' /> \\n\', ses);\n"
"http (\'      <xs:element ref=\\\'wsu:Expires\\\' minOccurs=\\\'0\\\' />\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'SignChallenge\\\' type=\\\'wsse:SignChallengeType\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'SignChallengeType\\\' >\\n\', ses);\n"
"http (\'	<xs:sequence>\\n\', ses);\n"
"http (\'	  <xs:any namespace=\\\'##any\\\' processContents=\\\'lax\\\' minOccurs=\\\'0\\\' maxOccurs=\\\'unbounded\\\' />\\n\', ses);\n"
"http (\'	</xs:sequence>\\n\', ses);\n"
"http (\'	<xs:anyAttribute namespace=\\\'##any\\\' processContents=\\\'lax\\\' />\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:element name=\\\'SignChallengeResponse\\\' type=\\\'wsse:SignChallengeResponseType\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'SignChallengeResponseType\\\' >\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'	  <xs:any namespace=\\\'##any\\\' processContents=\\\'lax\\\' minOccurs=\\\'0\\\' maxOccurs=\\\'unbounded\\\' />\\n\', ses);\n"
"http (\'	</xs:sequence>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'SecurityContextToken\\\' type=\\\'wsse:SecurityContextTokenType\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'SecurityContextTokenType\\\' >\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'	   <xs:any namespace=\\\'##any\\\' processContents=\\\'lax\\\' minOccurs=\\\'0\\\' maxOccurs=\\\'unbounded\\\' />\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'	<xs:attribute ref=\\\'wsu:Id\\\' use=\\\'optional\\\' />\\n\', ses);\n"
"http (\'	<xs:anyAttribute namespace=\\\'##other\\\' processContents=\\\'lax\\\' />\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'Keys\\\' type=\\\'wsse:KeysType\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'KeysType\\\' >\\n\', ses);\n"
"http (\'	<xs:sequence>\\n\', ses);\n"
"http (\'		<xs:any namespace=\\\'##any\\\' processContents=\\\'lax\\\' minOccurs=\\\'0\\\' maxOccurs=\\\'unbounded\\\' />\\n\', ses);\n"
"http (\'	</xs:sequence>  \\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'DerivedKeyToken\\\' type=\\\'wsse:Key\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'Key\\\' >\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:element ref=\\\'wsse:SecurityTokenReference\\\' minOccurs=\\\'0\\\' />\\n\', ses);\n"
"http (\'	  <xs:element name=\\\'Properties\\\' type=\\\'wsse:PropertiesType\\\' minOccurs=\\\'0\\\' />\\n\', ses);\n"
"http (\'	  <xs:choice minOccurs=\\\'0\\\' >\\n\', ses);\n"
"http (\'        <xs:element name=\\\'Generation\\\' type=\\\'xs:unsignedLong\\\' />\\n\', ses);\n"
"http (\'        <xs:sequence>\\n\', ses);\n"
"http (\'          <xs:element name=\\\'Offset\\\' type=\\\'xs:unsignedLong\\\' />\\n\', ses);\n"
"http (\'		  <xs:element name=\\\'Length\\\' type=\\\'xs:unsignedLong\\\' minOccurs=\\\'0\\\' />\\n\', ses);\n"
"http (\'        </xs:sequence>\\n\', ses);\n"
"http (\'      </xs:choice>\\n\', ses);\n"
"http (\'      <xs:element ref=\\\'wsse:Label\\\' minOccurs=\\\'0\\\' />\\n\', ses);\n"
"http (\'      <xs:element ref=\\\'wsse:Nonce\\\' minOccurs=\\\'0\\\' />\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'    <xs:attribute ref=\\\'wsu:Id\\\' />\\n\', ses);\n"
"http (\'    <xs:attribute name=\\\'Algorithm\\\' type=\\\'wsse:AlgorithmTypeOpenEnum\\\' form=\\\'qualified\\\' use=\\\'optional\\\' />\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'\\n\', ses);\n"
"http (\'  <xs:element name=\\\'Label\\\' type=\\\'xs:string\\\' />\\n\', ses);\n"
"http (\'  <xs:element name=\\\'Name\\\' type=\\\'xs:anyURI\\\' />\\n\', ses);\n"
"http (\'  <xs:complexType name=\\\'PropertiesType\\\' >\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:any namespace=\\\'##any\\\' processContents=\\\'lax\\\' minOccurs=\\\'0\\\' maxOccurs=\\\'unbounded\\\' />\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'</xsd:schema>\\n\', ses);\n"
"return string_output_string (ses);\n"
"}\n"
"--src wsrm_xsd.sql:434\n"
;

static const char *proc76 = 
"#line 904 \"[executable]/wsrm_xsd.sql\"\n"
"CREATE PROCEDURE WSRM_WSA200403_XSD ()\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"http (\'<?xml version=\"1.0\"?>\\n\', ses);\n"
"http (\'<xs:schema xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2002/07/utility\" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/03/addressing\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://schemas.xmlsoap.org/ws/2004/03/addressing\" elementFormDefault=\"qualified\" blockDefault=\"#all\" xmlns:wssu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\">\\n\', ses);\n"
"http (\'  <xs:element name=\"EndpointReference\" type=\"wsa:EndpointReferenceType\"/>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"EndpointReferenceType\">\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:element name=\"Address\" type=\"xs:anyURI\"/>\\n\', ses);\n"
"http (\'      <xs:element name=\"ReferenceProperties\" type=\"wsa:ReferencePropertiesType\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'      <xs:element name=\"PortType\" type=\"wsa:AttributedQName\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'      <xs:element name=\"ServiceName\" type=\"wsa:ServiceNameType\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'    <xs:attribute ref=\"wssu:Id\"/>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"ReferencePropertiesType\">\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:any processContents=\"lax\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"ServiceNameType\">\\n\', ses);\n"
"http (\'    <xs:simpleContent>\\n\', ses);\n"
"http (\'      <xs:extension base=\"xs:QName\">\\n\', ses);\n"
"http (\'        <xs:attribute name=\"PortName\" type=\"xs:NCName\"/>\\n\', ses);\n"
"http (\'      </xs:extension>\\n\', ses);\n"
"http (\'    </xs:simpleContent>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"AttributedURI\">\\n\', ses);\n"
"http (\'    <xs:simpleContent>\\n\', ses);\n"
"http (\'      <xs:extension base=\"xs:anyURI\">\\n\', ses);\n"
"http (\'        <xs:attribute ref=\"wssu:Id\"/>\\n\', ses);\n"
"http (\'      </xs:extension>\\n\', ses);\n"
"http (\'    </xs:simpleContent>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:element name=\"MessageID\" type=\"wsa:AttributedURI\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"RelatesTo\" type=\"wsa:Relationship\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"To\" type=\"wsa:AttributedURI\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"Action\" type=\"wsa:AttributedURI\" nillable=\"false\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"From\" type=\"wsa:EndpointReferenceType\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"ReplyTo\" type=\"wsa:EndpointReferenceType\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"FaultTo\" type=\"wsa:EndpointReferenceType\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"Recipient\" type=\"wsa:EndpointReferenceType\"/>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"Relationship\">\\n\', ses);\n"
"http (\'    <xs:simpleContent>\\n\', ses);\n"
"http (\'      <xs:extension base=\"xs:anyURI\">\\n\', ses);\n"
"http (\'        <xs:attribute name=\"RelationshipType\" type=\"xs:QName\" use=\"optional\"/>\\n\', ses);\n"
"http (\'        <xs:attribute ref=\"wssu:Id\"/>\\n\', ses);\n"
"http (\'      </xs:extension>\\n\', ses);\n"
"http (\'    </xs:simpleContent>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:simpleType name=\"RelationshipTypeValues\">\\n\', ses);\n"
"http (\'    <xs:restriction base=\"xs:QName\">\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsa:Reply\"/>\\n\', ses);\n"
"http (\'    </xs:restriction>\\n\', ses);\n"
"http (\'  </xs:simpleType>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"AttributedQName\">\\n\', ses);\n"
"http (\'    <xs:simpleContent>\\n\', ses);\n"
"http (\'      <xs:extension base=\"xs:QName\">\\n\', ses);\n"
"http (\'			</xs:extension>\\n\', ses);\n"
"http (\'    </xs:simpleContent>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:element name=\"ReplyAfter\"/>\\n\', ses);\n"
"http (\'  <xs:simpleType name=\"FaultSubcodeValues\">\\n\', ses);\n"
"http (\'    <xs:restriction base=\"xs:QName\">\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsa:InvalidMessageInformationHeader\"/>\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsa:MessageInformationHeaderRequired\"/>\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsa:DestinationUnreachable\"/>\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsa:ActionNotSupported\"/>\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsa:EndpointUnavailable\"/>\\n\', ses);\n"
"http (\'    </xs:restriction>\\n\', ses);\n"
"http (\'  </xs:simpleType>\\n\', ses);\n"
"http (\'  <xs:attribute name=\"Action\" type=\"xs:anyURI\"/>\\n\', ses);\n"
"http (\'</xs:schema>\\n\', ses);\n"
"return string_output_string (ses);\n"
"}\n"
"--src wsrm_xsd.sql:902\n"
;

static const char *proc77 = 
"#line 985 \"[executable]/wsrm_xsd.sql\"\n"
"CREATE PROCEDURE WSRM_OASIS200401WSSUTILITY_XSD ()\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"http (\'<?xml version=\"1.0\" encoding=\"UTF-8\"?>\\n\', ses);\n"
"http (\'<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\" xmlns=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\" targetNamespace=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\" version=\"0.1\">\\n\', ses);\n"
"http (\'  <xsd:simpleType name=\"tTimestampFault\">\\n\', ses);\n"
"http (\'    <xsd:restriction base=\"xsd:QName\">\\n\', ses);\n"
"http (\'      <xsd:enumeration value=\"wsu:MessageExpired\"/>\\n\', ses);\n"
"http (\'    </xsd:restriction>\\n\', ses);\n"
"http (\'  </xsd:simpleType>\\n\', ses);\n"
"http (\'  <xsd:attribute name=\"Id\" type=\"xsd:ID\" />\\n\', ses);\n"
"http (\'  <xsd:complexType name=\"AttributedDateTime\">\\n\', ses);\n"
"http (\'    <xsd:simpleContent>\\n\', ses);\n"
"http (\'      <xsd:extension base=\"xsd:string\">\\n\', ses);\n"
"http (\'    <xsd:attribute ref=\"wsu:Id\" use=\"optional\"/>\\n\', ses);\n"
"http (\'      </xsd:extension>\\n\', ses);\n"
"http (\'    </xsd:simpleContent>\\n\', ses);\n"
"http (\'  </xsd:complexType>\\n\', ses);\n"
"http (\'  <xsd:complexType name=\"AttributedURI\">\\n\', ses);\n"
"http (\'    <xsd:simpleContent>\\n\', ses);\n"
"http (\'      <xsd:extension base=\"xsd:anyURI\">\\n\', ses);\n"
"http (\'    <xsd:attribute ref=\"wsu:Id\" use=\"optional\"/>\\n\', ses);\n"
"http (\'      </xsd:extension>\\n\', ses);\n"
"http (\'    </xsd:simpleContent>\\n\', ses);\n"
"http (\'  </xsd:complexType>\\n\', ses);\n"
"http (\'  <xsd:complexType name=\"TimestampType\">\\n\', ses);\n"
"http (\'    <xsd:sequence>\\n\', ses);\n"
"http (\'      <xsd:element ref=\"wsu:Created\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'      <xsd:element ref=\"wsu:Expires\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'    </xsd:sequence>\\n\', ses);\n"
"http (\'    <xsd:attribute ref=\"wsu:Id\" use=\"optional\"/>\\n\', ses);\n"
"http (\'  </xsd:complexType>\\n\', ses);\n"
"http (\'  <xsd:element name=\"Timestamp\" type=\"wsu:TimestampType\"/>\\n\', ses);\n"
"http (\'  <xsd:element name=\"Expires\" type=\"wsu:AttributedDateTime\"/>\\n\', ses);\n"
"http (\'  <xsd:element name=\"Created\" type=\"wsu:AttributedDateTime\"/>\\n\', ses);\n"
"http (\'</xsd:schema>\\n\', ses);\n"
"return string_output_string (ses);\n"
"}\n"
"--src wsrm_xsd.sql:983\n"
;

static const char *proc78 = 
"#line 1029 \"[executable]/wsrm_xsd.sql\"\n"
"CREATE PROCEDURE WSRM_ORABPEL_XSD ()\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"http (\'<?xml version=\"1.0\"?>\\n\', ses);\n"
"http (\'<xsd:schema targetNamespace=\"http://schemas.oracle.com/bpel\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\">\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"rootId\" type=\"xsd:string\" />\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"parentId\" type=\"xsd:string\" />\\n\', ses);\n"
"http (\'	<xsd:attribute name=\"priority\" type=\"xsd:string\" />\\n\', ses);\n"
"http (\'</xsd:schema>\\n\', ses);\n"
"return string_output_string (ses);\n"
"}\n"
"--src wsrm_xsd.sql:1027\n"
;

static const char *proc79 = 
"#line 1046 \"[executable]/wsrm_xsd.sql\"\n"
"CREATE PROCEDURE WSRM_WSRM_2005_02_XSD ()\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"http (\'<?xml version=\"1.0\" encoding=\"UTF-8\"?>\\n\', ses);\n"
"http (\'<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\\n\', ses);\n"
"http (\'	   xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\"\\n\', ses);\n"
"http (\'	   xmlns:wsrm=\"http://schemas.xmlsoap.org/ws/2005/02/rm\"\\n\', ses);\n"
"http (\'	   xmlns:wssu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"\\n\', ses);\n"
"http (\'	   targetNamespace=\"http://schemas.xmlsoap.org/ws/2005/02/rm\"\\n\', ses);\n"
"http (\'	   elementFormDefault=\"qualified\"\\n\', ses);\n"
"http (\'	   attributeFormDefault=\"unqualified\">\\n\', ses);\n"
"http (\'  <xs:import namespace=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\"\\n\', ses);\n"
"http (\'	     schemaLocation=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\"/>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"SequenceType\">\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:element ref=\"wsrm:Identifier\"/>\\n\', ses);\n"
"http (\'      <xs:element name=\"MessageNumber\" type=\"xs:unsignedLong\"/>\\n\', ses);\n"
"http (\'      <xs:element name=\"LastMessage\" type=\"xs:ENTITY\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'    <xs:attribute ref=\"wssu:Id\" />\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:element name=\"Sequence\" type=\"wsrm:SequenceType\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"SequenceAcknowledgement\" type=\"wsrm:SequenceAcknowledgement_t\">\\n\', ses);\n"
"http (\'  </xs:element>\\n\', ses);\n"
"http (\'    <xs:complexType name=\"SequenceAcknowledgement_t\">\\n\', ses);\n"
"http (\'      <xs:sequence>\\n\', ses);\n"
"http (\'        <xs:element ref=\"wsrm:Identifier\"/>\\n\', ses);\n"
"http (\'          <xs:element name=\"AcknowledgementRange\" maxOccurs=\"unbounded\" type=\"wsrm:AcknowledgementRange_t\" minOccurs=\"0\">\\n\', ses);\n"
"http (\'          </xs:element>\\n\', ses);\n"
"http (\'          <xs:element name=\"Nack\" type=\"xs:unsignedLong\" maxOccurs=\"unbounded\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'      </xs:sequence>\\n\', ses);\n"
"http (\'      <xs:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'    </xs:complexType>\\n\', ses);\n"
"http (\'            <xs:complexType name=\"AcknowledgementRange_t\">\\n\', ses);\n"
"http (\'              <xs:sequence/>\\n\', ses);\n"
"http (\'              <xs:attribute name=\"Upper\" type=\"xs:unsignedLong\" use=\"required\"/>\\n\', ses);\n"
"http (\'              <xs:attribute name=\"Lower\" type=\"xs:unsignedLong\" use=\"required\"/>\\n\', ses);\n"
"http (\'              <xs:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'            </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"AckRequestedType\">\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:element ref=\"wsrm:Identifier\"/>\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'    <xs:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:element name=\"AckRequested\" type=\"wsrm:AckRequestedType\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"Identifier\">\\n\', ses);\n"
"http (\'    <xs:complexType>\\n\', ses);\n"
"http (\'      <xs:simpleContent>\\n\', ses);\n"
"http (\'        <xs:extension base=\"xs:anyURI\">\\n\', ses);\n"
"http (\'        </xs:extension>\\n\', ses);\n"
"http (\'      </xs:simpleContent>\\n\', ses);\n"
"http (\'    </xs:complexType>\\n\', ses);\n"
"http (\'  </xs:element>\\n\', ses);\n"
"http (\'  <xs:simpleType name=\"FaultCodes\">\\n\', ses);\n"
"http (\'    <xs:restriction base=\"xs:QName\">\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsrm:UnknownSequence\"/>\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsrm:SequenceTerminated\"/>\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsrm:InvalidAcknowledgement\"/>\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsrm:MessageNumberRollover\"/>\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsrm:CreateSequenceRefused\"/>\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsrm:LastMessageNumberExceeded\"/>\\n\', ses);\n"
"http (\'    </xs:restriction>\\n\', ses);\n"
"http (\'  </xs:simpleType>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"SequenceFaultType\">\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:element name=\"FaultCode\" type=\"xs:QName\" minOccurs=\"0\" />\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'    <xs:anyAttribute namespace=\"##any\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:element name=\"SequenceFault\" type=\"wsrm:SequenceFaultType\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"CreateSequence\" type=\"wsrm:CreateSequenceType\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"CreateSequenceResponse\" type=\"wsrm:CreateSequenceResponseType\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"TerminateSequence\" type=\"wsrm:TerminateSequenceType\"/>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"CreateSequenceType\">\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:element ref=\"wsrm:AcksTo\"/>\\n\', ses);\n"
"http (\'      <xs:element ref=\"wsrm:Expires\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'      <xs:element name=\"Offer\" type=\"wsrm:OfferType\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'      <xs:any namespace=\"##other\" processContents=\"lax\" minOccurs=\"0\" maxOccurs=\"unbounded\">\\n\', ses);\n"
"http (\'      </xs:any>\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'    <xs:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"CreateSequenceResponseType\">\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:element ref=\"wsrm:Identifier\"/>\\n\', ses);\n"
"http (\'      <xs:element name=\"Accept\" type=\"wsrm:AcceptType\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'      <xs:element ref=\"wsrm:Expires\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'      <xs:any namespace=\"##other\" processContents=\"lax\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'    <xs:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"TerminateSequenceType\">\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:element ref=\"wsrm:Identifier\"/>\\n\', ses);\n"
"http (\'      <xs:any namespace=\"##other\" processContents=\"lax\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'    <xs:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:element name=\"AcksTo\" type=\"wsa:EndpointReferenceType\"/>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"OfferType\">\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:element ref=\"wsrm:Identifier\"/>\\n\', ses);\n"
"http (\'      <xs:element ref=\"wsrm:Expires\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'      <xs:any namespace=\"##other\" processContents=\"lax\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'    <xs:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"AcceptType\">\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:element ref=\"wsrm:AcksTo\"/>\\n\', ses);\n"
"http (\'      <xs:any namespace=\"##other\" processContents=\"lax\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:element name=\"Expires\">\\n\', ses);\n"
"http (\'    <xs:complexType>\\n\', ses);\n"
"http (\'      <xs:simpleContent>\\n\', ses);\n"
"http (\'        <xs:extension base=\"xs:duration\">\\n\', ses);\n"
"http (\'          <xs:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'        </xs:extension>\\n\', ses);\n"
"http (\'      </xs:simpleContent>\\n\', ses);\n"
"http (\'    </xs:complexType>\\n\', ses);\n"
"http (\'  </xs:element>\\n\', ses);\n"
"http (\'</xs:schema>\\n\', ses);\n"
"return string_output_string (ses);\n"
"}\n"
"--src wsrm_xsd.sql:1044\n"
;

static const char *proc80 = 
"#line 1179 \"[executable]/wsrm_xsd.sql\"\n"
"CREATE PROCEDURE WSRM_WSA200408_XSD ()\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"http (\'<?xml version=\"1.0\"?>\\n\', ses);\n"
"http (\'<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" targetNamespace=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" elementFormDefault=\"qualified\" blockDefault=\"#all\"\\n\', ses);\n"
"http (\'  xmlns:wssu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\">\\n\', ses);\n"
"http (\'  <xs:element name=\"EndpointReference\" type=\"wsa:EndpointReferenceType\"/>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"EndpointReferenceType\">\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:element name=\"Address\" type=\"xs:anyURI\"/>\\n\', ses);\n"
"http (\'      <xs:element name=\"ReferenceProperties\" type=\"wsa:ReferencePropertiesType\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'      <xs:element name=\"ReferenceParameters\" type=\"wsa:ReferenceParametersType\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'      <xs:element name=\"PortType\" type=\"wsa:AttributedQName\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'      <xs:element name=\"ServiceName\" type=\"wsa:ServiceNameType\" minOccurs=\"0\"/>\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'    <xs:attribute ref=\"wssu:Id\"/>\\n\', ses);\n"
"http (\'    <xs:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"ReferencePropertiesType\">\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:any processContents=\"lax\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"ReferenceParametersType\">\\n\', ses);\n"
"http (\'    <xs:sequence>\\n\', ses);\n"
"http (\'      <xs:any processContents=\"lax\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\\n\', ses);\n"
"http (\'    </xs:sequence>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"ServiceNameType\">\\n\', ses);\n"
"http (\'    <xs:simpleContent>\\n\', ses);\n"
"http (\'      <xs:extension base=\"xs:QName\">\\n\', ses);\n"
"http (\'        <xs:attribute name=\"PortName\" type=\"xs:NCName\"/>\\n\', ses);\n"
"http (\'        <xs:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'      </xs:extension>\\n\', ses);\n"
"http (\'    </xs:simpleContent>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:element name=\"MessageID\" type=\"wsa:AttributedURI\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"RelatesTo\" type=\"wsa:Relationship\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"To\" type=\"wsa:AttributedURI\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"Action\" type=\"wsa:AttributedURI\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"From\" type=\"wsa:EndpointReferenceType\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"ReplyTo\" type=\"wsa:EndpointReferenceType\"/>\\n\', ses);\n"
"http (\'  <xs:element name=\"FaultTo\" type=\"wsa:EndpointReferenceType\"/>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"Relationship\">\\n\', ses);\n"
"http (\'    <xs:simpleContent>\\n\', ses);\n"
"http (\'      <xs:extension base=\"xs:anyURI\">\\n\', ses);\n"
"http (\'        <xs:attribute name=\"RelationshipType\" type=\"xs:QName\" use=\"optional\"/>\\n\', ses);\n"
"http (\'        <xs:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'      </xs:extension>\\n\', ses);\n"
"http (\'    </xs:simpleContent>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:simpleType name=\"RelationshipTypeValues\">\\n\', ses);\n"
"http (\'    <xs:restriction base=\"xs:QName\">\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsa:Reply\"/>\\n\', ses);\n"
"http (\'    </xs:restriction>\\n\', ses);\n"
"http (\'  </xs:simpleType>\\n\', ses);\n"
"http (\'  <xs:element name=\"ReplyAfter\" type=\"wsa:ReplyAfterType\"/>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"ReplyAfterType\">\\n\', ses);\n"
"http (\'    <xs:simpleContent>\\n\', ses);\n"
"http (\'      <xs:extension base=\"xs:nonNegativeInteger\">\\n\', ses);\n"
"http (\'        <xs:anyAttribute namespace=\"##other\"/>\\n\', ses);\n"
"http (\'      </xs:extension>\\n\', ses);\n"
"http (\'    </xs:simpleContent>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:simpleType name=\"FaultSubcodeValues\">\\n\', ses);\n"
"http (\'    <xs:restriction base=\"xs:QName\">\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsa:InvalidMessageInformationHeader\"/>\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsa:MessageInformationHeaderRequired\"/>\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsa:DestinationUnreachable\"/>\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsa:ActionNotSupported\"/>\\n\', ses);\n"
"http (\'      <xs:enumeration value=\"wsa:EndpointUnavailable\"/>\\n\', ses);\n"
"http (\'    </xs:restriction>\\n\', ses);\n"
"http (\'  </xs:simpleType>\\n\', ses);\n"
"http (\'  <xs:attribute name=\"Action\" type=\"xs:anyURI\"/>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"AttributedQName\">\\n\', ses);\n"
"http (\'    <xs:simpleContent>\\n\', ses);\n"
"http (\'      <xs:extension base=\"xs:QName\">\\n\', ses);\n"
"http (\'        <xs:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'      </xs:extension>\\n\', ses);\n"
"http (\'    </xs:simpleContent>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'  <xs:complexType name=\"AttributedURI\">\\n\', ses);\n"
"http (\'    <xs:simpleContent>\\n\', ses);\n"
"http (\'      <xs:extension base=\"xs:anyURI\">\\n\', ses);\n"
"http (\'        <xs:anyAttribute namespace=\"##other\" processContents=\"lax\"/>\\n\', ses);\n"
"http (\'      </xs:extension>\\n\', ses);\n"
"http (\'    </xs:simpleContent>\\n\', ses);\n"
"http (\'  </xs:complexType>\\n\', ses);\n"
"http (\'</xs:schema>\\n\', ses);\n"
"return string_output_string (ses);\n"
"}\n"
"--src wsrm_xsd.sql:1177\n"
;

/* wsrmcli.sql */

static const char *udt3 = 
"create type wsrm_cli as\n"
"(\n"
"url varchar,\n"
"seq varchar,\n"
"msgno int default -1,\n"
"assurance varchar,\n"
"expiry datetime,\n"
"address WSA_CLI,\n"
"i_timeout int,\n"
"resend_intl int,\n"
"ack_intl int,\n"
"dirty int default 0,\n"
"is_last int default 0,\n"
"is_finish int default 0\n"
")\n"
"temporary self as ref\n"
"constructor method wsrm_cli (addr WSA_CLI, url varchar),\n"
"constructor method wsrm_cli (addr WSA_CLI, url varchar, seq varchar),\n"
"method create_sequence () returns any,\n"
"method send_message (req soap_client_req, last int) returns any,\n"
"method send_message (req soap_client_req) returns any,\n"
"method finish (req soap_client_req) returns any,\n"
"method check_state () returns any,\n"
"method cancel () returns any,\n"
"method set_parameter (name varchar, val any) returns any,\n"
"method current_ver () returns varchar,\n"
"method in_seq () returns any\n";

static const char *other36 = 
"create method current_ver () for wsrm_cli\n"
"{\n"
"return \'http://schemas.xmlsoap.org/ws/2004/03/rm\';\n"
"}\n";

static const char *other37 = 
"create method in_seq () for wsrm_cli\n"
"{\n"
"if (self.seq is null or self.msgno < 0)\n"
"signal (\'42000\', \'No sequence opened\');\n"
"}\n";

static const char *other38 = 
"create constructor method wsrm_cli (in addr WSA_CLI, in url varchar) for wsrm_cli\n"
"{\n"
"self.url := url;\n"
"self.dirty := 0;\n"
"self.create_sequence ();\n"
"self.address := addr;\n"
"\n"
"return self;\n"
"}\n";

static const char *other39 = 
"create constructor method wsrm_cli (in addr WSA_CLI, in url varchar, in seq varchar) for wsrm_cli\n"
"{\n"
"self.url := url;\n"
"self.seq := seq;\n"
"self.address := addr;\n"
"set isolation=\'committed\';\n"
"whenever not found goto ends;\n"
"\n"
"select WOS_DELIVERY_ASSURANCE, WOS_SEQUENCE_EXPIRATION, WOS_INACTIVITY_TIMEOUT,\n"
"WOS_RETRANSMISSION_INTERVAL,WOS_ACKNOWLEDGEMENT_INTERVAL, WOS_LAST_SENT\n"
"into self.assurance, self.expiry, self.i_timeout, self.resend_intl, self.ack_intl, self.is_last\n"
"from SYS_WSRM_OUT_SEQUENCES where WOS_IDENTIFIER = seq;\n"
"\n"
"if (self.is_last is null)\n"
"self.is_last := 0;\n"
"\n"
"self.msgno := coalesce ((select top 1 OML_MESSAGE_ID from SYS_WSRM_OUT_MESSAGE_LOG\n"
"where OML_INDENTIFIER = seq order by 1 desc), 0);\n"
"\n"
"self.dirty := 0;\n"
"return self;\n"
"\n"
"ends:\n"
"signal (\'22023\', \'Non existing sequence\');\n"
"}\n";

static const char *other40 = 
"create method create_sequence () for wsrm_cli\n"
"{\n"
"if (self.seq is not null)\n"
"signal (\'37000\', \'Sequence is alredy created, first cancel or finish\');\n"
"\n"
"self.seq := lower (\'UUID:\'||uuid ());\n"
"self.msgno := 0;\n"
"self.assurance := \'ExactlyOnce\';\n"
"self.expiry := dateadd (\'hour\', 1, now ());\n"
"self.i_timeout := 2000;\n"
"self.resend_intl := 10000;\n"
"self.ack_intl := 2000;\n"
"\n"
"insert into SYS_WSRM_OUT_SEQUENCES (\n"
"WOS_IDENTIFIER, WOS_VERSION, WOS_DELIVERY_ASSURANCE,\n"
"WOS_SEQUENCE_EXPIRATION, WOS_INACTIVITY_TIMEOUT, WOS_RETRANSMISSION_INTERVAL,\n"
"WOS_ACKNOWLEDGEMENT_INTERVAL)\n"
"values 	(self.seq, self.current_ver (), self.assurance, self.expiry,\n"
"self.i_timeout, self.resend_intl, self.ack_intl);\n"
"return self.seq;\n"
"}\n";

static const char *other41 = 
"create method finish (in req soap_client_req)\n"
"for wsrm_cli\n"
"{\n"
"self.send_message (req, 1);\n"
"}\n";

static const char *other42 = 
"create method send_message (in req soap_client_req)\n"
"for wsrm_cli\n"
"{\n"
"self.send_message (req, 0);\n"
"}\n";

static const char *other43 = 
"create method send_message (in req soap_client_req, in last int)\n"
"for wsrm_cli\n"
"{\n"
"declare cr cursor for select OML_MESSAGE_ID from SYS_WSRM_OUT_MESSAGE_LOG where OML_INDENTIFIER = self.seq\n"
"order by OML_MESSAGE_ID desc;\n"
"\n"
"self.in_seq ();\n"
"whenever not found goto nf;\n"
"open cr (exclusive, prefetch 1);\n"
"fetch cr into self.msgno;\n"
"nf:\n"
"close cr;\n"
"if (self.msgno is null)\n"
"self.msgno := 0;\n"
"self.msgno := self.msgno + 1;\n"
"\n"
"\n"
"\n"
"insert into SYS_WSRM_OUT_MESSAGE_LOG (OML_MESSAGE, OML_ADDRESS, OML_INDENTIFIER, OML_MESSAGE_ID, OML_STATE)\n"
"values (req, self.address, self.seq, self.msgno, -1);\n"
"\n"
"\n"
"\n"
"\n"
"WSRM_CLIENT (self, last, req);\n"
"\n"
"if (last)\n"
"update SYS_WSRM_OUT_SEQUENCES set WOS_LAST_SENT = 1 where WOS_IDENTIFIER = self.seq;\n"
"\n"
"self.dirty := 0;\n"
"return self.msgno;\n"
"}\n";

static const char *other44 = 
"create method check_state () for wsrm_cli\n"
"{\n"
"declare stru any;\n"
"declare _all_is_send integer;\n"
"self.in_seq ();\n"
"\n"
"if (self.is_finish)\n"
"return vector (1);\n"
"\n"
"set isolation=\'committed\';\n"
"if (not exists (select 1 from SYS_WSRM_OUT_MESSAGE_LOG where OML_STATE <> 3 and OML_INDENTIFIER = self.seq))\n"
"{\n"
"self.is_finish := 1;\n"
"return vector (1);\n"
"}\n"
"stru := WSRM_CLIENT_ACKREQUESTED (self);\n"
"WSRM_CLIENT_ERROR (stru);\n"
"stru := WSRM_UPDATE_CLIENT_TABLES (stru, self);\n"
"\n"
"if (self.is_last)\n"
"{\n"
"if (not exists (select 1 from SYS_WSRM_OUT_MESSAGE_LOG\n"
"where OML_STATE <> 3 and OML_INDENTIFIER = self.seq))\n"
"{\n"
"self.is_finish := 1;\n"
"return vector (1);\n"
"}\n"
"}\n"
"\n"
"return stru;\n"
"}\n";

static const char *other45 = 
"create method cancel () for wsrm_cli\n"
"{\n"
"self.in_seq ();\n"
"\n"
"WSRM_CLIENT_ACKTERMINATE (self);\n"
"\n"
"delete from SYS_WSRM_OUT_SEQUENCES where WOS_IDENTIFIER = self.seq;\n"
"delete from SYS_WSRM_OUT_MESSAGE_LOG where OML_INDENTIFIER = self.seq;\n"
"\n"
"self.seq := null;\n"
"self.msgno := -1;\n"
"self.dirty := 0;\n"
"return;\n"
"}\n";

static const char *other46 = 
"create method set_parameter (in name varchar, in val any := null) for wsrm_cli\n"
"{\n"
"self.in_seq ();\n"
"\n"
"if (name = \'Assurance\')\n"
"{\n"
"if (val not in (\'AtMostOnce\',\'AtLeastOnce\',\'ExactlyOnce\',\'InOrder\'))\n"
"signal (\'22023\', \'value must be AtMostOnce, AtLeastOnce, ExactlyOnce or InOrder\');\n"
"self.assurance := val;\n"
"}\n"
"else if (name = \'Expiry\')\n"
"{\n"
"self.expiry := val;\n"
"}\n"
"else if (name = \'Timeout\')\n"
"{\n"
"if (val <= 0) signal (\'22023\', \'Positive integer required\');\n"
"self.i_timeout := val;\n"
"}\n"
"else if (name = \'RetryInterval\')\n"
"{\n"
"if (val <= 0) signal (\'22023\', \'Positive integer required\');\n"
"self.resend_intl := val;\n"
"}\n"
"else if (name = \'AckInterval\')\n"
"{\n"
"if (val <= 0) signal (\'22023\', \'Positive integer required\');\n"
"self.ack_intl := val;\n"
"}\n"
"else\n"
"signal (\'22023\', \'Unknown parameter\');\n"
"\n"
"update SYS_WSRM_OUT_SEQUENCES set\n"
"WOS_DELIVERY_ASSURANCE =  self.assurance,\n"
"WOS_SEQUENCE_EXPIRATION = self.expiry,\n"
"WOS_INACTIVITY_TIMEOUT =  self.i_timeout,\n"
"WOS_RETRANSMISSION_INTERVAL = self.resend_intl,\n"
"WOS_ACKNOWLEDGEMENT_INTERVAL = self.ack_intl\n"
"where WOS_IDENTIFIER = self.seq;\n"
"\n"
"self.dirty := 1;\n"
"return self;\n"
"}\n";

static const char *proc81 = 
"#line 283 \"[executable]/wsrmcli.sql\"\n"
"create procedure WSRM_CLIENT_POLICY (inout state wsrm_cli)\n"
"{\n"
"declare policy, ind, ver, spec_v, del_ass, i_timeout, r_int, a_int soap_parameter;\n"
"\n"
"if (not state.dirty)\n"
"return null;\n"
"\n"
"policy := new soap_parameter ();\n"
"ind := new soap_parameter ();\n"
"ver := new soap_parameter ();\n"
"spec_v := new soap_parameter ();\n"
"r_int := new soap_parameter ();\n"
"a_int := new soap_parameter ();\n"
"del_ass := new soap_parameter ();\n"
"i_timeout := new soap_parameter ();\n"
"\n"
"policy.set_xsd (\'http://schemas.xmlsoap.org/ws/2002/12/policy:PolicyAttachment\');\n"
"\n"
"ind.set_attribute (\'Identifier\', state.seq);\n"
"\n"
"policy.add_member (\'AppliesTo\', new soap_parameter (ind));\n"
"\n"
"ver.set_attribute (\'URI\', \'http://schemas.xmlsoap.org/ws/2004/03/rm\');\n"
"ver.set_attribute (\'Usage\', \'wsp:Required\');\n"
"\n"
"i_timeout.set_attribute (\'Milliseconds\', state.i_timeout);\n"
"\n"
"r_int.set_attribute (\'Milliseconds\', state.resend_intl);\n"
"\n"
"a_int.set_attribute (\'Milliseconds\', state.resend_intl);\n"
"\n"
"del_ass.set_attribute (\'Value\',\'wsrm:\' || state.assurance);\n"
"del_ass.set_attribute (\'Usage\',\'wsp:Required\');\n"
"\n"
"spec_v.add_member (\'SpecVersion\', ver);\n"
"spec_v.add_member (\'DeliveryAssurance\', del_ass);\n"
"spec_v.add_member (\'InactivityTimeout\', i_timeout);\n"
"spec_v.add_member (\'BaseRetransmissionInterval\', r_int);\n"
"spec_v.add_member (\'AcknowledgementInterval\', a_int);\n"
"spec_v.add_member (\'Expires\', state.expiry);\n"
"\n"
"policy.add_member (\'Policy\', spec_v);\n"
"\n"
"spec_v := new soap_parameter ();\n"
"spec_v.set_attribute (\'Ref\', \'http://schemas.xmlsoap.org/ws/2004/03/rm/baseTimingProfile.xml\');\n"
"\n"
"policy.add_member (\'PolicyReference\', spec_v);\n"
"\n"
"return policy;\n"
"}\n"
"--src wsrmcli.sql:281\n"
;

static const char *proc82 = 
"#line 336 \"[executable]/wsrmcli.sql\"\n"
"create procedure WSRM_CLIENT (in state wsrm_cli, in is_last integer, in req SOAP_CLIENT_REQ)\n"
"{\n"
"declare ret, wa, policy any;\n"
"declare st, pa soap_parameter;\n"
"declare identifier varchar;\n"
"declare retr integer;\n"
"declare vhdr any;\n"
"\n"
"if (req.style is null)\n"
"req.style := 1;\n"
"state.is_last := is_last;\n"
"identifier := state.seq;\n"
"retr := 0;\n"
"\n"
"st := new soap_parameter ();\n"
"pa := new soap_parameter ();\n"
"\n"
"st.set_xsd (\'http://schemas.xmlsoap.org/ws/2005/02/rm:Sequence\');\n"
"st.add_member (\'Identifier\', soap_parameter (identifier));\n"
"st.add_member (\'MessageNumber\', state.msgno);\n"
"st.set_attribute (\'Id\', uuid ());\n"
"\n"
"\n"
"\n"
"if (is_last)\n"
"st.add_member (\'LastMessage\', \'\');\n"
"\n"
"\n"
"\n"
"pa := WSRM_CLIENT_POLICY (state);\n"
"if (pa is not null)\n"
"policy := pa.get_call_param (\'\');\n"
"else\n"
"policy := vector ();\n"
"wa := WSA_REQ (state);\n"
"\n"
"vhdr := \'X-Virt-WSRM-ID: \' || registry_get (\'WSRMServerID\') || \';\'\n"
"|| identifier || \';\' || cast(state.msgno as varchar) || \'\\r\\n\';\n"
"\n"
"declare exit handler for sqlstate \'HTCLI\' {\n"
"update SYS_WSRM_OUT_MESSAGE_LOG set OML_STATE = 2\n"
"where OML_INDENTIFIER = identifier and  OML_MESSAGE_ID = state.msgno;\n"
"commit work;\n"
"retr := retr + 1;\n"
"if (retr > 3)\n"
"resignal;\n"
"\n"
"};\n"
"\n"
"commit work;\n"
"\n"
"\n"
"ret := SOAP_CLIENT (url=>req.url, operation=>req.operation, style=>(128+64+req.style),\n"
"headers=>vector_concat (wa, st.get_call_param (\'\'), policy, req.headers),\n"
"parameters=>req.parameters, direction=>(1),\n"
"target_namespace=>req.target_namespace,\n"
"soap_action=>req.soap_action,\n"
"attachments=>req.attachments,\n"
"ticket=>req.ticket,\n"
"passwd=>req.passwd,\n"
"user_name=>req.user_name,\n"
"user_password=>req.user_password,\n"
"auth_type=>req.auth_type,\n"
"security_type=>req.security_type,\n"
"template=>req.template,\n"
"version=>req.version,\n"
"security_schema=>req.security_schema,\n"
"http_header=>NULL);\n"
"\n"
"\n"
"whenever SQLSTATE \'*\' default;\n"
"\n"
"update SYS_WSRM_OUT_MESSAGE_LOG set OML_STATE = 1\n"
"where OML_INDENTIFIER = identifier and  OML_MESSAGE_ID = state.msgno and OML_STATE <> 3;\n"
"\n"
"\n"
"\n"
"if (ret is not null)\n"
"{\n"
"declare _all_is_send integer;\n"
"\n"
"update SYS_WSRM_OUT_MESSAGE_LOG set OML_RESPONSE = xml_tree_doc (ret)\n"
"where OML_INDENTIFIER = identifier and  OML_MESSAGE_ID = state.msgno;\n"
"\n"
"WSRM_CLIENT_ERROR (ret);\n"
"WSRM_UPDATE_CLIENT_TABLES (ret, state);\n"
"if (is_last)\n"
"{\n"
"select count (*) into _all_is_send from SYS_WSRM_OUT_MESSAGE_LOG\n"
"where OML_STATE <> 3 and OML_INDENTIFIER = identifier;\n"
"\n"
"if (_all_is_send = 0)\n"
"state.is_finish := 1;\n"
"}\n"
"}\n"
"\n"
"return 0;\n"
"}\n"
"--src wsrmcli.sql:334\n"
;

static const char *proc83 = 
"#line 436 \"[executable]/wsrmcli.sql\"\n"
"create procedure WSRM_CLIENT_ERROR (in err_vec any)\n"
"{\n"
"declare xt any;\n"
"if (err_vec is not NULL)\n"
"{\n"
"xt := xml_tree_doc (err_vec);\n"
"if (xpath_eval (\'[ xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\" ] //env:Fault\', xt, 1) is not null)\n"
"{\n"
"declare error_text varchar;\n"
"error_text :=\n"
"xpath_eval (\'[ xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\" ] //env:Fault/faultstring\',\n"
"xt, 1);\n"
"signal (\'WSRMC\', cast (error_text as varchar));\n"
"}\n"
"}\n"
"}\n"
"--src wsrmcli.sql:434\n"
;

static const char *proc84 = 
"#line 454 \"[executable]/wsrmcli.sql\"\n"
"create procedure WSRM_RESENDER (in identifier varchar)\n"
"{\n"
"declare ret, list any;\n"
"declare resend_message SOAP_CLIENT_REQ;\n"
"declare st, pa soap_parameter;\n"
"declare state wsrm_cli;\n"
"declare addr wsa_cli;\n"
"declare idx, len integer;\n"
"\n"
"set isolation=\'committed\';\n"
"list := vector ();\n"
"\n"
"for select OML_MESSAGE_ID, OML_MESSAGE, OML_ADDRESS from SYS_WSRM_OUT_MESSAGE_LOG\n"
"where OML_STATE <> 3 and OML_INDENTIFIER = identifier do\n"
"{\n"
"list := vector_concat (list, vector (vector (OML_MESSAGE_ID, OML_MESSAGE, OML_ADDRESS)));\n"
"}\n"
"\n"
"commit work;\n"
"\n"
"idx := 0;\n"
"len := length (list);\n"
"\n"
"while (idx < len)\n"
"{\n"
"declare policy any;\n"
"resend_message := list[idx][1];\n"
"addr := list[idx][2];\n"
"\n"
"state := new wsrm_cli (addr, addr.\"to\", identifier);\n"
"state.msgno := list[idx][0];\n"
"\n"
"WSRM_CLIENT (state, 0, resend_message);\n"
"\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"--src wsrmcli.sql:452\n"
;

static const char *proc85 = 
"#line 493 \"[executable]/wsrmcli.sql\"\n"
"create procedure WSRM_ACKNOWLEDGEMENT_PROCESS (in state wsrm_cli, in identifier varchar, in stru any)\n"
"{\n"
"declare my_max, idx, idx2, len2 integer;\n"
"declare list, dummy any;\n"
"declare cr cursor for select OML_MESSAGE_ID from SYS_WSRM_OUT_MESSAGE_LOG\n"
"where OML_INDENTIFIER = identifier;\n"
"list := vector ();\n"
"whenever not found goto ret;\n"
"open cr (exclusive);\n"
"fetch cr into dummy;\n"
"select count (*) into my_max from SYS_WSRM_OUT_MESSAGE_LOG where OML_INDENTIFIER = identifier;\n"
"\n"
"list := make_array (my_max + 1, \'any\');\n"
"idx := 0;\n"
"\n"
"while (idx <= my_max)\n"
"{\n"
"aset (list, idx, 0);\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"aset (list, 0, state.is_finish);\n"
"\n"
"idx := 0;\n"
"\n"
"declare elm any;\n"
"while (elm := adm_next_keyword (\'AcknowledgementRange\', stru, idx))\n"
"{\n"
"\n"
"idx2 := get_keyword (\'Lower\', elm[1], 0);\n"
"len2 := get_keyword (\'Upper\', elm[1], 0);\n"
"\n"
"while (idx2 <= len2)\n"
"{\n"
"aset (list, idx2, 1);\n"
"idx2 := idx2 + 1;\n"
"}\n"
"}\n"
"\n"
"if (elm = 0)\n"
"update SYS_WSRM_OUT_MESSAGE_LOG set OML_STATE = 3\n"
"where OML_INDENTIFIER = identifier;\n"
"\n"
"\n"
"idx := 1;\n"
"\n"
"while (idx <= my_max)\n"
"{\n"
"if (list[idx])\n"
"{\n"
"update SYS_WSRM_OUT_MESSAGE_LOG set OML_STATE = 3\n"
"where OML_INDENTIFIER = identifier and OML_MESSAGE_ID = idx;\n"
"if (row_count () = 0)\n"
"{\n"
"signal (\'42000\', \'Error on WSRM Client. The WSRM Server have unsend message.\');\n"
"}\n"
"}\n"
"idx := idx + 1;\n"
"\n"
"}\n"
"ret:\n"
"close cr;\n"
"return list;\n"
"}\n"
"--src wsrmcli.sql:491\n"
;

static const char *proc86 = 
"#line 559 \"[executable]/wsrmcli.sql\"\n"
"create procedure WSRM_UPDATE_CLIENT_TABLES (in response any, in state wsrm_cli)\n"
"{\n"
"declare xt any;\n"
"declare s soap_parameter;\n"
"declare identifier varchar;\n"
"\n"
"xt := xml_tree_doc (response);\n"
"s := new soap_parameter ();\n"
"s.set_xsd (\'http://schemas.xmlsoap.org/ws/2005/02/rm:SequenceAcknowledgement_t\');\n"
"s.deserialize (xt, \'SequenceAcknowledgement[1]\');\n"
"\n"
"identifier := cast (xpath_eval (\'//Identifier\', xt, 1) as varchar);\n"
"\n"
"return WSRM_ACKNOWLEDGEMENT_PROCESS (state, identifier, s.s);\n"
"}\n"
"--src wsrmcli.sql:557\n"
;

static const char *proc87 = 
"#line 577 \"[executable]/wsrmcli.sql\"\n"
"create procedure WSRM_CLIENT_ACKREQUESTED (in req wsrm_cli)\n"
"{\n"
"declare _headers, wa, ack any;\n"
"declare identifier varchar;\n"
"declare n soap_parameter;\n"
"\n"
"identifier := req.seq;\n"
"\n"
"n := new soap_parameter (identifier);\n"
"ack := vector (vector (\'\', \'http://schemas.xmlsoap.org/ws/2005/02/rm:AckRequested\'), vector (n.s));\n"
"wa := WSA_REQ (req);\n"
"_headers := vector_concat (ack, wa);\n"
"\n"
"commit work;\n"
"return SOAP_CLIENT (url=>req.url, operation=>\'WSRMAckRequested\',\n"
"style=>(128+64+1), headers=>_headers, direction=>0);\n"
"}\n"
"--src wsrmcli.sql:575\n"
;

static const char *proc88 = 
"#line 598 \"[executable]/wsrmcli.sql\"\n"
"create procedure WSRM_CLIENT_ACKTERMINATE (in req wsrm_cli)\n"
"{\n"
"declare _headers any;\n"
"declare n soap_parameter;\n"
"declare identifier varchar;\n"
"\n"
"identifier := req.seq;\n"
"n := new soap_parameter (identifier);\n"
"\n"
"_headers := vector (vector (\'\', \'http://schemas.xmlsoap.org/ws/2005/02/rm:SequenceTerminate\'), vector (n.s));\n"
"\n"
"SOAP_CLIENT (url=>req.url, operation=>\'WSRMSequenceTerminate\', headers=>_headers, direction=>1);\n"
"}\n"
"--src wsrmcli.sql:596\n"
;

static const char *other47 = 
"insert soft SYS_SCHEDULED_EVENT (SE_NAME, SE_START, SE_SQL, SE_INTERVAL)\n"
"values (\'WSRM Client Scheduled Tasks\', now(), \'DB.DBA.WSRM_CLIENT_SCHEDULED_TASKS ()\', 100)\n";
static const char *proc89 = 
"#line 619 \"[executable]/wsrmcli.sql\"\n"
"create procedure WSRM_CLIENT_SCHEDULED_TASKS ()\n"
"{\n"
"\n"
"for (select WOS_IDENTIFIER, WOS_DELIVERY_ASSURANCE, WOS_SEQUENCE_EXPIRATION,\n"
"WOS_INACTIVITY_TIMEOUT, WOS_RETRANSMISSION_INTERVAL, WOS_ACKNOWLEDGEMENT_INTERVAL\n"
"from SYS_WSRM_OUT_SEQUENCES where WOS_IDENTIFIER = \'\') do\n"
"{\n"
"if ((WOS_ACKNOWLEDGEMENT_INTERVAL is not NULL)\n"
"and (datediff (\'seconds\', WOS_ACKNOWLEDGEMENT_INTERVAL, now ()) > 0))\n"
"{\n"
" ;\n"
"}\n"
"\n"
"if ((WOS_RETRANSMISSION_INTERVAL is not NULL)\n"
"and (datediff (\'seconds\', WOS_RETRANSMISSION_INTERVAL, now ()) > 0))\n"
"{\n"
" ;\n"
"}\n"
"}\n"
"\n"
"set isolation=\'committed\';\n"
"\n"
"for (select OML_INDENTIFIER from SYS_WSRM_OUT_MESSAGE_LOG where OML_STATE <> 3) do\n"
"{\n"
"WSRM_RESENDER (OML_INDENTIFIER);\n"
"}\n"
"}\n"
"--src wsrmcli.sql:617\n"
;

static const char *proc90 = 
"#line 648 \"[executable]/wsrmcli.sql\"\n"
"create procedure WSRM_GET_IDENTIFIER (in s any)\n"
"{\n"
"declare ret soap_parameter;\n"
"\n"
"ret := new soap_parameter ();\n"
"ret.set_struct (s);\n"
"return ret.get_value ();\n"
"}\n"
"--src wsrmcli.sql:646\n"
;

static const char *proc91 = 
"#line 659 \"[executable]/wsrmcli.sql\"\n"
"create procedure WSA_REQ (inout state wsrm_cli)\n"
"{\n"
"declare req, mid, mto, mac any;\n"
"declare mfrom, mreply, mfault soap_parameter;\n"
"\n"
"mfrom := new soap_parameter ();\n"
"mreply := new soap_parameter ();\n"
"mfault := new soap_parameter ();\n"
"\n"
"req := vector ();\n"
"mfrom.set_xsd (\'http://schemas.xmlsoap.org/ws/2004/08/addressing:From\');\n"
"if (state.address.\"from\" is not null)\n"
"mfrom.add_member (\'Address\', state.address.\"from\");\n"
"else\n"
"mfrom.add_member (\'Address\', \'http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous\');\n"
"mfrom.set_attribute (\'Id\', uuid ());\n"
"req := vector_concat (mfrom.get_call_param (\'\'));\n"
"\n"
"if (state.address.mid is not null)\n"
"{\n"
"mid := vector (vector (\'\', \'http://schemas.xmlsoap.org/ws/2004/08/addressing:MessageID\'),\n"
"vector (composite (), vector (\'Id\', uuid ()), state.address.mid));\n"
"req := vector_concat (req, mid);\n"
"}\n"
"\n"
"if (state.address.\"to\" is not null)\n"
"{\n"
"mto := vector (vector (\'\', \'http://schemas.xmlsoap.org/ws/2004/08/addressing:To\'),\n"
"vector (composite (), vector (\'Id\', uuid ()), state.address.\"to\"));\n"
"req := vector_concat (req, mto);\n"
"}\n"
"\n"
"if (state.address.action is not null)\n"
"{\n"
"mac := vector (vector (\'\', \'http://schemas.xmlsoap.org/ws/2004/08/addressing:Action\'),\n"
"vector (composite (), vector (\'Id\', uuid ()), state.address.action));\n"
"req := vector_concat (req, mac);\n"
"}\n"
"\n"
"if (state.address.reply_to is not null)\n"
"{\n"
"mreply.set_xsd (\'http://schemas.xmlsoap.org/ws/2004/08/addressing:ReplyTo\');\n"
"mreply.add_member (\'Address\', state.address.reply_to);\n"
"mreply.set_attribute (\'Id\', uuid ());\n"
"req := vector_concat (req, mreply.get_call_param (\'\'));\n"
"}\n"
"\n"
"if (state.address.fault_to is not null)\n"
"{\n"
"mfault.set_xsd (\'http://schemas.xmlsoap.org/ws/2004/08/addressing:FaultTo\');\n"
"mfault.add_member (\'Address\', state.address.fault_to);\n"
"mfault.set_attribute (\'Id\', uuid ());\n"
"req := vector_concat (req, mfault.get_call_param (\'\'));\n"
"}\n"
"\n"
"return req;\n"
"}\n"
"--src wsrmcli.sql:657\n"
;

/* wsrmsrv.sql */

static const char *proc92 = 
"#line 23 \"[executable]/wsrmsrv.sql\"\n"
"create procedure WSRM_INIT ()\n"
"{\n"
"if (not isstring (registry_get (\'WSRMServerID\')))\n"
"registry_set (\'WSRMServerID\', uuid ());\n"
"}\n"
"--src wsrmsrv.sql:21\n"
;


static const char *other48 = 
" WSRM_INIT ()\n";
static const char *proc93 = 
"#line 35 \"[executable]/wsrmsrv.sql\"\n"
"create procedure WSRMSequence\n"
"(\n"
"in  Sequence any __soap_header \'http://schemas.xmlsoap.org/ws/2005/02/rm:Sequence\',\n"
"in  PolicyAttachment any := null __soap_header \'http://schemas.xmlsoap.org/ws/2002/12/policy:PolicyAttachment\',\n"
"in  MessageID any __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:MessageID\',\n"
"inout  \"To\" any __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:To\',\n"
"inout  Action any __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:Action\',\n"
"inout  \"From\" any __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:From\',\n"
"in  ReplyTo any := null __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:ReplyTo\',\n"
"in  FaultTo any := null __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:FaultTo\',\n"
"in  Security any := null __soap_header \'http://schemas.xmlsoap.org/ws/2003/06/secext:Security\',\n"
"out RelatesTo any := null __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:RelatesTo\',\n"
"out Acknowledgement any __soap_header \'http://schemas.xmlsoap.org/ws/2005/02/rm:SequenceAcknowledgement\',\n"
"out SequenceFault any __soap_fault \'http://schemas.xmlsoap.org/ws/2005/02/rm:SequenceFault\',\n"
"in  ws_soap_request any\n"
")\n"
"__soap_options (__soap_doc := \'__VOID__\', \"DefaultOperation\" := 1)\n"
"{\n"
"\n"
"declare _message_num, is_final, is_sync integer;\n"
"declare identifier, mto varchar;\n"
"declare _message, acknowled, res any;\n"
"declare s soap_parameter;\n"
"declare _from soap_parameter;\n"
"declare address WSA_CLI;\n"
"declare _addr varchar;\n"
"declare lines, pret, tmp any;\n"
"\n"
"\n"
"pret := null;\n"
"is_sync := 0;\n"
"\n"
"declare exit handler for sqlstate \'WSRM*\' {\n"
"\"From\" := null; \"To\" := null; Action := null;\n"
"SequenceFault := WSRM_SERVER_ERROR (__SQL_STATE, identifier);\n"
"connection_set (\'SOAPFault\', vector (\'300\', __SQL_MESSAGE));\n"
"return;\n"
"};\n"
"\n"
"lines := http_request_header ();\n"
"res := null; _addr := null;\n"
"s := new soap_parameter ();\n"
"_from := new soap_parameter ();\n"
"\n"
"if (\"From\" is not null)\n"
"{\n"
"_from.s := \"From\";\n"
"_addr := cast (_from.get_member (\'Address\') as varchar);\n"
"}\n"
"\n"
"\n"
"address := new wsa_cli ();\n"
"\n"
"s.s := Sequence;\n"
"identifier := WSRM_GET_IDENTIFIER (s.get_member (\'Identifier\'));\n"
"insert soft SYS_WSRM_IN_SEQUENCES (WIS_IDENTIFIER) values (identifier);\n"
"\n"
"\n"
"if ((MessageID is not NULL) and (Action is not NULL) and (\"From\" is not NULL) and (\"To\" is not NULL))\n"
"{\n"
"address.mid := MessageID;\n"
"address.action := Action;\n"
"address.\"from\" := _addr;\n"
"address.\"to\" := \"To\";\n"
"address.reply_to := ReplyTo;\n"
"address.fault_to := FaultTo;\n"
"\n"
"s.s := ReplyTo;\n"
"}\n"
"else\n"
"{\n"
"signal (\'WSRM1\', concat (\'The Sequence is terminated or address is not complete.\'));\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"if (PolicyAttachment is not NULL)\n"
"{\n"
"declare bri, i_timeout, acli, exp, del_ass, spec_ver any;\n"
"declare apl, pol soap_parameter;\n"
"\n"
"s := new soap_parameter();\n"
"s.s := PolicyAttachment;\n"
"apl := new soap_parameter ();\n"
"apl.s := s.get_member (\'AppliesTo\')[0];\n"
"pol := new soap_parameter ();\n"
"\n"
"identifier := apl.get_attribute(\'Identifier\');\n"
"\n"
"pol.s := s.get_member (\'Policy\');\n"
"i_timeout := pol.get_member(\'BaseRetransmissionInterval\')[1][1];\n"
"bri := pol.get_member(\'BaseRetransmissionInterval\')[1][1];\n"
"acli := pol.get_member(\'AcknowledgementInterval\')[1][1];\n"
"exp := pol.get_member(\'Expires\');\n"
"del_ass := pol.get_member(\'DeliveryAssurance\')[1][1];\n"
"spec_ver := pol.get_member(\'SpecVersion\')[1][1];\n"
"\n"
"update SYS_WSRM_IN_SEQUENCES set\n"
"WIS_VERSION = spec_ver,\n"
"WIS_DELIVERY_ASSURANCE = del_ass,\n"
"WIS_SEQUENCE_EXPIRATION = exp,\n"
"WIS_INACTIVITY_TIMEOUT = i_timeout,\n"
"WIS_RETRANSMISSION_INTERVAL = bri,\n"
"WIS_ACKNOWLEDGEMENT_INTERVAL = acli\n"
"where WIS_IDENTIFIER = identifier;\n"
"\n"
"}\n"
"\n"
"if (Sequence is not NULL)\n"
"{\n"
"declare opts any;\n"
"s.s := Sequence;\n"
"identifier := WSRM_GET_IDENTIFIER (s.get_member (\'Identifier\'));\n"
"_message_num := s.get_member (\'MessageNumber\');\n"
"is_final := s.get_member (\'LastMessage\');\n"
"\n"
"WSRM_CHECK_POLICY (identifier);\n"
"\n"
"_message := xml_tree_doc (ws_soap_request);\n"
"\n"
"if (is_final is null) is_final := -1;\n"
"\n"
"if ((is_final <> -1 and _addr is null) or\n"
"_addr = \'http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous\')\n"
"{\n"
"is_sync := 1;\n"
"}\n"
"else\n"
"{\n"
"http_rewrite ();\n"
"http_request_status (\'HTTP/1.1 202 Accepted\');\n"
"http_flush ();\n"
"}\n"
"\n"
"insert soft SYS_WSRM_IN_MESSAGE_LOG (IML_INDENTIFIER, IML_MESSAGE_ID, IML_MESSAGE, IML_ADDRES, IML_STATE)\n"
"values (identifier, _message_num, _message, address, is_final);\n"
"\n"
"opts := http_map_get (\'soap_opts\');\n"
"if (isarray (opts))\n"
"{\n"
"declare pname varchar;\n"
"declare nmsg any;\n"
"pname := get_keyword (\'WSRM-Callback\', opts);\n"
"if (length (pname) and __proc_exists (pname))\n"
"{\n"
"nmsg := xslt (\'http://local.virt/wsrmcall\', _message);\n"
"pret := call (pname) (nmsg, identifier, _message_num);\n"
"}\n"
"}\n"
"\n"
"commit work;\n"
"}\n"
"\n"
"\n"
"if (is_sync)\n"
"{\n"
"\n"
"\n"
"res := WSRM_ACKNOWLEDGEMENT (identifier);\n"
"\n"
"\n"
"if (res is not NULL)\n"
"{\n"
"Acknowledgement := res;\n"
"if (pret is not null and MessageID is not null)\n"
"{\n"
"declare _to, _from_addr any;\n"
"if (\"To\" is not null and \"From\" is not null)\n"
"{\n"
"_to := \"To\"[2];\n"
"_from_addr := get_keyword (\'Address\', \"From\");\n"
"\"To\" := vector (composite(), \'\', _from_addr); \"From\" := soap_box_structure (\'Address\', _to);\n"
"}\n"
"RelatesTo := vector (composite(), vector (\'RelationshipType\',\'wsa:Response\'), MessageID[2]);\n"
"}\n"
"else\n"
"{\n"
"\"From\" := vector (composite (), vector (\'Id\', \'Id-\'||uuid()), \'Address\', _addr);\n"
"\"To\" := vector (composite(), vector (\'Id\', \'Id-\'||uuid()), \'\');\n"
"}\n"
"return pret;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"goto flushit;\n"
"};\n"
"WSRM_ASYNC_PROCESS (identifier);\n"
"flushit:;\n"
"}\n"
"}\n"
"--src wsrmsrv.sql:33\n"
;

static const char *proc94 = 
"#line 232 \"[executable]/wsrmsrv.sql\"\n"
"create procedure\n"
"WSRMSequenceTerminate\n"
"(\n"
"in  SequenceTerminate any __soap_header \'http://schemas.xmlsoap.org/ws/2005/02/rm:SequenceTerminate\'\n"
")\n"
"__soap_options (__soap_doc := \'__VOID__\', DefaultOperation := 0)\n"
"{\n"
"declare identifier varchar;\n"
"\n"
"if (SequenceTerminate is not NULL)\n"
"{\n"
"identifier := cast (SequenceTerminate[0][2] as varchar);\n"
"\n"
"delete from SYS_WSRM_IN_MESSAGE_LOG where IML_INDENTIFIER = identifier;\n"
"delete from SYS_WSRM_IN_SEQUENCES where WIS_IDENTIFIER = identifier;\n"
"\n"
"commit work;\n"
"http_request_status (\'HTTP/1.1 202 Accepted\');\n"
"http_flush ();\n"
"http_request_status (\'reply sent\');\n"
"}\n"
"\n"
"return;\n"
"}\n"
"--src wsrmsrv.sql:230\n"
;

static const char *proc95 = 
"#line 258 \"[executable]/wsrmsrv.sql\"\n"
"create procedure\n"
"WSRMAckRequested\n"
"(\n"
"in  AckRequested any __soap_header \'http://schemas.xmlsoap.org/ws/2005/02/rm:AckRequested\',\n"
"in  ws_soap_request any,\n"
"out SequenceFault any __soap_fault \'http://schemas.xmlsoap.org/ws/2005/02/rm:SequenceFault\',\n"
"out Acknowledgement any __soap_header \'http://schemas.xmlsoap.org/ws/2005/02/rm:SequenceAcknowledgement\'\n"
")\n"
"__soap_options (__soap_doc := \'__VOID__\', DefaultOperation := 0)\n"
"{\n"
"declare identifier varchar;\n"
"\n"
"declare exit handler for sqlstate \'WSRM*\' {\n"
"SequenceFault := WSRM_SERVER_ERROR (__SQL_STATE, identifier);\n"
"connection_set (\'SOAPFault\', vector (\'300\', __SQL_MESSAGE));\n"
"return;\n"
"};\n"
"\n"
"if (AckRequested is not NULL)\n"
"{\n"
"identifier := cast (AckRequested [0][2] as varchar);\n"
"WSRM_CHECK_POLICY (identifier);\n"
"Acknowledgement := WSRM_ACKNOWLEDGEMENT (identifier);\n"
"}\n"
"return;\n"
"}\n"
"--src wsrmsrv.sql:256\n"
;

static const char *proc96 = 
"#line 286 \"[executable]/wsrmsrv.sql\"\n"
"create procedure WSRM_ACKNOWLEDGEMENT (in identifier varchar)\n"
"{\n"
"declare idx, max_exist, upper, lower, flag integer;\n"
"declare s, r soap_parameter;\n"
"declare _headers any;\n"
"\n"
"s := new soap_parameter ();\n"
"r := new soap_parameter ();\n"
"\n"
"s.add_member (\'Identifier\', soap_parameter (identifier));\n"
"\n"
"\n"
"idx := 1; lower := -1; flag := 0;\n"
"\n"
"select max (IML_MESSAGE_ID) into max_exist from SYS_WSRM_IN_MESSAGE_LOG where IML_INDENTIFIER = identifier;\n"
"\n"
"if (max_exist is NULL)\n"
"{\n"
"max_exist := 0;\n"
"lower := 0;\n"
"idx := 0;\n"
"}\n"
"\n"
"while (idx <= max_exist)\n"
"{\n"
"if (exists (select 1 from SYS_WSRM_IN_MESSAGE_LOG where\n"
"IML_INDENTIFIER = identifier and IML_MESSAGE_ID = idx))\n"
"{\n"
"if (flag <> 2)\n"
"lower := idx;\n"
"\n"
"upper := idx;\n"
"flag := 2;\n"
"}\n"
"else\n"
"flag := 1;\n"
"\n"
"if ((flag = 1 and lower > 0) or (idx = max_exist))\n"
"{\n"
"r := new soap_parameter ();\n"
"r.set_attribute (\'Upper\', upper);\n"
"r.set_attribute (\'Lower\', lower);\n"
"s.add_member (\'AcknowledgementRange\', r);\n"
"flag := 0; lower := -1;\n"
"}\n"
"\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"\n"
"return s.s;\n"
"}\n"
"--src wsrmsrv.sql:284\n"
;

static const char *proc97 = 
"#line 340 \"[executable]/wsrmsrv.sql\"\n"
"create procedure WSRM_SERVER_ERROR (in _state varchar, in identifier varchar)\n"
"{\n"
"declare f, ack soap_parameter;\n"
"f := soap_parameter ();\n"
"f.add_member (\'Identifier\', soap_parameter (identifier));\n"
"\n"
"if (_state = \'WSRM1\')\n"
"f.add_member (\'FaultCode\', soap_parameter (\'wsrm:SequenceTerminated\'));\n"
"else if (_state = \'WSRM2\')\n"
"f.add_member (\'FaultCode\', soap_parameter (\'wsrm:UnknownSequence\'));\n"
"else if (_state = \'WSRM5\')\n"
"f.add_member (\'FaultCode\', soap_parameter (\'wsrm:LastMessageNumberExceeded\'));\n"
"else\n"
"f.add_member (\'FaultCode\', soap_parameter (\'wsrm:SequenceRefused\'));\n"
"\n"
"if (0)\n"
"{\n"
"ack := soap_parameter ();\n"
"ack.set_attribute (\'Upper\', 1);\n"
"ack.set_attribute (\'Lower\', 10);\n"
"f.add_member (\'AcknowledgementRange\', ack);\n"
"}\n"
"return f.s;\n"
"\n"
"}\n"
"--src wsrmsrv.sql:338\n"
;

static const char *proc98 = 
"#line 367 \"[executable]/wsrmsrv.sql\"\n"
"create procedure WSRM_CHECK_POLICY (in identifier varchar)\n"
"{\n"
"if (exists (select 1 from SYS_WSRM_IN_MESSAGE_LOG where IML_INDENTIFIER = identifier and\n"
"IML_STATE = 5))\n"
"{\n"
"signal (\'WSRM1\', concat (\'The Sequence is terminated (\',\n"
"cast (identifier as varchar), \')\'));\n"
"}\n"
"\n"
"if (exists (select 1 from SYS_WSRM_IN_MESSAGE_LOG where IML_INDENTIFIER = identifier and\n"
"IML_STATE = 1))\n"
"{\n"
"update SYS_WSRM_IN_MESSAGE_LOG set IML_STATE = 2 where IML_INDENTIFIER = identifier;\n"
"commit work;\n"
"signal (\'WSRM5\', concat (\'Last message number exceeded (\',\n"
"cast (identifier as varchar), \')\'));\n"
"}\n"
"\n"
"\n"
"if (not exists (select 1 from SYS_WSRM_IN_SEQUENCES where WIS_IDENTIFIER = identifier))\n"
"{\n"
"signal (\'WSRM2\', concat (\'The sequence not exists (\',\n"
"cast (identifier as varchar), \')\'));\n"
"}\n"
"}\n"
"--src wsrmsrv.sql:365\n"
;

static const char *proc99 = 
"#line 394 \"[executable]/wsrmsrv.sql\"\n"
"create procedure WSRM_MAKE_RANGES (in arr any)\n"
"{\n"
"declare res, elm any;\n"
"declare i, l int;\n"
"res := vector ();\n"
"elm := vector (0, 0);\n"
"i := 0; l := length (arr);\n"
"while (i < l)\n"
"{\n"
"if (elm[0] = 0)\n"
"elm[0] := arr[i];\n"
"if (elm[1]+1 <> arr[i])\n"
"{\n"
"res := vector_concat (res, vector (elm));\n"
"elm := vector (arr[i], arr[i]);\n"
"}\n"
"elm[1] := arr[i];\n"
"\n"
"i := i + 1;\n"
"}\n"
"if (l = 1)\n"
"res := vector (elm);\n"
"else if (elm[0] <> 0)\n"
"res := vector_concat (res, vector (elm));\n"
"return res;\n"
"}\n"
"--src wsrmsrv.sql:392\n"
;

static const char *proc100 = 
"#line 422 \"[executable]/wsrmsrv.sql\"\n"
"create procedure WSRM_ASYNC_ACK_SEND (in seq varchar, in address varchar, in range any)\n"
"{\n"
"\n"
"declare n, ack, ra soap_parameter;\n"
"declare req wsrm_cli;\n"
"declare addr wsa_cli;\n"
"declare i, l, retr int;\n"
"declare wa, ranges any;\n"
"declare vhdr any;\n"
"\n"
"\n"
"vhdr := \'X-Virt-WSRM-ID: \' || registry_get (\'WSRMServerID\') || \';\' || cast (seq as varchar) || \';\' ;\n"
"n := new soap_parameter (seq);\n"
"ack := new soap_parameter ();\n"
"\n"
"ack.add_member (\'Identifier\', n);\n"
"ack.set_xsd (\'http://schemas.xmlsoap.org/ws/2005/02/rm:SequenceAcknowledgement\');\n"
"\n"
"ranges := WSRM_MAKE_RANGES (range);\n"
"\n"
"i := 0; l := length (ranges); retr := 0;\n"
"\n"
"if (l = 0)\n"
"return;\n"
"\n"
"while (i < l)\n"
"{\n"
"ra := new soap_parameter ();\n"
"ra.set_attribute (\'Upper\', ranges[i][1]);\n"
"ra.set_attribute (\'Lower\', ranges[i][0]);\n"
"ack.add_member (\'AcknowledgementRange\', ra);\n"
"vhdr := vhdr || sprintf(\'%d-%d;\', ranges[i][0], ranges[i][1]);\n"
"i := i + 1;\n"
"}\n"
"\n"
"req := wsrm_cli ();\n"
"addr := wsa_cli ();\n"
"addr.\"from\" := \'http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous\';\n"
"addr.\"to\" := \'http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous\';\n"
"addr.action := \'http://schemas.xmlsoap.org/ws/2004/03/rm#SequenceAcknowledgement\';\n"
"req.address := addr;\n"
"\n"
"wa := WSA_REQ (req);\n"
"\n"
"vhdr := vhdr || \'\\r\\n\';\n"
"\n"
"declare exit handler for sqlstate \'HTCLI\' {\n"
"retr := retr + 1;\n"
"if (retr > 3)\n"
"resignal;\n"
"};\n"
"\n"
"commit work;\n"
"SOAP_CLIENT (url=>address, operation=>\'AcknowledgementRange\', style=>(128+64+1), direction=>1,\n"
"headers=>vector_concat (wa, ack.get_call_param(\'\')), http_header=>null);\n"
"}\n"
"--src wsrmsrv.sql:420\n"
;

static const char *proc101 = 
"#line 481 \"[executable]/wsrmsrv.sql\"\n"
"create procedure WSRM_ASYNC_PROCESS (in seq varchar)\n"
"{\n"
"declare range varchar;\n"
"declare addr varchar;\n"
"\n"
"range := vector ();\n"
"addr := null;\n"
"\n"
"for select IML_MESSAGE_ID, IML_STATE, IML_ADDRES from SYS_WSRM_IN_MESSAGE_LOG where IML_INDENTIFIER = seq\n"
"do\n"
"{\n"
"if (IML_ADDRES is not null)\n"
"addr := (IML_ADDRES as wsa_cli).\"from\";\n"
"range := vector_concat (range, vector (IML_MESSAGE_ID));\n"
"}\n"
"\n"
"\n"
"\n"
"if (addr is not null)\n"
"WSRM_ASYNC_ACK_SEND (seq, addr, range);\n"
"\n"
"update SYS_WSRM_IN_SEQUENCES set WIS_ACK_SENT = 1 where WIS_IDENTIFIER = seq;\n"
"return;\n"
"}\n"
"--src wsrmsrv.sql:479\n"
;

static const char *other49 = 
"insert soft SYS_SCHEDULED_EVENT (SE_NAME, SE_START, SE_SQL, SE_INTERVAL)\n"
"values (\'WSRM Server Scheduled Tasks\', now(), \'DB.DBA.WSRM_SERVER_SCHEDULED_TASKS ()\', 100)\n";
static const char *proc102 = 
"#line 512 \"[executable]/wsrmsrv.sql\"\n"
"create procedure WSRM_SERVER_SCHEDULED_TASKS ()\n"
"{\n"
"\n"
"declare idn varchar;\n"
"\n"
"\n"
"\n"
"declare cr1 cursor for select WIS_IDENTIFIER\n"
"from SYS_WSRM_IN_SEQUENCES where WIS_SEQUENCE_EXPIRATION < now ();\n"
"\n"
"whenever not found goto nf1;\n"
"open cr1 (prefetch 1);\n"
"\n"
"while (1)\n"
"{\n"
"fetch cr1 into idn;\n"
"delete from SYS_WSRM_IN_MESSAGE_LOG where IML_INDENTIFIER = idn;\n"
"delete from SYS_WSRM_IN_SEQUENCES where current of cr1;\n"
"}\n"
"\n"
"nf1:\n"
"close cr1;\n"
"\n"
"\n"
"\n"
"declare cr2 cursor for select IML_INDENTIFIER\n"
"from SYS_WSRM_IN_MESSAGE_LOG where IML_STATE = 6;\n"
"\n"
"whenever not found goto nf2;\n"
"open cr2 (prefetch 1);\n"
"\n"
"while (1)\n"
"{\n"
"fetch cr2 into idn;\n"
"delete from SYS_WSRM_IN_SEQUENCES where WIS_IDENTIFIER = idn;\n"
"delete from SYS_WSRM_IN_MESSAGE_LOG where current of cr1;\n"
"}\n"
"\n"
"nf2:\n"
"close cr2;\n"
"\n"
"}\n"
"--src wsrmsrv.sql:510\n"
;

static const char *proc103 = 
"#line 557 \"[executable]/wsrmsrv.sql\"\n"
"create procedure WSRMSequenceAcknowledgement (\n"
"in  SequenceAcknowledgement any __soap_header \'http://schemas.xmlsoap.org/ws/2005/02/rm:SequenceAcknowledgement\',\n"
"in  MessageID any __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:MessageID\',\n"
"in  \"To\" any __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:To\',\n"
"in  Action any __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:Action\',\n"
"in  \"From\" any __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:From\',\n"
"in  ReplyTo any := null __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:ReplyTo\',\n"
"in  FaultTo any := null __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:FaultTo\',\n"
"in  Security any := null __soap_header \'http://schemas.xmlsoap.org/ws/2003/06/secext:Security\',\n"
"in  ws_soap_request any\n"
")\n"
"__soap_options (__soap_doc := \'__VOID__\', DefaultOperation := 1)\n"
"{\n"
"declare s soap_parameter;\n"
"declare identifier varchar;\n"
"declare cli wsrm_cli;\n"
"declare lines any;\n"
"\n"
"lines := http_request_header ();\n"
"s := new soap_parameter ();\n"
"s.s := SequenceAcknowledgement;\n"
"identifier := cast (WSRM_GET_IDENTIFIER (s.get_member (\'Identifier\')) as varchar);\n"
"\n"
"\n"
"cli := new wsrm_cli (WSA_CLI(), \'\', identifier);\n"
"\n"
"WSRM_ACKNOWLEDGEMENT_PROCESS (cli, identifier, s.s);\n"
"\n"
"\n"
"\n"
"http_request_status (\'HTTP/1.1 202 Accepted\');\n"
"http_flush ();\n"
"http_request_status (\'reply sent\');\n"
"}\n"
"--src wsrmsrv.sql:555\n"
;

static const char *proc104 = 
"#line 594 \"[executable]/wsrmsrv.sql\"\n"
"create procedure WSRMCreateSequence\n"
"(\n"
"in  CreateSequence any __soap_type \'http://schemas.xmlsoap.org/ws/2005/02/rm:CreateSequence\',\n"
"in  MessageID any := null __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:MessageID\',\n"
"in  \"To\" any := null __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:To\',\n"
"in  Action any := null __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:Action\',\n"
"in  \"From\" any := null __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:From\',\n"
"in  ReplyTo any := null __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:ReplyTo\',\n"
"in  FaultTo any := null __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:FaultTo\'\n"
")\n"
"__soap_doc \'http://schemas.xmlsoap.org/ws/2005/02/rm:CreateSequenceResponse\'\n"
"{\n"
"declare identifier any;\n"
"identifier := \'uuid:\' || lower (uuid ());\n"
"insert soft SYS_WSRM_IN_SEQUENCES (WIS_IDENTIFIER) values (identifier);\n"
"return soap_box_structure (\'Identifier\', vector (composite (), \'\', identifier));\n"
"}\n"
"--src wsrmsrv.sql:592\n"
;

static const char *proc105 = 
"#line 614 \"[executable]/wsrmsrv.sql\"\n"
"create procedure TerminateSequence\n"
"(\n"
"in  TerminateSequence any __soap_type \'http://schemas.xmlsoap.org/ws/2005/02/rm:TerminateSequence\',\n"
"in  MessageID any := null __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:MessageID\',\n"
"in  \"To\" any := null __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:To\',\n"
"in  Action any := null __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:Action\',\n"
"in  \"From\" any := null __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:From\',\n"
"in  ReplyTo any := null __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:ReplyTo\',\n"
"in  FaultTo any := null __soap_header \'http://schemas.xmlsoap.org/ws/2004/08/addressing:FaultTo\'\n"
")\n"
"__soap_doc \'__VOID__\'\n"
"{\n"
"delete from SYS_WSRM_IN_SEQUENCES where WIS_IDENTIFIER = TerminateSequence[0][2];\n"
"http_request_status (\'HTTP/1.1 202 Accepted\');\n"
"http_flush ();\n"
"http_request_status (\'reply sent\');\n"
"return;\n"
"}\n"
"--src wsrmsrv.sql:612\n"
;

/* wstr_ddl.sql */

static const char *udt4 = 
"create type POLICY_STRUCT as\n"
"(\n"
"usage varchar,\n"
"token_type varchar,\n"
"token_issuer varchar,\n"
"user_name varchar,\n"
"user_pass varchar,\n"
"debug integer default 0,\n"
"token varchar\n"
")\n";

static const char *tbl6 = 
"create table WST_SERVER_ISSUER_TOKENS\n"
"(\n"
"WSK_TOKEN_TYPE	varchar,\n"
"WSK_REQUEST_TYPE	varchar,\n"
"WSK_APPLIES_TO	varchar,\n"
"WSK_FROM		varchar,\n"
"WSK_SERVICE_NAME	varchar,\n"
"WSK_PORT_TYPE		varchar,\n"
"WSK_TOKEN		varchar,\n"
"PRIMARY KEY (WSK_TOKEN_TYPE, WSK_FROM, WSK_TOKEN)\n"
")\n";

/* wstrcli.sql */

static const char *proc106 = 
"#line 23 \"[executable]/wstrcli.sql\"\n"
"create procedure WST_CLI (in req SOAP_CLIENT_REQ, in policy POLICY_STRUCT)\n"
"{\n"
"declare ret any;\n"
"\n"
"ret := WST_GETRST (req, policy);\n"
"\n"
"if (policy.debug = 1)\n"
"return ret;\n"
"\n"
"policy.token := ret;\n"
"\n"
"ret := WS_TRUST_REQ (req, policy);\n"
"\n"
"return ret;\n"
"}\n"
"--src wstrcli.sql:21\n"
;

static const char *proc107 = 
"#line 40 \"[executable]/wstrcli.sql\"\n"
"create procedure WST_GETRST (in req SOAP_CLIENT_REQ, in policy POLICY_STRUCT)\n"
"{\n"
"declare ret any;\n"
"declare headers, param any;\n"
"declare wsa_from, wsu_time, par, created, expr, m_id, a_to, act soap_parameter;\n"
"declare rst SOAP_CLIENT_REQ;\n"
"declare style integer;\n"
"\n"
"rst := new SOAP_CLIENT_REQ ();\n"
"\n"
"rst.url := policy.token_issuer;\n"
"rst.operation := \'RequestSecurityToken\';\n"
"\n"
"wsa_from := new soap_parameter ();\n"
"wsa_from.set_xsd (\'http://schemas.xmlsoap.org/ws/2003/03/addressing:From\');\n"
"wsa_from.add_member (\'Address\', \'http://schemas.xmlsoap.org/ws/2003/03/addressing/role/anonymous\');\n"
"wsa_from.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"created := new soap_parameter (dt_set_tz (now (), 0));\n"
"created.set_xsd (\'http://schemas.xmlsoap.org/ws/2002/07/utility:Created\');\n"
"created.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"expr := new soap_parameter (dt_set_tz (dateadd (\'minute\', 5, now ()), 0));\n"
"expr.set_xsd (\'http://schemas.xmlsoap.org/ws/2002/07/utility:Expires\');\n"
"expr.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"wsu_time := new soap_parameter ();\n"
"wsu_time.set_xsd (\'http://schemas.xmlsoap.org/ws/2002/07/utility:Timestamp\');\n"
"wsu_time.add_member (\'Created\', created);\n"
"wsu_time.add_member (\'Expires\', expr);\n"
"\n"
"m_id := new soap_parameter (lower (\'UUID:\'||uuid ()));\n"
"m_id.set_xsd (\'http://schemas.xmlsoap.org/ws/2003/03/addressing:MessageID\');\n"
"m_id.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"a_to := new soap_parameter (rst.url);\n"
"a_to.set_xsd (\'http://schemas.xmlsoap.org/ws/2003/03/addressing:To\');\n"
"a_to.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"act := new soap_parameter (\'http://schemas.xmlsoap.org/security/RequestSecurityToken\');\n"
"act.set_xsd (\'http://schemas.xmlsoap.org/ws/2003/03/addressing:Action\');\n"
"act.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"headers := vector_concat (act.get_call_param (\'\'), wsa_from.get_call_param (\'\'), m_id.get_call_param (\'\'),\n"
"a_to.get_call_param (\'\'), wsu_time.get_call_param (\'\'));\n"
"\n"
"connection_set (\'__soap_ws_trust_user\', policy.user_name);\n"
"connection_set (\'__soap_ws_trust_pass\', policy.user_pass);\n"
"\n"
"if (policy.debug = 1)\n"
"style := 1 + 2 + 16;\n"
"else\n"
"style := 1 + 16;\n"
"\n"
"param := vector (vector (\n"
"\'RequestSecurityToken\', \'http://schemas.xmlsoap.org/ws/2002/12/secext:RequestSecurityToken\'),\n"
"soap_box_structure (\'TokenType\', \'wsse:\' || policy.token_type,\n"
"\'RequestType\', \'wsse:\' || policy.usage));\n"
"\n"
"ret := SOAP_CLIENT (url=>rst.url, operation=>rst.operation, headers=>headers,\n"
"style=>style,\n"
"parameters=>param,\n"
"auth_type=>\'key\',\n"
"soap_action=>\'http://schemas.xmlsoap.org/security/RequestSecurityToken\',\n"
"template=>\'[func:DB.DBA.SOAP_WS_TRUST_XENC_TEMPLATE]\',\n"
"\n"
"security_type=>\'sign\');\n"
"\n"
"if (policy.debug = 1)\n"
"return ret;\n"
"\n"
"return cast(xpath_eval (\'/RequestSecurityTokenResponse/RequestedSecurityToken/BinarySecurityToken/text()\'\n"
", xml_tree_doc (ret)) as varchar);\n"
"}\n"
"--src wstrcli.sql:38\n"
;

static const char *proc108 = 
"#line 117 \"[executable]/wstrcli.sql\"\n"
"create procedure WS_TRUST_REQ (in rst SOAP_CLIENT_REQ, in policy POLICY_STRUCT)\n"
"{\n"
"declare headers, ret, cli_cert_name any;\n"
"declare wsa_from, wsu_time, par, created, expr, m_id, a_to, act soap_parameter;\n"
"declare style integer;\n"
"\n"
"wsa_from := new soap_parameter ();\n"
"wsa_from.set_xsd (\'http://schemas.xmlsoap.org/ws/2003/03/addressing:From\');\n"
"wsa_from.add_member (\'Address\', \'http://schemas.xmlsoap.org/ws/2003/03/addressing/role/anonymous\');\n"
"wsa_from.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"created := new soap_parameter (dt_set_tz (now (), 0));\n"
"created.set_xsd (\'http://schemas.xmlsoap.org/ws/2002/07/utility:Created\');\n"
"created.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"expr := new soap_parameter (dt_set_tz (dateadd (\'minute\', 500, now ()), 0));\n"
"expr.set_xsd (\'http://schemas.xmlsoap.org/ws/2002/07/utility:Expires\');\n"
"expr.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"wsu_time := new soap_parameter ();\n"
"wsu_time.set_xsd (\'http://schemas.xmlsoap.org/ws/2002/07/utility:Timestamp\');\n"
"wsu_time.add_member (\'Created\', created);\n"
"wsu_time.add_member (\'Expires\', expr);\n"
"\n"
"m_id := new soap_parameter (lower (\'UUID:\'||uuid ()));\n"
"m_id.set_xsd (\'http://schemas.xmlsoap.org/ws/2003/03/addressing:MessageID\');\n"
"m_id.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"a_to := new soap_parameter (rst.url);\n"
"a_to.set_xsd (\'http://schemas.xmlsoap.org/ws/2003/03/addressing:To\');\n"
"a_to.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"act := new soap_parameter (\'http://weblogs.contoso.com/wse/samples/2003/07/AddEntry\');\n"
"act.set_xsd (\'http://schemas.xmlsoap.org/ws/2003/03/addressing:Action\');\n"
"act.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"if (policy.debug = 2)\n"
"style := 1 + 2 + 16;\n"
"else\n"
"style := 1 + 16;\n"
"\n"
"cli_cert_name := get_certificate_info (8, decode_base64 (policy.token), 1);\n"
"\n"
"if (cli_cert_name is null)\n"
"signal (\'42000\', \'Cannot resolve issued security token.\');\n"
"\n"
"headers := vector_concat (act.get_call_param (\'\'), wsa_from.get_call_param (\'\'), m_id.get_call_param (\'\'),\n"
"a_to.get_call_param (\'\'), wsu_time.get_call_param (\'\'));\n"
"\n"
"return SOAP_CLIENT (url=>rst.url, operation=>rst.operation, headers=>headers, style=>style, security_type=>\'sign\',\n"
"parameters=>rst.parameters, auth_type=>\'key\', template=>\'[\' || cli_cert_name || \']\');\n"
"}\n"
"--src wstrcli.sql:115\n"
;

/* wstrsrv.sql */

static const char *proc109 = 
"#line 24 \"[executable]/wstrsrv.sql\"\n"
"create procedure WS.SOAP.RequestSecurityToken\n"
"(\n"
"in  \"RequestSecurityToken\" any := null __soap_type \'http://schemas.xmlsoap.org/ws/2002/12/secext:RequestSecurityToken\',\n"
"out RequestSecurityTokenResponse any __soap_type \'http://schemas.xmlsoap.org/ws/2002/12/secext:RequestSecurityTokenResponse\',\n"
"inout \"From\" any __soap_header \'http://schemas.xmlsoap.org/ws/2003/03/addressing:From\',\n"
"inout \"MessageID\" any __soap_header \'http://schemas.xmlsoap.org/ws/2003/03/addressing:MessageID\',\n"
"out \"RelatesTo\" any __soap_header \'http://schemas.xmlsoap.org/ws/2003/03/addressing:RelatesTo\',\n"
"out \"Timestamp\" any __soap_header \'http://schemas.xmlsoap.org/ws/2002/07/utility:Timestamp\',\n"
"inout \"To\" any __soap_header \'http://schemas.xmlsoap.org/ws/2003/03/addressing:To\'\n"
") __soap_doc \'__VOID__\'\n"
"\n"
"{\n"
"declare ret any;\n"
"declare in_m_id any;\n"
"declare param any;\n"
"declare mid, bsc_any any;\n"
"declare wsa_from, wsu_time, par, created, expr, m_id, a_to, releates_to, bsc, resp, headers soap_parameter;\n"
"\n"
"bsc_any := ws_trust_token_gen (\"From\", \"MessageID\", \"RequestSecurityToken\", \"Timestamp\", \"To\");\n"
"in_m_id := cast (\"MessageID\"[1][1] as varchar);\n"
"\n"
"wsa_from := new soap_parameter ();\n"
"wsa_from.set_xsd (\'http://schemas.xmlsoap.org/ws/2003/03/addressing:From\');\n"
"wsa_from.add_member (\'Address\', \'http://\' || sys_connected_server_address () || http_map_get (\'domain\'));\n"
"wsa_from.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"created := new soap_parameter (dt_set_tz (now (), 0));\n"
"created.set_xsd (\'http://schemas.xmlsoap.org/ws/2002/07/utility:Created\');\n"
"created.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"expr := new soap_parameter (dt_set_tz (dateadd (\'minute\', 500, now ()), 0));\n"
"expr.set_xsd (\'http://schemas.xmlsoap.org/ws/2002/07/utility:Expires\');\n"
"expr.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"wsu_time := new soap_parameter ();\n"
"wsu_time.set_xsd (\'http://schemas.xmlsoap.org/ws/2002/07/utility:Timestamp\');\n"
"wsu_time.add_member (\'Created\', created);\n"
"wsu_time.add_member (\'Expires\', expr);\n"
"\n"
"m_id := new soap_parameter (lower (\'UUID:\'||uuid ()));\n"
"m_id.set_xsd (\'http://schemas.xmlsoap.org/ws/2003/03/addressing:MessageID\');\n"
"m_id.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"a_to := new soap_parameter (\'http://schemas.xmlsoap.org/ws/2003/03/addressing/role/anonymous\');\n"
"a_to.set_xsd (\'http://schemas.xmlsoap.org/ws/2003/03/addressing:To\');\n"
"a_to.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"releates_to := new soap_parameter (in_m_id);\n"
"releates_to.set_xsd (\'http://schemas.xmlsoap.org/ws/2003/03/addressing:RelatesTo\');\n"
"releates_to.set_attribute (\'RelationshipType\', \'wsa:Response\' || uuid());\n"
"releates_to.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"bsc := new soap_parameter (bsc_any);\n"
"bsc.set_xsd (\'http://schemas.xmlsoap.org/ws/2002/12/secext:BinarySecurityTokenType\');\n"
"bsc.set_attribute (\'ValueType\', \'wsse:X509v3\');\n"
"bsc.set_attribute (\'EncodingType\', \'wsse:Base64Binary\');\n"
"bsc.set_attribute (\'Id\', \'Id-\' || uuid());\n"
"\n"
"resp := new soap_parameter ();\n"
"resp.set_xsd (\'http://schemas.xmlsoap.org/ws/2002/12/secext:RequestSecurityTokenResponse\');\n"
"resp.add_member (\'TokenType\', \'wsse:X509v3\');\n"
"resp.add_member (\'RequestedSecurityToken\', vector (bsc.s));\n"
"\n"
"RequestSecurityTokenResponse := resp.s;\n"
"\"From\" := wsa_from.s;\n"
"\"MessageID\" := m_id.s;\n"
"\"Timestamp\" := wsu_time.s;\n"
"\"RelatesTo\" := releates_to.s;\n"
"\"To\" := a_to.s;\n"
"}\n"
"--src wstrsrv.sql:22\n"
;

static const char *other50 = 
"SOAP_LOAD_SCH (WSRM_WSS0212_XSD (), null, 0, 0)\n";
static const char *proc110 = 
"#line 99 \"[executable]/wstrsrv.sql\"\n"
"create procedure  DB.DBA.WS_TRUST_TOKEN_GEN (in \"From\" any, in \"MessageID\" any, in \"RequestSecurityToken\" any,\n"
"in \"Timestamp\" any, in \"To\" any)\n"
"{\n"
"declare ret any;\n"
"declare t_type, r_type, l_from varchar;\n"
"\n"
"if (__proc_exists (\'DB.DBA.WST_GET_SECURITY_TOKEN\'))\n"
"{\n"
"ret := call (\'DB.DBA.WST_GET_SECURITY_TOKEN\') (\"From\", \"MessageID\", \"RequestSecurityToken\", \"Timestamp\", \"To\");\n"
"return ret;\n"
"}\n"
"\n"
"t_type := cast (\"RequestSecurityToken\"[3] as varchar);\n"
"r_type := cast (\"RequestSecurityToken\"[5] as varchar);\n"
"l_from := cast (\"From\"[3] as varchar);\n"
"\n"
"select WSK_TOKEN into ret from WST_SERVER_ISSUER_TOKENS\n"
"where WSK_TOKEN_TYPE = t_type and WSK_REQUEST_TYPE = r_type and WSK_FROM = l_from;\n"
"\n"
"return ret;\n"
"}\n"
"--src wstrsrv.sql:97\n"
;

/* wsrmcall.xsl */

static const char *xsl23[]= {
"<?xml version=\"1.0\"?>\n"
"<!--\n"
" -  \n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -  \n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -  \n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -  \n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -  \n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -  \n"
" -  \n"
"-->\n"
"<!DOCTYPE xsl:stylesheet [\n"
"<!ENTITY soapencuri \"http://schemas.xmlsoap.org/soap/encoding/\">\n"
"<!ENTITY soapenv \"http://schemas.xmlsoap.org/soap/envelope/\">\n"
"<!ENTITY xsiuri \"http://www.w3.org/2001/XMLSchema-instance\">\n"
"<!ENTITY xsduri \"http://www.w3.org/2001/XMLSchema\">\n"
"<!ENTITY wsa \"http://schemas.xmlsoap.org/ws/2003/03/addressing\">\n"
"<!ENTITY wsa1 \"http://schemas.xmlsoap.org/ws/2004/03/addressing\">\n"
"<!ENTITY wsa2 \"http://schemas.xmlsoap.org/ws/2004/08/addressing\">\n"
"<!ENTITY wsu \"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\">\n"
"<!ENTITY wsse \"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\">\n"
"<!ENTITY ds \"http://www.w3.org/2000/09/xmldsig#\">\n"
"<!ENTITY xenc \"http://www.w3.org/2001/04/xmlenc#\">\n"
"]>\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\"\n"
"    xmlns:wsrm=\"http://schemas.xmlsoap.org/ws/2005/02/rm\"\n"
"    xmlns:soapenc=\"&soapencuri;\"\n"
"    xmlns:SOAP=\"&soapenv;\"\n"
"    xmlns:wsa=\"&wsa;\"\n"
"    xmlns:wsa1=\"&wsa1;\"\n"
"    xmlns:wsa2=\"&wsa2;\"\n"
"    xmlns:xsd=\"&xsduri;\"\n"
"    xmlns:xsi=\"&xsiuri;\"\n"
"    xmlns:wsu=\"&wsu;\"\n"
"    xmlns:wsse=\"&wsse;\"\n"
"    xmlns:ds=\"&ds;\"\n"
"    xmlns:xenc=\"&xenc;\"\n"
"    >\n"
"<xsl:output method=\"xml\" indent=\"yes\" omit-xml-declaration=\"yes\"/>\n"
"  <xsl:template match=\"/\">\n"
"    <xsl:apply-templates />\n"
"  </xsl:template>\n"
"  <xsl:template match=\"wsrm:*\" />\n"
"  <xsl:template match=\"*\">\n"
"    <xsl:copy>\n"
"      <xsl:copy-of select=\"@*\" />\n"
"      <xsl:apply-templates />\n"
"    </xsl:copy>\n"
"  </xsl:template>\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* rdf_net.sql */

static const char *other51 = 
"DB.DBA.VHOST_REMOVE (lpath=>\'/rdf_net\')\n";
static const char *other52 = 
"DB.DBA.VHOST_DEFINE (lpath=>\'/rdf_net\', ppath=>\'/rdf_net\')\n";
static const char *proc111 = 
"#line 36 \"[executable]/rdf_net.sql\"\n"
"create procedure rdf_net ()  __SOAP_HTTP \'text/html\'\n"
"{\n"
" ;\n"
"}\n"
"--src rdf_net.sql:34\n"
;

static const char *other53 = 
"grant execute on DB.DBA.rdf_net to public\n";
static const char *proc112 = 
"#line 45 \"[executable]/rdf_net.sql\"\n"
"create procedure DB.DBA.HTTP_RDF_NET (in _q any)\n"
"{\n"
"declare res, mdta, dta any;\n"
"declare state, msg, _check any;\n"
"declare ses any;\n"
"\n"
"_q := trim (_q);\n"
"\n"
"if (_q= \'\') return;\n"
"\n"
"_check := sql_parse (_q);\n"
"if (_check [0] <> 100)\n"
"signal (\'rdf_net\', \'Error in query.\');\n"
"\n"
"res := exec (_q,   state, msg, vector (), 0, mdta, dta);\n"
"\n"
"DB.DBA.rdf_net_make_struct (mdta, dta);\n"
"\n"
"return mdta;\n"
"}\n"
"--src rdf_net.sql:43\n"
;

static const char *proc113 = 
"#line 68 \"[executable]/rdf_net.sql\"\n"
"create procedure\n"
"rdf_net_format_mdta (inout mdta any)\n"
"{\n"
"declare idx, _line, _name, temp any;\n"
"\n"
"temp := mdta[0];\n"
"\n"
"for (idx := 0; idx < length (temp); idx := idx + 1)\n"
"{\n"
"_line := temp[idx];\n"
"_name := temp[idx][0];\n"
"_name := replace (_name, \' \', \'_\');\n"
"aset (_line, 0, _name);\n"
"aset (temp, idx, _line);\n"
"}\n"
"\n"
"aset (mdta, 0, temp);\n"
"}\n"
"--src rdf_net.sql:66\n"
;

static const char *proc114 = 
"#line 90 \"[executable]/rdf_net.sql\"\n"
"create procedure\n"
"rdf_net_make_xml (inout dta any, inout mdta any)\n"
"{\n"
"declare i, l, idx int;\n"
"declare ses any;\n"
"declare xsd varchar;\n"
"\n"
"ses := string_output ();\n"
"http (\'<?xml version=\"1.0\" ?>\\n\', ses);\n"
"http (\'<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:vcard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns=\"http://example.org/book/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:ns=\"http://example.org/ns#\">\\n\', ses);\n"
"i := 0; l := length (dta);\n"
"while (i < l)\n"
"{\n"
"declare _name, _row, _line varchar;\n"
"declare _type, _type_name, nill int;\n"
"_row := dta[i];\n"
"for (idx := 2; idx < length (_row); idx := idx + 2)\n"
"{\n"
"_type := _row[idx];\n"
"_name := _row[idx + 1];\n"
"_type := cast (_type as varchar);\n"
"_name := cast (_name as varchar);\n"
"\n"
"http (sprintf (\'<rdf:Description>\\n\'), ses);\n"
"http (sprintf (\'<%s>%s</%s>\\n\', _type, _name, _type), ses);\n"
"http (\'</rdf:Description>\\n\', ses);\n"
"}\n"
"i := i + 1;\n"
"}\n"
"http (\'</rdf:RDF>\', ses);\n"
"xsd := string_output_string (ses);\n"
"mdta := xsd;\n"
"return;\n"
"}\n"
"--src rdf_net.sql:88\n"
;

static const char *proc115 = 
"#line 127 \"[executable]/rdf_net.sql\"\n"
"create procedure\n"
"rdf_net_make_element (in mdta any, in dta any)\n"
"{\n"
"declare res any;\n"
"declare i, l, i1, i2 int;\n"
"i := 0; l := length (mdta); i1 := 2; i2 := 3;\n"
"res := make_array (2 + (l*2), \'any\');\n"
"while (i < l)\n"
"{\n"
"aset (res, i1, mdta[i][0]);\n"
"if (mdta[i][1] = 131 and not isblob(dta[i]))\n"
"aset (res, i2, cast (dta[i] as varbinary));\n"
"else\n"
"aset (res, i2, dta[i]);\n"
"i := i + 1;\n"
"i1 := i1 + 2;\n"
"i2 := i1 + 1;\n"
"}\n"
"return res;\n"
"}\n"
"--src rdf_net.sql:125\n"
;

static const char *proc116 = 
"#line 150 \"[executable]/rdf_net.sql\"\n"
"create procedure rdf_net_make_struct (inout mdta any, inout dta any)\n"
"{\n"
"declare res any;\n"
"declare i, l int;\n"
"mdta := mdta[0];\n"
"i := 0; l := length (dta);\n"
"res := make_array (l, \'any\');\n"
"while (i < l)\n"
"{\n"
"aset (res, i, rdf_net_make_element (mdta, dta[i]));\n"
"i := i + 1;\n"
"}\n"
"dta := res;\n"
"rdf_net_make_xml (dta, mdta);\n"
"}\n"
"--src rdf_net.sql:148\n"
;

static const char *other54 = 
"grant execute on DB.DBA.HTTP_RDF_NET to public\n";
/* simile.sql */

static const char *proc117 = 
"#line 26 \"[executable]/simile.sql\"\n"
"create procedure\n"
"DB.DBA.SIMILE_INIT ()\n"
"{\n"
"if (exists (select 1 from \"DB\".\"DBA\".\"SYS_USERS\" where U_NAME = \'SIMILE\'))\n"
"return;\n"
"DB.DBA.USER_CREATE (\'SIMILE\', uuid(), vector (\'DISABLED\', 1, \'LOGIN_QUALIFIER\', \'SIMILE\'));\n"
"}\n"
"--src simile.sql:24\n"
;


static const char *other55 = 
" DB.DBA.SIMILE_INIT ()\n";
static const char *other56 = 
"DB.DBA.VHOST_REMOVE (lpath=>\'/bank\')\n";
static const char *other57 = 
"DB.DBA.VHOST_DEFINE (lpath=>\'/bank\', ppath=>\'/SOAP/Http/simile\', soap_user=>\'SIMILE\')\n";
static const char *proc118 = 
"#line 48 \"[executable]/simile.sql\"\n"
"create procedure simile_iri (in s varchar)\n"
"{\n"
"return concat (\'http://simile.org/piggybank/\', s);\n"
"}\n"
"--src simile.sql:46\n"
;

static const char *proc119 = 
"#line 55 \"[executable]/simile.sql\"\n"
"create procedure SIMILE.SIMILE.simile ()  __SOAP_HTTP \'text/html\'\n"
"{\n"
"declare lines, ppath, path, pars, command, _rdf, _user, graph_iri, iri any;\n"
"\n"
"lines := http_request_header ();\n"
"pars := http_param ();\n"
"ppath := http_physical_path ();\n"
"path := split_and_decode (ppath, 0, \'\\0\\0/\');\n"
"_user := path[4];\n"
"\n"
"command := trim (ucase (get_keyword (\'command\', pars, \'\')));\n"
"_rdf := get_keyword (\'content\', pars, \'\');\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (command = \'UPLOAD\')\n"
"upload (_rdf, _user);\n"
"else if (command = \'CREATE\')\n"
"create_u (_user, lines);\n"
"else if (command = \'REMOVE\')\n"
"remove_u (_user);\n"
"else if (command = \'SAVE\')\n"
"upload (_rdf, _user);\n"
"else if (command = \'PUBLISH\')\n"
"upload (_rdf, _user);\n"
"else if (command = \'PERSIST\')\n"
"persist (_user);\n"
"else\n"
"http_request_status (\'HTTP/1.1 405 Method Not Allowed\');\n"
"\n"
"\n"
"}\n"
"--src simile.sql:53\n"
;

static const char *proc120 = 
"#line 94 \"[executable]/simile.sql\"\n"
"create procedure SIMILE.SIMILE.upload (in _rdf any, in _user varchar)\n"
"{\n"
"set_user_id (\'dba\');\n"
"DB.DBA.RDF_LOAD_RDFXML (_rdf, simile_iri (\'simile\'), simile_iri (_user));\n"
"}\n"
"--src simile.sql:92\n"
;

static const char *proc121 = 
"#line 101 \"[executable]/simile.sql\"\n"
"create procedure SIMILE.SIMILE.\"create_u\" (in _user varchar, in lines any)\n"
"{\n"
"declare _pass any;\n"
"_pass := WS.WS.FINDPARAM (lines, \'x-sembank-password-hash:\');\n"
"\n"
"if (exists (select 1 from WS.WS.SYS_DAV_USER where U_NAME = _user and pwd_magic_calc (U_NAME, U_PWD, 1) = _pass\n"
"and U_ACCOUNT_DISABLED = 0))\n"
"http_request_status (\'HTTP/1.1 201 Created\');\n"
"else\n"
"http_request_status (\'HTTP/1.1 403 Forbidden\');\n"
"}\n"
"--src simile.sql:99\n"
;

static const char *proc122 = 
"#line 114 \"[executable]/simile.sql\"\n"
"create procedure SIMILE.SIMILE.\"remove_u\" (in _item varchar)\n"
"{\n"
"return;\n"
"}\n"
"--src simile.sql:112\n"
;

static const char *proc123 = 
"#line 120 \"[executable]/simile.sql\"\n"
"create procedure SIMILE.SIMILE.\"persist\" (in _obj_uri varchar)\n"
"{\n"
"return;\n"
"}\n"
"--src simile.sql:118\n"
;

static const char *other58 = 
"grant execute on simile to public\n";
/* xrd2json.xsl */

static const char *xsl26[]= {
"<?xml version=\"1.0\" ?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n"
"    <xsl:output method=\"text\" media-type=\"application/json\"/>\n"
"  <xsl:variable name=\"uc\">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable>\n"
"  <xsl:variable name=\"lc\">abcdefghijklmnopqrstuvwxyz</xsl:variable>\n"
"    <xsl:template match=\"XRD\">\n"
"{\n"
"  <xsl:apply-templates select=\"Subject|Host|Alias\"/>\n"
"  \"link\": \n"
"    [\n"
"      <xsl:for-each select=\"Link\">\n"
"      {\n"
"        <xsl:for-each select=\"@*\">\"<xsl:value-of select=\"local-name(.)\"/>\": \"<xsl:value-of select=\".\"/>\"<xsl:if test=\"position () != last ()\">,\n"
"        </xsl:if></xsl:for-each>\n"
"      }<xsl:if test=\"position () != last ()\">,</xsl:if>\n"
"      </xsl:for-each>\n"
"    ]\n"
"}\n"
"    </xsl:template>\n"
"    <xsl:template match=\"Subject|Host|Alias\">\"<xsl:value-of select=\"translate (local-name(.), $uc, $lc)\"/>\": \"<xsl:value-of select=\".\"/>\",</xsl:template>\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* xml2json.xsl */

static const char *xsl27[]= {
"<?xml version=\"1.0\" ?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:vi=\"http://www.openlinksw.com/virtuoso/xslt/\" version=\"1.0\" >\n"
"    <xsl:output method=\"text\"/>\n"
"    <xsl:template match=\"/\">\n"
"	<xsl:text>{</xsl:text><xsl:apply-templates select=\"*\"/><xsl:text>}</xsl:text>\n"
"    </xsl:template>\n"
"    <xsl:template match=\"*[not (*) and text()]\">\"<xsl:value-of select=\"local-name(.)\"/>\":\"<xsl:value-of select=\"vi:json-esc-text (text())\"/><xsl:text>\"</xsl:text>\n"
"	<xsl:if test=\"following-sibling::*\"><xsl:text>, </xsl:text></xsl:if>\n"
"    </xsl:template>\n"
"    <xsl:template match=\"*[count(../*[name(../*) = name(.)]) = count(../*) and count(../*) &gt; 1]\">\n"
"	<xsl:if test=\"not(preceding-sibling::*)\"><xsl:text>\"</xsl:text><xsl:value-of select=\"local-name(.)\"/><xsl:text>\":[</xsl:text></xsl:if>\n"
"	<xsl:choose>\n"
"	    <xsl:when test=\"*\">\n"
"		<xsl:text>{</xsl:text><xsl:apply-templates select=\"*\"/><xsl:text>}</xsl:text>\n"
"	    </xsl:when>\n"
"	    <xsl:when test=\"not (*) and @*[.!='']\">\n"
"		<xsl:text>{</xsl:text>\n"
"		<xsl:for-each select=\"@*[.!='']\">\"-<xsl:value-of select=\"local-name(.)\"/>\":\"<xsl:value-of select=\"vi:json-esc-text (.)\"/><xsl:text>\"</xsl:text>\n"
"		    <xsl:if test=\"position() != last()\"><xsl:text>, </xsl:text></xsl:if>    \n"
"		</xsl:for-each>\n"
"		<xsl:if test=\"text()\"><xsl:text>, </xsl:text>\n"
"		    <xsl:text>\"#text\":\"</xsl:text><xsl:value-of select=\"vi:json-esc-text (./text())\"/><xsl:text>\"</xsl:text>\n"
"		</xsl:if>\n"
"		<xsl:text>}</xsl:text>\n"
"	    </xsl:when>\n"
"	    <xsl:otherwise>\n"
"		<xsl:text>\"</xsl:text><xsl:value-of select=\"vi:json-esc-text (./text())\"/><xsl:text>\"</xsl:text>\n"
"	    </xsl:otherwise>\n"
"	</xsl:choose>\n"
"	<xsl:if test=\"following-sibling::*\"><xsl:text>, </xsl:text></xsl:if>\n"
"	<xsl:if test=\"not(following-sibling::*)\"><xsl:text>]</xsl:text></xsl:if>\n"
"    </xsl:template>\n"
"    <xsl:template match=\"*\">\n"
"	<xsl:text>\"</xsl:text><xsl:value-of select=\"local-name(.)\"/><xsl:text>\":{</xsl:text>\n"
"	<xsl:for-each select=\"@*[.!='']\">\"-<xsl:value-of select=\"local-name(.)\"/>\":\"<xsl:value-of select=\"vi:json-esc-text (.)\"/><xsl:text>\"</xsl:text>\n"
"	    <xsl:if test=\"position() != last()\"><xsl:text>, </xsl:text></xsl:if>    \n"
"	</xsl:for-each>\n"
"	<xsl:if test=\"* and @*[.!='']\"><xsl:text>, </xsl:text></xsl:if>\n"
"	<xsl:apply-templates select=\"*\"/>\n"
"	<xsl:text>}</xsl:text>\n"
"	<xsl:if test=\"following-sibling::*\"><xsl:text>, </xsl:text></xsl:if>\n"
"    </xsl:template>\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* http_auth.sql */

static const char *proc124 = 
"#line 26 \"[executable]/http_auth.sql\"\n"
"create procedure\n"
"DB.DBA.HP_AUTH_SQL_USER (in realm varchar)\n"
"{\n"
"declare r integer;\n"
"r := DB.DBA.HTTP_AUTH_CHECK_USER (realm, 1, 1);\n"
"\n"
"if (r = 1)\n"
"{\n"
"if (http_map_get (\'persist_ses_vars\'))\n"
"{\n"
"declare vars any;\n"
"declare sid varchar;\n"
"vars := null;\n"
"sid := http_param (\'sid\');\n"
"vars := coalesce ((select deserialize (ASES_VARS) from DB.DBA.ADMIN_SESSION where ASES_ID = sid), null);\n"
"if (sid is not null and vars is null or isarray (vars))\n"
"connection_vars_set (vars);\n"
"if (sid is not null and connection_get (\'sid\') is null)\n"
"connection_set (\'sid\', sid);\n"
"}\n"
"return 1;\n"
"}\n"
"\n"
"else\n"
"{\n"
"return 0;\n"
"}\n"
"}\n"
"--src http_auth.sql:24\n"
;

static const char *proc125 = 
"#line 58 \"[executable]/http_auth.sql\"\n"
"create procedure\n"
"DB.DBA.HP_AUTH_DAV_ADMIN (in realm varchar)\n"
"{\n"
"declare r integer;\n"
"r := DB.DBA.HTTP_AUTH_CHECK_USER (realm, 0, 1, \'/admin/admin_dav\');\n"
"\n"
"if (r = 1)\n"
"{\n"
"if (http_map_get (\'persist_ses_vars\'))\n"
"{\n"
"declare vars any;\n"
"declare sid varchar;\n"
"vars := null;\n"
"sid := http_param (\'sid\');\n"
"vars := coalesce ((select deserialize (ASES_VARS) from DB.DBA.ADMIN_SESSION where ASES_ID = sid), null);\n"
"if (vars is null or isarray (vars))\n"
"connection_vars_set (vars);\n"
"if (connection_get (\'sid\') is null)\n"
"connection_set (\'sid\', sid);\n"
"}\n"
"return r;\n"
"}\n"
"\n"
"else\n"
"{\n"
"return 0;\n"
"}\n"
"}\n"
"--src http_auth.sql:56\n"
;

static const char *proc126 = 
"#line 89 \"[executable]/http_auth.sql\"\n"
"create procedure\n"
"DB.DBA.HP_AUTH_DAV_PROTOCOL (in realm varchar)\n"
"{\n"
"declare _u_name, _u_password, _perms varchar;\n"
"declare _u_id, _u_group, req_user, req_group, what integer;\n"
"declare auth any;\n"
"declare _user, lev varchar;\n"
"declare our_auth_vec, lines, sec, path, req_perms, req_meth, cmp_perms, def_page varchar;\n"
"declare _method, allow_basic, authenticated integer;\n"
"\n"
"declare c cursor for select 1, COL_OWNER, COL_GROUP, COL_PERMS\n"
"from WS.WS.SYS_DAV_COL where WS.WS.COL_PATH (COL_ID) = path;\n"
"declare r cursor for select 2, RES_OWNER, RES_GROUP, RES_PERMS\n"
"from WS.WS.SYS_DAV_RES where RES_FULL_PATH = path;\n"
"\n"
"authenticated := 0;\n"
"\n"
"lines := http_request_header ();\n"
"path := http_physical_path ();\n"
"\n"
"if (isarray (lines))\n"
"{\n"
"req_meth := aref (lines, 0);\n"
"if (strchr (req_meth, \' \') is not null)\n"
"req_meth := lower (substring (req_meth, 1, strchr (req_meth, \' \')));\n"
"}\n"
"\n"
"\n"
"if (req_meth = \'get\' or\n"
"req_meth = \'post\' or\n"
"req_meth = \'options\' or\n"
"req_meth = \'propfind\' or\n"
"req_meth = \'head\' or\n"
"req_meth = \'trace\' or\n"
"req_meth = \'copy\')\n"
"cmp_perms := \'1__\';\n"
"else if (req_meth = \'mkcol\' or req_meth = \'put\')\n"
"{\n"
"if (length (path) > 1 and strrchr (substring (path, 1, length(path) - 1), \'/\') is not null)\n"
"path := substring (path, 1, strrchr (substring (path, 1, length(path) - 1), \'/\') + 1);\n"
"cmp_perms := \'11_\';\n"
"}\n"
"else\n"
"cmp_perms := \'11_\';\n"
"\n"
"\n"
"what := 0;\n"
"whenever not found goto fr;\n"
"open c (prefetch 1);\n"
"fetch c into what, req_user, req_group, req_perms;\n"
"def_page := http_map_get (\'default_page\');\n"
"if (isstring (def_page))\n"
"{\n"
"path := concat (path, def_page);\n"
"what := 0;\n"
"}\n"
"fr:\n"
"close c;\n"
"\n"
"if (not what)\n"
"{\n"
"whenever not found goto fe;\n"
"open r (prefetch 1);\n"
"fetch r into what, req_user, req_group, req_perms;\n"
"fe:\n"
"close r;\n"
"}\n"
"\n"
"\n"
"sec := http_map_get (\'security_level\');\n"
"if (isstring (sec))\n"
"sec := ucase (sec);\n"
"if (sec = \'DIGEST\')\n"
"allow_basic := 0;\n"
"else\n"
"allow_basic := 1;\n"
"\n"
"auth := DB.DBA.vsp_auth_vec (lines);\n"
"\n"
"if (0 <> auth)\n"
"{\n"
"lev := get_keyword (\'authtype\', auth, \'\');\n"
"if (allow_basic = 0 and \'basic\' = lev)\n"
"goto nf;\n"
"\n"
"_user := get_keyword (\'username\', auth);\n"
"\n"
"if (_user = \'\' or isnull (_user))\n"
"{\n"
"goto nf;\n"
"}\n"
"\n"
"whenever not found goto nf;\n"
"\n"
"select U_NAME, pwd_magic_calc (U_NAME, U_PWD, 1), U_GROUP, U_ID, U_METHODS, U_DEF_PERMS\n"
"into _u_name, _u_password, _u_group, _u_id, _method, _perms from WS.WS.SYS_DAV_USER\n"
"where U_NAME = _user and U_ACCOUNT_DISABLED = 0 with (exclusive, prefetch 1);\n"
"if (_u_password is null)\n"
"goto nf;\n"
"if (DB.DBA.vsp_auth_verify_pass (auth, _u_name,\n"
"coalesce(get_keyword (\'realm\', auth), \'\'),\n"
"coalesce(get_keyword (\'uri\', auth), \'\'),\n"
"coalesce(get_keyword (\'nonce\', auth), \'\'),\n"
"coalesce(get_keyword (\'nc\', auth),\'\'),\n"
"coalesce(get_keyword (\'cnonce\', auth), \'\'),\n"
"coalesce(get_keyword (\'qop\', auth), \'\'),\n"
"_u_password))\n"
"{\n"
"update WS.WS.SYS_DAV_USER set U_LOGIN_TIME = now () where U_NAME = _user;\n"
"if (http_map_get (\'persist_ses_vars\'))\n"
"{\n"
"declare vars any;\n"
"declare sid varchar;\n"
"vars := null;\n"
"sid := http_param (\'sid\');\n"
"vars := coalesce ((select deserialize (ASES_VARS) from DB.DBA.ADMIN_SESSION where ASES_ID = sid),\n"
"null);\n"
"if (vars is null or isarray (vars))\n"
"connection_vars_set (vars);\n"
"if (connection_get (\'sid\') is null)\n"
"{\n"
"connection_set (\'sid\', sid);\n"
"}\n"
"}\n"
"if (connection_get (\'DAVUserID\') <> _u_id)\n"
"connection_set (\'DAVUserID\', _u_id);\n"
"authenticated := 1;\n"
"}\n"
"}\n"
"\n"
"\n"
"if (authenticated and _u_id = 1)\n"
"return 1;\n"
"else if (not authenticated and req_perms like concat (\'______\', cmp_perms, \'%\'))\n"
"return -1;\n"
"else if (authenticated and\n"
"((_u_id = req_user and req_perms like concat (cmp_perms, \'%\')) or\n"
"(req_group = _u_group and req_perms like concat (\'___\', cmp_perms, \'%\')) or\n"
"(req_perms like concat (\'______\', cmp_perms, \'%\'))))\n"
"return (_u_id);\n"
"else if (authenticated)\n"
"{\n"
"http_request_status (\'HTTP/1.1 403 Forbidden\');\n"
"http ( concat (\'<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\',\n"
"\'<HTML><HEAD>\',\n"
"\'<TITLE>403 Forbidden</TITLE>\',\n"
"\'</HEAD><BODY><H1>Forbidden</H1>\',\n"
"\'Access to the resource is forbidden.</BODY></HTML>\'));\n"
"return 0;\n"
"}\n"
"\n"
"\n"
"nf:\n"
"DB.DBA.vsp_auth_get (realm, \'/DAV\',\n"
"md5 (datestring(now())),\n"
"md5 (\'opaakki\'),\n"
"\'false\', lines, allow_basic);\n"
"return 0;\n"
"}\n"
"--src http_auth.sql:87\n"
;

static const char *proc127 = 
"#line 251 \"[executable]/http_auth.sql\"\n"
"create procedure\n"
"DB.DBA.HP_SES_VARS_STORE ()\n"
"{\n"
"declare vars any;\n"
"declare sid varchar;\n"
"if (http_map_get (\'persist_ses_vars\') and connection_is_dirty ())\n"
"{\n"
"vars := connection_vars ();\n"
"connection_vars_set (null);\n"
"sid := get_keyword (\'sid\', vars, null);\n"
"if (sid is not null)\n"
"update DB.DBA.ADMIN_SESSION set ASES_VARS = serialize (vars) where ASES_ID = sid;\n"
"}\n"
"}\n"
"--src http_auth.sql:249\n"
;

static const char *other59 = 
"grant execute on DB.DBA.HP_SES_VARS_STORE to public\n";
static const char *proc128 = 
"#line 271 \"[executable]/http_auth.sql\"\n"
"create procedure WS.WS.VSP_DEFINE (in path varchar, in _uid varchar)\n"
"{\n"
"declare x, y, stat, msg, st varchar;\n"
"declare str varchar;\n"
"if (strstr (path, \'..\'))\n"
"signal (\'22023\', \'Path contains ..\', \'HT051\');\n"
"str := string_output ();\n"
"\n"
"http (\'create procedure WS.WS.\"\', str);\n"
"http (path, str);\n"
"http (\'\" (in path varchar, in params varchar, in lines varchar) { ?>\', str);\n"
"st := NULL;\n"
"DB.DBA.expand_includes (path, str, 0, NULL, st);\n"
"\n"
"http (\'<?vsp }\', str);\n"
"stat := \'00000\';\n"
"str := string_output_string (str);\n"
"__set_user_id (_uid);\n"
"exec (str, stat, msg, vector (), 0, x, y);\n"
"if (stat <> \'00000\')\n"
"signal (stat, msg);\n"
"registry_set (path, file_stat (concat (http_root (), path)));\n"
"__pop_user_id ();\n"
"return 1;\n"
"}\n"
"--src http_auth.sql:269\n"
;

static const char *tbl7 = 
"CREATE TABLE WS.WS.SESSION (\n"
"S_ID 			varchar,\n"
"S_EXPIRE 			datetime,\n"
"S_VARS 			long varchar,\n"
"S_REQUEST_UNDER_RELOGIN 	long varchar,\n"
"S_REALM 			varchar,\n"
"S_IS_DIGEST 		integer,\n"
"S_DOMAIN 			varchar,\n"
"S_NONCE 			varchar,\n"
"S_OPAQUE 			varchar,\n"
"S_STALE 			varchar,\n"
"S_QOP 			varchar,\n"
"S_ALGORITHM 		varchar,\n"
"S_NC 			integer,\n"
"primary key (S_REALM, S_ID)\n"
")\n";

static const char *proc129 = 
"#line 324 \"[executable]/http_auth.sql\"\n"
" CREATE PROCEDURE WS.WS.SESSION_SAVE ()\n"
"{\n"
"declare sid varchar;\n"
"declare vars any;\n"
"\n"
"\n"
"vars := connection_vars ();\n"
"\n"
"if (http_map_get (\'persist_ses_vars\') and connection_is_dirty ())\n"
"{\n"
"\n"
"sid := get_keyword (\'sid\', vars, null);\n"
"\n"
"if (sid is not null)\n"
"update WS.WS.SESSION set S_VARS = serialize (vars) where S_ID = sid;\n"
"}\n"
"\n"
"connection_vars_set (NULL);\n"
"}\n"
"--src http_auth.sql:322\n"
;

static const char *proc130 = 
"#line 347 \"[executable]/http_auth.sql\"\n"
" CREATE PROCEDURE WS.WS.SESSION_TERMINATE (in url varchar)\n"
"{\n"
"\n"
"delete from WS.WS.SESSION where S_ID = connection_get (\'sid\');\n"
"\n"
"http_request_status (\'HTTP/1.1 302 Found\');\n"
"http_header (sprintf (\'Location: %s\\r\\n\', url));\n"
"}\n"
"--src http_auth.sql:345\n"
;

static const char *proc131 = 
"#line 361 \"[executable]/http_auth.sql\"\n"
" CREATE PROCEDURE WS.WS.DIGEST_AUTH (in realm varchar)\n"
"{\n"
"declare auth_vec, lines, vars, server_nc any;\n"
"declare passwd, sid, old_sid varchar;\n"
"declare client_nc, nonce varchar;\n"
"declare user_check varchar;\n"
"declare opts, public_pages, req_path any;\n"
"\n"
"opts := http_map_get (\'auth_opts\');\n"
"if (isarray (opts))\n"
"{\n"
"declare i, l integer;\n"
"public_pages := split_and_decode (get_keyword (\'public_pages\', opts, \'\'), 0, \',=,\');\n"
"req_path := split_and_decode (http_path (), 0, \'\\0\\0/\');\n"
"l := length (public_pages); i := 0;\n"
"while (i < l)\n"
"{\n"
"if (trim(public_pages[i]) = req_path [length (req_path) - 1] or req_path [length (req_path) - 1] = \'\')\n"
"return 1;\n"
"i := i + 1;\n"
"}\n"
"}\n"
"\n"
"lines := http_request_header();\n"
"auth_vec := DB.DBA.vsp_auth_vec (lines);\n"
"old_sid := null;\n"
"if (0 <> auth_vec)\n"
"{\n"
"declare usp any;\n"
"if (\'digest\' <> lower (get_keyword (\'authtype\' , auth_vec, \'\'))\n"
"or \'\' = get_keyword (\'username\' , auth_vec, \'\'))\n"
"goto nf;\n"
"\n"
"sid := get_keyword (\'opaque\', auth_vec, \'\');\n"
"if (sid = \'\')\n"
"sid := get_keyword (\'nonce\', auth_vec, \'\');\n"
"server_nc := coalesce ((select S_NC from WS.WS.SESSION where S_ID = sid), 0);\n"
"server_nc := sprintf (\'%08x\', server_nc);\n"
"client_nc := lower (get_keyword (\'nc\', auth_vec, \'0\'));\n"
"usp := http_map_get (\'auth_opts\');\n"
"if (not isarray(usp))\n"
"signal (\'22023\', \'The authentication hook needs a authentication option \"users_proc\" to be set to the function for user account checking.\', \'HT055\');\n"
"user_check := get_keyword (\'users_proc\', usp, null);\n"
"if (user_check is null)\n"
"goto nf;\n"
"call (user_check) (get_keyword (\'username\' , auth_vec), passwd);\n"
"if (passwd is null)\n"
"goto nf;\n"
"if (server_nc = client_nc and 1 = DB.DBA.vsp_auth_verify_pass (auth_vec,\n"
"get_keyword (\'username\' , auth_vec),\n"
"get_keyword (\'realm\', auth_vec, \'\'),\n"
"get_keyword (\'uri\', auth_vec, \'\'),\n"
"get_keyword (\'nonce\', auth_vec, \'\'),\n"
"get_keyword (\'nc\', auth_vec, \'\'),\n"
"get_keyword (\'cnonce\', auth_vec, \'\'),\n"
"get_keyword (\'qop\', auth_vec, \'\'),\n"
"passwd))\n"
"{\n"
"vars := coalesce ((select deserialize (S_VARS) from WS.WS.SESSION where S_ID = sid), NULL);\n"
"connection_vars_set (vars);\n"
"if (exists (select 1 from WS.WS.SESSION where S_ID = sid and S_EXPIRE <= now ()))\n"
"{\n"
"delete from WS.WS.SESSION where S_ID = sid and S_EXPIRE <= now ();\n"
"old_sid := sid;\n"
"goto nf;\n"
"}\n"
"update WS.WS.SESSION set S_EXPIRE = dateadd (\'minute\', 10, now ()), S_NC = S_NC + 1 where S_ID = sid;\n"
"return 1;\n"
"}\n"
"}\n"
"nf:\n"
"sid := md5 (concat (datestring (now ()), http_client_ip (), http_path ()));\n"
"nonce := sid;\n"
"vars := vector (\'sid\', sid);\n"
"if (old_sid is not null)\n"
"{\n"
"connection_set (\'sid\', sid);\n"
"vars := connection_vars ();\n"
"connection_vars_set (NULL);\n"
"}\n"
"insert into WS.WS.SESSION (S_REALM, S_ID, S_EXPIRE, S_VARS,\n"
"S_DOMAIN, S_NC, S_OPAQUE, S_NONCE, S_STALE, S_ALGORITHM)\n"
"values (http_path (), sid, dateadd (\'minute\', 10, now ()), serialize (vars),\n"
"http_path (), 1, sid, nonce, \'false\', \'MD5\');\n"
"DB.DBA.vsp_auth_get (realm, http_map_get (\'domain\'), nonce, sid, \'false\', lines, 0);\n"
"http (\'<HTML><BODY><p>Authorization failed (401)</p></BODY></HTML>\');\n"
"return 0;\n"
"}\n"
"--src http_auth.sql:359\n"
;

static const char *proc132 = 
"#line 457 \"[executable]/http_auth.sql\"\n"
"create procedure\n"
"DB.DBA.HTTP_AUTH_CHECK_USER (\n"
"in realm varchar,\n"
"in needSql integer := 0,\n"
"in requestAuth integer := 0,\n"
"in authDomain varchar := null)\n"
"{\n"
"declare _u_name, _u_password varchar;\n"
"declare sec, lev varchar;\n"
"declare allow_basic integer;\n"
"declare _user varchar;\n"
"declare lines, auth any;\n"
"\n"
"lines := http_request_header ();\n"
"sec := http_map_get (\'security_level\');\n"
"if (isstring (sec))\n"
"sec := lower (sec);\n"
"if (sec = \'digest\')\n"
"allow_basic := 0;\n"
"else\n"
"allow_basic := 1;\n"
"\n"
"auth := DB.DBA.vsp_auth_vec (lines);\n"
"if (0 <> auth)\n"
"{\n"
"lev := get_keyword (\'authtype\', auth, \'\');\n"
"if (allow_basic = 0 and \'basic\' = lev)\n"
"return -1;\n"
"_user := get_keyword (\'username\', auth, \'\');\n"
"\n"
"if (\'\' = _user)\n"
"goto nf;\n"
"\n"
"whenever not found goto nf;\n"
"\n"
"select U_NAME, U_PASSWORD\n"
"into _u_name, _u_password from DB.DBA.SYS_USERS\n"
"where U_NAME = _user and U_ACCOUNT_DISABLED = 0 and U_IS_ROLE = 0 and (U_SQL_ENABLE = 1 or needSql = 0) with (prefetch 1);\n"
"\n"
"if (1 = DB.DBA.vsp_auth_verify_pass (auth, _u_name,\n"
"get_keyword (\'realm\', auth, \'\'),\n"
"get_keyword (\'uri\', auth, \'\'),\n"
"get_keyword (\'nonce\', auth, \'\'),\n"
"get_keyword (\'nc\', auth, \'\'),\n"
"get_keyword (\'cnonce\', auth, \'\'),\n"
"get_keyword (\'qop\', auth, \'\'),\n"
"_u_password))\n"
"{\n"
"connection_set (\'SPARQLUserId\', _u_name);\n"
"commit work;\n"
"return 1;\n"
"}\n"
"}\n"
"\n"
"nf:\n"
"if (requestAuth = 1)\n"
"{\n"
"DB.DBA.vsp_auth_get (\n"
"realm,\n"
"coalesce (authDomain, http_path ()),\n"
"md5 (datestring (now ())),\n"
"md5 (\'secret\'),\n"
"\'false\',\n"
"lines,\n"
"allow_basic);\n"
"return 0;\n"
"}\n"
"\n"
"return -1;\n"
"}\n"
"--src http_auth.sql:455\n"
;

static const char *proc133 = 
"#line 529 \"[executable]/http_auth.sql\"\n"
"create procedure\n"
"DB.DBA.HP_AUTH_SPARQL_USER (in realm varchar)\n"
"{\n"
"if (DB.DBA.HTTP_AUTH_CHECK_USER (realm, 1, 1) = 1)\n"
"return 1;\n"
"else\n"
"return 0;\n"
"}\n"
"--src http_auth.sql:527\n"
;

/* xmla.sql */

static const char *udt5 = 
"create type xmla_discover as\n"
"(\n"
"request_type varchar,\n"
"restrictions any,\n"
"properties   any,\n"
"metadata	   any\n"
")\n"
"constructor method xmla_discover (request_type varchar, restrictions any, properties any),\n"
"method xmla_discover_datasources () returns any,\n"
"method xmla_discover_properties () returns any,\n"
"method xmla_discover_schema_rowsets () returns any,\n"
"method xmla_discover_enumerators () returns any,\n"
"method xmla_discover_keywords () returns any,\n"
"method xmla_discover_literals () returns any,\n"
"method xmla_dbschema_catalogs () returns any,\n"
"method xmla_dbschema_columns () returns any,\n"
"method xmla_dbschema_foreign_keys () returns any,\n"
"method xmla_dbschema_primary_keys () returns any,\n"
"method xmla_dbschema_provider_types () returns any,\n"
"method xmla_dbschema_tables () returns any,\n"
"method xmla_dbschema_tables_info () returns any,\n"
"method xmla_get_restriction (pname varchar, deflt any) returns any,\n"
"method xmla_get_property (pname varchar, deflt any) returns any,\n"
"method xmla_command () returns any\n";

static const char *other60 = 
"create constructor method\n"
"xmla_discover (in request_type varchar, in restrictions any, in properties any) for xmla_discover\n"
"{\n"
"self.request_type := request_type;\n"
"self.restrictions := restrictions;\n"
"self.properties   := properties;\n"
"}\n";

static const char *other61 = 
"create method\n"
"xmla_command () for xmla_discover\n"
"{\n"
"declare h any;\n"
"declare res any;\n"
"h := udt_implements_method (self, fix_identifier_case (\'xmla_\' || lcase (self.request_type)));\n"
"if (h)\n"
"{\n"
"res := call (h) (self);\n"
"return res;\n"
"}\n"
"signal (\'22023\', \'Not supported request : \' || self.request_type, \'XMLA0\');\n"
"}\n";

static const char *other62 = 
"create method\n"
"xmla_get_restriction (in pname varchar, in deflt any) for xmla_discover\n"
"{\n"
"declare restr_list any;\n"
"if (self.restrictions is not null)\n"
"{\n"
"restr_list := get_keyword (\'RestrictionList\', self.restrictions);\n"
"if (restr_list is null)\n"
"restr_list := get_keyword (\'urn:schemas-microsoft-com:xml-analysis:RestrictionList\', self.restrictions);\n"
"if (restr_list is not null)\n"
"{\n"
"declare val any;\n"
"val := get_keyword (pname, restr_list);\n"
"if (val is null)\n"
"val := get_keyword (\'urn:schemas-microsoft-com:xml-analysis:\'||pname, restr_list, deflt);\n"
"return val;\n"
"}\n"
"}\n"
"return deflt;\n"
"}\n";

static const char *other63 = 
"create method\n"
"xmla_get_property (in pname varchar, in deflt any) for xmla_discover\n"
"{\n"
"return xmla_get_property (self.properties , pname, deflt);\n"
"}\n";

static const char *proc134 = 
"#line 114 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_get_property (inout properties any, in pname varchar, in deflt any)\n"
"{\n"
"declare prop_list, ses_prop, val any;\n"
"declare i, l int;\n"
"val := null;\n"
"if (properties is not null)\n"
"{\n"
"prop_list := get_keyword (\'PropertyList\', properties, NULL);\n"
"if (prop_list is null)\n"
"prop_list := get_keyword (\'urn:schemas-microsoft-com:xml-analysis:PropertyList\', properties, NULL);\n"
"if (prop_list is not null)\n"
"{\n"
"val := get_keyword (pname, prop_list);\n"
"if (val is null)\n"
"val := get_keyword (\'urn:schemas-microsoft-com:xml-analysis:\'||pname, prop_list);\n"
"}\n"
"if (val is not null)\n"
"return val;\n"
"}\n"
"ses_prop := connection_get (\'XMLA_Properties\');\n"
"i := 0; l := length (ses_prop);\n"
"while (i < l)\n"
"{\n"
"declare elm any;\n"
"elm := ses_prop[i];\n"
"if (elm[0] = pname)\n"
"return elm[5];\n"
"i := i + 1;\n"
"}\n"
"return deflt;\n"
"}\n"
"--src xmla.sql:112\n"
;

static const char *proc135 = 
"#line 149 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_result_xsd (in name varchar, in typ varchar, in typ_name varchar)\n"
"{\n"
"return xslt (\'http://local.virt/soap_sch\',\n"
"xml_tree_doc (\'<complexType name=\"\' || name ||\n"
"\'\" xmlns=\"http://www.w3.org/2001/XMLSchema\"\' ||\n"
"\' xmlns:tns=\"urn:schemas-microsoft-com:xml-analysis:rowset\" targetNamespace=\"urn:schemas-microsoft-com:xml-analysis\">\' ||\n"
"\'<all><element name=\"\' || typ_name || \'\" type=\"tns:\' || typ || \'\" /></all></complexType>\'));\n"
"}\n"
"--src xmla.sql:147\n"
;

static const char *proc136 = 
"#line 160 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_session (in begin_session any, in end_session any, inout _session any, in properties any)\n"
"{\n"
"declare sid varchar;\n"
"if (_session is not null)\n"
"{\n"
"declare copy_ses, saved_props any;\n"
"copy_ses := _session;\n"
"_session := null;\n"
"sid := xpath_eval (\'/Session/@SessionID\', xml_tree_doc (copy_ses), 1);\n"
"saved_props :=\n"
"(select deserialize (S_VARS) from WS.WS.SESSION where S_ID = cast (sid as varchar) and S_REALM = \'XMLA\');\n"
"connection_set (\'XMLA_Properties\', saved_props);\n"
"properties := xmla_set_props (properties);\n"
"update WS.WS.SESSION set S_VARS = serialize (properties), S_EXPIRE = dateadd (\'minute\', 10, now ())\n"
"where S_ID = cast (sid as varchar) and S_REALM = \'XMLA\';\n"
"connection_set (\'XMLA_Properties\', properties);\n"
"commit work;\n"
"}\n"
"else if (begin_session is not null)\n"
"{\n"
"sid := md5 (cast (now() as varchar) || \'XMLA\');\n"
"properties := xmla_set_props (properties);\n"
"insert into WS.WS.SESSION (S_ID, S_EXPIRE, S_VARS, S_REALM)\n"
"values (sid, dateadd (\'minute\', 10, now ()), serialize (properties), \'XMLA\');\n"
"_session := xml_tree_doc (\n"
"\'<XA:Session xmlns:XA=\"urn:schemas-microsoft-com:xml-analysis\"\'\n"
"|| \' mustUnderstand=\"1\" SessionID=\"\' || sid || \'\"/>\'\n"
");\n"
"connection_set (\'XMLA_Properties\', properties);\n"
"commit work;\n"
"}\n"
"else if (end_session is not null)\n"
"{\n"
"sid := xpath_eval (\'/EndSession/@SessionID\', xml_tree_doc (end_session), 1);\n"
"delete from WS.WS.SESSION where S_ID = cast (sid as varchar) and S_REALM = \'XMLA\';\n"
"commit work;\n"
"}\n"
"}\n"
"--src xmla.sql:158\n"
;

static const char *proc137 = 
"#line 201 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_make_codes (in code varchar) returns varchar\n"
"{\n"
"declare i, l int;\n"
"declare res varchar;\n"
"res := \'\';\n"
"i := 0; l := length (code);\n"
"while (i < l)\n"
"{\n"
"if (code[i] >= ascii (\'0\') and code[i] <= ascii (\'9\'))\n"
"res := res || chr (code[i]);\n"
"else\n"
"res := res || sprintf (\'%d\', code[i]);\n"
"i := i + 1;\n"
"}\n"
"return res;\n"
"}\n"
"--src xmla.sql:199\n"
;

static const char *proc138 = 
"#line 220 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"\"Discover\" (in  \"RequestType\" varchar,\n"
"in  \"Restrictions\" any := NULL\n"
"\n"
", in  \"Properties\" any\n"
"\n"
", in \"BeginSession\" any __soap_header \'__XML__\'\n"
", in \"EndSession\" any __soap_header \'__XML__\'\n"
", inout \"Session\" any __soap_header \'__XML__\'\n"
", out \"Error\" any __soap_fault \'__XML__\'\n"
", out \"ws_xmla_xsd\" any\n"
")\n"
"__soap_options (__soap_type:=\'__ANY__\',\n"
"\"soapAction\":=\'urn:schemas-microsoft-com:xml-analysis:Discover\',\n"
"\"RequestNamespace\":=\'urn:schemas-microsoft-com:xml-analysis\',\n"
"\"ResponseNamespace\":=\'urn:schemas-microsoft-com:xml-analysis\',\n"
"\"PartName\":=\'return\'\n"
")\n"
"{\n"
"declare res, mdta any;\n"
"declare discover xmla_discover;\n"
"declare res_xsd any;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"declare xcode int;\n"
"xcode := atoi (xmla_make_codes (__SQL_STATE));\n"
"\"Error\" :=\n"
"xml_tree_doc (sprintf (\n"
"\'<Error ErrorCode=\"%d\" Description=\"[%s] %V\" Source=\"XML for Analysis Provider\" HelpFile=\"\" />\',\n"
"xcode, __SQL_STATE, __SQL_MESSAGE));\n"
"http_request_status (\'HTTP/1.1 500 Internal Server Error\');\n"
"connection_set (\'SOAPFault\', vector (sprintf (\'XMLAnalysisError.0x%08x\', xcode),\n"
"\'The XML for Analysis provider encountered an error\'));\n"
"return;\n"
"};\n"
"xmla_session (\"BeginSession\", \"EndSession\", \"Session\", \"Properties\");\n"
"discover := new xmla_discover (\"RequestType\", \"Restrictions\", \"Properties\");\n"
"res := discover.xmla_command ();\n"
"\n"
"mdta := discover.metadata;\n"
"\"ws_xmla_xsd\" := vector_concat (vector (xmla_result_xsd (\'return\', \'root\', \'root\')) , DB.DBA.SOAP_LOAD_SCH (mdta, NULL, 1));\n"
"return soap_box_structure (\'root\', vector_concat (vector (discover.metadata), res));\n"
"}\n"
"--src xmla.sql:218\n"
;

static const char *proc139 = 
"#line 266 \"[executable]/xmla.sql\"\n"
"create procedure xmla_check_user (inout uname varchar, inout passwd varchar)\n"
"{\n"
"declare ret int;\n"
"\n"
"ret := 1;\n"
"\n"
"if (uname is null and is_https_ctx ())\n"
"{\n"
"uname := connection_get (\'SPARQLUserId\');\n"
"passwd := (select pwd_magic_calc (U_NAME, U_PASSWORD, 1) from DB.DBA.SYS_USERS where U_NAME = uname);\n"
"}\n"
"\n"
"if (uname is null or passwd is null) \n"
"{\n"
"if (ret = 1)\n"
"signal (\'00002\', \'Unable to process the request, because the UserName property is not set or incorrect\');\n"
"else\n"
"signal (\'00009\', \'Unable to process the request, because the UserName property is not mapped to any SQL UserName\');\n"
"}\n"
"return ret;\n"
"}\n"
"--src xmla.sql:264\n"
;

static const char *proc140 = 
"#line 290 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"\"Execute\"  (in  \"Command\" varchar\n"
"\n"
", in  \"Properties\" any\n"
"\n"
", in \"BeginSession\" any __soap_header \'__XML__\'\n"
", in \"EndSession\" any __soap_header \'__XML__\'\n"
", inout \"Session\" any __soap_header \'__XML__\'\n"
", out \"Error\" any __soap_fault \'__XML__\'\n"
", out \"ws_xmla_xsd\" any\n"
")\n"
"__soap_options ( __soap_type:=\'__ANY__\',\n"
"\"soapAction\":=\'urn:schemas-microsoft-com:xml-analysis:Execute\',\n"
"\"RequestNamespace\":=\'urn:schemas-microsoft-com:xml-analysis\',\n"
"\"ResponseNamespace\":=\'urn:schemas-microsoft-com:xml-analysis\',\n"
"\"PartName\":=\'return\'\n"
")\n"
"{\n"
"declare res, mdta, dta any;\n"
"declare cat, fmt, axis_fmt, what, dsn, state, msg, stmt, tree, blob_limit, stmt_is_ddl any;\n"
"declare uname, passwd varchar;\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"declare xcode int;\n"
"xcode := atoi (xmla_make_codes (__SQL_STATE));\n"
"\"Error\" :=\n"
"xml_tree_doc (sprintf (\n"
"\'<Error ErrorCode=\"%d\" Description=\"[%s] %V\" Source=\"XML for Analysis Provider\" HelpFile=\"\" />\',\n"
"xcode, __SQL_STATE, __SQL_MESSAGE));\n"
"http_request_status (\'HTTP/1.1 500 Internal Server Error\');\n"
"connection_set (\'SOAPFault\', vector (sprintf (\'XMLAnalysisError.0x%08x\', xcode),\n"
"\'The XML for Analysis provider encountered an error\'));\n"
"return;\n"
"};\n"
"xmla_session (\"BeginSession\", \"EndSession\", \"Session\", \"Properties\");\n"
"dsn := xmla_get_property (\"Properties\", \'DataSourceInfo\', xmla_service_name ());\n"
"dsn := xmla_get_dsn_name (dsn);\n"
"\n"
"uname := xmla_get_property (\"Properties\", \'UserName\', null);\n"
"passwd := xmla_get_property (\"Properties\", \'Password\', null);\n"
"\n"
"\n"
"if (stmt is null and (\"BeginSession\" is not null or \"EndSession\" is not null))\n"
"return xml_tree_doc (\'<root xmlns=\"urn:schemas-microsoft-com:xml-analysis:empty\" />\');\n"
"\n"
"xmla_check_user (uname, passwd);\n"
"\n"
"state := \'00000\';\n"
"stmt := get_keyword (\'Statement\', \"Command\");\n"
"if (stmt is null)\n"
"stmt := get_keyword (\'urn:schemas-microsoft-com:xml-analysis:Statement\', \"Command\");\n"
"\n"
"xmla_cursor_stmt_change (\"Properties\", stmt);\n"
"\n"
"cat := xmla_get_property (\"Properties\", \'Catalog\', \'DB\');\n"
"fmt := xmla_get_property (\"Properties\", \'Format\', \'Tabular\');\n"
"axis_fmt := xmla_get_property (\"Properties\", \'AxisFormat\', \'TupleFormat\');\n"
"\n"
"\n"
"if (fmt not in (\'Tabular\') or axis_fmt not in (\'TupleFormat\'))\n"
"signal (\'00003\', \'Unable to process the request, because the Format or AxisFormat property is not supported\');\n"
"\n"
"what := xmla_get_property (\"Properties\", \'Content\', \'SchemaData\');\n"
"\n"
"set_user_id (uname, 1, passwd);\n"
"set_qualifier (cat);\n"
"\n"
"dta := vector ();\n"
"stmt_is_ddl := 0;\n"
"if (not xmla_not_local_dsn (dsn))\n"
"{\n"
"\n"
"tree := sql_parse (stmt);\n"
"if (tree [0] = 609)\n"
"{\n"
"stmt := sprintf (\'SELECT CAST (%s as VARCHAR)\', stmt);\n"
"tree := sql_parse (stmt);\n"
"}\n"
"if (tree [0] <> 100 and tree[0] <> 113)\n"
"{\n"
"if (registry_get (\'XMLA-DML\') = \'1\')\n"
"{\n"
"exec_metadata (\'select 1 as res\', null, null, mdta);\n"
"stmt_is_ddl := 1;\n"
"}\n"
"else\n"
"signal (\'00004\', \'Only select statements are supported via XML for Analysis provider\');\n"
"}\n"
"res := exec (stmt, state, msg, vector (), 0, mdta, dta);\n"
"if (isinteger (dta))\n"
"dta := vector (vector (dta));\n"
"if ((1 = length (dta)) and (1 = length (dta[0])) and (214 = __tag (dta[0][0])))\n"
"{\n"
"declare triples, inx any;\n"
"triples := dict_list_keys (dta[0][0], 1);\n"
"for (inx := 0; inx < length (triples); inx := inx + 1)\n"
"{\n"
"declare trip any;\n"
"trip := triples [inx];\n"
"trip [0] := __ro2sq (trip[0]);\n"
"trip [1] := __ro2sq (trip[1]);\n"
"trip [2] := __ro2sq (trip[2]);\n"
"triples [inx] := trip;\n"
"}\n"
"dta := triples;\n"
"exec_metadata (\'select \\\'\\\' as S, \\\'\\\' as P, \\\'\\\' as O any\', state, msg, mdta);\n"
"}\n"
"\n"
"\n"
"blob_limit := atoi (xmla_get_property (\"Properties\", \'BLOBLimit\', \'0\'));\n"
"if (blob_limit > 0)\n"
"connection_set (\'SOAPBlobLimit\', blob_limit);\n"
"}\n"
"else\n"
"{\n"
"\n"
"dsn := xmla_get_dsn_name (dsn);\n"
"rexecute (dsn, stmt, state, msg, vector (), 0, mdta, dta);\n"
"}\n"
"\n"
"if (state <> \'00000\')\n"
"signal (state, msg);\n"
"\n"
"\n"
"xmla_format_mdta (mdta);\n"
"if (not stmt_is_ddl)\n"
"xmla_make_cursors_state (\"Properties\", dta, stmt);\n"
"xmla_sparql_result (mdta, dta, stmt);\n"
"xmla_make_struct (mdta, dta);\n"
"\"ws_xmla_xsd\" := vector_concat (vector (xmla_result_xsd (\'return\', \'root\', \'root\')) , DB.DBA.SOAP_LOAD_SCH (mdta, NULL, 1));\n"
"return soap_box_structure (\'root\', case what when \'Data\' then dta\n"
"when \'Schema\' then vector (mdta)\n"
"else vector_concat (vector(mdta), dta) end);\n"
"}\n"
"--src xmla.sql:288\n"
;

static const char *proc141 = 
"#line 428 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_not_local_dsn (in dsn varchar)\n"
"{\n"
"declare nfo varchar;\n"
"if (dsn is null)\n"
"return 1;\n"
"nfo := split_and_decode (dsn,0,\'\\0\\0=\');\n"
"if (nfo[0] = xmla_service_name ())\n"
"return 0;\n"
"return 1;\n"
"}\n"
"--src xmla.sql:426\n"
;

static const char *proc142 = 
"#line 441 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_make_meta (in dta any)\n"
"{\n"
"declare i, l, i1 int;\n"
"declare res any;\n"
"i := 0; l := length (dta);\n"
"if (not isarray(dta) or l < 1)\n"
"return NULL;\n"
"dta := dta[0];\n"
"l := length (dta);\n"
"if (__tag(dta[0]) <> 255 or mod(l,2) <> 0 or l < 2)\n"
"return NULL;\n"
"res := make_array ((l/2) - 1, \'any\'); i1 := 0; i := 2;\n"
"while (i < l)\n"
"{\n"
"declare dtp any;\n"
"dtp := __tag (dta[i+1]);\n"
"aset (res, i1, vector (dta[i],\n"
"case when dtp = 193 and length(dta[i+1]) = 2 then \'boolean\' else dtp end\n"
"));\n"
"i1 := i1 + 1;\n"
"i := i + 2;\n"
"}\n"
"return res;\n"
"}\n"
"--src xmla.sql:439\n"
;

static const char *other64 = 
"create method\n"
"xmla_discover_datasources () returns any for xmla_discover\n"
"{\n"
"declare dta, mdta, _all any;\n"
"declare idx, has_vdb int;\n"
"\n"
"has_vdb := sys_stat (\'st_has_vdb\');\n"
"if (has_vdb)\n"
"_all := sql_data_sources (1);\n"
"else\n"
"_all := vector ();\n"
"\n"
"dta := vector (\n"
"soap_box_structure (\n"
"\'DataSourceName\', \'Local Server\',\n"
"\'DataSourceDescription\', \'Virtuoso Server\',\n"
"\'URL\', soap_current_url (),\n"
"\'DataSourceInfo\', \'DSN=\' || xmla_service_name(),\n"
"\'ProviderName\', \'Virtuoso XML for Analysis\',\n"
"\'ProviderType\', soap_box_structure (\n"
"\'TDP\', \'\'\n"
"\n"
"\n"
"),\n"
"\'AuthenticationMode\', \'Authenticated\'\n"
"));\n"
"\n"
"for (idx := 0; idx < length (_all); idx := idx + 1)\n"
"{\n"
"if (exists (select 1 from DB.DBA.SYS_DATA_SOURCE where DS_DSN = _all[idx][0]))\n"
"{\n"
"dta := vector_concat (dta, vector (soap_box_structure (\n"
"\'DataSourceName\', _all[idx][0],\n"
"\'DataSourceDescription\', _all[idx][1],\n"
"\'URL\', soap_current_url (),\n"
"\'DataSourceInfo\', \'DSN=\' || _all[idx][0],\n"
"\'ProviderName\', \'Virtuoso XML for Analysis\',\n"
"\'ProviderType\', soap_box_structure (\n"
"\'TDP\', \'\'\n"
"),\n"
"\'AuthenticationMode\', \'Authenticated\'\n"
")));\n"
"}\n"
"};\n"
"\n"
"mdta := xmla_make_meta (dta);\n"
"xmla_make_xsd (mdta);\n"
"self.metadata := mdta;\n"
"return dta;\n"
"}\n";

static const char *other65 = 
"create method\n"
"xmla_discover_properties () returns any for xmla_discover\n"
"{\n"
"declare res, props, _dsn any;\n"
"declare i, l int;\n"
"\n"
"_dsn := self.xmla_get_property (\'DataSourceInfo\', null);\n"
"\n"
"props := xmla_get_props (_dsn);\n"
"l := length (props);\n"
"i := 0;\n"
"res := make_array (l, \'any\');\n"
"\n"
"while (i < l)\n"
"{\n"
"declare prop any;\n"
"prop := props[i];\n"
"aset (res, i,\n"
"soap_box_structure (\'PropertyName\', prop[0],\n"
"\'PropertyDescription\', prop[1],\n"
"\'PropertyType\', prop[2],\n"
"\'PropertyAccessType\', case prop[3] when \'R\' then \'Read\' when \'W\' then \'Write\' else \'ReadWrite\' end,\n"
"\'IsRequired\', soap_boolean(prop[4]),\n"
"\'Value\', prop[5])\n"
");\n"
"i := i + 1;\n"
"}\n"
"declare mdta any;\n"
"mdta := xmla_make_meta (res);\n"
"xmla_make_xsd (mdta);\n"
"self.metadata := mdta;\n"
"return res;\n"
"}\n";

static const char *other66 = 
"create method\n"
"xmla_discover_schema_rowsets () returns any for xmla_discover\n"
"{\n"
"declare res, schs any;\n"
"declare i, l int;\n"
"\n"
"schs := xmla_get_schs ();\n"
"l := length (schs);\n"
"i := 0;\n"
"res := make_array (l, \'any\');\n"
"while (i < l)\n"
"{\n"
"declare sch any;\n"
"sch := schs[i];\n"
"aset (res, i,\n"
"soap_box_structure (\'SchemaName\', sch[0],\n"
"\'Restrictions\', sch[1],\n"
"\'Description\', sch[2])\n"
");\n"
"i := i + 1;\n"
"}\n"
"declare mdta any;\n"
"mdta := xmla_make_meta (res);\n"
"xmla_make_xsd (mdta);\n"
"self.metadata := mdta;\n"
"return res;\n"
"}\n";

static const char *other67 = 
"create method\n"
"xmla_discover_enumerators () returns any for xmla_discover\n"
"{\n"
"declare res, enums any;\n"
"declare i, l int;\n"
"\n"
"enums := xmla_get_enums ();\n"
"l := length (enums);\n"
"i := 0;\n"
"res := make_array (l, \'any\');\n"
"while (i < l)\n"
"{\n"
"declare enum any;\n"
"enum := enums[i];\n"
"aset (res, i,\n"
"soap_box_structure (\'EnumName\', enum[0],\n"
"\'EnumDescription\', enum[1],\n"
"\'EnumType\', enum[2],\n"
"\'ElementName\', enum[3],\n"
"\'ElementDescription\', enum[4],\n"
"\'EnumValue\', enum[5])\n"
");\n"
"i := i + 1;\n"
"}\n"
"declare mdta any;\n"
"mdta := xmla_make_meta (res);\n"
"xmla_make_xsd (mdta);\n"
"self.metadata := mdta;\n"
"return res;\n"
"}\n";

static const char *other68 = 
"create method\n"
"xmla_discover_keywords () returns any for xmla_discover\n"
"{\n"
"declare kwds, res any;\n"
"declare i, l int;\n"
"declare dsn any;\n"
"\n"
"dsn := self.xmla_get_property (\'DataSourceInfo\', xmla_service_name ());\n"
"dsn := xmla_get_dsn_name (dsn);\n"
"\n"
"if (not xmla_not_local_dsn (dsn))\n"
"kwds := xmla_get_kwds ();\n"
"else\n"
"{\n"
"declare _all any;\n"
"dsn := xmla_get_dsn_name (dsn);\n"
"_all := get_keyword (89, vdd_dsn_info(dsn), \'\');\n"
"kwds := split_and_decode (_all, 0, \'\\0\\0,\');\n"
"}\n"
"\n"
"l := length (kwds);\n"
"i := 0;\n"
"res := make_array (l, \'any\');\n"
"while (i < l)\n"
"{\n"
"aset (res, i,\n"
"soap_box_structure (\'Keyword\', kwds[i])\n"
");\n"
"i := i + 1;\n"
"}\n"
"declare mdta any;\n"
"mdta := xmla_make_meta (res);\n"
"xmla_make_xsd (mdta);\n"
"self.metadata := mdta;\n"
"return res;\n"
"}\n";

static const char *other69 = 
"create method\n"
"xmla_discover_literals () returns any for xmla_discover\n"
"{\n"
"declare res, lits any;\n"
"declare i, l int;\n"
"\n"
"lits := xmla_get_literals ();\n"
"l := length (lits);\n"
"i := 0;\n"
"res := make_array (l, \'any\');\n"
"while (i < l)\n"
"{\n"
"declare lit any;\n"
"lit := lits[i];\n"
"aset (res, i,\n"
"soap_box_structure (\'LiteralName\', lit[0],\n"
"\'LiteralValue\', lit[1],\n"
"\'LiteralInvalidChars\', lit[2],\n"
"\'LiteralInvalidStartingChars\', lit[3],\n"
"\'LiteralMaxLength\', lit[4]\n"
")\n"
");\n"
"i := i + 1;\n"
"}\n"
"declare mdta any;\n"
"mdta := xmla_make_meta (res);\n"
"xmla_make_xsd (mdta);\n"
"self.metadata := mdta;\n"
"return res;\n"
"}\n";

static const char *other70 = 
"create method\n"
"xmla_dbschema_catalogs () for xmla_discover\n"
"{\n"
"declare dta, mdta, cat any;\n"
"declare dsn any;\n"
"\n"
"dsn := self.xmla_get_property (\'DataSourceInfo\', xmla_service_name ());\n"
"dsn := xmla_get_dsn_name (dsn);\n"
"cat := self.xmla_get_restriction (\'CATALOG_NAME\', \'%\');\n"
"if (cat is null)\n"
"cat := \'%\';\n"
"\n"
"if (not xmla_not_local_dsn (dsn))\n"
"{\n"
"exec (\'select distinct name_part(KEY_TABLE,0) as CATALOG_NAME,\n"
"NULL as DESCRIPTION\n"
"from DB.DBA.SYS_KEYS where name_part(KEY_TABLE,0) like ?\', null, null,\n"
"vector (cat), 0, mdta, dta);\n"
"}\n"
"else\n"
"{\n"
"declare tables, temp, _last any;\n"
"declare idx int;\n"
"\n"
"tables := sql_tables (dsn, NULL, NULL, NULL, \'TABLE\');\n"
"temp := make_array (length (tables), \'any\');\n"
"for (idx := 0; idx < length (tables); idx := idx + 1)\n"
"if (tables[idx][0] is NULL)\n"
"aset (temp, idx, tables[idx][1]);\n"
"else\n"
"aset (temp, idx, tables[idx][0]);\n"
"temp := __vector_sort (temp);\n"
"if (length (temp) > 0)\n"
"_last := temp [0];\n"
"dta := vector (_last, NULL, NULL);\n"
"for (idx := 0; idx < length (temp); idx := idx + 1)\n"
"{\n"
"if (_last <> temp[idx])\n"
"{\n"
"_last := temp [idx];\n"
"dta := vector_concat (dta, vector (_last, NULL, NULL));\n"
"}\n"
"}\n"
"exec (\'select distinct name_part(KEY_TABLE,0) as CATALOG_NAME,\n"
"NULL as DESCRIPTION\n"
"from DB.DBA.SYS_KEYS where name_part(KEY_TABLE,0) like ?\', null, null,\n"
"vector (cat), 0, mdta);\n"
"dta := vector (dta);\n"
"}\n"
"\n"
"\n"
"xmla_make_struct (mdta, dta);\n"
"self.metadata := mdta;\n"
"return dta;\n"
"}\n";

static const char *proc143 = 
"#line 748 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_make_xsd (inout mdta any)\n"
"{\n"
"declare i, l int;\n"
"declare ses any;\n"
"declare xsd varchar;\n"
"ses := string_output ();\n"
"http (\'<schema  xmlns=\"http://www.w3.org/2001/XMLSchema\"  targetNamespace=\"urn:schemas-microsoft-com:xml-analysis:rowset\" elementFormDefault=\"qualified\" xmlns:sql=\"urn:schemas-microsoft-com:xml-sql\" xmlns:tns=\"urn:schemas-microsoft-com:xml-analysis:rowset\">\\n\', ses);\n"
"http (\'<element name=\"root\" type=\"tns:root\" />\\n\', ses);\n"
"http (\'<complexType name=\"root\">\\n\', ses);\n"
"http (  \'<sequence minOccurs=\"0\" maxOccurs=\"unbounded\">\\n\', ses);\n"
"http (    \'<element name=\"row\" type=\"tns:row\" />\\n\', ses);\n"
"http (  \'</sequence>\\n\', ses);\n"
"http (\'</complexType>\\n\', ses);\n"
"http (\'<complexType name=\"row\">\\n\', ses);\n"
"http (  \'<choice maxOccurs=\"unbounded\" minOccurs=\"0\" >\\n\', ses);\n"
"i := 0; l := length (mdta);\n"
"while (i < l)\n"
"{\n"
"declare _name varchar;\n"
"declare _type, _type_name, nill int;\n"
"_name := mdta[i][0];\n"
"_type := mdta[i][1];\n"
"if (length (mdta[i]) > 4)\n"
"nill := mdta[i][4];\n"
"else\n"
"nill := 0;\n"
"if (_type <> 193)\n"
"{\n"
"if (isstring (_type))\n"
"_type_name := _type;\n"
"else\n"
"_type_name := dv_to_soap_type (_type);\n"
"http (sprintf (\'<element name=\"%V\" type=\"%s\" sql:field=\"%s\" nillable=\"%d\" />\\n\', _name, _type_name, _name, nill), ses);\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'<element name=\"%V\" sql:field=\"%s\">\\n\', _name, _name), ses);\n"
"http (\'<complexType>\\n\', ses);\n"
"http (    \'<sequence minOccurs=\"0\" maxOccurs=\"unbounded\">\\n\', ses);\n"
"http (      \'<any processContents=\"lax\" maxOccurs=\"unbounded\"/>\\n\', ses);\n"
"http (    \'</sequence>\\n\', ses);\n"
"http (\'</complexType>\\n\', ses);\n"
"http (\'</element>\\n\', ses);\n"
"}\n"
"i := i + 1;\n"
"}\n"
"http (  \'</choice>\\n\', ses);\n"
"http (\'</complexType>\\n\', ses);\n"
"http (\'</schema>\', ses);\n"
"xsd := string_output_string (ses);\n"
"mdta := xml_tree_doc (xsd);\n"
"return;\n"
"}\n"
"--src xmla.sql:746\n"
;

static const char *proc144 = 
"#line 804 \"[executable]/xmla.sql\"\n"
"create procedure xmla_make_struct (inout mdta any, inout dta any)\n"
"{\n"
"declare res any;\n"
"declare i, l int;\n"
"mdta := mdta[0];\n"
"i := 0; l := length (dta);\n"
"res := make_array (l, \'any\');\n"
"while (i < l)\n"
"{\n"
"aset (res, i, xmla_make_element (mdta, dta[i]));\n"
"i := i + 1;\n"
"}\n"
"dta := res;\n"
"xmla_make_xsd (mdta);\n"
"}\n"
"--src xmla.sql:802\n"
;

static const char *proc145 = 
"#line 821 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_make_element (in mdta any, in dta any)\n"
"{\n"
"declare res any;\n"
"declare i, l, i1, i2 int;\n"
"i := 0; l := length (mdta); i1 := 2; i2 := 3;\n"
"res := make_array (2 + (l*2), \'any\');\n"
"aset (res, 0, composite ());\n"
"aset (res, 1, \'<structure>\');\n"
"while (i < l)\n"
"{\n"
"aset (res, i1, mdta[i][0]);\n"
"if (mdta[i][1] = 131 and not isblob(dta[i]))\n"
"aset (res, i2, cast (dta[i] as varbinary));\n"
"else if (mdta[i][1] = 219 and 219 <> __tag (dta[i]))\n"
"aset (res, i2, cast (dta[i] as decimal));\n"
"else\n"
"aset (res, i2, dta[i]);\n"
"i := i + 1;\n"
"i1 := i1 + 2;\n"
"i2 := i1 + 1;\n"
"}\n"
"return res;\n"
"}\n"
"--src xmla.sql:819\n"
;

static const char *other71 = 
"create method xmla_dbschema_columns () for xmla_discover\n"
"{\n"
"declare dta, mdta any;\n"
"declare dsn, cat, tb, col, sch any;\n"
"\n"
"dsn := self.xmla_get_property (\'DataSourceInfo\', xmla_service_name ());\n"
"dsn := xmla_get_dsn_name (dsn);\n"
"cat := self.xmla_get_restriction (\'TABLE_CATALOG\', \'%\');\n"
"sch := self.xmla_get_restriction (\'TABLE_SCHEMA\', \'%\');\n"
"tb := self.xmla_get_restriction (\'TABLE_NAME\', \'%\');\n"
"col := self.xmla_get_restriction (\'COLUMN_NAME\', \'%\');\n"
"if (cat is null)\n"
"cat := \'%\';\n"
"if (sch is null)\n"
"sch := \'%\';\n"
"if (tb is null)\n"
"tb := \'%\';\n"
"if (col is null)\n"
"col := \'%\';\n"
"\n"
"if (not xmla_not_local_dsn (dsn))\n"
"{\n"
"declare uname, passwd varchar;\n"
"uname := self.xmla_get_property (\'UserName\', null);\n"
"passwd := self.xmla_get_property (\'Password\', null);\n"
"xmla_check_user (uname, passwd);\n"
"set_user_id (uname, 1, passwd);\n"
"exec(\'select\n"
"name_part(KEY_TABLE, 0) as TABLE_CATALOG,\n"
"name_part(KEY_TABLE, 1) as TABLE_SCHEMA,\n"
"name_part(KEY_TABLE, 2) as TABLE_NAME,\n"
"\"COLUMN\" as COLUMN_NAME,\n"
"NULL as COLUMN_GUID,\n"
"NULL as COLUMN_PROPID INTEGER,\n"
"(select count(*) from DB.DBA.SYS_COLS where \"TABLE\" = KEY_TABLE and COL_ID <= c.COL_ID and \"COLUMN\" <> \'\'_IDN\'\') as ORDINAL_POSITION INTEGER,\n"
"case when deserialize(COL_DEFAULT) is null then 0 else -1 end as COLUMN_HASDEFAULT SMALLINT,\n"
"cast (deserialize(COL_DEFAULT) as NVARCHAR) as COLUMN_DEFAULT NVARCHAR(254),\n"
"cast (DB.DBA.oledb_dbflags(COL_DTP, COL_NULLABLE) as integer) as COLUMN_FLAGS INTEGER,\n"
"case COL_NULLABLE when 1 then -1 else 0 end as IS_NULLABLE SMALLINT,\n"
"cast (DB.DBA.oledb_dbtype(COL_DTP) as integer) as DATA_TYPE SMALLINT,\n"
"NULL as TYPE_GUID,\n"
"cast (DB.DBA.oledb_char_max_len(COL_DTP, COL_PREC) as integer) as CHARACTER_MAXIMUM_LENGTH INTEGER,\n"
"cast (DB.DBA.oledb_char_oct_len(COL_DTP, COL_PREC) as integer) as CHARACTER_OCTET_LENGTH INTEGER,\n"
"cast (DB.DBA.oledb_num_prec(COL_DTP, COL_PREC) as smallint) as NUMERIC_PRECISION SMALLINT,\n"
"cast (DB.DBA.oledb_num_scale(COL_DTP, COL_SCALE) as smallint) as NUMERIC_SCALE SMALLINT,\n"
"cast (DB.DBA.oledb_datetime_prec(COL_DTP, COL_PREC) as integer) as DATETIME_PRECISION INTEGER,\n"
"NULL as CHARACTER_SET_CATALOG NVARCHAR(1),\n"
"NULL as CHARACTER_SET_SCHEMA NVARCHAR(1),\n"
"NULL as CHARACTER_SET_NAME NVARCHAR(1),\n"
"NULL as COLLATION_CATALOG NVARCHAR(1),\n"
"NULL as COLLATION_SCHEMA NVARCHAR(1),\n"
"NULL as COLLATION_NAME NVARCHAR(1),\n"
"NULL as DOMAIN_CATALOG NVARCHAR(1),\n"
"NULL as DOMAIN_SCHEMA NVARCHAR(1),\n"
"NULL as DOMAIN_NAME NVARCHAR(1),\n"
"NULL as DESCRIPTION NVARCHAR(1)\n"
"from DB.DBA.SYS_KEYS, DB.DBA.SYS_KEY_PARTS, DB.DBA.SYS_COLS c\n"
"where\n"
"__any_grants(KEY_TABLE) and\n"
"name_part(KEY_TABLE, 0) = ? and\n"
"name_part(KEY_TABLE, 1) like ? and\n"
"name_part(KEY_TABLE, 2) like ? and\n"
"\"COLUMN\" like ? and\n"
"\"COLUMN\" <> \'\'_IDN\'\' and\n"
"KEY_IS_MAIN = 1 and\n"
"KEY_MIGRATE_TO is null and\n"
"KP_KEY_ID = KEY_ID and\n"
"COL_ID = KP_COL order by KEY_TABLE, 7 option (order)\'\n"
", null, null,\n"
"vector (cat, sch, tb, col), 0, mdta, dta);\n"
"}\n"
"else\n"
"{\n"
"dsn := xmla_get_dsn_name (dsn);\n"
"\n"
"exec (\'select TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, COLUMN_GUID, COLUMN_PROPID,\' ||\n"
"\'ORDINAL_POSITION, COLUMN_HASDEFAULT, COLUMN_DEFAULT, IS_NULLABLE, DATA_TYPE,\' ||\n"
"\'TYPE_GUID, CHARACTER_MAXIMUM_LENGTH, CHARACTER_OCTET_LENGTH, NUMERIC_PRECISION, NUMERIC_SCALE,\' ||\n"
"\'DATETIME_PRECISION, CHARACTER_SET_CATALOG, CHARACTER_SET_SCHEMA, CHARACTER_SET_NAME,\' ||\n"
"\'COLLATION_CATALOG, COLLATION_SCHEMA, COLLATION_NAME, DOMAIN_CATALOG, DOMAIN_SCHEMA,\' ||\n"
"\'DOMAIN_NAME, DESCRIPTION \' ||\n"
"\'from DB.DBA.XMLA_VDD_DBSCHEMA_COLUMNS where cat = ? and tb = ? and col = ? and dsn = ?\'\n"
", null, null, vector (cat, tb, col, dsn), 0, mdta, dta);\n"
"}\n"
"\n"
"xmla_make_struct (mdta, dta);\n"
"self.metadata := mdta;\n"
"return dta;\n"
"}\n";

static const char *other72 = 
"create method xmla_dbschema_foreign_keys () for xmla_discover\n"
"{\n"
"declare dta, mdta, stmt, state, msg any;\n"
"declare dsn any;\n"
"declare p_cat, p_tbl, p_sch any;\n"
"declare f_cat, f_tbl, f_sch any;\n"
"declare _ptbl, _ftbl varchar;\n"
"\n"
"dsn := self.xmla_get_property (\'DataSourceInfo\', xmla_service_name ());\n"
"dsn := xmla_get_dsn_name (dsn);\n"
"\n"
"p_cat := self.xmla_get_restriction (\'PK_TABLE_CATALOG\', \'%\');\n"
"p_sch := self.xmla_get_restriction (\'PK_TABLE_SCHEMA\', \'%\');\n"
"p_tbl := self.xmla_get_restriction (\'PK_TABLE_NAME\', \'%\');\n"
"f_cat := self.xmla_get_restriction (\'FK_TABLE_CATALOG\', \'%\');\n"
"f_sch := self.xmla_get_restriction (\'FK_TABLE_SCHEMA\', \'%\');\n"
"f_tbl := self.xmla_get_restriction (\'FK_TABLE_NAME\', \'%\');\n"
"\n"
"if (p_cat is null)\n"
"{\n"
"if (f_cat is not null)\n"
"p_cat := f_cat;\n"
"else\n"
"p_cat := \'%\';\n"
"}\n"
"\n"
"if (f_cat is null)\n"
"{\n"
"if (p_cat is not null)\n"
"f_cat := p_cat;\n"
"else\n"
"f_cat := \'%\';\n"
"}\n"
"\n"
"if (p_sch is null)\n"
"p_sch := \'%\';\n"
"if (p_tbl is null)\n"
"p_tbl := \'%\';\n"
"if (f_sch is null)\n"
"f_sch := \'%\';\n"
"if (f_tbl is null)\n"
"f_tbl := \'%\';\n"
"\n"
"p_cat := trim (p_cat, \'\"\');\n"
"p_sch := trim (p_sch, \'\"\');\n"
"p_tbl := trim (p_tbl, \'\"\');\n"
"f_cat := trim (f_cat, \'\"\');\n"
"f_sch := trim (f_sch, \'\"\');\n"
"f_tbl := trim (f_tbl, \'\"\');\n"
"_ptbl := p_cat || \'.\' || p_sch || \'.\' || p_tbl;\n"
"_ftbl := f_cat || \'.\' || f_sch || \'.\' || f_tbl;\n"
"\n"
"if (not xmla_not_local_dsn (dsn))\n"
"{\n"
"declare uname, passwd varchar;\n"
"uname := self.xmla_get_property (\'UserName\', null);\n"
"passwd := self.xmla_get_property (\'Password\', null);\n"
"xmla_check_user (uname, passwd);\n"
"set_user_id (uname, 1, passwd);\n"
"exec(\'select\n"
"name_part (PK_TABLE, 0) as PK_TABLE_CATALOG varchar (128),\n"
"name_part (PK_TABLE, 1) as PK_TABLE_SCHEMA varchar (128),\n"
"name_part (PK_TABLE, 2) as PK_TABLE_NAME varchar (128),\n"
"PKCOLUMN_NAME as PK_COLUMN_NAME,\n"
"NULL as PK_COLUMN_GUID,\n"
"NULL as PK_COLUMN_PROPID INTEGER,\n"
"name_part (FK_TABLE, 0) as FK_TABLE_CATALOG varchar (128),\n"
"name_part (FK_TABLE, 1) as FK_TABLE_SCHEMA varchar (128),\n"
"name_part (FK_TABLE, 2) as FK_TABLE_NAME varchar (128),\n"
"FKCOLUMN_NAME as FK_COLUMN_NAME,\n"
"NULL as FK_COLUMN_GUID,\n"
"NULL as FK_COLUMN_PROPID INTEGER,\n"
"(KEY_SEQ + 1) as ORDINAL INTEGER,\n"
"(case UPDATE_RULE when 0 then \'\'NO ACTION\'\' when 1 then \'\'CASCADE\'\' when 2 then \'\'SET NULL\'\' when 3 then \'\'SET DEFAULT\'\' else NULL end) as UPDATE_RULE varchar(20),\n"
"(case DELETE_RULE when 0 then \'\'NO ACTION\'\' when 1 then \'\'CASCADE\'\' when 2 then \'\'SET NULL\'\' when 3 then \'\'SET DEFAULT\'\' else NULL end) as DELETE_RULE varchar(20),\n"
"PK_NAME,\n"
"FK_NAME,\n"
"3 as DEFERRABILITY SMALLINT\n"
"from DB.DBA.SYS_FOREIGN_KEYS SYS_FOREIGN_KEYS\n"
"where name_part (PK_TABLE, 0) like ?\n"
"and name_part (PK_TABLE, 1) like ?\n"
"and name_part (PK_TABLE, 2) like ?\n"
"and name_part (FK_TABLE, 0) like ?\n"
"and name_part (FK_TABLE, 1) like ?\n"
"and name_part (FK_TABLE, 2) like ?\n"
"order by 1, 2, 3, 7, 8, 9, 13 \'\n"
", null, null,\n"
"vector(p_cat, p_sch, p_tbl, f_cat, f_sch, f_tbl), 0, mdta, dta);\n"
"}\n"
"else\n"
"{\n"
"dsn := xmla_get_dsn_name (dsn);\n"
"stmt := \'SELECT * FROM DB.DBA.SYS_FOREIGN_KEYS_VIEW WHERE PK_TABLE = \'\'\'\n"
"|| _ptbl || \'\'\' AND FK_TABLE = \'\'\' || _ftbl\n"
"|| \'\'\' AND DSN = \'\'\' || dsn || \'\'\'\';\n"
"exec (stmt, state, msg, vector (), 0, mdta, dta);\n"
"}\n"
"\n"
"xmla_make_struct (mdta, dta);\n"
"self.metadata := mdta;\n"
"return dta;\n"
"}\n";

static const char *other73 = 
"create method xmla_dbschema_primary_keys () for xmla_discover\n"
"{\n"
"declare state, msg, dta, mdta, stmt any;\n"
"declare dsn, cat, tb, col, sch any;\n"
"declare _tbl varchar;\n"
"\n"
"dsn := self.xmla_get_property (\'DataSourceInfo\', xmla_service_name ());\n"
"dsn := xmla_get_dsn_name (dsn);\n"
"cat := self.xmla_get_restriction (\'TABLE_CATALOG\', \'%\');\n"
"sch := self.xmla_get_restriction (\'TABLE_SCHEMA\', \'%\');\n"
"tb := self.xmla_get_restriction (\'TABLE_NAME\', \'%\');\n"
"\n"
"if (cat is null)\n"
"cat := \'%\';\n"
"if (sch is null)\n"
"sch := \'%\';\n"
"if (tb is null)\n"
"tb := \'%\';\n"
"\n"
"cat := trim (cat, \'\"\');\n"
"sch := trim (sch, \'\"\');\n"
"tb := trim (tb, \'\"\');\n"
"_tbl := cat || \'.\' || sch || \'.\' || tb;\n"
"\n"
"if (not xmla_not_local_dsn (dsn))\n"
"{\n"
"declare uname, passwd varchar;\n"
"uname := self.xmla_get_property (\'UserName\', null);\n"
"passwd := self.xmla_get_property (\'Password\', null);\n"
"xmla_check_user (uname, passwd);\n"
"set_user_id (uname, 1, passwd);\n"
"exec(\'select\n"
"name_part(KEY_TABLE, 0) AS TABLE_CATALOG NVARCHAR(128),\n"
"name_part(KEY_TABLE, 1) AS TABLE_SCHEMA NVARCHAR(128),\n"
"name_part(KEY_TABLE, 2) AS TABLE_NAME NVARCHAR(128),\n"
"\"COLUMN\" as COLUMN_NAME NVARCHAR(128),\n"
"NULL as COLUMN_GUID,\n"
"NULL as COLUMN_POPID INTEGER,\n"
"(KP_NTH + 1) as ORDINAL,\n"
"name_part(KEY_NAME, 2) as PK_NAME\n"
"from DB.DBA.SYS_KEYS, DB.DBA.SYS_KEY_PARTS, DB.DBA.SYS_COLS\n"
"where\n"
"__any_grants(KEY_TABLE) and\n"
"name_part(KEY_TABLE, 0) LIKE ? and\n"
"name_part(KEY_TABLE, 1) LIKE ? and\n"
"name_part(KEY_TABLE, 2) LIKE ? and\n"
"KEY_IS_MAIN = 1 and\n"
"KEY_MIGRATE_TO is null and\n"
"KP_KEY_ID = KEY_ID and\n"
"KP_NTH < KEY_DECL_PARTS and\n"
"COL_ID = KP_COL and\n"
"\"COLUMN\" <> \'\'_IDN\'\'\n"
"order by KEY_TABLE\'\n"
", null, null,\n"
"vector(cat, sch, tb), 0, mdta, dta);\n"
"}\n"
"else\n"
"{\n"
"dsn := xmla_get_dsn_name (dsn);\n"
"stmt := \'SELECT * FROM DB.DBA.SYS_PRIMARY_KEYS_VIEW WHERE PK_TABLE = \'\'\' || _tbl || \'\'\' AND DSN = \'\'\' || dsn || \'\'\'\';\n"
"exec (stmt, state, msg, vector (), 0, mdta, dta);\n"
"}\n"
"\n"
"xmla_make_struct (mdta, dta);\n"
"self.metadata := mdta;\n"
"return dta;\n"
"}\n";

static const char *other74 = 
"create method xmla_dbschema_provider_types () for xmla_discover\n"
"{\n"
"declare dta, mdta any;\n"
"declare dsn any;\n"
"declare t, m int;\n"
"\n"
"dsn := self.xmla_get_property (\'DataSourceInfo\', xmla_service_name ());\n"
"dsn := xmla_get_dsn_name (dsn);\n"
"\n"
"t := self.xmla_get_restriction (\'DATA_TYPE\', NULL);\n"
"m := self.xmla_get_restriction (\'BEST_MATCH\', NULL);\n"
"if (not xmla_not_local_dsn (dsn))\n"
"{\n"
"exec (\'select\n"
"gt.TYPE_NAME,\n"
"gt.DATA_TYPE,\n"
"gt.COLUMN_SIZE,\n"
"gt.LITERAL_PREFIX,\n"
"gt.LITERAL_SUFFIX,\n"
"gt.CREATE_PARAMS,\n"
"gt.IS_NULLABLE,\n"
"gt.CASE_SENSITIVE,\n"
"gt.SEARCHABLE,\n"
"gt.UNSIGNED_ATTRIBUTE,\n"
"gt.FIXED_PREC_SCALE,\n"
"gt.AUTO_UNIQUE_VALUE,\n"
"gt.LOCAL_TYPE_NAME,\n"
"gt.MINIMUM_SCALE,\n"
"gt.MAXIMUM_SCALE,\n"
"gt.GUID,\n"
"gt.TYPELIB,\n"
"gt.VERSION,\n"
"gt.IS_LONG,\n"
"gt.BEST_MATCH,\n"
"gt.IS_FIXEDLENGTH\n"
"from DB.DBA.oledb_get_types(t, m)\n"
"(\n"
"TYPE_NAME NVARCHAR(32),\n"
"DATA_TYPE SMALLINT,\n"
"COLUMN_SIZE INTEGER,\n"
"LITERAL_PREFIX NVARCHAR(5),\n"
"LITERAL_SUFFIX NVARCHAR(5),\n"
"CREATE_PARAMS NVARCHAR(64),\n"
"IS_NULLABLE SMALLINT,\n"
"CASE_SENSITIVE SMALLINT,\n"
"SEARCHABLE INTEGER,\n"
"UNSIGNED_ATTRIBUTE SMALLINT,\n"
"FIXED_PREC_SCALE SMALLINT,\n"
"AUTO_UNIQUE_VALUE SMALLINT,\n"
"LOCAL_TYPE_NAME NVARCHAR(32),\n"
"MINIMUM_SCALE SMALLINT,\n"
"MAXIMUM_SCALE SMALLINT,\n"
"GUID NVARCHAR,\n"
"TYPELIB NVARCHAR,\n"
"VERSION NVARCHAR(32),\n"
"IS_LONG SMALLINT,\n"
"BEST_MATCH SMALLINT,\n"
"IS_FIXEDLENGTH SMALLINT\n"
") gt\n"
"where\n"
"t = ? and m = ?\' , null, null,\n"
"vector (t, m), 0, mdta, dta);\n"
"}\n"
"else\n"
"{\n"
"dsn := xmla_get_dsn_name (dsn);\n"
"\n"
"exec (\'select TYPE_NAME, DATA_TYPE, COLUMN_SIZE, LITERAL_PREFIX, LITERAL_SUFFIX,\n"
"CREATE_PARAMS, IS_NULLABLE, CASE_SENSITIVE, SEARCHABLE, UNSIGNED_ATTRIBUTE,\n"
"FIXED_PREC_SCALE, AUTO_UNIQUE_VALUE, LOCAL_TYPE_NAME, MINIMUM_SCALE, MAXIMUM_SCALE,\n"
"GUID, TYPELIB, VERSION, IS_LONG, BEST_MATCH, IS_FIXEDLENGTH\n"
"from DB..XMLA_VDD_DBSCHEMA_PROVIDER_TYPES where tb = ? and cat = ? and dsn = ? \',\n"
"null, null, vector (t, m, dsn), 0, mdta, dta);\n"
"}\n"
"xmla_make_struct (mdta, dta);\n"
"self.metadata := mdta;\n"
"return dta;\n"
"}\n";

static const char *other75 = 
"create method xmla_dbschema_tables () for xmla_discover\n"
"{\n"
"declare dta, mdta any;\n"
"declare dsn, cat, sch, tb any;\n"
"\n"
"dsn := self.xmla_get_property (\'DataSourceInfo\', xmla_service_name ());\n"
"dsn := xmla_get_dsn_name (dsn);\n"
"cat := self.xmla_get_restriction (\'TABLE_CATALOG\', \'DB\');\n"
"sch := self.xmla_get_restriction (\'TABLE_SCHEMA\', \'%\');\n"
"tb := self.xmla_get_restriction (\'TABLE_NAME\', \'%\');\n"
"\n"
"if (cat is null)\n"
"cat := \'DB\';\n"
"if (sch is null)\n"
"sch := \'%\';\n"
"if (tb is null)\n"
"tb := \'%\';\n"
"\n"
"if (not xmla_not_local_dsn (dsn))\n"
"{\n"
"declare uname, passwd varchar;\n"
"uname := self.xmla_get_property (\'UserName\', null);\n"
"passwd := self.xmla_get_property (\'Password\', null);\n"
"xmla_check_user (uname, passwd);\n"
"set_user_id (uname, 1, passwd);\n"
"exec (\'select name_part(KEY_TABLE, 0) as TABLE_CATALOG,\n"
"name_part(KEY_TABLE, 1) as TABLE_SCHEMA,\n"
"name_part(KEY_TABLE, 2) as TABLE_NAME,\n"
"table_type(KEY_TABLE) as TABLE_TYPE,\n"
"NULL as TABLE_GUID,\n"
"NULL as DESCRIPTION NVARCHAR,\n"
"NULL as TABLE_PROPID INTEGER,\n"
"NULL as DATE_CREATED DATE,\n"
"NULL as DATE_MODIFIED DATE\n"
"from DB.DBA.SYS_KEYS where\n"
"__any_grants(KEY_TABLE) and\n"
"name_part(KEY_TABLE, 0) like ? and\n"
"name_part(KEY_TABLE, 1) like ? and\n"
"name_part(KEY_TABLE, 2) like ?\n"
"and KEY_IS_MAIN = 1 and\n"
"KEY_MIGRATE_TO is null\', null, null,\n"
"vector (cat, sch, tb), 0, mdta, dta);\n"
"}\n"
"else\n"
"{\n"
"exec (\'select TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, TABLE_TYPE, TABLE_GUID,\n"
"DESCRIPTION, TABLE_PROPID, DATE_CREATED, DATE_MODIFIED\n"
"from DB.DBA.XMLA_VDD_DBSCHEMA_TABLES where\n"
"tb = ? and cat = ? and dsn = ? \', null, null,\n"
"vector (tb, cat, dsn), 0, mdta, dta);\n"
"}\n"
"\n"
"xmla_make_struct (mdta, dta);\n"
"self.metadata := mdta;\n"
"return dta;\n"
"}\n";

static const char *other76 = 
"create method xmla_dbschema_tables_info () for xmla_discover\n"
"{\n"
"return self.xmla_dbschema_tables();\n"
"}\n";

static const char *proc146 = 
"#line 1260 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_get_schs ()\n"
"{\n"
"return vector (\n"
"vector (\'DBSCHEMA_CATALOGS\', soap_box_structure (\'CATALOG_NAME\', \'\'),\'\'),\n"
"vector (\'DBSCHEMA_TABLES\',\n"
"soap_box_structure (\'TABLE_CATALOG\', \'\', \'TABLE_SCHEMA\', \'\', \'TABLE_NAME\', \'\', \'TABLE_TYPE\', \'\')\n"
",\'\'),\n"
"vector (\'DBSCHEMA_TABLES_INFO\',\n"
"soap_box_structure (\'TABLE_CATALOG\', \'\', \'TABLE_SCHEMA\', \'\', \'TABLE_NAME\', \'\', \'TABLE_TYPE\', \'\')\n"
",\'\'),\n"
"vector (\'DBSCHEMA_COLUMNS\',\n"
"soap_box_structure (\'TABLE_CATALOG\', \'\', \'TABLE_SCHEMA\', \'\', \'TABLE_NAME\', \'\', \'TABLE_TYPE\', \'\', \'COLUMN_NAME\', \'\')\n"
",\'\'),\n"
"vector (\'DBSCHEMA_PRIMARY_KEYS\',\n"
"soap_box_structure (\'TABLE_CATALOG\', \'\', \'TABLE_SCHEMA\', \'\', \'TABLE_NAME\', \'\')\n"
",\'\'),\n"
"vector (\'DBSCHEMA_FOREIGN_KEYS\',\n"
"soap_box_structure (\'PK_TABLE_CATALOG\', \'\', \'PK_TABLE_SCHEMA\', \'\', \'PK_TABLE_NAME\', \'\',\n"
"\'FK_TABLE_CATALOG\', \'\', \'FK_TABLE_SCHEMA\', \'\', \'FK_TABLE_NAME\', \'\')\n"
",\'\'),\n"
"vector (\'DBSCHEMA_PROVIDER_TYPES\',\n"
"soap_box_structure (\'DATA_TYPE\', \'\', \'BEST_MATCH\', \'\')\n"
",\'\'),\n"
"vector (\'DISCOVER_DATASOURCES\',\n"
"soap_box_structure (\'DataSourceName\', \'\', \'URL\', \'\', \'ProviderName\', \'\', \'ProviderType\', \'\', \'AuthenticationMode\', \'\')\n"
",\'\'),\n"
"vector (\'DISCOVER_PROPERTIES\',\n"
"soap_box_structure (\'PropertyName\', \'\')\n"
",\'\'),\n"
"vector (\'DISCOVER_SCHEMA_ROWSETS\',\n"
"soap_box_structure (\'SchemaName\', \'\')\n"
",\'\'),\n"
"vector (\'DISCOVER_ENUMERATORS\',\n"
"soap_box_structure (\'EnumName\', \'\')\n"
",\'\'),\n"
"vector (\'DISCOVER_KEYWORDS\',\n"
"soap_box_structure (\'Keyword\', \'\')\n"
",\'\'),\n"
"vector (\'DISCOVER_LITERALS\',\n"
"soap_box_structure (\'LiteralName\', \'\')\n"
",\'\')\n"
");\n"
"}\n"
"--src xmla.sql:1258\n"
;

static const char *proc147 = 
"#line 1307 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_get_props (in _dsn varchar := NULL)\n"
"{\n"
"declare ses_props, _vdd_dsn_info any;\n"
"declare dbms_name, dbms_ver varchar;\n"
"\n"
"ses_props := connection_get (\'XMLA_Properties\');\n"
"if (isarray (ses_props))\n"
"return ses_props;\n"
"\n"
"dbms_name := sys_stat (\'st_dbms_name\');\n"
"dbms_ver := sys_stat (\'st_dbms_ver\');\n"
"_dsn := xmla_get_dsn_name (_dsn);\n"
"\n"
"if (not xmla_is_local_service (_dsn))\n"
"{\n"
"_vdd_dsn_info := vdd_dsn_info(_dsn);\n"
"dbms_name := get_keyword (17, _vdd_dsn_info, \'\');\n"
"dbms_ver := get_keyword (18, _vdd_dsn_info, \'\');\n"
"}\n"
"\n"
"return vector (\n"
"vector (\'AxisFormat\'	, \'\', \'string\', \'W\', 0, \'TupleFormat\'),\n"
"vector (\'BeginRange\'	, \'\', \'int\', \'W\', 0, \'-1\'),\n"
"vector (\'Catalog\'   	, \'\', \'string\', \'R/W\', 0, \'DB\'),\n"
"vector (\'Content\'   	, \'\', \'string\', \'W\', 0, \'\'),\n"
"vector (\'DataSourceInfo\', \'\', \'string\', \'R/W\', 0, \'\'),\n"
"vector (\'EndRange\'	, \'\', \'int\', \'W\', 0, \'-1\'),\n"
"vector (\'Format\'	, \'\', \'string\', \'W\', 0, \'Tabular\'),\n"
"vector (\'LocaleIdentifier\',\'\',\'int\', \'R/W\', 0, NULL),\n"
"vector (\'MDXSupport\'	, \'\', \'string\', \'R\', 0, \'None\'),\n"
"vector (\'Password\'	, \'\', \'string\', \'W\', 0, \'\'),\n"
"vector (\'ProviderName\'	, \'\', \'string\', \'R\', 0, dbms_name),\n"
"vector (\'ProviderVersion\',\'\', \'string\', \'R\', 0, dbms_ver),\n"
"vector (\'StateSupport\'	, \'\', \'string\', \'R\', 0, \'Sessions\'),\n"
"vector (\'Timeout\'	, \'\', \'int\', \'R/W\', 0, NULL),\n"
"vector (\'BLOBLimit\'	, \'\', \'int\', \'R/W\', 0, NULL),\n"
"vector (\'UserName\'	, \'\', \'string\', \'R/W\', 0, \'\')\n"
");\n"
"}\n"
"--src xmla.sql:1305\n"
;

static const char *proc148 = 
"#line 1349 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_get_dsn_name (in _dsn varchar)\n"
"{\n"
"return replace (_dsn, \'DSN=\', \'\');\n"
"return _dsn;\n"
"}\n"
"--src xmla.sql:1347\n"
;

static const char *proc149 = 
"#line 1357 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_is_local_service (in _dsn varchar)\n"
"{\n"
"if (_dsn <> xmla_service_name())\n"
"return 0;\n"
"return 1;\n"
"}\n"
"--src xmla.sql:1355\n"
;

static const char *proc150 = 
"#line 1366 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_set_props (in properties any)\n"
"{\n"
"declare prop_list, def_prop any;\n"
"declare i, l int;\n"
"def_prop := xmla_get_props ();\n"
"l := length (def_prop); i := 0;\n"
"while (i < l)\n"
"{\n"
"declare elm, val any;\n"
"elm := def_prop[i];\n"
"if (elm[3] in (\'R/W\', \'W\'))\n"
"{\n"
"val := xmla_get_property (properties, elm[0], elm[5]);\n"
"aset (elm, 5, val);\n"
"}\n"
"aset (def_prop, i, elm);\n"
"i := i + 1;\n"
"}\n"
"return def_prop;\n"
"}\n"
"--src xmla.sql:1364\n"
;

static const char *proc151 = 
"#line 1389 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_get_enums ()\n"
"{\n"
"return vector (\n"
"vector(\'ProviderType\',\'\',\'string\',\'TDP\',\'\',1),\n"
"\n"
"\n"
"\n"
"vector(\'AuthenticationMode\',\'\',\'string\',\'Unauthenticated\',\'\',5),\n"
"vector(\'AuthenticationMode\',\'\',\'string\',\'Authenticated\',\'\',6),\n"
"\n"
"vector(\'PropertyAccessType\',\'\',\'string\',\'Read\',\'\',8),\n"
"vector(\'PropertyAccessType\',\'\',\'string\',\'Write\',\'\',9),\n"
"vector(\'PropertyAccessType\',\'\',\'string\',\'ReadWrite\',\'\',10),\n"
"vector(\'StateSupport\',\'\',\'string\',\'None\',\'\',11),\n"
"\n"
"\n"
"\n"
"\n"
"vector(\'ResultsetFormat\',\'\',\'string\',\'Tabular\',\'\',16),\n"
"\n"
"vector(\'ResultsetAxisFormat\',\'\',\'string\',\'TupleFormat\',\'\',18),\n"
"\n"
"\n"
"vector(\'ResultsetContents\',\'\',\'string\',\'None\',\'\',21),\n"
"vector(\'ResultsetContents\',\'\',\'string\',\'Schema\',\'\',22),\n"
"vector(\'ResultsetContents\',\'\',\'string\',\'Data\',\'\',23),\n"
"vector(\'ResultsetContents\',\'\',\'string\',\'SchemaData\',\'\',24),\n"
"vector(\'MDXSupportLevel\',\'\',\'string\',\'None\',\'\',25)\n"
");\n"
"}\n"
"--src xmla.sql:1387\n"
;

static const char *proc152 = 
"#line 1422 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_get_literals ()\n"
"{\n"
"return vector (\n"
"vector (\'DBLITERAL_CATALOG_NAME\', \'\', \'.\', \'0123456789 \', 100),\n"
"vector (\'DBLITERAL_CATALOG_SEPARATOR\', \'.\', \'\', \'\', 0),\n"
"vector (\'DBLITERAL_COLUMN_ALIAS\', \'\', \'\\\'\"[]\', \'0123456789 \', 100),\n"
"vector (\'DBLITERAL_COLUMN_NAME\', \'\', \'.\', \'0123456789 \', 100),\n"
"vector (\'DBLITERAL_CORRELATION_NAME\', \'\', \'\\\'\"[]\', \'0123456789 \', 100),\n"
"vector (\'DBLITERAL_PROCEDURE_NAME\', \'\', \'.\', \'0123456789 \', 100),\n"
"vector (\'DBLITERAL_TABLE_NAME\', \'\', \'.\', \'0123456789 \', 100),\n"
"vector (\'DBLITERAL_TEXT_COMMAND\', \'\', \'\', \'\', 0),\n"
"vector (\'DBLITERAL_USER_NAME\', \'\', \'\', \'\', 0),\n"
"vector (\'DBLITERAL_QUOTE\', \'\"\', \'\', \'\', 0),\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"vector (\'DBLITERAL_PROPERTY_NAME\', \'\', \'.\', \'0123456789 \', 100),\n"
"vector (\'DBLITERAL_QUOTE_SUFFIX\', \'\"\', \'\', \'\', 0)\n"
");\n"
"}\n"
"--src xmla.sql:1420\n"
;

static const char *proc153 = 
"#line 1448 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_service_name ()\n"
"{\n"
"return \'Local_Instance\';\n"
"}\n"
"--src xmla.sql:1446\n"
;

static const char *proc154 = 
"#line 1456 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_get_kwds ()\n"
"{\n"
"return vector (\n"
"\'__SOAP_DOC\', \'__SOAP_DOCW\', \'__SOAP_HEADER\', \'__SOAP_HTTP\', \'__SOAP_NAME\', \'__SOAP_TYPE\',\n"
"\'__SOAP_XML_TYPE\', \'__SOAP_FAULT\', \'__SOAP_DIME_ENC\', \'__SOAP_MIME_ENC\', \'__SOAP_OPTIONS\',\n"
"\'ADA\', \'ADD\', \'ADMIN\', \'AFTER\', \'AGGREGATE\', \'ALL\', \'ALTER\', \'AND\', \'ANY\', \'ARE\', \'AS\',\n"
"\'ASC\', \'ATTACH\', \'ATTRIBUTE\', \'AUTHORIZATION\', \'BACKUP\', \'BEFORE\', \'BEGIN\', \'BEST\',\n"
"\'BETWEEN\', \'BINARY\', \'BY\', \'C\', \'CALL\', \'CALLED\', \'CASCADE\', \'CASE\', \'CAST\', \'CHAR\',\n"
"\'CHARACTER\', \'CHECK\', \'CHECKED\', \'CHECKPOINT\', \'CLOSE\', \'CLUSTERED\', \'CLR\', \'COALESCE\',\n"
"\'COBOL\', \'COLLATE\', \'COLUMN\', \'COMMIT\', \'CONSTRAINT\', \'CONSTRUCTOR\', \'CONTAINS\', \'CONTINUE\',\n"
"\'CONVERT\', \'CORRESPONDING\', \'CREATE\', \'CROSS\', \'CURRENT\', \'CURRENT_DATE\', \'CURRENT_TIME\',\n"
"\'CURRENT_TIMESTAMP\', \'CURSOR\', \'DATA\', \'DATE\', \'DATETIME\', \'DECIMAL\', \'DECLARE\', \'DEFAULT\',\n"
"\'DELETE\', \'DESC\', \'DETERMINISTIC\', \'DISCONNECT\', \'DISTINCT\', \'DO\', \'DOUBLE\', \'DROP\', \'DTD\',\n"
"\'DYNAMIC\', \'ELSE\', \'ELSEIF\', \'ENCODING\', \'END\', \'ESCAPE\', \'EXCEPT\', \'EXCLUSIVE\', \'EXECUTE\',\n"
"\'EXISTS\', \'EXTERNAL\', \'EXTRACT\', \'EXIT\', \'FETCH\', \'FINAL\', \'FLOAT\', \'FOR\', \'FOREIGN\',\n"
"\'FORTRAN\', \'FOUND\', \'FROM\', \'FULL\', \'FUNCTION\', \'GENERAL\', \'GENERATED\', \'GO\', \'GOTO\',\n"
"\'GRANT\', \'GROUP\', \'HANDLER\', \'HAVING\', \'HASH\', \'IDENTITY\', \'IDENTIFIED\', \'IF\', \'IN\',\n"
"\'INCREMENTAL\', \'INDEX\', \'INDICATOR\', \'INNER\', \'INOUT\', \'INPUT\', \'INSERT\', \'INSTANCE\',\n"
"\'INSTEAD\', \'INT\', \'INTEGER\', \'INTERSECT\', \'INTERNAL\', \'INTERVAL\', \'INTO\', \'IS\',\n"
"\'JAVA\', \'JOIN\', \'KEY\', \'KEYSET\', \'LANGUAGE\', \'LEFT\', \'LIKE\', \'LOCATOR\', \'LOG\', \'LONG\',\n"
"\'LOOP\', \'METHOD\', \'MODIFY\', \'MODIFIES\', \'MODULE\', \'MUMPS\', \'NAME\', \'NATURAL\', \'NCHAR\',\n"
"\'NEW\', \'NONINCREMENTAL\', \'NOT\', \'NO\', \'NULL\', \'NULLIF\', \'NUMERIC\', \'NVARCHAR\', \'OBJECT_ID\',\n"
"\'OF\', \'OFF\', \'OLD\', \'ON\', \'OPEN\', \'OPTION\', \'OR\', \'ORDER\', \'OUT\', \'OUTER\', \'OVERRIDING\',\n"
"\'PASCAL\', \'PASSWORD\', \'PERCENT\', \'PERSISTENT\', \'PLI\', \'PRECISION\', \'PREFETCH\', \'PRIMARY\',\n"
"\'PRIVILEGES\', \'PROCEDURE\', \'PUBLIC\', \'PURGE\', \'READS\', \'REAL\', \'REF\', \'REFERENCES\', \'REFERENCING\',\n"
"\'REMOTE\', \'RENAME\', \'REPLACING\', \'REPLICATION\', \'RESIGNAL\', \'RESTRICT\', \'RESULT\', \'RETURN\',\n"
"\'RETURNS\', \'REVOKE\', \'RIGHT\', \'ROLLBACK\', \'ROLE\', \'SCHEMA\', \'SELECT\', \'SELF\', \'SET\',\n"
"\'SHUTDOWN\', \'SMALLINT\', \'SNAPSHOT\', \'SOFT\', \'SOME\', \'SOURCE\', \'SPECIFIC\', \'SQL\',\n"
"\'SQLCODE\', \'SQLEXCEPTION\', \'SQLSTATE\', \'SQLWARNING\', \'STATIC\', \'STYLE\', \'SYNC\', \'SYSTEM\',\n"
"\'TABLE\', \'TEMPORARY\', \'TEXT\', \'THEN\', \'TIES\', \'TIME\', \'TIMESTAMP\', \'TO\', \'TOP\', \'TYPE\',\n"
"\'TRIGGER\', \'UNDER\',\n"
"\'UNION\', \'UNIQUE\', \'UPDATE\', \'USE\', \'USER\', \'USING\', \'VALUE\', \'VALUES\',\n"
"\'VARBINARY\', \'VARCHAR\', \'VARIABLE\', \'VIEW\', \'WHEN\', \'WHENEVER\', \'WHERE\', \'WHILE\', \'WITH\', \'WORK\', \'XML\', \'XPATH\'\n"
");\n"
"}\n"
"--src xmla.sql:1454\n"
;

static const char *proc155 = 
"#line 1495 \"[executable]/xmla.sql\"\n"
"create procedure DB.DBA.xmla_vdd_dbschema_tables_rpoc (in tb varchar, in cat varchar, in dsn varchar)\n"
"{\n"
"declare _all, temp any;\n"
"declare TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, TABLE_TYPE, TABLE_GUID varchar;\n"
"declare DESCRIPTION nvarchar;\n"
"declare TABLE_PROPID, idx int;\n"
"declare DATE_CREATED, DATE_MODIFIED date;\n"
"\n"
"_all := sql_tables (dsn, NULL, NULL, NULL, \'TABLE\');\n"
"temp := sql_tables (dsn, NULL, NULL, NULL, \'VIEW\');\n"
"_all := vector_concat (_all, temp);\n"
"temp := sql_tables (dsn, NULL, NULL, NULL, \'SYSTEM TABLE\');\n"
"_all := vector_concat (_all, temp);\n"
"\n"
"result_names (TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, TABLE_TYPE, TABLE_GUID, DESCRIPTION,\n"
"TABLE_PROPID, DATE_CREATED, DATE_MODIFIED);\n"
"\n"
"for (idx := 0; idx < length (_all); idx := idx + 1)\n"
"{\n"
"declare _line any;\n"
"_line := _all[idx];\n"
"result (_line[0], _line[1], _line[2], \'TABLE\', NULL, NULL, NULL, NULL, NULL);\n"
"}\n"
"\n"
"}\n"
"--src xmla.sql:1493\n"
;

static const char *proc156 = 
"#line 1522 \"[executable]/xmla.sql\"\n"
"create procedure DB.DBA.xmla_vdd_dbschema_columns_rpoc (in tb varchar, in cat varchar, in col varchar, in dsn varchar)\n"
"{\n"
"declare _all any;\n"
"declare TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, COLUMN_GUID, TYPE_GUID varchar;\n"
"declare COLUMN_DEFAULT, CHARACTER_SET_CATALOG, CHARACTER_SET_SCHEMA, CHARACTER_SET_NAME, COLLATION_CATALOG nvarchar;\n"
"declare idx, COLUMN_PROPID, ORDINAL_POSITION, COLUMN_HASDEFAULT, COLUMN_FLAGS, IS_NULLABLE, DATA_TYPE int;\n"
"declare CHARACTER_MAXIMUM_LENGTH, CHARACTER_OCTET_LENGTH, NUMERIC_PRECISION, NUMERIC_SCALE, DATETIME_PRECISION int;\n"
"declare COLLATION_SCHEMA, COLLATION_NAME, DOMAIN_CATALOG, DOMAIN_SCHEMA, DOMAIN_NAME, DESCRIPTION nvarchar;\n"
"\n"
"\n"
"_all := DB.DBA.sql_columns (dsn, tb, NULL, cat, NULL);\n"
"\n"
"if (_all = vector ())\n"
"_all := DB.DBA.sql_columns (dsn, NULL, NULL, cat, NULL);\n"
"\n"
"result_names (TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, COLUMN_GUID, COLUMN_PROPID,\n"
"ORDINAL_POSITION, COLUMN_HASDEFAULT, COLUMN_DEFAULT, COLUMN_FLAGS, IS_NULLABLE,\n"
"DATA_TYPE, TYPE_GUID, CHARACTER_MAXIMUM_LENGTH, CHARACTER_OCTET_LENGTH, NUMERIC_PRECISION,\n"
"NUMERIC_SCALE, DATETIME_PRECISION, CHARACTER_SET_CATALOG, CHARACTER_SET_SCHEMA,\n"
"CHARACTER_SET_NAME, COLLATION_CATALOG, COLLATION_SCHEMA, COLLATION_NAME, DOMAIN_CATALOG,\n"
"DOMAIN_SCHEMA, DOMAIN_NAME, DESCRIPTION);\n"
"\n"
"for (idx := 0; idx < length (_all); idx := idx + 1)\n"
"{\n"
"declare _line any;\n"
"declare _is_null any;\n"
"_line := _all[idx];\n"
"_is_null := 0;\n"
"if (_line[17] = \'YES\') _is_null := 1;\n"
"result (_line[0], _line[1], _line[2], _line[3], NULL, NULL, _line[16], NULL, cast (_line[12] as nvarchar), NULL, _is_null,\n"
"_line[4], NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,  NULL, NULL,\n"
"cast (_line[11] as nvarchar));\n"
"}\n"
"}\n"
"--src xmla.sql:1520\n"
;

static const char *view0 = 
"create procedure view XMLA_VDD_DBSCHEMA_COLUMNS as DB.DBA.xmla_vdd_dbschema_columns_rpoc (cat, tb, col, dsn)\n"
"(TABLE_CATALOG varchar, TABLE_SCHEMA varchar, TABLE_NAME varchar, COLUMN_NAME varchar, COLUMN_GUID varchar,\n"
"COLUMN_PROPID int, ORDINAL_POSITION int, COLUMN_HASDEFAULT int, COLUMN_DEFAULT nvarchar, COLUMN_FLAGS int,\n"
"IS_NULLABLE int, DATA_TYPE int, TYPE_GUID varchar, CHARACTER_MAXIMUM_LENGTH int, CHARACTER_OCTET_LENGTH int,\n"
"NUMERIC_PRECISION int, NUMERIC_SCALE int, DATETIME_PRECISION int, CHARACTER_SET_CATALOG NVARCHAR(1),\n"
"CHARACTER_SET_SCHEMA NVARCHAR(1), CHARACTER_SET_NAME NVARCHAR(1), COLLATION_CATALOG NVARCHAR(1),\n"
"COLLATION_SCHEMA NVARCHAR(1), COLLATION_NAME NVARCHAR(1), DOMAIN_CATALOG NVARCHAR(1), DOMAIN_SCHEMA NVARCHAR(1),\n"
"DOMAIN_NAME NVARCHAR(1), DESCRIPTION NVARCHAR(1))\n";

static const char *view1 = 
"create procedure view XMLA_VDD_DBSCHEMA_TABLES as DB.DBA.xmla_vdd_dbschema_tables_rpoc (tb, cat, dsn)\n"
"(TABLE_CATALOG varchar, TABLE_SCHEMA varchar, TABLE_NAME varchar, TABLE_TYPE varchar, TABLE_GUID varchar,\n"
"DESCRIPTION nvarchar, TABLE_PROPID int, DATE_CREATED date, DATE_MODIFIED date)\n";

static const char *view2 = 
"create procedure view XMLA_VDD_DBSCHEMA_PROVIDER_TYPES as DB.DBA.xmla_vdd_dbschema_provider_types_rpoc (tb, cat, dsn)\n"
"(TYPE_NAME varchar, DATA_TYPE int, COLUMN_SIZE int, LITERAL_PREFIX varchar, LITERAL_SUFFIX varchar,\n"
"CREATE_PARAMS varchar, IS_NULLABLE int, CASE_SENSITIVE int, SEARCHABLE int, UNSIGNED_ATTRIBUTE int,\n"
"FIXED_PREC_SCALE int, AUTO_UNIQUE_VALUE int, LOCAL_TYPE_NAME varchar, MINIMUM_SCALE int, MAXIMUM_SCALE int,\n"
"GUID varchar, TYPELIB varchar, VERSION varchar, IS_LONG int, BEST_MATCH int, IS_FIXEDLENGTH int)\n";

static const char *proc157 = 
"#line 1586 \"[executable]/xmla.sql\"\n"
"create procedure xmla_vdd_dbschema_provider_types_rpoc (in tb int, in cat int, in dsn varchar)\n"
"{\n"
"declare _all any;\n"
"declare idx int;\n"
"\n"
"declare TYPE_NAME, LITERAL_PREFIX, LITERAL_SUFFIX, CREATE_PARAMS, GUID, TYPELIB, VERSION, LOCAL_TYPE_NAME varchar;\n"
"declare IS_NULLABLE, CASE_SENSITIVE, SEARCHABLE, UNSIGNED_ATTRIBUTE int;\n"
"declare FIXED_PREC_SCALE, AUTO_UNIQUE_VALUE, MINIMUM_SCALE, MAXIMUM_SCALE int;\n"
"declare IS_LONG, BEST_MATCH, IS_FIXEDLENGTH int;\n"
"declare DATA_TYPE, COLUMN_SIZE int;\n"
"\n"
"\n"
"_all := vdd_dsn_info(dsn)[1];\n"
"result_names (TYPE_NAME, DATA_TYPE, COLUMN_SIZE, LITERAL_PREFIX, LITERAL_SUFFIX,\n"
"CREATE_PARAMS, IS_NULLABLE, CASE_SENSITIVE, SEARCHABLE, UNSIGNED_ATTRIBUTE,\n"
"FIXED_PREC_SCALE, AUTO_UNIQUE_VALUE, LOCAL_TYPE_NAME, MINIMUM_SCALE, MAXIMUM_SCALE,\n"
"GUID, TYPELIB, VERSION, IS_LONG, BEST_MATCH, IS_FIXEDLENGTH);\n"
"\n"
"for (idx := 0; idx < length (_all); idx := idx + 1)\n"
"{\n"
"declare _line any;\n"
"\n"
"_line := _all[idx];\n"
"result (_line[0], _line[1], _line[2], _line[3], _line[4], _line[5], _line[6], _line[7],\n"
"_line[8], _line[9], _line[10], _line[11], _line[12], _line[13], _line[14], NULL,\n"
"NULL, NULL, NULL, NULL, NULL);\n"
"}\n"
"}\n"
"--src xmla.sql:1584\n"
;

static const char *proc158 = 
"#line 1617 \"[executable]/xmla.sql\"\n"
"create procedure mxla_fk_pk_check (in dsn varchar, inout stmt varchar, inout mdta any, inout dta any)\n"
"{\n"
"declare state, msg any;\n"
"declare _new any;\n"
"\n"
"_new := split_and_decode (stmt, 0, \'\\0\\0\'\'\');\n"
"\n"
"if (strstr (stmt, \'DB.DBA.SYS_FOREIGN_KEYS\'))\n"
"{\n"
"stmt := \'SELECT * FROM DB.DBA.SYS_FOREIGN_KEYS_VIEW WHERE PK_TABLE = \'\'\' || _new[1] || \'\'\' AND FK_TABLE = \'\'\' || _new[3]\n"
"|| \'\'\' AND DSN = \'\'\' || dsn || \'\'\'\';\n"
"}\n"
"\n"
"if (strstr (stmt, \'XMLA_VIRTUOSO_DUMMY_PK\'))\n"
"{\n"
"stmt := \'SELECT * FROM DB.DBA.SYS_PRIMARY_KEYS_VIEW WHERE PK_TABLE = \'\'\' || _new[1] || \'\'\' AND DSN = \'\'\' || dsn || \'\'\'\';\n"
"}\n"
"\n"
"exec (stmt, state, msg, vector (), 0, mdta, dta);\n"
"}\n"
"--src xmla.sql:1615\n"
;

static const char *proc159 = 
"#line 1640 \"[executable]/xmla.sql\"\n"
"create procedure mxla_fk_pk_check_local (inout stmt varchar, inout mdta any, inout dta any)\n"
"{\n"
"declare _new, l_name, _schema, _catalog, _name, idx, _line any;\n"
"\n"
"if (strstr (stmt, \'XMLA_VIRTUOSO_DUMMY_PK\'))\n"
"{\n"
"_new := split_and_decode (stmt, 0, \'\\0\\0\'\'\');\n"
"_new := _new[1];\n"
"\n"
"_catalog := name_part (_new, 0);\n"
"_schema := name_part (_new, 1);\n"
"_name := name_part (_new, 2);\n"
"_catalog := trim (_catalog, \'\"\');\n"
"_schema := trim (_schema, \'\"\');\n"
"_name := trim (_name, \'\"\');\n"
"stmt := sprintf (\'SELECT COLUMN_NAME FROM %s.INFORMATION_SCHEMA.TABLE_CONSTRAINTS LEFT JOIN %s.INFORMATION_SCHEMA.KEY_COLUMN_USAGE ON %s.INFORMATION_SCHEMA.TABLE_CONSTRAINTS.CONSTRAINT_NAME = %s.INFORMATION_SCHEMA.KEY_COLUMN_USAGE.CONSTRAINT_NAME WHERE  CONSTRAINT_TYPE = \'\'PRIMARY KEY\'\' AND %s.INFORMATION_SCHEMA.TABLE_CONSTRAINTS.TABLE_NAME=\'\'%s\'\' AND %s.INFORMATION_SCHEMA.TABLE_CONSTRAINTS.TABLE_SCHEMA=\'\'%s\'\' AND %s.INFORMATION_SCHEMA.TABLE_CONSTRAINTS.CONSTRAINT_SCHEMA=\'\'%s\'\' AND %s.INFORMATION_SCHEMA.KEY_COLUMN_USAGE.TABLE_SCHEMA=\'\'%s\'\' AND %s.INFORMATION_SCHEMA.KEY_COLUMN_USAGE.CONSTRAINT_SCHEMA=\'\'%s\'\'\', _catalog, _catalog, _catalog, _catalog, _catalog, _name, _catalog, _schema, _catalog, _schema, _catalog, _schema, _catalog, _schema);\n"
"}\n"
"\n"
"if (strstr (stmt, \'FROM DB.DBA.SYS_FOREIGN_KEYS\'))\n"
"{\n"
"declare _dsn, r_name, fk_tables any;\n"
"declare state, msg any;\n"
"\n"
"_new := split_and_decode (stmt, 0, \'\\0\\0\'\'\');\n"
"_new := _new[1];\n"
"_new := replace (_new, \'\"\', \'\');\n"
"\n"
"if (exists (select 1 from DB.DBA.SYS_REMOTE_TABLE where RT_NAME = _new))\n"
"select RT_DSN, RT_REMOTE_NAME into _dsn, r_name  from DB.DBA.SYS_REMOTE_TABLE where RT_NAME = _new;\n"
"else\n"
"{\n"
"stmt := replace (stmt, \'\"\', \'\');\n"
"return;\n"
"}\n"
"\n"
"stmt := \'SELECT * FROM DB.DBA.SYS_FOREIGN_KEYS_VIEW WHERE PK_TABLE = \'\'\' || r_name || \'\'\' AND FK_TABLE = \'\'\' || _new\n"
"|| \'\'\' AND DSN = \'\'\' || _dsn || \'\'\'\';\n"
"\n"
"exec (stmt, state, msg, vector (), 0, mdta, dta);\n"
"\n"
"for (idx := 0; idx < length (dta); idx := idx + 1)\n"
"{\n"
"_line := dta[idx];\n"
"\n"
"if (exists (select 1 from DB.DBA.SYS_REMOTE_TABLE where _line[0] like \'%\' || RT_REMOTE_NAME))\n"
"{\n"
"select RT_NAME into l_name  from DB.DBA.SYS_REMOTE_TABLE where _line[0] like \'%\' || RT_REMOTE_NAME;\n"
"\n"
"aset (_line, 2, _new);\n"
"aset (_line, 0, l_name);\n"
"}\n"
"aset (dta, idx, _line);\n"
"}\n"
"\n"
"}\n"
"}\n"
"--src xmla.sql:1638\n"
;

static const char *view3 = 
"create procedure view DB.DBA.SYS_FOREIGN_KEYS_VIEW as DB.DBA.\"XMLA_GET_FK\" (PK_TABLE, FK_TABLE, DSN)\n"
"(PK_TABLE_SCHEMA VARCHAR,\n"
"PK_TABLE_NAME VARCHAR,\n"
"PK_COLUMN_NAME VARCHAR,\n"
"FK_TABLE_SCHEMA VARCHAR,\n"
"FK_TABLE_NAME VARCHAR,\n"
"FK_COLUMN_NAME VARCHAR,\n"
"KEY_SEQ SMALLINT,\n"
"UPDATE_RULE SMALLINT,\n"
"DELETE_RULE SMALLINT,\n"
"FK_NAME VARCHAR)\n";

static const char *view4 = 
"create procedure view DB.DBA.SYS_PRIMARY_KEYS_VIEW as DB.DBA.\"XMLA_GET_PK\" (PK_TABLE, DSN)\n"
"(COLUMN_NAME VARCHAR)\n";

static const char *proc160 = 
"#line 1721 \"[executable]/xmla.sql\"\n"
"create procedure DB.DBA.\"XMLA_GET_PK\" (in _pk_table varchar, in dsn varchar)\n"
"{\n"
"declare COLUMN_NAME VARCHAR;\n"
"declare pk_tables, _pk_tables, idx any;\n"
"\n"
"declare exit handler for sqlstate \'VD052\'\n"
"{\n"
"return;\n"
"};\n"
"\n"
"result_names (COLUMN_NAME);\n"
"\n"
"pk_tables := DB.DBA.sql_primary_keys (dsn, name_part (_pk_table, 0, null),\n"
"name_part (_pk_table, 1, null),\n"
"name_part (_pk_table, 2, null));\n"
"\n"
"for (idx := 0; idx < length (pk_tables); idx := idx + 1)\n"
"{\n"
"_pk_tables := pk_tables [idx];\n"
"\n"
"result (_pk_tables[3]);\n"
"}\n"
"}\n"
"--src xmla.sql:1719\n"
;

static const char *proc161 = 
"#line 1746 \"[executable]/xmla.sql\"\n"
"create procedure DB.DBA.\"XMLA_GET_FK\" (in _pk_table varchar, in _fk_table varchar, in dsn varchar)\n"
"{\n"
"declare PK_TABLE_SCHEMA VARCHAR;\n"
"declare PK_TABLE_NAME VARCHAR;\n"
"declare PK_COLUMN_NAME VARCHAR;\n"
"declare FK_TABLE_SCHEMA VARCHAR;\n"
"declare FK_TABLE_NAME VARCHAR;\n"
"declare FK_COLUMN_NAME VARCHAR;\n"
"declare KEY_SEQ SMALLINT;\n"
"declare UPDATE_RULE SMALLINT;\n"
"declare DELETE_RULE SMALLINT;\n"
"declare FK_NAME VARCHAR;\n"
"\n"
"declare fk_tables, _fk_tables, idx, _n1, _n2, _n3, _dsn any;\n"
"\n"
"declare exit handler for sqlstate \'*VD052\'\n"
"{\n"
"fk_tables := sql_foreign_keys (dsn, NULL, NULL, NULL, name_part (_pk_table, 0, null),\n"
"name_part (_pk_table, 1, null),\n"
"name_part (_pk_table, 2, null));\n"
"for (idx := 0; idx < length (fk_tables); idx := idx + 1)\n"
"{\n"
"_fk_tables := fk_tables [idx];\n"
"result (_fk_tables [0] || \'.\' || _fk_tables[1] || \'.\' || _fk_tables [2], _fk_tables[3], _pk_table, _fk_tables[7],\n"
"_fk_tables[8], _fk_tables[9], _fk_tables[10], _fk_tables[11], _fk_tables[12]);\n"
"}\n"
"return;\n"
"};\n"
"\n"
"declare exit handler for sqlstate \'VD052\'\n"
"{\n"
"return;\n"
"};\n"
"\n"
"result_names (PK_TABLE_SCHEMA, PK_TABLE_NAME, PK_COLUMN_NAME, FK_TABLE_SCHEMA, FK_TABLE_NAME, FK_COLUMN_NAME,\n"
"KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME);\n"
"\n"
"_n1 := name_part (_pk_table, 0, null);\n"
"_n2 := name_part (_pk_table, 1, null);\n"
"_n3 := name_part (_pk_table, 2, null);\n"
"_dsn := dsn;\n"
"fk_tables := vector ();\n"
"\n"
"for (select TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, DSN as LOC_DSN from DB.DBA.XMLA_VDD_DBSCHEMA_TABLES\n"
"where tb = _n3 and cat = _n1 and dsn = _dsn) do\n"
"{\n"
"fk_tables := vector_concat (fk_tables, sql_foreign_keys\n"
"(_dsn, NULL, NULL, NULL, TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME));\n"
"}\n"
"\n"
"for (idx := 0; idx < length (fk_tables); idx := idx + 1)\n"
"{\n"
"_fk_tables := fk_tables [idx];\n"
"if (_pk_table <> _fk_table)\n"
"result (name_part (_fk_table, 1, null), _fk_tables[2], _fk_tables[3],\n"
"name_part (_fk_table, 1, null), _fk_tables[6], _fk_tables[7],\n"
"_fk_tables[8], _fk_tables[9], _fk_tables[10], _fk_tables[11]);\n"
"else\n"
"result (_fk_tables[1], _fk_tables[2], _fk_tables[3],\n"
"_fk_tables[5], _fk_tables[6], _fk_tables[7],\n"
"_fk_tables[8], _fk_tables[9], _fk_tables[10], _fk_tables[11]);\n"
"}\n"
"}\n"
"--src xmla.sql:1744\n"
;

static const char *proc162 = 
"#line 1811 \"[executable]/xmla.sql\"\n"
"create procedure XMLA_USER_INIT ()\n"
"{\n"
"if (exists (select 1 from \"DB\".\"DBA\".\"SYS_USERS\" where U_NAME = \'XMLA\'))\n"
"return;\n"
"DB.DBA.USER_CREATE (\'XMLA\', uuid(), vector (\'DISABLED\', 1, \'LOGIN_QUALIFIER\', \'XMLA\'));\n"
"}\n"
"--src xmla.sql:1809\n"
;

static const char *other77 = 
"XMLA_USER_INIT ()\n";
static const char *other78 = 
"DB.DBA.VHOST_REMOVE (lpath=>\'/XMLA\')\n";
static const char *other79 = 
"DB.DBA.VHOST_DEFINE (lpath=>\'/XMLA\', ppath=>\'/SOAP/\', soap_user=>\'XMLA\',\n"
"soap_opts => vector (\'ServiceName\', \'XMLAnalysis\', \'elementFormDefault\', \'qualified\'))\n";
static const char *other80 = 
"grant execute on DB..\"Discover\" to \"XMLA\"\n";
static const char *other81 = 
"grant execute on DB..\"Execute\" to \"XMLA\"\n";
static const char *other82 = 
"grant execute on DB.DBA.\"xmla_vdd_dbschema_columns_rpoc\" to \"XMLA\"\n";
static const char *other83 = 
"grant execute on DB.DBA.\"XMLA_VDD_DBSCHEMA_COLUMNS\" to \"XMLA\"\n";
static const char *other84 = 
"grant all privileges on DB.DBA.\"XMLA_VDD_DBSCHEMA_COLUMNS\" to \"XMLA\"\n";
static const char *other85 = 
"grant execute on DB.DBA.\"xmla_vdd_dbschema_tables_rpoc\" to \"XMLA\"\n";
static const char *other86 = 
"grant execute on DB.DBA.\"XMLA_VDD_DBSCHEMA_TABLES\" to \"XMLA\"\n";
static const char *other87 = 
"grant all privileges on DB.DBA.\"XMLA_VDD_DBSCHEMA_TABLES\" to \"XMLA\"\n";
static const char *other88 = 
"grant all privileges on DB.DBA.\"XMLA_VDD_DBSCHEMA_PROVIDER_TYPES\" to \"XMLA\"\n";
static const char *other89 = 
"grant execute on DB.DBA.\"xmla_vdd_dbschema_provider_types_rpoc\" to \"XMLA\"\n";
static const char *other90 = 
"grant execute on DB.DBA.\"XMLA_GET_FK\" to \"XMLA\"\n";
static const char *other91 = 
"grant execute on DB.DBA.\"XMLA_GET_PK\" to \"XMLA\"\n";
static const char *other92 = 
"grant all privileges on DB.DBA.\"SYS_FOREIGN_KEYS_VIEW\" to \"XMLA\"\n";
static const char *other93 = 
"grant all privileges on DB.DBA.\"SYS_PRIMARY_KEYS_VIEW\" to \"XMLA\"\n";
static const char *proc163 = 
"#line 1872 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_cursor_stmt_change (in _props any, inout _stmt varchar)\n"
"{\n"
"declare _direction, new_stmpt, _left_str, _left_str_u varchar;\n"
"declare _skip, _n_rows, _return_bookmark, _bookmark_from, _return_row_count integer;\n"
"\n"
"_left_str := \'\';\n"
"\n"
"_direction := xmla_get_property (_props, \'direction\', \'forward\');\n"
"_bookmark_from := xmla_get_property (_props, \'bookmark-from\', NULL);\n"
"_skip := xmla_get_property (_props, \'skip\', 0);\n"
"_skip := xmla_make_skip (_bookmark_from, _skip, 1);\n"
"\n"
"_n_rows := xmla_get_property (_props, \'n-rows\', null);\n"
"_return_bookmark := xmla_get_property (_props, \'return-bookmark\', 0);\n"
"_return_row_count := xmla_get_property (_props, \'retrieve-row-count\', 0);\n"
"\n"
"new_stmpt := \'select \';\n"
"\n"
"if (_direction = \'forward\')\n"
"{\n"
"if (_skip)\n"
"{\n"
"_skip := cast (_skip as varchar);\n"
"if (_n_rows is null)\n"
"new_stmpt := new_stmpt || \'top \' || _skip || \' \';\n"
"else\n"
"new_stmpt := new_stmpt || \'top \' || _skip || \', \' || cast (_n_rows as varchar) || \' \';\n"
"}\n"
"else if (_n_rows > 0)\n"
"new_stmpt := new_stmpt || \'top \' || cast (_n_rows as varchar) || \' \';\n"
"}\n"
"\n"
"if (_return_bookmark)\n"
"new_stmpt := new_stmpt || \'\'\'_dummy_\'\' AS BOOKMARK, \';\n"
"\n"
"if (_return_row_count)\n"
"new_stmpt := new_stmpt || \'1 AS ROWCOUNT, \';\n"
"\n"
"_stmt := trim (_stmt);\n"
"\n"
"if (length (_stmt) > 6)\n"
"_left_str := \"LEFT\" (_stmt, 6);\n"
"\n"
"_left_str_u := ucase (_left_str, 6);\n"
"\n"
"if (_left_str_u = \'SELECT\')\n"
"_stmt := new_stmpt || \' * FROM (\' || _stmt || \') __xml_dt0\' ;\n"
"\n"
"\n"
"\n"
"}\n"
"--src xmla.sql:1870\n"
;

static const char *proc164 = 
"#line 1926 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_make_cursors_state (in _props any, inout _dta any, in stmt any)\n"
"{\n"
"declare _direction varchar;\n"
"declare _return_bookmark, _return_row_count, _skip, idx, idx2, len, _direc_save, _n_rows integer;\n"
"declare line, temp, _bookmark_from any;\n"
"\n"
"_return_bookmark := xmla_get_property (_props, \'return-bookmark\', 0);\n"
"_skip := xmla_get_property (_props, \'skip\', 0);\n"
"_n_rows := xmla_get_property (_props, \'n-rows\', null);\n"
"\n"
"_direction := xmla_get_property (_props, \'direction\', \'forward\');\n"
"_bookmark_from := xmla_get_property (_props, \'bookmark-from\', NULL);\n"
"_return_row_count := xmla_get_property (_props, \'retrieve-row-count\', 0);\n"
"\n"
"len := length (_dta);\n"
"\n"
"if (_return_row_count)\n"
"{\n"
"declare _rows any;\n"
"\n"
"_rows := xmla_get_rows_from_stmt (stmt);\n"
"\n"
"for (idx := 0; idx < len; idx := idx + 1)\n"
"{\n"
"line := _dta[idx];\n"
"aset (line, 1, _rows);\n"
"aset (_dta, idx, line);\n"
"}\n"
"}\n"
"\n"
"_direc_save := 0;\n"
"if (_direction = \'backward\')\n"
"_direc_save := len;\n"
"\n"
"if (_direction = \'backward\')\n"
"{\n"
"for (idx := 0; idx < len / 2 + 1; idx := idx + 1)\n"
"{\n"
"line := _dta[idx];\n"
"temp := _dta[len - idx - 1];\n"
"aset (_dta, idx, temp);\n"
"aset (_dta, len - idx - 1, line);\n"
"}\n"
"}\n"
"\n"
"if (_return_bookmark)\n"
"{\n"
"for (idx := 0; idx < len; idx := idx + 1)\n"
"{\n"
"line := _dta[idx];\n"
"if (_direction = \'backward\')\n"
"aset (line, 0, encode_base64 (serialize (vector(0, len - idx - 1, _direc_save))));\n"
"else\n"
"aset (line, 0, encode_base64 (serialize (vector(_skip, idx, _direc_save))));\n"
"aset (_dta, idx, line);\n"
"}\n"
"}\n"
"\n"
"\n"
"if (_direction = \'backward\')\n"
"{\n"
"declare _new_dta, _end any;\n"
"\n"
"_skip := xmla_make_skip (_bookmark_from, _skip, 0);\n"
"_new_dta := vector ();\n"
"idx2 := 0;\n"
"_end := _n_rows + _skip;\n"
"\n"
"if (_end > len)\n"
"_end := len;\n"
"\n"
"for (idx := _skip; idx < _end; idx := idx + 1)\n"
"{\n"
"line := _dta[idx];\n"
"_new_dta := vector_concat (_new_dta, vector (line));\n"
"idx2 := idx2 + 1;\n"
"}\n"
"\n"
"_dta := _new_dta;\n"
"}\n"
"}\n"
"--src xmla.sql:1924\n"
;

static const char *proc165 = 
"#line 2011 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_make_skip (in _skip any, in _add int, in _dir int)\n"
"{\n"
"declare pos_vec, ret any;\n"
"\n"
"ret := _add;\n"
"\n"
"if (_skip is NULL)\n"
"return ret;\n"
"\n"
"if (_skip <> \'\')\n"
"{\n"
"pos_vec := deserialize (decode_base64 (_skip));\n"
"\n"
"if (not isarray (pos_vec))\n"
"signal (\'00006\', \'Unable to process the bookmark, because the \"bookmark-from\" property is incorrect\');\n"
"if (_dir)\n"
"ret := pos_vec[0] + pos_vec[1] + _add;\n"
"else\n"
"ret := pos_vec[2] - pos_vec[1] + _add - 1;\n"
"}\n"
"else\n"
"signal (\'00007\', \'Unable to process the bookmark, because the \"bookmark-from\" property is not set or incorrect\');\n"
"\n"
"return ret;\n"
"}\n"
"--src xmla.sql:2009\n"
;

static const char *proc166 = 
"#line 2039 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_get_version ()\n"
"{\n"
"return \'1.01\';\n"
"}\n"
"--src xmla.sql:2037\n"
;

static const char *proc167 = 
"#line 2047 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_format_mdta (inout mdta any)\n"
"{\n"
"declare idx, _line, _name, temp any;\n"
"\n"
"temp := mdta[0];\n"
"\n"
"for (idx := 0; idx < length (temp); idx := idx + 1)\n"
"{\n"
"_line := temp[idx];\n"
"_name := temp[idx][0];\n"
"_name := replace (_name, \' \', \'_\');\n"
"aset (_line, 0, _name);\n"
"aset (temp, idx, _line);\n"
"}\n"
"\n"
"aset (mdta, 0, temp);\n"
"}\n"
"--src xmla.sql:2045\n"
;

static const char *proc168 = 
"#line 2068 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_get_rows_from_stmt (in stmt any)\n"
"{\n"
"declare res, mdta, dta, state, msg any;\n"
"declare new_stmpt, tmp varchar;\n"
"declare pos integer;\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"return -1;\n"
"};\n"
"\n"
"new_stmpt := \'SELECT count(*) \';\n"
"stmt := trim (stmt);\n"
"tmp := ucase (stmt);\n"
"pos := strstr (tmp, \'FROM\');\n"
"tmp := \"LEFT\" (stmt, pos);\n"
"\n"
"stmt := replace (stmt, tmp, new_stmpt, 1);\n"
"\n"
"res := exec (stmt, state, msg, vector (), 0, mdta, dta);\n"
"\n"
"return dta[0][0];\n"
"}\n"
"--src xmla.sql:2066\n"
;

static const char *proc169 = 
"#line 2095 \"[executable]/xmla.sql\"\n"
"create procedure\n"
"xmla_sparql_result (inout mdta any, inout dta any, in stmt any)\n"
"{\n"
"declare idx, idx2, tmdta any;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"tmdta := mdta[0];\n"
"\n"
"for (idx := 0; idx < length (tmdta); idx := idx + 1)\n"
"{\n"
"declare temp, line any;\n"
"\n"
"if (mdta[0][idx][1] = 242)\n"
"{\n"
"for (idx2 := 0; idx2 < length (dta); idx2 := idx2 + 1)\n"
"{\n"
"line := dta[idx2];\n"
"temp := line[idx];\n"
"temp := cast (temp as varchar);\n"
"aset (line, idx, temp);\n"
"aset (dta, idx2, line);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"--src xmla.sql:2093\n"
;

/* openxml.sql */

static const char *proc170 = 
"#line 33 \"[executable]/openxml.sql\"\n"
"create procedure\n"
"DB.DBA.OPENXML_DEFINE (in vname varchar, in tb varchar, in data varchar, in xp varchar, in meta any)\n"
"{\n"
"declare _vname, pname, vdef, pdef, msg, stat, n0, n1, n2, cols, defs, rnames1, tcols varchar;\n"
"declare mod, i, l integer;\n"
"declare xps, rnames, elm any;\n"
"mod := 0;\n"
"\n"
"if (tb is null)\n"
"tb := vname;\n"
"\n"
"tb := complete_table_name (tb, 1);\n"
"vname := complete_table_name (vname, 1);\n"
"\n"
"if (tb is not null and exists (select 1 from DB.DBA.SYS_KEYS where KEY_TABLE = tb))\n"
"{\n"
"if (not exists (select 1 from SYS_COLS where \\TABLE = tb and \\COLUMN = data))\n"
"signal (\'42S22\', \'The data column does not exist\', \'XV005\');\n"
"mod := 1;\n"
"}\n"
"\n"
"if (exists (select 1 from DB.DBA.SYS_VIEWS where V_NAME = vname))\n"
"signal (\'42S01\', \'The XML procedure view already exists\', \'XV004\');\n"
"\n"
"\n"
"if (not mod and xml_tree (data, 0) is null)\n"
"signal (\'22023\', \'The table does not exist and data is not valid XML\', \'XV001\');\n"
"\n"
"if (not isarray (meta))\n"
"signal (\'22023\', \'The metadata is not supplied\', \'XV002\');\n"
"\n"
"n0 := name_part (tb, 0);\n"
"n1 := name_part (tb, 1);\n"
"n2 := name_part (tb, 2);\n"
"\n"
"xps := vector(); rnames := vector (); defs := \'\'; cols := \'(\'; rnames1 := \'\'; tcols := \'\';\n"
"i := 0; l := length (meta);\n"
"while (i < l)\n"
"{\n"
"elm := meta[i];\n"
"if (not isarray (elm) or length (elm) < 1)\n"
"signal (\'22023\', \'The metadata is not valid\', \'XV003\');\n"
"if (length (elm) >= 2)\n"
"{\n"
"if (length (elm) = 2)\n"
"xps := vector_concat (xps, vector (elm[0]));\n"
"else\n"
"xps := vector_concat (xps, vector (elm[2]));\n"
"rnames := vector_concat (rnames, vector (elm[0]));\n"
"}\n"
"rnames1 := concat (rnames1, elm[0], \',\');\n"
"if (length (elm) > 1)\n"
"{\n"
"cols := concat (cols, sprintf (\'%s %s,\', elm[0], elm[1]));\n"
"defs := concat (defs, sprintf (\'declare %s %s;\\n\', elm [0], elm [1]));\n"
"}\n"
"else\n"
"{\n"
"declare ctype varchar;\n"
"if (tb is not null and not exists (select 1 from SYS_COLS where \\TABLE = tb and \\COLUMN = elm[0]))\n"
"signal (\'42S22\', \'The column does not exist\', \'XV005\');\n"
"select dv_type_title (COL_DTP) into ctype from SYS_COLS where \\TABLE = tb and \\COLUMN = elm[0];\n"
"cols := concat (cols, sprintf (\'%s %s,\', elm[0], ctype));\n"
"tcols := concat (tcols, elm [0], \',\');\n"
"}\n"
"i := i + 1;\n"
"}\n"
"aset (cols, length(cols) - 1, ascii(\')\'));\n"
"aset (rnames1, length(rnames1) - 1, ascii(\' \'));\n"
"vname := sprintf (\'\"%I\".\"%I\".\"%I\"\', n0, n1, name_part (vname, 2));\n"
"pname := sprintf (\'\"%I\".\"%I\".\"%s_OPENXML_PROC__\"\', n0, n1, DB.DBA.SYS_ALFANUM_NAME(name_part (vname, 2)));\n"
"vdef := sprintf (\'CREATE PROCEDURE VIEW %s AS %s() %s\', vname, pname, cols);\n"
"if (not mod)\n"
"{\n"
"pdef := sprintf (\'CREATE PROCEDURE %s ()\\n{ declare idoc, res any;\\ndeclare i, l integer;\\n%s\\n\',\n"
"pname, defs);\n"
"pdef := concat (pdef, sprintf (\'idoc := xml_tree_doc (\'\'%s\'\');\\n\', data));\n"
"pdef := concat (pdef, sprintf (\'res := xpath_eval (\'\'%s\'\', idoc, 0);\\n\', xp));\n"
"\n"
"pdef := concat (pdef, \'i:=0; l:=length(res);\\n\');\n"
"pdef := concat (pdef, \'while (i < l) {\\n\');\n"
"i := 0; l := length (xps);\n"
"while (i < l)\n"
"{\n"
"pdef := concat (pdef, sprintf (\'%s := xpath_eval (\'\'%s\'\', res[i], 1);\\n\',rnames[i],xps[i]));\n"
"i := i + 1;\n"
"}\n"
"pdef := concat (pdef, sprintf (\'i := i + 1;\\nresult (%s);\\n}\\n\', rnames1));\n"
"pdef := concat (pdef, \'\\n}\\n\');\n"
"}\n"
"else\n"
"{\n"
"pdef := sprintf (\'CREATE PROCEDURE %s ()\\n{ %s\\n\', pname, defs);\n"
"\n"
"pdef := concat (pdef,\n"
"sprintf (\'for select %s res from \"%I\".\"%I\".\"%I\" where xpath_contains (\"%I\", \'\'%s\'\', res) do {\\n\',\n"
"tcols, n0, n1, n2, data, xp));\n"
"i := 0; l := length (xps);\n"
"while (i < l)\n"
"{\n"
"pdef := concat (pdef, sprintf (\'%s := xpath_eval (\'\'%s\'\', res, 1);\\n\',rnames[i],xps[i]));\n"
"i := i + 1;\n"
"}\n"
"pdef := concat (pdef, sprintf (\'result (%s);\\n}\\n\', rnames1));\n"
"pdef := concat (pdef, \'\\n}\\n\');\n"
"}\n"
"\n"
"stat := \'00000\';\n"
"exec (pdef, stat, msg);\n"
"if (stat <> \'00000\')\n"
"signal (\'22023\', \'Bad datatype in metadata\', \'XV006\');\n"
"stat := \'00000\';\n"
"exec (vdef, stat, msg);\n"
"if (stat <> \'00000\')\n"
"signal (stat, msg);\n"
"}\n"
"--src openxml.sql:31\n"
;

/* vspx.sql */

static const char *tbl8 = 
"create table DB.DBA.VSPX_SESSION\n"
"(VS_REALM varchar,\n"
"VS_SID varchar,\n"
"VS_UID varchar,\n"
"VS_STATE long varchar,\n"
"VS_EXPIRY datetime,\n"
"VS_IP varchar,\n"
"primary key (VS_REALM, VS_SID))\n";

static const char *alter1 = 
"alter table DB.DBA.VSPX_SESSION add VS_IP varchar\n";

static const char *tbl9 = 
"create table WS.WS.HTTP_SES_TRAP_DISABLE\n"
"(\n"
"EXT varchar,\n"
"primary key (EXT)\n"
")\n";

static const char *trig6 = 
"#line 59 \"[executable]/vspx.sql\"\n"
"create trigger VSPX_SESSION_INSERT_AFTER after insert on DB.DBA.VSPX_SESSION {\n"
"declare v_sql any;\n"
"declare result, name, content, reg any;\n"
"declare pwd any;\n"
"declare _state varchar;\n"
"\n"
"if (not is_http_ctx ())\n"
"return;\n"
"\n"
"if(registry_get(\'__block_http_history\') = http_path()) {\n"
"\n"
"return;\n"
"}\n"
"\n"
"select pwd_magic_calc(\'dav\', U_PASSWORD, 1) into pwd from DB.DBA.SYS_USERS where U_NAME=\'dav\' and U_IS_ROLE=0;\n"
"reg := registry_get(\'__save_http_history\');\n"
"\n"
"if(isstring (reg) and reg <> \'\' and http_path() like concat(reg, \'/%\')) {\n"
"if(VS_STATE is NULL) {\n"
"_state := \'NULL\';\n"
"}\n"
"else {\n"
"_state := WS.WS.STR_SQL_APOS(VS_STATE);\n"
"}\n"
"v_sql := sprintf(\'insert replacing DB.DBA.VSPX_SESSION values(\\\'%s\\\', \\\'%s\\\', \\\'%s\\\', %s, now());\\n\', VS_REALM, VS_SID, VS_UID, _state);\n"
"v_sql := concat(\'SET TRIGGERS OFF;\\n\',\n"
"v_sql,\n"
"\'update DB.DBA.VSPX_SESSION set VS_STATE = coalesce ((select top 1 VS_STATE from DB.DBA.VSPX_SESSION where VS_STATE is not NULL), serialize (vector (\'\'vspx_user\'\', \'\'dba\'\'))) where VS_STATE is NULL;\');\n"
"name := sprintf(\'%06d_sql_exec\', sequence_next(\'sys_http_recording\'));\n"
"name := concat(\'/DAV/sys_http_recording/\', name);\n"
"\n"
"result := cast(DB.DBA.DAV_SEARCH_ID(\'/DAV/sys_http_recording/\', \'c\') as integer);\n"
"if(result < 0) {\n"
"\n"
"result := cast(DB.DBA.DAV_COL_CREATE(\'/DAV/sys_http_recording/\', \'110110110R\', \'dav\', \'dav\', \'dav\', pwd) as integer);\n"
"if(result < 0) {\n"
"return;\n"
"}\n"
"}\n"
"result := cast(DB.DBA.DAV_RES_UPLOAD(name, v_sql,\'text/html\',\'110110110R\',\'dav\',\'dav\',\'dav\', pwd) as INTEGER);\n"
"}\n"
"}\n"
"--src vspx.sql:57\n";

static const char *trig7 = 
"#line 105 \"[executable]/vspx.sql\"\n"
"create trigger VSPX_SESSION_WEBID_D before delete on DB.DBA.VSPX_SESSION order 100 referencing old as O\n"
"{\n"
"\n"
"declare _state, webidGraph any;\n"
"\n"
"_state := deserialize (O.VS_STATE);\n"
"if (not isnull (get_keyword (\'agent\', _state)) and not isnull (get_keyword (\'vtype\', _state)))\n"
"{\n"
"webidGraph := \'http:\' || replace (O.VS_SID, \':\', \'\');\n"
"DB.DBA.SPARUL_CLEAR (webidGraph, 0, 0, silent=>1);\n"
"}\n"
"}\n"
"--src vspx.sql:103\n";

static const char *udt6 = 
"create type vspx_event\n"
"as (\n"
"ve_params any,\n"
"ve_lines  any,\n"
"ve_path   any,\n"
"ve_button vspx_control,\n"
"ve_initiator vspx_control,\n"
"ve_is_post int default 0\n"
")  temporary self as ref\n";

static const char *udt7 = 
"create type vspx_control\n"
"as (\n"
"vc_parent  vspx_control default null,\n"
"vc_name varchar,\n"
"vc_instance_name varchar,\n"
"vc_enabled int default 1,\n"
"vc_error_message varchar default null,\n"
"vc_page vspx_page,\n"
"vc_focus int default 0,\n"
"vc_handlers any default null,\n"
"vc_attributes any,\n"
"vc_data_bound int default 0,\n"
"vc_inside_form int default 0,\n"
"vc_inx   int default null,\n"
"vc_level int default null,\n"
"vc_instantiate int default -1,\n"
"vc_top_form vspx_form,\n"
"vc_repeater vspx_control,\n"
"vc_control_state int default null,\n"
"vc_have_state int default 0,\n"
"vc_children any default null\n"
") temporary self as ref\n"
"method vc_data_bind (e vspx_event) returns any,\n"
"method vc_disable_child (ct_name varchar) returns any,\n"
"method vc_enable_child (ct_name varchar) returns any,\n"
"method vc_error_summary () returns any,\n"
"method vc_error_summary (esc_mode int) returns any,\n"
"method vc_error_summary (esc_mode int, pattern varchar) returns any,\n"
"method vc_find_control (name varchar) returns vspx_control,\n"
"method vc_find_descendant_control (name varchar) returns vspx_control,\n"
"method vc_find_parent_by_name (control vspx_control, name varchar) returns vspx_control,\n"
"method vc_find_parent (control vspx_control, udt_name varchar) returns vspx_control,\n"
"method vc_find_parent_form (control vspx_control) returns vspx_control,\n"
"method vc_find_rpt_control (name varchar) returns vspx_control,\n"
"method vc_sibling_value (name varchar) returns any,\n"
"method vc_get_focus (e vspx_event) returns any,\n"
"method vc_set_childs_focus (flag any, e vspx_event) returns any,\n"
"method vc_post (e vspx_event) returns any,\n"
"method vc_user_post (e vspx_event) returns any,\n"
"method vc_action (e vspx_event) returns any,\n"
"method vc_pre_render (stream any, n int) returns any,\n"
"method vc_render () returns any,\n"
"method vc_xrender () returns any,\n"
"method vc_render (ct_name varchar) returns any,\n"
"method vc_set_view_state (e vspx_event) returns any,\n"
"method vc_view_state (stream any, n int) returns any,\n"
"method vc_attribute (name varchar) returns vspx_attribute,\n"
"method vc_set_attribute (name varchar, value any) returns any,\n"
"method vc_add_attribute (name varchar, value any) returns any,\n"
"method vc_get_attribute (name varchar) returns any,\n"
"method vc_handle_error (state any, message any, deadl any) returns any,\n"
"method vc_init (name varchar, parent vspx_control) returns any,\n"
"method vc_get_name () returns any,\n"
"method vc_set_model () returns any,\n"
"method vc_add_handler (name varchar, method_name varchar) returns any,\n"
"method vc_invoke_handlers (name varchar) returns any,\n"
"method vc_debug_log (rectype varchar, txt varchar, more_data any) returns any,\n"
"method vc_debug_log_endgroup (begin_id integer, rectype varchar, txt varchar, more_data any) returns any,\n"
"method vc_push_in_state (stream any, state any) returns any,\n"
"method vc_push_in_stream (stream any, state any, n int) returns any,\n"
"method vc_get_control_state (def any) returns any,\n"
"method vc_set_control_state (state any) returns any,\n"
"constructor method vspx_control (name varchar, parent vspx_control)\n";

static const char *udt8 = 
"create type vspx_attribute as\n"
"(\n"
"va_name varchar,\n"
"va_value varchar,\n"
"va_parent vspx_control\n"
") temporary self as ref\n"
"method vc_render () returns any,\n"
"constructor method vspx_attribute (name varchar, parent vspx_control)\n";

static const char *udt9 = 
"create type vspx_page under vspx_control\n"
"as (\n"
"vc_view_state any,\n"
"vc_is_postback int default 0,\n"
"vc_persisted_vars any,\n"
"vc_event vspx_event,\n"
"vc_is_valid int default 1,\n"
"vc_authenticated int default 0,\n"
"vc_current_id int default 0,\n"
"vc_browser_caps any default 0,\n"
"vc_authentication_mode int default 1,\n"
"vc_debug_log_acc any default null\n"
")  temporary self as ref\n"
"method vc_state_deserialize (stream any, n int) returns any,\n"
"method vc_get_debug_log (title varchar) returns any\n";

static const char *other94 = 
"create constructor method vspx_attribute (in name varchar, inout parent vspx_control) for vspx_attribute\n"
"{\n"
"\n"
"self.va_name := name;\n"
"self.va_parent := parent;\n"
"}\n";

static const char *other95 = 
"create method vc_render () for vspx_attribute\n"
"{\n"
"if(self.va_value=\'@@hidden@@\') return;\n"
"http (\' \' || self.va_name || \'=\"\');\n"
"http_value (self.va_value);\n"
"http (\'\"\');\n"
"}\n";

static const char *other96 = 
"create method vc_attribute (in name varchar) returns vspx_attribute for vspx_control\n"
"{\n"
"declare i, l int;\n"
"i := 0; l := length (self.vc_attributes);\n"
"\n"
"while (i < l)\n"
"{\n"
"declare attr vspx_attribute;\n"
"attr := self.vc_attributes[i];\n"
"if (attr is not null and attr.va_name = name)\n"
"return attr;\n"
"i := i + 1;\n"
"}\n"
"return null;\n"
"}\n";

static const char *other97 = 
"create method vc_set_attribute (in name varchar, in value any) for vspx_control\n"
"{\n"
"declare i, l int;\n"
"i := 0; l := length (self.vc_attributes);\n"
"\n"
"while(i < l) {\n"
"declare attr vspx_attribute;\n"
"attr := self.vc_attributes[i];\n"
"if (attr is not null and attr.va_name = name) {\n"
"attr.va_value := value;\n"
"aset(self.vc_attributes, i, attr);\n"
"return attr;\n"
"}\n"
"i := i + 1;\n"
"}\n"
"return null;\n"
"}\n";

static const char *other98 = 
"create method vc_add_attribute (in name varchar, in value any) for vspx_control\n"
"{\n"
"\n"
"declare attrs any;\n"
"declare attr vspx_attribute;\n"
"\n"
"attr := self.vc_set_attribute (name, value);\n"
"if (attr is not null)\n"
"return attr;\n"
"attr := vspx_attribute (name, self);\n"
"attr.va_value := value;\n"
"attrs := self.vc_attributes;\n"
"attrs := vector_concat (attrs, vector (attr));\n"
"self.vc_attributes := attrs;\n"
"return attr;\n"
"}\n";

static const char *other99 = 
"create method vc_get_attribute (in name varchar) for vspx_control\n"
"{\n"
"declare i, l int;\n"
"i := 0; l := length (self.vc_attributes);\n"
"while (i < l)\n"
"{\n"
"declare attr vspx_attribute;\n"
"attr := self.vc_attributes[i];\n"
"if (attr is not null and attr.va_name = name)\n"
"{\n"
"return attr.va_value;\n"
"}\n"
"i := i + 1;\n"
"}\n"
"return null;\n"
"}\n";

static const char *other100 = 
"create method vc_add_handler (in name varchar, in method_name varchar) for vspx_control\n"
"{\n"
"declare pos, arr, hdl int;\n"
"declare meth any;\n"
"if (self.vc_handlers is null)\n"
"{\n"
"self.vc_handlers := vector (\n"
"\'on-init\', null,\n"
"\'before-data-bind\', null,\n"
"\'after-data-bind\', null,\n"
"\'on-post\', null,\n"
"\'before-render\', null\n"
");\n"
"}\n"
"\n"
"arr := self.vc_handlers;\n"
"pos := position (name, arr);\n"
"if (pos < 1)\n"
"signal (\'22023\', \'Invalid handler type, must be one of following: on-init, before-data-bind, after-data-bind, on-post or before-render\');\n"
"\n"
"hdl := arr [pos];\n"
"if (hdl is null)\n"
"hdl := vector ();\n"
"\n"
"meth := udt_implements_method (self.vc_page, fix_identifier_case (method_name));\n"
"if (meth)\n"
"{\n"
"hdl := vector_concat (hdl, vector (method_name));\n"
"}\n"
"else\n"
"{\n"
"signal (\'22023\', \'Not existing page method: \"\'||method_name||\'\".\');\n"
"}\n"
"\n"
"arr[pos] := hdl;\n"
"self.vc_handlers := arr;\n"
"}\n";

static const char *other101 = 
"create method vc_invoke_handlers (in name varchar) for vspx_control\n"
"{\n"
"declare meth, arr, hdl any;\n"
"declare i, l int;\n"
"if (self.vc_handlers is null)\n"
"return;\n"
"arr := self.vc_handlers;\n"
"hdl := get_keyword (name, arr);\n"
"if (hdl is null)\n"
"return;\n"
"l := length (hdl); i := 0;\n"
"while (i < l)\n"
"{\n"
"meth := udt_implements_method (self.vc_page, fix_identifier_case (hdl[i]));\n"
"call (meth) (self.vc_page, self);\n"
"i := i + 1;\n"
"}\n"
"}\n";

static const char *other102 = 
"create method vc_init (in name varchar, inout parent vspx_control) for vspx_control\n"
"{\n"
"declare id int;\n"
"\n"
"if (not isstring (name))\n"
"{\n"
"signal (\'22023\', \'Missing control name\');\n"
"}\n"
"\n"
"self.vc_name := name;\n"
"self.vc_parent := parent;\n"
"self.vc_page := parent.vc_page;\n"
"\n"
"if (self.vc_inx is null and parent.vc_inx is not null)\n"
"self.vc_inx := parent.vc_inx;\n"
"if (self.vc_level is null and parent.vc_level is not null)\n"
"self.vc_level := parent.vc_level;\n"
"\n"
"if (parent.vc_repeater is null and self.vc_inx is not null and parent.vc_inx is not null)\n"
"{\n"
"self.vc_repeater := parent;\n"
"}\n"
"else if (parent.vc_repeater is not null)\n"
"{\n"
"self.vc_repeater := parent.vc_repeater;\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (self.vc_inx is not null\n"
"\n"
")\n"
"{\n"
"if (self.vc_repeater is null)\n"
"self.vc_instance_name := sprintf (\'%s$%d\', self.vc_name, self.vc_inx);\n"
"else\n"
"self.vc_instance_name := sprintf (\'%s:%s$%d\',\n"
"self.vc_repeater.vc_instance_name, self.vc_name, self.vc_inx);\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (self.vc_inside_form or parent.vc_inside_form or\n"
"udt_instance_of (parent, fix_identifier_case (\'vspx_form\')))\n"
"self.vc_inside_form := 1;\n"
"\n"
"if (udt_instance_of (self, fix_identifier_case (\'vspx_form\')) and not self.vc_inside_form)\n"
"{\n"
"self.vc_top_form := self;\n"
"}\n"
"else if (parent.vc_top_form is not null)\n"
"{\n"
"self.vc_top_form := parent.vc_top_form;\n"
"}\n"
"}\n";

static const char *other103 = 
"create method vc_get_name () for vspx_control\n"
"{\n"
"if (self.vc_instance_name is null)\n"
"return self.vc_name;\n"
"return self.vc_instance_name;\n"
"}\n";

static const char *other104 = 
"create method vc_debug_log (in rectype varchar, in txt varchar, in more_data any) returns any for vspx_control\n"
"{\n"
"declare acc any;\n"
"declare head any;\n"
"declare id any;\n"
"if (self is null or self.vc_page is null)\n"
"return 0;\n"
"acc := self.vc_page.vc_debug_log_acc;\n"
"if (acc is null)\n"
"xte_nodebld_init (acc);\n"
"id := sequence_next(\'vspx_vc_debug_log\');\n"
"head := xte_head (rectype, \'text\', txt, \'control-name\', self.vc_name, \'instance-name\', self.vc_instance_name, \'id\', cast (id as varchar));\n"
"if (more_data is null)\n"
"xte_nodebld_acc (acc, xte_node (head));\n"
"else if (isentity (more_data))\n"
"xte_nodebld_acc (acc, xte_node (head, more_data));\n"
"else\n"
"xte_nodebld_acc (acc, xte_node (head, cast (more_data as varchar)));\n"
"self.vc_page.vc_debug_log_acc := acc;\n"
"return id;\n"
"}\n";

static const char *other105 = 
"create method vc_debug_log_endgroup (in begin_id integer, in rectype varchar, in txt varchar, in more_data any) returns any for vspx_control\n"
"{\n"
"declare acc any;\n"
"declare head any;\n"
"declare id any;\n"
"if (self is null or self.vc_page is null)\n"
"return 0;\n"
"acc := self.vc_page.vc_debug_log_acc;\n"
"if (acc is null)\n"
"xte_nodebld_init (acc);\n"
"id := sequence_next(\'vspx_vc_debug_log\');\n"
"head := xte_head (rectype, \'text\', txt, \'control-name\', self.vc_name, \'instance-name\', self.vc_instance_name, \'id\', cast (id as varchar), \'begin-id\', cast (begin_id as varchar));\n"
"if (more_data is null)\n"
"xte_nodebld_acc (acc, xte_node (head));\n"
"else if (isentity (more_data))\n"
"xte_nodebld_acc (acc, xte_node (head, more_data));\n"
"else\n"
"xte_nodebld_acc (acc, xte_node (head, cast (more_data as varchar)));\n"
"self.vc_page.vc_debug_log_acc := acc;\n"
"return id;\n"
"}\n";

static const char *other106 = 
"create method vc_state_deserialize (inout stream any, inout n int) returns any for vspx_page\n"
"{\n"
"declare ss any;\n"
"declare h any;\n"
"declare inx, len int;\n"
"h := udt_implements_method (self.vc_page, fix_identifier_case (concat (\'vc_view_state_\', self.vc_name)));\n"
"if (h <> 0)\n"
"{\n"
"call (h) (self.vc_page, self, stream, n);\n"
"}\n"
"ss := string_output ();\n"
"http (chr (193), ss);\n"
"http (serialize (n), ss);\n"
"http (string_output_string (stream), ss);\n"
"stream := null;\n"
"self.vc_view_state := deserialize (string_output_string (ss));\n"
"\n"
"}\n";

static const char *other107 = 
"create method vc_get_debug_log (in title varchar) returns any for vspx_page\n"
"{\n"
"declare acc any;\n"
"acc := self.vc_debug_log_acc;\n"
"if (acc is null)\n"
"return xml_tree_doc (xte_node (xte_head(title)));\n"
"xte_nodebld_final(acc, xte_head(title));\n"
"self.vc_debug_log_acc := null;\n"
"return xml_tree_doc (acc);\n"
"}\n";

static const char *udt10 = 
"create type vspx_row_template under vspx_control\n"
"as (\n"
"te_rowset any,\n"
"te_ctr int default 0,\n"
"te_editable int default 0\n"
")  temporary self as ref\n"
"constructor method vspx_row_template (name varchar,rowset any, parent vspx_control, ctr int),\n"
"constructor method vspx_row_template_fast (name varchar,rowset any, parent vspx_control, ctr int, nth int),\n"
"method te_column_value (name varchar) returns any\n";

static const char *udt11 = 
"create type vspx_form under vspx_control\n"
"as\n"
"(\n"
"uf_action varchar default \'\',\n"
"uf_method varchar default \'post\',\n"
"\n"
"uf_validators any,\n"
"uf_xmodel any default null,\n"
"uf_xsubmit any default null,\n"
"uf_xschema any default null\n"
")  temporary self as ref\n"
"constructor method vspx_form (name varchar, parent vspx_control),\n"
"method prologue_render (sid varchar, realm varchar, nonce varchar) returns any,\n"
"method epilogue_render () returns any,\n"
"overriding method vc_set_model () returns any\n";

static const char *udt12 = 
"create type vspx_tab under vspx_form\n"
"as\n"
"(\n"
"tb_active vspx_template,\n"
"tb_is_input int default 0,\n"
"tb_style varchar\n"
")\n"
"temporary self as ref\n"
"constructor method vspx_tab (name varchar, parent vspx_control),\n"
"\n"
"overriding method vc_set_view_state (e vspx_event) returns any,\n"
"overriding method vc_view_state (stream any, n int) returns any\n";

static const char *udt13 = 
"create type vspx_template under vspx_control\n"
"temporary self as ref\n"
"constructor method vspx_template (name varchar, parent vspx_control)\n";

static const char *udt14 = 
"create type vspx_update_form under vspx_form\n"
"as (\n"
"uf_keys  any,\n"
"uf_fields any,\n"
"uf_row any,\n"
"uf_columns any,\n"
"uf_table varchar,\n"
"uf_if_not_exists int,\n"
"uf_concurrency int default 0\n"
")  temporary self as ref\n"
"overriding method vc_view_state (stream any, n int) returns any,\n"
"overriding method vc_set_view_state (e vspx_event) returns any,\n"
"constructor method vspx_update_form (name varchar, parent vspx_control),\n"
"method uf_column_value (name varchar) returns any\n";

static const char *udt15 = 
"create type vspx_login_form under vspx_form\n"
"as\n"
"(\n"
"vlf_title varchar,\n"
"vlf_user_title varchar,\n"
"vlf_password_title varchar,\n"
"vlf_submit_title varchar,\n"
"vlf_login vspx_login\n"
") temporary self as ref\n"
"constructor method vspx_login_form (name varchar,  parent vspx_control),\n"
"constructor method vspx_login_form (name varchar, title varchar, user_title varchar, password_title varchar, submit_tile varchar, login vspx_login),\n"
"overriding method vc_render () returns any\n";

static const char *udt16 = 
"create type vspx_field_value under vspx_control\n"
"as\n"
"(\n"
"ufl_value any default null,\n"
"ufl_element_value any default null,\n"
"ufl_element_place any default null,\n"
"ufl_element_path any default null,\n"
"ufl_element_params any default null,\n"
"ufl_element_update_path any default null,\n"
"ufl_element_update_params any default null,\n"
"ufl_true_value any default 1,\n"
"ufl_false_value any default 0,\n"
"ufl_null_value any default null,\n"
"ufl_selected int default 0,\n"
"ufl_is_boolean int default 0\n"
")\n"
"temporary self as ref\n"
"constructor method vspx_field_value (name varchar, parent vspx_control),\n"
"method vc_get_from_element () returns any,\n"
"method vc_put_to_element (val any) returns any,\n"
"method vc_get_value_from_element () returns any,\n"
"method vc_put_value_to_element () returns any,\n"
"method vc_get_selected_from_value () returns any\n";

static const char *udt17 = 
"create type vspx_field under vspx_field_value\n"
"as\n"
"(\n"
"ufl_fmt_fn varchar default null,\n"
"ufl_cvt_fn varchar default null,\n"
"ufl_validators any,\n"
"ufl_column varchar default null,\n"
"ufl_error varchar default null,\n"
"ufl_error_glyph varchar default null,\n"
"ufl_failed int default 0,\n"
"ufl_group varchar default \'\',\n"
"ufl_name_suffix varchar default \'\',\n"
"ufl_active int default 1,\n"
"ufl_client_validate int default 0,\n"
"ufl_auto_submit int default 0\n"
")\n"
"temporary self as ref\n"
"constructor method vspx_field (name varchar, parent vspx_control),\n"
"method ufl_schema (sch any, name varchar) returns any,\n"
"method vc_validate () returns any\n";

static const char *udt18 = 
"create type vspx_column under vspx_field\n"
"as\n"
"(\n"
"ufl_col_label varchar,\n"
"ufl_col_offs int,\n"
"ufl_col_meta any,\n"
"ufl_table varchar default null,\n"
"ufl_is_key int default 0\n"
")\n"
"temporary self as ref\n"
"constructor method vspx_column (col varchar, label varchar, infmt varchar, outfmt varchar, parent vspx_control)\n";

static const char *udt19 = 
"create type vspx_update_field under vspx_text\n"
"temporary self as ref\n"
"constructor method vspx_update_field (name varchar, parent vspx_control),\n"
"overriding method vc_render () returns any,\n"
"overriding method vc_view_state (stream any, n int) returns any\n";

static const char *udt20 = 
"create type vspx_isql under vspx_form\n"
"as\n"
"(\n"
"\n"
"isql_custom_exec integer default 0,\n"
"isql_explain integer default 0,\n"
"isql_maxrows integer default 20,\n"
"isql_chunked integer default 0,\n"
"isql_current_stmt varchar default null,\n"
"isql_current_state any default null,\n"
"isql_current_meta any default null,\n"
"isql_current_pos int default 0,\n"
"isql_current_row int default 0,\n"
"isql_rows_fetched int default 0,\n"
"isql_user varchar default null,\n"
"isql_password varchar default null,\n"
"isql_isolation varchar default \'committed\',\n"
"isql_timeout integer default 60,\n"
"isql_text varchar default \'\',\n"
"\n"
"\n"
"isql_mtd any default null,\n"
"isql_res any default null,\n"
"isql_stmts any default null\n"
")\n"
"temporary self as ref\n"
"constructor method vspx_isql (name varchar, parent vspx_control),\n"
"method isql_exec () returns any\n";

static const char *udt21 = 
"create type vspx_text under vspx_field\n"
"as\n"
"(\n"
"tf_default varchar default \'\',\n"
"tf_style any default 0\n"
")\n"
"temporary self as ref\n"
"overriding method vc_render () returns any,\n"
"overriding method vc_set_view_state (e vspx_event) returns any,\n"
"overriding method vc_view_state (stream any, n int) returns any,\n"
"overriding method vc_set_model () returns any,\n"
"overriding method vc_xrender () returns any,\n"
"constructor method vspx_text (name varchar, parent vspx_control)\n";

static const char *udt22 = 
"create type vspx_textarea under vspx_text  temporary self as ref\n"
"constructor method vspx_textarea (name varchar, parent vspx_control),\n"
"overriding method vc_xrender () returns any,\n"
"overriding method vc_render () returns any\n";

static const char *udt23 = 
"create type vspx_label under vspx_field\n"
"as\n"
"(\n"
"vl_format varchar default \'%s\'\n"
") temporary self as ref\n"
"constructor method vspx_label (name varchar, parent vspx_control),\n"
"overriding method vc_render () returns any\n";

static const char *udt24 = 
"create type vspx_check_box under vspx_field\n"
"temporary self as ref\n"
"constructor method vspx_check_box (name varchar, parent vspx_control),\n"
"overriding method vc_render () returns any,\n"
"overriding method vc_xrender () returns any,\n"
"overriding method vc_view_state (stream any, n int) returns any,\n"
"overriding method vc_set_view_state (e vspx_event) returns any,\n"
"overriding method vc_set_model () returns any\n";

static const char *udt25 = 
"create type vspx_radio_button under vspx_field\n"
"temporary self as ref\n"
"constructor method vspx_radio_button (name varchar, parent vspx_control),\n"
"overriding method vc_view_state (stream any, n int) returns any,\n"
"overriding method vc_set_view_state (e vspx_event) returns any,\n"
"overriding method vc_render () returns any,\n"
"overriding method vc_xrender () returns any,\n"
"overriding method vc_set_model () returns any\n";

static const char *udt26 = 
"create type vspx_radio_group under vspx_field\n"
"temporary self as ref\n"
"constructor method vspx_radio_group (name varchar, parent vspx_control),\n"
"method vc_choose_selected () returns any,\n"
"overriding method vc_xrender () returns any,\n"
"overriding method vc_set_model () returns any\n";

static const char *udt27 = 
"create type vspx_url under vspx_field\n"
"as\n"
"(\n"
"vu_format varchar default \'%s\',\n"
"vu_url varchar default \'\',\n"
"vu_l_pars varchar default \'\',\n"
"vu_is_local int default 0\n"
")\n"
"temporary self as ref\n"
"overriding method vc_render () returns any,\n"
"constructor method vspx_url (name varchar, parent vspx_control)\n";

static const char *udt28 = 
"create type vspx_button under vspx_field as\n"
"(\n"
"bt_pressed int default 0,\n"
"bt_style  varchar default \'submit\',\n"
"bt_close_img varchar,\n"
"bt_open_img varchar,\n"
"bt_url varchar default \'\',\n"
"bt_l_pars varchar default \'\',\n"
"bt_text varchar default \'\',\n"
"bt_anchor int default 0\n"
")  temporary self as ref\n"
"overriding method vc_render () returns any,\n"
"overriding method vc_xrender () returns any,\n"
"overriding method vc_set_model () returns any,\n"
"constructor method vspx_button (name varchar, parent vspx_control)\n";

static const char *udt29 = 
"create type vspx_submit under vspx_button\n"
"temporary self as ref\n"
"constructor method vspx_submit (name varchar, parent vspx_control)\n";

static const char *udt30 = 
"create type vspx_logout_button under vspx_button\n"
"temporary self as ref\n"
"constructor method vspx_logout_button (name varchar, parent vspx_control)\n";

static const char *udt31 = 
"create type vspx_return_button under vspx_button\n"
"temporary self as ref\n"
"overriding method vc_render () returns any,\n"
"constructor method vspx_return_button (name varchar, parent vspx_control)\n";

static const char *udt32 = 
"create type vspx_delete_button under vspx_button as\n"
"(\n"
"btd_table varchar,\n"
"btd_key varchar\n"
") temporary self as ref\n"
"constructor method vspx_delete_button (name varchar, parent vspx_control)\n";

static const char *udt33 = 
"create type vspx_calendar under vspx_control as\n"
"(\n"
"cal_date date,\n"
"cal_meta any,\n"
"cal_selected datetime,\n"
"cal_current_row vspx_row_template\n"
") temporary self as ref\n"
"method vc_get_date_array () returns any,\n"
"overriding method vc_view_state (stream any, n int) returns any,\n"
"overriding method vc_set_view_state (e vspx_event) returns any,\n"
"constructor method vspx_calendar (name varchar, parent vspx_control)\n";

static const char *udt34 = 
"create type vspx_validator\n"
"as\n"
"(\n"
"vv_format varchar,\n"
"vv_test   varchar,\n"
"vv_expr   varchar,\n"
"vv_message varchar,\n"
"vv_empty_allowed int default 0\n"
")  temporary self as ref\n";

static const char *udt35 = 
"create type vspx_range_validator under vspx_validator\n"
"as\n"
"(\n"
"vr_min any,\n"
"vr_max any\n"
")  temporary self as ref\n"
"method vv_validate (control vspx_control) returns any\n";

static const char *udt36 = 
"create type vspx_data_set under vspx_form\n"
"as (\n"
"ds_nrows int,\n"
"ds_scrollable int,\n"
"ds_editable int default 1,\n"
"ds_row_meta any,\n"
"ds_row_data any,\n"
"ds_current_row vspx_row_template,\n"
"ds_rowno_edit int default null,\n"
"ds_rows_fetched int default 0,\n"
"ds_rows_total int default 0,\n"
"ds_rows_offs    int default 0,\n"
"ds_rows_offs_saved int default 0,\n"
"ds_scrolled     int default 0,\n"
"ds_has_next_page int default 0,\n"
"ds_prev_bookmark any default null,\n"
"ds_last_bookmark any default null,\n"
"ds_rows_cache any,\n"
"ds_data_source vspx_data_source default null\n"
")  temporary self as ref\n"
"method vc_templates_clean () returns any,\n"
"method vc_reset () returns any,\n"
"method ds_column_offset (name varchar) returns any,\n"
"method ds_iterate_rows (inx int) returns any,\n"
"constructor method vspx_data_set (name varchar, parent vspx_control),\n"
"overriding method vc_set_view_state (e vspx_event) returns any,\n"
"overriding method vc_view_state (stream any, n int) returns any\n";

static const char *udt37 = 
"create type vspx_data_source under vspx_control\n"
"as    (\n"
"ds_row_meta any,\n"
"ds_row_data any,\n"
"ds_array_data any,\n"
"ds_rows_fetched int default 0,\n"
"ds_rows_offs    int default 0,\n"
"ds_nrows int,\n"
"ds_total_pages int default 0,\n"
"ds_current_page int default 0,\n"
"ds_current_pager_idx int default 0,\n"
"ds_npages int default 10,\n"
"ds_first_page int default 0,\n"
"ds_last_page int default 0,\n"
"ds_total_rows int default 0,\n"
"ds_prev_bookmark any default null,\n"
"ds_next_bookmark any default null,\n"
"ds_parameters any default null,\n"
"ds_columns any default null,\n"
"ds_sql varchar default null,\n"
"ds_sql_type varchar default \'sql\',\n"
"ds_current_inx int default 0,\n"
"ds_update_inx int default -1,\n"
"ds_tables any default null,\n"
"ds_insert any default null,\n"
"ds_update any default null,\n"
"ds_delete any default null,\n"
"ds_rb_data any default null,\n"
"ds_have_more any default null\n"
")\n"
"temporary self as ref\n"
"method set_parameter (num any, value any) returns any,\n"
"method get_parameter (num any) returns any,\n"
"method add_parameter (value any) returns any,\n"
"method delete_parameter (num any) returns any,\n"
"method get_column_name (num any) returns any,\n"
"method set_column_label (num any, value any) returns any,\n"
"method get_column_label (num any) returns any,\n"
"method get_column_label (col varchar) returns any,\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"method set_item_value (row any, col any, value any) returns any,\n"
"method set_item_value (col varchar, value any) returns any,\n"
"method get_item_value (row any, col any) returns any,\n"
"method get_rb_item_value (row any, col any) returns any,\n"
"method get_item_value (col any) returns any,\n"
"method get_item_value (col varchar) returns any,\n"
"method set_expression (expression varchar) returns any,\n"
"method get_expression () returns varchar,\n"
"method set_expression_type (type varchar) returns any,\n"
"method get_expression_type () returns varchar,\n"
"method reset () returns any,\n"
"method ds_data_bind (e vspx_event) returns any,\n"
"method ds_make_statistic () returns any,\n"
"method ds_insert (e vspx_event) returns any,\n"
"method ds_update (e vspx_event) returns any,\n"
"method ds_delete (e vspx_event) returns any,\n"
"method ds_key_params (tbl varchar) returns any,\n"
"method ds_tbl_params (tbl varchar) returns any,\n"
"method get_current_row () returns any,\n"
"constructor method vspx_data_source (name varchar, parent vspx_control)\n";

static const char *other108 = 
"create method reset () for vspx_data_source\n"
"{\n"
"self.ds_prev_bookmark := null;\n"
"self.ds_last_bookmark := null;\n"
"}\n";

static const char *other109 = 
"create method ds_key_params (in tbl varchar) for vspx_data_source\n"
"{\n"
"declare i, l, r int;\n"
"declare pars any;\n"
"pars := vector ();\n"
"i := 0; l := length (self.ds_columns);\n"
"r := self.ds_update_inx;\n"
"while (i < l)\n"
"{\n"
"declare col vspx_column;\n"
"col := self.ds_columns[i];\n"
"if (col.ufl_table = tbl and col.ufl_is_key)\n"
"{\n"
"declare par any;\n"
"if (self.ds_rb_data is not null)\n"
"par := self.get_rb_item_value (r,i);\n"
"else\n"
"par := self.get_item_value (r,i);\n"
"pars := vector_concat (pars, vector (par));\n"
"}\n"
"i := i + 1;\n"
"}\n"
"return pars;\n"
"}\n";

static const char *other110 = 
"create method ds_tbl_params (in tbl varchar) for vspx_data_source\n"
"{\n"
"declare i, l, r int;\n"
"declare pars any;\n"
"pars := vector ();\n"
"i := 0; l := length (self.ds_columns);\n"
"r := self.ds_update_inx;\n"
"while (i < l)\n"
"{\n"
"declare col vspx_column;\n"
"col := self.ds_columns[i];\n"
"if (col.ufl_table = tbl)\n"
"{\n"
"declare par any;\n"
"par := self.get_item_value (r,i);\n"
"pars := vector_concat (pars, vector (par));\n"
"}\n"
"i := i + 1;\n"
"}\n"
"return pars;\n"
"}\n";

static const char *other111 = 
"create method ds_insert (inout e vspx_event) for vspx_data_source\n"
"{\n"
"declare stat, msg, pars any;\n"
"declare pos, ia any;\n"
"declare stmt varchar;\n"
"declare i, l int;\n"
"\n"
"ia := self.ds_insert;\n"
"i := 0;\n"
"l := length (ia);\n"
"while (i < l)\n"
"{\n"
"declare k, p any;\n"
"declare tbl varchar;\n"
"declare npars any;\n"
"\n"
"tbl := self.ds_tables[i];\n"
"p := self.ds_tbl_params (tbl);\n"
"stmt := ia[i];\n"
"npars := p;\n"
"stat := \'00000\';\n"
"exec (stmt, stat, msg, npars);\n"
"\n"
"if (stat <> \'00000\')\n"
"{\n"
"rollback work;\n"
"signal (stat, msg);\n"
"}\n"
"i := i + 1;\n"
"}\n"
"\n"
"}\n";

static const char *other112 = 
"create method ds_update (inout e vspx_event) for vspx_data_source\n"
"{\n"
"declare stat, msg, pars any;\n"
"declare pos any;\n"
"declare stmt varchar;\n"
"declare i, l int;\n"
"declare ua, ia any;\n"
"\n"
"ua := self.ds_update;\n"
"i := 0;\n"
"l := length (ua);\n"
"while (i < l)\n"
"{\n"
"declare k, p any;\n"
"declare tbl varchar;\n"
"declare npars any;\n"
"\n"
"tbl := self.ds_tables[i];\n"
"k := self.ds_key_params (tbl);\n"
"p := self.ds_tbl_params (tbl);\n"
"stmt := ua[i];\n"
"npars := vector_concat (p, k);\n"
"stat := \'00000\';\n"
"exec (stmt, stat, msg, npars);\n"
"\n"
"if (stat <> \'00000\')\n"
"{\n"
"rollback work;\n"
"signal (stat, msg);\n"
"}\n"
"i := i + 1;\n"
"}\n"
"}\n";

static const char *other113 = 
"create method ds_delete (inout e vspx_event) for vspx_data_source\n"
"{\n"
"declare stat, msg, pars any;\n"
"declare pos any;\n"
"declare stmt varchar;\n"
"declare i, l int;\n"
"declare da any;\n"
"\n"
"da := self.ds_delete;\n"
"i := 0;\n"
"l := length (da);\n"
"while (i < l)\n"
"{\n"
"declare k, p any;\n"
"declare tbl varchar;\n"
"declare npars any;\n"
"\n"
"tbl := self.ds_tables[i];\n"
"k := self.ds_key_params (tbl);\n"
"stmt := da[i];\n"
"npars := k;\n"
"stat := \'00000\';\n"
"exec (stmt, stat, msg, npars);\n"
"\n"
"if (stat <> \'00000\')\n"
"{\n"
"rollback work;\n"
"signal (stat, msg);\n"
"}\n"
"i := i + 1;\n"
"}\n"
"\n"
"}\n";

static const char *other114 = 
"create method ds_make_statistic () for vspx_data_source\n"
"{\n"
"declare stat, msg, data, meta any;\n"
"declare pos any;\n"
"declare stmt varchar;\n"
"declare i, l int;\n"
"declare j, k int;\n"
"\n"
"stat := \'00000\';\n"
"if(self.ds_sql_type = \'sql\') {\n"
"stmt := sprintf(\'select count(*) from (%s) %s\',  self.ds_sql, self.vc_name);\n"
"}\n"
"else if(self.ds_sql_type = \'procedure\') {\n"
"return 0;\n"
"}\n"
"else if(self.ds_sql_type = \'array\') {\n"
"self.ds_total_rows := length(self.ds_array_data);\n"
"goto skip_sql;\n"
"}\n"
"else if(self.ds_sql_type = \'table\') {\n"
"stmt := sprintf(\'select count(*) from %s\',  self.ds_sql);\n"
"}\n"
"exec(stmt, stat, msg, self.ds_parameters, 1, meta, data);\n"
"if(stat <> \'00000\') {\n"
"rollback work;\n"
"signal (stat, msg);\n"
"}\n"
"self.ds_total_rows := data[0][0];\n"
"skip_sql:\n"
"self.ds_total_pages := self.ds_total_rows / self.ds_nrows;\n"
"self.ds_current_page := self.ds_rows_offs / self.ds_nrows + 1;\n"
"if(mod(self.ds_current_page, self.ds_npages + 1) = 0) {\n"
"self.ds_first_page := self.ds_current_page;\n"
"}\n"
"else {\n"
"self.ds_first_page := self.ds_current_page - mod(self.ds_current_page, self.ds_npages + 1);\n"
"}\n"
"if(self.ds_first_page < 1) {\n"
"self.ds_first_page := 1;\n"
"}\n"
"self.ds_last_page := self.ds_first_page + self.ds_npages - 1;\n"
"if(self.ds_last_page > self.ds_total_pages + 1) {\n"
"self.ds_last_page := self.ds_total_pages + 1;\n"
"}\n"
"}\n";

static const char *other115 = 
"create method ds_data_bind (inout e vspx_event) for vspx_data_source\n"
"{\n"
"declare stat, msg, data, meta any;\n"
"declare pos any;\n"
"declare stmt varchar;\n"
"declare i, l int;\n"
"declare j, k int;\n"
"\n"
"stat := \'00000\';\n"
"stmt := self.ds_sql;\n"
"\n"
"if (self.ds_sql_type = \'sql\')\n"
"{\n"
"stmt := sprintf (\'select top %d,%d * from (\', self.ds_rows_offs, self.ds_nrows + 1)\n"
"|| stmt || \') \"\' || self.vc_name || \'\"\';\n"
"}\n"
"else if (self.ds_sql_type = \'procedure\')\n"
"{\n"
" ;\n"
"}\n"
"else if (self.ds_sql_type = \'array\')\n"
"{\n"
"self.ds_rows_fetched := length(self.ds_array_data) - self.ds_rows_offs;\n"
"if(self.ds_rows_fetched > self.ds_nrows) self.ds_rows_fetched := self.ds_nrows;\n"
"self.ds_row_data := subseq(self.ds_array_data, self.ds_rows_offs, self.ds_rows_offs + self.ds_rows_fetched);\n"
"return;\n"
"}\n"
"else if (self.ds_sql_type = \'table\')\n"
"{\n"
"stmt := sprintf (\'select top %d,%d * from %s\', self.ds_rows_offs, self.ds_nrows + 1, self.ds_sql);\n"
"}\n"
"\n"
"\n"
"exec (stmt, stat, msg, self.ds_parameters, self.ds_nrows + 1, meta, data);\n"
"if (stat <> \'00000\')\n"
"{\n"
"rollback work;\n"
"signal (stat, msg);\n"
"}\n"
"\n"
"if (isarray (data) and length (data) > self.ds_nrows)\n"
"{\n"
"self.ds_have_more := 1;\n"
"data := subseq (data, 0, self.ds_nrows);\n"
"}\n"
"else\n"
"{\n"
"self.ds_have_more := 0;\n"
"}\n"
"\n"
"\n"
"meta := meta [0];\n"
"l := length (self.ds_columns);\n"
"j := 0; k := length (meta);\n"
"while (i < l)\n"
"{\n"
"declare col vspx_column;\n"
"col := self.ds_columns[i];\n"
"j := 0;\n"
"while (j < k)\n"
"{\n"
"declare colname varchar;\n"
"if (isstring (meta[j][8]))\n"
"colname := meta[j][8];\n"
"else\n"
"colname := meta[j][0];\n"
"if (colname = col.ufl_column)\n"
"{\n"
"declare cmeta any;\n"
"cmeta := meta[j];\n"
"if (not isstring (meta[j][8]))\n"
"aset (cmeta, 8, colname);\n"
"col.ufl_col_offs := j;\n"
"col.ufl_col_meta := cmeta;\n"
"j := k;\n"
"}\n"
"j := j + 1;\n"
"}\n"
"i := i + 1;\n"
"}\n"
"\n"
"declare tables any;\n"
"i := 0; l := length (self.ds_columns);\n"
"tables := vector ();\n"
"while (i < l)\n"
"{\n"
"declare col vspx_column;\n"
"declare tblname varchar;\n"
"col := self.ds_columns[i];\n"
"if (isstring (col.ufl_col_meta[10])\n"
"and isstring (col.ufl_col_meta[9])\n"
"and isstring (col.ufl_col_meta[7])\n"
")\n"
"{\n"
"tblname := sprintf (\'\"%I\".\"%I\".\"%I\"\', col.ufl_col_meta[7], col.ufl_col_meta[9], col.ufl_col_meta[10]);\n"
"col.ufl_table := tblname;\n"
"if (not position (tblname, tables))\n"
"tables := vector_concat (tables, vector (tblname));\n"
"}\n"
"i := i + 1;\n"
"}\n"
"\n"
"declare ins, upd, del, whe, cols, vals varchar;\n"
"declare ua, ia, da any;\n"
"i := 0; l := length (tables);\n"
"j := 0; k := length (self.ds_columns);\n"
"ua := make_array (l, \'any\');\n"
"ia := make_array (l, \'any\');\n"
"da := make_array (l, \'any\');\n"
"while (i < l)\n"
"{\n"
"j := 0;\n"
"ins := \'insert into \' || tables[i] || \' \';\n"
"upd := \'update \' || tables[i] || \' set \';\n"
"del := \'delete from \' || tables[i] || \' \';\n"
"whe := \' where \';\n"
"cols := \'\'; vals := \'\';\n"
"while (j < k)\n"
"{\n"
"declare col vspx_column;\n"
"declare tblname varchar;\n"
"col := self.ds_columns[j];\n"
"if (tables[i] = col.ufl_table)\n"
"{\n"
"upd := upd || col.ufl_col_meta[8] || \' = ?, \';\n"
"if (not col.ufl_col_meta[4] and col.ufl_col_meta[6])\n"
"{\n"
"whe := whe || col.ufl_col_meta[8] || \' = ? and \';\n"
"col.ufl_is_key := 1;\n"
"}\n"
"cols := cols || col.ufl_col_meta[8] || \', \';\n"
"vals := vals || \'?, \';\n"
"}\n"
"j := j + 1;\n"
"}\n"
"upd := rtrim (upd,\', \'); whe := whe || \'1\';\n"
"cols := rtrim (cols,\', \'); vals :=  rtrim (vals,\', \');\n"
"upd := upd || whe;\n"
"del := del || whe;\n"
"ins := ins || \' (\' || cols || \') values (\' || vals ||\')\';\n"
"aset (ua, i, upd);\n"
"aset (ia, i, ins);\n"
"aset (da, i, del);\n"
"i := i + 1;\n"
"}\n"
"\n"
"self.ds_tables := tables;\n"
"self.ds_insert := ia;\n"
"self.ds_update := ua;\n"
"self.ds_delete := da;\n"
"\n"
"self.ds_rows_fetched := length (data);\n"
"self.ds_row_data := data;\n"
"self.ds_row_meta := meta;\n"
"\n"
"}\n";

static const char *other116 = 
"create method get_current_row () for vspx_data_source\n"
"{\n"
"return self.ds_current_inx;\n"
"}\n";

static const char *other117 = 
"create method set_parameter (in num any, in value any) for vspx_data_source\n"
"{\n"
"declare pars any;\n"
"if (length (self.ds_parameters) > num)\n"
"{\n"
"pars := self.ds_parameters;\n"
"aset (pars, num, value);\n"
"self.ds_parameters := pars;\n"
"}\n"
"}\n";

static const char *other118 = 
"create method get_parameter (in num any) for vspx_data_source\n"
"{\n"
"declare exit handler for sqlstate \'22003\' { return \'out-of-index\'; };\n"
"return self.ds_parameters[num];\n"
"}\n";

static const char *other119 = 
"create method add_parameter (in value any) for vspx_data_source\n"
"{\n"
"declare pars any;\n"
"pars := self.ds_parameters;\n"
"if (pars is null)\n"
"pars := vector ();\n"
"pars := vector_concat (pars, vector (value));\n"
"self.ds_parameters := pars;\n"
"}\n";

static const char *other120 = 
"create method delete_parameter (in num any) for vspx_data_source\n"
"{\n"
"declare pars any;\n"
"if (length (self.ds_parameters) > num)\n"
"{\n"
"declare i,j, l int;\n"
"pars := make_array(length(self.ds_parameters) - 1, \'any\');\n"
"i := 0; l := length (self.ds_parameters); j := 0;\n"
"while (i < l)\n"
"{\n"
"if (i <> num)\n"
"{\n"
"aset (pars, j, self.ds_parameters[i]);\n"
"j := j + 1;\n"
"}\n"
"i := i + 1;\n"
"}\n"
"self.ds_parameters := pars;\n"
"}\n"
"}\n";

static const char *other121 = 
"create method set_column_label (in num any, in value any) for vspx_data_source\n"
"{\n"
"declare cols any;\n"
"if (length (self.ds_columns) > num)\n"
"{\n"
"declare col vspx_column;\n"
"cols := self.ds_columns;\n"
"col := cols[num];\n"
"col.ufl_col_label := value;\n"
"aset (cols, num, col);\n"
"self.ds_columns := cols;\n"
"}\n"
"}\n";

static const char *other122 = 
"create method get_column_label (in num any) for vspx_data_source\n"
"{\n"
"declare exit handler for sqlstate \'*\' { return \'out-of-index\'; };\n"
"return (self.ds_columns[num] as vspx_column).ufl_col_label;\n"
"}\n";

static const char *other123 = 
"create method get_column_name (in num any) for vspx_data_source\n"
"{\n"
"\n"
"return (self.ds_columns[num] as vspx_column).ufl_column;\n"
"}\n";

static const char *other124 = 
"create method get_column_label (in col varchar) for vspx_data_source\n"
"{\n"
"declare colum vspx_column;\n"
"declare i, l int;\n"
"declare exit handler for sqlstate \'*\' { return \'out-of-index\'; };\n"
"i := 0; l := length (self.ds_columns);\n"
"while (i < l)\n"
"{\n"
"colum := self.ds_columns[i];\n"
"if (colum.ufl_column = col)\n"
"goto endf;\n"
"i := i + 1;\n"
"}\n"
"signal (\'22003\', \'Non-existing column\');\n"
"endf:;\n"
"return colum.ufl_col_label;\n"
"}\n";

static const char *other125 = 
"create method set_item_value (in row any, in col any, in value any) for vspx_data_source\n"
"{\n"
"declare data, drow any;\n"
"declare cols any;\n"
"declare colum vspx_column;\n"
"if (length (self.ds_row_data) <= row)\n"
"return;\n"
"data := self.ds_row_data;\n"
"drow := data[row];\n"
"cols := self.ds_columns;\n"
"if (length (cols) <= col)\n"
"return;\n"
"colum := cols[col];\n"
"aset (drow, colum.ufl_col_offs, value);\n"
"aset (data, row, drow);\n"
"if (self.ds_rb_data is null) self.ds_rb_data := self.ds_row_data;\n"
"self.ds_row_data := data;\n"
"}\n";

static const char *other126 = 
"create method set_item_value (in col varchar, in value any) for vspx_data_source\n"
"{\n"
"declare row int;\n"
"declare data, drow any;\n"
"declare colum vspx_column;\n"
"declare i, l int;\n"
"\n"
"row := self.ds_update_inx;\n"
"i := 0; l := length (self.ds_columns);\n"
"while (i < l)\n"
"{\n"
"colum := self.ds_columns[i];\n"
"if (colum.ufl_column = col)\n"
"goto endf;\n"
"i := i + 1;\n"
"}\n"
"signal (\'22003\', \'Non-existing column\');\n"
"endf:;\n"
"data := self.ds_row_data;\n"
"drow := data[row];\n"
"aset (drow, colum.ufl_col_offs, value);\n"
"aset (data, row, drow);\n"
"if (self.ds_rb_data is null) self.ds_rb_data := self.ds_row_data;\n"
"self.ds_row_data := data;\n"
"}\n";

static const char *other127 = 
"create method get_item_value (in row any, in col any) for vspx_data_source\n"
"{\n"
"declare colum vspx_column;\n"
"declare exit handler for sqlstate \'22003\' { return \'out-of-index\'; };\n"
"colum := self.ds_columns[col];\n"
"return self.ds_row_data[row][colum.ufl_col_offs];\n"
"}\n";

static const char *other128 = 
"create method get_rb_item_value (in row any, in col any) for vspx_data_source\n"
"{\n"
"declare colum vspx_column;\n"
"if (self.ds_rb_data is null)\n"
"return null;\n"
"declare exit handler for sqlstate \'22003\' { return \'out-of-index\'; };\n"
"colum := self.ds_columns[col];\n"
"return self.ds_rb_data[row][colum.ufl_col_offs];\n"
"}\n";

static const char *other129 = 
"create method get_item_value (in col any) for vspx_data_source\n"
"{\n"
"declare colum vspx_column;\n"
"declare exit handler for sqlstate \'22003\' { return \'\'; };\n"
"colum := self.ds_columns[col];\n"
"return self.ds_row_data[self.get_current_row ()][colum.ufl_col_offs];\n"
"}\n";

static const char *other130 = 
"create method get_item_value (in col varchar) for vspx_data_source\n"
"{\n"
"declare colum vspx_column;\n"
"declare i, l int;\n"
"declare exit handler for sqlstate \'22003\' { return \'\'; };\n"
"i := 0; l := length (self.ds_columns);\n"
"while (i < l)\n"
"{\n"
"colum := self.ds_columns[i];\n"
"if (colum.ufl_column = col)\n"
"goto endf;\n"
"i := i + 1;\n"
"}\n"
"signal (\'22003\', \'Non-existing column\');\n"
"endf:;\n"
"return self.ds_row_data[self.get_current_row ()][colum.ufl_col_offs];\n"
"}\n";

static const char *other131 = 
"create method set_expression (in expression varchar) for vspx_data_source\n"
"{\n"
"self.ds_sql := expression;\n"
"}\n";

static const char *other132 = 
"create method get_expression () for vspx_data_source\n"
"{\n"
"return self.ds_sql;\n"
"}\n";

static const char *other133 = 
"create method set_expression_type (in type varchar) for vspx_data_source\n"
"{\n"
"if (lower(type) not in (\'sql\', \'procedure\', \'table\'))\n"
"signal (\'22023\', \'Bad type of sql expression fo data-source\');\n"
"self.ds_sql_type := lower(type);\n"
"}\n";

static const char *other134 = 
"create method get_expression_type () for vspx_data_source\n"
"{\n"
"return self.ds_sql_type;\n"
"}\n";

static const char *other135 = 
"create method vc_templates_clean () for vspx_data_set\n"
"{\n"
"declare i, l int;\n"
"declare chils any;\n"
"chils := self.vc_children;\n"
"i := 0; l := length (chils);\n"
"while (i < l)\n"
"{\n"
"declare chil any;\n"
"chil := chils[i];\n"
"if (chil is not null and udt_instance_of (chil, fix_identifier_case (\'vspx_row_template\')))\n"
"{\n"
"\n"
"aset (chils, i, NULL);\n"
"}\n"
"i := i + 1;\n"
"}\n"
"self.vc_children := chils;\n"
"}\n";

static const char *other136 = 
"create method vc_reset () for vspx_data_set\n"
"{\n"
"self.ds_prev_bookmark := null;\n"
"self.ds_last_bookmark := null;\n"
"self.ds_rows_offs := 0;\n"
"}\n";

static const char *other137 = 
"create method ds_column_offset (in name varchar) for vspx_data_set\n"
"{\n"
"if (self.ds_data_source is null)\n"
"return (position (name, self.ds_row_meta) - 1);\n"
"else\n"
"{\n"
"declare i, l int;\n"
"i := 0; l := length (self.ds_row_meta);\n"
"while (i < l)\n"
"{\n"
"declare elm any;\n"
"elm := self.ds_row_meta[i];\n"
"if (isarray (elm) and length (elm) and elm[0] = name)\n"
"return i;\n"
"i := i + 1;\n"
"}\n"
"}\n"
"}\n";

static const char *other138 = 
"create method ds_iterate_rows (inout inx int) for vspx_data_set\n"
"{\n"
"declare i, l int;\n"
"declare chil vspx_control;\n"
"declare c any;\n"
"i := inx;\n"
"c := self.vc_children;\n"
"l := length (c);\n"
"chil := null;\n"
"while (i < l)\n"
"{\n"
"chil := c[i];\n"
"if (chil is not null and udt_instance_of (chil, fix_identifier_case (\'vspx_row_template\')))\n"
"{\n"
"inx := i + 1;\n"
"return chil;\n"
"}\n"
"else\n"
"chil := null;\n"
"i := i + 1;\n"
"}\n"
"inx := l;\n"
"return chil;\n"
"}\n";

static const char *other139 = 
"create method vc_choose_selected () for vspx_radio_group\n"
"{\n"
"declare i, l int;\n"
"i := 0; l := length (self.vc_children);\n"
"while (i < l)\n"
"{\n"
"declare chil any;\n"
"chil := self.vc_children[i];\n"
"if (chil is not null and udt_instance_of (chil, fix_identifier_case (\'vspx_radio_button\')))\n"
"{\n"
"if ((chil as vspx_field).ufl_value = self.ufl_value)\n"
"(chil as vspx_field).ufl_selected := 1;\n"
"else\n"
"(chil as vspx_field).ufl_selected := 0;\n"
"}\n"
"i := i + 1;\n"
"}\n"
"}\n";

static const char *other140 = 
"create method vc_push_in_state (inout stream any, inout state any) for vspx_control\n"
"{\n"
"declare nam varchar;\n"
"nam := self.vc_get_name ();\n"
"if (not position (nam, stream))\n"
"stream := vector_concat (stream, vector (nam, null));\n"
"aset (stream, position (nam, stream), case when isblob (state) then blob_to_string (state) else state end);\n"
"return;\n"
"}\n";

static const char *other141 = 
"create method vc_push_in_stream (inout stream any, inout state any, inout n int) for vspx_control\n"
"{\n"
"declare nam varchar;\n"
"nam := self.vc_get_name ();\n"
"http (serialize (nam), stream);\n"
"http (serialize (case when isblob (state) then blob_to_string (state) else state end), stream);\n"
"n := n + 2;\n"
"return;\n"
"}\n";

static const char *other142 = 
"create method vc_get_control_state (in def any) for vspx_control\n"
"{\n"
"declare stream, nam any;\n"
"nam := self.vc_get_name ();\n"
"stream := coalesce (self.vc_page.vc_view_state, vector ());\n"
"return get_keyword (nam, stream, def);\n"
"}\n";

static const char *other143 = 
"create method vc_set_control_state (inout state any) for vspx_control\n"
"{\n"
"declare stream any;\n"
"stream := self.vc_page.vc_view_state;\n"
"self.vc_push_in_state (stream, state);\n"
"self.vc_page.vc_view_state := stream;\n"
"}\n";

static const char *other144 = 
"create method vc_view_state (inout stream any, inout n int) for vspx_data_set\n"
"{\n"
"declare state, flds any;\n"
"flds :=  vector (serialize(self.ds_last_bookmark), serialize (self.ds_prev_bookmark), self.ds_rows_fetched, self.ds_rowno_edit, self.vc_enabled, self.ds_editable, self.ds_rows_offs);\n"
"self.vc_push_in_stream (stream, flds, n);\n"
"return;\n"
"}\n";

static const char *udt38 = 
"create type vspx_data_grid under vspx_form\n"
"as (\n"
"dg_nrows int default -1,\n"
"dg_scrollable int default 0,\n"
"dg_editable int default 1,\n"
"dg_row_meta any,\n"
"dg_row_data any,\n"
"dg_current_row vspx_row_template,\n"
"dg_rowno_edit int default null,\n"
"dg_rows_fetched int default 0,\n"
"dg_prev_bookmark any default null,\n"
"dg_last_bookmark any default null\n"
")  temporary self as ref\n"
"method vc_templates_clean () returns any,\n"
"constructor method vspx_data_grid (name varchar, parent vspx_control),\n"
"overriding method vc_set_view_state (e vspx_event) returns any,\n"
"overriding method vc_view_state (stream any, n int) returns any\n";

static const char *udt39 = 
"create type vspx_select_list under vspx_field\n"
"as (\n"
"vsl_items any,\n"
"vsl_item_values any,\n"
"vsl_selected_inx any default null,\n"
"vsl_change_script int default 0,\n"
"vsl_list_document any default null,\n"
"vsl_list_match varchar default null,\n"
"vsl_list_key_path varchar default null,\n"
"vsl_list_value_path varchar default null,\n"
"vsl_multiple int default 0\n"
")\n"
"temporary self as ref\n"
"overriding method vc_render () returns any,\n"
"overriding method vc_view_state (stream any, n int) returns any,\n"
"overriding method vc_set_view_state (e vspx_event) returns any,\n"
"overriding method vc_set_model () returns any,\n"
"overriding method vc_xrender () returns any,\n"
"method vs_set_selected () returns any,\n"
"constructor method vspx_select_list (name varchar, parent vspx_control)\n";

static const char *udt40 = 
"create type vspx_data_list under vspx_select_list temporary self as ref\n"
"constructor method vspx_data_list (name varchar, parent vspx_control)\n";

static const char *udt41 = 
"create type vspx_login under vspx_form\n"
"as (\n"
"vl_realm varchar,\n"
"vl_mode varchar,\n"
"vl_pwd_get varchar,\n"
"vl_usr_check varchar,\n"
"vl_authenticated int default 0,\n"
"vl_user varchar,\n"
"vl_sid varchar,\n"
"vl_no_login_redirect varchar,\n"
"vl_logout_in_progress int default 0\n"
")\n"
"temporary self as ref\n"
"overriding method vc_view_state (stream any, n int) returns any,\n"
"overriding method vc_set_view_state (e vspx_event) returns any,\n"
"constructor method vspx_login (name varchar, parent vspx_control)\n";

static const char *udt42 = 
"create type vspx_browse_button under vspx_button\n"
"as\n"
"(\n"
"vcb_selector varchar,\n"
"vcb_chil_options varchar default \'\',\n"
"vcb_browser_options varchar default \'\',\n"
"vcb_fields any,\n"
"vcb_ref_fields any,\n"
"vcb_params any default null,\n"
"vcb_browser_mode varchar default \'RES\',\n"
"vcb_list_mode integer default \'1\',\n"
"vcb_system varchar default \'\',\n"
"vcb_xfer varchar default \'DOM\',\n"
"vcb_current integer default 0,\n"
"vcb_filter varchar default \'*\'\n"
")\n"
"temporary self as ref\n"
"constructor method vspx_browse_button (name varchar, parent vspx_control),\n"
"overriding method vc_render () returns any\n";

static const char *udt43 = 
"create type vspx_tree under vspx_control\n"
"as\n"
"(\n"
"vt_current_node int default -1,\n"
"vt_node any default null,\n"
"vt_open_at varchar default null,\n"
"vt_xpath_id varchar default null\n"
")\n"
"temporary self as ref\n"
"overriding method vc_view_state (stream any, n int) returns any,\n"
"method vc_get_state () returns any,\n"
"method vc_open_at (path varchar) returns any,\n"
"constructor method vspx_tree (name varchar, parent vspx_control)\n";

static const char *udt44 = 
"create type vspx_tree_node under vspx_control\n"
"as\n"
"(\n"
"tn_tree vspx_tree default null,\n"
"tn_open int default 0,\n"
"tn_value varchar,\n"
"tn_element any default null,\n"
"tn_level int default 0,\n"
"tn_position int default 0,\n"
"tn_is_leaf int default 0\n"
")\n"
"temporary self as ref\n"
"method vc_close_all_childs () returns any,\n"
"method vc_get_state (stream any) returns any,\n"
"constructor method vspx_tree_node (name varchar, parent vspx_control, leaf int, ctr int, lev int)\n";

static const char *udt45 = 
"create type vspx_vscx under vspx_form\n"
"self as ref temporary\n"
"constructor method vspx_vscx (name varchar, parent vspx_control, uri varchar),\n"
"overriding method vc_pre_render (stream any, n int) returns any\n";

static const char *other145 = 
"create method vc_pre_render (inout stream any, inout n int) for vspx_vscx\n"
"{\n"
"declare tmp, ss, icnt any;\n"
"declare page vspx_page;\n"
"declare id varchar;\n"
"\n"
"id := self.vc_get_name ();\n"
"\n"
"page := self.vc_children[0];\n"
"ss := string_output ();\n"
"icnt := 0;\n"
"page.vc_pre_render (ss, icnt);\n"
"page.vc_state_deserialize (ss, icnt);\n"
"\n"
"self.vc_push_in_stream (stream, vspx_state_serialize (vspx_do_compact (page.vc_view_state)), n);\n"
"\n"
"return;\n"
"}\n";

static const char *proc171 = 
"#line 1873 \"[executable]/vspx.sql\"\n"
" create procedure vspx_state_serialize (inout state any)\n"
"{\n"
"return encode_base64 (serialize (state));\n"
"\n"
"}\n"
"--src vspx.sql:1871\n"
;

static const char *proc172 = 
"#line 1881 \"[executable]/vspx.sql\"\n"
" create procedure vspx_state_deserialize (inout state any)\n"
"{\n"
"return deserialize (decode_base64 (state));\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"--src vspx.sql:1879\n"
;

static const char *other146 = 
"create constructor method vspx_vscx (in name varchar, in parent vspx_control, in uri varchar)\n"
"for vspx_vscx\n"
"{\n"
"declare h, vx any;\n"
"declare thispage, page vspx_page;\n"
"declare resource_name, vspxm_name, sql_name, signature,\n"
"vspx_dbname, vspx_user, class_name, full_class_name, q_full_class_name, stat, msg varchar;\n"
"declare unlink int;\n"
"declare path, params, lines, inner_state, enc_inner any;\n"
"declare id varchar;\n"
"\n"
"uri := WS.WS.EXPAND_URL (http_physical_path (), uri);\n"
"\n"
"\n"
"\n"
"vspx_get_user_info (vspx_dbname, vspx_user);\n"
"resource_name := uri;\n"
"\n"
"class_name := vspx_get_class_name (resource_name);\n"
"full_class_name := concat (vspx_dbname, \'.\', vspx_user, \'.\', class_name);\n"
"q_full_class_name := concat (\'\"\',vspx_dbname, \'\".\"\', vspx_user, \'\".\', class_name);\n"
"signature := vspx_get_signature (vspx_dbname, vspx_user, resource_name);\n"
"\n"
"if (not udt_is_available (full_class_name) or (registry_get (resource_name) <> signature))\n"
"{\n"
"stat := \'00000\'; msg := \'\';\n"
"exec (concat (\'drop type \', q_full_class_name), stat, msg);\n"
"unlink := vspx_make_temp_names (resource_name, vspxm_name, sql_name);\n"
"vspx_make_sql (vspx_dbname, vspx_user, resource_name, vspxm_name, sql_name, class_name);\n"
"vspx_load_sql (vspx_dbname, vspx_user, resource_name, sql_name);\n"
"registry_set (resource_name, signature);\n"
"if (unlink)\n"
"{\n"
"file_delete (vspxm_name, 1);\n"
"file_delete (vspxm_name||\'0\', 1);\n"
"file_delete (sql_name, 1);\n"
"}\n"
"log_enable (0, 1);\n"
"exec (sprintf (\'grant execute on %s to \"%s\"\', q_full_class_name, vspx_user));\n"
"commit work;\n"
"log_enable (1, 1);\n"
"}\n"
"\n"
"self.vc_init (name, parent);\n"
"self.vc_have_state := 1;\n"
"id := self.vc_get_name ();\n"
"\n"
"thispage := parent.vc_page;\n"
"path := thispage.vc_event.ve_path;\n"
"params := thispage.vc_event.ve_params;\n"
"lines := thispage.vc_event.ve_lines;\n"
"inner_state := get_keyword (id, thispage.vc_view_state);\n"
"enc_inner := vector (concat (class_name, \'_view_state\'), inner_state);\n"
"params := vector_concat (params, enc_inner);\n"
"\n"
"page := __udt_instantiate_class (full_class_name, 0);\n"
"page.vc_inside_form := 1;\n"
"\n"
"\n"
"if (self.vc_inx is null)\n"
"{\n"
"thispage.vc_current_id := thispage.vc_current_id + 1;\n"
"page.vc_inx := thispage.vc_current_id;\n"
"}\n"
"else\n"
"page.vc_inx := self.vc_inx;\n"
"page.vc_parent := self;\n"
"page.vc_instance_name := id;\n"
"\n"
"self.vc_children := vector (page);\n"
"vx := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (vx)\n"
"{\n"
"call (vx) (parent.vc_page, self, parent);\n"
"}\n"
"\n"
"h := udt_implements_method (page, class_name, 1);\n"
"call (h) (page, path, params, lines);\n"
"}\n";

static const char *other147 = 
"create constructor method vspx_tree_node (in name varchar, inout parent vspx_control, in leaf int, in ctr int, in lev int) for vspx_tree_node\n"
"{\n"
"\n"
"self.tn_is_leaf := leaf;\n"
"self.tn_level := lev;\n"
"self.tn_position := ctr;\n"
"self.vc_inx := ctr;\n"
"self.vc_level := lev;\n"
"self.vc_init (name, parent);\n"
"self.vc_repeater := self;\n"
"if (parent is not null and udt_instance_of (parent, fix_identifier_case (\'vspx_tree\')))\n"
"self.tn_tree := parent;\n"
"else if (parent is not null and udt_instance_of (parent, fix_identifier_case (\'vspx_tree_node\')))\n"
"self.tn_tree := (parent as vspx_tree_node).tn_tree;\n"
"}\n";

static const char *other148 = 
"create constructor method vspx_row_template (in name varchar, inout rowset any, inout parent vspx_control, inout ctr int) for vspx_row_template\n"
"{\n"
"declare childs any;\n"
"self.vc_inx := ctr;\n"
"self.vc_init (name, parent);\n"
"self.te_ctr := ctr;\n"
"self.te_rowset := rowset;\n"
"\n"
"childs := parent.vc_children;\n"
"if (childs is not null)\n"
"childs := vector_concat (childs, vector (self));\n"
"else\n"
"childs := vector (self);\n"
"parent.vc_children := childs;\n"
"}\n";

static const char *other149 = 
"create constructor method vspx_row_template_fast (in name varchar, inout rowset any, inout parent vspx_control, inout ctr int, in nth int) for vspx_row_template\n"
"{\n"
"declare childs any;\n"
"self.vc_inx := ctr;\n"
"self.vc_init (name, parent);\n"
"self.te_ctr := ctr;\n"
"self.te_rowset := rowset;\n"
"}\n";

static const char *other150 = 
"create method te_column_value (in name varchar) for vspx_row_template\n"
"{\n"
"declare ds vspx_data_set;\n"
"declare i int;\n"
"ds := self.vc_parent;\n"
"i := ds.ds_column_offset (name);\n"
"if (i >= 0 and i < length (self.te_rowset))\n"
"return self.te_rowset [i];\n"
"else\n"
"return null;\n"
"}\n";

static const char *other151 = 
"create constructor method vspx_control (in name varchar, inout parent vspx_control) for vspx_control\n"
"{\n"
"declare childs any;\n"
"self.vc_init (name, parent);\n"
"}\n";

static const char *other152 = 
"create constructor method vspx_tree (in name varchar, inout parent vspx_control) for vspx_tree\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"self.vc_have_state := 1;\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other153 = 
"create constructor method vspx_radio_group (in name varchar, inout parent vspx_control) for vspx_radio_group\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other154 = 
"create constructor method vspx_isql (in name varchar, inout parent vspx_control) for vspx_isql\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"\n"
"}\n";

static const char *other155 = 
"create method isql_exec () for vspx_isql\n"
"{\n"
"declare err_sqlstate, commit_err_sqlstate, err_msg, commit_err_msg varchar;\n"
"declare m_dta, result any;\n"
"declare _maxres, stmt_text varchar;\n"
"declare parsed_text any;\n"
"\n"
"self.vc_error_message := vector();\n"
"self.isql_mtd := vector();\n"
"self.isql_res := vector();\n"
"\n"
"_maxres := self.isql_maxrows;\n"
"stmt_text := self.isql_text;\n"
"\n"
"if( length(stmt_text) = 0 )\n"
"return;\n"
"\n"
"commit_err_sqlstate := \'00000\';\n"
"\n"
"commit work;\n"
"\n"
"whenever sqlstate \'*\' goto text_split_error;\n"
"\n"
"parsed_text := sql_split_text (self.isql_text);\n"
"goto text_split_complete;\n"
"\n"
"text_split_error:\n"
"self.vc_error_message := vector_concat( self.vc_error_message, vector(vector(__SQL_STATE, __SQL_MESSAGE)) );\n"
"self.isql_mtd := vector_concat( self.isql_mtd, vector(0) );\n"
"self.isql_res := vector_concat( self.isql_res, vector(vector()) );\n"
"self.isql_stmts := vector_concat(self.isql_stmts, vector (self.isql_text));\n"
"return;\n"
"\n"
"text_split_complete:\n"
"whenever not found goto run_error;\n"
"whenever sqlstate \'*\' goto run_error;\n"
"\n"
"set isolation=self.isql_isolation;\n"
"\n"
"if (exists (select 1 from db.dba.sys_users where u_name = self.isql_user and u_sql_enable = 1))\n"
"{\n"
"if (exists( select 1 from db.dba.sys_users where U_NAME = connection_get (\'vspx_user\') and\n"
"(U_ID = 0 or U_GROUP = 0) ) )\n"
"__set_user_id (self.isql_user, 1);\n"
"else\n"
"__set_user_id (self.isql_user, 1, coalesce (self.isql_password, \'\'));\n"
"\n"
"}\n"
"else\n"
"{\n"
"__set_user_id (connection_get (\'vspx_user\'), 1);\n"
"\n"
"}\n"
"\n"
"declare i int;\n"
"i := 0;\n"
"while( i < length(parsed_text) ) {\n"
"\n"
"err_sqlstate := \'00000\'; err_msg := \'\';\n"
"\n"
"result := null;\n"
"if( self.isql_explain )\n"
"exec ( \'explain(?)\', err_sqlstate, err_msg, vector(parsed_text[i]), _maxres, m_dta, result);\n"
"else\n"
"{\n"
"commit work;\n"
"m_dta := 0;\n"
"if (self.isql_chunked)\n"
"{\n"
"exec_metadata (parsed_text[i], err_sqlstate, err_msg, m_dta);\n"
"if (err_sqlstate = \'00000\' and\n"
"regexp_match (\'^([[:space:]]*)[Uu][Ss][Ee]([[:space:]]*)([[:alnum:]]*)\', parsed_text[i]) is not null)\n"
"exec (parsed_text[i], err_sqlstate, err_msg);\n"
"}\n"
"else\n"
"exec ( parsed_text[i], err_sqlstate, err_msg, vector(), _maxres, m_dta, result);\n"
"}\n"
"if( err_sqlstate <> \'00000\' )\n"
"{\n"
"err_msg := err_msg || \'\\n\' || parsed_text[i];\n"
"rollback work;\n"
"}\n"
"self.vc_error_message := vector_concat( self.vc_error_message, vector(vector(err_sqlstate,err_msg)) );\n"
"self.isql_mtd := vector_concat( self.isql_mtd, vector(m_dta) );\n"
"self.isql_res := vector_concat( self.isql_res, vector(result) );\n"
"\n"
"if (self.isql_chunked)\n"
"{\n"
"declare stmt any;\n"
"stmt := parsed_text[i];\n"
"if (self.isql_explain)\n"
"{\n"
"stmt := concat (\'explain(\', WS.WS.STR_SQL_APOS(stmt), \')\');\n"
"}\n"
"self.isql_stmts := vector_concat(self.isql_stmts, vector (stmt));\n"
"}\n"
"i := i+1;\n"
"}\n"
"exec (\'commit work\', commit_err_sqlstate, commit_err_msg);\n"
"set isolation=\'committed\';\n"
"return;\n"
"\n"
"run_error:\n"
"self.vc_error_message := vector_concat( self.vc_error_message, vector(vector(__sql_state,__sql_message)) );\n"
"self.isql_mtd := vector_concat( self.isql_mtd, vector(0) );\n"
"self.isql_res := vector_concat( self.isql_res, vector(vector()) );\n"
"self.isql_stmts := vector_concat(self.isql_stmts, vector (self.isql_text));\n"
"set isolation=\'committed\';\n"
"rollback work;\n"
"return;\n"
"}\n";

static const char *proc173 = 
"#line 2195 \"[executable]/vspx.sql\"\n"
"create procedure\n"
"vspx_unqualify (in name varchar)\n"
"{\n"
"declare name_str varchar;\n"
"\n"
"if (not isstring (name))\n"
"{\n"
"name_str := cast (name as varchar);\n"
"}\n"
"else\n"
"{\n"
"name_str := name;\n"
"}\n"
"return (subseq (name_str, coalesce (strrchr (name_str, \'.\') + 1, 0)));\n"
"}\n"
"--src vspx.sql:2193\n"
;

static const char *proc174 = 
"#line 2212 \"[executable]/vspx.sql\"\n"
"create procedure\n"
"vspx_result_tbl_hdrs (in m_dta any)\n"
"{\n"
"\n"
"declare m_dta_col varchar;\n"
"declare inx, n_cols integer;\n"
"declare col_names varchar;\n"
"\n"
"if (not isarray (m_dta[0]))\n"
"return;\n"
"\n"
"n_cols := length (m_dta[0]);\n"
"\n"
"while (inx < n_cols)\n"
"{\n"
"m_dta_col := m_dta[0][inx];\n"
"\n"
"http (\'<td class=\"resheader\"><SPAN class=\"rescolname\">\');\n"
"col_names := m_dta_col[0];\n"
"\n"
"http_value (vspx_unqualify (col_names));\n"
"\n"
"http (\'</span><br/><span class=\"rescoltype\">\');\n"
"http (dv_type_title (m_dta_col[1]));\n"
"http (\'</span></td>\\n\');\n"
"\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"--src vspx.sql:2210\n"
;

static const char *proc175 = 
"#line 2244 \"[executable]/vspx.sql\"\n"
"create procedure\n"
"vspx_result_row_render (in result any, in m_dta any, in inx int := 0, in cset varchar := \'UTF-8\')\n"
"{\n"
"declare jnx integer;\n"
"declare res_row varchar;\n"
"declare res_col varchar;\n"
"declare res_cols, n_cols integer;\n"
"declare res_len integer;\n"
"declare dt_nfo any;\n"
"declare col_type integer;\n"
"\n"
"n_cols := length (aref (m_dta, 0));\n"
"dt_nfo := aref(m_dta, 0);\n"
"\n"
"http (sprintf (\'<tr class=\"%s\">\', case when mod(inx, 2) then \'resrowodd\' else \'resroweven\' end));\n"
"\n"
"res_row := result;\n"
"res_cols := length (res_row);\n"
"\n"
"jnx := 0;\n"
"\n"
"\n"
"while (jnx < res_cols)\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"http (\'Can\\\'t display result\');\n"
"goto next;\n"
"};\n"
"http (\'<td class=\"resdata\"> &nbsp;\');\n"
"res_col := aref (res_row, jnx);\n"
"col_type := aref (aref (dt_nfo, jnx), 1);\n"
"again:\n"
"if (__tag (res_col) = 193)\n"
"http_value (concat (\'(\', vector_print (res_col), \')\'));\n"
"else if (__tag (res_col) = 230 and res_col is not null)\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"http_value (res_col, NULL, ses);\n"
"http_value (string_output_string (ses));\n"
"}\n"
"else if (__tag (res_col) = 246 and res_col is not null)\n"
"{\n"
"declare dat any;\n"
"dat := __rdf_sqlval_of_obj (res_col, 1);\n"
"res_col := dat;\n"
"goto again;\n"
"}\n"
"else\n"
"{\n"
"declare res any; \n"
"res := 0;\n"
"if (__tag (res_col) = 182 and cset is not null)\n"
"res := charset_recode (res_col, cset, \'_WIDE_\');\n"
"if (res <> 0)\n"
"res_col := res;		\n"
"http_value (coalesce (res_col, \'<DB NULL>\'));\n"
"}\n"
"next:\n"
"http (\'</td>\');\n"
"jnx := jnx + 1;\n"
"}\n"
"http (\'</tr>\\n\');\n"
"}\n"
"--src vspx.sql:2242\n"
;

static const char *other156 = 
"create constructor method vspx_field_value (in name varchar, inout parent vspx_control) for vspx_field_value\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other157 = 
"create constructor method vspx_field (in name varchar, inout parent vspx_control) for vspx_field\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other158 = 
"create constructor method vspx_column (in col varchar, in label varchar, in infmt varchar, in outfmt varchar, inout parent vspx_control) for vspx_column\n"
"{\n"
"self.vc_init (parent.vc_name || \'_\' || col, parent);\n"
"self.ufl_column := col;\n"
"self.ufl_fmt_fn := outfmt;\n"
"self.ufl_cvt_fn := infmt;\n"
"self.ufl_col_label := label;\n"
"}\n";

static const char *other159 = 
"create constructor method vspx_calendar (in name varchar, inout parent vspx_control) for vspx_calendar\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"self.vc_have_state := 1;\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other160 = 
"create method vc_view_state (inout stream any, inout n int) for vspx_calendar\n"
"{\n"
"declare state any;\n"
"self.vc_push_in_stream (stream, self.cal_date, n);\n"
"return;\n"
"}\n";

static const char *other161 = 
"create method\n"
"vc_get_date_array () for vspx_calendar\n"
"{\n"
"declare i, l int;\n"
"declare m, y, w, d int;\n"
"declare dw int;\n"
"declare arr, res any;\n"
"declare dt date;\n"
"\n"
"dt := self.cal_date;\n"
"\n"
"arr := vector (\'\',\'\',\'\',\'\',\'\',\'\',\'\');\n"
"i := 0;\n"
"m := month (dt);\n"
"y := year (dt);\n"
"\n"
"res := vector ();\n"
"for (i := 1; i < 32; i := i + 1)\n"
"{\n"
"declare tmp date;\n"
"whenever sqlstate \'*\' goto next;\n"
"tmp := stringdate (sprintf (\'%d-%d-%d\', y, m, i));\n"
"if (i > 1 and dayofmonth (tmp) = 1)\n"
"goto endd;\n"
"dw := dayofweek(tmp);\n"
"aset (arr, dw - 1, cast (i as varchar));\n"
"if (0 = mod (dw, 7))\n"
"{\n"
"res := vector_concat (res, vector (arr));\n"
"arr := vector (\'\',\'\',\'\',\'\',\'\',\'\',\'\');\n"
"}\n"
"next:;\n"
"}\n"
"endd:\n"
"res := vector_concat (res, vector (arr));\n"
"return res;\n"
"}\n";

static const char *other162 = 
"create constructor method vspx_update_field (in name varchar, inout parent vspx_control) for vspx_update_field\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"self.vc_have_state := 1;\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other163 = 
"create constructor method vspx_tab (in name varchar, inout parent vspx_control) for vspx_tab\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"self.vc_have_state := 1;\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other164 = 
"create constructor method vspx_login (in name varchar, inout parent vspx_control) for vspx_login\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"self.vc_have_state := 1;\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other165 = 
"create constructor method vspx_update_form (in name varchar, inout parent vspx_control) for vspx_update_form\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"self.vc_have_state := 1;\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other166 = 
"create constructor method vspx_form (in name varchar, inout parent vspx_control) for vspx_form\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other167 = 
"create constructor method vspx_template (in name varchar, inout parent vspx_control) for vspx_template\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other168 = 
"create constructor method vspx_text (in name varchar, inout parent vspx_control) for vspx_text\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"self.vc_have_state := 1;\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other169 = 
"create constructor method vspx_textarea (in name varchar, inout parent vspx_control) for vspx_textarea\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"self.vc_have_state := 1;\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other170 = 
"create constructor method vspx_button (in name varchar, inout parent vspx_control) for vspx_button\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other171 = 
"create constructor method vspx_radio_button (in name varchar, inout parent vspx_control) for vspx_radio_button\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"self.vc_have_state := 1;\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other172 = 
"create constructor method vspx_submit (in name varchar, inout parent vspx_control) for vspx_submit\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other173 = 
"create constructor method vspx_delete_button (in name varchar, in parent vspx_control) for vspx_delete_button\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other174 = 
"create constructor method vspx_return_button (in name varchar, in parent vspx_control) for vspx_return_button\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other175 = 
"create constructor method vspx_browse_button (in name varchar, in parent vspx_control) for vspx_browse_button\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other176 = 
"create constructor method vspx_data_grid (in name varchar, inout parent vspx_control) for vspx_data_grid\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"self.vc_have_state := 1;\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other177 = 
"create constructor method vspx_data_set (in name varchar, inout parent vspx_control) for vspx_data_set\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"self.vc_have_state := 1;\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other178 = 
"create constructor method vspx_data_source (in name varchar, inout parent vspx_control) for vspx_data_source\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other179 = 
"create constructor method vspx_label (in name varchar, inout parent vspx_control) for vspx_label\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other180 = 
"create constructor method vspx_check_box (in name varchar, inout parent vspx_control) for vspx_check_box\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"self.vc_have_state := 1;\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other181 = 
"create constructor method vspx_url (in name varchar, inout parent vspx_control) for vspx_url\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other182 = 
"create constructor method vspx_select_list (in name varchar, inout parent vspx_control) for vspx_select_list\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"self.vc_have_state := 1;\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other183 = 
"create constructor method vspx_data_list (in name varchar, inout parent vspx_control) for vspx_data_list\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"self.vc_have_state := 1;\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other184 = 
"create constructor method vspx_logout_button (in name varchar, inout parent vspx_control) for vspx_logout_button\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other185 = 
"create constructor method vspx_login_form (in name varchar, inout parent vspx_control) for vspx_login_form\n"
"{\n"
"declare h any;\n"
"self.vc_init (name, parent);\n"
"h := udt_implements_method (parent.vc_page, fix_identifier_case (concat (\'vc_init_\', name)));\n"
"if (h)\n"
"{\n"
"call (h) (parent.vc_page, self, parent);\n"
"return;\n"
"}\n"
"}\n";

static const char *other186 = 
"create constructor method vspx_login_form (in name varchar, in title varchar, in user_title varchar, in password_title varchar, in submit_tile varchar, in login vspx_login) for vspx_login_form\n"
"{\n"
"\n"
"declare usr, pwd vspx_text;\n"
"declare loginb vspx_button;\n"
"\n"
"self.vc_init (name, login);\n"
"\n"
"self.vlf_title := title;\n"
"self.vlf_user_title := user_title;\n"
"self.vlf_password_title := password_title;\n"
"self.vlf_submit_title := submit_tile;\n"
"self.vlf_login := login;\n"
"\n"
"self.vc_inside_form := 1;\n"
"\n"
"usr := vspx_text (\'username\', self);\n"
"pwd := vspx_text (\'password\', self);\n"
"pwd.tf_style := 1;\n"
"loginb := vspx_button (\'login\', self);\n"
"loginb.ufl_value := submit_tile;\n"
"\n"
"self.vc_children := vector (usr, pwd, loginb);\n"
"}\n";

static const char *other187 = 
"create method prologue_render (in sid varchar, in realm varchar, in nonce varchar) for vspx_form\n"
"{\n"
"if (self.vc_page.vc_browser_caps and self.uf_xmodel is not null)\n"
"{\n"
"declare model, submit, sch any;\n"
"declare inst, fmodel any;\n"
"declare xslt_text varchar;\n"
"\n"
"model := self.uf_xmodel;\n"
"fmodel := self.uf_xsubmit;\n"
"sch := self.uf_xschema;\n"
"\n"
"xte_nodebld_init (inst);\n"
"xte_nodebld_acc (model, xte_node (xte_head (\'sid\'), coalesce (sid, \'\')));\n"
"xte_nodebld_acc (model, xte_node (xte_head (\'realm\'), coalesce (realm, \'\')));\n"
"xte_nodebld_acc (model, xte_node (xte_head (sprintf (\'%s_view_state\', self.vc_page.vc_name)),\n"
"vspx_state_serialize (self.vc_page.vc_view_state)));\n"
"xte_nodebld_acc (model, xte_node (xte_head (\'event__target\'), \'\'));\n"
"xte_nodebld_final (model, xte_head (\'post\', \'xmlns\', \'http://www.openlinksw.com/vspx/xforms/\'));\n"
"if (sch is not null)\n"
"{\n"
"xte_nodebld_final (sch, xte_head (\'schema\', \'xmlns\', \'http://www.w3.org/2001/XMLSchema\',\n"
"\'targetNamespace\', \'http://www.openlinksw.com/virtuoso/vspx/xforms/types\'\n"
"\n"
"));\n"
"xte_nodebld_acc (fmodel, sch);\n"
"}\n"
"\n"
"xte_nodebld_acc (inst, model);\n"
"\n"
"xte_nodebld_final (inst, xte_head (\'instance\'));\n"
"xte_nodebld_acc (fmodel, inst);\n"
"\n"
"if (0 and sch is not null)\n"
"{\n"
"xte_nodebld_final (fmodel,\n"
"xte_head (\'model\', \'xmlns\', \'http://www.w3.org/2002/xforms\', \'id\',\n"
"self.vc_get_name (), \'schema\', \'#\' || self.vc_get_name () || \'_sch\'));\n"
"}\n"
"else\n"
"{\n"
"xte_nodebld_final (fmodel,\n"
"xte_head (\'model\', \'xmlns\', \'http://www.w3.org/2002/xforms\', \'id\', self.vc_get_name ()));\n"
"}\n"
"\n"
"fmodel := xte_expand_xmlns (fmodel);\n"
"fmodel := xml_tree_doc (fmodel);\n"
"\n"
"\n"
"\n"
"if (not xslt_is_sheet (\'__xforms_model\'))\n"
"{\n"
"xslt_text :=\n"
"\'<?xml version=\'\'1.0\'\'?>\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\"\n"
"xmlns:xforms=\"http://www.w3.org/2002/xforms\"\n"
"xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n"
"xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n"
"xmlns:vxf=\"http://www.openlinksw.com/vspx/xforms/\"\n"
"xmlns:vxt=\"http://www.openlinksw.com/virtuoso/vspx/xforms/types\"\n"
">\n"
"<xsl:output method=\"xml\" omit-xml-declaration=\"yes\" indent=\"yes\" />\n"
"<xsl:template match=\"/\">\n"
"<xsl:apply-templates />\n"
"</xsl:template>\n"
"<xsl:template match=\"@*|node()\" priority=\"0\">\n"
"<xsl:copy>\n"
"<xsl:apply-templates />\n"
"</xsl:copy>\n"
"</xsl:template>\n"
"</xsl:stylesheet>\';\n"
"xslt_sheet (\'__xforms_model\', xtree_doc (xslt_text, 0));\n"
"}\n"
"\n"
"fmodel := xslt (\'__xforms_model\', fmodel);\n"
"\n"
"\n"
"\n"
"http_value (fmodel);\n"
"}\n"
"\n"
"if (self.uf_action = \'\')\n"
"self.uf_action := http_path ();\n"
"if (not self.vc_inside_form)\n"
"{\n"
"if (self.vc_page.vc_browser_caps)\n"
"{\n"
"return;\n"
"}\n"
"http (sprintf (\'<form name=\"%s\" method=\"%s\" action=\"%s\"\',\n"
"self.vc_name, self.uf_method, self.uf_action));\n"
"vspx_print_html_attrs (self); http (\'>\\n\');\n"
"\n"
"http (sprintf (\'<input type=\"hidden\" name=\"%s_view_state\" value=\"%s\" />\\n\',\n"
"self.vc_page.vc_name, vspx_state_serialize (self.vc_page.vc_view_state)));\n"
"if (self.vc_page.vc_authentication_mode)\n"
"{\n"
"if (length (sid) > 0)\n"
"{\n"
"http (sprintf (\'<input type=\"hidden\" name=\"sid\" value=\"%s\" />\\n\', sid));\n"
"http (sprintf (\'<input type=\"hidden\" name=\"realm\" value=\"%s\" />\\n\', realm));\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'<input type=\"hidden\" name=\"nonce\" value=\"%s\" />\\n\', nonce));\n"
"}\n"
"}\n"
"http (\'<input type=\"hidden\" name=\"__submit_func\" value=\"\" />\\n\');\n"
"http (\'<input type=\"hidden\" name=\"__event_target\" value=\"\" />\\n\');\n"
"http (\'<input type=\"hidden\" name=\"__event_initiator\" value=\"\" />\\n\');\n"
"}\n"
"}\n";

static const char *proc176 = 
"#line 2882 \"[executable]/vspx.sql\"\n"
"create procedure vspx_xtext_node (in val any)\n"
"{\n"
"if (val is null)\n"
"return \'\';\n"
"else if (isstring (val))\n"
"return val;\n"
"else\n"
"return cast (val as varchar);\n"
"}\n"
"--src vspx.sql:2880\n"
;

static const char *other188 = 
"create method epilogue_render () for vspx_form\n"
"{\n"
"if (self.vc_page.vc_browser_caps)\n"
"return;\n"
"if (not self.vc_inside_form)\n"
"http (\'</form>\\n\');\n"
"}\n";

static const char *other189 = 
"create method vc_set_model () for vspx_form\n"
"{\n"
"declare model, submit any;\n"
"if (self.uf_action = \'\')\n"
"self.uf_action := http_path ();\n"
"xte_nodebld_init (model);\n"
"xte_nodebld_init (submit);\n"
"self.uf_xmodel := model;\n"
"self.uf_xsubmit := submit;\n"
"return;\n"
"}\n";

static const char *other190 = 
"create method vc_set_model () for vspx_text\n"
"{\n"
"if (self.vc_top_form is null or self.vc_top_form.uf_xmodel is null)\n"
"return;\n"
"\n"
"declare model, val, sch any;\n"
"\n"
"model := self.vc_top_form.uf_xmodel;\n"
"\n"
"val := self.ufl_value;\n"
"if (val is null)\n"
"val := self.vc_get_control_state (null);\n"
"if (val is null)\n"
"val := self.tf_default;\n"
"\n"
"if (length (self.ufl_validators))\n"
"{\n"
"declare nam varchar;\n"
"nam :=  self.vc_name || \'_t\';\n"
"sch := self.vc_top_form.uf_xschema;\n"
"self.ufl_schema (sch, nam);\n"
"self.vc_top_form.uf_xschema := sch;\n"
"xte_nodebld_acc (model,\n"
"xte_node (xte_head (self.vc_get_name (), \'http://www.w3.org/2001/XMLSchema-instance:type\',\n"
"\'http://www.openlinksw.com/virtuoso/vspx/xforms/types:\' || nam), vspx_xtext_node(val)));\n"
"}\n"
"else\n"
"{\n"
"xte_nodebld_acc (model,\n"
"xte_node (xte_head (self.vc_get_name ()), vspx_xtext_node (val)));\n"
"}\n"
"\n"
"self.vc_top_form.uf_xmodel := model;\n"
"\n"
"return;\n"
"}\n";

static const char *other191 = 
"create method vc_set_model () for vspx_select_list\n"
"{\n"
"if (self.vc_top_form is null or self.vc_top_form.uf_xmodel is null)\n"
"return;\n"
"\n"
"declare model, val any;\n"
"model := self.vc_top_form.uf_xmodel;\n"
"\n"
"if (not self.vsl_multiple)\n"
"val := self.ufl_value;\n"
"else\n"
"{\n"
"declare i, l int;\n"
"if (isarray (self.ufl_value))\n"
"{\n"
"i := 0; l := length (self.ufl_value);\n"
"val := \'\';\n"
"while (i < l)\n"
"{\n"
"val := val || self.ufl_value[i] || \' \';\n"
"i := i + 1;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"val := \'\';\n"
"}\n"
"}\n"
"\n"
"xte_nodebld_acc (model,\n"
"xte_node (xte_head (self.vc_get_name ()), vspx_xtext_node (val))\n"
");\n"
"\n"
"self.vc_top_form.uf_xmodel := model;\n"
"\n"
"return;\n"
"}\n";

static const char *other192 = 
"create method vc_set_model () for vspx_check_box\n"
"{\n"
"if (self.vc_top_form is null or self.vc_top_form.uf_xmodel is null)\n"
"return;\n"
"\n"
"declare model any;\n"
"model := self.vc_top_form.uf_xmodel;\n"
"\n"
"xte_nodebld_acc (model,\n"
"xte_node (xte_head (self.vc_get_name (), \'http://www.w3.org/2001/XMLSchema-instance:type\',\n"
"\'http://www.w3.org/2001/XMLSchema:boolean\'), vspx_xtext_node (self.ufl_value))\n"
");\n"
"\n"
"self.vc_top_form.uf_xmodel := model;\n"
"\n"
"return;\n"
"}\n";

static const char *other193 = 
"create method vc_set_model () for vspx_radio_button\n"
"{\n"
"if (self.vc_top_form is null or self.vc_top_form.uf_xmodel is null)\n"
"return;\n"
"\n"
"declare model any;\n"
"model := self.vc_top_form.uf_xmodel;\n"
"\n"
"xte_nodebld_acc (model,\n"
"xte_node (xte_head (self.vc_get_name ()), vspx_xtext_node (self.ufl_value))\n"
");\n"
"\n"
"self.vc_top_form.uf_xmodel := model;\n"
"\n"
"return;\n"
"}\n";

static const char *other194 = 
"create method vc_set_model () for vspx_radio_group\n"
"{\n"
"if (self.vc_top_form is null or self.vc_top_form.uf_xmodel is null)\n"
"return;\n"
"\n"
"declare model any;\n"
"model := self.vc_top_form.uf_xmodel;\n"
"\n"
"xte_nodebld_acc (model,\n"
"xte_node (xte_head (self.vc_get_name ()), vspx_xtext_node (self.ufl_value))\n"
");\n"
"\n"
"self.vc_top_form.uf_xmodel := model;\n"
"\n"
"return;\n"
"}\n";

static const char *other195 = 
"create method vc_set_model () for vspx_button\n"
"{\n"
"if (self.vc_top_form is null or self.vc_top_form.uf_xsubmit is null)\n"
"return;\n"
"\n"
"declare submit any;\n"
"\n"
"submit := self.vc_top_form.uf_xsubmit;\n"
"\n"
"xte_nodebld_acc (submit,\n"
"xte_node (xte_head (\'submission\', \'id\', self.vc_get_name (),\n"
"\'action\', self.vc_top_form.uf_action, \'method\', self.vc_top_form.uf_method,\n"
"\'mediatype\', \'application/xml\'))\n"
");\n"
"\n"
"self.vc_top_form.uf_xsubmit := submit;\n"
"\n"
"return;\n"
"}\n";

static const char *other196 = 
"create method vc_render () for vspx_label\n"
"{\n"
"if (not self.vc_enabled)\n"
"return;\n"
"if (self.ufl_value is not null)\n"
"http (sprintf (self.vl_format, self.ufl_value));\n"
"else if (self.ufl_null_value is not null)\n"
"http (self.ufl_null_value);\n"
"else\n"
"http (sprintf (\'%s\', null));\n"
"}\n";

static const char *other197 = 
"create method vs_set_selected () for vspx_select_list\n"
"{\n"
"declare val, ival any;\n"
"\n"
"val := self.ufl_value;\n"
"ival := self.vsl_item_values;\n"
"\n"
"if (self.vsl_multiple and not isstring (val) and isarray (val))\n"
"{\n"
"declare i, l int;\n"
"declare sel any;\n"
"i := 0; l := length (ival);\n"
"sel := make_array (l, \'any\');\n"
"while (i < l)\n"
"{\n"
"if (position (ival[i], val))\n"
"sel[i] := 1;\n"
"else\n"
"sel[i] := 0;\n"
"i := i + 1;\n"
"}\n"
"self.vsl_selected_inx := sel;\n"
"}\n"
"else\n"
"{\n"
"self.vsl_selected_inx := position (cast (self.ufl_value as varchar), self.vsl_item_values) - 1;\n"
"}\n"
"}\n";

static const char *proc177 = 
"#line 3119 \"[executable]/vspx.sql\"\n"
" create procedure\n"
"vspx_print_html_attrs (inout control vspx_control)\n"
"{\n"
"declare i, l int;\n"
"i := 0; l := length (control.vc_attributes);\n"
"\n"
"while (i < l)\n"
"{\n"
"declare attr vspx_attribute;\n"
"attr := control.vc_attributes[i];\n"
"if (attr is not null)\n"
"{\n"
"attr.vc_render ();\n"
"}\n"
"i := i + 1;\n"
"}\n"
"}\n"
"--src vspx.sql:3117\n"
;

static const char *other198 = 
"create method vc_render () for vspx_url\n"
"{\n"
"declare url varchar;\n"
"declare uinfo any;\n"
"if (not self.vc_enabled)\n"
"return;\n"
"uinfo := WS.WS.PARSE_URI (self.vu_url);\n"
"url := self.vu_url;\n"
"\n"
"\n"
"if ((uinfo[0] = \'\' or self.vu_is_local) and self.vu_l_pars <> \'\')\n"
"{\n"
"if (uinfo[4] = \'\')\n"
"url := vspx_uri_add_parameters (self.vu_url, self.vu_l_pars);\n"
"else\n"
"url := vspx_uri_add_parameters (self.vu_url, self.vu_l_pars);\n"
"}\n"
"http (sprintf (\'<a href=\"%V\"\', case when self.ufl_active > 0 then url else \'javascript:void(0)\' end));\n"
"vspx_print_html_attrs (self);\n"
"http(\'>\');\n"
"if (230 = __tag (self.ufl_value))\n"
"http (sprintf (self.vu_format, cast(self.ufl_value as varchar)));\n"
"else\n"
"http (sprintf (self.vu_format, self.ufl_value));\n"
"http(\'</a>\');\n"
"}\n";

static const char *other199 = 
"create method vc_render () for vspx_check_box\n"
"{\n"
"if (not self.vc_enabled)\n"
"return;\n"
"if (self.ufl_is_boolean)\n"
"self.vc_get_selected_from_value();\n"
"http (sprintf (\'<input type=\"checkbox\" name=\"%s%s\" value=\"%s\" %s %s\',\n"
"case self.ufl_group when \'\' then self.vc_get_name () else self.ufl_group end,\n"
"self.ufl_name_suffix,\n"
"case self.ufl_is_boolean when 0 then cast(self.ufl_value as varchar) else \'1\' end,\n"
"case self.ufl_selected when 1 then \'checked=\"checked\"\' else \'\' end,\n"
"case self.ufl_client_validate when 0 then \'\' else \' onchange=\"javascript: vv_validate_\' || self.vc_name || \'(this)\"\' end));\n"
"if (self.ufl_auto_submit) http (\' onclick=\"doAutoSubmit (this.form, this)\"\');\n"
"vspx_print_html_attrs (self);\n"
"http (\'/>\');\n"
"}\n";

static const char *other200 = 
"create method vc_view_state (inout stream any, inout n int) for vspx_check_box\n"
"{\n"
"if (self.ufl_is_boolean)\n"
"self.vc_get_selected_from_value ();\n"
"self.vc_push_in_stream (stream, self.ufl_selected, n);\n"
"return;\n"
"}\n";

static const char *other201 = 
"create method vc_view_state (inout stream any, inout n int) for vspx_radio_button\n"
"{\n"
"self.vc_push_in_stream (stream, self.ufl_selected, n);\n"
"return;\n"
"}\n";

static const char *other202 = 
"create method vc_set_view_state (inout e vspx_event) for vspx_check_box\n"
"{\n"
"if (not e.ve_is_post or not position (self.vc_get_name(), self.vc_page.vc_view_state))\n"
"{\n"
"return;\n"
"}\n"
"self.ufl_selected := self.vc_get_control_state (self.ufl_selected);\n"
"if (self.ufl_is_boolean)\n"
"self.ufl_value := case self.ufl_selected when 0 then self.ufl_false_value else self.ufl_true_value end;\n"
"return;\n"
"}\n";

static const char *other203 = 
"create method vc_set_view_state (inout e vspx_event) for vspx_radio_button\n"
"{\n"
"if (not e.ve_is_post or not position (self.vc_get_name(), self.vc_page.vc_view_state))\n"
"{\n"
"return;\n"
"}\n"
"self.ufl_selected := self.vc_get_control_state (self.ufl_selected);\n"
"return;\n"
"}\n";

static const char *other204 = 
"create method vc_view_state (inout stream any, inout n int) for vspx_text\n"
"{\n"
"declare state any;\n"
"self.vc_push_in_stream (stream, self.ufl_value, n);\n"
"return;\n"
"}\n";

static const char *other205 = 
"create method vc_set_view_state (inout e vspx_event) for vspx_text\n"
"{\n"
"if (not e.ve_is_post or not position (self.vc_get_name(), self.vc_page.vc_view_state)\n"
"\n"
")\n"
"{\n"
"return;\n"
"}\n"
"declare vst any;\n"
"vst := self.vc_get_control_state (null);\n"
"if (vst is not null)\n"
"self.ufl_value := vst;\n"
"return;\n"
"}\n";

static const char *other206 = 
"create method vc_set_view_state (inout e vspx_event) for vspx_data_grid\n"
"{\n"
"declare state any;\n"
"if (not e.ve_is_post)\n"
"return;\n"
"\n"
"state := self.vc_get_control_state (null);\n"
"if (isarray (state))\n"
"{\n"
"self.dg_rows_fetched  := state[2];\n"
"self.dg_last_bookmark := deserialize(state[0]);\n"
"self.dg_prev_bookmark := deserialize(state[1]);\n"
"self.dg_rowno_edit    := state[3];\n"
"self.vc_enabled       := state[4];\n"
"self.dg_editable      := state[5];\n"
"}\n"
"}\n";

static const char *other207 = 
"create method vc_set_view_state (inout e vspx_event) for vspx_data_set\n"
"{\n"
"declare state any;\n"
"if (not e.ve_is_post)\n"
"return;\n"
"state := self.vc_get_control_state (null);\n"
"if (isarray (state))\n"
"{\n"
"self.ds_rows_fetched := state[2];\n"
"self.ds_last_bookmark := deserialize(state[0]);\n"
"self.ds_prev_bookmark := deserialize(state[1]);\n"
"self.ds_rowno_edit := state[3];\n"
"self.vc_enabled := state[4];\n"
"self.ds_editable := state[5];\n"
"self.ds_rows_offs := state[6];\n"
"}\n"
"}\n";

static const char *other208 = 
"create method vc_set_view_state (inout e vspx_event) for vspx_update_form\n"
"{\n"
"if (not length (self.uf_keys))\n"
"{\n"
"declare keys any;\n"
"keys := self.vc_get_control_state (null);\n"
"self.uf_keys := keys;\n"
"}\n"
"}\n";

static const char *other209 = 
"create method vc_set_view_state (inout e vspx_event) for vspx_select_list\n"
"{\n"
"if (e.ve_is_post and self.vc_page.vc_view_state is not null)\n"
"{\n"
"self.ufl_value := self.vc_get_control_state (null);\n"
"}\n"
"}\n";

static const char *other210 = 
"create method vc_set_view_state (inout e vspx_event) for vspx_login\n"
"{\n"
"if (e.ve_is_post and self.vc_page.vc_view_state is not null)\n"
"{\n"
"declare state any;\n"
"state := self.vc_get_control_state (null);\n"
"if (state is not null)\n"
"{\n"
"self.vl_logout_in_progress := get_keyword (\'vl_logout_in_progress\', state, 0);\n"
"if (self.vl_mode in (\'url\', \'cookie\'))\n"
"self.vl_authenticated := get_keyword (\'vl_authenticated\', state, 0);\n"
"}\n"
"}\n"
"}\n";

static const char *other211 = 
"create method vc_set_view_state (inout e vspx_event) for vspx_calendar\n"
"{\n"
"if (e.ve_is_post and self.vc_page.vc_view_state is not null)\n"
"{\n"
"self.cal_date := self.vc_get_control_state (null);\n"
"}\n"
"}\n";

static const char *other212 = 
"create method vc_set_view_state (inout e vspx_event) for vspx_tab\n"
"{\n"
"if (e.ve_is_post and self.vc_page.vc_view_state is not null)\n"
"{\n"
"declare state any;\n"
"state := self.vc_get_control_state (null);\n"
"if (state is not null)\n"
"self.tb_active := self.vc_find_control (state);\n"
"}\n"
"}\n";

static const char *proc178 = 
"#line 3345 \"[executable]/vspx.sql\"\n"
"create function XMLS_VALUE_OF_SUBTREE (in _ent any, in _path varchar, in _params any, in _place varchar) returns any\n"
"{\n"
"\n"
"if (not isentity (_ent))\n"
"return _ent;\n"
"if (_path is not null)\n"
"{\n"
"_ent := xquery_eval (_path, _ent, 1, _params);\n"
"if (_ent is null)\n"
"return null;\n"
"}\n"
"if (_place is not null)\n"
"{\n"
"if (not isentity (_ent))\n"
"signal (\'22023\', sprintf (\'Unable to apply place=\'\'%s\'\' to a non-XML value\', _place));\n"
"if (_place = \'text()\')\n"
"{\n"
"if (xpath_eval (\'[xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"] @xsi:nil[.=\"1\" or .=\"true\"]\', _ent) is not null)\n"
"return null;\n"
"if (isentity (_ent))\n"
"return cast (_ent as varchar);\n"
"return _ent;\n"
"}\n"
"if (left (_place, 1) = \'@\')\n"
"return xpath_eval (_place, _ent);\n"
"if (_place = \'.\')\n"
"return _ent;\n"
"signal (\'22023\', sprintf (\'Unsupported value \'\'%s\'\' of place argument\', _place));\n"
"}\n"
"return cast (_ent as varchar);\n"
"}\n"
"--src vspx.sql:3343\n"
;

static const char *other213 = 
"create method vc_get_from_element () for vspx_field_value\n"
"{\n"
"declare _ent any;\n"
"_ent := self.ufl_element_value;\n"
"if (not isentity (_ent))\n"
"return _ent;\n"
"if (self.ufl_element_path is not null)\n"
"{\n"
"\n"
"_ent := xquery_eval (self.ufl_element_path, _ent, 1, self.ufl_element_params);\n"
"if (_ent is null)\n"
"return null;\n"
"\n"
"}\n"
"if (self.ufl_element_place is not null)\n"
"{\n"
"if (not isentity (_ent))\n"
"signal (\'22023\', sprintf (\'Unable to apply element-place=\'\'%s\'\' in VSPX control \'\'%s\'\' to a non-entity value\', self.ufl_element_place, self.vc_name));\n"
"if (self.ufl_element_place = \'text()\')\n"
"{\n"
"if (xpath_eval (\'[xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"] @xsi:nil[.=\"1\" or .=\"true\"]\', _ent) is not null)\n"
"return null;\n"
"if (isentity (_ent))\n"
"return cast (_ent as varchar);\n"
"return _ent;\n"
"}\n"
"if (left (self.ufl_element_place, 1) = \'@\')\n"
"return xpath_eval (self.ufl_element_place, _ent);\n"
"if (self.ufl_element_place = \'.\')\n"
"return _ent;\n"
"signal (\'22023\', sprintf (\'Unsupported value \'\'%s\'\' of element-place attribute of VSPX control \'\'%s\'\'\', self.ufl_element_place, self.vc_name));\n"
"}\n"
"\n"
"return cast (_ent as varchar);\n"
"}\n";

static const char *other214 = 
"create method vc_put_to_element (inout _val any) for vspx_field_value\n"
"{\n"
"declare _ent any;\n"
"declare _path_used integer;\n"
"_ent := self.ufl_element_value;\n"
"if (not isentity (_ent))\n"
"return;\n"
"if (self.ufl_element_update_path is not null)\n"
"{\n"
"_ent := xquery_eval (self.ufl_element_update_path, _ent, 1, self.ufl_element_update_params);\n"
"if (_ent is null)\n"
"return;\n"
"_path_used := 1;\n"
"}\n"
"else if (self.ufl_element_path is not null)\n"
"{\n"
"_ent := xquery_eval (self.ufl_element_path, _ent, 1, self.ufl_element_params);\n"
"if (_ent is null)\n"
"return;\n"
"_path_used := 1;\n"
"}\n"
"else\n"
"_path_used := 0;\n"
"if (self.ufl_element_place is null or self.ufl_element_place = \'.\')\n"
"{\n"
"XMLReplace (_ent, _ent, self.ufl_value);\n"
"goto ent_is_set;\n"
"}\n"
"if (not isentity (_ent))\n"
"signal (\'22023\', sprintf (\'Unable to apply element-place=\'\'%s\'\' in VSPX control \'\'%s\'\' to a non-entity value\', self.ufl_element_place, self.vc_name));\n"
"if (self.ufl_element_place = \'text()\')\n"
"{\n"
"declare _chld_no integer;\n"
"_chld_no := xpath_eval (\'count (node())\', _ent);\n"
"if (_chld_no > 1)\n"
"signal (\'22023\', sprintf (\'Unable to apply element-place=\'\'%s\'\' in VSPX control \'\'%s\'\' to an value that have more than one child\', self.ufl_element_place, self.vc_name));\n"
"if (_val is null)\n"
"{\n"
"XMLAddAttribute (_ent, 2, \'http://www.w3.org/2001/XMLSchema-instance:nil\', \'1\');\n"
"goto ent_is_set;\n"
"if (_chld_no)\n"
"XMLReplace (_ent, xpath_eval (\'node()\', _ent), null);\n"
"}\n"
"else\n"
"{\n"
"declare _xsinil any;\n"
"_xsinil := xpath_eval (\'[xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"] @xsi:nil\', _ent);\n"
"if (_xsinil is not null)\n"
"XMLReplace (_ent, _xsinil, null);\n"
"if (_chld_no)\n"
"XMLReplace (_ent, xpath_eval (\'node()\', _ent), cast (_val as varchar));\n"
"else\n"
"XMLAppendChildren (_ent, cast (_val as varchar));\n"
"goto ent_is_set;\n"
"}\n"
"}\n"
"if (left (self.ufl_element_place, 1) = \'@\')\n"
"{\n"
"if (_val is null)\n"
"XMLReplace (_ent, xquery_eval (self.ufl_element_place, _ent), null);\n"
"else\n"
"XMLAddAttribute (_ent, 2, subseq (self.ufl_element_place, 1), cast (_val as varchar));\n"
"goto ent_is_set;\n"
"}\n"
"signal (\'22023\', sprintf (\'Unsupported value \'\'%s\'\' of element-place attribute of VSPX control \'\'%s\'\'\', self.ufl_element_place, self.vc_name));\n"
"ent_is_set:\n"
"if (not _path_used)\n"
"self.ufl_element_value := _ent;\n"
"}\n";

static const char *other215 = 
"create method vc_get_value_from_element () for vspx_field_value\n"
"{\n"
"self.ufl_value := self.vc_get_from_element();\n"
"}\n";

static const char *other216 = 
"create method vc_put_value_to_element () for vspx_field_value\n"
"{\n"
"self.vc_put_to_element (self.ufl_value);\n"
"}\n";

static const char *other217 = 
"create method vc_get_selected_from_value () for vspx_field_value\n"
"{\n"
"declare _val varchar;\n"
"if ((self.ufl_value is null and self.ufl_true_value is null) or\n"
"self.ufl_value is not null and self.ufl_true_value is not null and (self.ufl_true_value = _val) )\n"
"{\n"
"self.ufl_selected := 1;\n"
"return;\n"
"}\n"
"if ((self.ufl_value is null and self.ufl_false_value is null) or\n"
"self.ufl_value is not null and self.ufl_false_value is not null and (self.ufl_false_value = _val) )\n"
"{\n"
"self.ufl_selected := 0;\n"
"return;\n"
"}\n"
"if (self.ufl_value is null)\n"
"{\n"
"self.ufl_selected := 0;\n"
"return;\n"
"}\n"
"_val := cast (self.ufl_value as varchar);\n"
"if (_val <> \'false\' and _val <> \'0\' and _val <> \'\')\n"
"{\n"
"self.ufl_selected := 1;\n"
"return;\n"
"}\n"
"}\n";

static const char *other218 = 
"create method vc_validate() for vspx_field\n"
"{\n"
"declare i, l int;\n"
"i := 0;\n"
"l := length(self.ufl_validators);\n"
"while(i < l) {\n"
"declare vldt vspx_range_validator;\n"
"vldt := self.ufl_validators[i];\n"
"if(vldt.vv_validate(self)) {\n"
"i := l;\n"
"}\n"
"i := i + 1;\n"
"}\n"
"}\n";

static const char *other219 = 
"create method ufl_schema (inout sch any, in name varchar) for vspx_field\n"
"{\n"
"declare i, l int;\n"
"declare vv, typ, xsd_type any;\n"
"declare vld vspx_range_validator;\n"
"\n"
"vv := self.ufl_validators;\n"
"i := 0; l := length (vv);\n"
"if (sch is null)\n"
"xte_nodebld_init (sch);\n"
"\n"
"xte_nodebld_init (typ);\n"
"xsd_type := \'\';\n"
"\n"
"while (i < l)\n"
"{\n"
"vld := vv[i];\n"
"if (vld is not null)\n"
"{\n"
"if (vld.vv_test = \'regexp\' and xsd_type <> \'int\')\n"
"{\n"
"xte_nodebld_acc (typ, xte_node (xte_head (\'pattern\', \'value\', vld.vv_expr)));\n"
"xsd_type := \'string\';\n"
"}\n"
"else if (vld.vv_test = \'length\' and xsd_type <> \'int\')\n"
"{\n"
"xte_nodebld_acc (typ, xte_node (xte_head (\'minLength\', \'value\',\n"
"cast (vld.vr_min as varchar))));\n"
"xte_nodebld_acc (typ, xte_node (xte_head (\'maxLength\', \'value\',\n"
"cast (vld.vr_max as varchar))));\n"
"xsd_type := \'string\';\n"
"}\n"
"else if (vld.vv_test = \'value\' and xsd_type <> \'string\')\n"
"{\n"
"xte_nodebld_acc (typ, xte_node (xte_head (\'minInclusive\', \'value\',\n"
"cast (vld.vr_min as varchar))));\n"
"xte_nodebld_acc (typ, xte_node (xte_head (\'maxInclusive\', \'value\',\n"
"cast (vld.vr_max as varchar))));\n"
"xsd_type := \'int\';\n"
"}\n"
"\n"
"}\n"
"i := i + 1;\n"
"}\n"
"xsd_type := \'http://www.w3.org/2001/XMLSchema:\' || xsd_type;\n"
"xte_nodebld_final (typ, xte_head (\'restriction\', \'base\', xsd_type));\n"
"xte_nodebld_acc (sch, xte_node (xte_head (\'simpleType\', \'name\', name), typ));\n"
"}\n";

static const char *other220 = 
"create method vc_view_state (inout stream any, inout n int) for vspx_tab\n"
"{\n"
"if (self.tb_active is not null)\n"
"{\n"
"self.vc_push_in_stream (stream, self.tb_active.vc_name, n);\n"
"}\n"
"return;\n"
"}\n";

static const char *other221 = 
"create method vc_get_state (inout stream any) for vspx_tree_node\n"
"{\n"
"declare i, l int;\n"
"if (self.tn_open)\n"
"{\n"
"declare csum any;\n"
"declare parent_tree vspx_tree;\n"
"parent_tree := self.tn_tree;\n"
"if (parent_tree.vt_xpath_id is not null)\n"
"csum := xpath_eval (parent_tree.vt_xpath_id, self.tn_element);\n"
"else\n"
"csum := tree_md5(serialize (self.tn_element), 1);\n"
"stream := vector_concat (stream, vector (csum));\n"
"}\n"
"i := 0; l := length (self.vc_children);\n"
"while (i < l)\n"
"{\n"
"declare chil any;\n"
"chil := self.vc_children[i];\n"
"if (chil is not null and udt_instance_of (chil, fix_identifier_case (\'vspx_tree_node\')))\n"
"{\n"
"declare child_node vspx_tree_node;\n"
"child_node := chil;\n"
"child_node.vc_get_state (stream);\n"
"}\n"
"i := i + 1;\n"
"}\n"
"}\n";

static const char *other222 = 
"create method vc_get_state () for vspx_tree\n"
"{\n"
"declare state any;\n"
"declare i, l int;\n"
"state := vector ();\n"
"i := 0; l := length (self.vc_children);\n"
"while (i < l)\n"
"{\n"
"declare chil any;\n"
"chil := self.vc_children[i];\n"
"if (chil is not null and udt_instance_of (chil, fix_identifier_case (\'vspx_tree_node\')))\n"
"{\n"
"declare child_node vspx_tree_node;\n"
"child_node := chil;\n"
"child_node.vc_get_state (state);\n"
"}\n"
"i := i + 1;\n"
"}\n"
"return state;\n"
"}\n";

static const char *other223 = 
"create method vc_open_at (in path varchar) for vspx_tree\n"
"{\n"
"self.vt_open_at := path;\n"
"}\n";

static const char *other224 = 
"create method vc_view_state (inout stream any, inout n int) for vspx_tree\n"
"{\n"
"self.vc_push_in_stream (stream, self.vc_get_state (), n);\n"
"return;\n"
"}\n";

static const char *other225 = 
"create method vc_close_all_childs () for vspx_tree_node\n"
"{\n"
"declare i, l int;\n"
"i := 0; l := length (self.vc_children);\n"
"while (i < l)\n"
"{\n"
"declare chil vspx_tree_node;\n"
"chil := self.vc_children [i];\n"
"if (chil is not null and udt_instance_of (chil, fix_identifier_case (\'vspx_tree_node\')))\n"
"{\n"
"chil.tn_open := 0;\n"
"chil.vc_close_all_childs ();\n"
"}\n"
"i := i + 1;\n"
"}\n"
"return;\n"
"}\n";

static const char *other226 = 
"create method vc_render () for vspx_login_form\n"
"{\n"
"if (not self.vc_enabled)\n"
"return;\n"
"if (not self.vc_inside_form)\n"
"http (sprintf (\'<form name=\"%s\" method=\"post\">\', self.vc_name));\n"
"\n"
"if (self.vlf_login.vl_mode <> \'digest\')\n"
"{\n"
"http(\'<table border=\"0\"><tr><td>\');\n"
"http (self.vlf_user_title);\n"
"http (\'</td><td>\');\n"
"self.vc_render (\'username\');\n"
"http (\'</td></tr><tr><td>\');\n"
"http (self.vlf_password_title);\n"
"http (\'</td><td>\');\n"
"self.vc_render (\'password\');\n"
"http (\'</td></tr><tr><td colspan=\"2\">\');\n"
"self.vc_render (\'login\');\n"
"http (\'</td></tr></table>\');\n"
"}\n"
"else\n"
"{\n"
"self.vc_render (\'login\');\n"
"}\n"
"if (not self.vc_inside_form)\n"
"http (\'</form>\');\n"
"}\n";

static const char *other227 = 
"create method vc_templates_clean () for vspx_data_grid\n"
"{\n"
"declare i, l int;\n"
"declare chils any;\n"
"i := 0; l := length (self.vc_children);\n"
"chils := self.vc_children;\n"
"while (i < l)\n"
"{\n"
"declare chil any;\n"
"chil := self.vc_children[i];\n"
"if (chil is not null and udt_instance_of (chil, fix_identifier_case (\'vspx_row_template\')))\n"
"{\n"
"\n"
"aset (chils, i, NULL);\n"
"}\n"
"i := i + 1;\n"
"}\n"
"self.vc_children := chils;\n"
"}\n";

static const char *other228 = 
"create method vc_find_parent_by_name (inout control vspx_control, in name varchar) for vspx_control\n"
"{\n"
"if (control.vc_parent is null)\n"
"return NULL;\n"
"if (control.vc_parent.vc_name = name)\n"
"return control.vc_parent;\n"
"return self.vc_find_parent_by_name (control.vc_parent, name);\n"
"}\n";

static const char *other229 = 
"create method vc_find_parent (inout control vspx_control, in udt_name varchar) for vspx_control\n"
"{\n"
"if (control.vc_parent is null)\n"
"return NULL;\n"
"if (udt_instance_of (control.vc_parent, fix_identifier_case (udt_name)))\n"
"return control.vc_parent;\n"
"return self.vc_find_parent (control.vc_parent, udt_name);\n"
"}\n";

static const char *other230 = 
"create method vc_find_parent_form (inout control vspx_control) for vspx_control\n"
"{\n"
"if (control.vc_parent is null)\n"
"return NULL;\n"
"if (udt_instance_of (control.vc_parent, fix_identifier_case (\'vspx_form\')))\n"
"{\n"
"declare form vspx_form;\n"
"form := control.vc_parent;\n"
"if (not form.vc_inside_form)\n"
"return control.vc_parent;\n"
"else\n"
"return self.vc_find_parent_form (control.vc_parent);\n"
"}\n"
"return self.vc_find_parent_form (control.vc_parent);\n"
"}\n";

static const char *other231 = 
"create method vv_validate (inout control vspx_control) for vspx_range_validator\n"
"{\n"
"declare fail int;\n"
"fail := 0;\n"
"if (udt_instance_of (control, fix_identifier_case (\'vspx_field\'))) {\n"
"declare uf vspx_field;\n"
"declare val any;\n"
"val := control;\n"
"uf := val;\n"
"val := uf.ufl_value;\n"
"if (isstring (val) and val = \'\' and self.vv_empty_allowed) {\n"
"return 0;\n"
"}\n"
"if (self.vv_test = \'value\') {\n"
"declare mini, maxi any;\n"
"mini := self.vr_min;\n"
"maxi := self.vr_max;\n"
"if (isstring (val)) {\n"
"val := atoi (val);\n"
"}\n"
"if (val < mini or val > maxi) {\n"
"fail := 1;\n"
"}\n"
"}\n"
"else if (self.vv_test = \'length\') {\n"
"if (length(val) < self.vr_min or length(val) > self.vr_max) {\n"
"fail := 1;\n"
"}\n"
"}\n"
"else if (self.vv_test = \'regexp\') {\n"
"val := cast (val as varchar);\n"
"if (regexp_match (self.vv_expr, val) is null) {\n"
"fail := 1;\n"
"}\n"
"}\n"
"if(fail) {\n"
"control.vc_page.vc_is_valid := 0;\n"
"control.vc_error_message := self.vv_message;\n"
"uf.ufl_error := self.vv_message;\n"
"uf.ufl_failed := 1;\n"
"}\n"
"}\n"
"return fail;\n"
"}\n";

static const char *other232 = 
"create method vc_find_control (in name varchar) for vspx_control\n"
"{\n"
"declare inx, len int;\n"
"inx := 0;\n"
"len := length (self.vc_children);\n"
"\n"
"\n"
"while (inx < len)\n"
"{\n"
"declare child vspx_control;\n"
"child := self.vc_children[inx];\n"
"if (child is not null and child.vc_name = name)\n"
"{\n"
"\n"
"\n"
"return child;\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"\n"
"return NULL;\n"
"}\n";

static const char *other233 = 
"create method vc_find_descendant_control (in name varchar) for vspx_control\n"
"{\n"
"declare inx, len int;\n"
"inx := 0;\n"
"len := length (self.vc_children);\n"
"while (inx < len)\n"
"{\n"
"declare child vspx_control;\n"
"child := self.vc_children[inx];\n"
"if (child is not null and (child.vc_name = name or child.vc_instance_name = name))\n"
"{\n"
"return child;\n"
"}\n"
"else if (child is not null)\n"
"{\n"
"declare ret vspx_control;\n"
"ret := child.vc_find_descendant_control (name);\n"
"if (ret is not null)\n"
"return ret;\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"return NULL;\n"
"}\n";

static const char *other234 = 
"create method vc_find_rpt_control (in name varchar) for vspx_control\n"
"{\n"
"declare inx, len int;\n"
"if (self.vc_repeater is not null)\n"
"name := concat (self.vc_repeater.vc_instance_name, \':\', name);\n"
"inx := 0;\n"
"declare c any;\n"
"c := self.vc_children;\n"
"len := length (c);\n"
"while (inx < len)\n"
"{\n"
"declare child vspx_control;\n"
"child := c[inx];\n"
"if (child is not null and child.vc_instance_name = name)\n"
"{\n"
"return child;\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"return NULL;\n"
"}\n";

static const char *other235 = 
"create method vc_sibling_value (in name varchar) for vspx_control\n"
"{\n"
"declare inx, len int;\n"
"inx := 0;\n"
"len := length (self.vc_parent.vc_children);\n"
"while (inx < len)\n"
"{\n"
"declare child vspx_control;\n"
"child := self.vc_parent.vc_children[inx];\n"
"if (child is not null and child.vc_name = name)\n"
"return (child as vspx_field_value).ufl_value;\n"
"inx := inx + 1;\n"
"}\n"
"signal (\'VSPX0\', sprintf(\'vspx_control.vc_sibling_value() has failed to find a control \'\'%s\'\' that is a sibling of \'\'%s\'\'\', name, self.vc_name));\n"
"}\n";

static const char *other236 = 
"create method vc_render (in ct_name varchar) for vspx_control\n"
"{\n"
"declare ctrl vspx_control;\n"
"if (not self.vc_enabled)\n"
"return;\n"
"ctrl := self.vc_find_control (ct_name);\n"
"\n"
"\n"
"if ((ctrl is not null) and (ctrl.vc_enabled))\n"
"{\n"
"if (ctrl.vc_xrender ())\n"
"return;\n"
"ctrl.vc_render ();\n"
"}\n"
"return;\n"
"}\n";

static const char *other237 = 
"create method vc_disable_child (in ct_name varchar) for vspx_control\n"
"{\n"
"declare ctrl vspx_control;\n"
"ctrl := self.vc_find_control (ct_name);\n"
"if (ctrl is not null)\n"
"ctrl.vc_enabled := 0;\n"
"return;\n"
"}\n";

static const char *other238 = 
"create method vc_enable_child (in ct_name varchar) for vspx_control\n"
"{\n"
"declare ctrl vspx_control;\n"
"ctrl := self.vc_find_control (ct_name);\n"
"if (ctrl is not null)\n"
"ctrl.vc_enabled := 1;\n"
"return;\n"
"}\n";

static const char *other239 = 
"create method vc_get_focus (inout e vspx_event) for vspx_control\n"
"{\n"
"declare inx, len int;\n"
"declare event_target varchar;\n"
"\n"
"\n"
"if (not length (e.ve_params) or not e.ve_is_post)\n"
"return 0;\n"
"\n"
"event_target := get_keyword (\'__event_target\', e.ve_params, \'\');\n"
"inx := 0;\n"
"declare c any;\n"
"c := self.vc_children;\n"
"len := length (c);\n"
"while (inx < len) {\n"
"declare child vspx_control;\n"
"declare cname varchar;\n"
"\n"
"child := c[inx];\n"
"cname := \'@@none@@\';\n"
"if (child is not null)\n"
"cname := child.vc_get_name();\n"
"\n"
"if (get_keyword (cname, e.ve_params) is not null or cname = event_target) {\n"
"\n"
"if(udt_instance_of(child, fix_identifier_case (\'vspx_button\')) or\n"
"udt_instance_of(child, fix_identifier_case (\'vspx_form\'))) {\n"
"\n"
"declare initiator varchar;\n"
"\n"
"initiator := get_keyword (\'__event_initiator\', e.ve_params, \'\');\n"
"\n"
"e.ve_button := child;\n"
"child.vc_focus := 1;\n"
"self.vc_focus := 1;\n"
"\n"
"if (initiator <> \'\' and e.ve_initiator is null)\n"
"e.ve_initiator := child.vc_find_descendant_control (initiator);\n"
"\n"
"\n"
"{\n"
"declare parent, parent_form vspx_control;\n"
"parent := child;\n"
"parent_form := NULL;\n"
"while(parent is not null) {\n"
"if(udt_instance_of(parent, fix_identifier_case (\'vspx_tree_node\'))) {\n"
"goto end_while;\n"
"}\n"
"if(udt_instance_of(parent, fix_identifier_case (\'vspx_form\')) and not\n"
"udt_instance_of(parent, fix_identifier_case (\'vspx_data_set\')) and not\n"
"udt_instance_of(parent, fix_identifier_case (\'vspx_data_grid\')) and not\n"
"udt_instance_of(parent, fix_identifier_case (\'vspx_tab\')) and not\n"
"udt_instance_of(parent, fix_identifier_case (\'vspx_isql\'))) {\n"
"parent_form := parent;\n"
"goto end_while;\n"
"}\n"
"parent := parent.vc_parent;\n"
"}\n"
"end_while:\n"
"if(parent_form is not NULL) {\n"
"\n"
"parent_form.vc_set_childs_focus(1, e);\n"
"}\n"
"}\n"
"return 1;\n"
"}\n"
"}\n"
"if (child is not null and child.vc_get_focus (e)) {\n"
"self.vc_focus := 1;\n"
"return 1;\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"return 0;\n"
"}\n";

static const char *other240 = 
"create method vc_error_summary () for vspx_control\n"
"{\n"
"self.vc_error_summary (1);\n"
"}\n";

static const char *other241 = 
"create method vc_error_summary (in esc_mode int) for vspx_control\n"
"{\n"
"if (self.vc_page.vc_is_valid)\n"
"return 0;\n"
"declare i, l integer;\n"
"if (self.vc_error_message is not null)\n"
"{\n"
"\n"
"if (esc_mode)\n"
"http_value (self.vc_error_message);\n"
"else\n"
"http (self.vc_error_message);\n"
"return 1;\n"
"}\n"
"declare c any;\n"
"c := self.vc_children;\n"
"i := 0; l := length (c);\n"
"while (i < l)\n"
"{\n"
"declare chil vspx_control;\n"
"chil := c[i];\n"
"if (chil is not null and chil.vc_error_summary (esc_mode))\n"
"return 1;\n"
"i := i + 1;\n"
"}\n"
"return 0;\n"
"}\n";

static const char *other242 = 
"create method vc_error_summary (in esc_mode int, in pattern varchar) for vspx_control\n"
"{\n"
"if (self.vc_page.vc_is_valid)\n"
"return 0;\n"
"declare i, l integer;\n"
"declare cname varchar;\n"
"cname := self.vc_name;\n"
"if (self.vc_error_message is not null and regexp_match (pattern, cname) is not null)\n"
"{\n"
"\n"
"if (esc_mode)\n"
"http_value (self.vc_error_message);\n"
"else\n"
"http (self.vc_error_message);\n"
"return 1;\n"
"}\n"
"declare c any;\n"
"c := self.vc_children;\n"
"i := 0; l := length (c);\n"
"while (i < l)\n"
"{\n"
"declare chil vspx_control;\n"
"chil := c[i];\n"
"if (chil is not null and chil.vc_error_summary (esc_mode, pattern))\n"
"return 1;\n"
"i := i + 1;\n"
"}\n"
"return 0;\n"
"}\n";

static const char *other243 = 
"create method vc_xrender () for vspx_control\n"
"{\n"
"return 0;\n"
"}\n";

static const char *other244 = 
"create method vc_render () for vspx_control\n"
"{\n"
"declare h any;\n"
"declare inx, len int;\n"
"if (not self.vc_enabled)\n"
"return;\n"
"h := udt_implements_method (self.vc_page, fix_identifier_case (concat (\'vc_render_\', self.vc_name)));\n"
"if (h)\n"
"{\n"
"call (h) (self.vc_page, self);\n"
"return;\n"
"}\n"
"\n"
"if (self.vc_xrender ())\n"
"return;\n"
"\n"
"declare c any;\n"
"c := self.vc_children;\n"
"inx := 0;\n"
"len := length (c);\n"
"while (inx < len)\n"
"{\n"
"declare chil vspx_control;\n"
"chil := c[inx];\n"
"if (chil is not null)\n"
"chil.vc_render ();\n"
"inx := inx + 1;\n"
"}\n"
"}\n";

static const char *other245 = 
"create method vc_pre_render (inout stream any, inout n int) for vspx_control\n"
"{\n"
"declare h any;\n"
"declare inx, len int;\n"
"\n"
"\n"
"if (self.vc_have_state)\n"
"{\n"
"\n"
"self.vc_view_state (stream, n);\n"
"\n"
"}\n"
"\n"
"if (self.vc_page.vc_browser_caps)\n"
"self.vc_set_model ();\n"
"\n"
"h := udt_implements_method (self.vc_page, fix_identifier_case (concat (\'vc_pre_render_\', self.vc_name)));\n"
"if (h <> 0)\n"
"call (h) (self.vc_page, self);\n"
"\n"
"self.vc_invoke_handlers (\'before-render\');\n"
"\n"
"if (udt_instance_of (self, fix_identifier_case (\'vspx_field\')))\n"
"{\n"
"declare field vspx_field;\n"
"declare _fld any;\n"
"declare i, l int;\n"
"_fld := self;\n"
"field := _fld;\n"
"if (isstring (field.ufl_fmt_fn) and field.vc_error_message is null)\n"
"{\n"
"field.ufl_value := call (field.ufl_fmt_fn) (field.ufl_value);\n"
"}\n"
"}\n"
"\n"
"inx := 0;\n"
"declare c any;\n"
"c := self.vc_children;\n"
"len := length (c);\n"
"while (inx < len)\n"
"{\n"
"declare chil vspx_control;\n"
"chil := c[inx];\n"
"if (chil is not null)\n"
"chil.vc_pre_render (stream, n);\n"
"inx := inx + 1;\n"
"}\n"
"}\n";

static const char *other246 = 
"create method vc_handle_error (in state any, in message any, inout deadl any) for vspx_control\n"
"{\n"
"declare h any;\n"
"h := udt_implements_method (self.vc_page, fix_identifier_case (concat (\'vc_error_handler_\', self.vc_name)));\n"
"if (self is not null and self.vc_name is not null and h <> 0) {\n"
"declare rc int;\n"
"rc := call (h) (self.vc_page, state, message, deadl);\n"
"return rc;\n"
"}\n"
"else {\n"
"if(state = 100 and message is null) message := \'Not Found.\';\n"
"if (isinteger (state))\n"
"http_value(sprintf(\'STATE : %05d  MESSAGE :%s\', state, message));\n"
"else\n"
"http_value(sprintf(\'STATE : %s  MESSAGE :%s\', state, message));\n"
"}\n"
"return 0;\n"
"}\n";

static const char *other247 = 
"create method vc_data_bind (inout e vspx_event) for vspx_control\n"
"{\n"
"declare h any;\n"
"declare inx, len int;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"h := udt_implements_method (self.vc_page, fix_identifier_case (concat (\'vc_data_bind_\', self.vc_name)));\n"
"if (h <> 0)\n"
"{\n"
"declare disabled int;\n"
"\n"
"disabled := call (h) (self.vc_page, self, e);\n"
"if (disabled = 1)\n"
"return;\n"
"}\n"
"if (not self.vc_enabled)\n"
"return;\n"
"self.vc_invoke_handlers (\'before-data-bind\');\n"
"\n"
"if (udt_instance_of (self, fix_identifier_case (\'vspx_field\')))\n"
"{\n"
"declare field vspx_field;\n"
"declare _fld any;\n"
"_fld := self;\n"
"field := _fld;\n"
"if (field.ufl_value is null and field.ufl_null_value is not null)\n"
"field.ufl_value := field.ufl_null_value;\n"
"if (isstring (field.ufl_cvt_fn) and field.vc_error_message is null)\n"
"{\n"
"field.ufl_value := call (field.ufl_cvt_fn) (field.ufl_value);\n"
"}\n"
"}\n"
"\n"
"inx := 0;\n"
"declare c any;\n"
"c := self.vc_children;\n"
"len := length (c);\n"
"while (inx < len)\n"
"{\n"
"declare chil vspx_control;\n"
"chil := c[inx];\n"
"if (chil is not null)\n"
"{\n"
"\n"
"chil.vc_data_bind (e);\n"
"\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"if (e.ve_is_post\n"
"and e.ve_button is not null\n"
"and udt_instance_of (e.ve_button, \'vspx_form\')\n"
"and e.ve_initiator is null\n"
")\n"
"{\n"
"declare initiator varchar;\n"
"initiator := get_keyword (\'__event_initiator\', e.ve_params, \'\');\n"
"if (initiator <> \'\' and initiator = self.vc_get_name ())\n"
"{\n"
"e.ve_initiator := self;\n"
"}\n"
"}\n"
"\n"
"h := udt_implements_method (self.vc_page, fix_identifier_case (concat (\'vc_after_data_bind_\', self.vc_name)));\n"
"if (h <> 0)\n"
"{\n"
"\n"
"call (h) (self.vc_page, self, e);\n"
"}\n"
"self.vc_invoke_handlers (\'after-data-bind\');\n"
"}\n";

static const char *other248 = 
"create method vc_set_model () for vspx_control\n"
"{\n"
"return;\n"
"}\n";

static const char *other249 = 
"create method vc_view_state (inout stream any, inout n int) for vspx_control\n"
"{\n"
"\n"
"return;\n"
"}\n";

static const char *other250 = 
"create method vc_set_view_state (inout e vspx_event) for vspx_control\n"
"{\n"
"declare h any;\n"
"declare inx, len int;\n"
"\n"
"h := udt_implements_method (self.vc_page, fix_identifier_case (concat (\'vc_set_view_state_\', self.vc_name)));\n"
"if (h <> 0)\n"
"call (h) (self.vc_page, self, e);\n"
"self.vc_control_state := 1;\n"
"return;\n"
"}\n";

static const char *other251 = 
"create method vc_set_childs_focus(in flag any, inout e vspx_event) for vspx_control\n"
"{\n"
"declare inx, len int;\n"
"declare c any;\n"
"inx := 0;\n"
"c := self.vc_children;\n"
"len := length (c);\n"
"while(inx < len) {\n"
"declare child vspx_control;\n"
"child := c[inx];\n"
"if(child is not null) {\n"
"if(not udt_instance_of(child, fix_identifier_case(\'vspx_form\')) and not\n"
"udt_instance_of(child, fix_identifier_case(\'vspx_button\'))) {\n"
"child.vc_focus := flag;\n"
"child.vc_set_childs_focus(flag, e);\n"
"}\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"}\n";

static const char *other252 = 
"create method vc_post (inout e vspx_event) for vspx_control\n"
"{\n"
"declare h any;\n"
"declare inx, len int;\n"
"\n"
"h := udt_implements_method(self.vc_page, fix_identifier_case(concat(\'vc_post_\', self.vc_name)));\n"
"declare c any;\n"
"c := self.vc_children;\n"
"inx := 0;\n"
"len := length(c);\n"
"while(inx < len) {\n"
"declare child vspx_control;\n"
"child := c[inx];\n"
"if(child is not null) {\n"
"child.vc_post(e);\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"if(h <> 0) {\n"
"call (h) (self.vc_page, self, e);\n"
"}\n"
"if (udt_instance_of (self, fix_identifier_case (\'vspx_field\')))\n"
"{\n"
"declare field vspx_field;\n"
"declare _fld any;\n"
"_fld := self;\n"
"field := _fld;\n"
"if (field.ufl_value = field.ufl_null_value and field.vc_focus)\n"
"field.ufl_value := null;\n"
"}\n"
"}\n";

static const char *other253 = 
"create method vc_user_post (inout e vspx_event) for vspx_control\n"
"{\n"
"declare h any;\n"
"declare inx, len int;\n"
"\n"
"\n"
"h := udt_implements_method(self.vc_page, fix_identifier_case(concat(\'vc_user_post_\', self.vc_name)));\n"
"declare c any;\n"
"inx := 0;\n"
"c := self.vc_children;\n"
"len := length (c);\n"
"while(inx < len) {\n"
"declare child vspx_control;\n"
"child := c[inx];\n"
"if(child is not null) {\n"
"child.vc_user_post(e);\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"if(h <> 0) {\n"
"call (h) (self.vc_page, self, e);\n"
"}\n"
"self.vc_invoke_handlers (\'on-post\');\n"
"}\n";

static const char *other254 = 
"create method vc_action (inout e vspx_event) for vspx_control\n"
"{\n"
"declare h any;\n"
"declare inx, len int;\n"
"\n"
"h := udt_implements_method(self.vc_page, fix_identifier_case(concat(\'vc_action_\', self.vc_name)));\n"
"inx := 0;\n"
"declare c any;\n"
"c := self.vc_children;\n"
"len := length(c);\n"
"while(inx < len) {\n"
"declare child vspx_control;\n"
"child := c[inx];\n"
"if(child is not null) {\n"
"child.vc_action(e);\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"if(h <> 0) {\n"
"call (h) (self.vc_page, self, e);\n"
"}\n"
"\n"
"if (udt_instance_of(self, fix_identifier_case(\'vspx_field\'))) {\n"
"declare field vspx_field;\n"
"declare _fld any;\n"
"_fld := self;\n"
"field := _fld;\n"
"if(isstring(field.ufl_cvt_fn) and field.vc_error_message is null) {\n"
"field.ufl_value := call (field.ufl_cvt_fn) (field.ufl_value);\n"
"}\n"
"}\n"
"}\n";

static const char *other255 = 
"create method vc_render () for vspx_select_list\n"
"{\n"
"declare inx, len int;\n"
"declare form vspx_form;\n"
"if (not self.vc_enabled)\n"
"return;\n"
"http (sprintf (\'<select name=\"%s\"\', self.vc_get_name ()));\n"
"vspx_print_html_attrs (self);\n"
"if (self.vsl_multiple)\n"
"{\n"
"http (\' multiple=\"multiple\"\');\n"
"}\n"
"if (self.ufl_auto_submit or self.vsl_change_script) http (\' onchange=\"doAutoSubmit (this.form, this)\"\');\n"
"http (\'>\');\n"
"\n"
"inx := 0; len := length (self.vsl_items);\n"
"while (inx < len)\n"
"{\n"
"declare sel varchar;\n"
"sel := \'\';\n"
"if (not self.vsl_multiple)\n"
"{\n"
"sel := case self.vsl_selected_inx when inx then \'selected=\"selected\"\' else \'\' end;\n"
"}\n"
"else\n"
"{\n"
"if (isarray(self.vsl_selected_inx) and self.vsl_selected_inx[inx])\n"
"sel := \'selected=\"selected\"\';\n"
"else\n"
"sel := \'\';\n"
"}\n"
"http (sprintf (\'<option value=\"%s\" %s>%s</option>\', self.vsl_item_values[inx], sel, self.vsl_items[inx]));\n"
"inx := inx + 1;\n"
"}\n"
"http (\'</select>\');\n"
"}\n";

static const char *other256 = 
"create method vc_view_state (inout stream any, inout n int) for vspx_select_list\n"
"{\n"
"self.vc_push_in_stream (stream, self.ufl_value, n);\n"
"return;\n"
"}\n";

static const char *other257 = 
"create method vc_view_state (inout stream any, inout n int) for vspx_login\n"
"{\n"
"\n"
"declare state any;\n"
"state := vector (\n"
"\'vl_logout_in_progress\', self.vl_logout_in_progress,\n"
"\'vl_authenticated\', self.vl_authenticated\n"
");\n"
"self.vc_push_in_stream (stream, state, n);\n"
"return;\n"
"}\n";

static const char *other258 = 
"create method vc_render () for vspx_update_field\n"
"{\n"
"declare vst any;\n"
"if (not self.vc_enabled)\n"
"return;\n"
"if (self.ufl_failed and self.ufl_error_glyph is not null)\n"
"http (self.ufl_error_glyph);\n"
"\n"
"http (\'<input type=\"text\" name=\"\');\n"
"http (self.vc_get_name ());\n"
"if (self.ufl_value is not null)\n"
"{\n"
"http (\'\" value=\"\');\n"
"http_value (self.ufl_value);\n"
"}\n"
"else\n"
"{\n"
"vst := self.vc_get_control_state (null);\n"
"if (vst is not null)\n"
"{\n"
"http (\'\" value=\"\');\n"
"http_value (vst);\n"
"}\n"
"else\n"
"{\n"
"http (\'\" value=\"\');\n"
"http (self.tf_default);\n"
"}\n"
"\n"
"}\n"
"http (\'\"\');\n"
"vspx_print_html_attrs (self);\n"
"http (case self.ufl_client_validate when 0 then \'\' else \' onchange=\"javascript: vv_validate_\' || self.vc_name || \'(this)\"\' end);\n"
"if (self.ufl_auto_submit) http (\' onchange=\"doAutoSubmit (this.form, this)\"\');\n"
"http (\' />\');\n"
"if (self.ufl_failed and self.ufl_error_glyph is null)\n"
"http_value (self.ufl_error);\n"
"}\n";

static const char *other259 = 
"create method vc_xrender () for vspx_text\n"
"{\n"
"if (not self.vc_page.vc_browser_caps)\n"
"return 0;\n"
"if (self.tf_style = 1 or self.tf_style = \'password\')\n"
"{\n"
"http (sprintf (\'<xforms:secret ref=\"/vxf:post/vxf:%s\" model=\"%s\" />\',\n"
"self.vc_get_name (), self.vc_top_form.vc_get_name ()));\n"
"}\n"
"else if (self.tf_style <> \'hidden\' and self.tf_style <> 2)\n"
"{\n"
"http (sprintf (\'<xforms:input ref=\"/vxf:post/vxf:%s\" model=\"%s\" />\',\n"
"self.vc_get_name (), self.vc_top_form.vc_get_name ()));\n"
"}\n"
"return 1;\n"
"}\n";

static const char *other260 = 
"create method vc_xrender () for vspx_textarea\n"
"{\n"
"if (not self.vc_page.vc_browser_caps)\n"
"return 0;\n"
"http (sprintf (\'<xforms:textarea ref=\"/vxf:post/vxf:%s\" model=\"%s\" />\',\n"
"self.vc_get_name (), self.vc_top_form.vc_get_name ()));\n"
"return 1;\n"
"}\n";

static const char *other261 = 
"create method vc_xrender () for vspx_select_list\n"
"{\n"
"declare inx, len int;\n"
"\n"
"if (not self.vc_page.vc_browser_caps)\n"
"return 0;\n"
"\n"
"http (sprintf (\'<xforms:select%s ref=\"/vxf:post/vxf:%s\" model=\"%s\">\\n\',\n"
"case when not self.vsl_multiple then \'1\' else \'\' end,\n"
"self.vc_get_name (), self.vc_top_form.vc_get_name ()));\n"
"\n"
"inx := 0; len := length (self.vsl_items);\n"
"while (inx < len)\n"
"{\n"
"http (\'<xforms:item>\\n\');\n"
"http (sprintf (\'<xforms:label>%s</xforms:label>\\n\', self.vsl_items[inx]));\n"
"http (sprintf (\'<xforms:value>%s</xforms:value>\\n\', self.vsl_item_values[inx]));\n"
"http (\'</xforms:item>\\n\');\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"http (sprintf (\'</xforms:select%s>\\n\',\n"
"case when not self.vsl_multiple then \'1\' else \'\' end));\n"
"return 1;\n"
"}\n";

static const char *other262 = 
"create method vc_xrender () for vspx_check_box\n"
"{\n"
"if (not self.vc_page.vc_browser_caps)\n"
"return 0;\n"
"http (sprintf (\'<xforms:input ref=\"/vxf:post/vxf:%s\" model=\"%s\" />\',\n"
"self.vc_get_name (), self.vc_top_form.vc_get_name ()));\n"
"return 1;\n"
"}\n";

static const char *other263 = 
"create method vc_xrender () for vspx_radio_group\n"
"{\n"
"if (not self.vc_page.vc_browser_caps)\n"
"return 0;\n"
"declare inx, len int;\n"
"http (sprintf (\'<xforms:select1 ref=\"/vxf:post/vxf:%s\" model=\"%s\" appearance=\"full\">\\n\',\n"
"self.vc_get_name (), self.vc_top_form.vc_get_name ()));\n"
"\n"
"inx := 0; len := length (self.vc_children);\n"
"while (inx < len)\n"
"{\n"
"declare chil vspx_control;\n"
"chil := self.vc_children [inx];\n"
"if (chil is not null and udt_instance_of (chil, \'vspx_radio_button\'))\n"
"chil.vc_xrender ();\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"http (\'</xforms:select1>\\n\');\n"
"return 1;\n"
"}\n";

static const char *other264 = 
"create method vc_xrender () for vspx_radio_button\n"
"{\n"
"if (not self.vc_page.vc_browser_caps)\n"
"return 0;\n"
"http (\'<xforms:item>\\n\');\n"
"http (sprintf (\'<xforms:value>%s</xforms:value>\\n\', coalesce (self.ufl_value, \'\')));\n"
"http (\'</xforms:item>\\n\');\n"
"return 1;\n"
"}\n";

static const char *other265 = 
"create method vc_xrender () for vspx_button\n"
"{\n"
"if (not self.vc_page.vc_browser_caps)\n"
"return 0;\n"
"http (sprintf (\'<xforms:submit submission=\"%s\">\\n\', self.vc_get_name ()));\n"
"http (\'<xforms:label>\');\n"
"http_value (self.ufl_value);\n"
"http (\'</xforms:label>\\n\');\n"
"http (\'<xforms:action ev:event=\"DOMActivate\">\\n\');\n"
"http (sprintf (\'<xforms:setvalue ref=\"/vxf:post/vxf:event__target\" model=\"%s\">%s</xforms:setvalue>\\n\',\n"
"self.vc_top_form.vc_get_name (), self.vc_get_name ()));\n"
"http (\'</xforms:action>\\n\');\n"
"http (\'</xforms:submit>\\n\');\n"
"return 1;\n"
"}\n";

static const char *other266 = 
"create method vc_render () for vspx_text\n"
"{\n"
"declare vst any;\n"
"if (not self.vc_enabled)\n"
"return;\n"
"if (self.ufl_failed and self.ufl_error_glyph is not null)\n"
"http (self.ufl_error_glyph);\n"
"\n"
"http (sprintf (\'<input type=\"%s\" name=\"\', (case self.tf_style when 1 then \'password\' when \'password\' then self.tf_style when \'hidden\' then self.tf_style when 2 then \'hidden\' when \'file\' then \'file\' else \'text\' end)));\n"
"http (self.vc_get_name ());\n"
"\n"
"if (self.tf_style <> \'file\')\n"
"{\n"
"http (\'\" value=\"\');\n"
"if (self.ufl_value is not null)\n"
"{\n"
"http_value (self.ufl_value);\n"
"}\n"
"else\n"
"{\n"
"vst := self.vc_get_control_state (null);\n"
"if (vst is not null)\n"
"{\n"
"http_value (vst);\n"
"}\n"
"else\n"
"{\n"
"http (self.tf_default);\n"
"}\n"
"}\n"
"}\n"
"http (\'\"\');\n"
"\n"
"if (self.tf_style = 3) {\n"
"http(\' readonly=\"true\"\');\n"
"}\n"
"vspx_print_html_attrs (self);\n"
"http (case self.ufl_client_validate when 0 then \'\' else \' onchange=\"javascript: vv_validate_\' || self.vc_name || \'(this)\"\' end);\n"
"\n"
"if (self.ufl_auto_submit) http (\' onchange=\"doAutoSubmit (this.form, this)\"\');\n"
"\n"
"http (\' />\');\n"
"if (self.ufl_failed and self.ufl_error_glyph is null)\n"
"http_value (self.ufl_error);\n"
"}\n";

static const char *other267 = 
"create method vc_render () for vspx_textarea\n"
"{\n"
"declare vst any;\n"
"if (not self.vc_enabled)\n"
"return;\n"
"if (self.ufl_failed and self.ufl_error_glyph is not null)\n"
"http (self.ufl_error_glyph);\n"
"\n"
"http (\'<textarea name=\"\');\n"
"http (self.vc_get_name ());\n"
"http (\'\"\');\n"
"vspx_print_html_attrs (self);\n"
"http (case self.ufl_client_validate when 0 then \'\' else \' onchange=\"javascript: vv_validate_\' || self.vc_name || \'(this)\"\' end);\n"
"if (self.ufl_auto_submit) http (\' onchange=\"doAutoSubmit (this.form, this)\"\');\n"
"http (\' >\');\n"
"\n"
"if (self.ufl_value is not null)\n"
"{\n"
"http_value (self.ufl_value);\n"
"}\n"
"else\n"
"{\n"
"vst := self.vc_get_control_state (null);\n"
"if (vst is not null)\n"
"{\n"
"http_value (vst);\n"
"}\n"
"else\n"
"http (self.tf_default);\n"
"\n"
"}\n"
"http (\'</textarea>\');\n"
"if (self.ufl_failed and self.ufl_error_glyph is null)\n"
"http_value (self.ufl_error);\n"
"}\n";

static const char *other268 = 
"create method vc_render () for vspx_button\n"
"{\n"
"\n"
"if ( not self.vc_enabled)\n"
"return;\n"
"\n"
"\n"
"\n"
"\n"
"if (length (self.bt_url) and length (self.bt_l_pars))\n"
"{\n"
"self.bt_url := vspx_uri_add_parameters (self.bt_url, self.bt_l_pars);\n"
"self.bt_l_pars := null;\n"
"}\n"
"\n"
"if (self.bt_anchor = 1)\n"
"{\n"
"http (sprintf (\'<a name=\"btn_%s\"></a>\', self.vc_get_name ()));\n"
"}\n"
"\n"
"if (self.bt_style = \'image\')\n"
"{\n"
"declare frm vspx_control;\n"
"declare frm_name varchar;\n"
"frm := self.vc_find_parent_form (self);\n"
"if (frm is not null)\n"
"frm_name := frm.vc_name;\n"
"else\n"
"frm_name := \'\';\n"
"http ( sprintf ( \'<a href=\"%s\" %s><img src=\"%s\" border=\"0\" \',\n"
"case self.bt_url when \'\' then \'javascript:void(0)\' else self.bt_url end,\n"
"case when self.bt_url = \'\' and self.ufl_active > 0\n"
"then sprintf ( \'onclick=\"javascript: doPost (\\\'%s\\\', \\\'%s\\\'); return false\"\',\n"
"frm_name,\n"
"self.vc_get_name ()\n"
")\n"
"else \'\' end,\n"
"self.ufl_value));\n"
"vspx_print_html_attrs (self);\n"
"http (sprintf (\' />%s</a>\', self.bt_text));\n"
"return;\n"
"}\n"
"\n"
"if (self.bt_style = \'url\')\n"
"{\n"
"declare frm vspx_control;\n"
"declare frm_name varchar;\n"
"frm := self.vc_find_parent_form (self);\n"
"if (frm is not null)\n"
"frm_name := frm.vc_name;\n"
"else\n"
"frm_name := \'\';\n"
"http ( sprintf ( \'<a href=\"%s\" %s\',\n"
"case self.bt_url when \'\' then \'javascript:void(0)\' else self.bt_url end,\n"
"case when self.bt_url = \'\' and self.ufl_active > 0\n"
"then sprintf ( \'onclick=\"javascript: doPost (\\\'%s\\\', \\\'%s\\\'); return false\"\',\n"
"frm_name,\n"
"self.vc_get_name ()\n"
")\n"
"else \'\' end));\n"
"vspx_print_html_attrs (self);\n"
"http (\' >\');\n"
"http (self.ufl_value);\n"
"http (\'</a>\');\n"
"return;\n"
"}\n"
"\n"
"post_button:\n"
"\n"
"http (sprintf (\'<input type=\"%s\" name=\"\', case when self.ufl_active > 0 then \'submit\' else \'button\' end));\n"
"http (self.vc_get_name ());\n"
"if (self.ufl_value is not null)\n"
"{\n"
"http (\'\" value=\"\');\n"
"http_value (self.ufl_value);\n"
"}\n"
"http (\'\"\');\n"
"vspx_print_html_attrs (self);\n"
"http (\' />\');\n"
"}\n";

static const char *other269 = 
"create method vc_render () for vspx_browse_button\n"
"{\n"
"if ( not self.vc_enabled)\n"
"return;\n"
"\n"
"if (self.bt_style = \'url\')\n"
"{\n"
"\n"
"http (\'<a href=\"javascript:void(0)\"\');\n"
"vspx_print_html_attrs (self);\n"
"}\n"
"else if (self.bt_style = \'image\')\n"
"{\n"
"\n"
"http (\'<a href=\"javascript:void(0)\" \');\n"
"}\n"
"else\n"
"{\n"
"\n"
"http (\'<input type=\"button\" name=\"\');\n"
"http (self.vc_get_name ());\n"
"if (self.ufl_value is not null)\n"
"{\n"
"http (\'\" value=\"\');\n"
"http_value (self.ufl_value);\n"
"}\n"
"http (\'\"\');\n"
"vspx_print_html_attrs (self);\n"
"}\n"
"\n"
"http (\' onclick=\"javascript: \');\n"
"declare pars, fld_pars varchar;\n"
"if (1)\n"
"{\n"
"declare i, l int;\n"
"declare frm vspx_form;\n"
"frm := self.vc_find_parent_form (self);\n"
"i := 0; l := length (self.vcb_fields);\n"
"pars := \'\'; fld_pars := \'&\';\n"
"while (i < l)\n"
"{\n"
"declare tfl vspx_text;\n"
"tfl := self.vc_parent.vc_find_control (self.vcb_fields[i]);\n"
"http (sprintf (\'window.%s=document.%s[\\\'%s\\\']; \',\n"
"self.vcb_fields[i], frm.vc_name, self.vcb_ref_fields[i]));\n"
"pars := concat (pars, self.vcb_fields[i], \'=\\\'+ encodeURIComponent (document.\',frm.vc_name, \'[\\\'\', self.vcb_ref_fields[i], \'\\\'].value)+\\\'&\');\n"
"fld_pars := concat (fld_pars, \'fld_name=\', self.vcb_ref_fields[i], \'&\');\n"
"i := i + 1;\n"
"}\n"
"}\n"
"\n"
"if (self.vcb_system = \'dav\' or self.vcb_system = \'os\')\n"
"{\n"
"declare form vspx_form;\n"
"form := self.vc_find_parent_form (self);\n"
"if (form is not null)\n"
"fld_pars := concat (fld_pars, \'frm_name=\', form.vc_name);\n"
"pars := sprintf (\'browse_mode=%s&lst_mode=%s&xfer_mode=%s&cur_col=%d&os=%s&flt_pat=%s%s\', self.vcb_browser_mode , self.vcb_list_mode, self.vcb_xfer, self.vcb_current, self.vcb_system, self.vcb_filter, fld_pars);\n"
"}\n"
"\n"
"pars := rtrim (pars, \'&\');\n"
"if( self.vcb_browser_options <> \'\' ) pars := concat( pars, \'&\', self.vcb_browser_options );\n"
"if(self.vcb_params is not null) {\n"
"declare i, l int;\n"
"declare frm vspx_form;\n"
"declare params_string, result_string varchar;\n"
"declare params_stream, result_stream any;\n"
"i := 0;\n"
"l := length(self.vcb_params);\n"
"params_stream := string_output();\n"
"result_stream := string_output();\n"
"frm := self.vc_find_parent_form (self);\n"
"while(i < l) {\n"
"http(sprintf(\'&%s=\'\' + encodeURIComponent (document.%s.%s.value) + \'\'\', self.vcb_params[i], frm.vc_name, self.vcb_params[i]), params_stream);\n"
"i := i + 1;\n"
"}\n"
"params_string := string_output_string(params_stream);\n"
"http(sprintf(\'window.open(\\\\\'\'%s%s\\\\\'\', \\\\\'\'%s_window\\\\\'\', \\\\\'\'%s\\\\\'\')\',\n"
"vspx_uri_add_parameters (self.vcb_selector, pars),\n"
"params_string, self.vc_name,  self.vcb_chil_options), result_stream);\n"
"result_string := string_output_string(result_stream);\n"
"http(sprintf(\'var cmd_str=\'\'%s\'\'; eval(cmd_str); \"\', result_string));\n"
"}\n"
"else {\n"
"http(sprintf(\'window.open (\\\'%s\\\', \\\'%s_window\\\', \\\'%s\\\')\"\',\n"
"vspx_uri_add_parameters (self.vcb_selector, pars), self.vc_name,  self.vcb_chil_options));\n"
"}\n"
"if (self.bt_style = \'url\')\n"
"{\n"
"http (sprintf (\'>%V</a>\', self.ufl_value));\n"
"}\n"
"else if (self.bt_style = \'image\')\n"
"{\n"
"http (sprintf (\'><img src=\"%s\" border=\"0\" \', self.ufl_value));\n"
"vspx_print_html_attrs (self);\n"
"http (sprintf (\' />%s</a>\', self.bt_text));\n"
"}\n"
"else\n"
"{\n"
"http (\' />\');\n"
"}\n"
"}\n";

static const char *other270 = 
"create method vc_render () for vspx_return_button\n"
"{\n"
"if ( not self.vc_enabled)\n"
"return;\n"
"if (self.bt_style = \'url\')\n"
"{\n"
"\n"
"http (\'<a href=\"javascript:void(0)\"\');\n"
"vspx_print_html_attrs (self);\n"
"}\n"
"else if (self.bt_style = \'image\')\n"
"{\n"
"\n"
"http (\'<a href=\"javascript:void(0)\"\');\n"
"}\n"
"else\n"
"{\n"
"http (\'<input type=\"button\" name=\"\');\n"
"http (self.vc_get_name ());\n"
"if (self.ufl_value is not null)\n"
"{\n"
"http (\'\" value=\"\');\n"
"http_value (self.ufl_value);\n"
"}\n"
"http (\'\"\');\n"
"vspx_print_html_attrs (self);\n"
"}\n"
"declare frm vspx_form;\n"
"frm := self.vc_find_parent_form (self);\n"
"http (sprintf (\' onclick=\"javascript: selectRow_%s (\\\'\', self.vc_name));\n"
"if (frm is not null)\n"
"http (frm.vc_name);\n"
"http (\'\\\', \');\n"
"{\n"
"declare i, l integer;\n"
"i := 0; l := length (self.vc_children);\n"
"while (i < l)\n"
"{\n"
"declare chil vspx_field;\n"
"chil := self.vc_children[i];\n"
"if (chil is not null)\n"
"{\n"
"http (sprintf (\'\\\'%V\\\'\', replace(chil.ufl_value,\'\\\'\', \'\\\\\\\'\')));\n"
"}\n"
"else\n"
"http (\'\\\'\\\'\');\n"
"if (i <> (l - 1))\n"
"http (\',\');\n"
"i := i + 1;\n"
"}\n"
"}\n"
"http (\')\"\');\n"
"if (self.bt_style = \'url\')\n"
"{\n"
"http (sprintf (\'>%V</a>\', self.ufl_value));\n"
"}\n"
"else if (self.bt_style = \'image\')\n"
"{\n"
"http (sprintf (\'><img src=\"%s\" border=\"0\" \', self.ufl_value));\n"
"vspx_print_html_attrs (self);\n"
"http (sprintf (\' />%s</a>\', self.bt_text));\n"
"}\n"
"else\n"
"{\n"
"http (\' />\');\n"
"}\n"
"}\n";

static const char *other271 = 
"create method vc_render () for vspx_radio_button\n"
"{\n"
"if ( not self.vc_enabled)\n"
"return;\n"
"http (sprintf (\'<input type=\"radio\" name=\"%s\" value=\"%s\" %s \', case coalesce(self.ufl_group,\'\') when \'\' then self.vc_get_name () else self.ufl_group end, cast(self.ufl_value as varchar), case self.ufl_selected when 0 then \'\' else \'checked=\"checked\"\'  end));\n"
"vspx_print_html_attrs (self);\n"
"if (self.ufl_auto_submit) http (\' onclick=\"doAutoSubmit (this.form, this)\"\');\n"
"http (\'/>\');\n"
"}\n";

static const char *other272 = 
"create method vc_view_state (inout stream any, inout n int) for vspx_data_grid\n"
"{\n"
"declare flds any;\n"
"flds :=  vector (serialize(self.dg_last_bookmark), serialize (self.dg_prev_bookmark), self.dg_rows_fetched, self.dg_rowno_edit, self.vc_enabled, self.dg_editable);\n"
"self.vc_push_in_stream (stream, flds, n);\n"
"return;\n"
"}\n";

static const char *other273 = 
"create method uf_column_value (in name varchar) for vspx_update_form\n"
"{\n"
"declare pos int;\n"
"pos := position (name, self.uf_columns);\n"
"if (pos > 0 and length (self.uf_row) >= pos)\n"
"return self.uf_row[pos-1];\n"
"else\n"
"signal (\'22023\', sprintf (\'The column \"%s\" does not exist in rowset\', name));\n"
"}\n";

static const char *other274 = 
"create method vc_view_state (inout stream any, inout n int) for vspx_update_form\n"
"{\n"
"if (length (self.uf_keys) > 0)\n"
"{\n"
"self.vc_push_in_stream (stream, self.uf_keys, n);\n"
"}\n"
"}\n";

static const char *other275 = 
"create method vc_view_state (inout stream any, inout n int) for vspx_update_field\n"
"{\n"
"if (self.vc_page.vc_event.ve_is_post and not self.vc_parent.vc_focus)\n"
"return;\n"
"self.vc_push_in_stream (stream, self.ufl_value, n);\n"
"return;\n"
"}\n";

static const char *udt46 = 
"create type vspx_node_template under vspx_control\n"
"as ( vc_stub any ) temporary self as ref\n";

static const char *udt47 = 
"create type vspx_leaf_template under vspx_control\n"
"as ( vc_stub any ) temporary self as ref\n";

static const char *udt48 = 
"create type vspx_horizontal_template under vspx_control\n"
"as ( vc_stub any ) temporary self as ref\n";

static const char *udt49 = 
"create type vspx_xsd_stub under vspx_control\n"
"as ( vc_stub any ) temporary self as ref\n";

static const char *udt50 = 
"create type vspx_xsd_stub_top under vspx_control\n"
"as ( vc_stub any ) temporary self as ref\n";

static const char *udt51 = 
"create type vspx_xsd_stub_script under vspx_control\n"
"as ( vc_stub any ) temporary self as ref\n";

static const char *proc179 = 
"#line 5059 \"[executable]/vspx.sql\"\n"
"create procedure vspx_get_compiler_signature () returns varchar\n"
"{\n"
"declare res varchar;\n"
"res := \'&proc=2003-12-24 20:31:00.000000\';\n"
"if (\'1\' = registry_get (\'__external_vspx_xslt\'))\n"
"res := concat ( res,\n"
"\'&vspx=\',\n"
"cast (file_stat (concat (http_root (), \'/vspx/vspx.xsl\')) as varchar),\n"
"\'&vspx_expand=\',\n"
"cast (file_stat (concat (http_root (), \'/vspx/vspx_expand.xsl\')) as varchar)\n"
");\n"
"return res;\n"
"}\n"
"--src vspx.sql:5057\n"
;

static const char *proc180 = 
"#line 5074 \"[executable]/vspx.sql\"\n"
"create procedure\n"
"vspx_make_temp_names (in resource_name varchar, inout vspxm_name varchar, inout sql_name varchar)\n"
"returns int\n"
"{\n"
"declare is_temp, is_dav int;\n"
"is_temp := 0;\n"
"is_dav := http_map_get (\'is_dav\');\n"
"\n"
"if (not is_dav and registry_get (\'__no_vspx_temp\') <> \'1\')\n"
"{\n"
"declare tmp_name varchar;\n"
"tmp_name := tmp_file_name (\'vspx\', \'vspx\');\n"
"if (tmp_name is not null)\n"
"{\n"
"is_temp := 1;\n"
"resource_name := tmp_name;\n"
"}\n"
"}\n"
"\n"
"vspxm_name := resource_name;\n"
"if (vspxm_name like \'%.vspx\')\n"
"vspxm_name := substring (vspxm_name, 1, length (vspxm_name) - 5);\n"
"vspxm_name := concat (vspxm_name, \'.vspx-m\');\n"
"\n"
"sql_name := resource_name;\n"
"if (sql_name like \'%.vspx\')\n"
"sql_name := substring (sql_name, 1, length (sql_name) - 5);\n"
"sql_name := concat (sql_name, \'.vspx-sql\');\n"
"\n"
"return is_temp;\n"
"}\n"
"--src vspx.sql:5072\n"
;

static const char *proc181 = 
"#line 5108 \"[executable]/vspx.sql\"\n"
"create function vspx_make_vspxm (\n"
"in resource_name varchar,\n"
"in resource_text varchar,\n"
"in save_vspxm integer,\n"
"in vspxm_name varchar := NULL\n"
") returns any\n"
"{\n"
"declare resource_base_uri varchar;\n"
"\n"
"declare messages any;\n"
"declare expand_ctr integer;\n"
"declare xe, xe_for_xsd, xt any;\n"
"declare xslt_params any;\n"
"declare xslt_add_locations_sheet_name varchar;\n"
"declare xslt_expand_sheet_name varchar;\n"
"declare xslt_pre_xsd_sheet_name varchar;\n"
"declare xslt_pre_sql_sheet_name varchar;\n"
"declare xsd_name varchar;\n"
"declare page_style, xslt_style_uri varchar;\n"
"declare xslt_macro_sheet_name varchar;\n"
"declare xslt_macro_sheet_text varchar;\n"
"declare in_handler integer;\n"
"declare vspx_text_ses any;\n"
"declare old_vspx_text, new_vspx_text varchar;\n"
"declare xe_for_xsd_ses any;\n"
"declare xe_for_xsd_text varchar;\n"
"declare xsd_log varchar;\n"
"xslt_style_uri := null;\n"
"xslt_macro_sheet_name := \'\';\n"
"in_handler := 0;\n"
"xe := 0;\n"
"\n"
"if (vspxm_name is null)\n"
"{\n"
"vspxm_name := resource_name;\n"
"if (vspxm_name like \'%.vspx\')\n"
"vspxm_name := substring (vspxm_name, 1, length (vspxm_name) - 5);\n"
"vspxm_name := concat (vspxm_name, \'.vspx-m\');\n"
"}\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"declare old_in_handler integer;\n"
"old_in_handler := in_handler;\n"
"in_handler := 1;\n"
"if (xslt_style_uri is not null)\n"
"xslt_stale (xslt_macro_sheet_name);\n"
"if ((0 = old_in_handler) and (save_vspxm <> 0))\n"
"{\n"
"declare vspxm any;\n"
"vspxm := string_output();\n"
"http_value (string_output_string (messages), null, vspxm);\n"
"http_value (xe, null, vspxm);\n"
"vspx_src_store (vspxm_name, string_output_string (vspxm));\n"
"commit work;\n"
"}\n"
"resignal;\n"
"};\n"
"messages := string_output();\n"
"resource_base_uri := vspx_base_url (resource_name);\n"
"\n"
"\n"
"\n"
"http (sprintf(\'Preparing Virtuoso/PL from VSPX %s (retrieved from %s)\\n\', resource_name, resource_base_uri), messages);\n"
"if (resource_text is null)\n"
"{\n"
"declare dummy any;\n"
"dummy := 0;\n"
"resource_text := vspx_src_get (resource_name, dummy, 0);\n"
"}\n"
"xe := xtree_doc (resource_text, 256, resource_base_uri);\n"
"xslt_params := vector (\n"
"\'vspx_source\', resource_name,\n"
"\'vspx_source_date\', cast (file_stat (concat (http_root (), resource_name)) as varchar),\n"
"\'vspx_compile_date\', cast (now() as varchar),\n"
"\'vspx_compiler_version\', vspx_get_compiler_signature() );\n"
"if (\'1\' = registry_get (\'__external_vspx_xslt\'))\n"
"{\n"
"xslt_add_locations_sheet_name := \'file://vspx/vspx_add_locations.xsl\';\n"
"xslt_expand_sheet_name := \'file://vspx/vspx_expand.xsl\';\n"
"xslt_pre_xsd_sheet_name := \'file://vspx/vspx_pre_xsd.xsl\';\n"
"xslt_pre_sql_sheet_name := \'file://vspx/vspx_pre_sql.xsl\';\n"
"xsd_name := \'file://vspx/vspx.xsd\';\n"
"http (sprintf(\'VSPX compiler will use external stylesheet %s for macro expansion.\\n\', xslt_expand_sheet_name), messages);\n"
"xml_load_schema_decl (xsd_name, xsd_name, \'UTF-8\', \'x-any\');\n"
"}\n"
"else\n"
"{\n"
"xslt_add_locations_sheet_name := \'http://local.virt/vspx_add_locations\';\n"
"xslt_expand_sheet_name := \'http://local.virt/vspx_expand\';\n"
"xslt_pre_xsd_sheet_name := \'http://local.virt/vspx_pre_xsd\';\n"
"xslt_pre_sql_sheet_name := \'http://local.virt/vspx_pre_sql\';\n"
"xsd_name := \'http://local.virt/vspx.xsd\';\n"
"}\n"
"xe := xslt (xslt_add_locations_sheet_name, xe);\n"
"xml_doc_assign_base_uri (xe, resource_base_uri);\n"
"expand_ctr := 0;\n"
"page_style := xpath_eval (\'[xmlns:v=\"http://www.openlinksw.com/vspx/\"] //v:page/@style\', xe);\n"
"if (page_style is not null)\n"
"{\n"
"http (sprintf(\'The VSPX contains style URI %s\\n\', page_style), messages);\n"
"xslt_style_uri := DB.DBA.XML_URI_RESOLVE_LIKE_GET (resource_base_uri, page_style);\n"
"xslt_macro_sheet_name := concat (xslt_style_uri, \'-internal-\', cast (now() as varchar), \')\');\n"
"http (sprintf(\'The style URI is resolved as %s\\n\', xslt_style_uri), messages);\n"
"xslt_macro_sheet_text := concat (\n"
"\'<?xml version=\'\'1.0\'\'?>\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n"
"version=\"1.0\"\n"
"xmlns:v=\"http://www.openlinksw.com/vspx/\"  exclude-result-prefixes=\"v\"\n"
"xmlns:xhtml=\"http://www.w3.org/1999/xhtml\">\n"
"<xsl:param name=\"vspx_log\" />\n"
"<xsl:output method=\"xml\" omit-xml-declaration=\"no\" indent=\"yes\" />\n"
"\',\n"
"sprintf(\'\\n<xsl:import href=\"%V\"/>\\n<xsl:import href=\"%V\"/>\\n\',\n"
"xslt_style_uri, xslt_expand_sheet_name),\n"
"\'</xsl:stylesheet>\' );\n"
"xslt_sheet (xslt_macro_sheet_name, xtree_doc (xslt_macro_sheet_text, 0, xslt_macro_sheet_name));\n"
"}\n"
"else\n"
"{\n"
"xslt_macro_sheet_name := xslt_expand_sheet_name;\n"
"}\n"
"vspx_text_ses := string_output();\n"
"http_value (xe, null, vspx_text_ses);\n"
"old_vspx_text := string_output_string (vspx_text_ses);\n"
"expand_again:\n"
"http (sprintf(\'Applying %s\\n\', xslt_macro_sheet_name), messages);\n"
"xe := xslt (xslt_macro_sheet_name, xe, xslt_params);\n"
"xml_doc_assign_base_uri (xe, resource_base_uri);\n"
"vspx_text_ses := string_output();\n"
"http_value (xe, null, vspx_text_ses);\n"
"new_vspx_text := string_output_string (vspx_text_ses);\n"
"if (save_vspxm <> 0)\n"
"{\n"
"declare vspxm_ses any;\n"
"vspxm_ses := string_output();\n"
"http_value (string_output_string (messages), null, vspxm_ses);\n"
"http (new_vspx_text, vspxm_ses);\n"
"vspx_src_store (vspxm_name, string_output_string (vspxm_ses));\n"
"}\n"
"if (new_vspx_text = old_vspx_text)\n"
"goto done;\n"
"old_vspx_text := new_vspx_text;\n"
"expand_ctr := expand_ctr + 1;\n"
"if (expand_ctr > 30)\n"
"signal (\'22000\', sprintf(\'Too deep recursion in applying style \'\'%s\'\' to VSPX page \'\'%s\'\'\', xslt_macro_sheet_name, resource_name), \'VX002\');\n"
"goto expand_again;\n"
"done:\n"
"xe := xslt (xslt_macro_sheet_name, xe,\n"
"vector_concat (xslt_params,\n"
"vector (\'vspx_log\', string_output_string (messages)) ) );\n"
"\n"
"if (registry_get (\'vspx_production_mode\') <> \'1\')\n"
"{\n"
"declare dep_files any;\n"
"declare code_files any;\n"
"declare i, l int;\n"
"\n"
"dep_files := xpath_eval (\n"
"\'[xmlns:v=\"http://www.openlinksw.com/vspx/\" \' ||\n"
"\'xmlns:vdeps=\"http://www.openlinksw.com/vspx/deps/\"]\' ||\n"
"\' //v:hidden/@vdeps:url\',\n"
"xe, 0);\n"
"\n"
"code_files := xpath_eval (\n"
"\'[xmlns:v=\"http://www.openlinksw.com/vspx/\" \' ||\n"
"\'xmlns:vdeps=\"http://www.openlinksw.com/vspx/deps/\"]\' ||\n"
"\' //v:hidden/@vdeps:code-file\',\n"
"xe, 0);\n"
"\n"
"i := 0; l := length (code_files);\n"
"while (i < l)\n"
"{\n"
"declare code_file varchar;\n"
"code_file := WS.WS.EXPAND_URL (resource_name, cast (code_files[i] as varchar));\n"
"code_file := vspx_base_url (code_file);\n"
"dep_files := vector_concat (coalesce (dep_files, vector ()), vector (code_file));\n"
"i := i + 1;\n"
"}\n"
"\n"
"if (xslt_style_uri is not null)\n"
"{\n"
"dep_files := vector_concat (coalesce (dep_files, vector ()), vector (xslt_style_uri));\n"
"\n"
"}\n"
"\n"
"registry_set (sprintf (\'%s_file_deps\', resource_name), serialize (vspx_make_stat_vector (dep_files)));\n"
"}\n"
"\n"
"if (\'1\' = registry_get (\'__vspx_validate\'))\n"
"{\n"
"\n"
"xe_for_xsd := xslt (xslt_pre_xsd_sheet_name, xe);\n"
"xe_for_xsd_ses := string_output();\n"
"http_value (xe_for_xsd, null, xe_for_xsd_ses);\n"
"xe_for_xsd_text := string_output_string (xe_for_xsd_ses);\n"
"\n"
"if (save_vspxm <> 0)\n"
"vspx_src_store (concat(vspxm_name,\'-xsd\'), xe_for_xsd_text);\n"
"xsd_log := xml_validate_schema (\n"
"xe_for_xsd_text, 0, concat(vspxm_name,\'-xsd\'), \'LATIN-1\', \'x-any\',\n"
"\'Validation=RIGOROUS Fsa=ERROR FsaBadWs=IGNORE BuildStandalone=ENABLE AttrMissing=ERROR AttrMisformat=ERROR AttrUnknown=ERROR MaxErrors=200\',\n"
"\'xs:\', \':xs\', xsd_name );\n"
"if (save_vspxm <> 0)\n"
"vspx_src_store (concat(vspxm_name,\'-xsd-log\'), xsd_log);\n"
"xml_validate_schema (\n"
"xe_for_xsd_text, 0, concat(vspxm_name,\'-xsd\'), \'LATIN-1\', \'x-any\',\n"
"\'Validation=RIGOROUS Fsa=ERROR FsaBadWs=IGNORE BuildStandalone=ENABLE AttrMissing=ERROR AttrMisformat=ERROR AttrUnknown=ERROR MaxErrors=200 SignalOnError=ENABLE\',\n"
"\'xs:\', \':xs\', xsd_name );\n"
"\n"
"}\n"
"\n"
"if (save_vspxm <> 0)\n"
"{\n"
"declare vspxm_ses any;\n"
"declare vspxm_text varchar;\n"
"vspxm_ses := string_output();\n"
"http_value (xe, null, vspxm_ses);\n"
"vspxm_text := string_output_string (vspxm_ses);\n"
"vspx_src_store (concat (vspxm_name, \'0\'), vspxm_text);\n"
"}\n"
"\n"
"xe := xslt (xslt_pre_sql_sheet_name, xe);\n"
"\n"
"if (save_vspxm <> 0)\n"
"{\n"
"declare vspxm_ses any;\n"
"declare vspxm_text varchar;\n"
"vspxm_ses := string_output();\n"
"http_value (xe, null, vspxm_ses);\n"
"vspxm_text := string_output_string (vspxm_ses);\n"
"vspx_src_store (vspxm_name, vspxm_text);\n"
"}\n"
"if (xslt_style_uri is not null)\n"
"xslt_stale (xslt_macro_sheet_name);\n"
"return xe;\n"
"}\n"
"--src vspx.sql:5106\n"
;

static const char *proc182 = 
"#line 5348 \"[executable]/vspx.sql\"\n"
"create procedure vspx_make_sql (\n"
"in vspx_dbname varchar,\n"
"in vspx_user varchar,\n"
"in resource_name varchar,\n"
"inout vspxm_name varchar,\n"
"inout sql_name varchar,\n"
"in cls_name varchar\n"
")\n"
"{\n"
"declare resource_base_uri varchar;\n"
"\n"
"declare messages any;\n"
"declare xe, xt, dummy any;\n"
"declare xslt_params any;\n"
"declare xslt_main_sheet_name varchar;\n"
"declare subclass_name varchar;\n"
"declare code_files any;\n"
"declare in_handler integer;\n"
"in_handler := 0;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"declare old_in_handler integer;\n"
"old_in_handler := in_handler;\n"
"in_handler := 1;\n"
"resignal;\n"
"};\n"
"messages := string_output();\n"
"resource_base_uri := vspx_base_url (resource_name);\n"
"\n"
"\n"
"\n"
"xe := vspx_make_vspxm (resource_name, null, 1, vspxm_name);\n"
"\n"
"subclass_name := cast (xpath_eval (\'//page[1]/@page-subclass\', xe) as varchar);\n"
"if (subclass_name is null)\n"
"subclass_name := \'\';\n"
"registry_set (concat (\'subclass_name_\', resource_name), fix_identifier_case (subclass_name));\n"
"code_files := xpath_eval (\'[xmlns:v=\"http://www.openlinksw.com/vspx/\" \'||\n"
"\' xmlns:vdeps=\"http://www.openlinksw.com/vspx/deps/\"] //v:hidden/@vdeps:code-file\', xe, 0);\n"
"\n"
"xslt_params := vector (\n"
"\'vspx_dbname\', vspx_dbname,\n"
"\'vspx_user\', vspx_user,\n"
"\'vspx_source\', resource_name,\n"
"\'vspx_source_date\', cast (file_stat (concat (http_root (), resource_name)) as varchar),\n"
"\'vspx_compile_date\', cast (now() as varchar),\n"
"\'vspx_compiler_version\', vspx_get_compiler_signature(),\n"
"\'vspx_local_class_name\', cls_name);\n"
"if (\'1\' = registry_get (\'__external_vspx_xslt\'))\n"
"{\n"
"xslt_main_sheet_name := \'file://vspx/vspx.xsl\';\n"
"http (sprintf(\'-- VSPX compiler will use external stylesheet %s for composing SQL\\n\', xslt_main_sheet_name), messages);\n"
"}\n"
"else\n"
"{\n"
"xslt_main_sheet_name := \'http://local.virt/vspx\';\n"
"}\n"
"xt := xslt (xslt_main_sheet_name, xe, xslt_params);\n"
"http ( sprintf (\'-- The following SQL is created by applying %s:\\n\', xslt_main_sheet_name), messages);\n"
"http_value (xt, null, messages);\n"
"vspx_src_store (sql_name, string_output_string (messages));\n"
"return code_files;\n"
"}\n"
"--src vspx.sql:5346\n"
;

static const char *proc183 = 
"#line 5414 \"[executable]/vspx.sql\"\n"
"create procedure vspx_load_sql (\n"
"in vspx_dbname varchar,\n"
"in vspx_user varchar,\n"
"in resource_name varchar,\n"
"inout sql_name varchar)\n"
"{\n"
"\n"
"declare ses any;\n"
"declare cmd, dbg any;\n"
"declare line varchar;\n"
"declare i, is_drop, curline, sline int;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"ses := 1;\n"
"vspx_src_get (sql_name, ses, 1);\n"
"commit work;\n"
"\n"
"__set_user_id (vspx_user);\n"
"set_qualifier (vspx_dbname);\n"
"cmd := null;\n"
"curline := 0;\n"
"while (1)\n"
"{\n"
"\n"
"line := ses_read_line (ses, 0, 0, 1);\n"
"if (not isstring (line))\n"
"return;\n"
"if (cmd is null and (line like \'create %\' or line like \'drop %\' or line like \'grant %\'))\n"
"{\n"
"cmd := string_output ();\n"
"dbg := string_output ();\n"
"is_drop := 0;\n"
"if (line like \'drop %\')\n"
"is_drop := 1;\n"
"i := 1;\n"
"sline := curline;\n"
"}\n"
"if (rtrim(line, \'\\r\\n \') = \';\')\n"
"{\n"
"declare stmt, stat, msg varchar;\n"
"stmt := string_output_string (cmd);\n"
"if (not is_drop)\n"
"{\n"
"stmt := concat (sprintf (\'#line %d \"%s\"\\n\', sline-1, sql_name), stmt);\n"
"}\n"
"stat := \'00000\'; msg := \'\';\n"
"log_enable (0, 1);\n"
"exec (stmt, stat, msg);\n"
"if (stat = \'00000\')\n"
"{\n"
"commit work;\n"
"}\n"
"else\n"
"{\n"
"rollback work;\n"
"if (not is_drop)\n"
"{\n"
"\n"
"dbg_printf (\'%s\', string_output_string (dbg));\n"
"}\n"
"if (not (stmt like \'drop %\'))\n"
"signal (stat, concat (msg, \'\\nwhile executing the following statement:\\n\', stmt));\n"
"}\n"
"cmd := null;\n"
"dbg := null;\n"
"}\n"
"if (cmd is not null)\n"
"{\n"
"http (line, cmd);\n"
"http (sprintf (\'%03d \', i), dbg);\n"
"http (line, dbg);\n"
"i := i + 1;\n"
"}\n"
"curline := curline + 1;\n"
"}\n"
"}\n"
"--src vspx.sql:5412\n"
;

static const char *proc184 = 
"#line 5495 \"[executable]/vspx.sql\"\n"
"create procedure vspx_src_get (in resource_name varchar, inout ses any, in try_temp int)\n"
"{\n"
"declare is_dav int;\n"
"declare ret any;\n"
"\n"
"is_dav := http_map_get (\'is_dav\');\n"
"\n"
"if (not is_dav)\n"
"{\n"
"if (not (try_temp and registry_get (\'__no_vspx_temp\') <> \'1\'))\n"
"resource_name := concat (http_root (), resource_name);\n"
"\n"
"if (not ses)\n"
"ret := file_to_string (resource_name);\n"
"else\n"
"ses := file_to_string_output (resource_name);\n"
"}\n"
"else\n"
"{\n"
"if (not ses)\n"
"select blob_to_string (RES_CONTENT) into ret from WS.WS.SYS_DAV_RES where RES_FULL_PATH = resource_name;\n"
"else\n"
"{\n"
"declare cnt any;\n"
"ses := string_output ();\n"
"select RES_CONTENT into cnt from WS.WS.SYS_DAV_RES where RES_FULL_PATH = resource_name;\n"
"http (cnt, ses);\n"
"}\n"
"}\n"
"return ret;\n"
"}\n"
"--src vspx.sql:5493\n"
;

static const char *proc185 = 
"#line 5528 \"[executable]/vspx.sql\"\n"
"create procedure vspx_src_store (in resource_name varchar, inout ses any)\n"
"{\n"
"declare is_dav int;\n"
"\n"
"is_dav := http_map_get (\'is_dav\');\n"
"\n"
"if (not is_dav)\n"
"{\n"
"if (registry_get (\'__no_vspx_temp\') <> \'1\')\n"
"string_to_file (resource_name, ses, -2);\n"
"else\n"
"string_to_file (concat (http_root (), resource_name), ses, -2);\n"
"}\n"
"else\n"
"{\n"
"declare rc int;\n"
"log_enable (0, 1);\n"
"rc := DAV_RES_UPLOAD_STRSES_INT (resource_name, ses, \'\', \'110100000NN\',\n"
"coalesce ((select U_NAME from WS.WS.SYS_DAV_USER where U_ID = connection_get (\'DAVUserID\'))),\n"
"coalesce ((select G_NAME from WS.WS.SYS_DAV_GROUP where G_ID = connection_get (\'DAVGroupID\'))),\n"
"null, null, 0);\n"
"\n"
"if (rc < 0)\n"
"signal (\'42000\', sprintf (\'Can\'\'t store the file \'\'%s\'\': DAV error %d\', resource_name, rc) , \'DA010\');\n"
"}\n"
"return;\n"
"}\n"
"--src vspx.sql:5526\n"
;

static const char *proc186 = 
"#line 5557 \"[executable]/vspx.sql\"\n"
"create procedure vspx_base_url (in f varchar)\n"
"{\n"
"if (http_map_get (\'is_dav\'))\n"
"return concat (\'virt://WS.WS.SYS_DAV_RES.RES_FULL_PATH.RES_CONTENT:\',f);\n"
"else\n"
"return concat (\'file://\', f);\n"
"}\n"
"--src vspx.sql:5555\n"
;

static const char *proc187 = 
"#line 5566 \"[executable]/vspx.sql\"\n"
"create procedure vsxp_src_stat (in f varchar)\n"
"{\n"
"if (http_map_get (\'is_dav\'))\n"
"{\n"
"declare tim datetime;\n"
"select RES_MOD_TIME into tim from WS.WS.SYS_DAV_RES where RES_FULL_PATH = f;\n"
"return tim;\n"
"}\n"
"else\n"
"return file_stat (concat (http_root (), f));\n"
"}\n"
"--src vspx.sql:5564\n"
;

static const char *proc188 = 
"#line 5579 \"[executable]/vspx.sql\"\n"
"create procedure vspx_url_stat (in base_uri varchar)\n"
"{\n"
"declare s_url any;\n"
"s_url := WS.WS.PARSE_URI (base_uri);\n"
"if (s_url[0] = \'virt\')\n"
"{\n"
"s_url := split_and_decode (base_uri, 0, \'\\0\\0:\');\n"
"if (s_url[1] <> \'//WS.WS.SYS_DAV_RES.RES_FULL_PATH.RES_CONTENT\')\n"
"return 0;\n"
"declare tim datetime;\n"
"select RES_MOD_TIME into tim from WS.WS.SYS_DAV_RES where RES_FULL_PATH = s_url[2];\n"
"return cast (tim as varchar);\n"
"}\n"
"else if (s_url[0] = \'file\')\n"
"{\n"
"s_url := split_and_decode (base_uri, 0, \'\\0\\0:\');\n"
"return file_stat (concat (http_root (), s_url[1]));\n"
"}\n"
"else\n"
"return 0;\n"
"}\n"
"--src vspx.sql:5577\n"
;

static const char *proc189 = 
"#line 5602 \"[executable]/vspx.sql\"\n"
"create procedure vspx_make_stat_vector (in dep_files any)\n"
"{\n"
"declare inx integer;\n"
"declare dep_string any;\n"
"inx := 0;\n"
"dep_string := null;\n"
"while (inx < length (dep_files))\n"
"{\n"
"declare f_stat any;\n"
"declare f_name varchar;\n"
"\n"
"f_name := cast (dep_files[inx] as varchar);\n"
"f_stat := vspx_url_stat (f_name);\n"
"if (isstring (f_stat))\n"
"dep_string := vector_concat (coalesce (dep_string, vector()) , vector (f_name, f_stat));\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"return dep_string;\n"
"}\n"
"--src vspx.sql:5600\n"
;

static const char *proc190 = 
"#line 5624 \"[executable]/vspx.sql\"\n"
"create procedure vspx_check_file_deps (in resource_name varchar)\n"
"{\n"
"if (registry_get (\'vspx_production_mode\') <> \'1\')\n"
"{\n"
"declare dep_vector any;\n"
"declare inx integer;\n"
"dep_vector := registry_get (sprintf (\'%s_file_deps\', resource_name));\n"
"\n"
"if (not isstring (dep_vector))\n"
"return 1;\n"
"\n"
"dep_vector := deserialize (dep_vector);\n"
"\n"
"if (not isarray (dep_vector))\n"
"return 1;\n"
"\n"
"inx := 0;\n"
"while (inx < length (dep_vector))\n"
"{\n"
"declare saved_stat, saved_url, real_stat varchar;\n"
"\n"
"saved_url := dep_vector[inx];\n"
"saved_stat := dep_vector[inx + 1];\n"
"\n"
"real_stat := vspx_url_stat (saved_url);\n"
"\n"
"if (real_stat <> saved_stat)\n"
"return 0;\n"
"\n"
"inx := inx + 2;\n"
"}\n"
"}\n"
"return 1;\n"
"}\n"
"--src vspx.sql:5622\n"
;

static const char *proc191 = 
"#line 5660 \"[executable]/vspx.sql\"\n"
"create function\n"
"vspx_get_subclass_name (in resource_name varchar, in class_name varchar) returns varchar\n"
"{\n"
"declare subclass_name varchar;\n"
"declare len integer;\n"
"\n"
"subclass_name := registry_get (concat (\'subclass_name_\', resource_name));\n"
"if (isstring (subclass_name) and subclass_name <> \'\')\n"
"{\n"
"return subclass_name;\n"
"}\n"
"return class_name;\n"
"}\n"
"--src vspx.sql:5658\n"
;

static const char *proc192 = 
"#line 5675 \"[executable]/vspx.sql\"\n"
"create function\n"
"vspx_get_class_name (\n"
"in resource_name varchar ) returns varchar\n"
"{\n"
"declare class_name varchar;\n"
"declare len integer;\n"
"\n"
"class_name := fix_identifier_case (resource_name);\n"
"class_name := replace (class_name, \'/\', \'!\');\n"
"class_name := replace (class_name, \':\', \'!\');\n"
"class_name := replace (class_name, \'.\', \'!\');\n"
"class_name := replace (class_name, \'-\', \'!\');\n"
"class_name := replace (class_name, \' \', \'!\');\n"
"class_name := replace (class_name, \'_\', \'__\');\n"
"class_name := replace (class_name, \'!\', \'_\');\n"
"len := length (class_name);\n"
"if (len >= 32)\n"
"class_name := concat (md5 (class_name), subseq (class_name, len-31));\n"
"return fix_identifier_case (concat (\'page_\', class_name));\n"
"}\n"
"--src vspx.sql:5673\n"
;

static const char *proc193 = 
"#line 5697 \"[executable]/vspx.sql\"\n"
"create procedure vspx_get_signature (in dbname varchar, in usr varchar, in res varchar)\n"
"{\n"
"declare signature varchar;\n"
"signature := concat (\n"
"\'&dbname=\', dbname,\n"
"\'&user=\', usr,\n"
"\'&src=\', cast (vsxp_src_stat (res) as varchar),\n"
"vspx_get_compiler_signature() );\n"
"return signature;\n"
"}\n"
"--src vspx.sql:5695\n"
;

static const char *proc194 = 
"#line 5709 \"[executable]/vspx.sql\"\n"
"create procedure vspx_load_code (in vspx_dbname varchar, in vspx_user varchar,\n"
"in resource_name varchar, in code_files any)\n"
"{\n"
"declare i, l int;\n"
"declare is_dav int;\n"
"\n"
"is_dav := http_map_get (\'is_dav\');\n"
"i := 0; l := length (code_files);\n"
"while (i < l)\n"
"{\n"
"declare url any;\n"
"url := cast (code_files[i] as varchar);\n"
"url := WS.WS.EXPAND_URL (resource_name, url);\n"
"\n"
"dbg_printf (\'Loading: [%s]\', url);\n"
"if (not is_dav and registry_get (\'__no_vspx_temp\') <> \'1\')\n"
"url := concat (http_root (), url);\n"
"vspx_load_sql (vspx_dbname, vspx_user, resource_name, url);\n"
"dbg_printf (\'Done: [%s]\', url);\n"
"i := i + 1;\n"
"}\n"
"}\n"
"--src vspx.sql:5707\n"
;

static const char *proc195 = 
"#line 5733 \"[executable]/vspx.sql\"\n"
"create procedure vspx_report_debug_log (in page vspx_page)\n"
"{\n"
"declare sheet_name varchar;\n"
"if (\'1\' = registry_get (\'__external_vspx_xslt\'))\n"
"sheet_name := \'file://vspx/vspx_log_format.xsl\';\n"
"else\n"
"sheet_name := \'http://local.virt/vspx_log_format\';\n"
"http (\']]>-\' || \'->]]></table></div></ins></del><hr>\');\n"
"http_value (xslt (sheet_name, page.vc_get_debug_log(\'xmp\'), vector(\'tgt\',\'http\')));\n"
"}\n"
"--src vspx.sql:5731\n"
;

static const char *proc196 = 
"#line 5745 \"[executable]/vspx.sql\"\n"
"create procedure vspx_get_user_info (inout vspx_dbname varchar, inout vspx_user varchar)\n"
"{\n"
"\n"
"vspx_dbname := fix_identifier_case (dbname());\n"
"\n"
"vspx_user := fix_identifier_case (http_map_get (\'vsp_uid\'));\n"
"}\n"
"--src vspx.sql:5743\n"
;

static const char *proc197 = 
"#line 5755 \"[executable]/vspx.sql\"\n"
"create procedure\n"
"vspx_dispatch (in resource_name varchar, inout path any, inout params any, inout lines any, in class_name varchar := null, in compile_only int := 0, in vspx_dbname varchar := NULL, in vspx_user varchar := NULL)\n"
"{\n"
"declare signature varchar;\n"
"declare compile, executed, now int;\n"
"declare recompilation_is_allowed int;\n"
"declare page vspx_page;\n"
"declare full_class_name, q_full_class_name varchar;\n"
"declare subclass_name, full_subclass_name, q_full_subclass_name varchar;\n"
"declare h any;\n"
"declare new_signature varchar;\n"
"declare vspxm_name, sql_name varchar;\n"
"declare unlink, deadl int;\n"
"declare res_pos, tmp, vdir, vres, code_files any;\n"
"\n"
"\n"
"\n"
"if (vspx_user is null and vspx_dbname is null)\n"
"vspx_get_user_info (vspx_dbname, vspx_user);\n"
"if (class_name is null)\n"
"class_name := vspx_get_class_name (resource_name);\n"
"full_class_name := concat (vspx_dbname, \'.\', vspx_user, \'.\', class_name);\n"
"q_full_class_name := concat (\'\"\',vspx_dbname, \'\".\"\', vspx_user, \'\".\', class_name);\n"
"\n"
"subclass_name := vspx_get_subclass_name (resource_name, class_name);\n"
"full_subclass_name := concat (vspx_dbname, \'.\', vspx_user, \'.\', subclass_name);\n"
"q_full_subclass_name := concat (\'\"\',vspx_dbname, \'\".\"\', vspx_user, \'\".\', subclass_name);\n"
"signature := vspx_get_signature (vspx_dbname, vspx_user, resource_name);\n"
"\n"
"unlink := 0; vspxm_name := NULL; sql_name := NULL;\n"
"\n"
"if ((registry_get (resource_name) = signature) and udt_is_available (full_subclass_name)\n"
"and vspx_check_file_deps (resource_name)) {\n"
"goto run;\n"
"}\n"
"\n"
"icc_lock_at_commit (\'vspx_dispatch\', 1);\n"
"commit work;\n"
"log_enable (0);\n"
"\n"
"if ((registry_get (resource_name) = signature) and udt_is_available (full_subclass_name)\n"
"and vspx_check_file_deps (resource_name)) {\n"
"icc_unlock_now (\'vspx_dispatch\');\n"
"goto run;\n"
"}\n"
"\n"
"generate:\n"
"{\n"
"\n"
"declare stat, msg varchar;\n"
"declare exit handler for sqlstate \'*\' {\n"
"\n"
"if (udt_is_available (full_subclass_name) and subclass_name <> class_name)\n"
"exec (concat (\'drop type \', q_full_subclass_name), stat, msg);\n"
"if (udt_is_available (full_class_name))\n"
"exec (concat (\'drop type \', q_full_class_name), stat, msg );\n"
"registry_set (resource_name, \'\');\n"
"if (unlink) {\n"
"\n"
"file_delete (vspxm_name, 1);\n"
"file_delete (vspxm_name||\'0\', 1);\n"
"file_delete (sql_name, 1);\n"
"}\n"
"log_enable (1);\n"
"icc_unlock_now (\'vspx_dispatch\');\n"
"prof_sample (\'VSPX compilation\', msec_time () - now, 4);\n"
"resignal;\n"
"};\n"
"\n"
"registry_set (resource_name, concat (signature, \'!\'));\n"
"now := msec_time ();\n"
"stat := \'00000\';\n"
"msg := \'\';\n"
"unlink := vspx_make_temp_names (resource_name, vspxm_name, sql_name);\n"
"code_files := vspx_make_sql (vspx_dbname, vspx_user, resource_name, vspxm_name, sql_name, class_name);\n"
"\n"
"subclass_name := vspx_get_subclass_name (resource_name, class_name);\n"
"full_subclass_name := concat (vspx_dbname, \'.\', vspx_user, \'.\', subclass_name);\n"
"if (subclass_name <> class_name)\n"
"exec (concat (\'drop type \', q_full_subclass_name), stat, msg);\n"
"exec (concat (\'drop type \', q_full_class_name), stat, msg );\n"
"\n"
"vspx_load_sql (vspx_dbname, vspx_user, resource_name, sql_name);\n"
"vspx_load_code (vspx_dbname, vspx_user, resource_name, code_files);\n"
"compile := msec_time () - now;\n"
"registry_set (resource_name, signature);\n"
"if (unlink) {\n"
"\n"
"file_delete (vspxm_name, 1);\n"
"file_delete (vspxm_name||\'0\', 1);\n"
"file_delete (sql_name, 1);\n"
"}\n"
"log_enable (0, 1);\n"
"exec (concat (\'grant execute on \', q_full_class_name, \' to \"\', vspx_user, \'\"\'), stat, msg);\n"
"if (subclass_name <> class_name)\n"
"exec (concat (\'grant execute on \', q_full_subclass_name, \' to \"\', vspx_user, \'\"\'), stat, msg);\n"
"commit work;\n"
"icc_unlock_now (\'vspx_dispatch\');\n"
"goto run;\n"
"}\n"
"\n"
"run:\n"
"log_enable (1, 1);\n"
"\n"
"if (compile_only)\n"
"return null;\n"
"\n"
"now := msec_time ();\n"
"deadl := null;\n"
"__set_user_id (http_map_get (\'vsp_uid\'));\n"
"set_qualifier (vspx_dbname);\n"
"run_again:\n"
"page := __udt_instantiate_class (full_subclass_name, -1);\n"
"page.vc_page := page;\n"
"h := udt_implements_method (page, class_name, 1);\n"
"if (h) {\n"
"declare ss any;\n"
"declare icnt int;\n"
"declare exit handler for sqlstate \'*\', not found {\n"
"declare rc int;\n"
"\n"
"rollback work;\n"
"if (page.vc_debug_log_acc is not null)\n"
"page.vc_debug_log (\'begin\', \'Page error handler\', sprintf(\'Error: \'\'%s\'\': %s\', __SQL_STATE, __SQL_MESSAGE));\n"
"rc := page.vc_handle_error (__SQL_STATE, __SQL_MESSAGE, deadl);\n"
"if (not rc) {\n"
"prof_sample (resource_name, msec_time () - now, 4);\n"
"if (page.vc_debug_log_acc is not null)\n"
"{\n"
"page.vc_debug_log (\'fatal\', \'Page error handler has returned zero.\', null);\n"
"vspx_report_debug_log (page);\n"
"return;\n"
"}\n"
"resignal;\n"
"}\n"
"if (isinteger (deadl) and deadl > 0 and __SQL_STATE = \'40001\') {\n"
"goto run_again;\n"
"}\n"
"if (page.vc_debug_log_acc is not null)\n"
"{\n"
"page.vc_debug_log (\'fatal\', \'Page error handler has handled the error.\', null);\n"
"vspx_report_debug_log (page);\n"
"return;\n"
"}\n"
"return;\n"
"};\n"
"call (h) (page, path, params, lines);\n"
"page.vc_data_bind (page.vc_event);\n"
"if (page.vc_event.ve_is_post) {\n"
"page.vc_post(page.vc_event);\n"
"page.vc_user_post(page.vc_event);\n"
"page.vc_action(page.vc_event);\n"
"}\n"
"ss := string_output ();\n"
"icnt := 0;\n"
"page.vc_pre_render (ss, icnt);\n"
"page.vc_state_deserialize (ss, icnt);\n"
"page.vc_render ();\n"
"executed :=  msec_time () - now;\n"
"}\n"
"if (\'1\' = registry_get (\'__external_vspx_xslt\')) {\n"
"dbg_obj_print (sprintf (\'Compiled: %d, Executed: %d\', compile, executed));\n"
"}\n"
"if (compile <> 0)\n"
"prof_sample (\'VSPX compilation\', compile, 1);\n"
"prof_sample (resource_name, executed, 1);\n"
"if (page.vc_debug_log_acc is not null)\n"
"vspx_report_debug_log (page);\n"
"return page;\n"
"}\n"
"--src vspx.sql:5753\n"
;

static const char *proc198 = 
"#line 5928 \"[executable]/vspx.sql\"\n"
"create procedure\n"
"vspx_verify_pass (in auth_vec any, in passwd varchar)\n"
"{\n"
"return vsp_auth_verify_pass (auth_vec,\n"
"get_keyword (\'username\' , auth_vec, \'\'),\n"
"get_keyword (\'realm\', auth_vec, \'\'),\n"
"get_keyword (\'uri\', auth_vec, \'\'),\n"
"get_keyword (\'nonce\', auth_vec, \'\'),\n"
"get_keyword (\'nc\', auth_vec, \'\'),\n"
"get_keyword (\'cnonce\', auth_vec, \'\'),\n"
"get_keyword (\'qop\', auth_vec, \'\'),\n"
"passwd);\n"
"}\n"
"--src vspx.sql:5926\n"
;

static const char *proc199 = 
"#line 5944 \"[executable]/vspx.sql\"\n"
" create procedure\n"
"vspx_get_cookie_vec (in lines any)\n"
"{\n"
"declare cookie_vec any;\n"
"declare i,l int;\n"
"declare cookie_str varchar;\n"
"cookie_str := http_request_header (lines, \'Cookie\');\n"
"\n"
"if (not isstring (cookie_str))\n"
"return vector ();\n"
"cookie_vec := split_and_decode (cookie_str, 0, \'\\0\\0;=\');\n"
"i := 0; l := length (cookie_vec);\n"
"while (i < l)\n"
"{\n"
"declare kw, var varchar;\n"
"kw := trim (cookie_vec[i]);\n"
"var := cookie_vec[i+1];\n"
"if (var is not null)\n"
"var := trim (var);\n"
"aset (cookie_vec, i, kw);\n"
"aset (cookie_vec, i + 1, var);\n"
"i := i + 2;\n"
"}\n"
"return cookie_vec;\n"
"}\n"
"--src vspx.sql:5942\n"
;

static const char *proc200 = 
"#line 5972 \"[executable]/vspx.sql\"\n"
" create procedure\n"
"vspx_do_compact (in arr any) returns any\n"
"{\n"
"declare i, l int;\n"
"declare ret any;\n"
"if (arr is null or not isarray (arr))\n"
"return arr;\n"
"i := 0; l := length (arr);\n"
"if (mod(l,2))\n"
"return arr;\n"
"ret := vector ();\n"
"while (i < l)\n"
"{\n"
"if (arr[i] is not null and arr[i+1] is not null)\n"
"ret := vector_concat (ret, vector (arr[i], arr[i+1]));\n"
"i := i + 2;\n"
"}\n"
"return ret;\n"
"}\n"
"--src vspx.sql:5970\n"
;

static const char *proc201 = 
"#line 5997 \"[executable]/vspx.sql\"\n"
" create procedure DB.DBA.VSPX_COLUMNS_META (in sql varchar)\n"
"{\n"
"declare mtd, res any;\n"
"declare i, l int;\n"
"exec_metadata (sql, null, null, mtd);\n"
"res := string_output ();\n"
"mtd := mtd[0];\n"
"i := 0; l := length (mtd);\n"
"while (i < l)\n"
"{\n"
"declare colname varchar;\n"
"if (isstring (mtd[i][8]))\n"
"colname := mtd[i][8];\n"
"else\n"
"colname := mtd[i][0];\n"
"http (sprintf (\'<column name=\"%s\" />\\n\', colname), res);\n"
"i := i + 1;\n"
"}\n"
"return xml_tree_doc(string_output_string (res));\n"
"}\n"
"--src vspx.sql:5995\n"
;

static const char *other276 = 
"grant execute on DB.DBA.VSPX_COLUMNS_META to public\n";
static const char *proc202 = 
"#line 6023 \"[executable]/vspx.sql\"\n"
" create procedure VSPX_COLUMNS_META_TYPES (in col varchar, in tab varchar)\n"
"{\n"
"declare mtd, res, sql, ty any;\n"
"declare i, l int;\n"
"sql := \'select \' || col || \' from \' || tab;\n"
"exec_metadata (sql, null, null, mtd);\n"
"mtd := mtd[0];\n"
"i := 0; l := length (mtd);\n"
"if (l > 0 and length (mtd[0]) > 1)\n"
"{\n"
"ty := lower (dv_type_title (mtd[0][1]));\n"
"if (ty like \'long %\')\n"
"ty := substring (ty, 6, length (ty));\n"
"res := ty;\n"
"return res;\n"
"}\n"
"else\n"
"return \'varchar\';\n"
"}\n"
"--src vspx.sql:6021\n"
;

static const char *other277 = 
"grant execute on DB.DBA.VSPX_COLUMNS_META_TYPES to public\n";
static const char *proc203 = 
"#line 6047 \"[executable]/vspx.sql\"\n"
"create procedure VSPX_PK_COLUMNS (in tab varchar)\n"
"{\n"
"declare ses, ret any;\n"
"ses := string_output ();\n"
"for select \\COLUMN from\n"
"DB.DBA.SYS_KEYS v1,\n"
"DB.DBA.SYS_KEYS v2,\n"
"DB.DBA.SYS_KEY_PARTS kp,\n"
"DB.DBA.SYS_COLS\n"
"where\n"
"0 = casemode_strcmp (v1.key_table, tab)\n"
"and __any_grants (v1.KEY_TABLE)\n"
"and v1.KEY_IS_MAIN = 1\n"
"and v1.KEY_MIGRATE_TO is NULL\n"
"and v1.KEY_SUPER_ID = v2.KEY_ID\n"
"and kp.KP_KEY_ID = v1.KEY_ID\n"
"and kp.KP_NTH < v1.KEY_DECL_PARTS\n"
"and COL_ID = kp.KP_COL and \\COLUMN <> \'_IDN\'\n"
"order by v1.KEY_TABLE, kp.KP_NTH do\n"
"{\n"
"http (sprintf (\'<column name=\"%s\" />\\n\', \\COLUMN), ses);\n"
"}\n"
"ret := string_output_string (ses);\n"
"if (length (ret) = 0)\n"
"ret := \'<void />\';\n"
"return xml_tree_doc(ret);\n"
"}\n"
"--src vspx.sql:6045\n"
;

static const char *other278 = 
"grant execute on VSPX_PK_COLUMNS to public\n";
static const char *other279 = 
"insert soft DB.DBA.SYS_XPF_EXTENSIONS (XPE_NAME, XPE_PNAME) VALUES (\'http://www.openlinksw.com/vspx/:columns_meta\', \'DB.DBA.VSPX_COLUMNS_META\')\n";
static const char *other280 = 
"insert soft DB.DBA.SYS_XPF_EXTENSIONS (XPE_NAME, XPE_PNAME) VALUES (\'http://www.openlinksw.com/vspx/:columns_type\', \'DB.DBA.VSPX_COLUMNS_META_TYPES\')\n";
static const char *other281 = 
"insert soft DB.DBA.SYS_XPF_EXTENSIONS (XPE_NAME, XPE_PNAME) VALUES (\'http://www.openlinksw.com/vspx/:pk_columns\', \'DB.DBA.VSPX_PK_COLUMNS\')\n";
static const char *other282 = 
"xpf_extension (\'http://www.openlinksw.com/vspx/:columns_meta\', \'DB.DBA.VSPX_COLUMNS_META\', 0)\n";
static const char *other283 = 
"xpf_extension (\'http://www.openlinksw.com/vspx/:columns_type\', \'DB.DBA.VSPX_COLUMNS_META_TYPES\', 0)\n";
static const char *other284 = 
"xpf_extension (\'http://www.openlinksw.com/vspx/:pk_columns\', \'DB.DBA.VSPX_PK_COLUMNS\', 0)\n";
static const char *proc204 = 
"#line 6106 \"[executable]/vspx.sql\"\n"
" create procedure\n"
"dbg_vspx_control (in control vspx_control, in tab int default 0)\n"
"{\n"
"declare i, l int;\n"
"declare chil vspx_control;\n"
"declare uf vspx_field;\n"
"declare sp, val, und varchar;\n"
"if (control is null or not udt_instance_of (control, fix_identifier_case (\'vspx_control\')))\n"
"return;\n"
"l := length (control.vc_children);\n"
"if (not tab)\n"
"dbg_obj_print (\'=============BEGIN=============\');\n"
"if (tab >= 2)\n"
"{\n"
"sp := repeat (\' \', tab);\n"
"sp := concat(sp, \'+-\');\n"
"}\n"
"else\n"
"sp := repeat (\' \', tab);\n"
"\n"
"if (control.vc_inside_form)\n"
"und := \'*\';\n"
"else\n"
"und := \'-\';\n"
"\n"
"uf := null;\n"
"val := \'NONE\';\n"
"if (udt_instance_of (control, fix_identifier_case (\'vspx_field\')))\n"
"{\n"
"declare _ctrl any;\n"
"_ctrl := control;\n"
"uf := _ctrl;\n"
"if (not isstring (uf.ufl_value) and isarray(uf.ufl_value))\n"
"val := sprintf (\'vector (l=%d)\', length(uf.ufl_value));\n"
"else\n"
"val := cast (uf.ufl_value as varchar);\n"
"}\n"
"dbg_obj_print (substring (sprintf (\'%s%s%s (%s) (%s) %s %s [value=%s] %s\', sp, und, control.vc_name, udt_instance_of (control), control.vc_instance_name, case control.vc_focus when 1 then \'In focus\' else \'\' end, case control.vc_enabled when 1 then \'\' else \'DISABLED\' end, val, case when uf is not null and uf.ufl_selected then \'SELECTED\' else \'\' end), 1, 120));\n"
"if (l and not (l = 1 and control.vc_children[0] is null))\n"
"dbg_obj_print (sprintf (\'%s|\', repeat (\' \', tab+2)));\n"
"while (i < l)\n"
"{\n"
"chil := control.vc_children[i];\n"
"if (chil is not null)\n"
"dbg_vspx_control (chil, tab + 2);\n"
"i := i + 1;\n"
"}\n"
"if (not tab)\n"
"dbg_obj_print (\'=============END=============\');\n"
"}\n"
"--src vspx.sql:6104\n"
;

static const char *proc205 = 
"#line 6159 \"[executable]/vspx.sql\"\n"
" create procedure\n"
"vspx_uri_compose (in res any)\n"
"{\n"
"declare _full_path, _elm varchar;\n"
"declare idx integer;\n"
"\n"
"if (length (res) < 6)\n"
"signal (\'.....\', \'vspx_uri_compose needs a vector of lenght 6 or greater\');\n"
"\n"
"idx := 0;\n"
"_elm := \'\';\n"
"_full_path := \'\';\n"
"while (idx < 6)\n"
"{\n"
"_elm := res[idx];\n"
"if (isstring (_elm) and _elm <> \'\')\n"
"{\n"
"if (idx = 0)\n"
"_full_path := concat (_elm, \':\');\n"
"else if (idx = 1)\n"
"_full_path := concat (_full_path, \'//\', _elm);\n"
"else if (idx = 2)\n"
"_full_path := concat (_full_path, _elm);\n"
"else if (idx = 3)\n"
"_full_path := concat (_full_path, \';\', _elm);\n"
"else if (idx = 4)\n"
"_full_path := concat (_full_path, \'?\', _elm);\n"
"else if (idx = 5)\n"
"_full_path := concat (_full_path, \'#\', _elm);\n"
"}\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"return _full_path;\n"
"}\n"
"--src vspx.sql:6157\n"
;

static const char *proc206 = 
"#line 6197 \"[executable]/vspx.sql\"\n"
" create procedure\n"
"vspx_uri_add_parameters (in uri varchar, in pars varchar)\n"
"{\n"
"declare hinfo any;\n"
"declare par_str varchar;\n"
"uri := cast (uri as varchar);\n"
"hinfo := WS.WS.PARSE_URI (uri);\n"
"par_str := hinfo[4];\n"
"if (par_str <> \'\' and pars <> \'\')\n"
"par_str := par_str || \'&\' || pars;\n"
"else if (pars <> \'\')\n"
"par_str := pars;\n"
"aset (hinfo, 4, par_str);\n"
"return vspx_uri_compose (hinfo);\n"
"}\n"
"--src vspx.sql:6195\n"
;

static const char *proc207 = 
"#line 6216 \"[executable]/vspx.sql\"\n"
" create procedure vspx_xforms_params_parse (inout cnt any)\n"
"{\n"
"declare xt, ret, ss any;\n"
"if (not xslt_is_sheet (\'http://local.virt/xforms_params\'))\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"http (\'<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">\', ses);\n"
"http (\'<xsl:output method=\"text\" omit-xml-declaration=\"yes\" indent=\"yes\" />\', ses);\n"
"http (\'<xsl:template match=\"/\">\', ses);\n"
"http (\'<xsl:apply-templates select=\"post/*\" />\', ses);\n"
"http (\'</xsl:template>\', ses);\n"
"http (\'<xsl:template match=\"event__target\">&amp;<xsl:value-of select=\".\"/>=<xsl:value-of select=\".\"/></xsl:template>\', ses);\n"
"http (\'<xsl:template match=\"*\">&amp;<xsl:value-of select=\"local-name()\"/>=<xsl:value-of select=\".\" disable-output-escaping=\"yes\"/></xsl:template>\', ses);\n"
"http (\'</xsl:stylesheet>\', ses);\n"
"xslt_sheet (\'http://local.virt/xforms_params\', xml_tree_doc (xml_tree (ses)));\n"
"}\n"
"\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"return vector (\'Content\', cnt);\n"
"};\n"
"xt := xslt (\'http://local.virt/xforms_params\', xml_tree_doc (xml_tree (cnt)));\n"
"ss := string_output ();\n"
"http_value (xt, null, ss);\n"
"xt := string_output_string (ss);\n"
"ret := split_and_decode (xt, 0, \'\\0\\0&=\');\n"
"return ret;\n"
"}\n"
"--src vspx.sql:6214\n"
;

static const char *other285 = 
"insert soft \"DB\".\"DBA\".\"SYS_SCHEDULED_EVENT\" (SE_INTERVAL, SE_LAST_COMPLETED, SE_NAME, SE_SQL, SE_START)\n"
"values (1440, NULL, \'VSPX_SESSION_EXPIRE\', \'VSPX_EXPIRE_SESSIONS ()\', now())\n";
static const char *proc208 = 
"#line 6255 \"[executable]/vspx.sql\"\n"
"create procedure\n"
"VSPX_EXPIRE_SESSIONS ()\n"
"{\n"
"delete from VSPX_SESSION where VS_EXPIRY is null;\n"
"delete from VSPX_SESSION where datediff (\'minute\', VS_EXPIRY, now()) > 30;\n"
"\n"
"\n"
"}\n"
"--src vspx.sql:6253\n"
;

static const char *proc209 = 
"#line 6266 \"[executable]/vspx.sql\"\n"
"create procedure DB.DBA.sys_xpath_localfile_eval(in content any, in expr any) {\n"
"declare retval, result, pos, eval_result integer;\n"
"declare pwd, dav_content any;\n"
"declare xml_tree, xml_entity any;\n"
"\n"
"select pwd_magic_calc(\'dav\', U_PASSWORD, 1) into pwd from DB.DBA.SYS_USERS where U_NAME=\'dav\' and U_IS_ROLE=0;\n"
"retval := 0;\n"
"\n"
"result := cast(DB.DBA.DAV_SEARCH_ID(\'/DAV/temp/\', \'c\') as integer);\n"
"if(result < 0) {\n"
"\n"
"result := cast(DB.DBA.DAV_COL_CREATE(\'/DAV/temp/\', \'110110110R\', \'dav\', \'dav\', \'dav\', pwd) as integer);\n"
"if(result < 0) {\n"
"signal(\'XP001\', \'DAV Collection /DAV/temp/ can not be created.\');\n"
"return;\n"
"}\n"
"}\n"
"\n"
"result := cast(DB.DBA.DAV_RES_UPLOAD(\'/DAV/temp/temp.xml\', content, \'text/html\',\'110110110R\',\'dav\',\'dav\',\'dav\',pwd) as INTEGER);\n"
"if(result < 0) {\n"
"signal(\'XP002\', \'DAV Resource /DAV/temp/temp.xml can not be uploaded.\');\n"
"return;\n"
"}\n"
"\n"
"select blob_to_string(RES_CONTENT) into dav_content from WS.WS.SYS_DAV_RES where RES_FULL_PATH = \'/DAV/temp/temp.xml\';\n"
"\n"
"\n"
"{\n"
"again:\n"
"pos := strstr(dav_content, \'---BODY\');\n"
"if (pos is not null)\n"
"{\n"
"dav_content := subseq(dav_content, pos + length(\'---BODY\'));\n"
"goto again;\n"
"}\n"
"}\n"
"\n"
"pos := strstr(dav_content, \'\\n\');\n"
"dav_content := subseq(dav_content, pos + 1);\n"
"pos := strstr(dav_content, \'---END BODY\');\n"
"dav_content := subseq(dav_content, 0, pos);\n"
"\n"
"xml_entity := xtree_doc (dav_content, 0);\n"
"\n"
"eval_result := xpath_eval(expr, xml_entity, 1);\n"
"dbg_obj_print(eval_result);\n"
"\n"
"delete from WS.WS.SYS_DAV_RES where RES_FULL_PATH = \'/DAV/temp/temp.xml\';\n"
"\n"
"result(eval_result);\n"
"return retval;\n"
"}\n"
"--src vspx.sql:6264\n"
;

static const char *proc210 = 
"#line 6320 \"[executable]/vspx.sql\"\n"
"create procedure DB.DBA.sys_save_http_history(in vdir any, in vres any)\n"
"{\n"
"declare _ext, result, name, content, pwd, cnt any;\n"
"\n"
"if (registry_get (\'__block_http_history\') = http_path ()) \n"
"{\n"
"return;\n"
"}\n"
"vres := trim (vres);\n"
"\n"
"_ext := subseq (vres, strrchr (vres, \'.\') + 1);\n"
"if (exists (select 1 from WS.WS.HTTP_SES_TRAP_DISABLE where lcase (EXT) = lcase (_ext)))\n"
"return;\n"
"\n"
"\n"
"if (length (vres) > 0) \n"
"{\n"
"declare p any;\n"
"p := strstr (vres, \'?\');\n"
"if (p) \n"
"{\n"
"vres := subseq(vres, 0, p);\n"
"}\n"
"}\n"
"name := sprintf (\'%06d%s\', sequence_next (\'sys_http_recording\'), vres);\n"
"name := replace (name, \'-\', \'_\');\n"
"name := replace (name, \' \', \'_\');\n"
"name := replace (name, \':\', \'_\');\n"
"name := replace (name, \'/\', \'_\');\n"
"name := replace (name, \'.\', \'_\');\n"
"name := replace (name, \'&\', \'_\');\n"
"\n"
"content := http_full_request (0);\n"
"if (registry_get (\'__save_http_history_on_disk\') = \'1\')\n"
"{\n"
"declare ip varchar;\n"
"declare use_ip int;\n"
"if (registry_get (\'__save_http_history_use_ip\') = \'1\')\n"
"use_ip := 1;\n"
"else\n"
"use_ip := 0; 	\n"
"ip := http_client_ip ();\n"
"if (file_stat (\'./sys_http_recording\') = 0)\n"
"signal (\'VSPX9\', \'Can not upload resource into sys_http_recording/ directory\');\n"
"if (length (name) > 200)\n"
"name := subseq (name, 0, 200);\n"
"if (use_ip and file_stat (\'./sys_http_recording/\' || ip) = 0)\n"
"sys_mkdir (\'./sys_http_recording/\' || ip);\n"
"if (use_ip)\n"
"string_to_file (\'./sys_http_recording/\' || ip || \'/\' || name, content, -2);\n"
"else\n"
"string_to_file (\'./sys_http_recording/\' || name, content, -2);\n"
"}\n"
"else\n"
"{\n"
"name := concat (\'/DAV/sys_http_recording/\', name);\n"
"\n"
"result := cast (DB.DBA.DAV_SEARCH_ID (\'/DAV/sys_http_recording/\', \'c\') as integer);\n"
"if (result < 0) \n"
"{\n"
"\n"
"result := cast (DB.DBA.DAV_COL_CREATE_INT (\'/DAV/sys_http_recording/\', \'110100000NN\', \'dav\', \'dav\', \'dav\', null, \n"
"0, 0, 0, http_dav_uid (), http_admin_gid ()) as integer);\n"
"if(result < 0) \n"
"{\n"
"signal (\'VSPX9\', \'Can not create /DAV/sys_http_recording/ directory\');\n"
"return;\n"
"}\n"
"}\n"
"result := cast (DB.DBA.DAV_RES_UPLOAD_STRSES_INT (name, content,\'text/html\',\'110100000NN\',\'dav\',\'dav\', \'dav\', null, \n"
"0, now (), now (), null, http_dav_uid (), http_admin_gid (), 0) as integer);\n"
"if (result < 0) \n"
"{\n"
"signal (\'VSPX9\', \'Can not upload resource into /DAV/sys_http_recording/ directory\');\n"
"}\n"
"}\n"
"}\n"
"--src vspx.sql:6318\n"
;

static const char *proc211 = 
"#line 6400 \"[executable]/vspx.sql\"\n"
"create procedure\n"
"cal_icell (inout control vspx_control, in inx int)\n"
"{\n"
"return (control.vc_parent as vspx_row_template).te_rowset[inx];\n"
"}\n"
"--src vspx.sql:6398\n"
;

static const char *other286 = 
"grant execute on  vspx_event  to public\n";
static const char *other287 = 
"grant execute on  vspx_control  to public\n";
static const char *other288 = 
"grant execute on  vspx_attribute  to public\n";
static const char *other289 = 
"grant execute on  vspx_page  to public\n";
static const char *other290 = 
"grant under on vspx_page to public\n";
static const char *other291 = 
"grant execute on  vspx_row_template  to public\n";
static const char *other292 = 
"grant execute on  vspx_form  to public\n";
static const char *other293 = 
"grant execute on  vspx_tab  to public\n";
static const char *other294 = 
"grant execute on  vspx_template  to public\n";
static const char *other295 = 
"grant execute on  vspx_update_form  to public\n";
static const char *other296 = 
"grant execute on  vspx_login_form  to public\n";
static const char *other297 = 
"grant execute on  vspx_field  to public\n";
static const char *other298 = 
"grant execute on  vspx_column  to public\n";
static const char *other299 = 
"grant execute on  vspx_update_field  to public\n";
static const char *other300 = 
"grant execute on  vspx_isql  to public\n";
static const char *other301 = 
"grant execute on  vspx_text  to public\n";
static const char *other302 = 
"grant execute on  vspx_textarea  to public\n";
static const char *other303 = 
"grant execute on  vspx_label  to public\n";
static const char *other304 = 
"grant execute on  vspx_check_box  to public\n";
static const char *other305 = 
"grant execute on  vspx_radio_button  to public\n";
static const char *other306 = 
"grant execute on  vspx_radio_group  to public\n";
static const char *other307 = 
"grant execute on  vspx_url  to public\n";
static const char *other308 = 
"grant execute on  vspx_button  to public\n";
static const char *other309 = 
"grant execute on  vspx_submit  to public\n";
static const char *other310 = 
"grant execute on  vspx_logout_button  to public\n";
static const char *other311 = 
"grant execute on  vspx_return_button  to public\n";
static const char *other312 = 
"grant execute on  vspx_delete_button  to public\n";
static const char *other313 = 
"grant execute on  vspx_calendar  to public\n";
static const char *other314 = 
"grant execute on  vspx_validator  to public\n";
static const char *other315 = 
"grant execute on  vspx_range_validator  to public\n";
static const char *other316 = 
"grant execute on  vspx_data_set  to public\n";
static const char *other317 = 
"grant execute on  vspx_data_source  to public\n";
static const char *other318 = 
"grant execute on  vspx_data_grid  to public\n";
static const char *other319 = 
"grant execute on  vspx_select_list  to public\n";
static const char *other320 = 
"grant execute on  vspx_data_list  to public\n";
static const char *other321 = 
"grant execute on  vspx_login  to public\n";
static const char *other322 = 
"grant execute on  vspx_browse_button  to public\n";
static const char *other323 = 
"grant execute on  vspx_tree  to public\n";
static const char *other324 = 
"grant execute on  vspx_tree_node  to public\n";
static const char *other325 = 
"grant execute on  vspx_vscx  to public\n";
static const char *tbl10 = 
"create table VSPX_CUSTOM_CONTROL\n"
"(\n"
"VCC_TAG_NAME varchar not null primary key,\n"
"VCC_CLASS    varchar not null,\n"
"VCC_FUNCTION varchar not null\n"
")\n";

static const char *proc212 = 
"#line 6536 \"[executable]/vspx.sql\"\n"
" create procedure VSPX_CONTROL_EXISTS (in name varchar)\n"
"{\n"
"\n"
"if (exists (select 1 from VSPX_CUSTOM_CONTROL\n"
"where VCC_TAG_NAME = name and __proc_exists (VCC_FUNCTION)))\n"
"return 1;\n"
"return null;\n"
"}\n"
"--src vspx.sql:6534\n"
;

static const char *other326 = 
"grant execute on VSPX_CONTROL_EXISTS to public\n";
static const char *proc213 = 
"#line 6550 \"[executable]/vspx.sql\"\n"
" create procedure VSPX_CUSTOM_CLASS_NAME (in name varchar)\n"
"{\n"
"declare class_name varchar;\n"
"select VCC_CLASS into class_name from VSPX_CUSTOM_CONTROL where VCC_TAG_NAME = name;\n"
"return class_name;\n"
"}\n"
"--src vspx.sql:6548\n"
;

static const char *other327 = 
"grant execute on VSPX_CUSTOM_CLASS_NAME to public\n";
static const char *proc214 = 
"#line 6562 \"[executable]/vspx.sql\"\n"
" create procedure VSPX_CLASS_PARSER (in name varchar, in tag any)\n"
"{\n"
"declare fn varchar;\n"
"declare ss any;\n"
"select VCC_FUNCTION into fn from VSPX_CUSTOM_CONTROL where VCC_TAG_NAME = name;\n"
"ss := string_output ();\n"
"call (fn) (tag, ss);\n"
"return string_output_string (ss);\n"
"}\n"
"--src vspx.sql:6560\n"
;

static const char *other328 = 
"grant execute on VSPX_CLASS_PARSER to public\n";
static const char *other329 = 
"insert soft DB.DBA.SYS_XPF_EXTENSIONS (XPE_NAME, XPE_PNAME) values\n"
"(\'http://www.openlinksw.com/vspx/:vcc_exists\', \'DB.DBA.VSPX_CONTROL_EXISTS\')\n";
static const char *other330 = 
"insert soft DB.DBA.SYS_XPF_EXTENSIONS (XPE_NAME, XPE_PNAME) values\n"
"(\'http://www.openlinksw.com/vspx/:vcc_instantiate\', \'DB.DBA.VSPX_CLASS_PARSER\')\n";
static const char *other331 = 
"insert soft DB.DBA.SYS_XPF_EXTENSIONS (XPE_NAME, XPE_PNAME) values\n"
"(\'http://www.openlinksw.com/vspx/:vcc_class_name\', \'DB.DBA.VSPX_CUSTOM_CLASS_NAME\')\n";
static const char *other332 = 
"xpf_extension (\'http://www.openlinksw.com/vspx/:vcc_exists\', \'DB.DBA.VSPX_CONTROL_EXISTS\', 0)\n";
static const char *other333 = 
"xpf_extension (\'http://www.openlinksw.com/vspx/:vcc_instantiate\', \'DB.DBA.VSPX_CLASS_PARSER\', 0)\n";
static const char *other334 = 
"xpf_extension (\'http://www.openlinksw.com/vspx/:vcc_class_name\', \'DB.DBA.VSPX_CUSTOM_CLASS_NAME\', 0)\n";
static const char *proc215 = 
"#line 6599 \"[executable]/vspx.sql\"\n"
"create procedure\n"
"VSPX_REGISTER_CONTROL (in tag varchar, in class_name varchar, in func varchar)\n"
"{\n"
"insert replacing VSPX_CUSTOM_CONTROL (VCC_TAG_NAME, VCC_CLASS, VCC_FUNCTION)\n"
"values (tag, class_name, func);\n"
"}\n"
"--src vspx.sql:6597\n"
;

static const char *proc216 = 
"#line 6609 \"[executable]/vspx.sql\"\n"
" create procedure\n"
"vspx_sid_generate ()\n"
"{\n"
"declare tim, ip, path varchar;\n"
"tim := datestring (now ());\n"
"ip := http_client_ip ();\n"
"if (is_http_ctx ())\n"
"path := http_path ();\n"
"else\n"
"path := \'\';\n"
"return md5 (concat (tim, ip, path));\n"
"}\n"
"--src vspx.sql:6607\n"
;

static const char *proc217 = 
"#line 6624 \"[executable]/vspx.sql\"\n"
"create procedure vspx_label_render (in fmt varchar, in val any)\n"
"{\n"
"if (length (fmt))\n"
"http (sprintf (fmt, val));\n"
"else\n"
"http_value (val);\n"
"}\n"
"--src vspx.sql:6622\n"
;

static const char *proc218 = 
"#line 6633 \"[executable]/vspx.sql\"\n"
"create procedure vspx_url_render (in fmt varchar, in val any, in url any, in sid any, in realm any, in is_local any)\n"
"{\n"
"if (length (sid))\n"
"{\n"
"declare uinfo any;\n"
"uinfo := WS.WS.PARSE_URI (url);\n"
"if (uinfo[0] = \'\' or is_local = 1)\n"
"url := vspx_uri_add_parameters (url, sprintf (\'sid=%U&realm=%U\', sid, realm));\n"
"}\n"
"http (sprintf (\'<a href=\"%V\">\', url));\n"
"if (length (fmt))\n"
"http (sprintf (fmt, val));\n"
"else\n"
"http_value (val);\n"
"http (\'</a>\');\n"
"}\n"
"--src vspx.sql:6631\n"
;

static const char *proc219 = 
"#line 6651 \"[executable]/vspx.sql\"\n"
"create procedure vspx_url_render_ex (in fmt varchar, in val any, in url any, in sid any, in realm any, in is_local any, in attrs any)\n"
"{\n"
"declare i, l int;\n"
"if (length (sid))\n"
"{\n"
"declare uinfo any;\n"
"uinfo := WS.WS.PARSE_URI (url);\n"
"if (uinfo[0] = \'\' or is_local = 1)\n"
"url := vspx_uri_add_parameters (url, sprintf (\'sid=%U&realm=%U\', sid, realm));\n"
"}\n"
"http (sprintf (\'<a href=\"%V\"\', url));\n"
"i := 1; l := length (attrs);\n"
"while (i < l)\n"
"{\n"
"if (attrs[i-1] <> \'@@hidden@@\')\n"
"{\n"
"http (\' \' || attrs[i-1] || \'=\"\');\n"
"http_value (attrs[i]);\n"
"http (\'\"\');\n"
"}\n"
"\n"
"i := i + 2;\n"
"}\n"
"http (\'>\');\n"
"if (length (fmt))\n"
"http (sprintf (fmt, val));\n"
"else\n"
"http_value (val);\n"
"http (\'</a>\');\n"
"}\n"
"--src vspx.sql:6649\n"
;

static const char *proc220 = 
"#line 6684 \"[executable]/vspx.sql\"\n"
" create procedure VSPX_ONE_CONTROL_UP (in expn varchar)\n"
"{\n"
"declare idx integer;\n"
"declare hit1, hit2 any;\n"
"expn := concat (\' \', expn, \' \');\n"
"idx := 0;\n"
"again:\n"
"hit1 := regexp_parse (\'([^a-zA-Z0-9_\"])(control)([^a-zA-Z0-9_])\', expn, idx);\n"
"if (hit1 is NULL)\n"
"return subseq (expn, 1, length (expn) - 1);\n"
"hit2 := regexp_parse (\'([^a-zA-Z0-9_\"])(control[ \\t\\r\\n]*\\.[ \\t\\r\\n]*vc_parent)([^a-zA-Z0-9_])\', expn, idx);\n"
"if (hit2 is NULL)\n"
"return \'\';\n"
"if (aref (hit2, 0) <> aref (hit1, 0))\n"
"return \'\';\n"
"expn :=\n"
"concat (\n"
"subseq (expn, 0, aref (hit2, 4)),\n"
"\'control\',\n"
"subseq (expn, aref (hit2, 5)) );\n"
"idx := aref (hit2, 4) + 7;\n"
"goto again;\n"
"}\n"
"--src vspx.sql:6682\n"
;

static const char *other335 = 
"grant execute on VSPX_ONE_CONTROL_UP to public\n";
static const char *other336 = 
"insert soft DB.DBA.SYS_XPF_EXTENSIONS (XPE_NAME, XPE_PNAME) VALUES (\'http://www.openlinksw.com/vspx/:one-control-up\', \'DB.DBA.VSPX_ONE_CONTROL_UP\')\n";
static const char *other337 = 
"xpf_extension (\'http://www.openlinksw.com/vspx/:one-control-up\', \'DB.DBA.VSPX_ONE_CONTROL_UP\', 0)\n";
static const char *proc221 = 
"#line 6718 \"[executable]/vspx.sql\"\n"
"create procedure VSPX_USER_LOGIN (in realm varchar, in uname varchar, in pass varchar, in auth_function varchar)\n"
"{\n"
"declare rc int;\n"
"declare sid any;\n"
"\n"
"sid := null;\n"
"rc := call (auth_function) (uname, pass);\n"
"if (rc)\n"
"{\n"
"sid := md5 (concat (datestring (now ()), client_attr (\'client_ip\')));\n"
"insert into VSPX_SESSION (VS_REALM, VS_SID, VS_UID, VS_STATE, VS_EXPIRY) values (realm, sid, uname, null, now());\n"
"}\n"
"return sid;\n"
"}\n"
"--src vspx.sql:6716\n"
;

static const char *proc222 = 
"#line 6734 \"[executable]/vspx.sql\"\n"
"create procedure VSPX_SESSION_IS_VALID (in realm varchar, in sid varchar)\n"
"{\n"
"update VSPX_SESSION set VS_EXPIRY = now () where VS_SID = sid and VS_REALM = realm;\n"
"if (row_count () = 0)\n"
"return 0;\n"
"return 1;\n"
"}\n"
"--src vspx.sql:6732\n"
;

/* vspx_add_locations.xsl */

static const char *xsl32[]= {
"<?xml version='1.0'?>\n"
"<!--\n"
" -  \n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -  \n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -  \n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -  \n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -  \n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -  \n"
" -  \n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n"
"     version=\"1.0\"\n"
"     xmlns:v=\"http://www.openlinksw.com/vspx/\"  exclude-result-prefixes=\"v\"\n"
"     xmlns:xhtml=\"http://www.w3.org/1999/xhtml\">\n"
"<xsl:output method=\"xsl\" omit-xml-declaration=\"no\" indent=\"no\" />\n"
"\n"
"<xsl:template match=\"*\">\n"
"  <xsl:variable name=\"scriptable\" select=\"self::v:after-data-bind|self::v:after-data-bind-container|self::v:before-data-bind|self::v:before-data-bind-container|self::v:on-post|self::v:on-post-container|self::v:before-render|self::v:before-render-container|self::v:on-init|self::v:on-init-container|self::v:script|self::v:method|self::v:method-container\"/>\n"
"  <xsl:copy>\n"
"    <xsl:for-each select=\"@*\"><xsl:copy /></xsl:for-each>\n"
"    <xsl:if test=\"xpath-debug-srcline(.) > 0\">\n"
"      <xsl:attribute name=\"debug-srcfile\"><xsl:value-of select=\"xpath-debug-srcfile(.)\" /></xsl:attribute>\n"
"      <xsl:attribute name=\"debug-srcline\"><xsl:value-of select=\"xpath-debug-srcline(.)\" /></xsl:attribute>\n"
"    </xsl:if>\n"
"  <xsl:if test=\"$scriptable\">\n"
"#line push  \n"
"#line <xsl:value-of select=\"xpath-debug-srcline(.)\"/> \"<xsl:value-of select=\"xpath-debug-srcfile(.)\"/>\"\n"
"</xsl:if>\n"
"  <xsl:apply-templates select=\"node()\" />\n"
"  <xsl:if test=\"$scriptable\">\n"
"#line pop\n"
"</xsl:if>\n"
"  </xsl:copy>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"text()|comment()|processing-instruction()\">\n"
"  <xsl:copy/>\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* vspx_expand.xsl */

static const char *xsl33[]= {
"<?xml version='1.0'?>\n"
"<!--\n"
" -  \n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -  \n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -  \n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -  \n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -  \n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -  \n"
" -  \n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n"
"     version=\"1.0\"\n"
"     xmlns:v=\"http://www.openlinksw.com/vspx/\"\n"
"     xmlns:vdeps=\"http://www.openlinksw.com/vspx/deps/\"\n"
"     exclude-result-prefixes=\"v\"\n"
"     xmlns:xhtml=\"http://www.w3.org/1999/xhtml\">\n"
"<xsl:output method=\"xml\" omit-xml-declaration=\"no\" indent=\"yes\"\n"
"	cdata-section-elements=\"v:after-data-bind v:after-data-bind-container v:before-data-bind v:before-data-bind-container v:on-post v:on-post-container v:before-render v:before-render-container v:on-init v:script v:sql\" />\n"
"<xsl:param name=\"vspx_log\" />\n"
"<xsl:variable name=\"rootpage\" select=\"(//v:page)[1]\" />\n"
"<xsl:variable name=\"pagedecor\" select=\"$rootpage/@decor\" />\n"
"<xsl:variable name=\"pagestyle\" select=\"$rootpage/@style\" />\n"
"<xsl:variable name=\"fast-render\" select=\"boolean ($rootpage/@fast-render)\"/>\n"
"\n"
"<xsl:template match=\"/\">\n"
"  <xsl:if test=\"not ($vspx_log = '')\">\n"
"<xsl:comment><xsl:value-of select=\"concat('\\n',$vspx_log)\" /></xsl:comment><xsl:text>\n"
"</xsl:text>\n"
"  </xsl:if>\n"
"  <xsl:apply-templates select=\"node()\" />\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:include\">\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"@url\">\n"
"      <xsl:variable name=\"doc\" select=\"document (@url)\"/>\n"
"      <xsl:variable name=\"doc_page\" select=\"$doc/descendant-or-self::v:page\"/>\n"
"      <v:hidden>\n"
"	  <xsl:attribute name=\"url\" namespace=\"http://www.openlinksw.com/vspx/deps/\" >\n"
"	      <xsl:value-of select=\"document-get-uri($doc)\" />\n"
"	  </xsl:attribute>\n"
"      </v:hidden>\n"
"      <xsl:choose>\n"
"	<xsl:when test=\"$doc_page\">\n"
"	  <xsl:apply-templates select=\"$doc_page/node()\" />\n"
"	</xsl:when>\n"
"        <xsl:otherwise>\n"
"          <xsl:apply-templates select=\"$doc\" />\n"
"        </xsl:otherwise>\n"
"      </xsl:choose>\n"
"    </xsl:when>\n"
"    <xsl:otherwise>\n"
"       <xsl:message terminate=\"yes\">VSPX element 'include' should have a 'url' attribute.</xsl:message>\n"
"    </xsl:otherwise>\n"
"  </xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:code-file\">\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"@url\">\n"
"      <v:hidden>\n"
"	  <xsl:attribute name=\"code-file\" namespace=\"http://www.openlinksw.com/vspx/deps/\" >\n"
"	      <xsl:value-of select=\"@url\" />\n"
"	  </xsl:attribute>\n"
"      </v:hidden>\n"
"    </xsl:when>\n"
"    <xsl:otherwise>\n"
"       <xsl:message terminate=\"yes\">VSPX element 'code-file' should have a 'url' attribute.</xsl:message>\n"
"    </xsl:otherwise>\n"
"  </xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:placeholder\">\n"
"  <xsl:apply-templates select=\"$rootpage/*[not (local-name(.) = 'after-data-bind' or local-name(.) = 'before-data-bind' or local-name(.) = 'on-post' or local-name(.) = 'before-render' or local-name(.) = 'on-init' or local-name(.) = 'variable')]\" />\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:style\">\n"
"  <xsl:apply-templates select=\"node()\" />\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"processing-instruction()\">\n"
"   <xsl:copy-of select=\".\" />\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:page\">\n"
"  <xsl:choose>\n"
"    <xsl:when test=\".[.=$rootpage]/@decor\">\n"
"      <xsl:if test=\".//v:include[@rootpage]\">\n"
"	<xsl:message terminate=\"yes\">Tag 'v:include' with 'rootpage' atribute may cause infinite recursion when used outside decoration page.</xsl:message>\n"
"      </xsl:if>\n"
"      <xsl:copy>\n"
"        <xsl:copy-of select=\"@*[name() != 'decor']\" />\n"
"	<xsl:variable name=\"doc\" select=\"document (@decor)\"/>\n"
"	<xsl:apply-templates select=\"./*[local-name(.) = 'after-data-bind' or local-name(.) = 'before-data-bind' or local-name(.) = 'on-post' or local-name(.) = 'before-render' or local-name(.) = 'on-init' or local-name(.) = 'variable']\"/>\n"
"	<xsl:apply-templates select=\"$doc\" />\n"
"      </xsl:copy>\n"
"    </xsl:when>\n"
"    <xsl:when test=\".=$rootpage\">\n"
"      <xsl:copy>\n"
"        <xsl:copy-of select=\"@*[name() != 'style']\" />\n"
"        <xsl:apply-templates select=\"node()\" />\n"
"      </xsl:copy>\n"
"    </xsl:when>\n"
"    <xsl:otherwise>\n"
"      <xsl:apply-templates select=\"node()\" />\n"
"    </xsl:otherwise>\n"
"  </xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<!-- v:grid expansion -->\n"
"<xsl:template match=\"v:grid\">\n"
"<xsl:comment><xsl:value-of select=\"@name\" /></xsl:comment><xsl:text>\n"
"</xsl:text>\n"
"<xsl:variable name=\"n\" select=\"@name\" />\n"
"<v:data-set scrollable=\"1\" edit=\"1\">\n"
"  <xsl:attribute name=\"name\"><xsl:value-of select=\"$n\" /></xsl:attribute>\n"
"  <xsl:attribute name=\"data-source\"><xsl:value-of select=\"@data-source\" /></xsl:attribute>\n"
"  <v:template type=\"simple\" name-to-remove=\"table\" set-to-remove=\"bottom\">\n"
"  <xsl:attribute name=\"name\"><xsl:value-of select=\"$n\" />_header_template</xsl:attribute>\n"
"  <table>\n"
"    <xsl:copy-of select=\"@*\" />\n"
"    <!--xsl:attribute name=\"style\"><xsl:value-of select=\"@style\" /></xsl:attribute-->\n"
"    <xsl:apply-templates select=\"v:header\" />\n"
"  </table>\n"
"  </v:template>\n"
"  <v:template type=\"repeat\">\n"
"    <xsl:attribute name=\"name\"><xsl:value-of select=\"$n\" />_repeat_template</xsl:attribute>\n"
"    <v:template type=\"if-not-exists\">\n"
"     <xsl:attribute name=\"name\"><xsl:value-of select=\"$n\" />_not_exists_template</xsl:attribute>\n"
"    </v:template>\n"
"    <v:template type=\"edit\">\n"
"     <xsl:attribute name=\"name\"><xsl:value-of select=\"$n\" />_edit_template</xsl:attribute>\n"
"     <xsl:apply-templates select=\"v:columns\" mode=\"edit\"/>\n"
"    </v:template>\n"
"    <v:template type=\"add\">\n"
"     <xsl:attribute name=\"name\"><xsl:value-of select=\"$n\" />_add_template</xsl:attribute>\n"
"     <xsl:apply-templates select=\"v:columns\" mode=\"add\"/>\n"
"    </v:template>\n"
"    <v:template type=\"browse\"  name-to-remove=\"table\" set-to-remove=\"both\">\n"
"     <xsl:attribute name=\"name\"><xsl:value-of select=\"$n\" />_browse_template</xsl:attribute>\n"
"     <xsl:apply-templates select=\"v:columns\" mode=\"browse\"/>\n"
"    </v:template>\n"
"  </v:template>\n"
"  <v:template type=\"simple\" name-to-remove=\"table\" set-to-remove=\"top\">\n"
"  <xsl:attribute name=\"name\"><xsl:value-of select=\"$n\" />_footer_template</xsl:attribute>\n"
"  <table>\n"
"    <xsl:apply-templates select=\"v:footer\" />\n"
"  </table>\n"
"  </v:template>\n"
"  <xsl:apply-templates select=\"v:*[local-name() != 'columns' and local-name() != 'header' and local-name() != 'footer']\" />\n"
"</v:data-set><xsl:text>\n"
"</xsl:text>\n"
"<xsl:comment>end <xsl:value-of select=\"@name\" /></xsl:comment>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:header\">\n"
"   <xsl:apply-templates select=\"parent::*/v:columns\" mode=\"header\"/>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:footer\">\n"
"  <xsl:variable name=\"p\" select=\"ancestor::v:grid/@name\" />\n"
"  <tr>\n"
"  <td>\n"
"       <xsl:copy-of select=\"@*\" />\n"
"       <xsl:attribute name=\"colspan\"><xsl:value-of select=\"count(parent::*/v:columns/v:column)+1\"/></xsl:attribute>\n"
"       <v:button action=\"simple\">\n"
"    	    <xsl:attribute name=\"name\"><xsl:value-of select=\"$p\" />_prev</xsl:attribute>\n"
"    	    <xsl:attribute name=\"value\">Previous</xsl:attribute>\n"
"       </v:button>\n"
"       <v:button action=\"simple\">\n"
"    	    <xsl:attribute name=\"name\"><xsl:value-of select=\"$p\" />_next</xsl:attribute>\n"
"    	    <xsl:attribute name=\"value\">Next</xsl:attribute>\n"
"       </v:button>\n"
"  </td>\n"
"  </tr>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:columns\" mode=\"header\">\n"
"  <tr>\n"
"  <th>&#160;\n"
"       <xsl:copy-of select=\"ancestor::v:grid/v:header/@*\" />\n"
"  </th>\n"
"  <xsl:for-each select=\"v:column\">\n"
"  <xsl:variable name=\"c\" select=\"@name\" />\n"
"  <xsl:variable name=\"p\" select=\"ancestor::v:grid/@name\" />\n"
"  <xsl:variable name=\"ds\" select=\"ancestor::v:grid/@data-source\" />\n"
"    <th>\n"
"       <xsl:copy-of select=\"ancestor::v:grid/v:header/@*\" />\n"
"         <v:label>\n"
"     	   <xsl:attribute name=\"name\"><xsl:value-of select=\"$p\" />_<xsl:value-of select=\"$c\" />_header_label</xsl:attribute>\n"
"    	   <xsl:attribute name=\"value\">--(<xsl:value-of select=\"$ds\" />.get_column_label('<xsl:value-of select=\"$c\" />'))</xsl:attribute>\n"
"         </v:label>\n"
"    </th>\n"
"  </xsl:for-each>\n"
"  </tr>\n"
"</xsl:template>\n"
"\n"
"\n"
"<xsl:template match=\"v:columns\" mode=\"browse\">\n"
"  <xsl:variable name=\"p\" select=\"ancestor::v:grid/@name\" />\n"
"  <xsl:variable name=\"ds\" select=\"ancestor::v:grid/@data-source\" />\n"
"  <tr>\n"
"        <td>\n"
"          <v:button action=\"simple\" value=\"Edit\">\n"
"    	    <xsl:attribute name=\"name\"><xsl:value-of select=\"$p\" />_edit</xsl:attribute>\n"
"          </v:button>\n"
"          <v:button action=\"simple\" value=\"Delete\">\n"
"    	    <xsl:attribute name=\"name\"><xsl:value-of select=\"$p\" />_delete</xsl:attribute>\n"
"            <xsl:element name=\"on-post\" namespace=\"http://www.openlinksw.com/vspx/\">\n"
"                 <xsl:value-of select=\"$ds\" />.ds_delete (e);\n"
"                 <xsl:value-of select=\"$ds\" />.ds_data_bind (e);\n"
"                 self.<xsl:value-of select=\"$p\" />.vc_data_bind (e);\n"
"            </xsl:element>\n"
"          </v:button>\n"
"        </td>\n"
"  <xsl:for-each select=\"v:column\">\n"
"  <xsl:variable name=\"c\" select=\"@name\" />\n"
"  <xsl:variable name=\"ds\" select=\"ancestor::v:grid/@data-source\" />\n"
"    <td>\n"
"       <xsl:copy-of select=\"@*[local-name() != 'name']\" />\n"
"         <v:label>\n"
"    		<xsl:attribute name=\"name\"><xsl:value-of select=\"$p\" />_<xsl:value-of select=\"$c\" />_label</xsl:attribute>\n"
"    		<xsl:attribute name=\"value\">--(<xsl:value-of select=\"$ds\" />.get_item_value('<xsl:value-of select=\"$c\" />'))</xsl:attribute>\n"
"         </v:label>\n"
"    </td>\n"
"  </xsl:for-each>\n"
"  </tr>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:columns\" mode=\"add\">\n"
"  <xsl:variable name=\"p\" select=\"ancestor::v:grid/@name\" />\n"
"  <xsl:variable name=\"ds\" select=\"ancestor::v:grid/@data-source\" />\n"
"  <v:form type=\"update\" if-not-exists=\"insert\">\n"
"    <xsl:attribute name=\"name\"><xsl:value-of select=\"$p\" />_insert_form</xsl:attribute>\n"
"    <xsl:attribute name=\"data-source\"><xsl:value-of select=\"$ds\" /></xsl:attribute>\n"
"    <v:template type=\"simple\">\n"
"    <xsl:attribute name=\"name\"><xsl:value-of select=\"$p\" />_insert_template</xsl:attribute>\n"
"      <tr>\n"
"        <td>\n"
"          <v:button action=\"submit\" value=\"Add\">\n"
"            <xsl:attribute name=\"name\"><xsl:value-of select=\"$p\" />_insert_button</xsl:attribute>\n"
"          </v:button>\n"
"        </td>\n"
"      <xsl:for-each select=\"v:column\">\n"
"      <xsl:variable name=\"c\" select=\"@name\" />\n"
"        <td>\n"
"          <xsl:copy-of select=\"@*[local-name() != 'name']\" />\n"
"          <v:text>\n"
"    		<xsl:attribute name=\"name\"><xsl:value-of select=\"$p\" />_<xsl:value-of select=\"$c\" />_text_insert</xsl:attribute>\n"
"    		<xsl:attribute name=\"column\"><xsl:value-of select=\"$c\" /></xsl:attribute>\n"
"          </v:text>\n"
"        </td>\n"
"      </xsl:for-each>\n"
"      </tr>\n"
"    </v:template>\n"
"  </v:form>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:columns\" mode=\"edit\">\n"
"  <xsl:variable name=\"p\" select=\"ancestor::v:grid/@name\" />\n"
"  <xsl:variable name=\"ds\" select=\"ancestor::v:grid/@data-source\" />\n"
"  <v:form type=\"update\" >\n"
"    <xsl:attribute name=\"name\"><xsl:value-of select=\"$p\" />_update_form</xsl:attribute>\n"
"    <xsl:attribute name=\"data-source\"><xsl:value-of select=\"$ds\" /></xsl:attribute>\n"
"    <v:template type=\"simple\">\n"
"    <xsl:attribute name=\"name\"><xsl:value-of select=\"$p\" />_update_template</xsl:attribute>\n"
"      <tr>\n"
"        <td>\n"
"          <v:button action=\"submit\" value=\"Update\">\n"
"            <xsl:attribute name=\"name\"><xsl:value-of select=\"$p\" />_update_button</xsl:attribute>\n"
"          </v:button>\n"
"          <input type=\"submit\" name=\"Cancel\" value=\"Cancel\" />\n"
"        </td>\n"
"      <xsl:for-each select=\"v:column\">\n"
"      <xsl:variable name=\"c\" select=\"@name\" />\n"
"        <td>\n"
"          <xsl:copy-of select=\"@*[local-name() != 'name']\" />\n"
"          <v:text>\n"
"    		<xsl:attribute name=\"name\"><xsl:value-of select=\"$p\" />_<xsl:value-of select=\"$c\" />_text_edit</xsl:attribute>\n"
"    		<xsl:attribute name=\"column\"><xsl:value-of select=\"$c\" /></xsl:attribute>\n"
"          </v:text>\n"
"        </td>\n"
"      </xsl:for-each>\n"
"      </tr>\n"
"    </v:template>\n"
"  </v:form>\n"
"</xsl:template>\n"
"<!-- end of v:grid expansion -->\n"
"\n"
"<xsl:template match=\"v:label\">\n"
"  <xsl:variable name=\"opt-force\" select=\"boolean(@render-only='1')\"/>\n"
"  <xsl:variable name=\"is-optimizable\">\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"not ($opt-force or $fast-render)\"/>\n"
"      <xsl:when test=\"*\">\n"
"        <xsl:if test=\"$opt-force\"><xsl:message terminate=\"yes\">render-only could not be specified when label have descendants</xsl:message></xsl:if>\n"
"      </xsl:when>\n"
"      <xsl:otherwise>\n"
"        <xsl:variable name=\"unsafe-attr\" select=\"@*[not (name()='render-only' or name()='name' or name()='debug-srcfile' or name()='debug-srcline' or name()='format' or name() = 'value')][name() = local-name()]\"/>\n"
"        <xsl:choose>\n"
"          <xsl:when test=\"not(empty($unsafe-attr))\">\n"
"           <xsl:if test=\"$opt-force\"><xsl:message terminate=\"yes\">render-only could not be specified when label have attribute '<xsl:value-of select=\"name($unsafe-attr[1])\"/>'</xsl:message></xsl:if>\n"
"          </xsl:when>\n"
"          <xsl:otherwise>1</xsl:otherwise>\n"
"        </xsl:choose>\n"
"      </xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:variable>\n"
"  <xsl:variable name=\"format\">\n"
"    <xsl:choose>\n"
"	    <xsl:when test=\"@format\">\n"
"	      <xsl:apply-templates select=\"@format\" mode=\"value-exp\"><xsl:with-param name=\"report-error\" select=\"$opt-force\"/></xsl:apply-templates>\n"
"	    </xsl:when>\n"
"    	  <xsl:otherwise>null</xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:variable>\n"
"  <xsl:variable name=\"value\">\n"
"    <xsl:choose>\n"
"	    <xsl:when test=\"@value\">\n"
"	      <xsl:apply-templates select=\"@value\" mode=\"value-exp\"><xsl:with-param name=\"report-error\" select=\"$opt-force\"/></xsl:apply-templates>\n"
"	    </xsl:when>\n"
"	    <xsl:when test=\"$opt-force\">\n"
"    	    <xsl:message terminate=\"yes\">render-only could not be specified for a label that has no 'value' attribute</xsl:message>\n"
"	    </xsl:when>\n"
"    	  <xsl:otherwise></xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:variable>\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"$is-optimizable and not ($format = '' or $value = '')\">\n"
"    <xsl:processing-instruction name=\"vsp\">\n"
"    {\n"
"      vspx_label_render (\n"
"        <xsl:value-of select=\"$format\"/>\n"
"        , <xsl:value-of select=\"$value\"/>\n"
"      );\n"
"    }\n"
"    </xsl:processing-instruction>\n"
"      </xsl:when>\n"
"    <xsl:otherwise><xsl:call-template name=\"dflt-control\"/></xsl:otherwise>\n"
"  </xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:url\">\n"
"  <xsl:variable name=\"opt-force\" select=\"boolean(@render-only='1')\"/>\n"
"  <xsl:variable name=\"is-optimizable\">\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"not ($opt-force or $fast-render)\"/>\n"
"      <xsl:when test=\"*\">\n"
"        <xsl:if test=\"$opt-force\"><xsl:message terminate=\"yes\">render-only could not be specified when v:url have descendants</xsl:message></xsl:if>\n"
"      </xsl:when>\n"
"      <xsl:otherwise>\n"
"        <xsl:variable name=\"unsafe-attr\" select=\"@*[not (name()='render-only' or name()='name' or name()='debug-srcfile' or name()='debug-srcline' or name()='format' or name() = 'value' or name() = 'url' or name () = 'is-local' or starts-with(name(), 'xhtml_'))][name() = local-name()]\"/>\n"
"        <xsl:choose>\n"
"          <xsl:when test=\"not(empty($unsafe-attr))\">\n"
"           <xsl:if test=\"$opt-force\"><xsl:message terminate=\"yes\">render-only could not be specified when v:url have attribute '<xsl:value-of select=\"name($unsafe-attr[1])\"/>'</xsl:message></xsl:if>\n"
"          </xsl:when>\n"
"          <xsl:otherwise>1</xsl:otherwise>\n"
"        </xsl:choose>\n"
"      </xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:variable>\n"
"  <xsl:variable name=\"format\">\n"
"    <xsl:choose>\n"
"	    <xsl:when test=\"@format\">\n"
"	      <xsl:apply-templates select=\"@format\" mode=\"value-exp\"><xsl:with-param name=\"report-error\" select=\"$opt-force\"/></xsl:apply-templates>\n"
"	    </xsl:when>\n"
"    	  <xsl:otherwise>null</xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:variable>\n"
"  <xsl:variable name=\"value\">\n"
"    <xsl:choose>\n"
"	    <xsl:when test=\"@value\">\n"
"	      <xsl:apply-templates select=\"@value\" mode=\"value-exp\"><xsl:with-param name=\"report-error\" select=\"$opt-force\"/></xsl:apply-templates>\n"
"	    </xsl:when>\n"
"	    <xsl:when test=\"$opt-force\">\n"
"    	    <xsl:message terminate=\"yes\">render-only could not be specified for a v:url that has no 'value' attribute</xsl:message>\n"
"	    </xsl:when>\n"
"    	  <xsl:otherwise></xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:variable>\n"
"  <xsl:variable name=\"url\">\n"
"    <xsl:choose>\n"
"	    <xsl:when test=\"@url\">\n"
"	      <xsl:apply-templates select=\"@url\" mode=\"value-exp\"><xsl:with-param name=\"report-error\" select=\"$opt-force\"/></xsl:apply-templates>\n"
"	    </xsl:when>\n"
"	    <xsl:when test=\"$opt-force\">\n"
"    	    <xsl:message terminate=\"yes\">render-only could not be specified for a v:url that has no 'url' attribute</xsl:message>\n"
"	    </xsl:when>\n"
"    	  <xsl:otherwise></xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:variable>\n"
"  <xsl:variable name=\"xhtml-attrs\">\n"
"    <xsl:for-each select=\"@*[starts-with(name(), 'xhtml_')]\">\n"
"      <xsl:variable name=\"res\"><xsl:apply-templates select=\".\" mode=\"value-exp\"><xsl:with-param name=\"report-error\" select=\"$opt-force\"/></xsl:apply-templates></xsl:variable>\n"
"      <xsl:choose><xsl:when test=\"$res=''\"><unsafe/></xsl:when>\n"
"      <xsl:otherwise>\n"
"	   '<xsl:value-of select=\"substring-after (local-name(), 'xhtml_')\" />', <xsl:value-of select=\"$res\"/>\n"
"	   , </xsl:otherwise></xsl:choose>\n"
"    </xsl:for-each>\n"
"  </xsl:variable>\n"
"  <xsl:variable name=\"is-local\">\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"@is-local\"><xsl:value-of select=\"@is-local\"/></xsl:when>\n"
"      <xsl:otherwise>0</xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:variable>\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"$is-optimizable and not ($format = '' or $value = '' or $url='') and empty ($xhtml-attrs/unsafe)\">\n"
"    <xsl:processing-instruction name=\"vsp\">\n"
"    {\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"empty ($xhtml-attrs)\">\n"
"      vspx_url_render (\n"
"      </xsl:when>\n"
"      <xsl:otherwise>\n"
"      vspx_url_render_ex (\n"
"      </xsl:otherwise>\n"
"    </xsl:choose>\n"
"      <xsl:value-of select=\"$format\"/>\n"
"        , <xsl:value-of select=\"$value\"/>\n"
"        , <xsl:value-of select=\"$url\"/>\n"
"	, self.sid, self.realm, <xsl:value-of select=\"$is-local\"/><xsl:if test=\"not (empty ($xhtml-attrs))\">, vector (<xsl:value-of select=\"$xhtml-attrs\"/> NULL)</xsl:if>\n"
"      );\n"
"    }\n"
"    </xsl:processing-instruction>\n"
"      </xsl:when>\n"
"    <xsl:otherwise><xsl:call-template name=\"dflt-control\"/></xsl:otherwise>\n"
"  </xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"@*\" mode=\"value-exp\">\n"
"  <xsl:param name=\"report-error\"/>\n"
"  <xsl:variable name=\"res\">\n"
"    <xsl:choose>\n"
"      <xsl:when test=\". like '--after:%'\"><xsl:value-of select=\"v:one-control-up (substring (., 9, string-length(.)))\" /></xsl:when>\n"
"      <xsl:when test=\". like '--%'\"><xsl:value-of select=\"v:one-control-up (substring (., 3, string-length(.)))\" /></xsl:when>\n"
"      <xsl:when test=\". like '\\'%\\''\"><xsl:value-of select=\".\" /></xsl:when>\n"
"      <xsl:otherwise>'<xsl:value-of select=\".\" />'</xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:variable>\n"
"  <xsl:if test=\"$report-error and ($res='')\">\n"
"    <xsl:message terminate=\"yes\">render-only could not be specified if expression in attribute '<xsl:value-of select=\"name()\"/>' refers to 'control' but not to control.vc_parent</xsl:message>\n"
"  </xsl:if>\n"
"  <xsl:value-of select=\"$res\"/>\n"
"</xsl:template>\n"
"\n"
"<!-- some vspx controls may have no name; assign internal name -->\n"
"<xsl:template match=\"v:*\" name=\"dflt-control\">\n"
"    <xsl:variable name=\"ln\" select=\"local-name()\" />\n"
"    <xsl:copy>\n"
"      <xsl:copy-of select=\"@*\" />\n"
"      <xsl:if test=\"\n"
"	  not @name\n"
"	  and not starts-with ($ln, 'on-')\n"
"	  and not starts-with ($ln, 'after-')\n"
"	  and not starts-with ($ln, 'before-')\n"
"	  and $ln != 'error-summary'\n"
"	  and $ln != 'expression'\n"
"	  and $ln != 'hidden'\n"
"	  and $ln != 'key'\n"
"	  and $ln != 'node'\n"
"	  and $ln != 'node-set'\n"
"	  and $ln != 'rowset'\n"
"	  and $ln != 'script'\n"
"	  and $ln != 'sql'\n"
"	  and $ln != 'column'\n"
"	  and $ln != 'variable'\n"
"	  and $ln != 'param'\n"
"	  and $ln != 'field'\n"
"	  \">\n"
"	  <xsl:attribute name=\"name\">ctrl_<xsl:value-of select=\"generate-id ()\"/></xsl:attribute>\n"
"      </xsl:if>\n"
"      <xsl:apply-templates select=\"node()\" />\n"
"    </xsl:copy>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\">\n"
"    <xsl:copy>\n"
"      <xsl:copy-of select=\"@*\" />\n"
"      <xsl:apply-templates select=\"node()\" />\n"
"    </xsl:copy>\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* vspx_pre_xsd.xsl */

static const char *xsl34[]= {
"<?xml version='1.0'?>\n"
"<!--\n"
" -  \n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -  \n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -  \n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -  \n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -  \n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -  \n"
" -  \n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n"
"     version=\"1.0\"\n"
"     xmlns:v=\"http://www.openlinksw.com/vspx/\"  exclude-result-prefixes=\"v\"\n"
"     xmlns:xhtml=\"http://www.w3.org/1999/xhtml\"\n"
"     xmlns:vd=\"http://www.openlinksw.com/vspx/deps/\"\n"
"     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n"
"      >\n"
"<xsl:output method=\"xsl\" omit-xml-declaration=\"no\" indent=\"no\" />\n"
"\n"
"<xsl:template match=\"/\">\n"
"  <xsl:apply-templates select=\"node()\" mode=\"top\" />\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\" mode=\"top\">\n"
"  <v:xsd-stub-top>\n"
"    <xsl:apply-templates select=\"node()\" mode=\"top\" />\n"
"  </v:xsd-stub-top>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:*\" mode=\"top\">\n"
"  <xsl:copy>\n"
"    <xsl:call-template name=\"v-attrs\" />\n"
"    <xsl:apply-templates select=\"node()\" />\n"
"  </xsl:copy>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:*\">\n"
"  <xsl:copy>\n"
"    <xsl:call-template name=\"v-attrs\" />\n"
"    <xsl:apply-templates select=\"node()\" />\n"
"  </xsl:copy>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:vscx\" />\n"
"<!--\n"
"  <xsl:copy>\n"
"    <xsl:for-each select=\"@name|@url\"><xsl:copy /></xsl:for-each>\n"
"    <xsl:apply-templates select=\"node()\" />\n"
"  </xsl:copy>\n"
"</xsl:template>\n"
"-->\n"
"\n"
"<xsl:template name=\"v-attrs\">\n"
"  <xsl:for-each select=\"@*[not (name() like 'xhtml_%' or namespace-uri() = 'http://www.w3.org/1999/xhtml' or namespace-uri() = 'http://www.openlinksw.com/vspx/deps/' or namespace-uri() = 'http://www.w3.org/2001/XMLSchema-instance')]\">\n"
"    <xsl:copy />\n"
"  </xsl:for-each>\n"
"  <xsl:if test=\"@*[name() like 'xhtml_%' or namespace-uri() = 'http://www.w3.org/1999/xhtml']\">\n"
"    <xsl:attribute name=\"xsd-stub-xhtml\">\n"
"      <xsl:for-each select=\"@*[name() like 'xhtml_%' or namespace-uri() = 'http://www.w3.org/1999/xhtml']\">\n"
"        <xsl:value-of select=\"concat(' ',name(),' ')\"/>\n"
"      </xsl:for-each>\n"
"    </xsl:attribute>\n"
"  </xsl:if>\n"
"</xsl:template>\n"
"\n"
"\n"
"<xsl:template match=\"*\">\n"
"  <v:xsd-stub>\n"
"    <xsl:apply-templates select=\"node()\" />\n"
"  </v:xsd-stub>\n"
"</xsl:template>\n"
"\n"
"\n"
"<xsl:template match=\"script\">\n"
"  <v:xsd-stub-script>\n"
"    <xsl:apply-templates select=\"node()\" />\n"
"  </v:xsd-stub-script>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"text()|comment()|processing-instruction()\">\n"
"  <xsl:copy/>\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* vspx_pre_sql.xsl */

static const char *xsl35[]= {
"<?xml version='1.0'?>\n"
"<!--\n"
" -  \n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -  \n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -  \n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -  \n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -  \n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -  \n"
" -  \n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n"
"     version=\"1.0\"\n"
"     xmlns:v=\"http://www.openlinksw.com/vspx/\"  exclude-result-prefixes=\"v\"\n"
"     xmlns:xhtml=\"http://www.w3.org/1999/xhtml\">\n"
"<xsl:output method=\"text\" omit-xml-declaration=\"yes\" indent=\"yes\"\n"
"	cdata-section-elements=\"v:after-data-bind v:after-data-bind-container v:before-data-bind v:before-data-bind-container v:on-post v:on-post-container v:before-render v:before-render-container v:on-init v:script\" />\n"
"\n"
"<xsl:template match=\"/\">\n"
"  <xsl:apply-templates select=\"//v:*\" mode=\"attr-check\" />\n"
"  <xsl:apply-templates select=\"node()\" />\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\">\n"
"  <xsl:copy>\n"
"    <xsl:for-each select=\"@*\"><xsl:copy /></xsl:for-each>\n"
"    <xsl:apply-templates select=\"node()\" />\n"
"  </xsl:copy>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:*\">\n"
"  <xsl:copy>\n"
"    <xsl:for-each select=\"@*\"><xsl:copy /></xsl:for-each>\n"
"    <xsl:if test=\"empty(@control-udt) and empty (.[v:page])\">\n"
"      <xsl:attribute name=\"control-udt\"><xsl:apply-templates select=\".\" mode=\"create_control_name\"/></xsl:attribute>\n"
"    </xsl:if>\n"
"    <xsl:apply-templates select=\"node()\" />\n"
"  </xsl:copy>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:on-init|v:on-init-container|v:before-data-bind|v:before-data-bind-container|v:after-data-bind|v:after-data-bind-container|v:on-post|v:on-post-container|v:before-render|v:before-render-container\">\n"
"  <xsl:element name=\"{concat ('v:', replace (local-name(.), '-container', ''))}\">\n"
"    <xsl:for-each select=\"@*\"><xsl:copy /></xsl:for-each>\n"
"    <xsl:attribute name=\"belongs-to\"><xsl:apply-templates select=\"..\" mode=\"eh-belongs-to\"/></xsl:attribute>\n"
"--no_c_escapes-\n"
"   {\n"
"   <xsl:value-of select=\".\" />\n"
"   }<xsl:text/>\n"
"  </xsl:element>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:method|v:method-container\">\n"
"  <xsl:element name=\"{concat ('v:', replace (local-name(.), '-container', ''))}\">\n"
"    <xsl:for-each select=\"@*\"><xsl:copy /></xsl:for-each>\n"
"    <xsl:if test=\"empty(@returns)\">\n"
"      <xsl:attribute name=\"returns\">any</xsl:attribute>\n"
"    </xsl:if>\n"
"    <xsl:if test=\"empty(@arglist)\">\n"
"      <xsl:attribute name=\"arglist\">inout control vspx_control, inout e vspx_event</xsl:attribute>\n"
"    </xsl:if>\n"
"--no_c_escapes-\n"
"   {\n"
"   <xsl:value-of select=\".\" />\n"
"   }<xsl:text/>\n"
"  </xsl:element>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"text()|comment()|processing-instruction()\">\n"
"  <xsl:copy/>\n"
"</xsl:template>\n"
"\n"
"\n"
"<!-- mode=\"eh-belongs-to\": finding a name of control that relates to the given event handler -->\n"
"<xsl:template match=\"v:hidden\" mode=\"eh-belongs-to\" >\n"
"  <xsl:apply-templates select=\"..\" mode=\"eh-belongs-to\"/>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\" mode=\"eh-belongs-to\" >\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"@name and v:vcc_exists (name())\">\n"
"      <xsl:value-of select=\"@name\" />\n"
"    </xsl:when>\n"
"    <xsl:otherwise>\n"
"      <xsl:apply-templates select=\"..\" mode=\"eh-belongs-to\"/>\n"
"    </xsl:otherwise>\n"
"  </xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:*\" mode=\"eh-belongs-to\" >\n"
"  <xsl:value-of select=\"@name\" />\n"
"</xsl:template>\n"
"\n"
"<!--  mode=\"create_control_name\": composing target control name from tag name -->\n"
"\n"
"<xsl:template match=\"v:node-template\" mode=\"create_control_name\">vspx_tree_node</xsl:template>\n"
"<xsl:template match=\"v:leaf-template\" mode=\"create_control_name\">vspx_tree_node</xsl:template>\n"
"<xsl:template match=\"v:form[empty (@type) or @type='simple']\" mode=\"create_control_name\">vspx_form</xsl:template>\n"
"<xsl:template match=\"v:form\" mode=\"create_control_name\">vspx_<xsl:value-of select=\"@type\" />_form</xsl:template>\n"
"<xsl:template match=\"v:button[@action='simple']\" mode=\"create_control_name\">vspx_button</xsl:template>\n"
"<xsl:template match=\"v:button[@action='submit']\" mode=\"create_control_name\">vspx_submit</xsl:template>\n"
"<xsl:template match=\"v:button\" mode=\"create_control_name\">vspx_<xsl:value-of select=\"@action\" />_button</xsl:template>\n"
"<xsl:template match=\"v:template[@type='row']\" mode=\"create_control_name\">vspx_row_template</xsl:template>\n"
"<xsl:template match=\"v:template[@type='browse']\" mode=\"create_control_name\">vspx_row_template</xsl:template>\n"
"<xsl:template match=\"v:template\" mode=\"create_control_name\">vspx_template</xsl:template>\n"
"<xsl:template match=\"v:local-variable\" mode=\"create_control_name\">vspx_field_value</xsl:template>\n"
"<xsl:template match=\"v:*\" mode=\"create_control_name\">vspx_<xsl:value-of select=\"translate (local-name (),'-','_')\" /></xsl:template>\n"
"\n"
"<!-- search for invalid combinations of attributes -->\n"
"\n"
"<xsl:template match=\"v:*[@element-path][not(@element-value)]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'element-path' attribute without 'element-value' attribute</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:*[@element-update-path][not(@element-value)]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'element-update-path' attribute without 'element-value' attribute</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:*[@element-place][not(@element-value)]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'element-place' attribute without 'element-value' attribute</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:*[@element-params][not(@element-path)]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'element-params' attribute without 'element-path' attribute</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:*[@element-update-params][not(@element-path)]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'element-update-params' attribute without 'element-update-path' attribute</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:check-box[@true-value][not(@is-boolean='true' or @is-boolean='1')]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'true-value' attribute that is useless because 'is-boolean' attribute is not set to 'true'</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:check-box[@false-value][not(@is-boolean='true' or @is-boolean='1')]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'false-value' attribute that is useless because 'is-boolean' attribute is not set to 'true'</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:validator[@regexp][not(@test='regexp')]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'regexp' attribute that is useless because 'test' attribute is not set to 'regexp'</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:validator[@min][not(@test='value' or @test='length')]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'min' attribute that is useless because 'test' attribute is not set to 'value' or 'length'</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:validator[@max][not(@test='value' or @test='length')]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'max' attribute that is useless because 'test' attribute is not set to 'value' or 'length'</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:button[@child-window-options][not(@action='browse')]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'child-window-options' attribute that is useless because 'action' attribute is not set to 'browse'</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:button[@browser-current][not(@action='browse')]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'browser-current' attribute that is useless because 'action' attribute is not set to 'browse'</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:button[@browser-filter][not(@action='browse')]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'browser-filter' attribute that is useless because 'action' attribute is not set to 'browse'</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:button[@browser-list][not(@action='browse')]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'browser-list' attribute that is useless because 'action' attribute is not set to 'browse'</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:button[@browser-mode][not(@action='browse')]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'browser-mode' attribute that is useless because 'action' attribute is not set to 'browse'</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:button[@browser-type][not(@action='browse')]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'browser-type' attribute that is useless because 'action' attribute is not set to 'browse'</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:button[@browser-xfer][not(@action='browse')]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'browser-xfer' attribute that is useless because 'action' attribute is not set to 'browse'</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:button[@selector][not(@action='browse')]\" mode=\"attr-check\">\n"
"  <xsl:call-template name=\"report-bug\"><xsl:with-param name=\"bug\">'selector' attribute that is useless because 'action' attribute is not set to 'browse'</xsl:with-param></xsl:call-template>\n"
"</xsl:template>\n"
"\n"
"\n"
"<xsl:template match=\"*\" mode=\"attr-check\"></xsl:template>\n"
"\n"
"<xsl:template name=\"report-bug\">\n"
"  <xsl:message terminate=\"yes\">\n"
"    <xsl:text>The VSPX control</xsl:text>\n"
"    <xsl:if test=\"@name\"> '<xsl:value-of select=\"@name\"/>'</xsl:if>\n"
"    <xsl:text>of type '</xsl:text><xsl:value-of select=\"local-name()\"/><xsl:text>'</xsl:text>\n"
"    <xsl:if test=\"@debug-srcfile\"> (at line <xsl:value-of select=\"@debug-srcline\"/> of '<xsl:value-of select=\"@debug-srcfile\"/>')</xsl:if>\n"
"    <xsl:text> has </xsl:text><xsl:value-of select=\"$bug\"/>\n"
"  </xsl:message>\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* vspx_log_format.xsl */

static const char *xsl36[]= {
"<?xml version='1.0'?>\n"
"<!--\n"
" -  \n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -  \n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -  \n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -  \n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -  \n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -  \n"
" -  \n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n"
"     version=\"1.0\"\n"
"     xmlns:v=\"http://www.openlinksw.com/vspx/\"  exclude-result-prefixes=\"v\"\n"
"     xmlns:xhtml=\"http://www.w3.org/1999/xhtml\"\n"
"     xmlns:vd=\"http://www.openlinksw.com/vspx/deps/\"\n"
"     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n"
"      >\n"
"<xsl:output method=\"html\" omit-xml-declaration=\"yes\" indent=\"no\" />\n"
"\n"
"<xsl:template match=\"/\">\n"
"<hr/>\n"
"<xmp><xsl:copy-of select=\"*/*\"/></xmp>\n"
"<hr/>\n"
"<xmp><xsl:call-template name=\"group\"><xsl:with-param name=\"lst1\" select=\"*/*\"/></xsl:call-template></xmp>\n"
"<hr/>\n"
"<xsl:variable name=\"grouped\"><xsl:call-template name=\"group\"><xsl:with-param name=\"lst1\" select=\"*/*\"/></xsl:call-template></xsl:variable>\n"
"<h3>That's how the page has been executed:</h3>\n"
"  <ul>\n"
"  <xsl:apply-templates select=\"$grouped\" mode=\"render\" />\n"
"  </ul>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\" mode=\"render\">\n"
"  <li><b><xsl:value-of select=\"if(name()='begin-and-end','run',name())\"/></b><xsl:text> </xsl:text><xsl:value-of select=\"@text\"/> at <b><xsl:value-of select=\"@control-name\"/></b>\n"
"  <xsl:if test=\"@instance-name\"> (<xsl:value-of select=\"@instance-name\"/>)</xsl:if>\n"
"<!--    <xsl:value-of select=\"@begin-id\"/>-<xsl:value-of select=\"@id\"/> -->\n"
"    <xsl:if test=\"ul\"><ul><xsl:apply-templates select=\"ul/*\" mode=\"render\"/></ul></xsl:if>\n"
"  </li>\n"
"</xsl:template>\n"
"\n"
"<xsl:template name=\"group\">\n"
"  <xsl:variable name=\"lst\"><xsl:copy-of select=\"$lst1\"/></xsl:variable>\n"
"  <xsl:variable name=\"inners\" select=\"$lst/*[following-sibling::*/@begin-id = preceding-sibling::*/@id]\"/>\n"
"<!--  <outers><ul><xsl:copy-of select=\"$lst/*[not(@id = $inners/@id)]\"/></ul></outers> -->\n"
"<!--  <inners><ul><xsl:copy-of select=\"$inners\"/></ul></inners> -->\n"
"  <xsl:for-each select=\"$lst/*[not(@id = $inners/@id)]\">\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"@begin-id\"></xsl:when>\n"
"      <xsl:otherwise>\n"
"        <xsl:variable name=\"pair-begin\" select=\".\"/>\n"
"        <xsl:variable name=\"pair-end\" select=\"$pair-begin/following-sibling::*[@begin-id = $pair-begin/@id]\"/>\n"
"        <xsl:choose>\n"
"          <xsl:when test=\"count($pair-end) = 1\">\n"
"            <xsl:element name=\"{concat(name($pair-begin),'-and-',name($pair-end))}\">\n"
"              <xsl:copy-of select=\"$pair-end/@*\"/>\n"
"              <xsl:copy-of select=\"@*|node()\"/>\n"
"              <xsl:copy-of select=\"$pair-end/node()\"/>\n"
"              <ul>\n"
"                <xsl:call-template name=\"group\"><xsl:with-param name=\"lst1\" select=\"$pair-begin/following-sibling::*[@id &lt; $pair-end/@id]\"/></xsl:call-template>\n"
"              </ul>\n"
"            </xsl:element>\n"
"          </xsl:when>\n"
"          <xsl:otherwise><xsl:copy-of select=\".\"/></xsl:otherwise>\n"
"        </xsl:choose>\n"
"      </xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"begin[following-sibling::*[1][self::end][@control-name=current()/@control-name][@text=current()/@text]]\" mode=\"collapse\">\n"
"  <run><xsl:copy-of select=\"@*|node()\"/></run>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"end[preceding-sibling::*[1][self::begin][@control-name=current()/@control-name][@text=current()/@text]]\" mode=\"collapse\">\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"begin[following-sibling::*[1][self::break][@control-name=current()/@control-name]]\" mode=\"collapse\">\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"break[preceding-sibling::*[1][self::begin][@control-name=current()/@control-name]]\" mode=\"collapse\">\n"
"  <run-break><xsl:copy-of select=\"@*|node()\"/></run-break>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\" mode=\"collapse\">\n"
"<xsl:copy><xsl:copy-of select=\"@*|node()\"/></xsl:copy>\n"
"</xsl:template>\n"
"\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* vspx.xsd */

static const char *xsd37[]= {
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
"<!--\n"
" -  \n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -  \n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -  \n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -  \n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -  \n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -  \n"
" -  \n"
"-->\n"
"<!-- the common template for VSPX documentation reference manual -->\n"
"<!--\n"
"			common info per element\n"
"			<xs:appinfo>\n"
"			    <refpurpose></refpurpose>\n"
"			    <special-childs>\n"
"				<child name=\"\" />\n"
"			    </special-childs>\n"
"			</xs:appinfo>\n"
"\n"
"			this is to skip rendering of a element\n"
"			<xs:appinfo>\n"
"			  <no-render />\n"
"			</xs:appinfo>\n"
"			-->\n"
"<xs:schema targetNamespace=\"http://www.openlinksw.com/vspx/\" xmlns:v=\"http://www.openlinksw.com/vspx/\" xmlns:vd=\"http://www.openlinksw.com/vspx/deps/\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\n"
"  <xs:annotation>\n"
"    <xs:documentation>VSPX Syntax Reference</xs:documentation>\n"
"  </xs:annotation>\n"
"  <xs:annotation>\n"
"    <xs:documentation>Types of VSPX attributes</xs:documentation>\n"
"  </xs:annotation>\n"
"  <xs:simpleType name=\"CalculateableValue\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>global</xs:appinfo>\n"
"      <xs:appinfo><refpurpose>The type of attribute that contains an expression to be calculated at run time.</refpurpose></xs:appinfo>\n"
"      <xs:documentation>\n"
"The type of a string constant or an expression.\n"
"If the value of this type is started with '--', the rest of string\n"
"is the text of an expression to be calculated in order to get the effective value of the property.\n"
"If the value of this type is not started with '--', the effective value is the original string itself.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:whiteSpace value=\"preserve\"/>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:simpleType name=\"ForcedCalculateableValue\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>global</xs:appinfo>\n"
"      <xs:appinfo><refpurpose>The type of attribute that contains an expression to be calculated at run time.</refpurpose></xs:appinfo>\n"
"      <xs:documentation>\n"
"The type of an expression.\n"
"The value of this type must be started with '--', the rest of string\n"
"is the text of an expression to be calculated in order to get the effective value of the property.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:whiteSpace value=\"preserve\"/>\n"
"      <xs:pattern value='--([^&apos;&quot;]|([&apos;]([^&apos;]|([\\\\][&apos;]))*[&apos;])|([&quot;]([^&quot;]|([\\\\][&quot;]))*[\"]))+'/>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:simpleType name=\"ButtonStyle\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>\n"
"Style of rendering of the button.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:enumeration value=\"submit\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This is a default style used, no special handling.\n"
"The button will be rendered as a usual submit button.\n"
"				</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"url\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The button will be rendered as a link, furthermore client side JavaScript code will be produced to act as submit button.	</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"image\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The button will be rendered as an image on the browser under link button. In that case value of button control must be link to the image file.\n"
"				</xs:documentation>\n"
"        </xs:annotation>\n"
"        <!-- was icon? -->\n"
"      </xs:enumeration>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:simpleType name=\"ButtonAction\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>\n"
"VSPX type of the button.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:enumeration value=\"simple\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>is a simple submit button, no special functions\n"
"				</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"submit\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>an alias of 'simple' button, obsolete\n"
"				</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"delete\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>a button for deleting a row in a data-set or data-grid control. This is represented as a submit button with a special on-post script. The delete function is performed based on table, key attributes. (check implementation!!)\n"
"				</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"browse\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Button that opens pup-up window using client-side javascript (browse-button).\n"
"This control allows the designer to place some part of a form's input into a pop-up window. When the HTML page is rendered, this control puts a button and associated client-side javascript into the resulting page so clicking the button opens a child window.  </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"return\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"This is to be used on a page invoked for selecting from a browse button.  Specifies that the value of the fields designated by the field children are to be asigned to the corresponding fields of the invoking page.\n"
"				</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"logout\">\n"
"        <xs:annotation>\n"
"          <xs:documentation> This will terminate the current session when clicked.  Can only occur inside the login control.\n"
"				</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:simpleType name=\"SqlName\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>global</xs:appinfo>\n"
"      <xs:appinfo><refpurpose>The type of attribute that contains a name of the Virtuoso/PL UDT instance that should be created for the control.</refpurpose></xs:appinfo>\n"
"      <xs:documentation>\n"
"The type for a Virtuoso/PL name that should be used during code generation.\n"
"KNOWN BUG: If double quotes are used in the value of this type then\n"
"the generated code may be incorrect.\n"
"This is why this schema restrictes the syntax of values of such type.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:minLength value=\"1\" fixed=\"false\"/>\n"
"      <xs:maxLength value=\"32\" fixed=\"false\"/>\n"
"      <xs:pattern value=\"[A-Za-z0-9_]{1,32}\"/>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:simpleType name=\"SqlTableQname\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>\n"
"The type for a Virtuoso table name in form 'database.user.localname'.\n"
"KNOWN BUG: If double quotes are used in the value of this type then\n"
"the generated code may be incorrect.\n"
"This is  why this schema restricts the syntax of values of such type.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:pattern value=\"[A-Za-z0-9_]{1,32}\\.[A-Za-z0-9_]{0,32}\\.[A-Za-z0-9_]{1,32}\"/>\n"
"      <xs:pattern value=\"[A-Za-z0-9_]{1,32}\"/>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:simpleType name=\"SqlCode\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>global</xs:appinfo>\n"
"      <xs:appinfo><refpurpose>The type of a string value that is a Text of a Virtuoso/PL procedure.</refpurpose></xs:appinfo>\n"
"      <xs:documentation>Text of an event handler or other Virtuoso/PL procedure. This is\n"
"expected to be a complete statement or sequence of statements, hence\n"
"to be terminated like a statement, unlike the 'calculatable value'\n"
"expression case.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:whiteSpace value=\"preserve\"/>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:simpleType name=\"LoginMode\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>Method of passing login information from page to page.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:enumeration value=\"digest\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>HTTP digest authentication is used and the session id will travel as the opaque data in the digest headers.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"url\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The url mode means that URL poisoning is used and that the session id passes with the links, posts etc.  Some automation is offered for this by the vspx:url and vspx:form and derived controls.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"cookie\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>The session id is set in a cookie on browser.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:simpleType name=\"QNameOrEmpty\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>\n"
"The type for a name of redundand tags placed by WYSIWYG tools.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:pattern value=\"(\\w+[\\w:.-]*)?\"/>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:simpleType name=\"Unused\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>Indicates that the attribute is never used.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\"/>\n"
"  </xs:simpleType>\n"
"  <xs:simpleType name=\"TreeOrientation\" final=\"restriction\">\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:pattern value=\"horizontal\"/>\n"
"      <xs:pattern value=\"vertical\"/>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:simpleType name=\"SqlExpressionType\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>\n"
"Denotes the type of SQL expression\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:enumeration value=\"SQL\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The expression is a SQL select statement</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"TABLE\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>The expression is a table reference</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"PROCEDURE\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The expression is a procedure call</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"ARRAY\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>The rowset is already prepared and supplied as an array of arrays</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:simpleType name=\"PlCursorType\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>\n"
"This defines the type of PL scrollable cursor used.  In all cases, the\n"
"cursor is reopened at each invocation of the page and a\n"
"bookmark is used to position it.  The dynamic type is\n"
"recommended for performance, however this is efficient only if\n"
"the table is being read in the order of some index.\n"
"These must be fixed values, no data binding.\n"
"      </xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:enumeration value=\"static\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A static cursor is used.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"dynamic\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A dynamic cursor is used.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"keyset\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A keyset cursor is used.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:simpleType name=\"DebugLogValue\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>This defines what sort of data are saved to the debugging log. The value of this type is a space-delimited list of types of events that should be saved to the log.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:NMTOKENS\"/>\n"
"  </xs:simpleType>\n"
"  <!--\n"
";\n", 
"-->\n"
"  <xs:simpleType name=\"OnOff\">\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:enumeration value=\"on\"/>\n"
"      <xs:enumeration value=\"off\"/>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:attributeGroup name=\"HtmlGenAttributes\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>Commonly used attributes that configures the generated HTML layout. All of them have to begin with prefix 'xhtml_' and sufixed with HTML attribute name.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:attribute name=\"xsd-stub-xhtml\" type=\"xs:string\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>This attribute is for internal use only. It has no effect if added to the source VSPX file.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"width\" type=\"xs:string\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>Visible width of the control when it is displayed in WYSIWYG tools when the source VSPX text is edited.\n"
"The value of this attribute will not be used when the resulting HTML is rendered.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"height\" type=\"xs:string\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>Visible width of the control when it is displayed in WYSIWYG tools when the source VSPX text is edited.\n"
"The value of this attribute will not be used when the resulting HTML is rendered.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <!--xs:attribute name=\"size\" type=\"xs:string\" use=\"optional\"/-->\n"
"  </xs:attributeGroup>\n"
"  <xs:attributeGroup name=\"SqlGenAttributes\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>Commonly used attributes that configures the generated Virtuoso/PL code.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:attribute name=\"name\" type=\"v:SqlName\" use=\"required\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>A page level unique name identifying a control.</xs:documentation>\n"
"      </xs:annotation>\n"
"      <!-- name of control is always required! -->\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"annotation\" type=\"xs:string\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>A human readable comment.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"initial-enable\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>Determines  whether  a control is initially visible. True by default. Could be data-bound to an SQL expression.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"enabled\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>Determines  whether  a control is visible. True by default. Could be data-bound to an SQL expression.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"instantiate\" type=\"v:CalculateableValue\" use=\"optional\" default=\"true\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>Determines whether a control instantiate its children. It is true by default. It could be data-bound to an SQL expression. Unlike most of calcucateable attributes, the value of this attribute for a control is calcluated before calling 'on-init' event handler of the control; other values are calculated before calling 'before-data-bind' event handler.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"control-udt\" type=\"v:SqlName\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>At run time every control is represented as an instance of some user-defined type (UDT). VSPX compiles selects the UDT to use depending on name of the XML element that represents the control and maybe some of its attributes. In some specific cases the application developer may instruct VSPX compiler to use some other UDT, e.g. an application-specific UDT that is derived from the preset one. If specified, the value of 'control-udt' attribute should be equal to the name of the desired target UDT.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attributeGroup ref=\"v:HtmlGenAttributes\"/>\n"
"  </xs:attributeGroup>\n"
"  <xs:attributeGroup name=\"SqlColumn\">\n"
"    <xs:attribute name=\"column\" type=\"v:SqlName\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>The name of the column bound.\n"
"If nothing else is specified, the column meta data from the containing update form sets the field's attributes.\n"
"</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"null-value\" type=\"xs:string\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>This value will be shown if value of the column is NULL, also\n"
"	      value of the control will be set to null if this value is passed upon POST request.\n"
"	  </xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"  </xs:attributeGroup>\n"
"  <xs:attributeGroup name=\"UserInputAttributes\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>Attributes that configures reactions on user inputs.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:attribute name=\"error-glyph\" type=\"xs:string\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>The character to be displayed near the resulting HTML input element if the test of v:validator of the element detects an error in the current value of the element.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"auto-submit\" type=\"xs:boolean\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>Flag to auto submit the parent form if value of the control is changed.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"  </xs:attributeGroup>\n"
"  <!--\n"
";\n", 
"-->\n"
"  <xs:attributeGroup name=\"FieldValue\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>Attributes to specify the value that is displayed (and modified) by an user input control.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:attribute name=\"value\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>Data bindable value of control, represents value of HTML control to be drawn.\n"
"The calculated value of this attribute is stored in the control in ufl_value field.\n"
"</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"element-value\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>An XML entity that contains a value to be displayed by an HTML control.\n"
"The calculated value is stored in ufl_element_value field of the control.\n"
"This value is used only if ufl_value is null (e.g. if the 'value' attribute is not set at all), and the method vc_get_value_from_element() will be used to calculate ufl_value based on ufl_element_value, ufl_element_path and ufl_element_place.\n"
"</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"element-place\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>The place of actual data inside an XML element. The calculated value of this attribute is stored in ufl_element_place field of the control. This is to process XMLSchema-compatible data without writing extra code for handling NULL values. The XML element can contain the value to be bound in either attribute or in an inner text node. XMLSchema treats missing attributes as NULL values. missing text node as an empty string value and if 'xsi:nil' attribute is 'true' then inner text value is NULL no matter if there are any text nodes. These self-evident rules are convenient for XQuery data retrieval but not for data update: an result of some XQuery expression can point to data but not to a place where data should occur in the future.\n"
"The use of 'element-place' allows to eliminate the problem. Attributes 'element-value', 'element-path' and 'element-update-path' may locate an element that is always present whereas 'element-place' describes where the desired datum will occur in the element.\n"
"The value of this attribute should be a string of syntax '@attributename' or 'text()'. If this is '@attributename' then the effective bound value is a value of the specified attribute or NULL if the specified attribute is missing. On update, either the attribute is created/edited in order to set non-NULL value or the attribute is deleted in order to set NULL.\n"
"If text() is specified then both text value of the element and the value of its 'xsi:nil' are properly handled on both data bind and update.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"element-path\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>This is the path inside the entity that comes from 'element-value' attribute. The default path is 'self::node()'. This path is used to point precisely to an subentity that should actually be used for data binding. The calculated value of this attribute should be a string in XQuery syntax, and it is saved in ufl_element_path member of the control.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"element-params\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>This is the vector of parameter values of the path specified by 'element-path' attribute. The default is NULL indicating no parameters. The attribute is calculated but not used if 'element-path' attribute is missing. The calculated value of this attribute should be either NULL or a vector of even length whose items are parameter names and parameter values; refer to the description of xquery_eval() function for more details. The value of the attribute is saved in ufl_element_params member of the control.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"element-update-path\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>Like the value of 'element-path', this is the path inside the entity that comes from 'element-value' attribute. The difference is that 'element-path' is used inside 'vc_get_value_from_element() during data-bind to set ufl_value based on ufl_element_value whereas 'element-update-path' is used during data update inside 'vc_put_value_to_element() in order to save data inside the document that is referenced by ufl_element_value. The default path for update is equal to the path for data bind, i.e. it is the value of the calculated 'element-path' attribute or 'self::node()'. The calculated value of 'element-update-path' should be a string in XQuery syntax, and it is saved in ufl_element_update_path member of the control.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"element-update-params\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>This is the vector of parameter values of the path specified by 'element-update-path' attribute. The default is NULL indicating no parameters. The attribute is calculated but not used if 'element-update-path' attribute is missing (e.g. you should not try to specify 'element-path' without 'element-update-path' and both 'element-params' and 'element-update-params' in hope that values from 'element-update-params' will be passed to 'element-path' on update). The calculated value of this attribute should be either NULL or a vector of even length whose items are parameter names and parameter values; refer to the description of xquery_eval() function for more details. The value of the attribute is saved in ufl_element_update_params member of the control.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"fmt-function\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>This is to convert the value that is bound to the control into a string to use during the rendering. The value of this attribute should be a name of function that takes a single argument of the type that matches the type of ufl_value and returns a string. If this is used then the value of 'cvt-function' should probably be a name of function that converts the string back to the desired data type.\n"
"If a control supports 'format' attribute then the format is applied to the result of 'fmt-function', so the value returned by fmt-function may be e.g. an integer to be formatted by '%d' format.\n"
"The calculated value of this attribute is stored in ufl_fmt_fn field of the control.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"cvt-function\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>This is to convert a user input of type varchar into a value that should be stored in ufl_value (and e.g. placed into some database column by an update).\n"
"The calculated value of this attribute is stored in ufl_cvt_fn field of the control.\n"
"For more details, see the description of 'fmt_function' attribute above.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"  </xs:attributeGroup>\n"
"  <!--\n"
";\n", 
"-->\n"
"  <xs:attributeGroup name=\"LoginParams\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>The description of login method</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:attribute name=\"realm\" type=\"xs:NMTOKEN\" use=\"required\"/>\n"
"    <xs:attribute name=\"mode\" type=\"v:LoginMode\" use=\"required\"/>\n"
"    <xs:attribute name=\"user-password\" type=\"xs:NMTOKEN\" use=\"required\"/>\n"
"    <xs:attribute name=\"user-password-check\" type=\"xs:NMTOKEN\" use=\"required\"/>\n"
"  </xs:attributeGroup>\n"
"  <xs:attributeGroup name=\"BrowseButtonParams\">\n"
"    <xs:annotation>\n"
"      <xs:documentation> These are used in browse-button that opens pup-up window using client-side javascript.\n"
"      </xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:attribute name=\"child-window-options\" type=\"xs:string\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>Options for oppening a child pop-up window.This can be used only in conjuction with  action browse.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"browser-current\" type=\"xs:int\" use=\"optional\" default=\"0\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>Current directory of browsing. Can be used only with browse button for WebDAV or File system resources.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"browser-filter\" type=\"xs:string\" use=\"optional\" default=\"*\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>Filter expression(s) for browsing. (see above)</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"browser-list\" type=\"xs:string\" use=\"optional\" default=\"1\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>Type of browser list, 0 - short, 1 - long</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"browser-mode\" type=\"xs:string\" use=\"optional\" default=\"RES\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>COL, RES or STANDALONE , for a file system or DAV browse button, this specifies whether to return an path name or internal ID.\n"
"</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"browser-type\" type=\"xs:string\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>This designates the type of browser: dav or OS (filesystem).</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"browser-xfer\" type=\"xs:string\" use=\"optional\" fixed=\"DOM\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>For a browse button, this is the   means  of transferring the data between windows, DOM is default. No other options in current implementation.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"selector\" type=\"xs:anyURI\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>For a browse button this is the  URL that will be loaded into the pop up window.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"  </xs:attributeGroup>\n"
"  <xs:attributeGroup name=\"DebugAttributes\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>These attributes are for internal use only. The VSPX compiler adds them automatically to improve localization of errors in source VSPX pages.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:attribute name=\"debug-srcfile\" type=\"xs:string\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>URI of the source document where the tag comes from.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"debug-srcline\" type=\"xs:integer\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>Line number in the source document where the tag comes from.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"    <xs:attribute name=\"debug-log\" type=\"v:DebugLogValue\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>This defines what sort of data are saved to the debugging log.\n"
"</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"  </xs:attributeGroup>\n"
"  <xs:attributeGroup name=\"WmAttributes\">\n"
"    <xs:anyAttribute namespace=\"##other\" processContents=\"skip\"/>\n"
"  </xs:attributeGroup>\n"
"  <xs:group name=\"AnyHtmlContent\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>Arbitrary HTML tags.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:choice>\n"
"      <xs:element ref=\"v:style\"/>\n"
"      <xs:element ref=\"v:placeholder\"/>\n"
"      <xs:element ref=\"v:xsd-stub\"/>\n"
"      <xs:element ref=\"v:xsd-stub-script\"/>\n"
"      <xs:any namespace=\"##other\" processContents=\"skip\"/>\n"
"      <xs:any namespace=\"##local\"/>\n"
"    </xs:choice>\n"
"  </xs:group>\n"
"  <xs:annotation>\n"
"    <xs:documentation>VSPX Event Handlers</xs:documentation>\n"
"  </xs:annotation>\n"
"  <xs:complexType name=\"EventHandler\" mixed=\"true\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>Arbitrary event handler.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:choice minOccurs=\"0\">\n"
"      <xs:element ref=\"v:script\"/>\n"
"      <xs:element ref=\"v:xsd-stub-script\"/>\n"
"    </xs:choice>\n"
"    <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"    <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    <xs:attributeGroup ref=\"v:HtmlGenAttributes\"/>\n"
"  </xs:complexType>\n"
"  <xs:element name=\"after-data-bind\" type=\"v:EventHandler\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>Container for code that should be executed after data bind.</refpurpose>\n"
"        <no-render/>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>\n"
"The code contained in this element is executed after the default data bind processing on the returning edge of recursion.\n"
"The context has self as the page, control as the control with this handler, event as the vspx_event which caused the page invocation.\n"
"Any return value from the code is ignored.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"  </xs:element>\n"
"  <xs:element name=\"before-data-bind\" type=\"v:EventHandler\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>Container for code that should be executed before data bind.</refpurpose>\n"
"        <no-render/>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>\n"
"The code contained in this element is executed before the default data bind processing on the descending edge of recursion.\n"
"The context has self as the page, control as the control with this handler, event as the vspx_event which caused the page invocation.\n"
"A return value from the code if equal to 1 (one) will stop further data-bind processing of the\n"
"containing control and it's children if any.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"  </xs:element>\n"
"  <xs:element name=\"on-post\" type=\"v:EventHandler\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>Container for code that should be executed when the element gets a post.</refpurpose>\n"
"        <no-render/>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>\n"
"The code contained in this element is executed when the element gets a post.\n"
"For fields and forms, this is a context for an a SQL compound statement that will be executed.\n"
"The statement should end with a return 1 or 0.  The implicit return is 0.  A return of 1 means that the post is fully handled here and not to be passed on to the parent chain.\n"
"A 0 means that the post was not handled and the next control up the chain will try.\n"
"</xs:documentation>\n"
"      <xs:documentation>\n"
"The context has a self which is the page, a vspx_control which is the control which defines this handler, and a origin_control, which is the control that first got the post event.  This will be a data field or button.  The vspx_event with the post's data will be in the variable event.\n"
"</xs:documentation>\n"
"      <xs:documentation>\n"
"The interpretation of the return value is the same for other event handlers.  SQL\n"
"conditions signalled will go to the page, these condition handlers are\n"
"invoked in no special context, hence the declare handler for SQL\n"
"construct should not be used to pass control between handlers, but only\n"
"within handlers.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"  </xs:element>\n"
"  <!--\n"
";\n", 
"-->\n"
"  <xs:element name=\"before-render\" type=\"v:EventHandler\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>Container for code that should be executed before rendering.</refpurpose>\n"
"        <no-render/>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>\n"
"The code contained in this element is executed on the descending edge of recursion when traversing the vspx control tree before rendering.\n"
"This is expected to have side effects on vspx controls only, not to return anything or emit any output.\n"
"Any return value from the code is ignored.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"  </xs:element>\n"
"  <xs:element name=\"on-init\" type=\"v:EventHandler\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>Container for code that should be executed at the end of control instantiation.</refpurpose>\n"
"        <no-render/>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>The code contained in this element is executed at the end of the control's constructor.\n"
"	This is expected to have additional initialization checking etc.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"  </xs:element>\n"
"  <xs:element name=\"on-init-container\" type=\"v:EventHandler\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>This is identical to v:on-init.</refpurpose>\n"
"        <no-render/>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"  </xs:element>\n"
"  <xs:element name=\"before-data-bind-container\" type=\"v:EventHandler\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>This is identical to v:before-data-bind.</refpurpose>\n"
"        <no-render/>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"  </xs:element>\n"
"  <xs:element name=\"after-data-bind-container\" type=\"v:EventHandler\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>This is identical to v:after-data-bind.</refpurpose>\n"
"        <no-render/>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"  </xs:element>\n"
"  <xs:element name=\"on-post-container\" type=\"v:EventHandler\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>This is identical to v:on-post.</refpurpose>\n"
"        <no-render/>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"  </xs:element>\n"
"  <xs:element name=\"before-render-container\" type=\"v:EventHandler\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>This is identical to v:before-render.</refpurpose>\n"
"        <no-render/>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"  </xs:element>\n"
"  <xs:group name=\"EventTarget\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>Something that may become an receiver of an event.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:choice>\n"
"      <xs:element ref=\"v:on-init\"/>\n"
"      <xs:element ref=\"v:before-data-bind\"/>\n"
"      <xs:element ref=\"v:after-data-bind\"/>\n"
"      <xs:element ref=\"v:on-post\"/>\n"
"      <xs:element ref=\"v:before-render\"/>\n"
"      <xs:element ref=\"v:on-init-container\"/>\n"
"      <xs:element ref=\"v:before-data-bind-container\"/>\n"
"      <xs:element ref=\"v:after-data-bind-container\"/>\n"
"      <xs:element ref=\"v:on-post-container\"/>\n"
"      <xs:element ref=\"v:before-render-container\"/>\n"
"    </xs:choice>\n"
"  </xs:group>\n"
"  <xs:annotation>\n"
"    <xs:documentation>VSPX Controls</xs:documentation>\n"
"  </xs:annotation>\n"
"  <!--\n"
";\n", 
"-->\n"
"  <xs:element name=\"page\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>The container for the rest of the vspx code.\n"
"The page or a subclass of it will be the outermost VSPX element  on any VSPX page.\n"
"Each .vspx file defines explicitly one custom page class derived from vspx_page.\n"
"This element can enclose all HTML elements or can be incorporated in it's children on place apropriate for\n"
"rendering the VSPX controls, but one VSPX page must contain only one vspx:page element. and noe VSPX-specific element may appear outside the vspx:page. It can be placed in other HTML stuff or around it, does not matter, but VSP &amp; VSPX code must be inside it (the same applies to customized HTML attributes, i.e. containing &lt;?V &amp; &lt;?U shortcuts).\n"
"Note that when using 'include' or 'decoration' features the top level page element will be : in case of include - 'this' page, in case of 'decoration' - the decoration page.\n"
"Also page variables, controls will be combined in all cases of inclusion or macro-expansion, so their names must not be duplicated; this means that names of variables introduced by macro expansion or inclusion must not conflict with cnames of variables or controls in the top level page or any included or macro content.\n"
"</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>Container of VSPX code.</refpurpose>\n"
"        <tutorial id=\"VX-S-1\">/tutorial/web/vx_s_1/simple.vspx</tutorial>\n"
"        <tutorial id=\"VX-S-8\">/tutorial/web/vx_s_8/formsty.vspx</tutorial>\n"
"        <special-childs>\n"
"          <child name=\"variable\"/>\n"
"        </special-childs>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType mixed=\"true\">\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:AnyVspxPageContent\"/>\n"
"      </xs:choice>\n"
"      <xs:attribute name=\"name\" type=\"v:SqlName\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The name of subclass of vspx_page to be generated. The name of class will be prefixed with 'page_' plus that name.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"decor\" type=\"xs:anyURI\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This attribute specifies a 'decoration' page URL. The decoration page is a VSPX page that is wrapped around the including page.  The content of the including page is then put in the place indicated by a placeholder element in the decor page.  This is useful for defining enclosing tables, headers, footers and other repeating content.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"style\" type=\"xs:anyURI\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This designates an external XSL-T style sheet to be apply over the page, before page compilation.  This is useful as a 'macro' feature.  The XSLT sheet may define rules for macroexpanding things in the page body.\n"
"	  </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"on-error-redirect\" type=\"xs:anyURI\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This specifies where to redirect the HTTP client in the event of an  an unhandled error.\n"
"This  will pass a __SQL_STATE, __SQL_MESSAGE and __PAGE as parameters to the error page.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"on-deadlock-retry\" type=\"xs:integer\" use=\"optional\" default=\"0\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This specifies how many times to retry page execution upon deadlock.\n"
"When the number of retries is reached, the behaviour will be as for other SQL errors.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"doctype\" type=\"xs:string\" use=\"optional\" default=\"-//W3C//DTD HTML 4.0 Transitional//EN\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This is to specify the resulting document type declaration (DTD) public URI.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"doctype-system\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This is to specify the resulting document type declaration (DTD) system URI.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"page-subclass\" type=\"v:SqlName\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The name of page subclass to be instantiated for processing.\n"
"		The subclass with this name MUST already be  defined.\n"
"		The subclass definition can be kept in a code-behind file (see code-file element).\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"file-name\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>The name of page to be generated.\n"
"	    Used by wizards to designate where generated page will be stored.\n"
"	    This attribute do not affect VSPX processing.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"no-script-function\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A function to enable or disable automatic NOSCRIPT element generation.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:HtmlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"include\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>A place where the source code of other page should be inserted.</refpurpose>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>The VSPX compiler replaces this control with the content of another page.\n"
"This will include the content from the specified url at this point of the page.  The url is relative to the page.\n"
"The inclusion will be done before compilation of VSPX into Virtuoso/PL, hence the include can contain either vspx or static HTML  content.\n"
"The only requirement is that the included file be well formed.\n"
"Note also that if you are using vspx namespace in the include file, it must be declared as such.\n"
"This element will not be instantiated.\n"
"instead of instantiating it will be replaced with content of the specified document.\n"
"The included page may or may not contain a 'page' element.\n"
"If a 'page' element is found in the included file\n"
"this will be skipped in the resulting page.\n"
"Also names of controls in the included file   MUST NOT conflict with names of controls in the top level page or other included content.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:attribute name=\"url\" type=\"xs:anyURI\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>URL of file to be included. If relative then the base is the page where the control resides.\n"
"E.g. If '/home/pageA' includes 'subdir1/pageB' and the included page includes 'subdir2/pageC' then 'pageC' should reside\n"
"in '/home/subdir1/subdir2', not in '/home/subdir2'.\n"
"          </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"active\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A data bound value to enable or disable the link. The default is '1' meaning 'enable'.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"initial-active\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A data bound value to enable or disable the link. The default is '1' meaning 'enable'.\n"
"Unlike 'active' attribute, this one is effective only when the page is displayed in the first time, not after user posts data back to the page.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"name\" type=\"v:Unused\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This is not used; it is allowed for compatibility only.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"code-file\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>Code-behind file containing SQL script.</refpurpose>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>This element is used to load an external SQL\n"
"	  script after page class compilation and before page execution.\n"
"	  This script may contain page subclass or custom control definitions.\n"
"	  In this way SQL code can be separated from VSPX markup, or in other words\n"
"	  to separate page design from application logic.\n"
"      </xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:attribute name=\"url\" type=\"xs:anyURI\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>URL of file to be loaded after VSPX page compilation.\n"
"		If relative then the base is the page where the control resides\n"
"		(i.e. same URL resolution rules applied as for includes).\n"
"          </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"template\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>Container for a group of controls and/or HTML code.</refpurpose>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>The container for any optional, repeatable or otherwise grouped controls or code. The type modifier is used to specify special kind of templates (i.e. repeatable content or tree node representation)</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType mixed=\"true\">\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:AnyVspxPageContent\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attribute name=\"type\" type=\"v:TemplateType\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The behaviour of the template.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"redirect\" type=\"xs:anyURI\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The URL to which the user agent is redirected if not authenticated, applicable only when type is 'if-no-login'.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"condition\" type=\"v:SqlCode\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This is a SQL expression to be tested for rendering the template</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"name-to-remove\" type=\"v:QNameOrEmpty\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This works together with set-to-remove, see next.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"set-to-remove\" type=\"v:TemplateSetToRemove\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This combined with name-to-remove gives posibility to remove a HTML elements from output.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"title\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	    <xs:documentation>When used inside tab control, this is used to show as label of the selector</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:simpleType name=\"TemplateType\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>\n"
"The enumeration of allowed types of v:template.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:enumeration value=\"simple\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The template contains an arbitrary number of controls and HTML tags and  groups them together to control their processing, e.g. to enable or disable them altogether depending on some condition.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"repeat\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A repeating row of v:data-set. The template of this type will be repeated for each row in the window of the data-set. It will be instantiated, data bound, rendered.  If the template contains forms and submits, they get the post method called as one would expect.\n"
"On data binding, the parent of the template has its dg_current_row data member set to an array representing the selected row from left to right.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"row\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A repeating row of v:data-grid. The template of this type will be repeated for each row in the window of the v:data-grid. It will be instantiated, data bound, rendered.  If the template contains forms and submits, they get the post method called as one would expect.\n"
"On data binding, the parent of the template has its dg_current_row data member set to an array representing the selected row from left to right.\n"
"</xs:documentation>\n"
"          <xs:documentation>\n"
"The controls under this template (such as text, label, button etc.) can access data in current row in order as columns are given by referencing te_rowset member of row template.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"frame\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"A non-repeating static content of v:data-grid.\n"
"Content of this template represents view in page when rows are selected,\n"
"position of scroll buttons, rowset and form for adding a record.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"if-exists\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"Template that is enabled only if the resultset is not empty in v:data-set.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"if-not-exists\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Template that is enabled only if the resultset is empty in v:data-set.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"add\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Template that is enabled when user adds new record in the resultset in v:data-set (if the resultset is not read-only).\n"
"Similarly to templates of type 'edit', the 'add' template contains a vspx:form of type 'update' that is used to allow adding of rows in table as specified.\n"
"Usually this form is a vspx_form + vspx_text constrained to columns and table selected in SQL expression of the parent vspx:data-set control with value of key attributes set to null. Please remember to set the 'if-not-exists' attribute of the form to 'insert'.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"browse\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This type is meaningful only for templates right inside templates of type 'repeat'. When the template of type 'repeat' is used multiple times to display every row of a data-set, the template of type 'browse' expands only for those rows that are not currently editable.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"edit\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Template that is enabled when user edits an existing record in the resultset in v:data-set (if the resultset isnot read-only and if the 'edit' attribute of v:data-set is set to 'true').\n"
"The template of this type usually contains a vspx:form of type 'update';\n"
"the 'table' attribute of the form is the name of the table from 'sql' attribute of the v:data-set where the 'edit' template is located; controls of the form are usually constrained to columns of the SQL expression of that 'sql' attribute.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"if-login\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Template that is enabled when user is logged in (e.g. for use in v:login. If the login is valid, the contents of this child will be instantiated.  This can be for example a button with 'action' attribute set to 'logout', a welcome message or such.  When using the vspx:login system, the user name is is obtained by connection_get ('vspx_user').</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"if-not-login\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Template that is enabled when user is not yet logged in or is already logged out (e.g. for use in v:login.\n"
"The template specifies what to do if there are no credentials with the page.\n"
"If the 'redirect' attribute is given, then the entire page containing\n"
"this is not processed at all but instead the page specified in the url\n"
"is processed instead, with the context being that of the invocation of\n"
"this page.  The redirect page can thus ask for the login and having\n"
"checked it return to this page, since it knows the url for this.  In\n"
"this way it is possible to bookmark places of which the uri's may\n"
"expire, and accessing an expired place will just prompt for the login\n"
"before going to the page.\n"
"\n"
"\n"
"If the redirect is not specified, the content of the template is instantiated and shown. The content can be arbitrary, e.g. the vspx:login-form control can appear here, providing a standard login form that prompts for a user name and password and has a submit button.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"tree-node\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"Template for internal nodes of the tree in v:tree (i.e. for nodes with children).\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"tree-leaf\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Template for terminal nodes of the tree in v:tree (i.e. for nodes without children).</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"input\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Template for input the SQL statement to execute it interactively in v:isql element.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"result\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Template to show if v:isql returns result without an error.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"error\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Template to be shown by v:isql if the user entered the SQL query and the execution of this query caused an error.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <!--\n"
";\n", 
"-->\n"
"  <xs:simpleType name=\"TemplateSetToRemove\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>The set of HTML tags to be removed from the rendered text.</xs:documentation>\n"
"      <xs:documentation>\n"
"<para>When a v:template has 'name-to-remove' attribute, the rendered content will not\n"
"contain the first opening tag and/or the last closing tag whose name is equal to\n"
"the value of 'name-to-remove'.\n"
"So the result of rendering of</para>\n"
"<programlisting><![CDATA[\n"
"<v:template name-to-remove='p' set-to-remove='bottom'	><p>[1A]</p><p>[1B]</p><p>[1C]</p></v:template>\n"
"<v:template name-to-remove='p' set-to-remove='both'	><p>[2A]</p><p>[2B]</p><p>[2C]</p></v:template>\n"
"<v:template name-to-remove='p' set-to-remove='top'	><p>[3A]</p><p>[3B]</p><p>[3C]</p></v:template>]]>\n"
"</programlisting>\n"
"<para> is </para><programlisting><![CDATA[\n"
"<p>[1A]</p><p>[1B]</p><p>[1C][2A]</p><p>[2B]</p><p>[2C][3A]</p><p>[3B]</p><p>[3C]</p>]]></programlisting>\n"
"<para>The typical use is composing of tables, lists etc. on per-line basis.</para>\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:enumeration value=\"none\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The rendered output of the enclosing template will not be affected by the 'name-to-remove' attribute of the template.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"top\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The rendered output of the enclosing template should not contain the first opening tag whose name is equal to the value of 'name-to-remove' attribute of the template.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"bottom\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"The rendered output of the enclosing template should not contain the last closing tag whose name is equal to the value of 'name-to-remove' attribute of the template.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"both\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"The rendered output of the enclosing template should not contain the both the first opening tag and the last closing tag whose name is equal to the value of 'name-to-remove' attribute of the template.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:element name=\"form\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <target-udt>update_form</target-udt>\n"
"        <refpurpose>Generic scriptable container for elements that may accept user's input.</refpurpose>\n"
"        <tutorial id=\"VX-S-2\">/tutorial/web/vx_s_2/form.vspx</tutorial>\n"
"        <tutorial id=\"VX-S-3\">/tutorial/web/vx_s_3/update_form.vspx</tutorial>\n"
"        <special-childs>\n"
"          <child name=\"key\"/>\n"
"          <child name=\"text\"/>\n"
"        </special-childs>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>\n"
"    This is a grouping element for controls that handle post data and validation of user's input. In case of type 'update', this is a single row update control for a database table.\n"
"This retrieves the data from the row identified by the keys and shows the data in the column bound fields enclosed.  If responding to a post for a submit inside this form, the form updates/inserts the data and shows the resulting state at the render pass.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType mixed=\"true\">\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:FormSpecificContent\"/>\n"
"        <xs:group ref=\"v:FormNonSpecificContent\"/>\n"
"        <xs:group ref=\"v:UserInputTarget\"/>\n"
"        <xs:group ref=\"v:AnyHtmlContent\"/>\n"
"        <xs:element ref=\"v:template\"/>\n"
"        <xs:element ref=\"v:form\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attribute name=\"type\" type=\"v:FormType\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Type of form, can be 'simple' or 'update'. When this is 'simple' the vspx_form class will be instantiated, otherwise in case of 'update' vspx_update_form subclass will be used.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"action\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"      A URL for processing. The data filled-in the form will be submitted to the 'action' page.\n"
"      Therefore this is a page where the content of that form will be processed.\n"
"      If it is empty, the target is a current page.\n"
"				 </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"method\" type=\"v:FormMethod\" use=\"optional\" default=\"POST\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A method  of transferring the form data, can be POST or GET. The same as 'method' of HTML forms.</xs:documentation>\n"
"          <xs:documentation>The use of 'GET' is not recommended because the length of the URI may easily exceed internal limits of the browser or an intermediate proxy server.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"table\" type=\"v:SqlTableQname\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>If the value of 'type' attribute is 'update', the form acts as a single row update control for a database table; and the value of 'table' attribute specifies the name of that table.\n"
"It retrieves the data from the row identified by the keys and shows the data in the column bound fields enclosed.  If responding to a post for a submit inside this form, the form updates/inserts the data and shows the resulting state at the render pass.\n"
"This attribute is required if 'type' is 'update' and prohibited otherwise.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"if-not-exists\" type=\"v:FormUpdateIfNotExists\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>If the keys do not select any row, and the value of this attribute is 'insert', the update form will be filled in with defaults filled in and will do an insert into the table when the form is submitted.\n"
"In this case of course the keys will have to be defaulted after the post or will have to be supplied in the post as fields.\n"
"Any defaulting should take place in the v:on-post handler which is before the insert or update in the event of the post.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"concurrency\" type=\"xs:boolean\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>If true and a previous value was shown in the form before the post being processed, this causes the system to check whether any of the data has been updated between getting it and the post at hand.\n"
"This is a sort of optimistic concurrency control at the row level.  If an update is detected, the updated_meanwhile message is set as the error message of the form and no update is made.  The render pass may choose to process this message as it will, the default is to show it as any other error message for form level validation failure.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"triggers\" type=\"v:OnOff\" use=\"optional\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>This is applicable for update form only, when this is OFF no PL triggers\n"
"	will be fired when inserting or updating.</xs:documentation>\n"
"    </xs:annotation>\n"
"  </xs:attribute>\n"
"      <xs:attribute name=\"data-source\" type=\"v:SqlName\" use=\"optional\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>This is applicable to the update form and is\n"
"	An alternative of 'table'. When is specified the value is suppsed to be\n"
"	valid reference to existing data-source control. Further the given data-source\n"
"	will be used to bind/update the data.\n"
"      </xs:documentation>\n"
"    </xs:annotation>\n"
"  </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:simpleType name=\"FormType\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>The enumeration of allowed types of forms.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:enumeration value=\"simple\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"Form with no special data binding.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"update\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"Form that may be used in templates of type 'update' or 'add'.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:simpleType name=\"FormMethod\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>POST or GET</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:enumeration value=\"GET\"/>\n"
"      <xs:enumeration value=\"POST\"/>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:simpleType name=\"VariableStorage\" final=\"restriction\">\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:enumeration value=\"session\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>keep the variable in the session; needs a login control to be present</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"pagestate\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>keep the variable in page view state</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"temp\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>do not keep variable</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"0\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>same as 'pagestate'</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"1\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>same as 'session'</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:simpleType name=\"FormUpdateIfNotExists\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>\n"
"        <!-- TBD -->\n"
"      </xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:enumeration value=\"insert\"/>\n"
"      <xs:enumeration value=\"nothing\"/>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:element name=\"tab\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>\n"
"A container that contains some number of pages and displays them one by one.\n"
"This can be used for multi-page forms or Windows style tabbed decks or making multi-part forms, alternative visualizations of the same data etc.\n"
"</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>Selects one of its children to be active at any one time.</refpurpose>\n"
"        <tutorial id=\"VX-S-5\">/tutorial/web/vx_s_5/tab.vspx</tutorial>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:AnyHtmlContent\"/>\n"
"        <xs:element ref=\"v:template\"/>\n"
"        <xs:element ref=\"v:select-list\"/>\n"
"        <xs:element ref=\"v:data-list\"/>\n"
"        <xs:element ref=\"v:radio-group\"/>\n"
"        <xs:element ref=\"v:hidden\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attribute name=\"initial-active\" type=\"v:SqlName\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"This is the name of the child template which is active at the time and\n"
"which thus will be rendered.  Whether inactive templates are\n"
"instantiated and keep state is controlled by is-input.  The active\n"
"attribute initializes the tb_active member of the vspx_tab instance.\n"
"This is preserved in the view state. Data bindable.\n"
"			    </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"style\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"This determines what HTML control is used to select which child is shown.\n"
"If unspecified, there will be no such control and the program logic is responsible for flipping the pages.  Otherwise  \"list\" means there is a HTML select control showing the titles  of the tabs.  \"radio\" means the titles of the tabs are shown as a radio group.  If there is a tab selector widget, it is always above the tabs.\n"
"			    </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"active\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>A data bound value to enable or disable the tab switch.\n"
"	    The default is '1' meaning 'enable'.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"is-input\" type=\"xs:boolean\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>If true, all the children are considered to be collectively a\n"
"	    multipart form and each will be instantiated when the page is made and\n"
"	    will get to retain a view state.  Although only one page of the form\n"
"	    is shown at a time, the state of all is kept. Not data bindable.\n"
"	    The default is '1' meaning 'template contains input'.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <!--\n"
";\n", 
"-->\n"
"  <xs:element name=\"script\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>A (redundant) wrapper for SQL code, can be omitted.</refpurpose>\n"
"        <no-render/>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>\n"
"This control can appear only inside event handling controls and it always contain SQL code to be executed when the event occurs.\n"
"There is no difference for VSPX compiler whether SQL code is enclosed in 'script' control or not.\n"
"Some WYSIWYG tools can display the enclosed SQL code to the application developer according to custom attributes of this control\n"
"but it does not affect the generated Virtuoso/PL code of the page.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType mixed=\"true\">\n"
"      <xs:sequence minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:any namespace=\"##any\"/>\n"
"      </xs:sequence>\n"
"      <xs:attribute name=\"language\" type=\"v:SqlName\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>Denotes the type of language,\n"
"	    currently only Virtuoso/PL expressions are supported.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"variable\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>\n"
"This element declares a data member for the page subclass corresponding to the containing page.\n"
"The value of this data member can be preserved between consecutive postbacks.\n"
"The attribute \"persist\" determine how to save the variable's value: to session table for inter-page usage, keep in page state only or do not keep it at all.\n"
"Note that inter-page variable storage is available only when a vspx:login control is included on the page and authentication is performed; also the name of page variables in corresponding pages needs to be same.\n"
"There is no special class for this control because only a data member will be added.\n"
"Also the page defines two special variables 'sid' and 'realm' for login control.\n"
"So when an existing login control is is in authenticated state, these will contain values for session id and application realm.\n"
"Also every non-repeating control of the page will be represented as a page variable and thus be acessible as 'self.&lt;name_of_control&gt;' anywhere in the VSPX page after page initialization.\n"
"</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>Page variable - a user defined member of page class.</refpurpose>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType mixed=\"true\">\n"
"      <xs:sequence minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:any namespace=\"##any\"/>\n"
"      </xs:sequence>\n"
"      <xs:attribute name=\"name\" type=\"v:SqlName\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The name of page class member.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"type\" type=\"v:SqlName\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The SQL data type of the variable.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"default\" type=\"v:SqlCode\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The default value. Must be a literal scalar value suitable for the default clause of a user defined type member.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"persist\" type=\"v:VariableStorage\" use=\"optional\" default=\"pagestate\"/>\n"
"      <xs:attribute name=\"param-name\" type=\"v:SqlName\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>This specifies an optional name of a URL parameter for setting the page variable value.\n"
"            When this is specified and there is a parameter matching the name, the variable is set after it.  This is a shorthand for an explicit call of keyword_get.\n"
"          </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:HtmlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"local-variable\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>\n"
"This tag declares a control that can store a temporary value that can be accessed from other controls.\n"
"Usually it is an intermediate value that is used by a group of controls of the same form. E.g. if\n"
"controls of a form display various data stored in a complex object then it may be convenient to obtain this object once and place it\n"
"into value of a local-variable control that is the first child control of a form. The rest of child controls may access the value\n"
"from the first child to calculate their values.\n"
"</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <target-udt>field_value</target-udt>\n"
"        <refpurpose>Local variable - an invisible control to store a temporary value.</refpurpose>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:group ref=\"v:EventTarget\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:FieldValue\"/>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"method\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>Page method - a user defined member of page class.</refpurpose>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>This creates a custom method of the page class.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:complexContent>\n"
"        <xs:extension base=\"v:EventHandler\">\n"
"          <xs:attribute name=\"name\" type=\"v:SqlName\" use=\"required\">\n"
"	    <xs:annotation>\n"
"	      <xs:documentation>The name of method to be created</xs:documentation>\n"
"	    </xs:annotation>\n"
"	  </xs:attribute>\n"
"          <xs:attribute name=\"returns\" type=\"v:SqlName\" use=\"optional\">\n"
"	    <xs:annotation>\n"
"	      <xs:documentation>Optional return datatype type</xs:documentation>\n"
"	    </xs:annotation>\n"
"	  </xs:attribute>\n"
"          <xs:attribute name=\"arglist\" type=\"xs:string\" use=\"optional\">\n"
"	    <xs:annotation>\n"
"	      <xs:documentation>comma-separated list of arguments. For example : \"in arg1 varchar, out arg1 integer ...\"</xs:documentation>\n"
"	    </xs:annotation>\n"
"	  </xs:attribute>\n"
"        </xs:extension>\n"
"      </xs:complexContent>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"validator\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <target-udt>range_validator</target-udt>\n"
"        <refpurpose>A validator that is applied to user input.</refpurpose>\n"
"        <tutorial id=\"VX-S-2\">/tutorial/web/vx_s_2/date.vspx</tutorial>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>\n"
"The validator objects are invoked when the element's control gets posted. the validator elements only make sense inside field or form types of controls.  the validators are invoked in the order given, and the first one to fail stops the invocation chain, so that no later ones are attempted.\n"
"furthermore the vc_is_valid member of the containing page class instance will be reset to false (0) to stop further processing. see also error-summary element and error-glyph attribute of field element.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attribute name=\"test\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The type of test to be performed, can be 'length', 'value',  'regexp' or 'sql'.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"        <xs:simpleType>\n"
"          <xs:restriction base=\"xs:string\">\n"
"            <xs:enumeration value=\"length\"/>\n"
"            <xs:enumeration value=\"value\"/>\n"
"            <xs:enumeration value=\"regexp\"/>\n"
"            <xs:enumeration value=\"sql\"/>\n"
"          </xs:restriction>\n"
"        </xs:simpleType>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"min\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A lower limit in value and length tests\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"max\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The upper limit for value and length tests\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"regexp\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The REGEXP pattern to match field value\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"expression\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A SQL expression for validation\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"empty-allowed\" type=\"xs:boolean\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>If specified as true (1) this will allow submitting an empty field\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"message\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The error message to be associated to parent control when the test represented by this validator fails.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"runat\" type=\"v:ValidatorType\" use=\"optional\" default=\"server\">\n"
"        <xs:annotation>\n"
"          <xs:documentation><para>Where to perform validation, at server side after posting, or at browser side when entering the values. Note that client side validators can be assigned only to input controls, hence client side form validators for inter-field integrity testing are not allowed.</para>\n"
"	  <para>Client side validators will generate client side JavaScript.</para>\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:simpleType name=\"ValidatorType\" final=\"restriction\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>server or client</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:enumeration value=\"server\"/>\n"
"      <xs:enumeration value=\"client\"/>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:group name=\"UserInputTarget\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>Something that may be edited by a user.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:choice>\n"
"      <xs:element ref=\"v:validator\"/>\n"
"    </xs:choice>\n"
"  </xs:group>\n"
"  <xs:element name=\"field\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>Name of input to be sent to and back between pup-up and parent window.</refpurpose>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>\n"
" This element may occur under browse-button or select button,\n"
" it enumerates the names of inputs to be sent between pop-up and parent window.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attribute name=\"ref\" type=\"v:SqlName\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>When a field is used as child of and return button\n"
"	    then this must contain valid reference to name of a input control\n"
"	    (like text, select-list, data-list etc.) from current page. The referenced\n"
"	    control's value will be used to set the value of control with name specified in\n"
"	    attribute 'name' in the target page. The data will be set using automatically generated\n"
"	    JavaScript function.\n"
"	  </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"button\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <target-udt>delete_button</target-udt>\n"
"        <target-udt>logout_button</target-udt>\n"
"        <target-udt>browse_button</target-udt>\n"
"        <target-udt>return_button</target-udt>\n"
"        <target-udt>submit</target-udt>\n"
"        <refpurpose>Scriptable button.</refpurpose>\n"
"        <tutorial id=\"VX-S-2\">/tutorial/web/vx_s_2/form.vspx</tutorial>\n"
"        <tutorial id=\"VX-S-7\">/tutorial/web/vx_s_7/products.vspx</tutorial>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>Scriptable version of Submit Button of the HTML form. Depending of\n"
"'action' attribute it may have variants. In some of these variants the button will not have a submit function, as in select and browse buttons.  In these cases the button will use client JavaScript to pop up new windows or for setting values in other windows.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:element ref=\"v:field\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:SqlColumn\"/>\n"
"      <xs:attribute name=\"action\" type=\"v:ButtonAction\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This specifies the button subclass to use.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"value\" type=\"v:CalculateableValue\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Text of the label of the button.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"style\" type=\"v:ButtonStyle\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A style of button, affects appearance.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"active\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A data bound value to enable or disable the button. The default is '1' meaning 'enable'.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"initial-active\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A data bound value to enable or disable the button. The default is '1' meaning 'enable'.\n"
"Unlike 'active' attribute, this one is effective only when the page is displayed in the first time, not after user posts data back to the page.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:BrowseButtonParams\"/>\n"
"      <xs:attribute name=\"format\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A sprintf format string for printing the value</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"radio-button\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>is a scriptable version of HTML radio button.</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>Scriptable radio button.</refpurpose>\n"
"        <tutorial id=\"VX-S-2\">/tutorial/web/vx_s_2/radio.vspx</tutorial>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:UserInputTarget\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:SqlColumn\"/>\n"
"      <xs:attributeGroup ref=\"v:UserInputAttributes\"/>\n"
"      <xs:attribute name=\"group-name\" type=\"xs:NCName\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>When several  check boxes are to be grouped, this is the  name of the group. Upon  post the name of the group will be submitted  instead of the  than name of the control. This also will restrict in the group to have more than one button on</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:FieldValue\"/>\n"
"      <xs:attribute name=\"initial-checked\" type=\"xs:integer\" use=\"optional\" default=\"0\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This flag specifies whther this control is initially checked.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"check-box\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>is a represantation of HTML check box. Scriptable, databindable.</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>Scriptable check-box.</refpurpose>\n"
"        <tutorial id=\"VX-S-2\">/tutorial/web/vx_s_2/check_box.vspx</tutorial>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:UserInputTarget\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:SqlColumn\"/>\n"
"      <xs:attributeGroup ref=\"v:UserInputAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:FieldValue\"/>\n"
"      <xs:attribute name=\"group-name\" type=\"v:SqlName\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"When several check boxes are grouped, this is the group name.\n"
"This will be submitted instead of the control name on post.\n"
"			     </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"initial-checked\" type=\"v:CalculateableValue\" use=\"optional\" default=\"0\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Specifies whether the control is initially checked.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"is-boolean\" type=\"xs:boolean\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>If this attribute is set to '1' then the check-box is forced to ignore its 'initial-checked' status and work using the data-bound value as the only criterion for enabling or disabling its 'checked' property. This mode is convenient for editing two-state data values. Before render, the control will check if the ufl_value is equal to 'true-value' or 'false-value', and it is displayed as checked if the ufl_value is equal to 'true-value' (or it is not equal to any of these two but is not a logical 'false'). On post, a new status of the checkbox is inspected, and the ufl_value is set to 'true-value' if it is checked or 'false-value' otherwise.\n"
"The default value of this attribute is '0' meaning that there is no system-level relation between the 'checked' status and the 'value'.\n"
"When the form with the check-box submits data, the submitted value of the attribute depends on its 'is-boolean' property. If it's '0' then the result of cast (control.ufl_value as varchar) is submitted; otherwise a string '1' is submitted.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"true-value\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This attribute should be used if and only if 'is-boolean' attribute is set to '1'.\n"
"The calculated value of this attribute is saved in ufl_true_value field of the control and is used to represent a logical 'true' for the control. The checkbox is displayed as checked if the bound value is equal to the ufl_true_value. If the checked checkbox is submitted then the bound value of the control is set to the ufl_true_value.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"false-value\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This attribute should be used if and only if 'is-boolean' attribute is set to '1'.\n"
"The calculated value of this attribute is saved in ufl_false_value field of the control and is used to represent a logical 'false' for the control. The checkbox is displayed as not checked if the bound value is equal to the ufl_valuse_value. If no checked checkbox is submitted by a form then the bound value of the control is set to ufl_false_value.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <!--\n"
";\n", 
"-->\n"
"  <xs:element name=\"text\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>Scriptable, data-bindable input control.</refpurpose>\n"
"        <special-childs>\n"
"          <child name=\"validator\"/>\n"
"        </special-childs>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>Text input, with scripts and validation options but no implied database binding. String input of the HTML form.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType mixed=\"false\">\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:UserInputTarget\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:SqlColumn\"/>\n"
"      <xs:attributeGroup ref=\"v:UserInputAttributes\"/>\n"
"      <xs:attribute name=\"type\" type=\"v:TextInputType\" use=\"optional\" default=\"plain\"/>\n"
"      <xs:attribute name=\"default\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The default value of input field.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:FieldValue\"/>\n"
"      <xs:attribute name=\"default-value\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>This is an expression for setting the default value of the text.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"default_value\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This is deprecated alias for 'default-value' attribute (note the difference between minus sign and underscore).</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"format\" type=\"v:CalculateableValue\" use=\"optional\"/>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"textarea\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>Scriptable text-area input.</refpurpose>\n"
"        <tutorial id=\"VX-S-2\">/tutorial/web/vx_s_2/textarea.vspx</tutorial>\n"
"        <special-childs>\n"
"          <child name=\"validator\"/>\n"
"        </special-childs>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>Scriptable, databindable   HTML text area.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:UserInputTarget\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:SqlColumn\"/>\n"
"      <xs:attributeGroup ref=\"v:UserInputAttributes\"/>\n"
"      <xs:attribute name=\"type\" type=\"v:TextInputType\" use=\"optional\" default=\"plain\"/>\n"
"      <xs:attribute name=\"default_value\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The default value of the field. Can be accessed via control.ufl_value n data bind stage.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"default\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Deprecated alias of 'default_value'.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:FieldValue\"/>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:simpleType name=\"TextInputType\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>The way of displaying the value to the user.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:enumeration value=\"plain\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The value is displayed in a usual way and user can edit it. This is the default value.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"password\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The value is not shown on the screen to prevent occasional reading, only astericks are shown in the input field.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"hidden\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The text is passed to the target page without displaying it to the user.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:element name=\"item\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>\n"
"Item representing a selection inside a select list.\n"
"</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>Item representing a selection inside a select list.</refpurpose>\n"
"        <no-render/>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:attribute name=\"name\" type=\"v:SqlCode\" use=\"required\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>The visible value of the option, it will be shown\n"
"	    in the option list.\n"
"	  </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"value\" type=\"xs:string\" use=\"required\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>The key value of the option, it will be assigned\n"
"	    to the select control ufl_value is given option is seelcted.\n"
"	  </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:HtmlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"select-list\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>This is a scriptable version of HTML select control.\n"
"It shows a static list of items (see item element). Databind and on-post scripts are allowed.\n"
"</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>Fixed initialized select list.</refpurpose>\n"
"        <tutorial id=\"VX-S-2\">/tutorial/web/vx_s_2/select.vspx</tutorial>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:UserInputTarget\"/>\n"
"        <xs:element ref=\"v:item\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:SqlColumn\"/>\n"
"      <xs:attributeGroup ref=\"v:UserInputAttributes\"/>\n"
"      <xs:attribute name=\"multiple\" type=\"xs:boolean\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>Used to designate a multiple selection list box.\n"
"	    In this case the control's value will be an array of key data of selected items.\n"
"	  </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:FieldValue\"/>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"key\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>A key value of the vspx:form of type 'update'.</refpurpose>\n"
"        <no-render/>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>This control defines a key value of the vspx:form of type 'update'.\n"
"All the vspx:key children together should select one or zero rows from the table.\n"
"Controls inside the form will process fields of this selected row.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:attribute name=\"name\" type=\"v:SqlName\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Not used</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"column\" type=\"v:SqlName\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Name of the column in the table to be updated.\n"
"This may be either the name of a primary key column or an other column, as long as the selection specified by all vspx:key children of the vspx:form is unambiguous.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"value\" type=\"v:CalculateableValue\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The value of the key field referred to  by the 'column' attribute.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"default\" type=\"v:CalculateableValue\" use=\"optional\" default=\"null\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>The default value to be used when the 'value' expression returns NULL.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:HtmlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:group name=\"FormSpecificContent\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>Elements that may appear only inside a form.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:choice>\n"
"      <xs:element ref=\"v:button\"/>\n"
"      <xs:element ref=\"v:radio-group\"/>\n"
"      <xs:element ref=\"v:radio-button\"/>\n"
"      <xs:element ref=\"v:check-box\"/>\n"
"      <xs:element ref=\"v:select-list\"/>\n"
"      <xs:element ref=\"v:data-list\"/>\n"
"      <xs:element ref=\"v:textarea\"/>\n"
"      <xs:element ref=\"v:text\"/>\n"
"      <xs:element ref=\"v:key\"/>\n"
"      <xs:element ref=\"v:error-summary\"/>\n"
"      <xs:element ref=\"v:calendar\"/>\n"
"    </xs:choice>\n"
"  </xs:group>\n"
"  <xs:element name=\"label\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>Generic scriptable text.</refpurpose>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>This is for displaying a value as plain text.\n"
"The underlying class is derived from VSPX_FIELD so the value to be displayed is accessible as a value of any VSPX field.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:SqlColumn\"/>\n"
"      <xs:attributeGroup ref=\"v:FieldValue\"/>\n"
"      <xs:attribute name=\"format\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A sprintf format string for printing the value</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"url\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>Generic scriptable hypertext link.</refpurpose>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>Dynamic data bindable hypertext link.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:SqlColumn\"/>\n"
"      <xs:attributeGroup ref=\"v:FieldValue\"/>\n"
"      <xs:attribute name=\"format\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A sprintf format string for printing the value</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"url\" type=\"v:CalculateableValue\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A data bound value to be printed in place of href attribute.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"active\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A data bound value to enable or disable the url. The default is '1' meaning 'enable'.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <!--\n"
";\n", 
"-->\n"
"  <xs:element name=\"data-list\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>Select list initialized from database table.</refpurpose>\n"
"        <tutorial id=\"VX-S-3\">/tutorial/web/vx_s_3/selectdb.vspx</tutorial>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>This control is used to make a select list, based on a SQL expression.\n"
"      Also instead of SQL expression only table name could be given, so then control will compose apropriate select statement.\n"
"      </xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:UserInputTarget\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:UserInputAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:SqlColumn\"/>\n"
"      <xs:attributeGroup ref=\"v:FieldValue\"/>\n"
"      <xs:attribute name=\"table\" type=\"v:SqlTableQname\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A table name for select statement.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"key-column\" type=\"v:SqlName\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A key column name.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"value-column\" type=\"v:SqlName\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A value column name.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"sql\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>An alterantive of 'table' attribute, when this attribute\n"
"	    is specified it must contains a valid select statement. The selection list\n"
"	    will be instantiated using a cursor as this expression is defined.\n"
"	  </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"defvalue\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A default value for the control.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"multiple\" type=\"xs:boolean\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>Used to desigante a multiple selection list box.\n"
"	    In this case the control's value will be an array of key data of selected items.\n"
"	  </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"list-document\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This is to obtain all or some of items of the select-list from an XML document. If this attribute is specified then the value of the calculated attribute should be an XML entity and this entity will be saved in vsl_list_document field of the control; values of 'list-match', 'list-key-path' and 'list-value-path' arguments should specify XQuery expressions that should be used to retrieve keys and displayable values of items.\n"
"All selection items composed from the value of 'list-document' will be listed before all items from 'table' or 'sql', if both methods of data retrieval are used.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"list-match\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This is to calculate a string value that is an XQuery expression. The text of this expression will be saved in 'vsl_list_match' member of the control. This expression will be used during data binding to get array of displayable items from the value of 'list-document'. The expression should return a node-set using 'list-document' entity as a context mode; every item of the node-set will be converted into list item via 'list-key-path' and 'list-value-path' expressions.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"list-key-path\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This is to specify the XQuery expression that calculates key value of a list item, using a result of 'list-match' as a context node. The text of the expression will be saved in 'vsl_list_key_path' member of the control.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"list-value-path\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This is to specify the XQuery expression that calculates a displayable value of a list item, using a result of 'list-match' as a context node. The text of the expression will be saved in 'vsl_list_value_path' member of the control.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"node\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>This control indicates the place of a subtree inside a node template.</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>A place holder for rendering a tree node.</refpurpose>\n"
"        <no-render/>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:attribute name=\"void\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>Not used.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"tree\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>A container for displaying a tree of nested nodes.</refpurpose>\n"
"        <tutorial id=\"VX-S-4\">/tutorial/web/vx_s_4/tree.vspx</tutorial>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>\n"
"    <para>This can be used for hierarchical tables of contents,\n"
"    directory browsing, hierarchical menus and such.\n"
"    The tree can have either one or more branches open at any time, up to\n"
"    the leaves.  The tree has a root, which may or may not be visible.\n"
"    The contents of the tree can either be fixed, in which case these are an\n"
"    XML tree, or dynamic, in which case these are generated level by level\n"
"    by SQL functions attached to the tree. The tree can have various external appearences.</para>\n"
"\n"
"    <para>The tree is represented at run time by a vspx_tree instance.\n"
"    Nodes of the tree are represented by vspx_tree_node objects,\n"
"    which are childs of the vspx_tree.  The nodes hold an identifier (vc_instance_name)\n"
"    of the corresponding tree branch, which is used to retrieve children of the node.\n"
"    These also hold a flag (tn_open member) indicating if the node is open or not.</para>\n"
"			</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:element ref=\"v:template\"/>\n"
"        <xs:element ref=\"v:node-template\"/>\n"
"        <xs:element ref=\"v:leaf-template\"/>\n"
"        <xs:element ref=\"v:horizontal-template\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attribute name=\"show-root\" type=\"xs:boolean\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This attribute is obsolete and has no effect.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"multi-branch\" type=\"xs:boolean\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"This determines whether more than one branches can be open at one time.\n"
"The values are 0 and 1 (true and false).  The default is 0 (false).\n"
"			   </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"orientation\" type=\"v:TreeOrientation\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"      This can be 'horizontal' or 'vertical', the default is 'vertical'.\n"
"      The tree can have different styles.  The default is a vertical arrangement\n"
"      with open levels indented, the children under the parent node.\n"
"      Each node template is a single line.  The horizontal style shows each level on a separate line.\n"
"      In this case it is not allowed multiple open branches.  The children of the root will be\n"
"      shown on one line.  When one is opened, its children will fill the next line.\n"
"			   </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"root\" type=\"v:SqlName\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation><para>\n"
"This is a SQL expression which produces the root object.\n"
"This can be of any data type, a file system path is an example.\n"
"</para>\n"
"<programlisting>\n"
"<![CDATA[\n"
"create procedure root_node (in path varchar)\n"
"{\n"
"  declare i, l int;\n"
"  declare ret, arr any;\n"
"  arr :=\n"
"    vector_concat (sys_dirlist (path, 0), sys_dirlist (path, 1));\n"
"\n"
"  return arr;\n"
"};\n"
"]]></programlisting>\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"child-function\" type=\"v:SqlName\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"<para>Given the result of the root expression, this must generate an array\n"
"of similar elements corresponing to the children of the node in\n"
"question.  This same function should be applicable to each element of\n"
"the array it returns.  If the array is empty then the node in question\n"
"is a leaf.</para>\n"
"<programlisting>\n"
"<![CDATA[\n"
"\n"
"-- Example of this function\n"
"\n"
"create procedure child_node (in node_name varchar, in node varchar)\n"
"{\n"
"  declare i, l int;\n"
"  declare ret, arr any;\n"
"  declare exit handler for sqlstate '*'\n"
"    {\n"
"      return vector ();\n"
"    };\n"
"  if (isstring (file_stat (node_name, 3)))\n"
"    return vector ();\n"
"\n"
"  arr :=\n"
"    vector_concat (sys_dirlist (node_name, 0), sys_dirlist (node_name, 1));\n"
"\n"
"  return arr;\n"
"}\n"
";\n", 
"]]></programlisting>\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"start-path\" type=\"v:CalculateableValue\" use=\"required\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>This is an expression which will be evaluated and passed to the 'root' function as argument.\n"
"                    </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"open-at\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>This is an expression which will be used as XPath\n"
"	    expression to designate which branches of the tree are open\n"
"	    and which are not initially.\n"
"                    </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"error-summary\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>Placeholder for form error messages.\n"
"This is used on a form  to mark where error messages resulting from field or form validation are to be placed.\n"
"This   will be rendered if the vc_is_valid member of the enclosing page is false.\n"
"If rendered, this prints an error message generated by a validator or a catch handler.\n"
"This control wiil not be instantiated.  The error-summary may show errors for all controls or for a group of controls whose name matches a given regular expression.\n"
"The vc_error_message members of all controls whose validation failed will be shown at the place marked by this control if attribute 'match' is not specified. Otherwise the vc_error_message of controls whose validation failed and 'name' matches the pattern specified will be shown.\n"
"</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>Placeholder for error messages.</refpurpose>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:attribute name=\"match\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"This attribute specifies a regular expression to be matched against names of controls with failed validation.\n"
"The expression may match more than one control name, concatenating the messages in document order of controls. In this way an error summary may appear in\n"
"different places of the page to print errors for different controls.\n"
"			   </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:group name=\"FormNonSpecificContent\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>Elements that may appear both inside and outside a form.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:choice>\n"
"      <xs:element ref=\"v:variable\"/>\n"
"      <xs:element ref=\"v:local-variable\"/>\n"
"      <xs:element ref=\"v:method\"/>\n"
"      <xs:element ref=\"v:label\"/>\n"
"      <xs:element ref=\"v:url\"/>\n"
"      <xs:element ref=\"v:data-grid\"/>\n"
"      <xs:element ref=\"v:data-set\"/>\n"
"      <xs:element ref=\"v:data-source\"/>\n"
"      <xs:element ref=\"v:tab\"/>\n"
"      <xs:element ref=\"v:tree\"/>\n"
"      <xs:element ref=\"v:include\"/>\n"
"      <xs:element ref=\"v:isql\"/>\n"
"      <xs:element ref=\"v:login\"/>\n"
"      <xs:element ref=\"v:vscx\"/>\n"
"      <xs:element ref=\"v:local-variable\"/>\n"
"    </xs:choice>\n"
"  </xs:group>\n"
"  <!--\n"
";\n", 
"-->\n"
"  <xs:element name=\"login-form\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>\n"
"login-form is the control for getting login information.  This may only appear inside a login.\n"
"Its function will depend on the type of login being attempted.  If the type is digest, this is a button which, when submitted, will send the digest challenge.\n"
"			</xs:documentation>\n"
"      <xs:documentation>\n"
"If the url or cookie session mode is chosen, this will be a form of 2 fields with user name and password and a submit button.\n"
"			</xs:documentation>\n"
"      <xs:documentation>\n"
"if the standard form is not suitable, this can be an arbitrary form.  This must post  buttons values named \"username\" and \"password\" and a submit button named \"login\".  No children need be specified if the default form is OK.\n"
"			</xs:documentation>\n"
"      <xs:documentation>\n"
"If the redirect attribute of template[@type=if-no-login] is not specified,\n"
"the contents of this child are instantiated and shown in the place of the login control.\n"
"This can be arbitrary content.\n"
"			</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>A form to be shown if the user is not logged in.</refpurpose>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType mixed=\"true\">\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:AnyVspxPageContent\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attribute name=\"required\" type=\"xs:boolean\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"If digest is the mode, then this means that the login is mandatory and that instead of displaying the login button which will send the challenge if pressed, the challenge will be sent automatically.\n"
"			   </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"title\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Title of login button if digest is attempted.\n"
"			   </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"user-title\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Title of user name field\n"
"			   </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"password-title\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Title of password field\n"
"			   </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"submit-title\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Title of submit button\n"
"			   </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"login\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>Authentication parameters of a page.</refpurpose>\n"
"        <tutorial id=\"VX-S-6\">/tutorial/web/vx_s_6/login.vspx</tutorial>\n"
"        <special-childs>\n"
"          <child name=\"button\"/>\n"
"        </special-childs>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>\n"
"<para>The login control controls authentication for its page.\n"
"Depending on options this  may or may not be visible.\n"
"This works together with a login-form and logout-button controls.  The storage of passwords and user names is left to the application, which can specify functions called by these widgets.\n"
"The server keeps login information in the following table:</para>\n"
"<programlisting>\n"
"<![CDATA[\n"
"create table VSPX_SESSION (VS_REALM varchar, VS_SID varchar, VS_UID varchar, VS_STATE long varchar,\n"
"  primary key (VS_REALM, VS_SID));\n"
"]]>\n"
"</programlisting>\n"
"<para> This table is shared between all vspx applications, each with their login differentiated by realm.\n"
"The state is an array of name value pairs which will be accessed through connection_get and connection_set inside the page code.</para>\n"
"<para>\n"
"There are three methods of keeping session state:URL-poisoning, digest authentication and Cookies.The URL-poisoning scheme presents a login dialog form and sets a session ID as hidden form element.\n"
"Digest authentication  uses an opaque value as session id and is available only for browsers that support standard HTTP 1.1 digest authentication. The Cookie is an analogue of URL poisoning, but in that case session ID is kept as a Cookie, thus cookies must be enabled on the browser.\n"
"</para>\n"
"\n"
"<para>\n"
"The login control is mandatory when using a persistent page variables (see persist=\"session\" attribute of 'variable' control). This is because HTTP protocol is state-less; therefore value of such variables have to be stored in a table and restored on next hit with same session ID (and realm). Hence as login control maintains a session state (via some mechanism, see notes above), this capability is used to maintain persistent page variables.\n"
"Note also that persistent page variables can be used between different pages, in that case all of those pages need to have login control (in most cases it is invisible).\n"
"</para>\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:FormNonSpecificContent\"/>\n"
"        <xs:group ref=\"v:FormSpecificContent\"/>\n"
"        <xs:element ref=\"v:template\"/>\n"
"        <xs:element ref=\"v:login-form\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attribute name=\"realm\" type=\"xs:string\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This is the authentication realm name.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"mode\" type=\"v:LoginMode\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>This specifies the preferred mode of keeping session and login information.\n"
"In the case of url and cookie the name and password will have to be supplied in a form submit.  The vspx:login-form control provides a convenient way of doing this.  If passwords are transmitted in a form submit, it is best for security to have the login page accessed via SSL only. Many values may be separated by spaces.  This is the order of preference.  The system will use the first available depending on the user agent.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"user-password\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"<para>The name of a SQL function which will retrieve the password given a user name.  If digest authentication is to be possible, this function must be specified. Example:\n"
"</para>\n"
"<programlisting><![CDATA[\n"
"create procedure\n"
"sql_user_password (in name varchar)\n"
"{\n"
"  declare pass varchar;\n"
"  pass := NULL;\n"
"  whenever not found goto none;\n"
"  select pwd_magic_calc (U_NAME, U_PASSWORD, 1) into pass\n"
"          from SYS_USERS where U_NAME = name and U_SQL_ENABLE = 1 and U_IS_ROLE = 0;\n"
"none:\n"
"  return pass;\n"
"}\n"
";]]></programlisting>\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"user-password-check\" type=\"xs:string\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>\n"
"<para>This is a function which takes the user name and password (unencrypted) and returns true if these match, false otherwise.</para>\n"
"\n"
"<para>\n"
"If the application will keep a session state  which will automatically be extracted from the application's user repository upon login, then either of these functions may set this using connection_set.  This will persist in the session if the login is successful and will be discarded otherwise.  An example of such information is a user privilege class, real name, email or such.\n"
"These functions may be called one or more times during the session, but no more than one call at the start is guaranteed.</para>\n"
"<para>Example:</para>\n"
"<programlisting><![CDATA[\n"
"\n"
"create procedure\n"
"sql_user_password_check (in name varchar, in pass varchar)\n"
"{\n"
"  if (exists (select 1 from SYS_USERS where U_NAME = name and U_SQL_ENABLE = 1 and U_IS_ROLE = 0 and\n"
"        pwd_magic_calc (U_NAME, U_PASSWORD, 1) = pass))\n"
"    return 1;\n"
"  return 0;\n"
"}\n"
";]]></programlisting>\n"
"<para>Note: when the mode is digest the login control will only call user_password and in other modes  it will only call user_password_check.</para>\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:group name=\"AnyVspxPageContent\">\n"
"    <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"      <xs:group ref=\"v:FormSpecificContent\"/>\n"
"      <xs:group ref=\"v:FormNonSpecificContent\"/>\n"
"      <xs:group ref=\"v:AnyHtmlContent\"/>\n"
"      <xs:element ref=\"v:node\"/>\n"
"      <xs:element ref=\"v:form\"/>\n"
"      <xs:element ref=\"v:template\"/>\n"
"      <xs:element ref=\"v:hidden\"/>\n"
"      <xs:element ref=\"v:login\"/>\n"
"      <xs:element ref=\"v:login-form\"/>\n"
"      <xs:element ref=\"v:code-file\"/>\n"
"    </xs:choice>\n"
"  </xs:group>\n"
"  <xs:element name=\"column\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>A column marker.</refpurpose>\n"
"        <no-render/>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>\n"
"A column marker for use in v:data-set, v:data-grid and v:data-source.\n"
"This element should exist for each selected column of the SQL expression of the data set.\n"
"If this is specified under data-set, data-source or data-grid controls, this must be the exact same columns as in SQL statement to be evaluated. If those element is omitted in data-set or data-grid, the columns will be extracted from compilation of the SQL statement.\n"
"However, this  will always be required for calls of stored procedures that return resultsets and for the data-source control.\n"
"</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:attribute name=\"name\" type=\"v:SqlName\" use=\"required\">\n"
"	<xs:annotation>\n"
"	  <xs:documentation>The name of column\n"
"	  </xs:documentation>\n"
"	</xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"label\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"	<xs:annotation>\n"
"	  <xs:documentation>Alternate text which could be used to display in column headings.\n"
"	  </xs:documentation>\n"
"	</xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"input-format\" type=\"xs:string\" use=\"optional\">\n"
"	<xs:annotation>\n"
"	  <xs:documentation>A sprintf format string for printing the input value\n"
"	  </xs:documentation>\n"
"	</xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"output-format\" type=\"xs:string\" use=\"optional\">\n"
"	<xs:annotation>\n"
"	  <xs:documentation>A sprintf format string for printing the output value\n"
"	  </xs:documentation>\n"
"	</xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:HtmlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"data-set\">\n"
"    <xs:annotation>\n"
"      <xs:documentation><para>A container for displaying and/or editing the content of a resultset.\n"
"This is the generic multi-row database view control. It is used to show repeating data, as from tables\n"
"or procedure views. Allows scrolling (paging) editing the data; adding a row or removal of existing rows.\n"
"Usually this control generates a PL scrollable cursor of type. The number of rows shown is\n"
"configurable via nrows attribute. Note also that column children elements are optional; they can be omitted\n"
"so then VSPX engine will compute them from the specified SQL statement in 'sql' attribute.</para>\n"
"\n"
"<para>This control has the same functionality as the data-grid control but has different syntax, better suited for editing via plugins for 3-d party WYSWYG HTML authoring tools (as Addobe GoLive and similar).</para>\n"
"\n"
"<para>Specific to this control is to have several templates to present repeating and non-repeating groups of children elements. These templates are as follows: two generic templates to represent header and footer sections and one repeating template to enclose edit, add, not-exists and row (browse) sections. All of those templates are optional and their usage can be seen in examples.</para>\n"
"\n"
"<para>Also following the convention for names of controls must be followed: for scrolling buttons - [data-set name]'_prev', [data-set name]'_next', [data-set name]'_first' and [data-set name]'_last'; for editing buttons - [data-set name]'_edit' and [data-set name]'_delete'.</para>\n"
"      </xs:documentation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>Scrollable, multi-row data bound grid.</refpurpose>\n"
"        <tutorial id=\"VX-S-3\">/tutorial/web/vx_s_3/data_set.vspx</tutorial>\n"
"        <special-childs>\n"
"          <child name=\"\"/>\n"
"        </special-childs>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType mixed=\"true\">\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:AnyVspxPageContent\"/>\n"
"        <xs:element ref=\"v:column\"/>\n"
"        <xs:element ref=\"v:param\"/>\n"
"        <xs:element ref=\"v:key\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attribute name=\"sql\" type=\"v:SqlCode\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The select statement that gets the data.\n"
"Parameters to the statement MUST be specified as SQL identifiers prefixed with a colon.\n"
"The values are given in the control's vspx:param children.  These specify the parameter name and a data bound expression for the value.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"data-source\" type=\"v:SqlName\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>A reference to a data-source, which wil lbe used to bind the data in data-set grid.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"data\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation><para>When this attribute is specified it must be an\n"
"expression returning array of arrays. This is an alternative to specifying an\n"
"SQL expression or data-source. The result then will be used to instantiate\n"
"the repeating group. An example of such data is the result returned by 'exec' function:</para>\n"
"<programlisting>\n"
"(\n"
"  (\"ALFKI\" \"Alfreds Futterkiste\" \"030-0074321\" )\n"
"  (\"ANATR\" \"Ana Trujillo Emparedados y helados\" \"(5) 555-4729\" )\n"
")\n"
"</programlisting>\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"meta\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation><para>This attribute is used together with 'data', so when is\n"
"specified it needs to be an expression returning a meta-data for columns corresponding to the\n"
"these returned by 'data' expression. In practice it's same as 1-st element of metadata returned by 'exec()' :\n"
"</para>\n"
"\n"
"<programlisting>\n"
"(\n"
"  (\"CustomerID\" 182 0 5 0 1 1 \"Demo\" \"CustomerID\" \"demo\" \"Customers\" 0 )\n"
"  (\"CompanyName\" 182 0 40 1 1 1 \"Demo\" \"CompanyName\" \"demo\" \"Customers\" 0 )\n"
"  (\"Phone\" 182 0 24 1 1 1 \"Demo\" \"Phone\" \"demo\" \"Customers\" 0 )\n"
")\n"
"</programlisting>\n"
"\n"
"<para>for details of metadata see 'exec()' function description.</para>\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"nrows\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The maximum number of replicas of the row template to be made for rows selected.\n"
"It is like the rowset size for a scrollable cursor.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"scrollable\" type=\"xs:boolean\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The setting controls whether next and previous page buttons are presented.  This can be on even if the cursor is not scrollable as such.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"cursor-type\" type=\"v:PlCursorType\" use=\"optional\" default=\"dynamic\"/>\n"
"      <xs:attribute name=\"edit\" type=\"xs:boolean\" use=\"optional\" default=\"false\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Flags whether editing features are enabled on data grid control</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <!--\n"
";\n", 
"-->\n"
"  <xs:element name=\"param\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>Named parameter for the cursor.</refpurpose>\n"
"        <no-render/>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>Named parameter for execution of the cursor select statement. This must be the name of a parameter for SQL statement specified, but without leading colon.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:attribute name=\"name\" type=\"v:SqlName\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Name of the parameter.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"value\" type=\"v:CalculateableValue\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Data bound value of the parameter.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:HtmlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"data-grid\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>\n"
"<para>This is the generic multi-row database view control. It is used to show repeating data, as from tables\n"
"or procedure views. Allows scrolling (paging) editing the data; adding a row or removal of existing rows.\n"
"Usually this control generates a PL scrollable cursor of type as specified. The number of rows shown are\n"
"configurable via nrows attribute. Note also that column children elements are optional; they can be omitted\n"
"so then VSPX engine will compute them from specified SQL statement in 'sql' attribute.</para>\n"
"<para>Specific to this control is to have row-template and frame-template, these are to present repeating and non-repeating groups of children elements. The frame-template will usually\n"
"have a 'rowset' placeholder to designate the place where repeating group (row-template) will be instantiated. The control expects to find child controls with specific names. for scrolling buttons - [data-grid name]'_prev' and [data-grid name]'_next'; for editing buttons - [data-grid name]'_edit' and [data-grid name]'_delete'.</para>\n"
"	</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>Scrollable databound multi-row control.</refpurpose>\n"
"        <special-childs>\n"
"          <child name=\"\"/>\n"
"        </special-childs>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:AnyVspxPageContent\"/>\n"
"        <xs:element ref=\"v:column\"/>\n"
"        <xs:element ref=\"v:param\"/>\n"
"        <xs:element ref=\"v:key\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attribute name=\"data\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation><para>Expression which returns an array of rowset data, this is an alternative to specifying an SQL expression. The result then will be used to instantiate\n"
"the repeating group. An example of such data is the result returned by 'exec' function:</para>\n"
"<programlisting>\n"
"(\n"
"  (\"ALFKI\" \"Alfreds Futterkiste\" \"030-0074321\" )\n"
"  (\"ANATR\" \"Ana Trujillo Emparedados y helados\" \"(5) 555-4729\" )\n"
")\n"
"</programlisting>\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"meta\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation><para>This works with combination of data attribute, this expression must return an array of ro metadata. So when this is specified it needs to be an expression returning meta-data for columns. In practice this is the same as 1st element of metadata returned by 'exec()' :</para>\n"
"\n"
"<programlisting>\n"
"(\n"
"  (\"CustomerID\" 182 0 5 0 1 1 \"Demo\" \"CustomerID\" \"demo\" \"Customers\" 0 )\n"
"  (\"CompanyName\" 182 0 40 1 1 1 \"Demo\" \"CompanyName\" \"demo\" \"Customers\" 0 )\n"
"  (\"Phone\" 182 0 24 1 1 1 \"Demo\" \"Phone\" \"demo\" \"Customers\" 0 )\n"
")\n"
"</programlisting>\n"
"\n"
"<para>\n"
"for details of metadata see 'exec()' function description.</para>\n"
"\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"nrows\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The maximum number of replicas of the row template to be made for rows selected.\n"
"This is like the rowset size for a scrollable cursor.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"sql\" type=\"v:SqlCode\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The select statement that gets the data.\n"
"Parameters to the statement MUST be specified as SQL identifiers prefixed with a colon (named parameter).\n"
"The values are given in the control's vspx:param children.  These specify the parameter name and a data bound expression for the value.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"scrollable\" type=\"xs:boolean\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The setting controls whether next and previous page buttons are presented.  This can be on even if the cursor is not scrollable as such.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"cursor-type\" type=\"v:PlCursorType\" use=\"optional\" default=\"dynamic\"/>\n"
"      <xs:attribute name=\"edit\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Flags whether editing features are enabled on data grid control</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <!-- these are not implemented nor specified\n"
"      xs:attribute name=\"select\" type=\"xs:boolean\" use=\"optional\"/>\n"
"      <xs:attribute name=\"column-titles\" type=\"xs:boolean\" use=\"optional\"/>\n"
"      <xs:attribute name=\"table\" type=\"v:SqlTableQname\" use=\"optional\"/-->\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:anyAttribute namespace=\"##any\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"isql\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>An interactive SQL control that allows the user to type an SQL statement and to see the result of its execution.</refpurpose>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:element ref=\"v:template\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attribute name=\"isolation\" type=\"v:IsqlIsolation\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>Transaction isolation level to be used.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"timeout\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Query time-out in seconds (currently not supported)</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"maxrows\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Maximum number of rows to be displayed.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"user\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>SQL user account to perform the query, if not specified\n"
"	    the SQL account used to run the VSPX page will be used.\n"
"	  </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"password\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>When the 'user' attribute is supplied, this is\n"
"	    the user's password.\n"
"	  </xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:simpleType name=\"IsqlIsolation\">\n"
"    <xs:restriction base=\"xs:string\">\n"
"      <xs:enumeration value=\"uncomitted\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>'uncomitted' transaction isolation level</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"committed\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>'committed' transaction isolation level</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"repeatable\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>'repeatable' transaction isolation level</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"      <xs:enumeration value=\"serializable\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>'serializable' transaction isolation level</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:enumeration>\n"
"    </xs:restriction>\n"
"  </xs:simpleType>\n"
"  <xs:element name=\"radio-group\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>\n"
"      This control is used to group containing radio-buttons in a group.\n"
"      This ensures that only one button is  selected  at a time.\n"
"      Note: This control is not mandatory for making  such group of\n"
"      buttons, another option is to use 'group-name' attribute of the radio-button control.\n"
"      </xs:documentation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>A group of radio-buttons.</refpurpose>\n"
"        <tutorial id=\"VX-S-2\">/tutorial/web/vx_s_2/radio_group.vspx</tutorial>\n"
"        <tutorial id=\"VX-S-3\">/tutorial/web/vx_s_3/update_radio.vspx</tutorial>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:UserInputTarget\"/>\n"
"        <xs:group ref=\"v:AnyVspxPageContent\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:UserInputAttributes\"/>\n"
"      <xs:attribute name=\"column\" type=\"v:SqlName\" use=\"optional\">\n"
"      <xs:annotation>\n"
"        <xs:documentation>The name of the column bound.\n"
"	  If nothing else is specified, the column meta data from the\n"
"	  containing update form sets the field's attributes.</xs:documentation>\n"
"      </xs:annotation>\n"
"    </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"hidden\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>A wrapper that prevents WYSIWYG editors from displaying its content.</refpurpose>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>This control does not affect the resulting HTML and Virtuoso/PL code. It is used by some WYSIWYG editors in order to temporarily hide details of the page fragment from the editor's drawing area.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:AnyVspxPageContent\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:HtmlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"style\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>A markup tag for use by 'macro stylesheets'.</refpurpose>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>This control marks the enclosed content for special processing in the 'macro stylesheet' whose name is specified by 'style' attribute of v:page element.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType mixed=\"true\">\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:AnyVspxPageContent\"/>\n"
"      </xs:choice>\n"
"      <xs:attribute name=\"name\" type=\"xs:NMTOKEN\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>Optional name of the control which could be used\n"
"	    in the macro expansion stylesheet assigned.\n"
"	  </xs:documentation>\n"
"	</xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <!--\n"
";\n", 
"-->\n"
"  <xs:element name=\"placeholder\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>Placeholder for original page in the decoration page.</refpurpose>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>This marks the place in the decoration page where the content of the original page should be placed.</xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:sequence/>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"calendar\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>This is the generic calendar control.</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>Databound calendar control.</refpurpose>\n"
"        <special-childs>\n"
"          <child name=\"\"/>\n"
"        </special-childs>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:AnyVspxPageContent\"/>\n"
"        <xs:element ref=\"v:param\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attribute name=\"initial-date\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Expression which returns a date for setting initially the current date of the calendar.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:anyAttribute namespace=\"##any\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <!--\n"
";\n", 
"-->\n"
"  <xs:element name=\"expression\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>A container for SQL statement generating a rowset or table name (see data-source).</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>An SQL statement that generates a rowset for v:data-source.</refpurpose>\n"
"        <no-render/>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType mixed=\"true\">\n"
"      <xs:sequence minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:any namespace=\"##any\"/>\n"
"      </xs:sequence>\n"
"      <xs:attribute name=\"language\" type=\"v:SqlName\" use=\"optional\">\n"
"        <xs:annotation>\n"
"	  <xs:documentation>Denotes the type of language,\n"
"	    currently only SQL expressions are supported, see 'expression-type' attribute\n"
"	    of the data-source control.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"data-source\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>Invisible multi-row data source.\n"
"      This control is an invisible represantation of a result set. Also it offer a\n"
"      number of methods for accessing and updating the data. It can be used as a source in\n"
"      the data-set control or as a separate data source for various form controls (such as label, url etc.).\n"
"      This control is using 'SELECT TOP N,M ..' statements to bind the data into the resultset (when source is a table or SQL statement), hence this should be taken into account when using it.\n"
"      </xs:documentation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>Scrollable multi-row data bound source.</refpurpose>\n"
"        <special-childs>\n"
"          <child name=\"\"/>\n"
"        </special-childs>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType mixed=\"true\">\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:AnyVspxPageContent\"/>\n"
"        <xs:element ref=\"v:column\"/>\n"
"        <xs:element ref=\"v:param\"/>\n"
"        <xs:element ref=\"v:expression\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attribute name=\"expression-type\" type=\"v:SqlExpressionType\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Denotes the type of 'expression'</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"nrows\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>The maximum number of rows to be selected.\n"
"It is like the rowset size for a scrollable cursor.\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"initial-offset\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Number of record to start data binding of rowset</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"data\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation><para>When this attribute is specified it must be an\n"
"expression returning array of arrays. This is an alternative to specifying an\n"
"SQL expression or data-source. The result then will be used to instantiate\n"
"the repeating group. An example of such data is the result returned by 'exec' function:</para>\n"
"<programlisting>\n"
"(\n"
"  (\"ALFKI\" \"Alfreds Futterkiste\" \"030-0074321\" )\n"
"  (\"ANATR\" \"Ana Trujillo Emparedados y helados\" \"(5) 555-4729\" )\n"
")\n"
"</programlisting>\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attribute name=\"meta\" type=\"v:CalculateableValue\" use=\"optional\">\n"
"        <xs:annotation>\n"
"          <xs:documentation><para>This attribute is used together with 'data', so when is\n"
"specified it needs to be an expression returning a meta-data for columns corresponding to the\n"
"these returned by 'data' expression. In practice it's same as 1-st element of metadata returned by 'exec()' :\n"
"</para>\n"
"\n"
"<programlisting>\n"
"(\n"
"  (\"CustomerID\" 182 0 5 0 1 1 \"Demo\" \"CustomerID\" \"demo\" \"Customers\" 0 )\n"
"  (\"CompanyName\" 182 0 40 1 1 1 \"Demo\" \"CompanyName\" \"demo\" \"Customers\" 0 )\n"
"  (\"Phone\" 182 0 24 1 1 1 \"Demo\" \"Phone\" \"demo\" \"Customers\" 0 )\n"
")\n"
"</programlisting>\n"
"\n"
"<para>for details of metadata see 'exec()' function description.</para>\n"
"</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <!--\n"
";\n", 
"  xs:element name=\"grid\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>A simple data-set variant; no HTML code inside, expanded internally to a data-set</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <refpurpose>scrollable, multi-row data bound grid</refpurpose>\n"
"        <example-description>\n"
"			    </example-description>\n"
"        <example><![CDATA[\n"
"				]]></example>\n"
"        <special-childs>\n"
"          <child name=\"\"/>\n"
"        </special-childs>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType mixed=\"true\">\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:AnyVspxPageContent\"/>\n"
"        <xs:element name=\"v:columns\">\n"
"           <xs:sequence>\n"
"	     <xs:element ref=\"v:column\" minOccurs=\"1\" maxOccurs=\"unbounded\" />\n"
"	   </xs:sequence>\n"
"        </xs:element>\n"
"        <xs:element name=\"header\"/>\n"
"        <xs:element name=\"footer\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"   </xs:element\n"
";\n", 
"-->\n"
"  <xs:element name=\"xsd-stub-top\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>\n"
"This control should never appear in the VSPX source.\n"
"It is for internal use only.\n"
"Before applying XML schema validation to the page,\n"
"Virtuoso replaces non-VSPX tags with this one when they reside outside v:page.\n"
"</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>This is for internal use only.</refpurpose>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:AnyVspxPageContent\"/>\n"
"        <xs:element ref=\"v:page\"/>\n"
"        <xs:element ref=\"v:xsd-stub-top\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"xsd-stub\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>\n"
"This control should never appear in the VSPX source.\n"
"It is for internal use only.\n"
"Before applying XML schema validation to the page,\n"
"Virtuoso replaces non-VSPX tags with this one when they reside inside v:page.\n"
"</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>This is for internal use only.</refpurpose>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType mixed=\"true\">\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:AnyVspxPageContent\"/>\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <!-- IMHO this is incorrect:\n"
" 	<xs:group ref=\"v:EventTarget\"/>\n"
"VSPX.XSL does not handle correclty events that are\n"
"enclosed in HTML tags.\n"
"If you see this, go fix the VSPX page or improve the VSPX.XSL.\n"
" -->\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"xsd-stub-script\">\n"
"    <xs:annotation>\n"
"      <xs:documentation>\n"
"This control should never appear in the VSPX source.\n"
"It is for internal use only.\n"
"Before applying XML schema validation to the page,\n"
"Virtuoso replaces non-VSPX tags with this one when they reside inside event script tag such as v:on-init.\n"
"</xs:documentation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"        <refpurpose>This is for internal use only.</refpurpose>\n"
"      </xs:appinfo>\n"
"    </xs:annotation>\n"
"    <xs:complexType mixed=\"true\">\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"vscx\">\n"
"    <xs:annotation>\n"
"      <xs:appinfo>\n"
"        <no-default-target-udt/>\n"
"      </xs:appinfo>\n"
"      <xs:documentation>Custom control encapsulated in a separate VSPX page. This is a\n"
"	  wrapper for custom control instantiation. The target URL MUST contain\n"
"	  a valid VSPX page reference. In this way repeatable pieces of code can be reused in\n"
"	  form of instantiation of their page class, this is different from inclusion.\n"
"	  The target page variables can be initialized as attributes in this control, where\n"
"	  name of attribute is a name of variable of target page and value is\n"
"	  an expression to be assigned.\n"
"      </xs:documentation>\n"
"    </xs:annotation>\n"
"    <xs:complexType>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attribute name=\"url\" type=\"xs:anyURI\" use=\"required\">\n"
"        <xs:annotation>\n"
"          <xs:documentation>Reference to a VSPX page to be instantiated as a control.</xs:documentation>\n"
"        </xs:annotation>\n"
"      </xs:attribute>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:anyAttribute namespace=\"##local\" processContents=\"lax\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <!--\n"
";\n", 
"-->\n"
"  <xs:annotation>\n"
"    <xs:documentation>Deprecated VSPX Controls</xs:documentation>\n"
"  </xs:annotation>\n"
"  <xs:element name=\"node-template\">\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:AnyVspxPageContent\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"leaf-template\">\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:AnyVspxPageContent\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"  <xs:element name=\"horizontal-template\">\n"
"    <xs:complexType>\n"
"      <xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n"
"        <xs:group ref=\"v:EventTarget\"/>\n"
"        <xs:group ref=\"v:AnyVspxPageContent\"/>\n"
"      </xs:choice>\n"
"      <xs:attributeGroup ref=\"v:SqlGenAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:DebugAttributes\"/>\n"
"      <xs:attributeGroup ref=\"v:WmAttributes\"/>\n"
"    </xs:complexType>\n"
"  </xs:element>\n"
"</xs:schema>\n"
"\n"
,
 NULL };

/* vspx.xsl */

static const char *xsl38[]= {
"<?xml version='1.0'?>\n"
"<!DOCTYPE xsl:stylesheet [\n"
"  <!ENTITY LINE \"&#10;#line <xsl:value-of select='xpath-debug-xslline()+1' /> &quot;<xsl:value-of select='xpath-debug-xslfile()' />&quot;\">\n"
"]>\n"
"<!--\n"
" -  \n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -  \n"
" -  Copyright (C) 1998-2015 OpenLink Software\n"
" -  \n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -  \n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -  \n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -  \n"
" -  \n"
"-->\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n"
"     version=\"1.0\"\n"
"     xmlns:v=\"http://www.openlinksw.com/vspx/\"  exclude-result-prefixes=\"v\"\n"
"     xmlns:xhtml=\"http://www.w3.org/1999/xhtml\"\n"
"     xmlns:xforms=\"http://www.w3.org/2002/xforms\"\n"
"     xmlns:ev=\"http://www.w3.org/2001/xml-events\"\n"
"     >\n"
"<xsl:output method=\"text\" omit-xml-declaration=\"yes\" indent=\"no\" />\n"
"\n"
"<xsl:key name=\"on-init\" match=\"//v:on-init\" use=\"@belongs-to\" />\n"
"<xsl:key name=\"before-data-bind\" match=\"//v:before-data-bind\" use=\"@belongs-to\" />\n"
"<xsl:key name=\"after-data-bind\" match=\"//v:after-data-bind\" use=\"@belongs-to\" />\n"
"<xsl:key name=\"on-post\" match=\"//v:on-post\" use=\"@belongs-to\" />\n"
"<xsl:key name=\"before-render\" match=\"//v:before-render\" use=\"@belongs-to\" />\n"
"\n"
"<xsl:param name=\"vspx_dbname\">DB</xsl:param>\n"
"<xsl:param name=\"vspx_user\">dba</xsl:param>\n"
"<xsl:param name=\"vspx_source\">?unknown_source?</xsl:param>\n"
"<xsl:param name=\"vspx_source_date\">?unknown_source_date?</xsl:param>\n"
"<xsl:param name=\"vspx_compile_date\">?unknown_compile_date?</xsl:param>\n"
"<xsl:param name=\"vspx_compiler_version\">?unknown_compiler_version?</xsl:param>\n"
"<xsl:param name=\"vspx_local_class_name\">page_<xsl:value-of select=\"//v:page/@name\" /></xsl:param>\n"
"<xsl:param name=\"vspx_full_class_name\">\"<xsl:value-of select=\"$vspx_dbname\"/>\".\"<xsl:value-of select=\"$vspx_user\"/>\".<xsl:value-of select=\"$vspx_local_class_name\" /></xsl:param>\n"
"<xsl:variable name=\"this_page\" select=\"//v:page\" />\n"
"<xsl:variable name=\"debug_on\" select=\"count ($this_page/@debug-log[not(string(.) like '%disable%')])\"/>\n"
"\n"
"<!-- VARIABLES FOR DIFFERENT CONTROLS SET -->\n"
"\n"
"<xsl:variable name=\"member-controls-set\" select=\".//v:*[@name and local-name() != 'variable' and local-name() != 'method' and local-name() != 'column' and local-name() != 'param' and local-name() != 'field' and local-name() != 'key' and local-name() != 'item'  and local-name() != 'parameter']\"/>\n"
"\n"
"<xsl:variable name=\"not-a-control\" select=\".//v:field[empty(@value)]\" />\n"
"\n"
"<xsl:variable name=\"standard-post-set\" select=\"\n"
"    .//v:browse-button|\n"
"    .//v:button|\n"
"    .//v:calendar|\n"
"    .//v:check-box|\n"
"    .//v:data-list|\n"
"    .//v:field[@value]|\n"
"    .//v:form[@type='update']|\n"
"    .//v:form[@type='simple']|\n"
"    .//v:isql|\n"
"    .//v:login|\n"
"    .//v:radio-button|\n"
"    .//v:select-list|\n"
"    .//v:tab|\n"
"    .//v:textarea|\n"
"    .//v:text|\n"
"    .//v:tree|\n"
"    .//v:update-field|\n"
"    .//v:*[@name][v:validator]\" />\n"
"\n"
"<xsl:variable name=\"user-post-set\" select=\".//*[@name][not (. = $not-a-control)][key('on-post',@name)]\" />\n"
"\n"
"<xsl:variable name=\"statable-controls-set\" select=\".//v:isql\" />\n"
"\n"
"<xsl:variable name=\"initable-controls-set\" select=\"\n"
"    .//v:browse-button|\n"
"    .//v:button[@action='browse']|\n"
"    .//v:button[@action='delete']|\n"
"    .//v:button[@action='logout']|\n"
"    .//v:button[@action='return']|\n"
"    .//v:button[@action='simple']|\n"
"    .//v:button[@action='submit']|\n"
"    .//v:calendar|\n"
"    .//v:check-box|\n"
"    .//v:data-grid|\n"
"    .//v:data-list|\n"
"    .//v:data-set|\n"
"    .//v:data-source|\n"
"    .//v:field[@value]|\n"
"    .//v:form[@type='simple']|\n"
"    .//v:form[@type='update']|\n"
"    .//v:isql|\n"
"    .//v:label|\n"
"    .//v:login-form|\n"
"    .//v:login|\n"
"    .//v:radio-button|\n"
"    .//v:radio-group|\n"
"    .//v:select-list|\n"
"    .//v:tab|\n"
"    .//v:template[@type = 'add']|\n"
"    .//v:template[@type='edit']|\n"
"    .//v:template[@type='error']|\n"
"    .//v:template[@type='input']|\n"
"    .//v:template[@type='result']|\n"
"    .//v:template[@type='simple']|\n"
"    .//v:template[@type='page-navigator']|\n"
"    .//v:template[@type='if-not-exists']|\n"
"    .//v:template[@type='if-exists']|\n"
"    .//v:textarea|\n"
"    .//v:text|\n"
"    .//v:tree|\n"
"    .//v:update-field|\n"
"    .//v:url|\n"
"    .//v:local-variable|\n"
"    .//v:vscx\" />\n"
"\n"
"<xsl:variable name=\"bindable-controls-set\" select=\"\n"
"    .//v:browse-button|\n"
"    .//v:button[@action='browse']|\n"
"    .//v:button[@action='delete']|\n"
"    .//v:button[@action='logout']|\n"
"    .//v:button[@action='return']|\n"
"    .//v:button[@action='simple']|\n"
"    .//v:button[@action='submit']|\n"
"    .//v:calendar|\n"
"    .//v:check-box|\n"
"    .//v:data-list|\n"
"    .//v:data-source|\n"
"    .//v:data-set|.//v:data-grid|\n"
"    .//v:field[@value]|\n"
"    .//v:form[@type='simple']|\n"
"    .//v:form[@type='update']|\n"
"    .//v:isql|\n"
"    .//v:label|\n"
"    .//v:login|\n"
"    .//v:radio-button|\n"
"    .//v:select-list|\n"
"    .//v:tab|\n"
"    .//v:template[@type='simple']|\n"
"    .//v:template[@type='browse']|\n"
"    .//v:textarea|\n"
"    .//v:text|\n"
"    .//v:tree|\n"
"    .//v:url|\n"
"    .//v:local-variable|\n"
"    .//v:vscx|\n"
"    .//*[@name][not (. = $not-a-control)][key('before-data-bind',@name)]\" />\n"
"\n"
"<xsl:variable name=\"scrollable-controls-set\" select=\".//v:data-set\" />\n"
"\n"
"\n"
"<xsl:variable name=\"renderable-controls-set\" select=\"\n"
"    .//v:calendar|\n"
"    .//v:data-grid|\n"
"    .//v:data-list|\n"
"    .//v:data-set|\n"
"    .//v:form[@type='simple']|\n"
"    .//v:form[@type='update']|\n"
"    .//v:isql|\n"
"    .//v:login|\n"
"    .//v:radio-group|\n"
"    .//v:select-list|\n"
"    .//v:tab|\n"
"    .//v:template[@name and @type != 'if-login' and @type != 'if-no-login'][@type != 'row']|\n"
"    .//v:tree|\n"
"    .//v:vscx\" />\n"
"\n"
"<xsl:variable name=\"after-data-bind-set\" select=\".//*[@name][not (. = $not-a-control)][key('after-data-bind',@name)]\" />\n"
"\n"
"<xsl:variable name=\"before-render-set\" select=\".//*[@name][not (. = $not-a-control)][key('before-render',@name)]\" />\n"
"\n"
"<xsl:variable name=\"custom-controls-set\" select=\".//*[@name and v:vcc_exists (name())]\" />\n"
"\n"
"<xsl:variable name=\"renderable-rows-of-controls-set\" select=\".//v:template[@name][@type='row']\" />\n"
"\n"
"<xsl:template match=\"/\">\n"
"  <xsl:if test=\"$this_page[./ancestor::v:*]\">\n"
"    <xsl:message terminate=\"yes\">VSPX element 'page' is placed inside other VSPX element.</xsl:message>\n"
"  </xsl:if>\n"
"  <xsl:for-each select=\"/comment()\"><xsl:call-template name=\"comment_gen\" /></xsl:for-each>\n"
"  <xsl:for-each select=\"/*/comment()\"><xsl:call-template name=\"comment_gen\" /></xsl:for-each>\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"$this_page\"><xsl:apply-templates select=\"$this_page\" mode=\"page_class\" /></xsl:when>\n"
"    <xsl:otherwise><xsl:apply-templates select=\".\" mode=\"page_class\" /></xsl:otherwise>\n"
"  </xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<xsl:template name=\"comment_gen\">\n"
"<!--<xsl:value-of select=\"replace(replace(replace(serialize(.), concat('&lt;!-','-'), ''), concat('-','-&gt;'), ''), '&#x0A;', concat('&#x0A;-','-'))\" />.-->\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"node()\" mode=\"page_class\">\n"
"-- This is a automatically generated code, please do not edit\n"
"-- Created from <xsl:value-of select=\"$vspx_source\"/> by <xsl:value-of select=\"$vspx_compiler_version\"/>.\n"
"-- Source is dated <xsl:value-of select=\"$vspx_source_date\"/>.\n"
"-- Compilation started <xsl:value-of select=\"$vspx_compile_date\"/>.\n"
"set MACRO_SUBSTITUTION off;\n"
"set IGNORE_PARAMS on;\n"
"\n"
"<!-- The page class (UDT) definition -->\n"
"create type <xsl:value-of select=\"$vspx_full_class_name\" /> under vspx_page\n"
"  as (<xsl:for-each select=\".//v:variable\"><xsl:value-of select=\"@name\"/>\n"
"<xsl:text> </xsl:text>\n"
"<xsl:choose><xsl:when test=\"@type='xml'\">any</xsl:when><xsl:otherwise><xsl:value-of select=\"@type\"/></xsl:otherwise></xsl:choose>\n"
"<xsl:if test=\"@default\"> default <xsl:value-of select=\"@default\"/></xsl:if>,\n"
"       </xsl:for-each>\n"
"       <xsl:for-each select=\".//v:*[@name and local-name() != 'variable' and local-name() != 'method' and local-name() != 'column' and local-name() != 'param' and local-name() != 'field' and local-name() != 'key' and local-name() != 'item'  and local-name() != 'parameter']\">\n"
"       \"<xsl:value-of select=\"@name\" />\"<xsl:text> </xsl:text><xsl:value-of select=\"@control-udt\"/>, </xsl:for-each>\n"
"       <xsl:for-each select=\"$custom-controls-set\">\n"
"       \"<xsl:value-of select=\"@name\" />\"<xsl:text> </xsl:text><xsl:value-of select=\"v:vcc_class_name (name())\" />, </xsl:for-each>\n"
"       nonce varchar default '',\n"
"       sid varchar default '',\n"
"       realm varchar default ''\n"
"     )\n"
"  temporary self as ref\n"
"    constructor method <xsl:value-of select=\"$vspx_local_class_name\" /> (path any, params any, lines any),\n"
"    method vc_view_state_<xsl:value-of select=\"$vspx_local_class_name\" /> (control vspx_page, stream any, n int) returns any,\n"
"    method vc_set_view_state_<xsl:value-of select=\"$vspx_local_class_name\" /> (control vspx_page, e vspx_event) returns any,\n"
"<!-- no need: <xsl:call-template name=\"script_declare\"><xsl:with-param name=\"methodname\">on_init</xsl:with-param><xsl:with-param name=\"methodkey\">on-init</xsl:with-param></xsl:call-template> -->\n"
"  <xsl:call-template name=\"script_declare\"><xsl:with-param name=\"methodname\">data_bind</xsl:with-param><xsl:with-param name=\"methodkey\">before-data-bind</xsl:with-param></xsl:call-template>\n"
"  <xsl:call-template name=\"script_declare\"><xsl:with-param name=\"methodname\">after_data_bind</xsl:with-param><xsl:with-param name=\"methodkey\">after-data-bind</xsl:with-param></xsl:call-template>\n"
"  <xsl:call-template name=\"script_declare\"><xsl:with-param name=\"methodname\">user_post</xsl:with-param><xsl:with-param name=\"methodkey\">on-post</xsl:with-param></xsl:call-template>\n"
"  <xsl:call-template name=\"script_declare\"><xsl:with-param name=\"methodname\">pre_render</xsl:with-param><xsl:with-param name=\"methodkey\">before-render</xsl:with-param></xsl:call-template>\n"
"  <xsl:for-each select=\".//v:method\">\n"
"<xsl:text/>    method <xsl:value-of select=\"@name\" /> (<xsl:value-of select=\"@arglist\" />) returns <xsl:value-of select=\"@returns\" />,\n"
"  </xsl:for-each>\n"
"  <xsl:for-each select=\"$statable-controls-set\">\n"
"<xsl:text/>    method vc_set_view_state_<xsl:value-of select=\"@name\" /> (ctrl <xsl:value-of select=\"@control-udt\"/>, e vspx_event) returns any,\n"
"  </xsl:for-each>\n"
"  <!-- INIT -->\n"
"  <xsl:for-each select=\"$initable-controls-set\">\n"
"<xsl:text/>    method vc_init_<xsl:value-of select=\"@name\" /> (control <xsl:value-of select=\"@control-udt\"/>, parent vspx_control) returns any,\n"
"  </xsl:for-each>\n"
"  <xsl:for-each select=\"$custom-controls-set\">\n"
"    method vcc_init_<xsl:value-of select=\"@name\" /> (name varchar, parent vspx_control) returns <xsl:value-of select=\"v:vcc_class_name (name())\" />,\n"
"  </xsl:for-each>\n"
"  <!-- DATA-BIND -->\n"
"  <xsl:for-each select=\"$bindable-controls-set\">\n"
"<xsl:text/>    method vc_data_bind_<xsl:value-of select=\"@name\" /> (control <xsl:value-of select=\"@control-udt\"/>, e vspx_event) returns any,\n"
"  </xsl:for-each>\n"
"  <xsl:for-each select=\"$after-data-bind-set\">\n"
"<xsl:text/>    method vc_after_data_bind_<xsl:value-of select=\"@name\" /> (control <xsl:value-of select=\"@control-udt\"/>, e vspx_event) returns any,\n"
"  </xsl:for-each>\n"
"  <xsl:for-each select=\"$scrollable-controls-set\">\n"
"<xsl:text/>    method vc_scroll_<xsl:value-of select=\"@name\" /> (control <xsl:value-of select=\"@control-udt\"/>, new_rows_offs integer, e vspx_event) returns any,\n"
"  </xsl:for-each>\n"
"  <!-- STANDARD POST -->\n"
"  <xsl:for-each select=\"$standard-post-set\">\n"
"<xsl:text/>    method vc_post_<xsl:value-of select=\"@name\" /> (control <xsl:value-of select=\"@control-udt\"/>, e vspx_event) returns any,\n"
"  </xsl:for-each>\n"
"  <!-- USER POST -->\n"
"  <xsl:for-each select=\"$user-post-set\">\n"
"<xsl:text/>    method vc_user_post_<xsl:value-of select=\"@name\" /> (control <xsl:value-of select=\"@control-udt\"/>, e vspx_event) returns any,\n"
"  </xsl:for-each>\n"
"  <!-- ACTION -->\n"
"  <xsl:for-each select=\"$standard-post-set\">\n"
"<xsl:text/>    method vc_action_<xsl:value-of select=\"@name\" /> (control <xsl:value-of select=\"@control-udt\"/>, e vspx_event) returns any,\n"
"  </xsl:for-each>\n"
"  <!-- RENDER -->\n"
"  <xsl:for-each select=\"$renderable-controls-set\">\n"
"<xsl:text/>    method vc_render_<xsl:value-of select=\"@name\" /> (control <xsl:value-of select=\"@control-udt\"/>) returns any,\n"
"  </xsl:for-each>\n"
"  <xsl:for-each select=\"$renderable-rows-of-controls-set\">\n"
"<xsl:text/>    method vc_rows_render_<xsl:value-of select=\"@name\" /> (control <xsl:value-of select=\"../@control-udt\"/>) returns any,\n"
"  </xsl:for-each>\n"
"  <!-- data-bind; render for tree-node; special cases -->\n"
"  <xsl:for-each select=\".//v:tree\">\n"
"  <xsl:text/>    method vc_data_bind_node_<xsl:value-of select=\"@name\" /> (tree vspx_tree, control vspx_tree_node, e vspx_event, nodeset any, path any, inx int, level int) returns any,\n"
"<xsl:text/>    method vc_render_node_<xsl:value-of select=\"@name\" /> (control vspx_tree_node, childs any) returns any,\n"
"  </xsl:for-each>\n"
"  <!-- VALIDATE  -->\n"
"  <xsl:for-each select=\".//v:*[v:validator[@test='sql' and not @expression]]\">\n"
"<xsl:text/>    method vc_validate_<xsl:value-of select=\"@name\" /> (control <xsl:value-of select=\"@control-udt\"/>) returns any,\n"
"  </xsl:for-each>\n"
"  <!-- PRE-RENDER -->\n"
"  <xsl:for-each select=\"$before-render-set\">\n"
"<xsl:text/>    method vc_pre_render_<xsl:value-of select=\"@name\" /> (ctrl <xsl:value-of select=\"@control-udt\"/>) returns any,\n"
"  </xsl:for-each>\n"
"  <xsl:if test=\"@on-error-redirect or @on-deadlock-retry\">\n"
"<xsl:text/>    method vc_error_handler_<xsl:value-of select=\"$vspx_local_class_name\" /> (state any, message any, deadl any) returns any,\n"
"  </xsl:if>\n"
"<xsl:text/>    method vc_redirect (url any) returns any,\n"
"<xsl:text/>    method vc_render_<xsl:value-of select=\"$vspx_local_class_name\" /> (control vspx_page) returns any\n"
";\n", 
"<!-- The page UDT declaration end -->\n"
"\n"
"<!-- The page UDT constructor -->\n"
"create constructor method <xsl:value-of select=\"$vspx_local_class_name\" /> (in path any, in params any, in lines any)\n"
"for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"  declare childs any;\n"
"  declare vst, clen any;\n"
"  declare e vspx_event;\n"
"  <!-- not here; default is null; for vscx this is not true self.vc_parent := NULL; -->\n"
"  self.vc_view_state := vector ();\n"
"  self.vc_name := '<xsl:value-of select=\"$vspx_local_class_name\" />';\n"
"  self.vc_page := self;\n"
"  self.vc_have_state := 1;\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%ctor%']\">declare _debug_log_id integer; _debug_log_id := self.vc_debug_log ('begin', 'Page constructor', null); -- debug-log code</xsl:if>\n"
"\n"
"  e := new vspx_event ();\n"
"  clen := http_request_header (lines, 'Content-Length', null, '0');\n"
"  if (isstring (clen))\n"
"    clen := atoi (clen);\n"
"  else\n"
"    clen := 0;\n"
"\n"
"  if (length (params) &lt; (1+(4*http_map_get('is_dav'))) and clen &gt;= 10000000\n"
"    and lower (http_request_header (lines, 'Content-Type')) like 'multipart/%')\n"
"    {\n"
"      params := __http_stream_params ();\n"
"    }\n"
"  <!-- all browsers are suposed to set content-type, but some may not return application/xml with post\n"
"  in this way body may remains unread and next hit on same connection will crash the page.\n"
"  hence we will read if there is something to read and it's not parsed in 'params'\n"
"  -->\n"
"  if (http_request_header (lines, 'Content-Type') = 'application/xml' or (clen &gt; 0 and length (params) = 0))\n"
"    {\n"
"      declare cnt, xt, ppar any;\n"
"      cnt := http_body_read ();\n"
"      cnt := string_output_string (cnt);\n"
"      if (length (cnt) &gt; 0)\n"
"        params := vspx_xforms_params_parse (cnt);\n"
"    }\n"
"  e.ve_params := params;\n"
"  e.ve_lines := lines;\n"
"  e.ve_path := path;\n"
"\n"
"  vst := get_keyword ('<xsl:value-of select=\"$vspx_local_class_name\" />_view_state', params);\n"
"\n"
"  if (vst is not NULL)\n"
"    {\n"
"      e.ve_is_post := 1;\n"
"      self.vc_is_postback := 1;\n"
"    }\n"
"  self.vc_event := e;\n"
"\n"
"  self.vc_view_state := vector (\n"
"      self.vc_name, null,\n"
"      <xsl:for-each select=\".//v:*[@name][not (local-name(.) = 'variable' and (@persist = '1' or @persist = 'session'))]\">\n"
"        '<xsl:value-of select=\"@name\"/>', null,</xsl:for-each>\n"
"        '<xsl:value-of select=\"@name\"/>', null\n"
"      );\n"
"\n"
"  if (vst is not null)\n"
"    {\n"
"      declare post, state, extend any;\n"
"      declare i, l int;\n"
"      -- get the posted state\n"
"      post := vspx_state_deserialize (vst);\n"
"      -- page state\n"
"      state := self.vc_view_state;\n"
"      -- extension\n"
"      extend := vector ();\n"
"\n"
"      l := length (post); i := 0;\n"
"\n"
"      if (mod (l, 2))\n"
"        signal ('22023', 'Page state expects to have even length, current state is possibly broken');\n"
"\n"
"      while (i &lt; l)\n"
"        {\n"
"	  -- set the pages state back to vc_view_state\n"
"	  declare pos int;\n"
"	  pos := position (post[i], state);\n"
"	  if (pos)\n"
"	    aset (state, pos, post [i+1]);\n"
"	  else\n"
"	    extend := vector_concat (extend, vector (post[i], post[i+1]));\n"
"          i := i + 2;\n"
"	}\n"
"\n"
"      if (length (extend))\n"
"        self.vc_view_state := vector_concat (state, extend);\n"
"      else\n"
"        self.vc_view_state := state;\n"
"\n"
"      <!-- dbg_obj_print ('page view_state: ', state); -->\n"
"\n"
"    }\n"
"\n"
"  self.vc_set_view_state (e);\n"
"\n"
"  {\n"
"    declare control vspx_control;\n"
"    control := self;\n"
"    self.vc_children := vector (\n"
"    <!-- The login control should be only one, and MUST be on first place !!! -->\n"
"    <xsl:apply-templates select=\".//v:login\" mode=\"login_child\" />\n"
"    <xsl:apply-templates select=\"*\" mode=\"form_childs_init\" />\n"
"       NULL\n"
"       );\n"
"  }\n"
"\n"
"  self.vc_get_focus (e);\n"
"  <!-- self.vc_set_view_state (e); -->\n"
"  <xsl:for-each select=\"key('on-init',@name)\"><xsl:value-of select=\".\" /></xsl:for-each>\n"
"  self.vc_browser_caps := coalesce (connection_get ('RenderXForms'), 0);\n"
"  if (self.vc_browser_caps)\n"
"    {\n"
"      self.vc_add_attribute ('xmlns', 'http://www.w3.org/2002/06/xhtml2');\n"
"      self.vc_add_attribute ('xmlns:xsd', 'http://www.w3.org/2001/XMLSchema');\n"
"      self.vc_add_attribute ('xmlns:xforms', 'http://www.w3.org/2002/xforms');\n"
"      self.vc_add_attribute ('xmlns:ev', 'http://www.w3.org/2001/xml-events');\n"
"      self.vc_add_attribute ('xmlns:vxf', 'http://www.openlinksw.com/vspx/xforms/');\n"
"    }\n"
"  <!-- FK Child Window Generator START -->\n"
"  {\n"
"    declare pagename, xmlmodel any;\n"
"    <xsl:for-each select=\".//v:fk-child-window\">\n"
"      pagename := '<xsl:value-of select=\".//v:browse-button/@selector\" disable-output-escaping=\"yes\"/>';\n"
"      xmlmodel := '<xsl:value-of select=\"serialize(.)\" disable-output-escaping=\"yes\"/>';\n"
"      vspx_generate_page(pagename, xmlmodel);\n"
"    </xsl:for-each>\n"
"  }\n"
"  <!-- FK Child Window Generator END -->\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%ctor%']\">self.vc_debug_log_endgroup (_debug_log_id, 'end', 'Page constructor', null); -- debug-log code</xsl:if>\n"
"}\n"
";\n", 
"\n"
"  <xsl:for-each select=\".//v:method\">\n"
"&LINE;\n"
"create method <xsl:value-of select=\"@name\" /> (<xsl:value-of select=\"@arglist\" />) for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%method%']\">declare _debug_log_id integer; _debug_log_id := self.vc_debug_log ('begin', 'Custom method <xsl:value-of select=\"@name\" />', null); -- debug-log code</xsl:if>\n"
"  <xsl:value-of select=\".\" />\n"
"&LINE;\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%method%']\">self.vc_debug_log_endgroup (_debug_log_id, 'end', 'Custom method <xsl:value-of select=\"@name\" />', null); -- debug-log code</xsl:if>\n"
"}\n"
";\n", 
"  </xsl:for-each>\n"
"\n"
"<!-- PAGE METHODS (methods for self) -->\n"
"create method vc_view_state_<xsl:value-of select=\"$vspx_local_class_name\" /> (inout control vspx_page, inout stream any, inout n int) for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"  declare state any;\n"
"  state := vector(<xsl:for-each select=\".//v:variable[@persist = '0' or @persist = 'pagestate' or not @persist]\">\n"
"                    '<xsl:value-of select=\"@name\"/>', self.<xsl:value-of select=\"@name\"/>,\n"
"                  </xsl:for-each>\n"
"                  'realm', self.realm);\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%state%']\">control.vc_debug_log ('state', 'Page state saved', null); -- debug-log code</xsl:if>\n"
"  self.vc_push_in_stream (stream, state, n);\n"
"  return;\n"
"}\n"
";\n", 
"\n"
"create method vc_set_view_state_<xsl:value-of select=\"$vspx_local_class_name\" /> (inout control vspx_page, inout e vspx_event) for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"  declare vartmp any;\n"
"  if (e.ve_is_post) {\n"
"    declare vars any;\n"
"    vars := get_keyword ('<xsl:value-of select=\"$vspx_local_class_name\" />', self.vc_view_state, null);\n"
"    if (vars is not null) {\n"
"      self.realm := get_keyword ('realm', vars);\n"
"    <xsl:for-each select=\".//v:variable[@persist = '0' or @persist = 'pagestate' or not @persist]\">\n"
"      self.<xsl:value-of select=\"@name\"/> := get_keyword ('<xsl:value-of select=\"@name\"/>', vars);\n"
"      <xsl:if test=\"@type='xml'\">\n"
"      if (isstring (self.<xsl:value-of select=\"@name\"/>))\n"
"        self.<xsl:value-of select=\"@name\"/> := xtree_doc (self.<xsl:value-of select=\"@name\"/>);\n"
"      </xsl:if>\n"
"    </xsl:for-each>\n"
"    }\n"
"  }\n"
"  <xsl:for-each select=\".//v:variable[@param-name != '']\">\n"
"  vartmp := get_keyword ('<xsl:value-of select=\"@param-name\"/>', e.ve_params);\n"
"  if (vartmp is not null)\n"
"    self.<xsl:value-of select=\"@name\"/> := cast (vartmp as <xsl:value-of select=\"@type\"/>);\n"
"  </xsl:for-each>\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%state%']\">control.vc_debug_log ('state', 'Page state restored', null); -- debug-log code</xsl:if>\n"
"}\n"
";\n", 
"\n"
"<xsl:if test=\"@on-error-redirect or @on-deadlock-retry\">\n"
"create method vc_error_handler_<xsl:value-of select=\"$vspx_local_class_name\" /> (in state any, in message any, inout deadl any) for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%error%']\">declare _debug_log_id integer; _debug_log_id := self.vc_debug_log ('begin', 'Error handler', null); -- debug-log code</xsl:if>\n"
"  http_rewrite ();\n"
"  <xsl:if test=\"@on-deadlock-retry\">\n"
"  if (not isinteger (deadl)) {\n"
"    deadl := <xsl:value-of select=\"@on-deadlock-retry\"/>;\n"
"  }\n"
"  if (state = '40001') {\n"
"    deadl := deadl - 1;\n"
"    if (deadl &gt; 0) {\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%error%']\">self.vc_debug_log_endgroup (_debug_log_id, 'end', 'Error handler has detected a deadlock', null); -- debug-log code</xsl:if>\n"
"      return 1;\n"
"    }\n"
"  }\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@on-error-redirect\">\n"
"  {\n"
"    if (not isstring (state))\n"
"      state := cast (state as varchar);\n"
"    if (not isstring (message) and state = '100')\n"
"      message := 'Not found exception';\n"
"    http_request_status ('HTTP/1.1 302 Found');\n"
"    if(length (self.sid) and self.vc_authentication_mode) {\n"
"      http_header (sprintf ('Location: %V?__PAGE=%U&amp;__SQL_STATE=%U&amp;__SQL_MESSAGE=%U&amp;sid=%U&amp;realm=%U\\r\\n', '<xsl:value-of select=\"@on-error-redirect\"/>', http_path (), state, message, self.sid, self.realm));\n"
"    }\n"
"    else {\n"
"      http_header (sprintf ('Location: %V?__PAGE=%U&amp;__SQL_STATE=%U&amp;__SQL_MESSAGE=%U\\r\\n', '<xsl:value-of select=\"@on-error-redirect\"/>', http_path (), state, message));\n"
"    }\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%error%']\">self.vc_debug_log_endgroup (_debug_log_id, 'end', 'Error handler has performed a redirect', null); -- debug-log code</xsl:if>\n"
"    return 1;\n"
"  }\n"
"  </xsl:if>\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%error%']\">self.vc_debug_log_endgroup (_debug_log_id, 'end', 'Error handler', null); -- debug-log code</xsl:if>\n"
"  return 0;\n"
"}\n"
";\n", 
"</xsl:if>\n"
"\n"
"create method vc_redirect (in url any) for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"  if (length (self.sid))\n"
"    url := vspx_uri_add_parameters (url, sprintf ('sid=%U&amp;realm=%U', self.sid, self.realm));\n"
"  http_request_status ('HTTP/1.1 302 Found');\n"
"  http_header (concat (http_header_get (), 'Location: ',url,'\\r\\n'));\n"
"}\n"
";\n", 
"\n"
"<!-- no need: <xsl:call-template name=\"script_define\"><xsl:with-param name=\"methodname\">on_init</xsl:with-param><xsl:with-param name=\"methodkey\">on-init</xsl:with-param></xsl:call-template> -->\n"
"<xsl:call-template name=\"script_define\"><xsl:with-param name=\"methodname\">data_bind</xsl:with-param><xsl:with-param name=\"methodkey\">before-data-bind</xsl:with-param></xsl:call-template>\n"
"<xsl:call-template name=\"script_define\"><xsl:with-param name=\"methodname\">after_data_bind</xsl:with-param><xsl:with-param name=\"methodkey\">after-data-bind</xsl:with-param></xsl:call-template>\n"
"<xsl:call-template name=\"script_define\"><xsl:with-param name=\"methodname\">user_post</xsl:with-param><xsl:with-param name=\"methodkey\">on-post</xsl:with-param></xsl:call-template>\n"
"<xsl:call-template name=\"script_define\"><xsl:with-param name=\"methodname\">pre_render</xsl:with-param><xsl:with-param name=\"methodkey\">before-render</xsl:with-param></xsl:call-template>\n"
"\n"
"\n"
"<!-- Page class methods for well known controls -->\n"
"<!-- INIT -->\n"
"  -- INIT methods\n"
"<xsl:for-each select=\"$initable-controls-set\">\n"
"create method vc_init_<xsl:value-of select=\"@name\" /> (inout control <xsl:value-of select=\"@control-udt\"/>, inout parent vspx_control) for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"  <!-- some controls like VSCX needs vc_children to exists -->\n"
"  <xsl:if test=\"local-name () != 'vscx'\">\n"
"  if (control.vc_children is not null)\n"
"    {\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%init%']\">control.vc_debug_log ('skip', 'vc_init_...()', null); -- debug-log code</xsl:if>\n"
"      return;\n"
"    }\n"
"  </xsl:if>\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%init%']\">declare _debug_log_id integer; _debug_log_id := control.vc_debug_log ('begin', 'vc_init_...()', null); -- debug-log code</xsl:if>\n"
"  <xsl:if test=\"@initial-enable = '0' or @enabled = '0'\">\n"
"  control.vc_enabled := 0;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@is-boolean[.='1' or .='true']\">\n"
"    control.ufl_is_boolean := 1;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@true-value[not(. like '--%')]\">\n"
"    control.ufl_true_value := <xsl:apply-templates select=\"@true-value\" mode=\"static_value\"/>;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@false-value[not(. like '--%')]\">\n"
"    control.ufl_false_value := <xsl:apply-templates select=\"@false-value\" mode=\"static_value\"/>;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@value and not (@value like '--%')\">\n"
"  control.ufl_value := <xsl:apply-templates select=\"@value\" mode=\"static_value\"/>;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@defvalue and not (@defvalue like '--%')\">\n"
"  control.ufl_value := <xsl:apply-templates select=\"@defvalue\" mode=\"static_value\"/>;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@element-params and not (@element-params like '--%')\">\n"
"  control.ufl_element_params := <xsl:apply-templates select=\"@element-params\" mode=\"static_value\"/>;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@element-update-params and not (@element-update-params like '--%')\">\n"
"  control.ufl_element_update_params := <xsl:apply-templates select=\"@element-update-params\" mode=\"static_value\"/>;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@element-path and not (@element-path like '--%')\">\n"
"  control.ufl_element_path := <xsl:apply-templates select=\"@element-path\" mode=\"static_value\"/>;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@element-update-path and not (@element-update-path like '--%')\">\n"
"  control.ufl_element_update_path := <xsl:apply-templates select=\"@element-update-path\" mode=\"static_value\"/>;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@element-place and not (@element-place like '--%')\">\n"
"  control.ufl_element_place := <xsl:apply-templates select=\"@element-place\" mode=\"static_value\"/>;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@null-value\">\n"
"  control.ufl_null_value := <xsl:apply-templates select=\"@null-value\" mode=\"static_value\"/>;\n"
"  </xsl:if>\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"@instantiate[. like '--%']\">\n"
"  if (control.vc_instantiate &lt; 0)\n"
"    control.vc_instantiate := <xsl:apply-templates select=\"@instantiate\" mode=\"value\"/>;\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@instantiate = '0'\">\n"
"  if (control.vc_instantiate &lt; 0)\n"
"    control.vc_instantiate := 0;\n"
"    </xsl:when>\n"
"    <xsl:otherwise>\n"
"      control.vc_instantiate := 1;\n"
"    </xsl:otherwise>\n"
"  </xsl:choose>\n"
"  <xsl:if test=\"@instantiate\">\n"
"  if (not control.vc_instantiate)\n"
"    {\n"
"      control.vc_enabled := 0;\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%init%']\">control.vc_debug_log_endgroup (_debug_log_id, 'break', 'vc_init_...() has set vc_instantiate to zero', null); -- debug-log code</xsl:if>\n"
"      return;\n"
"    }\n"
"  </xsl:if>\n"
"  control.vc_attributes := vector (\n"
"    <xsl:for-each select=\"v:data-binding\">\n"
"    vspx_attribute ('<xsl:value-of select=\"@attr-name\" />', control),\n"
"    </xsl:for-each>\n"
"    <xsl:for-each select=\"@*[starts-with(name(), 'xhtml_')]\">\n"
"    vspx_attribute ('<xsl:value-of select=\"substring-after (local-name(), 'xhtml_')\" />', control),\n"
"    </xsl:for-each>\n"
"    NULL);\n"
"\n"
"  <xsl:if test=\"local-name () != 'data-set'\n"
"        and local-name () != 'data-grid'\n"
"        and local-name () != 'tab'\n"
"        and local-name () != 'login'\n"
"        and local-name () != 'vscx'\n"
"        and not (local-name ()='button' and @action='return') \">\n"
"  control.vc_children := vector (\n"
"       <xsl:apply-templates select=\"*\" mode=\"form_childs_init\" />\n"
"       NULL\n"
"       );\n"
"  </xsl:if>\n"
"  <xsl:apply-templates select=\".\" mode=\"init_method\" />\n"
"\n"
"  <!-- bellow was only for :\n"
"       .//v:field[@value]|\n"
"       .//v:button[@action='return']|\n"
"       .//v:text|.//v:textarea|\n"
"       .//v:button[@action='simple']|\n"
"       .//v:label|\n"
"       .//v:url|\n"
"       .//v:check-box|\n"
"       .//v:update-field|\n"
"       .//v:button[@action='submit']|\n"
"       .//v:radio-button|\n"
"       .//v:browse-button|\n"
"       .//v:template[@type='simple']|\n"
"       .//v:template[@type='input']|\n"
"       .//v:template[@type='result']|\n"
"       .//v:template[@type='error']|\n"
"       .//v:button[@action='logout']\"\n"
"  -->\n"
"  <xsl:if test=\"count (v:validator[string(@runat) != 'client'][@test != 'sql']) > 0\">\n"
"  {\n"
"     declare validators any;\n"
"     validators := make_array (<xsl:value-of select=\"count (v:validator[string(@runat) != 'client'][@test != 'sql'])\"/>, 'any');\n"
"       <xsl:for-each select=\"v:validator[string(@runat) != 'client'][@test != 'sql']\">\n"
"         {\n"
"           declare vldt vspx_range_validator;\n"
"           vldt := new vspx_range_validator ();\n"
"           <xsl:if test=\"@test != 'regexp'\">\n"
"           vldt.vr_min := <xsl:value-of select=\"@min\"/>;\n"
"           vldt.vr_max := <xsl:value-of select=\"@max\"/>;\n"
"       </xsl:if>\n"
"           vldt.vv_test := '<xsl:value-of select=\"@test\"/>';\n"
"           <xsl:if test=\"@test = 'regexp'\">\n"
"           vldt.vv_expr := '<xsl:value-of select=\"@regexp\"/>';\n"
"           </xsl:if>\n"
"           <xsl:if test=\"@empty-allowed\">\n"
"       vldt.vv_empty_allowed := <xsl:value-of select=\"@empty-allowed\"/>;\n"
"           </xsl:if>\n"
"	   vldt.vv_message := '<xsl:apply-templates select=\"@message\" mode=\"escaped_string\"/>';\n"
"           aset (validators, <xsl:value-of select=\"position()-1\" />, vldt);\n"
"         }\n"
"       </xsl:for-each>\n"
"     control.ufl_validators := validators;\n"
"  }\n"
"  </xsl:if>\n"
"  <xsl:if test=\"count (v:validator[@runat = 'client'][@test != 'sql']) > 0\">\n"
"  control.ufl_client_validate := <xsl:value-of select=\"count (v:validator[@runat = 'client'][@test != 'sql'])\" />;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@column != ''\">\n"
"  control.ufl_column := <xsl:apply-templates select=\"@column\" mode=\"static_value\"/>;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@error-glyph != ''\">\n"
"  control.ufl_error_glyph := <xsl:apply-templates select=\"@error-glyph\" mode=\"static_value\"/>;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"string-length(normalize-space(@fmt-function)) > 0\">\n"
"  control.ufl_fmt_fn := <xsl:apply-templates select=\"@fmt-function\" mode=\"static_value\"/>;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"string-length(normalize-space(@cvt-function)) > 0\">\n"
"  control.ufl_cvt_fn := <xsl:apply-templates select=\"@cvt-function\" mode=\"static_value\"/>;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@initial-checked and not @initial-checked like '--%'\"> <!-- this must be reset when post -->\n"
"  control.ufl_selected := <xsl:apply-templates select=\"@initial-checked\" mode=\"value\"/>;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@auto-submit and not @auto-submit like '--%'\">\n"
"  control.ufl_auto_submit := <xsl:apply-templates select=\"@auto-submit\" mode=\"value\"/>;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@group-name != ''\">\n"
"  control.ufl_group := <xsl:apply-templates select=\"@group-name\" mode=\"static_value\"/>;\n"
"  </xsl:if>\n"
"  <!-- if control is in repeater, then view state will not be restored on initial call\n"
"   in page constructor, then this should be set on instantiation.\n"
"  -->\n"
"  <xsl:if test=\"local-name(.) != 'vscx'\">\n"
"  if (self.vc_event.ve_is_post and control.vc_control_state is null)\n"
"    {\n"
"      control.vc_set_view_state (self.vc_event);\n"
"    }\n"
"  </xsl:if>\n"
"  <xsl:for-each select=\"key('on-init',@name)\">\n"
"    <xsl:value-of select=\".\" />\n"
"  if (not control.vc_enabled)\n"
"    {\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%init%']\">control.vc_debug_log_endgroup (_debug_log_id, 'break', 'vc_init_...() has set vc_enabled to zero', null); -- debug-log code</xsl:if>\n"
"      return;\n"
"    }\n"
"  </xsl:for-each>\n"
"  control.vc_invoke_handlers ('on-init');\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%init%']\">control.vc_debug_log_endgroup (_debug_log_id, 'end', 'vc_init_...()', null); -- debug-log code</xsl:if>\n"
"}\n"
";\n", 
"</xsl:for-each>\n"
"\n"
"<xsl:for-each select=\"$custom-controls-set\">\n"
"create method vcc_init_<xsl:value-of select=\"@name\" /> (in name varchar, inout parent vspx_control) for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"  <xsl:variable name=\"class_name\" select=\"v:vcc_class_name (name ())\"/>\n"
"  declare control <xsl:value-of select=\"$class_name\"/>;\n"
"  control := <xsl:value-of select=\"$class_name\"/> ();\n"
"  control.vc_name := name;\n"
"  control.vc_page := self;\n"
"  control.vc_parent := parent;\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%init%']\">declare _debug_log_id integer; _debug_log_id := control.vc_debug_log ('begin', 'vcc_init_...()', null); -- debug-log code</xsl:if>\n"
"  -- The code below is created by v:vcc_instantiate() for control name '<xsl:value-of select=\"name()\"/>':\n"
"  <xsl:value-of select=\"v:vcc_instantiate (name (), .)\" />\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%init%']\">control.vc_debug_log_endgroup (_debug_log_id, 'end', 'vcc_init_...()', null); -- debug-log code</xsl:if>\n"
"  return control;\n"
"}\n"
";\n", 
"</xsl:for-each>\n"
"\n"
"<!-- DATA-BIND -->\n"
"  -- DATA-BIND methods\n"
"<xsl:for-each select=\"$bindable-controls-set\">\n"
"create method vc_data_bind_<xsl:value-of select=\"@name\" /> (inout control <xsl:value-of select=\"@control-udt\"/> , inout e vspx_event) for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"  --no_c_escapes-\n"
"  declare path, params, lines any;\n"
"  <xsl:if test=\"@enabled[. like '--%']\">\n"
"  control.vc_enabled := <xsl:apply-templates select=\"@enabled\" mode=\"value\"/>;\n"
"  </xsl:if>\n"
"  if (not control.vc_enabled)\n"
"    {\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%data-bind%']\">control.vc_debug_log ('skip', 'vc_data_bind_...() has no effect because vc_enabled is zero', null); -- debug-log code</xsl:if>\n"
"      return 1;\n"
"    }\n"
"  path := e.ve_path;\n"
"  params := e.ve_params;\n"
"  lines := e.ve_lines;\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%init%']\">declare _debug_log_id integer; _debug_log_id := control.vc_debug_log ('begin', 'vc_data_bind_...()', null); -- debug-log code</xsl:if>\n"
"  <xsl:if test=\".=$initable-controls-set\">\n"
"   if (not control.vc_instantiate)\n"
"     {\n"
"       control.vc_instantiate := 1;\n"
"       self.vc_init_<xsl:value-of select=\"@name\" /> (control, control.vc_parent);\n"
"       if (self.vc_page.vc_is_postback and e.ve_button is null)\n"
"         self.vc_get_focus (e);\n"
"     }\n"
"  </xsl:if>\n"
"  <!--xsl:if test=\"@initial-checked != ''\">\n"
"  if (e.ve_is_post)\n"
"    control.ufl_selected := 0;\n"
"  </xsl:if-->\n"
"  <xsl:if test=\"key('before-data-bind',@name)\">\n"
"-- v:before-data-bind controls:\n"
"    <xsl:for-each select=\"key('before-data-bind',@name)\">\n"
"      <xsl:value-of select=\".\" />\n"
"  if (not control.vc_enabled)\n"
"    {\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%data-bind%']\">control.vc_debug_log_endgroup (_debug_log_id, 'break', 'vc_data_bind_...() exits because event handler has set vc_enabled is zero', null); -- debug-log code</xsl:if>\n"
"      return;\n"
"    }\n"
"    </xsl:for-each>\n"
"  </xsl:if>\n"
"  <xsl:for-each select=\"v:param\">\n"
"  declare <xsl:value-of select=\"@name\" /> any;\n"
"  </xsl:for-each>\n"
"  <xsl:for-each select=\"v:param\">\n"
"    <xsl:value-of select=\"@name\" /> := <xsl:apply-templates select=\"@value\" mode=\"value\" />;\n"
"  </xsl:for-each>\n"
"  <xsl:for-each select=\"v:data-binding\">\n"
"  control.vc_set_attribute('<xsl:value-of select=\"@attr-name\"/>', <xsl:apply-templates select=\"@attr-value\" mode=\"value\"/>);\n"
"  </xsl:for-each>\n"
"-- Databound fields of the control:\n"
"  <xsl:apply-templates select=\"@element-path[. like '--%']\" mode=\"field_value\"/>\n"
"  <xsl:apply-templates select=\"@element-update-path[. like '--%']\" mode=\"field_value\"/>\n"
"  <xsl:apply-templates select=\"@element-place[. like '--%']\" mode=\"field_value\"/>\n"
"  <xsl:apply-templates select=\"@element-value[. like '--%']\" mode=\"field_value\"/>\n"
"  <xsl:apply-templates select=\"@element-params[. like '--%']\" mode=\"field_value\"/>\n"
"  <xsl:apply-templates select=\"@element-update-params[. like '--%']\" mode=\"field_value\"/>\n"
"  <xsl:apply-templates select=\"@value[. like '--%']\" mode=\"field_value\"/>\n"
"  <xsl:if test=\"@element-value and not (@value)\">\n"
"  <!-- dbg_obj_print ('ufl_value, ufl_element_value, ufl_element_path before vc_get_value_from_element:', control.ufl_value, control.ufl_element_value, control.ufl_element_path); -->\n"
"  if (control.ufl_value is null)\n"
"    (control as vspx_field_value).vc_get_value_from_element();\n"
"  <!--\n"
"  else\n"
"    dbg_obj_print ('ufl_value is not set by vc_get_value_from_element:', control.ufl_value);\n"
"  -->\n"
"  </xsl:if>\n"
"  <xsl:for-each select=\"@defvalue[. like '--%']\">\n"
"  if (control.ufl_value is null)\n"
"    <xsl:apply-templates select=\".\" mode=\"field_value\"/>\n"
"  </xsl:for-each>\n"
"  <xsl:for-each select=\"@*[not starts-with(name(), 'xhtml_')][. like '--%'][local-name()!='enabled'][local-name()!='initial-enable'][local-name()!='value'][local-name()!='defvalue'][local-name()!='element-value'][local-name()!='element-path'][local-name()!='element-params'][local-name()!='element-update-path'][local-name()!='element-update-params'][local-name()!='element-place']\">\n"
"  <xsl:variable name=\"fldname\"><xsl:call-template name=\"attr_name\" /></xsl:variable>\n"
"  <xsl:if test=\"not ($fldname='')\">\n"
"  <xsl:if test=\"starts-with(local-name(), 'initial-')\">if (not e.ve_is_post) {</xsl:if>\n"
"  control.<xsl:value-of select=\"$fldname\" /> := <xsl:apply-templates select=\".\" mode=\"value\"/>;\n"
"  <xsl:if test=\"starts-with(local-name(), 'initial-')\">}</xsl:if>\n"
"  </xsl:if>\n"
"  </xsl:for-each>\n"
"-- Databound HTML attributes:\n"
"   <xsl:for-each select=\"@*[starts-with(name(), 'xhtml_')]\">\n"
"   <xsl:variable name=\"attr-name\" select=\"substring-after (local-name(), 'xhtml_')\" />\n"
"   <xsl:choose>\n"
"   <xsl:when test=\". like '--%'\">\n"
"   control.vc_set_attribute ('<xsl:value-of select=\"$attr-name\"/>', <xsl:apply-templates select=\".\" mode=\"value\"/>);\n"
"   </xsl:when>\n"
"   <xsl:otherwise>\n"
"   control.vc_set_attribute ('<xsl:value-of select=\"$attr-name\"/>', <xsl:apply-templates select=\".\" mode=\"static_value\"/>);\n"
"   </xsl:otherwise>\n"
"   </xsl:choose>\n"
"   </xsl:for-each>\n"
"  <xsl:apply-templates select=\".\" mode=\"data_bind_method\" />\n"
"&LINE;\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%data-bind%']\">control.vc_debug_log_endgroup (_debug_log_id, 'end', 'vc_data_bind_...()', null); -- debug-log code</xsl:if>\n"
"}\n"
";\n", 
"\n"
"</xsl:for-each>\n"
"\n"
"<xsl:for-each select=\"$after-data-bind-set\">\n"
"create method vc_after_data_bind_<xsl:value-of select=\"@name\" /> (inout control <xsl:value-of select=\"@control-udt\"/> , inout e vspx_event) for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"  --no_c_escapes-\n"
"  declare path, params, lines any;\n"
"\n"
"  if (not control.vc_enabled)\n"
"    return;\n"
"  path := e.ve_path;\n"
"  params := e.ve_params;\n"
"  lines := e.ve_lines;\n"
"  <xsl:for-each select=\"key('after-data-bind',@name)\"><xsl:value-of select=\".\" /></xsl:for-each>\n"
"}\n"
";\n", 
"\n"
"</xsl:for-each>\n"
"\n"
"<xsl:for-each select=\"$scrollable-controls-set\">\n"
"create method vc_scroll_<xsl:value-of select=\"@name\" /> (inout control <xsl:value-of select=\"@control-udt\"/> , in new_rows_offs integer, inout e vspx_event) for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"  <xsl:apply-templates select=\".\" mode=\"scroll_cursor_declaration\" />\n"
"  <xsl:apply-templates select=\".\" mode=\"scroll_code\" />\n"
"}\n"
";\n", 
"</xsl:for-each>\n"
"\n"
"<!-- STANDARD POST methods -->\n"
"<xsl:for-each select=\"$standard-post-set\">\n"
"create method vc_post_<xsl:value-of select=\"@name\" /> (inout control <xsl:value-of select=\"@control-udt\"/>, inout e vspx_event) for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"  --no_c_escapes-\n"
"  <!--\n"
"-#-!!  declare exit handler for sqlstate '*'\n"
"-#-!!    {\n"
"-#-!!       self.vc_is_valid := 0;\n"
"-#-!!       control.vc_error_message := concat (__SQL_MESSAGE, ' in v:<xsl:value-of select=\"local-name()\" /> \"<xsl:value-of select=\"@name\" />\" (post)');\n"
"-#-!!       return;\n"
"-#-!!    };\n"
"  -->\n"
"  declare path, params, lines any;\n"
"  path := e.ve_path;\n"
"  params := e.ve_params;\n"
"  lines := e.ve_lines;\n"
"  <xsl:choose>\n"
"  <xsl:when test=\"local-name() = 'radio-button' and ancestor::v:radio-group\">\n"
"  if(0 = control.vc_parent.vc_parent.vc_focus or not e.ve_is_post) {\n"
"    return;\n"
"  }\n"
"  </xsl:when>\n"
"  <xsl:otherwise>\n"
"  if(udt_instance_of (control, fix_identifier_case ('vspx_field')) and\n"
"      0 = control.vc_parent.vc_focus or not e.ve_is_post) {\n"
"    return;\n"
"  }\n"
"  </xsl:otherwise>\n"
"  </xsl:choose>\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%post%']\">declare _debug_log_id integer; _debug_log_id := control.vc_debug_log ('begin', 'vc_post_...()', null); -- debug-log code</xsl:if>\n"
"  <xsl:apply-templates select=\".\" mode=\"system_post\" />\n"
"  <xsl:apply-templates select=\".\" mode=\"simple_validators\" />\n"
"  <xsl:apply-templates select=\"v:validator[string(@runat) != 'client']\" mode=\"validate\" />\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%post%']\">control.vc_debug_log_endgroup (_debug_log_id, 'end', 'vc_post_...()', null); -- debug-log code</xsl:if>\n"
"}\n"
";\n", 
"</xsl:for-each>\n"
"\n"
"<!-- USER POST methods -->\n"
"<xsl:for-each select=\"$user-post-set\">\n"
"create method vc_user_post_<xsl:value-of select=\"@name\" /> (inout control <xsl:value-of select=\"@control-udt\"/>, inout e vspx_event) for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"  --no_c_escapes-\n"
"<!--\n"
"-#-!!  declare exit handler for sqlstate '*'\n"
"-#-!!    {\n"
"-#-!!       self.vc_is_valid := 0;\n"
"-#-!!       control.vc_error_message := concat (__SQL_MESSAGE, ' in v:<xsl:value-of select=\"local-name()\" /> \"<xsl:value-of select=\"@name\" />\" (post)');\n"
"-#-!!       return;\n"
"-#-!!    };\n"
"  -->\n"
"  declare path, params, lines any;\n"
"  path := e.ve_path;\n"
"  params := e.ve_params;\n"
"  lines := e.ve_lines;\n"
"  <xsl:choose>\n"
"  <xsl:when test=\"local-name() = 'radio-button' and ancestor::v:radio-group\">\n"
"  if (0 = control.vc_parent.vc_parent.vc_focus or not e.ve_is_post)\n"
"    return;\n"
"  </xsl:when>\n"
"  <xsl:otherwise>\n"
"  if (udt_instance_of (control, fix_identifier_case ('vspx_field')) and\n"
"    0 = control.vc_parent.vc_focus or not e.ve_is_post)\n"
"    {\n"
"      <!-- dbg_obj_print ('No user post: no focus on', control.vc_name, control.vc_parent.vc_name); -->\n"
"      return;\n"
"    }\n"
"  </xsl:otherwise>\n"
"  </xsl:choose>\n"
"  <xsl:if test=\"key('on-post',@name)\">\n"
" {\n"
"   declare form vspx_form;\n"
"   form := null;\n"
"   if(udt_instance_of (control, fix_identifier_case ('vspx_field'))\n"
"      and not udt_instance_of (control, fix_identifier_case ('vspx_button'))) {\n"
"      form := control.vc_find_parent_form (control);\n"
"   }\n"
"   if(control.vc_focus or (form is not null and form.vc_focus)) {\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%post%']\">declare _debug_log_id integer; _debug_log_id := control.vc_debug_log ('begin', 'vc_user_post_...()', null); -- debug-log code</xsl:if>\n"
"  <xsl:for-each select=\"key('on-post',@name)\"><xsl:value-of select=\".\" /></xsl:for-each>\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%post%']\">control.vc_debug_log_endgroup (_debug_log_id, 'end', 'vc_user_post_...()', null); -- debug-log code</xsl:if>\n"
"   }\n"
" }\n"
"</xsl:if>\n"
"}\n"
";\n", 
"</xsl:for-each>\n"
"\n"
"<!-- ACTIONS methods -->\n"
"<xsl:for-each select=\"$standard-post-set\">\n"
"create method vc_action_<xsl:value-of select=\"@name\" /> (inout control <xsl:value-of select=\"@control-udt\"/>, inout e vspx_event) for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"  --no_c_escapes-\n"
"  <!--\n"
"-#-!!  declare exit handler for sqlstate '*'\n"
"-#-!!    {\n"
"-#-!!       self.vc_is_valid := 0;\n"
"-#-!!       control.vc_error_message := concat (__SQL_MESSAGE, ' in v:<xsl:value-of select=\"local-name()\" /> \"<xsl:value-of select=\"@name\" />\" (post)');\n"
"-#-!!       return;\n"
"-#-!!    };\n"
"  -->\n"
"  declare path, params, lines any;\n"
"  path := e.ve_path;\n"
"  params := e.ve_params;\n"
"  lines := e.ve_lines;\n"
"  <xsl:choose>\n"
"  <xsl:when test=\"local-name() = 'radio-button' and ancestor::v:radio-group\">\n"
"  if (0 = control.vc_parent.vc_parent.vc_focus or not e.ve_is_post)\n"
"    return;\n"
"  </xsl:when>\n"
"  <xsl:otherwise>\n"
"  if (udt_instance_of (control, fix_identifier_case ('vspx_field')) and\n"
"    0 = control.vc_parent.vc_focus or not e.ve_is_post)\n"
"    return;\n"
"  </xsl:otherwise>\n"
"  </xsl:choose>\n"
"  <!--\n"
"  <xsl:apply-templates select=\"v:validator[string(@runat) != 'client']\" mode=\"validate\" />\n"
"  <xsl:apply-templates select=\"$editable-controls-set\" mode=\"simple_validators\" />\n"
"  -->\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%post%']\">declare _debug_log_id integer; _debug_log_id := control.vc_debug_log ('begin', 'vc_action_...()', null); -- debug-log code</xsl:if>\n"
"  <xsl:apply-templates select=\".\" mode=\"action_method\" />\n"
"<xsl:if test=\"ancestor-or-self::v:*/@debug-log[$debug_on][. like '%post%']\">control.vc_debug_log_endgroup (_debug_log_id, 'end', 'vc_action_...()', null); -- debug-log code</xsl:if>\n"
"}\n"
";\n", 
"</xsl:for-each>\n"
"\n"
"<!-- RENDER -->\n"
"<xsl:for-each select=\".//v:data-set|.//v:data-grid|.//v:form[@type='update']|.//v:form[@type='simple']|.//v:select-list|.//v:data-list|.//v:login|.//v:tree|.//v:tab|.//v:isql|.//v:calendar|.//v:vscx\">\n"
"create method vc_render_<xsl:value-of select=\"@name\" /> (inout control <xsl:value-of select=\"@control-udt\"/>) for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"  declare exit handler for sqlstate '*'\n"
"    {\n"
"      http ('&lt;pre&gt;');\n"
"      http_value (__SQL_STATE);\n"
"      http_value (__SQL_MESSAGE);\n"
"      http (' in v:<xsl:value-of select=\"local-name()\" /> \"<xsl:value-of select=\"@name\" />\" (render)');\n"
"      http ('&lt;/pre&gt;');\n"
"      return;\n"
"    };\n"
"  if (control is null or control.vc_children is null or not control.vc_enabled)\n"
"    return;\n"
"  <xsl:apply-templates select=\".\" mode=\"render_method\" />\n"
"}\n"
";\n", 
"</xsl:for-each>\n"
"\n"
"\n"
"<xsl:for-each select=\".//v:template[@name and @type != 'frame' and @type != 'if-login' and @type != 'if-no-login']|.//v:radio-group\">\n"
"  <xsl:apply-templates select=\".\" mode=\"render_method\" />\n"
"</xsl:for-each>\n"
"<!-- eof RENDER -->\n"
"\n"
"<!-- SET_VIEW_STATE -->\n"
"\n"
"<xsl:for-each select=\"$statable-controls-set\">\n"
"create method vc_set_view_state_<xsl:value-of select=\"@name\" /> (inout control <xsl:value-of select=\"@control-udt\"/> , inout e vspx_event) for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"  <xsl:apply-templates select=\".\" mode=\"set_view_state_method\" />\n"
"}\n"
";\n", 
"\n"
"</xsl:for-each>\n"
"\n"
"  <xsl:for-each select=\".//v:tree\">\n"
"  <xsl:apply-templates select=\".\" mode=\"node_data_bind_method\" />\n"
"  <xsl:apply-templates select=\".\" mode=\"node_render_method\" />\n"
"  </xsl:for-each>\n"
"\n"
"  <xsl:for-each select=\".//v:*[v:validator[@test='sql' and not @expression]]\">\n"
"  <xsl:apply-templates select=\".\" mode=\"validator_handler\" />\n"
"  </xsl:for-each>\n"
"\n"
"  <!-- pre-render method for all known -->\n"
"  <xsl:for-each select=\"$before-render-set\">\n"
"create method vc_pre_render_<xsl:value-of select=\"@name\" /> (inout control <xsl:value-of select=\"@control-udt\"/>) for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"  if (not control.vc_enabled)\n"
"    return;\n"
"  <xsl:for-each select=\"key('before-render',@name)\"><xsl:value-of select=\".\" /></xsl:for-each>\n"
"}\n"
";\n", 
"  </xsl:for-each>\n"
"\n"
"<xsl:call-template name=\"page_render_method\" />\n"
"</xsl:template> <!-- eof v:page template -->\n"
"\n"
"<!--\n"
"  Any existing data-bound attributes\n"
";\n", 
"-->\n"
"<xsl:template name=\"attr_name\">\n"
"<xsl:variable name=\"n\" select=\"local-name()\"/>\n"
"<xsl:choose>\n"
"   <xsl:when test=\"$n = 'active'\">ufl_active</xsl:when>\n"
"   <xsl:when test=\"$n = 'auto-submit'\">ufl_auto_submit</xsl:when>\n"
"   <xsl:when test=\"$n = 'data'\">\n"
"      <xsl:choose>\n"
"        <xsl:when test=\"parent::v:data-set\">ds_row_data</xsl:when>\n"
"        <xsl:when test=\"parent::v:data-grid\">dg_row_data</xsl:when>\n"
"      </xsl:choose>\n"
"   </xsl:when>\n"
"   <xsl:when test=\"$n = 'edit'\">\n"
"      <xsl:choose>\n"
"        <xsl:when test=\"parent::v:data-set\">ds_editable</xsl:when>\n"
"        <xsl:when test=\"parent::v:data-grid\">dg_editable</xsl:when>\n"
"      </xsl:choose>\n"
"   </xsl:when>\n"
"   <xsl:when test=\"$n = 'enabled'\">vc_enabled</xsl:when>\n"
"   <xsl:when test=\"$n = 'initial-date'\">cal_date</xsl:when>\n"
"   <xsl:when test=\"$n = 'maxrows'\">isql_maxrows</xsl:when>\n"
"   <xsl:when test=\"$n = 'meta'\">\n"
"      <xsl:choose>\n"
"        <xsl:when test=\"parent::v:data-set|parent::v:data-source\">ds_row_meta</xsl:when>\n"
"        <xsl:when test=\"parent::v:data-grid\">dg_row_meta</xsl:when>\n"
"      </xsl:choose>\n"
"   </xsl:when>\n"
"   <xsl:when test=\"$n = 'password'\">isql_password</xsl:when>\n"
"   <xsl:when test=\"$n = 'timeout'\">isql_timeout</xsl:when>\n"
"   <xsl:when test=\"$n = 'url'\">\n"
"   <xsl:choose>\n"
"     <xsl:when test=\"parent::v:url\">vu_url</xsl:when>\n"
"     <xsl:when test=\"parent::v:button\">bt_url</xsl:when>\n"
"   </xsl:choose>\n"
"   </xsl:when>\n"
"   <xsl:when test=\"$n = 'user'\">isql_user</xsl:when>\n"
"   <xsl:when test=\"$n = 'value'\">ufl_value</xsl:when>\n"
"   <xsl:when test=\"$n = 'defvalue'\">ufl_value</xsl:when>\n"
"   <xsl:when test=\"$n = 'element-value'\">ufl_element_value</xsl:when>\n"
"   <xsl:when test=\"$n = 'element-place'\">ufl_element_place</xsl:when>\n"
"   <xsl:when test=\"$n = 'element-path'\">ufl_element_path</xsl:when>\n"
"   <xsl:when test=\"$n = 'element-params'\">ufl_element_params</xsl:when>\n"
"   <xsl:when test=\"$n = 'element-update-path'\">ufl_element_update_path</xsl:when>\n"
"   <xsl:when test=\"$n = 'element-update-params'\">ufl_element_update_params</xsl:when>\n"
"   <xsl:when test=\"$n = 'default_value'\">tf_default</xsl:when>\n"
"   <xsl:when test=\"$n = 'action'\">uf_action</xsl:when>\n"
"   <xsl:when test=\"$n = 'browser-filter'\">vcb_filter</xsl:when>\n"
"   <xsl:when test=\"$n = 'browser-list'\">vcb_list_mode</xsl:when>\n"
"   <xsl:when test=\"$n = 'browser-mode'\">vcb_browser_mode</xsl:when>\n"
"   <xsl:when test=\"$n = 'browser-options'\">vcb_browser_options</xsl:when>\n"
"   <xsl:when test=\"$n = 'browser-type'\">vcb_system</xsl:when>\n"
"   <xsl:when test=\"$n = 'browser-xfer'\">vcb_xfer</xsl:when>\n"
"   <!--xsl:when test=\"$n = 'child-function'\"></xsl:when-->\n"
"   <xsl:when test=\"$n = 'child-window-options'\">vcb_chil_options</xsl:when>\n"
"   <xsl:when test=\"$n = 'column'\">ufl_column</xsl:when>\n"
"   <!--xsl:when test=\"$n = 'cursor-type'\"></xsl:when-->\n"
"   <xsl:when test=\"$n = 'cvt-function'\">ufl_cvt_fn</xsl:when>\n"
"   <xsl:when test=\"$n = 'error-glyph'\">ufl_error_glyph</xsl:when>\n"
"   <xsl:when test=\"$n = 'fmt-function'\">ufl_fmt_fn</xsl:when>\n"
"   <xsl:when test=\"$n = 'format'\">\n"
"   <xsl:choose>\n"
"     <xsl:when test=\"parent::v:url\">vu_format</xsl:when>\n"
"     <xsl:when test=\"parent::v:label\">vl_format</xsl:when>\n"
"   </xsl:choose>\n"
"   </xsl:when>\n"
"   <xsl:when test=\"$n = 'group-name'\">ufl_group</xsl:when>\n"
"   <xsl:when test=\"$n = 'initial-active'\">ufl_active</xsl:when>\n"
"   <xsl:when test=\"$n = 'initial-checked'\">ufl_selected</xsl:when>\n"
"   <xsl:when test=\"$n = 'true-value'\">ufl_true_value</xsl:when>\n"
"   <xsl:when test=\"$n = 'false-value'\">ufl_false_value</xsl:when>\n"
"   <xsl:when test=\"$n = 'isolation'\">isql_isolation</xsl:when>\n"
"   <!--xsl:when test=\"$n = 'method'\"></xsl:when-->\n"
"   <xsl:when test=\"$n = 'name-suffix'\">ufl_name_suffix</xsl:when>\n"
"   <xsl:when test=\"$n = 'nrows'\">\n"
"      <xsl:choose>\n"
"        <xsl:when test=\"parent::v:data-set|parent::v:data-source\">ds_nrows</xsl:when>\n"
"        <xsl:when test=\"parent::v:data-grid\">dg_nrows</xsl:when>\n"
"      </xsl:choose>\n"
"   </xsl:when>\n"
"   <xsl:when test=\"$n = 'realm'\">vl_realm</xsl:when>\n"
"   <xsl:when test=\"$n = 'scrollable'\">\n"
"      <xsl:choose>\n"
"        <xsl:when test=\"parent::v:data-set\">ds_scrollable</xsl:when>\n"
"        <xsl:when test=\"parent::v:data-grid\">dg_scrollable</xsl:when>\n"
"      </xsl:choose>\n"
"   </xsl:when>\n"
"   <xsl:when test=\"$n = 'expression'\">vv_expr</xsl:when>\n"
"   <xsl:when test=\"$n = 'sql'\">ds_sql</xsl:when>\n"
"   <xsl:when test=\"$n = 'style'\">\n"
"      <xsl:choose>\n"
"        <xsl:when test=\"parent::v:button\">bt_style</xsl:when>\n"
"        <xsl:when test=\"parent::v:tab\">tb_style</xsl:when>\n"
"      </xsl:choose>\n"
"   </xsl:when>\n"
"   <xsl:when test=\"$n = 'user-password'\">vl_pwd_get</xsl:when>\n"
"   <xsl:when test=\"$n = 'user-password-check'\">vl_usr_check</xsl:when>\n"
"   <xsl:when test=\"$n = 'type'\">tf_style</xsl:when>\n"
"   <xsl:when test=\"$n = 'initial-offset'\">ds_rows_offs</xsl:when>\n"
"   <xsl:when test=\"$n = 'data-source'\">ds_data_source</xsl:when>\n"
"   <xsl:when test=\"$n = 'selector'\">vcb_selector</xsl:when>\n"
"   <xsl:when test=\"$n = 'open-at'\">vt_open_at</xsl:when>\n"
"   <xsl:when test=\"$n = 'xpath-id'\">vt_xpath_id</xsl:when>\n"
"   <xsl:when test=\"$n = 'multiple'\">vsl_multiple</xsl:when>\n"
"   <xsl:when test=\"$n = 'list-document'\">vsl_list_document</xsl:when>\n"
"   <xsl:when test=\"$n = 'list-match'\">vsl_list_match</xsl:when>\n"
"   <xsl:when test=\"$n = 'list-key-path'\">vsl_list_key_path</xsl:when>\n"
"   <xsl:when test=\"$n = 'list-value-path'\">vsl_list_value_path</xsl:when>\n"
"   <xsl:otherwise></xsl:otherwise>\n"
"   </xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<xsl:template name=\"attr_static_assignment\">\n"
"  <xsl:variable name=\"lv\"><xsl:apply-templates select=\".\" mode=\"attr_name\"/></xsl:variable>\n"
"  <xsl:if test=\"not(.like'--%') and $lv\">\n"
"   control.<xsl:value-of select=\"$lv\"/> := <xsl:apply-templates select=\"@multiple\" mode=\"static_value\"/>;\n"
"  </xsl:if>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:form[@type='update']|v:form[@type='simple']\" mode=\"render_method\">\n"
"  --no_c_escapes-\n"
"  <xsl:variable name=\"httpmethod\">\n"
"     <xsl:choose>\n"
"  <xsl:when test=\"@method='POST'\">post</xsl:when><!-- XHTML 1.0 defines \"post\" and \"get\" -->\n"
"  <xsl:when test=\"@method='GET'\">get</xsl:when>\n"
"  <xsl:when test=\"not(@method)\">post</xsl:when>\n"
"  <xsl:otherwise>\n"
"    <xsl:message terminate=\"yes\">Attribute 'method' of VSPX control 'form' should be equal to either 'POST' (default) or 'GET', not to '<xsl:value-of select=\"@method\"/>'.</xsl:message>\n"
"  </xsl:otherwise>\n"
"      </xsl:choose>\n"
"  </xsl:variable>\n"
"  declare form <xsl:value-of select=\"@control-udt\"/>;\n"
"  form := control;\n"
"  form.uf_method := '<xsl:value-of select=\"$httpmethod\"/>';\n"
"  form.prologue_render (self.sid, self.realm, self.nonce);\n"
"  <xsl:text> ?&gt;</xsl:text>\n"
"     <xsl:apply-templates select=\"node()\"  mode=\"render_all\" />\n"
"  <xsl:text>&lt;?vsp </xsl:text>\n"
"  <xsl:text>form.epilogue_render ();</xsl:text>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:isql\" mode=\"render_method\">\n"
"  declare isql vspx_isql;\n"
"  declare i, l int;\n"
"  declare stmts any;\n"
"\n"
"\n"
"  isql := control;\n"
"  isql.prologue_render (self.sid, self.realm, self.nonce);\n"
"\n"
"  if (isql.isql_chunked)\n"
"    http_flush (1);\n"
"\n"
"  stmts := isql.isql_stmts;\n"
"  l := 0;\n"
"  if (isql.isql_chunked)\n"
"    l := length (stmts);\n"
"\n"
"  control.vc_render ('<xsl:value-of select=\"v:template[@type='input']/@name\" />');\n"
"  for (i := 0; i &lt; l; i := i + 1)\n"
"     {\n"
"       declare save_res any;\n"
"       isql.isql_current_stmt := stmts[i];\n"
"       isql.isql_current_state := isql.vc_error_message[i];\n"
"       isql.isql_current_meta := isql.isql_mtd[i];\n"
"       isql.isql_rows_fetched := 0;\n"
"       isql.isql_current_pos := i;\n"
"       save_res := isql.isql_res;\n"
"       if (isql.isql_current_state[0] = '00000')\n"
"         {\n"
"	   declare exit handler for sqlstate '*' {\n"
"             isql.isql_current_state := vector (__SQL_STATE, __SQL_MESSAGE);\n"
"	     goto render_error;\n"
"	   };\n"
"	   control.vc_render ('<xsl:value-of select=\"v:template[@type='result']/@name\" />');\n"
"	 }\n"
"       if (isql.isql_current_state[0] &lt;&gt; '00000')\n"
"         {\n"
"           render_error:\n"
"           declare templ_error vspx_control;\n"
"	   templ_error := control.vc_find_control ('<xsl:value-of select=\"v:template[@type='error']/@name\" />');\n"
"	   templ_error.vc_enabled := 1;\n"
"	   templ_error.vc_data_bind (self.vc_event);\n"
"           templ_error.vc_render ();\n"
"	 }\n"
"	isql.isql_res := save_res;\n"
"     }\n"
"  if (not isql.isql_chunked and l = 0)\n"
"    {\n"
"      control.vc_render ('<xsl:value-of select=\"v:template[@type='result']/@name\" />');\n"
"      control.vc_render ('<xsl:value-of select=\"v:template[@type='error']/@name\" />');\n"
"    }\n"
"  isql.epilogue_render ();\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:data-set\" mode=\"render_method\">\n"
"  --no_c_escapes-\n"
"  declare data_set vspx_data_set;\n"
"  declare i, rowi, rowl, l int;\n"
"  declare rows any;\n"
"  data_set := control;\n"
"<!--\n"
"  if(control.vc_error_message is not null) {\n"
"    http ('&lt;P&gt;');\n"
"    http (control.vc_error_message);\n"
"    http ('&lt;/P&gt;');\n"
"    } -->\n"
"  data_set.prologue_render (self.sid, self.realm, self.nonce);\n"
"  if(data_set.ds_rows_fetched) {\n"
"    <xsl:text> ?&gt;</xsl:text>\n"
"    <xsl:apply-templates select=\"*|@*\" mode=\"render_all\"/>\n"
"    <xsl:text>&lt;?vsp </xsl:text>\n"
"  }\n"
"  else {\n"
"    <xsl:text> ?&gt;</xsl:text>\n"
"    <xsl:apply-templates select=\"*|@*\" mode=\"render_all\"/>\n"
"    <xsl:text>&lt;?vsp </xsl:text>\n"
"  }\n"
"  data_set.epilogue_render ();\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:data-grid\" mode=\"render_method\">\n"
"  --no_c_escapes-\n"
"  declare data_grid vspx_data_grid;\n"
"  declare row_template vspx_row_template;\n"
"  data_grid := control;\n"
"  if (control.vc_error_message is not null)\n"
"    {\n"
"      http ('&lt;P&gt;');\n"
"      http (control.vc_error_message);\n"
"      http ('&lt;/P&gt;');\n"
"    }\n"
"  data_grid.prologue_render (self.sid, self.realm, self.nonce);\n"
"  declare i, rowi, rowl, l int;\n"
"  declare rows any;\n"
"\n"
"  if (data_grid.dg_rows_fetched)\n"
"    {\n"
"      <xsl:text> ?&gt;</xsl:text>\n"
"      <xsl:apply-templates select=\"v:template[@type='frame']\" mode=\"render_method\" />\n"
"      <xsl:text>&lt;?vsp </xsl:text>\n"
"    }\n"
"  else\n"
"    {\n"
"      <xsl:text> ?&gt;</xsl:text>\n"
"      <xsl:apply-templates select=\"v:template[@type='if-not-exists']\"  mode=\"render_all\" />\n"
"      <xsl:text>&lt;?vsp </xsl:text>\n"
"    }\n"
"  data_grid.epilogue_render ();\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:data-list|v:select-list\" mode=\"render_method\">\n"
"   control.vc_render ();\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:tab\" mode=\"render_method\">\n"
"   control.prologue_render (self.sid, self.realm, self.nonce);\n"
"   if (control.tb_style = 'list' or control.tb_style = 'radio')\n"
"    {\n"
"      declare sw vspx_control;\n"
"      sw := control.vc_find_control (concat (control.vc_name, '_switch'));\n"
"      sw.vc_render ();\n"
"    }\n"
"\n"
"   if (control.tb_active is not null)\n"
"     control.tb_active.vc_render ();\n"
"   control.epilogue_render ();\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:login\" mode=\"render_method\">\n"
"     declare login_control vspx_login;\n"
"     login_control := control;\n"
"     login_control.prologue_render (self.sid, self.realm, self.nonce);\n"
"      <xsl:text> ?&gt;</xsl:text>\n"
"      <xsl:apply-templates select=\"node()\"  mode=\"render_all\" />\n"
"      <xsl:text>&lt;?vsp </xsl:text>\n"
"     login_control.epilogue_render ();\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:tree\" mode=\"render_method\">\n"
"    declare chil vspx_control;\n"
"    declare tree vspx_tree;\n"
"    declare childs any;\n"
"    tree := control;\n"
"    declare i, len int;\n"
"    childs := null;\n"
"\n"
"    <xsl:if test=\"@orientation= 'horizontal'\">\n"
"    childs := vector ();\n"
"    </xsl:if>\n"
"\n"
"    <xsl:choose>\n"
"    <xsl:when test=\"@orientation='vertical'\">\n"
"    i := 0;\n"
"    len := length (control.vc_children);\n"
"    while (i &lt; len)\n"
"      {\n"
"         chil := control.vc_children [i];\n"
"         if (chil is not null and udt_instance_of (chil, fix_identifier_case ('vspx_tree_node')))\n"
"           self.vc_render_node_<xsl:value-of select=\"@name\" /> (chil, childs);\n"
"         i := i + 1;\n"
"      }\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@orientation='horizontal'\">\n"
"    declare chil_node vspx_control;\n"
"    chil_node := control;\n"
"    tree.vt_node := control;\n"
"    <xsl:text> ?&gt;</xsl:text>\n"
"      <xsl:apply-templates select=\"v:horizontal-template\" mode=\"render_all\" />\n"
"    <xsl:text>&lt;?vsp </xsl:text>\n"
"    i := 0; len := length (childs);\n"
"    while (i &lt; length (childs))\n"
"      {\n"
"        chil_node := childs[i];\n"
"        tree.vt_node := chil_node;\n"
"        <xsl:text> ?&gt;</xsl:text>\n"
"        <xsl:apply-templates select=\"v:horizontal-template\" mode=\"render_all\" />\n"
"        <xsl:text>&lt;?vsp </xsl:text>\n"
"        i := i + 1;\n"
"      }\n"
"    </xsl:when>\n"
"    </xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:tree\" mode=\"node_render_method\">\n"
"create method vc_render_node_<xsl:value-of select=\"@name\" /> (in control vspx_tree_node, inout childs any)\n"
"  for <xsl:value-of select=\"$vspx_full_class_name\" />\n"
"{\n"
"    declare chil vspx_tree_node;\n"
"    chil := control;\n"
"\n"
"    if (not control.vc_enabled)\n"
"      return;\n"
"\n"
"    if (chil is not null and chil.tn_is_leaf)\n"
"      {\n"
"        <xsl:text> ?&gt;</xsl:text>\n"
"    <xsl:choose>\n"
"    <xsl:when test=\"v:leaf-template\">\n"
"        <xsl:apply-templates select=\"v:leaf-template\"  mode=\"render_all\" />\n"
"    </xsl:when>\n"
"    <xsl:otherwise>\n"
"        <xsl:apply-templates select=\"v:node-template\"  mode=\"render_all\" />\n"
"    </xsl:otherwise>\n"
"    </xsl:choose>\n"
"        <xsl:text>&lt;?vsp </xsl:text>\n"
"      }\n"
"    else if (chil is not null)\n"
"      {\n"
"        <xsl:text> ?&gt;</xsl:text>\n"
"        <xsl:apply-templates select=\"v:node-template\"  mode=\"render_all\" />\n"
"        <xsl:text>&lt;?vsp </xsl:text>\n"
"    if (chil.tn_open and childs is not null)\n"
"      {\n"
"        childs := vector_concat (childs, vector (chil));\n"
"      }\n"
"   }\n"
"}\n"
";\n", 
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\" mode=\"node_render_method\"></xsl:template>\n"
"\n"
"\n"
"<xsl:template match=\"v:horizontal-template\" mode=\"render_all\">\n"
"   <xsl:apply-templates select=\"node()\" mode=\"render_all\"/>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:node-set\" mode=\"render_all\">\n"
"    <xsl:text>&lt;?vsp </xsl:text>\n"
"    {\n"
"        declare j, k int;\n"
"        j := 0; k := length (chil_node.vc_children);\n"
"        while (j &lt; k)\n"
"          {\n"
"            chil := chil_node.vc_children [j];\n"
"            if (chil is not null and udt_instance_of (chil, fix_identifier_case ('vspx_tree_node')))\n"
"              self.vc_render_node_<xsl:value-of select=\"ancestor::v:tree/@name\" /> (chil, childs);\n"
"            j := j + 1;\n"
"      }\n"
"    }\n"
"     <xsl:text> ?&gt;</xsl:text>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:node\" mode=\"render_all\">\n"
"    <xsl:if test=\"ancestor::v:tree/@orientation= 'vertical'\">\n"
"    <xsl:text>&lt;?vsp </xsl:text>\n"
"    if (chil is not null and chil.tn_open and not chil.tn_is_leaf)\n"
"      {\n"
"    declare i, l int;\n"
"        i := 0; l := length (chil.vc_children);\n"
"    while (i &lt; l)\n"
"          {\n"
"        declare own_chil vspx_control;\n"
"            own_chil := chil.vc_children [i];\n"
"            if (own_chil is not null and udt_instance_of (own_chil, fix_identifier_case ('vspx_tree_node')))\n"
"          self.vc_render_node_<xsl:value-of select=\"ancestor::v:tree/@name\" /> (own_chil, childs);\n"
"            i := i + 1;\n"
"      }\n"
"      }\n"
"    <xsl:text> ?&gt;</xsl:text>\n"
"    </xsl:if>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:isql\" mode=\"init_method\">\n"
"  control.isql_isolation := <xsl:apply-templates select=\"@isolation\" mode=\"static_value\"/>;\n"
"  control.isql_user := <xsl:apply-templates select=\"@user\" mode=\"static_value\"/>;\n"
"  <xsl:if test=\"@password\">\n"
"  control.isql_password := <xsl:apply-templates select=\"@password\" mode=\"static_value\"/>;\n"
"  </xsl:if>\n"
"  control.isql_timeout := <xsl:apply-templates select=\"@timeout\" mode=\"static_value\"/>;\n"
"  control.isql_maxrows := <xsl:apply-templates select=\"@maxrows\" mode=\"static_value\"/>;\n"
"\n"
"  declare templ_result vspx_template;\n"
"  declare templ_error vspx_template;\n"
"\n"
"  templ_result := control.vc_find_control ('<xsl:value-of select=\"v:template[@type='result']/@name\" />');\n"
"  templ_error := control.vc_find_control ('<xsl:value-of select=\"v:template[@type='error']/@name\" />');\n"
"\n"
"  templ_result.vc_enabled := 0;\n"
"  if (templ_error is not null)\n"
"    templ_error.vc_enabled := 0;\n"
"  control.isql_chunked := <xsl:value-of select=\"boolean (@mode='chunked')\"/>;\n"
"  <xsl:call-template name=\"inside_form\" />\n"
"</xsl:template>\n"
"\n"
"\n"
"<xsl:template match=\"v:template[@type='add']|v:template[@type='edit']\" mode=\"init_method\">\n"
"  <xsl:if test=\"not v:form[@type = 'update']\">\n"
"  control.vc_enabled := 0;\n"
"  </xsl:if>\n"
"</xsl:template>\n"
"\n"
"\n"
"<xsl:template match=\"v:isql\" mode=\"data_bind_method\">\n"
"</xsl:template>\n"
"\n"
"\n"
"<xsl:template match=\"v:login-form\" mode=\"render_all\">\n"
"    <xsl:text>&lt;?vsp </xsl:text>\n"
"    if (not login_control.vl_authenticated)\n"
"      {\n"
"       <xsl:choose>\n"
"       <xsl:when test=\"count (descendant::v:*) = 0 and boolean(number (@required))\">\n"
"        control.vc_find_control ('<xsl:value-of select=\"@name\" />').vc_render ();\n"
"       </xsl:when>\n"
"       <xsl:otherwise>\n"
"        declare login_form vspx_login_form;\n"
"        login_form := control.vc_find_control ('<xsl:value-of select=\"@name\" />');\n"
"       {\n"
"    declare control vspx_control;\n"
"        control := login_form;\n"
"        <xsl:text> ?&gt;</xsl:text>\n"
"       <xsl:apply-templates select=\"node()\"  mode=\"render_all\" />\n"
"        <xsl:text>&lt;?vsp </xsl:text>\n"
"       }\n"
"       </xsl:otherwise>\n"
"       </xsl:choose>\n"
"      }\n"
"    <xsl:text> ?&gt;</xsl:text>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:template[@type='if-no-login']\" mode=\"render_all\">\n"
"    <xsl:text>&lt;?vsp </xsl:text>\n"
"    if (not login_control.vl_authenticated)\n"
"      {\n"
"        <xsl:text> ?&gt;</xsl:text>\n"
"        <xsl:apply-templates select=\"node()\"  mode=\"render_all\" />\n"
"        <xsl:text>&lt;?vsp </xsl:text>\n"
"      }\n"
"    <xsl:text> ?&gt;</xsl:text>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:template[@type='if-login']\" mode=\"render_all\">\n"
"    <xsl:text>&lt;?vsp </xsl:text>\n"
"    if (login_control.vl_authenticated)\n"
"      {\n"
"        <xsl:text> ?&gt;</xsl:text>\n"
"        <xsl:apply-templates select=\"node()\"  mode=\"render_all\" />\n"
"        <xsl:text>&lt;?vsp </xsl:text>\n"
"      }\n"
"    <xsl:text> ?&gt;</xsl:text>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:button[@action='logout']\" mode=\"render_all\">\n"
"    <xsl:text>&lt;?vsp </xsl:text>\n"
"    if (login_control.vl_authenticated)\n"
"      {\n"
"        control.vc_render ('<xsl:value-of select=\"@name\" />');\n"
"      }\n"
"    <xsl:text> ?&gt;</xsl:text>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:calendar\" mode=\"render_method\">\n"
"  <xsl:text> ?&gt;</xsl:text>\n"
"  <xsl:apply-templates select=\"node()\" mode=\"render_all\"/>\n"
"  <xsl:text>&lt;?vsp </xsl:text>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:*\" mode=\"render_method\">\n"
"    http ('&lt;H4&gt;Not implemented component: \"<xsl:value-of select=\"@control-udt\"/>\"&lt;/H4&gt;');\n"
"</xsl:template>\n"
"\n"
"\n"
"<xsl:template match=\"v:select-list\" mode=\"init_method\">\n"
"   control.vsl_items := vector ( <xsl:for-each select=\"item\" >'<xsl:value-of select=\"@name\" />' <xsl:if test=\"position() != last()\">, </xsl:if></xsl:for-each>);\n"
"   control.vsl_item_values := vector ( <xsl:for-each select=\"item\" >'<xsl:value-of select=\"@value\" />' <xsl:if test=\"position() != last()\">, </xsl:if></xsl:for-each>);\n"
"   <xsl:if test=\"@multiple\">\n"
"   control.vsl_multiple := atoi(<xsl:apply-templates select=\"@multiple\" mode=\"static_value\"/>);\n"
"   </xsl:if>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:data-list\" mode=\"init_method\">\n"
"   <xsl:if test=\"@multiple\">\n"
"   control.vsl_multiple := atoi(<xsl:apply-templates select=\"@multiple\" mode=\"static_value\"/>);\n"
"   </xsl:if>\n"
"   <xsl:if test=\"@list-match[not(. like '--%')]\">\n"
"   control.vsl_list_match := <xsl:apply-templates select=\"@list-match\" mode=\"static_value\"/>;\n"
"   </xsl:if>\n"
"   <xsl:if test=\"@list-key-path[not(. like '--%')]\">\n"
"   control.vsl_list_key_path := <xsl:apply-templates select=\"@list-key-path\" mode=\"static_value\"/>;\n"
"   </xsl:if>\n"
"   <xsl:if test=\"@list-value-path[not(. like '--%')]\">\n"
"   control.vsl_list_value_path := <xsl:apply-templates select=\"@list-value-path\" mode=\"static_value\"/>;\n"
"   </xsl:if>\n"
"</xsl:template>\n"
"<!--\n"
"data-list bind method\n"
";\n", 
"-->\n"
"\n"
"<xsl:template match=\"v:data-list\" mode=\"data_bind_method\">\n"
"  {\n"
"    declare items, item_values any;\n"
"\n"
"    control.vsl_items := vector ();\n"
"    control.vsl_item_values := vector ();\n"
"\n"
"    items := vector ();\n"
"    item_values := vector ();\n"
"  <xsl:if test=\"@list-document\">\n"
"    declare all_items any;\n"
"    declare idx, len integer;\n"
"    all_items := xquery_eval (control.vsl_list_match, control.vsl_list_document, 0);\n"
"    len := length (all_items);\n"
"    idx := 0;\n"
"    while (idx &lt; len)\n"
"      {\n"
"        declare itm any;\n"
"        itm := aref (all_items, idx);\n"
"        items := vector_concat(items, vector(sprintf('%V', cast(xquery_eval(control.vsl_list_key_path, itm) as varchar))));\n"
"        item_values := vector_concat(item_values, vector(sprintf('%V', cast(xquery_eval(control.vsl_list_value_path, itm) as varchar))));\n"
"        idx := idx + 1;\n"
"      }\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@table or @sql\">\n"
"    <xsl:if test=\"@table\">\n"
"    for select <xsl:value-of select=\"@key-column\" />, <xsl:value-of select=\"@value-column\" /> from <xsl:value-of select=\"@table\" /> do\n"
"    </xsl:if>\n"
"    <xsl:if test=\"@sql and not @table\">\n"
"    for <xsl:value-of select=\"@sql\" /> do\n"
"    </xsl:if>\n"
"      {\n"
"        items := vector_concat(items, vector(sprintf('%V', cast(<xsl:value-of select=\"@value-column\" /> as varchar))));\n"
"        item_values := vector_concat(item_values, vector(sprintf('%V', cast(<xsl:value-of select=\"@key-column\" /> as varchar))));\n"
"      }\n"
"  </xsl:if>\n"
"    control.vsl_items := items;\n"
"    control.vsl_item_values := item_values;\n"
"    <!-- control.vsl_selected_inx := position (cast (control.ufl_value as varchar), control.vsl_item_values) - 1; -->\n"
"    control.vs_set_selected ();\n"
"  }\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:select-list\" mode=\"data_bind_method\">\n"
"    <!-- control.vsl_selected_inx := position (cast (control.ufl_value as varchar), control.vsl_item_values) - 1; -->\n"
"    control.vs_set_selected ();\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:isql\" mode=\"set_view_state_method\">\n"
"\n"
"  if (get_keyword ('<xsl:value-of select=\"@name\"/>_submit', e.ve_params, NULL) is NULL)\n"
"    return;\n"
"\n"
"  declare templ vspx_template;\n"
"\n"
"  templ := control.vc_find_control ('<xsl:value-of select=\"v:template[@type='input']/@name\" />');\n"
"\n"
"       if (e.ve_is_post)\n"
"        {\n"
"           templ.vc_enabled := 0;\n"
"        }\n"
"\n"
"</xsl:template>\n"
"\n"
"<!--\n"
"data-grid bind method\n"
";\n", 
"-->\n"
"\n"
"<xsl:template name=\"columns_list\">\n"
"   <xsl:param name=\"names_as_string\"/>\n"
"      <xsl:choose>\n"
"        <xsl:when test=\"count(v:column) > 0\">\n"
"      <xsl:for-each select=\"v:column\">\n"
"          <xsl:if test=\"$names_as_string = 1\">'</xsl:if><xsl:value-of select=\"@name\" /><xsl:if test=\"$names_as_string = 1\">'</xsl:if><xsl:if test=\"position() != last()\">, </xsl:if>\n"
"      </xsl:for-each>\n"
"        </xsl:when>\n"
"        <xsl:otherwise>\n"
"      <xsl:if test=\"function-available('v:columns_meta')\">\n"
"      <xsl:variable name=\"sql\" select=\"@sql|v:sql\"/>\n"
"      <xsl:variable name=\"columns\" select=\"v:columns_meta ($sql)\" />\n"
"      <xsl:for-each select=\"$columns/column\">\n"
"          <xsl:if test=\"$names_as_string = 1\">'</xsl:if><xsl:value-of select=\"@name\" /><xsl:if test=\"$names_as_string = 1\">'</xsl:if><xsl:if test=\"position() != last()\">, </xsl:if>\n"
"      </xsl:for-each>\n"
"      </xsl:if>\n"
"        </xsl:otherwise>\n"
"      </xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<!-- ches120\n"
"THIS IS NECESSARY FOR COMPLEX SQL EXPRESSION WITCH MAY CONTAIN LOT OF SPECIAL SYMBOLS.\n"
"IN THIS CASE SQL ESPRESSION MAY BE PLACED INSIDE 'CDATA' BLOCK AS ADDITIONAL v:sql ELEMENT INSIDE DATA-SET\n"
"ches120 -->\n"
"\n"
"<xsl:template match=\"v:sql\">\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:sql\" mode=\"render_method\"></xsl:template>\n"
"\n"
"<xsl:template match=\"v:sql\" mode=\"render_all\"></xsl:template>\n"
"\n"
"<xsl:template name=\"extract_sql\">\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"@sql\">\n"
"      <xsl:apply-templates select=\"@sql\" mode=\"make_sql_statement\"/>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"./sql\">\n"
"      <xsl:value-of select=\"translate(./sql, ':', '')\" />\n"
"    </xsl:when>\n"
"  </xsl:choose>\n"
"</xsl:template>\n"
"<!-- - -ches120 -->\n"
"\n"
"\n"
"\n"
"<xsl:template match=\"v:data-grid\" mode=\"data_bind_method\">\n"
"      declare dta any;\n"
"      <xsl:if test=\"@sql or ./sql\">\n"
"      <xsl:for-each select=\"v:param\">\n"
"        declare <xsl:value-of select=\"@name\" /> any;\n"
"      </xsl:for-each>\n"
"\n"
"      declare <xsl:call-template name=\"columns_list\" /> any;\n"
"\n"
"      <xsl:choose>\n"
"      <xsl:when test=\"@cursor-type\" >\n"
"      declare cr <xsl:value-of select=\"@cursor-type\" /> cursor for <xsl:call-template name=\"extract_sql\"/>;\n"
"      </xsl:when>\n"
"      <xsl:otherwise>\n"
"      declare cr dynamic cursor for <xsl:call-template name=\"extract_sql\"/>;\n"
"      </xsl:otherwise>\n"
"      </xsl:choose>\n"
"\n"
"      <xsl:if test=\"@edit like '--%'\">\n"
"        control.dg_editable := <xsl:apply-templates select=\"@edit\" mode=\"value\" />;\n"
"      </xsl:if>\n"
"\n"
"      <xsl:for-each select=\"v:param\">\n"
"       <xsl:value-of select=\"@name\" /> := <xsl:apply-templates select=\"@value\" mode=\"value\" />;\n"
"      </xsl:for-each>\n"
"       declare exit handler for sqlstate '*'\n"
"     {\n"
"       self.vc_is_valid := 0;\n"
"       control.vc_error_message := concat (__SQL_MESSAGE, ' in v:data-grid \"<xsl:value-of select=\"@name\" />\" (data bind)');\n"
"       return 1;\n"
"     };\n"
"\n"
"       dta := vector ();\n"
"     {\n"
"       declare inx int;\n"
"       declare bkm any;\n"
"       declare direction varchar;\n"
"\n"
"       direction := null; bkm := null;\n"
"       if (e.ve_button)\n"
"         {\n"
"       if (e.ve_button.vc_name = '<xsl:value-of select=\"@name\" />_prev')\n"
"         direction := 'bkw';\n"
"       else if (e.ve_button.vc_name = '<xsl:value-of select=\"@name\" />_next')\n"
"         direction := 'fwd';\n"
"     }\n"
"       open cr;\n"
"       inx := 0;\n"
"\n"
"       declare have_more int;\n"
"       have_more := 0;\n"
"       whenever not found goto none;\n"
"       if (direction is null)\n"
"     {\n"
"       bkm := control.dg_prev_bookmark;\n"
"     }\n"
"       else\n"
"         bkm := control.dg_last_bookmark;\n"
"\n"
"       if (bkm is not null)\n"
"     {\n"
"       whenever not found goto first_page;\n"
"       fetch cr bookmark bkm into <xsl:call-template name=\"columns_list\" />;\n"
"           if (direction = 'bkw')\n"
"             {\n"
"               inx := 0;\n"
"           while (inx &lt; control.dg_rows_fetched + control.dg_nrows)\n"
"         {\n"
"           fetch cr previous into <xsl:call-template name=\"columns_list\" />;\n"
"                   inx := inx + 1;\n"
"         }\n"
"         }\n"
"           inx := 0;\n"
"           control.dg_prev_bookmark := bookmark (cr);\n"
"     }\n"
"       else\n"
"     {\n"
"first_page:\n"
"       fetch cr first into <xsl:call-template name=\"columns_list\" />;\n"
"         {\n"
"           inx := 1;\n"
"           dta := vector_concat (dta, vector (vector (<xsl:call-template name=\"columns_list\" />)));\n"
"         }\n"
"           control.vc_disable_child ('<xsl:value-of select=\"@name\" />_prev');\n"
"       control.dg_prev_bookmark := null;\n"
"     }\n"
"\n"
"\n"
"       while (inx &lt; control.dg_nrows or control.dg_nrows &lt; 0)\n"
"     {\n"
"       fetch cr next into <xsl:call-template name=\"columns_list\" />;\n"
"         {\n"
"           dta := vector_concat (dta, vector (vector (<xsl:call-template name=\"columns_list\" />)));\n"
"           bkm := bookmark (cr);\n"
"           inx := inx + 1;\n"
"         }\n"
"         }\n"
"    fetch cr next into <xsl:call-template name=\"columns_list\" />;\n"
"        have_more := 1;\n"
"none:\n"
"        control.dg_last_bookmark := bkm;\n"
"    control.dg_rows_fetched := inx;\n"
"    if (inx &lt; control.dg_nrows or not have_more)\n"
"      {\n"
"            control.vc_disable_child ('<xsl:value-of select=\"@name\" />_next');\n"
"      }\n"
"    else\n"
"      control.vc_enable_child ('<xsl:value-of select=\"@name\" />_next');\n"
"\n"
"    if (not inx)\n"
"      control.vc_disable_child ('<xsl:value-of select=\"@name\" />_prev');\n"
"\n"
"        close cr;\n"
"      }\n"
"    control.dg_row_meta := vector (<xsl:call-template name=\"columns_list\" ><xsl:with-param name=\"names_as_string\" select=\"1\"/></xsl:call-template>);\n"
"    </xsl:if>\n"
"    <xsl:if test=\"@data and @meta\">\n"
"    {\n"
"       declare new_dta any;\n"
"       dta := <xsl:apply-templates select=\"@data\" mode=\"value\" />;\n"
"       control.dg_row_meta := <xsl:apply-templates select=\"@meta\" mode=\"value\" />;\n"
"\n"
"       declare direction varchar;\n"
"       declare len, what int;\n"
"       declare i int;\n"
"\n"
"       len := length (dta);\n"
"\n"
"       direction := null;\n"
"       if (e.ve_button)\n"
"         {\n"
"       if (e.ve_button.vc_name = '<xsl:value-of select=\"@name\" />_prev')\n"
"         direction := 'bkw';\n"
"       else if (e.ve_button.vc_name = '<xsl:value-of select=\"@name\" />_next')\n"
"         direction := 'fwd';\n"
"     }\n"
"\n"
"       if (direction is null)\n"
"     {\n"
"       i := coalesce (control.dg_prev_bookmark, 0);\n"
"     }\n"
"       else\n"
"         i := coalesce (control.dg_last_bookmark, 0);\n"
"\n"
"       if (direction = 'bkw' and control.dg_prev_bookmark is not null)\n"
"         i := control.dg_prev_bookmark - control.dg_nrows;\n"
"\n"
"\n"
"       if (not i)\n"
"      control.vc_disable_child ('<xsl:value-of select=\"@name\" />_prev');\n"
"\n"
"       declare limit, inx, no_more int;\n"
"\n"
"       limit := control.dg_nrows + i;\n"
"       if (limit &gt; length(dta)) limit := length(dta);\n"
"       inx := 0;\n"
"\n"
"       if (i &lt; 0) i := 0;\n"
"\n"
"       new_dta := make_array (limit - i, 'any');\n"
"       control.dg_prev_bookmark := i;\n"
"       while (i &lt; limit)\n"
"         {\n"
"           aset (new_dta, inx, dta[i]);\n"
"           inx := inx  + 1;\n"
"           i := i + 1;\n"
"         }\n"
"       dta := new_dta;\n"
"       control.dg_last_bookmark := i;\n"
"\n"
"       if (inx &lt; control.dg_nrows)\n"
"      {\n"
"            control.vc_disable_child ('<xsl:value-of select=\"@name\" />_next');\n"
"      }\n"
"    else\n"
"      control.vc_enable_child ('<xsl:value-of select=\"@name\" />_next');\n"
"\n"
"\n"
"       control.dg_rows_fetched := length (dta); -- do by offset\n"
"    }\n"
"    </xsl:if>\n"
"\n"
"      {\n"
"    declare inx, len int;\n"
"        inx := 0;\n"
"        len := length (dta);\n"
"        control.vc_templates_clean ();\n"
"    control.dg_current_row := NULL;\n"
"        while (inx &lt; len)\n"
"          {\n"
"        declare template_row vspx_row_template;\n"
"        declare select_bt vspx_return_button;\n"
"        declare bt_edit, bt_delete, bt_select, button vspx_button;\n"
"            select_bt := null;\n"
"            template_row := vspx_row_template ('<xsl:value-of select=\"v:template[@type='row']/@name\" />', dta[inx], control, inx);\n"
"\n"
"            bt_edit := bt_delete := bt_select := null;\n"
"\n"
"        <xsl:choose>\n"
"            <xsl:when test=\"v:template[@type='row']//v:button[@action='simple'][@name = concat (ancestor::v:data-grid/@name, '_select')]\">\n"
"            bt_select := vspx_button ('<xsl:value-of select=\"@name\" />_select', template_row);\n"
"        </xsl:when>\n"
"        <xsl:when test=\"v:template[@type='row']//v:button[@action='return'][@name = concat (ancestor::v:data-grid/@name, '_select')]\">\n"
"            bt_select := vspx_return_button ('<xsl:value-of select=\"@name\" />_select', template_row);\n"
"            select_bt := bt_select;\n"
"            </xsl:when>\n"
"        </xsl:choose>\n"
"\n"
"        {\n"
"          declare control vspx_row_template;\n"
"              control := template_row; -- we will lie for a moment\n"
"\n"
"        template_row.vc_children := vector (bt_edit, bt_delete, bt_select,\n"
"          <xsl:apply-templates select=\"v:template[@type='row']/*\" mode=\"form_childs_init\" />\n"
"          NULL\n"
"        );\n"
"        }\n"
"\n"
"        if (e.ve_button is null)\n"
"          {\n"
"        self.vc_get_focus (e);\n"
"        <xsl:if test=\"v:template[@type='edit']\">\n"
"          if(e.ve_is_post and e.ve_button is not null and template_row.vc_focus\n"
"		and e.ve_button.vc_name = '<xsl:value-of select=\"@name\"/>_edit')\n"
"          {\n"
"            declare chils any;\n"
"            template_row.te_editable := 1;\n"
"            <xsl:choose>\n"
"            <xsl:when test=\"v:template[@type='edit']/v:form[@type='update']\">\n"
"            declare uf vspx_update_form;\n"
"            uf := control.vc_find_control ('<xsl:value-of select=\"v:template[@type='edit']/v:form[@type='update']/@name\" />');\n"
"            uf.vc_focus := 1;\n"
"            uf.vc_enabled := 1;\n"
"            </xsl:when>\n"
"            <xsl:when test=\"v:template[@type='edit' and not v:form[@type='update']]\">\n"
"            declare ut vspx_control;\n"
"                    ut := control.vc_find_control ('<xsl:value-of select=\"v:template[@type='edit']/@name\"/>');\n"
"                    ut.vc_enabled := 1;\n"
"            </xsl:when>\n"
"                </xsl:choose>\n"
"            control.dg_current_row := template_row;\n"
"            control.dg_rowno_edit := inx;\n"
"          }\n"
"        else\n"
"        </xsl:if>\n"
"          if(e.ve_is_post and e.ve_button is not null and template_row.vc_focus\n"
"		and e.ve_button.vc_name = '<xsl:value-of select=\"@name\"/>_delete')\n"
"          {\n"
"	    control.dg_current_row := template_row;\n"
"	    <!--\n"
"            -#-e.ve_button.vc_instance_name := e.ve_button.vc_name;\n"
"	    -#-e.ve_button.vc_name := '<xsl:value-of select=\"@name\"/>_delete';\n"
"	    -->\n"
"            control.dg_rowno_edit := -1;\n"
"          }\n"
"          }\n"
"\n"
"            if (select_bt is not null)\n"
"          {\n"
"                control.dg_current_row := template_row;\n"
"        select_bt.vc_enabled := 1;\n"
"        select_bt.vc_data_bind (e);\n"
"            control.dg_current_row := NULL;\n"
"          }\n"
"\n"
"            inx := inx + 1;\n"
"      }\n"
"      }\n"
"  if (e.ve_button is null)\n"
"    self.vc_get_focus (e);\n"
"</xsl:template>\n"
"\n"
"<!--\n"
"data-source bind method\n"
";\n", 
"-->\n"
"<xsl:template match=\"v:data-source\" mode=\"data_bind_method\">\n"
"&LINE;\n"
"<xsl:if test=\"@data and @meta\">\n"
"  control.ds_array_data := <xsl:apply-templates select=\"@data\" mode=\"value\" />;\n"
"  control.ds_row_meta := <xsl:apply-templates select=\"@meta\" mode=\"value\" />;\n"
"</xsl:if>\n"
"<xsl:if test=\"not(@data and @meta)\">\n"
"  if (control.ds_sql is null)\n"
"    control.ds_sql := '<xsl:value-of select=\"normalize-space(v:expression/text())\" />';\n"
"  if (control.ds_parameters is null)\n"
"    control.ds_parameters := vector (<xsl:for-each select=\"v:param\">\n"
"  <xsl:apply-templates select=\"@value\" mode=\"value\"/>\n"
"  <xsl:if test=\"position () != last()\">,</xsl:if>\n"
"  </xsl:for-each>\n"
"&LINE;\n"
"  );\n"
"</xsl:if>\n"
"  control.ds_data_bind (e);\n"
"</xsl:template>\n"
"\n"
"<!--\n"
"data-set bind method (and internals that are common for data bind and scrolling)\n"
";\n", 
"-->\n"
"\n"
"<xsl:template match=\"v:data-set\" mode=\"scroll_cursor_declaration\">\n"
"&LINE;\n"
"  <xsl:for-each select=\"v:param\">\n"
"  declare <xsl:value-of select=\"@name\" /> any;\n"
"  <xsl:value-of select=\"@name\" /> := <xsl:apply-templates select=\"@value\" mode=\"value\" />;\n"
"  </xsl:for-each>\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"@sql or ./sql\"> <!-- binding to SQL select stmt -->\n"
"&LINE;\n"
"  declare <xsl:call-template name=\"columns_list\" /> any;\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"@cursor-type\" >\n"
"  declare cr <xsl:value-of select=\"@cursor-type\" /> cursor for <xsl:call-template name=\"extract_sql\"/>;\n"
"      </xsl:when>\n"
"      <xsl:otherwise>\n"
"  declare cr dynamic cursor for <xsl:call-template name=\"extract_sql\"/>;\n"
"      </xsl:otherwise>\n"
"    </xsl:choose>\n"
"  declare bkm any;\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@data and @meta\"> <!-- binding to vector -->\n"
"&LINE;\n"
"  if (control.ds_row_data is null)\n"
"    {\n"
"      control.ds_row_data := <xsl:apply-templates select=\"@data\" mode=\"value\" />;\n"
"      control.ds_row_meta := <xsl:apply-templates select=\"@meta\" mode=\"value\" />;\n"
"    }\n"
"    control.ds_rows_total := length (control.ds_row_data);\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@data-source\">\n"
"&LINE;\n"
"      declare _ds vspx_data_source;\n"
"      _ds := control.ds_data_source;\n"
"      control.ds_nrows := control.ds_data_source.ds_nrows;\n"
"    </xsl:when>\n"
"  </xsl:choose>\n"
"</xsl:template>\n"
"\n"
"\n"
"<xsl:template match=\"v:data-set\" mode=\"scroll_code\">\n"
"&LINE;\n"
"-- Performing scrolling to get control.ds_rows_offs equal to the requested new_rows_offs.\n"
"  <!-- dbg_obj_print ('Scroll from ', control.ds_rows_offs , ' to ', new_rows_offs);-->\n"
"  new_rows_offs := __max (new_rows_offs, 0);\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"@sql or ./sql\"> <!-- binding to SQL select stmt -->\n"
"&LINE;\n"
"  declare exit handler for sqlstate '*' {\n"
"    self.vc_is_valid := 0;\n"
"    control.vc_error_message := concat (__SQL_MESSAGE, ' in v:data-set \"<xsl:value-of select=\"@name\" />\" (data bind)');\n"
"    return;\n"
"    };\n"
"  open cr;\n"
"  if (new_rows_offs &lt; (control.ds_rows_offs + control.ds_rows_fetched))\n"
"    bkm := control.ds_prev_bookmark;\n"
"  else\n"
"    {\n"
"      bkm := control.ds_last_bookmark;\n"
"      control.ds_rows_offs := control.ds_rows_offs + control.ds_rows_fetched;\n"
"    }\n"
"  control.ds_last_bookmark := null;\n"
"  if (bkm is not null)\n"
"    {\n"
"      whenever not found goto reset_to_beginning;\n"
"      fetch cr bookmark bkm into <xsl:call-template name=\"columns_list\" />;\n"
"      if (new_rows_offs &lt; control.ds_rows_offs)\n"
"        {\n"
"          while (new_rows_offs &lt; control.ds_rows_offs)\n"
"            {\n"
"              fetch cr previous into <xsl:call-template name=\"columns_list\" />;\n"
"   <!-- dbg_obj_print ('Fetch previous at ', control.ds_rows_offs, '(?):', <xsl:call-template name=\"columns_list\" />); -->\n"
"              control.ds_rows_offs := control.ds_rows_offs - 1;\n"
"            }\n"
"        }\n"
"      else\n"
"        {\n"
"          while (new_rows_offs > control.ds_rows_offs)\n"
"            {\n"
"              fetch cr next into <xsl:call-template name=\"columns_list\" />;\n"
"   <!-- dbg_obj_print ('Fetch next at ', control.ds_rows_offs, '(?):', <xsl:call-template name=\"columns_list\" />); -->\n"
"              control.ds_rows_offs := control.ds_rows_offs + 1;\n"
"            }\n"
"        }\n"
"      control.ds_prev_bookmark := bookmark(cr);\n"
"      goto scroll_complete;\n"
"    }\n"
"reset_to_beginning:\n"
"  <!-- dbg_obj_print ('Reset to bweginning'); -->\n"
"  control.ds_prev_bookmark := null;\n"
"  control.ds_rows_offs := 0;\n"
"  control.ds_rows_fetched := 0;\n"
"  new_rows_offs := 0;\n"
"scroll_complete:\n"
"  ;\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@data and @meta\"> <!-- binding to vector -->\n"
"&LINE;\n"
"  control.ds_rows_offs := new_rows_offs;\n"
"  control.ds_prev_bookmark := control.ds_rows_offs;\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@data-source\">\n"
"&LINE;\n"
"  if (new_rows_offs &lt;&gt; control.ds_data_source.ds_rows_offs)\n"
"    {\n"
"      control.ds_data_source.ds_rows_offs := new_rows_offs;\n"
"      control.ds_data_source.vc_data_bind (e);\n"
"    }\n"
"  if (control.ds_data_source.ds_have_more is not null)\n"
"    {\n"
"      control.ds_has_next_page := control.ds_data_source.ds_have_more;\n"
"    }\n"
"  else\n"
"    {\n"
"      if(control.ds_data_source.ds_rows_fetched &lt; control.ds_data_source.ds_nrows)\n"
"	control.ds_has_next_page := 0;\n"
"      else\n"
"	control.ds_has_next_page := 1;\n"
"    }\n"
"  control.ds_row_meta := control.ds_data_source.ds_row_meta;\n"
"  control.ds_rows_fetched := control.ds_data_source.ds_rows_fetched;\n"
"  control.ds_prev_bookmark := new_rows_offs;\n"
"  control.ds_rows_offs := new_rows_offs;\n"
"  control.ds_last_bookmark := new_rows_offs + control.ds_data_source.ds_rows_fetched;\n"
"    </xsl:when>\n"
"  </xsl:choose>\n"
"-- At this point the scrolling is complete.\n"
"</xsl:template>\n"
"\n"
"\n"
"<xsl:template match=\"v:data-set\" mode=\"data_bind_method\">\n"
"&LINE;\n"
"  control.ds_rows_offs_saved := control.ds_rows_offs;\n"
"  declare dta any;\n"
"  declare nav_template vspx_control;\n"
"  declare _page_navigator vspx_template;\n"
"  declare new_rows_offs integer;\n"
"\n"
"  <xsl:apply-templates select=\".\" mode=\"scroll_cursor_declaration\" />\n"
"&LINE;\n"
"  new_rows_offs := control.ds_rows_offs;\n"
"  control.ds_has_next_page := 0;\n"
"\n"
"  nav_template := control.vc_find_control ('<xsl:value-of select=\"v:template[@type='simple'][.//v:button[@name=concat(ancestor::v:data-set/@name, '_next')]]/@name\" />');\n"
"  if (nav_template is null)\n"
"    nav_template := control;\n"
"\n"
"  <xsl:if test=\"@data-source and //v:template[@type='page-navigator']//v:button[@name = concat(ancestor::v:data-set/@name, '_pager')]\">\n"
"&LINE;\n"
"-- Detect pressed page button\n"
"        _page_navigator := self.<xsl:value-of select=\"//v:template[@type='page-navigator']/@name\"/>;\n"
"        <xsl:if test=\"//v:template[@type='page-navigator']/@npages\">\n"
"        _ds.ds_npages := <xsl:value-of select=\"//v:template[@type='page-navigator']/@npages\"/>;\n"
"        </xsl:if>\n"
"        if(_ds.ds_rows_offs = 0) _ds.ds_rows_offs := new_rows_offs;\n"
"        _ds.ds_make_statistic();\n"
"        _ds.ds_current_pager_idx := _ds.ds_first_page;\n"
"        _page_navigator.vc_children := vector();\n"
"        while(_ds.ds_current_pager_idx &lt; _ds.ds_last_page + 1) {\n"
"          declare _name varchar;\n"
"          declare _btn vspx_button;\n"
"          _name := sprintf('<xsl:value-of select=\"@name\"/>_pager_%d', _ds.ds_current_pager_idx);\n"
"          _btn := vspx_button(_name, control);\n"
"          _page_navigator.vc_children := vector_concat(_page_navigator.vc_children, vector(_btn));\n"
"          _ds.ds_current_pager_idx := _ds.ds_current_pager_idx + 1;\n"
"        }\n"
"        if(e.ve_button is null) {\n"
"          self.vc_get_focus(e);\n"
"        }\n"
"  </xsl:if>\n"
"&LINE;\n"
"  if(e.ve_button and control.vc_focus)\n"
"    {\n"
"      if(e.ve_button.vc_name = '<xsl:value-of select=\"@name\" />_prev')\n"
"        {\n"
"           new_rows_offs := __max (new_rows_offs - control.ds_nrows, 0);\n"
"           control.ds_scrolled := -1;\n"
"        }\n"
"      else if(e.ve_button.vc_name = '<xsl:value-of select=\"@name\" />_next')\n"
"        {\n"
"           new_rows_offs := control.ds_rows_offs + control.ds_rows_fetched;\n"
"            control.ds_scrolled := 1;\n"
"        }\n"
"      else if(e.ve_button.vc_name = '<xsl:value-of select=\"@name\" />_first')\n"
"        {\n"
"          new_rows_offs := 0;\n"
"          control.ds_scrolled := -1;\n"
"        }\n"
"&LINE;\n"
"      else if(e.ve_button.vc_name = '<xsl:value-of select=\"@name\" />_last')\n"
"        {\n"
"  <xsl:choose>\n"
"      <xsl:when test=\"@data-source\">\n"
"          _ds.ds_make_statistic();\n"
"	  new_rows_offs := _ds.ds_total_pages * control.ds_data_source.ds_nrows;\n"
"	  if (new_rows_offs = _ds.ds_total_rows and _ds.ds_total_pages > 0)\n"
"	    new_rows_offs := (_ds.ds_total_pages - 1) * control.ds_data_source.ds_nrows;\n"
"      </xsl:when>\n"
"      <xsl:when test=\"@sql or ./v:sql\">\n"
"	  declare total int;\n"
"	  select count(*) into total from (<xsl:call-template name=\"extract_sql\"/>) <xsl:value-of select=\"@name\"/>;\n"
"	  new_rows_offs := total - mod (total, control.ds_nrows);\n"
"	  if (new_rows_offs = total and total &gt; control.ds_nrows)\n"
"	    new_rows_offs := total - control.ds_nrows;\n"
"      </xsl:when>\n"
"      <xsl:otherwise>\n"
"	  new_rows_offs := control.ds_rows_total - mod (control.ds_rows_total, control.ds_nrows);\n"
"      </xsl:otherwise>\n"
"  </xsl:choose>\n"
"        }\n"
"&LINE;\n"
"      else if(e.ve_button.vc_name like '<xsl:value-of select=\"@name\" />_pager_%')\n"
"        {\n"
"          declare _pos, _page integer;\n"
"          _pos := length('<xsl:value-of select=\"@name\" />_pager_');\n"
"          _page := atoi(subseq(e.ve_button.vc_name, _pos));\n"
"          new_rows_offs := control.ds_data_source.ds_nrows * (_page - 1);\n"
"        }\n"
"    }\n"
"  <xsl:apply-templates select=\".\" mode=\"scroll_code\" />\n"
"&LINE;\n"
"\n"
"<!-- ches120 -->\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"@sql or ./sql\"> <!-- binding to SQL select stmt -->\n"
"  declare inx integer;\n"
"    declare prev_fetched int;\n"
"  inx := 0;\n"
"<!--\n"
"    <xsl:if test=\"@initial-enable like '-#-#%'\">\n"
"    control.vc_enabled := <xsl:apply-templates select=\"@initial-enable\" mode=\"value\" />;\n"
"    </xsl:if>\n"
"-->\n"
"      <xsl:if test=\"@edit like '--%'\">\n"
"        control.ds_editable := <xsl:apply-templates select=\"@edit\" mode=\"value\" />;\n"
"      </xsl:if>\n"
"\n"
"  {\n"
"    whenever not found goto none;\n"
"    dta := vector ();\n"
"    if (control.ds_rows_offs = 0)\n"
"      {\n"
"        fetch cr first into <xsl:call-template name=\"columns_list\" />;\n"
"        bkm := bookmark (cr);\n"
"        inx := 1;\n"
"        dta := vector_concat (dta, vector (vector (<xsl:call-template name=\"columns_list\" />)));\n"
"        nav_template.vc_disable_child ('<xsl:value-of select=\"@name\" />_prev');\n"
"        control.ds_prev_bookmark := null;\n"
"      }\n"
"    while (inx &lt; control.ds_nrows)\n"
"      {\n"
"        fetch cr next into <xsl:call-template name=\"columns_list\" />;\n"
"        dta := vector_concat (dta, vector (vector (<xsl:call-template name=\"columns_list\" />)));\n"
"        bkm := bookmark (cr);\n"
"        inx := inx + 1;\n"
"      }\n"
"    fetch cr next into <xsl:call-template name=\"columns_list\" />;\n"
"    control.ds_has_next_page := 1;\n"
"  }\n"
"none:\n"
"  prev_fetched := control.ds_rows_fetched;\n"
"  control.ds_last_bookmark := bkm;\n"
"  control.ds_rows_fetched := inx;\n"
"  close cr;\n"
"  control.ds_row_meta := vector (<xsl:call-template name=\"columns_list\"><xsl:with-param name=\"names_as_string\" select=\"1\" /></xsl:call-template>);\n"
"    </xsl:when> <!-- end binding to SQL select -->\n"
"    <xsl:when test=\"@data and @meta\"> <!-- binding to vector -->\n"
"  control.ds_last_bookmark := __min (control.ds_prev_bookmark + control.ds_nrows, control.ds_rows_total);\n"
"  control.ds_has_next_page := lt (control.ds_last_bookmark, control.ds_rows_total);\n"
"  control.ds_rows_fetched := control.ds_last_bookmark - control.ds_prev_bookmark;\n"
"  if (control.ds_prev_bookmark &gt; control.ds_last_bookmark)\n"
"    dta := vector ();\n"
"  else\n"
"    dta := subseq (control.ds_row_data, control.ds_prev_bookmark, control.ds_last_bookmark);\n"
"    </xsl:when> <!-- end binding to a VECTOR -->\n"
"    <xsl:when test=\"@data-source\">\n"
"  dta := control.ds_data_source.ds_row_data;\n"
"      <xsl:if test=\"//v:template[@type='page-navigator']//v:button[@name = concat(ancestor::v:data-set/@name, '_pager')]\">\n"
"-- prepare final set of navigator's buttons\n"
"        declare _page_navigator vspx_template;\n"
"        _page_navigator := self.<xsl:value-of select=\"//v:template[@type='page-navigator']/@name\"/>;\n"
"        <xsl:if test=\"//v:template[@type='page-navigator']/@npages\">\n"
"        _ds.ds_npages := <xsl:value-of select=\"//v:template[@type='page-navigator']/@npages\"/>;\n"
"        </xsl:if>\n"
"        if(_ds.ds_rows_offs = 0) _ds.ds_rows_offs := new_rows_offs;\n"
"        _ds.ds_make_statistic();\n"
"        _ds.ds_current_pager_idx := _ds.ds_first_page;\n"
"        _page_navigator.vc_children := vector();\n"
"  while(_ds.ds_current_pager_idx &lt; _ds.ds_last_page + 1)\n"
"    {\n"
"          declare _name varchar;\n"
"          declare _btn vspx_button;\n"
"          _name := sprintf('<xsl:value-of select=\"@name\"/>_pager_%d', _ds.ds_current_pager_idx);\n"
"          _btn := vspx_button(_name, control);\n"
"          self.vc_init_<xsl:value-of select=\"@name\"/>_pager(_btn, control);\n"
"          self.vc_data_bind_<xsl:value-of select=\"@name\" />_pager(_btn, e);\n"
"          _page_navigator.vc_children := vector_concat(_page_navigator.vc_children, vector(_btn));\n"
"          _ds.ds_current_pager_idx := _ds.ds_current_pager_idx + 1;\n"
"    }\n"
"      </xsl:if>\n"
"\n"
"<!-- navigation -->\n"
"    </xsl:when>\n"
"    <xsl:otherwise>\n"
"    <xsl:message terminate=\"yes\">Missing attribute. The data-set can be bound via SQL, function or data-source.</xsl:message>\n"
"    </xsl:otherwise>\n"
"    </xsl:choose>\n"
"&LINE;\n"
"  if (not control.ds_has_next_page)\n"
"    {\n"
"      nav_template.vc_disable_child ('<xsl:value-of select=\"@name\" />_next');\n"
"      nav_template.vc_disable_child ('<xsl:value-of select=\"@name\" />_last');\n"
"    }\n"
"  else\n"
"    {\n"
"      nav_template.vc_enable_child ('<xsl:value-of select=\"@name\" />_next');\n"
"      nav_template.vc_enable_child ('<xsl:value-of select=\"@name\" />_last');\n"
"    }\n"
"  if (not control.ds_rows_offs)\n"
"    {\n"
"      nav_template.vc_disable_child ('<xsl:value-of select=\"@name\" />_prev');\n"
"      nav_template.vc_disable_child ('<xsl:value-of select=\"@name\" />_first');\n"
"    }\n"
"  else\n"
"    {\n"
"      nav_template.vc_enable_child ('<xsl:value-of select=\"@name\" />_prev');\n"
"      nav_template.vc_enable_child ('<xsl:value-of select=\"@name\" />_first');\n"
"    }\n"
"\n"
"      {\n"
"        declare inx, len int;\n"
"        declare rows_cache, children any;\n"
"  <xsl:if test=\".//v:template[@type='repeat']//v:template[@type='edit']//v:form[@type='update']\">\n"
"        declare uf vspx_update_form;\n"
"        uf := control.vc_find_control('<xsl:value-of select=\".//v:template[@type='repeat']//v:template[@type='edit']//v:form[@type='update']/@name\" />');\n"
"  </xsl:if>\n"
"&LINE;\n"
"        inx := 0;\n"
"        len := length (dta);\n"
"        control.vc_templates_clean ();\n"
"        control.ds_current_row := NULL;\n"
"	<!--control.ds_rows_cache := vector();-->\n"
"        if (control.ds_row_data is null)\n"
"          control.ds_row_data := dta;\n"
"	rows_cache := make_array (len, 'any');\n"
"        while(inx &lt; len) {\n"
"          declare template_row vspx_row_template;\n"
"          declare select_bt vspx_return_button;\n"
"          declare bt_edit, bt_delete, bt_select vspx_button;\n"
"\n"
"          if (control.ds_data_source is not null)\n"
"        control.ds_data_source.ds_current_inx := inx;\n"
"\n"
"          select_bt := null;\n"
"	  template_row := vspx_row_template ('<xsl:apply-templates select=\"*\" mode=\"rpt_name\"/>', dta[inx], control, inx, 0);\n"
"          bt_edit := bt_delete := bt_select := null;\n"
"          <xsl:choose>\n"
"            <xsl:when test=\"v:template[@type='repeat']//v:button[@action='simple'][@name = concat(ancestor::v:data-set/@name, '_select')]\">\n"
"              bt_select := vspx_button('<xsl:value-of select=\"@name\" />_select', template_row);\n"
"            </xsl:when>\n"
"            <xsl:when test=\"v:template[@type='repeat']//v:button[@action='return'][@name = concat(ancestor::v:data-set/@name, '_select')]\">\n"
"              bt_select := vspx_return_button('<xsl:value-of select=\"@name\" />_return', template_row);\n"
"              select_bt := bt_select;\n"
"            </xsl:when>\n"
"          </xsl:choose>\n"
"&LINE;\n"
"        {\n"
"          declare control vspx_row_template;\n"
"              control := template_row; -- we'll change the 'control' for a moment to set up the right parent\n"
"\n"
"        template_row.vc_children := vector (bt_edit, bt_delete, bt_select,\n"
"  <xsl:apply-templates select=\"*\" mode=\"rpt_init\" />\n"
"&LINE;\n"
"          NULL\n"
"        );\n"
"        }\n"
"      if (e.ve_button is null)\n"
"        {\n"
"	  <!-- traverse from current template if needed -->\n"
"          template_row.vc_get_focus (e);\n"
"   <xsl:if test=\".//v:template[@type='repeat']//v:template[@type='edit']//v:form[@type='update']\">\n"
"&LINE;\n"
"          if(e.ve_is_post and e.ve_button is not null and template_row.vc_focus\n"
"		and e.ve_button.vc_name = '<xsl:value-of select=\"@name\"/>_edit')\n"
"            {\n"
"              declare chils any;\n"
"              template_row.te_editable := 1;\n"
"              uf.vc_enabled := 1;\n"
"              control.ds_current_row := template_row;\n"
"              uf.vc_data_bind (e);\n"
"              uf.vc_data_bound := 1;\n"
"              control.ds_rowno_edit := inx;\n"
"            }\n"
"          else\n"
"  </xsl:if>\n"
"&LINE;\n"
"          if(e.ve_is_post and e.ve_button is not null and template_row.vc_focus\n"
"		and e.ve_button.vc_name = '<xsl:value-of select=\"@name\"/>_delete')\n"
"              {\n"
"                control.ds_current_row := template_row;\n"
"                control.ds_rowno_edit := -1;\n"
"                if (control.ds_data_source is not null)\n"
"                  control.ds_data_source.ds_update_inx := inx;\n"
"              }\n"
"          }\n"
"  <xsl:if test=\".//v:template[@type='repeat']//v:template[@type='edit']//v:form[@type='update']\">\n"
"&LINE;\n"
"        else if (uf.vc_focus and control.ds_rowno_edit = inx)\n"
"          {\n"
"            uf.vc_enabled := 1;\n"
"            control.ds_current_row := template_row;\n"
"            if (control.ds_data_source is not null)\n"
"              control.ds_data_source.ds_update_inx := inx;\n"
"            uf.vc_data_bind (e);\n"
"	    <!--control.ds_current_row := NULL;-->\n"
"            uf.vc_enabled := 0;\n"
"          }\n"
"  </xsl:if>\n"
"&LINE;\n"
"        if (select_bt is not null)\n"
"          {\n"
"            control.ds_current_row := template_row;\n"
"            select_bt.vc_enabled := 1;\n"
"            select_bt.vc_data_bind(e);\n"
"	    <!--control.ds_current_row := NULL;-->\n"
"          }\n"
"	rows_cache [inx] := template_row;\n"
"        inx := inx + 1;\n"
"	<!--control.ds_rows_cache := vector_concat(control.ds_rows_cache, vector(template_row));-->\n"
"      }\n"
"      control.ds_rows_cache := rows_cache;\n"
"      <!-- do the concat once -->\n"
"      children := control.vc_children;\n"
"      control.vc_children := vector_concat (children, rows_cache);\n"
"    }\n"
"  if (control.ds_data_source is not null)\n"
"    control.ds_data_source.ds_current_inx := -1;\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:template[@type='browse']\" mode=\"rpt_init\">\n"
"    <xsl:apply-templates select=\"*\" mode=\"form_childs_init\" />\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:data-set\" mode=\"rpt_init\"/>\n"
"\n"
"<xsl:template match=\"*\" mode=\"rpt_init\">\n"
"    <xsl:apply-templates select=\"*\" mode=\"rpt_init\"/>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:template[@type='browse']\" mode=\"rpt_name\"><xsl:value-of select=\"@name\" /></xsl:template>\n"
"\n"
"<xsl:template match=\"v:data-set\" mode=\"rpt_name\" />\n"
"\n"
"<xsl:template match=\"*\" mode=\"rpt_name\">\n"
"    <xsl:apply-templates select=\"*\" mode=\"rpt_name\"/>\n"
"</xsl:template>\n"
"\n"
"<!--\n"
"quoted name to intenal convertor,\n"
"removes double quote char and replaces some special chars with underscore\n"
";\n", 
"-->\n"
"\n"
"<xsl:template match=\"@*\" mode=\"internal_name\">\n"
"<xsl:value-of select=\"translate (., '-.&quot;', '__')\"/>\n"
"</xsl:template>\n"
"\n"
"<!--\n"
"form bind method\n"
";\n", 
"-->\n"
"\n"
"<xsl:template match=\"v:form[@type='update']\" mode=\"data_bind_method\">\n"
"  if (control.vc_data_bound)\n"
"    return 1;\n"
"  <xsl:param name=\"table\" select=\"@table\" />\n"
"  <xsl:for-each select=\"v:key\">\n"
"    declare key_<xsl:apply-templates select=\"@column\" mode=\"internal_name\" /> any;\n"
"    key_<xsl:apply-templates select=\"@column\" mode=\"internal_name\" /> := coalesce (<xsl:apply-templates select=\"@value\" mode=\"value\" />,\n"
"     <xsl:choose><xsl:when test=\"@default!=''\"><xsl:value-of select=\"@default\" /></xsl:when>\n"
"     <xsl:otherwise>NULL</xsl:otherwise></xsl:choose>);\n"
"  </xsl:for-each>\n"
"<!--\n"
"  <xsl:if test=\"@initial-enable like '-#-#%'\">\n"
"    control.vc_enabled := <xsl:apply-templates select=\"@initial-enable\" mode=\"value\" />;\n"
"  </xsl:if>\n"
"-->\n"
"  control.uf_keys := vector (<xsl:for-each select=\"v:key\"> key_<xsl:apply-templates select=\"@column\" mode=\"internal_name\" /> <xsl:if test=\"position() != last()\">,</xsl:if> </xsl:for-each>);\n"
"  control.uf_row := null;\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"@data-source\">\n"
"      <xsl:variable name=\"ds\" select=\"@data-source\" />\n"
"      <xsl:for-each select=\"v:template//v:*[@column like '--%']\">\n"
"      self.<xsl:value-of select=\"@name\"/>.ufl_column := <xsl:apply-templates select=\"@column\" mode=\"value\"/>;\n"
"      </xsl:for-each>\n"
"      <xsl:for-each select=\"v:template//v:*[@column]\">\n"
"      self.<xsl:value-of select=\"@name\"/>.ufl_value := <xsl:value-of select=\"$ds\"/>.get_item_value (self.<xsl:value-of select=\"@name\"/>.ufl_column);\n"
"      </xsl:for-each>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"ancestor::v:template[@type='add' or @type='edit']\">\n"
"      <xsl:if test=\"v:template//v:*[@column]\">\n"
"        <xsl:for-each select=\"v:template//v:*[@column]\">\n"
"          declare _<xsl:value-of select=\"@name\" /> any;\n"
"        </xsl:for-each>\n"
"        whenever not found goto none;\n"
"        select <xsl:for-each select=\"v:template//v:*[@column]\"> <xsl:value-of select=\"@column\" /> <xsl:if test=\"position() != last()\">,</xsl:if> </xsl:for-each> into <xsl:for-each select=\"v:template//v:*[@column]\"> _<xsl:value-of select=\"@name\" /> <xsl:if test=\"position() != last()\">,</xsl:if> </xsl:for-each> from <xsl:value-of select=\"$table\" /> where <xsl:for-each select=\"key\"> <xsl:value-of select=\"@column\" /> = key_<xsl:apply-templates select=\"@column\" mode=\"internal_name\" /> <xsl:if test=\"position() != last()\"> and </xsl:if> </xsl:for-each>;\n"
"        control.uf_row := vector (<xsl:for-each select=\"v:template//v:*[@column]\"> _<xsl:value-of select=\"@name\" /> <xsl:if test=\"position() != last()\">,</xsl:if> </xsl:for-each>);\n"
"        {\n"
"    declare template vspx_template;\n"
"          declare i, l, inx int;\n"
"          template := control.vc_find_control('<xsl:value-of select=\"v:template/@name\" />');\n"
"          i := 0; l := length (control.uf_fields);\n"
"          inx := 0;\n"
"          while(i &lt; l) {\n"
"            declare uf vspx_control;\n"
"            uf := template.vc_find_control(control.uf_fields[i]);\n"
"	    if(uf is not null and udt_instance_of(uf, fix_identifier_case ('vspx_field')) and (uf as vspx_field).ufl_column is not null)\n"
"	    {\n"
"	      declare field vspx_field;\n"
"	      field := uf;\n"
"	      field.ufl_value := control.uf_row[inx];\n"
"	      if (field.ufl_value is null and field.ufl_null_value is not null)\n"
"	        field.ufl_value := field.ufl_null_value;\n"
"              inx := inx + 1;\n"
"            }\n"
"            i := i + 1;\n"
"          }\n"
"        }\n"
"      </xsl:if>\n"
"    </xsl:when>\n"
"    <xsl:otherwise>\n"
"      <xsl:if test=\"v:template[@type='if-exists']//v:*[@column]\">\n"
"        <xsl:for-each select=\"v:template[@type='if-exists']//v:*[@column]\">\n"
"          declare _<xsl:value-of select=\"@name\" /> any;\n"
"        </xsl:for-each>\n"
"        whenever not found goto none;\n"
"        select <xsl:for-each select=\"v:template[@type='if-exists']//v:*[@column]\"> <xsl:value-of select=\"@column\" /> <xsl:if test=\"position() != last()\">,</xsl:if> </xsl:for-each> into <xsl:for-each select=\"v:template[@type='if-exists']//v:*[@column]\"> _<xsl:value-of select=\"@name\" /> <xsl:if test=\"position() != last()\">,</xsl:if> </xsl:for-each> from <xsl:value-of select=\"$table\" /> where <xsl:for-each select=\"key\"> <xsl:value-of select=\"@column\" /> = key_<xsl:apply-templates select=\"@column\" mode=\"internal_name\" /> <xsl:if test=\"position() != last()\"> and </xsl:if> </xsl:for-each>;\n"
"        control.uf_row := vector (<xsl:for-each select=\"v:template[@type='if-exists']//v:*[@column]\"> _<xsl:value-of select=\"@name\" /> <xsl:if test=\"position() != last()\">,</xsl:if> </xsl:for-each>);\n"
"        {\n"
"          declare template vspx_template;\n"
"          declare i, l, inx int;\n"
"          template := control.vc_find_control('<xsl:value-of select=\"v:template/@name\" />');\n"
"          i := 0; l := length (control.uf_fields);\n"
"          inx := 0;\n"
"          while(i &lt; l) {\n"
"            declare uf vspx_control;\n"
"            uf := template.vc_find_control (control.uf_fields[i]);\n"
"            if (uf is not null and udt_instance_of (uf, fix_identifier_case ('vspx_field')) and (uf as vspx_field).ufl_column is not null) {\n"
"          declare val any;\n"
"              val := control.uf_row[inx];\n"
"              (uf as vspx_field).ufl_value := val;\n"
"	  if (udt_instance_of (uf, fix_identifier_case ('vspx_check_box')) and not (uf as vspx_field).ufl_is_boolean)\n"
"        {\n"
"          (uf as vspx_field).ufl_selected := case\n"
"                                                when val is null then 0\n"
"                            when (val &lt;&gt; 0) then 1\n"
"                            when (isstring (val) and lower(val) = 'yes') then 1\n"
"                            else 0 end;\n"
"          if ((uf as vspx_field).ufl_selected)\n"
"            (uf as vspx_field).ufl_value := 1;\n"
"          else\n"
"            (uf as vspx_field).ufl_value := 0;\n"
"        }\n"
"	<!--uf.vc_data_bound := 1;-->\n"
"              inx := inx + 1;\n"
"            }\n"
"            i := i + 1;\n"
"          }\n"
"        }\n"
"      </xsl:if>\n"
"    </xsl:otherwise>\n"
"  </xsl:choose>\n"
"none:;\n"
"</xsl:template>\n"
"\n"
"\n"
"<!--\n"
"login bind method (url and cookie)\n"
";\n", 
"-->\n"
"\n"
"<xsl:template match=\"v:login[@mode='url' or @mode='cookie']\" mode=\"data_bind_method\">\n"
"  --no_c_escapes-\n"
"  declare usr, pass_clear, pass, sid varchar;\n"
"  declare vars any;\n"
"  if (control.vc_data_bound)\n"
"    return 1;\n"
"  control.vc_data_bound := 1;\n"
"  usr := get_keyword ('username' , params, '');\n"
"  pass := get_keyword ('password' , params, '');\n"
"  <xsl:if test=\"@mode = 'url'\">\n"
"  pass_clear := get_keyword ('password_plain' , params, '');\n"
"  if (not length (pass))\n"
"    pass := pass_clear;\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@mode = 'cookie'\">\n"
"   {\n"
"     declare cookies any;\n"
"     cookies := vspx_get_cookie_vec (lines);\n"
"     self.sid := get_keyword ('sid', cookies);\n"
"     self.realm := get_keyword ('realm', cookies);\n"
"     self.vc_authentication_mode := 0;\n"
"   }\n"
"  </xsl:if>\n"
"  <xsl:if test=\"@mode = 'url'\">\n"
"     self.sid := get_keyword ('sid', params);\n"
"     self.realm := get_keyword ('realm', params);\n"
"     self.nonce := get_keyword ('nonce', params);\n"
"  </xsl:if>\n"
"\n"
"  if (length (self.sid))\n"
"    {\n"
"      vars := coalesce ((select deserialize (blob_to_string(VS_STATE)) from VSPX_SESSION where VS_SID = self.sid), NULL);\n"
"      connection_vars_set (vars);\n"
"      update VSPX_SESSION set VS_EXPIRY = now () where VS_SID = self.sid and VS_REALM = control.vl_realm and VS_IP = http_client_ip () and datediff ('minute', VS_EXPIRY, now()) &lt; 30;\n"
"      if (row_count () = 0)\n"
"        goto re_auth;\n"
"      control.vl_authenticated := 1;\n"
"      control.vl_sid := self.sid;\n"
"      self.vc_authenticated := 1;\n"
"      <xsl:for-each select=\"//v:variable[@persist = '1' or @persist = 'session']\">\n"
"      self.<xsl:value-of select=\"@name\" /> := coalesce (connection_get ('<xsl:value-of select=\"@name\" />'), self.<xsl:value-of select=\"@name\" />);\n"
"      </xsl:for-each>;\n"
"      goto authenticated;\n"
"    }\n"
"\n"
"re_auth:\n"
"\n"
"  <xsl:if test=\"@mode = 'url'\">\n"
"  if (length (self.nonce))\n"
"    {\n"
"      delete from VSPX_SESSION where VS_REALM = control.vl_realm\n"
"        and VS_SID = self.nonce;\n"
"      if (row_count () and not length (pass_clear))\n"
"        {\n"
"	  connection_set ('vspx_nonce', self.nonce);\n"
"        }\n"
"    }\n"
"  </xsl:if>\n"
"\n"
"  <xsl:if test=\"@user-password-check\">\n"
"  if (<xsl:value-of select=\"@user-password-check\" /> (usr, pass))\n"
"    {\n"
"       sid := md5 (concat (datestring (now ()), http_client_ip (), http_path ()));\n"
"       insert into VSPX_SESSION (VS_REALM, VS_SID, VS_UID, VS_STATE, VS_EXPIRY, VS_IP) values (control.vl_realm, sid, usr, null, now(), http_client_ip ());\n"
"       control.vl_authenticated := 1;\n"
"       self.vc_authenticated := 1;\n"
"       self.sid := sid;\n"
"       self.realm := control.vl_realm;\n"
"       control.vl_sid := self.sid;\n"
"       connection_set ('vspx_user', usr);\n"
"      if (usr &lt;&gt; '')\n"
"        {\n"
"          control.vl_user := usr;\n"
"        }\n"
"      goto authenticated;\n"
"    }\n"
"  </xsl:if>\n"
"\n"
"\n"
"\n"
"    control.vl_authenticated := 0;\n"
"    self.vc_authenticated := 0;\n"
"    self.sid := null;\n"
"    <xsl:choose>\n"
"    <xsl:when test=\"v:template[@type='if-no-login']/@redirect\">\n"
"     {\n"
"       declare ex_path, sep, redir_url varchar;\n"
"       <xsl:choose>\n"
"	   <xsl:when test=\"starts-with(v:template[@type='if-no-login']/@redirect, '--')\">\n"
"       redir_url := <xsl:apply-templates select=\"v:template[@type='if-no-login']/@redirect\" mode=\"value\" />;\n"
"	   </xsl:when>\n"
"	   <xsl:otherwise>\n"
"       redir_url := <xsl:apply-templates select=\"v:template[@type='if-no-login']/@redirect\" mode=\"static_value\" />;\n"
"	   </xsl:otherwise>\n"
"       </xsl:choose>\n"
"       ex_path := WS.WS.EXPAND_URL (http_path (), redir_url);\n"
"       if (ex_path &lt;&gt; http_path ())\n"
"         {\n"
"           declare pars, req_url, pars_arr, i, l any;\n"
"	   pars := http_request_get ('QUERY_STRING');\n"
"	   pars_arr := split_and_decode (pars);\n"
"	   l := length (pars_arr);\n"
"	   req_url := http_path ();\n"
"	   if (l &gt; 0 and mod (l, 2) = 0)\n"
"	     {\n"
"	       req_url := req_url || '?';\n"
"	       for (i := 0; i &lt; l; i := i + 2)\n"
"		  {\n"
"		    if (pars_arr [i] not in ('sid', 'realm'))\n"
"		      req_url := req_url || sprintf ('%U', pars_arr [i]) || '=' || sprintf ('%U', pars_arr [i+1]) || '&amp;';\n"
"		  }\n"
"	       req_url := rtrim (req_url, '&amp;');\n"
"	     }\n"
"	   sep := '?';\n"
"	   if (strchr (redir_url, sep) is not null)\n"
"	     sep := '&amp;';\n"
"	   self.vc_redirect (concat (redir_url, sprintf ('%sURL=%U', sep, req_url)));\n"
"         }\n"
"       else\n"
"         {\n"
"           self.nonce := md5 (concat (datestring (now ()), http_client_ip (), http_path ()));\n"
"	 }\n"
"     }\n"
"    </xsl:when>\n"
"    <xsl:otherwise>\n"
"    self.nonce := md5 (concat (datestring (now ()), http_client_ip (), http_path ()));\n"
"    </xsl:otherwise>\n"
"    </xsl:choose>\n"
"    <xsl:if test=\"@mode = 'url' and .//v:text[@name='password_plain']\">\n"
"    if (length (self.nonce))\n"
"      {\n"
"        insert into VSPX_SESSION (VS_REALM, VS_SID, VS_EXPIRY, VS_IP)\n"
"          values (control.vl_realm, self.nonce, dateadd ('minute', -110, now ()), http_client_ip ());\n"
"      }\n"
"    </xsl:if>\n"
"authenticated:;\n"
"    <xsl:if test=\"@mode = 'cookie'\">\n"
"    declare cook_str, expire varchar;\n"
"    expire := date_rfc1123 (dateadd ('hour', 1, now()));\n"
"    cook_str :=\n"
"      	sprintf ('Set-Cookie: sid=%s; path=%s; expires=%s;\\r\\nSet-Cookie: realm=%s; path=%s; expires=%s;\\r\\n',\n"
"	self.sid, http_map_get ('domain'), expire, self.realm, http_map_get ('domain'), expire);\n"
"\n"
"    if (http_header_get () is null)\n"
"      cook_str := concat (http_header_get (), cook_str);\n"
"    if (length (self.sid) > 0)\n"
"      http_header (cook_str);\n"
"    </xsl:if>\n"
"    declare page_children any;\n"
"    page_children := self.vc_children;\n"
"    page_children[0] := null;\n"
"    self.vc_children := page_children;\n"
"    page_children := null;\n"
"</xsl:template>\n"
"\n"
"<!--\n"
"login bind method\n"
";\n", 
"-->\n"
"\n"
"<xsl:template match=\"v:login[@mode='digest']\" mode=\"data_bind_method\">\n"
"   --no_c_escapes-\n"
"   declare auth any;\n"
"   if (control.vc_data_bound)\n"
"     return 1;\n"
"   control.vc_data_bound := 1;\n"
"   auth := DB.DBA.vsp_auth_vec (lines);\n"
"\n"
"   if (not isarray (auth) or 'digest' &lt;&gt; lower (get_keyword ('authtype' , auth, '')))\n"
"     goto re_auth;\n"
"\n"
"   declare usr, sid, pass varchar;\n"
"   usr := get_keyword ('username' , auth, '');\n"
"   sid := get_keyword ('opaque' , auth, get_keyword ('nonce', auth, ''));\n"
"\n"
"   pass := <xsl:value-of select=\"@user-password\" /> (usr);\n"
"\n"
"   if (vspx_verify_pass (auth, pass))\n"
"     {\n"
"       declare vars any;\n"
"       vars := coalesce ((select deserialize (blob_to_string(VS_STATE)) from VSPX_SESSION where VS_SID = sid), NULL);\n"
"       connection_vars_set (vars);\n"
"       update VSPX_SESSION set VS_UID = usr, VS_EXPIRY = now () where VS_SID = sid and VS_REALM = control.vl_realm;\n"
"       if (row_count () = 0)\n"
"     goto re_auth;\n"
"      if (not control.vl_authenticated)\n"
"    connection_set ('vspx_user', usr);\n"
"       control.vl_authenticated := 1;\n"
"       control.vl_sid := sid;\n"
"       self.sid := sid;\n"
"       self.vc_authenticated := 1;\n"
"       self.realm := control.vl_realm;\n"
"       control.vl_user := usr;\n"
"      <xsl:for-each select=\".//v:variable[@persist = '1' or @persist = 'session']\">\n"
"      self.<xsl:value-of select=\"@name\" /> := connection_get ('<xsl:value-of select=\"@name\" />');\n"
"      </xsl:for-each>;\n"
"       goto authenticated;\n"
"     }\n"
"\n"
"\n"
"re_auth:\n"
"\n"
"   if ('<xsl:value-of select=\"v:login-form/@required\" />' = '1')\n"
"     {\n"
"       declare nonce , sid varchar;\n"
"       nonce := sid := md5 (concat (datestring (now ()), http_client_ip (), http_path ()));\n"
"       insert into VSPX_SESSION (VS_REALM, VS_SID, VS_UID, VS_STATE, VS_EXPIRY, VS_IP)\n"
"       values (control.vl_realm, sid, null, null, now (), http_client_ip ());\n"
"       control.vl_authenticated := 0;\n"
"       self.vc_authenticated := 0;\n"
"       self.sid := sid;\n"
"       self.realm := control.vl_realm;\n"
"       DB.DBA.vsp_auth_get (control.vl_realm, http_map_get ('domain'), nonce, sid, 'false', lines, 0);\n"
"     }\n"
"    <xsl:if test=\"v:template[@type='if-no-login']/@redirect\">\n"
"     {\n"
"       declare pars, req_url, pars_arr, i, l any;\n"
"       pars := http_request_get ('QUERY_STRING');\n"
"       pars_arr := split_and_decode (pars);\n"
"       l := length (pars_arr);\n"
"       req_url := http_path ();\n"
"       if (l &gt; 0 and mod (l, 2) = 0)\n"
"         {\n"
"           req_url := req_url || '?';\n"
"           for (i := 0; i &lt; l; i := i + 2)\n"
"              {\n"
"                if (pars_arr [i] not in ('sid', 'realm'))\n"
"                  req_url := req_url || sprintf ('%U', pars_arr [i]) || '=' || sprintf ('%U', pars_arr [i+1]) || '&amp;';\n"
"              }\n"
"           req_url := rtrim (req_url, '&amp;');\n"
"         }\n"
"\n"
"       http_request_status ('HTTP/1.1 302 Found');\n"
"       http_header (concat ('Location: <xsl:value-of select=\"v:template[@type='if-no-login']/@redirect\" />',\n"
"       	sprintf ('?URL=%U\\r\\n', req_url)));\n"
"     }\n"
"    </xsl:if>\n"
"authenticated:;\n"
"    declare page_children any;\n"
"    page_children := self.vc_children;\n"
"    page_children[0] := null;\n"
"    self.vc_children := page_children;\n"
"    page_children := null;\n"
"</xsl:template>\n"
"\n"
"<!--\n"
"fields bind method\n"
";\n", 
"-->\n"
"\n"
"<xsl:template match=\"v:field[@value]|v:textarea|v:text\" mode=\"data_bind_method\">\n"
"<!--\n"
"   <xsl:if test=\"@value like '-#-#%'\">\n"
"   if (not control.vc_data_bound and control.vc_enabled and control.vc_parent.vc_enabled)\n"
"     {\n"
"       control.ufl_value := <xsl:apply-templates select=\"@value\" mode=\"value\" />;\n"
"       control.vc_data_bound := 1;\n"
"     }\n"
"   </xsl:if>\n"
"-->\n"
"</xsl:template>\n"
"\n"
"<!--\n"
"checkbox control bind method\n"
";\n", 
"-->\n"
"\n"
"\n"
"<!--\n"
"tree control bind method\n"
";\n", 
"-->\n"
"\n"
"<xsl:template match=\"v:tree\" mode=\"data_bind_method\">\n"
"    declare root, chil, childs, start_path any;\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"starts-with(@start-path, '--')\">\n"
"    start_path := <xsl:apply-templates select=\"@start-path\" mode=\"value\" />;\n"
"      </xsl:when>\n"
"      <xsl:otherwise>\n"
"    start_path := <xsl:apply-templates select=\"@start-path\" mode=\"static_value\" />;\n"
"      </xsl:otherwise>\n"
"    </xsl:choose>\n"
"    root := <xsl:value-of select=\"@root\" /> (start_path);\n"
"    declare i, l int;\n"
"    i := 0; l := length (root);\n"
"    childs := make_array (l, 'any');\n"
"    while (i &lt; l) {\n"
"      declare node, dummy vspx_tree_node;\n"
"      dummy := null;\n"
"      node := self.vc_data_bind_node_<xsl:value-of select=\"@name\"/> (control, dummy, e, root[i], start_path, i, 0);\n"
"      aset (childs, i, node);\n"
"      i := i + 1;\n"
"    }\n"
"    control.vc_children := childs;\n"
"    self.vc_get_focus (e);\n"
"    <xsl:if test=\"@multi-branch = '0'\">\n"
"    i := 0;\n"
"    while (i &lt; l) {\n"
"      declare node vspx_tree_node;\n"
"      node := control.vc_children [i];\n"
"      if (node.tn_open and not node.vc_focus and e.ve_is_post and control.vc_focus) {\n"
"        node.tn_open := 0;\n"
"        node.vc_close_all_childs ();\n"
"      }\n"
"      i := i + 1;\n"
"    }\n"
"    </xsl:if>\n"
"</xsl:template>\n"
"\n"
"<!--\n"
"isql node control bind method\n"
";\n", 
"-->\n"
"\n"
"<xsl:template match=\"v:isql\" mode=\"system_post\">\n"
"  if(e.ve_is_post) {\n"
"    -- late binding from controls, if they exist\n"
"    control.isql_text := get_keyword ('<xsl:value-of select=\"@name\"/>_text', e.ve_params, control.isql_text);\n"
"    control.isql_password := get_keyword ('<xsl:value-of select=\"@name\"/>_pwd', e.ve_params, control.isql_password);\n"
"    control.isql_user :=  get_keyword ('<xsl:value-of select=\"@name\"/>_user', e.ve_params, control.isql_user);\n"
"    control.isql_isolation := get_keyword ('<xsl:value-of select=\"@name\"/>_isolation', e.ve_params, control.isql_isolation);\n"
"    control.isql_maxrows :=  cast( get_keyword('<xsl:value-of select=\"@name\"/>_maxrows', e.ve_params, cast(control.isql_maxrows as varchar)) as integer);\n"
"    control.isql_explain :=  cast( get_keyword('<xsl:value-of select=\"@name\"/>_explain', e.ve_params, cast(control.isql_explain as varchar)) as integer);\n"
"  }\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:isql\" mode=\"action_method\">\n"
"\n"
"  declare templ_input, templ_result, templ_error vspx_template;\n"
"\n"
"  if(control.isql_custom_exec = 1) {\n"
"    return;\n"
"  }\n"
"\n"
"  templ_input := control.vc_find_control ('<xsl:value-of select=\"v:template[@type='input']/@name\" />');\n"
"  templ_result := control.vc_find_control ('<xsl:value-of select=\"v:template[@type='result']/@name\" />');\n"
"  templ_error := control.vc_find_control ('<xsl:value-of select=\"v:template[@type='error']/@name\" />');\n"
"\n"
"  if(get_keyword ('<xsl:value-of select=\"@name\"/>_submit', e.ve_params, NULL) is NULL) {\n"
"    return;\n"
"  }\n"
"  if (e.ve_is_post) {\n"
"\n"
"    control.isql_exec(); -- actual sql script execution\n"
"\n"
"    if(length(control.vc_error_message) = 0 ) {\n"
"      templ_input.vc_enabled := 1;\n"
"      templ_result.vc_enabled := 0;\n"
"      if (templ_error is not null)\n"
"        templ_error.vc_enabled := 0;\n"
"      templ_input.vc_data_bind (e);\n"
"    }\n"
"    else if(length(control.vc_error_message) = 1 and\n"
"        control.vc_error_message[0][0] &lt;&gt; '00000' ) {\n"
"      -- error occured in single statement execution\n"
"      templ_input.vc_enabled := 0;\n"
"      templ_result.vc_enabled := 0;\n"
"      if (templ_error is not null and not control.isql_chunked)\n"
"        {\n"
"	  templ_error.vc_enabled := 1;\n"
"	  templ_error.vc_data_bind (e);\n"
"        }\n"
"    }\n"
"    else {\n"
"      templ_input.vc_enabled := 0;\n"
"      templ_result.vc_enabled := 1;\n"
"      if (templ_error is not null)\n"
"        {\n"
"	  templ_error.vc_enabled := 0;\n"
"	}\n"
"      templ_result.vc_data_bind (e);\n"
"    }\n"
"  }\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:calendar\" mode=\"render_all\" >\n"
"    <xsl:text>&lt;?vsp </xsl:text>\n"
"    {\n"
"      control.vc_render ('<xsl:value-of select='@name' />');\n"
"    }\n"
"    <xsl:text> ?&gt;</xsl:text>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"v:isql\" mode=\"render_all\" >\n"
"    <xsl:text>&lt;?vsp </xsl:text>\n"
"    {\n"
"      control.vc_render ('<xsl:value-of select='@name' />');\n"
"    }\n"
"    <xsl:text> ?&gt;</xsl:text>\n"
"</xsl:template>\n"
"\n"
"<xsl:templa