/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.chart.axis;

import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.stream.Collectors;
import org.eclipse.trace4cps.common.jfreechart.chart.axis.Section;
import org.eclipse.trace4cps.common.jfreechart.chart.axis.SectionAxis;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.Range;

public final class AxisUtils {
    public static final FontRenderContext DEFAULT_FONT_RENDER_CONTEXT = new FontRenderContext(null, true, false);

    private AxisUtils() {
    }

    public static void calculateAndApplyFixedDimension(SymbolAxis axis, RectangleEdge edge) {
        AxisUtils.calculateAndApplyFixedDimension(axis, edge, DEFAULT_FONT_RENDER_CONTEXT);
    }

    public static void calculateAndApplyFixedDimension(SymbolAxis axis, RectangleEdge edge, FontRenderContext frc) {
        double fixedDimension = 0.0;
        String[] stringArray = axis.getSymbols();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String symbol = stringArray[n2];
            if (symbol != null) {
                Rectangle2D symbolBounds = axis.getTickLabelFont().getStringBounds(symbol, frc);
                fixedDimension = Math.max(fixedDimension, RectangleEdge.isLeftOrRight((RectangleEdge)edge) ? symbolBounds.getWidth() : symbolBounds.getHeight());
            }
            ++n2;
        }
        if (axis.getLabel() != null) {
            Rectangle2D labelBounds = axis.getLabelInsets().createOutsetRectangle(axis.getLabelFont().getStringBounds(axis.getLabel(), frc));
            fixedDimension += RectangleEdge.isLeftOrRight((RectangleEdge)edge) ? labelBounds.getHeight() : labelBounds.getWidth();
        }
        axis.setFixedDimension(fixedDimension);
    }

    public static void calculateAndApplyFixedDimension(SectionAxis axis, RectangleEdge edge) {
        AxisUtils.calculateAndApplyFixedDimension(axis, edge, DEFAULT_FONT_RENDER_CONTEXT);
    }

    public static void calculateAndApplyFixedDimension(SectionAxis axis, RectangleEdge edge, FontRenderContext frc) {
        double fixedDimension = 0.0;
        for (String sectionLabel : axis.getSections().stream().map(Section::getLabel).collect(Collectors.toList())) {
            if (sectionLabel == null) continue;
            String tickLabel = axis.createTickLabel(sectionLabel);
            Rectangle2D symbolBounds = axis.getTickLabelFont().getStringBounds(tickLabel, frc);
            symbolBounds = axis.getTickLabelInsets().createOutsetRectangle(symbolBounds);
            fixedDimension = Math.max(fixedDimension, RectangleEdge.isLeftOrRight((RectangleEdge)edge) ? symbolBounds.getWidth() : symbolBounds.getHeight());
        }
        if (axis.getLabel() != null) {
            Rectangle2D labelBounds = axis.getLabelInsets().createOutsetRectangle(axis.getLabelFont().getStringBounds(axis.getLabel(), frc));
            fixedDimension += RectangleEdge.isLeftOrRight((RectangleEdge)edge) ? labelBounds.getHeight() : labelBounds.getWidth();
        }
        axis.setFixedDimension(fixedDimension);
    }

    public static int calculateVisibleTickCount(TickUnit unit, Range range) {
        return (int)(Math.floor(range.getUpperBound() / unit.getSize()) - Math.ceil(range.getLowerBound() / unit.getSize()) + 1.0);
    }

    public static double scaleValue(double value, Range source, Range target) {
        if (!source.contains(value)) {
            throw new IllegalArgumentException("Value should lie within source range");
        }
        return (value - source.getLowerBound()) / source.getLength() * target.getLength() + target.getLowerBound();
    }
}

