/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class ParameterDialog
extends Dialog {
    private static final Map<String, Map<String, Object>> SETTINGS = new HashMap<String, Map<String, Object>>();
    private static final Object LOCK = new Object();
    private final String settingsKey;
    private static final String POSITIVE_DOUBLE_KEY = "POSITIVE_DOUBLE";
    private Text positiveDoubleInput;
    private boolean positiveDoubleOk = true;
    private static final String SELECTION_KEY = "SELECTION";
    private SelectionType selectionType;
    private CheckboxTableViewer cbtv;
    private static final String TIMEUNIT_KEY = "TIMEUNIT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParameterDialog(Shell parentShell, String settingsKey) {
        super(parentShell);
        this.settingsKey = settingsKey;
        Object object = LOCK;
        synchronized (object) {
            Map<String, Object> settings = SETTINGS.get(settingsKey);
            if (settings == null) {
                SETTINGS.put(settingsKey, new HashMap());
            }
        }
    }

    protected final Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.getShell().setText(this.getTitle());
        this.draw(composite);
        return composite;
    }

    protected abstract String getTitle();

    protected abstract void draw(Composite var1);

    protected void checkOkButton() {
        Button button = this.getButton(0);
        if (button != null) {
            boolean ok = this.checkSelection() && this.checkWindowWidth();
            button.setEnabled(ok && this.inputIsValid());
        }
    }

    protected boolean inputIsValid() {
        return true;
    }

    protected final boolean checkWindowWidth() {
        return this.positiveDoubleInput == null || this.positiveDoubleOk;
    }

    protected final boolean checkSelection() {
        if (this.cbtv == null) {
            return true;
        }
        if (this.selectionType == SelectionType.EXACTLY_ONE) {
            return this.get(SELECTION_KEY, List.class).size() == 1;
        }
        if (this.selectionType == SelectionType.AT_LEAST_ONE) {
            return this.get(SELECTION_KEY, List.class).size() >= 1;
        }
        return false;
    }

    protected final void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.checkOkButton();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSet(String key) {
        Object object = LOCK;
        synchronized (object) {
            return SETTINGS.get(this.settingsKey).containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(String key, Object value) {
        Object object = LOCK;
        synchronized (object) {
            SETTINGS.get(this.settingsKey).put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T get(String key, Class<T> clazz) {
        Object object = LOCK;
        synchronized (object) {
            return (T)SETTINGS.get(this.settingsKey).get(key);
        }
    }

    public double getPositiveDoubleValue() {
        return this.get(POSITIVE_DOUBLE_KEY, Double.class);
    }

    public List<String> getSelection() {
        return this.get(SELECTION_KEY, List.class);
    }

    public TimeUnit getTimeUnit() {
        return this.get(TIMEUNIT_KEY, TimeUnit.class);
    }

    Button addCheckbox(Composite gr, String msg, final String key, boolean initialValue) {
        if (!this.isSet(key)) {
            this.set(key, initialValue);
        }
        Label lb = new Label(gr, 256);
        lb.setText(msg);
        final Button cb = new Button(gr, 32);
        cb.setSelection(this.get(key, Boolean.class).booleanValue());
        cb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.set(key, cb.getSelection());
            }
        });
        return cb;
    }

    void addTimeUnitDropdown(Composite gr, String msg) {
        if (!this.isSet(TIMEUNIT_KEY)) {
            this.set(TIMEUNIT_KEY, (Object)TimeUnit.SECONDS);
        }
        Label lb = new Label(gr, 256);
        lb.setText(msg);
        final Combo cb = new Combo(gr, 12);
        String[] items = new String[]{TimeUnit.MICROSECONDS.toString(), TimeUnit.MILLISECONDS.toString(), TimeUnit.SECONDS.toString(), TimeUnit.MINUTES.toString(), TimeUnit.HOURS.toString(), TimeUnit.DAYS.toString()};
        cb.setItems(items);
        String selected = this.get(TIMEUNIT_KEY, TimeUnit.class).toString();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(selected)) {
                cb.select(i);
                break;
            }
            ++i;
        }
        cb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = cb.getSelectionIndex();
                String selection = cb.getItem(idx);
                ParameterDialog.this.set(ParameterDialog.TIMEUNIT_KEY, (Object)TimeUnit.valueOf(selection));
            }
        });
    }

    void addText(Composite gr, String msg, final String key, String defaultValue) {
        if (!this.isSet(key)) {
            this.set(key, defaultValue);
        }
        Label lb = new Label(gr, 256);
        lb.setText(msg);
        final Text text = new Text(gr, 2052);
        GridData eData = new GridData();
        eData.horizontalIndent = 0;
        eData.horizontalAlignment = 4;
        eData.grabExcessHorizontalSpace = true;
        eData.widthHint = 150;
        text.setText(this.get(key, String.class));
        text.setLayoutData((Object)eData);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterDialog.this.set(key, text.getText());
            }
        });
    }

    Composite addPositiveDoubleInput(Composite main, boolean includeZero) {
        return this.addPositiveDoubleInput(main, "Window width (" + TimeUnit.SECONDS.toString().toLowerCase() + ")", includeZero);
    }

    Composite addPositiveDoubleInput(Composite gr, String msg, final boolean includeZero) {
        if (!this.isSet(POSITIVE_DOUBLE_KEY)) {
            this.set(POSITIVE_DOUBLE_KEY, includeZero ? 0.0 : 1.0);
        }
        if (msg != null) {
            Label label = new Label(gr, 256);
            label.setText(msg);
        }
        Composite inputGroup = new Composite(gr, 0);
        GridLayout inputLayout = new GridLayout(2, true);
        inputLayout.marginWidth = 0;
        inputGroup.setLayout((Layout)inputLayout);
        GridData data = new GridData(4, 4, true, false);
        inputGroup.setLayoutData((Object)data);
        this.positiveDoubleInput = new Text(inputGroup, 2052);
        GridData eData = new GridData();
        eData.horizontalIndent = 0;
        eData.horizontalAlignment = 4;
        eData.grabExcessHorizontalSpace = true;
        eData.widthHint = 150;
        this.positiveDoubleInput.setText(Double.toString(this.get(POSITIVE_DOUBLE_KEY, Double.class)));
        this.positiveDoubleInput.setLayoutData((Object)eData);
        final Text errorMsg = new Text(inputGroup, 72);
        GridData errorData = new GridData();
        errorData.horizontalAlignment = 128;
        errorData.grabExcessHorizontalSpace = true;
        errorData.minimumWidth = 150;
        errorMsg.setLayoutData((Object)errorData);
        errorMsg.setBackground(errorMsg.getDisplay().getSystemColor(22));
        errorMsg.setForeground(errorMsg.getDisplay().getSystemColor(3));
        errorMsg.setLayoutData((Object)errorData);
        errorMsg.setVisible(false);
        this.positiveDoubleInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String s = ParameterDialog.this.positiveDoubleInput.getText();
                ParameterDialog.this.positiveDoubleOk = true;
                try {
                    double v = Double.parseDouble(s);
                    if (v < 0.0 || v == 0.0 && !includeZero) {
                        ParameterDialog.this.positiveDoubleOk = false;
                    } else {
                        ParameterDialog.this.set(ParameterDialog.POSITIVE_DOUBLE_KEY, v);
                    }
                }
                catch (NumberFormatException ex) {
                    ParameterDialog.this.positiveDoubleOk = false;
                }
                if (ParameterDialog.this.positiveDoubleOk) {
                    errorMsg.setVisible(false);
                } else if (!errorMsg.isDisposed()) {
                    errorMsg.setText("Not a positive real");
                    errorMsg.setVisible(true);
                    errorMsg.getParent().update();
                }
                ParameterDialog.this.checkOkButton();
            }
        });
        return inputGroup;
    }

    void addSelectionInput(Composite main, String title, SelectionType selectionType, Collection<String> items) {
        this.selectionType = selectionType;
        if (!this.isSet(SELECTION_KEY)) {
            this.set(SELECTION_KEY, new ArrayList());
        }
        Group gr = new Group(main, 4);
        gr.setText(title);
        gr.setLayout((Layout)new GridLayout(1, true));
        GridData data = new GridData(4, 4, true, false);
        gr.setLayoutData((Object)data);
        ArrayList<String> input = new ArrayList<String>();
        input.addAll(items);
        Collections.sort(input);
        this.cbtv = CheckboxTableViewer.newCheckList((Composite)gr, (int)2048);
        this.cbtv.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.cbtv.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cbtv.setInput(input);
        List selection = this.get(SELECTION_KEY, List.class);
        this.cbtv.setCheckedElements(selection.toArray());
        this.cbtv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }
        });
        this.cbtv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CheckboxTableViewer source = (CheckboxTableViewer)event.getSource();
                ArrayList<String> newSelection = new ArrayList<String>();
                Object[] objectArray = source.getCheckedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    newSelection.add(o.toString());
                    ++n2;
                }
                ParameterDialog.this.set(ParameterDialog.SELECTION_KEY, newSelection);
                ParameterDialog.this.checkOkButton();
            }
        });
        this.addSelectionButtons(main, this.cbtv);
    }

    private void addSelectionButtons(Composite composite, final CheckboxTableViewer cbtv) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(1, 128, true, false));
        Button selectButton = new Button(buttonComposite, 0);
        selectButton.setText("Select all");
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                cbtv.setAllChecked(true);
                cbtv.setSelection(cbtv.getSelection(), true);
            }
        });
        Button deselectButton = new Button(buttonComposite, 0);
        deselectButton.setText("Deselect all");
        deselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                cbtv.setAllChecked(false);
                cbtv.setSelection(cbtv.getSelection(), true);
            }
        });
    }

    static enum SelectionType {
        EXACTLY_ONE,
        AT_LEAST_ONE;

    }
}

