/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tools.launch.core.factory;

import org.eclipse.core.resources.IProject;
import org.eclipse.linuxtools.tools.launch.core.properties.LinuxtoolsPathProperty;

public abstract class LinuxtoolsProcessFactory {
    private static final String PATH = "PATH";
    private static final String PATH_EQUAL = "PATH=";
    private static final String SEPARATOR = ":";

    private String getEnvpPath(String[] envp) {
        String[] stringArray = envp;
        int n = envp.length;
        int n2 = 0;
        while (n2 < n) {
            String env = stringArray[n2];
            if (env.startsWith(PATH_EQUAL)) {
                return env.substring(PATH_EQUAL.length());
            }
            ++n2;
        }
        return null;
    }

    protected String[] updateEnvironment(String[] envp, IProject project) {
        String[] newEnvp;
        if (project == null) {
            return envp;
        }
        if (envp == null) {
            envp = new String[]{};
        }
        String ltPath = LinuxtoolsPathProperty.getInstance().getLinuxtoolsPath(project);
        String envpPath = this.getEnvpPath(envp);
        String systemPath = System.getenv(PATH);
        StringBuffer newPath = new StringBuffer();
        newPath.append(PATH_EQUAL);
        if (ltPath != null && ltPath.length() > 0) {
            newPath.append(ltPath);
            newPath.append(SEPARATOR);
        }
        if (envpPath != null && envpPath.length() > 0) {
            newPath.append(envpPath);
            newPath.append(SEPARATOR);
        }
        if (systemPath != null && systemPath.length() > 0) {
            newPath.append(systemPath);
            newPath.append(SEPARATOR);
        }
        if (newPath.length() == PATH_EQUAL.length()) {
            return envp;
        }
        if (envpPath != null) {
            newEnvp = new String[envp.length];
            int i = 0;
            while (i < envp.length) {
                newEnvp[i] = envp[i].startsWith(PATH_EQUAL) ? newPath.toString() : envp[i];
                ++i;
            }
        } else {
            newEnvp = new String[envp.length + 1];
            int i = 0;
            while (i < envp.length) {
                newEnvp[i] = envp[i];
                ++i;
            }
            newEnvp[envp.length] = newPath.toString();
        }
        return newEnvp;
    }
}

