/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.mgmt.PropertiesUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.dto.ServiceReferenceDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceReferenceMTO
implements Serializable {
    public static final byte EXPORTED = 1;
    public static final byte IMPORTED = 2;
    public static final byte LOCAL = 0;
    private static final long serialVersionUID = -4088391130982105496L;
    private final long id;
    private final long bundle;
    private final Map<String, Object> properties;
    private final long[] usingBundles;
    private final int exportImportMode;

    public static ServiceReferenceMTO createMTO(ServiceReferenceDTO dto, int exportImportMode) {
        return new ServiceReferenceMTO(dto, exportImportMode);
    }

    private Map<String, Object> getMapFromProperties(ServiceReference<?> ref) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] stringArray = ref.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            result.put(key, ref.getProperty(key));
            ++n2;
        }
        return result;
    }

    public static ServiceReferenceMTO createMTO(ServiceReference<?> ref, int exportImportMode) {
        return new ServiceReferenceMTO(ref, exportImportMode);
    }

    public static ServiceReferenceMTO createMTO(ServiceReferenceDTO dto) {
        return new ServiceReferenceMTO(dto, 0);
    }

    public static long[] usingBundles(ServiceReference<?> ref) {
        Bundle[] using = ref.getUsingBundles();
        if (using == null) {
            return new long[0];
        }
        List<Bundle> bundles = Arrays.asList(using);
        long[] results = new long[bundles.size()];
        int i = 0;
        Iterator<Bundle> it = bundles.iterator();
        while (it.hasNext()) {
            results[i] = it.next().getBundleId();
            ++i;
        }
        return results;
    }

    ServiceReferenceMTO(ServiceReference<?> ref, int exportImportMode) {
        this.id = (Long)ref.getProperty("service.id");
        this.bundle = ref.getBundle().getBundleId();
        this.properties = PropertiesUtil.convertMapToSerializableMap(this.getMapFromProperties(ref));
        this.usingBundles = ServiceReferenceMTO.usingBundles(ref);
        this.exportImportMode = exportImportMode;
    }

    ServiceReferenceMTO(ServiceReferenceDTO srDTO, int exportImportMode) {
        this.id = srDTO.id;
        this.bundle = srDTO.bundle;
        this.properties = PropertiesUtil.convertMapToSerializableMap((Map)srDTO.properties);
        this.usingBundles = srDTO.usingBundles;
        this.exportImportMode = exportImportMode;
    }

    public long getId() {
        return this.id;
    }

    public long getBundle() {
        return this.bundle;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public long[] getUsingBundles() {
        return this.usingBundles;
    }

    public String[] getServices() {
        return (String[])this.properties.get("objectClass");
    }

    public int getRanking() {
        Integer ranking = (Integer)this.properties.get("service.ranking");
        if (ranking == null) {
            return 0;
        }
        return ranking;
    }

    public String toString() {
        return "ServiceReferenceMTO [id=" + this.id + ", bundle=" + this.bundle + ", properties=" + this.properties + ", usingBundles=" + Arrays.toString(this.usingBundles) + ", exportImportMode=" + this.exportImportMode + "]";
    }

    public int getExportImportMode() {
        return this.exportImportMode;
    }
}

