/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class Statements {
    @Experimental
    public static Function<Triple, Resource> TRIPLE_BNODE_MAPPER = t -> SimpleValueFactory.getInstance().createBNode(Base64.getUrlEncoder().encodeToString(t.stringValue().getBytes(StandardCharsets.UTF_8)));

    public static void consume(ValueFactory vf, Resource subject, IRI predicate, Value object, Consumer<Statement> consumer, Resource ... contexts) {
        Objects.requireNonNull(contexts, "contexts argument may not be null; either the value should be cast to Resource or an empty array should be supplied");
        Objects.requireNonNull(consumer);
        if (contexts.length > 0) {
            for (Resource context : contexts) {
                consumer.accept(vf.createStatement(subject, predicate, object, context));
            }
        } else {
            consumer.accept(vf.createStatement(subject, predicate, object));
        }
    }

    public static <C extends Collection<Statement>> C create(ValueFactory vf, Resource subject, IRI predicate, Value object, C collection, Resource ... contexts) {
        Objects.requireNonNull(collection);
        Statements.consume(vf, subject, predicate, object, st -> collection.add(st), contexts);
        return collection;
    }

    public static Statement stripContext(Statement statement) {
        return Statements.stripContext((ValueFactory)SimpleValueFactory.getInstance(), statement);
    }

    public static Statement stripContext(ValueFactory vf, Statement statement) {
        if (statement.getContext() == null) {
            return statement;
        }
        return vf.createStatement(statement.getSubject(), statement.getPredicate(), statement.getObject());
    }

    @Deprecated(since="3.5.0")
    public static Triple toTriple(Statement statement) {
        return Statements.toTriple((ValueFactory)SimpleValueFactory.getInstance(), statement);
    }

    @Deprecated(since="3.5.0")
    public static Triple toTriple(ValueFactory vf, Statement statement) {
        return vf.createTriple(statement.getSubject(), statement.getPredicate(), statement.getObject());
    }

    public static Statement toStatement(Triple triple) {
        return Statements.statement(triple);
    }

    public static Statement statement(Triple triple) {
        return Statements.toStatement(triple, null);
    }

    public static Statement statement(Triple triple, Resource context) {
        return Statements.statement((ValueFactory)SimpleValueFactory.getInstance(), triple, context);
    }

    public static Statement toStatement(Triple triple, Resource context) {
        return Statements.statement((ValueFactory)SimpleValueFactory.getInstance(), triple, context);
    }

    public static Statement toStatement(ValueFactory vf, Triple triple, Resource context) {
        return Statements.statement(vf, triple, context);
    }

    public static Statement statement(ValueFactory vf, Triple triple, Resource context) {
        return vf.createStatement(triple.getSubject(), triple.getPredicate(), triple.getObject(), context);
    }

    public static Statement statement(Resource subject, IRI predicate, Value object, Resource context) {
        return Statements.statement((ValueFactory)SimpleValueFactory.getInstance(), subject, predicate, object, context);
    }

    public static Statement statement(ValueFactory vf, Resource subject, IRI predicate, Value object, Resource context) {
        return vf.createStatement(subject, predicate, object, context);
    }

    public static boolean isSameTriple(Statement st1, Statement st2) {
        Objects.requireNonNull(st1);
        Objects.requireNonNull(st2);
        return st1.getPredicate().equals((Object)st2.getPredicate()) && st1.getSubject().equals((Object)st2.getSubject()) && st1.getObject().equals((Object)st2.getObject());
    }

    @Experimental
    public static void convertRDFStarToReification(Statement st, Consumer<Statement> consumer) {
        Statements.convertRDFStarToReification((ValueFactory)SimpleValueFactory.getInstance(), st, consumer);
    }

    @Experimental
    public static void convertRDFStarToReification(ValueFactory vf, Statement st, Consumer<Statement> consumer) {
        Statements.convertRDFStarToReification(vf, TRIPLE_BNODE_MAPPER, st, consumer);
    }

    @Experimental
    public static void convertRDFStarToReification(ValueFactory vf, Function<Triple, Resource> reifiedIdMapper, Statement st, Consumer<Statement> consumer) {
        Resource subject = st.getSubject();
        Value object = st.getObject();
        if (subject instanceof Triple || object instanceof Triple) {
            if (subject instanceof Triple) {
                subject = Statements.createReifiedStatement(vf, reifiedIdMapper, (Triple)subject, st.getContext(), consumer);
            }
            if (object instanceof Triple) {
                object = Statements.createReifiedStatement(vf, reifiedIdMapper, (Triple)object, st.getContext(), consumer);
            }
            st = vf.createStatement(subject, st.getPredicate(), object, st.getContext());
        }
        consumer.accept(st);
    }

    private static Resource createReifiedStatement(ValueFactory vf, Function<Triple, Resource> reifiedIdMapper, Triple triple, Resource context, Consumer<Statement> consumer) {
        Resource stId = reifiedIdMapper.apply(triple);
        Statement reifiedSt = vf.createStatement(stId, RDF.TYPE, (Value)RDF.STATEMENT, context);
        consumer.accept(reifiedSt);
        Statement reifiedStSubject = vf.createStatement(stId, RDF.SUBJECT, (Value)triple.getSubject(), context);
        Statements.convertRDFStarToReification(vf, reifiedIdMapper, reifiedStSubject, consumer);
        Statement reifiedStPredicate = vf.createStatement(stId, RDF.PREDICATE, (Value)triple.getPredicate(), context);
        consumer.accept(reifiedStPredicate);
        Statement reifiedStObject = vf.createStatement(stId, RDF.OBJECT, triple.getObject(), context);
        Statements.convertRDFStarToReification(vf, reifiedIdMapper, reifiedStObject, consumer);
        return stId;
    }
}

