/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.federation;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.repository.sparql.federation.JoinExecutorBase;

public class ServiceJoinIterator
extends JoinExecutorBase<BindingSet> {
    protected Service service;
    protected EvaluationStrategy strategy;

    public ServiceJoinIterator(CloseableIteration<BindingSet> leftIter, Service service, BindingSet bindings, EvaluationStrategy strategy) throws QueryEvaluationException {
        super(leftIter, (TupleExpr)service, bindings);
        this.service = service;
        this.strategy = strategy;
        this.run();
    }

    protected void handleBindings() throws Exception {
        Var serviceRef = this.service.getServiceRef();
        if (!serviceRef.hasValue()) {
            while (!this.isClosed() && this.leftIter.hasNext()) {
                this.addResult(this.strategy.evaluate((TupleExpr)this.service, (BindingSet)this.leftIter.next()));
            }
            return;
        }
        String serviceUri = serviceRef.getValue().stringValue();
        FederatedService fs = this.strategy.getService(serviceUri);
        this.addResult(fs.evaluate(this.service, this.leftIter, this.service.getBaseURI()));
    }
}

