/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.am3.dsls.km3.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gmt.am3.dsls.km3.KM3Projector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class KM3Extractor
implements IObjectActionDelegate {
    private AtlModelHandler amh = AtlModelHandler.getDefault((String)"EMF");
    private ISelection selection;
    private KM3Projector kp = KM3Projector.getKM3Projector();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        try {
            IFile file = (IFile)((IStructuredSelection)this.selection).getFirstElement();
            InputStream in = file.getContents();
            ASMModel model = this.amh.loadModel(file.getName(), this.kp.getEMFKM3Metamodel(), in);
            String km3 = this.kp.getStringFromKM3(model);
            String name = file.getName();
            name = String.valueOf(name.substring(0, name.length() - file.getFileExtension().length())) + "km3";
            if (km3 != null) {
                IWorkspace wks = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot wksroot = wks.getRoot();
                IFile fileCreated = wksroot.getFile(file.getFullPath().removeLastSegments(1).append(name));
                InputStream stream = this.openContentStream(km3);
                if (fileCreated.exists()) {
                    fileCreated.setContents(stream, true, true, null);
                } else {
                    fileCreated.create(stream, true, null);
                }
                try {
                    stream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private InputStream openContentStream(String contents) {
        return new ByteArrayInputStream(contents.getBytes());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

