/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFSClass.java,v 1.1 2007/03/18 08:10:13 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfs;

import org.eclipse.emf.common.util.EList;

import org.eclipse.eodm.rdf.rdfbase.RDFSResource;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>RDFS Class</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfs.RDFSClass#getRDFSsubClassOf <em>RDFSsubClassOf</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfs.RDFSClass#getSubClass <em>subClass</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfs.RDFSClass#getPropertyForDomain <em>propertyForDomain</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfs.RDFSClass#getPropertyForRange <em>propertyForRange</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.rdf.rdfs.util.RDFSPackage#getRDFSClass()
 * @model
 * @generated
 */
public interface RDFSClass extends RDFSResource {
	/**
	 * Returns the value of the '<em><b>RDFSsubClassOf</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfs.RDFSClass}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfs.RDFSClass#getSubClass <em>subClass</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>RDF Ssub Class Of</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>RDFSsubClassOf</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfs.util.RDFSPackage#getRDFSClass_RDFSsubClassOf()
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSClass#getSubClass
	 * @model type="org.eclipse.eodm.rdf.rdfs.RDFSClass" opposite="subClass"
	 * @generated
	 */
	EList getRDFSsubClassOf();

	/**
	 * Returns the value of the '<em><b>subClass</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfs.RDFSClass}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfs.RDFSClass#getRDFSsubClassOf <em>RDFSsubClassOf</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sub Class</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>subClass</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfs.util.RDFSPackage#getRDFSClass_SubClass()
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSClass#getRDFSsubClassOf
	 * @model type="org.eclipse.eodm.rdf.rdfs.RDFSClass" opposite="RDFSsubClassOf"
	 * @generated
	 */
	EList getSubClass();

	/**
	 * Returns the value of the '<em><b>propertyForDomain</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.RDFProperty}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfbase.RDFProperty#getRDFSdomain <em>RDFSdomain</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Property For Domain</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>propertyForDomain</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfs.util.RDFSPackage#getRDFSClass_PropertyForDomain()
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFProperty#getRDFSdomain
	 * @model type="org.eclipse.eodm.rdf.rdfbase.RDFProperty" opposite="RDFSdomain"
	 * @generated
	 */
	EList getPropertyForDomain();

	/**
	 * Returns the value of the '<em><b>propertyForRange</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.RDFProperty}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfbase.RDFProperty#getRDFSrange <em>RDFSrange</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Property For Range</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>propertyForRange</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfs.util.RDFSPackage#getRDFSClass_PropertyForRange()
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFProperty#getRDFSrange
	 * @model type="org.eclipse.eodm.rdf.rdfbase.RDFProperty" opposite="RDFSrange"
	 * @generated
	 */
	EList getPropertyForRange();

	/**
	 * Returns the value of the '<em><b>typedResource</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.RDFSResource}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFtype <em>RDFtype</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>typedResource</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfs.util.RDFSPackage#getRDFSClass_TypedResource()
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFtype
	 * @model type="org.eclipse.eodm.rdf.rdfbase.RDFSResource" opposite="RDFtype"
	 */	
	EList getTypedResource();

} // RDFSClass
