/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.deploy.edit.parts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.draw2d.Cube3DFigure;
import org.eclipse.uml2.diagram.common.editparts.PrimaryShapeEditPart;
import org.eclipse.uml2.diagram.common.editpolicies.UpdateDescriptionEditPolicy;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterLinkDescriptor;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterNodeDescriptor;
import org.eclipse.uml2.diagram.deploy.edit.parts.NodeNameEditPart;
import org.eclipse.uml2.diagram.deploy.edit.policies.NodeCanonicalEditPolicy;
import org.eclipse.uml2.diagram.deploy.edit.policies.NodeGraphicalNodeEditPolicy;
import org.eclipse.uml2.diagram.deploy.edit.policies.NodeItemSemanticEditPolicy;
import org.eclipse.uml2.diagram.deploy.part.UMLDiagramUpdateCommand;
import org.eclipse.uml2.diagram.deploy.part.UMLDiagramUpdater;
import org.eclipse.uml2.diagram.deploy.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeEditPart
extends ShapeNodeEditPart
implements PrimaryShapeEditPart {
    public static final int VISUAL_ID = 2004;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private LinkTargetListener myLinkTargetListener;

    public NodeEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        if (UMLVisualIDRegistry.isShortcutDescendant(this.getNotationView())) {
            this.installEditPolicy(UpdateDescriptionEditPolicy.ROLE, (EditPolicy)new UpdateDescriptionEditPolicy(UMLDiagramUpdater.TYPED_ADAPTER, true));
        }
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new NodeItemSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new NodeGraphicalNodeEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new NodeCanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        NodeFigure figure = new NodeFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public NodeFigure getPrimaryShape() {
        return (NodeFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof NodeNameEditPart) {
            ((NodeNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getNameLabel());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        return super.getContentPaneFor(editPart);
    }

    protected org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(100), this.getMapMode().DPtoLP(60));
        return result;
    }

    protected org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure createNodeFigure() {
        org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(5003));
    }

    protected void handleNotificationEvent(Notification event) {
        if (event.getNotifier() == this.getModel() && EcorePackage.eINSTANCE.getEModelElement_EAnnotations().equals(event.getFeature())) {
            this.handleMajorSemanticChange();
        } else {
            super.handleNotificationEvent(event);
        }
        this.handleTypeLinkModification(event);
    }

    private DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = this.getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    private LinkTargetListener getLinkTargetListener() {
        if (this.myLinkTargetListener == null) {
            this.myLinkTargetListener = new LinkTargetListener();
        }
        return this.myLinkTargetListener;
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
        for (IUpdaterNodeDescriptor iUpdaterNodeDescriptor : this.getNode_2004ContainedLinks()) {
            EObject nextLink = iUpdaterNodeDescriptor.getModelElement();
            if (nextLink == null) continue;
            switch (iUpdaterNodeDescriptor.getVisualID()) {
                case 4001: {
                    this.getLinkTargetListener().addReferenceListener(nextLink, (EStructuralFeature)UMLPackage.eINSTANCE.getDeployment_DeployedArtifact());
                    break;
                }
            }
        }
    }

    private List<IUpdaterLinkDescriptor> getNode_2004ContainedLinks() {
        return UMLDiagramUpdater.getNode_2004ContainedLinks(this.getNotationView());
    }

    protected void removeSemanticListeners() {
        super.removeSemanticListeners();
        this.getLinkTargetListener().dispose();
    }

    private void handleTypeLinkModification(Notification event) {
        if (event.getFeature() == UMLPackage.eINSTANCE.getDeploymentTarget_Deployment()) {
            block0 : switch (event.getEventType()) {
                case 3: {
                    Object link = event.getNewValue();
                    if (link instanceof Deployment) {
                        this.getLinkTargetListener().addReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getDeployment_DeployedArtifact());
                    }
                    if (!(link instanceof Deployment)) break;
                    this.refreshDiagram();
                    break;
                }
                case 4: {
                    Object link = event.getOldValue();
                    if (link instanceof Deployment) {
                        this.getLinkTargetListener().removeReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getDeployment_DeployedArtifact());
                    }
                    if (!(link instanceof Deployment)) break;
                    this.refreshDiagram();
                    break;
                }
                case 5: {
                    List links = (List)event.getNewValue();
                    for (Object link : links) {
                        if (!(link instanceof Deployment)) continue;
                        this.getLinkTargetListener().addReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getDeployment_DeployedArtifact());
                    }
                    for (Object link : links) {
                        if (!(link instanceof Deployment)) continue;
                        this.refreshDiagram();
                        break block0;
                    }
                    break;
                }
                case 6: {
                    List links = (List)event.getOldValue();
                    for (Object link : links) {
                        if (!(link instanceof Deployment)) continue;
                        this.getLinkTargetListener().removeReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getDeployment_DeployedArtifact());
                    }
                    for (Object link : links) {
                        if (!(link instanceof Deployment)) continue;
                        this.refreshDiagram();
                        break block0;
                    }
                    break;
                }
            }
        }
    }

    public void refreshDiagram() {
        UMLDiagramUpdateCommand.performCanonicalUpdate(this.getDiagramView().getElement());
    }

    private class LinkTargetListener
    implements NotificationListener {
        Map<EObject, Set<EStructuralFeature>> myNotifiers = new HashMap<EObject, Set<EStructuralFeature>>();

        private LinkTargetListener() {
        }

        private void added(EObject link, EStructuralFeature feature) {
            if (!this.myNotifiers.containsKey(link)) {
                this.myNotifiers.put(link, new HashSet());
            }
            this.myNotifiers.get(link).add(feature);
        }

        private void removed(EObject link, EStructuralFeature feature) {
            if (!this.myNotifiers.containsKey(link)) {
                return;
            }
            this.myNotifiers.get(link).remove(feature);
        }

        public void dispose() {
            Set<Map.Entry<EObject, Set<EStructuralFeature>>> entrySet = this.myNotifiers.entrySet();
            for (Map.Entry<EObject, Set<EStructuralFeature>> entry : entrySet) {
                for (EStructuralFeature feature : entry.getValue()) {
                    NodeEditPart.this.getDiagramEventBroker().removeNotificationListener(entry.getKey(), (Object)feature, (NotificationListener)this);
                }
            }
        }

        private void removeReferenceListener(EObject link, EStructuralFeature feature) {
            NodeEditPart.this.getDiagramEventBroker().removeNotificationListener(link, (Object)feature, (NotificationListener)this);
            this.removed(link, feature);
        }

        private void addReferenceListener(EObject link, EStructuralFeature feature) {
            NodeEditPart.this.getDiagramEventBroker().addNotificationListener(link, feature, (NotificationListener)this);
            this.added(link, feature);
        }

        public void notifyChanged(Notification event) {
            if (event.getFeature() == UMLPackage.eINSTANCE.getDeployment_DeployedArtifact()) {
                NodeEditPart.this.refreshDiagram();
                return;
            }
        }
    }

    public class NodeFigure
    extends Cube3DFigure {
        private boolean myUseLocalCoordinates = false;

        public NodeFigure() {
            this.setTypeLabelVisible(false);
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }

        public Label getNameLabel() {
            return super.getNameLabel();
        }
    }
}

