/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.draw2d;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class BisectionBorderItemLocator
extends BorderItemLocator {
    public BisectionBorderItemLocator(IFigure parentFigure) {
        super(parentFigure);
    }

    public BisectionBorderItemLocator(IFigure parentFigure, int preferredSide) {
        super(parentFigure, preferredSide);
    }

    public BisectionBorderItemLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint) {
        super(borderItem, parentFigure, constraint);
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        int side = BisectionBorderItemLocator.findClosestSideOfParent((Rectangle)proposedLocation, (Rectangle)this.getParentBorder());
        return this.getBisectionLocation(super.getValidLocation(proposedLocation, borderItem), side);
    }

    public void relocate(IFigure borderItem) {
        Dimension size = this.getSize(borderItem);
        Rectangle rectSuggested = new Rectangle(this.getPreferredLocation(borderItem), size);
        int closestSide = BisectionBorderItemLocator.findClosestSideOfParent((Rectangle)rectSuggested, (Rectangle)this.getParentBorder());
        this.setPreferredSideOfParent(closestSide);
        Point ptNewLocation = this.locateOnBorder(this.getPreferredLocation(borderItem), this.getPreferredSideOfParent(), 0, borderItem);
        this.setCurrentSideOfParent(BisectionBorderItemLocator.findClosestSideOfParent((Rectangle)new Rectangle(ptNewLocation, size), (Rectangle)this.getParentBorder()));
        Rectangle bisectLoc = this.getBisectionLocation(new Rectangle(ptNewLocation, size), this.getCurrentSideOfParent());
        borderItem.getBounds().setBounds(bisectLoc);
    }

    protected Rectangle getBisectionLocation(Rectangle location, int side) {
        Rectangle bisectingLocation = new Rectangle(location);
        switch (side) {
            case 8: {
                bisectingLocation.x += bisectingLocation.width / 2;
                break;
            }
            case 16: {
                bisectingLocation.x -= bisectingLocation.width / 2;
                break;
            }
            case 1: {
                bisectingLocation.y += bisectingLocation.height / 2;
                break;
            }
            case 4: {
                bisectingLocation.y -= bisectingLocation.height / 2;
            }
        }
        return bisectingLocation;
    }

    private Point locateOnBorder(Point suggestedLocation, int suggestedSide, int circuitCount, IFigure borderItem) {
        Point recommendedLocation = this.locateOnParent(suggestedLocation, suggestedSide, borderItem);
        int vertical_gap = MapModeUtil.getMapMode((IFigure)this.getParentFigure()).DPtoLP(8);
        int horizontal_gap = MapModeUtil.getMapMode((IFigure)this.getParentFigure()).DPtoLP(8);
        Dimension borderItemSize = this.getSize(borderItem);
        if (circuitCount < 4 && this.conflicts(recommendedLocation, borderItem)) {
            if (suggestedSide == 8) {
                do {
                    recommendedLocation.y += borderItemSize.height + vertical_gap;
                } while (this.conflicts(recommendedLocation, borderItem));
                if (recommendedLocation.y > this.getParentBorder().getBottomLeft().y - borderItemSize.height) {
                    return this.locateOnBorder(recommendedLocation, 4, circuitCount + 1, borderItem);
                }
            } else if (suggestedSide == 4) {
                do {
                    recommendedLocation.x += borderItemSize.width + horizontal_gap;
                } while (this.conflicts(recommendedLocation, borderItem));
                if (recommendedLocation.x > this.getParentBorder().getBottomRight().x - borderItemSize.width) {
                    return this.locateOnBorder(recommendedLocation, 16, circuitCount + 1, borderItem);
                }
            } else if (suggestedSide == 16) {
                do {
                    recommendedLocation.y -= borderItemSize.height + vertical_gap;
                } while (this.conflicts(recommendedLocation, borderItem));
                if (recommendedLocation.y < this.getParentBorder().getTopRight().y) {
                    return this.locateOnBorder(recommendedLocation, 1, circuitCount + 1, borderItem);
                }
            } else {
                do {
                    recommendedLocation.x -= borderItemSize.width + horizontal_gap;
                } while (this.conflicts(recommendedLocation, borderItem));
                if (recommendedLocation.x < this.getParentBorder().getTopLeft().x) {
                    return this.locateOnBorder(recommendedLocation, 8, circuitCount + 1, borderItem);
                }
            }
        }
        return recommendedLocation;
    }

    private boolean conflicts(Point recommendedLocation, IFigure targetBorderItem) {
        Rectangle recommendedRect = new Rectangle(recommendedLocation, this.getSize(targetBorderItem));
        List borderItems = targetBorderItem.getParent().getChildren();
        int currentIndex = borderItems.indexOf(targetBorderItem);
        int i = 0;
        while (i < currentIndex) {
            Rectangle rect;
            IFigure borderItem = (IFigure)borderItems.get(i);
            if (borderItem.isVisible() && (rect = borderItem.getBounds().getCopy()).intersects(recommendedRect)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Point locateOnParent(Point suggestedLocation, int suggestedSide, IFigure borderItem) {
        Rectangle bounds = this.getParentBorder();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        Dimension borderItemSize = this.getSize(borderItem);
        int newX = suggestedLocation.x;
        int newY = suggestedLocation.y;
        int westX = parentFigureX - borderItemSize.width + this.getBorderItemOffset().width;
        int eastX = parentFigureX + parentFigureWidth - this.getBorderItemOffset().width;
        int southY = parentFigureY + parentFigureHeight - this.getBorderItemOffset().height;
        int northY = parentFigureY - borderItemSize.height + this.getBorderItemOffset().height;
        if (suggestedSide == 8) {
            if (suggestedLocation.x != westX) {
                newX = westX;
            }
            if (suggestedLocation.y < bounds.getTopLeft().y) {
                newY = northY + borderItemSize.height;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = southY - borderItemSize.height;
            }
        } else if (suggestedSide == 16) {
            if (suggestedLocation.x != eastX) {
                newX = eastX;
            }
            if (suggestedLocation.y < bounds.getTopLeft().y) {
                newY = northY + borderItemSize.height;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = southY - borderItemSize.height;
            }
        } else if (suggestedSide == 4) {
            if (suggestedLocation.y != southY) {
                newY = southY;
            }
            if (suggestedLocation.x < bounds.getBottomLeft().x) {
                newX = westX + borderItemSize.width;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = eastX - borderItemSize.width;
            }
        } else {
            if (suggestedLocation.y != northY) {
                newY = northY;
            }
            if (suggestedLocation.x < bounds.getBottomLeft().x) {
                newX = westX + borderItemSize.width;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = eastX - borderItemSize.width;
            }
        }
        return new Point(newX, newY);
    }
}

