/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.library.advice;

import java.util.ArrayList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class ThreadAdvice
extends AbstractEditHelperAdvice {
    public static final String RMS_THREAD_QN = "robotics::execcontainer::Thread";

    protected boolean approveCreateElementRequest(CreateElementRequest request) {
        IElementType type = request.getElementType();
        EObject container = request.getContainer();
        return type != null && container instanceof Class && StereotypeUtil.isApplied((Element)((Class)container), (String)"robotics::components::ComponentDefinition");
    }

    public boolean approveRequest(IEditCommandRequest request) {
        GetEditContextRequest context;
        if (request instanceof GetEditContextRequest && (context = (GetEditContextRequest)request).getEditCommandRequest() instanceof CreateElementRequest) {
            return this.approveCreateElementRequest((CreateElementRequest)context.getEditCommandRequest());
        }
        return super.approveRequest(request);
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        EObject newElement = request.getElementToConfigure();
        if (!(newElement instanceof Class)) {
            return super.getAfterConfigureCommand(request);
        }
        final Class cls = (Class)newElement;
        Element eClsOwner = cls.getOwner();
        if (!(eClsOwner instanceof Class) || !StereotypeUtil.isApplied((Element)((Class)eClsOwner), (String)"robotics::components::ComponentDefinition")) {
            return super.getAfterConfigureCommand(request);
        }
        final Class clsOwner = (Class)eClsOwner;
        final NamedElement threadType = ElementUtils.getQualifiedElementFromRS((Element)cls, (String)RMS_THREAD_QN);
        if (!(threadType instanceof Classifier)) {
            return super.getAfterConfigureCommand(request);
        }
        CompositeCommand compositeCommand = new CompositeCommand("Activity creation command");
        RecordingCommand typeElement = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)newElement)){

            protected void doExecute() {
                cls.createGeneralization((Classifier)threadType);
                StereotypeUtil.apply((Element)cls, (String)"robotics::components::Activity");
                int idx = 1;
                ArrayList<String> allNamesOfExistingActivities = new ArrayList<String>();
                for (Classifier c : clsOwner.getNestedClassifiers()) {
                    if (!(c instanceof Class) || !StereotypeUtil.isApplied((Element)c, (String)"robotics::components::Activity")) continue;
                    allNamesOfExistingActivities.add(c.getName());
                }
                while (allNamesOfExistingActivities.contains("Activity" + idx)) {
                    ++idx;
                }
                cls.setName("Activity" + idx);
                Property clsPart = clsOwner.createOwnedAttribute("activity" + idx, (Type)cls);
                StereotypeUtil.apply((Element)clsPart, (String)"robotics::components::ActivityInstance");
            }
        };
        compositeCommand.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)typeElement));
        return compositeCommand.isEmpty() ? super.getAfterConfigureCommand(request) : compositeCommand;
    }
}

