/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.cdteditor.sync;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.robotics.core.commands.PortCommands;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentPort;
import org.eclipse.papyrus.robotics.ros2.reverse.PortInfo;
import org.eclipse.papyrus.robotics.ros2.reverse.fromfile.ReversePortsFromSource;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.CreatePortUtils;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.ServiceDefUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

public class SyncPortsToModel {
    public static void sync(Class clazz, List<URI> pathMapURIs, IASTNode node, ITranslationUnit itu) {
        ReversePortsFromSource reversePorts = new ReversePortsFromSource(clazz, pathMapURIs, itu);
        reversePorts.scanFunctions(node);
        int i = 0;
        EList ports = clazz.getOwnedPorts();
        for (PortInfo pi : reversePorts.getPortInfoList()) {
            String[] nameArray = pi.dtQName.split("::");
            String pkgName = nameArray[0];
            String sdName = nameArray[2];
            Property existing = clazz.getOwnedAttribute(pi.topic, null);
            Port port = null;
            if (existing == null) {
                if (i < ports.size()) {
                    port = (Port)ports.get(i);
                    port.setName(pi.topic);
                } else {
                    Interface newSD = ServiceDefUtils.getServiceDef((Class)clazz, pathMapURIs, (PortInfo.PortKind)pi.pk, (String)pkgName, (String)sdName);
                    port = CreatePortUtils.createPort((Class)clazz, (PortInfo)pi, (Interface)newSD);
                }
            } else if (existing instanceof Port) {
                port = (Port)existing;
                Interface existingSD = InteractionUtils.getServiceDefinition((Port)port);
                Interface newSD = ServiceDefUtils.getServiceDef((Class)clazz, pathMapURIs, (PortInfo.PortKind)pi.pk, (String)pkgName, (String)sdName);
                if (newSD != existingSD) {
                    SyncPortsToModel.updateSD(clazz, port, pi, newSD);
                }
            }
            if (port != null) {
                ComponentPort portSt = (ComponentPort)UMLUtil.getStereotypeApplication((Element)port, ComponentPort.class);
                portSt.setQos(pi.qos);
            }
            ++i;
        }
    }

    public static void updateSD(Class clazz, Port port, PortInfo pi, Interface sd) {
        Class cs = (Class)port.getType();
        try {
            PortCommands.removeProvReq((Port)port).execute(null, null);
        }
        catch (ExecutionException e) {
            Activator.log.error((Throwable)e);
        }
        if (ServiceDefUtils.isProvided((PortInfo.PortKind)pi.pk)) {
            cs.createInterfaceRealization(null, sd);
        } else {
            cs.createUsage((NamedElement)sd);
        }
    }
}

