/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.bt.xsdgw.uml2xml.executors;

import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.expressions.Helper;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.HelperOperationCall;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.NonTransformationExecutionContext;
import org.eclipse.papyrus.robotics.bt.xsdgw.uml2xml.utils.ModuleResolver;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.Activity;

public class BTMLHelperCaller {
    private static String fLibraryName = "BTMLLib";
    private Module module;
    private NonTransformationExecutionContext fExecContext;
    private HelperOperationCall fCall;
    private String srcContainer = "transforms";

    public void setUp() throws MdaException {
        QVTOCompiler compiler = new QVTOCompiler();
        ModuleResolver importResolver = ModuleResolver.createTestPluginResolver(this.srcContainer);
        UnitProxy srcUnit = importResolver.resolveUnit(fLibraryName);
        CompiledUnit result = compiler.compile(srcUnit, new QvtCompilerOptions(), null);
        if (result.getErrors().size() != 0) {
            throw new MdaException("Library " + fLibraryName + " has compilation errors!");
        }
        this.module = (Module)result.getModules().get(0);
        HashSet<Module> importedModules = new HashSet<Module>();
        importedModules.add(this.module);
        QvtOperationalParserUtil.collectAllImports((Module)this.module, importedModules);
        this.fExecContext = new NonTransformationExecutionContext(importedModules);
    }

    public void setUpOperation(String op_name) throws MdaException {
        Helper operation = BTMLHelperCaller.findOperationByName(this.module, op_name);
        if (operation == null) {
            throw new MdaException("Library operation " + op_name + " not found");
        }
        this.fCall = this.fExecContext.createHelperCall(operation);
    }

    public void dispose() {
        if (this.fExecContext != null) {
            this.fExecContext.dispose();
        }
    }

    public Diagram getBtDiagram(Activity self) throws Exception {
        Object callResult = this.fCall.invoke((Object)self, new Object[0]);
        if (callResult == null || !(callResult instanceof Diagram)) {
            throw new Exception("getBtDiagram() didn't return a Diagram type!");
        }
        return (Diagram)callResult;
    }

    public LinkedHashSet<Action> getBtNodeChildrenOrdered(Action self, Diagram diag) throws Exception {
        Object callResult = this.fCall.invoke((Object)self, new Object[]{diag});
        if (callResult == null) {
            throw new Exception("getBtNodeChildrenOrdered() didn't return an ordered set of Action types!");
        }
        return (LinkedHashSet)callResult;
    }

    private static Helper findOperationByName(Module module, String operationName) {
        for (EOperation eOperation : module.getEOperations()) {
            if (!operationName.equals(eOperation.getName()) || !(eOperation instanceof Helper)) continue;
            return (Helper)eOperation;
        }
        return null;
    }
}

