/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.tables.common;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.robotics.assertions.tables.OpaqueExpressionCellEditor;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.UMLPackage;

public class ContractAssertionCellAxisConfiguration
implements ICellAxisConfiguration {
    public String getConfigurationId() {
        return "ContractAndAssertion.id";
    }

    public String getConfigurationDescription() {
        return "ContractAndAssertion";
    }

    public boolean handles(Table table, Object axisElement) {
        boolean axisMatch;
        String type = table.getTableConfiguration().getType();
        Object represents = AxisUtils.getRepresentedElement((Object)axisElement);
        boolean typeMatch = type.equals("AssertionTable") || type.equals("GuaranteesTable") || type.equals("AssumptionsTable");
        boolean bl = axisMatch = represents.equals(UMLPackage.eINSTANCE.getOpaqueExpression_Language()) || represents.equals(UMLPackage.eINSTANCE.getOpaqueExpression_Body());
        return typeMatch && axisMatch;
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axisElement, String configLabel) {
        Object represents = AxisUtils.getRepresentedElement((Object)axisElement);
        if (represents.equals(UMLPackage.eINSTANCE.getOpaqueExpression_Language())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new LanguageDisplayConverter(), "NORMAL", configLabel);
        } else if (represents.equals(UMLPackage.eINSTANCE.getOpaqueExpression_Body())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new BodyDisplayConverter(), "NORMAL", configLabel);
        }
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new TextPainter(), "NORMAL", configLabel);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)this.getCellEditor(), "EDIT", configLabel);
    }

    protected ICellEditor getCellEditor() {
        return new OpaqueExpressionCellEditor();
    }

    class BodyDisplayConverter
    extends DisplayConverter {
        BodyDisplayConverter() {
        }

        public Object displayToCanonicalValue(Object display) {
            return display;
        }

        public Object canonicalToDisplayValue(Object canonical) {
            if (canonical instanceof OpaqueExpression) {
                return ((OpaqueExpression)canonical).getBodies().get(0);
            }
            return canonical;
        }
    }

    class LanguageDisplayConverter
    extends DisplayConverter {
        LanguageDisplayConverter() {
        }

        public Object displayToCanonicalValue(Object display) {
            return display;
        }

        public Object canonicalToDisplayValue(Object canonical) {
            if (canonical instanceof OpaqueExpression) {
                return ((OpaqueExpression)canonical).getLanguages().get(0);
            }
            return canonical;
        }
    }
}

