/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.launch.proptesters;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentInstance;
import org.eclipse.papyrus.robotics.ros2.launch.lifecycle.LifecycleState;
import org.eclipse.papyrus.robotics.ros2.launch.utils.LaunchUtils;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

public class LaunchTester
extends PropertyTester {
    public static final String CURRENT_STATE = "currentState";
    public static final String BIN_AVAILABLE = "binAvailable";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)receiver;
            if (CURRENT_STATE.equals(property)) {
                return this.checkState(selection, expectedValue);
            }
            if (BIN_AVAILABLE.equals(property)) {
                return this.binaryAvailable(selection);
            }
        }
        return false;
    }

    protected boolean checkState(IStructuredSelection selection, Object expectedValue) {
        Property instance;
        EObject prop = EMFHelper.getEObject((Object)selection.getFirstElement());
        String expectedStateStr = (String)expectedValue;
        if (prop instanceof Property && expectedValue instanceof String && StereotypeUtil.isApplied((Element)(instance = (Property)prop), ComponentInstance.class)) {
            LifecycleState.EState currentState = LifecycleState.getState(instance.getName());
            String[] stringArray = expectedStateStr.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String expectedState = stringArray[n2];
                if (currentState == LifecycleState.getEState(expectedState)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean binaryAvailable(IStructuredSelection selection) {
        Property instance;
        EObject prop = EMFHelper.getEObject((Object)selection.getFirstElement());
        if (prop instanceof Property && StereotypeUtil.isApplied((Element)(instance = (Property)prop), ComponentInstance.class)) {
            return LaunchUtils.existsExecutable(instance);
        }
        return false;
    }
}

