/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.bt.types.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.robotics.bt.profile.bt.InFlowPort;
import org.eclipse.papyrus.robotics.bt.profile.bt.OutFlowPort;
import org.eclipse.papyrus.robotics.bt.types.utils.uml.AbstractCallActionPinUpdater;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.UMLFactory;

public class BtActionPinUpdater
extends AbstractCallActionPinUpdater<CallOperationAction> {
    @Override
    public void updatePins(CallOperationAction node) {
        super.updatePins(node);
        for (InputPin ip : node.getInputs()) {
            StereotypeUtil.apply((Element)ip, InFlowPort.class);
        }
        for (OutputPin op : node.getOutputs()) {
            StereotypeUtil.apply((Element)op, OutFlowPort.class);
        }
        if (node.getTarget() != null) {
            node.setTarget(null);
        }
    }

    @Override
    public List<InputPin> deriveArguments(CallOperationAction node) {
        ArrayList<InputPin> derivedInputPins = new ArrayList<InputPin>();
        if (node.getOperation() != null) {
            for (Parameter parameter : node.getOperation().getOwnedParameters()) {
                if (parameter.getDirection() != ParameterDirectionKind.INOUT_LITERAL && parameter.getDirection() != ParameterDirectionKind.IN_LITERAL) continue;
                InputPin derivedPin = UMLFactory.eINSTANCE.createInputPin();
                derivedInputPins.add(derivedPin);
                derivedPin.setType(parameter.getType());
                derivedPin.setLower(parameter.getLower());
                derivedPin.setUpper(parameter.getUpper());
                if (parameter.getDirection() == ParameterDirectionKind.INOUT_LITERAL) {
                    derivedPin.setName("[in] " + parameter.getName());
                    continue;
                }
                derivedPin.setName(parameter.getName());
            }
        }
        return derivedInputPins;
    }

    @Override
    public List<OutputPin> deriveResults(CallOperationAction node) {
        ArrayList<OutputPin> derivedOutputPins = new ArrayList<OutputPin>();
        if (node.getOperation() != null) {
            for (Parameter parameter : node.getOperation().getOwnedParameters()) {
                if (parameter.getDirection() != ParameterDirectionKind.INOUT_LITERAL && parameter.getDirection() != ParameterDirectionKind.OUT_LITERAL) continue;
                OutputPin derivedPin = UMLFactory.eINSTANCE.createOutputPin();
                derivedOutputPins.add(derivedPin);
                derivedPin.setType(parameter.getType());
                derivedPin.setLower(parameter.getLower());
                derivedPin.setUpper(parameter.getUpper());
                if (parameter.getDirection() == ParameterDirectionKind.INOUT_LITERAL) {
                    derivedPin.setName("[out] " + parameter.getName());
                    continue;
                }
                derivedPin.setName(parameter.getName());
            }
        }
        return derivedOutputPins;
    }
}

